package com.bokesoft.distro.tech.commons.basis.flightrecord.struc.database;

import java.io.Serializable;

/** 数据库连接关闭事件 */
public class ConnectionCloseEvent implements Serializable {

    private String datasourceId;
    private String connInstId;
    private long closeTime;

    public static ConnectionCloseEvent build(String datasourceId, String connInstId){
        ConnectionCloseEvent e = new ConnectionCloseEvent();
        e.datasourceId = datasourceId;
        e.connInstId = connInstId;
        e.closeTime = System.currentTimeMillis();
        return e;
    }

    public ConnectionCloseEvent(){
        //JSON 反序列化等场景需要
    }

    public ConnectionCloseEvent(String datasourceId, String connInstId, long closeTime) {
        this.datasourceId = datasourceId;
        this.connInstId = connInstId;
        this.closeTime = closeTime;
    }

    public String getDatasourceId() {
        return datasourceId;
    }

    public void setDatasourceId(String datasourceId) {
        this.datasourceId = datasourceId;
    }

    public String getConnInstId() {
        return connInstId;
    }

    public void setConnInstId(String connInstId) {
        this.connInstId = connInstId;
    }

    public long getCloseTime() {
        return closeTime;
    }

    public void setCloseTime(long closeTime) {
        this.closeTime = closeTime;
    }

    @Override
    public String toString() {
        return "ConnectionCloseEvent [datasourceId=" + datasourceId + ", connInstId=" + connInstId + ", closeTime="
                + closeTime + "]";
    }

}

