package com.bokesoft.distro.tech.commons.basis.coordinate.struct;


import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.json.JSONString;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public final class Semaphore implements JSONString {

    public final String key;
    public final LocalDateTime time;

    /**
     * 业务标识,在yigo中一般是FormKey
     */
    private String tag;
    /**
     * 会话标识,在yigo中一般是operator
     */
    private String session;

    public Semaphore(String key) {
        this.key = key;
        this.time = LocalDateTime.now();
    }


    private Semaphore(String key, LocalDateTime time) {
        this.key = key;
        this.time = time;
    }


    public String getTag() {
        return tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getSession() {
        return session;
    }

    public void setSession(String session) {
        this.session = session;
    }

    public String toJSONString() {
        JSONObject js = new JSONObject();
        js.put("key", key);
        js.put("time", time.format(DateTimeFormatter.ISO_DATE_TIME));
        js.put("tag", tag);
        js.put("session", session);
        return js.toString();
    }

    @Override
    public String toString() {
        return String.format("%s[%s,%s,%s]", key, time, tag, session);
    }

    public static Semaphore fromJSONString(String str) {
        JSONObject obj = new JSONObject(str);
        String key = obj.optString("key");
        String time = obj.optString("time", "");
        Semaphore semaphore = new Semaphore(key,
                StringUtils.isBlank(time) ? null : LocalDateTime.from(DateTimeFormatter.ISO_DATE_TIME.parse(time)));
        semaphore.tag = (obj.optString("tag", null));
        semaphore.session = obj.optString("session", null);
        return semaphore;
    }


}
