/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.bootsupport.starter.utils;

import com.bokesoft.distro.tech.bootsupport.starter.deployment.SpringResourceMultiSolutionMetaResolverFactory;
import com.bokesoft.distro.tech.bootsupport.starter.utils.YigoPropPreparationHelper;
import com.bokesoft.distro.tech.bootsupport.starter.utils.YigoServiceInitHelper;
import com.bokesoft.distro.tech.yigosupport.deployment.resource.intf.IResourceIO;
import com.bokesoft.distro.tech.yigosupport.extension.base.log.LogSvrSlf4j;
import com.bokesoft.yes.mid.base.MidGlobalEnv;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ResourceLoader;

public class YigoInitUtil {
    private static final Logger log = LoggerFactory.getLogger(YigoInitUtil.class);

    public static void initYigoEnv(ResourceLoader resourceLoader, MultiSolutionPathProvider solutions, RunAfterYigoInitialized runner, boolean keepSilent) throws IOException {
        new SpringResourceMultiSolutionMetaResolverFactory().setResourceLoader(resourceLoader);
        File workDir = Files.createTempDirectory(YigoInitUtil.class.getName() + "-", new FileAttribute[0]).toFile();
        String workPath = workDir.getCanonicalPath();
        log.info("\u5f00\u59cb\u521d\u59cb\u5316\u51c6\u5907, \u5de5\u4f5c\u76ee\u5f55='{}' ...", (Object)workPath);
        YigoInitUtil.prepareProperties(workDir, solutions.getSolutionResources());
        try {
            log.info("\u5f00\u59cb\u521d\u59cb\u5316 Yigo \u73af\u5883 ...");
            long startMs = System.currentTimeMillis();
            YigoPropPreparationHelper.PrepareResult prepareResult = new YigoPropPreparationHelper.PrepareResult(workPath, false);
            YigoServiceInitHelper.initYigoService(prepareResult);
            log.info("\u5b8c\u6210 Yigo \u73af\u5883\u521d\u59cb\u5316, \u8017\u65f6 {} \u79d2 .", (Object)((System.currentTimeMillis() - startMs) / 1000L));
            log.info("\u5f00\u59cb\u6267\u884c Yigo \u8bbe\u8ba1\u5de5\u5177\u4efb\u52a1 ...");
            IMetaFactory metaFactory = MidGlobalEnv.getInstance().getMetaFactory();
            runner.run(metaFactory);
            log.info("Yigo \u521d\u59cb\u5316\u5b8c\u6210, \u5de5\u4f5c\u76ee\u5f55='{}' .", (Object)workPath);
        }
        catch (Exception ex) {
            if (keepSilent) {
                log.error("Yigo \u542f\u52a8\u8fc7\u7a0b\u51fa\u9519: {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)ex));
            }
            log.error("Yigo \u542f\u52a8\u8fc7\u7a0b\u51fa\u9519", (Throwable)ex);
            ExceptionUtils.rethrow((Throwable)ex);
        }
    }

    private static void prepareProperties(File workDir, String[] slnResources) throws IOException {
        Properties coreProps = new Properties();
        ArrayList<String> solutions = new ArrayList<String>();
        for (int i = 0; i < slnResources.length; ++i) {
            String slnRes = slnResources[i];
            String slnName = "sln-" + i;
            solutions.add(slnName);
            Properties slnProp = new Properties();
            slnProp.setProperty("IMPL", SkipSthMetaResolverFactory.class.getName());
            String paraRootRes = "PARA.ROOT_RESOURCE";
            slnProp.setProperty(paraRootRes, slnRes);
            YigoInitUtil.savePropFile(workDir, slnName, slnProp, "Solution properties for " + slnRes);
        }
        coreProps.setProperty("SolutionPath", workDir.getCanonicalPath());
        coreProps.setProperty("SOLUTIONS", StringUtils.join(solutions, (String)","));
        coreProps.setProperty("LOGSVR", LogSvrSlf4j.class.getName());
        coreProps.setProperty("DEBUG", "true");
        YigoInitUtil.savePropFile(workDir, "core", coreProps, "Yigo core properties");
    }

    private static void savePropFile(File workDir, String fileName, Properties properties, String desc) throws IOException {
        File propFile = new File(workDir, fileName + ".properties");
        try (OutputStream out = Files.newOutputStream(propFile.toPath(), new OpenOption[0]);){
            properties.store(out, desc);
        }
    }

    public static class SkipSthMetaResolverFactory
    extends SpringResourceMultiSolutionMetaResolverFactory {
        private static final String[] SKIP_FILES = new String[]{"/Enhance.xml", "/service_cmd.xml", "/service_filter.xml"};

        @Override
        protected IResourceIO getResourceIO() {
            final IResourceIO inner = super.getResourceIO();
            return new IResourceIO(){

                public List<String> list() throws IOException {
                    return inner.list();
                }

                public byte[] read(String resource) throws IOException {
                    for (String skip : SKIP_FILES) {
                        if (!resource.endsWith(skip)) continue;
                        log.warn("\u6587\u4ef6 '{}' \u5df2\u88ab\u5ffd\u7565 .", (Object)resource);
                        return null;
                    }
                    return inner.read(resource);
                }

                public void write(String resource, byte[] data) throws IOException {
                    inner.write(resource, data);
                }

                public String getInstanceId() {
                    return inner.getInstanceId();
                }

                public URI getURI(String resource) throws IOException {
                    return inner.getURI(resource);
                }
            };
        }
    }

    public static interface RunAfterYigoInitialized {
        public void run(IMetaFactory var1);
    }

    public static interface MultiSolutionPathProvider {
        public String[] getSolutionResources();
    }
}

