/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.bootsupport.starter.datasource;

import com.bokesoft.distro.tech.bootsupport.starter.utils.DataSourceAwareDBManagerBuilder;
import com.bokesoft.distro.tech.bootsupport.starter.wrapper.WrappedConnection;
import com.bokesoft.yigo.mid.connection.IConnectionProfile;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.mid.connection.IDBManagerFactory;
import java.sql.Connection;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.slf4j.event.Level;

public class DataSourceAwareDBManagerFactory
implements IDBManagerFactory {
    private static Log log = LogFactory.getLog(DataSourceAwareDBManagerFactory.class);
    private static Log tracePrintLog = LogFactory.getLog((String)(DataSourceAwareDBManagerFactory.class.getName() + ".tracePrint"));
    private static long expectPrintTraceTime = -1L;
    private static long intervalMs = 300000L;
    private static DataSource datasource;
    private static Level logLevel;
    private static boolean dbTraceCacheEnabled;
    private static boolean execTimeoutControlEnabled;

    public static void setDataSource(DataSource datasource) {
        DataSourceAwareDBManagerFactory.datasource = datasource;
    }

    public static void setLogLevel(String logLevelStr) {
        if (null != logLevelStr) {
            switch (logLevelStr.toUpperCase()) {
                case "INFO": {
                    logLevel = Level.INFO;
                    break;
                }
                case "WARN": {
                    logLevel = Level.WARN;
                    break;
                }
                case "ERROR": {
                    logLevel = Level.ERROR;
                }
                default: {
                    logLevel = Level.DEBUG;
                }
            }
        }
    }

    public static void setDbTraceCacheEnabled(boolean dbTraceCacheEnabled) {
        DataSourceAwareDBManagerFactory.dbTraceCacheEnabled = dbTraceCacheEnabled;
    }

    public static void setExecTimeoutControlEnabled(boolean execTimeoutControlEnabled) {
        DataSourceAwareDBManagerFactory.execTimeoutControlEnabled = execTimeoutControlEnabled;
    }

    public static void setPrintDBTraceIntervalTime(long intervalMs) {
        DataSourceAwareDBManagerFactory.intervalMs = intervalMs;
    }

    public IDBManager getDBManager(IConnectionProfile cp) throws Throwable {
        try {
            return DataSourceAwareDBManagerBuilder.getDBManager(cp, datasource, logLevel, dbTraceCacheEnabled, execTimeoutControlEnabled);
        }
        catch (Exception ex) {
            log.error((Object)"\u901a\u8fc7 Bean \u521b\u5efa IConnectionFactory \u5931\u8d25", (Throwable)ex);
            if (dbTraceCacheEnabled && this.canPrint()) {
                tracePrintLog.error((Object)DataSourceAwareDBManagerFactory.buildDBTraceContent());
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canPrint() {
        if (System.currentTimeMillis() > expectPrintTraceTime) {
            DataSourceAwareDBManagerFactory dataSourceAwareDBManagerFactory = this;
            synchronized (dataSourceAwareDBManagerFactory) {
                if (System.currentTimeMillis() > expectPrintTraceTime) {
                    expectPrintTraceTime = System.currentTimeMillis() + intervalMs;
                    return true;
                }
            }
        }
        return false;
    }

    private static String buildDBTraceContent() {
        StringBuffer result = new StringBuffer("DB Connection create Trace Info");
        result.append("\n");
        result.append("-----------------------------------------------------------------\n");
        int pos = 1;
        for (Connection conn : WrappedConnection.dbTraceCache.keySet()) {
            result.append("index[" + pos + "],connection:" + conn.toString() + " call by trace");
            result.append(WrappedConnection.dbTraceCache.get(conn));
            result.append("\n");
            result.append("-----------------------------------------------------------------\n");
            ++pos;
        }
        return result.toString();
    }

    static {
        logLevel = Level.DEBUG;
    }
}

