/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.bootsupport.starter.beans;

import com.bokesoft.distro.tech.bootsupport.starter.api.YigoClientPageVariableProvider;
import com.bokesoft.distro.tech.bootsupport.starter.api.ctx.PageBuildContext;
import com.bokesoft.distro.tech.bootsupport.starter.runtime.YigoInstanceManager;
import com.bokesoft.distro.tech.bootsupport.starter.runtime.model.InstanceStatus;
import com.bokesoft.distro.tech.commons.basis.dependency.DependencySortCore;
import com.bokesoft.distro.tech.yigosupport.extension.utils.yigo.SessionUtils;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;

@Service
public class PagesBuildService {
    private static Logger logger = LoggerFactory.getLogger(PagesBuildService.class);
    private ResourceLoader resourceLoader;
    private List<YigoClientPageVariableProvider> varProviders;
    @Autowired
    private YigoInstanceManager yigoInstanceManager;
    private ObjectMapper objectMapper;

    public PagesBuildService(ResourceLoader resourceLoader, List<YigoClientPageVariableProvider> varProviders) {
        this.resourceLoader = resourceLoader;
        this.varProviders = varProviders;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public ResponseEntity<String> buildPage(String pageResourceLocation, PageBuildContext pageBuildContext, String clientID, String locale) {
        if (InstanceStatus.Status.READY.equals((Object)this.yigoInstanceManager.getInstanceStatus().getStatus())) {
            return (ResponseEntity)SessionUtils.processWithContext((String)clientID, ctx -> {
                ctx.getEnv().setLocale(locale);
                return this.getStringResponseEntity(pageResourceLocation, pageBuildContext, ctx);
            });
        }
        try {
            return this.getStringResponseEntity(pageResourceLocation, pageBuildContext, null);
        }
        catch (Exception e) {
            return (ResponseEntity)ExceptionUtils.rethrow((Throwable)e);
        }
    }

    private ResponseEntity<String> getStringResponseEntity(String pageResourceLocation, PageBuildContext pageBuildContext, DefaultContext yigoCtx) {
        pageBuildContext.setDefaultContext(yigoCtx);
        return this.buildPage(pageResourceLocation, pageBuildContext);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ResponseEntity<String> buildPage(String resLoc, PageBuildContext pvc) {
        Resource resource = this.resourceLoader.getResource(resLoc);
        Assert.notNull((Object)resource, (String)("\u65e0\u6cd5\u627e\u5230\u8d44\u6e90 - '" + resLoc + "'"));
        try (InputStream is = resource.getInputStream();){
            String html = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)html), (String)("\u8d44\u6e90 '" + resLoc + "' \u5185\u5bb9\u4e3a\u7a7a"));
            int docTypeStartPos = html.toUpperCase().indexOf("<!doctype html>".toUpperCase());
            if (docTypeStartPos > 0) {
                html = html.substring(docTypeStartPos);
            }
            List providers = DependencySortCore.sort(this.varProviders);
            LinkedHashMap<String, Map<String, Object>> pageVars = new LinkedHashMap<String, Map<String, Object>>();
            for (YigoClientPageVariableProvider p : providers) {
                Map<String, Object> vars;
                if (!p.support(pvc) || null == (vars = p.getVariables(pvc)) || vars.size() <= 0) continue;
                pageVars.put(p.getClass().getName(), vars);
            }
            html = this.injectPageVarsJs(html, pageVars, resLoc);
            HttpHeaders headers = new HttpHeaders();
            headers.set((Object)"Cache-Control", (Object)CacheControl.noCache().cachePrivate().mustRevalidate().getHeaderValue());
            ResponseEntity responseEntity = new ResponseEntity((Object)html, (MultiValueMap)headers, HttpStatus.OK);
            return responseEntity;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return (ResponseEntity)ExceptionUtils.rethrow((Throwable)e);
        }
    }

    private String injectPageVarsJs(String html, Map<String, Map<String, Object>> pageVars, String resLoc) {
        try {
            ArrayList<String> result = new ArrayList<String>();
            result.add("/** Created by " + this.getClass().getName() + " */");
            result.add("window.YigoClientPageVariable = {};");
            for (Map.Entry<String, Map<String, Object>> pcEn : pageVars.entrySet()) {
                String providerName = pcEn.getKey();
                result.add("/** Provided by " + providerName + " */");
                for (Map.Entry<String, Object> en : pcEn.getValue().entrySet()) {
                    String varName = en.getKey();
                    Object val = en.getValue();
                    String json = this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(val);
                    result.add("window.YigoClientPageVariable." + varName + "=" + json + ";");
                }
            }
            int scriptInsertPoint = this.calcScriptInsertPoint(html, resLoc);
            String before = html.substring(0, scriptInsertPoint);
            String after = html.substring(scriptInsertPoint);
            return before + "\n\n<script>\n" + StringUtils.join(result, (String)"\n") + "\n</script>\n\n" + after;
        }
        catch (JsonProcessingException e) {
            return (String)ExceptionUtils.rethrow((Throwable)e);
        }
    }

    private int calcScriptInsertPoint(String html, String resLoc) {
        String sHead = "<head>";
        int result = html.toUpperCase().indexOf(sHead.toUpperCase());
        if (result > 0) {
            result += sHead.length();
        }
        Assert.isTrue((result > 0 ? 1 : 0) != 0, (String)("\u9875\u9762 '" + resLoc + "' \u65e0\u6548 - \u65e0\u6cd5\u627e\u5230 <head></head> \u6807\u7b7e\u4f5c\u4e3a\u53ef\u63d2\u5165\u70b9"));
        return result;
    }
}

