/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.bootsupport.starter.beans;

import com.bokesoft.distro.tech.yigosupport.extension.utils.yigo.SessionUtils;
import com.bokesoft.distro.tech.yigosupport.extension.utils.yigo.StorageUtil;
import com.bokesoft.yigo.mid.base.DefaultContext;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class FileController {
    public static final int FILE_VIEW_INLINE = 10;
    public static final int FILE_VIEW_DOWNLOAD = 20;
    public static final int MEDIA_TYPE_BIN = 10;
    public static final int MEDIA_TYPE_PDF = 20;
    public static final int MEDIA_TYPE_EXCEL = 30;
    private static final String PREFIX_FILE_DOWNLOAD = "/remote-files";

    public static String buildDownloadUrl(String fileId, String fileName, int fileViewType, String prefix, int mediaType) {
        String url = PREFIX_FILE_DOWNLOAD.substring(1) + "/" + fileViewType + "/" + mediaType + "/" + prefix + "/" + fileId + "/" + fileName;
        return url;
    }

    @RequestMapping(value={"/remote-files/{fileViewType}/{mediaType}/{prefix}/{fileId}/{fileName}"})
    public ResponseEntity<InputStreamResource> fileDownload(@PathVariable(value="fileViewType") int fileViewType, @PathVariable(value="mediaType") int mediaType, @PathVariable(value="prefix") String prefix, @PathVariable(value="fileId") String fileId, @PathVariable(value="fileName") String fileName) throws Throwable {
        return (ResponseEntity)SessionUtils.processWithContext(null, ctx -> {
            byte[] bytes = StorageUtil.readFile((DefaultContext)ctx, (String)prefix, (String)(fileId + "/" + fileName));
            try (ByteArrayInputStream in = new ByteArrayInputStream(bytes);){
                ResponseEntity response;
                HttpHeaders headers = new HttpHeaders();
                if (10 == fileViewType) {
                    headers.add("Content-Disposition", "inline; filename=" + fileName);
                } else if (20 == fileViewType) {
                    headers.add("Content-Disposition", "attachment; filename=" + fileName);
                }
                headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
                headers.add("Pragma", "no-cache");
                headers.add("Expires", "0");
                ResponseEntity responseEntity = response = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).contentType(this.calcMediaType(mediaType)).body((Object)new InputStreamResource((InputStream)in));
                return responseEntity;
            }
        });
    }

    private MediaType calcMediaType(int mediaType) {
        MediaType mt;
        switch (mediaType) {
            case 10: {
                mt = MediaType.APPLICATION_OCTET_STREAM;
                break;
            }
            case 20: {
                mt = MediaType.APPLICATION_PDF;
                break;
            }
            case 30: {
                mt = new MediaType("application/vnd.ms-excel");
                break;
            }
            default: {
                mt = MediaType.APPLICATION_OCTET_STREAM;
            }
        }
        return mt;
    }
}

