package com.bokesoft.distro.tech.bootsupport.starter.utils;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.distro.tech.yigosupport.extension.exception.Misc;
import com.bokesoft.yigo.common.trace.TraceRecorder;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalExceptionUtil {

    private static Logger log = LoggerFactory.getLogger(GlobalExceptionUtil.class);
    private final static String[] exceptionBlockedList = {"java.sql", "oracle.jdbc", "com.mysql.cj.jdbc.exceptions",
            "org.springframework.jdbc"};

    public static Throwable handleException(Throwable e) {
        Throwable rootEx = ExceptionUtils.getRootCause(e);
        if (null == rootEx) {
            rootEx = e;
        }
        String message = checkAndReplaceExceptionMessage(rootEx);
        return Misc.convertToYigoException(e,message);
    }

    /**
     * 检查并替换异常信息
     */
    public static String checkAndReplaceExceptionMessage(Throwable rootEx) {
        String exName = rootEx.getClass().getName();
        String message = rootEx.getMessage();
        if (StringUtils.isBlank(message)) {
            return "技术故障，请联系管理员";
        }
        // 考虑ERP框架,message是json结构
        if (message.startsWith("{") && message.endsWith("}")) {
            JSONObject json = JSONObject.parseObject(message);
            for (String keyWords : exceptionBlockedList) {
                if (exName.contains(keyWords)) {
                    log.error(rootEx.getMessage(), rootEx);
                    json.put("message", "技术故障，请联系管理员");
                    break;
                }
            }
            String jsonOrgDetail = json.getString("detail");
            json.put("detail", " [错误代码: " + TraceRecorder.getTraceId() + "]\n" + jsonOrgDetail);
            message = json.toJSONString();
            return message;
        } else {
            for (String keyWords : exceptionBlockedList) {
                if (exName.contains(keyWords)) {
                    log.error(rootEx.getMessage(), rootEx);
                    message = "技术故障，请联系管理员";
                    break;
                }
            }
            // 普通有值的message直接处理抛出
            message = message + " [错误代码: " + TraceRecorder.getTraceId() + "]";
            return message;
        }
    }

}
