package com.bokesoft.distro.tech.bootsupport.starter.servlet;

import com.bokesoft.distro.tech.bootsupport.starter.runtime.YigoInstanceManager;
import com.bokesoft.distro.tech.bootsupport.starter.runtime.model.InstanceStatus;
import com.bokesoft.distro.tech.bootsupport.starter.utils.GlobalExceptionUtil;
import com.bokesoft.yes.common.trace.struct.EnforceLevel;
import com.bokesoft.yes.mid.servlet.ServiceDispatch;
import com.bokesoft.yigo.common.trace.TraceSystemManager;
import org.apache.commons.lang3.exception.ExceptionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ExceptionHandlerServiceDispatch extends ServiceDispatch {

    private YigoInstanceManager yigoInstanceManager;
    public ExceptionHandlerServiceDispatch(YigoInstanceManager yigoInstanceManager){
        this.yigoInstanceManager = yigoInstanceManager;
    }

    @Override
    public Object processService(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Throwable {
        try {
            if(!InstanceStatus.Status.READY.equals(yigoInstanceManager.getInstanceStatus().getStatus())) {
                throw new RuntimeException("Yigo程序还未初始化完成!");
            }
            return super.processService(httpServletRequest, httpServletResponse);
        } catch (Throwable throwable) {
            // FIXME ServiceServlet 需要在核心处理加上 TraceSystemManager.setEnforceMode
            TraceSystemManager.setEnforceMode();
            Throwable e = GlobalExceptionUtil.handleException(throwable);
            return ExceptionUtils.rethrow(e);
        }
    }
}
