package com.bokesoft.distro.tech.bootsupport.starter.plugins;

import java.io.File;

import org.apache.commons.io.FileUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

import org.json.JSONObject;
import com.bokesoft.distro.tech.bootsupport.starter.api.YigoAdditionalInitiator;
import com.bokesoft.distro.tech.commons.basis.MiscUtil;
import com.bokesoft.distro.tech.yigosupport.extension.utils.yigo.StorageUtil;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.mid.file.service.DownloadExcelService;
import com.bokesoft.yes.mid.file.service.ExportFileService;
import com.bokesoft.yes.mid.ver.SystemInfo;
import com.bokesoft.yes.struct.filedata.FileData;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.service.IServiceProvider;
import com.bokesoft.yigo.mid.service.provider.ServiceProviderFactory;

@Component
@ConditionalOnProperty(name="distro.tech.bootsupport.plugin.export.enabled",havingValue = "true",matchIfMissing = false)
public class ExportFileThenDownloadExcelRedirectPlugin implements YigoAdditionalInitiator {

	@Override
	public void init(DefaultContext context) {
		ExportFileServiceExt ee = new ExportFileServiceExt();
		DownloadExcelServiceEx de = new DownloadExcelServiceEx();
		ServiceProviderFactory.registerProvider(new Object[][] {
			{ee.getServiceName(), ee},
			{de.getServiceName(), de}
		});
	}
	
	public static class ExportFileServiceExt extends ExportFileService {
		
		@Override
		public Object process(DefaultContext ctx, String cmd, StringHashMap<Object> arguments) throws Throwable {
			Object origRes = super.process(ctx, cmd, arguments);
			int yigoversion = Integer.parseInt(SystemInfo.getBuildID());
			if(yigoversion < 20220905){
				MiscUtil.$assert(!(origRes instanceof JSONObject),
						"不支持的 Cmd '"+cmd+"': 返回的数据对象类型('"+origRes.getClass()+"')不是 JSONObject");

				// 替换 Cmd 中 返回 JSON 对象中 "filePath"
				JSONObject json = (JSONObject)origRes;
				String filePath = json.getString("filePath");
				MiscUtil.$assert(null==filePath, "不支持的 Cmd '"+cmd+"': 返回的数据不包含 filePath");

				File xlsPath = new File(filePath);
				//读取并重新将数据存储到支持多节点的存储中
				long SOID = TypeConvertor.toLong(arguments.get("OID")).longValue();
				filePath = StorageUtil.writeFile(ctx, json.getString("fileName"), json.getString("formKey"), SOID, "", "EXCEL", xlsPath);
				json.put("filePath", filePath);
			}else{
				MiscUtil.$assert(!(origRes instanceof FileData ),
						"不支持的 Cmd '"+cmd+"': 返回的数据对象类型('"+origRes.getClass()+"')不是 com.bokesoft.yes.struct.filedata.FileData");
				// 替换 Cmd 中 返回 JSON 对象中 "filePath"
				FileData fileData = (FileData)origRes;
				//读取并重新将数据存储到支持多节点的存储中
				long SOID = TypeConvertor.toLong(arguments.get("OID")).longValue();
				String filePath = StorageUtil.writeFile(ctx, fileData.getFileName(), arguments.get("formKey").toString(), SOID, "", "EXCEL", fileData.getData());
				fileData.setPath(filePath);
			}

			return origRes;
		}

		@Override
		public IServiceProvider<DefaultContext> newInstance() {
			return new ExportFileServiceExt();
		}
		
	}
	
	public static class DownloadExcelServiceEx extends DownloadExcelService {
		
		@Override
		protected IServiceCmd<DefaultContext> getDefaultImpl() {
			final IServiceCmd<DefaultContext> defaultImpl = super.getDefaultImpl();
			return new IServiceCmd<DefaultContext>() {
				@Override
				public void dealArguments(DefaultContext ctx, StringHashMap<Object> args) throws Throwable {
					String fileId = (String) args.get("filePath");
					String fileName = (String) args.get("fileName");
					String formKey = (String) args.get("formKey");
					File temp = File.createTempFile(fileId, "."+fileName);
					byte[] bytes = StorageUtil.readFile(ctx, formKey, fileId);
					FileUtils.writeByteArrayToFile(temp,bytes);
					args.put("filePath", temp.getCanonicalPath());
					defaultImpl.dealArguments(ctx, args);
				}
				@Override
				public Object doCmd(DefaultContext ctx) throws Throwable {
					return defaultImpl.doCmd(ctx);
				}
				@Override
				public IServiceCmd<DefaultContext> newInstance() {
					return this;
				}
				@Override
				public void checkSecurity(IServiceProvider<DefaultContext> provider, DefaultContext ctx,
						String cmd, StringHashMap<Object> args) throws Throwable {
					defaultImpl.checkSecurity(provider, ctx, cmd, args);
				}
				@Override
				public String getCmd() {
					return defaultImpl.getCmd();
				}
			};
		}

		@Override
		public IServiceProvider<DefaultContext> newInstance() {
			return new DownloadExcelServiceEx();
		}
		
	}
}