package com.bokesoft.distro.tech.bootsupport.starter.patch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

import com.bokesoft.yes.mid.filter.LoginFilter;

/**
 * 通过简单的 URL 栈 修复 Yigo 内置的 LoginFilter 在 SpringBoot 环境运行时 循环进入 doFilter 的问题(StackOverflow)
 */
public class LoginFilter4SpringBoot extends LoginFilter {
	private ThreadLocal<List<String>> urlsInThread = new ThreadLocal<>();

	public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
		HttpServletRequest httpReq = (HttpServletRequest)request;

		String path = httpReq.getServletPath();
		List<String> urls = urlsInThread.get();
		if (null==urls) {
			urls = new ArrayList<>();
			urlsInThread.set(urls);
		}
		if (urls.contains(path)) {
			//已经访问过当前路径, 延续 FilterChain
			chain.doFilter(request, response);
			return;
		}
		try {
			//记住曾经访问的路径
			urls.add(path);
			//继续进行 login 校验
			super.doFilter(request, response, chain);
		}finally {
			urls.remove(urls.size()-1);
		}
	}

	public void init(FilterConfig filterConfig) throws ServletException {
		super.init(filterConfig);
	}
}