package com.bokesoft.distro.tech.bootsupport.starter.instance.impl;

import javax.management.MalformedObjectNameException;

import com.bokesoft.base.bokebase.instance.NetworkUtil;
import com.bokesoft.base.bokebase.instance.impl.DefaultProcessInstanceProvider;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

/**
 * 明确知道进程主服务端口的情况下,提供实例ID的策略
 */
public class YigoBootProcessInstanceProvider extends DefaultProcessInstanceProvider {
    private final int serverPort;

    public YigoBootProcessInstanceProvider(int serverPort) throws MalformedObjectNameException {
        this.serverPort = serverPort;
    }

    @Override
    public String getInstanceId(){
        if(isDocker()) {
            return NetworkUtil.getHost() + ":" + serverPort;
        }else{
            return NetworkUtil.getIp() + ":" + serverPort;
        }
    }

    private boolean isDocker() {
        File file = new File("/.dockerenv");
        if(file.exists()){
            return true;
        }
        Map<String,String> systemEnvs = new HashMap<>();
        for(String key:systemEnvs.keySet()){
            if(key.startsWith("KUBERNETES")){
                return true;
            }
        }
        return false;
    }

}