package com.bokesoft.distro.tech.bootsupport.starter.filter;

import com.bokesoft.distro.tech.bootsupport.starter.execctl.ExecutionTimeoutManager;

import javax.servlet.*;
import java.io.IOException;

/**
 * 执行超时时间准备工作，执行前初始化相关的ThreadLocal,执行完成后清理ThreadLocal
 */
public class ExecutionTimeoutPrepareFilter implements Filter {
    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        try {
            ExecutionTimeoutManager.init();
            filterChain.doFilter(servletRequest, servletResponse);
        } finally {
            ExecutionTimeoutManager.reset();
        }
    }
}
