package com.bokesoft.distro.tech.bootsupport.starter.execctl.model;

import com.bokesoft.yigo.struct.document.Document;

import java.util.UUID;

/**
 * 开始时间对象, 记录不同类型的执行开始时间
 */
public class StartTimeObject {
    /**
     * 开始时间
     */
    private long startTime;
    /**
     * 开始时间类型
     */
    private StartTimeObjectType type;
    /**
     * 实例 ID, 用于标识同类型开始时间对象的不同实例
     */
    private String instanceId;
    /**
     * 标识在处理过程中同类单元可并行起作用
     */
    private boolean parallel;
    /**
     * 执行点，用于关联与执行阶段的关系
     */
    private String executionPoint;

    public long getStartTime() {
        return startTime;
    }

    public StartTimeObjectType getType() {
        return type;
    }

    public String getInstanceId() {
        return instanceId;
    }

    public boolean isParallel() {
        return parallel;
    }

    public String getExecutionPoint() {
        return executionPoint;
    }

    private StartTimeObject() {
        //避免直接创建 StartTimeObject
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public static StartTimeObject buildServiceStartTimeObject() {
        StartTimeObject sto = new StartTimeObject();
        sto.startTime = System.currentTimeMillis();
        sto.type = StartTimeObjectType.SERVICE;
        return sto;
    }

    public static StartTimeObject buildTransactionStartTimeObject(String connectionInstanceId) {
        StartTimeObject sto = new StartTimeObject();
        sto.startTime = System.currentTimeMillis();
        sto.type = StartTimeObjectType.TRANSACTION;
        sto.instanceId = connectionInstanceId;
        sto.parallel = true;
        return sto;
    }

    public static StartTimeObject buildDataObjectStartTimeObject(Document doc,String executionPoint) {
        String instanceId = UUID.randomUUID().toString();
        doc.putExpandData(StartTimeObject.class.getName(), instanceId);
        StartTimeObject sto = new StartTimeObject();
        sto.startTime = System.currentTimeMillis();
        sto.type = StartTimeObjectType.DATAOBJECT;
        sto.instanceId = instanceId;
        sto.executionPoint = executionPoint;
        return sto;
    }

    public static StartTimeObject buildSqlExectionStartTimeObject() {
        StartTimeObject sto = new StartTimeObject();
        sto.startTime = System.currentTimeMillis();
        sto.type = StartTimeObjectType.SQLEXECUTION;
        return sto;
    }

    /**
     * 开始时间对象的类型
     */
    public static enum StartTimeObjectType {
        /**
         * Yigo 服务
         */
        SERVICE(10),
        /**
         * 事务, 关联到 DBManager
         */
        TRANSACTION(20),
        /**
         * Yigo 数据对象
         */
        DATAOBJECT(30),
        /**
         * SQL 语句执行
         */
        SQLEXECUTION(40);

        private int value;

        StartTimeObjectType(int value) {
            this.value = value;
        }

        public int getValue() {
            return value;
        }
    }

}
