package com.bokesoft.distro.tech.bootsupport.starter.configurer;

import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import com.bokesoft.distro.tech.yigosupport.extension.cache.SqlQueryCache;
import com.bokesoft.distro.tech.yigosupport.extension.cache.SqlQueryCache.Request;
import com.bokesoft.distro.tech.yigosupport.extension.cache.SqlQueryCache.RequestContext;

/**
 * {@link SqlQueryCache} 需要的信息配置
 */
@Configuration
public class SqlQueryCacheConfigurer {
	@Bean
	@ConditionalOnMissingBean
	public RequestContext getRequestContext() {
		return new RequestContext() {
			@Override
			public Request getRequest() {
				HttpServletRequest request = null;
				RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
			    if (null!=requestAttributes){
			        request = ((ServletRequestAttributes) requestAttributes).getRequest();
			    }
			    if (null!=request) {
			    	return new HttpRequest(request);
			    }else {
			    	return null;
			    }
			}
		};
	}
	
	//spring 2.6.0 以后的版本默认禁止 Bean 之间的循环引用, @Lazy 延迟加载, 打破循环依赖
	@Lazy
	@Autowired
	public void setRequestContext(RequestContext context) {
		SqlQueryCache.setRequestContext(context);
	}
	
	public static class HttpRequest implements Request {
		private HttpServletRequest request;

		public HttpRequest(HttpServletRequest request) {
			this.request = request;
		}
		@Override
		public Object getAttribute(String key) {
			return request.getAttribute(key);
		}
		@Override
		public void setAttribute(String key, Object value) {
			request.setAttribute(key, value);
		}
		
	}
}
