package com.bokesoft.distro.tech.bootsupport.starter.configurer;

import com.bokesoft.distro.tech.bootsupport.starter.config.TraceConfig;
import com.bokesoft.distro.tech.bootsupport.starter.config.YigoInstanceReadyConfig;
import com.bokesoft.distro.tech.bootsupport.starter.filter.DefaultSecurityFilter;
import com.bokesoft.distro.tech.bootsupport.starter.filter.ExecutionTimeoutPrepareFilter;
import com.bokesoft.distro.tech.bootsupport.starter.filter.YigoInstanceReadyFilter;
import com.bokesoft.distro.tech.bootsupport.starter.patch.LoginFilter4SpringBoot;
import com.bokesoft.distro.tech.bootsupport.starter.runtime.YigoInstanceManager;
import com.bokesoft.distro.tech.bootsupport.starter.servlet.ExceptionHandlerAttachmentServlet;
import com.bokesoft.distro.tech.bootsupport.starter.servlet.ExceptionHandlerServiceDispatch;
import com.bokesoft.distro.tech.yigosupport.extension.filter.RequestTrackingFilter;
import com.bokesoft.distro.tech.yigosupport.extension.filter.TracePrepareFilter;
import com.bokesoft.distro.tech.yigosupport.extension.filter.YigoServiceInfoClearFilter;
import com.bokesoft.yes.mid.filter.GZIPFilter;
import com.bokesoft.yes.mid.servlet.AttachmentServlet;
import com.bokesoft.yes.mid.servlet.ServiceServlet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * 实现 web.xml 定义的 WebApp 组件
 */
@Configuration
@ComponentScan
public class ServletContextConfigurer {
	private static final int FILTER_ORDER_BEFORE_GZIP = 1000;
	private static final int FILTER_ORDER_GZIP = 2000;
	private static final int FILTER_ORDER_AFTER_GZIP = 3000;

	private static final String BEAN_NAME_EX_YIGO_SERVLET = "com.bokesoft.distro.tech.bootsupport.starter.servlet.ExceptionHandlerServiceDispatch";
	private static final String BEAN_NAME_EX_YIGO_ATTACH = "com.bokesoft.distro.tech.bootsupport.starter.servlet.ExceptionHandlerAttachmentServlet";

	private static final String BEAN_NAME_BUILD_YIGO_INSTANCE_READY_CONFIG = "buildYigoInstanceReadyConfig";

	@Value("${distro.tech.bootsupport.login-filter.login-page}")
	private String loginFilter_loginPage;
	@Value("${distro.tech.bootsupport.login-filter.style}")
	private String loginFilter_style;
	@Value("${distro.tech.bootsupport.login-filter.main-page}")
	private String loginFilter_mainPage;
	@Value("${distro.tech.bootsupport.login-filter.waiting-page}")
	private String loginFilter_waitingPage;

	@Value("${distro.tech.bootsupport.login-filter.mobile-login-page}")
	private String loginFilter_mobileLoginPage;
	@Value("${distro.tech.bootsupport.login-filter.mobile-waiting-page}")
	private String loginFilter_mobileWaitingPage;
	@Value("${distro.tech.bootsupport.login-filter.mobile-main-page}")
	private String loginFilter_mobileMainPage;


	@Autowired
	private YigoInstanceManager yigoInstanceManager;

	@Autowired
	private TraceConfig traceConfig;

	@Bean(BEAN_NAME_BUILD_YIGO_INSTANCE_READY_CONFIG)
	@ConfigurationProperties(prefix="yigoee.tech.bootsupport.instance-ready")
	public YigoInstanceReadyConfig buildYigoInstanceReadyConfig(){
		return new YigoInstanceReadyConfig(new String[]{loginFilter_loginPage, loginFilter_mainPage, loginFilter_waitingPage},
				new String[]{loginFilter_mobileLoginPage, loginFilter_mobileWaitingPage, loginFilter_mobileMainPage});
	}

	@Bean
	@Autowired
	@DependsOn({BEAN_NAME_BUILD_YIGO_INSTANCE_READY_CONFIG})
	public FilterRegistrationBean<YigoInstanceReadyFilter> yigoInstanceReadyFilter(YigoInstanceReadyConfig yigoInstanceReadyConfig) {
		FilterRegistrationBean<YigoInstanceReadyFilter> filter =
				new FilterRegistrationBean<>(new YigoInstanceReadyFilter(yigoInstanceManager, loginFilter_waitingPage,
						loginFilter_mobileWaitingPage,	yigoInstanceReadyConfig));
		filter.setUrlPatterns(Collections.singletonList("/*"));
		filter.setOrder(FILTER_ORDER_BEFORE_GZIP);
		return filter;
	}

	@Bean
	public FilterRegistrationBean<TracePrepareFilter> registerTracePrepareFilter() {
		FilterRegistrationBean<TracePrepareFilter> filter =
				new FilterRegistrationBean<>(new TracePrepareFilter());
		Map<String, String> initParameters = new LinkedHashMap<>();
		initParameters.put(TracePrepareFilter.PARA_OVERFLOW_LIMIT, ""+traceConfig.getDrConfig().getLimit());
		initParameters.put(TracePrepareFilter.PARA_OVERFLOW_STRATEGY, traceConfig.getDrConfig().getOverflowStrategy());
		filter.setInitParameters(initParameters);
		filter.setUrlPatterns(Collections.singletonList("/*"));
		filter.setOrder(FILTER_ORDER_BEFORE_GZIP);
		return filter;
	}

	@Bean
	public FilterRegistrationBean<YigoServiceInfoClearFilter> registerYigoServiceInfoClearFilter() {
		FilterRegistrationBean<YigoServiceInfoClearFilter> filter =
				new FilterRegistrationBean<>(new YigoServiceInfoClearFilter());
		filter.setUrlPatterns(Collections.singletonList("/*"));
		filter.setOrder(FILTER_ORDER_AFTER_GZIP);
		return filter;
	}

	@Bean
	public FilterRegistrationBean<ExecutionTimeoutPrepareFilter> executionTImeoutFilter() {
		FilterRegistrationBean<ExecutionTimeoutPrepareFilter> filter = new FilterRegistrationBean<>(new ExecutionTimeoutPrepareFilter());
		filter.setUrlPatterns(Collections.singletonList("/*"));
		filter.setOrder(FILTER_ORDER_BEFORE_GZIP);
		return filter;
	}

	@Bean
	@ConditionalOnProperty(name="distro.tech.bootsupport.gzip-filter.enabled",havingValue="true",matchIfMissing = true)
	public FilterRegistrationBean<GZIPFilter> gzipFilter() {
		FilterRegistrationBean<GZIPFilter> filter = new FilterRegistrationBean<>(new GZIPFilter());
		filter.setUrlPatterns(Collections.singletonList("/*"));
		filter.setOrder(FILTER_ORDER_GZIP);
		return filter;
	}

	@Bean
	@ConditionalOnProperty(name = "distro.tech.bootsupport.buildin-loginfilter.enabled",havingValue = "true",matchIfMissing = true)
	public FilterRegistrationBean<LoginFilter4SpringBoot> loginFilter() {
		FilterRegistrationBean<LoginFilter4SpringBoot> filter =
				new FilterRegistrationBean<>(new LoginFilter4SpringBoot());

		Map<String, String> initParameters = new LinkedHashMap<>();
		initParameters.put("encoding", "UTF-8");
		initParameters.put("loginpage", loginFilter_loginPage);
		initParameters.put("style", loginFilter_style);
		filter.setInitParameters(initParameters);
		filter.setUrlPatterns(Arrays.asList(loginFilter_mainPage, "/"));
		filter.setOrder(FILTER_ORDER_AFTER_GZIP);
		return filter;
	}

	@Bean
	public FilterRegistrationBean<DefaultSecurityFilter> defaultSecurityFilter() {
		FilterRegistrationBean<DefaultSecurityFilter> filter =
				new FilterRegistrationBean<>(new DefaultSecurityFilter());
		filter.setUrlPatterns(Collections.singletonList("/*"));
		filter.setOrder(FILTER_ORDER_AFTER_GZIP);
		return filter;
	}

	@Bean
	public FilterRegistrationBean<RequestTrackingFilter> requestTrackingFilter() {
		FilterRegistrationBean<RequestTrackingFilter> filter =
				new FilterRegistrationBean<>(new RequestTrackingFilter());
		filter.setUrlPatterns(Collections.singletonList("/*"));
		filter.setOrder(FILTER_ORDER_AFTER_GZIP);
		return filter;
	}

	@Bean( name = BEAN_NAME_EX_YIGO_SERVLET )
	@ConditionalOnProperty(name = "yigoee.tech.bootsupport.global-exception.enabled", havingValue = "true", matchIfMissing = true)
	public ServletRegistrationBean<ServiceServlet> serviceDispatchWithWrapTraceIdException() {
		return new ServletRegistrationBean<>(new ExceptionHandlerServiceDispatch(yigoInstanceManager), "/servlet", "/servlet/*");
	}

	@Bean( name = BEAN_NAME_EX_YIGO_ATTACH )
	@ConditionalOnProperty(name = "yigoee.tech.bootsupport.global-exception.enabled", havingValue = "true", matchIfMissing = true)
	public ServletRegistrationBean<AttachmentServlet> attachmentServletWithWrapTraceIdException() {
		return new ServletRegistrationBean<>(new ExceptionHandlerAttachmentServlet(), "/attach", "/attach/*");
	}

	@Bean
	@ConditionalOnMissingBean(name = { BEAN_NAME_EX_YIGO_SERVLET })
	public ServletRegistrationBean<ServiceServlet> serviceDispatch() {
		return new ServletRegistrationBean<>(new ServiceServlet(), "/servlet", "/servlet/*");
	}

	@Bean
	@ConditionalOnMissingBean(name = { BEAN_NAME_EX_YIGO_ATTACH })
	public ServletRegistrationBean<AttachmentServlet> attachmentServlet() {
		return new ServletRegistrationBean<>(new AttachmentServlet(), "/attach", "/attach/*");
	}

}