package com.bokesoft.distro.tech.bootsupport.starter.configurer;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DeprecatedConfigurer {

    /**
     * 检查旧的datapath配置是否还在使用
     */
    @Value("${distro.tech.bootsupport.datapath:}")
    public void checkNoUseDatapath(String dataPath) {
        if (StringUtils.isNotBlank(dataPath)) {
            throw new RuntimeException("配置项 distro.tech.bootsupport.datapath 已废弃, 请使用 yigo.configuration.solution.data-path");
        }
    }


}
