package com.bokesoft.distro.tech.bootsupport.starter.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="distro.tech.yigosupport.pages")
public class YigoPagesConfig {
    /** 在 Yigo 发布 jar 包中 Web 应用资源所在的目录 */
	public static final String YIGO_RESOURCE_LOCATION = "classpath:/webapps/yigo/";

    private static final String RESOURCE_MAIN_PURE_JSP = YigoPagesConfig.YIGO_RESOURCE_LOCATION+"main_pure.html";
	private static final String RESOURCE_LOGIN_JSP = YigoPagesConfig.YIGO_RESOURCE_LOCATION+"login.html";
    private static final String RESOURCE_WAITING_JSP = RESOURCE_LOGIN_JSP;
    private static final String RESOURCE_MOBILE_HOME_HTML = YigoPagesConfig.YIGO_RESOURCE_LOCATION+"m_home.html";
    private static final String RESOURCE_MOBILE_LGOIN_HTML = YigoPagesConfig.YIGO_RESOURCE_LOCATION+"m_login.html";
    private static final String RESOURCE_MOBILE_WAITING_HTML = RESOURCE_MOBILE_HOME_HTML;

    /** 默认(即 Web 页面)的静态资源 URL 定义 */
    private DefaultPageResourceLocations defaultPageResourceLocations = DefaultPageResourceLocations.buildDefault();

    public DefaultPageResourceLocations getDefaultPageResourceLocations() {
        return defaultPageResourceLocations;
    }
    public void setDefaultPageResourceLocations(DefaultPageResourceLocations defaultPageResourceLocations) {
        this.defaultPageResourceLocations = defaultPageResourceLocations;
    }

    public static class DefaultPageResourceLocations {

        /** 登录页面的静态资源位置 */
        private String login;
        /** 主框架页面的静态资源位置 */
        private String mainframe;
        /** 等待页面的静态资源位置 */
        private String waiting;
        /** 手持主页面资源位置 */
        private String mobileHome;
        /** 手持登录页面资源位置 */
        private String mobileLogin;
        /** 手持登录页面资源位置 */
        private String mobileWaiting;

        public String getLogin() {
            return login;
        }
        public void setLogin(String login) {
            this.login = login;
        }
        public String getMainframe() {
            return mainframe;
        }
        public void setMainframe(String mainframe) {
            this.mainframe = mainframe;
        }
        public String getWaiting() {
            return waiting;
        }
        public void setWaiting(String waiting) {
            this.waiting = waiting;
        }
        public String getMobileHome() {
            return mobileHome;
        }
        public void setMobileHome(String mobileHome) {
            this.mobileHome = mobileHome;
        }
        public String getMobileLogin() {
            return mobileLogin;
        }
        public void setMobileLogin(String mobileLogin) {
            this.mobileLogin = mobileLogin;
        }

        public String getMobileWaiting() {
            return mobileWaiting;
        }
        public void setMobileWaiting(String mobileWaiting) {
            this.mobileWaiting = mobileWaiting;
        }

        public static final DefaultPageResourceLocations buildDefault(){
            DefaultPageResourceLocations d = new DefaultPageResourceLocations();
            d.setLogin(RESOURCE_LOGIN_JSP);
            d.setMainframe(RESOURCE_MAIN_PURE_JSP);
            d.setWaiting(RESOURCE_WAITING_JSP);
            d.setMobileHome(RESOURCE_MOBILE_HOME_HTML);
            d.setMobileLogin(RESOURCE_MOBILE_LGOIN_HTML);
            d.setMobileWaiting(RESOURCE_MOBILE_WAITING_HTML);
            return d;
        }
    }
}
