package com.bokesoft.distro.tech.bootsupport.starter.config;

import com.bokesoft.distro.tech.bootsupport.starter.beans.HealthController;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * 与实例是否 Ready 状态控制相关的配置
 */
public class YigoInstanceReadyConfig {
    /** 默认的独立请求 URL */
    private final String[] DEFAULT_INDEP_URLS = {
        "*.jpg", "*.png", "*.git", "*.woff2", "*.js", "*.css", "*.less", "*.js.map", HealthController.HEALTH_REQUEST_PREFIX+"/**"
    };
    /** 默认的PC应用页面 URL */
    private List<String> DEFAULT_APP_PC_PAGE_URLS = new ArrayList<>();

    /** 默认的手持应用页面 URL */
    private List<String> DEFAULT_APP_MOBILE_PAGE_URLS = new ArrayList<>();

    /** PC应用页面 URL 集合. 如果 Yigo 实例没有 Ready, 这些页面将被重定向到 Waiting 页面. */
    private List<String> appPcPageUrls = new ArrayList<>();

    /** 手持应用页面 URL 集合. 如果 Yigo 实例没有 Ready, 这些页面将被重定向到 Waiting 页面. */
    private List<String> appMobilePageUrls = new ArrayList<>();

    /** 独立请求 URL 集合, 支持通配符(独立请求的意思是其是否可以访问与 Yigo 实例是否启动无关). */
    private List<String> yigoIndepUrls = new ArrayList<>();

    public List<String> getAppPcPageUrls() {
        return appPcPageUrls;
    }

    public List<String> getAppMobilePageUrls() {
        return appMobilePageUrls;
    }

    public void setAppPcPageUrls(List<String> appPcPageUrls) {
        this.appPcPageUrls = appPcPageUrls;
        // 将 DEFAULT_APP_PAGE_URLS merge 回来
        this.appPcPageUrls.addAll(DEFAULT_APP_PC_PAGE_URLS);
    }

    public void setAppMobilePageUrls(List<String> appMobilePageUrls){
        this.appMobilePageUrls = appMobilePageUrls;
        this.appMobilePageUrls.addAll(DEFAULT_APP_MOBILE_PAGE_URLS);
    }

    public List<String> getYigoIndepUrls() {
        return yigoIndepUrls;
    }
    public void setYigoIndepUrls(List<String> yigoIndepUrls) {
        this.yigoIndepUrls = yigoIndepUrls;
        // 将 DEFAULT_INDEP_URLS merge 回来
        this.yigoIndepUrls.addAll(Arrays.asList(DEFAULT_INDEP_URLS));
    }

    public YigoInstanceReadyConfig(String[] defaultPcPageUrls,String[] defaultMobilePageUrls){
        this.DEFAULT_APP_PC_PAGE_URLS.add("/");
        this.DEFAULT_APP_PC_PAGE_URLS.addAll(Arrays.asList(defaultPcPageUrls));
        this.DEFAULT_APP_MOBILE_PAGE_URLS.addAll(Arrays.asList(defaultMobilePageUrls));

        /* 考虑以下情况,所以在构造函数中对 appPcPageUrls, appMobilePageUrls 赋值一次
         * 1.不一定有yml修改触发 setter 方法
         * 2.不建议如果变量为空返回default定义值, 每次 Arrays.asList 是有性能损耗的
         */
        this.appPcPageUrls.addAll(DEFAULT_APP_PC_PAGE_URLS);
        this.appMobilePageUrls.addAll(DEFAULT_APP_MOBILE_PAGE_URLS);

        this.yigoIndepUrls.addAll(Arrays.asList(DEFAULT_INDEP_URLS));
    }
}
