package com.bokesoft.distro.tech.bootsupport.starter.beans;

import java.io.ByteArrayInputStream;

import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.bokesoft.distro.tech.yigosupport.extension.utils.yigo.SessionUtils;
import com.bokesoft.distro.tech.yigosupport.extension.utils.yigo.StorageUtil;

/**
 * 与文件下载有关的一些功能, 主要用于 PDF 打印、数据导出等
 */
@RestController
public class FileController {
	
	/** 文件下载显示方式 - inline */
	public static final int FILE_VIEW_INLINE = 10;
	/** 文件下载显示方式 - download */
	public static final int FILE_VIEW_DOWNLOAD = 20;
	
	/** 文件类型 - 二进制文件 */
	public static final int MEDIA_TYPE_BIN = 10;
	/** 文件类型 - PDF */
	public static final int MEDIA_TYPE_PDF = 20;
	/** 文件类型 - Excel */
	public static final int MEDIA_TYPE_EXCEL = 30;
	
	/** 用于文件下载/显示的 URL 前缀 */
	private static final String PREFIX_FILE_DOWNLOAD = "/remote-files";
	
	/**
	 * 供其他程序调用的静态方法, 统一 URL 的生成方式
	 * @param fileId
	 * @param fileName
	 * @return
	 */
	public static String buildDownloadUrl(String fileId, String fileName, int fileViewType,String prefix, int mediaType) {
		String url = PREFIX_FILE_DOWNLOAD.substring(1)/*去掉首字符"/"*/
				+ "/" + fileViewType + "/" + mediaType + "/" +prefix+"/"+ fileId + "/" + fileName;
		return url;
	}
	
	@RequestMapping(PREFIX_FILE_DOWNLOAD + "/{fileViewType}/{mediaType}/{prefix}/{fileId}/{fileName}")
	public ResponseEntity<InputStreamResource> fileDownload(
			@PathVariable("fileViewType") int fileViewType,
			@PathVariable("mediaType") int mediaType,
			@PathVariable("prefix") String prefix,
			@PathVariable("fileId") String fileId,
			@PathVariable("fileName") String fileName) throws Throwable {
			
			return SessionUtils.processWithContext(null, ctx->{
				byte[] bytes = StorageUtil.readFile(ctx, prefix, fileId+"/"+fileName);
				
				try(ByteArrayInputStream in = new ByteArrayInputStream(bytes)){
					HttpHeaders headers = new HttpHeaders();
		            if (FILE_VIEW_INLINE==fileViewType) {
		            	headers.add("Content-Disposition", "inline; filename="+fileName);
		            }else if (FILE_VIEW_DOWNLOAD==fileViewType) {
		            	headers.add("Content-Disposition", "attachment; filename="+fileName);
		            }
		            headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
		            headers.add("Pragma", "no-cache");
		            headers.add("Expires", "0");
		            ResponseEntity<InputStreamResource> response = ResponseEntity.ok().headers(headers)
		                    .contentType(calcMediaType(mediaType))
		                    .body(new InputStreamResource(in));
		            return response;
				}
			});
	}

	private MediaType calcMediaType(int mediaType) {
		MediaType mt;
		switch (mediaType) {
		case MEDIA_TYPE_BIN:
			mt = MediaType.APPLICATION_OCTET_STREAM;
			break;
		case MEDIA_TYPE_PDF:
			mt = MediaType.APPLICATION_PDF;
			break;
		case MEDIA_TYPE_EXCEL:
			mt = new MediaType("application/vnd.ms-excel");
			break;
		default:
			mt = MediaType.APPLICATION_OCTET_STREAM;
			break;
		}
		return mt;
	}
}
