package com.bokesoft.distro.tech.bootsupport.starter.auth.strage;

import com.bokesoft.distro.tech.bootsupport.starter.auth.strage.impl.TokenPermissionChecker;
import com.bokesoft.distro.tech.commons.basis.auth.annotation.Strategy;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.EnumMap;
import java.util.Map;


@Component
public class PermissionCheckerRegistry {

    private final TokenPermissionChecker tokenPermissionChecker;

    private final Map<Strategy, PermissionCheckerStrategy> registry = new EnumMap<>(Strategy.class);

    public PermissionCheckerRegistry(TokenPermissionChecker tokenPermissionChecker) {
        this.tokenPermissionChecker = tokenPermissionChecker;
    }

    @PostConstruct
    public void init() {
        registry.put(Strategy.TOKEN, tokenPermissionChecker);
    }

    public PermissionCheckerStrategy get(Strategy strategy) {
        return registry.get(strategy);
    }

}
