package com.bokesoft.distro.tech.bootsupport.starter.api.ctx;

import javax.servlet.http.HttpServletRequest;

import com.bokesoft.distro.tech.bootsupport.starter.beans.PagesBuildService;
import com.bokesoft.distro.tech.bootsupport.starter.utils.ServletUtil;
import com.bokesoft.yigo.mid.base.DefaultContext;
import org.apache.commons.lang3.StringUtils;

/**
 * 页面构建所需上下文,参考 {@link PagesBuildService#buildPage(String, PageBuildContext, String)}
 *
 */
public class PageBuildContext {
    /**
     * 当前页面类型. 非系统级页面默认使用 {@link PageClass#CUSTOM}
     */
    private PageClass pageClass;
    /**
     * 当前页面访问路径(不包括 ContextPath)
     */
    private String pagePath;
    /**
     * Yigo 上下文
     */
    private DefaultContext defaultContext;

    public PageBuildContext(String pagePath) {
        this(PageClass.CUSTOM, pagePath);
    }

    public PageBuildContext(PageClass pageClass, String pagePath) {
        this.pageClass = pageClass;
        this.pagePath = pagePath;
    }

    public PageClass getPageClass() {
        return pageClass;
    }

    public String getPagePath() {
        return pagePath;
    }

    public DefaultContext getDefaultContext() {
        return defaultContext;
    }

    public void setDefaultContext(DefaultContext context){
        this.defaultContext = context;
    }

    public static PageBuildContext build(HttpServletRequest request, PageClass pageClass){
        return new PageBuildContext(pageClass, ServletUtil.getFullServletPath(request));
    }

    public static PageBuildContext build(HttpServletRequest request){
        return PageBuildContext.build(request, PageClass.CUSTOM);
    }

    public enum PageClass {

        /** 等待页面 */
        WAITING(101),
        /** Web 应用登录页面 */
        LOGIN(102),
        /** Web 应用主框架页面 */
        MAINFRAME(103),
        /** 手持等待页面*/
        MOBILEWAITING(201),
        /** 手持登录页面*/
        MOBILELOGIN(202),
        /** 手持应用主框架页面 */
        MOBILEHOME(203),

        /**
         * 手持应用主框架页面
         * @deprecated 已被 {@link PageClass#MOBILEHOME} 代替
         */
        @Deprecated
        APPHOME(203),
        /** 自定义页面 */
        CUSTOM(999999);

        private int value;
        PageClass(int value){
            this.value = value;
        }
        public int getValue(){
            return this.value;
        }
    }
}
