/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.bootsupport.yigoconfig.configurer;

import com.bokesoft.distro.tech.bootsupport.starter.api.YigoAdditionalInitiator;
import com.bokesoft.distro.tech.bootsupport.yigoconfig.config.YigoConfigBean;
import com.bokesoft.distro.tech.bootsupport.yigoconfig.config.struc.LoginConfig;
import com.bokesoft.distro.tech.bootsupport.yigoconfig.config.struc.SessionConfig;
import com.bokesoft.distro.tech.bootsupport.yigoconfig.config.struc.SettingConfig;
import com.bokesoft.yes.mid.session.AccountLockoutInfoProvider;
import com.bokesoft.yes.mid.session.IAccountLockoutInfoMap;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.setting.MetaLoginSetting;
import com.bokesoft.yigo.meta.setting.MetaSession;
import com.bokesoft.yigo.meta.setting.MetaSetting;
import com.bokesoft.yigo.mid.base.DefaultContext;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class YigoConfigConfigurer {
    private static Logger log = LoggerFactory.getLogger(YigoConfigConfigurer.class);
    @Autowired
    private YigoConfigBean yigoConfig;

    @Bean
    public YigoAdditionalInitiator initYigoConfig() {
        return new YigoAdditionalInitiator(){

            public void init(DefaultContext yigoCtx) {
                if (null != YigoConfigConfigurer.this.yigoConfig) {
                    SettingConfig settingConfig = YigoConfigConfigurer.this.yigoConfig.getSetting();
                    YigoConfigConfigurer.this.setSettingInfo(yigoCtx, settingConfig);
                }
            }
        };
    }

    private void setSettingInfo(DefaultContext yigoCtx, SettingConfig settingConfig) {
        if (null != settingConfig) {
            String ssoProviderClassName;
            LoginConfig loginConfig;
            SessionConfig sessionConfig = settingConfig.getSession();
            if (null != sessionConfig) {
                Integer accountLockoutDuration;
                MetaSession metaSession = this.getMetaSession(yigoCtx);
                Integer accountLockoutThreshold = sessionConfig.getAccountLockoutThreshold();
                if (null != accountLockoutThreshold) {
                    metaSession.setAccountLockoutThreshold(accountLockoutThreshold);
                    log.info("\u52a0\u8f7d Yigo \u7a0b\u5e8f: \u5f3a\u5236\u8bbe\u7f6e AccountLockoutThreshold='{}' .", (Object)accountLockoutThreshold);
                }
                if (null != (accountLockoutDuration = sessionConfig.getAccountLockoutDuration())) {
                    metaSession.setAccountLockoutDuration(accountLockoutDuration);
                    log.info("\u52a0\u8f7d Yigo \u7a0b\u5e8f: \u5f3a\u5236\u8bbe\u7f6e AccountLockoutDuration='{}' .", (Object)accountLockoutDuration);
                }
                this.initAccountLockoutInfoMap(metaSession);
            }
            if (null != (loginConfig = settingConfig.getLogin()) && StringUtils.isNotBlank((CharSequence)(ssoProviderClassName = loginConfig.getSsoProvider()))) {
                MetaSetting settings = MetaFactory.getGlobalInstance().getSetting();
                MetaLoginSetting loginSetting = settings.getLogin();
                if (null == loginSetting) {
                    loginSetting = new MetaLoginSetting();
                    settings.setLogin(loginSetting);
                }
                loginSetting.setSSOProvider(ssoProviderClassName);
                log.info("\u52a0\u8f7d Yigo \u7a0b\u5e8f: \u8bbe\u7f6e ssoProvider='{}' .", (Object)ssoProviderClassName);
            }
        }
    }

    private MetaSession getMetaSession(DefaultContext yigoCtx) {
        MetaSession metaSession = yigoCtx.getVE().getMetaFactory().getSetting().getSession();
        if (null == metaSession) {
            metaSession = new MetaSession();
            yigoCtx.getVE().getMetaFactory().getSetting().setSession(metaSession);
        }
        return metaSession;
    }

    private void initAccountLockoutInfoMap(MetaSession metaSession) {
        IAccountLockoutInfoMap lockInfo = AccountLockoutInfoProvider.getInstance().getAccountLockoutInfoMap();
        lockInfo.setAccountLockoutDuration(metaSession == null ? 0 : metaSession.getAccountLockoutDuration());
        lockInfo.setAccountLockoutThreshold(metaSession == null ? 0 : metaSession.getAccountLockoutThreshold());
    }
}

