/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.loadbalancer;

import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.loadbalancer.annotation.LoadBalancerClientConfigurationRegistrar;
import org.springframework.cloud.loadbalancer.annotation.LoadBalancerClients;
import org.springframework.cloud.loadbalancer.config.LoadBalancerZoneConfig;
import org.springframework.cloud.netflix.eureka.loadbalancer.EurekaLoadBalancerClientConfiguration;
import org.springframework.cloud.netflix.eureka.loadbalancer.EurekaLoadBalancerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={EurekaLoadBalancerProperties.class})
@ConditionalOnClass(value={LoadBalancerClientConfigurationRegistrar.class})
@LoadBalancerClients(defaultConfiguration={EurekaLoadBalancerClientConfiguration.class})
public class LoadBalancerEurekaAutoConfiguration {
    public static final String LOADBALANCER_ZONE = "spring.cloud.loadbalancer.zone";

    @Bean
    @ConditionalOnMissingBean
    EurekaLoadBalancerProperties eurekaLoadBalancerProperties() {
        return new EurekaLoadBalancerProperties();
    }

    @Bean
    @ConditionalOnMissingBean
    LoadBalancerZoneConfig zoneConfig(Environment environment) {
        return new LoadBalancerZoneConfig(environment.getProperty(LOADBALANCER_ZONE));
    }
}

