/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.processor;

import java.sql.SQLException;
import java.util.concurrent.CountDownLatch;

public abstract class ThreadTask<T>
implements Runnable {
    private boolean success = false;
    private SQLException error = null;
    private CountDownLatch countDownLatch;
    private T obj;

    public ThreadTask(T obj, CountDownLatch countDownLatch) {
        this.obj = obj;
        this.countDownLatch = countDownLatch;
    }

    @Override
    public void run() {
        try {
            try {
                this.doTask();
                this.setSuccess(true);
            }
            catch (SQLException e2) {
                this.setError(e2);
                this.setSuccess(false);
                if (this.countDownLatch != null) {
                    this.countDownLatch.countDown();
                }
            }
        }
        finally {
            if (this.countDownLatch != null) {
                this.countDownLatch.countDown();
            }
        }
    }

    protected abstract void doTask() throws SQLException;

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setError(SQLException error) {
        this.error = error;
    }

    public SQLException getError() {
        return this.error;
    }

    public T getObj() {
        return this.obj;
    }

    public void setObj(T obj) {
        this.obj = obj;
    }
}

