/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.processor;

import dm.jdbc.desc.conf.DmSvcConf;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.filter.log.ILogger;
import dm.jdbc.filter.log.LogFactory;
import dm.jdbc.processor.BaseThread;
import dm.jdbc.util.CacheQueue;
import dm.jdbc.util.MiscUtil;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashMap;

public class DBAliveCheckThread
extends BaseThread {
    private static ILogger log = LogFactory.getLog(DBAliveCheckThread.class);
    private CacheQueue<DmdbConnection> connList = new CacheQueue<DmdbConnection>(Integer.MAX_VALUE, false){

        @Override
        protected boolean needRemove(DmdbConnection conn) {
            return conn.do_isClosed();
        }
    };

    private DBAliveCheckThread() {
        super("DB-ALIVE-CHECK-THREAD");
        this.start();
    }

    public static DBAliveCheckThread getInstance() {
        return DBAliveCheckThreadHolder.instance;
    }

    public static void addConnection(DmdbConnection conn) {
        if (DmSvcConf.GLOBAL.dbAliveCheckFreq <= 0) {
            return;
        }
        DBAliveCheckThread.getInstance().connList.put(conn);
    }

    @Override
    public void run() {
        HashMap<String, Boolean> dbStatMap = new HashMap<String, Boolean>();
        while (true) {
            block7: {
                try {
                    dbStatMap.clear();
                    DmdbConnection conn = null;
                    int count = this.connList.size();
                    int i2 = 0;
                    while (i2 < count) {
                        block8: {
                            conn = this.connList.get();
                            if (conn == null) break block7;
                            try {
                                String url = String.valueOf(conn.host) + ":" + conn.port;
                                Boolean alive = (Boolean)dbStatMap.get(url);
                                if (alive == null) {
                                    alive = this.checkDbAlive(conn.host, conn.port);
                                    dbStatMap.put(url, alive);
                                }
                                if (alive.booleanValue()) break block8;
                                conn.abort(null);
                            }
                            catch (Exception exception) {}
                        }
                        this.connList.put(conn);
                        ++i2;
                    }
                }
                catch (Exception exception) {}
            }
            MiscUtil.sleep(DmSvcConf.GLOBAL.dbAliveCheckFreq);
        }
    }

    private boolean checkDbAlive(String host, int port) {
        boolean alive;
        block5: {
            alive = false;
            Socket socket = null;
            try {
                try {
                    socket = new Socket();
                    InetSocketAddress socketAddress = new InetSocketAddress(host, port);
                    socket.connect(socketAddress, DmSvcConf.GLOBAL.dbAliveCheckTimeout);
                    alive = true;
                }
                catch (Exception e2) {
                    log.warn("checkDbAlive failed: " + e2.getMessage());
                    MiscUtil.close(socket);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                MiscUtil.close(socket);
                throw throwable;
            }
            MiscUtil.close(socket);
        }
        return alive;
    }

    /* synthetic */ DBAliveCheckThread(DBAliveCheckThread dBAliveCheckThread) {
        this();
    }

    private static class DBAliveCheckThreadHolder {
        private static final DBAliveCheckThread instance = new DBAliveCheckThread(null);

        private DBAliveCheckThreadHolder() {
        }
    }
}

