/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter.stat;

import dm.jdbc.desc.conf.DmSvcConf;
import dm.jdbc.driver.Configuration;
import dm.jdbc.filter.stat.StatReader;
import dm.jdbc.processor.BaseFlusher;
import dm.jdbc.util.DateUtil;
import dm.jdbc.util.MiscUtil;
import dm.jdbc.util.StringUtil;
import java.util.ArrayList;
import java.util.Date;

public class StatFlusher
extends BaseFlusher {
    private static StatReader statReader = new StatReader();
    private static int READ_MAX_SIZE = 100;
    private ArrayList<String> logList;

    private StatFlusher() {
        super("StatFlusher", DmSvcConf.GLOBAL.statDir, "dm_jdbc_stat", DmSvcConf.GLOBAL.statFlushFreq);
        this.fileExtention = DmSvcConf.GLOBAL.statFileType == Configuration.STAT_FILE_TYPE_CSV ? ".csv" : this.fileExtention;
    }

    public static StatFlusher getInstance() {
        return StatFlusherThreadHolder.instance;
    }

    public static boolean isConnStatEnabled() {
        return DmSvcConf.GLOBAL.statEnable;
    }

    public static boolean isSlowSqlStatEnabled() {
        return DmSvcConf.GLOBAL.statEnable;
    }

    public static boolean isHighFreqSqlStatEnabled() {
        return DmSvcConf.GLOBAL.statEnable;
    }

    @Override
    protected void doRun() {
        while (this.flushFreq > 0) {
            this.doStat();
            MiscUtil.sleep(this.flushFreq * 1000);
        }
    }

    protected void doStat() {
        boolean hasMore;
        if (this.logList == null) {
            this.logList = new ArrayList(16);
        }
        this.logList.add("******************************************************* " + DateUtil.formatDate(new Date(System.currentTimeMillis()), 2) + " *******************************************************");
        if (StatFlusher.isConnStatEnabled()) {
            this.logList.add("#connection stat");
            hasMore = true;
            while (hasMore) {
                hasMore = statReader.readConnStat(this.logList, READ_MAX_SIZE);
                this.writeAndFlush(this.logList.toArray(new String[0]), 0, this.logList.size());
                this.logList.clear();
            }
        }
        if (StatFlusher.isHighFreqSqlStatEnabled()) {
            this.logList.add("#top " + DmSvcConf.GLOBAL.statHighFreqSqlCount + " high freq sql stat");
            hasMore = true;
            while (hasMore) {
                hasMore = statReader.readHighFreqSqlStat(this.logList, READ_MAX_SIZE);
                this.writeAndFlush(this.logList.toArray(new String[0]), 0, this.logList.size());
                this.logList.clear();
            }
        }
        if (StatFlusher.isSlowSqlStatEnabled()) {
            this.logList.add("#top " + DmSvcConf.GLOBAL.statSlowSqlCount + " slow sql stat");
            hasMore = true;
            while (hasMore) {
                hasMore = statReader.readSlowSqlStat(this.logList, READ_MAX_SIZE);
                this.writeAndFlush(this.logList.toArray(new String[0]), 0, this.logList.size());
                this.logList.clear();
            }
        }
        this.logList.add(StringUtil.LINE_SEPARATOR);
        this.logList.add(StringUtil.LINE_SEPARATOR);
        this.writeAndFlush(this.logList.toArray(new String[0]), 0, this.logList.size());
        this.logList.clear();
    }

    @Override
    protected void beforeExit() throws Exception {
        this.doStat();
    }

    protected void writeAndFlush(String[] logs, int startOff, int len) {
        byte[] bytes = null;
        int i2 = startOff;
        while (i2 < startOff + len) {
            bytes = (String.valueOf(logs[i2]) + StringUtil.LINE_SEPARATOR).getBytes();
            this.buffer.putBytes(bytes, 0, bytes.length);
            if (this.buffer.length() >= 32768) {
                this.doFlush(this.buffer);
            }
            ++i2;
        }
        if (this.buffer.length() > 0) {
            this.doFlush(this.buffer);
        }
    }

    /* synthetic */ StatFlusher(StatFlusher statFlusher) {
        this();
    }

    private static class StatFlusherThreadHolder {
        private static final StatFlusher instance = new StatFlusher(null);

        private StatFlusherThreadHolder() {
        }
    }
}

