/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter.stat;

import dm.jdbc.desc.conf.DmProperties;
import dm.jdbc.desc.conf.DmSvcConf;
import dm.jdbc.driver.DmDriver;
import dm.jdbc.driver.DmdbCallableStatement;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbDatabaseMetaData;
import dm.jdbc.driver.DmdbParameterMetaData;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbResultSetMetaData;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.filter.BaseFilter;
import dm.jdbc.filter.FilterChain;
import dm.jdbc.filter.stat.JdbcStat;
import dm.jdbc.filter.stat.StatFlusher;
import dm.jdbc.filter.stat.StatUtil;
import dm.jdbc.util.StringUtil;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.RowIdLifetime;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

public class StatFilter
extends BaseFilter {
    private static int maxConnSize = 1000;
    public static JdbcStat jdbcStat = new JdbcStat(maxConnSize);

    static {
        if (StringUtil.isNotEmpty(DmSvcConf.GLOBAL.statDir)) {
            StatFlusher.getInstance().start();
        }
    }

    private StatFilter() {
    }

    public static StatFilter getInstance() {
        return StatFilterThreadHolder.instance;
    }

    @Override
    public Connection Driver_connect(FilterChain filterChain, DmDriver driver, DmProperties props) throws SQLException {
        DmdbConnection conn = (DmdbConnection)filterChain.Driver_connect(driver, props);
        conn.statInfo.init(conn);
        conn.statInfo.setConstructNano();
        conn.statInfo.getConnStat().incrementConn();
        return conn;
    }

    @Override
    public void Connection_close(FilterChain filterChain, DmdbConnection dmdbConnection) throws SQLException {
        boolean isClosed = dmdbConnection.do_isClosed();
        if (!isClosed) {
            dmdbConnection.statInfo.getConnStat().decrementStmt(StatUtil.getActiveStmtCount(dmdbConnection));
            dmdbConnection.statInfo.getConnStat().decrementConn();
        }
        filterChain.Connection_close(dmdbConnection);
    }

    @Override
    public void Connection_commit(FilterChain filterChain, DmdbConnection dmdbConnection) throws SQLException {
        filterChain.Connection_commit(dmdbConnection);
        dmdbConnection.statInfo.getConnStat().incrementCommitCount();
    }

    @Override
    public Statement Connection_createStatement(FilterChain filterChain, DmdbConnection conn) throws SQLException {
        DmdbStatement stmt = (DmdbStatement)filterChain.Connection_createStatement(conn);
        StatUtil.statementCreateAfter(conn, stmt);
        return stmt;
    }

    @Override
    public Statement Connection_createStatement(FilterChain filterChain, DmdbConnection dmdbConnection, int resultSetType, int resultSetConcurrency) throws SQLException {
        DmdbStatement stmt = (DmdbStatement)filterChain.Connection_createStatement(dmdbConnection, resultSetType, resultSetConcurrency);
        StatUtil.statementCreateAfter(dmdbConnection, stmt);
        return stmt;
    }

    @Override
    public Statement Connection_createStatement(FilterChain filterChain, DmdbConnection dmdbConnection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        DmdbStatement stmt = (DmdbStatement)filterChain.Connection_createStatement(dmdbConnection, resultSetType, resultSetConcurrency, resultSetHoldability);
        StatUtil.statementCreateAfter(dmdbConnection, stmt);
        return stmt;
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain filterChain, DmdbConnection dmdbConnection, String sql) throws SQLException {
        DmdbPreparedStatement stmt = (DmdbPreparedStatement)filterChain.Connection_prepareStatement(dmdbConnection, sql);
        StatUtil.statementCreateAfter(dmdbConnection, stmt);
        return stmt;
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain filterChain, DmdbConnection dmdbConnection, String sql, int autoGeneratedKeys) throws SQLException {
        DmdbPreparedStatement stmt = (DmdbPreparedStatement)filterChain.Connection_prepareStatement(dmdbConnection, sql, autoGeneratedKeys);
        StatUtil.statementCreateAfter(dmdbConnection, stmt);
        return stmt;
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain filterChain, DmdbConnection dmdbConnection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        DmdbPreparedStatement stmt = (DmdbPreparedStatement)filterChain.Connection_prepareStatement(dmdbConnection, sql, resultSetType, resultSetConcurrency);
        StatUtil.statementCreateAfter(dmdbConnection, stmt);
        return stmt;
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain filterChain, DmdbConnection dmdbConnection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        DmdbPreparedStatement stmt = (DmdbPreparedStatement)filterChain.Connection_prepareStatement(dmdbConnection, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        StatUtil.statementCreateAfter(dmdbConnection, stmt);
        return stmt;
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain filterChain, DmdbConnection dmdbConnection, String sql, int[] columnIndexes) throws SQLException {
        DmdbPreparedStatement stmt = (DmdbPreparedStatement)filterChain.Connection_prepareStatement(dmdbConnection, sql, columnIndexes);
        StatUtil.statementCreateAfter(dmdbConnection, stmt);
        return stmt;
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain filterChain, DmdbConnection dmdbConnection, String sql, String[] columnNames) throws SQLException {
        DmdbPreparedStatement stmt = (DmdbPreparedStatement)filterChain.Connection_prepareStatement(dmdbConnection, sql, columnNames);
        StatUtil.statementCreateAfter(dmdbConnection, stmt);
        return stmt;
    }

    @Override
    public CallableStatement Connection_prepareCall(FilterChain filterChain, DmdbConnection dmdbConnection, String sql) throws SQLException {
        DmdbCallableStatement stmt = (DmdbCallableStatement)filterChain.Connection_prepareCall(dmdbConnection, sql);
        StatUtil.statementCreateAfter(dmdbConnection, stmt);
        return stmt;
    }

    @Override
    public CallableStatement Connection_prepareCall(FilterChain filterChain, DmdbConnection dmdbConnection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        DmdbCallableStatement stmt = (DmdbCallableStatement)filterChain.Connection_prepareCall(dmdbConnection, sql, resultSetType, resultSetConcurrency);
        StatUtil.statementCreateAfter(dmdbConnection, stmt);
        return stmt;
    }

    @Override
    public CallableStatement Connection_prepareCall(FilterChain filterChain, DmdbConnection dmdbConnection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        DmdbCallableStatement stmt = (DmdbCallableStatement)filterChain.Connection_prepareCall(dmdbConnection, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        StatUtil.statementCreateAfter(dmdbConnection, stmt);
        return stmt;
    }

    @Override
    public void Connection_rollback(FilterChain filterChain, DmdbConnection dmdbConnection) throws SQLException {
        filterChain.Connection_rollback(dmdbConnection);
        dmdbConnection.statInfo.getConnStat().incrementRollbackCount();
    }

    @Override
    public void Connection_rollback(FilterChain filterChain, DmdbConnection dmdbConnection, Savepoint savepoint) throws SQLException {
        filterChain.Connection_rollback(dmdbConnection, savepoint);
        dmdbConnection.statInfo.getConnStat().incrementRollbackCount();
    }

    @Override
    public void Statement_close(FilterChain filterChain, DmdbStatement dmdbStatement) throws SQLException {
        if (!dmdbStatement.do_isClosed()) {
            StatUtil.statementCloseBefore(dmdbStatement);
        }
        filterChain.Statement_close(dmdbStatement);
    }

    @Override
    public boolean Statement_execute(FilterChain filterChain, DmdbStatement dmdbStatement, String sql) throws SQLException {
        StatUtil.statementExecuteBefore(dmdbStatement, sql);
        try {
            boolean firstResult = filterChain.Statement_execute(dmdbStatement, sql);
            StatUtil.statementExecuteAfter(dmdbStatement, sql, firstResult);
            return firstResult;
        }
        catch (SQLException e2) {
            StatUtil.statementExecuteErrorAfter(dmdbStatement, e2);
            throw e2;
        }
    }

    @Override
    public boolean Statement_execute(FilterChain filterChain, DmdbStatement dmdbStatement, String sql, int autoGeneratedKeys) throws SQLException {
        StatUtil.statementExecuteBefore(dmdbStatement, sql);
        try {
            boolean firstResult = filterChain.Statement_execute(dmdbStatement, sql, autoGeneratedKeys);
            StatUtil.statementExecuteAfter(dmdbStatement, sql, firstResult);
            return firstResult;
        }
        catch (SQLException e2) {
            StatUtil.statementExecuteErrorAfter(dmdbStatement, e2);
            throw e2;
        }
    }

    @Override
    public boolean Statement_execute(FilterChain filterChain, DmdbStatement dmdbStatement, String sql, int[] columnIndexes) throws SQLException {
        StatUtil.statementExecuteBefore(dmdbStatement, sql);
        try {
            boolean firstResult = filterChain.Statement_execute(dmdbStatement, sql, columnIndexes);
            StatUtil.statementExecuteAfter(dmdbStatement, sql, firstResult);
            return firstResult;
        }
        catch (SQLException e2) {
            StatUtil.statementExecuteErrorAfter(dmdbStatement, e2);
            throw e2;
        }
    }

    @Override
    public boolean Statement_execute(FilterChain filterChain, DmdbStatement dmdbStatement, String sql, String[] columnNames) throws SQLException {
        StatUtil.statementExecuteBefore(dmdbStatement, sql);
        try {
            boolean firstResult = filterChain.Statement_execute(dmdbStatement, sql, columnNames);
            StatUtil.statementExecuteAfter(dmdbStatement, sql, firstResult);
            return firstResult;
        }
        catch (SQLException e2) {
            StatUtil.statementExecuteErrorAfter(dmdbStatement, e2);
            throw e2;
        }
    }

    @Override
    public int[] Statement_executeBatch(FilterChain filterChain, DmdbStatement dmdbStatement) throws SQLException {
        StatUtil.statementExecuteBatchBefore(dmdbStatement);
        try {
            int[] updateCount = filterChain.Statement_executeBatch(dmdbStatement);
            StatUtil.statementExecuteBatchAfter(dmdbStatement, updateCount);
            return updateCount;
        }
        catch (SQLException e2) {
            StatUtil.statementExecuteErrorAfter(dmdbStatement, e2);
            throw e2;
        }
    }

    @Override
    public ResultSet Statement_executeQuery(FilterChain filterChain, DmdbStatement dmdbStatement, String sql) throws SQLException {
        StatUtil.statementExecuteQueryBefore(dmdbStatement, sql);
        try {
            DmdbResultSet rs = (DmdbResultSet)filterChain.Statement_executeQuery(dmdbStatement, sql);
            StatUtil.statementExecuteQueryAfter(dmdbStatement, sql, rs);
            return rs;
        }
        catch (SQLException e2) {
            StatUtil.statementExecuteErrorAfter(dmdbStatement, e2);
            throw e2;
        }
    }

    @Override
    public int Statement_executeUpdate(FilterChain filterChain, DmdbStatement dmdbStatement, String sql) throws SQLException {
        StatUtil.statementExecuteUpdateBefore(dmdbStatement, sql);
        try {
            int updateCount = filterChain.Statement_executeUpdate(dmdbStatement, sql);
            StatUtil.statementExecuteUpdateAfter(dmdbStatement, sql, updateCount);
            return updateCount;
        }
        catch (SQLException e2) {
            StatUtil.statementExecuteErrorAfter(dmdbStatement, e2);
            throw e2;
        }
    }

    @Override
    public int Statement_executeUpdate(FilterChain filterChain, DmdbStatement dmdbStatement, String sql, int autoGeneratedKeys) throws SQLException {
        StatUtil.statementExecuteUpdateBefore(dmdbStatement, sql);
        try {
            int updateCount = filterChain.Statement_executeUpdate(dmdbStatement, sql, autoGeneratedKeys);
            StatUtil.statementExecuteUpdateAfter(dmdbStatement, sql, updateCount);
            return updateCount;
        }
        catch (SQLException e2) {
            StatUtil.statementExecuteErrorAfter(dmdbStatement, e2);
            throw e2;
        }
    }

    @Override
    public int Statement_executeUpdate(FilterChain filterChain, DmdbStatement dmdbStatement, String sql, int[] columnIndexes) throws SQLException {
        StatUtil.statementExecuteUpdateBefore(dmdbStatement, sql);
        try {
            int updateCount = filterChain.Statement_executeUpdate(dmdbStatement, sql, columnIndexes);
            StatUtil.statementExecuteUpdateAfter(dmdbStatement, sql, updateCount);
            return updateCount;
        }
        catch (SQLException e2) {
            StatUtil.statementExecuteErrorAfter(dmdbStatement, e2);
            throw e2;
        }
    }

    @Override
    public int Statement_executeUpdate(FilterChain filterChain, DmdbStatement dmdbStatement, String sql, String[] columnNames) throws SQLException {
        StatUtil.statementExecuteUpdateBefore(dmdbStatement, sql);
        try {
            int updateCount = filterChain.Statement_executeUpdate(dmdbStatement, sql, columnNames);
            StatUtil.statementExecuteUpdateAfter(dmdbStatement, sql, updateCount);
            return updateCount;
        }
        catch (SQLException e2) {
            StatUtil.statementExecuteErrorAfter(dmdbStatement, e2);
            throw e2;
        }
    }

    @Override
    public void ResultSet_close(FilterChain filterChain, DmdbResultSet dmdbResultSet) throws SQLException {
        if (!dmdbResultSet.do_isClosed()) {
            StatUtil.resultSetCloseBefore(dmdbResultSet);
        }
        filterChain.ResultSet_close(dmdbResultSet);
    }

    @Override
    public boolean PreparedStatement_execute(FilterChain filterChain, DmdbPreparedStatement rpstmt) throws SQLException {
        StatUtil.preparedStatementExecuteBefore(rpstmt);
        try {
            boolean firstResult = filterChain.PreparedStatement_execute(rpstmt);
            StatUtil.preparedStatementExecuteAfter(rpstmt, firstResult);
            return firstResult;
        }
        catch (SQLException e2) {
            StatUtil.statementExecuteErrorAfter(rpstmt, e2);
            throw e2;
        }
    }

    @Override
    public int[] PreparedStatement_executeBatch(FilterChain filterChain, DmdbPreparedStatement rpstmt) throws SQLException {
        StatUtil.preparedStatementExecuteBatchBefore(rpstmt);
        try {
            int[] updateCounts = filterChain.PreparedStatement_executeBatch(rpstmt);
            StatUtil.preparedStatementExecuteBatchAfter(rpstmt, updateCounts);
            return updateCounts;
        }
        catch (SQLException e2) {
            StatUtil.statementExecuteErrorAfter(rpstmt, e2);
            throw e2;
        }
    }

    @Override
    public ResultSet PreparedStatement_executeQuery(FilterChain filterChain, DmdbPreparedStatement rpstmt) throws SQLException {
        StatUtil.preparedStatementExecuteQueryBefore(rpstmt);
        try {
            DmdbResultSet rs = (DmdbResultSet)filterChain.PreparedStatement_executeQuery(rpstmt);
            StatUtil.preparedStatementExecuteQueryAfter(rpstmt, rs);
            return rs;
        }
        catch (SQLException e2) {
            StatUtil.statementExecuteErrorAfter(rpstmt, e2);
            throw e2;
        }
    }

    @Override
    public int PreparedStatement_executeUpdate(FilterChain filterChain, DmdbPreparedStatement rpstmt) throws SQLException {
        StatUtil.preparedStatementExecuteUpdateBefore(rpstmt);
        try {
            int updateCount = filterChain.PreparedStatement_executeUpdate(rpstmt);
            StatUtil.preparedStatementExecuteUpdateAfter(rpstmt, updateCount);
            return updateCount;
        }
        catch (SQLException e2) {
            StatUtil.statementExecuteErrorAfter(rpstmt, e2);
            throw e2;
        }
    }

    @Override
    public void Connection_abort(FilterChain chain, DmdbConnection connection, Executor executor) throws SQLException {
        chain.Connection_abort(connection, executor);
    }

    @Override
    public void Connection_clearWarnings(FilterChain chain, DmdbConnection connection) throws SQLException {
        chain.Connection_clearWarnings(connection);
    }

    @Override
    public Array Connection_createArrayOf(FilterChain chain, DmdbConnection connection, String typeName, Object[] elements) throws SQLException {
        return chain.Connection_createArrayOf(connection, typeName, elements);
    }

    @Override
    public Blob Connection_createBlob(FilterChain chain, DmdbConnection connection) throws SQLException {
        return chain.Connection_createBlob(connection);
    }

    @Override
    public Clob Connection_createClob(FilterChain chain, DmdbConnection connection) throws SQLException {
        return chain.Connection_createClob(connection);
    }

    @Override
    public NClob Connection_createNClob(FilterChain chain, DmdbConnection connection) throws SQLException {
        return chain.Connection_createNClob(connection);
    }

    @Override
    public SQLXML Connection_createSQLXML(FilterChain chain, DmdbConnection connection) throws SQLException {
        return chain.Connection_createSQLXML(connection);
    }

    @Override
    public Struct Connection_createStruct(FilterChain chain, DmdbConnection connection, String typeName, Object[] attributes) throws SQLException {
        return chain.Connection_createStruct(connection, typeName, attributes);
    }

    @Override
    public boolean Connection_getAutoCommit(FilterChain chain, DmdbConnection connection) throws SQLException {
        return chain.Connection_getAutoCommit(connection);
    }

    @Override
    public String Connection_getCatalog(FilterChain chain, DmdbConnection connection) throws SQLException {
        return chain.Connection_getCatalog(connection);
    }

    @Override
    public Properties Connection_getClientInfo(FilterChain chain, DmdbConnection connection) throws SQLException {
        return chain.Connection_getClientInfo(connection);
    }

    @Override
    public String Connection_getClientInfo(FilterChain chain, DmdbConnection connection, String name) throws SQLException {
        return chain.Connection_getClientInfo(connection, name);
    }

    @Override
    public int Connection_getHoldability(FilterChain chain, DmdbConnection connection) throws SQLException {
        return chain.Connection_getHoldability(connection);
    }

    @Override
    public DatabaseMetaData Connection_getMetaData(FilterChain chain, DmdbConnection connection) throws SQLException {
        return chain.Connection_getMetaData(connection);
    }

    @Override
    public int Connection_getNetworkTimeout(FilterChain chain, DmdbConnection connection) throws SQLException {
        return chain.Connection_getNetworkTimeout(connection);
    }

    @Override
    public String Connection_getSchema(FilterChain chain, DmdbConnection connection) throws SQLException {
        return chain.Connection_getSchema(connection);
    }

    @Override
    public int Connection_getTransactionIsolation(FilterChain chain, DmdbConnection connection) throws SQLException {
        return chain.Connection_getTransactionIsolation(connection);
    }

    @Override
    public Map<String, Class<?>> Connection_getTypeMap(FilterChain chain, DmdbConnection connection) throws SQLException {
        return chain.Connection_getTypeMap(connection);
    }

    @Override
    public SQLWarning Connection_getWarnings(FilterChain chain, DmdbConnection connection) throws SQLException {
        return chain.Connection_getWarnings(connection);
    }

    @Override
    public boolean Connection_isClosed(FilterChain chain, DmdbConnection connection) throws SQLException {
        return chain.Connection_isClosed(connection);
    }

    @Override
    public boolean Connection_isReadOnly(FilterChain chain, DmdbConnection connection) throws SQLException {
        return chain.Connection_isReadOnly(connection);
    }

    @Override
    public boolean Connection_isValid(FilterChain chain, DmdbConnection connection, int timeout) throws SQLException {
        return chain.Connection_isValid(connection, timeout);
    }

    @Override
    public String Connection_nativeSQL(FilterChain chain, DmdbConnection connection, String sql) throws SQLException {
        return chain.Connection_nativeSQL(connection, sql);
    }

    @Override
    public void Connection_releaseSavepoint(FilterChain chain, DmdbConnection connection, Savepoint savepoint) throws SQLException {
        chain.Connection_releaseSavepoint(connection, savepoint);
    }

    @Override
    public void Connection_setAutoCommit(FilterChain chain, DmdbConnection connection, boolean autoCommit) throws SQLException {
        chain.Connection_setAutoCommit(connection, autoCommit);
    }

    @Override
    public void Connection_setCatalog(FilterChain chain, DmdbConnection connection, String catalog) throws SQLException {
        chain.Connection_setCatalog(connection, catalog);
    }

    @Override
    public void Connection_setClientInfo(FilterChain chain, DmdbConnection connection, Properties properties) throws SQLClientInfoException {
        chain.Connection_setClientInfo(connection, properties);
    }

    @Override
    public void Connection_setClientInfo(FilterChain chain, DmdbConnection connection, String name, String value) throws SQLClientInfoException {
        chain.Connection_setClientInfo(connection, name, value);
    }

    @Override
    public void Connection_setHoldability(FilterChain chain, DmdbConnection connection, int holdability) throws SQLException {
        chain.Connection_setHoldability(connection, holdability);
    }

    @Override
    public void Connection_setNetworkTimeout(FilterChain chain, DmdbConnection connection, Executor executor, int milliseconds) throws SQLException {
        chain.Connection_setNetworkTimeout(connection, executor, milliseconds);
    }

    @Override
    public void Connection_setReadOnly(FilterChain chain, DmdbConnection connection, boolean readOnly) throws SQLException {
        chain.Connection_setReadOnly(connection, readOnly);
    }

    @Override
    public Savepoint Connection_setSavepoint(FilterChain chain, DmdbConnection connection) throws SQLException {
        return chain.Connection_setSavepoint(connection);
    }

    @Override
    public Savepoint Connection_setSavepoint(FilterChain chain, DmdbConnection connection, String name) throws SQLException {
        return chain.Connection_setSavepoint(connection, name);
    }

    @Override
    public void Connection_setSchema(FilterChain chain, DmdbConnection connection, String schema) throws SQLException {
        chain.Connection_setSchema(connection, schema);
    }

    @Override
    public void Connection_setTransactionIsolation(FilterChain chain, DmdbConnection connection, int level) throws SQLException {
        chain.Connection_setTransactionIsolation(connection, level);
    }

    @Override
    public void Connection_setTypeMap(FilterChain chain, DmdbConnection connection, Map<String, Class<?>> map) throws SQLException {
        chain.Connection_setTypeMap(connection, map);
    }

    @Override
    public void Statement_addBatch(FilterChain chain, DmdbStatement statement, String sql) throws SQLException {
        chain.Statement_addBatch(statement, sql);
    }

    @Override
    public void Statement_cancel(FilterChain chain, DmdbStatement statement) throws SQLException {
        chain.Statement_cancel(statement);
    }

    @Override
    public void Statement_clearBatch(FilterChain chain, DmdbStatement statement) throws SQLException {
        chain.Statement_clearBatch(statement);
    }

    @Override
    public void Statement_clearWarnings(FilterChain chain, DmdbStatement statement) throws SQLException {
        chain.Statement_clearWarnings(statement);
    }

    @Override
    public void Statement_closeOnCompletion(FilterChain chain, DmdbStatement statement) throws SQLException {
        chain.Statement_closeOnCompletion(statement);
    }

    @Override
    public Connection Statement_getConnection(FilterChain chain, DmdbStatement statement) throws SQLException {
        return chain.Statement_getConnection(statement);
    }

    @Override
    public int Statement_getFetchDirection(FilterChain chain, DmdbStatement statement) throws SQLException {
        return chain.Statement_getFetchDirection(statement);
    }

    @Override
    public int Statement_getFetchSize(FilterChain chain, DmdbStatement statement) throws SQLException {
        return chain.Statement_getFetchSize(statement);
    }

    @Override
    public ResultSet Statement_getGeneratedKeys(FilterChain chain, DmdbStatement statement) throws SQLException {
        return chain.Statement_getGeneratedKeys(statement);
    }

    @Override
    public int Statement_getMaxFieldSize(FilterChain chain, DmdbStatement statement) throws SQLException {
        return chain.Statement_getMaxFieldSize(statement);
    }

    @Override
    public int Statement_getMaxRows(FilterChain chain, DmdbStatement statement) throws SQLException {
        return chain.Statement_getMaxRows(statement);
    }

    @Override
    public boolean Statement_getMoreResults(FilterChain chain, DmdbStatement statement) throws SQLException {
        return chain.Statement_getMoreResults(statement);
    }

    @Override
    public boolean Statement_getMoreResults(FilterChain chain, DmdbStatement statement, int current) throws SQLException {
        return chain.Statement_getMoreResults(statement, current);
    }

    @Override
    public int Statement_getQueryTimeout(FilterChain chain, DmdbStatement statement) throws SQLException {
        return chain.Statement_getQueryTimeout(statement);
    }

    @Override
    public ResultSet Statement_getResultSet(FilterChain chain, DmdbStatement statement) throws SQLException {
        return chain.Statement_getResultSet(statement);
    }

    @Override
    public int Statement_getResultSetConcurrency(FilterChain chain, DmdbStatement statement) throws SQLException {
        return chain.Statement_getResultSetConcurrency(statement);
    }

    @Override
    public int Statement_getResultSetHoldability(FilterChain chain, DmdbStatement statement) throws SQLException {
        return chain.Statement_getResultSetHoldability(statement);
    }

    @Override
    public int Statement_getResultSetType(FilterChain chain, DmdbStatement statement) throws SQLException {
        return chain.Statement_getResultSetType(statement);
    }

    @Override
    public int Statement_getUpdateCount(FilterChain chain, DmdbStatement statement) throws SQLException {
        return chain.Statement_getUpdateCount(statement);
    }

    @Override
    public SQLWarning Statement_getWarnings(FilterChain chain, DmdbStatement statement) throws SQLException {
        return chain.Statement_getWarnings(statement);
    }

    @Override
    public boolean Statement_isCloseOnCompletion(FilterChain chain, DmdbStatement statement) throws SQLException {
        return chain.Statement_isCloseOnCompletion(statement);
    }

    @Override
    public boolean Statement_isClosed(FilterChain chain, DmdbStatement statement) throws SQLException {
        return chain.Statement_isClosed(statement);
    }

    @Override
    public boolean Statement_isPoolable(FilterChain chain, DmdbStatement statement) throws SQLException {
        return chain.Statement_isPoolable(statement);
    }

    @Override
    public void Statement_setCursorName(FilterChain chain, DmdbStatement statement, String name) throws SQLException {
        chain.Statement_setCursorName(statement, name);
    }

    @Override
    public void Statement_setEscapeProcessing(FilterChain chain, DmdbStatement statement, boolean enable) throws SQLException {
        chain.Statement_setEscapeProcessing(statement, enable);
    }

    @Override
    public void Statement_setFetchDirection(FilterChain chain, DmdbStatement statement, int direction) throws SQLException {
        chain.Statement_setFetchDirection(statement, direction);
    }

    @Override
    public void Statement_setFetchSize(FilterChain chain, DmdbStatement statement, int rows) throws SQLException {
        chain.Statement_setFetchSize(statement, rows);
    }

    @Override
    public void Statement_setMaxFieldSize(FilterChain chain, DmdbStatement statement, int max) throws SQLException {
        chain.Statement_setMaxFieldSize(statement, max);
    }

    @Override
    public void Statement_setMaxRows(FilterChain chain, DmdbStatement statement, int max) throws SQLException {
        chain.Statement_setMaxRows(statement, max);
    }

    @Override
    public void Statement_setPoolable(FilterChain chain, DmdbStatement statement, boolean poolable) throws SQLException {
        chain.Statement_setPoolable(statement, poolable);
    }

    @Override
    public void Statement_setQueryTimeout(FilterChain chain, DmdbStatement statement, int seconds) throws SQLException {
        chain.Statement_setQueryTimeout(statement, seconds);
    }

    @Override
    public void PreparedStatement_addBatch(FilterChain chain, DmdbPreparedStatement preparedStatement) throws SQLException {
        chain.PreparedStatement_addBatch(preparedStatement);
    }

    @Override
    public void PreparedStatement_clearParameters(FilterChain chain, DmdbPreparedStatement preparedStatement) throws SQLException {
        chain.PreparedStatement_clearParameters(preparedStatement);
    }

    @Override
    public ResultSetMetaData PreparedStatement_getMetaData(FilterChain chain, DmdbPreparedStatement preparedStatement) throws SQLException {
        return chain.PreparedStatement_getMetaData(preparedStatement);
    }

    @Override
    public ParameterMetaData PreparedStatement_getParameterMetaData(FilterChain chain, DmdbPreparedStatement preparedStatement) throws SQLException {
        return chain.PreparedStatement_getParameterMetaData(preparedStatement);
    }

    @Override
    public void PreparedStatement_setArray(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, Array x2) throws SQLException {
        chain.PreparedStatement_setArray(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setAsciiStream(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2) throws SQLException {
        chain.PreparedStatement_setAsciiStream(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setAsciiStream(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, int length) throws SQLException {
        chain.PreparedStatement_setAsciiStream(preparedStatement, parameterIndex, x2, length);
    }

    @Override
    public void PreparedStatement_setAsciiStream(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, long length) throws SQLException {
        chain.PreparedStatement_setAsciiStream(preparedStatement, parameterIndex, x2, length);
    }

    @Override
    public void PreparedStatement_setBigDecimal(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, BigDecimal x2) throws SQLException {
        chain.PreparedStatement_setBigDecimal(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setBinaryStream(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2) throws SQLException {
        chain.PreparedStatement_setBinaryStream(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setBinaryStream(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, int length) throws SQLException {
        chain.PreparedStatement_setBinaryStream(preparedStatement, parameterIndex, x2, length);
    }

    @Override
    public void PreparedStatement_setBinaryStream(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, long length) throws SQLException {
        chain.PreparedStatement_setBinaryStream(preparedStatement, parameterIndex, x2, length);
    }

    @Override
    public void PreparedStatement_setBlob(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, Blob x2) throws SQLException {
        chain.PreparedStatement_setBlob(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setBlob(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream inputStream) throws SQLException {
        chain.PreparedStatement_setBlob(preparedStatement, parameterIndex, inputStream);
    }

    @Override
    public void PreparedStatement_setBlob(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream inputStream, long length) throws SQLException {
        chain.PreparedStatement_setBlob(preparedStatement, parameterIndex, inputStream, length);
    }

    @Override
    public void PreparedStatement_setBoolean(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, boolean x2) throws SQLException {
        chain.PreparedStatement_setBoolean(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setByte(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, byte x2) throws SQLException {
        chain.PreparedStatement_setByte(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setBytes(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, byte[] x2) throws SQLException {
        chain.PreparedStatement_setBytes(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setCharacterStream(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader) throws SQLException {
        chain.PreparedStatement_setCharacterStream(preparedStatement, parameterIndex, reader);
    }

    @Override
    public void PreparedStatement_setCharacterStream(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader, int length) throws SQLException {
        chain.PreparedStatement_setCharacterStream(preparedStatement, parameterIndex, reader, length);
    }

    @Override
    public void PreparedStatement_setCharacterStream(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader, long length) throws SQLException {
        chain.PreparedStatement_setCharacterStream(preparedStatement, parameterIndex, reader, length);
    }

    @Override
    public void PreparedStatement_setClob(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, Clob x2) throws SQLException {
        chain.PreparedStatement_setClob(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setClob(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader) throws SQLException {
        chain.PreparedStatement_setClob(preparedStatement, parameterIndex, reader);
    }

    @Override
    public void PreparedStatement_setClob(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader, long length) throws SQLException {
        chain.PreparedStatement_setClob(preparedStatement, parameterIndex, reader, length);
    }

    @Override
    public void PreparedStatement_setDate(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, Date x2) throws SQLException {
        chain.PreparedStatement_setDate(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setDate(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, Date x2, Calendar cal) throws SQLException {
        chain.PreparedStatement_setDate(preparedStatement, parameterIndex, x2, cal);
    }

    @Override
    public void PreparedStatement_setDouble(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, double x2) throws SQLException {
        chain.PreparedStatement_setDouble(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setFloat(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, float x2) throws SQLException {
        chain.PreparedStatement_setFloat(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setInt(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, int x2) throws SQLException {
        chain.PreparedStatement_setInt(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setLong(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, long x2) throws SQLException {
        chain.PreparedStatement_setLong(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setNCharacterStream(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader value) throws SQLException {
        chain.PreparedStatement_setNCharacterStream(preparedStatement, parameterIndex, value);
    }

    @Override
    public void PreparedStatement_setNCharacterStream(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader value, long length) throws SQLException {
        chain.PreparedStatement_setNCharacterStream(preparedStatement, parameterIndex, value, length);
    }

    @Override
    public void PreparedStatement_setNClob(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, NClob value) throws SQLException {
        chain.PreparedStatement_setNClob(preparedStatement, parameterIndex, value);
    }

    @Override
    public void PreparedStatement_setNClob(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader) throws SQLException {
        chain.PreparedStatement_setNClob(preparedStatement, parameterIndex, reader);
    }

    @Override
    public void PreparedStatement_setNClob(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader, long length) throws SQLException {
        chain.PreparedStatement_setNClob(preparedStatement, parameterIndex, reader, length);
    }

    @Override
    public void PreparedStatement_setNString(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, String value) throws SQLException {
        chain.PreparedStatement_setNString(preparedStatement, parameterIndex, value);
    }

    @Override
    public void PreparedStatement_setNull(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, int sqlType) throws SQLException {
        chain.PreparedStatement_setNull(preparedStatement, parameterIndex, sqlType);
    }

    @Override
    public void PreparedStatement_setNull(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, int sqlType, String typeName) throws SQLException {
        chain.PreparedStatement_setNull(preparedStatement, parameterIndex, sqlType, typeName);
    }

    @Override
    public void PreparedStatement_setObject(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2) throws SQLException {
        chain.PreparedStatement_setObject(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setObject(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2, int targetSqlType) throws SQLException {
        chain.PreparedStatement_setObject(preparedStatement, parameterIndex, x2, targetSqlType);
    }

    @Override
    public void PreparedStatement_setObject(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2, int targetSqlType, int scaleOrLength) throws SQLException {
        chain.PreparedStatement_setObject(preparedStatement, parameterIndex, x2, targetSqlType, scaleOrLength);
    }

    @Override
    public void PreparedStatement_setRef(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, Ref x2) throws SQLException {
        chain.PreparedStatement_setRef(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setRowId(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, RowId x2) throws SQLException {
        chain.PreparedStatement_setRowId(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setSQLXML(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, SQLXML xmlObject) throws SQLException {
        chain.PreparedStatement_setSQLXML(preparedStatement, parameterIndex, xmlObject);
    }

    @Override
    public void PreparedStatement_setShort(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, short x2) throws SQLException {
        chain.PreparedStatement_setShort(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setString(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, String x2) throws SQLException {
        chain.PreparedStatement_setString(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setTime(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, Time x2) throws SQLException {
        chain.PreparedStatement_setTime(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setTime(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, Time x2, Calendar cal) throws SQLException {
        chain.PreparedStatement_setTime(preparedStatement, parameterIndex, x2, cal);
    }

    @Override
    public void PreparedStatement_setTimestamp(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, Timestamp x2) throws SQLException {
        chain.PreparedStatement_setTimestamp(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setTimestamp(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, Timestamp x2, Calendar cal) throws SQLException {
        chain.PreparedStatement_setTimestamp(preparedStatement, parameterIndex, x2, cal);
    }

    @Override
    public void PreparedStatement_setURL(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, URL x2) throws SQLException {
        chain.PreparedStatement_setURL(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setUnicodeStream(FilterChain chain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, int length) throws SQLException {
        chain.PreparedStatement_setUnicodeStream(preparedStatement, parameterIndex, x2, length);
    }

    @Override
    public Array CallableStatement_getArray(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return chain.CallableStatement_getArray(callableStatement, parameterName);
    }

    @Override
    public Array CallableStatement_getArray(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return chain.CallableStatement_getArray(callableStatement, parameterIndex);
    }

    @Override
    public BigDecimal CallableStatement_getBigDecimal(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return chain.CallableStatement_getBigDecimal(callableStatement, parameterName);
    }

    @Override
    public BigDecimal CallableStatement_getBigDecimal(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return chain.CallableStatement_getBigDecimal(callableStatement, parameterIndex);
    }

    @Override
    public BigDecimal CallableStatement_getBigDecimal(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex, int scale) throws SQLException {
        return chain.CallableStatement_getBigDecimal(callableStatement, parameterIndex, scale);
    }

    @Override
    public Blob CallableStatement_getBlob(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return chain.CallableStatement_getBlob(callableStatement, parameterName);
    }

    @Override
    public Blob CallableStatement_getBlob(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return chain.CallableStatement_getBlob(callableStatement, parameterIndex);
    }

    @Override
    public boolean CallableStatement_getBoolean(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return chain.CallableStatement_getBoolean(callableStatement, parameterName);
    }

    @Override
    public boolean CallableStatement_getBoolean(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return chain.CallableStatement_getBoolean(callableStatement, parameterIndex);
    }

    @Override
    public byte CallableStatement_getByte(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return chain.CallableStatement_getByte(callableStatement, parameterName);
    }

    @Override
    public byte CallableStatement_getByte(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return chain.CallableStatement_getByte(callableStatement, parameterIndex);
    }

    @Override
    public byte[] CallableStatement_getBytes(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return chain.CallableStatement_getBytes(callableStatement, parameterName);
    }

    @Override
    public byte[] CallableStatement_getBytes(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return chain.CallableStatement_getBytes(callableStatement, parameterIndex);
    }

    @Override
    public Reader CallableStatement_getCharacterStream(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return chain.CallableStatement_getCharacterStream(callableStatement, parameterName);
    }

    @Override
    public Reader CallableStatement_getCharacterStream(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return chain.CallableStatement_getCharacterStream(callableStatement, parameterIndex);
    }

    @Override
    public Clob CallableStatement_getClob(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return chain.CallableStatement_getClob(callableStatement, parameterName);
    }

    @Override
    public Clob CallableStatement_getClob(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return chain.CallableStatement_getClob(callableStatement, parameterIndex);
    }

    @Override
    public Date CallableStatement_getDate(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return chain.CallableStatement_getDate(callableStatement, parameterName);
    }

    @Override
    public Date CallableStatement_getDate(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, Calendar cal) throws SQLException {
        return chain.CallableStatement_getDate(callableStatement, parameterName, cal);
    }

    @Override
    public Date CallableStatement_getDate(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return chain.CallableStatement_getDate(callableStatement, parameterIndex);
    }

    @Override
    public Date CallableStatement_getDate(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex, Calendar cal) throws SQLException {
        return chain.CallableStatement_getDate(callableStatement, parameterIndex, cal);
    }

    @Override
    public double CallableStatement_getDouble(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return chain.CallableStatement_getDouble(callableStatement, parameterName);
    }

    @Override
    public double CallableStatement_getDouble(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return chain.CallableStatement_getDouble(callableStatement, parameterIndex);
    }

    @Override
    public float CallableStatement_getFloat(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return chain.CallableStatement_getFloat(callableStatement, parameterName);
    }

    @Override
    public float CallableStatement_getFloat(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return chain.CallableStatement_getFloat(callableStatement, parameterIndex);
    }

    @Override
    public int CallableStatement_getInt(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return chain.CallableStatement_getInt(callableStatement, parameterName);
    }

    @Override
    public int CallableStatement_getInt(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return chain.CallableStatement_getInt(callableStatement, parameterIndex);
    }

    @Override
    public long CallableStatement_getLong(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return chain.CallableStatement_getLong(callableStatement, parameterName);
    }

    @Override
    public long CallableStatement_getLong(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return chain.CallableStatement_getLong(callableStatement, parameterIndex);
    }

    @Override
    public Reader CallableStatement_getNCharacterStream(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return chain.CallableStatement_getNCharacterStream(callableStatement, parameterName);
    }

    @Override
    public Reader CallableStatement_getNCharacterStream(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return chain.CallableStatement_getNCharacterStream(callableStatement, parameterIndex);
    }

    @Override
    public NClob CallableStatement_getNClob(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return chain.CallableStatement_getNClob(callableStatement, parameterName);
    }

    @Override
    public NClob CallableStatement_getNClob(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return chain.CallableStatement_getNClob(callableStatement, parameterIndex);
    }

    @Override
    public String CallableStatement_getNString(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return chain.CallableStatement_getNString(callableStatement, parameterName);
    }

    @Override
    public String CallableStatement_getNString(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return chain.CallableStatement_getNString(callableStatement, parameterIndex);
    }

    @Override
    public Object CallableStatement_getObject(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return chain.CallableStatement_getObject(callableStatement, parameterName);
    }

    @Override
    public <T> T CallableStatement_getObject(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, Class<T> type) throws SQLException {
        return chain.CallableStatement_getObject(callableStatement, parameterName, type);
    }

    @Override
    public Object CallableStatement_getObject(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, Map<String, Class<?>> map) throws SQLException {
        return chain.CallableStatement_getObject(callableStatement, parameterName, map);
    }

    @Override
    public Object CallableStatement_getObject(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return chain.CallableStatement_getObject(callableStatement, parameterIndex);
    }

    @Override
    public <T> T CallableStatement_getObject(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex, Class<T> type) throws SQLException {
        return chain.CallableStatement_getObject(callableStatement, parameterIndex, type);
    }

    @Override
    public Object CallableStatement_getObject(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        return chain.CallableStatement_getObject(callableStatement, parameterIndex, map);
    }

    @Override
    public Ref CallableStatement_getRef(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return chain.CallableStatement_getRef(callableStatement, parameterName);
    }

    @Override
    public Ref CallableStatement_getRef(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return chain.CallableStatement_getRef(callableStatement, parameterIndex);
    }

    @Override
    public RowId CallableStatement_getRowId(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return chain.CallableStatement_getRowId(callableStatement, parameterName);
    }

    @Override
    public RowId CallableStatement_getRowId(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return chain.CallableStatement_getRowId(callableStatement, parameterIndex);
    }

    @Override
    public SQLXML CallableStatement_getSQLXML(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return chain.CallableStatement_getSQLXML(callableStatement, parameterName);
    }

    @Override
    public SQLXML CallableStatement_getSQLXML(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return chain.CallableStatement_getSQLXML(callableStatement, parameterIndex);
    }

    @Override
    public short CallableStatement_getShort(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return chain.CallableStatement_getShort(callableStatement, parameterName);
    }

    @Override
    public short CallableStatement_getShort(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return chain.CallableStatement_getShort(callableStatement, parameterIndex);
    }

    @Override
    public String CallableStatement_getString(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return chain.CallableStatement_getString(callableStatement, parameterName);
    }

    @Override
    public String CallableStatement_getString(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return chain.CallableStatement_getString(callableStatement, parameterIndex);
    }

    @Override
    public Time CallableStatement_getTime(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return chain.CallableStatement_getTime(callableStatement, parameterName);
    }

    @Override
    public Time CallableStatement_getTime(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, Calendar cal) throws SQLException {
        return chain.CallableStatement_getTime(callableStatement, parameterName, cal);
    }

    @Override
    public Time CallableStatement_getTime(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return chain.CallableStatement_getTime(callableStatement, parameterIndex);
    }

    @Override
    public Time CallableStatement_getTime(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex, Calendar cal) throws SQLException {
        return chain.CallableStatement_getTime(callableStatement, parameterIndex, cal);
    }

    @Override
    public Timestamp CallableStatement_getTimestamp(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return chain.CallableStatement_getTimestamp(callableStatement, parameterName);
    }

    @Override
    public Timestamp CallableStatement_getTimestamp(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, Calendar cal) throws SQLException {
        return chain.CallableStatement_getTimestamp(callableStatement, parameterName, cal);
    }

    @Override
    public Timestamp CallableStatement_getTimestamp(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return chain.CallableStatement_getTimestamp(callableStatement, parameterIndex);
    }

    @Override
    public Timestamp CallableStatement_getTimestamp(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex, Calendar cal) throws SQLException {
        return chain.CallableStatement_getTimestamp(callableStatement, parameterIndex, cal);
    }

    @Override
    public URL CallableStatement_getURL(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return chain.CallableStatement_getURL(callableStatement, parameterName);
    }

    @Override
    public URL CallableStatement_getURL(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return chain.CallableStatement_getURL(callableStatement, parameterIndex);
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, int sqlType) throws SQLException {
        chain.CallableStatement_registerOutParameter(callableStatement, parameterName, sqlType);
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, int sqlType, String typeName) throws SQLException {
        chain.CallableStatement_registerOutParameter(callableStatement, parameterName, sqlType, typeName);
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, int sqlType, int scale) throws SQLException {
        chain.CallableStatement_registerOutParameter(callableStatement, parameterName, sqlType, scale);
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex, int sqlType) throws SQLException {
        chain.CallableStatement_registerOutParameter(callableStatement, parameterIndex, sqlType);
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex, int sqlType, String typeName) throws SQLException {
        chain.CallableStatement_registerOutParameter(callableStatement, parameterIndex, sqlType, typeName);
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain chain, DmdbCallableStatement callableStatement, int parameterIndex, int sqlType, int scale) throws SQLException {
        chain.CallableStatement_registerOutParameter(callableStatement, parameterIndex, sqlType, scale);
    }

    @Override
    public void CallableStatement_setAsciiStream(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, InputStream x2) throws SQLException {
        chain.CallableStatement_setAsciiStream(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setAsciiStream(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, InputStream x2, int length) throws SQLException {
        chain.CallableStatement_setAsciiStream(callableStatement, parameterName, x2, length);
    }

    @Override
    public void CallableStatement_setAsciiStream(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, InputStream x2, long length) throws SQLException {
        chain.CallableStatement_setAsciiStream(callableStatement, parameterName, x2, length);
    }

    @Override
    public void CallableStatement_setBigDecimal(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, BigDecimal x2) throws SQLException {
        chain.CallableStatement_setBigDecimal(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setBinaryStream(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, InputStream x2) throws SQLException {
        chain.CallableStatement_setBinaryStream(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setBinaryStream(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, InputStream x2, int length) throws SQLException {
        chain.CallableStatement_setBinaryStream(callableStatement, parameterName, x2, length);
    }

    @Override
    public void CallableStatement_setBinaryStream(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, InputStream x2, long length) throws SQLException {
        chain.CallableStatement_setBinaryStream(callableStatement, parameterName, x2, length);
    }

    @Override
    public void CallableStatement_setBlob(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, Blob x2) throws SQLException {
        chain.CallableStatement_setBlob(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setBlob(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, InputStream inputStream) throws SQLException {
        chain.CallableStatement_setBlob(callableStatement, parameterName, inputStream);
    }

    @Override
    public void CallableStatement_setBlob(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, InputStream inputStream, long length) throws SQLException {
        chain.CallableStatement_setBlob(callableStatement, parameterName, inputStream, length);
    }

    @Override
    public void CallableStatement_setBoolean(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, boolean x2) throws SQLException {
        chain.CallableStatement_setBoolean(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setByte(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, byte x2) throws SQLException {
        chain.CallableStatement_setByte(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setBytes(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, byte[] x2) throws SQLException {
        chain.CallableStatement_setBytes(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setCharacterStream(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, Reader reader) throws SQLException {
        chain.CallableStatement_setCharacterStream(callableStatement, parameterName, reader);
    }

    @Override
    public void CallableStatement_setCharacterStream(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, Reader reader, int length) throws SQLException {
        chain.CallableStatement_setCharacterStream(callableStatement, parameterName, reader, length);
    }

    @Override
    public void CallableStatement_setCharacterStream(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, Reader reader, long length) throws SQLException {
        chain.CallableStatement_setCharacterStream(callableStatement, parameterName, reader, length);
    }

    @Override
    public void CallableStatement_setClob(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, Clob x2) throws SQLException {
        chain.CallableStatement_setClob(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setClob(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, Reader reader) throws SQLException {
        chain.CallableStatement_setClob(callableStatement, parameterName, reader);
    }

    @Override
    public void CallableStatement_setClob(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, Reader reader, long length) throws SQLException {
        chain.CallableStatement_setClob(callableStatement, parameterName, reader, length);
    }

    @Override
    public void CallableStatement_setDate(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, Date x2) throws SQLException {
        chain.CallableStatement_setDate(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setDate(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, Date x2, Calendar cal) throws SQLException {
        chain.CallableStatement_setDate(callableStatement, parameterName, x2, cal);
    }

    @Override
    public void CallableStatement_setDouble(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, double x2) throws SQLException {
        chain.CallableStatement_setDouble(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setFloat(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, float x2) throws SQLException {
        chain.CallableStatement_setFloat(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setInt(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, int x2) throws SQLException {
        chain.CallableStatement_setInt(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setLong(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, long x2) throws SQLException {
        chain.CallableStatement_setLong(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setNCharacterStream(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, Reader value) throws SQLException {
        chain.CallableStatement_setNCharacterStream(callableStatement, parameterName, value);
    }

    @Override
    public void CallableStatement_setNCharacterStream(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, Reader value, long length) throws SQLException {
        chain.CallableStatement_setNCharacterStream(callableStatement, parameterName, value, length);
    }

    @Override
    public void CallableStatement_setNClob(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, NClob value) throws SQLException {
        chain.CallableStatement_setNClob(callableStatement, parameterName, value);
    }

    @Override
    public void CallableStatement_setNClob(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, Reader reader) throws SQLException {
        chain.CallableStatement_setNClob(callableStatement, parameterName, reader);
    }

    @Override
    public void CallableStatement_setNClob(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, Reader reader, long length) throws SQLException {
        chain.CallableStatement_setNClob(callableStatement, parameterName, reader, length);
    }

    @Override
    public void CallableStatement_setNString(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, String value) throws SQLException {
        chain.CallableStatement_setNString(callableStatement, parameterName, value);
    }

    @Override
    public void CallableStatement_setNull(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, int sqlType) throws SQLException {
        chain.CallableStatement_setNull(callableStatement, parameterName, sqlType);
    }

    @Override
    public void CallableStatement_setNull(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, int sqlType, String typeName) throws SQLException {
        chain.CallableStatement_setNull(callableStatement, parameterName, sqlType, typeName);
    }

    @Override
    public void CallableStatement_setObject(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, Object x2) throws SQLException {
        chain.CallableStatement_setObject(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setObject(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, Object x2, int targetSqlType) throws SQLException {
        chain.CallableStatement_setObject(callableStatement, parameterName, x2, targetSqlType);
    }

    @Override
    public void CallableStatement_setObject(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, Object x2, int targetSqlType, int scale) throws SQLException {
        chain.CallableStatement_setObject(callableStatement, parameterName, x2, targetSqlType, scale);
    }

    @Override
    public void CallableStatement_setRowId(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, RowId x2) throws SQLException {
        chain.CallableStatement_setRowId(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setSQLXML(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, SQLXML xmlObject) throws SQLException {
        chain.CallableStatement_setSQLXML(callableStatement, parameterName, xmlObject);
    }

    @Override
    public void CallableStatement_setShort(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, short x2) throws SQLException {
        chain.CallableStatement_setShort(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setString(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, String x2) throws SQLException {
        chain.CallableStatement_setString(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setTime(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, Time x2) throws SQLException {
        chain.CallableStatement_setTime(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setTime(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, Time x2, Calendar cal) throws SQLException {
        chain.CallableStatement_setTime(callableStatement, parameterName, x2, cal);
    }

    @Override
    public void CallableStatement_setTimestamp(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, Timestamp x2) throws SQLException {
        chain.CallableStatement_setTimestamp(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setTimestamp(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, Timestamp x2, Calendar cal) throws SQLException {
        chain.CallableStatement_setTimestamp(callableStatement, parameterName, x2, cal);
    }

    @Override
    public void CallableStatement_setURL(FilterChain chain, DmdbCallableStatement callableStatement, String parameterName, URL val) throws SQLException {
        chain.CallableStatement_setURL(callableStatement, parameterName, val);
    }

    @Override
    public boolean CallableStatement_wasNull(FilterChain chain, DmdbCallableStatement callableStatement) throws SQLException {
        return chain.CallableStatement_wasNull(callableStatement);
    }

    @Override
    public boolean ResultSet_absolute(FilterChain chain, DmdbResultSet resultSet, int row) throws SQLException {
        return chain.ResultSet_absolute(resultSet, row);
    }

    @Override
    public void ResultSet_afterLast(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        chain.ResultSet_afterLast(resultSet);
    }

    @Override
    public void ResultSet_beforeFirst(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        chain.ResultSet_beforeFirst(resultSet);
    }

    @Override
    public void ResultSet_cancelRowUpdates(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        chain.ResultSet_cancelRowUpdates(resultSet);
    }

    @Override
    public void ResultSet_clearWarnings(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        chain.ResultSet_clearWarnings(resultSet);
    }

    @Override
    public void ResultSet_deleteRow(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        chain.ResultSet_deleteRow(resultSet);
    }

    @Override
    public int ResultSet_findColumn(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return chain.ResultSet_findColumn(resultSet, columnLabel);
    }

    @Override
    public boolean ResultSet_first(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        return chain.ResultSet_first(resultSet);
    }

    @Override
    public Array ResultSet_getArray(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return chain.ResultSet_getArray(resultSet, columnLabel);
    }

    @Override
    public Array ResultSet_getArray(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return chain.ResultSet_getArray(resultSet, columnIndex);
    }

    @Override
    public InputStream ResultSet_getAsciiStream(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return chain.ResultSet_getAsciiStream(resultSet, columnLabel);
    }

    @Override
    public InputStream ResultSet_getAsciiStream(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return chain.ResultSet_getAsciiStream(resultSet, columnIndex);
    }

    @Override
    public BigDecimal ResultSet_getBigDecimal(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return chain.ResultSet_getBigDecimal(resultSet, columnLabel);
    }

    @Override
    public BigDecimal ResultSet_getBigDecimal(FilterChain chain, DmdbResultSet resultSet, String columnLabel, int scale) throws SQLException {
        return chain.ResultSet_getBigDecimal(resultSet, columnLabel, scale);
    }

    @Override
    public BigDecimal ResultSet_getBigDecimal(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return chain.ResultSet_getBigDecimal(resultSet, columnIndex);
    }

    @Override
    public BigDecimal ResultSet_getBigDecimal(FilterChain chain, DmdbResultSet resultSet, int columnIndex, int scale) throws SQLException {
        return chain.ResultSet_getBigDecimal(resultSet, columnIndex, scale);
    }

    @Override
    public InputStream ResultSet_getBinaryStream(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return chain.ResultSet_getBinaryStream(resultSet, columnLabel);
    }

    @Override
    public InputStream ResultSet_getBinaryStream(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return chain.ResultSet_getBinaryStream(resultSet, columnIndex);
    }

    @Override
    public Blob ResultSet_getBlob(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return chain.ResultSet_getBlob(resultSet, columnLabel);
    }

    @Override
    public Blob ResultSet_getBlob(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return chain.ResultSet_getBlob(resultSet, columnIndex);
    }

    @Override
    public boolean ResultSet_getBoolean(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return chain.ResultSet_getBoolean(resultSet, columnLabel);
    }

    @Override
    public boolean ResultSet_getBoolean(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return chain.ResultSet_getBoolean(resultSet, columnIndex);
    }

    @Override
    public byte ResultSet_getByte(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return chain.ResultSet_getByte(resultSet, columnLabel);
    }

    @Override
    public byte ResultSet_getByte(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return chain.ResultSet_getByte(resultSet, columnIndex);
    }

    @Override
    public byte[] ResultSet_getBytes(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return chain.ResultSet_getBytes(resultSet, columnLabel);
    }

    @Override
    public byte[] ResultSet_getBytes(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return chain.ResultSet_getBytes(resultSet, columnIndex);
    }

    @Override
    public Reader ResultSet_getCharacterStream(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return chain.ResultSet_getCharacterStream(resultSet, columnLabel);
    }

    @Override
    public Reader ResultSet_getCharacterStream(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return chain.ResultSet_getCharacterStream(resultSet, columnIndex);
    }

    @Override
    public Clob ResultSet_getClob(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return chain.ResultSet_getClob(resultSet, columnLabel);
    }

    @Override
    public Clob ResultSet_getClob(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return chain.ResultSet_getClob(resultSet, columnIndex);
    }

    @Override
    public int ResultSet_getConcurrency(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        return chain.ResultSet_getConcurrency(resultSet);
    }

    @Override
    public String ResultSet_getCursorName(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        return chain.ResultSet_getCursorName(resultSet);
    }

    @Override
    public Date ResultSet_getDate(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return chain.ResultSet_getDate(resultSet, columnLabel);
    }

    @Override
    public Date ResultSet_getDate(FilterChain chain, DmdbResultSet resultSet, String columnLabel, Calendar cal) throws SQLException {
        return chain.ResultSet_getDate(resultSet, columnLabel, cal);
    }

    @Override
    public Date ResultSet_getDate(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return chain.ResultSet_getDate(resultSet, columnIndex);
    }

    @Override
    public Date ResultSet_getDate(FilterChain chain, DmdbResultSet resultSet, int columnIndex, Calendar cal) throws SQLException {
        return chain.ResultSet_getDate(resultSet, columnIndex, cal);
    }

    @Override
    public double ResultSet_getDouble(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return chain.ResultSet_getDouble(resultSet, columnLabel);
    }

    @Override
    public double ResultSet_getDouble(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return chain.ResultSet_getDouble(resultSet, columnIndex);
    }

    @Override
    public int ResultSet_getFetchDirection(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        return chain.ResultSet_getFetchDirection(resultSet);
    }

    @Override
    public int ResultSet_getFetchSize(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        return chain.ResultSet_getFetchSize(resultSet);
    }

    @Override
    public float ResultSet_getFloat(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return chain.ResultSet_getFloat(resultSet, columnLabel);
    }

    @Override
    public float ResultSet_getFloat(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return chain.ResultSet_getFloat(resultSet, columnIndex);
    }

    @Override
    public int ResultSet_getHoldability(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        return chain.ResultSet_getHoldability(resultSet);
    }

    @Override
    public int ResultSet_getInt(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return chain.ResultSet_getInt(resultSet, columnLabel);
    }

    @Override
    public int ResultSet_getInt(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return chain.ResultSet_getInt(resultSet, columnIndex);
    }

    @Override
    public long ResultSet_getLong(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return chain.ResultSet_getLong(resultSet, columnLabel);
    }

    @Override
    public long ResultSet_getLong(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return chain.ResultSet_getLong(resultSet, columnIndex);
    }

    @Override
    public ResultSetMetaData ResultSet_getMetaData(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        return chain.ResultSet_getMetaData(resultSet);
    }

    @Override
    public Reader ResultSet_getNCharacterStream(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return chain.ResultSet_getNCharacterStream(resultSet, columnLabel);
    }

    @Override
    public Reader ResultSet_getNCharacterStream(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return chain.ResultSet_getNCharacterStream(resultSet, columnIndex);
    }

    @Override
    public NClob ResultSet_getNClob(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return chain.ResultSet_getNClob(resultSet, columnLabel);
    }

    @Override
    public NClob ResultSet_getNClob(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return chain.ResultSet_getNClob(resultSet, columnIndex);
    }

    @Override
    public String ResultSet_getNString(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return chain.ResultSet_getNString(resultSet, columnLabel);
    }

    @Override
    public String ResultSet_getNString(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return chain.ResultSet_getNString(resultSet, columnIndex);
    }

    @Override
    public Object ResultSet_getObject(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return chain.ResultSet_getObject(resultSet, columnLabel);
    }

    @Override
    public <T> T ResultSet_getObject(FilterChain chain, DmdbResultSet resultSet, String columnLabel, Class<T> type) throws SQLException {
        return chain.ResultSet_getObject(resultSet, columnLabel, type);
    }

    @Override
    public Object ResultSet_getObject(FilterChain chain, DmdbResultSet resultSet, String columnLabel, Map<String, Class<?>> map) throws SQLException {
        return chain.ResultSet_getObject(resultSet, columnLabel, map);
    }

    @Override
    public Object ResultSet_getObject(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return chain.ResultSet_getObject(resultSet, columnIndex);
    }

    @Override
    public <T> T ResultSet_getObject(FilterChain chain, DmdbResultSet resultSet, int columnIndex, Class<T> type) throws SQLException {
        return chain.ResultSet_getObject(resultSet, columnIndex, type);
    }

    @Override
    public Object ResultSet_getObject(FilterChain chain, DmdbResultSet resultSet, int columnIndex, Map<String, Class<?>> map) throws SQLException {
        return chain.ResultSet_getObject(resultSet, columnIndex, map);
    }

    @Override
    public Ref ResultSet_getRef(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return chain.ResultSet_getRef(resultSet, columnLabel);
    }

    @Override
    public Ref ResultSet_getRef(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return chain.ResultSet_getRef(resultSet, columnIndex);
    }

    @Override
    public int ResultSet_getRow(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        return chain.ResultSet_getRow(resultSet);
    }

    @Override
    public RowId ResultSet_getRowId(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return chain.ResultSet_getRowId(resultSet, columnLabel);
    }

    @Override
    public RowId ResultSet_getRowId(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return chain.ResultSet_getRowId(resultSet, columnIndex);
    }

    @Override
    public SQLXML ResultSet_getSQLXML(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return chain.ResultSet_getSQLXML(resultSet, columnLabel);
    }

    @Override
    public SQLXML ResultSet_getSQLXML(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return chain.ResultSet_getSQLXML(resultSet, columnIndex);
    }

    @Override
    public short ResultSet_getShort(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return chain.ResultSet_getShort(resultSet, columnLabel);
    }

    @Override
    public short ResultSet_getShort(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return chain.ResultSet_getShort(resultSet, columnIndex);
    }

    @Override
    public Statement ResultSet_getStatement(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        return chain.ResultSet_getStatement(resultSet);
    }

    @Override
    public String ResultSet_getString(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return chain.ResultSet_getString(resultSet, columnLabel);
    }

    @Override
    public String ResultSet_getString(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return chain.ResultSet_getString(resultSet, columnIndex);
    }

    @Override
    public Time ResultSet_getTime(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return chain.ResultSet_getTime(resultSet, columnLabel);
    }

    @Override
    public Time ResultSet_getTime(FilterChain chain, DmdbResultSet resultSet, String columnLabel, Calendar cal) throws SQLException {
        return chain.ResultSet_getTime(resultSet, columnLabel, cal);
    }

    @Override
    public Time ResultSet_getTime(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return chain.ResultSet_getTime(resultSet, columnIndex);
    }

    @Override
    public Time ResultSet_getTime(FilterChain chain, DmdbResultSet resultSet, int columnIndex, Calendar cal) throws SQLException {
        return chain.ResultSet_getTime(resultSet, columnIndex, cal);
    }

    @Override
    public Timestamp ResultSet_getTimestamp(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return chain.ResultSet_getTimestamp(resultSet, columnLabel);
    }

    @Override
    public Timestamp ResultSet_getTimestamp(FilterChain chain, DmdbResultSet resultSet, String columnLabel, Calendar cal) throws SQLException {
        return chain.ResultSet_getTimestamp(resultSet, columnLabel, cal);
    }

    @Override
    public Timestamp ResultSet_getTimestamp(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return chain.ResultSet_getTimestamp(resultSet, columnIndex);
    }

    @Override
    public Timestamp ResultSet_getTimestamp(FilterChain chain, DmdbResultSet resultSet, int columnIndex, Calendar cal) throws SQLException {
        return chain.ResultSet_getTimestamp(resultSet, columnIndex, cal);
    }

    @Override
    public int ResultSet_getType(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        return chain.ResultSet_getType(resultSet);
    }

    @Override
    public URL ResultSet_getURL(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return chain.ResultSet_getURL(resultSet, columnLabel);
    }

    @Override
    public URL ResultSet_getURL(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return chain.ResultSet_getURL(resultSet, columnIndex);
    }

    @Override
    public InputStream ResultSet_getUnicodeStream(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return chain.ResultSet_getUnicodeStream(resultSet, columnLabel);
    }

    @Override
    public InputStream ResultSet_getUnicodeStream(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return chain.ResultSet_getUnicodeStream(resultSet, columnIndex);
    }

    @Override
    public SQLWarning ResultSet_getWarnings(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        return chain.ResultSet_getWarnings(resultSet);
    }

    @Override
    public void ResultSet_insertRow(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        chain.ResultSet_insertRow(resultSet);
    }

    @Override
    public boolean ResultSet_isAfterLast(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        return chain.ResultSet_isAfterLast(resultSet);
    }

    @Override
    public boolean ResultSet_isBeforeFirst(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        return chain.ResultSet_isBeforeFirst(resultSet);
    }

    @Override
    public boolean ResultSet_isClosed(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        return chain.ResultSet_isClosed(resultSet);
    }

    @Override
    public boolean ResultSet_isFirst(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        return chain.ResultSet_isFirst(resultSet);
    }

    @Override
    public boolean ResultSet_isLast(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        return chain.ResultSet_isLast(resultSet);
    }

    @Override
    public boolean ResultSet_last(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        return chain.ResultSet_last(resultSet);
    }

    @Override
    public void ResultSet_moveToCurrentRow(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        chain.ResultSet_moveToCurrentRow(resultSet);
    }

    @Override
    public void ResultSet_moveToInsertRow(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        chain.ResultSet_moveToInsertRow(resultSet);
    }

    @Override
    public boolean ResultSet_next(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        return chain.ResultSet_next(resultSet);
    }

    @Override
    public boolean ResultSet_previous(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        return chain.ResultSet_previous(resultSet);
    }

    @Override
    public void ResultSet_refreshRow(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        chain.ResultSet_refreshRow(resultSet);
    }

    @Override
    public boolean ResultSet_relative(FilterChain chain, DmdbResultSet resultSet, int rows) throws SQLException {
        return chain.ResultSet_relative(resultSet, rows);
    }

    @Override
    public boolean ResultSet_rowDeleted(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        return chain.ResultSet_rowDeleted(resultSet);
    }

    @Override
    public boolean ResultSet_rowInserted(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        return chain.ResultSet_rowInserted(resultSet);
    }

    @Override
    public boolean ResultSet_rowUpdated(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        return chain.ResultSet_rowUpdated(resultSet);
    }

    @Override
    public void ResultSet_setFetchDirection(FilterChain chain, DmdbResultSet resultSet, int direction) throws SQLException {
        chain.ResultSet_setFetchDirection(resultSet, direction);
    }

    @Override
    public void ResultSet_setFetchSize(FilterChain chain, DmdbResultSet resultSet, int rows) throws SQLException {
        chain.ResultSet_setFetchSize(resultSet, rows);
    }

    @Override
    public void ResultSet_updateArray(FilterChain chain, DmdbResultSet resultSet, String columnLabel, Array x2) throws SQLException {
        chain.ResultSet_updateArray(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateArray(FilterChain chain, DmdbResultSet resultSet, int columnIndex, Array x2) throws SQLException {
        chain.ResultSet_updateArray(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateAsciiStream(FilterChain chain, DmdbResultSet resultSet, String columnLabel, InputStream x2) throws SQLException {
        chain.ResultSet_updateAsciiStream(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateAsciiStream(FilterChain chain, DmdbResultSet resultSet, String columnLabel, InputStream x2, int length) throws SQLException {
        chain.ResultSet_updateAsciiStream(resultSet, columnLabel, x2, length);
    }

    @Override
    public void ResultSet_updateAsciiStream(FilterChain chain, DmdbResultSet resultSet, String columnLabel, InputStream x2, long length) throws SQLException {
        chain.ResultSet_updateAsciiStream(resultSet, columnLabel, x2, length);
    }

    @Override
    public void ResultSet_updateAsciiStream(FilterChain chain, DmdbResultSet resultSet, int columnIndex, InputStream x2) throws SQLException {
        chain.ResultSet_updateAsciiStream(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateAsciiStream(FilterChain chain, DmdbResultSet resultSet, int columnIndex, InputStream x2, int length) throws SQLException {
        chain.ResultSet_updateAsciiStream(resultSet, columnIndex, x2, length);
    }

    @Override
    public void ResultSet_updateAsciiStream(FilterChain chain, DmdbResultSet resultSet, int columnIndex, InputStream x2, long length) throws SQLException {
        chain.ResultSet_updateAsciiStream(resultSet, columnIndex, x2, length);
    }

    @Override
    public void ResultSet_updateBigDecimal(FilterChain chain, DmdbResultSet resultSet, String columnLabel, BigDecimal x2) throws SQLException {
        chain.ResultSet_updateBigDecimal(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateBigDecimal(FilterChain chain, DmdbResultSet resultSet, int columnIndex, BigDecimal x2) throws SQLException {
        chain.ResultSet_updateBigDecimal(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateBinaryStream(FilterChain chain, DmdbResultSet resultSet, String columnLabel, InputStream x2) throws SQLException {
        chain.ResultSet_updateBinaryStream(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateBinaryStream(FilterChain chain, DmdbResultSet resultSet, String columnLabel, InputStream x2, int length) throws SQLException {
        chain.ResultSet_updateBinaryStream(resultSet, columnLabel, x2, length);
    }

    @Override
    public void ResultSet_updateBinaryStream(FilterChain chain, DmdbResultSet resultSet, String columnLabel, InputStream x2, long length) throws SQLException {
        chain.ResultSet_updateBinaryStream(resultSet, columnLabel, x2, length);
    }

    @Override
    public void ResultSet_updateBinaryStream(FilterChain chain, DmdbResultSet resultSet, int columnIndex, InputStream x2) throws SQLException {
        chain.ResultSet_updateBinaryStream(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateBinaryStream(FilterChain chain, DmdbResultSet resultSet, int columnIndex, InputStream x2, int length) throws SQLException {
        chain.ResultSet_updateBinaryStream(resultSet, columnIndex, x2, length);
    }

    @Override
    public void ResultSet_updateBinaryStream(FilterChain chain, DmdbResultSet resultSet, int columnIndex, InputStream x2, long length) throws SQLException {
        chain.ResultSet_updateBinaryStream(resultSet, columnIndex, x2, length);
    }

    @Override
    public void ResultSet_updateBlob(FilterChain chain, DmdbResultSet resultSet, String columnLabel, InputStream inputStream) throws SQLException {
        chain.ResultSet_updateBlob(resultSet, columnLabel, inputStream);
    }

    @Override
    public void ResultSet_updateBlob(FilterChain chain, DmdbResultSet resultSet, String columnLabel, InputStream inputStream, long length) throws SQLException {
        chain.ResultSet_updateBlob(resultSet, columnLabel, inputStream, length);
    }

    @Override
    public void ResultSet_updateBlob(FilterChain chain, DmdbResultSet resultSet, String columnLabel, Blob x2) throws SQLException {
        chain.ResultSet_updateBlob(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateBlob(FilterChain chain, DmdbResultSet resultSet, int columnIndex, InputStream inputStream) throws SQLException {
        chain.ResultSet_updateBlob(resultSet, columnIndex, inputStream);
    }

    @Override
    public void ResultSet_updateBlob(FilterChain chain, DmdbResultSet resultSet, int columnIndex, InputStream inputStream, long length) throws SQLException {
        chain.ResultSet_updateBlob(resultSet, columnIndex, inputStream, length);
    }

    @Override
    public void ResultSet_updateBlob(FilterChain chain, DmdbResultSet resultSet, int columnIndex, Blob x2) throws SQLException {
        chain.ResultSet_updateBlob(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateBoolean(FilterChain chain, DmdbResultSet resultSet, String columnLabel, boolean x2) throws SQLException {
        chain.ResultSet_updateBoolean(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateBoolean(FilterChain chain, DmdbResultSet resultSet, int columnIndex, boolean x2) throws SQLException {
        chain.ResultSet_updateBoolean(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateByte(FilterChain chain, DmdbResultSet resultSet, String columnLabel, byte x2) throws SQLException {
        chain.ResultSet_updateByte(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateByte(FilterChain chain, DmdbResultSet resultSet, int columnIndex, byte x2) throws SQLException {
        chain.ResultSet_updateByte(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateBytes(FilterChain chain, DmdbResultSet resultSet, String columnLabel, byte[] x2) throws SQLException {
        chain.ResultSet_updateBytes(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateBytes(FilterChain chain, DmdbResultSet resultSet, int columnIndex, byte[] x2) throws SQLException {
        chain.ResultSet_updateBytes(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateCharacterStream(FilterChain chain, DmdbResultSet resultSet, String columnLabel, Reader reader) throws SQLException {
        chain.ResultSet_updateCharacterStream(resultSet, columnLabel, reader);
    }

    @Override
    public void ResultSet_updateCharacterStream(FilterChain chain, DmdbResultSet resultSet, String columnLabel, Reader reader, int length) throws SQLException {
        chain.ResultSet_updateCharacterStream(resultSet, columnLabel, reader, length);
    }

    @Override
    public void ResultSet_updateCharacterStream(FilterChain chain, DmdbResultSet resultSet, String columnLabel, Reader reader, long length) throws SQLException {
        chain.ResultSet_updateCharacterStream(resultSet, columnLabel, reader, length);
    }

    @Override
    public void ResultSet_updateCharacterStream(FilterChain chain, DmdbResultSet resultSet, int columnIndex, Reader x2) throws SQLException {
        chain.ResultSet_updateCharacterStream(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateCharacterStream(FilterChain chain, DmdbResultSet resultSet, int columnIndex, Reader x2, int length) throws SQLException {
        chain.ResultSet_updateCharacterStream(resultSet, columnIndex, x2, length);
    }

    @Override
    public void ResultSet_updateCharacterStream(FilterChain chain, DmdbResultSet resultSet, int columnIndex, Reader x2, long length) throws SQLException {
        chain.ResultSet_updateCharacterStream(resultSet, columnIndex, x2, length);
    }

    @Override
    public void ResultSet_updateClob(FilterChain chain, DmdbResultSet resultSet, String columnLabel, Reader reader) throws SQLException {
        chain.ResultSet_updateClob(resultSet, columnLabel, reader);
    }

    @Override
    public void ResultSet_updateClob(FilterChain chain, DmdbResultSet resultSet, String columnLabel, Reader reader, long length) throws SQLException {
        chain.ResultSet_updateClob(resultSet, columnLabel, reader, length);
    }

    @Override
    public void ResultSet_updateClob(FilterChain chain, DmdbResultSet resultSet, String columnLabel, Clob x2) throws SQLException {
        chain.ResultSet_updateClob(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateClob(FilterChain chain, DmdbResultSet resultSet, int columnIndex, Reader reader) throws SQLException {
        chain.ResultSet_updateClob(resultSet, columnIndex, reader);
    }

    @Override
    public void ResultSet_updateClob(FilterChain chain, DmdbResultSet resultSet, int columnIndex, Reader reader, long length) throws SQLException {
        chain.ResultSet_updateClob(resultSet, columnIndex, reader, length);
    }

    @Override
    public void ResultSet_updateClob(FilterChain chain, DmdbResultSet resultSet, int columnIndex, Clob x2) throws SQLException {
        chain.ResultSet_updateClob(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateDate(FilterChain chain, DmdbResultSet resultSet, String columnLabel, Date x2) throws SQLException {
        chain.ResultSet_updateDate(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateDate(FilterChain chain, DmdbResultSet resultSet, int columnIndex, Date x2) throws SQLException {
        chain.ResultSet_updateDate(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateDouble(FilterChain chain, DmdbResultSet resultSet, String columnLabel, double x2) throws SQLException {
        chain.ResultSet_updateDouble(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateDouble(FilterChain chain, DmdbResultSet resultSet, int columnIndex, double x2) throws SQLException {
        chain.ResultSet_updateDouble(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateFloat(FilterChain chain, DmdbResultSet resultSet, String columnLabel, float x2) throws SQLException {
        chain.ResultSet_updateFloat(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateFloat(FilterChain chain, DmdbResultSet resultSet, int columnIndex, float x2) throws SQLException {
        chain.ResultSet_updateFloat(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateInt(FilterChain chain, DmdbResultSet resultSet, String columnLabel, int x2) throws SQLException {
        chain.ResultSet_updateInt(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateInt(FilterChain chain, DmdbResultSet resultSet, int columnIndex, int x2) throws SQLException {
        chain.ResultSet_updateInt(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateLong(FilterChain chain, DmdbResultSet resultSet, String columnLabel, long x2) throws SQLException {
        chain.ResultSet_updateLong(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateLong(FilterChain chain, DmdbResultSet resultSet, int columnIndex, long x2) throws SQLException {
        chain.ResultSet_updateLong(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateNCharacterStream(FilterChain chain, DmdbResultSet resultSet, String columnLabel, Reader reader) throws SQLException {
        chain.ResultSet_updateNCharacterStream(resultSet, columnLabel, reader);
    }

    @Override
    public void ResultSet_updateNCharacterStream(FilterChain chain, DmdbResultSet resultSet, String columnLabel, Reader reader, long length) throws SQLException {
        chain.ResultSet_updateNCharacterStream(resultSet, columnLabel, reader, length);
    }

    @Override
    public void ResultSet_updateNCharacterStream(FilterChain chain, DmdbResultSet resultSet, int columnIndex, Reader x2) throws SQLException {
        chain.ResultSet_updateNCharacterStream(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateNCharacterStream(FilterChain chain, DmdbResultSet resultSet, int columnIndex, Reader x2, long length) throws SQLException {
        chain.ResultSet_updateNCharacterStream(resultSet, columnIndex, x2, length);
    }

    @Override
    public void ResultSet_updateNClob(FilterChain chain, DmdbResultSet resultSet, String columnLabel, NClob nClob) throws SQLException {
        chain.ResultSet_updateNClob(resultSet, columnLabel, nClob);
    }

    @Override
    public void ResultSet_updateNClob(FilterChain chain, DmdbResultSet resultSet, String columnLabel, Reader reader) throws SQLException {
        chain.ResultSet_updateNClob(resultSet, columnLabel, reader);
    }

    @Override
    public void ResultSet_updateNClob(FilterChain chain, DmdbResultSet resultSet, String columnLabel, Reader reader, long length) throws SQLException {
        chain.ResultSet_updateNClob(resultSet, columnLabel, reader, length);
    }

    @Override
    public void ResultSet_updateNClob(FilterChain chain, DmdbResultSet resultSet, int columnIndex, NClob nClob) throws SQLException {
        chain.ResultSet_updateNClob(resultSet, columnIndex, nClob);
    }

    @Override
    public void ResultSet_updateNClob(FilterChain chain, DmdbResultSet resultSet, int columnIndex, Reader reader) throws SQLException {
        chain.ResultSet_updateNClob(resultSet, columnIndex, reader);
    }

    @Override
    public void ResultSet_updateNClob(FilterChain chain, DmdbResultSet resultSet, int columnIndex, Reader reader, long length) throws SQLException {
        chain.ResultSet_updateNClob(resultSet, columnIndex, reader, length);
    }

    @Override
    public void ResultSet_updateNString(FilterChain chain, DmdbResultSet resultSet, String columnLabel, String nString) throws SQLException {
        chain.ResultSet_updateNString(resultSet, columnLabel, nString);
    }

    @Override
    public void ResultSet_updateNString(FilterChain chain, DmdbResultSet resultSet, int columnIndex, String nString) throws SQLException {
        chain.ResultSet_updateNString(resultSet, columnIndex, nString);
    }

    @Override
    public void ResultSet_updateNull(FilterChain chain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        chain.ResultSet_updateNull(resultSet, columnLabel);
    }

    @Override
    public void ResultSet_updateNull(FilterChain chain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        chain.ResultSet_updateNull(resultSet, columnIndex);
    }

    @Override
    public void ResultSet_updateObject(FilterChain chain, DmdbResultSet resultSet, String columnLabel, Object x2) throws SQLException {
        chain.ResultSet_updateObject(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateObject(FilterChain chain, DmdbResultSet resultSet, String columnLabel, Object x2, int scaleOrLength) throws SQLException {
        chain.ResultSet_updateObject(resultSet, columnLabel, x2, scaleOrLength);
    }

    @Override
    public void ResultSet_updateObject(FilterChain chain, DmdbResultSet resultSet, int columnIndex, Object x2) throws SQLException {
        chain.ResultSet_updateObject(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateObject(FilterChain chain, DmdbResultSet resultSet, int columnIndex, Object x2, int scaleOrLength) throws SQLException {
        chain.ResultSet_updateObject(resultSet, columnIndex, x2, scaleOrLength);
    }

    @Override
    public void ResultSet_updateRef(FilterChain chain, DmdbResultSet resultSet, String columnLabel, Ref x2) throws SQLException {
        chain.ResultSet_updateRef(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateRef(FilterChain chain, DmdbResultSet resultSet, int columnIndex, Ref x2) throws SQLException {
        chain.ResultSet_updateRef(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateRow(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        chain.ResultSet_updateRow(resultSet);
    }

    @Override
    public void ResultSet_updateRowId(FilterChain chain, DmdbResultSet resultSet, String columnLabel, RowId x2) throws SQLException {
        chain.ResultSet_updateRowId(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateRowId(FilterChain chain, DmdbResultSet resultSet, int columnIndex, RowId x2) throws SQLException {
        chain.ResultSet_updateRowId(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateSQLXML(FilterChain chain, DmdbResultSet resultSet, String columnLabel, SQLXML xmlObject) throws SQLException {
        chain.ResultSet_updateSQLXML(resultSet, columnLabel, xmlObject);
    }

    @Override
    public void ResultSet_updateSQLXML(FilterChain chain, DmdbResultSet resultSet, int columnIndex, SQLXML xmlObject) throws SQLException {
        chain.ResultSet_updateSQLXML(resultSet, columnIndex, xmlObject);
    }

    @Override
    public void ResultSet_updateShort(FilterChain chain, DmdbResultSet resultSet, String columnLabel, short x2) throws SQLException {
        chain.ResultSet_updateShort(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateShort(FilterChain chain, DmdbResultSet resultSet, int columnIndex, short x2) throws SQLException {
        chain.ResultSet_updateShort(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateString(FilterChain chain, DmdbResultSet resultSet, String columnLabel, String x2) throws SQLException {
        chain.ResultSet_updateString(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateString(FilterChain chain, DmdbResultSet resultSet, int columnIndex, String x2) throws SQLException {
        chain.ResultSet_updateString(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateTime(FilterChain chain, DmdbResultSet resultSet, String columnLabel, Time x2) throws SQLException {
        chain.ResultSet_updateTime(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateTime(FilterChain chain, DmdbResultSet resultSet, int columnIndex, Time x2) throws SQLException {
        chain.ResultSet_updateTime(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateTimestamp(FilterChain chain, DmdbResultSet resultSet, String columnLabel, Timestamp x2) throws SQLException {
        chain.ResultSet_updateTimestamp(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateTimestamp(FilterChain chain, DmdbResultSet resultSet, int columnIndex, Timestamp x2) throws SQLException {
        chain.ResultSet_updateTimestamp(resultSet, columnIndex, x2);
    }

    @Override
    public boolean ResultSet_wasNull(FilterChain chain, DmdbResultSet resultSet) throws SQLException {
        return chain.ResultSet_wasNull(resultSet);
    }

    @Override
    public boolean DatabaseMetaData_allProceduresAreCallable(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_allProceduresAreCallable(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_allTablesAreSelectable(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_allTablesAreSelectable(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_autoCommitFailureClosesAllResultSets(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_autoCommitFailureClosesAllResultSets(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_dataDefinitionCausesTransactionCommit(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_dataDefinitionCausesTransactionCommit(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_dataDefinitionIgnoredInTransactions(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_dataDefinitionIgnoredInTransactions(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_deletesAreDetected(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        return chain.DatabaseMetaData_deletesAreDetected(databaseMetaData, type);
    }

    @Override
    public boolean DatabaseMetaData_doesMaxRowSizeIncludeBlobs(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_doesMaxRowSizeIncludeBlobs(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_generatedKeyAlwaysReturned(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_generatedKeyAlwaysReturned(databaseMetaData);
    }

    @Override
    public ResultSet DatabaseMetaData_getAttributes(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        return chain.DatabaseMetaData_getAttributes(databaseMetaData, catalog, schemaPattern, typeNamePattern, attributeNamePattern);
    }

    @Override
    public ResultSet DatabaseMetaData_getBestRowIdentifier(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        return chain.DatabaseMetaData_getBestRowIdentifier(databaseMetaData, catalog, schema, table, scope, nullable);
    }

    @Override
    public String DatabaseMetaData_getCatalogSeparator(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getCatalogSeparator(databaseMetaData);
    }

    @Override
    public String DatabaseMetaData_getCatalogTerm(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getCatalogTerm(databaseMetaData);
    }

    @Override
    public ResultSet DatabaseMetaData_getCatalogs(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getCatalogs(databaseMetaData);
    }

    @Override
    public ResultSet DatabaseMetaData_getClientInfoProperties(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getClientInfoProperties(databaseMetaData);
    }

    @Override
    public ResultSet DatabaseMetaData_getColumnPrivileges(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        return chain.DatabaseMetaData_getColumnPrivileges(databaseMetaData, catalog, schema, table, columnNamePattern);
    }

    @Override
    public ResultSet DatabaseMetaData_getColumns(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return chain.DatabaseMetaData_getColumns(databaseMetaData, catalog, schemaPattern, tableNamePattern, columnNamePattern);
    }

    @Override
    public Connection DatabaseMetaData_getConnection(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getConnection(databaseMetaData);
    }

    @Override
    public ResultSet DatabaseMetaData_getCrossReference(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        return chain.DatabaseMetaData_getCrossReference(databaseMetaData, parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable);
    }

    @Override
    public int DatabaseMetaData_getDatabaseMajorVersion(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getDatabaseMajorVersion(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getDatabaseMinorVersion(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getDatabaseMinorVersion(databaseMetaData);
    }

    @Override
    public String DatabaseMetaData_getDatabaseProductName(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getDatabaseProductName(databaseMetaData);
    }

    @Override
    public String DatabaseMetaData_getDatabaseProductVersion(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getDatabaseProductVersion(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getDefaultTransactionIsolation(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getDefaultTransactionIsolation(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getDriverMajorVersion(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) {
        return chain.DatabaseMetaData_getDriverMajorVersion(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getDriverMinorVersion(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) {
        return chain.DatabaseMetaData_getDriverMinorVersion(databaseMetaData);
    }

    @Override
    public String DatabaseMetaData_getDriverName(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getDriverName(databaseMetaData);
    }

    @Override
    public String DatabaseMetaData_getDriverVersion(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getDriverVersion(databaseMetaData);
    }

    @Override
    public ResultSet DatabaseMetaData_getExportedKeys(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table) throws SQLException {
        return chain.DatabaseMetaData_getExportedKeys(databaseMetaData, catalog, schema, table);
    }

    @Override
    public String DatabaseMetaData_getExtraNameCharacters(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getExtraNameCharacters(databaseMetaData);
    }

    @Override
    public ResultSet DatabaseMetaData_getFunctionColumns(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        return chain.DatabaseMetaData_getFunctionColumns(databaseMetaData, catalog, schemaPattern, functionNamePattern, columnNamePattern);
    }

    @Override
    public ResultSet DatabaseMetaData_getFunctions(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        return chain.DatabaseMetaData_getFunctions(databaseMetaData, catalog, schemaPattern, functionNamePattern);
    }

    @Override
    public String DatabaseMetaData_getIdentifierQuoteString(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getIdentifierQuoteString(databaseMetaData);
    }

    @Override
    public ResultSet DatabaseMetaData_getImportedKeys(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table) throws SQLException {
        return chain.DatabaseMetaData_getImportedKeys(databaseMetaData, catalog, schema, table);
    }

    @Override
    public ResultSet DatabaseMetaData_getIndexInfo(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        return chain.DatabaseMetaData_getIndexInfo(databaseMetaData, catalog, schema, table, unique, approximate);
    }

    @Override
    public int DatabaseMetaData_getJDBCMajorVersion(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getJDBCMajorVersion(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getJDBCMinorVersion(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getJDBCMinorVersion(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxBinaryLiteralLength(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getMaxBinaryLiteralLength(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxCatalogNameLength(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getMaxCatalogNameLength(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxCharLiteralLength(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getMaxCharLiteralLength(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxColumnNameLength(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getMaxColumnNameLength(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxColumnsInGroupBy(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getMaxColumnsInGroupBy(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxColumnsInIndex(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getMaxColumnsInIndex(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxColumnsInOrderBy(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getMaxColumnsInOrderBy(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxColumnsInSelect(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getMaxColumnsInSelect(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxColumnsInTable(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getMaxColumnsInTable(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxConnections(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getMaxConnections(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxCursorNameLength(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getMaxCursorNameLength(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxIndexLength(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getMaxIndexLength(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxProcedureNameLength(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getMaxProcedureNameLength(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxRowSize(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getMaxRowSize(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxSchemaNameLength(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getMaxSchemaNameLength(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxStatementLength(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getMaxStatementLength(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxStatements(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getMaxStatements(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxTableNameLength(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getMaxTableNameLength(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxTablesInSelect(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getMaxTablesInSelect(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxUserNameLength(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getMaxUserNameLength(databaseMetaData);
    }

    @Override
    public String DatabaseMetaData_getNumericFunctions(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getNumericFunctions(databaseMetaData);
    }

    @Override
    public ResultSet DatabaseMetaData_getPrimaryKeys(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table) throws SQLException {
        return chain.DatabaseMetaData_getPrimaryKeys(databaseMetaData, catalog, schema, table);
    }

    @Override
    public ResultSet DatabaseMetaData_getProcedureColumns(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        return chain.DatabaseMetaData_getProcedureColumns(databaseMetaData, catalog, schemaPattern, procedureNamePattern, columnNamePattern);
    }

    @Override
    public String DatabaseMetaData_getProcedureTerm(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getProcedureTerm(databaseMetaData);
    }

    @Override
    public ResultSet DatabaseMetaData_getProcedures(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        return chain.DatabaseMetaData_getProcedures(databaseMetaData, catalog, schemaPattern, procedureNamePattern);
    }

    @Override
    public ResultSet DatabaseMetaData_getPseudoColumns(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return chain.DatabaseMetaData_getPseudoColumns(databaseMetaData, catalog, schemaPattern, tableNamePattern, columnNamePattern);
    }

    @Override
    public int DatabaseMetaData_getResultSetHoldability(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getResultSetHoldability(databaseMetaData);
    }

    @Override
    public RowIdLifetime DatabaseMetaData_getRowIdLifetime(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getRowIdLifetime(databaseMetaData);
    }

    @Override
    public String DatabaseMetaData_getSQLKeywords(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getSQLKeywords(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getSQLStateType(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getSQLStateType(databaseMetaData);
    }

    @Override
    public String DatabaseMetaData_getSchemaTerm(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getSchemaTerm(databaseMetaData);
    }

    @Override
    public ResultSet DatabaseMetaData_getSchemas(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getSchemas(databaseMetaData);
    }

    @Override
    public ResultSet DatabaseMetaData_getSchemas(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern) throws SQLException {
        return chain.DatabaseMetaData_getSchemas(databaseMetaData, catalog, schemaPattern);
    }

    @Override
    public String DatabaseMetaData_getSearchStringEscape(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getSearchStringEscape(databaseMetaData);
    }

    @Override
    public String DatabaseMetaData_getStringFunctions(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getStringFunctions(databaseMetaData);
    }

    @Override
    public ResultSet DatabaseMetaData_getSuperTables(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return chain.DatabaseMetaData_getSuperTables(databaseMetaData, catalog, schemaPattern, tableNamePattern);
    }

    @Override
    public ResultSet DatabaseMetaData_getSuperTypes(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        return chain.DatabaseMetaData_getSuperTypes(databaseMetaData, catalog, schemaPattern, typeNamePattern);
    }

    @Override
    public String DatabaseMetaData_getSystemFunctions(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getSystemFunctions(databaseMetaData);
    }

    @Override
    public ResultSet DatabaseMetaData_getTablePrivileges(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return chain.DatabaseMetaData_getTablePrivileges(databaseMetaData, catalog, schemaPattern, tableNamePattern);
    }

    @Override
    public ResultSet DatabaseMetaData_getTableTypes(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getTableTypes(databaseMetaData);
    }

    @Override
    public ResultSet DatabaseMetaData_getTables(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        return chain.DatabaseMetaData_getTables(databaseMetaData, catalog, schemaPattern, tableNamePattern, types);
    }

    @Override
    public String DatabaseMetaData_getTimeDateFunctions(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getTimeDateFunctions(databaseMetaData);
    }

    @Override
    public ResultSet DatabaseMetaData_getTypeInfo(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getTypeInfo(databaseMetaData);
    }

    @Override
    public ResultSet DatabaseMetaData_getUDTs(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        return chain.DatabaseMetaData_getUDTs(databaseMetaData, catalog, schemaPattern, typeNamePattern, types);
    }

    @Override
    public String DatabaseMetaData_getURL(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getURL(databaseMetaData);
    }

    @Override
    public String DatabaseMetaData_getUserName(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_getUserName(databaseMetaData);
    }

    @Override
    public ResultSet DatabaseMetaData_getVersionColumns(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table) throws SQLException {
        return chain.DatabaseMetaData_getVersionColumns(databaseMetaData, catalog, schema, table);
    }

    @Override
    public boolean DatabaseMetaData_insertsAreDetected(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        return chain.DatabaseMetaData_insertsAreDetected(databaseMetaData, type);
    }

    @Override
    public boolean DatabaseMetaData_isCatalogAtStart(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_isCatalogAtStart(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_isReadOnly(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_isReadOnly(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_locatorsUpdateCopy(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_locatorsUpdateCopy(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_nullPlusNonNullIsNull(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_nullPlusNonNullIsNull(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_nullsAreSortedAtEnd(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_nullsAreSortedAtEnd(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_nullsAreSortedAtStart(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_nullsAreSortedAtStart(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_nullsAreSortedHigh(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_nullsAreSortedHigh(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_nullsAreSortedLow(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_nullsAreSortedLow(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_othersDeletesAreVisible(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        return chain.DatabaseMetaData_othersDeletesAreVisible(databaseMetaData, type);
    }

    @Override
    public boolean DatabaseMetaData_othersInsertsAreVisible(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        return chain.DatabaseMetaData_othersInsertsAreVisible(databaseMetaData, type);
    }

    @Override
    public boolean DatabaseMetaData_othersUpdatesAreVisible(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        return chain.DatabaseMetaData_othersUpdatesAreVisible(databaseMetaData, type);
    }

    @Override
    public boolean DatabaseMetaData_ownDeletesAreVisible(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        return chain.DatabaseMetaData_ownDeletesAreVisible(databaseMetaData, type);
    }

    @Override
    public boolean DatabaseMetaData_ownInsertsAreVisible(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        return chain.DatabaseMetaData_ownInsertsAreVisible(databaseMetaData, type);
    }

    @Override
    public boolean DatabaseMetaData_ownUpdatesAreVisible(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        return chain.DatabaseMetaData_ownUpdatesAreVisible(databaseMetaData, type);
    }

    @Override
    public boolean DatabaseMetaData_storesLowerCaseIdentifiers(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_storesLowerCaseIdentifiers(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_storesLowerCaseQuotedIdentifiers(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_storesLowerCaseQuotedIdentifiers(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_storesMixedCaseIdentifiers(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_storesMixedCaseIdentifiers(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_storesMixedCaseQuotedIdentifiers(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_storesMixedCaseQuotedIdentifiers(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_storesUpperCaseIdentifiers(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_storesUpperCaseIdentifiers(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_storesUpperCaseQuotedIdentifiers(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_storesUpperCaseQuotedIdentifiers(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsANSI92EntryLevelSQL(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsANSI92EntryLevelSQL(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsANSI92FullSQL(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsANSI92FullSQL(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsANSI92IntermediateSQL(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsANSI92IntermediateSQL(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsAlterTableWithAddColumn(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsAlterTableWithAddColumn(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsAlterTableWithDropColumn(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsAlterTableWithDropColumn(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsBatchUpdates(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsBatchUpdates(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsCatalogsInDataManipulation(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsCatalogsInDataManipulation(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsCatalogsInIndexDefinitions(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsCatalogsInIndexDefinitions(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsCatalogsInPrivilegeDefinitions(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsCatalogsInPrivilegeDefinitions(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsCatalogsInProcedureCalls(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsCatalogsInProcedureCalls(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsCatalogsInTableDefinitions(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsCatalogsInTableDefinitions(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsColumnAliasing(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsColumnAliasing(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsConvert(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsConvert(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsConvert(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, int fromType, int toType) throws SQLException {
        return chain.DatabaseMetaData_supportsConvert(databaseMetaData, fromType, toType);
    }

    @Override
    public boolean DatabaseMetaData_supportsCoreSQLGrammar(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsCoreSQLGrammar(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsCorrelatedSubqueries(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsCorrelatedSubqueries(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsDataDefinitionAndDataManipulationTransactions(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsDataDefinitionAndDataManipulationTransactions(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsDataManipulationTransactionsOnly(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsDataManipulationTransactionsOnly(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsDifferentTableCorrelationNames(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsDifferentTableCorrelationNames(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsExpressionsInOrderBy(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsExpressionsInOrderBy(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsExtendedSQLGrammar(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsExtendedSQLGrammar(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsFullOuterJoins(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsFullOuterJoins(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsGetGeneratedKeys(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsGetGeneratedKeys(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsGroupBy(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsGroupBy(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsGroupByBeyondSelect(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsGroupByBeyondSelect(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsGroupByUnrelated(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsGroupByUnrelated(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsIntegrityEnhancementFacility(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsIntegrityEnhancementFacility(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsLikeEscapeClause(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsLikeEscapeClause(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsLimitedOuterJoins(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsLimitedOuterJoins(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsMinimumSQLGrammar(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsMinimumSQLGrammar(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsMixedCaseIdentifiers(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsMixedCaseIdentifiers(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsMixedCaseQuotedIdentifiers(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsMixedCaseQuotedIdentifiers(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsMultipleOpenResults(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsMultipleOpenResults(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsMultipleResultSets(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsMultipleResultSets(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsMultipleTransactions(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsMultipleTransactions(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsNamedParameters(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsNamedParameters(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsNonNullableColumns(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsNonNullableColumns(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsOpenCursorsAcrossCommit(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsOpenCursorsAcrossCommit(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsOpenCursorsAcrossRollback(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsOpenCursorsAcrossRollback(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsOpenStatementsAcrossCommit(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsOpenStatementsAcrossCommit(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsOpenStatementsAcrossRollback(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsOpenStatementsAcrossRollback(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsOrderByUnrelated(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsOrderByUnrelated(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsOuterJoins(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsOuterJoins(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsPositionedDelete(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsPositionedDelete(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsPositionedUpdate(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsPositionedUpdate(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsResultSetConcurrency(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, int type, int concurrency) throws SQLException {
        return chain.DatabaseMetaData_supportsResultSetConcurrency(databaseMetaData, type, concurrency);
    }

    @Override
    public boolean DatabaseMetaData_supportsResultSetHoldability(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, int holdability) throws SQLException {
        return chain.DatabaseMetaData_supportsResultSetHoldability(databaseMetaData, holdability);
    }

    @Override
    public boolean DatabaseMetaData_supportsResultSetType(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        return chain.DatabaseMetaData_supportsResultSetType(databaseMetaData, type);
    }

    @Override
    public boolean DatabaseMetaData_supportsSavepoints(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsSavepoints(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsSchemasInDataManipulation(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsSchemasInDataManipulation(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsSchemasInIndexDefinitions(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsSchemasInIndexDefinitions(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsSchemasInPrivilegeDefinitions(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsSchemasInPrivilegeDefinitions(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsSchemasInProcedureCalls(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsSchemasInProcedureCalls(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsSchemasInTableDefinitions(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsSchemasInTableDefinitions(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsSelectForUpdate(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsSelectForUpdate(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsStatementPooling(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsStatementPooling(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsStoredFunctionsUsingCallSyntax(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsStoredFunctionsUsingCallSyntax(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsStoredProcedures(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsStoredProcedures(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsSubqueriesInComparisons(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsSubqueriesInComparisons(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsSubqueriesInExists(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsSubqueriesInExists(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsSubqueriesInIns(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsSubqueriesInIns(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsSubqueriesInQuantifieds(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsSubqueriesInQuantifieds(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsTableCorrelationNames(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsTableCorrelationNames(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsTransactionIsolationLevel(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, int level) throws SQLException {
        return chain.DatabaseMetaData_supportsTransactionIsolationLevel(databaseMetaData, level);
    }

    @Override
    public boolean DatabaseMetaData_supportsTransactions(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsTransactions(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsUnion(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsUnion(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsUnionAll(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_supportsUnionAll(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_updatesAreDetected(FilterChain chain, DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        return chain.DatabaseMetaData_updatesAreDetected(databaseMetaData, type);
    }

    @Override
    public boolean DatabaseMetaData_usesLocalFilePerTable(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_usesLocalFilePerTable(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_usesLocalFiles(FilterChain chain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return chain.DatabaseMetaData_usesLocalFiles(databaseMetaData);
    }

    @Override
    public String ParameterMetaData_getParameterClassName(FilterChain chain, DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        return chain.ParameterMetaData_getParameterClassName(parameterMetaData, param);
    }

    @Override
    public int ParameterMetaData_getParameterCount(FilterChain chain, DmdbParameterMetaData parameterMetaData) throws SQLException {
        return chain.ParameterMetaData_getParameterCount(parameterMetaData);
    }

    @Override
    public int ParameterMetaData_getParameterMode(FilterChain chain, DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        return chain.ParameterMetaData_getParameterMode(parameterMetaData, param);
    }

    @Override
    public int ParameterMetaData_getParameterType(FilterChain chain, DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        return chain.ParameterMetaData_getParameterType(parameterMetaData, param);
    }

    @Override
    public String ParameterMetaData_getParameterTypeName(FilterChain chain, DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        return chain.ParameterMetaData_getParameterTypeName(parameterMetaData, param);
    }

    @Override
    public int ParameterMetaData_getPrecision(FilterChain chain, DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        return chain.ParameterMetaData_getPrecision(parameterMetaData, param);
    }

    @Override
    public int ParameterMetaData_getScale(FilterChain chain, DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        return chain.ParameterMetaData_getScale(parameterMetaData, param);
    }

    @Override
    public int ParameterMetaData_isNullable(FilterChain chain, DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        return chain.ParameterMetaData_isNullable(parameterMetaData, param);
    }

    @Override
    public boolean ParameterMetaData_isSigned(FilterChain chain, DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        return chain.ParameterMetaData_isSigned(parameterMetaData, param);
    }

    @Override
    public String ResultSetMetaData_getCatalogName(FilterChain chain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return chain.ResultSetMetaData_getCatalogName(resultSetMetaData, column);
    }

    @Override
    public String ResultSetMetaData_getColumnClassName(FilterChain chain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return chain.ResultSetMetaData_getColumnClassName(resultSetMetaData, column);
    }

    @Override
    public int ResultSetMetaData_getColumnCount(FilterChain chain, DmdbResultSetMetaData resultSetMetaData) throws SQLException {
        return chain.ResultSetMetaData_getColumnCount(resultSetMetaData);
    }

    @Override
    public int ResultSetMetaData_getColumnDisplaySize(FilterChain chain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return chain.ResultSetMetaData_getColumnDisplaySize(resultSetMetaData, column);
    }

    @Override
    public String ResultSetMetaData_getColumnLabel(FilterChain chain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return chain.ResultSetMetaData_getColumnLabel(resultSetMetaData, column);
    }

    @Override
    public String ResultSetMetaData_getColumnName(FilterChain chain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return chain.ResultSetMetaData_getColumnName(resultSetMetaData, column);
    }

    @Override
    public int ResultSetMetaData_getColumnType(FilterChain chain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return chain.ResultSetMetaData_getColumnType(resultSetMetaData, column);
    }

    @Override
    public String ResultSetMetaData_getColumnTypeName(FilterChain chain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return chain.ResultSetMetaData_getColumnTypeName(resultSetMetaData, column);
    }

    @Override
    public int ResultSetMetaData_getPrecision(FilterChain chain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return chain.ResultSetMetaData_getPrecision(resultSetMetaData, column);
    }

    @Override
    public int ResultSetMetaData_getScale(FilterChain chain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return chain.ResultSetMetaData_getScale(resultSetMetaData, column);
    }

    @Override
    public String ResultSetMetaData_getSchemaName(FilterChain chain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return chain.ResultSetMetaData_getSchemaName(resultSetMetaData, column);
    }

    @Override
    public String ResultSetMetaData_getTableName(FilterChain chain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return chain.ResultSetMetaData_getTableName(resultSetMetaData, column);
    }

    @Override
    public boolean ResultSetMetaData_isAutoIncrement(FilterChain chain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return chain.ResultSetMetaData_isAutoIncrement(resultSetMetaData, column);
    }

    @Override
    public boolean ResultSetMetaData_isCaseSensitive(FilterChain chain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return chain.ResultSetMetaData_isCaseSensitive(resultSetMetaData, column);
    }

    @Override
    public boolean ResultSetMetaData_isCurrency(FilterChain chain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return chain.ResultSetMetaData_isCurrency(resultSetMetaData, column);
    }

    @Override
    public boolean ResultSetMetaData_isDefinitelyWritable(FilterChain chain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return chain.ResultSetMetaData_isDefinitelyWritable(resultSetMetaData, column);
    }

    @Override
    public int ResultSetMetaData_isNullable(FilterChain chain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return chain.ResultSetMetaData_isNullable(resultSetMetaData, column);
    }

    @Override
    public boolean ResultSetMetaData_isReadOnly(FilterChain chain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return chain.ResultSetMetaData_isReadOnly(resultSetMetaData, column);
    }

    @Override
    public boolean ResultSetMetaData_isSearchable(FilterChain chain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return chain.ResultSetMetaData_isSearchable(resultSetMetaData, column);
    }

    @Override
    public boolean ResultSetMetaData_isSigned(FilterChain chain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return chain.ResultSetMetaData_isSigned(resultSetMetaData, column);
    }

    @Override
    public boolean ResultSetMetaData_isWritable(FilterChain chain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return chain.ResultSetMetaData_isWritable(resultSetMetaData, column);
    }

    /* synthetic */ StatFilter(StatFilter statFilter) {
        this();
    }

    private static class StatFilterThreadHolder {
        private static final StatFilter instance = new StatFilter(null);

        private StatFilterThreadHolder() {
        }
    }
}

