/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter.rw;

import dm.jdbc.desc.conf.DmProperties;
import dm.jdbc.driver.DmDriver;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbCallableStatement;
import dm.jdbc.driver.DmdbClob;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbDatabaseMetaData;
import dm.jdbc.driver.DmdbIntervalDT;
import dm.jdbc.driver.DmdbIntervalYM;
import dm.jdbc.driver.DmdbParameterMetaData;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbResultSetMetaData;
import dm.jdbc.driver.DmdbSavepoint;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.driver.DmdbTimestamp;
import dm.jdbc.driver.DmdbXAResource;
import dm.jdbc.filter.Filter;
import dm.jdbc.filter.FilterChain;
import dm.jdbc.filter.rw.ExecuteCallBack;
import dm.jdbc.filter.rw.RWUtil2;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.RowIdLifetime;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class RWFilter2
implements Filter {
    private static final RWFilter2 rwFilter = new RWFilter2();

    public static RWFilter2 getInstance() {
        return rwFilter;
    }

    @Override
    public long Blob_length(FilterChain filterChain, DmdbBlob blob) throws SQLException {
        return blob.do_length();
    }

    @Override
    public byte[] Blob_getBytes(FilterChain filterChain, DmdbBlob blob, long pos, int length) throws SQLException {
        return blob.do_getBytes(pos, length);
    }

    @Override
    public InputStream Blob_getBinaryStream(FilterChain filterChain, DmdbBlob blob) throws SQLException {
        return blob.do_getBinaryStream();
    }

    @Override
    public long Blob_position(FilterChain filterChain, DmdbBlob blob, byte[] pattern, long start) throws SQLException {
        return blob.do_position(pattern, start);
    }

    @Override
    public long Blob_position(FilterChain filterChain, DmdbBlob blob, Blob pattern, long start) throws SQLException {
        return blob.do_position(pattern, start);
    }

    @Override
    public int Blob_setBytes(FilterChain filterChain, DmdbBlob blob, long pos, byte[] bytes) throws SQLException {
        return blob.do_setBytes(pos, bytes);
    }

    @Override
    public int Blob_setBytes(FilterChain filterChain, DmdbBlob blob, long pos, byte[] bytes, int offset, int len) throws SQLException {
        return blob.do_setBytes(pos, bytes, offset, len);
    }

    @Override
    public OutputStream Blob_setBinaryStream(FilterChain filterChain, DmdbBlob blob, long pos) throws SQLException {
        return blob.do_setBinaryStream(pos);
    }

    @Override
    public void Blob_truncate(FilterChain filterChain, DmdbBlob blob, long len) throws SQLException {
        blob.do_truncate(len);
    }

    @Override
    public void Blob_free(FilterChain filterChain, DmdbBlob blob) throws SQLException {
        blob.do_free();
    }

    @Override
    public InputStream Blob_getBinaryStream(FilterChain filterChain, DmdbBlob blob, long pos, long length) throws SQLException {
        return blob.do_getBinaryStream(pos, length);
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex, int sqlType) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_registerOutParameter(parameterIndex, sqlType);
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex, int sqlType, int scale) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_registerOutParameter(parameterIndex, sqlType, scale);
    }

    @Override
    public boolean CallableStatement_wasNull(FilterChain filterChain, DmdbCallableStatement callableStatement) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_wasNull();
    }

    @Override
    public String CallableStatement_getString(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getString(parameterIndex);
    }

    @Override
    public boolean CallableStatement_getBoolean(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getBoolean(parameterIndex);
    }

    @Override
    public byte CallableStatement_getByte(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getByte(parameterIndex);
    }

    @Override
    public short CallableStatement_getShort(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getShort(parameterIndex);
    }

    @Override
    public int CallableStatement_getInt(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getInt(parameterIndex);
    }

    @Override
    public long CallableStatement_getLong(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getLong(parameterIndex);
    }

    @Override
    public float CallableStatement_getFloat(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getFloat(parameterIndex);
    }

    @Override
    public double CallableStatement_getDouble(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getDouble(parameterIndex);
    }

    @Override
    public BigDecimal CallableStatement_getBigDecimal(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex, int scale) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getBigDecimal(parameterIndex, scale);
    }

    @Override
    public byte[] CallableStatement_getBytes(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getBytes(parameterIndex);
    }

    @Override
    public Date CallableStatement_getDate(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getDate(parameterIndex);
    }

    @Override
    public Time CallableStatement_getTime(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getTime(parameterIndex);
    }

    @Override
    public Timestamp CallableStatement_getTimestamp(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getTimestamp(parameterIndex);
    }

    @Override
    public Object CallableStatement_getObject(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getObject(parameterIndex);
    }

    @Override
    public BigDecimal CallableStatement_getBigDecimal(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getBigDecimal(parameterIndex);
    }

    @Override
    public Object CallableStatement_getObject(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getObject(parameterIndex, map);
    }

    @Override
    public Ref CallableStatement_getRef(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getRef(parameterIndex);
    }

    @Override
    public Blob CallableStatement_getBlob(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getBlob(parameterIndex);
    }

    @Override
    public Clob CallableStatement_getClob(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getClob(parameterIndex);
    }

    @Override
    public Array CallableStatement_getArray(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getArray(parameterIndex);
    }

    @Override
    public Date CallableStatement_getDate(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex, Calendar cal) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getDate(parameterIndex, cal);
    }

    @Override
    public Time CallableStatement_getTime(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex, Calendar cal) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getTime(parameterIndex, cal);
    }

    @Override
    public Timestamp CallableStatement_getTimestamp(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex, Calendar cal) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getTimestamp(parameterIndex, cal);
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex, int sqlType, String typeName) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_registerOutParameter(parameterIndex, sqlType, typeName);
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, int sqlType) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_registerOutParameter(parameterName, sqlType);
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, int sqlType, int scale) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_registerOutParameter(parameterName, sqlType, scale);
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, int sqlType, String typeName) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_registerOutParameter(parameterName, sqlType, typeName);
    }

    @Override
    public URL CallableStatement_getURL(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getURL(parameterIndex);
    }

    @Override
    public void CallableStatement_setURL(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, URL val) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_setURL(parameterName, val);
    }

    @Override
    public void CallableStatement_setNull(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, int sqlType) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_setNull(parameterName, sqlType);
    }

    @Override
    public void CallableStatement_setBoolean(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, boolean x2) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_setBoolean(parameterName, x2);
    }

    @Override
    public void CallableStatement_setByte(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, byte x2) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_setByte(parameterName, x2);
    }

    @Override
    public void CallableStatement_setShort(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, short x2) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_setShort(parameterName, x2);
    }

    @Override
    public void CallableStatement_setInt(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, int x2) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_setInt(parameterName, x2);
    }

    @Override
    public void CallableStatement_setLong(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, long x2) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_setLong(parameterName, x2);
    }

    @Override
    public void CallableStatement_setFloat(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, float x2) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_setFloat(parameterName, x2);
    }

    @Override
    public void CallableStatement_setDouble(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, double x2) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_setDouble(parameterName, x2);
    }

    @Override
    public void CallableStatement_setBigDecimal(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, BigDecimal x2) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_setBigDecimal(parameterName, x2);
    }

    @Override
    public void CallableStatement_setString(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, String x2) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_setString(parameterName, x2);
    }

    @Override
    public void CallableStatement_setBytes(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, byte[] x2) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_setBytes(parameterName, x2);
    }

    @Override
    public void CallableStatement_setDate(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Date x2) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_setDate(parameterName, x2);
    }

    @Override
    public void CallableStatement_setTime(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Time x2) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_setTime(parameterName, x2);
    }

    @Override
    public void CallableStatement_setTimestamp(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Timestamp x2) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_setTimestamp(parameterName, x2);
    }

    @Override
    public void CallableStatement_setAsciiStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, InputStream x2, int length) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_setAsciiStream(parameterName, x2, length);
    }

    @Override
    public void CallableStatement_setBinaryStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, InputStream x2, int length) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_setBinaryStream(parameterName, x2, length);
    }

    @Override
    public void CallableStatement_setObject(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Object x2, int targetSqlType, int scale) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_setObject(parameterName, x2, targetSqlType, scale);
    }

    @Override
    public void CallableStatement_setObject(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Object x2, int targetSqlType) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_setObject(parameterName, x2, targetSqlType);
    }

    @Override
    public void CallableStatement_setObject(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Object x2) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_setObject(parameterName, x2);
    }

    @Override
    public void CallableStatement_setCharacterStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Reader reader, int length) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_setCharacterStream(parameterName, reader, length);
    }

    @Override
    public void CallableStatement_setDate(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Date x2, Calendar cal) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_setDate(parameterName, x2, cal);
    }

    @Override
    public void CallableStatement_setTime(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Time x2, Calendar cal) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_setTime(parameterName, x2, cal);
    }

    @Override
    public void CallableStatement_setTimestamp(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Timestamp x2, Calendar cal) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_setTimestamp(parameterName, x2, cal);
    }

    @Override
    public void CallableStatement_setNull(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, int sqlType, String typeName) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_setNull(parameterName, sqlType, typeName);
    }

    @Override
    public String CallableStatement_getString(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getString(parameterName);
    }

    @Override
    public boolean CallableStatement_getBoolean(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getBoolean(parameterName);
    }

    @Override
    public byte CallableStatement_getByte(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getByte(parameterName);
    }

    @Override
    public short CallableStatement_getShort(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getShort(parameterName);
    }

    @Override
    public int CallableStatement_getInt(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getInt(parameterName);
    }

    @Override
    public long CallableStatement_getLong(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getLong(parameterName);
    }

    @Override
    public float CallableStatement_getFloat(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getFloat(parameterName);
    }

    @Override
    public double CallableStatement_getDouble(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getDouble(parameterName);
    }

    @Override
    public byte[] CallableStatement_getBytes(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getBytes(parameterName);
    }

    @Override
    public Date CallableStatement_getDate(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getDate(parameterName);
    }

    @Override
    public Time CallableStatement_getTime(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getTime(parameterName);
    }

    @Override
    public Timestamp CallableStatement_getTimestamp(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getTimestamp(parameterName);
    }

    @Override
    public Object CallableStatement_getObject(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getObject(parameterName);
    }

    @Override
    public BigDecimal CallableStatement_getBigDecimal(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getBigDecimal(parameterName);
    }

    @Override
    public Object CallableStatement_getObject(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Map<String, Class<?>> map) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getObject(parameterName, map);
    }

    @Override
    public Ref CallableStatement_getRef(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getRef(parameterName);
    }

    @Override
    public Blob CallableStatement_getBlob(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getBlob(parameterName);
    }

    @Override
    public Clob CallableStatement_getClob(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getClob(parameterName);
    }

    @Override
    public Array CallableStatement_getArray(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getArray(parameterName);
    }

    @Override
    public Date CallableStatement_getDate(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Calendar cal) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getDate(parameterName, cal);
    }

    @Override
    public Time CallableStatement_getTime(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Calendar cal) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getTime(parameterName, cal);
    }

    @Override
    public Timestamp CallableStatement_getTimestamp(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Calendar cal) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getTimestamp(parameterName, cal);
    }

    @Override
    public URL CallableStatement_getURL(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getURL(parameterName);
    }

    @Override
    public RowId CallableStatement_getRowId(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getRowId(parameterIndex);
    }

    @Override
    public RowId CallableStatement_getRowId(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getRowId(parameterName);
    }

    @Override
    public void CallableStatement_setRowId(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, RowId x2) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_setRowId(parameterName, x2);
    }

    @Override
    public void CallableStatement_setNString(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, String value) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_setNString(parameterName, value);
    }

    @Override
    public void CallableStatement_setNCharacterStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Reader value, long length) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_setNCharacterStream(parameterName, value, length);
    }

    @Override
    public void CallableStatement_setNClob(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, NClob value) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_setNClob(parameterName, value);
    }

    @Override
    public void CallableStatement_setClob(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Reader reader, long length) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_setClob(parameterName, reader, length);
    }

    @Override
    public void CallableStatement_setBlob(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, InputStream inputStream, long length) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_setBlob(parameterName, inputStream, length);
    }

    @Override
    public void CallableStatement_setNClob(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Reader reader, long length) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_setNClob(parameterName, reader, length);
    }

    @Override
    public NClob CallableStatement_getNClob(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getNClob(parameterIndex);
    }

    @Override
    public NClob CallableStatement_getNClob(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getNClob(parameterName);
    }

    @Override
    public void CallableStatement_setSQLXML(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, SQLXML xmlObject) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_setSQLXML(parameterName, xmlObject);
    }

    @Override
    public SQLXML CallableStatement_getSQLXML(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getSQLXML(parameterIndex);
    }

    @Override
    public SQLXML CallableStatement_getSQLXML(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getSQLXML(parameterName);
    }

    @Override
    public String CallableStatement_getNString(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getNString(parameterIndex);
    }

    @Override
    public String CallableStatement_getNString(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getNString(parameterName);
    }

    @Override
    public Reader CallableStatement_getNCharacterStream(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getNCharacterStream(parameterIndex);
    }

    @Override
    public Reader CallableStatement_getNCharacterStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getNCharacterStream(parameterName);
    }

    @Override
    public Reader CallableStatement_getCharacterStream(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getCharacterStream(parameterIndex);
    }

    @Override
    public Reader CallableStatement_getCharacterStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getCharacterStream(parameterName);
    }

    @Override
    public void CallableStatement_setBlob(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Blob x2) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_setBlob(parameterName, x2);
    }

    @Override
    public void CallableStatement_setClob(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Clob x2) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_setClob(parameterName, x2);
    }

    @Override
    public void CallableStatement_setAsciiStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, InputStream x2, long length) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_setAsciiStream(parameterName, x2, length);
    }

    @Override
    public void CallableStatement_setBinaryStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, InputStream x2, long length) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_setBinaryStream(parameterName, x2, length);
    }

    @Override
    public void CallableStatement_setCharacterStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Reader reader, long length) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_setCharacterStream(parameterName, reader, length);
    }

    @Override
    public void CallableStatement_setAsciiStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, InputStream x2) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_setAsciiStream(parameterName, x2);
    }

    @Override
    public void CallableStatement_setBinaryStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, InputStream x2) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_setBinaryStream(parameterName, x2);
    }

    @Override
    public void CallableStatement_setCharacterStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Reader reader) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_setCharacterStream(parameterName, reader);
    }

    @Override
    public void CallableStatement_setNCharacterStream(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Reader value) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_setNCharacterStream(parameterName, value);
    }

    @Override
    public void CallableStatement_setClob(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Reader reader) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_setClob(parameterName, reader);
    }

    @Override
    public void CallableStatement_setBlob(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, InputStream inputStream) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_setBlob(parameterName, inputStream);
    }

    @Override
    public void CallableStatement_setNClob(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Reader reader) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_setNClob(parameterName, reader);
    }

    @Override
    public <T> T CallableStatement_getObject(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex, Class<T> type) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getObject(parameterIndex, type);
    }

    @Override
    public <T> T CallableStatement_getObject(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Class<T> type) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getObject(parameterName, type);
    }

    @Override
    public void CallableStatement_setObject(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Object x2, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_setObject(parameterName, x2, targetSqlType, scaleOrLength);
    }

    @Override
    public void CallableStatement_setObject(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, Object x2, SQLType targetSqlType) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_setObject(parameterName, x2, targetSqlType);
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex, SQLType sqlType) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_registerOutParameter(parameterIndex, sqlType);
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex, SQLType sqlType, int scale) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_registerOutParameter(parameterIndex, sqlType, scale);
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex, SQLType sqlType, String typeName) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_registerOutParameter(parameterIndex, sqlType, typeName);
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, SQLType sqlType) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_registerOutParameter(parameterName, sqlType);
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, SQLType sqlType, int scale) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_registerOutParameter(parameterName, sqlType, scale);
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName, SQLType sqlType, String typeName) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_registerOutParameter(parameterName, sqlType, typeName);
    }

    @Override
    public DmdbIntervalYM CallableStatement_getINTERVALYM(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getINTERVALYM(parameterIndex);
    }

    @Override
    public DmdbIntervalDT CallableStatement_getINTERVALDT(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getINTERVALDT(parameterIndex);
    }

    @Override
    public DmdbTimestamp CallableStatement_getTIMESTAMP(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getTIMESTAMP(parameterIndex);
    }

    @Override
    public ResultSet CallableStatement_getCursor(FilterChain filterChain, DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getCursor(parameterIndex);
    }

    @Override
    public long Clob_length(FilterChain filterChain, DmdbClob clob) throws SQLException {
        return clob.do_length();
    }

    @Override
    public String Clob_getSubString(FilterChain filterChain, DmdbClob clob, long pos, int length) throws SQLException {
        return clob.do_getSubString(pos, length);
    }

    @Override
    public Reader Clob_getCharacterStream(FilterChain filterChain, DmdbClob clob) throws SQLException {
        return clob.do_getCharacterStream();
    }

    @Override
    public InputStream Clob_getAsciiStream(FilterChain filterChain, DmdbClob clob) throws SQLException {
        return clob.do_getAsciiStream();
    }

    @Override
    public long Clob_position(FilterChain filterChain, DmdbClob clob, String searchstr, long start) throws SQLException {
        return clob.do_position(searchstr, start);
    }

    @Override
    public long Clob_position(FilterChain filterChain, DmdbClob clob, Clob searchstr, long start) throws SQLException {
        return clob.do_position(searchstr, start);
    }

    @Override
    public int Clob_setString(FilterChain filterChain, DmdbClob clob, long pos, String str) throws SQLException {
        return clob.do_setString(pos, str);
    }

    @Override
    public int Clob_setString(FilterChain filterChain, DmdbClob clob, long pos, String str, int offset, int len) throws SQLException {
        return clob.do_setString(pos, str, offset, len);
    }

    @Override
    public OutputStream Clob_setAsciiStream(FilterChain filterChain, DmdbClob clob, long pos) throws SQLException {
        return clob.do_setAsciiStream(pos);
    }

    @Override
    public Writer Clob_setCharacterStream(FilterChain filterChain, DmdbClob clob, long pos) throws SQLException {
        return clob.do_setCharacterStream(pos);
    }

    @Override
    public void Clob_truncate(FilterChain filterChain, DmdbClob clob, long len) throws SQLException {
        clob.do_truncate(len);
    }

    @Override
    public void Clob_free(FilterChain filterChain, DmdbClob clob) throws SQLException {
        clob.do_free();
    }

    @Override
    public Reader Clob_getCharacterStream(FilterChain filterChain, DmdbClob clob, long pos, long length) throws SQLException {
        return clob.do_getCharacterStream(pos, length);
    }

    @Override
    public void Connection_reconnect(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        RWUtil2.reconnect(connection);
    }

    @Override
    public Statement Connection_createStatement(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        DmdbStatement statement;
        statement.rwInfo.stmtCurrent = statement = connection.do_createStatement();
        statement.rwInfo.readOnly = RWUtil2.checkReadonly(statement, null);
        try {
            if (RWUtil2.isCreateStandbyStmt(statement)) {
                statement.rwInfo.stmtStandby = connection.rwInfo.connStandby.do_createStatement();
            }
        }
        catch (SQLException e2) {
            RWUtil2.afterExceptionOnStandby(connection, e2);
        }
        return statement;
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain filterChain, DmdbConnection connection, String sql) throws SQLException {
        DmdbPreparedStatement preparedStatement = connection.do_prepareStatement(sql);
        preparedStatement.rwInfo.stmtCurrent = preparedStatement;
        preparedStatement.rwInfo.readOnly = RWUtil2.checkReadonly(preparedStatement, sql);
        try {
            if (RWUtil2.isCreateStandbyStmt(preparedStatement)) {
                preparedStatement.rwInfo.stmtCurrent = preparedStatement.rwInfo.stmtStandby = connection.rwInfo.connStandby.do_prepareStatement(sql);
            }
        }
        catch (SQLException e2) {
            RWUtil2.afterExceptionOnStandby(connection, e2);
        }
        return preparedStatement;
    }

    @Override
    public CallableStatement Connection_prepareCall(FilterChain filterChain, DmdbConnection connection, String sql) throws SQLException {
        DmdbCallableStatement callableStatement = connection.do_prepareCall(sql);
        callableStatement.rwInfo.stmtCurrent = callableStatement;
        callableStatement.rwInfo.readOnly = RWUtil2.checkReadonly(callableStatement, sql);
        try {
            if (RWUtil2.isCreateStandbyStmt(callableStatement)) {
                callableStatement.rwInfo.stmtCurrent = callableStatement.rwInfo.stmtStandby = connection.rwInfo.connStandby.do_prepareCall(sql);
            }
        }
        catch (SQLException e2) {
            RWUtil2.afterExceptionOnStandby(connection, e2);
        }
        return callableStatement;
    }

    @Override
    public String Connection_nativeSQL(FilterChain filterChain, DmdbConnection connection, String sql) throws SQLException {
        return connection.do_nativeSQL(sql);
    }

    @Override
    public void Connection_setAutoCommit(FilterChain filterChain, DmdbConnection connection, boolean autoCommit) throws SQLException {
        if (RWUtil2.isStandbyAlive(connection)) {
            connection.rwInfo.connStandby.do_setAutoCommit(autoCommit);
        }
        connection.do_setAutoCommit(autoCommit);
    }

    @Override
    public boolean Connection_getAutoCommit(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        return connection.do_getAutoCommit();
    }

    @Override
    public void Connection_commit(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        try {
            if (RWUtil2.isStandbyAlive(connection)) {
                connection.rwInfo.connStandby.do_commit();
            }
        }
        catch (SQLException e2) {
            RWUtil2.afterExceptionOnStandby(connection, e2);
        }
        connection.do_commit();
    }

    @Override
    public void Connection_rollback(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        try {
            if (RWUtil2.isStandbyAlive(connection)) {
                connection.rwInfo.connStandby.do_rollback();
            }
        }
        catch (SQLException e2) {
            RWUtil2.afterExceptionOnStandby(connection, e2);
        }
        connection.do_rollback();
    }

    @Override
    public void Connection_close(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        try {
            if (RWUtil2.isStandbyAlive(connection)) {
                connection.rwInfo.connStandby.do_close();
            }
        }
        catch (SQLException sQLException) {}
        connection.do_close();
    }

    @Override
    public boolean Connection_isClosed(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        return filterChain.Connection_isClosed(connection);
    }

    @Override
    public DatabaseMetaData Connection_getMetaData(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        return connection.do_getMetaData();
    }

    @Override
    public void Connection_setReadOnly(FilterChain filterChain, DmdbConnection connection, boolean readOnly) throws SQLException {
        if (connection.rwInfo.connStandby != null) {
            connection.rwInfo.connStandby.do_setReadOnly(readOnly);
        }
        connection.do_setReadOnly(readOnly);
    }

    @Override
    public boolean Connection_isReadOnly(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        return connection.do_isReadOnly();
    }

    @Override
    public void Connection_setCatalog(FilterChain filterChain, DmdbConnection connection, String catalog) throws SQLException {
        if (RWUtil2.isStandbyAlive(connection)) {
            connection.rwInfo.connStandby.do_setCatalog(catalog);
        }
        connection.do_setCatalog(catalog);
    }

    @Override
    public String Connection_getCatalog(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        return connection.do_getCatalog();
    }

    @Override
    public void Connection_setTransactionIsolation(FilterChain filterChain, DmdbConnection connection, int level) throws SQLException {
        try {
            if (RWUtil2.isStandbyAlive(connection)) {
                connection.rwInfo.connStandby.do_setTransactionIsolation(level);
            }
        }
        catch (SQLException e2) {
            RWUtil2.afterExceptionOnStandby(connection, e2);
        }
        connection.do_setTransactionIsolation(level);
    }

    @Override
    public int Connection_getTransactionIsolation(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        return connection.do_getTransactionIsolation();
    }

    @Override
    public SQLWarning Connection_getWarnings(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        return connection.do_getWarnings();
    }

    @Override
    public void Connection_clearWarnings(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        if (connection.rwInfo.connStandby != null) {
            connection.rwInfo.connStandby.do_clearWarnings();
        }
        connection.do_clearWarnings();
    }

    @Override
    public Statement Connection_createStatement(FilterChain filterChain, DmdbConnection connection, int resultSetType, int resultSetConcurrency) throws SQLException {
        DmdbStatement statement;
        statement.rwInfo.stmtCurrent = statement = connection.do_createStatement(resultSetType, resultSetConcurrency);
        statement.rwInfo.readOnly = RWUtil2.checkReadonly(statement, null);
        try {
            if (RWUtil2.isCreateStandbyStmt(statement)) {
                statement.rwInfo.stmtStandby = connection.rwInfo.connStandby.do_createStatement(resultSetType, resultSetConcurrency);
            }
        }
        catch (SQLException e2) {
            RWUtil2.afterExceptionOnStandby(connection, e2);
        }
        return statement;
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain filterChain, DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        DmdbPreparedStatement preparedStatement = connection.do_prepareStatement(sql, resultSetType, resultSetConcurrency);
        preparedStatement.rwInfo.stmtCurrent = preparedStatement;
        preparedStatement.rwInfo.readOnly = RWUtil2.checkReadonly(preparedStatement, sql);
        try {
            if (RWUtil2.isCreateStandbyStmt(preparedStatement)) {
                preparedStatement.rwInfo.stmtCurrent = preparedStatement.rwInfo.stmtStandby = connection.rwInfo.connStandby.do_prepareStatement(sql, resultSetType, resultSetConcurrency);
            }
        }
        catch (SQLException e2) {
            RWUtil2.afterExceptionOnStandby(connection, e2);
        }
        return preparedStatement;
    }

    @Override
    public CallableStatement Connection_prepareCall(FilterChain filterChain, DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        DmdbCallableStatement callableStatement = connection.do_prepareCall(sql, resultSetType, resultSetConcurrency);
        callableStatement.rwInfo.stmtCurrent = callableStatement;
        callableStatement.rwInfo.readOnly = RWUtil2.checkReadonly(callableStatement, sql);
        try {
            if (RWUtil2.isCreateStandbyStmt(callableStatement)) {
                callableStatement.rwInfo.stmtCurrent = callableStatement.rwInfo.stmtStandby = connection.rwInfo.connStandby.do_prepareCall(sql, resultSetType, resultSetConcurrency);
            }
        }
        catch (SQLException e2) {
            RWUtil2.afterExceptionOnStandby(connection, e2);
        }
        return callableStatement;
    }

    @Override
    public Map<String, Class<?>> Connection_getTypeMap(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        return connection.do_getTypeMap();
    }

    @Override
    public void Connection_setTypeMap(FilterChain filterChain, DmdbConnection connection, Map<String, Class<?>> map) throws SQLException {
        if (connection.rwInfo.connStandby != null) {
            connection.rwInfo.connStandby.do_setTypeMap(map);
        }
        connection.do_setTypeMap(map);
    }

    @Override
    public void Connection_setHoldability(FilterChain filterChain, DmdbConnection connection, int holdability) throws SQLException {
        if (connection.rwInfo.connStandby != null) {
            connection.rwInfo.connStandby.do_setHoldability(holdability);
        }
        connection.do_setHoldability(holdability);
    }

    @Override
    public int Connection_getHoldability(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        return connection.do_getHoldability();
    }

    @Override
    public Savepoint Connection_setSavepoint(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        DmdbSavepoint sp = connection.do_setSavepoint();
        try {
            if (RWUtil2.isStandbyAlive(connection)) {
                sp.standby = connection.rwInfo.connStandby.do_setSavepoint();
            }
        }
        catch (SQLException e2) {
            RWUtil2.afterExceptionOnStandby(connection, e2);
        }
        return sp;
    }

    @Override
    public Savepoint Connection_setSavepoint(FilterChain filterChain, DmdbConnection connection, String name) throws SQLException {
        DmdbSavepoint sp = connection.do_setSavepoint(name);
        try {
            if (RWUtil2.isStandbyAlive(connection)) {
                sp.standby = connection.rwInfo.connStandby.do_setSavepoint(name);
            }
        }
        catch (SQLException e2) {
            RWUtil2.afterExceptionOnStandby(connection, e2);
        }
        return sp;
    }

    @Override
    public void Connection_rollback(FilterChain filterChain, DmdbConnection connection, Savepoint savepoint) throws SQLException {
        try {
            if (RWUtil2.isStandbyAlive(connection)) {
                connection.rwInfo.connStandby.do_rollback(((DmdbSavepoint)savepoint).standby);
            }
        }
        catch (SQLException e2) {
            RWUtil2.afterExceptionOnStandby(connection, e2);
        }
        connection.do_rollback(savepoint);
    }

    @Override
    public void Connection_releaseSavepoint(FilterChain filterChain, DmdbConnection connection, Savepoint savepoint) throws SQLException {
        try {
            if (RWUtil2.isStandbyAlive(connection)) {
                connection.rwInfo.connStandby.do_releaseSavepoint(((DmdbSavepoint)savepoint).standby);
            }
        }
        catch (SQLException e2) {
            RWUtil2.afterExceptionOnStandby(connection, e2);
        }
        connection.do_releaseSavepoint(savepoint);
    }

    @Override
    public Statement Connection_createStatement(FilterChain filterChain, DmdbConnection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        DmdbStatement statement;
        statement.rwInfo.stmtCurrent = statement = connection.do_createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        statement.rwInfo.readOnly = RWUtil2.checkReadonly(statement, null);
        try {
            if (RWUtil2.isCreateStandbyStmt(statement)) {
                statement.rwInfo.stmtStandby = connection.rwInfo.connStandby.do_createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
            }
        }
        catch (SQLException e2) {
            RWUtil2.afterExceptionOnStandby(connection, e2);
        }
        return statement;
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain filterChain, DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        DmdbPreparedStatement preparedStatement = connection.do_prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        preparedStatement.rwInfo.stmtCurrent = preparedStatement;
        preparedStatement.rwInfo.readOnly = RWUtil2.checkReadonly(preparedStatement, sql);
        try {
            if (RWUtil2.isCreateStandbyStmt(preparedStatement)) {
                preparedStatement.rwInfo.stmtCurrent = preparedStatement.rwInfo.stmtStandby = connection.rwInfo.connStandby.do_prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            }
        }
        catch (SQLException e2) {
            RWUtil2.afterExceptionOnStandby(connection, e2);
        }
        return preparedStatement;
    }

    @Override
    public CallableStatement Connection_prepareCall(FilterChain filterChain, DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        DmdbCallableStatement callableStatement = connection.do_prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        callableStatement.rwInfo.stmtCurrent = callableStatement;
        callableStatement.rwInfo.readOnly = RWUtil2.checkReadonly(callableStatement, sql);
        try {
            if (RWUtil2.isCreateStandbyStmt(callableStatement)) {
                callableStatement.rwInfo.stmtCurrent = callableStatement.rwInfo.stmtStandby = connection.rwInfo.connStandby.do_prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            }
        }
        catch (SQLException e2) {
            RWUtil2.afterExceptionOnStandby(connection, e2);
        }
        return callableStatement;
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain filterChain, DmdbConnection connection, String sql, int autoGeneratedKeys) throws SQLException {
        DmdbPreparedStatement preparedStatement = connection.do_prepareStatement(sql, autoGeneratedKeys);
        preparedStatement.rwInfo.stmtCurrent = preparedStatement;
        preparedStatement.rwInfo.readOnly = RWUtil2.checkReadonly(preparedStatement, sql);
        try {
            if (RWUtil2.isCreateStandbyStmt(preparedStatement)) {
                preparedStatement.rwInfo.stmtCurrent = preparedStatement.rwInfo.stmtStandby = connection.rwInfo.connStandby.do_prepareStatement(sql, autoGeneratedKeys);
            }
        }
        catch (SQLException e2) {
            RWUtil2.afterExceptionOnStandby(connection, e2);
        }
        return preparedStatement;
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain filterChain, DmdbConnection connection, String sql, int[] columnIndexes) throws SQLException {
        DmdbPreparedStatement preparedStatement = connection.do_prepareStatement(sql, columnIndexes);
        preparedStatement.rwInfo.stmtCurrent = preparedStatement;
        preparedStatement.rwInfo.readOnly = RWUtil2.checkReadonly(preparedStatement, sql);
        try {
            if (RWUtil2.isCreateStandbyStmt(preparedStatement)) {
                preparedStatement.rwInfo.stmtCurrent = preparedStatement.rwInfo.stmtStandby = connection.rwInfo.connStandby.do_prepareStatement(sql, columnIndexes);
            }
        }
        catch (SQLException e2) {
            RWUtil2.afterExceptionOnStandby(connection, e2);
        }
        return preparedStatement;
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain filterChain, DmdbConnection connection, String sql, String[] columnNames) throws SQLException {
        DmdbPreparedStatement preparedStatement = connection.do_prepareStatement(sql, columnNames);
        preparedStatement.rwInfo.stmtCurrent = preparedStatement;
        preparedStatement.rwInfo.readOnly = RWUtil2.checkReadonly(preparedStatement, sql);
        try {
            if (RWUtil2.isCreateStandbyStmt(preparedStatement)) {
                preparedStatement.rwInfo.stmtCurrent = preparedStatement.rwInfo.stmtStandby = connection.rwInfo.connStandby.do_prepareStatement(sql, columnNames);
            }
        }
        catch (SQLException e2) {
            RWUtil2.afterExceptionOnStandby(connection, e2);
        }
        return preparedStatement;
    }

    @Override
    public Clob Connection_createClob(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        return connection.do_createClob();
    }

    @Override
    public Blob Connection_createBlob(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        return connection.do_createBlob();
    }

    @Override
    public NClob Connection_createNClob(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        return connection.do_createNClob();
    }

    @Override
    public SQLXML Connection_createSQLXML(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        return connection.do_createSQLXML();
    }

    @Override
    public boolean Connection_isValid(FilterChain filterChain, DmdbConnection connection, int timeout) throws SQLException {
        return connection.do_isValid(timeout);
    }

    @Override
    public void Connection_setClientInfo(FilterChain filterChain, DmdbConnection connection, String name, String value) throws SQLClientInfoException {
        connection.do_setClientInfo(name, value);
    }

    @Override
    public void Connection_setClientInfo(FilterChain filterChain, DmdbConnection connection, Properties properties) throws SQLClientInfoException {
        connection.do_setClientInfo(properties);
    }

    @Override
    public String Connection_getClientInfo(FilterChain filterChain, DmdbConnection connection, String name) throws SQLException {
        return connection.do_getClientInfo(name);
    }

    @Override
    public Properties Connection_getClientInfo(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        return connection.do_getClientInfo();
    }

    @Override
    public Array Connection_createArrayOf(FilterChain filterChain, DmdbConnection connection, String typeName, Object[] elements) throws SQLException {
        return connection.do_createArrayOf(typeName, elements);
    }

    @Override
    public Struct Connection_createStruct(FilterChain filterChain, DmdbConnection connection, String typeName, Object[] attributes) throws SQLException {
        return connection.do_createStruct(typeName, attributes);
    }

    @Override
    public void Connection_setSchema(FilterChain filterChain, DmdbConnection connection, String schema) throws SQLException {
        try {
            if (RWUtil2.isStandbyAlive(connection)) {
                connection.rwInfo.connStandby.do_setSchema(schema);
            }
        }
        catch (SQLException e2) {
            RWUtil2.afterExceptionOnStandby(connection, e2);
        }
        connection.do_setSchema(schema);
    }

    @Override
    public String Connection_getSchema(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        return connection.do_getSchema();
    }

    @Override
    public void Connection_abort(FilterChain filterChain, final DmdbConnection connection, Executor executor) throws SQLException {
        SecurityManager sec = System.getSecurityManager();
        if (sec != null) {
            sec.checkPermission(DmdbConnection.ABORT_PERMISSION);
        }
        if (executor == null) {
            try {
                if (RWUtil2.isStandbyAlive(connection)) {
                    connection.rwInfo.connStandby.do_abort(null);
                }
            }
            catch (SQLException sQLException) {}
            connection.do_abort(null);
            return;
        }
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (RWUtil2.isStandbyAlive(connection)) {
                        connection.rwInfo.connStandby.do_abort(null);
                    }
                }
                catch (SQLException sQLException) {}
                try {
                    connection.do_abort(null);
                }
                catch (SQLException sQLException) {}
            }
        });
    }

    @Override
    public void Connection_setNetworkTimeout(FilterChain filterChain, DmdbConnection connection, Executor executor, int milliseconds) throws SQLException {
        if (RWUtil2.isStandbyAlive(connection)) {
            connection.rwInfo.connStandby.do_setNetworkTimeout(executor, milliseconds);
        }
        connection.do_setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public int Connection_getNetworkTimeout(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        return connection.do_getNetworkTimeout();
    }

    @Override
    public boolean DatabaseMetaData_allProceduresAreCallable(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_allProceduresAreCallable();
    }

    @Override
    public boolean DatabaseMetaData_allTablesAreSelectable(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_allTablesAreSelectable();
    }

    @Override
    public String DatabaseMetaData_getURL(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_getURL();
    }

    @Override
    public String DatabaseMetaData_getUserName(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_getUserName();
    }

    @Override
    public boolean DatabaseMetaData_isReadOnly(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_isReadOnly();
    }

    @Override
    public boolean DatabaseMetaData_nullsAreSortedHigh(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_nullsAreSortedHigh();
    }

    @Override
    public boolean DatabaseMetaData_nullsAreSortedLow(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_nullsAreSortedLow();
    }

    @Override
    public boolean DatabaseMetaData_nullsAreSortedAtStart(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_nullsAreSortedAtStart();
    }

    @Override
    public boolean DatabaseMetaData_nullsAreSortedAtEnd(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_nullsAreSortedAtEnd();
    }

    @Override
    public String DatabaseMetaData_getDatabaseProductName(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_getDatabaseProductName();
    }

    @Override
    public String DatabaseMetaData_getDatabaseProductVersion(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_getDatabaseProductVersion();
    }

    @Override
    public String DatabaseMetaData_getDriverName(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_getDriverName();
    }

    @Override
    public String DatabaseMetaData_getDriverVersion(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_getDriverVersion();
    }

    @Override
    public int DatabaseMetaData_getDriverMajorVersion(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) {
        return databaseMetaData.do_getDriverMajorVersion();
    }

    @Override
    public int DatabaseMetaData_getDriverMinorVersion(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) {
        return databaseMetaData.do_getDriverMinorVersion();
    }

    @Override
    public boolean DatabaseMetaData_usesLocalFiles(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_usesLocalFiles();
    }

    @Override
    public boolean DatabaseMetaData_usesLocalFilePerTable(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_usesLocalFilePerTable();
    }

    @Override
    public boolean DatabaseMetaData_supportsMixedCaseIdentifiers(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsMixedCaseIdentifiers();
    }

    @Override
    public boolean DatabaseMetaData_storesUpperCaseIdentifiers(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_storesUpperCaseIdentifiers();
    }

    @Override
    public boolean DatabaseMetaData_storesLowerCaseIdentifiers(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_storesLowerCaseIdentifiers();
    }

    @Override
    public boolean DatabaseMetaData_storesMixedCaseIdentifiers(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_storesMixedCaseIdentifiers();
    }

    @Override
    public boolean DatabaseMetaData_supportsMixedCaseQuotedIdentifiers(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsMixedCaseQuotedIdentifiers();
    }

    @Override
    public boolean DatabaseMetaData_storesUpperCaseQuotedIdentifiers(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_storesUpperCaseQuotedIdentifiers();
    }

    @Override
    public boolean DatabaseMetaData_storesLowerCaseQuotedIdentifiers(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_storesLowerCaseQuotedIdentifiers();
    }

    @Override
    public boolean DatabaseMetaData_storesMixedCaseQuotedIdentifiers(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_storesMixedCaseQuotedIdentifiers();
    }

    @Override
    public String DatabaseMetaData_getIdentifierQuoteString(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_getIdentifierQuoteString();
    }

    @Override
    public String DatabaseMetaData_getSQLKeywords(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_getSQLKeywords();
    }

    @Override
    public String DatabaseMetaData_getNumericFunctions(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_getNumericFunctions();
    }

    @Override
    public String DatabaseMetaData_getStringFunctions(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_getStringFunctions();
    }

    @Override
    public String DatabaseMetaData_getSystemFunctions(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_getSystemFunctions();
    }

    @Override
    public String DatabaseMetaData_getTimeDateFunctions(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_getTimeDateFunctions();
    }

    @Override
    public String DatabaseMetaData_getSearchStringEscape(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_getSearchStringEscape();
    }

    @Override
    public String DatabaseMetaData_getExtraNameCharacters(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_getExtraNameCharacters();
    }

    @Override
    public boolean DatabaseMetaData_supportsAlterTableWithAddColumn(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsAlterTableWithAddColumn();
    }

    @Override
    public boolean DatabaseMetaData_supportsAlterTableWithDropColumn(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsAlterTableWithDropColumn();
    }

    @Override
    public boolean DatabaseMetaData_supportsColumnAliasing(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsColumnAliasing();
    }

    @Override
    public boolean DatabaseMetaData_nullPlusNonNullIsNull(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_nullPlusNonNullIsNull();
    }

    @Override
    public boolean DatabaseMetaData_supportsConvert(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsConvert();
    }

    @Override
    public boolean DatabaseMetaData_supportsConvert(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, int fromType, int toType) throws SQLException {
        return databaseMetaData.do_supportsConvert(fromType, toType);
    }

    @Override
    public boolean DatabaseMetaData_supportsTableCorrelationNames(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsTableCorrelationNames();
    }

    @Override
    public boolean DatabaseMetaData_supportsDifferentTableCorrelationNames(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsDifferentTableCorrelationNames();
    }

    @Override
    public boolean DatabaseMetaData_supportsExpressionsInOrderBy(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsExpressionsInOrderBy();
    }

    @Override
    public boolean DatabaseMetaData_supportsOrderByUnrelated(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsOrderByUnrelated();
    }

    @Override
    public boolean DatabaseMetaData_supportsGroupBy(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsGroupBy();
    }

    @Override
    public boolean DatabaseMetaData_supportsGroupByUnrelated(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsGroupByUnrelated();
    }

    @Override
    public boolean DatabaseMetaData_supportsGroupByBeyondSelect(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsGroupByBeyondSelect();
    }

    @Override
    public boolean DatabaseMetaData_supportsLikeEscapeClause(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsLikeEscapeClause();
    }

    @Override
    public boolean DatabaseMetaData_supportsMultipleResultSets(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsMultipleResultSets();
    }

    @Override
    public boolean DatabaseMetaData_supportsMultipleTransactions(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsMultipleTransactions();
    }

    @Override
    public boolean DatabaseMetaData_supportsNonNullableColumns(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsNonNullableColumns();
    }

    @Override
    public boolean DatabaseMetaData_supportsMinimumSQLGrammar(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsMinimumSQLGrammar();
    }

    @Override
    public boolean DatabaseMetaData_supportsCoreSQLGrammar(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsCoreSQLGrammar();
    }

    @Override
    public boolean DatabaseMetaData_supportsExtendedSQLGrammar(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsExtendedSQLGrammar();
    }

    @Override
    public boolean DatabaseMetaData_supportsANSI92EntryLevelSQL(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsANSI92EntryLevelSQL();
    }

    @Override
    public boolean DatabaseMetaData_supportsANSI92IntermediateSQL(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsANSI92IntermediateSQL();
    }

    @Override
    public boolean DatabaseMetaData_supportsANSI92FullSQL(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsANSI92FullSQL();
    }

    @Override
    public boolean DatabaseMetaData_supportsIntegrityEnhancementFacility(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsIntegrityEnhancementFacility();
    }

    @Override
    public boolean DatabaseMetaData_supportsOuterJoins(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsOuterJoins();
    }

    @Override
    public boolean DatabaseMetaData_supportsFullOuterJoins(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsFullOuterJoins();
    }

    @Override
    public boolean DatabaseMetaData_supportsLimitedOuterJoins(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsLimitedOuterJoins();
    }

    @Override
    public String DatabaseMetaData_getSchemaTerm(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_getSchemaTerm();
    }

    @Override
    public String DatabaseMetaData_getProcedureTerm(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_getProcedureTerm();
    }

    @Override
    public String DatabaseMetaData_getCatalogTerm(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_getCatalogTerm();
    }

    @Override
    public boolean DatabaseMetaData_isCatalogAtStart(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_isCatalogAtStart();
    }

    @Override
    public String DatabaseMetaData_getCatalogSeparator(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_getCatalogSeparator();
    }

    @Override
    public boolean DatabaseMetaData_supportsSchemasInDataManipulation(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsSchemasInDataManipulation();
    }

    @Override
    public boolean DatabaseMetaData_supportsSchemasInProcedureCalls(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsSchemasInProcedureCalls();
    }

    @Override
    public boolean DatabaseMetaData_supportsSchemasInTableDefinitions(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsSchemasInTableDefinitions();
    }

    @Override
    public boolean DatabaseMetaData_supportsSchemasInIndexDefinitions(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsSchemasInIndexDefinitions();
    }

    @Override
    public boolean DatabaseMetaData_supportsSchemasInPrivilegeDefinitions(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsSchemasInPrivilegeDefinitions();
    }

    @Override
    public boolean DatabaseMetaData_supportsCatalogsInDataManipulation(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsCatalogsInDataManipulation();
    }

    @Override
    public boolean DatabaseMetaData_supportsCatalogsInProcedureCalls(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsCatalogsInProcedureCalls();
    }

    @Override
    public boolean DatabaseMetaData_supportsCatalogsInTableDefinitions(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsCatalogsInTableDefinitions();
    }

    @Override
    public boolean DatabaseMetaData_supportsCatalogsInIndexDefinitions(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsCatalogsInIndexDefinitions();
    }

    @Override
    public boolean DatabaseMetaData_supportsCatalogsInPrivilegeDefinitions(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsCatalogsInPrivilegeDefinitions();
    }

    @Override
    public boolean DatabaseMetaData_supportsPositionedDelete(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsPositionedDelete();
    }

    @Override
    public boolean DatabaseMetaData_supportsPositionedUpdate(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsPositionedUpdate();
    }

    @Override
    public boolean DatabaseMetaData_supportsSelectForUpdate(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsSelectForUpdate();
    }

    @Override
    public boolean DatabaseMetaData_supportsStoredProcedures(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsStoredProcedures();
    }

    @Override
    public boolean DatabaseMetaData_supportsSubqueriesInComparisons(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsSubqueriesInComparisons();
    }

    @Override
    public boolean DatabaseMetaData_supportsSubqueriesInExists(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsSubqueriesInExists();
    }

    @Override
    public boolean DatabaseMetaData_supportsSubqueriesInIns(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsSubqueriesInIns();
    }

    @Override
    public boolean DatabaseMetaData_supportsSubqueriesInQuantifieds(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsSubqueriesInQuantifieds();
    }

    @Override
    public boolean DatabaseMetaData_supportsCorrelatedSubqueries(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsCorrelatedSubqueries();
    }

    @Override
    public boolean DatabaseMetaData_supportsUnion(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsUnion();
    }

    @Override
    public boolean DatabaseMetaData_supportsUnionAll(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsUnionAll();
    }

    @Override
    public boolean DatabaseMetaData_supportsOpenCursorsAcrossCommit(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsOpenCursorsAcrossCommit();
    }

    @Override
    public boolean DatabaseMetaData_supportsOpenCursorsAcrossRollback(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsOpenCursorsAcrossRollback();
    }

    @Override
    public boolean DatabaseMetaData_supportsOpenStatementsAcrossCommit(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsOpenStatementsAcrossCommit();
    }

    @Override
    public boolean DatabaseMetaData_supportsOpenStatementsAcrossRollback(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsOpenStatementsAcrossRollback();
    }

    @Override
    public int DatabaseMetaData_getMaxBinaryLiteralLength(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_getMaxBinaryLiteralLength();
    }

    @Override
    public int DatabaseMetaData_getMaxCharLiteralLength(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_getMaxCharLiteralLength();
    }

    @Override
    public int DatabaseMetaData_getMaxColumnNameLength(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_getMaxColumnNameLength();
    }

    @Override
    public int DatabaseMetaData_getMaxColumnsInGroupBy(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_getMaxColumnsInGroupBy();
    }

    @Override
    public int DatabaseMetaData_getMaxColumnsInIndex(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_getMaxColumnsInIndex();
    }

    @Override
    public int DatabaseMetaData_getMaxColumnsInOrderBy(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_getMaxColumnsInOrderBy();
    }

    @Override
    public int DatabaseMetaData_getMaxColumnsInSelect(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_getMaxColumnsInSelect();
    }

    @Override
    public int DatabaseMetaData_getMaxColumnsInTable(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_getMaxColumnsInTable();
    }

    @Override
    public int DatabaseMetaData_getMaxConnections(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_getMaxConnections();
    }

    @Override
    public int DatabaseMetaData_getMaxCursorNameLength(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_getMaxCursorNameLength();
    }

    @Override
    public int DatabaseMetaData_getMaxIndexLength(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_getMaxIndexLength();
    }

    @Override
    public int DatabaseMetaData_getMaxSchemaNameLength(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_getMaxSchemaNameLength();
    }

    @Override
    public int DatabaseMetaData_getMaxProcedureNameLength(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_getMaxProcedureNameLength();
    }

    @Override
    public int DatabaseMetaData_getMaxCatalogNameLength(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_getMaxCatalogNameLength();
    }

    @Override
    public int DatabaseMetaData_getMaxRowSize(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_getMaxRowSize();
    }

    @Override
    public boolean DatabaseMetaData_doesMaxRowSizeIncludeBlobs(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_doesMaxRowSizeIncludeBlobs();
    }

    @Override
    public int DatabaseMetaData_getMaxStatementLength(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_getMaxStatementLength();
    }

    @Override
    public int DatabaseMetaData_getMaxStatements(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_getMaxStatements();
    }

    @Override
    public int DatabaseMetaData_getMaxTableNameLength(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_getMaxTableNameLength();
    }

    @Override
    public int DatabaseMetaData_getMaxTablesInSelect(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_getMaxTablesInSelect();
    }

    @Override
    public int DatabaseMetaData_getMaxUserNameLength(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_getMaxUserNameLength();
    }

    @Override
    public int DatabaseMetaData_getDefaultTransactionIsolation(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_getDefaultTransactionIsolation();
    }

    @Override
    public boolean DatabaseMetaData_supportsTransactions(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsTransactions();
    }

    @Override
    public boolean DatabaseMetaData_supportsTransactionIsolationLevel(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, int level) throws SQLException {
        return databaseMetaData.do_supportsTransactionIsolationLevel(level);
    }

    @Override
    public boolean DatabaseMetaData_supportsDataDefinitionAndDataManipulationTransactions(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsDataDefinitionAndDataManipulationTransactions();
    }

    @Override
    public boolean DatabaseMetaData_supportsDataManipulationTransactionsOnly(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsDataManipulationTransactionsOnly();
    }

    @Override
    public boolean DatabaseMetaData_dataDefinitionCausesTransactionCommit(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_dataDefinitionCausesTransactionCommit();
    }

    @Override
    public boolean DatabaseMetaData_dataDefinitionIgnoredInTransactions(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_dataDefinitionIgnoredInTransactions();
    }

    @Override
    public ResultSet DatabaseMetaData_getProcedures(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        databaseMetaData.connection.rwInfo.rwCounter.countPrimary();
        return databaseMetaData.do_getProcedures(catalog, schemaPattern, procedureNamePattern);
    }

    @Override
    public ResultSet DatabaseMetaData_getProcedureColumns(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        databaseMetaData.connection.rwInfo.rwCounter.countPrimary();
        return databaseMetaData.do_getProcedureColumns(catalog, schemaPattern, procedureNamePattern, columnNamePattern);
    }

    @Override
    public ResultSet DatabaseMetaData_getTables(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        databaseMetaData.connection.rwInfo.rwCounter.countPrimary();
        return databaseMetaData.do_getTables(catalog, schemaPattern, tableNamePattern, types);
    }

    @Override
    public ResultSet DatabaseMetaData_getSchemas(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        databaseMetaData.connection.rwInfo.rwCounter.countPrimary();
        return databaseMetaData.do_getSchemas();
    }

    @Override
    public ResultSet DatabaseMetaData_getCatalogs(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_getCatalogs();
    }

    @Override
    public ResultSet DatabaseMetaData_getTableTypes(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        databaseMetaData.connection.rwInfo.rwCounter.countPrimary();
        return databaseMetaData.do_getTableTypes();
    }

    @Override
    public ResultSet DatabaseMetaData_getColumns(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        databaseMetaData.connection.rwInfo.rwCounter.countPrimary();
        return databaseMetaData.do_getColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern);
    }

    @Override
    public ResultSet DatabaseMetaData_getColumnPrivileges(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        databaseMetaData.connection.rwInfo.rwCounter.countPrimary();
        return databaseMetaData.do_getColumnPrivileges(catalog, schema, table, columnNamePattern);
    }

    @Override
    public ResultSet DatabaseMetaData_getTablePrivileges(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        databaseMetaData.connection.rwInfo.rwCounter.countPrimary();
        return databaseMetaData.do_getTablePrivileges(catalog, schemaPattern, tableNamePattern);
    }

    @Override
    public ResultSet DatabaseMetaData_getBestRowIdentifier(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        databaseMetaData.connection.rwInfo.rwCounter.countPrimary();
        return databaseMetaData.do_getBestRowIdentifier(catalog, schema, table, scope, nullable);
    }

    @Override
    public ResultSet DatabaseMetaData_getVersionColumns(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table) throws SQLException {
        databaseMetaData.connection.rwInfo.rwCounter.countPrimary();
        return databaseMetaData.do_getVersionColumns(catalog, schema, table);
    }

    @Override
    public ResultSet DatabaseMetaData_getPrimaryKeys(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table) throws SQLException {
        databaseMetaData.connection.rwInfo.rwCounter.countPrimary();
        return databaseMetaData.do_getPrimaryKeys(catalog, schema, table);
    }

    @Override
    public ResultSet DatabaseMetaData_getImportedKeys(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table) throws SQLException {
        databaseMetaData.connection.rwInfo.rwCounter.countPrimary();
        return databaseMetaData.do_getImportedKeys(catalog, schema, table);
    }

    @Override
    public ResultSet DatabaseMetaData_getExportedKeys(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table) throws SQLException {
        databaseMetaData.connection.rwInfo.rwCounter.countPrimary();
        return databaseMetaData.do_getExportedKeys(catalog, schema, table);
    }

    @Override
    public ResultSet DatabaseMetaData_getCrossReference(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        databaseMetaData.connection.rwInfo.rwCounter.countPrimary();
        return databaseMetaData.do_getCrossReference(parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable);
    }

    @Override
    public ResultSet DatabaseMetaData_getTypeInfo(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        databaseMetaData.connection.rwInfo.rwCounter.countPrimary();
        return databaseMetaData.do_getTypeInfo();
    }

    @Override
    public ResultSet DatabaseMetaData_getIndexInfo(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        databaseMetaData.connection.rwInfo.rwCounter.countPrimary();
        return databaseMetaData.do_getIndexInfo(catalog, schema, table, unique, approximate);
    }

    @Override
    public boolean DatabaseMetaData_supportsResultSetType(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        return databaseMetaData.do_supportsResultSetType(type);
    }

    @Override
    public boolean DatabaseMetaData_supportsResultSetConcurrency(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, int type, int concurrency) throws SQLException {
        return databaseMetaData.do_supportsResultSetConcurrency(type, concurrency);
    }

    @Override
    public boolean DatabaseMetaData_ownUpdatesAreVisible(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        return databaseMetaData.do_ownUpdatesAreVisible(type);
    }

    @Override
    public boolean DatabaseMetaData_ownDeletesAreVisible(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        return databaseMetaData.do_ownDeletesAreVisible(type);
    }

    @Override
    public boolean DatabaseMetaData_ownInsertsAreVisible(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        return databaseMetaData.do_ownInsertsAreVisible(type);
    }

    @Override
    public boolean DatabaseMetaData_othersUpdatesAreVisible(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        return databaseMetaData.do_othersUpdatesAreVisible(type);
    }

    @Override
    public boolean DatabaseMetaData_othersDeletesAreVisible(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        return databaseMetaData.do_othersDeletesAreVisible(type);
    }

    @Override
    public boolean DatabaseMetaData_othersInsertsAreVisible(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        return databaseMetaData.do_othersInsertsAreVisible(type);
    }

    @Override
    public boolean DatabaseMetaData_updatesAreDetected(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        return databaseMetaData.do_updatesAreDetected(type);
    }

    @Override
    public boolean DatabaseMetaData_deletesAreDetected(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        return databaseMetaData.do_deletesAreDetected(type);
    }

    @Override
    public boolean DatabaseMetaData_insertsAreDetected(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        return databaseMetaData.do_insertsAreDetected(type);
    }

    @Override
    public boolean DatabaseMetaData_supportsBatchUpdates(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsBatchUpdates();
    }

    @Override
    public ResultSet DatabaseMetaData_getUDTs(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        databaseMetaData.connection.rwInfo.rwCounter.countPrimary();
        return databaseMetaData.do_getUDTs(catalog, schemaPattern, typeNamePattern, types);
    }

    @Override
    public Connection DatabaseMetaData_getConnection(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_getConnection();
    }

    @Override
    public boolean DatabaseMetaData_supportsSavepoints(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsSavepoints();
    }

    @Override
    public boolean DatabaseMetaData_supportsNamedParameters(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsNamedParameters();
    }

    @Override
    public boolean DatabaseMetaData_supportsMultipleOpenResults(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsMultipleOpenResults();
    }

    @Override
    public boolean DatabaseMetaData_supportsGetGeneratedKeys(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsGetGeneratedKeys();
    }

    @Override
    public ResultSet DatabaseMetaData_getSuperTypes(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        databaseMetaData.connection.rwInfo.rwCounter.countPrimary();
        return databaseMetaData.do_getSuperTypes(catalog, schemaPattern, typeNamePattern);
    }

    @Override
    public ResultSet DatabaseMetaData_getSuperTables(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        databaseMetaData.connection.rwInfo.rwCounter.countPrimary();
        return databaseMetaData.do_getSuperTables(catalog, schemaPattern, tableNamePattern);
    }

    @Override
    public ResultSet DatabaseMetaData_getAttributes(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        databaseMetaData.connection.rwInfo.rwCounter.countPrimary();
        return databaseMetaData.do_getAttributes(catalog, schemaPattern, typeNamePattern, attributeNamePattern);
    }

    @Override
    public boolean DatabaseMetaData_supportsResultSetHoldability(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, int holdability) throws SQLException {
        return databaseMetaData.do_supportsResultSetHoldability(holdability);
    }

    @Override
    public int DatabaseMetaData_getResultSetHoldability(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_getResultSetHoldability();
    }

    @Override
    public int DatabaseMetaData_getDatabaseMajorVersion(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_getDatabaseMajorVersion();
    }

    @Override
    public int DatabaseMetaData_getDatabaseMinorVersion(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_getDatabaseMinorVersion();
    }

    @Override
    public int DatabaseMetaData_getJDBCMajorVersion(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_getJDBCMajorVersion();
    }

    @Override
    public int DatabaseMetaData_getJDBCMinorVersion(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_getJDBCMinorVersion();
    }

    @Override
    public int DatabaseMetaData_getSQLStateType(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_getSQLStateType();
    }

    @Override
    public boolean DatabaseMetaData_locatorsUpdateCopy(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_locatorsUpdateCopy();
    }

    @Override
    public boolean DatabaseMetaData_supportsStatementPooling(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsStatementPooling();
    }

    @Override
    public RowIdLifetime DatabaseMetaData_getRowIdLifetime(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_getRowIdLifetime();
    }

    @Override
    public ResultSet DatabaseMetaData_getSchemas(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern) throws SQLException {
        databaseMetaData.connection.rwInfo.rwCounter.countPrimary();
        return databaseMetaData.do_getSchemas(catalog, schemaPattern);
    }

    @Override
    public boolean DatabaseMetaData_supportsStoredFunctionsUsingCallSyntax(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsStoredFunctionsUsingCallSyntax();
    }

    @Override
    public boolean DatabaseMetaData_autoCommitFailureClosesAllResultSets(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_autoCommitFailureClosesAllResultSets();
    }

    @Override
    public ResultSet DatabaseMetaData_getClientInfoProperties(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        databaseMetaData.connection.rwInfo.rwCounter.countPrimary();
        return databaseMetaData.do_getClientInfoProperties();
    }

    @Override
    public ResultSet DatabaseMetaData_getFunctions(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        databaseMetaData.connection.rwInfo.rwCounter.countPrimary();
        return databaseMetaData.do_getFunctions(catalog, schemaPattern, functionNamePattern);
    }

    @Override
    public ResultSet DatabaseMetaData_getFunctionColumns(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        databaseMetaData.connection.rwInfo.rwCounter.countPrimary();
        return databaseMetaData.do_getFunctionColumns(catalog, schemaPattern, functionNamePattern, columnNamePattern);
    }

    @Override
    public ResultSet DatabaseMetaData_getPseudoColumns(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        databaseMetaData.connection.rwInfo.rwCounter.countPrimary();
        return databaseMetaData.do_getPseudoColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern);
    }

    @Override
    public boolean DatabaseMetaData_generatedKeyAlwaysReturned(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_generatedKeyAlwaysReturned();
    }

    @Override
    public long DatabaseMetaData_getMaxLogicalLobSize(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_getMaxLogicalLobSize();
    }

    @Override
    public boolean DatabaseMetaData_supportsRefCursors(FilterChain filterChain, DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.do_supportsRefCursors();
    }

    @Override
    public Connection Driver_connect(FilterChain filterChain, DmDriver driver, DmProperties props) throws SQLException {
        return RWUtil2.connect(driver, props);
    }

    @Override
    public int ParameterMetaData_getParameterCount(FilterChain filterChain, DmdbParameterMetaData parameterMetaData) throws SQLException {
        return parameterMetaData.do_getParameterCount();
    }

    @Override
    public int ParameterMetaData_isNullable(FilterChain filterChain, DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        return parameterMetaData.do_isNullable(param);
    }

    @Override
    public boolean ParameterMetaData_isSigned(FilterChain filterChain, DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        return parameterMetaData.do_isSigned(param);
    }

    @Override
    public int ParameterMetaData_getPrecision(FilterChain filterChain, DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        return parameterMetaData.do_getPrecision(param);
    }

    @Override
    public int ParameterMetaData_getScale(FilterChain filterChain, DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        return parameterMetaData.do_getScale(param);
    }

    @Override
    public int ParameterMetaData_getParameterType(FilterChain filterChain, DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        return parameterMetaData.do_getParameterType(param);
    }

    @Override
    public String ParameterMetaData_getParameterTypeName(FilterChain filterChain, DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        return parameterMetaData.do_getParameterTypeName(param);
    }

    @Override
    public String ParameterMetaData_getParameterClassName(FilterChain filterChain, DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        return parameterMetaData.do_getParameterClassName(param);
    }

    @Override
    public int ParameterMetaData_getParameterMode(FilterChain filterChain, DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        return parameterMetaData.do_getParameterMode(param);
    }

    @Override
    public ResultSet PreparedStatement_executeQuery(FilterChain filterChain, final DmdbPreparedStatement preparedStatement) throws SQLException {
        return RWUtil2.execute(preparedStatement, null, new ExecuteCallBack<ResultSet>(){

            @Override
            ResultSet execute() throws SQLException {
                return preparedStatement.rwInfo.getPstmtCurrent().do_executeQuery();
            }

            @Override
            ResultSet execute(DmdbStatement otherStmt) throws SQLException {
                return ((DmdbPreparedStatement)otherStmt).do_executeQuery();
            }
        });
    }

    @Override
    public int PreparedStatement_executeUpdate(FilterChain filterChain, final DmdbPreparedStatement preparedStatement) throws SQLException {
        return RWUtil2.execute(preparedStatement, null, new ExecuteCallBack<Integer>(){

            @Override
            Integer execute() throws SQLException {
                return preparedStatement.rwInfo.getPstmtCurrent().do_executeUpdate();
            }

            @Override
            Integer execute(DmdbStatement otherStmt) throws SQLException {
                return ((DmdbPreparedStatement)otherStmt).do_executeUpdate();
            }
        });
    }

    @Override
    public int[] PreparedStatement_executeBatch(FilterChain filterChain, final DmdbPreparedStatement preparedStatement) throws SQLException {
        try {
            preparedStatement.clearBatch = false;
            if (preparedStatement.rwInfo.stmtStandby != null) {
                preparedStatement.rwInfo.stmtStandby.clearBatch = false;
            }
            int[] nArray = RWUtil2.execute(preparedStatement, null, new ExecuteCallBack<int[]>(){

                @Override
                int[] execute() throws SQLException {
                    return preparedStatement.rwInfo.getPstmtCurrent().do_executeBatch();
                }

                @Override
                int[] execute(DmdbStatement otherStmt) throws SQLException {
                    return otherStmt.do_executeBatch();
                }
            });
            return nArray;
        }
        finally {
            preparedStatement.do_clearBatch();
            preparedStatement.clearBatch = true;
            if (preparedStatement.rwInfo.stmtStandby != null) {
                preparedStatement.rwInfo.stmtStandby.do_clearBatch();
                preparedStatement.rwInfo.stmtStandby.clearBatch = true;
            }
        }
    }

    @Override
    public long[] PreparedStatement_executeLargeBatch(FilterChain filterChain, final DmdbPreparedStatement preparedStatement) throws SQLException {
        try {
            preparedStatement.clearBatch = false;
            if (preparedStatement.rwInfo.stmtStandby != null) {
                preparedStatement.rwInfo.stmtStandby.clearBatch = false;
            }
            long[] lArray = RWUtil2.execute(preparedStatement, null, new ExecuteCallBack<long[]>(){

                @Override
                long[] execute() throws SQLException {
                    return preparedStatement.rwInfo.getPstmtCurrent().do_executeLargeBatch();
                }

                @Override
                long[] execute(DmdbStatement otherStmt) throws SQLException {
                    return ((DmdbPreparedStatement)otherStmt).do_executeLargeBatch();
                }
            });
            return lArray;
        }
        finally {
            preparedStatement.do_clearBatch();
            preparedStatement.clearBatch = true;
            if (preparedStatement.rwInfo.stmtStandby != null) {
                preparedStatement.rwInfo.stmtStandby.do_clearBatch();
                preparedStatement.rwInfo.stmtStandby.clearBatch = true;
            }
        }
    }

    @Override
    public void PreparedStatement_setNull(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, int sqlType) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setNull(parameterIndex, sqlType);
    }

    @Override
    public void PreparedStatement_setBoolean(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, boolean x2) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setBoolean(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setByte(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, byte x2) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setByte(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setShort(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, short x2) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setShort(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setInt(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, int x2) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setInt(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setLong(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, long x2) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setLong(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setFloat(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, float x2) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setFloat(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setDouble(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, double x2) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setDouble(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setBigDecimal(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, BigDecimal x2) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setBigDecimal(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setString(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, String x2) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setString(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setBytes(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, byte[] x2) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setBytes(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setDate(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Date x2) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setDate(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setTime(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Time x2) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setTime(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setTimestamp(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Timestamp x2) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setTimestamp(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setAsciiStream(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, int length) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setAsciiStream(parameterIndex, x2, length);
    }

    @Override
    public void PreparedStatement_setUnicodeStream(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, int length) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setUnicodeStream(parameterIndex, x2, length);
    }

    @Override
    public void PreparedStatement_setBinaryStream(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, int length) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setBinaryStream(parameterIndex, x2, length);
    }

    @Override
    public void PreparedStatement_clearParameters(FilterChain filterChain, DmdbPreparedStatement preparedStatement) throws SQLException {
        if (preparedStatement.rwInfo.stmtStandby != null) {
            preparedStatement.rwInfo.getPstmtStandby().do_clearParameters();
        }
        preparedStatement.do_clearParameters();
    }

    @Override
    public void PreparedStatement_setObject(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2, int targetSqlType) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setObject(parameterIndex, x2, targetSqlType);
    }

    @Override
    public void PreparedStatement_setObject(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setObject(parameterIndex, x2);
    }

    @Override
    public boolean PreparedStatement_execute(FilterChain filterChain, final DmdbPreparedStatement preparedStatement) throws SQLException {
        return RWUtil2.execute(preparedStatement, null, new ExecuteCallBack<Boolean>(){

            @Override
            Boolean execute() throws SQLException {
                return preparedStatement.rwInfo.getPstmtCurrent().do_execute();
            }

            @Override
            Boolean execute(DmdbStatement otherStmt) throws SQLException {
                return ((DmdbPreparedStatement)otherStmt).do_execute();
            }
        });
    }

    @Override
    public void PreparedStatement_addBatch(FilterChain filterChain, DmdbPreparedStatement preparedStatement) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_addBatch();
    }

    @Override
    public void PreparedStatement_setCharacterStream(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader, int length) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void PreparedStatement_setRef(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Ref x2) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setRef(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setBlob(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Blob x2) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setBlob(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setClob(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Clob x2) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setClob(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setArray(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Array x2) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setArray(parameterIndex, x2);
    }

    @Override
    public ResultSetMetaData PreparedStatement_getMetaData(FilterChain filterChain, DmdbPreparedStatement preparedStatement) throws SQLException {
        return preparedStatement.rwInfo.getPstmtCurrent().do_getMetaData();
    }

    @Override
    public void PreparedStatement_setDate(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Date x2, Calendar cal) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setDate(parameterIndex, x2, cal);
    }

    @Override
    public void PreparedStatement_setTime(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Time x2, Calendar cal) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setTime(parameterIndex, x2, cal);
    }

    @Override
    public void PreparedStatement_setTimestamp(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Timestamp x2, Calendar cal) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setTimestamp(parameterIndex, x2, cal);
    }

    @Override
    public void PreparedStatement_setNull(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, int sqlType, String typeName) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setNull(parameterIndex, sqlType, typeName);
    }

    @Override
    public void PreparedStatement_setURL(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, URL x2) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setURL(parameterIndex, x2);
    }

    @Override
    public ParameterMetaData PreparedStatement_getParameterMetaData(FilterChain filterChain, DmdbPreparedStatement preparedStatement) throws SQLException {
        return preparedStatement.rwInfo.getPstmtCurrent().do_getParameterMetaData();
    }

    @Override
    public void PreparedStatement_setRowId(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, RowId x2) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setRowId(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setNString(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, String value) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setNString(parameterIndex, value);
    }

    @Override
    public void PreparedStatement_setNCharacterStream(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader value, long length) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setNCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void PreparedStatement_setNClob(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, NClob value) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setNClob(parameterIndex, value);
    }

    @Override
    public void PreparedStatement_setClob(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader, long length) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setClob(parameterIndex, reader, length);
    }

    @Override
    public void PreparedStatement_setBlob(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream inputStream, long length) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setBlob(parameterIndex, inputStream, length);
    }

    @Override
    public void PreparedStatement_setNClob(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader, long length) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setNClob(parameterIndex, reader, length);
    }

    @Override
    public void PreparedStatement_setSQLXML(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, SQLXML xmlObject) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setSQLXML(parameterIndex, xmlObject);
    }

    @Override
    public void PreparedStatement_setObject(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2, int targetSqlType, int scaleOrLength) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setObject(parameterIndex, x2, targetSqlType, scaleOrLength);
    }

    @Override
    public void PreparedStatement_setAsciiStream(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, long length) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setAsciiStream(parameterIndex, x2, length);
    }

    @Override
    public void PreparedStatement_setBinaryStream(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, long length) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setBinaryStream(parameterIndex, x2, length);
    }

    @Override
    public void PreparedStatement_setCharacterStream(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader, long length) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void PreparedStatement_setAsciiStream(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setAsciiStream(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setBinaryStream(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setBinaryStream(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setCharacterStream(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void PreparedStatement_setNCharacterStream(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader value) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setNCharacterStream(parameterIndex, value);
    }

    @Override
    public void PreparedStatement_setClob(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setClob(parameterIndex, reader);
    }

    @Override
    public void PreparedStatement_setBlob(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream inputStream) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setBlob(parameterIndex, inputStream);
    }

    @Override
    public void PreparedStatement_setNClob(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setNClob(parameterIndex, reader);
    }

    @Override
    public void PreparedStatement_setObject(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setObject(parameterIndex, x2, targetSqlType, scaleOrLength);
    }

    @Override
    public void PreparedStatement_setObject(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2, SQLType targetSqlType) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setObject(parameterIndex, x2, targetSqlType);
    }

    @Override
    public long PreparedStatement_executeLargeUpdate(FilterChain filterChain, final DmdbPreparedStatement preparedStatement) throws SQLException {
        return RWUtil2.execute(preparedStatement, null, new ExecuteCallBack<Long>(){

            @Override
            Long execute() throws SQLException {
                return preparedStatement.rwInfo.getPstmtCurrent().do_executeLargeUpdate();
            }

            @Override
            Long execute(DmdbStatement otherStmt) throws SQLException {
                return ((DmdbPreparedStatement)otherStmt).do_executeLargeUpdate();
            }
        });
    }

    @Override
    public void PreparedStatement_preCompile(FilterChain filterChain, DmdbPreparedStatement preparedStatement, String sql) throws SQLException {
        preparedStatement.rwInfo.stmtCurrent = preparedStatement;
        preparedStatement.rwInfo.getPstmtCurrent().do_preCompile(sql);
    }

    @Override
    public void PreparedStatement_setTIMESTAMP(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, DmdbTimestamp x2) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setTIMESTAMP(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setINTERVALYM(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, DmdbIntervalYM x2) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setINTERVALYM(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setINTERVALDT(FilterChain filterChain, DmdbPreparedStatement preparedStatement, int parameterIndex, DmdbIntervalDT x2) throws SQLException {
        preparedStatement.rwInfo.getPstmtCurrent().do_setINTERVALDT(parameterIndex, x2);
    }

    @Override
    public boolean ResultSet_next(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        return resultSet.do_next();
    }

    @Override
    public void ResultSet_close(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        resultSet.do_close();
    }

    @Override
    public boolean ResultSet_wasNull(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        return resultSet.do_wasNull();
    }

    @Override
    public String ResultSet_getString(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return resultSet.do_getString(columnIndex);
    }

    @Override
    public boolean ResultSet_getBoolean(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return resultSet.do_getBoolean(columnIndex);
    }

    @Override
    public byte ResultSet_getByte(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return resultSet.do_getByte(columnIndex);
    }

    @Override
    public short ResultSet_getShort(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return resultSet.do_getShort(columnIndex);
    }

    @Override
    public int ResultSet_getInt(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return resultSet.do_getInt(columnIndex);
    }

    @Override
    public long ResultSet_getLong(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return resultSet.do_getLong(columnIndex);
    }

    @Override
    public float ResultSet_getFloat(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return resultSet.do_getFloat(columnIndex);
    }

    @Override
    public double ResultSet_getDouble(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return resultSet.do_getDouble(columnIndex);
    }

    @Override
    public BigDecimal ResultSet_getBigDecimal(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, int scale) throws SQLException {
        return resultSet.do_getBigDecimal(columnIndex, scale);
    }

    @Override
    public byte[] ResultSet_getBytes(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return resultSet.do_getBytes(columnIndex);
    }

    @Override
    public Date ResultSet_getDate(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return resultSet.do_getDate(columnIndex);
    }

    @Override
    public Time ResultSet_getTime(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return resultSet.do_getTime(columnIndex);
    }

    @Override
    public Timestamp ResultSet_getTimestamp(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return resultSet.do_getTimestamp(columnIndex);
    }

    @Override
    public InputStream ResultSet_getAsciiStream(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return resultSet.do_getAsciiStream(columnIndex);
    }

    @Override
    public InputStream ResultSet_getUnicodeStream(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return resultSet.do_getUnicodeStream(columnIndex);
    }

    @Override
    public InputStream ResultSet_getBinaryStream(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return resultSet.do_getBinaryStream(columnIndex);
    }

    @Override
    public String ResultSet_getString(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return resultSet.do_getString(columnLabel);
    }

    @Override
    public boolean ResultSet_getBoolean(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return resultSet.do_getBoolean(columnLabel);
    }

    @Override
    public byte ResultSet_getByte(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return resultSet.do_getByte(columnLabel);
    }

    @Override
    public short ResultSet_getShort(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return resultSet.do_getShort(columnLabel);
    }

    @Override
    public int ResultSet_getInt(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return resultSet.do_getInt(columnLabel);
    }

    @Override
    public long ResultSet_getLong(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return resultSet.do_getLong(columnLabel);
    }

    @Override
    public float ResultSet_getFloat(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return resultSet.do_getFloat(columnLabel);
    }

    @Override
    public double ResultSet_getDouble(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return resultSet.do_getDouble(columnLabel);
    }

    @Override
    public BigDecimal ResultSet_getBigDecimal(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, int scale) throws SQLException {
        return resultSet.do_getBigDecimal(columnLabel, scale);
    }

    @Override
    public byte[] ResultSet_getBytes(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return resultSet.do_getBytes(columnLabel);
    }

    @Override
    public Date ResultSet_getDate(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return resultSet.do_getDate(columnLabel);
    }

    @Override
    public Time ResultSet_getTime(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return resultSet.do_getTime(columnLabel);
    }

    @Override
    public Timestamp ResultSet_getTimestamp(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return resultSet.do_getTimestamp(columnLabel);
    }

    @Override
    public InputStream ResultSet_getAsciiStream(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return resultSet.do_getAsciiStream(columnLabel);
    }

    @Override
    public InputStream ResultSet_getUnicodeStream(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return resultSet.do_getUnicodeStream(columnLabel);
    }

    @Override
    public InputStream ResultSet_getBinaryStream(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return resultSet.do_getBinaryStream(columnLabel);
    }

    @Override
    public SQLWarning ResultSet_getWarnings(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        return resultSet.do_getWarnings();
    }

    @Override
    public void ResultSet_clearWarnings(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        resultSet.do_clearWarnings();
    }

    @Override
    public String ResultSet_getCursorName(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        return resultSet.do_getCursorName();
    }

    @Override
    public ResultSetMetaData ResultSet_getMetaData(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        return resultSet.do_getMetaData();
    }

    @Override
    public Object ResultSet_getObject(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return resultSet.do_getObject(columnIndex);
    }

    @Override
    public Object ResultSet_getObject(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return resultSet.do_getObject(columnLabel);
    }

    @Override
    public int ResultSet_findColumn(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return resultSet.do_findColumn(columnLabel);
    }

    @Override
    public Reader ResultSet_getCharacterStream(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return resultSet.do_getCharacterStream(columnIndex);
    }

    @Override
    public Reader ResultSet_getCharacterStream(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return resultSet.do_getCharacterStream(columnLabel);
    }

    @Override
    public BigDecimal ResultSet_getBigDecimal(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return resultSet.do_getBigDecimal(columnIndex);
    }

    @Override
    public BigDecimal ResultSet_getBigDecimal(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return resultSet.do_getBigDecimal(columnLabel);
    }

    @Override
    public boolean ResultSet_isBeforeFirst(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        return resultSet.do_isBeforeFirst();
    }

    @Override
    public boolean ResultSet_isAfterLast(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        return resultSet.do_isAfterLast();
    }

    @Override
    public boolean ResultSet_isFirst(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        return resultSet.do_isFirst();
    }

    @Override
    public boolean ResultSet_isLast(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        return resultSet.do_isLast();
    }

    @Override
    public void ResultSet_beforeFirst(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        resultSet.do_beforeFirst();
    }

    @Override
    public void ResultSet_afterLast(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        resultSet.do_afterLast();
    }

    @Override
    public boolean ResultSet_first(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        return resultSet.do_first();
    }

    @Override
    public boolean ResultSet_last(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        return resultSet.do_last();
    }

    @Override
    public int ResultSet_getRow(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        return resultSet.do_getRow();
    }

    @Override
    public boolean ResultSet_absolute(FilterChain filterChain, DmdbResultSet resultSet, int row) throws SQLException {
        return resultSet.do_absolute(row);
    }

    @Override
    public boolean ResultSet_relative(FilterChain filterChain, DmdbResultSet resultSet, int rows) throws SQLException {
        return resultSet.do_relative(rows);
    }

    @Override
    public boolean ResultSet_previous(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        return resultSet.do_previous();
    }

    @Override
    public void ResultSet_setFetchDirection(FilterChain filterChain, DmdbResultSet resultSet, int direction) throws SQLException {
        resultSet.do_setFetchDirection(direction);
    }

    @Override
    public int ResultSet_getFetchDirection(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        return resultSet.do_getFetchDirection();
    }

    @Override
    public void ResultSet_setFetchSize(FilterChain filterChain, DmdbResultSet resultSet, int rows) throws SQLException {
        resultSet.do_setFetchSize(rows);
    }

    @Override
    public int ResultSet_getFetchSize(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        return resultSet.do_getFetchSize();
    }

    @Override
    public int ResultSet_getType(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        return resultSet.do_getType();
    }

    @Override
    public int ResultSet_getConcurrency(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        return resultSet.do_getConcurrency();
    }

    @Override
    public boolean ResultSet_rowUpdated(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        return resultSet.do_rowUpdated();
    }

    @Override
    public boolean ResultSet_rowInserted(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        return resultSet.do_rowInserted();
    }

    @Override
    public boolean ResultSet_rowDeleted(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        return resultSet.do_rowDeleted();
    }

    @Override
    public void ResultSet_updateNull(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        resultSet.do_updateNull(columnIndex);
    }

    @Override
    public void ResultSet_updateBoolean(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, boolean x2) throws SQLException {
        resultSet.do_updateBoolean(columnIndex, x2);
    }

    @Override
    public void ResultSet_updateByte(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, byte x2) throws SQLException {
        resultSet.do_updateByte(columnIndex, x2);
    }

    @Override
    public void ResultSet_updateShort(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, short x2) throws SQLException {
        resultSet.do_updateShort(columnIndex, x2);
    }

    @Override
    public void ResultSet_updateInt(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, int x2) throws SQLException {
        resultSet.do_updateInt(columnIndex, x2);
    }

    @Override
    public void ResultSet_updateLong(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, long x2) throws SQLException {
        resultSet.do_updateLong(columnIndex, x2);
    }

    @Override
    public void ResultSet_updateFloat(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, float x2) throws SQLException {
        resultSet.do_updateFloat(columnIndex, x2);
    }

    @Override
    public void ResultSet_updateDouble(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, double x2) throws SQLException {
        resultSet.do_updateDouble(columnIndex, x2);
    }

    @Override
    public void ResultSet_updateBigDecimal(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, BigDecimal x2) throws SQLException {
        resultSet.do_updateBigDecimal(columnIndex, x2);
    }

    @Override
    public void ResultSet_updateString(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, String x2) throws SQLException {
        resultSet.do_updateString(columnIndex, x2);
    }

    @Override
    public void ResultSet_updateBytes(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, byte[] x2) throws SQLException {
        resultSet.do_updateBytes(columnIndex, x2);
    }

    @Override
    public void ResultSet_updateDate(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Date x2) throws SQLException {
        resultSet.do_updateDate(columnIndex, x2);
    }

    @Override
    public void ResultSet_updateTime(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Time x2) throws SQLException {
        resultSet.do_updateTime(columnIndex, x2);
    }

    @Override
    public void ResultSet_updateTimestamp(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Timestamp x2) throws SQLException {
        resultSet.do_updateTimestamp(columnIndex, x2);
    }

    @Override
    public void ResultSet_updateAsciiStream(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, InputStream x2, int length) throws SQLException {
        resultSet.do_updateAsciiStream(columnIndex, x2, length);
    }

    @Override
    public void ResultSet_updateBinaryStream(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, InputStream x2, int length) throws SQLException {
        resultSet.do_updateBinaryStream(columnIndex, x2, length);
    }

    @Override
    public void ResultSet_updateCharacterStream(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Reader x2, int length) throws SQLException {
        resultSet.do_updateCharacterStream(columnIndex, x2, length);
    }

    @Override
    public void ResultSet_updateObject(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Object x2, int scaleOrLength) throws SQLException {
        resultSet.do_updateObject(columnIndex, x2, scaleOrLength);
    }

    @Override
    public void ResultSet_updateObject(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Object x2) throws SQLException {
        resultSet.do_updateObject(columnIndex, x2);
    }

    @Override
    public void ResultSet_updateNull(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        resultSet.do_updateNull(columnLabel);
    }

    @Override
    public void ResultSet_updateBoolean(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, boolean x2) throws SQLException {
        resultSet.do_updateBoolean(columnLabel, x2);
    }

    @Override
    public void ResultSet_updateByte(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, byte x2) throws SQLException {
        resultSet.do_updateByte(columnLabel, x2);
    }

    @Override
    public void ResultSet_updateShort(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, short x2) throws SQLException {
        resultSet.do_updateShort(columnLabel, x2);
    }

    @Override
    public void ResultSet_updateInt(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, int x2) throws SQLException {
        resultSet.do_updateInt(columnLabel, x2);
    }

    @Override
    public void ResultSet_updateLong(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, long x2) throws SQLException {
        resultSet.do_updateLong(columnLabel, x2);
    }

    @Override
    public void ResultSet_updateFloat(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, float x2) throws SQLException {
        resultSet.do_updateFloat(columnLabel, x2);
    }

    @Override
    public void ResultSet_updateDouble(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, double x2) throws SQLException {
        resultSet.do_updateDouble(columnLabel, x2);
    }

    @Override
    public void ResultSet_updateBigDecimal(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, BigDecimal x2) throws SQLException {
        resultSet.do_updateBigDecimal(columnLabel, x2);
    }

    @Override
    public void ResultSet_updateString(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, String x2) throws SQLException {
        resultSet.do_updateString(columnLabel, x2);
    }

    @Override
    public void ResultSet_updateBytes(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, byte[] x2) throws SQLException {
        resultSet.do_updateBytes(columnLabel, x2);
    }

    @Override
    public void ResultSet_updateDate(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Date x2) throws SQLException {
        resultSet.do_updateDate(columnLabel, x2);
    }

    @Override
    public void ResultSet_updateTime(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Time x2) throws SQLException {
        resultSet.do_updateTime(columnLabel, x2);
    }

    @Override
    public void ResultSet_updateTimestamp(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Timestamp x2) throws SQLException {
        resultSet.do_updateTimestamp(columnLabel, x2);
    }

    @Override
    public void ResultSet_updateAsciiStream(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, InputStream x2, int length) throws SQLException {
        resultSet.do_updateAsciiStream(columnLabel, x2, length);
    }

    @Override
    public void ResultSet_updateBinaryStream(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, InputStream x2, int length) throws SQLException {
        resultSet.do_updateBinaryStream(columnLabel, x2, length);
    }

    @Override
    public void ResultSet_updateCharacterStream(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Reader reader, int length) throws SQLException {
        resultSet.do_updateCharacterStream(columnLabel, reader, length);
    }

    @Override
    public void ResultSet_updateObject(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Object x2, int scaleOrLength) throws SQLException {
        resultSet.do_updateObject(columnLabel, x2, scaleOrLength);
    }

    @Override
    public void ResultSet_updateObject(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Object x2) throws SQLException {
        resultSet.do_updateObject(columnLabel, x2);
    }

    @Override
    public void ResultSet_insertRow(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        resultSet.do_insertRow();
    }

    @Override
    public void ResultSet_updateRow(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        resultSet.do_updateRow();
    }

    @Override
    public void ResultSet_deleteRow(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        resultSet.do_deleteRow();
    }

    @Override
    public void ResultSet_refreshRow(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        resultSet.do_refreshRow();
    }

    @Override
    public void ResultSet_cancelRowUpdates(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        resultSet.do_cancelRowUpdates();
    }

    @Override
    public void ResultSet_moveToInsertRow(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        resultSet.do_moveToInsertRow();
    }

    @Override
    public void ResultSet_moveToCurrentRow(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        resultSet.do_moveToCurrentRow();
    }

    @Override
    public Statement ResultSet_getStatement(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        return resultSet.do_getStatement();
    }

    @Override
    public Object ResultSet_getObject(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Map<String, Class<?>> map) throws SQLException {
        return resultSet.do_getObject(columnIndex, map);
    }

    @Override
    public Ref ResultSet_getRef(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return resultSet.do_getRef(columnIndex);
    }

    @Override
    public Blob ResultSet_getBlob(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return resultSet.do_getBlob(columnIndex);
    }

    @Override
    public Clob ResultSet_getClob(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return resultSet.do_getClob(columnIndex);
    }

    @Override
    public Array ResultSet_getArray(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return resultSet.do_getArray(columnIndex);
    }

    @Override
    public Object ResultSet_getObject(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Map<String, Class<?>> map) throws SQLException {
        return resultSet.do_getObject(columnLabel, map);
    }

    @Override
    public Ref ResultSet_getRef(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return resultSet.do_getRef(columnLabel);
    }

    @Override
    public Blob ResultSet_getBlob(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return resultSet.do_getBlob(columnLabel);
    }

    @Override
    public Clob ResultSet_getClob(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return resultSet.do_getClob(columnLabel);
    }

    @Override
    public Array ResultSet_getArray(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return resultSet.do_getArray(columnLabel);
    }

    @Override
    public Date ResultSet_getDate(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Calendar cal) throws SQLException {
        return resultSet.do_getDate(columnIndex, cal);
    }

    @Override
    public Date ResultSet_getDate(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Calendar cal) throws SQLException {
        return resultSet.do_getDate(columnLabel, cal);
    }

    @Override
    public Time ResultSet_getTime(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Calendar cal) throws SQLException {
        return resultSet.do_getTime(columnIndex, cal);
    }

    @Override
    public Time ResultSet_getTime(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Calendar cal) throws SQLException {
        return resultSet.do_getTime(columnLabel, cal);
    }

    @Override
    public Timestamp ResultSet_getTimestamp(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Calendar cal) throws SQLException {
        return resultSet.do_getTimestamp(columnIndex, cal);
    }

    @Override
    public Timestamp ResultSet_getTimestamp(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Calendar cal) throws SQLException {
        return resultSet.do_getTimestamp(columnLabel, cal);
    }

    @Override
    public URL ResultSet_getURL(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return resultSet.do_getURL(columnIndex);
    }

    @Override
    public URL ResultSet_getURL(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return resultSet.do_getURL(columnLabel);
    }

    @Override
    public void ResultSet_updateRef(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Ref x2) throws SQLException {
        resultSet.do_updateRef(columnIndex, x2);
    }

    @Override
    public void ResultSet_updateRef(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Ref x2) throws SQLException {
        resultSet.do_updateRef(columnLabel, x2);
    }

    @Override
    public void ResultSet_updateBlob(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Blob x2) throws SQLException {
        resultSet.do_updateBlob(columnIndex, x2);
    }

    @Override
    public void ResultSet_updateBlob(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Blob x2) throws SQLException {
        resultSet.do_updateBlob(columnLabel, x2);
    }

    @Override
    public void ResultSet_updateClob(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Clob x2) throws SQLException {
        resultSet.do_updateClob(columnIndex, x2);
    }

    @Override
    public void ResultSet_updateClob(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Clob x2) throws SQLException {
        resultSet.do_updateClob(columnLabel, x2);
    }

    @Override
    public void ResultSet_updateArray(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Array x2) throws SQLException {
        resultSet.do_updateArray(columnIndex, x2);
    }

    @Override
    public void ResultSet_updateArray(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Array x2) throws SQLException {
        resultSet.do_updateArray(columnLabel, x2);
    }

    @Override
    public RowId ResultSet_getRowId(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return resultSet.do_getRowId(columnIndex);
    }

    @Override
    public RowId ResultSet_getRowId(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return resultSet.do_getRowId(columnLabel);
    }

    @Override
    public void ResultSet_updateRowId(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, RowId x2) throws SQLException {
        resultSet.do_updateRowId(columnIndex, x2);
    }

    @Override
    public void ResultSet_updateRowId(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, RowId x2) throws SQLException {
        resultSet.do_updateRowId(columnLabel, x2);
    }

    @Override
    public int ResultSet_getHoldability(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        return resultSet.do_getHoldability();
    }

    @Override
    public boolean ResultSet_isClosed(FilterChain filterChain, DmdbResultSet resultSet) throws SQLException {
        return resultSet.do_isClosed();
    }

    @Override
    public void ResultSet_updateNString(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, String nString) throws SQLException {
        resultSet.do_updateNString(columnIndex, nString);
    }

    @Override
    public void ResultSet_updateNString(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, String nString) throws SQLException {
        resultSet.do_updateNString(columnLabel, nString);
    }

    @Override
    public void ResultSet_updateNClob(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, NClob nClob) throws SQLException {
        resultSet.do_updateNClob(columnIndex, nClob);
    }

    @Override
    public void ResultSet_updateNClob(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, NClob nClob) throws SQLException {
        resultSet.do_updateNClob(columnLabel, nClob);
    }

    @Override
    public NClob ResultSet_getNClob(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return resultSet.do_getNClob(columnIndex);
    }

    @Override
    public NClob ResultSet_getNClob(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return resultSet.do_getNClob(columnLabel);
    }

    @Override
    public SQLXML ResultSet_getSQLXML(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return resultSet.do_getSQLXML(columnIndex);
    }

    @Override
    public SQLXML ResultSet_getSQLXML(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return resultSet.do_getSQLXML(columnLabel);
    }

    @Override
    public void ResultSet_updateSQLXML(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, SQLXML xmlObject) throws SQLException {
        resultSet.do_updateSQLXML(columnIndex, xmlObject);
    }

    @Override
    public void ResultSet_updateSQLXML(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, SQLXML xmlObject) throws SQLException {
        resultSet.do_updateSQLXML(columnLabel, xmlObject);
    }

    @Override
    public String ResultSet_getNString(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return resultSet.do_getNString(columnIndex);
    }

    @Override
    public String ResultSet_getNString(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return resultSet.do_getNString(columnLabel);
    }

    @Override
    public Reader ResultSet_getNCharacterStream(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return resultSet.do_getNCharacterStream(columnIndex);
    }

    @Override
    public Reader ResultSet_getNCharacterStream(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return resultSet.do_getNCharacterStream(columnLabel);
    }

    @Override
    public void ResultSet_updateNCharacterStream(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Reader x2, long length) throws SQLException {
        resultSet.do_updateNCharacterStream(columnIndex, x2, length);
    }

    @Override
    public void ResultSet_updateNCharacterStream(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Reader reader, long length) throws SQLException {
        resultSet.do_updateNCharacterStream(columnLabel, reader, length);
    }

    @Override
    public void ResultSet_updateAsciiStream(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, InputStream x2, long length) throws SQLException {
        resultSet.do_updateAsciiStream(columnIndex, x2, length);
    }

    @Override
    public void ResultSet_updateBinaryStream(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, InputStream x2, long length) throws SQLException {
        resultSet.do_updateBinaryStream(columnIndex, x2, length);
    }

    @Override
    public void ResultSet_updateCharacterStream(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Reader x2, long length) throws SQLException {
        resultSet.do_updateCharacterStream(columnIndex, x2, length);
    }

    @Override
    public void ResultSet_updateAsciiStream(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, InputStream x2, long length) throws SQLException {
        resultSet.do_updateAsciiStream(columnLabel, x2, length);
    }

    @Override
    public void ResultSet_updateBinaryStream(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, InputStream x2, long length) throws SQLException {
        resultSet.do_updateBinaryStream(columnLabel, x2, length);
    }

    @Override
    public void ResultSet_updateCharacterStream(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Reader reader, long length) throws SQLException {
        resultSet.do_updateCharacterStream(columnLabel, reader, length);
    }

    @Override
    public void ResultSet_updateBlob(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, InputStream inputStream, long length) throws SQLException {
        resultSet.do_updateBlob(columnIndex, inputStream, length);
    }

    @Override
    public void ResultSet_updateBlob(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, InputStream inputStream, long length) throws SQLException {
        resultSet.do_updateBlob(columnLabel, inputStream, length);
    }

    @Override
    public void ResultSet_updateClob(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Reader reader, long length) throws SQLException {
        resultSet.do_updateClob(columnIndex, reader, length);
    }

    @Override
    public void ResultSet_updateClob(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Reader reader, long length) throws SQLException {
        resultSet.do_updateClob(columnLabel, reader, length);
    }

    @Override
    public void ResultSet_updateNClob(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Reader reader, long length) throws SQLException {
        resultSet.do_updateNClob(columnIndex, reader, length);
    }

    @Override
    public void ResultSet_updateNClob(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Reader reader, long length) throws SQLException {
        resultSet.do_updateNClob(columnLabel, reader, length);
    }

    @Override
    public void ResultSet_updateNCharacterStream(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Reader x2) throws SQLException {
        resultSet.do_updateNCharacterStream(columnIndex, x2);
    }

    @Override
    public void ResultSet_updateNCharacterStream(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Reader reader) throws SQLException {
        resultSet.do_updateNCharacterStream(columnLabel, reader);
    }

    @Override
    public void ResultSet_updateAsciiStream(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, InputStream x2) throws SQLException {
        resultSet.do_updateAsciiStream(columnIndex, x2);
    }

    @Override
    public void ResultSet_updateBinaryStream(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, InputStream x2) throws SQLException {
        resultSet.do_updateBinaryStream(columnIndex, x2);
    }

    @Override
    public void ResultSet_updateCharacterStream(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Reader x2) throws SQLException {
        resultSet.do_updateCharacterStream(columnIndex, x2);
    }

    @Override
    public void ResultSet_updateAsciiStream(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, InputStream x2) throws SQLException {
        resultSet.do_updateAsciiStream(columnLabel, x2);
    }

    @Override
    public void ResultSet_updateBinaryStream(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, InputStream x2) throws SQLException {
        resultSet.do_updateBinaryStream(columnLabel, x2);
    }

    @Override
    public void ResultSet_updateCharacterStream(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Reader reader) throws SQLException {
        resultSet.do_updateCharacterStream(columnLabel, reader);
    }

    @Override
    public void ResultSet_updateBlob(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, InputStream inputStream) throws SQLException {
        resultSet.do_updateBlob(columnIndex, inputStream);
    }

    @Override
    public void ResultSet_updateBlob(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, InputStream inputStream) throws SQLException {
        resultSet.do_updateBlob(columnLabel, inputStream);
    }

    @Override
    public void ResultSet_updateClob(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Reader reader) throws SQLException {
        resultSet.do_updateClob(columnIndex, reader);
    }

    @Override
    public void ResultSet_updateClob(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Reader reader) throws SQLException {
        resultSet.do_updateClob(columnLabel, reader);
    }

    @Override
    public void ResultSet_updateNClob(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Reader reader) throws SQLException {
        resultSet.do_updateNClob(columnIndex, reader);
    }

    @Override
    public void ResultSet_updateNClob(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Reader reader) throws SQLException {
        resultSet.do_updateNClob(columnLabel, reader);
    }

    @Override
    public <T> T ResultSet_getObject(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Class<T> type) throws SQLException {
        return resultSet.do_getObject(columnIndex, type);
    }

    @Override
    public <T> T ResultSet_getObject(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Class<T> type) throws SQLException {
        return resultSet.do_getObject(columnLabel, type);
    }

    @Override
    public void ResultSet_updateObject(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Object x2, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        resultSet.do_updateObject(columnIndex, x2, targetSqlType, scaleOrLength);
    }

    @Override
    public void ResultSet_updateObject(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Object x2, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        resultSet.do_updateObject(columnLabel, x2, targetSqlType, scaleOrLength);
    }

    @Override
    public void ResultSet_updateObject(FilterChain filterChain, DmdbResultSet resultSet, int columnIndex, Object x2, SQLType targetSqlType) throws SQLException {
        resultSet.do_updateObject(columnIndex, x2, targetSqlType);
    }

    @Override
    public void ResultSet_updateObject(FilterChain filterChain, DmdbResultSet resultSet, String columnLabel, Object x2, SQLType targetSqlType) throws SQLException {
        resultSet.do_updateObject(columnLabel, x2, targetSqlType);
    }

    @Override
    public int ResultSetMetaData_getColumnCount(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData) throws SQLException {
        return resultSetMetaData.do_getColumnCount();
    }

    @Override
    public boolean ResultSetMetaData_isAutoIncrement(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return resultSetMetaData.do_isAutoIncrement(column);
    }

    @Override
    public boolean ResultSetMetaData_isCaseSensitive(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return resultSetMetaData.do_isCaseSensitive(column);
    }

    @Override
    public boolean ResultSetMetaData_isSearchable(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return resultSetMetaData.do_isSearchable(column);
    }

    @Override
    public boolean ResultSetMetaData_isCurrency(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return resultSetMetaData.do_isCurrency(column);
    }

    @Override
    public int ResultSetMetaData_isNullable(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return resultSetMetaData.do_isNullable(column);
    }

    @Override
    public boolean ResultSetMetaData_isSigned(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return resultSetMetaData.do_isSigned(column);
    }

    @Override
    public int ResultSetMetaData_getColumnDisplaySize(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return resultSetMetaData.do_getColumnDisplaySize(column);
    }

    @Override
    public String ResultSetMetaData_getColumnLabel(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return resultSetMetaData.do_getColumnLabel(column);
    }

    @Override
    public String ResultSetMetaData_getColumnName(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return resultSetMetaData.do_getColumnName(column);
    }

    @Override
    public String ResultSetMetaData_getSchemaName(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return resultSetMetaData.do_getSchemaName(column);
    }

    @Override
    public int ResultSetMetaData_getPrecision(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return resultSetMetaData.do_getPrecision(column);
    }

    @Override
    public int ResultSetMetaData_getScale(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return resultSetMetaData.do_getScale(column);
    }

    @Override
    public String ResultSetMetaData_getTableName(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return resultSetMetaData.do_getTableName(column);
    }

    @Override
    public String ResultSetMetaData_getCatalogName(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return resultSetMetaData.do_getCatalogName(column);
    }

    @Override
    public int ResultSetMetaData_getColumnType(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return resultSetMetaData.do_getColumnType(column);
    }

    @Override
    public String ResultSetMetaData_getColumnTypeName(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return resultSetMetaData.do_getColumnTypeName(column);
    }

    @Override
    public boolean ResultSetMetaData_isReadOnly(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return resultSetMetaData.do_isReadOnly(column);
    }

    @Override
    public boolean ResultSetMetaData_isWritable(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return resultSetMetaData.do_isWritable(column);
    }

    @Override
    public boolean ResultSetMetaData_isDefinitelyWritable(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return resultSetMetaData.do_isDefinitelyWritable(column);
    }

    @Override
    public String ResultSetMetaData_getColumnClassName(FilterChain filterChain, DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return resultSetMetaData.do_getColumnClassName(column);
    }

    @Override
    public ResultSet Statement_executeQuery(FilterChain filterChain, final DmdbStatement statement, final String sql) throws SQLException {
        return RWUtil2.execute(statement, sql, new ExecuteCallBack<ResultSet>(){

            @Override
            ResultSet execute() throws SQLException {
                return statement.rwInfo.stmtCurrent.do_executeQuery(sql);
            }

            @Override
            ResultSet execute(DmdbStatement otherStmt) throws SQLException {
                return otherStmt.do_executeQuery(sql);
            }
        });
    }

    @Override
    public int Statement_executeUpdate(FilterChain filterChain, final DmdbStatement statement, final String sql) throws SQLException {
        return RWUtil2.execute(statement, sql, new ExecuteCallBack<Integer>(){

            @Override
            Integer execute() throws SQLException {
                return statement.rwInfo.stmtCurrent.do_executeUpdate(sql);
            }

            @Override
            Integer execute(DmdbStatement otherStmt) throws SQLException {
                return otherStmt.do_executeUpdate(sql);
            }
        });
    }

    @Override
    public void Statement_close(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        try {
            if (RWUtil2.isStandbyStatementValid(statement)) {
                statement.rwInfo.stmtStandby.do_close();
            }
        }
        catch (SQLException e2) {
            RWUtil2.afterExceptionOnStandby(statement.connection, e2);
        }
        statement.do_close();
    }

    @Override
    public int Statement_getMaxFieldSize(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return statement.rwInfo.stmtCurrent.do_getMaxFieldSize();
    }

    @Override
    public void Statement_setMaxFieldSize(FilterChain filterChain, DmdbStatement statement, int max) throws SQLException {
        try {
            if (statement.rwInfo.stmtStandby != null) {
                statement.rwInfo.stmtStandby.do_setMaxFieldSize(max);
            }
        }
        catch (SQLException sQLException) {}
        statement.do_setMaxFieldSize(max);
    }

    @Override
    public int Statement_getMaxRows(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return statement.rwInfo.stmtCurrent.do_getMaxRows();
    }

    @Override
    public void Statement_setMaxRows(FilterChain filterChain, DmdbStatement statement, int max) throws SQLException {
        try {
            if (statement.rwInfo.stmtStandby != null) {
                statement.rwInfo.stmtStandby.do_setMaxRows(max);
            }
        }
        catch (SQLException sQLException) {}
        statement.do_setMaxRows(max);
    }

    @Override
    public void Statement_setEscapeProcessing(FilterChain filterChain, DmdbStatement statement, boolean enable) throws SQLException {
        if (statement.rwInfo.stmtStandby != null) {
            statement.rwInfo.stmtStandby.do_setEscapeProcessing(enable);
        }
        statement.do_setEscapeProcessing(enable);
    }

    @Override
    public int Statement_getQueryTimeout(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return statement.rwInfo.stmtCurrent.do_getQueryTimeout();
    }

    @Override
    public void Statement_setQueryTimeout(FilterChain filterChain, DmdbStatement statement, int seconds) throws SQLException {
        try {
            if (statement.rwInfo.stmtStandby != null) {
                statement.rwInfo.stmtStandby.do_setQueryTimeout(seconds);
            }
        }
        catch (SQLException sQLException) {}
        statement.do_setQueryTimeout(seconds);
    }

    @Override
    public void Statement_cancel(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        try {
            if (RWUtil2.isStandbyStatementValid(statement)) {
                statement.rwInfo.stmtStandby.do_cancel();
            }
        }
        catch (SQLException e2) {
            RWUtil2.afterExceptionOnStandby(statement.connection, e2);
        }
        statement.do_cancel();
    }

    @Override
    public SQLWarning Statement_getWarnings(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return statement.rwInfo.stmtCurrent.do_getWarnings();
    }

    @Override
    public void Statement_clearWarnings(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        if (statement.rwInfo.stmtStandby != null) {
            statement.rwInfo.stmtStandby.do_clearWarnings();
        }
        statement.do_clearWarnings();
    }

    @Override
    public void Statement_setCursorName(FilterChain filterChain, DmdbStatement statement, String name) throws SQLException {
        try {
            if (RWUtil2.isStandbyStatementValid(statement)) {
                statement.rwInfo.stmtStandby.do_setCursorName(name);
            }
        }
        catch (SQLException e2) {
            RWUtil2.afterExceptionOnStandby(statement.connection, e2);
        }
        statement.do_setCursorName(name);
    }

    @Override
    public boolean Statement_execute(FilterChain filterChain, final DmdbStatement statement, final String sql) throws SQLException {
        return RWUtil2.execute(statement, sql, new ExecuteCallBack<Boolean>(){

            @Override
            Boolean execute() throws SQLException {
                return statement.rwInfo.stmtCurrent.do_execute(sql);
            }

            @Override
            Boolean execute(DmdbStatement otherStmt) throws SQLException {
                return otherStmt.do_execute(sql);
            }
        });
    }

    @Override
    public ResultSet Statement_getResultSet(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return statement.rwInfo.stmtCurrent.do_getResultSet();
    }

    @Override
    public int Statement_getUpdateCount(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return statement.rwInfo.stmtCurrent.do_getUpdateCount();
    }

    @Override
    public boolean Statement_getMoreResults(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return statement.rwInfo.stmtCurrent.do_getMoreResults();
    }

    @Override
    public void Statement_setFetchDirection(FilterChain filterChain, DmdbStatement statement, int direction) throws SQLException {
        try {
            if (statement.rwInfo.stmtStandby != null) {
                statement.rwInfo.stmtStandby.do_setFetchDirection(direction);
            }
        }
        catch (SQLException sQLException) {}
        statement.do_setFetchDirection(direction);
    }

    @Override
    public int Statement_getFetchDirection(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return statement.rwInfo.stmtCurrent.do_getFetchDirection();
    }

    @Override
    public void Statement_setFetchSize(FilterChain filterChain, DmdbStatement statement, int rows) throws SQLException {
        try {
            if (statement.rwInfo.stmtStandby != null) {
                statement.rwInfo.stmtStandby.do_setFetchSize(rows);
            }
        }
        catch (SQLException sQLException) {}
        statement.do_setFetchSize(rows);
    }

    @Override
    public int Statement_getFetchSize(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return statement.rwInfo.stmtCurrent.do_getFetchSize();
    }

    @Override
    public int Statement_getResultSetConcurrency(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return statement.rwInfo.stmtCurrent.do_getResultSetConcurrency();
    }

    @Override
    public int Statement_getResultSetType(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return statement.rwInfo.stmtCurrent.do_getResultSetType();
    }

    @Override
    public void Statement_addBatch(FilterChain filterChain, DmdbStatement statement, String sql) throws SQLException {
        statement.rwInfo.stmtCurrent.do_addBatch(sql);
    }

    @Override
    public void Statement_clearBatch(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        if (statement.rwInfo.stmtStandby != null) {
            statement.rwInfo.stmtStandby.do_clearBatch();
        }
        statement.do_clearBatch();
    }

    @Override
    public int[] Statement_executeBatch(FilterChain filterChain, final DmdbStatement statement) throws SQLException {
        try {
            statement.clearBatch = false;
            if (statement.rwInfo.stmtStandby != null) {
                statement.rwInfo.stmtStandby.clearBatch = false;
            }
            int[] nArray = RWUtil2.execute(statement, null, new ExecuteCallBack<int[]>(){

                @Override
                int[] execute() throws SQLException {
                    return statement.rwInfo.stmtCurrent.do_executeBatch();
                }

                @Override
                int[] execute(DmdbStatement otherStmt) throws SQLException {
                    return otherStmt.do_executeBatch();
                }
            });
            return nArray;
        }
        finally {
            statement.do_clearBatch();
            statement.clearBatch = true;
            if (statement.rwInfo.stmtStandby != null) {
                statement.rwInfo.stmtStandby.do_clearBatch();
                statement.rwInfo.stmtStandby.clearBatch = true;
            }
        }
    }

    @Override
    public Connection Statement_getConnection(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return statement.do_getConnection();
    }

    @Override
    public boolean Statement_getMoreResults(FilterChain filterChain, DmdbStatement statement, int current) throws SQLException {
        return statement.rwInfo.stmtCurrent.do_getMoreResults(current);
    }

    @Override
    public ResultSet Statement_getGeneratedKeys(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return statement.rwInfo.stmtCurrent.do_getGeneratedKeys();
    }

    @Override
    public int Statement_executeUpdate(FilterChain filterChain, final DmdbStatement statement, final String sql, final int autoGeneratedKeys) throws SQLException {
        return RWUtil2.execute(statement, sql, new ExecuteCallBack<Integer>(){

            @Override
            Integer execute() throws SQLException {
                return statement.rwInfo.stmtCurrent.do_executeUpdate(sql, autoGeneratedKeys);
            }

            @Override
            Integer execute(DmdbStatement otherStmt) throws SQLException {
                return otherStmt.do_executeUpdate(sql, autoGeneratedKeys);
            }
        });
    }

    @Override
    public int Statement_executeUpdate(FilterChain filterChain, final DmdbStatement statement, final String sql, final int[] columnIndexes) throws SQLException {
        return RWUtil2.execute(statement, sql, new ExecuteCallBack<Integer>(){

            @Override
            Integer execute() throws SQLException {
                return statement.rwInfo.stmtCurrent.do_executeUpdate(sql, columnIndexes);
            }

            @Override
            Integer execute(DmdbStatement otherStmt) throws SQLException {
                return otherStmt.do_executeUpdate(sql, columnIndexes);
            }
        });
    }

    @Override
    public int Statement_executeUpdate(FilterChain filterChain, final DmdbStatement statement, final String sql, final String[] columnNames) throws SQLException {
        return RWUtil2.execute(statement, sql, new ExecuteCallBack<Integer>(){

            @Override
            Integer execute() throws SQLException {
                return statement.rwInfo.stmtCurrent.do_executeUpdate(sql, columnNames);
            }

            @Override
            Integer execute(DmdbStatement otherStmt) throws SQLException {
                return otherStmt.do_executeUpdate(sql, columnNames);
            }
        });
    }

    @Override
    public boolean Statement_execute(FilterChain filterChain, final DmdbStatement statement, final String sql, final int autoGeneratedKeys) throws SQLException {
        return RWUtil2.execute(statement, sql, new ExecuteCallBack<Boolean>(){

            @Override
            Boolean execute() throws SQLException {
                return statement.rwInfo.stmtCurrent.do_execute(sql, autoGeneratedKeys);
            }

            @Override
            Boolean execute(DmdbStatement otherStmt) throws SQLException {
                return otherStmt.do_execute(sql, autoGeneratedKeys);
            }
        });
    }

    @Override
    public boolean Statement_execute(FilterChain filterChain, final DmdbStatement statement, final String sql, final int[] columnIndexes) throws SQLException {
        return RWUtil2.execute(statement, sql, new ExecuteCallBack<Boolean>(){

            @Override
            Boolean execute() throws SQLException {
                return statement.rwInfo.stmtCurrent.do_execute(sql, columnIndexes);
            }

            @Override
            Boolean execute(DmdbStatement otherStmt) throws SQLException {
                return otherStmt.do_execute(sql, columnIndexes);
            }
        });
    }

    @Override
    public boolean Statement_execute(FilterChain filterChain, final DmdbStatement statement, final String sql, final String[] columnNames) throws SQLException {
        return RWUtil2.execute(statement, sql, new ExecuteCallBack<Boolean>(){

            @Override
            Boolean execute() throws SQLException {
                return statement.rwInfo.stmtCurrent.do_execute(sql, columnNames);
            }

            @Override
            Boolean execute(DmdbStatement otherStmt) throws SQLException {
                return otherStmt.do_execute(sql, columnNames);
            }
        });
    }

    @Override
    public int Statement_getResultSetHoldability(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return statement.rwInfo.stmtCurrent.do_getResultSetHoldability();
    }

    @Override
    public boolean Statement_isClosed(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return statement.rwInfo.stmtCurrent.do_isClosed();
    }

    @Override
    public void Statement_setPoolable(FilterChain filterChain, DmdbStatement statement, boolean poolable) throws SQLException {
        if (statement.rwInfo.stmtStandby != null) {
            statement.rwInfo.stmtStandby.do_setPoolable(poolable);
        }
        statement.do_setPoolable(poolable);
    }

    @Override
    public boolean Statement_isPoolable(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return statement.rwInfo.stmtCurrent.do_isPoolable();
    }

    @Override
    public void Statement_closeOnCompletion(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        if (statement.rwInfo.stmtStandby != null) {
            statement.rwInfo.stmtStandby.do_closeOnCompletion();
        }
        statement.do_closeOnCompletion();
    }

    @Override
    public boolean Statement_isCloseOnCompletion(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return statement.rwInfo.stmtCurrent.do_isCloseOnCompletion();
    }

    @Override
    public long Statement_getLargeUpdateCount(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return statement.rwInfo.stmtCurrent.do_getLargeUpdateCount();
    }

    @Override
    public void Statement_setLargeMaxRows(FilterChain filterChain, DmdbStatement statement, long max) throws SQLException {
        try {
            if (statement.rwInfo.stmtStandby != null) {
                statement.rwInfo.stmtStandby.do_setLargeMaxRows(max);
            }
        }
        catch (SQLException sQLException) {}
        statement.do_setLargeMaxRows(max);
    }

    @Override
    public long Statement_getLargeMaxRows(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return statement.rwInfo.stmtCurrent.do_getLargeMaxRows();
    }

    @Override
    public long[] Statement_executeLargeBatch(FilterChain filterChain, final DmdbStatement statement) throws SQLException {
        try {
            statement.clearBatch = false;
            if (statement.rwInfo.stmtStandby != null) {
                statement.rwInfo.stmtStandby.clearBatch = false;
            }
            long[] lArray = RWUtil2.execute(statement, null, new ExecuteCallBack<long[]>(){

                @Override
                long[] execute() throws SQLException {
                    return statement.rwInfo.stmtCurrent.do_executeLargeBatch();
                }

                @Override
                long[] execute(DmdbStatement otherStmt) throws SQLException {
                    return otherStmt.do_executeLargeBatch();
                }
            });
            return lArray;
        }
        finally {
            statement.do_clearBatch();
            statement.clearBatch = true;
            if (statement.rwInfo.stmtStandby != null) {
                statement.rwInfo.stmtStandby.do_clearBatch();
                statement.rwInfo.stmtStandby.clearBatch = true;
            }
        }
    }

    @Override
    public long Statement_executeLargeUpdate(FilterChain filterChain, final DmdbStatement statement, final String sql) throws SQLException {
        return RWUtil2.execute(statement, sql, new ExecuteCallBack<Long>(){

            @Override
            Long execute() throws SQLException {
                return statement.rwInfo.stmtCurrent.do_executeLargeUpdate(sql);
            }

            @Override
            Long execute(DmdbStatement otherStmt) throws SQLException {
                return otherStmt.do_executeLargeUpdate(sql);
            }
        });
    }

    @Override
    public long Statement_executeLargeUpdate(FilterChain filterChain, final DmdbStatement statement, final String sql, final int autoGeneratedKeys) throws SQLException {
        return RWUtil2.execute(statement, sql, new ExecuteCallBack<Long>(){

            @Override
            Long execute() throws SQLException {
                return statement.rwInfo.stmtCurrent.do_executeLargeUpdate(sql, autoGeneratedKeys);
            }

            @Override
            Long execute(DmdbStatement otherStmt) throws SQLException {
                return otherStmt.do_executeLargeUpdate(sql, autoGeneratedKeys);
            }
        });
    }

    @Override
    public long Statement_executeLargeUpdate(FilterChain filterChain, final DmdbStatement statement, final String sql, final int[] columnIndexes) throws SQLException {
        return RWUtil2.execute(statement, sql, new ExecuteCallBack<Long>(){

            @Override
            Long execute() throws SQLException {
                return statement.rwInfo.stmtCurrent.do_executeLargeUpdate(sql, columnIndexes);
            }

            @Override
            Long execute(DmdbStatement otherStmt) throws SQLException {
                return otherStmt.do_executeLargeUpdate(sql, columnIndexes);
            }
        });
    }

    @Override
    public long Statement_executeLargeUpdate(FilterChain filterChain, final DmdbStatement statement, final String sql, final String[] columnNames) throws SQLException {
        return RWUtil2.execute(statement, sql, new ExecuteCallBack<Long>(){

            @Override
            Long execute() throws SQLException {
                return statement.rwInfo.stmtCurrent.do_executeLargeUpdate(sql, columnNames);
            }

            @Override
            Long execute(DmdbStatement otherStmt) throws SQLException {
                return otherStmt.do_executeLargeUpdate(sql, columnNames);
            }
        });
    }

    @Override
    public long Statement_getExecuteId(FilterChain filterChain, DmdbStatement statement) {
        return statement.rwInfo.stmtCurrent.do_getExecuteId();
    }

    @Override
    public String Statement_getPrintMsg(FilterChain filterChain, DmdbStatement statement) {
        return statement.rwInfo.stmtCurrent.do_getPrintMsg();
    }

    @Override
    public int Statement_getSqlType(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return statement.rwInfo.stmtCurrent.do_getSqlType();
    }

    @Override
    public RowId Statement_getRowId(FilterChain filterChain, DmdbStatement statement) throws SQLException {
        return statement.rwInfo.stmtCurrent.do_getRowId();
    }

    @Override
    public ResultSet[] Statement_getResultSets(FilterChain filterChain, DmdbStatement statement) {
        return statement.rwInfo.stmtCurrent.do_getResultSets();
    }

    @Override
    public void Connection_reset(FilterChain filterChain, DmdbConnection connection) throws SQLException {
        try {
            if (RWUtil2.isStandbyAlive(connection)) {
                connection.rwInfo.connStandby.do_reset();
            }
        }
        catch (SQLException e2) {
            RWUtil2.afterExceptionOnStandby(connection, e2);
        }
        connection.do_reset();
    }

    @Override
    public String Statement_getExplain(FilterChain filterChain, DmdbStatement dmdbStatement) {
        return filterChain.Statement_getExplain(dmdbStatement);
    }

    @Override
    public ResultSet CallableStatement_getCursor(FilterChain filterChain, DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getCursor(parameterName);
    }

    @Override
    public void CallableStatement_setINTERVALDT(FilterChain filterChain, DmdbCallableStatement callableStatement, String paramName, DmdbIntervalDT x2) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_setINTERVALDT(paramName, x2);
    }

    @Override
    public void CallableStatement_setINTERVALYM(FilterChain filterChain, DmdbCallableStatement callableStatement, String paramName, DmdbIntervalYM x2) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_setINTERVALYM(paramName, x2);
    }

    @Override
    public void CallableStatement_setTIMESTAMP(FilterChain filterChain, DmdbCallableStatement callableStatement, String paramName, DmdbTimestamp x2) throws SQLException {
        callableStatement.rwInfo.getCstmtCurrent().do_setTIMESTAMP(paramName, x2);
    }

    @Override
    public DmdbTimestamp CallableStatement_getTIMESTAMP(FilterChain filterChain, DmdbCallableStatement callableStatement, String paramName) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getTIMESTAMP(paramName);
    }

    @Override
    public DmdbIntervalDT CallableStatement_getINTERVALDT(FilterChain filterChain, DmdbCallableStatement callableStatement, String paramName) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getINTERVALDT(paramName);
    }

    @Override
    public DmdbIntervalYM CallableStatement_getINTERVALYM(FilterChain filterChain, DmdbCallableStatement callableStatement, String paramName) throws SQLException {
        return callableStatement.rwInfo.getCstmtCurrent().do_getINTERVALYM(paramName);
    }

    @Override
    public void XAResource_start(FilterChain filterChain, DmdbXAResource xaResource, Xid xid, int flags) throws XAException {
        xaResource.do_start(xid, flags);
    }

    @Override
    public void XAResource_end(FilterChain filterChain, DmdbXAResource xaResource, Xid xid, int flags) throws XAException {
        xaResource.do_end(xid, flags);
    }

    @Override
    public boolean XAResource_setTransactionTimeout(FilterChain filterChain, DmdbXAResource xaResource, int seconds) throws XAException {
        return xaResource.do_setTransactionTimeout(seconds);
    }

    @Override
    public int XAResource_getTransactionTimeout(FilterChain filterChain, DmdbXAResource xaResource) throws XAException {
        return xaResource.do_getTransactionTimeout();
    }

    @Override
    public void XAResource_rollback(FilterChain filterChain, DmdbXAResource xaResource, Xid xid) throws XAException {
        xaResource.do_rollback(xid);
    }

    @Override
    public void XAResource_commit(FilterChain filterChain, DmdbXAResource xaResource, Xid xid, boolean onePhase) throws XAException {
        xaResource.do_commit(xid, onePhase);
    }

    @Override
    public Xid[] XAResource_recover(FilterChain filterChain, DmdbXAResource xaResource, int flag) throws XAException {
        return xaResource.do_recover(flag);
    }

    @Override
    public int XAResource_prepare(FilterChain filterChain, DmdbXAResource xaResource, Xid xid) throws XAException {
        return xaResource.do_prepare(xid);
    }

    @Override
    public boolean XAResource_isSameRM(FilterChain filterChain, DmdbXAResource xaResource, XAResource xaRes) throws XAException {
        return xaResource.do_isSameRM(xaRes);
    }

    @Override
    public void XAResource_forget(FilterChain filterChain, DmdbXAResource xaResource, Xid xid) throws XAException {
        xaResource.do_forget(xid);
    }
}

