/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter;

import dm.jdbc.desc.conf.DmProperties;
import dm.jdbc.desc.conf.DmSvcConf;
import dm.jdbc.desc.enums.ExecuteType;
import dm.jdbc.desc.enums.RWSite;
import dm.jdbc.driver.Configuration;
import dm.jdbc.driver.DmdbCallableStatement;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.filter.DpcFilter;
import dm.jdbc.filter.Filter;
import dm.jdbc.filter.FilterChain;
import dm.jdbc.filter.custom.CustomFilter;
import dm.jdbc.filter.fldr.FldrFilter;
import dm.jdbc.filter.fldr.FldrTableInfo;
import dm.jdbc.filter.log.LogFilter;
import dm.jdbc.filter.reconnect.ReconnectFilter;
import dm.jdbc.filter.rw.RWCounter;
import dm.jdbc.filter.rw.RWFilter;
import dm.jdbc.filter.rw.RWFilter2;
import dm.jdbc.filter.stat.ConnectionStat;
import dm.jdbc.filter.stat.SqlStat;
import dm.jdbc.filter.stat.StatFilter;
import dm.jdbc.filter.stat.StatService;
import dm.jdbc.util.StringUtil;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;

public abstract class Filterable {
    protected FilterChain filterChain = null;
    public RWInfo rwInfo = null;
    public LogInfo logInfo = null;
    public StatInfo statInfo = null;
    public FldrInfo fldrInfo = null;
    protected long ID = -1L;

    public abstract long getID();

    public Filterable(DmdbConnection connection, DmProperties props) {
        this.filterChain = this.createFilterChain(connection, props);
    }

    public FilterChain createFilterChain(DmdbConnection connection, DmProperties props) {
        String customFilter;
        FilterChain filterChain = null;
        ArrayList<Filter> filters = new ArrayList<Filter>();
        props = props == null && connection != null ? connection.props : props;
        String string = customFilter = props == null ? null : props.getString(Configuration.customFilter);
        if (StringUtil.isNotEmpty(customFilter)) {
            filters.add(CustomFilter.getInstance(customFilter));
        }
        if (connection != null) {
            if (DmSvcConf.GLOBAL.logLevel != 0) {
                filters = filters == null ? new ArrayList<Filter>() : filters;
                filters.add(LogFilter.getInstance());
                this.logInfo = new LogInfo();
            }
            if (DmSvcConf.GLOBAL.statEnable) {
                filters = filters == null ? new ArrayList() : filters;
                filters.add(StatFilter.getInstance());
                this.statInfo = new StatInfo();
            }
            if (connection.epGroup != null && connection.epGroup.reconnect != 0) {
                filters = filters == null ? new ArrayList() : filters;
                filters.add(ReconnectFilter.getInstance());
            }
            if (connection.mppOpt > 0) {
                filters = filters == null ? new ArrayList<Filter>() : filters;
                filters.add(FldrFilter.getInstance());
                this.fldrInfo = new FldrInfo();
            }
            if (connection.epGroup != null && connection.epGroup.cluster == 5) {
                filters = filters == null ? new ArrayList<Filter>() : filters;
                filters.add(DpcFilter.getInstance());
            }
            if (connection.rwSeparate > 0) {
                filters = filters == null ? new ArrayList() : filters;
                filters.add(connection.rwSeparate >= 3 ? RWFilter.getInstance() : RWFilter2.getInstance());
                this.rwInfo = new RWInfo();
            }
        } else if (props != null) {
            if (Configuration.parseLogLevel(props) != 0) {
                filters = filters == null ? new ArrayList<Filter>() : filters;
                filters.add(LogFilter.getInstance());
                this.logInfo = new LogInfo();
            }
            if (props.getBoolean(Configuration.statEnable)) {
                filters = filters == null ? new ArrayList<Filter>() : filters;
                filters.add(StatFilter.getInstance());
                this.statInfo = new StatInfo();
            }
            if (props.getInt(Configuration.reconnect) != 0) {
                filters = filters == null ? new ArrayList<Filter>() : filters;
                filters.add(ReconnectFilter.getInstance());
            }
            if (props.getInt(Configuration.mppOpt) > 0) {
                filters = filters == null ? new ArrayList<Filter>() : filters;
                filters.add(FldrFilter.getInstance());
                this.fldrInfo = new FldrInfo();
            }
            if (Configuration.parseCluster(props) == 5) {
                filters = filters == null ? new ArrayList<Filter>() : filters;
                filters.add(DpcFilter.getInstance());
            }
            int rwSeparate = 0;
            rwSeparate = props.getInt(Configuration.rwSeparate);
            if (rwSeparate > 0) {
                filters = filters == null ? new ArrayList<Filter>() : filters;
                filters.add(rwSeparate >= 3 ? RWFilter.getInstance() : RWFilter2.getInstance());
                this.rwInfo = new RWInfo();
            }
        }
        if (filters != null && filters.size() > 0) {
            filterChain = new FilterChain(filters.toArray(new Filter[0]));
        }
        return filterChain;
    }

    public class FldrInfo {
        public ConcurrentHashMap<Integer, DmdbConnection> fldrConnMap;
        public int fldrConnSize = 0;
        public ExecutorService fldrExecutor;
        public FldrTableInfo fldrTableInfo = null;
        public ConcurrentHashMap<Integer, DmdbStatement> fldrStmtMap = null;
        protected int fldrStmtSize = 0;

        public void clearFldr() {
            if (this.fldrConnMap != null) {
                this.fldrConnMap.clear();
                this.fldrConnMap = null;
                this.fldrConnSize = 0;
            }
            if (this.fldrExecutor != null) {
                this.fldrExecutor.shutdownNow();
                this.fldrExecutor = null;
            }
            if (this.fldrStmtMap != null) {
                this.fldrStmtMap.clear();
                this.fldrStmtMap = null;
                this.fldrStmtSize = 0;
            }
        }

        public int getFldrConnSize() {
            return this.fldrConnSize;
        }

        public void setFldrConnSize(int size) {
            this.fldrConnSize = size;
        }

        public void setFldrStmtSize(int fldrStmtSize) {
            this.fldrStmtSize = fldrStmtSize;
        }

        public int getFldrStmtSize() {
            return this.fldrStmtSize;
        }
    }

    public class LogInfo {
        public long lastExecuteStartNano;
    }

    public class RWInfo {
        public RWSite distribute = RWSite.PRIMARY;
        public RWCounter rwCounter = null;
        public DmdbConnection connStandby = null;
        public long tryRecoverTs = 0L;
        public DmdbStatement stmtStandby = null;
        public DmdbStatement stmtCurrent = null;
        public boolean readOnly = true;

        public DmdbStatement getStmtStandby() {
            return this.stmtStandby;
        }

        public DmdbStatement getStmtCurrent() {
            return this.stmtCurrent;
        }

        public DmdbPreparedStatement getPstmtStandby() {
            return this.stmtStandby instanceof DmdbPreparedStatement ? (DmdbPreparedStatement)this.stmtStandby : null;
        }

        public DmdbPreparedStatement getPstmtCurrent() {
            return this.stmtCurrent instanceof DmdbPreparedStatement ? (DmdbPreparedStatement)this.stmtCurrent : null;
        }

        public DmdbCallableStatement getCstmtStandby() {
            return this.stmtStandby instanceof DmdbCallableStatement ? (DmdbCallableStatement)this.stmtStandby : null;
        }

        public DmdbCallableStatement getCstmtCurrent() {
            return this.stmtCurrent instanceof DmdbCallableStatement ? (DmdbCallableStatement)this.stmtCurrent : null;
        }

        public void cleanup() {
            this.distribute = RWSite.PRIMARY;
            this.rwCounter = null;
            this.connStandby = null;
            this.stmtStandby = null;
            this.stmtCurrent = null;
        }

        public RWSite toPrimary() {
            if (this.distribute != RWSite.PRIMARY) {
                this.rwCounter.countPrimary();
            }
            this.distribute = RWSite.PRIMARY;
            return this.distribute;
        }

        public RWSite toStandby() {
            if (this.distribute != RWSite.STANDBY) {
                this.rwCounter.countStandby();
            }
            this.distribute = RWSite.STANDBY;
            return this.distribute;
        }

        public RWSite toAny() {
            this.distribute = this.rwCounter.count(RWSite.ANY, this.connStandby);
            return this.distribute;
        }
    }

    public class StatInfo {
        public long constructNano;
        public ConnectionStat connStat;
        public long lastExecuteStartNano;
        public long lastExecuteTimeNano;
        public ExecuteType lastExecuteType;
        public boolean firstResultSet;
        public String lastExecuteSql;
        public SqlStat sqlStat;
        public String sql;
        public int cursorIndex = 0;
        public int closeCount = 0;
        public long readStringLength = 0L;
        public long readBytesLength = 0L;
        public int openInputStreamCount = 0;
        public int openReaderCount = 0;

        public void init(DmdbConnection conn) {
            this.connStat = StatService.jdbcStat.createConnStat(conn);
        }

        public void setConstructNano() {
            this.constructNano = System.nanoTime();
        }

        public long getConstructNano() {
            return this.constructNano;
        }

        public ConnectionStat getConnStat() {
            return this.connStat;
        }

        public long getLastExecuteStartNano() {
            return this.lastExecuteStartNano;
        }

        public void setLastExecuteStartNano(long lastExecuteStartNano) {
            this.lastExecuteStartNano = lastExecuteStartNano;
        }

        public long getLastExecuteTimeNano() {
            return this.lastExecuteTimeNano;
        }

        public void setLastExecuteTimeNano(long lastExecuteTimeNano) {
            this.lastExecuteTimeNano = lastExecuteTimeNano;
        }

        public ExecuteType getLastExecuteType() {
            return this.lastExecuteType;
        }

        public void setLastExecuteType(ExecuteType lastExecuteType) {
            this.lastExecuteType = lastExecuteType;
        }

        public boolean isFirstResultSet() {
            return this.firstResultSet;
        }

        public void setFirstResultSet(boolean firstResultSet) {
            this.firstResultSet = firstResultSet;
        }

        public String getLastExecuteSql() {
            return this.lastExecuteSql;
        }

        public void setLastExecuteSql(String lastExecuteSql) {
            this.lastExecuteSql = lastExecuteSql;
        }

        public SqlStat getSqlStat() {
            return this.sqlStat;
        }

        public void setSqlStat(SqlStat sqlStat) {
            this.sqlStat = sqlStat;
        }

        public void setConnStat(ConnectionStat connStat) {
            this.connStat = connStat;
        }

        public void setConstructNano(long constructNano) {
            this.constructNano = constructNano;
        }

        public void afterExecute(long nanoSpan) {
            this.lastExecuteTimeNano = nanoSpan;
        }

        public void beforeExecute() {
            this.lastExecuteStartNano = System.nanoTime();
        }

        public String getSql() {
            return this.sql;
        }

        public void setSql(String sql) {
            this.sql = sql;
        }

        public int getCursorIndex() {
            return this.cursorIndex;
        }

        public void setCursorIndex(int cursorIndex) {
            this.cursorIndex = cursorIndex;
        }

        public int getCloseCount() {
            return this.closeCount;
        }

        public void setCloseCount(int closeCount) {
            this.closeCount = closeCount;
        }

        public long getReadStringLength() {
            return this.readStringLength;
        }

        public void setReadStringLength(long readStringLength) {
            this.readStringLength = readStringLength;
        }

        public long getReadBytesLength() {
            return this.readBytesLength;
        }

        public void setReadBytesLength(long readBytesLength) {
            this.readBytesLength = readBytesLength;
        }

        public int getOpenInputStreamCount() {
            return this.openInputStreamCount;
        }

        public void setOpenInputStreamCount(int openInputStreamCount) {
            this.openInputStreamCount = openInputStreamCount;
        }

        public int getOpenReaderCount() {
            return this.openReaderCount;
        }

        public void setOpenReaderCount(int openReaderCount) {
            this.openReaderCount = openReaderCount;
        }

        public void incrementCloseCount() {
            this.closeCount = this.closeCount++;
        }
    }
}

