/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.desc.ExecuteRetInfo;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbResultSetCache;
import dm.jdbc.driver.DmdbResultSetKey;
import dm.jdbc.driver.DmdbStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DmdbResultSetCachePool {
    static Map<DmdbResultSetKey, DmdbResultSetCache> rsHashMap = null;
    static List<DmdbResultSetKey> keyList = null;
    static long totalDataLen;

    static {
        rsHashMap = Collections.synchronizedMap(new HashMap(100));
        keyList = Collections.synchronizedList(new LinkedList());
        totalDataLen = 0L;
    }

    private static long removeLast() {
        int size = keyList.size();
        if (size == 0) {
            return 0L;
        }
        DmdbResultSetKey rsKey = keyList.remove(size - 1);
        if (rsKey == null) {
            return 0L;
        }
        DmdbResultSetCache crs = rsHashMap.remove(rsKey);
        if (crs == null) {
            return 0L;
        }
        return crs.getDataLen();
    }

    private static void refreshKeyList(DmdbResultSetKey rsKey) {
        keyList.remove(rsKey);
        keyList.add(0, rsKey);
    }

    public static void addResultSet(DmdbStatement statement, String sql, ExecuteRetInfo execInfo) throws SQLException {
        DmdbConnection conn = statement.connection;
        long dataLen = execInfo == null ? 0L : execInfo.rsSizeof;
        long cacheSize = conn.rsCacheSize * 1024 * 1024;
        while (totalDataLen + dataLen > cacheSize) {
            if (totalDataLen == 0L) {
                return;
            }
            totalDataLen -= DmdbResultSetCachePool.removeLast();
        }
        DmdbResultSetKey rsKey = new DmdbResultSetKey(conn.guid, conn.schema, sql, statement);
        DmdbResultSetCachePool.refreshKeyList(rsKey);
        DmdbResultSetCache crs = new DmdbResultSetCache(execInfo);
        rsHashMap.put(rsKey, crs);
        totalDataLen += dataLen;
    }

    public static DmdbResultSetCache getResultSetCache(String guid, String curSch, String sql, DmdbStatement stmt) throws SQLException {
        DmdbResultSetKey rsKey = new DmdbResultSetKey(guid, curSch, sql, stmt);
        DmdbResultSetCache crs = rsHashMap.get(rsKey);
        if (crs == null) {
            return null;
        }
        if (crs.refreshed(stmt.connection)) {
            rsHashMap.remove(rsKey);
            keyList.remove(rsKey);
            return null;
        }
        DmdbResultSetCachePool.refreshKeyList(rsKey);
        return crs;
    }
}

