/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.desc.convert;

import dm.jdbc.desc.convert.OffRowData;
import dm.jdbc.driver.DBError;
import dm.jdbc.internal.IDmdbConnection;
import dm.jdbc.util.ByteArrayQueue;
import dm.jdbc.util.ByteUtil;
import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;

public class OffRowReaderData
extends OffRowData {
    public OffRowReaderData(Reader reader, IDmdbConnection conn, long targetLength) throws SQLException {
        super(reader, conn, targetLength);
        this.init();
    }

    @Override
    public void read(ByteArrayQueue byteArray) throws SQLException {
        if (this.getBufferLeaveLen() > 0) {
            this.readFromBuffer(byteArray);
        } else if (!this.readOver) {
            int readLen = this.READ_LEN;
            if (this.targetLength != -1L) {
                readLen = (int)(this.targetLength - this.position > (long)readLen ? (long)readLen : this.targetLength - this.position);
            }
            try {
                Reader reader = (Reader)this.obj;
                char[] chars = new char[readLen];
                readLen = reader.read(chars, 0, chars.length);
                if (readLen <= 0) {
                    this.readOver = true;
                    return;
                }
                byte[] readBytes = ByteUtil.fromString(new String(chars, 0, readLen), this.encoding);
                this.position += (long)readLen;
                if (readLen < chars.length || this.targetLength != -1L && this.position == this.targetLength) {
                    this.readOver = true;
                }
                byteArray.putBytes(readBytes, 0, readBytes.length);
            }
            catch (IOException e2) {
                DBError.throwException(e2.getMessage(), e2);
            }
        }
    }

    @Override
    public byte[] readAll() throws SQLException {
        ByteArrayQueue byteArray = new ByteArrayQueue();
        this.read(byteArray);
        while (!this.readOver) {
            this.read(byteArray);
        }
        return byteArray.toBytes();
    }
}

