/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.desc;

import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.util.DriverUtil;
import dm.jdbc.util.StringUtil;
import java.sql.SQLException;

public class SQLName {
    String m_name = "";
    String m_pkgName = "";
    String m_schName = "";
    String m_fulName = "";
    int m_schId = -1;
    int m_packId = -1;
    DmdbConnection m_conn = null;

    SQLName(String fulName) {
        this.m_fulName = fulName;
    }

    public SQLName(DmdbConnection conn) {
        this.m_conn = conn;
    }

    String getFulName() throws SQLException {
        if (this.m_fulName.length() > 0) {
            return this.m_fulName;
        }
        if (StringUtil.isEmpty(this.m_name)) {
            return null;
        }
        if (this.m_packId != 0 || this.m_schId != 0) {
            String sql = "SELECT NAME INTO ? FROM SYS.SYSOBJECTS WHERE ID=?";
            Object[] inParams = new Object[2];
            inParams[1] = this.m_packId != 0 ? this.m_packId : this.m_schId;
            Integer[] outParamTypes = new Integer[2];
            outParamTypes[0] = 12;
            Object[] outParams = DriverUtil.executePrepareCall(this.m_conn, sql, inParams, outParamTypes);
            if (this.m_packId != 0) {
                this.m_pkgName = (String)outParams[0];
                this.m_fulName = String.valueOf(this.m_pkgName) + "." + this.m_name;
            } else {
                this.m_schName = (String)outParams[0];
                this.m_fulName = String.valueOf(this.m_schName) + "." + this.m_name;
            }
        }
        if (this.m_fulName.length() > 0) {
            return this.m_fulName;
        }
        return this.m_name;
    }
}

