/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.desc;

import dm.jdbc.desc.TypeDescriptor;
import dm.jdbc.driver.DmdbType;

public class Column {
    public String typeName = "";
    public int type = 0;
    public int prec = 0;
    public int scale = 0;
    public String name = "";
    public String tableName = "";
    public String schemaName = "";
    public boolean nullable = false;
    public boolean identity = false;
    public boolean readonly = false;
    public String baseName = "";
    public boolean lob = false;
    public int lobTabId;
    public int lobColId;
    public TypeDescriptor typeDescriptor = null;
    public boolean isBdta = false;
    public static final int MASK_ORACLE_DATE = 1;
    public static final int MASK_ORACLE_FLOAT = 2;
    public static final int MASK_BFILE = 3;
    public static final int MASK_LOCAL_DATETIME = 4;
    public int mask = 0;

    public static int getMaxTupleLen(Column[] cols, int maxRowSize) {
        int tmp_tuple_len = 0;
        int i2 = 0;
        while (i2 < cols.length) {
            int dType = cols[i2].type;
            if (dType == 12 || dType == 19 || DmdbType.isComplexType(dType, cols[i2].scale)) {
                tmp_tuple_len = maxRowSize;
                break;
            }
            tmp_tuple_len += cols[i2].prec;
            i2 = (short)(i2 + 1);
        }
        if (tmp_tuple_len > maxRowSize) {
            tmp_tuple_len = maxRowSize;
        }
        return tmp_tuple_len += 10 + 2 * cols.length + 8;
    }

    protected Object clone() {
        Column param = new Column();
        param.baseName = this.baseName;
        param.identity = this.identity;
        param.isBdta = this.isBdta;
        param.lob = this.lob;
        param.lobColId = this.lobColId;
        param.lobTabId = this.lobTabId;
        param.name = this.name;
        param.nullable = this.nullable;
        param.prec = this.prec;
        param.readonly = this.readonly;
        param.scale = this.scale;
        param.schemaName = this.schemaName;
        param.tableName = this.tableName;
        param.type = this.type;
        param.typeDescriptor = this.typeDescriptor;
        param.typeName = this.typeName;
        param.mask = this.mask;
        return param;
    }
}

