/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.commons.slnbase.service.right.util;

import com.bokesoft.yes.mid.rights.RightsProviderFactory;
import com.bokesoft.yes.mid.rights.cache.IRightsCache;
import com.bokesoft.yes.mid.rights.cache.RightsCacheFactory;
import com.bokesoft.yigo.commons.slnbase.service.right.enums.TargetType;
import com.bokesoft.yigo.commons.slnbase.service.right.struct.DictRight;
import com.bokesoft.yigo.commons.slnbase.service.right.struct.EntryRight;
import com.bokesoft.yigo.commons.slnbase.service.right.struct.FormRight;
import com.bokesoft.yigo.commons.slnbase.service.right.struct.RightSaveVO;
import com.bokesoft.yigo.commons.slnbase.service.right.util.RightCacheUtil;
import com.bokesoft.yigo.commons.slnbase.service.right.util.RightUtil;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.rights.EntryRights;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class RightIOUtil {
    public static void Save(DefaultContext ctx, Long roleID, Long operatorID, String viewId) throws Throwable {
        RightSaveVO rightVO = RightIOUtil.buildRightIO(ctx, roleID, operatorID);
        RightIOUtil.saveEntry(ctx, rightVO.getEntryRight(), rightVO.getOperatorId(), rightVO.getRoleId());
        RightIOUtil.saveFormOptRight(ctx, rightVO.getFormRights(), rightVO.getOperatorId(), rightVO.getRoleId());
        RightIOUtil.saveFormFieldRight(ctx, rightVO.getFormRights(), rightVO.getOperatorId(), rightVO.getRoleId());
        RightIOUtil.saveDictDataRight(ctx, rightVO.getDictRights(), rightVO.getOperatorId(), rightVO.getRoleId());
        RightCacheUtil.clearCacheByViewId(ctx.getVE().getClientID(), viewId);
    }

    private static RightSaveVO buildRightIO(DefaultContext ctx, Long roleID, Long operatorID) {
        RightSaveVO rightIO = new RightSaveVO();
        rightIO.setOperatorId(operatorID);
        rightIO.setRoleId(roleID);
        Long relatedId = -1L;
        TargetType targetType = null;
        if (roleID > 0L) {
            targetType = TargetType.ROLE;
            relatedId = roleID;
        } else if (operatorID > 0L) {
            targetType = TargetType.OPERATOR;
            relatedId = operatorID;
        }
        Document document = ctx.getDocument();
        DataTable head = document.get("YES_RS_RightsSet");
        String formKey = head.getString("FormKey");
        String itemKey = head.getString("ItemKey");
        DataTable entryRightDT = document.get("YES_RS_EntryRights");
        EntryRight entryRight = new EntryRight();
        entryRight.setHasAllEntry(head.getInt("All_Entry") == 1);
        entryRight.setEntryList(new ArrayList<EntryRight.Entry>());
        if (entryRightDT != null) {
            entryRightDT.beforeFirst();
            while (entryRightDT.next()) {
                EntryRight.Entry entry = new EntryRight.Entry();
                entry.setEntryKey(entryRightDT.getString("EntryKey"));
                entry.setEntryName(entryRightDT.getString("EntryName"));
                entry.setId(entryRightDT.getLong("OID"));
                entry.setPid(entryRightDT.getLong("ParentID"));
                entry.setSelectE(entryRightDT.getInt("select_E") == 1);
                entryRight.getEntryList().add(entry);
            }
        }
        rightIO.setEntryRight(entryRight);
        Map<String, DictRight> dictRights = RightCacheUtil.getDictRights(ctx, targetType, relatedId);
        Map<String, FormRight> formRights = RightCacheUtil.getFormRights(ctx, targetType, relatedId);
        if (StringUtils.isNotEmpty((CharSequence)formKey) && !formRights.containsKey(formKey)) {
            formRights.put(formKey, RightUtil.buildFormRightByDoc(document));
        }
        if (StringUtils.isNotEmpty((CharSequence)itemKey) && !dictRights.containsKey(itemKey)) {
            DictRight dictRight = RightUtil.buildDictRightByDoc(document);
            dictRights.put(itemKey, dictRight);
        }
        rightIO.setDictRights(new ArrayList<DictRight>(dictRights.values()));
        rightIO.setFormRights(new ArrayList<FormRight>(formRights.values()));
        return rightIO;
    }

    private static void saveEntry(DefaultContext ctx, EntryRight entryRight, Long operatorID, Long roleID) throws Throwable {
        String dSql = "";
        String iSql = "";
        long relatedID = -1L;
        IRightsCache rightsCache = null;
        if (roleID > -1L) {
            relatedID = roleID;
            rightsCache = RightsCacheFactory.getInstance().createRoleRightsCache();
            dSql = "DELETE FROM SYS_RoleEntryRights where RoleID=?";
            iSql = "INSERT INTO SYS_RoleEntryRights (EntryKey,RoleID) VALUES ";
        } else if (operatorID > -1L) {
            relatedID = operatorID;
            rightsCache = RightsCacheFactory.getInstance().createOperatorRightsCache();
            dSql = "DELETE FROM SYS_OperatorEntryRights where OperatorID=?";
            iSql = "INSERT INTO SYS_OperatorEntryRights (EntryKey,OperatorID) VALUES ";
        }
        ctx.getDBManager().execPrepareUpdate(dSql, new Object[]{relatedID});
        StringBuffer updateSqlbf = new StringBuffer(iSql);
        ArrayList<Object> args = new ArrayList<Object>();
        EntryRights currentER = RightsProviderFactory.getInstance().newRightsProvider(ctx).getEntryRights();
        if (entryRight.isHasAllEntry() && currentER.hasAllRights()) {
            updateSqlbf.append("(?,?),");
            args.add("*");
            args.add(relatedID);
        } else {
            List<EntryRight.Entry> entries = entryRight.getEntryList();
            if (entries != null) {
                for (EntryRight.Entry entry : entries) {
                    if (!entry.isSelectE()) continue;
                    updateSqlbf.append("(?,?),");
                    args.add(entry.getEntryKey());
                    args.add(relatedID);
                }
            }
        }
        if (args.size() > 0) {
            ctx.getDBManager().execPrepareUpdate(updateSqlbf.substring(0, updateSqlbf.length() - 1), args);
        }
        rightsCache.clearEntryRights(relatedID);
    }

    private static void saveFormFieldRight(DefaultContext ctx, List<FormRight> formRights, Long operatorID, Long roleID) throws Throwable {
        String dSql = "";
        String iSql = "";
        long relatedID = -1L;
        IRightsCache rightsCache = null;
        if (roleID > -1L) {
            relatedID = roleID;
            dSql = "DELETE FROM SYS_RoleFieldRights where RoleID=? AND FormKey=?";
            iSql = "INSERT INTO SYS_RoleFieldRights (FormKey,FieldKey,Visible,Enable,RoleID) VALUES ";
            rightsCache = RightsCacheFactory.getInstance().createRoleRightsCache();
        } else if (operatorID > -1L) {
            relatedID = operatorID;
            dSql = "DELETE FROM SYS_OperatorFieldRights where OperatorID=? AND FormKey=?";
            iSql = "INSERT INTO SYS_OperatorFieldRights (FormKey,FieldKey,Visible,Enable,OperatorID) VALUES ";
            rightsCache = RightsCacheFactory.getInstance().createOperatorRightsCache();
        }
        StringBuffer updateSqlbf = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        for (FormRight formRight : formRights) {
            args.clear();
            updateSqlbf.setLength(0);
            updateSqlbf.append(iSql);
            String formKey = formRight.getFormKey();
            ctx.getDBManager().execPrepareUpdate(dSql, new Object[]{relatedID, formKey});
            List<FormRight.Field> fields = formRight.getField();
            for (FormRight.Field field : fields) {
                if (field.isEdit() && field.isVisible()) continue;
                updateSqlbf.append("(?,?,?,?,?),");
                args.add(formKey);
                args.add(field.getFieldKey());
                args.add(field.isVisible() ? 1 : 0);
                args.add(field.isEdit() ? 1 : 0);
                args.add(relatedID);
            }
            if (args.size() > 0) {
                ctx.getDBManager().execPrepareUpdate(updateSqlbf.substring(0, updateSqlbf.length() - 1), args);
            }
            rightsCache.clearFormRights(relatedID, formKey);
        }
    }

    private static void saveFormOptRight(DefaultContext ctx, List<FormRight> formRights, Long operatorID, Long roleID) throws Throwable {
        String dSql = "";
        String iSql = "";
        long relatedID = -1L;
        IRightsCache rightsCache = null;
        if (roleID > -1L) {
            relatedID = roleID;
            dSql = "DELETE FROM SYS_RoleOptRights where RoleID=? AND FormKey=?";
            iSql = "INSERT INTO SYS_RoleOptRights (FormKey, OptKey,RoleID) VALUES ";
            rightsCache = RightsCacheFactory.getInstance().createRoleRightsCache();
        } else if (operatorID > -1L) {
            relatedID = operatorID;
            dSql = "DELETE FROM SYS_OperatorOptRights where OperatorID=? AND FormKey=?";
            iSql = "INSERT INTO SYS_OperatorOptRights (FormKey, OptKey,OperatorID) VALUES ";
            rightsCache = RightsCacheFactory.getInstance().createOperatorRightsCache();
        }
        StringBuffer updateSqlbf = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        HashSet<String> optKeys = RightIOUtil.getFormKeysOfHasAllOptRight(ctx);
        for (FormRight formRight : formRights) {
            String formKey = formRight.getFormKey();
            ctx.getDBManager().execPrepareUpdate(dSql, new Object[]{relatedID, formKey});
            args.clear();
            updateSqlbf.setLength(0);
            updateSqlbf.append(iSql);
            List<FormRight.Opt> opts = formRight.getOpt();
            if (formRight.isHasAllOptRights() && (RightUtil.isAdmin(ctx) || optKeys.contains(formKey))) {
                updateSqlbf.append("(?,?,?),");
                args.add(formKey);
                args.add("*");
                args.add(relatedID);
            } else if (opts != null) {
                for (FormRight.Opt opt : opts) {
                    if (!opt.isOpt()) continue;
                    updateSqlbf.append("(?,?,?),");
                    args.add(formKey);
                    args.add(opt.getOptKey());
                    args.add(relatedID);
                }
            }
            if (args.size() > 0) {
                ctx.getDBManager().execPrepareUpdate(updateSqlbf.substring(0, updateSqlbf.length() - 1), args);
            }
            rightsCache.clearFormRights(relatedID, formKey);
        }
    }

    private static void saveDictDataRight(DefaultContext ctx, List<DictRight> dictRights, Long operatorID, Long roleID) throws Throwable {
        ArrayList<Number> args = new ArrayList<Number>();
        String dSql = "";
        String iSql = "";
        String dbTable = "";
        IRightsCache rightsCache = null;
        long relatedID = -1L;
        if (roleID > -1L) {
            relatedID = roleID;
            dSql = "DELETE FROM ${TABLE_RR} where RoleID=?";
            iSql = "INSERT INTO ${TABLE_RR} (DictID,RoleID) VALUES";
            rightsCache = RightsCacheFactory.getInstance().createRoleRightsCache();
        } else if (operatorID > -1L) {
            relatedID = operatorID;
            dSql = "DELETE FROM ${TABLE_RR} where OperatorID=?";
            iSql = "INSERT INTO ${TABLE_RR} (DictID,OperatorID) VALUES";
            rightsCache = RightsCacheFactory.getInstance().createOperatorRightsCache();
        }
        StringBuffer updateSqlbf = new StringBuffer(iSql);
        IMetaFactory metaFactory = ctx.getVE().getMetaFactory();
        if (dictRights != null && dictRights.size() > 0) {
            HashSet<String> allDictRightItemKeys = RightIOUtil.getItemKeysOfHasAllDictRight(ctx, dictRights, operatorID, roleID);
            for (DictRight dictRight : dictRights) {
                boolean allDict;
                String itemKey = dictRight.getItemKey();
                MetaDataObject metaDataObject = metaFactory.getDataObject(itemKey);
                dbTable = metaDataObject.getMainTable().getBindingDBTableName();
                if (roleID > -1L) {
                    dbTable = dbTable + "_RR";
                } else if (operatorID > -1L) {
                    dbTable = dbTable + "_OR";
                }
                ctx.getDBManager().execPrepareUpdate(dSql.replace("${TABLE_RR}", dbTable), new Object[]{relatedID});
                updateSqlbf.setLength(0);
                updateSqlbf.append(iSql.replace("${TABLE_RR}", dbTable));
                if (dictRight.isHasEmptRights()) {
                    updateSqlbf.append("(?,?),");
                    args.add(0);
                    args.add(relatedID);
                }
                boolean bl = allDict = RightUtil.isAdmin(ctx) || metaFactory.hasAllDictRights(itemKey) || allDictRightItemKeys.contains(itemKey);
                if (dictRight.isHasAllRights() && allDict) {
                    updateSqlbf.append("(?,?),");
                    args.add(-1);
                    args.add(relatedID);
                } else {
                    List<DictRight.Data> dataList = dictRight.getDataList();
                    if (dataList != null && dataList.size() > 0) {
                        for (DictRight.Data data : dataList) {
                            if (data.isDataRight()) {
                                updateSqlbf.append("(?,?),");
                                args.add(data.getOid());
                                args.add(relatedID);
                            }
                            if (args.size() <= 1000) continue;
                            ctx.getDBManager().execPrepareUpdate(updateSqlbf.substring(0, updateSqlbf.length() - 1), args);
                            args.clear();
                        }
                    }
                }
                if (args.size() > 0) {
                    ctx.getDBManager().execPrepareUpdate(updateSqlbf.substring(0, updateSqlbf.length() - 1), args);
                    args.clear();
                }
                rightsCache.clearDictRights(relatedID, dictRight.getItemKey());
            }
        }
    }

    private static HashSet<String> getItemKeysOfHasAllDictRight(DefaultContext ctx, List<DictRight> dictRights, Long operatorID, Long roleID) throws Throwable {
        HashSet<String> itemKeys = new HashSet<String>();
        long relatedID = -1L;
        String sql = "";
        if (roleID > -1L) {
            relatedID = roleID;
            sql = "SELECT '${ITEM_KEY}' AS ItemKey FROM ${TABLE} WHERE RoleID=? AND DictID=?";
        } else if (operatorID > -1L) {
            relatedID = operatorID;
            sql = "SELECT '${ITEM_KEY}' AS ItemKey FROM ${TABLE} WHERE OperatorID=? AND DictID=?";
        }
        if (dictRights != null) {
            ArrayList<Number> args = new ArrayList<Number>();
            StringBuilder querySB = new StringBuilder();
            IMetaFactory metaFactory = ctx.getVE().getMetaFactory();
            int i = 0;
            for (DictRight dictRight : dictRights) {
                if (i > 0) {
                    querySB.append("\n").append(" UNION ALL ");
                }
                MetaDataObject metaDataObject = metaFactory.getDataObject(dictRight.getItemKey());
                String dbTable = metaDataObject.getMainTable().getBindingDBTableName();
                if (roleID > -1L) {
                    dbTable = dbTable + "_RR";
                } else if (operatorID > -1L) {
                    dbTable = dbTable + "_OR";
                }
                querySB.append(sql.replace("${TABLE}", dbTable).replace("${ITEM_KEY}", dictRight.getItemKey()));
                args.add(relatedID);
                args.add(-1);
                ++i;
            }
            DataTable dt = ctx.getDBManager().execPrepareQuery(querySB.toString(), args);
            if (dt.size() > 0) {
                dt.beforeFirst();
                while (dt.next()) {
                    itemKeys.add(dt.getString("ItemKey"));
                }
            }
        }
        return itemKeys;
    }

    private static HashSet<String> getFormKeysOfHasAllOptRight(DefaultContext ctx) throws Throwable {
        DataTable roleOptRightDT;
        Long userId = ctx.getVE().getEnv().getUserID();
        List roleIds = ctx.getVE().getEnv().getRoleIDList();
        HashSet<String> formKeys = new HashSet<String>();
        DataTable userOptRightDT = ctx.getDBManager().execPrepareQuery("SELECT FormKey,OptKey FROM SYS_OperatorOptRights WHERE OperatorID=?", new Object[]{userId});
        if (userOptRightDT.size() > 0) {
            userOptRightDT.beforeFirst();
            while (userOptRightDT.next()) {
                String formKey = userOptRightDT.getString("FormKey");
                String optKey = userOptRightDT.getString("OptKey");
                if (!"*".equals(optKey)) continue;
                formKeys.add(formKey);
            }
        }
        if (roleIds != null && roleIds.size() > 0 && (roleOptRightDT = ctx.getDBManager().execPrepareQuery("SELECT FormKey,OptKey FROM SYS_RoleOptRights WHERE RoleID IN (" + StringUtils.join(Collections.nCopies(roleIds.size(), "?"), (String)",") + ")", new Object[]{roleIds})).size() > 0) {
            roleOptRightDT.beforeFirst();
            while (roleOptRightDT.next()) {
                String formKey = roleOptRightDT.getString("FormKey");
                String optKey = roleOptRightDT.getString("OptKey");
                if (!"*".equals(optKey)) continue;
                formKeys.add(formKey);
            }
        }
        return formKeys;
    }
}

