/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.commons.slnbase.service.right;

import com.bokesoft.distro.tech.yigosupport.extension.base.IStaticMethodByNameExtServiceWrapper;
import com.bokesoft.yigo.commons.slnbase.service.right.enums.RightType;
import com.bokesoft.yigo.commons.slnbase.service.right.enums.TargetType;
import com.bokesoft.yigo.commons.slnbase.service.right.struct.DictRight;
import com.bokesoft.yigo.commons.slnbase.service.right.struct.FormRight;
import com.bokesoft.yigo.commons.slnbase.service.right.util.RightCacheUtil;
import com.bokesoft.yigo.commons.slnbase.service.right.util.RightIOUtil;
import com.bokesoft.yigo.commons.slnbase.service.right.util.RightUtil;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RightService
implements IStaticMethodByNameExtServiceWrapper {
    private static final String DFT_VIEW_UUID = "0";
    private static Logger log = LoggerFactory.getLogger((String)RightService.class.getName());

    public static Document loadSetRightsList(DefaultContext ctx) throws Throwable {
        Document document = ctx.getDocument();
        RightUtil.SetRight currentRightsData = RightUtil.getSetRightsData(ctx);
        DataTable headDT = document.get("YES_RS_RightsSet");
        headDT.setInt("All_O", Integer.valueOf(0));
        headDT.setInt("All_IsVisible", Integer.valueOf(0));
        headDT.setInt("All_IsEdit", Integer.valueOf(0));
        headDT.setInt("Is_Null", Integer.valueOf(0));
        headDT.setInt("All_DataRight", Integer.valueOf(0));
        headDT.setInt("All_Entry", Integer.valueOf(0));
        DataTable entryRightDT = document.get("YES_RS_EntryRights");
        RightUtil.buildEntryRightDT(currentRightsData.getEntry(), entryRightDT, 0L);
        DataTable dictRightsDT = document.get("YES_RS_DictRights");
        RightUtil.buildDictRightsDT(currentRightsData.getDict(), dictRightsDT);
        DataTable billRightsDT = document.get("YES_RS_BillRights");
        RightUtil.buildBillRightsDT(currentRightsData.getForm(), billRightsDT);
        return document;
    }

    public static Document loadEntryRights(DefaultContext ctx, Long roleID, Long operatorID) {
        try {
            Document document = ctx.getDocument();
            DataTable entryDT = null;
            if (operatorID > 0L) {
                entryDT = ctx.getDBManager().execPrepareQuery("SELECT * FROM sys_operatorentryrights WHERE OperatorID=?", new Object[]{operatorID});
            } else if (roleID > 0L) {
                entryDT = ctx.getDBManager().execPrepareQuery("SELECT * FROM sys_roleentryrights WHERE RoleID=?", new Object[]{roleID});
            }
            DataTable entryRightDT = document.get("YES_RS_EntryRights");
            boolean all = false;
            ArrayList<String> hasRightEntryList = new ArrayList<String>();
            if (entryDT.size() > 0) {
                entryDT.beforeFirst();
                while (entryDT.next()) {
                    String entryKey = entryDT.getString("EntryKey");
                    if (entryKey.equals("*")) {
                        all = true;
                        break;
                    }
                    hasRightEntryList.add(entryKey);
                }
            }
            if (entryRightDT.size() > 0) {
                entryRightDT.beforeFirst();
                while (entryRightDT.next()) {
                    String curEK = entryRightDT.getString("EntryKey");
                    if (all || hasRightEntryList.contains(curEK)) {
                        entryRightDT.setInt("select_E", Integer.valueOf(1));
                        continue;
                    }
                    entryRightDT.setInt("select_E", Integer.valueOf(0));
                }
            }
            DataTable headDT = document.get("YES_RS_RightsSet");
            headDT.setInt("All_Entry", Integer.valueOf(all ? 1 : 0));
            return document;
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            return (Document)ExceptionUtils.rethrow((Throwable)e);
        }
    }

    public static Document loadFormRights(DefaultContext ctx, Long roleID, Long operatorID, String formKey, String viewUUID) throws Throwable {
        Document document = ctx.getDocument();
        DataTable headDT = document.get("YES_RS_RightsSet");
        String clientId = ctx.getVE().getClientID();
        if (StringUtils.isNotEmpty((CharSequence)viewUUID) && !DFT_VIEW_UUID.equals(viewUUID)) {
            String curFormCacheKey;
            FormRight formRightCache;
            String prevFormKey = headDT.getString("FormKey");
            TargetType targetType = TargetType.OPERATOR;
            Long relatedId = -1L;
            if (roleID > 0L) {
                relatedId = roleID;
                targetType = TargetType.ROLE;
            } else if (operatorID > 0L) {
                relatedId = operatorID;
                targetType = TargetType.OPERATOR;
            }
            if (StringUtils.isNotEmpty((CharSequence)prevFormKey)) {
                String prevFormCacheKey = RightCacheUtil.buildCacheKey(targetType, RightType.FORM, relatedId, prevFormKey, viewUUID, clientId);
                RightCacheUtil.setCache(prevFormCacheKey, RightUtil.buildFormRightByDoc(document));
            }
            if ((formRightCache = (FormRight)RightCacheUtil.getCache(curFormCacheKey = RightCacheUtil.buildCacheKey(targetType, RightType.FORM, relatedId, formKey, viewUUID, clientId))) != null) {
                if (headDT.first()) {
                    headDT.setString("FormKey", formKey);
                }
                RightUtil.fillFormRight2Document(document, formRightCache);
                return document;
            }
        }
        RightUtil.FormRightsData formRightsData = RightUtil.loadFormRights(ctx, formKey, roleID, operatorID);
        if (headDT.first()) {
            headDT.setString("FormKey", formKey);
            headDT.setInt("All_O", Integer.valueOf(formRightsData.isHasAllOptRights() ? 1 : 0));
            headDT.setInt("All_IsVisible", Integer.valueOf(formRightsData.isHasAllVisibleRights() ? 1 : 0));
            headDT.setInt("All_IsEdit", Integer.valueOf(formRightsData.isHasAllEnableRights() ? 1 : 0));
        }
        DataTable operationsDT = document.get("YES_RS_Operations");
        operationsDT.clear();
        List<RightUtil.FormRightsData.OptData> optDataList = formRightsData.getOptData();
        if (optDataList != null) {
            RightUtil.buildFormOptRightDT(optDataList, operationsDT, 0L);
        }
        DataTable fieldRightDT = document.get("YES_RS_FieldRights");
        fieldRightDT.clear();
        List<RightUtil.FormRightsData.FieldData> fieldDataList = formRightsData.getFieldData();
        if (fieldDataList != null) {
            RightUtil.buildFormFieldRightDT(fieldDataList, fieldRightDT, 0L);
        }
        return document;
    }

    public static Document loadDictRights(DefaultContext ctx, Long roleID, Long operatorID, String itemKey, String viewUUID) throws Throwable {
        Document document = ctx.getDocument();
        DataTable headDT = document.get("YES_RS_RightsSet");
        String clientId = ctx.getVE().getClientID();
        if (StringUtils.isNotEmpty((CharSequence)viewUUID) && !DFT_VIEW_UUID.equals(viewUUID)) {
            String curDictCacheKey;
            DictRight dictRightCache;
            String prevItemKey = headDT.getString("ItemKey");
            TargetType targetType = TargetType.OPERATOR;
            Long relatedId = -1L;
            if (roleID > 0L) {
                relatedId = roleID;
                targetType = TargetType.ROLE;
            } else if (operatorID > 0L) {
                relatedId = operatorID;
                targetType = TargetType.OPERATOR;
            }
            if (StringUtils.isNotEmpty((CharSequence)prevItemKey)) {
                String prevDictCacheKey = RightCacheUtil.buildCacheKey(targetType, RightType.DICT, relatedId, prevItemKey, viewUUID, clientId);
                DictRight dictRight = RightUtil.buildDictRightByDoc(document);
                RightCacheUtil.setCache(prevDictCacheKey, dictRight);
            }
            if ((dictRightCache = (DictRight)RightCacheUtil.getCache(curDictCacheKey = RightCacheUtil.buildCacheKey(targetType, RightType.DICT, relatedId, itemKey, viewUUID, clientId))) != null) {
                headDT.setString("ItemKey", itemKey);
                RightUtil.fillDictRight2Document(document, dictRightCache);
                return document;
            }
        }
        DictRight dictRightsData = RightUtil.loadDictRightsData(ctx, itemKey, roleID, operatorID);
        headDT.setString("ItemKey", itemKey);
        headDT.setInt("All_DataRight", Integer.valueOf(dictRightsData.isHasAllRights() ? 1 : 0));
        headDT.setInt("Is_Null", Integer.valueOf(dictRightsData.isHasEmptRights() ? 1 : 0));
        DataTable dataRigthsDT = document.get("YES_RS_DataRigths");
        dataRigthsDT.clear();
        if (dictRightsData.getDataList() != null) {
            for (DictRight.Data dictData : dictRightsData.getDataList()) {
                dataRigthsDT.append();
                dataRigthsDT.setLong("OID", dictData.getOid());
                dataRigthsDT.setString("Code", dictData.getCode());
                dataRigthsDT.setString("Name", dictData.getName());
                dataRigthsDT.setLong("ParentId", dictData.getParentId());
                dataRigthsDT.setInt("Is_DataRight", Integer.valueOf(dictData.isDataRight() ? 1 : 0));
            }
        }
        return document;
    }

    public static void save(DefaultContext ctx, Long roleID, Long operatorID, String viewId) {
        try {
            RightIOUtil.Save(ctx, roleID, operatorID, viewId);
        }
        catch (Throwable throwable) {
            log.error(throwable.getMessage(), throwable);
            ExceptionUtils.rethrow((Throwable)throwable);
        }
    }
}

