package com.bokesoft.yigo.commons.slnbase.service.right.excel.utils;

import com.bokesoft.yes.mid.auth.cache.SessionInfo;
import com.bokesoft.yigo.common.def.DataObjectPrimaryType;
import com.bokesoft.yigo.common.def.DataObjectSecondaryType;
import com.bokesoft.yigo.commons.slnbase.service.right.excel.structure.*;
import com.bokesoft.yigo.commons.slnbase.service.right.excel.treetar.TreeCacheData;
import com.bokesoft.yigo.commons.slnbase.service.right.excel.treetar.TreeDataTarTool;
import com.bokesoft.yigo.commons.slnbase.service.right.excel.treetar.TreeUnit;
import com.bokesoft.yigo.meta.base.AbstractCompositeObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectList;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectProfile;
import com.bokesoft.yigo.meta.entry.MetaEntry;
import com.bokesoft.yigo.meta.entry.MetaEntryItem;
import com.bokesoft.yigo.meta.form.MetaFormList;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.rights.MetaDictDefinition;
import com.bokesoft.yigo.meta.rights.MetaDictRightsCollection;
import com.bokesoft.yigo.meta.rights.MetaFormDefinition;
import com.bokesoft.yigo.meta.rights.MetaFormRightsCollection;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.mid.session.ISessionInfo;
import com.bokesoft.yigo.mid.session.ISessionInfoMap;
import com.bokesoft.yigo.mid.session.ISessionInfoProvider;
import com.bokesoft.yigo.mid.session.SessionInfoProviderHolder;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.env.Env;
import org.apache.commons.lang3.StringUtils;

import java.util.*;

public class RightsDataUtil {

    private static TreeCacheData orgTreeCache;

    private static long POSITION_DATA_LAST_MODIFY_TIME;

    private static final String SQL_QUERY_ALL_OPERATOR_POSITION = "select OID,ParentID  FROM  ZSJ_OrganizationUnitHead where  Enable = 1";

    private static final String SQL_QUERY_POSITION_DATA_LAST_MODIFY = "select MAX(modifytime) as lastedit FROM ZSJ_OrganizationUnitHead where Enable = 1";

    private static final String SQL_QUERY_OPERATOR_ORG_INFO = "select NAME,OID,ParentID,OrganizationType FROM "
            + " ZSJ_OrganizationUnitHead where Enable in (0,1) AND OID IN (${OIDS})"
            + " ORDER BY OrganizationType desc";

    private static final String SQL_QUERY_ROLEIDS_BY_OPERATOR_DEFAULT_POSITION = "select distinct posd.RoleID,rol.PostID FROM sys_operator ope "
            + " left join sys_operatorpost rol on ope.oid = rol.soid "
            + " left join ZSJ_OrganizationUnitHead pos on rol.PostID = pos.oid "
            + " left join ZSJ_OrganizationUnitDetail posd on pos.oid = posd.soid "
            + " where ope.Enable in (0,1) and ope.OID = ? AND rol.isdefault=1 and pos.Enable in (0,1) and posd.RoleID>0 ";

    private static final String SQL_QUERY_OPERATOR_ALL_POSITION = "select distinct rol.PostID FROM "
            + " sys_operator ope left join sys_operatorpost rol on ope.oid = rol.soid WHERE ope.Enable in (0,1) and ope.OID = ?";

    private static final String SQL_QUERY_ROLEIDS_BY_POSITION = "select distinct posd.RoleID,rol.PostID FROM sys_operator ope "
            + " LEFT JOIN sys_operatorpost rol on ope.oid = rol.soid "
            + " LEFT JOIN ZSJ_OrganizationUnitHead pos on rol.PostID = pos.oid "
            + " LEFT JOIN ZSJ_OrganizationUnitDetail posd on pos.oid = posd.soid " + " where "
            + " ope.Enable in (0,1) and ope.OID = ?" + " and pos.OID=?" + " and pos.Enable in (0,1) and posd.RoleID>0 ";

    private static synchronized TreeCacheData getOrgTreeCache(DefaultContext context) throws Throwable {

        IDBManager dbManager = context.getDBManager();
        DataTable dt = dbManager.execQuery(SQL_QUERY_POSITION_DATA_LAST_MODIFY);
        dt.first();
        if (POSITION_DATA_LAST_MODIFY_TIME < 0) {
            POSITION_DATA_LAST_MODIFY_TIME = dt.getDateTime(0).getTime();
            orgTreeCache = buildOrgTreeCache(context);
        }
        if (dt.getDateTime(0).getTime() > POSITION_DATA_LAST_MODIFY_TIME) {
            POSITION_DATA_LAST_MODIFY_TIME = dt.getDateTime(0).getTime();
            orgTreeCache = buildOrgTreeCache(context);
        }
        return orgTreeCache;
    }

    private static TreeCacheData buildOrgTreeCache(DefaultContext context) throws Throwable {
        Set<TreeUnit> treeSet = new HashSet<TreeUnit>();
        IDBManager dbManager = context.getDBManager();
        DataTable dt = dbManager.execQuery(SQL_QUERY_ALL_OPERATOR_POSITION);
        dt.beforeFirst();
        while (dt.next()) {
            treeSet.add(new TreeUnit(dt.getLong("OID"), dt.getLong("ParentID") <= 0 ? 0 : dt.getLong("ParentID")));
        }
        return TreeDataTarTool.initTreeData(treeSet);
    }

    public static void setOperatorDefaultInfo(DefaultContext context, Env env) throws Throwable {
        long positionID = -1;
        ArrayList<Long> roleList = new ArrayList<Long>();
        IDBManager dbManager = context.getDBManager();
        DataTable dt = dbManager.execPrepareQuery(SQL_QUERY_ROLEIDS_BY_OPERATOR_DEFAULT_POSITION, env.getUserID());
        dt.beforeFirst();
        while (dt.next()) {
            if (positionID < 0) {
                positionID = dt.getLong(1);
            }
            roleList.add(dt.getLong(0));
        }
        setOperatorDefaultRoles(context, env, roleList);
        setOperatorDefaultPosition(context, env, positionID);
    }

    public static void setOperatorDefaultRoles(DefaultContext context, Env env, ArrayList<Long> roleList)
            throws Throwable {
        ISessionInfoProvider provider = SessionInfoProviderHolder.getSimpleProvider();
        ISessionInfoMap sessionInfoMap = provider.getSessionInfoMap();
        ISessionInfo session = sessionInfoMap.get(env.getClientID());
        if (null != session) {

            if (null != env.getRoleIDList()) {
                session.getRoleIDList().clear();
                session.getRoleIDList().addAll(roleList);
            } else {
                ((SessionInfo) session).setRoleIDList(roleList);
            }
        } else {
            if (null != env.getRoleIDList()) {
                env.getRoleIDList().clear();
                env.getRoleIDList().addAll(roleList);
            } else {
                env.setRoleIDList(roleList);
            }
        }

    }

    public static void setOperatorDefaultPosition(DefaultContext context, Env env, long positionID) throws Throwable {
        ISessionInfoProvider provider = SessionInfoProviderHolder.getSimpleProvider();
        ISessionInfoMap sessionInfoMap = provider.getSessionInfoMap();
        ISessionInfo session = sessionInfoMap.get(env.getClientID());

        CurrentOrgInfo currentOrgInfo = getCurrentOrgInfo(context, env, positionID);
        if (null != session) {
            session.getSessionParas().put("CORPNAME", currentOrgInfo.getCorpName());
            session.getSessionParas().put("ORGNAME", currentOrgInfo.getOrgName());
            session.getSessionParas().put("POSITIONID", positionID);
        } else {
            env.put("CORPNAME", currentOrgInfo.getCorpName());
            env.put("ORGNAME", currentOrgInfo.getOrgName());
            env.put("POSITIONID", positionID);
        }
    }

    public static void setOperatorRoles(DefaultContext context, Env env, long positionID) throws Throwable {
        List<Long> result = new ArrayList<Long>();
        IDBManager dbManager = context.getDBManager();
        DataTable dt = dbManager.execPrepareQuery(SQL_QUERY_ROLEIDS_BY_POSITION, env.getUserID(), positionID);
        ISessionInfoProvider provider = SessionInfoProviderHolder.getSimpleProvider();
        ISessionInfoMap sessionInfoMap = provider.getSessionInfoMap();
        ISessionInfo session = sessionInfoMap.get(env.getClientID());
        dt.beforeFirst();
        while (dt.next()) {
            result.add(dt.getLong(0));
        }
        session.getRoleIDList().clear();
        session.getRoleIDList().addAll(result);
        sessionInfoMap.put(env.getClientID(), session);
    }

    public static void setOperatorPosition(DefaultContext context, Env env, long positionID) throws Throwable {
        ISessionInfoProvider provider = SessionInfoProviderHolder.getSimpleProvider();
        ISessionInfoMap sessionInfoMap = provider.getSessionInfoMap();
        ISessionInfo session = sessionInfoMap.get(env.getClientID());
        if (null != session) {
            session.getSessionParas().put("ORGNAME", getCurrentOrgInfo(context, env, positionID).getOrgName());
            session.getSessionParas().put("POSITIONID", positionID);
            sessionInfoMap.put(env.getClientID(), session);
        }
        env.put("ORGNAME", getCurrentOrgInfo(context, env, positionID).getOrgName());
        env.put("POSITIONID", positionID);
    }

    public static CurrentOrgInfo getCurrentOrgInfo(DefaultContext context, Env env, Long positionID) throws Throwable {
        String corpName = null;
        LinkedList<String> orgNameList = new LinkedList<String>();
        IDBManager dbManager = context.getDBManager();
        Set<Long> parents = getDirectAncestorsOrgSet(context, positionID);
        parents.add(positionID);
        String args = "";
        for (int i = 0; i < parents.size(); i++) {
            args += ",?";
        }
        args = args.substring(1);
        String sql = SQL_QUERY_OPERATOR_ORG_INFO.replace("${OIDS}", args);
        DataTable orgDt = dbManager.execPrepareQuery(sql, parents.toArray());

        long checkPosID = positionID;
        orgDt.beforeFirst();
        while (orgDt.next()) {
            String organizationType = orgDt.getString("OrganizationType");
            if (organizationType.contentEquals("1")) {
                corpName = orgDt.getString("NAME");
            } else {
                if (checkPosID == orgDt.getLong("OID")) {
                    orgNameList.addFirst(orgDt.getString("NAME"));
                    checkPosID = orgDt.getLong("ParentID");
                    orgDt.beforeFirst();
                }
            }
        }
        String orgName = StringUtils.join(orgNameList, "|");
        return new CurrentOrgInfo(corpName, orgName);
    }

    public static List<OperatorPosition> getOperatorAllPosition(DefaultContext context, Env env) throws Throwable {
        List<OperatorPosition> OperatorPositionList = new ArrayList<OperatorPosition>();
        IDBManager dbManager = context.getDBManager();
        DataTable dt = dbManager.execPrepareQuery(SQL_QUERY_OPERATOR_ALL_POSITION, env.getUserID());
        dt.beforeFirst();
        while (dt.next()) {
            if (dt.getLong("POSTID") > 0) {
                OperatorPosition op = new OperatorPosition();
                op.setPositionId(dt.getLong("POSTID"));
                op.setPositionName(getCurrentOrgInfo(context, env, dt.getLong("POSTID")).getOrgName());
                OperatorPositionList.add(op);
            }
        }
        return OperatorPositionList;
    }

    public static Set<Long> getDirectAncestorsOrgSet(DefaultContext context, Long positionID) throws Throwable {
        Set<Long> parents = TreeDataTarTool.findDirectAncestors(getOrgTreeCache(context), positionID, false);
        TreeDataTarTool.findDirectAncestors(getOrgTreeCache(context), positionID, 3, false);
        return parents;
    }

    public static TreeUnit getCurrentOrgTreeUnit(DefaultContext context, Long positionID) throws Throwable {
        TreeUnit result = getOrgTreeCache(context).getTreeDataCache().get(positionID);
        return result;
    }

    public static RightsData getRightsData(DefaultContext context) throws Throwable {
        RightsData result = new RightsData();
        List<RightsData4Dict> rightsData4Dict = _getRightsData4Dict(context);
        List<RightsData4Form> rightsData4Form = _getRightsData4Form(context);
        List<RightsData4Entry> rightsData4Entry = _getRightsData4Entry(context);
        result.setRightsData4Dict(rightsData4Dict);
        result.setRightsData4Entry(rightsData4Entry);
        result.setRightsData4Form(rightsData4Form);
        return result;
    }

    private static List<RightsData4Dict> _getRightsData4Dict(DefaultContext context) throws Throwable {
        List<RightsData4Dict> result = new ArrayList<RightsData4Dict>();

        List<String> ignoreDict = _getIgnoreDictData(context);
        MetaDataObjectList dataObjectList = context.getVE().getMetaFactory().getDataObjectList();
        Iterator<MetaDataObjectProfile> it = dataObjectList.iterator();
        while (it.hasNext()) {
            MetaDataObjectProfile mop = it.next();
            if (mop.getPrimaryType() == DataObjectPrimaryType.ENTITY
                    && mop.getSecondaryType() == DataObjectSecondaryType.DICT && !ignoreDict.contains(mop.getKey())) {
                RightsData4Dict appRightsData4Dict = new RightsData4Dict();
                appRightsData4Dict.setCaption(mop.getCaption());
                appRightsData4Dict.setKey(mop.getKey());
                if (null != mop.getDataObject()) {
                    String talbeName = mop.getDataObject().getMainTableKey();
                    if (null != mop.getDataObject().getMainTable()
                            && StringUtils.isNotBlank(mop.getDataObject().getMainTable().getDBTableName())) {
                        talbeName = mop.getDataObject().getMainTable().getDBTableName();
                    }
                    appRightsData4Dict.setMainTableKey(talbeName);
                    appRightsData4Dict.setProject(mop.getProject().getKey());
                    result.add(appRightsData4Dict);
                }
            }
        }
        return result;
    }

    private static List<String> _getIgnoreDictData(DefaultContext context) throws Throwable {
        List<String> ignoreDict = new ArrayList<String>();
        if (null != context.getVE().getMetaFactory().getRightsDefinition()
                && null != context.getVE().getMetaFactory().getRightsDefinition().getDictRightsCollection()) {
            MetaDictRightsCollection extDitcRightsData = context.getVE().getMetaFactory().getRightsDefinition()
                    .getDictRightsCollection();
            Iterator<MetaDictDefinition> extIt = extDitcRightsData.iterator();
            while (extIt.hasNext()) {
                MetaDictDefinition metaDictDefinition = extIt.next();
                ignoreDict.add(metaDictDefinition.getItemKey());
            }
        }
        return ignoreDict;
    }

    private static List<RightsData4Form> _getRightsData4Form(DefaultContext context) throws Throwable {
        List<RightsData4Form> result = new ArrayList<RightsData4Form>();
        List<String> ignoreDict = _getIgnoreFormData(context);
        MetaFormList formList = context.getVE().getMetaFactory().getMetaFormList();
        Iterator<MetaFormProfile> it = formList.iterator();
        while (it.hasNext()) {
            MetaFormProfile mfp = it.next();
            if (!ignoreDict.contains(mfp.getKey())) {
                RightsData4Form appRightsData4Form = new RightsData4Form();
                appRightsData4Form.setCaption(mfp.getCaption());
                appRightsData4Form.setKey(mfp.getKey());
                appRightsData4Form.setProject(mfp.getProject().getKey());
                result.add(appRightsData4Form);
            }
        }
        return result;
    }

    private static List<String> _getIgnoreFormData(DefaultContext context) {
        List<String> ignoreDict = new ArrayList<String>();
        if (null != context.getVE().getMetaFactory().getRightsDefinition()
                && null != context.getVE().getMetaFactory().getRightsDefinition().getFormRightsCollection()) {
            MetaFormRightsCollection extFormRightsData = context.getVE().getMetaFactory().getRightsDefinition()
                    .getFormRightsCollection();
            Iterator<MetaFormDefinition> extIt = extFormRightsData.iterator();
            while (extIt.hasNext()) {
                MetaFormDefinition metaFormDefinition = extIt.next();
                ignoreDict.add(metaFormDefinition.getFormKey());
            }
        }
        return ignoreDict;
    }

    private static List<RightsData4Entry> _getRightsData4Entry(DefaultContext context) throws Throwable {
        MetaEntry rootEntry = context.getVE().getMetaFactory().getEntryList(context.getVE().getAppKey());
        List<RightsData4Entry> result = _parseRights4EntryData(rootEntry, 0);
        return result;
    }

    private static List<RightsData4Entry> _parseRights4EntryData(MetaEntry entry, int entryLevel) {
        List<RightsData4Entry> result = new ArrayList<RightsData4Entry>();
        Iterator<AbstractCompositeObject> itEntry = entry.iterator();
        entryLevel++;
        while (itEntry.hasNext()) {
            RightsData4Entry entrydata = new RightsData4Entry();
            AbstractCompositeObject absEentry = itEntry.next();
            if (absEentry instanceof MetaEntry) {
                MetaEntry metaEntry = (MetaEntry) absEentry;
                entrydata.setCaption(metaEntry.getCaption());
                entrydata.setKey(metaEntry.getKey());
                entrydata.setProject(metaEntry.getProject());
                entrydata.setChildEntries(_parseRights4EntryData(metaEntry, entryLevel));
                entrydata.setParentKey(entry.getKey());
                entrydata.setEntryLevel(entryLevel);
            } else if (absEentry instanceof MetaEntryItem) {
                MetaEntryItem metaEntryItem = (MetaEntryItem) absEentry;
                entrydata.setCaption(metaEntryItem.getCaption());
                entrydata.setKey(metaEntryItem.getKey());
                entrydata.setProject(metaEntryItem.getProject());
                entrydata.setParentKey(entry.getKey());
                entrydata.setEntryLevel(entryLevel);
            }
            result.add(entrydata);
        }
        return result;
    }

    public static class CurrentOrgInfo {
        private String orgName;

        private String corpName;

        public CurrentOrgInfo(String corpName, String orgName) {
            this.orgName = orgName;
            this.corpName = corpName;
        }

        public String getOrgName() {
            return orgName;
        }

        public String getCorpName() {
            return corpName;
        }
    }
}
