package com.bokesoft.yigo.commons.slnbase.service.right.excel;

import com.bokesoft.yes.excel.template.util.ExcelUtil;
import com.bokesoft.yes.struct.filedata.FileData;
import com.bokesoft.yigo.commons.slnbase.service.right.excel.structure.RightsData;
import com.bokesoft.yigo.commons.slnbase.service.right.excel.structure.RightsData4Dict;
import com.bokesoft.yigo.commons.slnbase.service.right.excel.structure.RightsData4Entry;
import com.bokesoft.yigo.commons.slnbase.service.right.excel.structure.RightsData4Form;
import com.bokesoft.yigo.commons.slnbase.service.right.excel.utils.RightsDataUtil;
import com.bokesoft.yigo.excel.IExportService;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.condition.ConditionParas;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.document.FilterMap;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

import java.io.ByteArrayOutputStream;
import java.util.List;

public class RightsDataCfgExportSerivce implements IExportService {

    @Override
    public FileData exportData(DefaultContext context, Document document, FilterMap filterMap,
                               ConditionParas condParameters, String exportTables, String postEServiceName, boolean onlyCurrentPage, String exportFileName, boolean needDownload)
            throws Throwable {
        RightsData rightsData = RightsDataUtil.getRightsData(context);
        Workbook workbook = new SXSSFWorkbook(10000);
        _fillRightsData4Entry2Workbook(rightsData, workbook);
        _fillRightsData4Form2Workbook(rightsData, workbook);
        _fillRightsData4Dict2Workbook(rightsData, workbook);
//        String filePath = ExcelUtils.getExportFilePath(context.getVE().getMetaFactory(), "RightsData");
//        ExcelUtil.writeExcel((Workbook) workbook, filePath);
        FileData fileData = new FileData();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        workbook.write(bos);
        fileData.setFileName(exportFileName);
        fileData.setData(bos.toByteArray());
        return fileData;
    }

    private void _fillRightsData4Entry2Workbook(RightsData rightsData, Workbook workbook) {
        Sheet sheetEntry = ExcelUtil.getSheet(workbook, "入口权限");
        Row rowEntryTitle = ExcelUtil.getRow(sheetEntry, 0);
        ExcelUtil.setCellValue(ExcelUtil.getCell(rowEntryTitle, 0), "Project/功能模块");
        ExcelUtil.setCellValue(ExcelUtil.getCell(rowEntryTitle, 1), "Key/入口key");
        ExcelUtil.setCellValue(ExcelUtil.getCell(rowEntryTitle, 2), "Caption/入口名称");
        ExcelUtil.setCellValue(ExcelUtil.getCell(rowEntryTitle, 3), "Parent/入口父节点");
        ExcelUtil.setCellValue(ExcelUtil.getCell(rowEntryTitle, 4), "EntryLevel/入口等级");
        List<RightsData4Entry> rightsData4Entry = rightsData.getRightsData4Entry();
        _fillRightsData4Entry2Workbook_Core(sheetEntry, rightsData4Entry);
    }

    private void _fillRightsData4Entry2Workbook_Core(Sheet sheetEntry, List<RightsData4Entry> rightsData4Entry) {
        for (int eIdx = 0; eIdx < rightsData4Entry.size(); eIdx++) {
            ExcelUtil.setCellValue(sheetEntry, sheetEntry.getLastRowNum() + 1, 0,
                    rightsData4Entry.get(eIdx).getProject());
            ExcelUtil.setCellValue(sheetEntry, sheetEntry.getLastRowNum(), 1, rightsData4Entry.get(eIdx).getKey());
            ExcelUtil.setCellValue(sheetEntry, sheetEntry.getLastRowNum(), 2, rightsData4Entry.get(eIdx).getCaption());
            ExcelUtil.setCellValue(sheetEntry, sheetEntry.getLastRowNum(), 3,
                    rightsData4Entry.get(eIdx).getParentKey());
            ExcelUtil.setCellValue(sheetEntry, sheetEntry.getLastRowNum(), 4,
                    rightsData4Entry.get(eIdx).getEntryLevel());
            if (null != rightsData4Entry.get(eIdx).getChildEntries()) {
                _fillRightsData4Entry2Workbook_Core(sheetEntry, rightsData4Entry.get(eIdx).getChildEntries());
            }
        }
    }

    private void _fillRightsData4Form2Workbook(RightsData rightsData, Workbook workbook) {
        Sheet sheet = ExcelUtil.getSheet(workbook, "表单权限");
        Row rowTitle = ExcelUtil.getRow(sheet, 0);
        ExcelUtil.setCellValue(ExcelUtil.getCell(rowTitle, 0), "Project/功能模块");
        ExcelUtil.setCellValue(ExcelUtil.getCell(rowTitle, 1), "Key/表单key");
        ExcelUtil.setCellValue(ExcelUtil.getCell(rowTitle, 2), "Caption/表单名称");
        List<RightsData4Form> rightsData4Form = rightsData.getRightsData4Form();
        _fillRightsData4Form2Workbook_Core(sheet, rightsData4Form);
    }

    private void _fillRightsData4Form2Workbook_Core(Sheet sheet, List<RightsData4Form> rightsData4Form) {
        for (int idx = 0; idx < rightsData4Form.size(); idx++) {
            ExcelUtil.setCellValue(sheet, sheet.getLastRowNum() + 1, 0, rightsData4Form.get(idx).getProject());
            ExcelUtil.setCellValue(sheet, sheet.getLastRowNum(), 1, rightsData4Form.get(idx).getKey());
            ExcelUtil.setCellValue(sheet, sheet.getLastRowNum(), 2, rightsData4Form.get(idx).getCaption());
        }
    }

    private void _fillRightsData4Dict2Workbook(RightsData rightsData, Workbook workbook) {
        Sheet sheet = ExcelUtil.getSheet(workbook, "数据权限");
        Row rowTitle = ExcelUtil.getRow(sheet, 0);
        ExcelUtil.setCellValue(ExcelUtil.getCell(rowTitle, 0), "Project/功能模块");
        ExcelUtil.setCellValue(ExcelUtil.getCell(rowTitle, 1), "Key/字典key");
        ExcelUtil.setCellValue(ExcelUtil.getCell(rowTitle, 2), "Caption/字典名称");
        List<RightsData4Dict> rightsData4Dict = rightsData.getRightsData4Dict();
        _fillRightsData4Dict2Workbook_Core(sheet, rightsData4Dict);
    }

    private void _fillRightsData4Dict2Workbook_Core(Sheet sheet, List<RightsData4Dict> rightsData4Dict) {
        for (int idx = 0; idx < rightsData4Dict.size(); idx++) {
            ExcelUtil.setCellValue(sheet, sheet.getLastRowNum() + 1, 0, rightsData4Dict.get(idx).getProject());
            ExcelUtil.setCellValue(sheet, sheet.getLastRowNum(), 1, rightsData4Dict.get(idx).getKey());
            ExcelUtil.setCellValue(sheet, sheet.getLastRowNum(), 2, rightsData4Dict.get(idx).getCaption());
        }
    }

}
