package com.bokesoft.yigo.commons.slnbase.service.right.util;

import com.bokesoft.distro.tech.yigosupport.extension.utils.yigo.SessionUtils;
import com.bokesoft.yigo.cache.CacheFactory;
import com.bokesoft.yigo.cache.ICache;
import com.bokesoft.yigo.commons.slnbase.service.right.enums.TargetType;
import com.bokesoft.yigo.commons.slnbase.service.right.struct.DictRight;
import com.bokesoft.yigo.commons.slnbase.service.right.struct.FormRight;
import com.bokesoft.yigo.commons.slnbase.service.right.enums.RightType;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.session.ISessionInfo;
import jodd.util.Wildcard;
import java.util.*;

public class RightCacheUtil {
    private static ICache RIGHT_CACHE = CacheFactory.getInstance().createCache(RightCacheUtil.class.getName());
    /**缓存key前缀*/
    private static String CACHE_PREFIX = "YIGO_RIGHT_CACHE";
    /**缓存key拼接符号*/
    private static final String JOIN_SYMBOL = "#";

    public static <T> void setCache(String cacheKey, T obj) {
        RIGHT_CACHE.put(cacheKey, obj);
    }

    public static <T> T getCache(String cacheKey) {
        return (T) RIGHT_CACHE.get(cacheKey);
    }

    public static boolean  contains(String cacheKey) {
        return RIGHT_CACHE.contains(cacheKey);
    }

    public static String buildCacheKey(TargetType targetType, RightType rightType, Long relatedId, String relatedKey, String viewUUID, String clientID) {
        CachePart cachePart = new CachePart(targetType, rightType, relatedId, relatedKey, viewUUID, clientID);
        return CACHE_PREFIX + JOIN_SYMBOL + cachePart.toString();
    }

    /**
     * 获取表单权限
     * @param ctx
     * @param targetType 目标类型
     * @param relatedId 对应目标OID 比如roleID或者userId
     * @return
     */
    public static Map<String,FormRight> getFormRights(DefaultContext ctx, TargetType targetType, Long relatedId) {
        Set<String> cacheKeys = RIGHT_CACHE.getKeys();
        Map<String,FormRight> formRights=new HashMap<>(64);
        String clientId = ctx.getVE().getClientID();
        String pattern = buildCacheKey(targetType, RightType.FORM, relatedId, "*", "*", clientId);
        if (cacheKeys != null) {
            for (String cacheKey : cacheKeys) {
                if (Wildcard.matchOne(cacheKey,pattern)>-1) {
                    CachePart cachePart=buildCachePart(cacheKey);
                    formRights.put(cachePart.getRelatedKey(),getCache(cacheKey));
                }
            }
        }
        return formRights;
    }

    /**
     * 获取字典权限
     * @param ctx
     * @param targetType 目标类型
     * @param relatedId 对应目标OID 比如roleID或者userId
     * @return
     */
    public static Map<String,DictRight> getDictRights(DefaultContext ctx, TargetType targetType, Long relatedId) {
        Set<String> cacheKeys = RIGHT_CACHE.getKeys();
        Map<String,DictRight> dictRights=new HashMap<>(64);
        String clientId = ctx.getVE().getClientID();
        String pattern = buildCacheKey(targetType, RightType.DICT, relatedId, "*", "*", clientId);
        if (cacheKeys != null) {
            for (String cacheKey : cacheKeys) {
                if (Wildcard.matchOne(cacheKey,pattern)>-1) {
                    CachePart cachePart=buildCachePart(cacheKey);
                    dictRights.put(cachePart.getRelatedKey(),getCache(cacheKey));
                }
            }
        }
        return dictRights;
    }

    /**
     * 用于定时任务调用 清除离线用户cache
     */
    public static void clearCacheOffline() {
        Set<String> cacheKeys = RIGHT_CACHE.getKeys();
        if (cacheKeys != null) {
            for (String cacheKey : cacheKeys) {
                String[] parts = cacheKey.split(JOIN_SYMBOL);
                String clientId =parts[6];
                //如果用户离线,则清除缓存
                ISessionInfo sessionInfo = SessionUtils.getLoginSession(clientId);
                if (sessionInfo == null) {
                    //clear
                    RIGHT_CACHE.remove(cacheKey);
                }
            }
        }
    }

    /**
     * 根据清除缓存
     * @param clientId
     * @param viewId
     */
    public static void clearCacheByViewId(String clientId,String viewId){
        Set<String> cacheKeys = RIGHT_CACHE.getKeys();
        if(cacheKeys != null) {
            for (String cacheKey : cacheKeys) {
                if(cacheKey.indexOf(viewId)>-1&&cacheKey.indexOf(clientId)>-1){
                    RIGHT_CACHE.remove(cacheKey);
                }
            }
        }
    }

    private static CachePart buildCachePart(String cacheKey) {
        String[] parts = cacheKey.split(JOIN_SYMBOL);
        TargetType targetType = TargetType.valueOf(parts[1]);
        RightType rightType = RightType.valueOf(parts[2]);
        Long relatedId = Long.parseLong(parts[3]);
        String relatedKey = parts[4];
        String viewUUID = parts[5];
        String clientID = parts[6];
        CachePart cachePart = new CachePart(targetType, rightType, relatedId, relatedKey, viewUUID, clientID);
        return cachePart;
    }

    /**
     * 缓存key结构定义
     */
    private static class CachePart {
        /**
         * 关联的角色id或者操作员id
         */
        private Long relatedId;
        /**
         * 目标类型 角色或者操作员
         */
        private TargetType targetType;
        /**
         * 权限类型 表单/字典
         */
        private RightType rightType;
        /**
         * 界面唯一id
         */
        private String viewUUID;
        /**
         * 关联的字典key或者单据key
         */
        private String relatedKey;
        /**
         * 当前用户会话id
         */
        private String clientID;

        public CachePart(TargetType targetType, RightType rightType, Long relatedId, String relatedKey, String viewUUID, String clientID) {
            this.targetType = targetType;
            this.rightType = rightType;
            this.relatedId = relatedId;
            this.viewUUID = viewUUID;
            this.relatedKey = relatedKey;
            this.clientID = clientID;
        }

        public TargetType getTargetType() {
            return targetType;
        }

        public RightType getRightType() {
            return rightType;
        }

        public String getViewUUID() {
            return viewUUID;
        }

        public String getRelatedKey() {
            return relatedKey;
        }

        public String getClientID() {
            return clientID;
        }

        public Long getRelatedId() {
            return relatedId;
        }

        @Override
        public String toString() {
            List<String> parts = new ArrayList<>();
            parts.add(targetType.name());
            parts.add(rightType.name());
            parts.add(relatedId.toString());
            parts.add(relatedKey);
            parts.add(viewUUID);
            parts.add(clientID);
            return String.join(JOIN_SYMBOL, parts);
        }
    }
}
