package com.bokesoft.yigo.commons.slnbase.service.right.excel;

import com.bokesoft.yes.excel.template.util.ExcelUtil;
import com.bokesoft.yes.struct.filedata.FileData;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.commons.slnbase.service.right.excel.structure.RightsData;
import com.bokesoft.yigo.commons.slnbase.service.right.excel.structure.RightsData4Dict;
import com.bokesoft.yigo.commons.slnbase.service.right.excel.utils.RightsDataUtil;
import com.bokesoft.yigo.excel.IExportService;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.condition.ConditionParas;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.document.FilterMap;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

import java.io.ByteArrayOutputStream;
import java.util.List;

public class RoleRightsDataExportSerivce implements IExportService {

    private final String SQL_QUERY_ROLEOPTRIGHTS = "SELECT FormKey, OptKey FROM SYS_RoleOptRights where RoleID=?";

    private final String SQL_QUERY_ROLEFIELDRIGHTS = "SELECT FormKey,FieldKey,Visible,Enable FROM SYS_RoleFieldRights where RoleID=?";

    private final String SQL_QUERY_ROLEENTRYRIGHTS = "SELECT EntryKey FROM SYS_RoleEntryRights where RoleID=?";

    private final String SQL_QUERY_ROLEDICTRIGHTS = "SELECT DictID FROM ${TABLE_RR} where RoleID=?";

    @Override
    public FileData exportData(DefaultContext context, Document document, FilterMap filterMap,
                               ConditionParas condParameters, String exportTables, String postEServiceName, boolean onlyCurrentPage, String exportFileName, boolean needDownload)
            throws Throwable {
        RightsData rightsData = RightsDataUtil.getRightsData(context);
        Workbook workbook = new SXSSFWorkbook(10000);
        long roleID = TypeConvertor.toLong(context.getPara("RoleOID"));
        if (roleID == 0) {
            throw new Exception("没有选择角色！");
        }
        _fillRoleRightsData4Entry2Workbook(context, workbook, roleID);
        _fillRoleRightsData4EntryOpt2Workbook(context, workbook, roleID);
        _fillRoleRightsData4EntryField2Workbook(context, workbook, roleID);
        _fillRoleRightsData4Dict2Workbook(context, workbook, rightsData, roleID);
//        String filePath = ExcelUtils.getExportFilePath(context.getVE().getMetaFactory(), "RightsData");
//        ExcelUtil.writeExcel((Workbook) workbook, filePath);
        FileData fileData = new FileData();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        workbook.write(bos);
        fileData.setFileName(exportFileName);
        fileData.setData(bos.toByteArray());
        return fileData;
    }

    private void _fillRoleRightsData4EntryOpt2Workbook(DefaultContext context, Workbook workbook, long roleID)
            throws Throwable {

        Sheet sheetRoleOpt = ExcelUtil.getSheet(workbook, "角色权限操作");
        Row rowEntryTitle = ExcelUtil.getRow(sheetRoleOpt, 0);
        ExcelUtil.setCellValue(ExcelUtil.getCell(rowEntryTitle, 0), "表单key");
        ExcelUtil.setCellValue(ExcelUtil.getCell(rowEntryTitle, 1), "操作key");
        DataTable dt = context.getDBManager().execPrepareQuery(SQL_QUERY_ROLEOPTRIGHTS, roleID);
        dt.beforeFirst();
        while (dt.next()) {
            ExcelUtil.setCellValue(sheetRoleOpt, sheetRoleOpt.getLastRowNum() + 1, 0, dt.getString("FormKey"));
            ExcelUtil.setCellValue(sheetRoleOpt, sheetRoleOpt.getLastRowNum(), 1, dt.getString("OptKey"));
        }
    }

    private void _fillRoleRightsData4EntryField2Workbook(DefaultContext context, Workbook workbook, long roleID)
            throws Throwable {
        Sheet sheetRoleField = ExcelUtil.getSheet(workbook, "角色字段权限");
        Row rowEntryTitle = ExcelUtil.getRow(sheetRoleField, 0);
        ExcelUtil.setCellValue(ExcelUtil.getCell(rowEntryTitle, 0), "表单key");
        ExcelUtil.setCellValue(ExcelUtil.getCell(rowEntryTitle, 1), "字段key");
        ExcelUtil.setCellValue(ExcelUtil.getCell(rowEntryTitle, 2), "可见性");
        ExcelUtil.setCellValue(ExcelUtil.getCell(rowEntryTitle, 3), "可用性");
        DataTable dt = context.getDBManager().execPrepareQuery(SQL_QUERY_ROLEFIELDRIGHTS, roleID);
        dt.beforeFirst();
        while (dt.next()) {
            ExcelUtil.setCellValue(sheetRoleField, sheetRoleField.getLastRowNum() + 1, 0, dt.getString("FormKey"));
            ExcelUtil.setCellValue(sheetRoleField, sheetRoleField.getLastRowNum(), 1, dt.getString("FieldKey"));
            ExcelUtil.setCellValue(sheetRoleField, sheetRoleField.getLastRowNum(), 2, dt.getInt("Visible"));
            ExcelUtil.setCellValue(sheetRoleField, sheetRoleField.getLastRowNum(), 3, dt.getInt("Enable"));
        }
    }

    private void _fillRoleRightsData4Entry2Workbook(DefaultContext context, Workbook workbook, long roleID)
            throws Throwable {

        Sheet sheetRoleEntry = ExcelUtil.getSheet(workbook, "角色入口权限");
        Row rowEntryTitle = ExcelUtil.getRow(sheetRoleEntry, 0);
        ExcelUtil.setCellValue(ExcelUtil.getCell(rowEntryTitle, 0), "可访问的入口key");
        DataTable dt = context.getDBManager().execPrepareQuery(SQL_QUERY_ROLEENTRYRIGHTS, roleID);
        dt.beforeFirst();
        while (dt.next()) {
            ExcelUtil.setCellValue(sheetRoleEntry, sheetRoleEntry.getLastRowNum() + 1, 0, dt.getString("EntryKey"));
        }
    }

    private void _fillRoleRightsData4Dict2Workbook(DefaultContext context, Workbook workbook, RightsData rightsData,
                                                   long roleID) throws Throwable {
        Sheet sheet = ExcelUtil.getSheet(workbook, "数据权限");
        Row rowTitle = ExcelUtil.getRow(sheet, 0);
        ExcelUtil.setCellValue(ExcelUtil.getCell(rowTitle, 0), "Project/模块");
        ExcelUtil.setCellValue(ExcelUtil.getCell(rowTitle, 1), "字典key");
        ExcelUtil.setCellValue(ExcelUtil.getCell(rowTitle, 2), "字典名称");
        ExcelUtil.setCellValue(ExcelUtil.getCell(rowTitle, 3), "对应数据表");
        ExcelUtil.setCellValue(ExcelUtil.getCell(rowTitle, 4), "对应数据ID");
        List<RightsData4Dict> rightsData4Dict = rightsData.getRightsData4Dict();
        _fillRoleRightsData4Dict2Workbook_Core(context, roleID, sheet, rightsData4Dict);
    }

    private void _fillRoleRightsData4Dict2Workbook_Core(DefaultContext context, long roleID, Sheet sheet,
                                                        List<RightsData4Dict> rightsData4Dict) throws Throwable {
        for (int idx = 0; idx < rightsData4Dict.size(); idx++) {
            String sql = SQL_QUERY_ROLEDICTRIGHTS.replace("${TABLE_RR}",
                    rightsData4Dict.get(idx).getMainTableKey() + "_RR");
            DataTable dt = context.getDBManager().execPrepareQuery(sql, roleID);
            dt.beforeFirst();
            while (dt.next()) {
                ExcelUtil.setCellValue(sheet, sheet.getLastRowNum() + 1, 0, rightsData4Dict.get(idx).getProject());
                ExcelUtil.setCellValue(sheet, sheet.getLastRowNum(), 1, rightsData4Dict.get(idx).getKey());
                ExcelUtil.setCellValue(sheet, sheet.getLastRowNum(), 2, rightsData4Dict.get(idx).getCaption());
                ExcelUtil.setCellValue(sheet, sheet.getLastRowNum(), 3, rightsData4Dict.get(idx).getMainTableKey() + "_RR");
                ExcelUtil.setCellValue(sheet, sheet.getLastRowNum(), 4, dt.getLong("DictID"));
            }
        }
    }
}
