package com.bokesoft.yigo.commons.slnbase.service.right;

import com.bokesoft.distro.tech.yigosupport.extension.base.IStaticMethodByNameExtServiceWrapper;
import com.bokesoft.yigo.commons.slnbase.service.right.enums.TargetType;
import com.bokesoft.yigo.commons.slnbase.service.right.struct.DictRight;
import com.bokesoft.yigo.commons.slnbase.service.right.struct.FormRight;
import com.bokesoft.yigo.commons.slnbase.service.right.enums.RightType;
import com.bokesoft.yigo.commons.slnbase.service.right.util.RightCacheUtil;
import com.bokesoft.yigo.commons.slnbase.service.right.util.RightIOUtil;
import com.bokesoft.yigo.commons.slnbase.service.right.util.RightUtil;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.List;

/**
 * yigo权限服务,通过InvokeService调用
 */
public class RightService implements IStaticMethodByNameExtServiceWrapper {
    private static final String DFT_VIEW_UUID ="0";
    private static Logger log = LoggerFactory.getLogger(RightService.class.getName());
    /**
     * 初始化加载
     * @param ctx
     * @return
     * @throws Throwable
     */
    public static Document loadSetRightsList(DefaultContext ctx) throws Throwable {
        Document document = ctx.getDocument();
        RightUtil.SetRight currentRightsData = RightUtil.getSetRightsData(ctx);
        DataTable headDT = document.get("YES_RS_RightsSet");
        headDT.setInt("All_O", 0);
        headDT.setInt("All_IsVisible", 0);
        headDT.setInt("All_IsEdit", 0);
        headDT.setInt("Is_Null", 0);
        headDT.setInt("All_DataRight", 0);
        headDT.setInt("All_Entry", 0);
        DataTable entryRightDT = document.get("YES_RS_EntryRights");
        RightUtil.buildEntryRightDT(currentRightsData.getEntry(), entryRightDT, 0l);
        DataTable dictRightsDT = document.get("YES_RS_DictRights");
        RightUtil.buildDictRightsDT(currentRightsData.getDict(), dictRightsDT);
        DataTable billRightsDT = document.get("YES_RS_BillRights");
        RightUtil.buildBillRightsDT(currentRightsData.getForm(), billRightsDT);
        return document;
    }

    /**
     * 根据指定角色加载菜单
     * @param ctx
     * @param roleID 角色id
     * @param operatorID 操作员id
     * @return
     */
    public static Document loadEntryRights(DefaultContext ctx, Long roleID,Long operatorID) {
        try {
            Document document = ctx.getDocument();
            DataTable entryDT=null;
            if(operatorID>0l){
                entryDT = ctx.getDBManager().execPrepareQuery("SELECT * FROM sys_operatorentryrights WHERE OperatorID=?", operatorID);
            }else if(roleID>0l){
                entryDT = ctx.getDBManager().execPrepareQuery("SELECT * FROM sys_roleentryrights WHERE RoleID=?", roleID);
            }
            DataTable entryRightDT = document.get("YES_RS_EntryRights");

            boolean all = false;
            List<String> hasRightEntryList = new ArrayList<>();
            if (entryDT.size() > 0) {
                entryDT.beforeFirst();
                while (entryDT.next()) {
                    String entryKey = entryDT.getString("EntryKey");
                    if (entryKey.equals("*")) {
                        all = true;
                        break;
                    }
                    hasRightEntryList.add(entryKey);
                }
            }
            //update
            if (entryRightDT.size() > 0) {
                entryRightDT.beforeFirst();
                while (entryRightDT.next()) {
                    String curEK = entryRightDT.getString("EntryKey");
                    if (all || hasRightEntryList.contains(curEK)) {
                        entryRightDT.setInt("select_E", 1);
                    }else {
                        entryRightDT.setInt("select_E", 0);
                    }
                }
            }
            DataTable headDT = document.get("YES_RS_RightsSet");
            headDT.setInt("All_Entry", all ? 1 : 0);
            return document;
        } catch (Throwable e) {
            log.error(e.getMessage(),e);
            return ExceptionUtils.rethrow(e);
        }
    }

    /**
     * 加载指定单据表单权限
     * @param ctx
     * @param roleID 角色id
     * @param operatorID 操作员id
     * @param formKey 单据key
     * @param viewUUID 界面唯一id
     * @return
     */
    public static Document loadFormRights(DefaultContext ctx,Long roleID,Long operatorID, String formKey, String viewUUID) throws Throwable {
        Document document = ctx.getDocument();
        DataTable headDT = document.get("YES_RS_RightsSet");
        String clientId =ctx.getVE().getClientID();
        //load cache
        if(StringUtils.isNotEmpty(viewUUID) && !DFT_VIEW_UUID.equals(viewUUID)){
            String prevFormKey = headDT.getString("FormKey");
            TargetType targetType =TargetType.OPERATOR;
            Long relatedId=-1l;
            if(roleID>0l){
                relatedId=roleID;
                targetType =TargetType.ROLE;
            }else if(operatorID>0l){
                relatedId=operatorID;
                targetType =TargetType.OPERATOR;
            }
            if(StringUtils.isNotEmpty(prevFormKey)){
                String  prevFormCacheKey = RightCacheUtil.buildCacheKey(targetType,RightType.FORM,relatedId,prevFormKey,viewUUID,clientId);
                //设置缓存
                RightCacheUtil.setCache(prevFormCacheKey,RightUtil.buildFormRightByDoc(document));
            }
            String curFormCacheKey = RightCacheUtil.buildCacheKey(targetType,RightType.FORM,relatedId,formKey,viewUUID,clientId);
            //加载当前form权限缓存
            FormRight formRightCache = RightCacheUtil.getCache(curFormCacheKey);
            if(formRightCache!=null){
                if(headDT.first()){
                    headDT.setString("FormKey",formKey);
                }
                RightUtil.fillFormRight2Document(document,formRightCache);
                return document;
            }
        }
        RightUtil.FormRightsData formRightsData = RightUtil.loadFormRights(ctx, formKey, roleID, operatorID);
        //update head
        if(headDT.first()){
            headDT.setString("FormKey",formKey);
            headDT.setInt("All_O", formRightsData.isHasAllOptRights() ? 1 : 0);
            headDT.setInt("All_IsVisible", formRightsData.isHasAllVisibleRights() ? 1 : 0);
            headDT.setInt("All_IsEdit", formRightsData.isHasAllEnableRights() ? 1 : 0);
        }
        //update Operations
        DataTable operationsDT = document.get("YES_RS_Operations");
        operationsDT.clear();
        List<RightUtil.FormRightsData.OptData> optDataList = formRightsData.getOptData();
        if(optDataList!=null){
            RightUtil.buildFormOptRightDT(optDataList,operationsDT,0L);
        }
        //update FieldRights
        DataTable fieldRightDT = document.get("YES_RS_FieldRights");
        fieldRightDT.clear();
        List<RightUtil.FormRightsData.FieldData> fieldDataList = formRightsData.getFieldData();
        if (fieldDataList != null) {
            RightUtil.buildFormFieldRightDT(fieldDataList, fieldRightDT, 0L);
        }
        return document;
    }

    /**
     * 加载对应字典权限
     * @param ctx
     * @param roleID 角色id
     * @param operatorID 操作员id
     * @param itemKey 字典key
     * @param viewUUID 界面唯一id
     * @return
     */
    public static Document loadDictRights(DefaultContext ctx, Long roleID,Long operatorID, String itemKey, String viewUUID) throws Throwable {
        Document document = ctx.getDocument();
        DataTable headDT = document.get("YES_RS_RightsSet");
        String clientId =ctx.getVE().getClientID();
        //load cache
        if(StringUtils.isNotEmpty(viewUUID) && !DFT_VIEW_UUID.equals(viewUUID)){
            String prevItemKey = headDT.getString("ItemKey");
            TargetType targetType =TargetType.OPERATOR;
            Long relatedId=-1l;
            if(roleID>0l){
                relatedId=roleID;
                targetType =TargetType.ROLE;
            }else if(operatorID>0l){
                relatedId=operatorID;
                targetType =TargetType.OPERATOR;
            }
            if(StringUtils.isNotEmpty(prevItemKey)){
                String  prevDictCacheKey = RightCacheUtil.buildCacheKey(targetType,RightType.DICT,relatedId,prevItemKey,viewUUID,clientId);
                DictRight dictRight=  RightUtil.buildDictRightByDoc(document);
                //设置缓存
                RightCacheUtil.setCache(prevDictCacheKey,dictRight);
            }
            String curDictCacheKey= RightCacheUtil.buildCacheKey(targetType,RightType.DICT,relatedId,itemKey,viewUUID,clientId);
            //加载当前Dict权限缓存
            DictRight dictRightCache = RightCacheUtil.getCache(curDictCacheKey);
            if(dictRightCache!=null){
                headDT.setString("ItemKey",itemKey);
                RightUtil.fillDictRight2Document(document,dictRightCache);
                return document;
            }
        }
        DictRight dictRightsData = RightUtil.loadDictRightsData(ctx, itemKey, roleID, operatorID);
        headDT.setString("ItemKey",itemKey);
        headDT.setInt("All_DataRight", dictRightsData.isHasAllRights() ? 1 : 0);
        headDT.setInt("Is_Null", dictRightsData.isHasEmptRights() ? 1 : 0);
        //update DataRigths
        DataTable dataRigthsDT = document.get("YES_RS_DataRigths");
        dataRigthsDT.clear();
        if(dictRightsData.getDataList()!=null){
            for (DictRight.Data dictData : dictRightsData.getDataList()) {
                dataRigthsDT.append();
                dataRigthsDT.setLong("OID",dictData.getOid());
                dataRigthsDT.setString("Code",dictData.getCode());
                dataRigthsDT.setString("Name",dictData.getName());
                dataRigthsDT.setLong("ParentId",dictData.getParentId());
                dataRigthsDT.setInt("Is_DataRight",dictData.isDataRight()?1:0);
            }
        }
        return document;
    }

    /**
     * 权限保存
     * @param ctx
     * @param roleID 角色id
     * @param operatorID 操作员id
     * @param viewId 界面唯一id
     */
    public static void save(DefaultContext ctx,Long roleID,Long operatorID,String viewId) {
        try {
            RightIOUtil.Save(ctx,roleID,operatorID,viewId);
        } catch (Throwable throwable) {
            log.error(throwable.getMessage(),throwable);
            ExceptionUtils.rethrow(throwable);
        }
    }

}
