package com.bokesoft.yigo.commons.slnbase.service;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.FullyQualifiedAnnotationBeanNameGenerator;

@Configuration
@ComponentScan(nameGenerator = FullyQualifiedAnnotationBeanNameGenerator.class)
@ConditionalOnProperty(
    name = SlnBaseConfiguration.ROOT_CONFIG_PREFIX + ".enabled", havingValue = "true", matchIfMissing = true)
public class SlnBaseConfiguration {
    /**
     * 本模块 application.yml 根配置项的前缀
     */
    public static final String ROOT_CONFIG_PREFIX = "yigo.commons.sln-base";

}
