/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.commons.slnbase.service.right.excel.treetar;

import com.alibaba.fastjson.JSON;
import com.bokesoft.yigo.commons.slnbase.service.right.excel.treetar.TreeCacheData;
import com.bokesoft.yigo.commons.slnbase.service.right.excel.treetar.TreeCompressData;
import com.bokesoft.yigo.commons.slnbase.service.right.excel.treetar.TreeUnit;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeDataTarTool {
    private static final long NODE_ALL_ID = 0L;
    private static Logger logger = LoggerFactory.getLogger(TreeDataTarTool.class);

    public static TreeCacheData initTreeData(Set<TreeUnit> treeSet) {
        TreeCacheData result = new TreeCacheData();
        HashMap<Long, TreeUnit> treeMap = new HashMap<Long, TreeUnit>();
        for (TreeUnit treeUnit : treeSet) {
            treeMap.put(treeUnit.getId(), treeUnit);
        }
        result.setTreeDataCache(treeMap);
        HashMap<Integer, Map<Long, TreeUnit>> treeDataCache = new HashMap<Integer, Map<Long, TreeUnit>>();
        result.setTreeLevelDataCache(treeDataCache);
        TreeUnit allTree = new TreeUnit(0L, -1L);
        allTree.setTreeLevel(-1);
        ArrayList<TreeUnit> atchildren = new ArrayList<TreeUnit>();
        allTree.setChildren(atchildren);
        HashMap<Long, TreeUnit> allTreeMap = new HashMap<Long, TreeUnit>();
        allTreeMap.put(0L, allTree);
        treeDataCache.put(-1, allTreeMap);
        HashSet<TreeUnit> dealedKeySet = new HashSet<TreeUnit>();
        int treeLevel = 0;
        long unDealedSize = -1L;
        long dealedSize = -1L;
        do {
            unDealedSize = treeSet.size();
            HashMap<Long, TreeUnit> curLevelTreeMap = new HashMap<Long, TreeUnit>();
            for (TreeUnit treeUnit : treeSet) {
                if (treeUnit.getParentId() <= 0L) {
                    treeUnit.setParentId(0L);
                    treeUnit.setTreeLevel(treeLevel);
                    curLevelTreeMap.put(treeUnit.getId(), treeUnit);
                    atchildren.add(treeUnit);
                    dealedKeySet.add(treeUnit);
                    continue;
                }
                if (!((Map)treeDataCache.get(treeLevel - 1)).containsKey(treeUnit.getParentId())) continue;
                TreeUnit parent = (TreeUnit)treeMap.get(treeUnit.getParentId());
                List<TreeUnit> pchildren = parent.getChildren();
                if (null == pchildren) {
                    pchildren = new ArrayList<TreeUnit>();
                }
                pchildren.add(treeUnit);
                parent.setChildren(pchildren);
                treeUnit.setTreeLevel(treeLevel);
                curLevelTreeMap.put(treeUnit.getId(), treeUnit);
                dealedKeySet.add(treeUnit);
            }
            if (!curLevelTreeMap.isEmpty()) {
                treeDataCache.put(treeLevel, curLevelTreeMap);
            }
            treeSet.removeAll(dealedKeySet);
            dealedKeySet.clear();
            dealedSize = treeSet.size();
            ++treeLevel;
        } while (unDealedSize != dealedSize);
        Map LeveL0TreeMap = (Map)treeDataCache.get(0);
        for (TreeUnit treeUnit : treeSet) {
            treeUnit.setParentId(0L);
            treeUnit.setTreeLevel(0);
            LeveL0TreeMap.put(treeUnit.getId(), treeUnit);
            atchildren.add(treeUnit);
        }
        return result;
    }

    public static TreeCompressData compress(TreeCacheData cacheData, Set<Long> sourceTypeIDs, boolean uesExclude, boolean ignoreMissedIDs) {
        Map<Integer, Map<Long, TreeUnit>> treeLevelDataCache = cacheData.getTreeLevelDataCache();
        Map<Long, TreeUnit> treeDataCache = cacheData.getTreeDataCache();
        TreeCompressData dealedData = new TreeCompressData();
        HashSet<Long> includeIDs = new HashSet<Long>();
        HashSet<Long> excludeIDs = new HashSet<Long>();
        ArrayList<Long> typeIdList = new ArrayList<Long>();
        typeIdList.addAll(sourceTypeIDs);
        long curTlevel = treeLevelDataCache.size();
        do {
            for (int idx = 0; idx < typeIdList.size(); ++idx) {
                long typeID = (Long)typeIdList.get(idx);
                TreeUnit tbean = treeDataCache.get(typeID);
                if (null == tbean) {
                    if (ignoreMissedIDs) continue;
                    logger.error(">>> [ID]" + typeID + ",\u5728\u6811\u7ed3\u6784\u4e2d\u4e0d\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5");
                    throw new RuntimeException(">>> [ID]" + typeID + ",\u5728\u6811\u7ed3\u6784\u4e2d\u4e0d\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5");
                }
                long parentID = tbean.getParentId();
                int parentTLevel = tbean.getTreeLevel() - 1;
                TreeUnit pbean = treeLevelDataCache.get(parentTLevel).get(parentID);
                List<TreeUnit> pchildren = pbean.getChildren();
                ArrayList<Long> brothers = new ArrayList<Long>();
                for (TreeUnit pchild : pchildren) {
                    brothers.add(pchild.getId());
                }
                if (!TreeDataTarTool._checkRateWithCompression(typeIdList, excludeIDs, brothers, uesExclude)) continue;
                typeIdList.removeAll(brothers);
                typeIdList.add(parentID);
                --idx;
            }
        } while (--curTlevel > -1L);
        includeIDs.addAll(typeIdList);
        dealedData.setExcludeIDs(excludeIDs);
        dealedData.setIncludeIDs(includeIDs);
        return dealedData;
    }

    public static Set<Long> findDirectAncestors(TreeCacheData cacheData, long id, boolean ignoreMissedIDs) {
        return TreeDataTarTool.findDirectAncestors(cacheData, id, -1L, ignoreMissedIDs);
    }

    public static Set<Long> findDirectAncestors(TreeCacheData cacheData, long id, long targetLevel, boolean ignoreMissedIDs) {
        HashSet<Long> result = new HashSet<Long>();
        Map<Long, TreeUnit> treeDataCache = cacheData.getTreeDataCache();
        TreeUnit tbean = treeDataCache.get(id);
        if (null == tbean) {
            if (ignoreMissedIDs) {
                logger.error(">>> [ID]" + id + ",\u5728\u6811\u7ed3\u6784\u4e2d\u4e0d\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5");
                throw new RuntimeException(">>> [ID]" + id + ",\u5728\u6811\u7ed3\u6784\u4e2d\u4e0d\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5");
            }
            return result;
        }
        logger.info(">>> [ID]" + id + ",\u83b7\u53d6\u7684bean\u6570\u636e:" + JSON.toJSONString((Object)tbean));
        int curTreeLevel = tbean.getTreeLevel();
        if (targetLevel < (long)curTreeLevel) {
            long parentID = tbean.getParentId();
            result.add(parentID);
            while (parentID > 0L && targetLevel < (long)curTreeLevel) {
                TreeUnit pbean = treeDataCache.get(parentID);
                parentID = pbean.getParentId();
                curTreeLevel = tbean.getTreeLevel();
                result.add(parentID);
            }
        }
        return result;
    }

    public static long findParent(TreeCacheData cacheData, long id, boolean ignoreMissedIDs) {
        Map<Long, TreeUnit> treeDataCache = cacheData.getTreeDataCache();
        TreeUnit tbean = treeDataCache.get(id);
        if (null == tbean && ignoreMissedIDs) {
            logger.error(">>> [ID]" + id + ",\u5728\u6811\u7ed3\u6784\u4e2d\u4e0d\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5");
            throw new RuntimeException(">>> [ID]" + id + ",\u5728\u6811\u7ed3\u6784\u4e2d\u4e0d\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5");
        }
        long parentID = tbean.getParentId();
        return parentID;
    }

    public static Set<Long> extension(TreeCacheData cacheData, TreeCompressData compressData, int targetLevel, boolean ignoreMissedIds) {
        return TreeDataTarTool.extension(cacheData, compressData.getIncludeIDs(), compressData.getExcludeIDs(), targetLevel, ignoreMissedIds);
    }

    public static Set<Long> extension(TreeCacheData cacheData, Set<Long> includeIDs, Set<Long> excludeIDs, int targetLevel, boolean ignoreMissedIds) {
        Map<Long, TreeUnit> treeMap = cacheData.getTreeDataCache();
        HashSet<Long> result = new HashSet<Long>();
        for (Long sourceTypeID : includeIDs) {
            TreeUnit tbean = treeMap.get(sourceTypeID);
            if (null != tbean) {
                if (targetLevel > 0 && tbean.getTreeLevel() >= targetLevel) {
                    if (null != excludeIDs && excludeIDs.contains(sourceTypeID)) continue;
                    result.add(sourceTypeID);
                    continue;
                }
                List<TreeUnit> children = tbean.getChildren();
                if (null != children) {
                    TreeDataTarTool._extensionChildren(result, children, excludeIDs, targetLevel);
                    continue;
                }
                if (null != excludeIDs && excludeIDs.contains(sourceTypeID)) continue;
                result.add(sourceTypeID);
                continue;
            }
            if (ignoreMissedIds) continue;
            logger.error(">>> [ID]" + sourceTypeID + ",\u5728\u6811\u7ed3\u6784\u4e2d\u4e0d\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5");
            throw new RuntimeException(">>> [ID]" + sourceTypeID + ",\u5728\u6811\u7ed3\u6784\u4e2d\u4e0d\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5");
        }
        return result;
    }

    private static boolean _checkRateWithCompression(List<Long> typeIdList, Set<Long> excludeIDs, List<Long> brothers, boolean uesExclude) {
        HashSet<Long> unmatchedSet = new HashSet<Long>();
        for (Long brother : brothers) {
            if (typeIdList.contains(brother)) continue;
            unmatchedSet.add(brother);
        }
        BigDecimal usSize = new BigDecimal(unmatchedSet.size());
        BigDecimal bSize = new BigDecimal(brothers.size());
        if (uesExclude) {
            if (usSize.divide(bSize, 3, 4).compareTo(new BigDecimal("0.3")) < 0) {
                excludeIDs.addAll(unmatchedSet);
                return true;
            }
        } else if (unmatchedSet.isEmpty()) {
            excludeIDs.addAll(unmatchedSet);
            return true;
        }
        return false;
    }

    private static void _extensionChildren(Set<Long> result, List<TreeUnit> children, Set<Long> excludeIDs, int targetLevel) {
        for (TreeUnit child : children) {
            if (targetLevel > 0 && child.getTreeLevel() >= targetLevel) {
                if (null != excludeIDs && excludeIDs.contains(child.getId())) continue;
                result.add(child.getId());
                continue;
            }
            List<TreeUnit> gchildren = child.getChildren();
            if (null != gchildren) {
                TreeDataTarTool._extensionChildren(result, gchildren, excludeIDs, targetLevel);
                continue;
            }
            if (null != excludeIDs && excludeIDs.contains(child.getId())) continue;
            result.add(child.getId());
        }
    }
}

