package com.bokesoft.yigo.commons.slnbase.service.right.util;

import com.bokesoft.yes.mid.rights.RightsProviderFactory;
import com.bokesoft.yes.mid.rights.cache.IRightsCache;
import com.bokesoft.yes.mid.rights.cache.RightsCacheFactory;
import com.bokesoft.yigo.commons.slnbase.service.right.enums.TargetType;
import com.bokesoft.yigo.commons.slnbase.service.right.struct.DictRight;
import com.bokesoft.yigo.commons.slnbase.service.right.struct.EntryRight;
import com.bokesoft.yigo.commons.slnbase.service.right.struct.FormRight;
import com.bokesoft.yigo.commons.slnbase.service.right.struct.RightSaveVO;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.rights.EntryRights;
import org.apache.commons.lang3.StringUtils;
import java.util.*;

public class RightIOUtil {

    /**
     * 权限保存
     * @param ctx
     * @param roleID 角色id
     * @param operatorID 操作员id
     * @param viewId 界面唯一id
     */
    public static void Save(DefaultContext ctx, Long roleID, Long operatorID, String viewId) throws Throwable {
        RightSaveVO rightVO = buildRightIO(ctx, roleID, operatorID);
        saveEntry(ctx, rightVO.getEntryRight(), rightVO.getOperatorId(), rightVO.getRoleId());
        saveFormOptRight(ctx, rightVO.getFormRights(), rightVO.getOperatorId(), rightVO.getRoleId());
        saveFormFieldRight(ctx, rightVO.getFormRights(), rightVO.getOperatorId(), rightVO.getRoleId());
        saveDictDataRight(ctx, rightVO.getDictRights(), rightVO.getOperatorId(), rightVO.getRoleId());
        //clear cache
        RightCacheUtil.clearCacheByViewId(ctx.getVE().getClientID(), viewId);
    }

    /**
     * 构建权限vo(表单权限和字典权限通过缓存加载)
     * @param ctx
     * @param roleID
     * @param operatorID
     * @return
     */
    private static RightSaveVO buildRightIO(DefaultContext ctx, Long roleID, Long operatorID) {
        RightSaveVO rightIO = new RightSaveVO();
        rightIO.setOperatorId(operatorID);
        rightIO.setRoleId(roleID);
        Long relatedId = -1l;
        TargetType targetType = null;
        if (roleID > 0l) {
            targetType = TargetType.ROLE;
            relatedId = roleID;
        } else if (operatorID > 0l) {
            targetType = TargetType.OPERATOR;
            relatedId = operatorID;
        }
        Document document = ctx.getDocument();
        DataTable head = document.get("YES_RS_RightsSet");
        String formKey = head.getString("FormKey");
        String itemKey = head.getString("ItemKey");
        //菜单
        DataTable entryRightDT = document.get("YES_RS_EntryRights");
        EntryRight entryRight = new EntryRight();
        entryRight.setHasAllEntry(head.getInt("All_Entry") == 1);
        entryRight.setEntryList(new ArrayList<>());
        if (entryRightDT != null) {
            entryRightDT.beforeFirst();
            while (entryRightDT.next()) {
                EntryRight.Entry entry = new EntryRight.Entry();
                entry.setEntryKey(entryRightDT.getString("EntryKey"));
                entry.setEntryName(entryRightDT.getString("EntryName"));
                entry.setId(entryRightDT.getLong("OID"));
                entry.setPid(entryRightDT.getLong("ParentID"));
                entry.setSelectE(entryRightDT.getInt("select_E") == 1);
                entryRight.getEntryList().add(entry);
            }
        }
        rightIO.setEntryRight(entryRight);
        //字典
        Map<String, DictRight> dictRights = RightCacheUtil.getDictRights(ctx, targetType, relatedId);
        //单据
        Map<String, FormRight> formRights = RightCacheUtil.getFormRights(ctx, targetType, relatedId);
        //判断当前缓存
        if (StringUtils.isNotEmpty(formKey) && !formRights.containsKey(formKey)) {
            formRights.put(formKey, RightUtil.buildFormRightByDoc(document));
        }
        if (StringUtils.isNotEmpty(itemKey) && !dictRights.containsKey(itemKey)) {
            DictRight dictRight = RightUtil.buildDictRightByDoc(document);
            dictRights.put(itemKey, dictRight);
        }
        rightIO.setDictRights(new ArrayList<>(dictRights.values()));
        rightIO.setFormRights(new ArrayList<>(formRights.values()));
        return rightIO;
    }

    /**
     * 保存菜单权限
     * @param ctx
     * @param entryRight
     * @param operatorID
     * @param roleID
     */
    private static void saveEntry(DefaultContext ctx, EntryRight entryRight, Long operatorID, Long roleID) throws Throwable {
        String dSql = "", iSql = "";
        long relatedID = -1l;
        IRightsCache rightsCache = null;
        if (roleID > -1l) {
            relatedID = roleID;
            rightsCache = RightsCacheFactory.getInstance().createRoleRightsCache();
            dSql = "DELETE FROM SYS_RoleEntryRights where RoleID=?";
            iSql = "INSERT INTO SYS_RoleEntryRights (EntryKey,RoleID) VALUES ";
        } else if (operatorID > -1l) {
            relatedID = operatorID;
            rightsCache = RightsCacheFactory.getInstance().createOperatorRightsCache();
            dSql = "DELETE FROM SYS_OperatorEntryRights where OperatorID=?";
            iSql = "INSERT INTO SYS_OperatorEntryRights (EntryKey,OperatorID) VALUES ";
        }
        ctx.getDBManager().execPrepareUpdate(dSql, relatedID);
        StringBuffer updateSqlbf = new StringBuffer(iSql);
        List<Object> args = new ArrayList<Object>();
        EntryRights currentER = RightsProviderFactory.getInstance().newRightsProvider(ctx).getEntryRights();
        if (entryRight.isHasAllEntry() && currentER.hasAllRights()) {
            updateSqlbf.append("(?,?),");
            args.add("*");
            args.add(relatedID);
        } else {
            List<EntryRight.Entry> entries = entryRight.getEntryList();
            if (entries != null) {
                for (EntryRight.Entry entry : entries) {
                    if (entry.isSelectE()) {
                        updateSqlbf.append("(?,?),");
                        args.add(entry.getEntryKey());
                        args.add(relatedID);
                    }

                }
            }
        }
        if (args.size() > 0) {
            ctx.getDBManager().execPrepareUpdate(updateSqlbf.substring(0, updateSqlbf.length() - 1), args);
        }
        rightsCache.clearEntryRights(relatedID);
    }

    /**
     * 保存表单字段权限
     * @param ctx
     * @param formRights
     * @param operatorID
     * @param roleID
     * @throws Throwable
     */
    private static void saveFormFieldRight(DefaultContext ctx, List<FormRight> formRights, Long operatorID, Long roleID) throws Throwable {
        String dSql = "", iSql = "";
        long relatedID = -1l;
        IRightsCache rightsCache = null;
        if (roleID > -1l) {
            relatedID = roleID;
            dSql = "DELETE FROM SYS_RoleFieldRights where RoleID=? AND FormKey=?";
            iSql = "INSERT INTO SYS_RoleFieldRights (FormKey,FieldKey,Visible,Enable,RoleID) VALUES ";
            rightsCache = RightsCacheFactory.getInstance().createRoleRightsCache();
        } else if (operatorID > -1l) {
            relatedID = operatorID;
            dSql = "DELETE FROM SYS_OperatorFieldRights where OperatorID=? AND FormKey=?";
            iSql = "INSERT INTO SYS_OperatorFieldRights (FormKey,FieldKey,Visible,Enable,OperatorID) VALUES ";
            rightsCache = RightsCacheFactory.getInstance().createOperatorRightsCache();
        }
        StringBuffer updateSqlbf = new StringBuffer();
        List<Object> args = new ArrayList<Object>();
        for (FormRight formRight : formRights) {
            args.clear();
            updateSqlbf.setLength(0);
            updateSqlbf.append(iSql);
            String formKey = formRight.getFormKey();
            //先删除
            ctx.getDBManager().execPrepareUpdate(dSql, relatedID, formKey);
            //表单字段
            List<FormRight.Field> fields = formRight.getField();
            for (FormRight.Field field : fields) {
                //只需要保存没有权限的数据
                if (!field.isEdit() || !field.isVisible()) {
                    updateSqlbf.append("(?,?,?,?,?),");
                    args.add(formKey);
                    args.add(field.getFieldKey());
                    args.add(field.isVisible() ? 1 : 0);
                    args.add(field.isEdit() ? 1 : 0);
                    args.add(relatedID);
                }
            }
            if (args.size() > 0) {
                ctx.getDBManager().execPrepareUpdate(updateSqlbf.substring(0, updateSqlbf.length() - 1), args);
            }
            //清除缓存
            rightsCache.clearFormRights(relatedID, formKey);
        }
    }

    /**
     * 保存表单操作权限
     * @param ctx
     * @param formRights
     * @param operatorID
     * @param roleID
     * @throws Throwable
     */
    private static void saveFormOptRight(DefaultContext ctx, List<FormRight> formRights, Long operatorID, Long roleID) throws Throwable {
        String dSql = "", iSql = "";
        long relatedID = -1l;
        IRightsCache rightsCache = null;
        if (roleID > -1l) {
            relatedID = roleID;
            dSql = "DELETE FROM SYS_RoleOptRights where RoleID=? AND FormKey=?";
            iSql = "INSERT INTO SYS_RoleOptRights (FormKey, OptKey,RoleID) VALUES ";
            rightsCache = RightsCacheFactory.getInstance().createRoleRightsCache();
        } else if (operatorID > -1l) {
            relatedID = operatorID;
            dSql = "DELETE FROM SYS_OperatorOptRights where OperatorID=? AND FormKey=?";
            iSql = "INSERT INTO SYS_OperatorOptRights (FormKey, OptKey,OperatorID) VALUES ";
            rightsCache = RightsCacheFactory.getInstance().createOperatorRightsCache();
        }
        StringBuffer updateSqlbf = new StringBuffer();
        List<Object> args = new ArrayList<Object>();

        HashSet<String> optKeys = getFormKeysOfHasAllOptRight(ctx);
        for (FormRight formRight : formRights) {
            String formKey = formRight.getFormKey();
            //先删除
            ctx.getDBManager().execPrepareUpdate(dSql, relatedID, formKey);
            args.clear();
            updateSqlbf.setLength(0);
            updateSqlbf.append(iSql);
            //表单操作
            List<FormRight.Opt> opts = formRight.getOpt();
            if (formRight.isHasAllOptRights() && (RightUtil.isAdmin(ctx) || optKeys.contains(formKey))) {
                updateSqlbf.append("(?,?,?),");
                args.add(formKey);
                args.add("*");
                args.add(relatedID);
            } else {
                if (opts != null) {
                    for (FormRight.Opt opt : opts) {
                        if (opt.isOpt()) {
                            updateSqlbf.append("(?,?,?),");
                            args.add(formKey);
                            args.add(opt.getOptKey());
                            args.add(relatedID);
                        }
                    }
                }
            }
            if (args.size() > 0) {
                ctx.getDBManager().execPrepareUpdate(updateSqlbf.substring(0, updateSqlbf.length() - 1), args);
            }
            //清除缓存
            rightsCache.clearFormRights(relatedID, formKey);
        }
    }

    /**
     * 保存字典权限数据
     * @param ctx
     * @param dictRights
     * @param operatorID
     * @param roleID
     */
    private static void saveDictDataRight(DefaultContext ctx, List<DictRight> dictRights, Long operatorID, Long roleID) throws Throwable {
        List<Object> args = new ArrayList<Object>();
        String dSql = "", iSql = "", dbTable = "";
        IRightsCache rightsCache = null;
        long relatedID = -1l;
        if (roleID > -1l) {
            relatedID = roleID;
            dSql = "DELETE FROM ${TABLE_RR} where RoleID=?";
            iSql = "INSERT INTO ${TABLE_RR} (DictID,RoleID) VALUES";
            rightsCache = RightsCacheFactory.getInstance().createRoleRightsCache();
        } else if (operatorID > -1l) {
            relatedID = operatorID;
            dSql = "DELETE FROM ${TABLE_RR} where OperatorID=?";
            iSql = "INSERT INTO ${TABLE_RR} (DictID,OperatorID) VALUES";
            rightsCache = RightsCacheFactory.getInstance().createOperatorRightsCache();
        }

        StringBuffer updateSqlbf = new StringBuffer(iSql);
        IMetaFactory metaFactory = ctx.getVE().getMetaFactory();
        MetaDataObject metaDataObject;
        if (dictRights != null && dictRights.size() > 0) {
            HashSet<String> allDictRightItemKeys = getItemKeysOfHasAllDictRight(ctx, dictRights, operatorID, roleID);
            for (DictRight dictRight : dictRights) {
                String itemKey = dictRight.getItemKey();
                metaDataObject = metaFactory.getDataObject(itemKey);
                dbTable = metaDataObject.getMainTable().getBindingDBTableName();
                if (roleID > -1l) {
                    dbTable = dbTable + "_RR";
                } else if (operatorID > -1l) {
                    dbTable = dbTable + "_OR";
                }
                //删除
                ctx.getDBManager().execPrepareUpdate(dSql.replace("${TABLE_RR}", dbTable), relatedID);
                updateSqlbf.setLength(0);
                updateSqlbf.append(iSql.replace("${TABLE_RR}", dbTable));
                //空值权限
                if (dictRight.isHasEmptRights()) {
                    updateSqlbf.append("(?,?),");
                    args.add(0);
                    args.add(relatedID);
                }
                boolean allDict = RightUtil.isAdmin(ctx) || metaFactory.hasAllDictRights(itemKey) || allDictRightItemKeys.contains(itemKey);
                if (dictRight.isHasAllRights() && allDict) {
                    updateSqlbf.append("(?,?),");
                    args.add(-1);
                    args.add(relatedID);
                } else {
                    List<DictRight.Data> dataList = dictRight.getDataList();
                    if (dataList != null && dataList.size() > 0) {
                        for (DictRight.Data data : dataList) {
                            if (data.isDataRight()) {
                                updateSqlbf.append("(?,?),");
                                args.add(data.getOid());
                                args.add(relatedID);
                            }
                            if (args.size() > 1000) {
                                ctx.getDBManager().execPrepareUpdate(updateSqlbf.substring(0, updateSqlbf.length() - 1), args);
                                args.clear();
                            }
                        }
                    }
                }
                if (args.size() > 0) {
                    ctx.getDBManager().execPrepareUpdate(updateSqlbf.substring(0, updateSqlbf.length() - 1), args);
                    args.clear();
                }
                rightsCache.clearDictRights(relatedID, dictRight.getItemKey());
            }
        }

    }

    private static HashSet<String> getItemKeysOfHasAllDictRight(DefaultContext ctx, List<DictRight> dictRights, Long operatorID, Long roleID) throws Throwable {
        HashSet<String> itemKeys = new HashSet();
        long relatedID = -1l;
        String sql = "";
        if (roleID > -1l) {
            relatedID = roleID;
            sql = "SELECT '${ITEM_KEY}' AS ItemKey FROM ${TABLE} WHERE RoleID=? AND DictID=?";
        } else if (operatorID > -1l) {
            relatedID = operatorID;
            sql = "SELECT '${ITEM_KEY}' AS ItemKey FROM ${TABLE} WHERE OperatorID=? AND DictID=?";
        }
        if (dictRights != null) {
            List<Object> args = new ArrayList<>();
            StringBuilder querySB = new StringBuilder();
            IMetaFactory metaFactory = ctx.getVE().getMetaFactory();
            MetaDataObject metaDataObject;
            int i = 0;
            for (DictRight dictRight : dictRights) {
                if (i > 0) {
                    querySB.append("\n").append(" UNION ALL ");
                }
                metaDataObject = metaFactory.getDataObject(dictRight.getItemKey());
                String dbTable = metaDataObject.getMainTable().getBindingDBTableName();
                if (roleID > -1l) {
                    dbTable = dbTable + "_RR";
                } else if (operatorID > -1l) {
                    dbTable = dbTable + "_OR";
                }
                querySB.append(sql.replace("${TABLE}", dbTable).replace("${ITEM_KEY}", dictRight.getItemKey()));
                args.add(relatedID);
                args.add(-1);
                i++;
            }
            DataTable dt = ctx.getDBManager().execPrepareQuery(querySB.toString(), args);
            if (dt.size() > 0) {
                dt.beforeFirst();
                while (dt.next()) {
                    itemKeys.add(dt.getString("ItemKey"));
                }
            }
        }
        return itemKeys;
    }

    /**
     * 查询当前用户有 表单操作全部权限 的表单集合
     * @param ctx
     * @return
     */
    private static HashSet<String> getFormKeysOfHasAllOptRight(DefaultContext ctx) throws Throwable {
            Long userId = ctx.getVE().getEnv().getUserID();
            List<Long> roleIds = ctx.getVE().getEnv().getRoleIDList();
            HashSet<String> formKeys = new HashSet();
            DataTable userOptRightDT = ctx.getDBManager().execPrepareQuery("SELECT FormKey,OptKey FROM SYS_OperatorOptRights WHERE OperatorID=?", userId);
            if (userOptRightDT.size() > 0) {
                userOptRightDT.beforeFirst();
                while (userOptRightDT.next()) {
                    String formKey = userOptRightDT.getString("FormKey");
                    String optKey = userOptRightDT.getString("OptKey");
                    if ("*".equals(optKey)) {
                        formKeys.add(formKey);
                    }
                }
            }
            if (roleIds != null && roleIds.size() > 0) {
                DataTable roleOptRightDT = ctx.getDBManager().execPrepareQuery("SELECT FormKey,OptKey FROM SYS_RoleOptRights WHERE RoleID IN (" + StringUtils.join(Collections.nCopies(roleIds.size(), "?"), ",") + ")", roleIds);
                if (roleOptRightDT.size() > 0) {
                    roleOptRightDT.beforeFirst();
                    while (roleOptRightDT.next()) {
                        String formKey = roleOptRightDT.getString("FormKey");
                        String optKey = roleOptRightDT.getString("OptKey");
                        if ("*".equals(optKey)) {
                            formKeys.add(formKey);
                        }
                    }
                }
            }
            return formKeys;
    }


}
