/**
 * 加载ux
 */
(async () => {
    const loader = await import("./ux-loader/index.js");

    if (window.YigoMobileUxSetting) { // 有YigoUX
        // 加载主题
        let loadThemeResult = loader.loadTheme(
            YigoMobileUxSetting.themeOption,
            YigoMobileUxSetting.avaliableThemes,
            YigoMobileUxSetting.additionalThemeVariables,
            YigoMobileUxSetting.extendThemeCssUrls
        );
        //应用主题
        if (loadThemeResult) {
            loader.applyTheme(() => { });
        }

        //同步主题到 cookie, 这样登录一次后, 下次就会记住用户的设置(用于登录界面)
        window.dispatchEvent(new CustomEvent('YIUI-ux-theme-changed', {
            detail: {
                themeOptionMobile: YigoMobileUxSetting.themeOption
            }
        }));
    }
})();

function getUXWebRoot() {
    return './yesui/';
}