import "./modulepreload-polyfill-7faf532e.js";
import { A as YesModalContainer, T as Tabs, L as LLMChatTrigger, B as LLMChat, b as YesVBaseComponent, C as ControlMapping, D as treeClickHandle, F as FormRenderUtil, E as YesOwnerDraw, c as YElement, s as h, M as MainContainerBuilder } from "./yes-ui-0d74d048.js";
import { q as ExceptionStack, bz as StatusProxy, bA as afterYIUILoad, bB as UIOptTraceUtil, aB as MainUIOptTracer, bC as FormRender, bD as AppSetting, be as MainFrameInterface, bE as LLMChatInterface, S as SvrMgr, K as I18N, bd as MainContainer, bF as SessionParasCache, bw as SessionInfo, _ as IconSourceLoader, bG as YesCore, w as ControlType, bH as CookiesUtil, j as FormBuilder, M as MetaService, s as FormTarget, O as OperationState, N as NewOpt, i as OptQueue, bI as RemoteService, k as FormStack, ao as BaseDialog, a6 as GridSetting, h as FormType, bs as NotificationMgr, bJ as MenuFavoriteService, bK as ViewParser, l as FuncMap, bL as DataService, aK as DictService, L as LoadingUtil, bM as BeaconService, bN as RTS_Service, bO as IconUtil, v as ViewContext } from "./yes-core-bce045b8.js";
import { M as MainFrame } from "./index-bc50abdf.js";
import "./vendor-e1ca6068.js";
MainFrameInterface.MainFrame = MainFrame;
LLMChatInterface.LLMChat = LLMChat;
LLMChatInterface.LLMChatTrigger = LLMChatTrigger;
window.addEventListener("error", function(e) {
  ExceptionStack.push(e.error);
});
window.addEventListener("unhandledrejection", function(e) {
  ExceptionStack.push(e.reason);
});
window.addEventListener("YIUI-loaded", function() {
  StatusProxy.licenseCheck();
});
window.Yes_TEMP_LoggedInState = true;
window.addEventListener("beforeunload", (e) => {
  console.log("main onbeforeunload");
  if (window.Yes_TEMP_LoggedInState) {
    e.preventDefault();
    e.returnValue = "";
    return "";
  }
});
async function init() {
  let strings = await SvrMgr.loadi18nData();
  I18N.seti18nStrings(strings);
  const mainContainer = MainContainerBuilder(Tabs);
  MainContainer.set(mainContainer);
  SvrMgr.getSessionInfo().then(function(result) {
    if (result) {
      if (result.SessionParas) {
        var sessionData = result.SessionParas;
        if (typeof sessionData === "string") {
          sessionData = JSON.parse(sessionData);
        }
        SessionParasCache.setParas(sessionData);
      }
      SessionInfo.setCode(result.Code);
      SessionInfo.setUserName(result.Name);
      SessionInfo.setUserID(result.UserID);
      SessionInfo.setClusterID(result.clusterID);
      SessionInfo.setLoginTime(result.Time);
    } else {
      SessionInfo.clear();
    }
  });
  await IconSourceLoader.loadIconSourceFile();
  window.YIUI = {
    ...window.YIUI || {},
    YesCore,
    YesBaseComponent: YesVBaseComponent,
    BuilderMap: ControlMapping,
    treeClickHandle: treeClickHandle(mainContainer),
    SvrMgr,
    SessionInfo,
    I18N,
    ControlType,
    CookiesUtil,
    errorHandle(e) {
      return ExceptionStack.push(e);
    },
    FormBuilder,
    MetaService,
    FormTarget,
    OperationState,
    NewOpt,
    OptQueue,
    FormRenderUtil,
    RemoteService,
    YesOwnerDraw,
    FormStack,
    BaseDialog,
    YElement,
    h,
    isShowReloadButton: true,
    // 是否显示reload按钮
    // reg: function(){}
    GridSetting,
    AppSetting,
    FormType,
    APP: {
      MainFrame
    },
    NotificationMgr,
    MenuFavoriteService,
    ViewParser,
    Expr: FuncMap,
    DataService,
    DictService,
    LoadingUtil,
    BeaconService,
    RTS_Service,
    IconUtil
  };
  window.YIUI.webRoot = (() => {
    let url;
    if (SvrMgr.baseurl) {
      url = `${SvrMgr.baseurl}/${"yesui"}/`;
    } else {
      url = `${"yesui"}/`;
    }
    return url;
  })();
  AppSetting.updateClientSetting("mainframe.openEntryByClick", true);
  AppSetting.updateClientSetting("mainframe.closeOtherEntry", false);
  window.View = {
    FuncMap: null
  };
  window.Expr = {
    regCluster: function(map, funext) {
      YesCore.Functions.regCluster(funext);
    }
  };
  window.exec = async function(formID, formula) {
    var form = FormStack.getForm(formID);
    var cxt = new ViewContext(form);
    if (form) {
      return form.eval(formula, cxt);
    } else {
      var parser = new ViewParser();
      return parser.eval(formula, cxt);
    }
  };
}
init().then(async () => {
  afterYIUILoad();
  await UIOptTraceUtil.init();
  window.YIUI.MainUIOptTracer = MainUIOptTracer;
  function repeatUploadUserTraces() {
    UIOptTraceUtil.uploadTraces();
    setTimeout(repeatUploadUserTraces, 3e5);
  }
  repeatUploadUserTraces();
});
FormRender.setYesCom(new YesModalContainer());
new Tabs({
  parent: document.querySelector("#app")
});
let LLMChatFlag = false;
AppSetting.registerClientSettingsListener("yescore.llmchat.enable", (key, value) => {
  if (value) {
    LLMChatTrigger.init();
    LLMChatFlag = true;
  } else {
    if (LLMChatFlag) {
      LLMChatTrigger.destroy();
      LLMChatFlag = false;
    }
  }
});
//# sourceMappingURL=main-aa736da4.js.map
