import { Y as YesVBatchImageUploader, a as YesComponentBuilder, b as YesVBaseComponent, c as YElement, d as YesCheckListBoxBuilder, e as YesCheckListBoxStyle, f as YesComboBoxBuilder, g as YesComboBoxStyle, h as YesVImage, i as debounce, j as YesImageBuilder, k as YesVVideoPlayer, l as YesVideoPlayerBuilder, m as YesVBaseText, n as YesVSeparator, o as YesVTextArea, p as jq, q as YesTextAreaBuilder, r as YesVBaseButton, s as h$1, t as closestEles, u as YesForm, C as ControlMapping, v as select, w as syncevent, x as YesNumberEditorBuilderBuilder, V as VAutoLayout, y as VFlexFlowLayoutCss3, z as YesFlexflowLayoutPanelPanelBuilder } from "./yes-ui-0d74d048.js";
import { I as InterActiveFactory, K as I18N, w as ControlType, X as CompSetting, H as HashMap, aQ as Popup, e as FallBackUtil, al as ImageSourceType, Y as TraceUIOptEvent, a3 as CaseType, a4 as TextFormat, a1 as PositionUtil, aj as FileUtil, L as LoadingUtil, bt as SelectEditType, aE as DictState, aD as ItemData, aI as SecondaryType, a5 as RoundingMode, aq as DirectionType, bu as DictPaneShowType, ak as ImageScaleType, R as CssUtil, S as SvrMgr, v as ViewContext, Z as ZIndexUtil, bv as WaterMark, bw as SessionInfo, bx as Env, k as FormStack, by as RightsService, M as MetaService, a8 as DialogType, au as DialogFactory, b8 as TimerTaskManagerFactory } from "./yes-core-bce045b8.js";
import { H as h, I as Hammerjs, K as snabbdomJsx, D as Decimal } from "./vendor-e1ca6068.js";
import { M as MainMenu$1, a as MLogin$1, b as MloginProvider, c as MainMenuProvider } from "./yes-core-m-9a5f0fc3.js";
class YesMBatchImageUploader extends YesVBatchImageUploader {
  install() {
    super.install();
    var self2 = this;
    if (InterActiveFactory.Interactive.canInteractive()) {
      this.$_img.$removeListener("click");
      this.$_img.$addListener("click", function(e) {
        var len = self2.el.$findByClassName("batchImag-wrap").length;
        if (self2.enable && len < self2.maxCount) {
          self2.showActionSheet(len);
        }
        e.stopPropagation();
      });
    }
  }
  showActionSheet(selectedNum) {
    var optItemMask = document.createElement("div");
    optItemMask.classList.add("optitem_mask");
    document.body.appendChild(optItemMask);
    var optItemView = document.createElement("div");
    optItemView.classList.add("optitem_view");
    optItemMask.appendChild(optItemView);
    var photograph = document.createElement("div");
    photograph.classList.add("img_photograph");
    photograph.innerText = I18N.getString("IMAGE_PHOTOGRAPH", "拍照");
    optItemView.appendChild(photograph);
    var photoAblum = document.createElement("div");
    photoAblum.classList.add("img_photoAlbum");
    photoAblum.innerText = I18N.getString("IMAGE_PHOTOABLUM", "从相册选择");
    optItemView.appendChild(photoAblum);
    var cancel = document.createElement("div");
    cancel.classList.add("img_cancel");
    cancel.innerText = I18N.getString("DICT_CANCEL", "取消");
    optItemView.appendChild(cancel);
    var self2 = this;
    optItemMask.addEventListener("click", function(e) {
      e.stopPropagation();
      optItemMask.parentNode.removeChild(optItemMask);
    });
    photograph.addEventListener("click", async function(e) {
      e.stopPropagation();
      await self2.owner.takePhotoBymobile();
      optItemMask.parentNode.removeChild(optItemMask);
    });
    photoAblum.addEventListener("click", async function(e) {
      e.stopPropagation();
      await self2.owner.selectPhotoBymobile(selectedNum);
      optItemMask.parentNode.removeChild(optItemMask);
    });
    cancel.addEventListener("click", function(e) {
      e.stopPropagation();
      optItemMask.parentNode.removeChild(optItemMask);
    });
  }
}
class YesMBatchImageUploaderBuilder extends YesComponentBuilder {
  static create(options) {
    return new YesMBatchImageUploader(options);
  }
}
class YesBaseInnerLabel extends YesVBaseComponent {
  constructor(options) {
    super(options);
  }
  beforeRender(ct) {
    super.beforeRender(ct);
    this.initCompStyle(this.owner.meta);
  }
  afterRender() {
    super.afterRender();
    this.showCompStyle();
  }
  initCompStyle(meta) {
    switch (meta.type) {
      case ControlType.TEXTEDITOR:
      case ControlType.TEXTAREA:
      case ControlType.TEXTBUTTON:
      case ControlType.NUMBEREDITOR:
      case ControlType.PASSWORDEDITOR:
      case ControlType.COMBOBOX:
      case ControlType.CHECKLISTBOX:
      case ControlType.DICT:
      case ControlType.DYNAMICDICT:
      case ControlType.COMPDICT:
      case ControlType.DATEPICKER:
      case ControlType.DATERANGEPICKER:
      case ControlType.UTCDATEPICKER:
      case ControlType.TIMEZONEDATEPICKER:
      case ControlType.MONTHPICKER:
      case ControlType.TIMEPICKER:
      case ControlType.IMAGE:
        var compStyle = meta.compStyle || CompSetting.CompStyle;
        if (compStyle && !meta.buddyKey) {
          this.cssClass += " " + compStyle;
        }
    }
  }
  showCompStyle() {
    var meta = this.owner.meta;
    if (!meta.compStyle)
      return;
  }
}
class YesMCheckListBox extends YesBaseInnerLabel {
  constructor(options) {
    super(options);
    this.itemIcons = new HashMap();
  }
  createHtml() {
    this.el.$addClass("ui-control").$addClass("mui-cmb ui-cmb");
    this.$label = YElement.buildFromVNode(h("span.mui-cmb-btn")).$appendTo(this.el);
    this.$icon = YElement.buildFromVNode(h("span.mui-cmb-i")).$appendTo(this.el);
  }
  initCss(options) {
    super.initCss(options);
    var format = this.owner.style && this.owner.style.format;
    if (format) {
      this.setAlignCssName(format);
    }
  }
  setLabelCss(lblCss) {
    this.el.$appendStyles(lblCss);
  }
  async checkItems() {
    var fn = this.owner.checkItems;
    if (typeof fn === "function") {
      return fn.apply(this.owner, arguments);
    }
  }
  reset() {
  }
  //TODO
  getEditor() {
    return this.$label;
  }
  setEnable(enable) {
    super.setEnable(enable);
    if (!enable) {
      if (this.$label.hasClass("ptext")) {
        this.$label.$setInnerText("");
      }
    } else {
      if (!this.owner.value && this.owner.promptText) {
        this.$label.$addClass("ptext");
        if (!this.el.hasClass("ui-readonly")) {
          this.$label.$setInnerText(this.owner.promptText);
        }
      }
    }
  }
  setShowText(caption) {
    if (caption == "" || caption == null || !caption) {
      if (this.owner.promptText) {
        this.$label.$addClass("ptext");
        if (!this.el.hasClass("ui-readonly")) {
          this.$label.$setInnerText(this.owner.promptText);
        }
      } else {
        this.$label.$setInnerText("");
      }
    } else {
      this.$label.$removeClass("ptext");
      this.$label.$setInnerText(caption);
    }
  }
  setValue(value) {
    super.setValue(value);
  }
  getShowText() {
    return this.$label.getInnerText();
  }
  getInput() {
    return this.$label;
  }
  hideClearBtn() {
  }
  setIsEmpty(caption) {
  }
  getIntCaption(items, caption) {
    if (!items) {
      return "";
    }
    if (this.integerValue && this.value == "0") {
      this.isZero = false;
      var self2 = this;
      for (var i = 0, item; item = items[i]; i++) {
        if (item.value == "0") {
          self2.isZero = true;
        }
      }
      if (!self2.isZero) {
        caption = "";
      }
    }
    return caption;
  }
  clearbtnFn() {
    this.commitValue("");
    const childs = this.cbbviewbody.getChildElms();
    childs.forEach(($childel) => $childel.$removeClass("select"));
    this.doHide();
  }
  surebtnfn() {
    const childs = this.cbbviewbody.getChildElms();
    let _childs = childs.filter(($childel) => $childel.hasClass("select"));
    var value = _childs.map((_el) => {
      return _el.getAttr("value");
    }).join(",");
    this.commitValue(value);
    this.doHide();
  }
  renderItems() {
    var data = this.data, self2 = this;
    this.cbbview = YElement.buildFromVNode(h("div.cbbview.cbllview"));
    if (this.owner.editType != 2 && this.owner.sideCaption) {
      this.cbbnav = YElement.buildFromVNode(h("div.cbb-nav")).$appendTo(this.cbbview);
      this.cbbnav.$setInnerText(this.owner.sideCaption);
    }
    this.cbbviewHeader = YElement.buildFromVNode(h("div.cbb-header")).$appendTo(this.cbbview);
    this.cbbviewbody = YElement.buildFromVNode(h("div.cbb-body")).$appendTo(this.cbbview);
    this.cbbviewfoot = YElement.buildFromVNode(h("div.cbb-foot")).$appendTo(this.cbbview);
    let clearbtn = YElement.buildFromVNode(h("button.foot-clearbtn", {})).$setInnerText(I18N.getString("DICT_EMPTY", "清空")).$appendTo(this.cbbviewfoot);
    clearbtn.$addListener("click", this.clearbtnFn.bind(this));
    let surebtn = YElement.buildFromVNode(h("button.foot-surebtn", {})).$setInnerText(I18N.getString("CURRENCY_OK", "确认")).$appendTo(this.cbbviewfoot);
    surebtn.$addListener("click", this.surebtnfn.bind(this));
    var self2 = this;
    if (!data || data.length == 0) {
      let $label = YElement.buildFromVNode(h("div.item")).$appendTo(this.cbbviewbody);
      $label.$setInnerText(I18N.getString("YESCOMBOBOX_NODATA", "无匹配数据"));
    } else {
      for (var j = 0; j < data.length; j++) {
        let item = data[j];
        let $item = YElement.buildFromVNode(h("div.item")).$appendTo(this.cbbviewbody);
        $item.$setAttr("title", item.showCaption == null ? "" : item.showCaption);
        $item.$setAttr("value", item.value);
        YElement.buildFromVNode(h("span.box")).$appendTo($item);
        let icon = YElement.buildFromVNode(h("span.icon")).$appendTo($item);
        self2.setIconValue(self2, icon, item.icon);
        let $title = YElement.buildFromVNode(h("label.title")).$appendTo($item);
        $title.$setInnerText(item.showCaption == null ? "" : item.showCaption);
        $item.$click(function() {
          let _item = YElement.buildFromVNode(this);
          if (_item.hasClass("select")) {
            _item.$removeClass("select");
          } else {
            _item.$addClass("select");
          }
        });
      }
    }
    this.rendercbbview();
  }
  async setIconValue(self2, icon, value) {
    if (!value)
      return;
    if (value.substr(0, 7) == "http://" || value.substr(0, 8) == "https://") {
      self2.setIconPath(icon, value);
    } else {
      if (self2.itemIcons.containsKey(value)) {
        var url = self2.itemIcons.get(value);
        url && self2.setIconPath(icon, url);
      } else {
        self2.owner.getImageBase64URL(value, null, null).then(function(url2) {
          url2 && self2.setIconPath(icon, url2);
          self2.itemIcons.put(value, url2);
        });
      }
    }
  }
  setIconPath(icon, path) {
    icon && icon.$addStyle("background-image", "url(" + path + ")");
    icon && icon.$addStyle("display", "inline-block");
  }
  rendercbbview() {
    var self2 = this;
    let { editType, promptText, caption } = this.owner;
    var setting = {
      el: this.cbbview,
      dir: "bottom",
      className: "cclbviewpop",
      closeCallBack: function() {
        self2.$icon.$removeClass("up");
      }
    };
    switch (editType) {
      case 1:
        setting["dir"] = "center";
        setting["size"] = "70% 292";
        break;
      case 2:
        setting["dir"] = "right";
        setting["size"] = "100% 100%";
        setting["fullScreenNavBar"] = true;
        setting["navCaption"] = promptText || "侧滑";
        break;
      case 3:
        setting["dir"] = "drop";
        setting["dom"] = this.el.getElm();
        break;
      default:
        setting["size"] = "100% 292";
        break;
    }
    this.cbbpop = new Popup(setting);
  }
  doShow() {
    var _a;
    this.cbbpop.options.ziBase = this.owner.getZIndex("control");
    (_a = this.cbbpop) == null ? void 0 : _a.show();
    this.$icon.$addClass("up");
  }
  doHide() {
    var _a;
    (_a = this.cbbpop) == null ? void 0 : _a.hide();
    this.$icon.$removeClass("up");
  }
  mdHandler(event2) {
    let self2 = this;
    if (!this.enable)
      return;
    this.checkItems().then(function(data) {
      self2.data = data;
      self2.renderItems();
      if (self2.data && self2.data.length > 0) {
        let vuls = self2.value ? self2.value.split(",") : [];
        const childs = self2.cbbviewbody.getChildElms();
        childs.forEach(($childel) => {
          vuls.forEach((v) => {
            if ($childel.getAttr("value") == v) {
              $childel.$addClass("select");
            }
          });
        });
      }
      self2.doShow();
    });
  }
  destroy() {
    super.destroy();
    this.el.$removeListener("click", this.mdHandler);
  }
  install() {
    super.install();
    var self2 = this;
    this.el.$addListener("click", self2.mdHandler.bind(this));
  }
}
class YesMCheckListBoxBuilder extends YesCheckListBoxBuilder {
  static create(options) {
    if (options.viewStyle == "Tag" || options.viewStyle == "Tiled") {
      return new YesCheckListBoxStyle(options);
    } else {
      return new YesMCheckListBox(options);
    }
  }
}
class YesMComboBox extends YesBaseInnerLabel {
  constructor(options) {
    super(options);
    this.itemIcons = new HashMap();
  }
  createHtml() {
    this.el.$addClass("ui-control").$addClass("ui-cmb mui-cmb");
    this.$label = YElement.buildFromVNode(h("span.mui-cmb-btn")).$appendTo(this.el);
    this.$icon = YElement.buildFromVNode(h("span.mui-cmb-i")).$appendTo(this.el);
    this.$dropBtn = this.el;
  }
  initCss(options) {
    super.initCss(options);
    var format = this.owner.style && this.owner.style.format;
    if (format) {
      this.setAlignCssName(format);
    }
  }
  setLabelCss(lblCss) {
    this.el.$appendStyles(lblCss);
  }
  async checkItems() {
    var fn = this.owner.checkItems;
    if (typeof fn === "function") {
      return fn.apply(this.owner, arguments);
    }
  }
  reset() {
  }
  //TODO
  getEditor() {
    return this.$label;
  }
  setEnable(enable) {
    super.setEnable(enable);
    if (!enable) {
      if (this.$label.hasClass("ptext")) {
        this.$label.$setInnerText("");
      }
    } else {
      if (!this.owner.value && this.owner.promptText) {
        this.$label.$addClass("ptext");
        if (!this.el.hasClass("ui-readonly")) {
          this.$label.$setInnerText(this.owner.promptText);
        }
      }
    }
  }
  setShowText(caption) {
    if (caption == "" || caption == null || !caption) {
      if (this.owner.promptText) {
        this.$label.$addClass("ptext");
        if (!this.el.hasClass("ui-readonly")) {
          this.$label.$setInnerText(this.owner.promptText);
        }
      } else {
        this.$label.$setInnerText("");
      }
    } else {
      this.$label.$removeClass("ptext");
      this.$label.$setInnerText(caption);
    }
  }
  setValue(value) {
    super.setValue(value);
  }
  getShowText() {
    return this.$label.getInnerText();
  }
  getInput() {
    return this.$label;
  }
  hideClearBtn() {
  }
  getIntCaption(items, caption) {
    if (!items) {
      return "";
    }
    if (this.integerValue && this.value == "0") {
      this.isZero = false;
      var self2 = this;
      for (var i = 0, item; item = items[i]; i++) {
        if (item.value == "0") {
          self2.isZero = true;
        }
      }
      if (!self2.isZero) {
        caption = "";
      }
    }
    return caption;
  }
  renderItems() {
    var data = this.data, self2 = this;
    this.cbbview = YElement.buildFromVNode(h("div.cbbview"));
    if (this.owner.editType != 2 && this.owner.sideCaption) {
      this.cbbnav = YElement.buildFromVNode(h("div.cbb-nav")).$appendTo(this.cbbview);
      this.cbbnav.$setInnerText(this.owner.sideCaption);
    }
    this.cbbviewHeader = YElement.buildFromVNode(h("div.cbb-header")).$appendTo(this.cbbview);
    this.cbbviewbody = YElement.buildFromVNode(h("div.cbb-body")).$appendTo(this.cbbview);
    if (data.length == 0) {
      let $label = YElement.buildFromVNode(h("div.item")).$appendTo(this.cbbviewbody);
      $label.$setInnerText(I18N.getString("YESCOMBOBOX_NODATA", "无匹配数据"));
    } else {
      for (var j = 0; j < data.length; j++) {
        let item = data[j];
        let $item = YElement.buildFromVNode(h("div.item")).$appendTo(this.cbbviewbody);
        $item.$setAttr("title", item.showCaption == null ? "" : item.showCaption);
        $item.$setAttr("value", item.value);
        let icon = YElement.buildFromVNode(h("span.icon")).$appendTo($item);
        YElement.buildFromVNode(h("span", item.showCaption == null ? "" : item.showCaption)).$appendTo($item);
        self2.setIconValue(self2, icon, item.icon);
        $item.$click(function(e) {
          self2.doHide();
          let _item = YElement.buildFromVNode(this);
          var value = _item.getAttr("value");
          if (_item.hasClass("select")) {
            self2.commitValue("");
            _item.$removeClass("select");
          } else {
            if (self2.selectType == 2) {
              _item.$addClass("selected");
            } else {
              const childs = self2.cbbviewbody.getChildElms();
              childs.forEach(($childel) => {
                if ($childel.getAttr("value") == value) {
                  $childel.$addClass("select");
                } else {
                  $childel.$removeClass("select");
                }
              });
            }
            self2.commitValue(value);
          }
          e.stopPropagation();
        });
      }
    }
    this.rendercbbview();
  }
  async setIconValue(self2, icon, value) {
    if (!value)
      return;
    if (value.substr(0, 7) == "http://" || value.substr(0, 8) == "https://") {
      self2.setIconPath(icon, value);
    } else {
      if (self2.itemIcons.containsKey(value)) {
        var url = self2.itemIcons.get(value);
        url && self2.setIconPath(icon, url);
      } else {
        self2.owner.getImageBase64URL(value, null, null).then(function(url2) {
          url2 && self2.setIconPath(icon, url2);
          self2.itemIcons.put(value, url2);
        });
      }
    }
  }
  setIconPath(icon, path) {
    if (icon) {
      icon.$addStyle("background-image", "url(" + path + ")");
      icon.$addStyle("display", "inline-block");
    }
  }
  closeCallBack() {
    this.$icon.$removeClass("up");
  }
  rendercbbview() {
    let { editType, promptText, caption } = this.owner;
    var setting = {
      el: this.cbbview,
      dir: "bottom",
      className: "cbbviewpop",
      closeCallBack: this.closeCallBack.bind(this)
    };
    switch (editType) {
      case 1:
        setting["dir"] = "center";
        setting["size"] = "70% 252";
        break;
      case 2:
        setting["dir"] = "right";
        setting["size"] = "100% 100%";
        setting["fullScreenNavBar"] = true;
        setting["navCaption"] = promptText || "侧滑";
        break;
      case 3:
        setting["dir"] = "drop";
        setting["dom"] = this.el.getElm();
        break;
      default:
        setting["size"] = "100% 252";
        break;
    }
    this.cbbpop = new Popup(setting);
  }
  doShow() {
    var _a;
    this.cbbpop.options.ziBase = this.owner.getZIndex("control");
    (_a = this.cbbpop) == null ? void 0 : _a.show();
    this.$icon.$addClass("up");
  }
  doHide() {
    var _a;
    this.cbbview.$remove();
    (_a = this.cbbpop) == null ? void 0 : _a.hide();
    this.$icon.$removeClass("up");
  }
  mdHandler(event2) {
    let self2 = this;
    if (!this.enable)
      return;
    this.checkItems().then(function(data) {
      self2.data = data;
      self2.renderItems();
      if (self2.data.length > 0) {
        const childs = self2.cbbviewbody.getChildElms();
        childs.forEach(($childel) => {
          if ($childel.getAttr("value") == self2.value) {
            $childel.$addClass("select");
          }
        });
      }
      self2.doShow();
    });
  }
  destroy() {
    super.destroy();
    this.el.$removeListener("click", this.mdHandler);
  }
  install() {
    super.install();
    var self2 = this;
    this.el.$addListener("click", self2.mdHandler.bind(this));
  }
}
class YesMComboBoxBuilder extends YesComboBoxBuilder {
  static create(options) {
    if (options.viewStyle == "Tag" || options.viewStyle == "Tiled") {
      return new YesComboBoxStyle(options);
    } else {
      return new YesMComboBox(options);
    }
  }
}
const getImageInfo = function(url, callback) {
  var img = new Image();
  img.src = url;
  if (img.complete) {
    callback(img.width, img.height);
  } else {
    img.onload = function() {
      callback(img.width, img.height);
    };
  }
};
const doCount = function(imgWidth, imgHeight, _elwidth, _elheight) {
  let width, height;
  if (_elheight == 0 && _elwidth != 0) {
    height = _elwidth * imgHeight / imgWidth;
  } else if (_elwidth == 0 && _elheight != 0) {
    width = _elheight * imgWidth / imgHeight;
  }
  return { elwidth: width, elheight: height };
};
class YesMImage extends YesVImage {
  afterRender() {
    super.afterRender();
    this.owner.maskImage && this.setMaskImage(this.owner.maskImage);
    this.owner.promptImage && this.setPromptImage();
  }
  setIconStyle() {
    super.setIconStyle();
    if (this.owner.imageScaleType == -1) {
      this.$_img.$addStyle("backgroundSize", "100% 100%");
    }
  }
  setImagePath(path) {
    if (!this.el) {
      return;
    }
    try {
      if (path) {
        this.$wrapper.$hide();
        this.$mask.$show();
        this.el.$addClass("item");
        getImageInfo(path, (imgWidth, imgHeight) => {
          this.el.addPostpatchHook(() => {
            if (this.el.getElm()) {
              let { width, height } = this.el.getElm().getBoundingClientRect();
              let { elwidth, elheight } = doCount(imgWidth, imgHeight, width, height);
              this.$_img.$setWidth(elwidth);
              this.$_img.$setHeight(elheight);
              this.$_img.$addStyle("background-image", "url(" + path + ")");
            }
          });
        });
      } else {
        this.$wrapper.$show();
        this.$mask.$hide();
        this.el.$removeClass("item");
      }
    } catch (e) {
      console.error(e);
    }
  }
  setPromptImage() {
    if (this.owner.promptImage) {
      var self2 = this;
      this.owner.getImageBase64URL(this.owner.promptImage).then(function(url) {
        self2.$wrapper.$addClass("propmtImage");
        self2.$wrapper.$addStyle("background-image", "url(" + url + ")");
        self2.$wrapper.$show();
      });
    }
  }
  // 处理maskImage剪切图。
  setMaskImage(maskImage) {
    if (maskImage) {
      var self2 = this;
      this.owner.getImageBase64URL(maskImage).then(function(url) {
        self2.$_img.$addClass("img_mask");
        self2.$_img.$addStyle("-webkit-mask-image", "url(" + url + ")");
      });
    }
  }
  //查看原图
  showOriginImage() {
    var value = this.value;
    var self2 = this;
    this.originImageShow = document.createElement("div");
    this.originImageShow.classList.add("show_item");
    this.originImageShow.style.zIndex = this.owner.getZIndex("control");
    document.body.appendChild(this.originImageShow);
    this.originImage = document.createElement("img");
    this.originImage.classList.add("show_img");
    this.originImageShow.appendChild(this.originImage);
    self2.originImageShow.fireClose = () => {
      self2.destroy();
    };
    var reg = /^data:image\/(jpeg|png|gif);base64,/;
    if (reg.test(value)) {
      this.originImage.setAttribute("src", value);
    } else {
      this.owner.getImageBase64URL(value, false).then(function(url) {
        self2.originImage.setAttribute("src", url);
        FallBackUtil.addFallBack(self2.originImageShow);
      }).catch(function() {
        FallBackUtil.removeFallBack();
        self2.originImageShow.parentNode.removeChild(self2.originImageShow);
      });
    }
    var hammerjs = new Hammerjs(this.originImageShow);
    var beginX = 0, beginY = 0;
    var scale = 1, rotation = void 0;
    hammerjs.get("pinch").set({ enable: true });
    hammerjs.get("pan").set({ enable: true });
    hammerjs.get("tap").set({ enable: true });
    hammerjs.on("tap", function() {
      FallBackUtil.removeFallBack();
      self2.originImage.parentNode.removeChild(self2.originImage);
      self2.originImage = null;
      self2.originImageShow.parentNode.removeChild(self2.originImageShow);
      self2.originImageShow = null;
    });
    hammerjs.on("pinch", function(event2) {
      var oldScale = 1, oldRotation = 0;
      if (!rotation)
        rotation = event2.rotation;
      var transformStr = self2.originImage.style.transform;
      if (transformStr) {
        oldScale = parseFloat(transformStr.split("scale(")[1].split(")")[0]);
        oldRotation = parseFloat(transformStr.split("rotate(")[1].split("deg)")[0]);
      }
      self2.originImage.style.transform = "scale(" + (oldScale + (event2.scale - scale)) + ") rotate(" + (oldRotation + (event2.rotation - rotation)) + "deg)";
      scale = event2.eventType == 4 ? 1 : event2.scale;
      rotation = event2.eventType == 4 ? 0 : event2.rotation;
    });
    hammerjs.on("pan", function(event2) {
      var left = parseInt(self2.originImage.style.left) || 0;
      var top = parseInt(self2.originImage.style.top) || 0;
      self2.originImage.style.left = left + (event2.deltaX - beginX) + "px";
      self2.originImage.style.top = top + (event2.deltaY - beginY) + "px";
      beginX = event2.isFinal ? 0 : event2.deltaX;
      beginY = event2.isFinal ? 0 : event2.deltaY;
    });
  }
  destroy() {
    if (this.originImageShow) {
      FallBackUtil.removeFallBack();
      this.originImage.parentNode.removeChild(this.originImage);
      this.originImage = null;
      this.originImageShow.parentNode.removeChild(this.originImageShow);
      this.originImageShow = null;
    }
  }
  install() {
    super.install();
    var self2 = this;
    var switchOptMask = function(show) {
      if (show) {
        self2.$mask.$findByClassName("bar")[0].$show();
        self2.show.$show();
        var clearShow = self2.owner.sourceType == ImageSourceType.DATA && self2.enable;
        clearShow ? self2.clear.$show() : self2.clear.$hide();
        self2.$wrapper.$addStyle("pointer-events", "none");
      } else {
        self2.$mask.$findByClassName("bar")[0].$hide();
        self2.show.$hide();
        self2.clear.$hide();
        self2.isDbLClick = false;
        setTimeout(() => {
          self2.$wrapper.$addStyle("pointer-events", "");
        }, 100);
      }
      clearTimeout(self2.timeOutEvent);
    };
    this.el.$addListener("mouseover", function(e) {
      !self2.isDbLClick && switchOptMask(false);
    }).$addListener("mouseout", function(e) {
      !self2.isDbLClick && switchOptMask(false);
    }).$addListener("touchstart", function() {
      self2.isDbLClick = false;
      clearTimeout(self2.timeOutEvent);
      self2.timeOutEvent = setTimeout(() => {
        self2.isDbLClick = true;
        switchOptMask(true);
      }, 500);
    }).$addListener("touchmove", function(e) {
      switchOptMask(false);
    }).$addListener("touchend", function(e) {
      if (e.target == self2.clear.getElm()) {
        self2.clear.getElm().click();
      } else if (e.target == self2.show.getElm()) {
        self2.show.getElm().click();
      }
      !self2.isDbLClick && switchOptMask(false);
    });
    this.el.$removeListener("click");
    if (InterActiveFactory.Interactive.canInteractive()) {
      this.$wrapper.$removeListener("click");
      this.$wrapper.$addListener("click", function(e) {
        if (InterActiveFactory.Interactive.canInteractive()) {
          if (!self2.enable)
            return;
          self2.showActionSheet();
        }
      });
    } else {
      this.$wrapper.$addListener("click", function(e) {
        if (!self2.enable)
          return;
        self2.changeDef();
      });
    }
    this.$_img.$addListener("click", debounce(async function(e) {
      if (!self2.enable)
        return;
      if (self2.getValue()) {
        await self2.doOnClick(e, null);
      }
    }));
    this.show.$removeListener("click");
    this.show.$addListener("click", function(e) {
      self2.showOriginImage();
    });
  }
  showActionSheet() {
    var optItemMask = document.createElement("div");
    optItemMask.classList.add("optitem_mask");
    document.body.appendChild(optItemMask);
    var optItemView = document.createElement("div");
    optItemView.classList.add("optitem_view");
    optItemMask.appendChild(optItemView);
    var photograph = document.createElement("div");
    photograph.classList.add("img_photograph");
    photograph.innerText = I18N.getString("IMAGE_PHOTOGRAPH", "拍照");
    optItemView.appendChild(photograph);
    var photoAblum = document.createElement("div");
    photoAblum.classList.add("img_photoAlbum");
    photoAblum.innerText = I18N.getString("IMAGE_PHOTOABLUM", "从相册选择");
    optItemView.appendChild(photoAblum);
    var cancel = document.createElement("div");
    cancel.classList.add("img_cancel");
    cancel.innerText = I18N.getString("DICT_CANCEL", "取消");
    optItemView.appendChild(cancel);
    var self2 = this;
    optItemMask.addEventListener("click", function(e) {
      e.stopPropagation();
      optItemMask.parentNode.removeChild(optItemMask);
    });
    photograph.addEventListener("click", async function(e) {
      e.stopPropagation();
      await self2.owner.takePhotoBymobile();
      optItemMask.parentNode.removeChild(optItemMask);
    });
    photoAblum.addEventListener("click", async function(e) {
      e.stopPropagation();
      await self2.owner.selectPhotoBymobile();
      optItemMask.parentNode.removeChild(optItemMask);
    });
    cancel.addEventListener("click", function(e) {
      e.stopPropagation();
      optItemMask.parentNode.removeChild(optItemMask);
    });
  }
}
class YesMImageBuilder extends YesImageBuilder {
  static create(options) {
    return new YesMImage(options);
  }
}
class YesMVideoPlayer extends YesVVideoPlayer {
  install() {
    super.install();
    if (InterActiveFactory.Interactive.canInteractive()) {
      this.div_video.$removeListener("click");
      this.div_video.$addListener("click", () => {
        if (this.enable) {
          this.showActionSheet();
        }
      });
    }
  }
  showActionSheet() {
    var optItemMask = document.createElement("div");
    optItemMask.classList.add("optitem_mask");
    document.body.appendChild(optItemMask);
    var optItemView = document.createElement("div");
    optItemView.classList.add("optitem_view");
    optItemMask.appendChild(optItemView);
    var takeVideo = document.createElement("div");
    takeVideo.classList.add("video_takevideo");
    takeVideo.innerText = I18N.getString("VIDEO_TAKEVIDEO", "拍摄视频");
    optItemView.appendChild(takeVideo);
    var selectVideo = document.createElement("div");
    selectVideo.classList.add("video_selectvideo");
    selectVideo.innerText = I18N.getString("VIDEO_SELECTVIDEO", "选择视频");
    optItemView.appendChild(selectVideo);
    var cancel = document.createElement("div");
    cancel.classList.add("video_cancel");
    cancel.innerText = I18N.getString("DICT_CANCEL", "取消");
    optItemView.appendChild(cancel);
    var self2 = this;
    optItemMask.addEventListener("click", function(e) {
      e.stopPropagation();
      optItemMask.parentNode.removeChild(optItemMask);
    });
    takeVideo.addEventListener("click", async function(e) {
      e.stopPropagation();
      await self2.owner.doTakeVideo();
      optItemMask.parentNode.removeChild(optItemMask);
    });
    selectVideo.addEventListener("click", async function(e) {
      e.stopPropagation();
      await self2.owner.doSelectVideo();
      optItemMask.parentNode.removeChild(optItemMask);
    });
    cancel.addEventListener("click", function(e) {
      e.stopPropagation();
      optItemMask.parentNode.removeChild(optItemMask);
    });
  }
}
class YesMVideoPlayerBuilder extends YesVideoPlayerBuilder {
  static create(options) {
    return new YesMVideoPlayer(options);
  }
}
var __defProp$3 = Object.defineProperty;
var __getOwnPropDesc$3 = Object.getOwnPropertyDescriptor;
var __decorateClass$3 = (decorators, target, key, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$3(target, key) : target;
  for (var i = decorators.length - 1, decorator; i >= 0; i--)
    if (decorator = decorators[i])
      result = (kind ? decorator(target, key, result) : decorator(result)) || result;
  if (kind && result)
    __defProp$3(target, key, result);
  return result;
};
class YesVTextEditor extends YesVBaseText {
  constructor(options) {
    super(options);
    this.maxLength = options.maxLength;
    this.caseType = options.caseType;
    this.trim = options.trim;
    this.icon = options.icon;
    this.preIcon = options.preIcon;
    this.embedText = options.embedText;
    this.selectOnFocus = options.selectOnFocus;
    this.invalidChars = options.invalidChars;
    this.keyEnter = options.keyEnter;
    this.holdFocus = options.holdFocus;
    this.prefix = options.prefix;
    this.suffix = options.suffix;
  }
  createHtml() {
    this.el.$addClass("ui-control").$addClass("ui-txted");
    this.$wrap = YElement.buildFromVNode(h("div.txted-wrap")).$appendTo(this.el);
    this.$input = YElement.buildFromVNode(/* @__PURE__ */ snabbdomJsx.html("input", { type: "text" })).$appendTo(this.$wrap);
    this.$clearBtn = YElement.buildFromVNode(h("span.clear")).$appendTo(this.el);
    if (this.prefix || this.suffix) {
      this.el.$addClass("char");
      this.$container = YElement.buildFromVNode(h("div.container")).$appendTo(this.el);
      this.$wrap.$appendTo(this.$container);
      this.$clearBtn.$appendTo(this.$container);
      this.$clearBtn.$hide();
      if (this.prefix) {
        this.$prefix = YElement.buildFromVNode(h("div.prefix"));
        this.$prefix.$setInnerText(this.prefix);
        this.$prefix.$insertBefore(this.$container);
      }
      if (this.suffix) {
        this.$suffix = YElement.buildFromVNode(h("div.suffix"));
        this.$suffix.$setInnerText(this.suffix);
        this.$suffix.$appendTo(this.el);
      }
    } else {
      this.$wrap.$appendTo(this.el);
      this.$clearBtn.$appendTo(this.el);
      this.$clearBtn.$hide();
    }
    if (parseInt(this.maxLength) > 0) {
      this.$input.$setAttr("maxlength", this.maxLength);
    }
    var textCase = this.caseType;
    if (textCase != CaseType.NONE) {
      if (textCase == CaseType.UPPER) {
        this.$input.$addClass("uppercase");
      } else {
        this.$input.$addClass("lowercase");
      }
    }
    if (this.owner.showWordLimit) {
      var limit = YElement.buildFromVNode(h("span")).$addClass("txt-showlen");
      limit.$appendTo(this.el);
      this.$showLen = YElement.buildFromVNode(h("span")).$setInnerText("0");
      this.$showLen.$appendTo(limit);
      var span = YElement.buildFromVNode(h("span")).$setInnerText("/" + this.owner.maxLength);
      span.$appendTo(limit);
      this.el.$addClass("maxlen");
    }
    this.$required_error_Icon = YElement.buildFromVNode(h("span")).$addClass("reicon").$appendTo(this.el);
  }
  initCss(options) {
    if (!options || !this.el) {
      return;
    }
    var outerCss = this.getOuterCss(options, false);
    var inputCss = this.getInputCss(options);
    var lblCss = this.getLabelCss(options);
    var inputLblCss = this.getInputLbl(options);
    this.el.$appendStyles(outerCss).$appendStyles(inputCss);
    this.$input.$appendStyles(lblCss).$appendStyles(inputLblCss);
    this.setFormatStyle(options);
    this.$input.$appendStyles(this.txtCss || /* @__PURE__ */ new Map());
  }
  afterRender() {
    super.afterRender();
    this.icon && this.setIcon(this.icon);
    this.preIcon && this.setPreIcon(this.preIcon);
    this.promptText && this.setPromptText(this.promptText);
    this.embedText && this.setEmbedText(this.embedText);
  }
  getInput() {
    return this.$input;
  }
  focus() {
    this.$input.$focus();
  }
  setShowWordLimit() {
    var inputEle = this.$input.getElm();
    if (!inputEle)
      return;
    var value = inputEle == null ? void 0 : inputEle.value;
    var len = value.length > this.owner.maxLength ? this.owner.maxLength : value.length;
    this.$showLen && this.$showLen.$setInnerText(len);
    this.$showLen && this.$showLen.addPostpatchHook(() => {
      this.reCalcClearLocation();
    });
    if (len > 0 && this.el.hasClass("focus")) {
      this.$input.$setInputValue(value);
      this.$clearBtn.getElm().style.display = "";
      this.$clearBtn.getElm().style.visibility = "visible";
    }
  }
  setShowText(value) {
    this.$input.$setInputValue(value);
    this.setIsEmpty(value);
    this.$input.addPostpatchHook(() => {
      this.setShowWordLimit();
    });
  }
  getShowText() {
    var elm = this.$input.getElm();
    return elm ? elm.value : "";
  }
  //TODO icon 不需要 缓存， 模型该处理this.icon， 多次seticon 有问题
  setIcon(icon) {
    if (icon) {
      if (!this.$icon) {
        this.$icon = YElement.buildFromVNode(h("span.icon")).$appendTo(this.el);
        this.el.$addClass("icon");
      }
      var self2 = this;
      this.getImageBase64URL(icon, null, null).then(function(url) {
        self2.$icon.$addStyle("background-image", "url(" + url + ")");
      });
    } else {
      this.$icon && this.$icon.$addStyle("background-image", "none");
    }
  }
  //TODO 同icon
  setPreIcon(preIcon) {
    if (preIcon) {
      if (!this.$preIcon) {
        this.$preIcon = YElement.buildFromVNode(h("span.pre-icon")).$prependTo(this.el);
        this.el.$addClass("preicon");
      }
      var self2 = this;
      this.getImageBase64URL(preIcon, null, null).then(function(url) {
        self2.$preIcon.$addStyle("background-image", "url(" + url + ")");
      });
    } else {
      this.$preIcon && this.$preIcon.$addStyle("background-image", "none");
    }
  }
  setBackColor(backColor) {
    this.$input.$appendStyles(new Map(Object.entries({
      "background-image": "none",
      "background-color": backColor
    })));
    this.el.$appendStyles(new Map(Object.entries({
      "background-image": "none",
      "background-color": backColor
    })));
  }
  setForeColor(foreColor) {
    this.$input.$addStyle("color", foreColor);
  }
  refreshREIcon() {
    if (this.$required_error_Icon.getChildElms().length == 0) {
      this.$required_error_Icon.$addStyle("display", "none");
    }
  }
  reCalcClearLocation() {
    if (this.$input) {
      var inputElm = this.$input.$parent().getElm();
      if (inputElm)
        this.$clearBtn.$addStyle("left", inputElm.offsetLeft + inputElm.offsetWidth - 16 + "px");
    }
  }
  setError(error, msg) {
    this.$required_error_Icon.$addStyle("display", "block");
    var self2 = this;
    self2.error = error;
    var errorDiv;
    var errorDivArr = this.el.$findByClassName("error-icon");
    if (errorDivArr.length == 0) {
      errorDiv = YElement.buildFromVNode(h("span")).$addClass("error-icon").$appendTo(this.$required_error_Icon);
    } else {
      errorDiv = errorDivArr[0];
    }
    if (error) {
      this.el.$addClass("error");
      if (this.owner.checkRuleErrorIcon) {
        this.getImageBase64URL(this.owner.checkRuleErrorIcon, null, null).then(function(url) {
          errorDiv.$addStyle("background-image", "url(" + url + ")");
        });
      } else {
        errorDiv.$remove();
      }
      if (this.$required_error_Icon.$findByClassName("required-icon").length != 0) {
        errorDiv.$remove();
      }
      errorDiv.$addStyle("title", msg);
    } else {
      if (this.owner.checkRulePassIcon) {
        this.getImageBase64URL(this.owner.checkRulePassIcon, null, null).then(function(url) {
          errorDiv.$addStyle("background-image", "url(" + url + ")");
        });
      } else {
        errorDiv.$remove();
      }
      this.el.$removeClass("error");
    }
    this.refreshREIcon();
    this.$required_error_Icon.addPostpatchHook(() => {
      this.reCalcClearLocation();
    });
  }
  setRequired(required) {
    this.$required_error_Icon.$addStyle("display", "block");
    var self2 = this;
    self2.required = required;
    var requireDiv;
    var requireDivArray = this.el.$findByClassName("required-icon");
    if (requireDivArray.length == 0) {
      requireDiv = YElement.buildFromVNode(h("span")).$addClass("required-icon").$appendTo(this.$required_error_Icon);
    } else {
      requireDiv = requireDivArray[0];
    }
    if (required) {
      this.el.$addClass("required");
      if (this.owner.requiredIcon) {
        this.getImageBase64URL(this.owner.requiredIcon, null, null).then(function(url) {
          requireDiv.$addStyle("background-image", "url(" + url + ")");
        });
      } else {
        requireDiv.$remove();
      }
    } else {
      requireDiv.$remove();
      this.el.$removeClass("required");
    }
    this.refreshREIcon();
    this.$required_error_Icon.addPostpatchHook(() => {
      this.reCalcClearLocation();
    });
  }
  setEmbedText(embedText) {
    this.$embed = YElement.buildFromVNode(h("span.embed")).$setInnerText(embedText);
    this.$embed.$insertBefore(this.$wrap);
    if (embedText) {
      this.el.$addClass("embed");
      if (this.owner.embedTextSize) {
        this.$embed.$addStyle("fontSize", this.owner.embedTextSize + "px");
      }
      if (this.owner.embedTextColor) {
        this.$embed.$addStyle("color", this.owner.embedTextColor);
      }
    }
  }
  setPromptText(promptText) {
    this.$input.$setAttr("placeholder", promptText);
  }
  doEnterPress() {
    var fn = this.owner.doEnterPress;
    if (typeof fn === "function") {
      return fn.apply(this.owner, arguments);
    }
  }
  doFocusOut() {
    var fn = this.owner.doFocusOut;
    if (typeof fn === "function") {
      return fn.apply(this.owner, arguments);
    }
  }
  doOnFocus() {
    var fn = this.owner.doOnFocus;
    if (typeof fn === "function") {
      return fn.apply(this.owner, arguments);
    }
  }
  doTextChanged() {
    var fn = this.owner.doTextChanged;
    if (typeof fn === "function") {
      return fn.apply(this.owner, arguments);
    }
  }
  getClearBtn() {
    return this.$clearBtn;
  }
  doOnInputClick(event2, item) {
    var _a;
    var self2 = this;
    var selectAll = self2.selectOnFocus;
    if (!self2.enable)
      return false;
    if (selectAll) {
      let doc = document;
      if ((_a = doc.selection) == null ? void 0 : _a.empty) {
        doc.selection.empty();
      } else if (window.getSelection) {
        var sel = window.getSelection();
        sel == null ? void 0 : sel.removeAllRanges();
      }
      const $target = event2 == null ? void 0 : event2.target;
      $target == null ? void 0 : $target.select();
      selectAll = false;
    }
    self2.focusOwner();
  }
  install() {
    super.install();
    var self2 = this;
    var input = this.$input;
    var selectAll = self2.selectOnFocus;
    var doKeyPress = function(event2) {
      var value = event2.target.value;
      var newValue = TextFormat.format(value, self2.owner);
      event2.target.value = newValue;
      self2.setShowWordLimit();
      self2.doTextChanged();
    };
    this.$clearBtn.$addListener("click", function() {
      self2.$input.getElm() && (self2.$input.getElm().value = "");
      self2.setShowWordLimit();
      self2.doTextChanged();
    });
    input.$addListener("click", function(event2) {
      self2.doOnInputClick(event2, null);
    }).$addListener("focusin", function() {
      if (self2.enable) {
        self2.el.$addClass("focus");
        self2.doOnFocus();
        if (selectAll) {
          if (self2.selectOnFocus) {
            const $target = event == null ? void 0 : event.target;
            $target == null ? void 0 : $target.select();
          }
        }
      }
      self2.reCalcClearLocation();
      self2.setShowWordLimit();
    }).$addListener("keypress", function(event2) {
    }).$addListener("keyup", function() {
    }).$addListener("keydown", async (event2) => {
      if (!self2.enable)
        return;
      let keyCode = event2.keyCode || event2.charCode;
      switch (keyCode) {
        case 13:
        case 108:
          input.$setInputValue(event2.target.value);
          try {
            await self2.commitValue(input.getInputValue());
          } catch (error) {
            throw error;
          }
          if (self2.keyEnter) {
            let result = self2.doEnterPress();
            return result;
          }
          if (self2.holdFocus) {
            input.$focus();
          } else {
            self2.requestNextFocus(keyCode);
          }
          event2.preventDefault();
          break;
        case 8:
          self2.setShowWordLimit();
          self2.doTextChanged();
          break;
        case 9:
          self2.requestNextFocus(keyCode);
          event2.preventDefault();
          break;
      }
    }).$addListener("focus", function() {
    }).$addListener("focusout", async (event2) => {
      if (!self2.enable)
        return false;
      if (self2.owner.isDestroyed || self2.processing) {
        return false;
      }
      selectAll = self2.selectOnFocus;
      input.$setInputValue(event2.target.value);
      try {
        await self2.commitValue(input.getInputValue());
      } catch (error) {
        throw error;
      }
      self2.doFocusOut();
      self2.el && self2.el.$removeClass("focus");
      self2.setShowWordLimit();
      self2.$clearBtn.getElm().style.display = "none";
    }).$addListener("paste", function() {
      self2.$input.addPostpatchHook(() => {
        var v = self2.$input.getElm().value;
        v = TextFormat.format(v, self2.options);
        self2.$input.$setInputValue(v);
      });
    }).$addListener("mouseenter", function(event2) {
      self2.reCalcClearLocation();
    }).$addListener("mouseleave", function(event2) {
      if (!self2.enable)
        return false;
      input.$setInputValue(event2.target.value);
    });
    input.$addListener("compositionend", function() {
      self2.$showLen && self2.$showLen.$setInnerText(input.getElm().value.length);
    });
    input.$addListener("input", function(e) {
      doKeyPress(e);
    });
    input.$addListener("propertychange", function(e) {
      doKeyPress(e);
    });
  }
}
__decorateClass$3([
  TraceUIOptEvent()
], YesVTextEditor.prototype, "doOnInputClick", 1);
class YesVPasswordEditor extends YesVTextEditor {
  constructor(options) {
    super(options);
    this.showSwitchIcon = options.showSwitchIcon;
    this.showPlainText = options.showPlainText;
  }
  createHtml() {
    var _a;
    super.createHtml();
    this.el.$addClass("ui-pwd");
    this.$input.$setAttr("type", "password");
    this.$input.$setAttr("value", this.getValue());
    if (this.showSwitchIcon) {
      this.$showSwitchBtn = YElement.buildFromVNode(h("span.show-switch.closed")).$appendTo(this.el);
    }
    if (this.showPlainText) {
      (_a = this.$showSwitchBtn) == null ? void 0 : _a.$toggleClass("closed");
      this.$input.$setAttr("type", "text");
    }
  }
  showSwitchClick() {
    var self2 = this;
    this.$showSwitchBtn.$click(function(e) {
      if (!self2.enable)
        return false;
      self2.$showSwitchBtn.$toggleClass("closed");
      if (self2.$showSwitchBtn.hasClass("closed")) {
        self2.$input.$setAttr("type", "password");
      } else {
        self2.$input.$setAttr("type", "text");
      }
    });
  }
  install() {
    super.install();
    if (this.showSwitchIcon) {
      this.showSwitchClick();
    }
  }
}
class YesPasswordEditorBuilder extends YesComponentBuilder {
  static create(options) {
    return new YesVPasswordEditor(options);
  }
}
class YesMSeparator extends YesVSeparator {
  constructor(options) {
    super(options);
    this.setLocation = function() {
      var location = this.owner.iconLocation, loccss = "";
      switch (location) {
        case 0:
          loccss += "column";
          break;
        case 1:
          loccss += "column-reverse";
          break;
        case 3:
          loccss += "row-reverse";
          break;
      }
      this.$centerDiv.$addStyle("flex-direction", loccss);
    };
    this.setForeColor = function(foreColor) {
      this.foreColor = foreColor;
      if (foreColor) {
        this.el.$find((item) => {
          return item.hasClass("ui-sepl");
        }).map((item) => {
          item.$addStyle("background-color", foreColor);
        });
        if (this.$centerDiv) {
          this.$centerDiv.$addStyle("color", foreColor);
        } else {
          this.$linestp.$addStyle("background-color", foreColor);
        }
      }
    };
  }
  createHtml() {
    super.createHtml();
    this.el.$setInnerText("");
    this.el.$addClass("ui-sep");
    if ((this.owner.caption || this.owner.icon) && this.owner.orientation == "Horizontal") {
      var span1 = YElement.buildFromVNode(h("span.ui-sepl"));
      var span2 = YElement.buildFromVNode(h("span.ui-sepl"));
      this.$centerDiv = YElement.buildFromVNode(h("div.sp-content"));
      this.el.$append(span1).$append(this.$centerDiv).$append(span2);
      if (this.owner.icon) {
        var img = YElement.buildFromVNode(h("span.sp-content-icon")).$appendTo(this.$centerDiv);
        this.owner.getImageBase64URL(this.owner.icon).then(function(path) {
          img.$addStyle("backgroundImage", "url(" + path + ")");
        });
      }
      if (this.owner.caption) {
        YElement.buildFromVNode(h("span.sp-content-text")).$setInnerText(this.owner.caption).$appendTo(this.$centerDiv);
      }
      if (this.owner.caption && this.owner.icon) {
        this.setLocation();
      }
    } else {
      this.$linestp = YElement.buildFromVNode(h("div.ui-steline")).$appendTo(this.el);
      if (this.owner.orientation == "Vertical") {
        this.$linestp.$addClass("ui-sep-vertical");
      } else {
        this.$linestp.$addClass("ui-sep-horizontal");
      }
    }
  }
  initCss(options) {
    super.initCss(options);
    if (!options) {
      return;
    }
    var outerCss = this.getOuterCss(options, false);
    var inputCss = this.getInputCss(options);
    var lblCss = this.getLabelCss(options);
    this.el.$appendStyles(outerCss).$appendStyles(inputCss);
    this.setFormatStyle(options);
    if (options.foreColor) {
      this.el.$find((item) => {
        return item.hasClass("ui-sepl");
      }).map((item) => {
        item.$addStyle("background-color", options.foreColor);
      });
    }
    if (this.$centerDiv) {
      this.$centerDiv.$appendStyles(lblCss);
    }
  }
}
class YesSeparatorBuilder extends YesComponentBuilder {
  static create(options) {
    return new YesMSeparator(options);
  }
}
class YesMTextArea extends YesVTextArea {
  constructor(options) {
    super(options);
    this.maxLength = options.maxLength;
    this.embedText = options.embedText;
    this.invalidChars = options.invalidChars;
    this.icon = options.icon;
    this.preIcon = options.preIcon;
    this.selectOnFocus = options.selectOnFocus;
  }
  getClearBtn() {
    return this.$clearBtn;
  }
  createHtml() {
    this.el.$addClass("ui-control").$addClass("ui-txta");
    this.$input = YElement.buildFromVNode(h("textarea")).$appendTo(this.el);
    if (this.autoSize) {
      let $pre = YElement.buildFromVNode(h("pre"));
      this.$span = YElement.buildFromVNode(h("span")).$appendTo($pre);
      YElement.buildFromVNode(h("br")).$appendTo($pre);
      $pre.$insertBefore(this.$input);
      this.el.$addClass("txta-wrap");
    }
    this.$clearBtn = YElement.buildFromVNode(h("span.clear")).$appendTo(this.el);
    this.$clearBtn.$hide();
    if (this.owner.showWordLimit) {
      var limit = YElement.buildFromVNode(h("span")).$addClass("txt-showlen");
      limit.$appendTo(this.el);
      this.$showLen = YElement.buildFromVNode(h("span")).$setInnerText("0");
      this.$showLen.$appendTo(limit);
      var span = YElement.buildFromVNode(h("span")).$setInnerText("/" + this.owner.maxLength);
      span.$appendTo(limit);
      this.el.$addClass("maxlen");
    }
    this.$required_error_Icon = YElement.buildFromVNode(h("span")).$addClass("reicon").$appendTo(this.el);
  }
  initCss(options) {
    if (!options || !this.el) {
      return;
    }
    var outerCss = this.getOuterCss(options, false);
    var inputCss = this.getInputCss(options);
    var lblCss = this.getLabelCss(options);
    var inputLblCss = this.getInputLbl(options);
    this.el.$appendStyles(outerCss).$appendStyles(inputCss);
    this.$input.$appendStyles(lblCss).$appendStyles(inputLblCss);
    this.setFormatStyle(options);
    this.$input.$appendStyles(this.txtCss || /* @__PURE__ */ new Map());
  }
  afterRender() {
    super.afterRender();
    this.setMaxLength(this.maxLength);
    this.icon && this.setIcon(this.icon);
    this.preIcon && this.setPreIcon(this.preIcon);
    this.embedText && this.setEmbedText(this.embedText);
  }
  //TODO icon 不需要 缓存， 模型该处理this.icon， 多次seticon 有问题
  setIcon(icon) {
    if (icon) {
      if (!this.$icon) {
        this.$icon = YElement.buildFromVNode(h("span.icon")).$appendTo(this.el);
        this.el.$addClass("icon");
      }
      var self2 = this;
      this.getImageBase64URL(icon, null, null).then(function(url) {
        self2.$icon.$addStyle("background-image", "url(" + url + ")");
      });
    } else {
      this.$icon && this.$icon.$addStyle("background-image", "none");
    }
  }
  //TODO 同icon
  setPreIcon(preIcon) {
    if (preIcon) {
      if (!this.$preIcon) {
        this.$preIcon = YElement.buildFromVNode(h("span.pre-icon")).$prependTo(this.el);
        this.el.$addClass("preicon");
      }
      var self2 = this;
      this.getImageBase64URL(preIcon, null, null).then(function(url) {
        self2.$preIcon.$addStyle("background-image", "url(" + url + ")");
      });
    } else {
      this.$preIcon && this.$preIcon.$addStyle("background-image", "none");
    }
  }
  getInput() {
    return this.$input;
  }
  setEnable(enable) {
    super.setEnable(enable);
  }
  focus() {
    this.$input.$focus();
  }
  setEmbedText(embedText) {
    this.$embed = YElement.buildFromVNode(h("span.embed")).$setInnerText(embedText);
    this.$embed.$insertBefore(this.$input);
    if (embedText) {
      this.el.$addClass("embed");
      if (this.owner.embedTextSize) {
        this.$embed.$addStyle("fontSize", this.owner.embedTextSize + "px");
      }
      if (this.owner.embedTextColor) {
        this.$embed.$addStyle("color", this.owner.embedTextColor);
      }
    }
  }
  getShowText() {
    return this.$input.getInputValue();
  }
  setShowWordLimit() {
    if (this.processing)
      return;
    var inputEle = this.$input.getElm();
    if (!inputEle)
      return;
    var value = inputEle.value;
    var len = value.length > this.owner.maxLength ? this.owner.maxLength : value.length;
    this.$showLen && this.$showLen.$setInnerText(len);
    if (len > 0 && this.el.hasClass("focus")) {
      this.$input.$setInputValue(value);
      this.$clearBtn.getElm().style.display = "";
    }
  }
  setShowText(value) {
    this.$input.$setInputValue(value);
    this.$span && this.$span.$setInnerText(value);
    this.setIsEmpty(value);
    this.$input.addPostpatchHook(() => {
      this.setShowWordLimit();
    });
  }
  setBackColor(backColor) {
    this.el.$appendStyles(
      new Map(
        Object.entries({
          "background-image": "none",
          "background-color": backColor
        })
      )
    );
  }
  setForeColor(foreColor) {
    this.$input.$addStyle("color", foreColor);
  }
  setHeight(height) {
    super.setHeight(height);
  }
  setWidth(width) {
    super.setWidth(width);
  }
  setTextCase(textCase) {
    var el = this.$input;
    this.caseType = textCase;
    if (textCase === CaseType.UPPER) {
      el.$addClass("uppercase");
    } else {
      el.$removeClass("uppercase");
    }
    if (textCase === CaseType.LOWER) {
      el.$addClass("lowercase");
    } else {
      el.$removeClass("lowercase");
    }
  }
  setMaxLength(maxLength) {
    if (maxLength > 0) {
      this.maxLength = maxLength;
      this.$input.$setAttr("maxlength", maxLength);
    }
  }
  setPromptText(promptText) {
    this.promptText = promptText;
    this.$input.$setAttr("placeholder", promptText);
  }
  doFocusOut() {
    var fn = this.owner.doFocusOut;
    if (typeof fn === "function") {
      return fn.apply(this.owner, arguments);
    }
  }
  doOnFocus() {
    var fn = this.owner.doOnFocus;
    if (typeof fn === "function") {
      return fn.apply(this.owner, arguments);
    }
  }
  doTextChanged() {
    this.$input.$setInputValue(this.$input.getElm().value);
    var fn = this.owner.doTextChanged;
    if (typeof fn === "function") {
      return fn.apply(this.owner, arguments);
    }
  }
  refreshREIcon() {
    var self2 = this;
    if (this.$required_error_Icon.getChildElms().length == 0) {
      this.$required_error_Icon.$addStyle("display", "none");
    } else {
      self2.$required_error_Icon.addPostpatchHook(() => {
        this.$required_error_Icon.getChildElms().forEach((item) => {
          var display = self2.$required_error_Icon.getElm().style.display;
          item.$addStyle("display", display);
        });
      });
    }
  }
  setError(error, msg) {
    this.$required_error_Icon.$addStyle("display", "block");
    var self2 = this;
    self2.error = error;
    var errorDiv;
    var errorDivArr = this.el.$findByClassName("error-icon");
    if (errorDivArr.length == 0) {
      errorDiv = YElement.buildFromVNode(h("span")).$addClass("error-icon").$appendTo(this.$required_error_Icon);
    } else {
      errorDiv = errorDivArr[0];
    }
    if (error) {
      this.el.$addClass("error");
      if (this.owner.checkRuleErrorIcon) {
        this.getImageBase64URL(this.owner.checkRuleErrorIcon, null, null).then(function(url) {
          errorDiv.$addStyle("background-image", "url(" + url + ")");
        });
      } else {
        errorDiv.$remove();
      }
      if (this.$required_error_Icon.$findByClassName("required-icon").length != 0) {
        errorDiv.$remove();
      }
      errorDiv.$addStyle("title", msg);
    } else {
      if (this.owner.checkRulePassIcon) {
        this.getImageBase64URL(this.owner.checkRulePassIcon, null, null).then(function(url) {
          errorDiv.$addStyle("background-image", "url(" + url + ")");
        });
      } else {
        errorDiv.$remove();
      }
      this.el.$removeClass("error");
    }
    this.refreshREIcon();
  }
  setRequired(required) {
    this.$required_error_Icon.$addStyle("display", "block");
    var self2 = this;
    self2.required = required;
    var requireDiv;
    var requireDivArray = this.el.$findByClassName("required-icon");
    if (requireDivArray.length == 0) {
      requireDiv = YElement.buildFromVNode(h("span")).$addClass("required-icon").$appendTo(this.$required_error_Icon);
    } else {
      requireDiv = requireDivArray[0];
    }
    if (required) {
      this.el.$addClass("required");
      if (this.owner.requiredIcon) {
        this.getImageBase64URL(this.owner.requiredIcon, null, null).then(function(url) {
          requireDiv.$addStyle("background-image", "url(" + url + ")");
        });
      } else {
        requireDiv.$remove();
      }
    } else {
      requireDiv.$remove();
      this.el.$removeClass("required");
    }
    this.refreshREIcon();
  }
  install() {
    super.install();
    var self2 = this;
    var input = this.$input;
    var doKeyPress = function(event2) {
      var value = event2.target.value;
      var newValue = TextFormat.format(value, self2.owner);
      event2.target.value = newValue;
      self2.setShowWordLimit();
      self2.doTextChanged();
    };
    this.$clearBtn.$addListener("click", function() {
      self2.$input.getElm() && (self2.$input.getElm().value = "");
      self2.setShowWordLimit();
      self2.doTextChanged();
    });
    input.$addListener("click", function(event2) {
      if (!self2.enable)
        return false;
      self2.$input.$addClass("focus");
      if (self2.needSelectAll) {
        event2.target.select();
        self2.needSelectAll = false;
      }
      self2.focusOwner();
    }).$addListener("focusin", function() {
      if (!self2.enable)
        return false;
      self2.el.$addClass("focus");
      self2.doOnFocus();
      if (self2.selectOnFocus) {
        self2.needSelectAll = self2.selectOnFocus;
      }
      self2.$clearBtn.getElm().style.display = "";
    }).$addListener("focusout", async function(event2) {
      if (self2.processing) {
        return false;
      }
      if (!self2.enable)
        return false;
      self2.$input.$removeClass("focus");
      input.$setInputValue(event2.target.value);
      await self2.commitValue(input.getInputValue());
      self2.doFocusOut();
      self2.el && self2.el.$removeClass("focus");
      self2.setShowWordLimit();
      self2.$clearBtn.getElm().style.display = "none";
    }).$addListener("keydown", function(event2) {
      if (!self2.enable)
        return;
      var keyCode = event2.keyCode || event2.charCode;
      if (keyCode == 9) {
        self2.requestNextFocus(keyCode);
        event2.preventDefault();
      } else if (keyCode == 8) {
        self2.setShowWordLimit();
        self2.doTextChanged();
      }
    }).$addListener("keypress", function(event2) {
    }).$removeListener("blur");
    if (jq.browser.isIE) {
      self2.$input.$addListener("keypress", function(event2) {
        var _a;
        if (!self2.enable)
          return;
        let tmpString = (_a = event2.target) == null ? void 0 : _a.value;
        if (tmpString.length > self2.maxLength) {
          self2.$input.$setInputValue(tmpString.substring(0, self2.maxLength));
        }
      });
    }
    input.$addListener("compositionend", function() {
      self2.$showLen && self2.$showLen.$setInnerText(input.getElm().value.length);
    });
    input.$addListener("input", function(e) {
      doKeyPress(e);
    });
    input.$addListener("propertychange", function(e) {
      doKeyPress(e);
    });
  }
}
class YesMTextAreaBuilder extends YesTextAreaBuilder {
  static create(options) {
    return new YesMTextArea(options);
  }
}
class YesTextEditorBuilder extends YesComponentBuilder {
  static create(options) {
    return new YesVTextEditor(options);
  }
}
var __defProp$2 = Object.defineProperty;
var __getOwnPropDesc$2 = Object.getOwnPropertyDescriptor;
var __decorateClass$2 = (decorators, target, key, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$2(target, key) : target;
  for (var i = decorators.length - 1, decorator; i >= 0; i--)
    if (decorator = decorators[i])
      result = (kind ? decorator(target, key, result) : decorator(result)) || result;
  if (kind && result)
    __defProp$2(target, key, result);
  return result;
};
var renderMenu = function(self2) {
  var _a;
  var ul = self2.ul;
  if (typeof ul != "undefined") {
    ul.$setAttr("id", self2.getId() + "_toolbar").$addClass("tbr-ul");
    var _li = ul.getChildElms().forEach((item2) => {
      var _a3, _b, _c;
      item2.$addClass("tbr-item");
      var _a2 = item2.$findByTagName("a");
      _a2.forEach(function(a_item) {
        a_item.$addClass("tbr-btn");
        var icon = a_item.getAttr("icon");
        if (icon) {
          var _span = YElement.buildFromVNode(h$1("img.icon")).$insertBefore(a_item.$findByClassName("txt")[0]);
          (function(newSpan, newIcon) {
            self2.getImageBase64URL(newIcon).then(function(src) {
              newSpan.$setAttr("src", src);
            });
          })(_span, icon);
        }
      });
      var _ul = (_b = (_a3 = item2.$findByTagName("ul")[0]) == null ? void 0 : _a3.$addClass("tbr-vw")) == null ? void 0 : _b.$setAttr("tabindex", "0");
      (_c = item2.$findByTagName("ul")[0]) == null ? void 0 : _c.$addStyle("zIndex", self2.owner.getZIndex("popview"));
      _ul == null ? void 0 : _ul.$findByTagName("li").forEach((li_item) => {
        li_item.$addClass("dp-item").$setAttr("tabindex", "-1");
      });
    });
  }
  var childElms = (_a = self2.ul) == null ? void 0 : _a.getChildElms();
  for (var i = 0, len = childElms == null ? void 0 : childElms.length; i < len; i++) {
    var _li = childElms[i];
    var item = self2.owner.items[_li.getAttr("index")];
    _li.$setProp("item", item);
    _li.$setAttr("key", item.key);
    if (item.cssClass) {
      _li.$addClass(item.cssClass);
    }
    if (i != len - 1) {
      YElement.buildFromVNode(h$1("span.quarantine")).$appendTo(_li);
    }
    if (item.items) {
      for (var j = 0, length = _li.$findByTagName("ul")[0].getChildElms().length; j < length; j++) {
        var child = _li.$findByTagName("ul")[0].getChildElms()[j];
        child.$setProp("item", item.items[child.getAttr("index")]);
        if (child.getProp("item").cssClass) {
          child.$addClass(child.getProp("item").cssClass);
        }
        child.$setAttr("key", item.items[child.getAttr("index")].key);
      }
    }
  }
};
var resetItems = function(_this) {
  var _a;
  (_a = _this.ul) == null ? void 0 : _a.$findByTagName("li").forEach((item) => {
    item.$removeClass("hide");
  });
  var flag = false;
  _this.el.addPostpatchHook(function(el) {
    var _a2, _b, _c, _d;
    var children = [], child;
    for (var i = 0; i < ((_a2 = _this.ul) == null ? void 0 : _a2.getChildElms().length); i++) {
      child = (_b = _this.ul) == null ? void 0 : _b.getChildElms()[i];
      if (child.isShow()) {
        children.push(child);
      }
    }
    flag = ((_c = children == null ? void 0 : children[children.length - 1]) == null ? void 0 : _c.getElm().getBoundingClientRect().top) > ((_d = children == null ? void 0 : children[0]) == null ? void 0 : _d.getElm().getBoundingClientRect().top);
    if ((children == null ? void 0 : children.length) > 0 && flag) {
      var _div = _this.dropView.$empty();
      var _ul = YElement.buildFromVNode(h$1("ul")).$appendTo(_div);
      _this.dpUl = _ul;
      _ul.$addClass("tbr-ul");
      _div.$addStyle("top", _this.el.getElm().getBoundingClientRect().top + _this.el.getElm().getBoundingClientRect().height + "px");
      for (var i = 0, len = children.length; i < len; i++) {
        child = children[i];
        if (child.getElm().getBoundingClientRect().top > children[0].getElm().getBoundingClientRect().top) {
          var newChild = child.$clone();
          child.$addClass("hide");
          newChild.$appendTo(_ul);
          var a = newChild.$findByTagName("a")[0];
          var icon = a.getAttr("icon");
          if (icon) {
            var _span = a.$findByClassName("icon")[0];
            if (!_span.getAttr("style")) {
              (function(newSpan, nIcon) {
                _this.getImageBase64URL(nIcon).then(function(src) {
                  newSpan.$setAttr("src", src);
                });
              })(_span, icon);
            }
          }
          newChild.$setProp("item", child.getProp("item"));
          var items = child.$findByClassName("dp-item");
          if (items.length > 0) {
            for (var j = 0, length = items.length; j < length; j++) {
              var dpItem = newChild.$findByClassName("dp-item")[j];
              dpItem.$setProp("item", child.getProp("item").items[j]);
              var dp_a = dpItem.$findByTagName("a")[0];
              var dp_icon = dp_a.getAttr("icon");
              if (dp_icon) {
                var _dp_span = dp_a.$findByClassName("icon")[0];
                if (!_dp_span.getAttr("style")) {
                  (function(newSpan, nIcon) {
                    _this.getImageBase64URL(nIcon).then(function(src) {
                      newSpan.$addStyle("background-image", "url(" + src + ")");
                    });
                  })(_dp_span, dp_icon);
                }
              }
            }
          }
        }
      }
      children.forEach((elm) => {
        if (elm.hasClass("hide")) {
          _this._dropBtn.$addClass("show");
          return;
        }
      });
      _this.dropView.addPostpatchHook(() => {
        if (!_this.dropResized) {
          _this.resizeDropView();
        }
        _this.dropResized = false;
      });
    } else {
      _this._dropBtn.$removeClass("show");
      _this._dropBtn.$setInnerText("");
      _this.dropView && _this.dropView.getChildElms().forEach((item) => item.$remove());
    }
  });
};
var viewItemClick = async function(event2, self2, li) {
  var _this = event2.target;
  window["uploadType"] = _this.getAttribute("multiple");
  if (li.classList.contains("ui-readonly"))
    return;
  if (_this.classList.contains("dpd-btn")) {
    _this.classList.toggle("show");
  } else if (li.classList.contains("sp-btn") && (event2.target.classList.contains("btn-right") || event2.target.classList.contains("arrow"))) {
    self2.dropView.$findByClassName("show")[0].$removeClass("show");
    _this.classList.toggle("show");
    PositionUtil.setViewPos(event2.target, self2.dropView.getElm(), false);
  } else {
    li.parentElement.parentElement.classList.remove("show");
    self2.dropView.$removeClass("show");
    self2._dropBtn.$removeClass("select");
    var item = li.item;
    await self2.doOnClick(event2, item);
    event2.stopPropagation();
  }
};
class YesVToolbar extends YesVBaseButton {
  constructor(options) {
    super(options);
    this.dropResized = false;
    this.install = function() {
      var self2 = this;
      this._dropBtn.$click(function(event2) {
        var _this = self2.dropView;
        _this.$addStyle("right", window.innerWidth - self2.el.getElm().getBoundingClientRect().left - self2.el.getElm().offsetWidth + "px");
        _this.$addStyle("top", self2.el.getElm().getBoundingClientRect().top + self2.el.offsetHeight + "px");
        _this.$empty();
        resetItems(self2);
        _this.$toggleClass("show");
        self2._dropBtn.$addClass("select");
        _this.$addStyle("zIndex", self2.owner.getZIndex("control"));
        var mdhandler = function(e) {
          var target = e.target;
          if (closestEles(target, self2.dpUl).length == 0 && closestEles(target, _this.getElm()).length == 0 && closestEles(target, self2._dropBtn.getElm()).length == 0 && !self2.clickel) {
            let isShow = _this.hasClass("show");
            _this && _this.$removeClass("show");
            document.removeEventListener("touchstart", mdhandler);
            if (isShow)
              self2.doOnDocumentClick();
          }
          if (self2.el.$findByClassName("select").length > 0) {
            self2.el.$findByClassName("select")[0].$removeClass("select");
          }
        };
        document.addEventListener("touchstart", mdhandler);
        self2.resizeDropView();
        self2.dropResized = true;
      });
      this.resizeHandler = this.resizeFun.bind(self2);
      window.addEventListener("resize", this.resizeHandler);
    };
    this.getId = () => {
      return options.getId();
    };
  }
  getId() {
  }
  renderItems(self2, parent, items) {
    var _renderItems = function(parent2, items2) {
      var ul = parent2.$findByTagName("ul")[0];
      if (!ul) {
        ul = YElement.buildFromVNode(h$1("ul")).$appendTo(parent2);
      }
      var li, a;
      for (var i = 0, item; item = items2[i]; i++) {
        li = YElement.buildFromVNode(h$1("li")).$appendTo(ul);
        li.$click(debounce(async function(e) {
          self2.clickevent = true;
          if (this.elm.classList.contains("tbr-item")) {
            if (this.elm !== e.target.closest("li"))
              return;
            await self2.itemClick(e, self2, this.elm);
            window["uploadType"] = this.elm.getAttribute("multiple");
          } else {
            await viewItemClick(e, self2, this.elm);
          }
        }));
        li.$addStyle("display", item.visible ? "block" : "none");
        if (!item.enable) {
          li.$addStyle("display", "none");
        }
        li.key = item.key;
        li.$setAttr("index", i);
        a = YElement.buildFromVNode(h$1("a")).$appendTo(li);
        if (item.icon) {
          a.$setAttr("icon", item.icon);
          a.$addClass("pre-icon");
        }
        YElement.buildFromVNode(h$1("span.txt")).$setInnerText(item.caption).$appendTo(a);
        var needUpload = item.uploadFile;
        if (!needUpload) {
          needUpload = li.key && li.key.toLowerCase().indexOf("upload") != -1;
          if (!needUpload && item.action) {
            needUpload = FileUtil.needUploadFile(item.action);
          }
        }
        if (item.uploadType == "multiple") {
          li.$setAttr("multiple", "multiple");
        }
        if (!item.enable) {
          li.$addClass("ui-readonly");
        }
        if (item.items instanceof Array) {
          li.$addClass("dpd-btn");
          YElement.buildFromVNode(h$1("span.arrow")).$appendTo(a);
          _renderItems(li, item.items);
        }
      }
      if (items2.length == 0) {
        ul.$addClass("empty");
      }
    };
    if (items && items.length > 0) {
      self2.el.$removeClass("empty");
      _renderItems(parent, items);
    } else {
      self2.el.$addClass("empty");
    }
  }
  createHtml() {
    this.el.$addClass("ui-tbr mobile");
    this._dropBtn = YElement.buildFromVNode(h$1("span.dp-btn")).$appendTo(this.el);
    this.ul = YElement.buildFromVNode(h$1("ul")).$appendTo(this.el);
    this.renderItems(this, this.el, this.owner.items);
    var rawDropview = document.createElement("div");
    document.body.appendChild(rawDropview);
    this.dropView = YElement.buildFromVNode(h$1("div"));
    this.dropView.$setRawDomElm(rawDropview);
    this.dropView.$addClass("tbr-dpvw mobile");
  }
  async itemClick(event2, self2, li) {
    var _this = event2.target;
    window["uploadType"] = _this.getAttribute("multiple");
    if (_this.tagName.toLowerCase() != "li") {
      _this = li;
    }
    if (_this.classList.contains("ui-readonly"))
      return;
    self2.ul.$findByClassName("dpd-btn").forEach((el) => {
      el.getElm().classList.remove("show");
    });
    self2.dropView.$findByClassName("dpd-btn").forEach((el) => {
      el.getElm().classList.remove("show");
    });
    self2.clickel = _this;
    try {
      await self2.doOnClick(event2, _this.item);
    } catch (error) {
      li.classList.toggle("show");
      throw error;
    }
    var mdhandler = function(e) {
      var target = e.target;
      if (closestEles(target, self2.ul).length == 0 && closestEles(target, li).length == 0 && closestEles(target, self2._dropBtn.getElm()).length == 0 && !self2.clickel) {
        let isShow = li.hasClass("show");
        li && li.classList.remove("show");
        document.removeEventListener("mousedown", mdhandler);
        if (isShow)
          self2.doOnDocumentClick();
      }
      if (self2.el.$findByClassName("select").length > 0) {
        self2.el.$findByClassName("select")[0].$removeClass("select");
      }
    };
    if (this.owner.isDestroyed)
      return;
    let item = this.owner.items.filter((item2) => item2.key == _this.item.key);
    _this.item = Object.assign(_this.item, item[0]);
    var vw = li.querySelector(".tbr-vw");
    vw && (vw.style.zIndex = self2.owner.getZIndex("control"));
    if (li.classList.contains("dpd-btn")) {
      li.classList.toggle("show");
      self2.showChildrenOptKey = li.classList.contains("show") ? _this.item.key : "";
      document.addEventListener("mousedown", mdhandler);
      self2.doOnDropBtnClick(event2, li.item);
    } else if (li.classList.contains("sp-btn") && (_this.classList.contains("btn-right") || event2.target.classList.contains("arrow") || event2.target.classList.contains("btn-right"))) {
      li.classList.toggle("show");
      self2.showChildrenOptKey = li.classList.contains("show") ? _this.item.key : "";
      PositionUtil.setViewPos(li, li.querySelector(".tbr-vw"), false);
    }
    if (!_this.item.items || _this.item.items.length == 0) {
      li.classList.remove("show");
      self2.dropView.$removeClass("show");
      self2._dropBtn.$removeClass("select");
    }
    self2.clickel = null;
  }
  render(ct) {
    super.render(ct);
  }
  afterRender() {
    super.afterRender();
    renderMenu(this);
    resetItems(this);
  }
  doInitFocus() {
    var $li = this.ul.$findByTagName("li");
    if ($li.length > 0) {
      $li[0].$findByClassName("tbr-btn")[0].$setAttr("tabindex", -1).$focus();
    }
  }
  setWidth(width) {
    var w = width == "auto" ? "" : width;
    this.el.$addStyle("width", w);
    resetItems(this);
  }
  afterRepaint() {
    var self2 = this;
    var showULDiv = function(parent) {
      var li_list = parent.$findByTagName("li");
      for (var i = 0; i < li_list.length; i++) {
        var liVnode = li_list[i];
        var liElm = liVnode.getElm();
        var key = liVnode.getAttr("key");
        if (key == self2.showChildrenOptKey) {
          liVnode.$addClass("show");
          var mdhandler = function(e) {
            var target = e.target;
            if (closestEles(target, self2.ul).length == 0 && closestEles(target, liElm).length == 0 && closestEles(target, self2._dropBtn.getElm()).length == 0 && !self2.clickel) {
              liElm && liElm.classList.remove("show");
              document.removeEventListener("mousedown", mdhandler);
            }
            if (self2.el.$findByClassName("select").length > 0) {
              self2.el.$findByClassName("select")[0].$removeClass("select");
            }
          };
          document.addEventListener("mousedown", mdhandler);
          break;
        }
      }
      self2.showChildrenOptKey = "";
    };
    if (!this.dropView.hasClass("show")) {
      this.el.addPostpatchHook(() => {
        showULDiv(this.el);
      });
    } else {
      this.el.addPostpatchHook(() => {
        showULDiv(this.dropView);
      });
    }
  }
  repaint() {
    if (this.clickevent) {
      this.clickevent = false;
      return;
    }
    if (!this.ul)
      return;
    this.ul.$empty();
    this.renderItems(this, this.el, this.owner.items);
    renderMenu(this);
    resetItems(this);
    this.afterRepaint();
  }
  setItemVisible(key, visible) {
    if (!this.el)
      return;
    this.ul.$findByClassName("dpd-btn").forEach((el) => {
      var _a;
      (_a = el.getElm()) == null ? void 0 : _a.classList.remove("show");
    });
    this.dropView.$findByClassName("dpd-btn").forEach((el) => {
      var _a;
      (_a = el.getElm()) == null ? void 0 : _a.classList.remove("show");
    });
    var items = this.owner.items;
    for (var i = 0, item; item = items[i]; i++) {
      if (item.key === key) {
        item.visible = visible;
        this.ul.$find((vEl) => vEl.getAttr("key") == key)[0].$addStyle("display", visible ? "block" : "none");
        break;
      }
    }
    resetItems(this);
  }
  setItemEnable(key, enable) {
    if (!this.el)
      return;
    this.ul.$findByClassName("dpd-btn").forEach((el) => {
      var _a;
      (_a = el.getElm()) == null ? void 0 : _a.classList.remove("show");
    });
    this.dropView.$findByClassName("dpd-btn").forEach((el) => {
      var _a;
      (_a = el.getElm()) == null ? void 0 : _a.classList.remove("show");
    });
    var items = this.owner.items, changed;
    for (var i = 0, item; item = items[i]; i++) {
      if (item.key === key) {
        changed = item.enable != enable;
        item.enable = enable;
        changed && this.ul.$find((vEl) => vEl.getAttr("key") == key)[0].$toggleClass("ui-readonly");
        if (!item.enable) {
          this.ul.$find((vEl) => vEl.getAttr("key") == key)[0].$addStyle("display", "none");
        } else if (item.enable && item.visible) {
          this.ul.$find((vEl) => vEl.getAttr("key") == key)[0].$addStyle("display", "block");
        }
        break;
      }
    }
    resetItems(this);
  }
  getDropView() {
    return this.dropView;
  }
  beforeDestroy() {
    this.dropView && this.dropView.$remove();
    this.resizeHandler && window.removeEventListener("resize", this.resizeHandler);
  }
  clearOperation() {
  }
  addOperation() {
  }
  async doOnClick(e, subItem) {
    var fn = this.owner.doClick;
    if (typeof fn === "function") {
      return fn.apply(this.owner, arguments);
    }
  }
  async doOnDropBtnClick(e, subItem) {
  }
  async doOnDocumentClick(e, subItem) {
  }
  handleShortcuts(e) {
    if (!this.special_keys) {
      this.special_keys = {
        "27": "esc",
        "9": "tab",
        "32": "space",
        "13": "enter",
        "8": "backspace",
        "145": "scroll lock",
        "20": "caps lock",
        "144": "num lock",
        "19": "pause",
        "45": "insert",
        "36": "home",
        "46": "delete",
        "35": "end",
        "33": "page up",
        "34": "page down",
        "37": "left",
        "38": "up",
        "39": "right",
        "40": "down",
        "96": "0",
        // 小键盘
        "97": "1",
        "98": "2",
        "99": "3",
        "100": "4",
        "101": "5",
        "102": "6",
        "103": "7",
        "104": "8",
        "105": "9",
        "106": "*",
        "107": "+",
        "108": "enter",
        "109": "-",
        "110": ".",
        "111": "/",
        "112": "f1",
        "113": "f2",
        "114": "f3",
        "115": "f4",
        "116": "f5",
        "117": "f6",
        "118": "f7",
        "119": "f8",
        "120": "f9",
        "121": "f10",
        "122": "f11",
        "123": "f12"
      };
    }
    var code = e.keyCode || e.which || e.charCode;
    if (code == null) {
      return;
    }
    var key = this.special_keys[code] || String.fromCharCode(code);
    var recorder = {
      shift: e.shiftKey,
      ctrl: e.ctrlKey,
      alt: e.altKey,
      meta: e.metaKey,
      code: key.toLowerCase()
    };
    var match = function(r1, r2) {
      return !!r1.shift == !!r2.shift && !!r1.ctrl == !!r2.ctrl && !!r1.alt == !!r2.alt && r1.code == r2.code;
    };
    var btn;
    this.el.$findByTagName("li").forEach((_item) => {
      var item = _item.getProp("item");
      if (item && item.recorder && match(recorder, item.recorder)) {
        return btn = _item;
      }
    });
    if (btn && btn.getProp("item").enable && (btn && btn.getProp("item").visible)) {
      btn.$setAttr("tabindex", 0).$focus().$callSync("click");
      e.preventDefault();
    }
  }
  resizeFun() {
    resetItems(this);
    this.el.$toggleClass("resize");
  }
  resizeDropView() {
    var elm = this.el.getElm();
    var top = elm.getBoundingClientRect().top;
    var height = elm.getBoundingClientRect().height;
    var dropViewElm = this.dropView.getElm();
    if (top + height / 2 >= document.body.clientHeight / 2) {
      dropViewElm.style.top = dropViewElm.getBoundingClientRect().top - dropViewElm.getBoundingClientRect().height - height + "px";
    } else {
      dropViewElm.style.top = dropViewElm.getBoundingClientRect().top + "px";
    }
  }
}
__decorateClass$2([
  TraceUIOptEvent()
], YesVToolbar.prototype, "doOnClick", 1);
__decorateClass$2([
  TraceUIOptEvent()
], YesVToolbar.prototype, "doOnDropBtnClick", 1);
__decorateClass$2([
  TraceUIOptEvent()
], YesVToolbar.prototype, "doOnDocumentClick", 1);
class YesMToolbarBuilder extends YesComponentBuilder {
  static create(options) {
    return new YesVToolbar(options);
  }
}
class YesVTabContainer extends YesVBaseComponent {
  constructor(options) {
    super(options);
    this.tabGroup = options.tabGroup;
  }
  createHtml() {
    this.el.$addClass("ui-control").$addClass("ui-cont");
    this.content = YElement.buildFromVNode(h("div.ui-cont-content")).$appendTo(this.el);
    this.tgel = YElement.buildFromVNode(h("div.ui-cont-tg.hide")).$appendTo(this.el);
  }
  add(form, ofForm) {
    this.content.getChildElms().map((el) => {
      if (el.getAttr("formkey") == form.formKey) {
        el.$show();
      } else {
        el.$hide();
      }
    });
    {
      var content = YElement.buildFromVNode(h("div.content")).$appendTo(this.content);
      content.$setAttr("formkey", form.formKey);
      const yesform = new YesForm({ form, el: content });
      yesform.render();
    }
    this.updateNavigation(form, ofForm);
  }
  hideContent(form) {
    this.content.getChildElms().map((el) => el.$hide());
    form.getNavigationBar() && form.getNavigationBar().updateNavBar(form);
  }
  showContent(formKey, form, ofForm) {
    this.content.getChildElms().map((el) => {
      if (el.getAttr("formkey") == formKey) {
        el.$show();
        el.$addStyle("display", "block");
        this.updateNavigation(form, ofForm);
      } else {
        el.$hide();
      }
    });
  }
  render(ct) {
    super.render(ct);
    if (this.tabGroup) {
      this.tgel.$removeClass("hide");
      let com = ControlMapping.getInstance().get(this.tabGroup);
      this.tabGroup.setYesCom(com);
      this.tabGroup.render(this.tgel);
    }
  }
  updateNavigation(form, ofForm) {
    var _a;
    form.pFormID = ofForm.pFormID;
    (_a = ofForm.getNavigationBar()) == null ? void 0 : _a.updateNavBar(form);
  }
}
class YesTabContainerBuilder extends YesComponentBuilder {
  static create(options) {
    return new YesVTabContainer(options);
  }
}
(function(global2, factory) {
  global2 = global2 || self, global2.Rolldate = factory();
})(globalThis, function() {
  var commonjsGlobal = typeof globalThis !== "undefined" ? globalThis : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : {};
  function createCommonjsModule(fn, module) {
    return module = { exports: {} }, fn(module, module.exports), module.exports;
  }
  var bscroll_min = createCommonjsModule(function(module, exports) {
    /*!
     * better-normal-scroll v1.14.1
     * (c) 2016-2019 ustbhuangyi
     * Released under the MIT License.
     */
    !function(t, i) {
      module.exports = i();
    }(commonjsGlobal, function() {
      function o(t2, i2) {
        for (; i2 + 1 < t2.length; i2++)
          t2[i2] = t2[i2 + 1];
        t2.pop();
      }
      var l = function(t2, i2) {
        if (Array.isArray(t2))
          return t2;
        if (Symbol.iterator in Object(t2))
          return function(t3, i3) {
            var e2 = [], s2 = true, o2 = false, n2 = void 0;
            try {
              for (var r2, h3 = t3[Symbol.iterator](); !(s2 = (r2 = h3.next()).done) && (e2.push(r2.value), !i3 || e2.length !== i3); s2 = true)
                ;
            } catch (t4) {
              o2 = true, n2 = t4;
            } finally {
              try {
                !s2 && h3.return && h3.return();
              } finally {
                if (o2)
                  throw n2;
              }
            }
            return e2;
          }(t2, i2);
        throw new TypeError("Invalid attempt to destructure non-iterable instance");
      };
      var e = "undefined" != typeof window, t = e && navigator.userAgent.toLowerCase(), i = t && /wechatdevtools/.test(t), s = t && 0 < t.indexOf("android");
      function T() {
        return window.performance && window.performance.now ? window.performance.now() + window.performance.timing.navigationStart : +/* @__PURE__ */ new Date();
      }
      function a(t2) {
        for (var i2 = arguments.length, e2 = Array(1 < i2 ? i2 - 1 : 0), s2 = 1; s2 < i2; s2++)
          e2[s2 - 1] = arguments[s2];
        for (var o2 = 0; o2 < e2.length; o2++) {
          var n2 = e2[o2];
          for (var r2 in n2)
            t2[r2] = n2[r2];
        }
        return t2;
      }
      function c(t2) {
        return null == t2;
      }
      var n = e && document.createElement("div").style, r = function() {
        if (!e)
          return false;
        var t2 = { webkit: "webkitTransform", Moz: "MozTransform", O: "OTransform", ms: "msTransform", standard: "transform" };
        for (var i2 in t2)
          if (void 0 !== n[t2[i2]])
            return i2;
        return false;
      }();
      function h2(t2) {
        return false !== r && ("standard" === r ? "transitionEnd" === t2 ? "transitionend" : t2 : r + t2.charAt(0).toUpperCase() + t2.substr(1));
      }
      function p(t2, i2, e2, s2) {
        t2.addEventListener(i2, e2, { passive: false, capture: !!s2 });
      }
      function u(t2, i2, e2, s2) {
        t2.removeEventListener(i2, e2, { passive: false, capture: !!s2 });
      }
      function m(t2) {
        for (var i2 = 0, e2 = 0; t2; )
          i2 -= t2.offsetLeft, e2 -= t2.offsetTop, t2 = t2.offsetParent;
        return { left: i2, top: e2 };
      }
      r && "standard" !== r && r.toLowerCase();
      var d = h2("transform"), f = h2("transition"), v = e && h2("perspective") in n, g = e && ("ontouchstart" in window || i), y = false !== d, w = e && f in n, S = { transform: d, transition: f, transitionTimingFunction: h2("transitionTimingFunction"), transitionDuration: h2("transitionDuration"), transitionDelay: h2("transitionDelay"), transformOrigin: h2("transformOrigin"), transitionEnd: h2("transitionEnd") }, x = { touchstart: 1, touchmove: 1, touchend: 1, mousedown: 2, mousemove: 2, mouseup: 2 };
      function b(t2) {
        if (t2 instanceof window.SVGElement) {
          var i2 = t2.getBoundingClientRect();
          return { top: i2.top, left: i2.left, width: i2.width, height: i2.height };
        }
        return { top: t2.offsetTop, left: t2.offsetLeft, width: t2.offsetWidth, height: t2.offsetHeight };
      }
      function X(t2, i2) {
        for (var e2 in i2)
          if (i2[e2].test(t2[e2]))
            return true;
        return false;
      }
      function Y(t2) {
        var i2 = 1 < arguments.length && void 0 !== arguments[1] ? arguments[1] : "click", e2 = void 0;
        "mouseup" === t2.type || "mousecancel" === t2.type ? e2 = t2 : "touchend" !== t2.type && "touchcancel" !== t2.type || (e2 = t2.changedTouches[0]);
        var s2 = {};
        e2 && (s2.screenX = e2.screenX || 0, s2.screenY = e2.screenY || 0, s2.clientX = e2.clientX || 0, s2.clientY = e2.clientY || 0);
        var o2 = void 0, n2 = true, r2 = true;
        if ("undefined" != typeof MouseEvent)
          try {
            o2 = new MouseEvent(i2, a({ bubbles: n2, cancelable: r2 }, s2));
          } catch (t3) {
            h3();
          }
        else
          h3();
        function h3() {
          (o2 = document.createEvent("Event")).initEvent(i2, n2, r2), a(o2, s2);
        }
        o2.forwardedTouchEvent = true, o2._constructed = true, t2.target.dispatchEvent(o2);
      }
      var _ = { startX: 0, startY: 0, scrollX: false, scrollY: true, freeScroll: false, directionLockThreshold: 5, eventPassthrough: "", click: false, tap: false, bounce: true, bounceTime: 800, momentum: true, momentumLimitTime: 300, momentumLimitDistance: 15, swipeTime: 2500, swipeBounceTime: 500, deceleration: 15e-4, flickLimitTime: 200, flickLimitDistance: 100, resizePolling: 60, probeType: 0, preventDefault: true, preventDefaultException: { tagName: /^(INPUT|TEXTAREA|BUTTON|SELECT|AUDIO)$/ }, HWCompositing: true, useTransition: true, useTransform: true, bindToWrapper: false, disableMouse: g, disableTouch: !g, observeDOM: true, autoBlur: true, wheel: false, snap: false, scrollbar: false, pullDownRefresh: false, pullUpLoad: false, mouseWheel: false, stopPropagation: false, zoom: false, infinity: false, dblclick: false };
      var M = { swipe: { style: "cubic-bezier(0.23, 1, 0.32, 1)", fn: function(t2) {
        return 1 + --t2 * t2 * t2 * t2 * t2;
      } }, swipeBounce: { style: "cubic-bezier(0.25, 0.46, 0.45, 0.94)", fn: function(t2) {
        return t2 * (2 - t2);
      } }, bounce: { style: "cubic-bezier(0.165, 0.84, 0.44, 1)", fn: function(t2) {
        return 1 - --t2 * t2 * t2 * t2;
      } } };
      function E(t2, i2, e2, s2, o2, n2, r2) {
        var h3 = t2 - i2, a2 = Math.abs(h3) / e2, l2 = r2.deceleration, c2 = r2.itemHeight, p2 = r2.swipeBounceTime, u2 = r2.wheel, m2 = r2.swipeTime, d2 = u2 ? 4 : 15, f2 = t2 + a2 / l2 * (h3 < 0 ? -1 : 1);
        return u2 && c2 && (f2 = Math.round(f2 / c2) * c2), f2 < s2 ? (f2 = n2 ? Math.max(s2 - n2 / 4, s2 - n2 / d2 * a2) : s2, m2 = p2) : o2 < f2 && (f2 = n2 ? Math.min(o2 + n2 / 4, o2 + n2 / d2 * a2) : o2, m2 = p2), { destination: Math.round(f2), duration: m2 };
      }
      function D() {
      }
      var k, P, L, O, W, H = e ? window.requestAnimationFrame || window.webkitRequestAnimationFrame || window.mozRequestAnimationFrame || window.oRequestAnimationFrame || function(t2) {
        return window.setTimeout(t2, (t2.interval || 100 / 60) / 2);
      } : D, z = e ? window.cancelAnimationFrame || window.webkitCancelAnimationFrame || window.mozCancelAnimationFrame || window.oCancelAnimationFrame || function(t2) {
        window.clearTimeout(t2);
      } : D;
      function I(t2) {
        console.error("[BScroll warn]: " + t2);
      }
      function A(t2, i2) {
        this.wrapper = "string" == typeof t2 ? document.querySelector(t2) : t2, this.wrapper || I("Can not resolve the wrapper DOM."), this.scroller = this.wrapper.children[0], this.scroller || I("The wrapper need at least one child element to be scroller."), this.scrollerStyle = this.scroller.style, this._init(i2);
      }
      return (k = A).prototype._init = function(t2) {
        this._handleOptions(t2), this._events = {}, this.x = 0, this.y = 0, this.directionX = 0, this.directionY = 0, this.setScale(1), this._addDOMEvents(), this._initExtFeatures(), this._watchTransition(), this.options.observeDOM && this._initDOMObserver(), this.options.autoBlur && this._handleAutoBlur(), this.refresh(), this.options.snap || this.scrollTo(this.options.startX, this.options.startY), this.enable();
      }, k.prototype.setScale = function(t2) {
        this.lastScale = c(this.scale) ? t2 : this.scale, this.scale = t2;
      }, k.prototype._handleOptions = function(t2) {
        this.options = a({}, _, t2), this.translateZ = this.options.HWCompositing && v ? " translateZ(0)" : "", this.options.useTransition = this.options.useTransition && w, this.options.useTransform = this.options.useTransform && y, this.options.preventDefault = !this.options.eventPassthrough && this.options.preventDefault, this.options.scrollX = "horizontal" !== this.options.eventPassthrough && this.options.scrollX, this.options.scrollY = "vertical" !== this.options.eventPassthrough && this.options.scrollY, this.options.freeScroll = this.options.freeScroll && !this.options.eventPassthrough, this.options.directionLockThreshold = this.options.eventPassthrough ? 0 : this.options.directionLockThreshold, true === this.options.tap && (this.options.tap = "tap");
      }, k.prototype._addDOMEvents = function() {
        var t2 = p;
        this._handleDOMEvents(t2);
      }, k.prototype._removeDOMEvents = function() {
        var t2 = u;
        this._handleDOMEvents(t2);
      }, k.prototype._handleDOMEvents = function(t2) {
        var i2 = this.options.bindToWrapper ? this.wrapper : window;
        t2(window, "orientationchange", this), t2(window, "resize", this), this.options.click && t2(this.wrapper, "click", this, true), this.options.disableMouse || (t2(this.wrapper, "mousedown", this), t2(i2, "mousemove", this), t2(i2, "mousecancel", this), t2(i2, "mouseup", this)), g && !this.options.disableTouch && (t2(this.wrapper, "touchstart", this), t2(i2, "touchmove", this), t2(i2, "touchcancel", this), t2(i2, "touchend", this)), t2(this.scroller, S.transitionEnd, this);
      }, k.prototype._initExtFeatures = function() {
        this.options.snap && this._initSnap(), this.options.scrollbar && this._initScrollbar(), this.options.pullUpLoad && this._initPullUp(), this.options.pullDownRefresh && this._initPullDown(), this.options.wheel && this._initWheel(), this.options.mouseWheel && this._initMouseWheel(), this.options.zoom && this._initZoom(), this.options.infinity && this._initInfinite();
      }, k.prototype._watchTransition = function() {
        if ("function" == typeof Object.defineProperty) {
          var o2 = this, n2 = false, t2 = this.options.useTransition ? "isInTransition" : "isAnimating";
          Object.defineProperty(this, t2, { get: function() {
            return n2;
          }, set: function(t3) {
            n2 = t3;
            for (var i2 = o2.scroller.children.length ? o2.scroller.children : [o2.scroller], e2 = n2 && !o2.pulling ? "none" : "auto", s2 = 0; s2 < i2.length; s2++)
              i2[s2].style.pointerEvents = e2;
          } });
        }
      }, k.prototype._handleAutoBlur = function() {
        this.on("scrollStart", function() {
          var t2 = document.activeElement;
          !t2 || "INPUT" !== t2.tagName && "TEXTAREA" !== t2.tagName || t2.blur();
        });
      }, k.prototype._initDOMObserver = function() {
        var n2 = this;
        if ("undefined" != typeof MutationObserver) {
          var r2 = void 0, t2 = new MutationObserver(function(t3) {
            if (!n2._shouldNotRefresh()) {
              for (var i2 = false, e2 = false, s2 = 0; s2 < t3.length; s2++) {
                var o2 = t3[s2];
                if ("attributes" !== o2.type) {
                  i2 = true;
                  break;
                }
                if (o2.target !== n2.scroller) {
                  e2 = true;
                  break;
                }
              }
              i2 ? n2.refresh() : e2 && (clearTimeout(r2), r2 = setTimeout(function() {
                n2._shouldNotRefresh() || n2.refresh();
              }, 60));
            }
          });
          t2.observe(this.scroller, { attributes: true, childList: true, subtree: true }), this.on("destroy", function() {
            t2.disconnect();
          });
        } else
          this._checkDOMUpdate();
      }, k.prototype._shouldNotRefresh = function() {
        var t2 = this.x > this.minScrollX || this.x < this.maxScrollX || this.y > this.minScrollY || this.y < this.maxScrollY;
        return this.isInTransition || this.stopFromTransition || t2;
      }, k.prototype._checkDOMUpdate = function() {
        var e2 = b(this.scroller), s2 = e2.width, o2 = e2.height;
        function n2() {
          var t2 = this;
          setTimeout(function() {
            (function() {
              if (!this.destroyed) {
                var t3 = (e2 = b(this.scroller)).width, i2 = e2.height;
                s2 === t3 && o2 === i2 || this.refresh(), s2 = t3, o2 = i2, n2.call(this);
              }
            }).call(t2);
          }, 1e3);
        }
        n2.call(this);
      }, k.prototype.handleEvent = function(t2) {
        switch (t2.type) {
          case "touchstart":
          case "mousedown":
            this._start(t2), this.options.zoom && t2.touches && 1 < t2.touches.length && this._zoomStart(t2);
            break;
          case "touchmove":
          case "mousemove":
            this.options.zoom && t2.touches && 1 < t2.touches.length ? this._zoom(t2) : this._move(t2);
            break;
          case "touchend":
          case "mouseup":
          case "touchcancel":
          case "mousecancel":
            this.scaled ? this._zoomEnd(t2) : this._end(t2);
            break;
          case "orientationchange":
          case "resize":
            this._resize();
            break;
          case "transitionend":
          case "webkitTransitionEnd":
          case "oTransitionEnd":
          case "MSTransitionEnd":
            this._transitionEnd(t2);
            break;
          case "click":
            this.enabled && !t2._constructed && (X(t2.target, this.options.preventDefaultException) || (t2.preventDefault(), t2.stopPropagation()));
            break;
          case "wheel":
          case "DOMMouseScroll":
          case "mousewheel":
            this._onMouseWheel(t2);
        }
      }, k.prototype.refresh = function() {
        var t2 = "static" === window.getComputedStyle(this.wrapper, null).position, i2 = b(this.wrapper);
        this.wrapperWidth = i2.width, this.wrapperHeight = i2.height;
        var e2 = b(this.scroller);
        this.scrollerWidth = Math.round(e2.width * this.scale), this.scrollerHeight = Math.round(e2.height * this.scale), this.relativeX = e2.left, this.relativeY = e2.top, t2 && (this.relativeX -= i2.left, this.relativeY -= i2.top), this.minScrollX = 0, this.minScrollY = 0;
        var s2 = this.options.wheel;
        s2 ? (this.items = this.scroller.children, this.options.itemHeight = this.itemHeight = this.items.length ? this.scrollerHeight / this.items.length : 0, void 0 === this.selectedIndex && (this.selectedIndex = s2.selectedIndex || 0), this.options.startY = -this.selectedIndex * this.itemHeight, this.maxScrollX = 0, this.maxScrollY = -this.itemHeight * (this.items.length - 1)) : (this.maxScrollX = this.wrapperWidth - this.scrollerWidth, this.options.infinity || (this.maxScrollY = this.wrapperHeight - this.scrollerHeight), this.maxScrollX < 0 ? (this.maxScrollX -= this.relativeX, this.minScrollX = -this.relativeX) : 1 < this.scale && (this.maxScrollX = this.maxScrollX / 2 - this.relativeX, this.minScrollX = this.maxScrollX), this.maxScrollY < 0 ? (this.maxScrollY -= this.relativeY, this.minScrollY = -this.relativeY) : 1 < this.scale && (this.maxScrollY = this.maxScrollY / 2 - this.relativeY, this.minScrollY = this.maxScrollY)), this.hasHorizontalScroll = this.options.scrollX && this.maxScrollX < this.minScrollX, this.hasVerticalScroll = this.options.scrollY && this.maxScrollY < this.minScrollY, this.hasHorizontalScroll || (this.maxScrollX = this.minScrollX, this.scrollerWidth = this.wrapperWidth), this.hasVerticalScroll || (this.maxScrollY = this.minScrollY, this.scrollerHeight = this.wrapperHeight), this.endTime = 0, this.directionX = 0, this.directionY = 0, this.wrapperOffset = m(this.wrapper), this.trigger("refresh"), !this.scaled && this.resetPosition();
      }, k.prototype.enable = function() {
        this.enabled = true;
      }, k.prototype.disable = function() {
        this.enabled = false;
      }, (P = A).prototype._start = function(t2) {
        var i2 = x[t2.type];
        if ((1 === i2 || 0 === t2.button) && !(!this.enabled || this.destroyed || this.initiated && this.initiated !== i2)) {
          this.initiated = i2, this.options.preventDefault && !X(t2.target, this.options.preventDefaultException) && t2.preventDefault(), this.options.stopPropagation && t2.stopPropagation(), this.moved = false, this.distX = 0, this.distY = 0, this.directionX = 0, this.directionY = 0, this.movingDirectionX = 0, this.movingDirectionY = 0, this.directionLocked = 0, this._transitionTime(), this.startTime = T(), this.options.wheel && (this.target = t2.target), this.stop();
          var e2 = t2.touches ? t2.touches[0] : t2;
          this.startX = this.x, this.startY = this.y, this.absStartX = this.x, this.absStartY = this.y, this.pointX = e2.pageX, this.pointY = e2.pageY, this.trigger("beforeScrollStart");
        }
      }, P.prototype._move = function(t2) {
        if (this.enabled && !this.destroyed && x[t2.type] === this.initiated) {
          this.options.preventDefault && t2.preventDefault(), this.options.stopPropagation && t2.stopPropagation();
          var i2 = t2.touches ? t2.touches[0] : t2, e2 = i2.pageX - this.pointX, s2 = i2.pageY - this.pointY;
          this.pointX = i2.pageX, this.pointY = i2.pageY, this.distX += e2, this.distY += s2;
          var o2 = Math.abs(this.distX), n2 = Math.abs(this.distY), r2 = T();
          if (!(r2 - this.endTime > this.options.momentumLimitTime && n2 < this.options.momentumLimitDistance && o2 < this.options.momentumLimitDistance)) {
            if (this.directionLocked || this.options.freeScroll || (o2 > n2 + this.options.directionLockThreshold ? this.directionLocked = "h" : n2 >= o2 + this.options.directionLockThreshold ? this.directionLocked = "v" : this.directionLocked = "n"), "h" === this.directionLocked) {
              if ("vertical" === this.options.eventPassthrough)
                t2.preventDefault();
              else if ("horizontal" === this.options.eventPassthrough)
                return void (this.initiated = false);
              s2 = 0;
            } else if ("v" === this.directionLocked) {
              if ("horizontal" === this.options.eventPassthrough)
                t2.preventDefault();
              else if ("vertical" === this.options.eventPassthrough)
                return void (this.initiated = false);
              e2 = 0;
            }
            e2 = this.hasHorizontalScroll ? e2 : 0, s2 = this.hasVerticalScroll ? s2 : 0, this.movingDirectionX = 0 < e2 ? -1 : e2 < 0 ? 1 : 0, this.movingDirectionY = 0 < s2 ? -1 : s2 < 0 ? 1 : 0;
            var h3 = this.x + e2, a2 = this.y + s2, l2 = false, c2 = false, p2 = false, u2 = false, m2 = this.options.bounce;
            false !== m2 && (l2 = void 0 === m2.top || m2.top, c2 = void 0 === m2.bottom || m2.bottom, p2 = void 0 === m2.left || m2.left, u2 = void 0 === m2.right || m2.right), (h3 > this.minScrollX || h3 < this.maxScrollX) && (h3 = h3 > this.minScrollX && p2 || h3 < this.maxScrollX && u2 ? this.x + e2 / 3 : h3 > this.minScrollX ? this.minScrollX : this.maxScrollX), (a2 > this.minScrollY || a2 < this.maxScrollY) && (a2 = a2 > this.minScrollY && l2 || a2 < this.maxScrollY && c2 ? this.y + s2 / 3 : a2 > this.minScrollY ? this.minScrollY : this.maxScrollY), this.moved || (this.moved = true, this.trigger("scrollStart")), this._translate(h3, a2), r2 - this.startTime > this.options.momentumLimitTime && (this.startTime = r2, this.startX = this.x, this.startY = this.y, 1 === this.options.probeType && this.trigger("scroll", { x: this.x, y: this.y })), 1 < this.options.probeType && this.trigger("scroll", { x: this.x, y: this.y });
            var d2 = document.documentElement.scrollLeft || window.pageXOffset || document.body.scrollLeft, f2 = document.documentElement.scrollTop || window.pageYOffset || document.body.scrollTop, v2 = this.pointX - d2, g2 = this.pointY - f2;
            (v2 > document.documentElement.clientWidth - this.options.momentumLimitDistance || v2 < this.options.momentumLimitDistance || g2 < this.options.momentumLimitDistance || g2 > document.documentElement.clientHeight - this.options.momentumLimitDistance) && this._end(t2);
          }
        }
      }, P.prototype._end = function(t2) {
        if (this.enabled && !this.destroyed && x[t2.type] === this.initiated) {
          this.initiated = false, this.options.preventDefault && !X(t2.target, this.options.preventDefaultException) && t2.preventDefault(), this.options.stopPropagation && t2.stopPropagation(), this.trigger("touchEnd", { x: this.x, y: this.y }), this.isInTransition = false;
          var i2 = Math.round(this.x), e2 = Math.round(this.y), s2 = i2 - this.absStartX, o2 = e2 - this.absStartY;
          if (this.directionX = 0 < s2 ? -1 : s2 < 0 ? 1 : 0, this.directionY = 0 < o2 ? -1 : o2 < 0 ? 1 : 0, !this.options.pullDownRefresh || !this._checkPullDown()) {
            if (this._checkClick(t2))
              this.trigger("scrollCancel");
            else if (!this.resetPosition(this.options.bounceTime, M.bounce)) {
              this._translate(i2, e2), this.endTime = T();
              var n2 = this.endTime - this.startTime, r2 = Math.abs(i2 - this.startX), h3 = Math.abs(e2 - this.startY);
              if (this._events.flick && n2 < this.options.flickLimitTime && r2 < this.options.flickLimitDistance && h3 < this.options.flickLimitDistance)
                this.trigger("flick");
              else {
                var a2 = 0;
                if (this.options.momentum && n2 < this.options.momentumLimitTime && (h3 > this.options.momentumLimitDistance || r2 > this.options.momentumLimitDistance)) {
                  var l2 = false, c2 = false, p2 = false, u2 = false, m2 = this.options.bounce;
                  false !== m2 && (l2 = void 0 === m2.top || m2.top, c2 = void 0 === m2.bottom || m2.bottom, p2 = void 0 === m2.left || m2.left, u2 = void 0 === m2.right || m2.right);
                  var d2 = -1 === this.directionX && p2 || 1 === this.directionX && u2 ? this.wrapperWidth : 0, f2 = -1 === this.directionY && l2 || 1 === this.directionY && c2 ? this.wrapperHeight : 0, v2 = this.hasHorizontalScroll ? E(this.x, this.startX, n2, this.maxScrollX, this.minScrollX, d2, this.options) : { destination: i2, duration: 0 }, g2 = this.hasVerticalScroll ? E(this.y, this.startY, n2, this.maxScrollY, this.minScrollY, f2, this.options) : { destination: e2, duration: 0 };
                  i2 = v2.destination, e2 = g2.destination, a2 = Math.max(v2.duration, g2.duration), this.isInTransition = true;
                } else
                  this.options.wheel && (e2 = Math.round(e2 / this.itemHeight) * this.itemHeight, a2 = this.options.wheel.adjustTime || 400);
                var y2 = M.swipe;
                if (this.options.snap) {
                  var w2 = this._nearestSnap(i2, e2);
                  this.currentPage = w2, a2 = this.options.snapSpeed || Math.max(Math.max(Math.min(Math.abs(i2 - w2.x), 1e3), Math.min(Math.abs(e2 - w2.y), 1e3)), 300), i2 = w2.x, e2 = w2.y, this.directionX = 0, this.directionY = 0, y2 = this.options.snap.easing || M.bounce;
                }
                if (i2 !== this.x || e2 !== this.y)
                  return (i2 > this.minScrollX || i2 < this.maxScrollX || e2 > this.minScrollY || e2 < this.maxScrollY) && (y2 = M.swipeBounce), void this.scrollTo(i2, e2, a2, y2);
                this.options.wheel && (this.selectedIndex = Math.round(Math.abs(this.y / this.itemHeight))), this.trigger("scrollEnd", { x: this.x, y: this.y });
              }
            }
          }
        }
      }, P.prototype._checkClick = function(t2) {
        var i2, e2, s2, o2, n2, r2 = this.stopFromTransition && !this.pulling;
        if (this.stopFromTransition = false, this.moved)
          return false;
        if (this.options.wheel) {
          if (this.target && this.target.classList.contains(this.options.wheel.wheelWrapperClass)) {
            var h3 = Math.abs(Math.round(this.y / this.itemHeight)), a2 = Math.round((this.pointY + (o2 = this.wrapper, n2 = o2.getBoundingClientRect(), { left: -(n2.left + window.pageXOffset), top: -(n2.top + window.pageYOffset) }).top - this.wrapperHeight / 2) / this.itemHeight);
            this.target = this.items[h3 + a2];
          }
          return this.scrollToElement(this.target, this.options.wheel.adjustTime || 400, true, true, M.swipe), true;
        }
        if (r2)
          return false;
        var l2 = this.options.dblclick, c2 = false;
        if (l2 && this.lastClickTime) {
          var p2 = l2.delay, u2 = void 0 === p2 ? 300 : p2;
          T() - this.lastClickTime < u2 && (c2 = true, Y(t2, "dblclick"));
        }
        return this.options.tap && (i2 = t2, e2 = this.options.tap, (s2 = document.createEvent("Event")).initEvent(e2, true, true), s2.pageX = i2.pageX, s2.pageY = i2.pageY, i2.target.dispatchEvent(s2)), this.options.click && !X(t2.target, this.options.preventDefaultException) && Y(t2), this.lastClickTime = c2 ? null : T(), true;
      }, P.prototype._resize = function() {
        var t2 = this;
        this.enabled && (s && (this.wrapper.scrollTop = 0), clearTimeout(this.resizeTimeout), this.resizeTimeout = setTimeout(function() {
          t2.refresh();
        }, this.options.resizePolling));
      }, P.prototype._startProbe = function() {
        z(this.probeTimer), this.probeTimer = H(function t2() {
          var i2 = e2.getComputedPosition();
          e2.trigger("scroll", i2), e2.isInTransition ? e2.probeTimer = H(t2) : e2.trigger("scrollEnd", i2);
        });
        var e2 = this;
      }, P.prototype._transitionTime = function() {
        var t2 = 0 < arguments.length && void 0 !== arguments[0] ? arguments[0] : 0;
        if (this.scrollerStyle[S.transitionDuration] = t2 + "ms", this.options.wheel)
          for (var i2 = 0; i2 < this.items.length; i2++)
            this.items[i2].style[S.transitionDuration] = t2 + "ms";
        if (this.indicators)
          for (var e2 = 0; e2 < this.indicators.length; e2++)
            this.indicators[e2].transitionTime(t2);
      }, P.prototype._transitionTimingFunction = function(t2) {
        if (this.scrollerStyle[S.transitionTimingFunction] = t2, this.options.wheel)
          for (var i2 = 0; i2 < this.items.length; i2++)
            this.items[i2].style[S.transitionTimingFunction] = t2;
        if (this.indicators)
          for (var e2 = 0; e2 < this.indicators.length; e2++)
            this.indicators[e2].transitionTimingFunction(t2);
      }, P.prototype._transitionEnd = function(t2) {
        t2.target === this.scroller && this.isInTransition && (this._transitionTime(), (!this.pulling || 1 === this.movingDirectionY) && !this.resetPosition(this.options.bounceTime, M.bounce) && (this.isInTransition = false, 3 !== this.options.probeType && this.trigger("scrollEnd", { x: this.x, y: this.y })));
      }, P.prototype._translate = function(t2, i2, e2) {
        if (function(t3, i3) {
          if (!t3)
            throw new Error("[BScroll] " + i3);
        }(!c(t2) && !c(i2), "Translate x or y is null or undefined."), c(e2) && (e2 = this.scale), this.options.useTransform ? this.scrollerStyle[S.transform] = "translate(" + t2 + "px," + i2 + "px) scale(" + e2 + ")" + this.translateZ : (t2 = Math.round(t2), i2 = Math.round(i2), this.scrollerStyle.left = t2 + "px", this.scrollerStyle.top = i2 + "px"), this.options.wheel)
          for (var s2 = this.options.wheel.rotate, o2 = void 0 === s2 ? 25 : s2, n2 = 0; n2 < this.items.length; n2++) {
            var r2 = o2 * (i2 / this.itemHeight + n2);
            this.items[n2].style[S.transform] = "rotateX(" + r2 + "deg)";
          }
        if (this.x = t2, this.y = i2, this.setScale(e2), this.indicators)
          for (var h3 = 0; h3 < this.indicators.length; h3++)
            this.indicators[h3].updatePosition();
      }, P.prototype._animate = function(r2, h3, a2, l2) {
        var c2 = this, p2 = this.x, u2 = this.y, m2 = this.lastScale, d2 = this.scale, f2 = T(), v2 = f2 + a2;
        this.isAnimating = true, z(this.animateTimer), function t2() {
          var i2 = T();
          if (v2 <= i2)
            return c2.isAnimating = false, c2._translate(r2, h3, d2), c2.trigger("scroll", { x: c2.x, y: c2.y }), void (c2.pulling || c2.resetPosition(c2.options.bounceTime) || c2.trigger("scrollEnd", { x: c2.x, y: c2.y }));
          var e2 = l2(i2 = (i2 - f2) / a2), s2 = (r2 - p2) * e2 + p2, o2 = (h3 - u2) * e2 + u2, n2 = (d2 - m2) * e2 + m2;
          c2._translate(s2, o2, n2), c2.isAnimating && (c2.animateTimer = H(t2)), 3 === c2.options.probeType && c2.trigger("scroll", { x: c2.x, y: c2.y });
        }();
      }, P.prototype.scrollBy = function(t2, i2) {
        var e2 = 2 < arguments.length && void 0 !== arguments[2] ? arguments[2] : 0, s2 = 3 < arguments.length && void 0 !== arguments[3] ? arguments[3] : M.bounce;
        t2 = this.x + t2, i2 = this.y + i2, this.scrollTo(t2, i2, e2, s2);
      }, P.prototype.scrollTo = function(t2, i2) {
        var e2 = 2 < arguments.length && void 0 !== arguments[2] ? arguments[2] : 0, s2 = 3 < arguments.length && void 0 !== arguments[3] ? arguments[3] : M.bounce;
        (this.x !== t2 || this.y !== i2) && (this.isInTransition = this.options.useTransition && 0 < e2 && (t2 !== this.x || i2 !== this.y), !e2 || this.options.useTransition ? (this._transitionTimingFunction(s2.style), this._transitionTime(e2), this._translate(t2, i2), e2 && 3 === this.options.probeType && this._startProbe(), e2 || (this.trigger("scroll", { x: t2, y: i2 }), this._reflow = document.body.offsetHeight, this.resetPosition(this.options.bounceTime, M.bounce) || this.trigger("scrollEnd", { x: t2, y: i2 })), this.options.wheel && (i2 > this.minScrollY ? this.selectedIndex = 0 : i2 < this.maxScrollY ? this.selectedIndex = this.items.length - 1 : this.selectedIndex = Math.round(Math.abs(i2 / this.itemHeight)))) : this._animate(t2, i2, e2, s2.fn));
      }, P.prototype.scrollToElement = function(t2, i2, e2, s2, o2) {
        if (t2 && (t2 = t2.nodeType ? t2 : this.scroller.querySelector(t2), !this.options.wheel || t2.classList.contains(this.options.wheel.wheelItemClass))) {
          var n2 = m(t2);
          n2.left -= this.wrapperOffset.left, n2.top -= this.wrapperOffset.top, true === e2 && (e2 = Math.round(t2.offsetWidth / 2 - this.wrapper.offsetWidth / 2)), true === s2 && (s2 = Math.round(t2.offsetHeight / 2 - this.wrapper.offsetHeight / 2)), n2.left -= e2 || 0, n2.top -= s2 || 0, n2.left = n2.left > this.minScrollX ? this.minScrollX : n2.left < this.maxScrollX ? this.maxScrollX : n2.left, n2.top = n2.top > this.minScrollY ? this.minScrollY : n2.top < this.maxScrollY ? this.maxScrollY : n2.top, this.options.wheel && (n2.top = Math.round(n2.top / this.itemHeight) * this.itemHeight), this.scrollTo(n2.left, n2.top, i2, o2);
        }
      }, P.prototype.resetPosition = function() {
        var t2 = 0 < arguments.length && void 0 !== arguments[0] ? arguments[0] : 0, i2 = 1 < arguments.length && void 0 !== arguments[1] ? arguments[1] : M.bounce, e2 = this.x, s2 = Math.round(e2);
        !this.hasHorizontalScroll || s2 > this.minScrollX ? e2 = this.minScrollX : s2 < this.maxScrollX && (e2 = this.maxScrollX);
        var o2 = this.y, n2 = Math.round(o2);
        return !this.hasVerticalScroll || n2 > this.minScrollY ? o2 = this.minScrollY : n2 < this.maxScrollY && (o2 = this.maxScrollY), (e2 !== this.x || o2 !== this.y) && (this.scrollTo(e2, o2, t2, i2), true);
      }, P.prototype.getComputedPosition = function() {
        var t2 = window.getComputedStyle(this.scroller, null), i2 = void 0, e2 = void 0;
        return e2 = this.options.useTransform ? (i2 = +((t2 = t2[S.transform].split(")")[0].split(", "))[12] || t2[4]), +(t2[13] || t2[5])) : (i2 = +t2.left.replace(/[^-\d.]/g, ""), +t2.top.replace(/[^-\d.]/g, "")), { x: i2, y: e2 };
      }, P.prototype.stop = function() {
        if (this.options.useTransition && this.isInTransition) {
          this.isInTransition = false, z(this.probeTimer);
          var t2 = this.getComputedPosition();
          this._translate(t2.x, t2.y), this.options.wheel ? this.target = this.items[Math.round(-t2.y / this.itemHeight)] : this.trigger("scrollEnd", { x: this.x, y: this.y }), this.stopFromTransition = true;
        } else
          !this.options.useTransition && this.isAnimating && (this.isAnimating = false, z(this.animateTimer), this.trigger("scrollEnd", { x: this.x, y: this.y }), this.stopFromTransition = true);
      }, P.prototype.destroy = function() {
        this.destroyed = true, this.trigger("destroy"), this.options.useTransition ? z(this.probeTimer) : z(this.animateTimer), this._removeDOMEvents(), this._events = {};
      }, (L = A).prototype.on = function(t2, i2) {
        var e2 = 2 < arguments.length && void 0 !== arguments[2] ? arguments[2] : this;
        this._events[t2] || (this._events[t2] = []), this._events[t2].push([i2, e2]);
      }, L.prototype.once = function(t2, i2) {
        var e2 = 2 < arguments.length && void 0 !== arguments[2] ? arguments[2] : this;
        function s2() {
          this.off(t2, s2), i2.apply(e2, arguments);
        }
        s2.fn = i2, this.on(t2, s2);
      }, L.prototype.off = function(t2, i2) {
        var e2 = this._events[t2];
        if (e2)
          for (var s2 = e2.length; s2--; )
            (e2[s2][0] === i2 || e2[s2][0] && e2[s2][0].fn === i2) && o(e2, s2);
      }, L.prototype.trigger = function(t2) {
        var i2 = this._events[t2];
        if (i2)
          for (var e2 = i2.length, s2 = [].concat(function(t3) {
            if (Array.isArray(t3)) {
              for (var i3 = 0, e3 = Array(t3.length); i3 < t3.length; i3++)
                e3[i3] = t3[i3];
              return e3;
            }
            return Array.from(t3);
          }(i2)), o2 = 0; o2 < e2; o2++) {
            var n2 = s2[o2], r2 = l(n2, 2), h3 = r2[0], a2 = r2[1];
            h3 && h3.apply(a2, [].slice.call(arguments, 1));
          }
      }, (O = A).prototype.wheelTo = function() {
        var t2 = 0 < arguments.length && void 0 !== arguments[0] ? arguments[0] : 0;
        if (this.options.wheel) {
          var i2 = -t2 * this.itemHeight;
          this.scrollTo(0, i2);
        }
      }, O.prototype.getSelectedIndex = function() {
        return this.options.wheel && this.selectedIndex;
      }, O.prototype._initWheel = function() {
        var t2 = this.options.wheel;
        t2.wheelWrapperClass || (t2.wheelWrapperClass = "wheel-scroll"), t2.wheelItemClass || (t2.wheelItemClass = "wheel-item"), void 0 === t2.selectedIndex && (t2.selectedIndex = 0, I("wheel option selectedIndex is required!"));
      }, (W = A).prototype._initMouseWheel = function() {
        var t2 = this;
        this._handleMouseWheelEvent(p), this.on("destroy", function() {
          clearTimeout(t2.mouseWheelTimer), clearTimeout(t2.mouseWheelEndTimer), t2._handleMouseWheelEvent(u);
        }), this.firstWheelOpreation = true;
      }, W.prototype._handleMouseWheelEvent = function(t2) {
        t2(this.wrapper, "wheel", this), t2(this.wrapper, "mousewheel", this), t2(this.wrapper, "DOMMouseScroll", this);
      }, W.prototype._onMouseWheel = function(t2) {
        var i2 = this;
        if (this.enabled) {
          t2.preventDefault(), this.options.stopPropagation && t2.stopPropagation(), this.firstWheelOpreation && this.trigger("scrollStart"), this.firstWheelOpreation = false;
          var e2 = this.options.mouseWheel, s2 = e2.speed, o2 = void 0 === s2 ? 20 : s2, n2 = e2.invert, r2 = void 0 !== n2 && n2, h3 = e2.easeTime, a2 = void 0 === h3 ? 300 : h3;
          clearTimeout(this.mouseWheelTimer), this.mouseWheelTimer = setTimeout(function() {
            i2.options.snap || a2 || i2.trigger("scrollEnd", { x: i2.x, y: i2.y }), i2.firstWheelOpreation = true;
          }, 400);
          var l2 = void 0, c2 = void 0;
          switch (true) {
            case "deltaX" in t2:
              c2 = 1 === t2.deltaMode ? (l2 = -t2.deltaX * o2, -t2.deltaY * o2) : (l2 = -t2.deltaX, -t2.deltaY);
              break;
            case "wheelDeltaX" in t2:
              l2 = t2.wheelDeltaX / 120 * o2, c2 = t2.wheelDeltaY / 120 * o2;
              break;
            case "wheelDelta" in t2:
              l2 = c2 = t2.wheelDelta / 120 * o2;
              break;
            case "detail" in t2:
              l2 = c2 = -t2.detail / 3 * o2;
              break;
            default:
              return;
          }
          var p2 = r2 ? -1 : 1;
          l2 *= p2, c2 *= p2, this.hasVerticalScroll || (l2 = c2, c2 = 0);
          var u2 = void 0, m2 = void 0;
          if (this.options.snap)
            return u2 = this.currentPage.pageX, m2 = this.currentPage.pageY, 0 < l2 ? u2-- : l2 < 0 && u2++, 0 < c2 ? m2-- : c2 < 0 && m2++, void this._goToPage(u2, m2);
          u2 = this.x + Math.round(this.hasHorizontalScroll ? l2 : 0), m2 = this.y + Math.round(this.hasVerticalScroll ? c2 : 0), this.movingDirectionX = this.directionX = 0 < l2 ? -1 : l2 < 0 ? 1 : 0, this.movingDirectionY = this.directionY = 0 < c2 ? -1 : c2 < 0 ? 1 : 0, u2 > this.minScrollX ? u2 = this.minScrollX : u2 < this.maxScrollX && (u2 = this.maxScrollX), m2 > this.minScrollY ? m2 = this.minScrollY : m2 < this.maxScrollY && (m2 = this.maxScrollY);
          var d2 = this.y === m2;
          this.scrollTo(u2, m2, a2, M.swipe), this.trigger("scroll", { x: this.x, y: this.y }), clearTimeout(this.mouseWheelEndTimer), d2 && (this.mouseWheelEndTimer = setTimeout(function() {
            i2.trigger("scrollEnd", { x: i2.x, y: i2.y });
          }, a2));
        }
      }, A.Version = "1.14.1", A;
    });
  });
  var version = "3.1.2";
  function Rolldate2() {
    var config = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : {};
    var _this = this, el = void 0;
    _this.extend(config);
    if (config.el) {
      el = _this.$(config.el);
      if (!el || el.bindRolldate) {
        return;
      }
      el.bindRolldate = 1;
      _this.tap(el, function() {
        _this.show();
      });
    }
    if (config.value) {
      if (config.el) {
        if (el.nodeName.toLowerCase() == "input") {
          el.value = config.value;
        } else {
          el.innerText = config.value;
        }
      }
      var str = config.value.replace(/-/g, "/").replace(/[^\d/:\s]/g, ""), date = new Date(str);
      if (!date || date == "Invalid Date") {
        console.error("Invalid Date：" + str);
      } else {
        if (config.el) {
          el.bindDate = date;
        } else {
          _this.bindDate = date;
        }
      }
    }
  }
  Rolldate2.prototype = {
    constructor: Rolldate2,
    baseData: function baseData() {
      let cancel = YIUI.I18N.getString("CURRENCY_CANCEL", "取消");
      let confirm = YIUI.I18N.getString("CURRENCY_OK", "确认");
      let clear = YIUI.I18N.getString("CURRENCY_CLEAN", "清除");
      return {
        domId: {
          yyyy: "rolldate-year",
          MM: "rolldate-month",
          dd: "rolldate-day",
          HH: "rolldate-hour",
          mm: "rolldate-min",
          ss: "rolldate-sec"
        },
        opts: {
          //插件默认配置
          el: "",
          format: "yyyy-MM-dd",
          beginYear: 2e3,
          endYear: 2100,
          init: null,
          moveEnd: null,
          confirm: null,
          cancel: null,
          commitValue: null,
          fireClose: null,
          dateShow: null,
          minStep: 1,
          trigger: "tap",
          editType: "Dialog",
          gteZIndex: null,
          lang: { title: "侧滑", cancel, confirm, clear, year: "年", month: "月", day: "日", hour: "时", min: "分", sec: "秒" }
        }
      };
    },
    extend: function extend(config) {
      var _this = this, opts = _this.baseData().opts;
      for (var key in opts) {
        if (opts[key] && Object.prototype.toString.call(opts[key]) == "[object Object]") {
          for (var key2 in config[key]) {
            opts[key][key2] = config[key][key2] == void 0 ? opts[key][key2] : config[key][key2];
          }
        } else {
          opts[key] = config[key] || opts[key];
        }
      }
      _this.config = opts;
    },
    setViewPos: function(_dom, _view) {
      if (!_view.tagName)
        return;
      var rect = _dom.getBoundingClientRect();
      var cityOffset = {
        left: rect.left,
        top: rect.top
      };
      var top = "auto", bottom = "auto", left = "auto", right = "auto";
      var w = window.innerWidth;
      var h2 = window.innerHeight;
      var dom_h = _dom.offsetHeight;
      if (h2 - cityOffset.top - dom_h < _view.offsetHeight) {
        if (cityOffset.top < _view.offsetHeight) {
          _view.classList.add("toplst");
          _view.classList.remove("bottomlst");
          top = (h2 - _view.offsetHeight) / 2 + "px";
          bottom = (h2 - _view.offsetHeight) / 2 + "px";
        } else {
          _view.classList.add("toplst");
          _view.classList.remove("bottomlst");
          bottom = h2 - cityOffset.top + "px";
        }
      } else {
        _view.classList.remove("toplst");
        _view.classList.add("bottomlst");
        top = cityOffset.top + dom_h + "px";
      }
      _dom.offsetWidth;
      if (w - cityOffset.left < _view.offsetWidth) {
        left = w - _view.offsetWidth;
      } else {
        left = cityOffset.left;
      }
      var style = "left: " + left + "px; right: " + right + "px; bottom: " + bottom + "; top: " + top + ";";
      _view.style.cssText += "; " + style;
    },
    setViewTop: function(_dom, _view) {
      var rect = _dom.getBoundingClientRect();
      var cityOffset = {
        lef: rect.left,
        top: rect.top
      };
      var top = "auto", bottom = "auto";
      if (window.innerHeight - cityOffset.top - _dom.offsetHeight < _view.offsetHeight) {
        _view.classList.add("toplst");
        bottom = window.innerHeight - cityOffset.top + "px";
      } else {
        _view.classList.remove("toplst");
        top = cityOffset.top + _dom.offsetHeight + "px";
      }
      _view.style.top = top;
      _view.style.bottom = bottom;
    },
    setViewLeft: function(_dom, _view) {
      var rect = _dom.getBoundingClientRect();
      var cityOffset = {
        lef: rect.left,
        top: rect.top
      };
      var left = "auto", right = "auto";
      var w = window.innerWidth;
      _dom.offsetWidth;
      if (w - cityOffset.left < _view.offsetWidth) {
        left = w - _view.offsetWidth + "px";
      } else {
        left = cityOffset.left + "px";
      }
      _view.style.left = left;
      _view.style.right = right;
    },
    createUI: function createUI() {
      var _this = this, data = _this.baseData(), config = _this.config, domId = data.domId, FormatArr = config.format.split(/-|\/|\s|:/g), len = FormatArr.length, ul = "", date = config.el ? _this.$(config.el).bindDate || /* @__PURE__ */ new Date() : _this.bindDate || /* @__PURE__ */ new Date(), itemClass = "", lang = config.lang;
      for (var i = 0; i < len; i++) {
        var f = FormatArr[i], domMndex = 0;
        ul += '<div id="' + domId[f] + '"><ul class="wheel-scroll">';
        if (f == "yyyy") {
          for (var j = config.beginYear; j <= config.endYear; j++) {
            itemClass = j == date.getFullYear() ? "active" : "";
            ul += '<li class="wheel-item ' + itemClass + '" data-index="' + domMndex + '">' + j + lang.year + "</li>";
            domMndex++;
          }
        } else if (f == "MM") {
          for (var k = 1; k <= 12; k++) {
            itemClass = k == date.getMonth() + 1 ? "active" : "";
            ul += '<li class="wheel-item ' + itemClass + '" data-index="' + domMndex + '">' + (k < 10 ? "0" + k : k) + lang.month + "</li>";
            domMndex++;
          }
        } else if (f == "dd") {
          var day = _this.bissextile(date.getFullYear(), date.getMonth() + 1);
          for (var l = 1; l <= day; l++) {
            itemClass = l == date.getDate() ? "active" : "";
            ul += '<li class="wheel-item ' + itemClass + '" data-index="' + domMndex + '">' + (l < 10 ? "0" + l : l) + lang.day + "</li>";
            domMndex++;
          }
        } else if (f == "HH") {
          for (var m = 0; m <= 23; m++) {
            itemClass = m == date.getHours() ? "active" : "";
            ul += '<li class="wheel-item ' + itemClass + '" data-index="' + domMndex + '">' + (m < 10 ? "0" + m : m) + lang.hour + "</li>";
            domMndex++;
          }
        } else if (f == "mm") {
          for (var n = 0; n <= 59; n += config.minStep) {
            itemClass = n == date.getMinutes() ? "active" : "";
            ul += '<li class="wheel-item ' + itemClass + '" data-index="' + domMndex + '">' + (n < 10 ? "0" + n : n) + lang.min + "</li>";
            domMndex++;
          }
        } else if (f == "ss") {
          for (var o = 0; o <= 59; o++) {
            itemClass = o == date.getSeconds() ? "active" : "";
            ul += '<li class="wheel-item ' + itemClass + '" data-index="' + domMndex + '">' + (o < 10 ? "0" + o : o) + lang.sec + "</li>";
            domMndex++;
          }
        }
        ul += "</ul></div>";
      }
      var navHtml = "";
      if (_this.config.editType == "Sideslip") {
        navHtml = '<div class="ui-nav date"><div class="ui-statusbar date" style="height: 0px;"></div><div class="ui-navview"><div class="ui-navleft"><div class="leftback rolldate"></div></div><div class="ui-navcenter"><span class="ui-nav-label">' + lang.title + '</span></div><div class="ui-navright"></div></div></div><div class="flexdiv"></div>';
        var $html = '<div class="rolldate-mask"></div><div class="rolldate-panel ' + _this.config.editType + '">' + navHtml + '<section class="rolldate-content"><div class="rolldate-dim mask-top"></div><div class="rolldate-dim mask-bottom"></div><div class="rolldate-wrapper">' + ul + '</div></section><header><span class="rolldate-btn rolldate-clear">' + lang.clear + '</span><span class="rolldate-btn rolldate-confirm">' + lang.confirm + "</span></header></div>";
      } else {
        var $html = '<div class="rolldate-mask"></div><div class="rolldate-panel ' + _this.config.editType + '"><header><span class="rolldate-btn rolldate-clear">' + lang.clear + '</span><span class="rolldate-btn rolldate-confirm">' + lang.confirm + '</span></header><section class="rolldate-content"><div class="rolldate-dim mask-top"></div><div class="rolldate-dim mask-bottom"></div><div class="rolldate-wrapper">    ' + ul + '</div></section><footer><span class="rolldate-btn rolldate-cancel">' + lang.cancel + "</span></footer>          </div>";
      }
      var box = document.createElement("div");
      box.className = "rolldate-container" + (!!navigator.userAgent.match(/MicroMessenger/i) ? " wx" : "");
      box.innerHTML = $html;
      document.body.appendChild(box);
      if (_this.config.editType == "DropView") {
        _this.setViewPos(_this.$(config.el), _this.$(".rolldate-panel"));
      }
      if (_this.$(".ui-nav.date")) {
        _this.$(".ui-statusbar.date").style.height = InterActiveFactory.interactiveHeigth + "px";
      }
      _this.scroll = {};
      var _loop = function _loop2(_i2) {
        var $id = domId[FormatArr[_i2]];
        _this.scroll[FormatArr[_i2]] = new bscroll_min("#" + $id, {
          wheel: {
            selectedIndex: 0
          }
        });
        var that = _this.scroll[FormatArr[_i2]], active = _this.$("#" + $id + " .active"), index = active ? active.getAttribute("data-index") : Math.round(date.getMinutes() / config.minStep);
        that.wheelTo(index);
        that.on("scrollEnd", function() {
          if (config.moveEnd) {
            config.moveEnd.call(_this, that);
          }
          if ([domId["yyyy"], domId["MM"]].indexOf(that.wrapper.id) != -1 && _this.scroll["yyyy"] && _this.scroll["MM"] && _this.scroll["dd"]) {
            _this.getSelected(_this.scroll["dd"]);
            var _day = _this.bissextile(_this.getSelected(_this.scroll["yyyy"]), _this.getSelected(_this.scroll["MM"])), li = "";
            if (_day != _this.$("#" + domId["dd"] + " li", 1).length) {
              for (var _l = 1; _l <= _day; _l++) {
                li += '<li class="wheel-item">' + (_l < 10 ? "0" + _l : _l) + lang.day + "</li>";
              }
              _this.$("#" + domId["dd"] + " ul").innerHTML = li;
              _this.scroll["dd"].refresh();
            }
          }
        });
      };
      for (var _i = 0; _i < len; _i++) {
        _loop(_i);
      }
      _this.$(".rolldate-panel").classList.add("fadeIn");
      _this.$(".rolldate-mask").style.zIndex = _this.config.gteZIndex();
      _this.$(".rolldate-panel").style.zIndex = _this.config.gteZIndex() + 1;
    },
    $: function $(selector, flag) {
      if (typeof selector != "string" && selector.nodeType) {
        return selector;
      }
      return flag ? document.querySelectorAll(selector) : document.querySelector(selector);
    },
    tap: function tap(el, fn) {
      var _this = this, hasTouch = "ontouchstart" in window;
      if (hasTouch && _this.config.trigger == "tap") {
        var o = {};
        el.addEventListener("touchstart", function(e) {
          var t = e.touches[0];
          o.startX = t.pageX;
          o.startY = t.pageY;
          o.sTime = +/* @__PURE__ */ new Date();
        });
        el.addEventListener("touchend", function(e) {
          var t = e.changedTouches[0];
          o.endX = t.pageX;
          o.endY = t.pageY;
          if (+/* @__PURE__ */ new Date() - o.sTime < 300) {
            if (Math.abs(o.endX - o.startX) + Math.abs(o.endY - o.startY) < 20) {
              e.preventDefault();
              fn.call(this, e);
            }
          }
          o = {};
        });
      } else {
        el.addEventListener("click", function(e) {
          fn.call(this, e);
        });
      }
    },
    show: function show() {
      var _this = this, config = _this.config, el = void 0;
      if (config.el) {
        el = _this.$(config.el);
        if (!el.bindRolldate) {
          return;
        }
        if (el.nodeName.toLowerCase() == "input") {
          el.blur();
        }
      }
      if (_this.$(".rolldate-container")) {
        return;
      }
      if (config.init && config.init.call(_this) === false) {
        return;
      }
      _this.createUI();
      _this.event();
      config.dateShow();
    },
    hide: function hide(flag) {
      var _this = this, el = _this.$(".rolldate-panel.fadeIn");
      if (el) {
        el.classList.remove("fadeIn");
        el.classList.add("fadeOut");
        el.classList.add(_this.config.editType);
        _this.destroy(flag);
      }
    },
    event: function event2() {
      var _this = this, mask = _this.$(".rolldate-mask"), cancel = _this.$(".rolldate-cancel"), confirm = _this.$(".rolldate-confirm"), clear = _this.$(".rolldate-clear"), leftback = _this.$(".leftback.rolldate");
      _this.tap(mask, function() {
        _this.hide(1);
      });
      clear && _this.tap(clear, function() {
        _this.hide(1);
        _this.config.commitValue("");
      });
      cancel && _this.tap(cancel, function() {
        _this.hide(1);
      });
      leftback && _this.tap(leftback, function() {
        _this.hide(1);
      });
      _this.tap(confirm, function() {
        var config = _this.config, el = void 0, date = config.format, newDate = /* @__PURE__ */ new Date();
        for (var f in _this.scroll) {
          var d = _this.getSelected(_this.scroll[f]);
          date = date.replace(f, d);
          if (f == "yyyy") {
            newDate.setFullYear(d);
          } else if (f == "MM") {
            newDate.setMonth(d - 1);
          } else if (f == "dd") {
            newDate.setDate(d);
          } else if (f == "HH") {
            newDate.setHours(d);
          } else if (f == "mm") {
            newDate.setMinutes(d);
          } else if (f == "ss") {
            newDate.setSeconds(d);
          }
        }
        if (config.confirm) {
          var flag = config.confirm.call(_this, date);
          if (flag === false) {
            return false;
          } else if (flag) {
            date = flag;
          }
        }
        if (config.el) {
          el = _this.$(config.el);
          if (el.nodeName.toLowerCase() == "input") {
            el.value = date;
          } else {
            el.innerText = date;
          }
          el.bindDate = newDate;
        } else {
          _this.bindDate = newDate;
        }
        _this.hide();
        _this.config.commitValue(date);
      });
    },
    bissextile: function bissextile(year, month) {
      var day = void 0;
      if (month == 1 || month == 3 || month == 5 || month == 7 || month == 8 || month == 10 || month == 12) {
        day = 31;
      } else if (month == 4 || month == 6 || month == 11 || month == 9) {
        day = 30;
      } else if (month == 2) {
        if (year % 4 == 0 && (year % 100 != 0 || year % 400 == 0)) {
          day = 29;
        } else {
          day = 28;
        }
      }
      return day;
    },
    destroy: function destroy(flag) {
      var _this = this, config = _this.config;
      for (var i in _this.scroll) {
        _this.scroll[i].destroy();
      }
      if (flag && config.cancel) {
        config.cancel.call(_this);
      }
      setTimeout(function() {
        config.fireClose();
        var el = _this.$(".rolldate-container");
        document.body.removeChild(el);
      }, 300);
    },
    getSelected: function getSelected(scroll) {
      var el = this.$("#" + scroll.wrapper.id + " li", 1)[scroll.getSelectedIndex()];
      return el && el.innerText.replace(/\D/g, "");
    }
  };
  Rolldate2.version = version;
  return Rolldate2;
});
var __defProp$1 = Object.defineProperty;
var __getOwnPropDesc$1 = Object.getOwnPropertyDescriptor;
var __decorateClass$1 = (decorators, target, key, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$1(target, key) : target;
  for (var i = decorators.length - 1, decorator; i >= 0; i--)
    if (decorator = decorators[i])
      result = (kind ? decorator(target, key, result) : decorator(result)) || result;
  if (kind && result)
    __defProp$1(target, key, result);
  return result;
};
class YesMDatePicker extends YesBaseInnerLabel {
  constructor(options) {
    super(options);
  }
  createHtml() {
    this.el.$addClass("ui-control").$addClass("mui-dp");
    this.$label = YElement.buildFromVNode(h("span.mui-dp-btn")).$appendTo(this.el);
    this.$label.$setAttr("id", "m_date_" + this.owner.getId());
    this.$icon = YElement.buildFromVNode(h("span.mui-dp-i")).$appendTo(this.el);
  }
  initCss(options) {
    super.initCss(options);
    var format = this.owner.style && this.owner.style.format;
    if (format) {
      this.setAlignCssName(format);
    }
  }
  setLabelCss(lblCss) {
    this.el.$appendStyles(lblCss);
  }
  setEnable(enable) {
    super.setEnable(enable);
    if (!enable) {
      if (this.$label.hasClass("ptext")) {
        this.$label.$setInnerText("");
      }
    } else {
      if (!this.owner.value && this.owner.promptText) {
        this.$label.$addClass("ptext");
        if (!this.el.hasClass("ui-readonly")) {
          this.$label.$setInnerText(this.owner.promptText);
        }
      }
    }
  }
  setShowText(caption) {
    if (caption == "" || caption == null || !caption) {
      if (this.owner.promptText) {
        this.$label.$addClass("ptext");
        if (!this.el.hasClass("ui-readonly")) {
          this.$label.$setInnerText(this.owner.promptText);
        }
      } else {
        this.$label.$setInnerText("");
      }
    } else {
      this.$label.$removeClass("ptext");
      this.$label.$setInnerText(caption);
    }
  }
  destroy() {
    super.destroy();
    this.cbbpop && this.cbbpop.remove();
  }
  setValue(value) {
    super.setValue(value);
  }
  getShowText() {
    return this.$label.getInnerText();
  }
  getInput() {
    return this.$label;
  }
  doShow() {
    var _a;
    (_a = this.cbbpop) == null ? void 0 : _a.show();
    this.$icon.$addClass("up");
  }
  doHide() {
    var _a;
    (_a = this.cbbpop) == null ? void 0 : _a.hide();
    this.$icon.$removeClass("up");
  }
  async commitValue(...args) {
    LoadingUtil.show();
    try {
      return await this.owner.commitValue.apply(this.owner, args);
    } finally {
      LoadingUtil.hide();
    }
  }
  getFormat() {
    return this.owner.onlyDate ? "yyyy-MM-dd" : "yyyy-MM-dd HH:mm:ss";
  }
  async doOnDropBtnClick(event2, item) {
  }
  install() {
    super.install();
    var self2 = this;
    let { value, editType, promptText, caption } = self2.owner;
    var currYear = new Date(value).getFullYear();
    this.el.$click(function(event2) {
      if (!self2.enable)
        return;
      self2.datePop = new Rolldate({
        el: self2.el[0],
        format: self2.getFormat(),
        beginYear: currYear - 100,
        //开始年份
        endYear: currYear + 100,
        //结束年份
        minstep: 1,
        trigger: "tap",
        editType: SelectEditType.toString(editType),
        value: self2.$label.getInnerText(),
        lang: { title: promptText || caption },
        gteZIndex: function() {
          return self2.owner.getZIndex("control");
        },
        commitValue: (v) => {
          self2.commitValue(v);
        },
        fireClose: () => {
          FallBackUtil.removeFallBack();
        },
        dateShow: () => {
          FallBackUtil.addFallBack(self2.datePop);
          self2.doOnDropBtnClick(event2, null);
        }
      });
      self2.datePop.fireClose = () => {
        self2.datePop.hide();
      };
      self2.datePop.show();
    });
  }
}
__decorateClass$1([
  TraceUIOptEvent()
], YesMDatePicker.prototype, "doOnDropBtnClick", 1);
class YesDatePickerBuilder extends YesComponentBuilder {
  static create(options) {
    return new YesMDatePicker(options);
  }
}
class YesMUTCDatePicker extends YesMDatePicker {
  constructor(options) {
    super(options);
  }
}
class YesUTCDatePickerBuilder extends YesComponentBuilder {
  static create(options) {
    return new YesMUTCDatePicker(options);
  }
}
class YesMMonthPicker extends YesMDatePicker {
  constructor(options) {
    super(options);
  }
  getFormat() {
    return "yyyy-MM";
  }
}
class YesMonthPickerBuilder extends YesComponentBuilder {
  static create(options) {
    return new YesMMonthPicker(options);
  }
}
class YesMTimePicker extends YesMDatePicker {
  constructor(options) {
    super(options);
  }
  getFormat() {
    return this.owner.second ? "HH:mm:ss" : "HH:mm";
  }
}
class YesTimePickerBuilder extends YesComponentBuilder {
  static create(options) {
    return new YesMTimePicker(options);
  }
}
const buildVNode$4 = YElement.buildFromVNode;
const formatAsyncData$5 = (datas) => {
  datas.forEach((val, i) => {
    var id = val.itemKey + "_" + val.OID;
    val.id = id;
    if (val.items && val.items.length > 0) {
      formatAsyncData$5(val.items);
    }
  });
  return datas;
};
class YesVDictTable {
  constructor(options) {
    this.editor = options.editor;
    this.startRow = 0;
    this.pageMaxNum = options.pageMaxNum || 30;
    this.pageIndicatorCount = options.pageIndicatorCount || 1;
    this.needLoad = true;
    this.el = options.editor.el;
  }
  render() {
    this.dt = buildVNode$4(h("div.dicttable"));
    var wrap = buildVNode$4(h("div.dicttable-wrap")).$appendTo(this.dt);
    this._input = buildVNode$4(h("input.dicttable-txt")).$appendTo(wrap);
    this._input.$setAttr("placeholder", I18N.getString("DICT_KEYWORD", "请输入关键字"));
    this._clearBtn = buildVNode$4(h("button.dicttable-clearBtn")).$appendTo(wrap);
    this._clearBtn.$setInnerText(I18N.getString("DICT_EMPTY", "清空"));
    this._itemsView = buildVNode$4(h("div.dicttable-items")).$appendTo(this.dt);
    this._itemsView.$scroll(this.scroll.bind(this));
  }
  createRootNode() {
  }
  scroll(e) {
    if (!this.needLoad) {
      return;
    }
    let scrollTop = this._itemsView.getElm().scrollTop;
    var clientHeight = this._itemsView.getElm().clientHeight;
    var scrollHeight = this._itemsView.getElm().scrollHeight;
    var self2 = this;
    if (Math.ceil(scrollTop + clientHeight) >= scrollHeight) {
      self2.startRow += self2.pageMaxNum;
      self2.loadData(self2.dt, self2._selectValue);
    }
  }
  /**
   * 清空搜索框
   */
  clearSearchInput() {
    this._input.$setInputValue("");
    this.fuzzyValue = null;
  }
  checkDisplayCols() {
    return new Promise((resolve) => {
      if (this.columns) {
        resolve(this.columns);
      } else {
        var self2 = this;
        this.getDisplayCols().then(function(columns) {
          self2.columns = columns;
          resolve(columns);
        });
      }
    });
  }
  async showing(value) {
    this.clearSearchInput();
    this._selectValue = value;
    var self2 = this;
    await self2.checkDisplayCols();
    await self2.loadData(self2.dt, self2._selectValue);
    self2.doPop();
    self2.install();
  }
  loadData(nodeEl, selectValue) {
    if (!nodeEl) {
      nodeEl = this.dt;
    }
    var selectId = selectValue && selectValue.itemKey + "_" + selectValue.oid;
    var nodeValue = this.getNodeValue(nodeEl);
    this.needLoad = false;
    var data = [];
    let self2 = this;
    return this.getQueryData(
      this.startRow,
      this.pageMaxNum,
      this.pageIndicatorCount,
      this.fuzzyValue,
      nodeValue
    ).then(function(_data) {
      data = _data.data;
      self2.addNodes(data, selectId);
    }).finally(function() {
      self2.needLoad = data.length < self2.pageMaxNum ? false : true;
    });
  }
  addNodes(nodes, selectId) {
    if (nodes) {
      var syncNodes = formatAsyncData$5(nodes);
      this.buildNode(syncNodes, selectId);
    }
  }
  /**
   * 移除根节点外的所有节点
   */
  reset() {
    this.dt.$findByClassName("dicttable-item").forEach((el) => el.$remove());
  }
  /** 构建树结构 */
  buildNode(nodes, selectId) {
    if (!nodes || nodes.length == 0) {
      this.reset();
    }
    this.addChildNodes(nodes, selectId);
  }
  /**
   * 根据父节点 添加子节点
   * @param {} nodes
   * @param {} pNodeKey
   */
  addChildNodes(nodes, selectId) {
    if (nodes && this.startRow == 0) {
      this._itemsView.$empty();
    }
    if (nodes.length == 0) {
      buildVNode$4(h("div.dict-nochange", {}, I18N.getString("YESCOMBOBOX_NODATA", "无匹配数据"))).$appendTo(this._itemsView);
    }
    let node, item, enable, self2 = this;
    for (let i = 0; i < nodes.length; i++) {
      node = nodes[i];
      enable = node.Enable || 0;
      item = buildVNode$4(h("div.dicttable-item")).$appendTo(this._itemsView);
      buildVNode$4(h("span.dicttable-item-icon")).$appendTo(item);
      buildVNode$4(h("label", {}, node.caption)).$appendTo(item);
      item.$setAttr("itemKey", node.itemKey);
      item.$setAttr("oid", node.oid);
      item.$setAttr("enable", enable);
      item.$setAttr("code", node.Code);
      item.$setAttr("name", node.Name);
      item.$setAttr("useCode", node.UseCode);
      switch (enable) {
        case DictState.Enable:
          item.$addClass("enable");
          break;
        case DictState.Disable:
          item.$addClass("disable");
          break;
        case DictState.Discard:
          item.$addClass("discard");
          break;
      }
      var pnid = node.itemKey + "_" + node.oid;
      if (selectId != null) {
        if (pnid == selectId) {
          item.$addClass("sel");
        }
      }
      item.$click(function(e) {
        let _item = buildVNode$4(this);
        self2._itemsView.$findByClassName("dicttable-item").forEach((el) => {
          el.$removeClass("sel");
        });
        _item.$addClass("sel");
        self2._selectValue = self2.getNodeValue(_item);
        self2.dictpopupview.hide();
        self2.startRow = 0;
        self2.el.$removeClass("on");
        self2.commitValue(self2._selectValue);
        self2.hideView();
      });
    }
  }
  doPop() {
    let self2 = this;
    var setting = {
      el: this.dt,
      dir: "right",
      className: "dictviewpop",
      closeCallBack: function() {
        self2.startRow = 0;
        self2._itemsView.getChildElms().forEach((el) => el.$remove());
        self2.hideView();
        self2.el.$removeClass("on");
        self2._clearBtn.$removeListener("click", self2._clearBtn._clearBtnfn);
      }
    };
    switch (this.editor.owner.editType) {
      case 1:
        setting["dir"] = "center";
        setting["size"] = "80% 300";
        break;
      case 0:
        setting["dir"] = "bottom";
        setting["size"] = "100% 300";
        break;
      case 3:
        setting["dir"] = "drop";
        setting["size"] = "70% 300";
        setting["dom"] = this.el.getElm();
        break;
      default:
        setting["dir"] = "right";
        setting["size"] = "100% 100%";
        setting["fullScreenNavBar"] = true;
        setting["navCaption"] = this.editor.owner.promptText || "侧滑";
        break;
    }
    setting.ziBase = this.editor.owner.getZIndex("control");
    this.dictpopupview = new Popup(setting);
    this.el.$addClass("on");
    this.dictpopupview.show();
  }
  getNodeValue($node) {
    var text = "";
    if ($node.getAttr("oid") >= 0) {
      var caption = [];
      caption.push($node.$findByTagName("label")[0].getInnerText());
      text = caption.join(" ");
    }
    var options = {};
    options["oid"] = $node.getAttr("oid") || 0;
    options["itemKey"] = $node.getAttr("itemKey");
    options["caption"] = text;
    options["UseCode"] = $node.getAttr("useCode");
    options["Name"] = $node.getAttr("name");
    options["Code"] = $node.getAttr("code");
    return new ItemData(options);
  }
  install() {
    var self2 = this;
    this._clearBtn._clearBtnfn = function(e) {
      self2._clearBtn.$removeListener("click", self2._clearBtn._clearBtnfn);
      self2._itemsView.$findByClassName("dicttable-item").forEach((el) => {
        el.$removeClass("sel");
      });
      self2._selectValue = null;
      self2.dictpopupview.hide();
      self2.startRow = 0;
      self2.el.$removeClass("on");
      self2.commitValue(null);
      self2.hideView();
    };
    this._clearBtn.$addListener("click", self2._clearBtn._clearBtnfn);
    this._input.$addListener("blur", function(e) {
      var value = self2._input.getElm().value;
      self2.fuzzyValue = value;
      self2.startRow = 0;
      return self2.loadData(self2.dt, self2._selectValue);
    });
    this._input.$keydown(function(e) {
      var keyCode = e.keyCode;
      if (keyCode == 13) {
        buildVNode$4(this).$blur();
      }
    });
  }
}
const buildVNode$3 = YElement.buildFromVNode;
const formatAsyncData$4 = (datas) => {
  datas.forEach((val, i) => {
    var id = val.itemKey + "_" + (val.OID || 0);
    val.id = id;
    if (val.items && val.items.length > 0) {
      formatAsyncData$4(val.items);
    }
  });
  return datas;
};
const expandNode$1 = async function(self2, node) {
  var $arrow = node.$findByTagName("span")[0];
  if ($arrow.hasClass("dt-collapse")) {
    $arrow.$removeClass("dt-collapse").$addClass("dt-arrowgif");
  }
  if (!node.getAttr("isLoaded")) {
    let data = await self2.getDictChildren(self2.getNodeValue(node));
    var nodes = data.data;
    var $arrow = node.$findByTagName("span")[0];
    if (nodes.length == 0) {
      $arrow.$removeClass("dt-arrowgif");
      $arrow.$addClass("dt-collapse");
    }
    self2.addTreeNodes(node, nodes);
  }
  node.$findByTagName("ul")[0] && node.$findByTagName("ul")[0].$show();
  var $arrow = node.$findByTagName("span")[0];
  if ($arrow.hasClass("dt-arrowgif")) {
    $arrow.$removeClass("dt-arrowgif").$addClass("dt-expand");
    $arrow.$next().$findByClassName("branch")[0].$removeClass("b-collapse").$addClass("b-expand");
  } else if ($arrow.hasClass("dt-collapse")) {
    $arrow.$removeClass("dt-collapse").$addClass("dt-expand");
    $arrow.$next().$findByClassName("branch")[0].$removeClass("b-collapse").$addClass("b-expand");
  }
  return;
};
const collapseNode$1 = function(node) {
  node.$findByTagName("ul")[0] && node.$findByTagName("ul")[0].$hide();
  var $arrow = node.$findByTagName("span")[0];
  $arrow.$removeClass("dt-expand").$addClass("dt-collapse");
  $arrow.$next().$findByClassName("branch")[0].$removeClass("b-expand").$addClass("b-collapse");
};
class YesVDictTree {
  constructor(options) {
    this.dt = buildVNode$3(h("div.dicttree.dt-vw"));
    this.editor = options.editor;
    this.el = options.editor.el;
    this._pMap = {};
  }
  render() {
    let self2 = this;
    this._itemsView = buildVNode$3(h("div.dicttree-items")).$appendTo(this.dt);
    this._clearBtn = buildVNode$3(h("button.dicttree-clearBtn")).$appendTo(this.dt);
    this._clearBtn.$setInnerText(I18N.getString("DICT_EMPTY", "清空"));
    this._clearBtn["_clearBtnFn"] = function(params) {
      this._clearBtn.$removeListener("click", this._clearBtn["_clearBtnFn"].bind(this));
      self2.dictpopupview.hide();
      self2.el.$removeClass("on");
      self2.commitValue(null);
      self2.hideView();
    };
    this._clearBtn.$addListener("click", this._clearBtn["_clearBtnFn"].bind(this));
  }
  clearSelectedNode() {
    this._itemsView.$findByClassName("sel")[0].$removeClass("sel");
  }
  /**
   * 创建根节点
   * @param {} itemKey
   * @param {} nodeKey
   * @param {} name
   */
  renderRootNode() {
    var _this = this;
    let { itemKey, oid } = this.editor.rootItem;
    var _li = YElement.buildFromVNode(h("li.item.root", {
      attrs: { id: itemKey + "_" + oid, oid, itemKey, level: -1, comp_Level: 1 }
    })).$appendTo(this._itemsView);
    YElement.buildFromVNode(h("span.icon.dt-expand", {
      on: {
        click: function(e) {
          e.stopPropagation();
          let _arrow = YElement.buildFromVNode(this);
          if (_arrow.hasClass("dt-collapse")) {
            expandNode$1(_this, _li);
            return;
          }
          if (_arrow.hasClass("dt-expand")) {
            collapseNode$1(_li);
          }
        }
      }
    })).$appendTo(_li);
    var _a = YElement.buildFromVNode(h("a.dt-anchor")).$appendTo(_li);
    YElement.buildFromVNode(h("a.branch.b-expand")).$appendTo(_a);
    let btxt = YElement.buildFromVNode(h("span.b-txt")).$appendTo(_a);
    btxt.$setInnerText(this.editor.rootCaption);
    YElement.buildFromVNode(h("ul.dt-ul")).$appendTo(_li);
    this.rootNode = _li;
  }
  selectNode(node) {
    this.commitValue(this.getNodeValue(node));
    this.dictpopupview.hide();
    this.el.$removeClass("on");
    this.hideView();
  }
  checkDisplayCols() {
    return new Promise((resolve) => {
      if (this.columns) {
        resolve(this.columns);
      } else {
        var self2 = this;
        this.getDisplayCols().then(function(columns) {
          self2.columns = columns;
          resolve(columns);
        });
      }
    });
  }
  async showing(value) {
    await this.renderRootNode();
    let def = null;
    if (value && value.getOID() > 0) {
      def = this.setSelectionValue(value);
    }
    if (!def) {
      def = expandNode$1(this, this.rootNode);
    }
    this.doPopup();
    return def;
  }
  async setSelectionValue(value) {
    let self2 = this;
    let root = this.getNodeValue(this.rootNode);
    let rootId = root && root.getOID();
    let _expand = async function(tree, parents, index) {
      if (parents) {
        if (index < parents.length) {
          let oid = parents[index].oid;
          if (parents) {
            let $nodes = self2.dt.$find((node) => {
              return node.getAttr("oid") == oid;
            });
            if ($nodes.length == 0 && rootId) {
              $nodes = self2.dt.$find((node) => {
                return node.getAttr("oid") == rootId;
              });
            }
            if ($nodes.length > 0) {
              await expandNode$1(tree, $nodes[0]);
              await _expand(tree, parents, index + 1);
            }
          }
        }
      }
    };
    var paths = await self2.getTreePath(value, rootId);
    var len = paths.length;
    if (len > 0) {
      for (var i = 0; i < len; i++) {
        await _expand(self2, paths[i], 0);
      }
    } else {
      await expandNode$1(self2, self2.rootNode);
    }
    var selectNodes = self2.dt.$find((node) => {
      return node.getAttr("oid") == value.oid;
    });
    if (selectNodes.length == 1) {
      selectNodes[0].$addClass("sel");
    }
  }
  addTreeNodes(node, nodes) {
    var _this = this;
    if (!node.getAttr("isLoaded")) {
      if (nodes && nodes.length > 0) {
        var syncNodes = formatAsyncData$4(nodes);
        _this.addNodes(syncNodes, node, parseInt(node.getAttr("level")) + 1);
        node.$setAttr("isLoaded", true);
      }
    }
  }
  /**
    * 根据父节点 添加子节点
    * @param {} nodes
    * @param {} pNodeKey
    */
  addNodes(nodes, pNode, level) {
    var pNodeKey = pNode.getAttr("id");
    if (nodes.length <= 0) {
      pNode.$findByTagName("span")[0].$removeClass("dt-collapse");
      return;
    }
    pNode.$setAttr("isLoaded", true);
    var node, nid, oid, itemKey, code, name, useCode;
    this._pMap[pNodeKey] || (this._pMap[pNodeKey] = []);
    var _pul = pNode.$findByTagName("ul")[0];
    if (!_pul || _pul.length == 0) {
      _pul = YElement.buildFromVNode(h("ul.dt-ul")).$appendTo(pNode);
    }
    for (var i = 0, len = nodes.length; i < len; i++) {
      node = nodes[i];
      nid = node.id;
      oid = node.OID;
      code = node.Code;
      name = node.Name;
      useCode = node.UseCode;
      itemKey = node.itemKey;
      this._pMap[pNodeKey].push(nid);
      var _li = YElement.buildFromVNode(h("li.item", {
        attrs: { id: nid, oid, parentid: pNodeKey, itemKey, level, code, name, useCode }
      }));
      var pItemKey = pNode.getAttr("itemKey");
      var comp_Level = parseInt(pNode.getAttr("comp_Level"));
      if (itemKey != pItemKey) {
        comp_Level += 1;
      }
      _li.$setAttr("comp_Level", comp_Level);
      var comp_css = "level comp_Level" + comp_Level;
      if (node.disableSelect) {
        comp_css += " disableSelect";
      }
      _li.$addClass(comp_css);
      var _titleSpan = YElement.buildFromVNode(h("div.dt-li-title"));
      _li.$append(_titleSpan);
      var _span, _this = this;
      var _a = YElement.buildFromVNode(h("a.dt-anchor", {
        on: {
          click: function() {
            let $node = YElement.buildFromVNode(this);
            if (!$node.$parent().$parent().hasClass("disableSelect")) {
              _this.selectNode($node.$parent().$parent());
            }
          }
        }
      }));
      var _explore = YElement.buildFromVNode(h("span"));
      var css_name = "";
      _span = YElement.buildFromVNode(h("span", {
        on: {
          click: async function() {
            let $item = YElement.buildFromVNode(this);
            let $node = $item.$parent().$parent();
            if ($item.hasClass("dt-collapse")) {
              await expandNode$1(_this, $node);
              return;
            }
            if ($item.hasClass("dt-expand")) {
              await collapseNode$1($node);
              return;
            }
            if (!$node.hasClass("disableSelect")) {
              _this.selectNode($node);
              return;
            }
          }
        }
      }));
      if (node.NodeType == 1) {
        if (node.open) {
          _span.$addClass("icon dt-expand");
          css_name = "branch b-expand";
        } else {
          _span.$addClass("icon dt-collapse");
          css_name = "branch b-collapse";
        }
        _titleSpan.$append(_span);
      } else {
        _span.$addClass("icon");
        _titleSpan.$append(_span);
        css_name = "branch";
      }
      _a.$append(_explore);
      switch (node.Enable) {
        case DictState.Enable:
          css_name += " enable";
          break;
        case DictState.Disable:
          css_name += " disable";
          break;
        case DictState.Discard:
          css_name += " discard";
          break;
      }
      _explore.$addClass(css_name);
      var _selectNode = YElement.buildFromVNode(h("span.b-txt"));
      var caption = !node.caption ? "" : node.caption;
      _selectNode.$setInnerText(caption);
      _a.$append(_selectNode);
      _titleSpan.$append(_a);
      _pul.$append(_li);
      if (this.editor.value && nid == this.editor.value.itemKey + "_" + this.editor.value.oid) {
        _li.$addClass("sel");
      }
    }
  }
  doPopup() {
    let self2 = this;
    var setting = {
      el: this.dt,
      dir: "right",
      className: "dictviewpop",
      closeCallBack: function() {
        self2._clearBtn.$removeListener("click", self2._clearBtn["_clearBtnFn"].bind(self2));
        self2._itemsView.getChildElms().forEach((el) => el.$remove());
        self2.hideView();
        self2.el.$removeClass("on");
      }
    };
    switch (this.editor.owner.editType) {
      case 1:
        setting["dir"] = "center";
        setting["size"] = "80% 285";
        break;
      case 0:
        setting["dir"] = "bottom";
        setting["size"] = "100% 285";
        break;
      case 3:
        setting["dir"] = "drop";
        setting["size"] = "70% 285";
        setting["dom"] = this.el.getElm();
        break;
      default:
        setting["dir"] = "right";
        setting["size"] = "100% 100%";
        setting["fullScreenNavBar"] = true;
        setting["navCaption"] = this.editor.owner.promptText || "侧滑";
        break;
    }
    setting.ziBase = this.editor.owner.getZIndex("control");
    this.dictpopupview = new Popup(setting);
    this.el.$addClass("on");
    this.dictpopupview.show();
  }
  /**
   * 移除根节点外的所有节点
   */
  reset() {
    this.dt.$findByClassName("dicttree-item").forEach((el) => el.$remove());
  }
  getNodeValue($node) {
    var text = "";
    if ($node.getAttr("oid") >= 0) {
      var caption = [], label = $node.$findByClassName("b-txt")[0];
      if (label) {
        caption.push(label.getInnerText());
        text = caption.join(" ");
      }
    }
    var options = {};
    options["oid"] = $node.getAttr("oid") || 0;
    options["itemKey"] = $node.getAttr("itemKey");
    options["caption"] = text;
    options["UseCode"] = $node.getAttr("useCode");
    options["Name"] = $node.getAttr("name");
    options["Code"] = $node.getAttr("code");
    return new ItemData(options);
  }
}
class YesVBaseDict extends YesVBaseText {
  constructor(options) {
    super(options);
    this.createHtml = function() {
      this.el.$addClass("ui-control").$addClass("ui-dict");
      this.dictWrap = YElement.buildFromVNode(h("div.dict-warp")).$appendTo(this.el);
      this._textView = YElement.buildFromVNode(h("input.dict-txt")).$appendTo(this.dictWrap);
      this._clearBtn = YElement.buildFromVNode(h("span.clear")).$appendTo(this.dictWrap);
      this.dropArrow = YElement.buildFromVNode(h("div.dict-arrow")).$appendTo(this.el);
    };
    this.maxRows = options.maxRows;
    this.pageIndicatorCount = options.pageIndicatorCount;
  }
  initCss(options) {
    if (!options) {
      return;
    }
    const outerCss = this.getOuterCss(options, true);
    const inputCss = this.getInputCss(options);
    const lblCss = this.getLabelCss(options);
    const inputLblCss = this.getInputLbl(options);
    this.el.$appendStyles(outerCss).$appendStyles(inputCss);
    this._textView.$appendStyles(inputLblCss).$appendStyles(lblCss);
    this.setFormatStyle(options);
    this._textView.$appendStyles(this.txtCss);
  }
  setBrowserFormKey(browserFormKey) {
    this.browserFormKey = browserFormKey;
  }
  getBrowserFormKey() {
    return this.browserFormKey;
  }
  setQueryFormKey(queryFormKey) {
    this.browserFormKey = queryFormKey;
  }
  getQueryFormKey() {
    return this.queryFormKey;
  }
  afterRender() {
    super.afterRender();
    this._needShow = false;
    this._hasShow = false;
    if (this.owner.multiSelect) {
      this._textView.$setAttr("readonly", true);
    }
    this._textView.$setAttr("unselectable", "on");
  }
  // 移动端不需要聚焦
  focus() {
  }
  setShowText(text) {
    this._textView.$setInputValue(text);
    this._temp = text;
  }
  getInput() {
    return this._textView;
  }
  setPromptText(promptText) {
    this._textView.$setAttr("placeholder", promptText);
  }
  checkDict() {
    var fn = this.owner.checkDict;
    if (typeof fn === "function") {
      return fn.apply(this.owner, arguments);
    }
  }
  getItemKey() {
    var fn = this.owner.getItemKey;
    if (typeof fn === "function") {
      return fn.apply(this.owner, arguments);
    }
  }
  getQueryCols() {
    var fn = this.owner.getQueryCols;
    if (typeof fn === "function") {
      return fn.apply(this.owner, arguments);
    }
  }
  hideDictList() {
    this._hasShow = false;
  }
  getClearBtn() {
    return this._clearBtn;
  }
  hideSuggestView() {
    if (!this._suggestViewShow)
      return;
    this.$suggestView.empty();
    this.$suggestView.hide();
    this._suggestViewShow = false;
  }
  // var cmbMousedown = function (self, e) {
  // document.addEventListener("touchmove", function (e) {
  //     var target = $(e.target);
  //     if (target.closest(self._dropView).length == 0
  //         && target.closest(self._dropBtn).length == 0 && !target.hasClass("clear")) {
  //         self._textView.blur();
  //     }
  // }, true);
  install() {
    var self2 = this;
    var openDropView = function() {
      self2._hasShow = true;
      self2._needShow = false;
      LoadingUtil.show(1);
      self2.checkDict().then(function(result) {
        if (result) {
          self2.getData(result);
        }
        LoadingUtil.hide();
        if (self2.view) {
          return self2.showing(self2.value);
        }
      }).catch(function(error) {
        self2._hasShow = false;
        throw error;
      });
    };
    this.dropArrow.$addListener("touchstart", function(e) {
      self2._needShow = !self2._hasShow;
    }).$click(function(e) {
      if (!self2.enable) {
        return;
      }
      if (!self2._hasShow) {
        openDropView();
      } else {
        self2.hideDictList();
      }
      e.stopPropagation();
    });
    var input = self2.getInput();
    input.$click(function(e) {
      if (self2.enable) {
        e.stopPropagation();
      }
    });
    input.$addListener("focus", (e) => {
      if (self2.enable) {
        self2._clearBtn.$addClass("show");
        if (self2.owner.multiSelect) {
          if (!self2._hasShow) {
            openDropView();
          } else {
            self2.hideDictList();
          }
        } else {
          self2.el.$addClass("line_focus");
          self2._textView.$addClass("focus");
          self2._isClickClearBtn = false;
        }
      }
    }).$addListener("focusout", async function(e) {
      if (self2._isClickClearBtn) {
        return;
      }
      self2.setPlaceholderVal();
      let text = self2._textView.getElm().value;
      await self2.autoComplete(text);
      self2._textView.$removeClass("focus");
      self2.el.$removeClass("line_focus");
      self2._clearBtn.$removeClass("show");
    });
    this._textView.$keydown(function(event2) {
      if (!self2.enable)
        return;
      switch (event2.keyCode || event2.charCode) {
        case 13:
        case 108:
          self2._textView.$blur();
      }
    });
    this._clearBtn.$addListener("touchstart", function(e) {
      if (self2.owner.promptText) {
        self2.setPromptText(self2.owner.promptText);
      } else {
        self2.setPromptText("");
      }
      self2._textView.$setInputValue("");
      self2._isClickClearBtn = true;
    }).$mouseup(function(e) {
      self2._textView.$focus();
    });
    this._clearBtn.$addListener("touchend", function(e) {
      self2._textView.$focus();
    });
  }
  createRootNodes(data) {
    var list = YElement.buildFromVNode(h("ul")), $view = this.$suggestView;
    if (data.length == 0) {
      let div = YElement.buildFromVNode(h("div"));
      let label = YElement.buildFromVNode(
        h("label.empty", I18N.getString("YESCOMBOBOX_NODATA", "无匹配数据"))
      );
      label.$appendTo(div);
      div.$appendTo($view);
      $view.$addClass("empty");
    } else {
      list.$appendTo($view);
      $view.hasClass("empty") ? $view.$removeClass("empty") : $view;
    }
    let cityObj = this.el.getElm();
    let rect = cityObj.getBoundingClientRect();
    $view.$addStyle("top", rect.top + rect.height + "px").$addStyle("left", rect.left + "px");
  }
  createNodes(data, parent) {
    const liClickHandler = async (node) => {
      const id = node.getAttr("id");
      const siblings = node.$parent().getChildElms().filter((vEl) => {
        return vEl.getAttr("id") !== id;
      });
      siblings.forEach((vEl) => {
        vEl.$removeClass("sel");
      });
      this._selectValue = this.getNodeValues(node);
      this.setValue(this._selectValue);
      try {
        var change = await this.commitValue(this.getValue());
      } catch (error) {
        throw error;
      }
      if (!change) {
        this.setShowText(this._temp);
      }
    };
    for (let i = 0, len = data.length; i < len; i++) {
      let item = data[i];
      let _li = YElement.buildFromVNode(
        h("li", {
          attrs: {
            id: "li_" + i,
            oid: item.oid,
            itemkey: item.itemKey,
            tabindex: "0"
          },
          on: {
            click: () => liClickHandler(_li)
          }
        })
      );
      YElement.buildFromVNode(h("div.dt-wholerow")).$appendTo(_li);
      let _a = YElement.buildFromVNode(h("a.dt-anchor")).$appendTo(_li);
      let _spanIcon = YElement.buildFromVNode(h("span.branch")).$appendTo(_a);
      if (item.NodeType == 1) {
        _spanIcon.$addClass("p_node");
      }
      if (item.Enable == 0) {
        _spanIcon.$addClass("disabled");
      } else if (item.Enable == -1) {
        _spanIcon.$addClass("invalid");
      }
      YElement.buildFromVNode(h("span.b-txt", item.caption)).$appendTo(_a);
      _li.$appendTo(parent);
    }
  }
  getQueryData(...arg) {
    var fn = this.owner.getQueryData;
    if (typeof fn === "function") {
      return fn.apply(this.owner, arguments);
    }
  }
  /**
   * 有值点击下拉，无选中框收缩，恢复原样
   */
  setPlaceholderVal() {
    let placeholder = this._textView.getAttr("placeholder") || "";
    let node = this._textView.getElm();
    let val = node.value;
    if (this.promptText) {
      if (placeholder != this.promptText && !val && this.getValue()) {
        node.value = placeholder;
      }
      this.setPromptText(this.promptText);
    } else {
      this.setPromptText("");
      if (!val && this.getValue() && placeholder) {
        node.value = placeholder;
      }
    }
  }
  /**
  * 移除根节点外的所有节点
  */
  reset() {
  }
  resetDropViewClass() {
  }
  async autoComplete(text) {
    if (!this.enable || this._suggestViewShow) {
      return;
    }
    if (this.owner.multiSelect) {
      if (this._needShow) {
        this.doFocusOut();
      }
      return;
    }
    if (this.owner.promptData) {
      this.hideSuggestView();
    }
    if (this._needShow) {
      this.setShowText(this._temp);
      return;
    }
    if (this._hasShow) {
      return;
    }
    let self2 = this;
    if (text != this._temp) {
      if (!text) {
        this.commitValue(null);
      } else {
        var change = await self2.checkDict();
        if (change) {
          self2.getData(change);
        }
        let data = await self2.getQueryData(0, self2.maxRows, self2.pageIndicatorCount, text, this.rootItem);
        var items = data.data;
        if (items.length == 1) {
          var itemData = new ItemData(items[0]);
          var isChange = await self2.commitValue(itemData);
          if (!isChange) {
            self2.setShowText(self2._temp);
          }
        } else {
          self2.setShowText(self2._temp);
          self2.setPromptText(self2.owner.promptText);
          self2.focus();
        }
      }
    } else {
      self2.doFocusOut();
    }
  }
  getNodeValues($node) {
    if ($node.length > 0) {
      var text = "";
      if ($node.getAttr("oid") >= 0) {
        text = $node.children("a").text();
      }
      var options = {};
      options["oid"] = $node.getAttr("oid") || 0;
      options["itemKey"] = $node.getAttr("itemKey");
      options["caption"] = text;
      var itemData = new ItemData(options);
      return itemData;
    }
  }
}
class YesMDict extends YesVBaseDict {
  constructor(options) {
    super(options);
  }
  getData(result) {
    this.rootCaption = result.rootCaption;
    this.rootItem = result.root;
    if (result.secondaryType == SecondaryType.CHAINDICT) {
      this.view = new YesVDictTable({
        editor: this
      });
    } else {
      this.view = new YesVDictTree({
        editor: this
      });
    }
    var self2 = this;
    this.view.getTreePath = function() {
      return self2.getTreePath.apply(self2, arguments);
    };
    this.view.getDictChildren = function() {
      return self2.getDictChildren.apply(self2, arguments);
    };
    this.view.getDisplayCols = function() {
      return self2.getDisplayCols.apply(self2, arguments);
    };
    this.view.getQueryData = function() {
      return self2.getQueryData.apply(self2, arguments);
    };
    this.view.getAllItems = function() {
      return self2.getAllItems.apply(self2, arguments);
    };
    this.view.commitValue = function(value) {
      self2.commitValue(value);
    };
    this.view.hideView = function() {
      self2.hideDictList();
    };
    this.view.render();
  }
  destroy() {
    super.destroy();
  }
  showing(value) {
    return this.view.showing(value);
  }
  getDictChildren() {
    var fn = this.owner.getDictChildren;
    if (typeof fn === "function") {
      return fn.apply(this.owner, arguments);
    }
  }
  getQueryData() {
    var fn = this.owner.getQueryData;
    if (typeof fn === "function") {
      return fn.apply(this.owner, arguments);
    }
  }
  getTreePath() {
    var fn = this.owner.getTreePath;
    if (typeof fn === "function") {
      return fn.apply(this.owner, arguments);
    }
  }
  getDisplayCols() {
    var fn = this.owner.getDisplayCols;
    if (typeof fn === "function") {
      return fn.apply(this.owner, arguments);
    }
  }
  endEdit() {
    var fn = this.owner.endEdit;
    if (typeof fn === "function") {
      return fn.apply(this.owner, arguments);
    }
  }
  getAllItems() {
    var fn = this.owner.getAllItems;
    if (typeof fn === "function") {
      return fn.apply(this.owner, arguments);
    }
  }
}
const buildVNode$2 = YElement.buildFromVNode;
const formatAsyncData$3 = (datas) => {
  datas.forEach((val, i) => {
    var id = val.itemKey + "_" + val.OID;
    val.id = id;
    if (val.items && val.items.length > 0) {
      formatAsyncData$3(val.items);
    }
  });
  return datas;
};
const ToObject = (values) => {
  let obj = {};
  values && values.forEach((val) => {
    obj[val.itemKey + "_" + val.oid] = val;
  });
  return obj;
};
const ToArray = (checkedNodes) => {
  var values = [];
  for (const key in checkedNodes) {
    values.push(checkedNodes[key]);
  }
  return values;
};
class YesVDictCheckedTable {
  constructor(options) {
    this.editor = options.editor;
    this.startRow = 0;
    this.pageMaxNum = options.pageMaxNum || 30;
    this.pageIndicatorCount = options.pageIndicatorCount || 1;
    this.needLoad = true;
    this.el = options.editor.el;
    this.checkedNodes = {};
  }
  render() {
    this.dt = buildVNode$2(h("div.dicttable"));
    var wrap = buildVNode$2(h("div.dicttable-wrap")).$appendTo(this.dt);
    this._input = buildVNode$2(h("input.dicttable-txt")).$appendTo(wrap);
    this._input.$setAttr("placeholder", I18N.getString("DICT_KEYWORD", "请输入关键字"));
    var _info = buildVNode$2(h("div.chaindict-info")).$appendTo(this.dt);
    this._infoItem = buildVNode$2(h("span.item.sel")).$appendTo(_info);
    this._infoItem.$setInnerText(I18N.getString("DICT_OPTIONS", "选项"));
    this._infoSelItem = buildVNode$2(h("span.selectItem")).$appendTo(_info);
    this._infoSelItem.$setInnerText(I18N.getString("DICT_SELECTED", "已选") + I18N.getString("DICT_ITEM", "项"));
    this._infoItemline = buildVNode$2(h("span.item_line.info")).$appendTo(_info);
    this.bodyView = buildVNode$2(h("div.dicttable-view")).$appendTo(this.dt);
    this._itemsView = buildVNode$2(h("div.dicttable-items.show")).$appendTo(this.bodyView);
    this._itemsView.$scroll(this.scroll.bind(this));
    this._selectItemView = buildVNode$2(h("div.chainSelect.hide")).$appendTo(this.bodyView);
    var _btns = buildVNode$2(h("div.chaindict-btns")).$appendTo(this.dt);
    this._clearBtn = buildVNode$2(h("button.chaindict-clearBtn", {}, I18N.getString("DICT_EMPTY", "清空"))).$appendTo(_btns);
    this._sure = buildVNode$2(h("button.chaindict-sure", {}, I18N.getString("CURRENCY_OK", "确定"))).$appendTo(_btns);
  }
  createRootNode() {
  }
  scroll(e) {
    if (!this.needLoad || this.loading) {
      return;
    }
    let scrollTop = this._itemsView.getElm().scrollTop;
    var clientHeight = this._itemsView.getElm().clientHeight;
    var scrollHeight = this._itemsView.getElm().scrollHeight;
    var self2 = this;
    if (Math.ceil(scrollTop + clientHeight) >= scrollHeight) {
      self2.startRow += self2.pageMaxNum;
      self2.loadData(self2.dt);
    }
  }
  /**
   * 清空搜索框
   */
  clearSearchInput() {
    this._input.$setInputValue("");
    this.fuzzyValue = null;
  }
  checkDisplayCols() {
    return new Promise((resolve) => {
      if (this.columns) {
        resolve(this.columns);
      } else {
        var self2 = this;
        this.getDisplayCols().then(function(columns) {
          self2.columns = columns;
          resolve(columns);
        });
      }
    });
  }
  async showing(value) {
    this.clearSearchInput();
    this.checkedNodes = ToObject(value);
    var self2 = this;
    await self2.checkDisplayCols();
    await self2.loadData(self2.dt);
    this.showSelItemView();
    self2.doPop();
    self2.install();
  }
  loadData(nodeEl) {
    if (!nodeEl) {
      nodeEl = this.dt;
    }
    var nodeValue = this.getNodeValue(nodeEl);
    this.needLoad = false;
    var data = [];
    let self2 = this;
    return this.getQueryData(
      this.startRow,
      this.pageMaxNum,
      this.pageIndicatorCount,
      this.fuzzyValue,
      nodeValue
    ).then(function(_data) {
      data = _data.data;
      self2.addNodes(data);
    }).finally(function() {
      self2.needLoad = data.length < self2.pageMaxNum ? false : true;
    });
  }
  addNodes(nodes) {
    if (nodes) {
      var syncNodes = formatAsyncData$3(nodes);
      this.buildNode(syncNodes);
    }
  }
  /**
   * 移除根节点外的所有节点
   */
  reset() {
    this.dt.$findByClassName("dicttable-item").forEach((el) => el.$remove());
  }
  /** 构建树结构 */
  buildNode(nodes) {
    if (!nodes || nodes.length == 0) {
      this.reset();
    }
    this.addChildNodes(nodes);
  }
  /**
   * 根据父节点 添加子节点
   * @param {} nodes
   * @param {} pNodeKey
   */
  addChildNodes(nodes) {
    if (nodes && this.startRow == 0) {
      this._itemsView.$empty();
    }
    if (nodes.length == 0) {
      buildVNode$2(h("div.dict-nochange", {}, I18N.getString("YESCOMBOBOX_NODATA", "无匹配数据"))).$appendTo(this._itemsView);
    }
    let node, item, enable;
    for (let i = 0; i < nodes.length; i++) {
      node = nodes[i];
      enable = node.Enable || 0;
      item = buildVNode$2(h("div.dicttable-item")).$appendTo(this._itemsView);
      buildVNode$2(h("span.dicttable-item-icon")).$appendTo(item);
      buildVNode$2(h("label", {}, node.caption)).$appendTo(item);
      item.$setAttr("itemKey", node.itemKey);
      item.$setAttr("oid", node.oid);
      item.$setAttr("enable", enable);
      item.$setAttr("id", node.itemKey + "_" + node.oid);
      switch (enable) {
        case DictState.Enable:
          item.$addClass("enable");
          break;
        case DictState.Disable:
          item.$addClass("disable");
          break;
        case DictState.Discard:
          item.$addClass("discard");
          break;
      }
      var pnid = node.itemKey + "_" + node.oid;
      if (this.checkedNodes[pnid]) {
        item.$addClass("sel");
      }
      let self2 = this;
      item.$click(function(e) {
        let $node = buildVNode$2(this);
        if ($node.hasClass("disableSelect"))
          return;
        let _id = $node.getAttr("id");
        if ($node.hasClass("sel")) {
          $node.$removeClass("sel");
          delete self2.checkedNodes[_id];
        } else {
          $node.$addClass("sel");
          self2.checkedNodes[_id] = self2.getNodeValue($node);
        }
      });
    }
  }
  checkboxClick($node) {
    if ($node.hasClass("disableSelect")) {
      return;
    }
    var isSelect = $node.hasClass("sel");
    var id = $node.getAttr("select_id");
    if (isSelect) {
      $node.$removeClass("sel");
      delete this.checkedNodes[id];
      this._itemsView.$findById(id).$removeClass("sel");
    } else {
      $node.$addClass("sel");
      this.checkedNodes[id] = this.getNodeValue($node);
      this._itemsView.$findById(id).$addClass("sel");
    }
  }
  doPop() {
    let self2 = this;
    var setting = {
      el: this.dt,
      dir: "right",
      className: "dictviewpop",
      closeCallBack: function() {
        self2.startRow = 0;
        self2.dt.$remove();
        self2.hideView();
        self2.el.$removeClass("on");
        self2._clearBtn.$removeListener("click", self2._clearBtn.clearBtnFn);
        self2._sure.$removeListener("click", self2._sure.sureFn);
      }
    };
    switch (this.editor.owner.editType) {
      case 1:
        setting["dir"] = "center";
        setting["size"] = "80% 372";
        break;
      case 0:
        setting["dir"] = "bottom";
        setting["size"] = "100% 372";
        break;
      case 3:
        setting["dir"] = "drop";
        setting["size"] = "70% 320";
        setting["dom"] = this.el.getElm();
        break;
      default:
        setting["dir"] = "right";
        setting["size"] = "100% 100%";
        setting["fullScreenNavBar"] = true;
        setting["navCaption"] = this.editor.owner.promptText || "侧滑";
        break;
    }
    setting.ziBase = this.editor.owner.getZIndex("control");
    this.dictpopupview = new Popup(setting);
    this.el.$addClass("on");
    this.dictpopupview.show();
  }
  getNodeValue($node) {
    var text = "";
    if ($node.getAttr("oid") >= 0) {
      var caption = [];
      caption.push($node.$findByTagName("label")[0].getInnerText());
      text = caption.join(" ");
    }
    var options = {};
    options["oid"] = $node.getAttr("oid") || 0;
    options["itemKey"] = $node.getAttr("itemKey");
    options["caption"] = text;
    return new ItemData(options);
  }
  addSelectNodes(nodes) {
    this._selectItemView.$empty();
    for (var i = 0; i < nodes.length; i++) {
      this.addSelectNode(nodes[i]);
    }
  }
  addSelectNode(node) {
    let self2 = this;
    var enable = node.enable || 0;
    var item = buildVNode$2(h("span.chain-selItem.sel")).$appendTo(this._selectItemView);
    var label = buildVNode$2(h("label")).$appendTo(item);
    label.$setInnerText(node.caption);
    item.$setAttr("itemKey", node.itemKey);
    item.$setAttr("oid", node.oid);
    item.$setAttr("enable", enable);
    item.$setAttr("select_id", node.itemKey + "_" + node.oid);
    item.$click(function() {
      let _item = buildVNode$2(this);
      self2.checkboxClick(_item);
    });
  }
  showItemView() {
    if (this._selectItemView.hasClass("show"))
      return;
    this._infoItem.$removeClass("sel");
    this._infoSelItem.$addClass("sel");
    this._infoItemline.$addClass("infosel").$removeClass("info");
    this._itemsView.$removeClass("show").$addClass("hide");
    this.addSelectNodes(ToArray(this.checkedNodes));
    this._selectItemView.$removeClass("hide").$addClass("show");
  }
  showSelItemView() {
    if (this._itemsView.hasClass("show"))
      return;
    this._infoItem.$addClass("sel");
    this._infoSelItem.$removeClass("sel");
    this._infoItemline.$addClass("info").$removeClass("infosel");
    this._itemsView.$removeClass("hide").$addClass("show");
    this._selectItemView.$removeClass("show").$addClass("hide");
  }
  install() {
    var self2 = this;
    self2._sure.sureFn = function() {
      self2._clearBtn.$removeListener("click", self2._clearBtn.clearBtnFn);
      self2._sure.$removeListener("click", self2._sure.sureFn);
      self2.commitValue(ToArray(self2.checkedNodes));
      self2.dictpopupview.hide();
      self2.el.$removeClass("on");
      self2.startRow = 0;
      self2.hideView();
    };
    self2._clearBtn.clearBtnFn = function() {
      self2._clearBtn.$removeListener("click", self2._clearBtn.clearBtnFn);
      self2._sure.$removeListener("click", self2._sure.sureFn);
      self2._itemsView.$findByClassName("dicttable-item").forEach((el) => {
        el.$removeClass("sel");
      });
      self2.checkedNodes = null;
      self2.dictpopupview.hide();
      self2.startRow = 0;
      self2.el.$removeClass("on");
      self2.commitValue(null);
      self2.hideView();
    };
    this._clearBtn.$addListener("click", self2._clearBtn.clearBtnFn);
    this._sure.$addListener("click", self2._sure.sureFn);
    this._input.$addListener("focus", function(e) {
      self2.showSelItemView();
    });
    this._input.$addListener("blur", function(e) {
      var value = self2._input.getElm().value;
      self2.fuzzyValue = value;
      self2.startRow = 0;
      return self2.loadData(self2.dt);
    });
    this._input.$keydown(function(e) {
      var keyCode = e.keyCode;
      if (keyCode == 13) {
        buildVNode$2(this).$blur();
      }
    });
    this._infoItem.$click(function(e) {
      self2.showSelItemView();
    });
    this._infoSelItem.$click(function(e) {
      self2.showItemView();
    });
    let touchmove = false, startX, startY, diffX, diffY;
    this.bodyView.$addListener("touchstart", (e) => {
      var touch = e.changedTouches[0];
      startX = touch.pageX;
      startY = touch.pageY;
      touchmove = false;
    });
    this.bodyView.$addListener("touchmove", (e) => {
      var touch = e.changedTouches[0];
      var endX = touch.pageX;
      var endY = touch.pageY;
      diffX = endX - startX;
      diffY = endY - startY;
      touchmove = true;
    });
    this.bodyView.$addListener("touchend", (event2) => {
      if (!touchmove)
        return;
      if (Math.abs(diffX) - Math.abs(diffY) < 0) {
        return;
      }
      if (diffX < 5) {
        this.showItemView();
      } else if (diffX > 5) {
        this.showSelItemView();
      }
    });
  }
}
const buildVNode$1 = YElement.buildFromVNode;
const formatAsyncData$2 = (datas) => {
  datas.forEach((val, i) => {
    var id = val.itemKey + "_" + (val.OID || 0);
    val.id = id;
    if (val.items && val.items.length > 0) {
      formatAsyncData$2(val.items);
    }
  });
  return datas;
};
const collapseNode = function(node) {
  var _a;
  (_a = node.$findByTagName("ul")[0]) == null ? void 0 : _a.$hide();
  var $arrow = node.$findByTagName("span")[0];
  $arrow.$removeClass("dt-expand").$addClass("dt-collapse");
  let nextNode = $arrow.$next();
  if (nextNode.hasClass("dt-anchor")) {
    var branch = nextNode.$findByTagName("branch")[0];
    if (branch)
      branch.$removeClass("b-expand").$addClass("b-collapse");
  }
};
const allowClickHandler = function(self2, allow, li) {
  if (allow.hasClass("dt-collapse")) {
    expandNode(self2, li);
    return;
  }
  if (allow.hasClass("dt-expand")) {
    collapseNode(li);
  }
};
class YesVDictCheckedTree {
  constructor(options) {
    this.dt = buildVNode$1(h("div.dicttree.dt-vw"));
    this.editor = options.editor;
    this.el = options.editor.el;
    this._pMap = {};
    this.checkedNodes = {};
    this.independent = this.editor.owner && this.editor.owner.independent;
  }
  render() {
    let self2 = this;
    this._itemsView = buildVNode$1(h("div.dicttree-items")).$appendTo(this.dt);
    var _btns = buildVNode$1(h("div.chaindict-btns")).$appendTo(this.dt);
    this._clearBtn = buildVNode$1(h("button.chaindict-clearBtn", {
      on: {
        click: function() {
          self2.checkedNodes = {};
          self2.dictpopupview.hide();
          self2.el.$removeClass("on");
          self2.commitValue(null);
          self2.hideView();
        }
      }
    }, I18N.getString("DICT_EMPTY", "清空"))).$appendTo(_btns);
    this._sure = buildVNode$1(h("button.chaindict-sure", {
      on: {
        click: function() {
          self2.commitValue(self2.getCheckedValues());
          self2.dictpopupview.hide();
          self2.el.$removeClass("on");
          self2.startRow = 0;
          self2.hideView();
        }
      }
    }, I18N.getString("CURRENCY_OK", "确定"))).$appendTo(_btns);
  }
  clearSelectedNode() {
  }
  /**
   * 创建根节点
   * @param {} itemKey
   * @param {} nodeKey
   * @param {} name
   */
  renderRootNode() {
    let { itemKey, oid } = this.editor.rootItem;
    let _this = this;
    var _li = YElement.buildFromVNode(h("li.root", {
      attrs: { id: itemKey + "_" + oid, oid, itemKey, level: -1, comp_Level: 1 }
    })).$appendTo(this._itemsView);
    this.rootArrow = YElement.buildFromVNode(h("span.icon.dt-expand", {
      on: {
        click: () => allowClickHandler(this, this.rootArrow, _li)
      }
    })).$appendTo(_li);
    YElement.buildFromVNode(h("span.dt-chk.chkstate0", {
      attrs: { chkstate: 0 },
      on: {
        click: function() {
          let $node = YElement.buildFromVNode(this).$parent();
          if (!$node.hasClass("disableSelect")) {
            _this.checkboxClick($node);
          }
        }
      }
    })).$appendTo(_li);
    var _a = YElement.buildFromVNode(h("a.dt-anchor")).$appendTo(_li);
    YElement.buildFromVNode(h("a.branch.b-expand")).$appendTo(_a);
    let btxt = YElement.buildFromVNode(h("span.b-txt")).$appendTo(_a);
    btxt.$setInnerText(this.editor.rootCaption);
    YElement.buildFromVNode(h("ul.dt-ul")).$appendTo(_li);
    this.rootNode = _li;
  }
  selectNode(node) {
    this.commitValue(this.getNodeValue(node));
    this.dictpopupview.hide();
    this.el.$removeClass("on");
    this.hideView();
  }
  checkDisplayCols() {
    return new Promise((resolve) => {
      if (this.columns) {
        resolve(this.columns);
      } else {
        var self2 = this;
        this.getDisplayCols().then(function(columns) {
          self2.columns = columns;
          resolve(columns);
        });
      }
    });
  }
  renderLevelNodebyValue(nodes) {
    var i = 1;
    var self2 = this;
    var renderNodes = async function(value, i2) {
      if (value[i2]) {
        let item;
        self2._itemsView.$findByClassName("item").forEach((_item) => {
          if (_item.getAttr("oid") == value[i2]["oid"]) {
            item = _item;
          }
        });
        if (item) {
          await expandNode(self2, item);
          value[i2 + 1] && renderNodes(value, i2 + 1);
        }
      }
    };
    renderNodes(nodes[0], i);
  }
  async showing(value) {
    let def;
    this.renderRootNode();
    if (value) {
      setDictTreeCheckedNodes(self, value);
      def = await this.setSelectionValue(value);
    }
    if (!def) {
      def = expandNode(this, this.rootNode);
    }
    this.doPopup();
    return def;
  }
  setSelectionValue(value) {
    var self2 = this;
    var _expand = async function(tree, parents, index) {
      if (parents) {
        if (index < parents.length) {
          var oid = parents[index].oid;
          if (parents) {
            var $node = self2.dt.$find((vEl) => vEl.getAttr("oid") == oid)[0];
            if ($node) {
              await expandNode(tree, $node);
              await _expand(tree, parents, index + 1);
            }
          }
        }
      }
    };
    return self2.getTreePath(value).then(async function(paths) {
      var len = paths.length;
      if (len > 0) {
        for (var i = 0; i < len; i++) {
          await _expand(self2, paths[i], 0);
        }
      } else {
        await expandNode(self2, self2.rootNode);
      }
      return true;
    }).then(function() {
      self2.setSelectedNode(value);
    });
  }
  setSelectedNode(value) {
    var self2 = this;
    for (var i = 0, len = value.length; i < len; i++) {
      var node = self2.dt.$find((vEl) => {
        return vEl.getAttr("oid") == value[i].oid;
      })[0];
      if (!node) {
        if (!self2.independent)
          self2.clearChkNodes = true;
      } else {
        checkTreeNode(self2, node, 1);
      }
    }
  }
  addTreeNodes(node, nodes) {
    var _this = this;
    if (!node.getAttr("isLoaded")) {
      if (nodes && nodes.length > 0) {
        var syncNodes = formatAsyncData$2(nodes);
        _this.addNodes(syncNodes, node, parseInt(node.getAttr("level")) + 1);
        node.$setAttr("isLoaded", true);
      }
    }
  }
  /**
   * 收拢节点
   */
  collapseNode(node) {
    node.$findByTagName("ul")[0] && node.$findByTagName("ul")[0].$hide();
    var $arrow = node.$findByTagName("span")[0];
    $arrow.$removeClass("dt-expand").$addClass("dt-collapse");
    $arrow.$next().$next().$findByClassName("branch")[0].$removeClass("b-expand").$addClass("b-collapse");
  }
  checkboxClick($node) {
    if ($node.hasClass("disableSelect"))
      return;
    if (this.clearChkNodes) {
      this.checkedNodes = {};
    }
    var state = $node.$findByClassName("dt-chk")[0].getAttr("chkstate") == 0 ? 1 : 0;
    checkTreeNode(this, $node, state);
    var nodeKey = $node.getAttr("id");
    if (state == 1) {
      this.checkedNodes[nodeKey] = this.getNodeValue($node);
    } else {
      delete this.checkedNodes[nodeKey];
    }
    this.clearChkNodes = false;
  }
  /**
    * 根据父节点 添加子节点
    * @param {} nodes
    * @param {} pNodeKey
    */
  addNodes(nodes, pNode, level) {
    var pNodeKey = pNode.getAttr("id");
    if (nodes.length <= 0) {
      pNode.$findByTagName("span")[0].$removeClass("dt-collapse");
      return;
    }
    pNode.$setAttr("isLoaded", true);
    var node, nid, oid, itemKey;
    this._pMap[pNodeKey] || (this._pMap[pNodeKey] = []);
    var _pul = pNode.$findByTagName("ul")[0];
    if (!_pul || _pul.length == 0) {
      _pul = YElement.buildFromVNode(h("ul.dt-ul")).$appendTo(pNode);
    }
    for (var i = 0, len = nodes.length; i < len; i++) {
      node = nodes[i];
      nid = node.id;
      oid = node.OID;
      itemKey = node.itemKey;
      if (!this._pMap[pNodeKey].includes(nid)) {
        this._pMap[pNodeKey].push(nid);
      }
      var _li = YElement.buildFromVNode(h("li.item", {
        attrs: { id: nid, oid, parentid: pNodeKey, itemKey, level }
      }));
      var pItemKey = pNode.getAttr("itemKey");
      var comp_Level = parseInt(pNode.getAttr("comp_Level"));
      if (itemKey != pItemKey) {
        comp_Level += 1;
      }
      _li.$setAttr("comp_Level", comp_Level);
      var comp_css = "level comp_Level" + comp_Level;
      if (node.disableSelect) {
        comp_css += " disableSelect";
      }
      _li.$addClass(comp_css);
      var _span, _this = this;
      var _a = YElement.buildFromVNode(h("a.dt-anchor"));
      var _explore = YElement.buildFromVNode(h("span"));
      var css_name = "";
      _span = YElement.buildFromVNode(h("span", {
        on: {
          click: async function(e) {
            e.stopPropagation();
            let $item = YElement.buildFromVNode(this);
            let $node = $item.$parent();
            if ($item.hasClass("dt-collapse")) {
              await expandNode(_this, $item.$parent());
              return;
            }
            if ($item.hasClass("dt-expand")) {
              await _this.collapseNode($node);
              return;
            }
          }
        }
      }));
      if (node.NodeType == 1) {
        if (node.open) {
          _span.$addClass("icon dt-expand");
          css_name = "branch b-expand";
        } else {
          _span.$addClass("icon dt-collapse");
          css_name = "branch b-collapse";
        }
        _li.$append(_span);
      } else {
        _span.$addClass("icon");
        _li.$append(_span);
        css_name = "branch";
      }
      _a.$append(_explore);
      switch (node.Enable) {
        case DictState.Enable:
          css_name += " enable";
          break;
        case DictState.Disable:
          css_name += " disable";
          break;
        case DictState.Discard:
          css_name += " discard";
          break;
      }
      _explore.$addClass(css_name);
      let _chk = YElement.buildFromVNode(h("span.dt-chk", {
        on: {
          click: function(e) {
            let $node = YElement.buildFromVNode(this);
            _this.checkboxClick($node.$parent());
            e.stopPropagation();
          }
        }
      }));
      _li.$append(_chk);
      var _selectNode = YElement.buildFromVNode(h("span.b-txt"));
      var caption = !node.caption ? "" : node.caption;
      _selectNode.$setInnerText(caption);
      let p_state = pNode.$findByClassName("dt-chk", 2)[0].getAttr("chkstate");
      let chkstate = 0;
      if (nid in this.checkedNodes) {
        chkstate = 1;
      }
      if (this.indeterminatedNodes == null) {
        this.indeterminatedNodes = [];
      }
      if (!this.independent && nid in this.indeterminatedNodes) {
        chkstate = 2;
      }
      if (chkstate == 0 && !this.independent && pNode) {
        p_state = p_state || 0;
        if (p_state == 1) {
          chkstate = 1;
        }
      }
      _chk.$setAttr("chkstate", chkstate).$addClass("chkstate" + chkstate);
      _a.$append(_selectNode);
      _li.$append(_a);
      _pul.$append(_li);
    }
  }
  doPopup() {
    let self2 = this;
    var setting = {
      el: this.dt,
      dir: "right",
      className: "dictviewpop",
      closeCallBack: function() {
        self2.checkedNodes = {};
        self2._itemsView.getChildElms().forEach((el) => el.$remove());
        self2.hideView();
        self2.el.$removeClass("on");
      }
    };
    switch (this.editor.owner.editType) {
      case 1:
        setting["dir"] = "center";
        setting["size"] = "80% 285";
        break;
      case 0:
        setting["dir"] = "bottom";
        setting["size"] = "100% 285";
        break;
      case 3:
        setting["dir"] = "drop";
        setting["size"] = "70% 285";
        setting["dom"] = this.el.getElm();
        break;
      default:
        setting["dir"] = "right";
        setting["size"] = "100% 100%";
        setting["fullScreenNavBar"] = true;
        setting["navCaption"] = this.editor.owner.promptText || "侧滑";
        break;
    }
    setting.ziBase = this.editor.owner.getZIndex("control");
    this.dictpopupview = new Popup(setting);
    this.el.$addClass("on");
    this.dictpopupview.show();
  }
  /**
   * 移除根节点外的所有节点
   */
  reset() {
    this.dt.$findByClassName("dicttree-item").forEach((el) => el.$remove());
  }
  getNodeValue($node) {
    if (!$node)
      return;
    var text = "";
    if ($node.getAttr("oid") >= 0) {
      var caption = [], label = $node.$findByClassName("dt-chk")[0];
      if (label) {
        caption.push(label.getInnerText());
        text = caption.join(" ");
      }
    }
    var options = {};
    options["oid"] = $node.getAttr("oid") || 0;
    options["itemKey"] = $node.getAttr("itemKey");
    options["caption"] = text;
    return new ItemData(options);
  }
  getCheckedValues() {
    var dictTree = this;
    var values = [];
    if (dictTree.rootNode) {
      var rootId = dictTree.rootNode.getAttr("id");
      if (rootId in dictTree.checkedNodes && !this.independent) {
        values.push(dictTree.getNodeValue(dictTree.rootNode));
        return values;
      }
    }
    for (const key in dictTree.checkedNodes) {
      let val = dictTree.checkedNodes[key];
      var $node = dictTree.dt.$findById(key);
      if (!this.independent) {
        var pId = $node.getAttr("parentid");
        var $pNode = dictTree.dt.$findById(pId);
        if ($pNode) {
          var chkstate = $pNode.$findByClassName("dt-chk")[0].getAttr("chkstate") || 0;
          if (chkstate != 1) {
            values.push(val);
          }
        } else {
          values.push(val);
        }
      } else {
        values.push(val);
      }
    }
    return values;
  }
}
const setDictTreeCheckedNodes = function(self2, value) {
  let checkedNodes = {};
  if (value) {
    value.forEach((item) => {
      let nodeId = item.itemKey + "_" + item.oid;
      checkedNodes[nodeId] = item;
    });
  }
  self2.checkedNodes = checkedNodes;
};
const expandNode = async function(self2, node) {
  var $arrow = node.$findByTagName("span")[0];
  if ($arrow.hasClass("dt-collapse")) {
    $arrow.$removeClass("dt-collapse").$addClass("dt-arrowgif");
  }
  if (!node.getAttr("isLoaded")) {
    await self2.getDictChildren(self2.getNodeValue(node)).then(function(data) {
      var nodes = data.data;
      var $arrow2 = node.$findByTagName("span")[0];
      if (nodes.length == 0) {
        $arrow2.$removeClass("dt-arrowgif");
        $arrow2.$addClass("dt-collapse");
      }
      self2.addTreeNodes(node, nodes);
    });
  }
  node.$findByTagName("ul")[0] && node.$findByTagName("ul")[0].$show();
  var $arrow = node.$findByTagName("span")[0];
  if ($arrow.hasClass("dt-arrowgif")) {
    $arrow.$removeClass("dt-arrowgif").$addClass("dt-expand");
    $arrow.$next().$next().$findByClassName("branch")[0].$removeClass("b-collapse").$addClass("b-expand");
  } else if ($arrow.hasClass("dt-collapse")) {
    $arrow.$removeClass("dt-collapse").$addClass("dt-expand");
    $arrow.$next().$next().$findByClassName("branch")[0].$removeClass("b-collapse").$addClass("b-expand");
  }
  return;
};
const checkTreeNode = function(tree, $node, checkstate) {
  function checkChildNode($pNode, checkstate2) {
    var pChkBox = $pNode.$findByClassName("dt-chk")[0];
    pChkBox.$removeClass("chkstate" + pChkBox.getAttr("chkstate"));
    pChkBox.$setAttr("chkstate", checkstate2);
    pChkBox.$addClass("chkstate" + checkstate2);
    if (checkstate2 != 2) {
      var pNodeKey = $pNode.getAttr("id");
      tree._pMap[pNodeKey] || (tree._pMap[pNodeKey] = []);
      for (var i = 0; i < tree._pMap[pNodeKey].length; i++) {
        var cId = tree._pMap[pNodeKey][i];
        var $child = tree.dt.$findById(cId);
        if (checkstate2 == 0) {
          delete tree.checkedNodes[cId];
        }
        $child && checkChildNode($child, checkstate2);
      }
    }
  }
  function checkSiblingsNode($node2) {
    var siBlingsNodes = $node2.$parent().getChildElms();
    for (var i = 0; i < siBlingsNodes.length; i++) {
      var $sNode = siBlingsNodes[i];
      var checkState = $sNode.$findByClassName("dt-chk")[0].getAttr("chkstate");
      if (checkState == "1") {
        var _id = $sNode.getAttr("id");
        tree.checkedNodes[_id] = tree.getNodeValue($sNode);
      }
    }
  }
  function checkParentNode($cNode, checkstate2) {
    var pId = $cNode.getAttr("parentid");
    if (!pId)
      return;
    var $pNode = tree.dt.$findById(pId);
    checkSiblingsNode($pNode);
    var pChkBox = $pNode.$findByClassName("dt-chk")[0];
    if (checkstate2 == 2) {
      pChkBox.$removeClass("chkstate" + pChkBox.getAttr("chkstate"));
      pChkBox.$setAttr("chkstate", 2);
      pChkBox.$addClass("chkstate2");
      checkParentNode($pNode, 2);
    } else if (checkstate2 == 1) {
      tree._pMap[pId] || (tree._pMap[pId] = []);
      var diffstate = false;
      for (var i = 0; i < tree._pMap[pId].length; i++) {
        var cId = tree._pMap[pId][i];
        var $child = tree.dt.$findById(cId);
        if ($child) {
          var check = $child.$findByClassName("dt-chk", 2)[0].getAttr("chkstate") || 0;
          if (check != checkstate2) {
            diffstate = true;
            break;
          }
        }
      }
      if (diffstate) {
        checkstate2 = 2;
      }
      pChkBox.$removeClass("chkstate" + pChkBox.getAttr("chkstate"));
      pChkBox.$setAttr("chkstate", checkstate2);
      pChkBox.$addClass("chkstate" + checkstate2);
      checkParentNode($pNode, checkstate2);
    } else {
      var pChkState = pChkBox.getAttr("chkstate") || 0;
      var curId = $cNode.getAttr("id");
      if (pChkState == 1) {
        var len = tree._pMap[pId].length;
        if (len == 1) {
          checkstate2 = 0;
        } else {
          for (var i = 0; i < tree._pMap[pId].length; i++) {
            var cId = tree._pMap[pId][i];
            if (cId == curId) {
              continue;
            }
            var $child = tree.dt.$findById(cId);
            tree.checkedNodes[cId] = tree.getNodeValue($child);
          }
          checkstate2 = 2;
        }
        pChkBox.$removeClass("chkstate" + pChkBox.getAttr("chkstate"));
        pChkBox.$setAttr("chkstate", checkstate2);
        pChkBox.$addClass("chkstate" + checkstate2);
      } else if (pChkState == 2) {
        var diffstate = true;
        for (var i = 0; i < tree._pMap[pId].length; i++) {
          var cId = tree._pMap[pId][i];
          var $child = tree.dt.$findById(cId);
          if ($child) {
            var check = $child.$findByClassName("dt-chk")[0].getAttr("chkstate") || 0;
            if (check != checkstate2) {
              diffstate = false;
              break;
            }
          }
        }
        if (diffstate) {
          checkstate2 = 0;
          pChkBox.$removeClass("chkstate" + pChkBox.getAttr("chkstate"));
          pChkBox.$setAttr("chkstate", checkstate2);
          pChkBox.$addClass("chkstate" + checkstate2);
        }
      }
      checkParentNode($pNode, checkstate2);
    }
    if (checkstate2 == 1) {
      tree.checkedNodes[pId] = tree.getNodeValue($pNode);
    } else {
      delete tree.checkedNodes[pId];
    }
  }
  var id = $node.getAttr("id");
  if (checkstate == 1) {
    tree.checkedNodes[id] = tree.getNodeValue($node);
  } else {
    delete tree.checkedNodes[id];
  }
  if (!tree.independent) {
    checkChildNode($node, checkstate);
    checkParentNode($node, checkstate);
    checkSiblingsNode($node);
  } else {
    var $chk = $node.$findByClassName("dt-chk")[0];
    $chk.$removeClass("chkstate" + $chk.getAttr("chkstate"));
    $chk.$setAttr("chkstate", checkstate);
    $chk.$addClass("chkstate" + checkstate);
  }
};
class YesMultiSelectDict extends YesVBaseDict {
  constructor(options) {
    super(options);
  }
  getData(result) {
    this.rootCaption = result.rootCaption;
    this.rootItem = result.root;
    if (result.secondaryType == SecondaryType.CHAINDICT) {
      this.view = new YesVDictCheckedTable({
        editor: this
      });
    } else {
      this.view = new YesVDictCheckedTree({
        editor: this
      });
    }
    var self2 = this;
    this.view.getTreePath = function() {
      return self2.getTreePath.apply(self2, arguments);
    };
    this.view.getDictChildren = function() {
      return self2.getDictChildren.apply(self2, arguments);
    };
    this.view.getDisplayCols = function() {
      return self2.getDisplayCols.apply(self2, arguments);
    };
    this.view.getQueryData = function() {
      return self2.getQueryData.apply(self2, arguments);
    };
    this.view.commitValue = function(value) {
      self2.commitValue(value);
    };
    this.view.hideView = function() {
      self2.hideDictList();
    };
    this.view.render();
  }
  destroy() {
  }
  showing(value) {
    return this.view.showing(value);
  }
  getDictChildren() {
    var fn = this.owner.getDictChildren;
    if (typeof fn === "function") {
      return fn.apply(this.owner, arguments);
    }
  }
  getTreePath() {
    var fn = this.owner.getTreePath;
    if (typeof fn === "function") {
      return fn.apply(this.owner, arguments);
    }
  }
  getDisplayCols() {
    var fn = this.owner.getDisplayCols;
    if (typeof fn === "function") {
      return fn.apply(this.owner, arguments);
    }
  }
}
class YesDictBuilder extends YesComponentBuilder {
  static create(options) {
    var com;
    if (options.multiSelect) {
      com = new YesMultiSelectDict(options);
    } else {
      com = new YesMDict(options);
    }
    return com;
  }
}
class YesVDictSearchBox extends YesMDict {
  constructor(options) {
    options.editType = 3;
    super(options);
  }
  getData(result) {
    super.getData(result);
    this.searchRender();
  }
  searchRender() {
    this.view.dt.$addClass("ui-dict-search");
    this.wrap = this.view.dt.$findByClassName("dicttable-wrap")[0];
    this.$search = YElement.buildFromVNode(h("div.search-iconview")).$appendTo(this.wrap);
  }
}
class YesDictSearchBoxBuilder extends YesComponentBuilder {
  static create(options) {
    return new YesVDictSearchBox(options);
  }
}
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __decorateClass = (decorators, target, key, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target;
  for (var i = decorators.length - 1, decorator; i >= 0; i--)
    if (decorator = decorators[i])
      result = (kind ? decorator(target, key, result) : decorator(result)) || result;
  if (kind && result)
    __defProp(target, key, result);
  return result;
};
function autoStrip(s, settings) {
  s = s || "";
  if (settings.aSign) {
    if (s.indexOf(settings.aSign) > -1) {
      if (settings.pSign == "s") {
        var first = settings.aSign.substr(0, 1);
        var reg2 = new RegExp("^[0-9]+.?[0-9]*");
        if (reg2.test(first)) {
          var reg = new RegExp("(.*)" + settings.aSign);
          s = s.replace(reg, "$1", "");
        } else {
          s = s.replace(settings.aSign, "");
        }
      } else {
        s = s.replace(settings.aSign, "");
      }
    }
  }
  s = s.replace(settings.skipFirstAutoStrip, "$1$2");
  s = s.replace(settings.skipLastAutoStrip, "$1");
  s = s.replace(settings.allowedAutoStrip, "");
  if (settings.altDec) {
    s = s.replace(settings.altDec, settings.aDec);
  }
  var m = s.match(settings.numRegAutoStrip);
  s = m ? [m[1], m[2], m[3]].join("") : "";
  return s;
}
function convertKeyToNumber(settings, key) {
  if (typeof settings[key] === "string") {
    settings[key] *= 1;
  }
}
function autoCode(settings) {
  settings.oEvent = null;
  var vmax = settings.vMax.toString().split("."), vmin = !settings.vMin && settings.vMin !== 0 ? [] : settings.vMin.toString().split(".");
  convertKeyToNumber(settings, "vMax");
  convertKeyToNumber(settings, "vMin");
  convertKeyToNumber(settings, "mDec");
  settings.aNeg = settings.vMin < 0 ? "-" : "";
  vmax[0] = vmax[0].replace("-", "");
  vmin[0] = vmin[0].replace("-", "");
  settings.mInt = Math.max(vmax[0].length, vmin[0].length, 1);
  if (settings.mDec === null) {
    var vmaxLength = 0, vminLength = 0;
    if (vmax[1]) {
      vmaxLength = vmax[1].length;
    }
    if (vmin[1]) {
      vminLength = vmin[1].length;
    }
    settings.mDec = Math.max(vmaxLength, vminLength);
  }
  if (settings.altDec === null && settings.mDec > 0) {
    if (settings.aDec === "." && settings.aSep !== ",") {
      settings.altDec = ",";
    } else if (settings.aDec === "," && settings.aSep !== ".") {
      settings.altDec = ".";
    }
  }
  var aNegReg = settings.aNeg ? "([-\\" + settings.aNeg + "]?)" : "(-?)";
  settings.aNegRegAutoStrip = aNegReg;
  settings.skipFirstAutoStrip = new RegExp(aNegReg + "[^-" + (settings.aNeg ? "\\" + settings.aNeg : "") + "\\" + settings.aDec + "\\d].*?(\\d|\\" + settings.aDec + "\\d)");
  settings.skipLastAutoStrip = new RegExp("(\\d\\" + settings.aDec + "?)[^\\" + settings.aDec + "\\d]\\D*$");
  var allowed = "-" + settings.aNum + "\\" + settings.aDec;
  settings.allowedAutoStrip = new RegExp("[^" + allowed + "]", "gi");
  settings.numRegAutoStrip = new RegExp(aNegReg + "(?:\\" + settings.aDec + "?(\\d+\\" + settings.aDec + "\\d+)|(\\d*(?:\\" + settings.aDec + "\\d*)?))");
  return settings;
}
function presentNumber(s, aDec, aNeg) {
  if (aNeg && aNeg !== "-") {
    s = s.replace("-", aNeg);
  }
  if (aDec && aDec !== ".") {
    s = s.replace(".", aDec);
  }
  return s;
}
function autoCheck(s, settings) {
  s = autoStrip(s, settings);
  s = truncateDecimal(s, settings.aDec, settings.mDec);
  s = fixNumber(s, settings.aDec, settings.aNeg);
  var value = s;
  let d = new Decimal(value);
  return d.greaterThanOrEqualTo(settings.dMin) && d.lessThanOrEqualTo(settings.dMax);
}
function truncateDecimal(s, aDec, mDec) {
  if (aDec && mDec) {
    var parts = s.split(aDec);
    if (parts[1] && parts[1].length > mDec) {
      if (mDec > 0) {
        parts[1] = parts[1].substring(0, mDec);
        s = parts.join(aDec);
      } else {
        s = parts[0];
      }
    }
  }
  return s;
}
function fixNumber(s, aDec, aNeg) {
  if (aDec && aDec !== ".") {
    s = s.replace(aDec, ".");
  }
  if (aNeg && aNeg !== "-") {
    s = s.replace(aNeg, "-");
  }
  if (!s.match(/\d/)) {
    s += "0";
  }
  return s;
}
function stripTrailingZeros(iv, settings) {
  if (iv.length > 0 && settings.stripTrailingZeros) {
    if (iv.indexOf(".") > 0) {
      var as = iv.split("");
      while (as.length > 0) {
        var len = as.length - 1;
        if (as[len] == 0) {
          as.splice(len);
        } else if (as[len] == ".") {
          as.splice(len);
          break;
        } else {
          break;
        }
      }
      iv = as.join("");
    }
  }
  return iv;
}
function autoRound(iv, settings) {
  iv = iv === "" ? "0" : iv.toString();
  var ivRounded = "", i = 0, nSign = "";
  if (iv.charAt(0) === "-") {
    nSign = "-";
    iv = iv.replace("-", "");
  }
  if (!iv.match(/^\d/)) {
    iv = "0" + iv;
  }
  if (nSign === "-" && +iv === 0) {
    nSign = "";
  }
  var dPos = iv.lastIndexOf("."), vdPos = dPos === -1 ? iv.length - 1 : dPos, cDec = iv.length - 1 - vdPos;
  if (cDec <= settings.mDec) {
    ivRounded = iv;
    if (!settings.stripTrailingZeros) {
      if (dPos === -1) {
        ivRounded += ".";
      }
      var zeros = "0";
      while (cDec < settings.mDec) {
        ivRounded += zeros;
        cDec += zeros.length;
      }
    }
  } else {
    var rLength = dPos + settings.mDec, tRound = +iv.charAt(rLength + 1), ivArray = iv.substring(0, rLength + 1).split("");
    if (tRound > 4 && settings.mRound === RoundingMode.HALF_UP || tRound > 0 && settings.mRound === RoundingMode.ROUND_UP || nSign === "" && tRound > 0 && settings.mRound === RoundingMode.ROUND_CEILING || nSign === "-" && tRound > 0 && settings.mRound === RoundingMode.ROUND_FLOOR) {
      for (i = ivArray.length - 1; i >= 0; i -= 1) {
        if (ivArray[i] !== ".") {
          ivArray[i] = +ivArray[i] + 1;
          if (ivArray[i] < 10) {
            break;
          }
          if (i > 0) {
            ivArray[i] = "0";
          }
        }
      }
    }
    ivArray = ivArray.slice(0, rLength + 1);
    ivRounded = ivArray.join("");
  }
  return +ivRounded === 0 ? ivRounded : nSign + ivRounded;
}
function autoGroup(iv, settings, isNumber) {
  if (isNumber) {
    if (iv != settings.aSign) {
      iv = autoStrip(iv, settings);
    }
  } else {
    iv = autoStrip(iv, settings);
  }
  iv.replace(",", ".");
  var empty = checkEmpty(iv, settings);
  if (empty !== null) {
    return empty;
  }
  var ivSplit = iv.split(settings.aDec);
  if (settings.altDec && ivSplit.length === 1) {
    ivSplit = iv.split(settings.altDec);
  }
  var s = ivSplit[0];
  if (settings.aSep && settings.useSeparator) {
    var digitalGroup;
    if (settings.dGroup === 2) {
      digitalGroup = /(\d)((\d)(\d{2}?)+)$/;
    } else if (settings.dGroup === 4) {
      digitalGroup = /(\d)((\d{4}?)+)$/;
    } else {
      digitalGroup = /(\d)((\d{3}?)+)$/;
    }
    while (digitalGroup.test(s)) {
      s = s.replace(digitalGroup, "$1" + settings.aSep + "$2");
    }
  }
  if (settings.mDec !== 0 && ivSplit.length > 1) {
    iv = s;
    if (ivSplit[1].length > settings.mDec) {
      ivSplit[1] = ivSplit[1].substring(0, settings.mDec);
    }
    if (ivSplit.length > 1) {
      iv += settings.aDec + ivSplit[1];
    }
  } else {
    iv = s;
  }
  if (settings.aSign && (settings.pSign === "p" || settings.pSign === "s")) {
    var has_aNeg = iv.indexOf(settings.aNeg) !== -1;
    iv = iv.replace(settings.aNeg, "");
    if (has_aNeg) {
      iv = settings.aNeg + iv;
    }
    iv = settings.pSign === "p" ? settings.aSign + iv : iv + settings.aSign;
  }
  return iv;
}
function checkEmpty(iv, settings) {
  if (iv === "" || iv === settings.aNeg) {
    return iv;
  }
  return null;
}
function getElementSelection(that) {
  if (that.__IsVirtual) {
    that = that.getRawDomElm();
  }
  var position = {
    length: 0,
    end: 0,
    start: 0
  };
  if (that.selectionStart === void 0) {
    that.focus();
    let doc = document;
    var select2 = doc.selection.createRange();
    position.length = select2.text.length;
    select2.moveStart("character", -that.value.length);
    position.end = select2.text.length;
    position.start = position.end - position.length;
  } else {
    position.start = that.selectionStart;
    position.end = that.selectionEnd;
    position.length = position.end - position.start;
  }
  return position;
}
function setElementSelection(that, start, end) {
  if (that.__IsVirtual) {
    that = that.getRawDomElm();
  }
  if (that.selectionStart === void 0) {
    that.focus();
    var r = that.createTextRange();
    r.collapse(true);
    r.moveEnd("character", end);
    r.moveStart("character", start);
    r.select();
  } else {
    that.selectionStart = start;
    that.selectionEnd = end;
  }
}
function truncateDecimal1(s, settings) {
  var aDec = settings.aDec, mDec = settings.mDec, mInt = settings.mInt;
  if (aDec && mDec) {
    var parts = s.split(aDec);
    if (parts[1] && parts[1].length > mDec) {
      if (mDec > 0) {
        parts[1] = parts[1].substring(0, mDec);
        s = parts.join(aDec);
      } else {
        s = parts[0];
      }
    }
  }
  if (aDec && mInt) {
    var parts = s.split(aDec), maSep;
    var re = /\-/g;
    var len = parts[0].split(",").length - 1;
    mInt = len + mInt;
    maSep = parts[0].match(re) ? parts[0].match(re).length : 0;
    if (parts[0] && parts[0].length + maSep > mInt) {
      if (mInt > 0) {
        parts[0] = parts[0].substring(0, mInt + maSep);
        s = parts.join(aDec);
      } else {
        s = parts[0];
      }
    }
  }
  return s;
}
function autoGroup1(iv, settings) {
  iv = autoStrip(iv, settings);
  iv.replace(",", ".");
  var empty = checkEmpty(iv, settings);
  if (empty !== null) {
    return empty;
  }
  var ivSplit = iv.split(settings.aDec);
  if (settings.altDec && ivSplit.length === 1) {
    ivSplit = iv.split(settings.altDec);
  }
  var s = ivSplit[0];
  if (settings.aSep && settings.useSeparator) {
    var digitalGroup;
    if (settings.dGroup === 2) {
      digitalGroup = /(\d)((\d)(\d{2}?)+)$/;
    } else if (settings.dGroup === 4) {
      digitalGroup = /(\d)((\d{4}?)+)$/;
    } else {
      digitalGroup = /(\d)((\d{3}?)+)$/;
    }
    while (digitalGroup.test(s)) {
      s = s.replace(digitalGroup, "$1" + settings.aSep + "$2");
    }
  }
  if (settings.mDec !== 0 && ivSplit.length > 1) {
    iv = s;
    if (ivSplit[1].length > settings.mDec) {
      ivSplit[1] = ivSplit[1].substring(0, settings.mDec);
    }
    if (ivSplit.length > 1) {
      iv += settings.aDec + ivSplit[1];
    }
  } else {
    iv = s;
  }
  return iv;
}
function NumberEditorHandler(that, settings) {
  this.settings = settings;
  this.that = that;
  this.formatted = false;
  this.settingsClone = autoCode(this.settings);
  this.value = that.getInputValue();
}
NumberEditorHandler.prototype = {
  init: function(e) {
    this.value = this.that.getElm().value;
    this.settingsClone = autoCode(this.settings);
    this.ctrlKey = e.ctrlKey;
    this.cmdKey = e.metaKey;
    this.shiftKey = e.shiftKey;
    this.selection = getElementSelection(this.that);
    if (e.type === "keydown" || e.type === "keyup") {
      this.kdCode = e.keyCode;
    }
    this.which = e.which;
    this.processed = false;
    this.formatted = false;
    this.changeSing();
  },
  changeSing() {
    let newValue = "";
    if (this.settings.pSign == "p") {
      for (let i = 0; i < this.value.length; i++) {
        if (this.value[i] != this.settings.aSign[i]) {
          newValue += this.value[i];
        }
      }
      this.value = newValue;
    } else if (this.settings.pSign == "s") {
      let len = this.settings.aSign.length;
      for (let i = this.value.length - 1; i >= 0; i--) {
        if (this.value[i] != this.settings.aSign[i - (this.value.length - len)]) {
          newValue = this.value[i] + newValue;
        }
      }
      this.value = newValue;
    }
  },
  setSelection: function(start, end, setReal) {
    start = Math.max(start, 0);
    var val = this.that.getInputValue() || "";
    end = Math.min(end, val.length);
    this.selection = {
      start,
      end,
      length: end - start
    };
    if (setReal === void 0 || setReal) {
      setElementSelection(this.that, start, end);
    }
  },
  setPosition: function(pos, setReal) {
    this.setSelection(pos, pos, setReal);
  },
  getBeforeAfter: function() {
    var value = this.value, left = value.substring(
      0,
      this.selection.start
    ), right = value.substring(
      this.selection.end,
      value.length
    );
    return [left, right];
  },
  getBeforeAfterStriped: function() {
    var parts = this.getBeforeAfter();
    return parts;
  },
  normalizeParts: function(left, right) {
    var settingsClone = this.settingsClone;
    if (this.first) {
      right = autoStrip(right, settingsClone);
      left = autoStrip(left, settingsClone);
      this.first = false;
    }
    var new_value = left + right;
    if (settingsClone.aDec) {
      var m = new_value.match(new RegExp("^" + settingsClone.aNegRegAutoStrip + "\\" + settingsClone.aDec));
      if (m) {
        left = left.replace(m[1], m[1] + "0");
        new_value = left + right;
      }
    }
    return [left, right];
  },
  processKeypress: function() {
    var settingsClone = this.settingsClone, cCode = String.fromCharCode(this.which), parts = this.getBeforeAfterStriped(), left = parts[0], right = parts[1];
    if (cCode === settingsClone.aDec || settingsClone.altDec && cCode === settingsClone.altDec || (cCode === "." || cCode === ",") && this.kdCode === 110) {
      if (!settingsClone.mDec || !settingsClone.aDec) {
        return true;
      }
      if (settingsClone.aNeg && right.indexOf(settingsClone.aNeg) > -1) {
        return true;
      }
      if (left.indexOf(settingsClone.aDec) > -1) {
        return true;
      }
      if (right.indexOf(settingsClone.aDec) > 0) {
        return true;
      }
      if (right.indexOf(settingsClone.aDec) === 0) {
        right = right.substr(1);
      }
      this.setValueParts(left + settingsClone.aDec, right);
      return true;
    }
    if (cCode === "-" || cCode === "+") {
      if (!settingsClone.aNeg) {
        return true;
      }
      if (left === "" && right.indexOf(settingsClone.aNeg) > -1) {
        left = settingsClone.aNeg;
        right = right.substring(1, right.length);
      }
      if (left.charAt(0) === settingsClone.aNeg) {
        left = left.substring(1, left.length);
      } else {
        left = cCode === "-" ? settingsClone.aNeg + left : left;
      }
      this.setValueParts(left, right);
      return true;
    }
    if (cCode >= "0" && cCode <= "9") {
      if (settingsClone.aNeg && left === "" && right.indexOf(settingsClone.aNeg) > -1) {
        left = settingsClone.aNeg;
        right = right.substring(1, right.length);
      }
      if (settingsClone.vMax <= 0 && settingsClone.vMin < settingsClone.vMax && this.value.indexOf(settingsClone.aNeg) === -1 && cCode !== "0") {
        left = settingsClone.aNeg + left;
      }
      this.setValueParts(left + cCode, right);
      return true;
    }
    return true;
  },
  setValueParts: function(left, right) {
    var settingsClone = this.settingsClone, parts = this.normalizeParts(left, right), new_value = parts.join(""), position = parts[0].length;
    if (autoCheck(new_value, settingsClone)) {
      new_value = truncateDecimal(
        new_value,
        settingsClone.aDec,
        settingsClone.mDec
      );
      if (position > new_value.length) {
        position = new_value.length;
      }
      this.value = new_value;
      this.setPosition(position, false);
      return true;
    }
    return false;
  },
  processAllways: function() {
    var parts;
    if (this.kdCode === 8 || this.kdCode === 46) {
      if (!this.selection.length) {
        parts = this.getBeforeAfter();
        parts[0] = autoStrip(parts[0], this.settingsClone);
        parts[1] = autoStrip(parts[1], this.settingsClone);
        if (this.kdCode === 8) {
          parts[0] = parts[0].substring(0, parts[0].length - 1);
        } else {
          parts[1] = parts[1].substring(1, parts[1].length);
        }
        this.setValueParts(parts[0], parts[1]);
      } else {
        parts = this.getBeforeAfterStriped();
        this.setValueParts(parts[0], parts[1]);
      }
      return true;
    }
    return false;
  },
  checkPaste: function() {
    if (this.valuePartsBeforePaste !== void 0) {
      var parts = this.getBeforeAfter(), oldParts = this.valuePartsBeforePaste;
      delete this.valuePartsBeforePaste;
      parts[0] = parts[0].substr(0, oldParts[0].length) + autoStrip(parts[0].substr(oldParts[0].length), this.settingsClone);
      if (!this.setValueParts(parts[0], parts[1])) {
        this.value = oldParts.join("");
        this.setPosition(oldParts[0].length, false);
      }
    }
  },
  skipAllways: function(e) {
    var kdCode = this.kdCode, which = this.which, ctrlKey = this.ctrlKey, cmdKey = this.cmdKey, shiftKey = this.shiftKey;
    if ((ctrlKey || cmdKey) && e.type === "keyup" && this.valuePartsBeforePaste !== void 0 || shiftKey && kdCode === 45) {
      this.checkPaste();
      return false;
    }
    if (kdCode >= 112 && kdCode <= 123 || kdCode >= 91 && kdCode <= 93 || kdCode >= 9 && kdCode <= 31 || kdCode < 8 && (which === 0 || which === kdCode) || kdCode === 144 || kdCode === 145 || kdCode === 45) {
      return true;
    }
    if ((ctrlKey || cmdKey) && kdCode === 65) {
      return true;
    }
    if ((ctrlKey || cmdKey) && (kdCode === 67 || kdCode === 86 || kdCode === 88)) {
      if (kdCode === 86 || kdCode === 45) {
        if (e.type === "keydown" || e.type === "keypress") {
          if (this.valuePartsBeforePaste === void 0) {
            this.valuePartsBeforePaste = this.getBeforeAfter();
          }
        } else {
          this.checkPaste();
        }
      }
      return e.type === "keydown" || e.type === "keypress" || kdCode === 67;
    }
    if (ctrlKey || cmdKey) {
      return true;
    }
    if (kdCode === 37 || kdCode === 39) {
      var aSep = this.settingsClone.aSep, start = this.selection.start, value = this.that.getInputValue();
      if (e.type === "keydown" && aSep && !this.shiftKey) {
        if (kdCode === 37 && value.charAt(start - 2) === aSep) {
          this.setPosition(start - 1);
        } else if (kdCode === 39 && value.charAt(start + 1) === aSep) {
          this.setPosition(start + 1);
        }
      }
      return true;
    }
    if (kdCode >= 34 && kdCode <= 40) {
      return true;
    }
    return false;
  },
  formatQuick: function() {
    var settingsClone = this.settingsClone, parts = this.getBeforeAfterStriped(), leftLength = this.value;
    if ((settingsClone.aSep === "" || settingsClone.aSep !== "" && leftLength.indexOf(settingsClone.aSep) === -1) && (settingsClone.aSign === "" || settingsClone.aSign !== "" && leftLength.indexOf(settingsClone.aSign) === -1)) {
      var subParts = [], nSign = "";
      subParts = leftLength.split(settingsClone.aDec);
      if (subParts[0].indexOf("-") > -1) {
        nSign = "-";
        subParts[0] = subParts[0].replace("-", "");
        parts[0] = parts[0].replace("-", "");
      }
      if (subParts[0].length > settingsClone.mInt && parts[0].charAt(0) === "0") {
        parts[0] = parts[0].slice(1);
      }
      parts[0] = nSign + parts[0];
    }
    var value = truncateDecimal1(this.value, this.settingsClone), value = autoGroup1(value, this.settingsClone);
    if (this.settings.pSign == "p") {
      value = this.settings.aSign + value;
    } else if (this.settings.pSign == "s") {
      value = value + this.settings.aSign;
    }
    var position = value.length;
    if (value) {
      var left_ar = parts[0].split(""), i = 0;
      for (i; i < left_ar.length; i += 1) {
        if (!left_ar[i].match("\\d")) {
          left_ar[i] = "\\" + left_ar[i];
        }
      }
      var leftReg = new RegExp("^.*?" + left_ar.join(".*?"));
      var newLeft = value.match(leftReg);
      if (newLeft) {
        position = newLeft[0].length;
        if ((position === 0 && value.charAt(0) !== settingsClone.aNeg || position === 1 && value.charAt(0) === settingsClone.aNeg) && settingsClone.aSign && settingsClone.pSign === "p") {
          position = this.settingsClone.aSign.length + (value.charAt(0) === "-" ? 1 : 0);
        }
      } else if (settingsClone.aSign && settingsClone.pSign === "s") {
        position -= settingsClone.aSign.length;
      }
    } else {
      settingsClone.aSign && (value = settingsClone.aSign);
    }
    if (this.that.__IsVirtual) {
      this.that.$setInputValue(value);
    } else {
      this.that.value = value;
    }
    this.setPosition(position);
    this.formatted = true;
  }
};
function getHandler($that, settings, update) {
  var data = $that.getDataSet("NumberEditor");
  if (!data) {
    data = {};
    $that.$setDataSet("NumberEditor", data);
  }
  var handler = data.handler;
  if (handler === void 0 && settings || update) {
    handler = new NumberEditorHandler($that, settings);
    data.handler = handler;
  }
  return handler;
}
class YesVNumberEditor extends YesVBaseText {
  constructor(options) {
    var decPrecision = options.precision;
    var decScale = options.scale;
    var roundingMode = options.roundingMode;
    var maxNumber = "";
    for (var i = 0; i < decPrecision - decScale; i++) {
      maxNumber += "9";
    }
    if (decScale > 0) {
      maxNumber += ".";
      for (var i = 0; i < decScale; i++) {
        maxNumber += "9";
      }
    }
    options.vMax = maxNumber;
    options.vMin = "-" + maxNumber;
    options.mDec = decScale;
    options.mRound = roundingMode;
    super(options);
    this.normalCaption = "";
    this.text_focusout = async (event2) => {
      var self2 = this;
      var $this = self2.$input;
      if (!self2.enable || self2.processing)
        return false;
      self2.needSelectAll = self2.selectOnFocus;
      var handler = self2.handler, settingsClone = handler.settingsClone, value = $this.getInputValue(), origValue = value;
      handler.settingsClone.oEvent = "focusout";
      if (handler.that.__IsVirtual) {
        handler.that.$setRawDomElm(self2.$input.getElm());
      }
      if (value !== "") {
        value = autoStrip(value, settingsClone);
        if (checkEmpty(value, settingsClone) === null && autoCheck(value, settingsClone)) {
          value = fixNumber(
            value,
            settingsClone.aDec,
            settingsClone.aNeg
          );
          value = autoRound(value, settingsClone);
          value = presentNumber(
            value,
            settingsClone.aDec,
            settingsClone.aNeg
          );
          value = stripTrailingZeros(value, settingsClone);
        } else {
          value = "";
        }
      }
      var groupedValue = checkEmpty(value, settingsClone);
      if (groupedValue === null) {
        groupedValue = autoGroup(value, settingsClone, void 0);
      }
      if (groupedValue !== origValue) {
        $this.$setInputValue(groupedValue);
      }
      var curValue = value == "" ? new Decimal(0) : new Decimal(value);
      if (self2.allowNull) {
        if (value == "") {
          curValue = null;
        }
      }
      try {
        await self2.commitValue(curValue);
      } catch (error) {
        throw error;
      } finally {
        self2.doFocusOut();
        self2.el && self2.el.$removeClass("focus");
      }
    };
    this.aNum = options.aNum || "0123456789";
    this.aSep = options.aSep || ",";
    this.dGroup = options.dGroup || "3";
    this.aDec = options.aDec || ".";
    this.aSign = options.aSign;
    this.pSign = options.pSign;
    this.vMax = options.vMax;
    this.dMax = new Decimal(this.vMax);
    this.vMin = options.vMin;
    this.dMin = new Decimal(this.vMin);
    this.mDec = options.mDec;
    this.mPre = options.mPre || "16";
    this.mRound = options.mRound;
    this.altDec = options.altDec;
    this.formulaText = options.formulaText;
    this.selectOnFocus = options.selectOnFocus;
    this.allowNull = options.allowNull || false;
  }
  createHtml() {
    this.el.$addClass("ui-control").$addClass("ui-numed");
    const _wrap = h("div.numbed-wrap");
    var wrap = YElement.buildFromVNode(_wrap).$appendTo(this.el);
    const _input = /* @__PURE__ */ snabbdomJsx.html("input", { type: "text" });
    this.$input = YElement.buildFromVNode(_input).$appendTo(wrap);
    const _clearBtn = h("span.clear");
    this.$clearBtn = YElement.buildFromVNode(_clearBtn).$appendTo(this.el);
  }
  initCss(options) {
    if (!options) {
      return;
    }
    var str = this.getOuterCss(options, false);
    var inputCss = this.getInputCss(options);
    var lblCss = this.getLabelCss(options);
    var inputLblCss = this.getInputLbl(options);
    this.el.$appendStyles(str).$appendStyles(inputCss);
    this.$input.$appendStyles(inputLblCss).$appendStyles(lblCss);
    this.setFormatStyle(options);
    this.txtCss && this.$input.$appendStyles(this.txtCss);
  }
  render(ct) {
    super.render(ct);
    this.handler = getHandler(this.$input, this, false);
    this.handler.first = true;
  }
  afterRender() {
    super.afterRender();
    this.promptText && this.setPromptText(this.promptText);
  }
  getValue() {
    var realV = null;
    if (this.value == null) {
      realV = 0;
    } else {
      realV = fixNumber(this.value, this.aDec);
    }
    return new Decimal(realV);
  }
  getInput() {
    return this.$input;
  }
  getClearBtn() {
    return this.$clearBtn;
  }
  setShowText(text) {
    this.$input.$setInputValue(text);
    this.$input.getElm() && (this.$input.getElm().value = text);
  }
  focus() {
    this.$input.$focus();
  }
  //TODO 处理颜色
  setBackColor(backColor) {
    this.backColor = backColor;
    this.$input.$appendStyles(new Map(Object.entries({
      "background-image": "none",
      "background-color": backColor
    })));
    this.el.$appendStyles(new Map(Object.entries({
      "background-image": "none",
      "background-color": backColor
    })));
  }
  //TODO 处理颜色
  setForeColor(foreColor) {
    this.foreColor = foreColor;
    this.$input.$addStyle("color", foreColor);
  }
  //TODO 不要出现 -3 的PX
  setHeight(height) {
    super.setHeight(height);
  }
  setWidth(width) {
    super.setWidth(width);
  }
  setPromptText(promptText) {
    this.$input.$setAttr("placeholder", promptText);
  }
  // autoGroup(value) {
  //     var value = autoGroup(value, this.settings, false);
  //     return value;
  // };
  setNormalCaption(caption) {
    this.normalCaption = caption;
  }
  doFocusOut() {
    var fn = this.owner.doFocusOut;
    if (typeof fn === "function") {
      return fn.apply(this.owner, arguments);
    }
  }
  doTextChanged() {
    var fn = this.owner.doTextChanged;
    if (typeof fn === "function") {
      return fn.apply(this.owner, arguments);
    }
  }
  doOnFocus() {
    var fn = this.owner.doOnFocus;
    if (typeof fn === "function") {
      return fn.apply(this.owner, arguments);
    }
  }
  getShowText() {
    return this.$input.getInputValue();
  }
  async doOnInputClick(event2, item) {
    var $this = this.$input, self2 = this;
    if (!self2.enable)
      return false;
    var handler = self2.handler;
    if (handler.that.__IsVirtual) {
      handler.that.$setRawDomElm(event2.target);
    }
    if (self2.aSign && !$this.getInputValue() && (self2.pSign == "s" || self2.pSign == "p")) {
      $this.$setInputValue(self2.aSign);
    }
    self2.focusOwner();
    if (self2.needSelectAll) {
      let doc = document;
      if (doc.selection && doc.selection.empty) {
        doc.selection.empty();
      } else if (window.getSelection) {
        var sel = window.getSelection();
        sel && sel.removeAllRanges();
      }
      var pSign = self2.pSign;
      if (self2.selectOnFocus) {
        if (pSign) {
          if (pSign == "p") {
            setElementSelection(event2.target, self2.aSign.length, self2.$input.getInputValue().length);
          } else if (pSign == "s") {
            setElementSelection(event2.target, 0, self2.$input.getInputValue().length - self2.aSign.length);
          }
        } else {
          select(event2.target);
        }
      }
      self2.needSelectAll = false;
    }
  }
  install() {
    super.install();
    var $this = this.$input, self2 = this;
    self2.needSelectAll = self2.selectOnFocus;
    $this.$addListener("input", function(e) {
      if (!self2.enable)
        return false;
      var handler = self2.handler;
      handler.init(e);
      handler.settings.oEvent = "keypress";
      if (handler.skipAllways(e)) {
        self2.doTextChanged();
        return true;
      }
      handler.formatQuick();
      if (self2.owner.textChanged && e.target.value)
        self2.doTextChanged();
      e.preventDefault();
      handler.formatted = false;
      return false;
    });
    $this.$addListener("focusin", function(event2) {
      if (!self2.enable)
        return false;
      if (self2.formulaText && !self2.el.hasClass("focus")) {
        self2.$input.$setInputValue(self2.normalCaption);
      }
      self2.el.$addClass("focus");
      var handler = self2.handler;
      handler.settingsClone.oEvent = "focusin";
      if (handler.that.__IsVirtual) {
        handler.that.$setRawDomElm(event2.target);
      }
      var onempty = checkEmpty($this.getInputValue(), handler.settingsClone);
      if (onempty) {
        $this.$setInputValue(onempty);
        if (handler.settings.pSign === "s") {
          setElementSelection(event2.target, 0, 0);
        } else {
          setElementSelection(
            event2.target,
            handler.settings.aSign.length,
            handler.settings.aSign.length
          );
        }
      }
      if (self2.needSelectAll) {
        var pSign = self2.pSign;
        if (self2.selectOnFocus) {
          if (pSign) {
            if (pSign == "p") {
              setElementSelection(event2.target, self2.aSign.length, self2.$input.getInputValue().length);
            } else if (pSign == "s") {
              setElementSelection(event2.target, 0, self2.$input.getInputValue().length - self2.aSign.length);
            }
          } else {
            select(event2.target);
          }
        }
      }
      self2.doOnFocus();
    });
    $this.$addListener("focusout", syncevent(self2.text_focusout));
    $this.$addListener("click", function(event2) {
      self2.doOnInputClick(event2, null);
    });
    self2.el.$addListener("mouseenter", function() {
      if (!self2.enable)
        return false;
      if (self2.aSign && !$this.getInputValue() && (self2.pSign == "s" || self2.pSign == "p")) {
        $this.$setInputValue(self2.aSign);
      }
    });
    self2.el.$addListener("mouseleave", function() {
      if (!self2.enable)
        return false;
      if (!self2.el.hasClass("focus") && $this.getInputValue() == self2.aSign) {
        $this.$setInputValue("");
      }
    });
    self2.$clearBtn.$mousedown(function(e) {
      self2.aSign && $this.$setInputValue(self2.aSign);
      self2.normalCaption = "";
    });
  }
}
__decorateClass([
  TraceUIOptEvent()
], YesVNumberEditor.prototype, "doOnInputClick", 1);
class YesMNumberEditorBuilderBuilder extends YesNumberEditorBuilderBuilder {
  static create(options) {
    return new YesVNumberEditor(options);
  }
}
const getcurrentIndexByVisible = (index, currentIndexByVisible, currentIndexByAll, visible) => {
  if (!visible && (currentIndexByAll == index && currentIndexByVisible > 0 || currentIndexByAll > index)) {
    return currentIndexByVisible - 1;
  }
  if (visible && currentIndexByAll > index) {
    return currentIndexByVisible + 1;
  }
  return currentIndexByVisible;
};
const getTranslateX = ($dom) => {
  if (!$dom)
    return;
  var translateX = parseFloat(
    getComputedStyle($dom)["transform"].substring(7).split(",")[4]
  );
  return translateX.toString() == "NaN" ? 0 : translateX;
};
class MTabLayout extends VAutoLayout {
  constructor(options) {
    super(options);
    this.showHead = options.meta.showHead;
    this.tabMode = options.meta.tabMode;
    this.currentIndex = 0;
  }
  createHTML() {
    this.el.$addClass("ui-pnl").$addClass("uim-tpl");
    this.navs = YElement.buildFromVNode(h("div.uim-tpl-navs"));
    this.content = YElement.buildFromVNode(h("div.uim-tpl-content"));
    this.line = YElement.buildFromVNode(h("div.uim-tpl-line")).$appendTo(this.navs);
    if (this.owner.meta.tabPosition == DirectionType.BOTTOM) {
      this.el.$append(this.content).$append(this.navs);
    } else {
      this.el.$append(this.navs).$append(this.content);
    }
    if (this.tabMode == 1) {
      this.navs.$addClass("navs-scroll");
    }
    if (!this.showHead) {
      this.navs.$addClass("navs-hide");
    }
    return this.el;
  }
  getTabIndex() {
    return this.currentIndex;
  }
  selectedTabKey() {
    return this.navs.$findByClassName("cur")[0].getAttr("control-key");
  }
  initCss(style) {
    super.initCss(style);
    if (this.owner.meta.indicatorColor) {
      this.line.$addStyle("background", this.owner.meta.indicatorColor);
    }
    if (this.owner.meta.indicatorHeight) {
      this.line.$setHeight(this.owner.meta.indicatorHeight);
    }
  }
  /** 组件渲染前事件*/
  beforeRenderItem(c, target, layoutItem, index) {
    c.setWidth("100%");
    c.setHeight("100%");
  }
  /**
   * 返回控件comp即将被render到的dom
   * @param comp
   * @param layoutItem comp在items中的index
   */
  getItemTarget(comp, layoutItem, index) {
    if (comp.container) {
      return comp.container;
    }
    var nav = YElement.buildFromVNode(h("div.uim-tpl-nav", {
      attrs: { "control-key": layoutItem.key }
    })).$appendTo(this.navs), tab = YElement.buildFromVNode(h("div.uim-tpl-panel", {
      attrs: { "control-key": layoutItem.key }
    })).$appendTo(this.content), target = YElement.buildFromVNode(h("div")).$appendTo(tab);
    YElement.buildFromVNode(h("span.nav-text", {}, layoutItem.caption)).$appendTo(nav);
    if (!comp.visible) {
      nav.$addClass("hide");
      tab.$addClass("hide");
    }
    if (this.currentIndex == index) {
      nav.$addClass("cur");
    }
    return target;
  }
  afterRender() {
    super.afterRender();
    this.layoutRender();
    this.install();
  }
  isMax() {
    return this.el.hasClass("zoomui");
  }
  addViewBadge(badge) {
    var _view, navs = this.navs.$findByClassName("uim-tpl-nav");
    if (badge[0].indexOf(".") > -1 && badge[0].split(".")[1]) {
      var key = badge[0].split(".")[1];
      _view = navs.filter((vEl) => vEl.getAttr("control-key") == key)[0];
    } else {
      _view = navs[badge[2]];
    }
    super.addViewBadge(badge, _view);
  }
  removeViewBadge(badge) {
    var _view, navs = this.navs.$findByClassName("uim-tpl-nav");
    if (badge[0].indexOf(".") > -1 && badge[0].split(".")[1]) {
      var key = badge[0].split(".")[1];
      _view = navs.filter((vEl) => vEl.getAttr("control-key") == key)[0];
    } else {
      _view = navs[badge[1]];
    }
    super.removeViewBadge(badge, _view);
  }
  reduceVisible(visible, comp) {
    let index = 0, nav, panel, currentIndex, isVisible;
    this.navs.$findByClassName("uim-tpl-nav").forEach((el, _index) => {
      if (el.getAttr("control-key") == comp.key) {
        index = _index;
        nav = el;
      }
      if (!el.hasClass("hide"))
        ;
    });
    this.content.$findByClassName("uim-tpl-panel").forEach((el, _index) => {
      if (el.getAttr("control-key") == comp.key) {
        panel = el;
      }
    });
    currentIndex = this.navs.$findByClassName("cur")[0].index();
    isVisible = !nav.hasClass("hide");
    if (visible) {
      if (isVisible)
        return;
      panel.$removeClass("hide");
      nav.$removeClass("hide");
    } else {
      if (!isVisible)
        return;
      nav.$addClass("hide");
      panel.$addClass("hide");
    }
    this.currentIndex = getcurrentIndexByVisible(index, this.currentIndex, currentIndex, visible);
    this.layoutRender();
  }
  selectTab(key) {
    let self2 = this;
    this.navs.$findByClassName("uim-tpl-nav").forEach((el, index) => {
      if (el.getAttr("control-key") == key && !el.hasClass("hide")) {
        self2.doMove(el);
      }
    });
  }
  layoutRender() {
    var visibleNum = this._getvisibleNum();
    if (visibleNum > 0) {
      if (this.navs.getElm()) {
        let curNav = this.navs.$findByClassName("uim-tpl-nav")[this.currentIndex];
        this.line.$setWidth(curNav.getElm().offsetWidth);
      } else {
        this.line.$setWidth(100 / visibleNum + "%");
      }
    } else {
      this.line.$setWidth(0);
    }
    this.content.$setWidth(visibleNum * 100 + "%");
  }
  _getvisibleNum() {
    let tplnavs = this.navs.$findByClassName("uim-tpl-nav").filter((el) => {
      return !el.hasClass("hide");
    });
    return tplnavs.length;
  }
  doMove(_$nav) {
    _$nav.$addClass("cur");
    this.currentIndex = _$nav.index() - 1;
    let elm = _$nav.getElm();
    this.line.$setWidth(elm.offsetWidth);
    this.line.$addStyle("transform", "translateX(" + elm.offsetLeft + "px)");
    this.content.$addStyle("transform", "translateX(-" + 100 / this._getvisibleNum() * this.currentIndex + "%)");
    _$nav.siblings().forEach((el) => el.$removeClass("cur"));
  }
  install() {
    var self2 = this;
    this.navs.$findByClassName("uim-tpl-nav").forEach(($nav) => {
      $nav.$click(function() {
        self2.doMove(YElement.buildFromVNode(this));
        self2.owner.doItemChanged();
      });
    });
    this.touchSilde();
    this.el.$scroll(() => {
      this.el.getElm().scrollLeft = 0;
    });
  }
  touchSilde() {
    var $content = this.content, cWidth, touchstartX, touchstartY, swipeX, swipeY, panelstartX, prevTouchmoveX, touchmoveX, touchmoveY, bili = 0.1, panelWidth, biliDistance, ismove = false, lastMoveDis = 4;
    $content.$addListener("touchstart", touchstartHandler.bind(this));
    function touchstartHandler(e) {
      ismove = false;
      swipeX = true;
      swipeY = true;
      touchstartX = e.changedTouches[0].pageX;
      touchstartY = e.changedTouches[0].pageY;
      cWidth = $content.getElm().offsetWidth;
      panelWidth = cWidth / this._getvisibleNum();
      biliDistance = panelWidth * bili;
      $content.$addStyle("transition", "none");
      panelstartX = getTranslateX($content.getElm());
      $content.$addListener("touchmove", touchmoveHandler.bind(this));
      $content.$addListener("touchend", touchendHandler.bind(this));
      e.stopPropagation();
    }
    function touchmoveHandler(e) {
      ismove = true;
      prevTouchmoveX = touchmoveX;
      touchmoveX = e.changedTouches[0].pageX;
      touchmoveY = e.changedTouches[0].pageY;
      var result = Math.abs(touchmoveX - touchstartX) - Math.abs(touchmoveY - touchstartY) * 2;
      if (swipeX && result > 0) {
        var distance = touchmoveX - touchstartX, translateX = panelstartX + distance, minTranslateX = -(cWidth - cWidth / this._getvisibleNum());
        if (translateX >= 0)
          translateX = 0;
        if (translateX <= minTranslateX)
          translateX = minTranslateX;
        $content.getElm().style.transform = "translateX(" + translateX + "px)";
        e.preventDefault();
        e.stopPropagation();
        swipeY = false;
      }
      if (swipeY && result <= 0) {
        swipeX = false;
      }
    }
    function touchendHandler(e) {
      if (ismove && swipeX) {
        var touchmoveX2 = e.changedTouches[0].pageX, distance = touchmoveX2 - prevTouchmoveX, totalDis = touchmoveX2 - touchstartX, translateX = panelstartX;
        if (Math.abs(distance) >= lastMoveDis || Math.abs(totalDis) >= biliDistance) {
          if (totalDis > 0) {
            this.currentIndex = this.currentIndex > 0 ? this.currentIndex - 1 : 0;
          }
          if (totalDis < 0) {
            var i = this._getvisibleNum() - 1;
            this.currentIndex = this.currentIndex < i ? this.currentIndex + 1 : i;
          }
          translateX = -(this.currentIndex * panelWidth);
          this.owner.doItemChanged();
        }
        $content.$addStyle("transition", "transform .3s");
        $content.$addStyle("transform", "translateX(" + translateX + "px)");
        let _$nav = this.navs.$findByClassName("uim-tpl-nav")[this.currentIndex];
        this.showHead && this.doMove(_$nav);
      } else {
        $content.$addStyle("transition", "transform .3s");
      }
      e.stopPropagation();
      $content.$removeListener("touchmove");
      $content.$removeListener("touchend");
    }
  }
}
class YesTabPanelBuilder extends YesComponentBuilder {
  static create(options) {
    return new MTabLayout(options);
  }
}
class MFlexFlowLayoutCss3 extends VFlexFlowLayoutCss3 {
  beforeRenderItem(c, target, layoutItem, index) {
    super.beforeRenderItem(c, target, layoutItem, index);
    if (c.getHeight() == "unset") {
      c.setHeight("0px");
    }
  }
}
class YesMFlexflowLayoutPanelPanelBuilder extends YesFlexflowLayoutPanelPanelBuilder {
  static create(options) {
    return new MFlexFlowLayoutCss3(options);
  }
}
class YesDynamicDictBuilder extends YesDictBuilder {
}
var formatAsyncData$1 = function(datas) {
  datas.forEach((val) => {
    var id = val.itemKey + "_" + val.OID;
    val.id = id;
    if (val.items && val.items.length > 0) {
      formatAsyncData$1(val.items);
    }
  });
  return datas;
};
class YesVDictPaneLevel extends YesVBaseComponent {
  constructor(options) {
    super(options);
    this.value = {};
  }
  createHtml() {
    super.createHtml();
    this.el.$addClass("ui-control").$addClass("ui-dlevel");
    this.$dlevel = YElement.buildFromVNode(h("div.ui-dlevel-view")).$appendTo(this.el);
  }
  createLevelNode(node, level) {
    var $level = YElement.buildFromVNode(h("div.level")).$appendTo(this.$dlevel);
    $level.$setAttr("level", level);
    $level.$setAttr("oid", node.OID);
    return $level;
  }
  afterRender() {
    this.renderDictData().then(() => {
      super.afterRender();
    });
  }
  setLabelCss(lblCss) {
    this.el.$appendStyles(lblCss);
  }
  doItem(item) {
    var _a;
    (_a = item.$parent()) == null ? void 0 : _a.$findByClassName("item").forEach((el) => {
      if (item.getAttr("parentid") == el.getAttr("parentid")) {
        el.$removeClass("hide");
        if (item.getAttr("oid") == el.getAttr("oid")) {
          el.$addClass("check");
        } else {
          el.$removeClass("check");
        }
      } else {
        el.$addClass("hide");
      }
    });
    let level = item.getAttr("level");
    let levels = this.$dlevel.getChildElms().filter((el) => el.getAttr("level") > level);
    levels.forEach((eel, i) => {
      if (i == 0) {
        eel.getChildElms().forEach((_item) => {
          _item.$removeClass("check");
          if (item.getAttr("oid") == _item.getAttr("parentid")) {
            _item.$removeClass("hide");
          } else {
            _item.$addClass("hide");
          }
        });
      } else {
        eel.getChildElms().forEach((_item) => {
          _item.$addClass("hide").$removeClass("check");
        });
      }
    });
  }
  showing(value) {
    this.getTreePath(value).then((paths) => {
      if (paths[0]) {
        paths[0].push(value);
        this.renderLevelNodebyValue(paths[0]);
      }
    });
  }
  async renderLevelNodebyValue(nodes) {
    var i = 1;
    var self2 = this;
    var renderNodes = async function(value, i2) {
      if (value[i2]) {
        let $item = self2.$dlevel.$findByClassName("item").filter((el) => el.getAttr("oid") == value[i2]["oid"])[0];
        if ($item) {
          let items = self2.$dlevel.$findByClassName("item");
          let chills = items.filter((el) => el.getAttr("parentid") == value[i2]["oid"]);
          if (chills.length == 0) {
            await self2.renderLevelNodes(value[i2], $item);
          }
          self2.doItem($item);
        }
        if (value[i2 + 1]) {
          renderNodes(value, i2 + 1);
        }
      }
      return;
    };
    await renderNodes(nodes, i);
  }
  async renderLevelNodes(dictData, $node, root) {
    let $level, load = false, level = 0;
    if ($node) {
      load = $node.getAttr("load");
      level = $node.getAttr("level") || 0;
      $level = this.$dlevel.$find((vEl) => {
        return vEl.getAttr("level") == level + 1 && vEl.$findByClassName("level");
      })[0];
      $node.$setAttr("load", true);
    }
    if (!$level) {
      $level = this.createLevelNode(dictData, level + 1);
    }
    root && $level.$setAttr("root", true);
    if (!load) {
      let data = await this.getDictChildren(new ItemData(dictData));
      var childNodes = data.data;
      if (childNodes && childNodes.length > 0) {
        var syncNodes = formatAsyncData$1(childNodes);
        this.renderNextNodes(syncNodes, $level, level);
      }
    }
    return;
  }
  /**
   * 根据父节点 添加子节点
   * @param {} nodes
   * @param {} pNodeKey
   */
  renderNextNodes(nodes, pNode, level) {
    for (var i = 0, len = nodes.length; i < len; i++) {
      var $item = YElement.buildFromVNode(h("div.item")).$appendTo(pNode);
      let { id, OID, Enable, disableSelect, itemKey, caption, ParentID, NodeType } = nodes[i];
      $item.$setAttr("id", id);
      $item.$setAttr("oid", OID);
      $item.$setAttr("itemKey", itemKey);
      $item.$setAttr("level", level + 1);
      $item.$setAttr("enable", Enable);
      $item.$setAttr("disableSelect", disableSelect);
      $item.$setAttr("parentid", ParentID);
      $item.$setAttr("nodetype", NodeType);
      switch (Enable) {
        case DictState.Enable:
          $item.$addClass("enable");
          break;
        case DictState.Disable:
          $item.$addClass("disable");
          break;
        case DictState.Discard:
          $item.$addClass("discard");
          break;
      }
      $item.$setInnerText(caption);
      this.setItemStyle($item);
      let self2 = this;
      $item.$click(function() {
        if (!self2.enable)
          return;
        var item = YElement.buildFromVNode(this);
        var node = new ItemData({ oid: item.getAttr("oid"), itemKey: item.getAttr("itemKey") });
        if (!$item.getAttr("disableSelect")) {
          self2.doItem(item);
          self2.value = node;
          self2.commitValue(node);
        }
      });
    }
  }
  setItemStyle($li) {
    let { foreColor, format } = this.owner.style;
    foreColor && $li.$addStyle("color", foreColor);
    if (format) {
      let { font, size, italic, bold } = format;
      if (font) {
        size && $li.$addStyle("fontSize", size);
        italic && $li.$addStyle("fontStyle", "italic");
        bold && $li.$addStyle("fontWeight", "700");
      }
    }
  }
  checkDict() {
    let fn = this.owner.checkDict;
    if (typeof fn === "function") {
      return fn.apply(this.owner, arguments);
    }
  }
  getDictChildren() {
    var fn = this.owner.getDictChildren;
    if (typeof fn === "function") {
      return fn.apply(this.owner, arguments);
    }
  }
  getItemKey() {
    let fn = this.owner.getItemKey;
    if (typeof fn === "function") {
      return fn.apply(this.owner, arguments);
    }
  }
  getQueryCols() {
    let fn = this.owner.getQueryCols;
    if (typeof fn === "function") {
      return fn.apply(this.owner, arguments);
    }
  }
  getTreePath() {
    var fn = this.owner.getTreePath;
    if (typeof fn === "function") {
      return fn.apply(this.owner, arguments);
    }
  }
  setPromptText() {
  }
  reset() {
  }
  setValue(value) {
    if (value) {
      this.value = value;
      this.showing(this.value);
    } else {
      this.$dlevel.$findByTagName("li").forEach((item) => item.$removeClass("check"));
      this.$dlevel.getChildElms().forEach(($level, i) => {
        if (i > 0) {
          $level.$addClass("hide");
          $level.$findByTagName("ul").forEach((item) => item.$addClass("hide"));
        } else {
          $level.$removeClass("hide");
          $level.$findByTagName("ul").forEach((item) => item.$removeClass("hide"));
        }
      });
    }
  }
  repaint() {
    this.$dlevel.getChildElms().forEach((el) => {
      el.$remove();
    });
    this.renderDictData();
  }
  doFocusOut() {
    var fn = this.owner.doFocusOut;
    if (typeof fn === "function") {
      return fn.apply(this.owner, arguments);
    }
  }
  async renderDictData() {
    var result = await this.checkDict();
    if (result) {
      this.renderLevelNodes(result.root, null, true);
    }
  }
}
var formatAsyncData = function(datas) {
  datas.forEach((val) => {
    var id = val.itemKey + "_" + val.OID;
    val.id = id;
    if (val.items && val.items.length > 0) {
      formatAsyncData(val.items);
    }
  });
  return datas;
};
var removeNext = function(ttel, type) {
  if (ttel && ttel.$next()) {
    if (ttel.$next().hasClass("ui-dtree-vl") && !type) {
      ttel.$next().$addClass("hide");
    }
    type ? ttel.$next().$removeClass("check") : ttel.$next().$addClass("hide");
    if (ttel.$next().$next()) {
      removeNext(ttel.$next(), type);
    }
  }
};
var addBefore = function(bttel) {
  if (bttel && bttel.$prev()) {
    bttel.$prev().$addClass("check");
    if (bttel.$prev().$prev()) {
      addBefore(bttel.$prev());
    }
  }
};
class YesVDictPaneTree extends YesVBaseComponent {
  constructor(options) {
    super(options);
  }
  createHtml() {
    super.createHtml();
    this.el.$addClass("ui-control").$addClass("ui-dtree");
    this.$dtreetitle = YElement.buildFromVNode(h("div.ui-dtree-title")).$appendTo(this.el);
    this.$dtree = YElement.buildFromVNode(h("div.ui-dtree-view")).$appendTo(this.el);
  }
  createtreeNode(node, tree) {
    var $tree = YElement.buildFromVNode(h("div.tree")).$appendTo(this.$dtree);
    $tree.$setAttr("tree", tree);
    $tree.$setAttr("oid", node.OID);
    return $tree;
  }
  afterRender() {
    this.renderDictData().then(() => {
      super.afterRender();
    });
  }
  setLabelCss(lblCss) {
    this.el.$appendStyles(lblCss);
  }
  doTitle(item) {
    let caption = item.getInnerText(), oid = item.getAttr("oid"), tree = item.getAttr("tree"), nodetype = item.getAttr("nodetype");
    var titles = this.$dtreetitle.getChildElms().filter(($tt) => $tt.getAttr("tree") == tree);
    if (titles.length == 0) {
      this.setDictTreeTitle(caption, oid, tree, true, nodetype);
    } else {
      titles[0].$removeClass("hide");
      titles[0].$prev() && titles[0].$prev().$removeClass("hide");
      titles[0].$setInnerText(caption);
      titles[0].$setAttr("oid", oid);
      titles[0].$setAttr("nodetype", nodetype);
      titles[0].$addClass("check");
      removeNext(titles[0], false);
    }
  }
  doItem(item) {
    var _a, _b, _c, _d, _e, _f;
    item.$addClass("check");
    (_a = item.$parent()) == null ? void 0 : _a.$findByClassName("item").forEach((el) => {
      if (item.getAttr("parentid") == el.getAttr("parentid")) {
        el.$removeClass("hide");
        if (item.getAttr("oid") == el.getAttr("oid")) {
          el.$addClass("check");
        } else {
          el.$removeClass("check");
        }
      } else {
        el.$addClass("hide");
      }
    });
    (_c = (_b = item.$parent()) == null ? void 0 : _b.$next()) == null ? void 0 : _c.$findByClassName("item").forEach((el) => {
      if (item.getAttr("oid") == el.getAttr("parentid")) {
        el.$removeClass("hide");
      } else {
        el.$addClass("hide");
      }
    });
    if (item.getAttr("nodetype") == 1) {
      (_d = item.$parent()) == null ? void 0 : _d.$addClass("hide");
    }
    (_f = (_e = item.$parent()) == null ? void 0 : _e.$next()) == null ? void 0 : _f.$removeClass("hide");
    item.getAttr("tree");
    this.$dtree.$findByClassName("item").forEach((el) => {
      if (item.getAttr("oid") == el.getAttr("parentid")) {
        el.$removeClass("check");
      }
    });
  }
  showing(value) {
    this.getTreePath(value).then((paths) => {
      if (paths[0]) {
        paths[0].push(value);
        this.renderTreeNodebyValue(paths[0]);
      }
    });
  }
  async renderTreeNodebyValue(nodes) {
    var i = 1;
    var self2 = this;
    var renderNodes = async function(value, i2) {
      if (value[i2]) {
        let $item = self2.$dtree.$findByClassName("item").filter((el) => el.getAttr("oid") == value[i2]["oid"])[0];
        if ($item) {
          let items = self2.$dtree.$findByClassName("item");
          let chills = items.filter((el) => el.getAttr("parentid") == value[i2]["oid"]);
          if (chills.length == 0) {
            await self2.renderTreeNodes(value[i2], $item);
          }
          self2.doTitle($item);
          self2.doItem($item);
        }
        if (value[i2 + 1]) {
          renderNodes(value, i2 + 1);
        }
      }
    };
    await renderNodes(nodes, i);
  }
  setDictTreeTitle(caption, oid, tree, line, nodetype) {
    if (line) {
      let $line = YElement.buildFromVNode(h("i.ui-dtree-vl")).$appendTo(this.$dtreetitle);
      $line.$setInnerText("/");
    }
    var item = YElement.buildFromVNode(h("div.ui-dtree-item")).$appendTo(this.$dtreetitle);
    item.$setInnerText(caption);
    item.$setAttr("oid", oid);
    item.$setAttr("nodetype", nodetype);
    item.$setAttr("tree", tree);
    item.$addClass("check");
    removeNext(item, true);
    addBefore(item);
    let self2 = this;
    item.$click(function() {
      var item2 = YElement.buildFromVNode(this);
      var tree2 = parseInt(item2.getAttr("tree")) || 2;
      if (tree2 != 0 && item2.getAttr("nodetype") != 1) {
        tree2 = tree2 - 1;
      }
      self2.$dtree.getChildElms().forEach(($tree) => {
        if ($tree.getAttr("tree") == tree2) {
          $tree.$removeClass("hide");
        } else {
          $tree.$addClass("hide");
        }
      });
      removeNext(item2, true);
      addBefore(item2);
      item2.$addClass("check");
      self2.doTitle(item2);
    });
  }
  async renderTreeNodes(dictData, $node) {
    let $tree, load = false, tree = 0;
    if ($node) {
      load = $node.getAttr("load");
      tree = $node.getAttr("tree") || 0;
      $tree = this.$dtree.$find((vEl) => {
        return vEl.getAttr("tree") == tree + 1 && vEl.$findByClassName("tree");
      })[0];
      $node.$setAttr("load", true);
    }
    if (!$tree) {
      $tree = this.createtreeNode(dictData, tree + 1);
    }
    if (!load) {
      let data = await this.getDictChildren(new ItemData(dictData));
      var childNodes = data.data;
      if (childNodes && childNodes.length > 0) {
        var syncNodes = formatAsyncData(childNodes);
        this.renderNextNodes(syncNodes, $tree, tree);
      }
    }
    return;
  }
  /**
   * 根据父节点 添加子节点
   * @param {} nodes
   * @param {} pNodeKey
   */
  renderNextNodes(nodes, pNode, tree) {
    for (var i = 0, len = nodes.length; i < len; i++) {
      var $item = YElement.buildFromVNode(h("div.item")).$appendTo(pNode);
      let { id, OID, Enable, disableSelect, itemKey, caption, ParentID, NodeType } = nodes[i];
      $item.$setAttr("id", id);
      $item.$setAttr("oid", OID);
      $item.$setAttr("itemKey", itemKey);
      $item.$setAttr("tree", tree + 1);
      $item.$setAttr("load", false);
      $item.$setAttr("enable", Enable);
      $item.$setAttr("disableSelect", disableSelect);
      $item.$setAttr("parentid", ParentID);
      $item.$setAttr("nodetype", NodeType);
      switch (Enable) {
        case DictState.Enable:
          $item.$addClass("enable");
          break;
        case DictState.Disable:
          $item.$addClass("disable");
          break;
        case DictState.Discard:
          $item.$addClass("discard");
          break;
      }
      $item.$setInnerText(caption);
      this.setItemStyle($item);
      let self2 = this;
      $item.$click(function(e) {
        if (!self2.enable)
          return;
        var item = YElement.buildFromVNode(this);
        var node = new ItemData({ oid: item.getAttr("oid"), itemKey: item.getAttr("itemKey") });
        if (!item.getAttr("disableSelect")) {
          self2.doTitle(item);
          self2.doItem(item);
          self2.value = node;
          self2.commitValue(node);
        }
      });
    }
  }
  setItemStyle($li) {
    let { foreColor, format } = this.owner.style;
    foreColor && $li.$addStyle("color", foreColor);
    if (format) {
      let { font, size, italic, bold } = format;
      if (font) {
        size && $li.$addStyle("fontSize", size);
        italic && $li.$addStyle("fontStyle", "italic");
        bold && $li.$addStyle("fontWeight", "700");
      }
    }
  }
  checkDict() {
    let fn = this.owner.checkDict;
    if (typeof fn === "function") {
      return fn.apply(this.owner, arguments);
    }
  }
  getDictChildren() {
    var fn = this.owner.getDictChildren;
    if (typeof fn === "function") {
      return fn.apply(this.owner, arguments);
    }
  }
  getItemKey() {
    let fn = this.owner.getItemKey;
    if (typeof fn === "function") {
      return fn.apply(this.owner, arguments);
    }
  }
  getQueryCols() {
    let fn = this.owner.getQueryCols;
    if (typeof fn === "function") {
      return fn.apply(this.owner, arguments);
    }
  }
  getTreePath() {
    var fn = this.owner.getTreePath;
    if (typeof fn === "function") {
      return fn.apply(this.owner, arguments);
    }
  }
  setPromptText() {
  }
  reset() {
  }
  setValue(value) {
    if (value) {
      this.value = value;
      this.showing(this.value);
    } else {
      this.$dtree.getChildElms().forEach(($tree, i) => {
        $tree.$findByClassName("item").forEach((item) => item.$removeClass("check"));
        if (i > 0) {
          $tree.$addClass("hide");
        } else {
          $tree.$removeClass("hide");
        }
      });
      this.$dtreetitle.getChildElms().forEach(($tree, i) => {
        $tree.$removeClass("check");
        if (i > 0) {
          $tree.$addClass("hide");
        } else {
          $tree.$removeClass("hide");
        }
      });
    }
  }
  repaint() {
    this.$dtreetitle.getChildElms().forEach((el) => el.$remove());
    this.$dtree.getChildElms().forEach((el) => el.$remove());
    this.renderDictData();
  }
  doFocusOut() {
    var fn = this.owner.doFocusOut;
    if (typeof fn === "function") {
      return fn.apply(this.owner, arguments);
    }
  }
  async renderDictData() {
    var result = await this.checkDict();
    if (result) {
      this.setDictTreeTitle(result.rootCaption, result.root.oid, 0, false, result.root.nodeType);
      this.renderTreeNodes(result.root);
    }
  }
}
class YesDictPaneBuilder extends YesComponentBuilder {
  static create(options) {
    var comp;
    if (options.showType == DictPaneShowType.LEVEL) {
      comp = new YesVDictPaneLevel(options);
    } else {
      comp = new YesVDictPaneTree(options);
    }
    return comp;
  }
}
class YesVMobileMenu extends YesVBaseComponent {
  constructor(options) {
    super(options);
    this.form = options.form;
  }
  createHtml() {
    this.menu = new MainMenu$1({ el: this.el, form: this.form });
  }
}
class YesVNavigationList extends YesVBaseComponent {
  constructor(options) {
    super(options);
  }
  createHtml() {
    this.el.$addClass("ui-navlist");
  }
  render(ct) {
    super.render(ct);
    this.doItems();
  }
  async doItems() {
    if (this.owner.source == 1) {
      this.owner.doMainMenu(this.el);
    } else {
      this.renderItems();
    }
  }
  renderItems() {
    let items = this.owner.items;
    if (items && items.length > 0) {
      this.$navlist = YElement.buildFromVNode(h("div.navlist-view")).$appendTo(this.el);
      let itemWidth = "100%";
      if (this.owner.itemStyle == 1) {
        this.$navlist.$addClass("tiled");
        itemWidth = 100 / this.owner.columnCount + "%";
      }
      items.forEach(async (item) => {
        let $item = YElement.buildFromVNode(h("div.navlist-item", {
          on: {
            click: () => {
              this.owner.doItemOnClick(item.key, this.el);
            }
          }
        })).$appendTo(this.$navlist);
        if (item.icon) {
          let $icon = YElement.buildFromVNode(h("img.img")).$appendTo($item);
          let url = await this.owner.getImageBase64URL(item.icon);
          $icon.$setAttr("src", url);
          this.setIconStyle($icon);
        }
        item.caption && YElement.buildFromVNode(h("label.label", {}, item.caption)).$appendTo($item);
        $item.$setWidth(itemWidth);
        this.setItemStyle($item);
      });
    }
  }
  itemHidden() {
    this.$navlist.$hide();
  }
  itemShow() {
    this.$navlist.$show();
  }
  setIconStyle($icon) {
    $icon.$addClass(ImageScaleType.toString(this.owner.imageScaleType));
  }
  setItemStyle($item) {
    if (this.owner.listRow) {
      let { backColor, bottomPadding, foreColor, highlightBackColor, leftPadding, padding, rightPadding, size, topPadding } = this.owner.listRow;
      if (backColor) {
        $item.$addStyle("background-color", backColor);
      }
      if (foreColor) {
        $item.$addStyle("color", foreColor);
      }
      if (highlightBackColor) {
        CssUtil.setHighlightBackColor($item, highlightBackColor);
      }
      if (size > 0) {
        $item.$addStyle("font-size", size);
      }
      if (padding) {
        $item.$addStyle("padding", padding);
      }
      if (topPadding) {
        $item.$addStyle("padding-top", topPadding);
      }
      if (rightPadding) {
        $item.$addStyle("padding-right", rightPadding);
      }
      if (bottomPadding) {
        $item.$addStyle("padding-bottom", bottomPadding);
      }
      if (leftPadding) {
        $item.$addStyle("padding-left", leftPadding);
      }
    }
  }
}
class YesNavigationListBuilder extends YesComponentBuilder {
  static create(options) {
    return new YesVNavigationList(options);
  }
}
const regH5Controls = () => {
  ControlMapping.getInstance().reg(ControlType.DICTPANE, YesDictPaneBuilder);
  ControlMapping.getInstance().reg(ControlType.CONTAINER, YesTabContainerBuilder);
  ControlMapping.getInstance().reg(ControlType.TEXTAREA, YesMTextAreaBuilder);
  ControlMapping.getInstance().reg(ControlType.SEPARATOR, YesSeparatorBuilder);
  ControlMapping.getInstance().reg(ControlType.COMBOBOX, YesMComboBoxBuilder);
  ControlMapping.getInstance().reg(ControlType.CHECKLISTBOX, YesMCheckListBoxBuilder);
  ControlMapping.getInstance().reg(ControlType.IMAGE, YesMImageBuilder);
  ControlMapping.getInstance().reg(ControlType.TEXTEDITOR, YesTextEditorBuilder);
  ControlMapping.getInstance().reg(ControlType.PASSWORDEDITOR, YesPasswordEditorBuilder);
  ControlMapping.getInstance().reg(ControlType.BATCHIMAGEUPLOADER, YesMBatchImageUploaderBuilder);
  ControlMapping.getInstance().reg(ControlType.VIDEOPLAYER, YesMVideoPlayerBuilder);
  ControlMapping.getInstance().reg(ControlType.TOOLBAR, YesMToolbarBuilder);
  ControlMapping.getInstance().reg(ControlType.DATEPICKER, YesDatePickerBuilder);
  ControlMapping.getInstance().reg(ControlType.UTCDATEPICKER, YesUTCDatePickerBuilder);
  ControlMapping.getInstance().reg(ControlType.MONTHPICKER, YesMonthPickerBuilder);
  ControlMapping.getInstance().reg(ControlType.TIMEPICKER, YesTimePickerBuilder);
  ControlMapping.getInstance().reg(ControlType.DICT, YesDictBuilder);
  ControlMapping.getInstance().reg(ControlType.DICTSEARCHBOX, YesDictSearchBoxBuilder);
  ControlMapping.getInstance().reg(ControlType.NUMBEREDITOR, YesMNumberEditorBuilderBuilder);
  ControlMapping.getInstance().reg(ControlType.NAVIGATIONLIST, YesNavigationListBuilder);
  ControlMapping.getInstance().reg(ControlType.TABPANEL, YesTabPanelBuilder);
  ControlMapping.getInstance().reg(ControlType.DYNAMICDICT, YesDynamicDictBuilder);
  ControlMapping.getInstance().reg(ControlType.FLEXFLOWLAYOUTPANEL, YesMFlexflowLayoutPanelPanelBuilder);
  ControlMapping.getInstance().get(ControlType.CUSTOM).reg("MobileMenu", YesVMobileMenu);
};
const removeNode = function(pdom) {
  while (pdom.hasChildNodes()) {
    pdom.setAttribute("style", "");
    pdom.setAttribute("id", "");
    pdom.removeChild(pdom.firstChild);
  }
};
class YesVNavigationBar {
  constructor(options) {
    this.form = options;
    this.navigation = this.form.metaForm.navigation || {};
    this.caption = options.caption;
    this.uiRightButton = false;
    this.uiLeftButton = false;
    this.hasRightdot = true;
    this.hasLeftBack = this.form.pFormID ? true : false;
    this.init();
  }
  init() {
    let { hasRightButton, rightButton, hasLeftButton, leftButton } = this.navigation;
    if (hasRightButton != "false") {
      if (rightButton && rightButton.icon) {
        this.uiRightButton = true;
        this.hasRightdot = false;
      }
    }
    if (hasLeftButton != "false") {
      if (leftButton && leftButton.icon) {
        this.uiLeftButton = true;
        this.hasLeftBack = false;
      }
    }
  }
  async getBaseImage(path, form, thumbnail, sourceType) {
    let params = {
      path,
      formKey: form.formKey,
      thumbnail,
      sourceType
    };
    return await SvrMgr.getBase64Image(params);
  }
  createHtml() {
    this.el.classList.add("ui-nav");
    this.$navel = document.createElement("div");
    this.$navel.classList.add("ui-navview");
    this.el.appendChild(this.$navel);
    this.$leftel = document.createElement("div");
    this.$leftel.classList.add("ui-navleft");
    this.$navel.appendChild(this.$leftel);
    this.$centerel = document.createElement("div");
    this.$centerel.classList.add("ui-navcenter");
    this.$navel.appendChild(this.$centerel);
    this.$rightel = document.createElement("div");
    this.$rightel.classList.add("ui-navright");
    this.$navel.appendChild(this.$rightel);
    this.$label = document.createElement("div");
    this.$label.classList.add("ui-nav-label");
    this.caption = this.form.getAbbrCaption();
    this.$label.innerHTML = this.caption;
    this.$centerel.appendChild(this.$label);
    if (this.hasLeftBack) {
      this.leftback = document.createElement("div");
      this.leftback.classList.add("leftback");
      this.$leftel.appendChild(this.leftback);
    }
    if (this.uiLeftButton) {
      this.leftButton = document.createElement("img");
      this.leftButton.classList.add("img");
      this.$leftel.appendChild(this.leftButton);
    }
    if (this.uiRightButton) {
      this.rightButton = document.createElement("img");
      this.rightButton.classList.add("img");
      this.$rightel.appendChild(this.rightButton);
    }
    this.rightdot = document.createElement("div");
    this.rightdot.classList.add("right-dot");
    this.rightdot.classList.add("hide");
    this.$rightel.appendChild(this.rightdot);
    this.optover = document.createElement("div");
    this.optover.classList.add("optover");
    this.optover.classList.add("hide");
    this.$navel.appendChild(this.optover);
    this.optview = document.createElement("div");
    this.optview.classList.add("optview");
    this.optover.appendChild(this.optview);
  }
  render(el) {
    this.el = el;
    this.setStatusBarHeight();
    this.createHtml();
    this.initStyle();
    this.install();
  }
  // 设置原生状态条的高度
  setStatusBarHeight() {
    let statusbar = document.createElement("div");
    statusbar.classList.add("ui-statusbar");
    statusbar.style.height = InterActiveFactory.interactiveHeigth + "px";
    this.el.appendChild(statusbar);
  }
  // 清空当前的opt操作
  clearOperation() {
  }
  // 新增当前的opt
  addOperation(opts) {
    this.opts = opts;
    this.newOpts = opts;
  }
  repaint() {
    if (this.newOpts && this.newOpts.length > 0) {
      let vlen = 0;
      this.newOpts.forEach((opt) => {
        if (!opt.visible || !opt.enable) {
          vlen++;
        }
      });
      if (vlen != this.newOpts.length) {
        this.rightdot.classList.remove("hide");
      } else {
        this.rightdot.classList.add("hide");
      }
    }
  }
  // 重新构建opt
  renderItems() {
    if (this.newOpts && this.newOpts.length > 0) {
      let self2 = this;
      this.rightdot.classList.remove("hide");
      removeNode(this.optview);
      let navtool = document.createElement("div");
      navtool.classList.add("navtool");
      this.optview.appendChild(navtool);
      let toollabel = document.createElement("span");
      toollabel.innerHTML = "操作";
      toollabel.classList.add("toollabel");
      navtool.appendChild(toollabel);
      let tooldelete = document.createElement("span");
      tooldelete.classList.add("tooldelete");
      navtool.appendChild(tooldelete);
      let optul = document.createElement("ul");
      optul.classList.add("opts");
      this.optview.appendChild(optul);
      let vlen = 0;
      this.newOpts.forEach((opt) => {
        let li = document.createElement("li");
        li.classList.add("opt");
        li.setAttribute("opt-key", opt.key);
        optul.appendChild(li);
        if (opt.icon) {
          let img = document.createElement("img");
          li.appendChild(img);
          this.getBaseImage(opt.icon, this.form, null, null).then((url) => {
            img.setAttribute("src", url);
          });
        }
        let label;
        if (opt.caption) {
          label = document.createElement("label");
          label.innerHTML = opt.caption;
          li.appendChild(label);
          if (opt.items && opt.items.length > 0) {
            li.classList.add("more");
          }
        }
        if (!opt.visible || !opt.enable) {
          li.classList.add("hide");
          vlen++;
        }
        li.onclick = debounce(async function(e) {
          if (this.classList.contains("more")) {
            await self2.form.asyncEval(opt.action, new ViewContext(self2.form));
            await self2.form.addOperation();
            self2.newOpts = self2.getItem(opt.key);
            self2.renderItems();
            scaledown(self2.optview);
          } else {
            scaleup(self2.optview, async () => {
              self2.optover && self2.optover.classList.add("hide");
              await self2.form.asyncEval(opt.action, new ViewContext(self2.form));
              self2.newOpts = self2.opts;
            });
          }
          e.stopPropagation();
        });
      });
      if (vlen == this.newOpts.length) {
        self2.newOpts = self2.opts;
        self2.optover.classList.add("hide");
        self2.rightdot.classList.add("hide");
      } else {
        var w = window.innerWidth - 40;
        var hidden_div = Math.floor(w / 82);
        let _len = (this.newOpts.length - vlen) % hidden_div;
        if (_len != 0) {
          let len = hidden_div - _len;
          for (let j = 0; j < len; j++) {
            let optOnshow = document.createElement("li");
            optOnshow.classList.add("opt");
            optOnshow.classList.add("onshow");
            optul.appendChild(optOnshow);
          }
        }
      }
    }
  }
  initStyle() {
    let { backColor, backImage, foreColor, leftButton, rightButton } = this.navigation;
    if (backColor) {
      this.el.style.backgroundColor = backColor;
    }
    if (backImage) {
      this.getBaseImage(backImage, this.form, null, null).then((url) => {
        this.el.style.backgroundImage = "url(" + url + ")";
      });
    }
    if (foreColor) {
      this.el.style.color = foreColor;
    }
    if (this.uiLeftButton) {
      this.getBaseImage(leftButton.icon, this.form, null, null).then((url) => {
        this.leftButton.setAttribute("src", url);
      });
    }
    if (this.uiRightButton) {
      this.getBaseImage(rightButton.icon, this.form, null, null).then((url) => {
        this.rightButton.setAttribute("src", url);
      });
    }
    if (!this.hasRightdot) {
      this.rightdot.classList.add("dot-hide");
    }
  }
  getItem(key) {
    var item;
    var operation = function(items) {
      for (var i = 0; i < items.length; i++) {
        if (items[i].key == key) {
          item = items[i];
          break;
        }
        if (items[i].items) {
          operation(items[i].items);
        }
      }
      if (item) {
        return item.items;
      }
    };
    return operation(this.opts);
  }
  setItemVisible(key, visible) {
    if (!this.opts)
      return;
    for (let i = 0; i < this.opts.length; i++) {
      let opt = this.opts[i];
      if (opt.key == key) {
        opt["visible"] = visible;
        this.newOpts[i]["visible"] = visible;
        break;
      }
    }
    this.repaint();
  }
  setItemEnable(key, enable) {
    if (!this.opts)
      return;
    for (let i = 0; i < this.opts.length; i++) {
      let opt = this.opts[i];
      if (opt.key == key) {
        opt["enable"] = enable;
        this.newOpts[i]["enable"] = enable;
        break;
      }
    }
    this.repaint();
  }
  updateNavBar(form) {
    removeNode(this.el);
    if (form.metaForm.hasNavigationBar) {
      let yesnavbar = new YesVNavigationBar(form);
      yesnavbar.render(this.el);
      form.setNavigationBar(yesnavbar);
      form.addOperation(yesnavbar);
      this.el.setAttribute("id", form.formID + "_navigation");
    }
  }
  setFormCaption(caption) {
    this.$label.innerHTML = caption;
  }
  destory() {
    for (const key in this) {
      if (this[key]["onclick"]) {
        this[key]["onclick"] = null;
      }
      delete this[key];
    }
  }
  install() {
    let self2 = this;
    this.leftback && (this.leftback.onclick = function(e) {
      if (self2.navigation.leftButton && self2.navigation.leftButton.content) {
        self2.form.asyncEval(
          self2.navigation.leftButton.content,
          new ViewContext(self2.form)
        );
      } else {
        self2.form.fireClose();
      }
    });
    this.optover.onclick = function(e) {
      scaleup(self2.optview, () => {
        self2.optover && self2.optover.classList.add("hide");
        self2.newOpts = self2.opts;
      });
      e.stopPropagation();
    };
    this.rightdot.onclick = function(e) {
      self2.renderItems();
      self2.optover.classList.remove("hide");
      self2.optover.style.zIndex = ZIndexUtil.getZIndex(self2.form, "navopt");
      scaledown(self2.optview);
      e.stopPropagation();
    };
    this.uiLeftButton && (this.leftButton.onclick = function(e) {
      if (self2.navigation.leftButton.content) {
        self2.form.asyncEval(
          self2.navigation.leftButton.content,
          new ViewContext(self2.form)
        );
      } else {
        self2.form.fireClose();
      }
      e.stopPropagation();
    });
    this.uiRightButton && (this.rightButton.onclick = function(e) {
      self2.form.asyncEval(
        self2.navigation.rightButton.content,
        new ViewContext(self2.form)
      );
      e.stopPropagation();
    });
  }
}
const scaledown = (el) => {
  el.classList.add("show");
  el.classList.add("scaledown");
  let animationend1 = function() {
    el.classList.remove("scaledown");
    el.removeEventListener("animationend", animationend1);
  };
  el.addEventListener("animationend", animationend1);
};
const scaleup = (el, fn) => {
  el.classList.add("scaleup");
  let animationend1 = function() {
    el.classList.remove("scaledown");
    el.classList.remove("scaleup");
    el.classList.remove("show");
    fn();
    el.removeEventListener("animationend", animationend1);
  };
  el.addEventListener("animationend", animationend1);
};
const buildVNode = YElement.buildFromVNode;
class Tabs {
  constructor(options) {
    this.app = options.parent;
    this.rendering = false;
    this.renderFormIng = [];
    Tabs.instance = this;
    this.init();
    this.appInstall();
    this.yesformMap = /* @__PURE__ */ new Map();
  }
  init() {
    this.overlay = document.createElement("div");
    this.overlay.setAttribute("id", "overlay");
    this.overlay.classList.add("hide");
    this.app.appendChild(this.overlay);
  }
  //静态方法
  static getInstance(options) {
    if (!this.instance) {
      this.instance = new Tabs(options);
    }
    return this.instance;
  }
  createHTML() {
    this.main = document.createElement("div");
    this.main.className = "home-page";
    this.navel = document.createElement("div");
    this.overlay.classList.remove("hide");
    this.main.appendChild(this.navel);
    this.app.appendChild(this.main);
  }
  setCurrent(form) {
    this.main.setAttribute("id", form.formID + "_" + form.formKey);
    this.main.setAttribute("formID", form.formID);
    let _pform = form.getParentForm();
    let containerForm = _pform == null ? void 0 : _pform.containerForm;
    var pform = containerForm ? containerForm : form.getParentForm();
    if (pform) {
      let phomePages = pform && document.getElementById(pform.formID + "_" + pform.formKey);
      this.main.classList.add("show");
      this.main.classList.add("movein");
      let self2 = this;
      const _doCurrent = function(self22, pform2, phomePages2) {
        self22.main.classList.remove("movein");
        phomePages2 == null ? void 0 : phomePages2.classList.remove("show");
        self22.closeTimerTasks(pform2);
        self22.overlay.classList.add("hide");
      };
      if (MLogin$1.loginForm == form.formKey) {
        _doCurrent(self2, pform, phomePages);
        self2.rendering = false;
        if (self2.renderFormIng[0]) {
          self2.add(self2.renderFormIng[0].form, self2.renderFormIng[0].container);
          self2.renderFormIng.splice(0, 1);
        }
      } else {
        let animationend2 = function() {
          _doCurrent(self2, pform, phomePages);
          self2.main.removeEventListener("animationend", animationend2);
          self2.rendering = false;
          if (self2.renderFormIng[0]) {
            self2.add(self2.renderFormIng[0].form, self2.renderFormIng[0].container);
            self2.renderFormIng.splice(0, 1);
          }
        };
        this.main.addEventListener("animationend", animationend2);
      }
    } else {
      this.main.classList.add("show");
      this.overlay.classList.add("hide");
      this.rendering = false;
      if (this.renderFormIng[0]) {
        this.add(this.renderFormIng[0].form, this.renderFormIng[0].container);
        this.renderFormIng.splice(0, 1);
      }
    }
  }
  addForm(form) {
    this.createHTML();
    if (MLogin$1.loginForm == form.formKey) {
      this.main.classList.add("login");
    }
    let _el = document.createElement("div");
    const el = buildVNode(h("div.form"));
    this.main.appendChild(_el);
    this.convertNodeToVnode(_el, el);
    const yesform = new YesForm({ form, el });
    this.yesformMap.set(form.formID, yesform);
    this.setCurrent(form);
    this.doNavigationBar(form);
    this.renderWaterMark(form, el);
    yesform.render();
  }
  // 处理导航栏
  doNavigationBar(form) {
    if (!form.metaForm.hasNavigationBar) {
      this.navel.style.display = "none";
    }
    let yesnavbar = new YesVNavigationBar(form);
    yesnavbar.render(this.navel);
    form.setNavigationBar(yesnavbar);
    form.addOperation(yesnavbar);
    this.navel.setAttribute("id", form.formID + "_navigation");
  }
  renderWaterMark(form, formElm) {
    formElm.addPostpatchHook(() => {
      if (form.watermark && form.watermark.formulaText) {
        form.asyncEval(form.watermark.formulaText, new ViewContext(form)).then(function(result) {
          if (result) {
            var waterObj = Object.assign({
              caption: result,
              el: formElm.getElm(),
              form
            }, form.watermark);
            new WaterMark().init(waterObj);
          }
        });
      }
    });
  }
  add(form, container) {
    if (!form)
      return;
    if (form.formID == this.currentFormID)
      return;
    form.setUserID(SessionInfo.getUserID());
    if (this.rendering) {
      this.renderFormIng.push({ form, container });
    } else {
      this.currentFormID = form.formID;
      this.rendering = true;
      if (form.eventHandlerCollection) {
        Env.addSendSignalForm(form);
      }
      FallBackUtil.addFallBack(form);
      this.overlay.classList.remove("hide");
      this.addForm(form);
      this.startTimeTasks(form);
      this.overlay.addEventListener("click", (e) => e.stopPropagation());
    }
  }
  // 父亲节点为container
  addFormByContainer(form) {
    this.add(form, true);
  }
  setFormCaption(caption) {
    this.main.querySelector(".ui-nav-label").innerHTML = caption;
  }
  convertNodeToVnode(node, vnode) {
    vnode.$setRawDomElm(node);
  }
  backForm(form) {
    MLogin$1.doClose(form);
    this.overlay.classList.remove("hide");
    var pform = form.getParentForm();
    if (pform) {
      let phomePages = document.getElementById(pform.formID + "_" + pform.formKey);
      phomePages == null ? void 0 : phomePages.classList.add("show");
    }
    let self2 = this;
    let homePages = document.getElementById(form.formID + "_" + form.formKey);
    if (homePages) {
      let formID = form.formID;
      FormStack.removeForm(formID);
      form.getNavigationBar().destory();
      self2.navel = null;
      self2.closeTimerTasks(form);
      homePages == null ? void 0 : homePages.classList.remove("movein");
      homePages == null ? void 0 : homePages.classList.remove("show");
      homePages == null ? void 0 : homePages.remove();
      self2.currentFormID = pform ? pform.formID : null;
      self2.startTimeTasks(pform);
      self2.overlay.classList.add("hide");
    }
  }
  async close(form) {
    MLogin$1.doClose(form);
    if (form.formKey != MLogin$1.loginForm) {
      FallBackUtil.removeFallBack();
    }
    this.overlay.classList.remove("hide");
    let _pform = form.getParentForm();
    let containerForm = _pform == null ? void 0 : _pform.containerForm;
    var pform = containerForm ? containerForm : form.getParentForm();
    if (pform) {
      if (pform.getUserID() != SessionInfo.getUserID()) {
        pform.setUserID(SessionInfo.getUserID());
        var ref = new RightsService(pform);
        ref && ref.clear();
        var _ref = new MetaService(pform);
        _ref && _ref.clear();
        await pform.showDocument();
      }
      let phomePages = document.getElementById(pform.formID + "_" + pform.formKey);
      phomePages == null ? void 0 : phomePages.classList.add("show");
      if (pform.eventHandlerCollection) {
        Env.doSendSignalForm(pform);
      }
    }
    let self2 = this;
    let homePages = document.getElementById(form.formID + "_" + form.formKey);
    const _close = function(self22, form2, homePages2, pform2) {
      let formID = form2.formID;
      FormStack.removeForm(formID);
      form2.getNavigationBar().destory();
      self22.navel = null;
      self22.closeTimerTasks(form2);
      homePages2 == null ? void 0 : homePages2.classList.remove("movein");
      homePages2 == null ? void 0 : homePages2.classList.remove("show");
      homePages2 == null ? void 0 : homePages2.remove();
      self22.currentFormID = pform2 ? pform2.formID : null;
      self22.startTimeTasks(pform2);
      self22.overlay.classList.add("hide");
      self22.yesformMap.delete(formID);
    };
    if (homePages) {
      homePages == null ? void 0 : homePages.classList.add("moveout");
      if (MLogin$1.loginForm == form.formKey) {
        _close(self2, form, homePages, pform);
      } else {
        var animationend1 = function() {
          _close(self2, form, homePages, pform);
          homePages.removeEventListener("animationend", animationend1);
        };
        homePages.addEventListener("animationend", animationend1);
      }
    }
  }
  closeAll() {
    var self2 = this;
    var options = {
      msg: I18N.getString("GRID_WHETHERCLOSEALL", "是否关闭所有表单?"),
      msgType: DialogType.YES_NO,
      events: {
        YES: function() {
          FormStack.getFormList().reverse().forEach(async (form, i) => {
            if (MLogin$1.startForm != form.formKey) {
              await self2.close(form);
            }
          });
          FallBackUtil.removeAllBack();
          return Promise.resolve(true);
        },
        NO: function() {
          return Promise.resolve(true);
        }
      }
    };
    var dialog = DialogFactory.create(options);
    dialog.show();
  }
  getEL() {
    return this.main;
  }
  getActiveFormID() {
    return this.currentFormID;
  }
  appInstall() {
    this.app.addEventListener("scroll", () => {
      this.app.scrollLeft = 0;
    });
  }
  startTimeTasks(form) {
    if (!form)
      return;
    var manager = TimerTaskManagerFactory.createManager(form);
    if (manager) {
      manager.startTasks();
    }
  }
  closeTimerTasks(form) {
    if (!form)
      return;
    var manager = TimerTaskManagerFactory.getManager(form.formID);
    try {
      if (manager) {
        manager.closeAllTasks();
      }
    } finally {
      TimerTaskManagerFactory.removeManager(form.formID);
    }
  }
  reRender(form) {
    const currentYesForm = this.yesformMap.get(form.formID);
    currentYesForm.reloadForm(form);
    currentYesForm.render();
  }
}
class MLogin {
  constructor(options) {
  }
  renderDefault(path) {
    this.el = document.createElement("iframe");
    this.el.className = "m_login";
    document.body.appendChild(this.el);
    this.el.setAttribute("src", path);
  }
  setZindex(zIndex) {
    this.el.style.zIndex = zIndex;
  }
  remove() {
    this.el.remove();
  }
  // 默认的的登录界面，取消按钮触发的事件
  removeHtml() {
    this.el.remove();
  }
}
MloginProvider.setInstance({
  create(option) {
    return new MLogin(option);
  }
});
class MainMenu {
  constructor(options) {
    this.loading = true;
    this.options = options;
    this.columnCount = options.columnCount || 3;
    this.isparent = !!options.menu;
    this.init();
  }
  async init() {
    this.createMenuHtml();
    let _result = await this.options.getItems();
    this.data = _result.entry.children;
    this.caption = _result.caption;
    this.addItems(this.data, this.$content);
    if (this.isparent) {
      this.createBackBtn(this.$content, "p-0");
    }
  }
  createMenuHtml() {
    this.$wrap = YElement.buildFromVNode(h("div.navlist-mainmenu"));
    this.$content = YElement.buildFromVNode(h("div.navlist-mainmenu-content")).$appendTo(this.$wrap);
    this.options.el.$append(this.$wrap);
  }
  addItems(data, container, parentIndex) {
    container.getChildElms().forEach((el) => el.$remove());
    data.forEach((v, i) => {
      container.$append(this.createItem(i, v, parentIndex));
    });
  }
  createItem(i, data, parentIndex) {
    let self2 = this;
    var _className = data.children ? "folder" : "file", menuIndex = parentIndex != void 0 ? parentIndex + "-" + i : i + "", $icon = YElement.buildFromVNode(h("span")), $text = YElement.buildFromVNode(h("span.text", {}, data.name));
    var _div = YElement.buildFromVNode(h("div.navlist-mainmenu-item." + _className, {
      on: {
        click(e) {
          if (self2.loading) {
            self2.loading = false;
            LoadingUtil.show(1);
            self2.showSubmenu(this).finally(() => {
              LoadingUtil.hide();
              self2.loading = true;
            });
          }
        }
      }
    }));
    _div.$setProp("menuIndex", menuIndex);
    _div.$append($icon);
    _div.$append($text);
    _div.$setAttr("path", data.path);
    _div.$setAttr("formKey", data.formKey);
    _div.$addStyle("width", `calc(100%/${this.columnCount})`);
    if (data.icon) {
      $icon.$addClass("path");
      this.renderIcon($icon, data.icon);
    } else {
      $icon.$addClass("icon");
    }
    return _div;
  }
  async renderIcon($icon, icon) {
    let _icon = await this.options.getImageBase64URL(icon);
    $icon.$addStyle("background-image", "url(" + _icon + ")");
  }
  showSubmenu(target) {
    var $target = YElement.buildFromVNode(target), menuIndex = $target.getProp("menuIndex"), isFolder = $target.hasClass("folder");
    if (isFolder) {
      var submenuData = this.getMenuData(this.data, menuIndex);
      this.addItems(submenuData, this.$content, menuIndex);
      this.createBackBtn(this.$content, menuIndex);
      return Promise.resolve();
    } else {
      var path = $target.getAttr("path");
      var formKey = $target.getAttr("formKey");
      return this.options.doForm(path, formKey);
    }
  }
  goback(target) {
    var $target = YElement.buildFromVNode(target), arr = $target.getProp("menuIndex").split("-");
    arr.pop();
    if (arr.length) {
      if (arr.length == 1 && arr[0] == "p") {
        this.options.itemShow();
        this.$wrap.$remove();
      } else {
        var menuIndex = arr.join("-");
        this.addItems(this.getMenuData(this.data, menuIndex), this.$content, menuIndex);
        this.createBackBtn(this.$content, menuIndex);
      }
    } else {
      this.addItems(this.data, this.$content, menuIndex);
      if (this.isparent) {
        this.createBackBtn(this.$content, "p-0");
      }
    }
  }
  //返回array
  getMenuData(data, menuIndex) {
    var arr = menuIndex.split("-");
    function getChildren(data2, arr2) {
      if (arr2.length <= 1) {
        return data2[arr2.shift()].children;
      } else {
        return getChildren(data2[arr2.shift()].children, arr2);
      }
    }
    return getChildren(data, arr);
  }
  createBackBtn(container, menuIndex) {
    let self2 = this;
    let $back = YElement.buildFromVNode(h("div.navlist-mainmenu-back", {
      on: {
        click() {
          self2.goback(this);
        }
      }
    })).$prependTo(container);
    $back.$setProp("menuIndex", menuIndex);
    return $back;
  }
}
MainMenuProvider.setInstance({
  create(option) {
    return new MainMenu(option);
  }
});
const mobile = "";
export {
  Tabs as T,
  regH5Controls as r
};
//# sourceMappingURL=yes-ui-m-f2cea9c3.js.map
