var __defProp2 = Object.defineProperty;
var __defNormalProp = (obj, key2, value) => key2 in obj ? __defProp2(obj, key2, { enumerable: true, configurable: true, writable: true, value }) : obj[key2] = value;
var __publicField = (obj, key2, value) => {
  __defNormalProp(obj, typeof key2 !== "symbol" ? key2 + "" : key2, value);
  return value;
};
import { U as Utils, H as HashMap, J as DomEventQueue, L as LoadingUtil, K as I18N, P as VAlignment, Q as HAlignment, R as CssUtil, m as TypeConvertor, v as ViewContext, W as ToolTipUtil, w as ControlType, X as CompSetting, Y as TraceUIOptEvent, _ as IconSourceLoader, $ as CompDataType, a0 as ChartType, a1 as PositionUtil, a2 as PromptType, a3 as CaseType, a4 as TextFormat, a5 as RoundingMode, a6 as GridSetting, a7 as Dialog$1, a8 as DialogType, a9 as Exception, aa as DateFormat, ab as DateLangUtil, ac as DatePickerSetting, ad as ComboBoxSetting, ae as DictSetting, af as SelectTextFocusType, ag as PageLoadType, ah as SystemField, ai as FileUtil, aj as ImageScaleType, ak as ImageSourceType, al as ImageTypes, am as Request, an as BaseDialog$1, ao as TimeFormat, ap as DirectionType, Z as ZIndexUtil, e as FallBackUtil, aq as FormUIStatusMask, k as FormStack, ar as RichDocService, as as ContainerStyle, at as DialogFactory, au as ImgSetting, av as MapDrawType, aw as MapSetting, ax as DateUtil, ay as BaseDialogProvider, az as ConfirmPanelSetting, aA as DialogBtn, aB as MainUIOptTracer, aC as ItemData, D as DataUtil, aD as DictState, aE as StringUtil, aF as DictType, aG as DictHandler, aH as SecondaryType, aI as Item, aJ as DictService, aK as SizeUtil, aL as BuddyKey_NOT_EXISTS, aM as DesignModeSetting, aN as supportTouch, aO as TableRowType, aP as Popup$1, aQ as BarCodeType, aR as DialogProvider, aS as DialogSetting, aT as ErrorDialogProvider, aU as WarnDialogProvider, h as FormType, aV as MessageFun, aW as EditRowProvider, aX as PopupProvider, I as InterActiveFactory, aY as PopupMenuProvider, aZ as ButtonType, a_ as LocationInfo, a$ as HyperLinkHandler, b0 as ComboBoxHandler, b1 as CheckListBoxHandler, b2 as UploadFileHandler, b3 as ImageHandler, b4 as DictQueryPage, b5 as DictTraceHandler, s as FormTarget, b6 as UIOptTraceFormat, b7 as TimerTaskManagerFactory, b8 as CompEventListener, b9 as HeadInfoUtil, M as MetaService, f as MetaForm, j as FormBuilder, ba as HeadInfoOptType, O as OperationState, i as OptQueue, N as NewOpt, bb as getEntryData, bc as MainContainer, bd as MainFrameInterface, be as LLMChat_SizeOptions, bf as LLMChatReplyType, bg as LLMChatService, bh as LLMChatEnums, bi as LLMChatRelatedDataService, bj as LLMChatAgentRouterService, bk as LLMChatContext, bl as DoneReason, bm as NoticeType, bn as Position, S as SvrMgr, bo as LoadOpt, bp as NotificationMgr } from "./yes-core-636cc260.js";
import { d as h$1, i as init$1, e as classModule, g as propsModule, j as attributesModule, s as styleModule, k as eventListenersModule, l as datasetModule, m as init$2, D as Decimal, o as array, q as primitive, v as vnode, u as utils, w as writeSync, t as html2canvas, E, x as moment, y as snabbdomJsx, z as Cropper, Q as Quill, A as Delta, B as JsBarcode, F as browser, G as interact, V as Viewer, _ } from "./vendor-e1ca6068.js";
const data$1 = new HashMap();
class ControlMapping {
  static getInstance() {
    if (!ControlMapping.instance) {
      ControlMapping.instance = new ControlMapping();
      return ControlMapping.instance;
    }
    return ControlMapping.instance;
  }
  reg(type, Control) {
    data$1.put(type, Control);
  }
  get(com) {
    var type = com.type;
    if (Utils.isNumeric(com)) {
      type = com;
    }
    const result = data$1.get(type).build(com);
    if (!result) {
      console.log(`control ${com.type} not supported!`);
    }
    return result;
  }
  getMap() {
    return data$1;
  }
}
const data = new HashMap();
class EditorMapping {
  static getInstance() {
    if (!EditorMapping.instance) {
      EditorMapping.instance = new EditorMapping();
      return EditorMapping.instance;
    }
    return EditorMapping.instance;
  }
  reg(type, editor) {
    data.put(type, editor);
  }
  get(type) {
    const result = data.get(type);
    if (!result) {
      console.log(`editor ${type} not supported!`);
    }
    return result;
  }
  getMap() {
    return data;
  }
}
const userAgent$1 = navigator.userAgent;
class jq {
  // static $(jq: any): any {
  //     return $(jq);
  // }
  static htmlEncode(html2) {
    return Utils.htmlEncode(html2);
  }
  static extend(target, object) {
    return Object.assign(target, object);
  }
  static isPercentage(data2) {
    return Utils.isPercentage(data2);
  }
  static isNumeric(data2) {
    return Utils.isNumeric(data2);
  }
  static isString(data2) {
    return Utils.isString(data2);
  }
  static isObject(data2) {
    return Utils.isObject(data2);
  }
  static isArray(data2) {
    return Utils.isArray(data2);
  }
  static isUndefined(data2) {
    return Utils.isUndefined(data2);
  }
  static getZindex(elm) {
    return Utils.getZindex(elm);
  }
  // static Deferred(callback: (deferred: any) => any) {
  //     return $.Deferred(callback);
  // }
  // static debounce(delay: number, callback: (event: any) => void) {
  //     return $.debounce(delay, callback);
  // }
  static cookie(key2, value) {
    if (arguments.length == 1) {
      return Utils.getCookie(key2);
    }
    return Utils.setCookie(key2, value);
  }
  static noop() {
    return () => {
    };
  }
  static error(err) {
    throw new Error(err);
  }
}
jq.browser = {
  isSafari: /webkit/.test(userAgent$1),
  opera: /opera/.test(userAgent$1),
  isMozilla: /mozilla/.test(userAgent$1) && !/(compatible|webkit)/.test(userAgent$1),
  isIE: function() {
    var isIE = userAgent$1.indexOf("compatible") > -1 && userAgent$1.indexOf("msie") > -1;
    var isEdge = userAgent$1.indexOf("edge") > -1 && !isIE;
    var isIE11 = userAgent$1.indexOf("trident") > -1 && userAgent$1.indexOf("rv:11.0") > -1;
    return isIE || isIE11 || isEdge;
  }(),
  version: function() {
    var isIE = userAgent$1.indexOf("compatible") > -1 && userAgent$1.indexOf("msie") > -1;
    var isEdge = userAgent$1.indexOf("edge") > -1 && !isIE;
    var isIE11 = userAgent$1.indexOf("trident") > -1 && userAgent$1.indexOf("rv:11.0") > -1;
    if (isIE) {
      var reg = new RegExp("msie (\\d+\\.\\d+);");
      reg.test(userAgent$1);
      var ver = parseFloat(RegExp["$1"]);
      if (ver > 6) {
        return ver;
      } else {
        return 6;
      }
    } else if (isEdge) {
      return "edge";
    } else if (isIE11) {
      return 11;
    } else {
      return (userAgent$1.match(/.+(?:firefox|opera|chrome|netscape)[/: ]([\d.]+)/) || [])[1];
    }
  }()
};
let nextTickQueue = {
  elements: []
};
let globalSuspendPatchDep = 0;
function batchApplyPatch() {
  var roots = nextTickQueue.elements;
  nextTickQueue.elements = [];
  roots.forEach(function(rootEle) {
    rootEle.$applyPatch();
  });
}
function patchTimer(timeout) {
  if (timeout > 0) {
    setTimeout(function() {
      if (globalSuspendPatchDep) {
        batchApplyPatch();
        patchTimer(timeout);
      }
    }, timeout);
  }
}
class vb {
  // private static getSupportedTags(): Array<string> {
  //     let SUPPORTED_TAGS: Array<string> = Object.keys(YesBaseComponents).map(item =>
  //         item.substring(3)
  //     ); // YesButton --> Button
  //     SUPPORTED_TAGS = SUPPORTED_TAGS.concat(Object.keys(panelsMapping)); // BaseComponents基本控件 + layout布局控件
  //     return SUPPORTED_TAGS;
  // }
  static getKeyByValue(object, value) {
    return Object.keys(object).find((key2) => object[key2] === value);
  }
  static supportVNode(yigoComponent) {
    return true;
  }
  static isVirtual(yElmOrDom) {
    if (yElmOrDom.__IsVirtual) {
      return true;
    } else {
      return false;
    }
  }
  static _hasSameVNodeRootInElements(elements, root) {
    if (elements && elements.length > 0 && root) {
      for (let i = 0; i < elements.length; i++) {
        let element = elements[i];
        if (root.compareVNode(element)) {
          return true;
        }
      }
    } else {
      return false;
    }
  }
  static _findRoot(elm) {
    var rootEle = elm.$parents((pEle) => {
      return true;
    });
    return rootEle;
  }
  static noticeChange(elm, msg) {
    const root = vb._findRoot(elm);
    if (!root.supportPatch()) {
      return;
    }
    if (msg === "$remove") {
      root.addRemovedYele(elm);
    }
    if (!vb._hasSameVNodeRootInElements(nextTickQueue.elements, root)) {
      console.log(
        "noticeChange:" + msg
        /*, elm, root*/
      );
      nextTickQueue.elements.push(root);
    }
    root.$setAttachData("willPatch", true);
    if (!(globalSuspendPatchDep || nextTickQueue.callback)) {
      nextTickQueue.callback = batchApplyPatch;
      setTimeout(function() {
        var callback = nextTickQueue.callback;
        nextTickQueue.callback = void 0;
        if (callback) {
          callback.call({});
        }
      }, 0);
    }
  }
  static isGlobalSuspendPatch() {
    return !!globalSuspendPatchDep;
  }
  static suspendRootPatch(options) {
    if (nextTickQueue.callback) {
      nextTickQueue.callback = void 0;
    }
    if (options && options.timeout) {
      patchTimer(options.timeout);
    }
    ++globalSuspendPatchDep;
  }
  static resumeRootPatch() {
    if (globalSuspendPatchDep > 0) {
      --globalSuspendPatchDep;
    }
    if (globalSuspendPatchDep <= 0) {
      let elm = nextTickQueue.elements[0];
      elm && vb.noticeChange(elm, "resumeRootPatch");
    }
  }
}
function toVNodeFun(_vnode, isClone) {
  if (!(_vnode && typeof _vnode === "object")) {
    return _vnode;
  }
  _vnode.data = _vnode.data || {};
  let data2 = {};
  data2.key = isClone ? void 0 : _vnode.key;
  data2.is = _vnode.data.is;
  data2.ns = _vnode.data.ns;
  data2.attrs = _vnode.data.attrs && { ..._vnode.data.attrs };
  data2.class = _vnode.data.class && { ..._vnode.data.class };
  data2.style = _vnode.data.style && { ..._vnode.data.style };
  data2.dataset = _vnode.data.dataset && { ..._vnode.data.dataset };
  data2.hook = _vnode.data.hook && { ..._vnode.data.hook };
  data2.props = _vnode.data.props && { ..._vnode.data.props };
  data2.on = _vnode.data.on && { ..._vnode.data.on };
  data2.attachData = _vnode.data.attachData && { ..._vnode.data.attachData } || {};
  if (isClone) {
    data2.attachData.isRemoved = false;
    data2.attachData.willPatch = false;
    data2.attachData.cleanAfterRemove = false;
    data2.attachData["will-change-children"] = false;
  } else {
    data2.attachData.isOld = true;
  }
  _vnode.data.yelementData = _vnode.data.yelementData || new YElementData();
  _vnode.data.yelementData._oldVNode && delete _vnode.data.yelementData._oldVNode;
  isClone && (data2.yelementData = new YElementData(_vnode.data.yelementData));
  isClone && (data2.yelementData.parentVNode = void 0);
  if (_vnode.sel === "!") {
    let vnode2 = h$1(_vnode.sel, data2, _vnode.text);
    if (!isClone) {
      vnode2.elm = _vnode.elm;
      _vnode.data.yelementData._oldVNode = vnode2;
    }
    vnode2["listener"] = _vnode["listener"];
    return vnode2;
  } else if (_vnode.sel !== void 0 && _vnode.sel !== "text") {
    let text = _vnode.text;
    let children;
    if (_vnode.children) {
      children = [];
      for (let i = 0; i < _vnode.children.length; i++) {
        const cvnode = _vnode.children[i];
        children.push(toVNodeFun(cvnode, isClone));
      }
    }
    let vnode2 = h$1(_vnode.sel, data2, children || text);
    if (isClone) {
      children && children.forEach((c) => {
        if ("string" !== typeof c) {
          var data22 = c.data;
          if (data22) {
            var ydata = data22.yelementData;
            ydata && (ydata.parentVNode = vnode2);
          }
        }
      });
    } else {
      vnode2.elm = _vnode.elm;
      _vnode.data.yelementData._oldVNode = vnode2;
    }
    vnode2["listener"] = _vnode["listener"];
    return vnode2;
  } else {
    let vnode2 = h$1(_vnode.sel || "text", data2, _vnode.text);
    if (!isClone) {
      vnode2.elm = _vnode.elm;
      _vnode.data.yelementData._oldVNode = vnode2;
    }
    vnode2["listener"] = _vnode["listener"];
    return vnode2;
  }
}
function closestEles(curElm, targetElm) {
  let result = [];
  if (curElm === targetElm) {
    result.push(curElm);
  }
  if (curElm.parentElement) {
    result = result.concat(closestEles(curElm.parentElement, targetElm));
  }
  return result;
}
function getClosestEle(target, callback) {
  while (!callback(target)) {
    target = target.parentElement;
    if (!target) {
      return null;
    }
  }
  return target;
}
class _Debounce {
  constructor(fn) {
    this.running = false;
    this.fn = fn;
  }
  doAction() {
    var self2 = this;
    return async function() {
      if (self2.running) {
        return;
      }
      try {
        await DomEventQueue.lock();
        self2.running = true;
        LoadingUtil.show();
        return await self2.fn.apply(this, arguments);
      } finally {
        self2.running = false;
        LoadingUtil.hide();
        DomEventQueue.unlock();
      }
    };
  }
}
const debounce = function(fn) {
  return new _Debounce(fn).doAction();
};
let defaultPageOptions = {
  totalNumber: 1,
  pageNumber: 1,
  pageSize: 10,
  totalPage: 1,
  pageRange: 0,
  prevText: "",
  nextText: "",
  firstText: "",
  lastText: "",
  ellipsisText: "...",
  classPrefix: "paginationjs",
  showGoInput: false,
  showGoButton: false,
  showNavigator: false,
  showFirstButton: false,
  showLastButton: false,
  showPageDetail: true,
  showAllPages: false,
  showPages: false,
  pageIndicatorCount: 3,
  pageChanges: function() {
  }
};
class Pagination {
  constructor(pageContainer, options) {
    this.container = pageContainer;
    this.attributes = jq.extend({}, defaultPageOptions);
    this.attributes = jq.extend(this.attributes, options);
  }
  initialize() {
    this.attributes.totalPage = this.calTotalPage(
      this.attributes.totalNumber,
      this.attributes.pageSize
    );
    var self2 = this;
    this.model = {
      el: self2.container,
      content: self2.container,
      pageRange: this.attributes.pageRange,
      pageSize: this.attributes.pageSize,
      totalNumber: this.attributes.totalNumber,
      totalPage: this.attributes.totalPage,
      pageChanges: this.attributes.pageChanges,
      pageNumber: 1,
      hidePagination: function() {
      },
      setTotalRowCount: function(totalRowCount, resetPageNum) {
      }
    };
    var self2 = this;
    var model = this.model;
    self2.container.$addClass("paginationjs");
    model.el = YElement.buildFromVNode(
      h$1("div", { class: { "paginationjs-pages": true } })
    ).$hide();
    model.content = YElement.buildFromVNode(
      h$1("div", { class: { "paginationjs-content": true } })
    ).$appendTo(self2.container);
    model.el.$appendTo(self2.container);
    model.hidePagination = function() {
      model.el.$hide();
    };
    model.setTotalRowCount = function(totalRowCount, resetPageNum) {
      self2.attributes.totalNumber = totalRowCount;
      this.totalNumber = totalRowCount;
      this.totalPage = self2.calTotalPage(totalRowCount, self2.attributes.pageSize);
      if (resetPageNum) {
        this.pageNumber = 1;
      }
      if (this.pageNumber > this.totalPage) {
        this.pageNumber = this.totalPage;
      }
      self2.render();
    };
    this.observer();
  }
  calTotalPage(totalPage, pageRowCount) {
    if (jq.isNumeric(totalPage)) {
      return Math.ceil(totalPage / pageRowCount);
    }
  }
  render() {
    var model = this.model, el = this.container, currentPage = model.pageNumber || this.attributes.pageNumber, pageRange = this.attributes.pageRange, totalPage = model.totalPage, rangeStart = currentPage - pageRange, rangeEnd = currentPage + pageRange;
    if (rangeEnd > totalPage) {
      rangeEnd = totalPage;
      rangeStart = totalPage - pageRange * 2;
      rangeStart = rangeStart < 1 ? 1 : rangeStart;
    }
    if (rangeStart <= 1) {
      rangeStart = 1;
      rangeEnd = Math.min(pageRange * 2 + 1, totalPage);
    }
    el.$findByClassName("paginationjs-pages")[0].$empty().$append(
      this.createTemplate({
        currentPage,
        totalPage,
        rangeStart,
        rangeEnd
      })
    ).$show();
    return el;
  }
  createTemplate(args) {
    var currentPage = args.currentPage, totalPage = args.totalPage, rangeStart = args.rangeStart, rangeEnd = args.rangeEnd, totalNumber = this.attributes.totalNumber, prevText = this.attributes.prevText, nextText = this.attributes.nextText, ellipsisText = this.attributes.ellipsisText, classPrefix = this.attributes.classPrefix, showGoInput = this.attributes.showGoInput, showGoButton = this.attributes.showGoButton, showFirstButton = this.attributes.showFirstButton, showLastButton = this.attributes.showLastButton, showPageDetail = this.attributes.showPageDetail, showAllPages = this.attributes.showAllPages, showPages = this.attributes.showPages, firstText = this.attributes.firstText, lastText = this.attributes.lastText, pageIndicatorCount = this.attributes.pageIndicatorCount, ulYele = YElement.buildFromVNode(h$1("ul")), i;
    var pageCont = [];
    var self2 = this;
    var el = this.model.el;
    if (currentPage === 1) {
      if (showFirstButton) {
        let firstClass = { disabled: true };
        firstClass[classPrefix + "-firstpage"] = true;
        YElement.buildFromVNode(
          h$1(
            "li",
            {
              class: firstClass,
              attrs: { title: "First Page" }
            },
            h$1("a", null, firstText)
          )
        ).$appendTo(ulYele);
      }
      let prevClass = { disabled: true };
      prevClass[classPrefix + "-prev"] = true;
      YElement.buildFromVNode(
        h$1(
          "li",
          {
            class: prevClass
          },
          h$1("a", null, prevText)
        )
      ).$appendTo(ulYele);
    } else {
      if (showFirstButton) {
        let firstClass = {};
        firstClass[classPrefix + "-firstpage"] = true;
        YElement.buildFromVNode(
          h$1(
            "li",
            {
              class: firstClass,
              attrs: { title: "First Page" }
            },
            h$1("a", null, firstText)
          )
        ).$appendTo(ulYele);
      }
      let prevClass = { "paginationjs-previous": true };
      prevClass[classPrefix + "-prev"] = true;
      YElement.buildFromVNode(
        h$1(
          "li",
          {
            class: prevClass,
            attrs: { title: "Previous page" },
            dataset: { num: (currentPage - 1).toString() }
          },
          h$1("a", null, prevText)
        )
      ).$appendTo(ulYele);
    }
    if (showAllPages) {
      if (rangeStart > pageIndicatorCount) {
        let firstClass = { "paginationjs-page": true };
        firstClass[classPrefix + "-page"] = true;
        firstClass[classPrefix + "-first"] = true;
        let ellipsisClass = { disabled: true };
        ellipsisClass[classPrefix + "-ellipsis"] = true;
        YElement.buildFromVNode(
          h$1(
            "li",
            {
              class: firstClass,
              dataset: { num: "1" }
            },
            h$1("a", null, "1")
          )
        ).$appendTo(ulYele);
        YElement.buildFromVNode(
          h$1(
            "li",
            {
              class: ellipsisClass
            },
            h$1("a", null, ellipsisText)
          )
        ).$appendTo(ulYele);
      } else {
        for (i = 1; i < rangeStart; i++) {
          let cls = { "paginationjs-page": true };
          cls[classPrefix + "-page"] = true;
          cls[classPrefix + "-first"] = true;
          YElement.buildFromVNode(
            h$1(
              "li",
              {
                class: cls,
                dataset: { num: i + "" }
              },
              h$1("a", null, i)
            )
          ).$appendTo(ulYele);
        }
      }
    }
    if (showPages) {
      var len = parseInt(((pageIndicatorCount - 1) / 2).toString());
      if (len >= currentPage) {
        len = currentPage - 1;
      }
      if (totalPage >= pageIndicatorCount && totalPage - currentPage < Math.ceil((pageIndicatorCount - 1) / 2)) {
        len += len - (totalPage - currentPage);
      }
      if (totalPage < pageIndicatorCount) {
        len = currentPage - 1;
      }
      for (var j = len; j >= 1; j--) {
        let cls = { "paginationjs-page": true };
        cls[classPrefix + "-page"] = true;
        cls[classPrefix + "-first"] = true;
        YElement.buildFromVNode(
          h$1(
            "li",
            {
              class: cls,
              dataset: { num: currentPage - j + "" }
            },
            h$1("a", null, currentPage - j)
          )
        ).$appendTo(ulYele);
      }
    }
    for (i = rangeStart; i <= rangeEnd; i++) {
      let cls = { "paginationjs-page": true, active: i == currentPage };
      cls[classPrefix + "-page"] = true;
      YElement.buildFromVNode(
        h$1(
          "li",
          {
            class: cls,
            dataset: { num: i + "" }
          },
          h$1("a", null, i)
        )
      ).$appendTo(ulYele);
    }
    if (i == 1 && rangeEnd == 0) {
      let cls = { "paginationjs-page": true, active: true };
      cls[classPrefix + "-page"] = true;
      YElement.buildFromVNode(
        h$1(
          "li",
          {
            class: cls,
            dataset: { num: i + "" }
          },
          h$1("a", null, i)
        )
      ).$appendTo(ulYele);
      totalPage = 1;
    }
    if (showPages) {
      var len = Math.ceil((pageIndicatorCount - 1) / 2);
      if (totalPage - currentPage < len) {
        len -= len - (totalPage - currentPage);
      }
      if (totalPage >= pageIndicatorCount && currentPage <= parseInt(((pageIndicatorCount - 1) / 2).toString())) {
        len += parseInt(((pageIndicatorCount - 1) / 2).toString()) - (currentPage - 1);
      }
      if (totalPage < pageIndicatorCount) {
        len = totalPage - currentPage;
      }
      for (let i2 = 1; i2 <= len; i2++) {
        let cls = { "paginationjs-page": true };
        cls[classPrefix + "-page"] = true;
        cls[classPrefix + "-first"] = true;
        YElement.buildFromVNode(
          h$1(
            "li",
            {
              class: cls,
              dataset: { num: currentPage + i2 + "" }
            },
            h$1("a", null, currentPage + i2)
          )
        ).$appendTo(ulYele);
      }
    }
    if (showAllPages) {
      if (rangeEnd >= totalPage - 2) {
        for (let i2 = rangeEnd + 1; i2 <= totalPage; i2++) {
          let cls = { "paginationjs-page": true };
          cls[classPrefix + "-page"] = true;
          YElement.buildFromVNode(
            h$1(
              "li",
              {
                class: cls,
                dataset: { num: i2 + "" }
              },
              h$1("a", null, i2)
            )
          ).$appendTo(ulYele);
        }
      } else {
        let ellipsisClass = { disabled: true };
        ellipsisClass[classPrefix + "-ellipsis"] = true;
        YElement.buildFromVNode(
          h$1(
            "li",
            {
              class: ellipsisClass
            },
            h$1("a", null, ellipsisText)
          )
        ).$appendTo(ulYele);
        let lastClass = { "paginationjs-page": true };
        lastClass[classPrefix + "-page"] = true;
        lastClass[classPrefix + "-last"] = true;
        YElement.buildFromVNode(
          h$1(
            "li",
            {
              class: lastClass,
              dataset: { num: totalPage + "" }
            },
            h$1("a", null, totalPage)
          )
        ).$appendTo(ulYele);
      }
    }
    if (currentPage == totalPage) {
      let cls = { disabled: true };
      cls[classPrefix + "-next"] = true;
      YElement.buildFromVNode(
        h$1(
          "li",
          {
            class: cls
          },
          h$1("a", null, nextText)
        )
      ).$appendTo(ulYele);
      if (showLastButton) {
        let lastClass = { disabled: true };
        lastClass[classPrefix + "-lastpage"] = true;
        YElement.buildFromVNode(
          h$1(
            "li",
            {
              class: lastClass
            },
            h$1("a", null, lastText)
          )
        ).$appendTo(ulYele);
      }
    } else {
      let cls = { "paginationjs-next": true };
      cls[classPrefix + "-next"] = true;
      YElement.buildFromVNode(
        h$1(
          "li",
          {
            class: cls,
            dataset: { num: currentPage + 1 + "" },
            attrs: { title: "Next Page" }
          },
          h$1("a", null, nextText)
        )
      ).$appendTo(ulYele);
      if (showLastButton) {
        let lastClass = {};
        lastClass[classPrefix + "-lastpage"] = true;
        YElement.buildFromVNode(
          h$1(
            "li",
            {
              class: lastClass,
              attrs: { title: "Last Page" }
            },
            h$1("a", null, lastText)
          )
        ).$appendTo(ulYele);
      }
    }
    pageCont.push(ulYele);
    if (showPageDetail) {
      let cls = {};
      cls[classPrefix + "-nav"] = true;
      pageCont.push(
        YElement.buildFromVNode(
          h$1(
            "div",
            { class: cls },
            I18N.getString("PAGINATION_JOINT", "共") + "" + totalNumber + I18N.getString("PAGINATION_TOTAL", "条")
          )
        )
      );
    }
    if (showGoInput) {
      let cls = {};
      cls[classPrefix + "-go-input"] = true;
      let inputWrap = YElement.buildFromVNode(
        h$1("div", { class: cls }, [
          h$1("input", {
            class: { "paginationjs-go-pagenumber": true },
            attrs: { type: "text" },
            props: { value: currentPage }
          }),
          "/" + totalPage + I18N.getString("PAGINATION_PAGE", "页")
        ])
      );
      let $input = inputWrap.$findByClassName("paginationjs-go-pagenumber")[0];
      $input == null ? void 0 : $input.$addListener("blur", function(event2) {
        $input.$setInputValue(event2.currentTarget.value);
      });
      $input == null ? void 0 : $input.$addListener("keyup", function(event2) {
        if (event2.which === 13) {
          var pageNumber = event2.currentTarget.value;
          if (!jq.isNumeric(pageNumber))
            return;
          var curNumber = self2.model.pageNumber;
          if (curNumber == pageNumber)
            return;
          self2.go(parseInt(pageNumber));
        }
      });
      pageCont.push(inputWrap);
    }
    if (showGoButton) {
      let cls = {};
      cls[classPrefix + "-go-button"] = true;
      let buttonWrap = YElement.buildFromVNode(
        h$1("div", { class: cls }, [
          h$1("input", {
            class: { "paginationjs-go-button": true },
            attrs: { type: "button" },
            props: { value: "Go" }
          })
        ])
      );
      let $button = buttonWrap.$findByClassName("paginationjs-go-button")[0];
      $button == null ? void 0 : $button.$addListener("click", debounce(async function() {
        var pageNumber = el.$findByClassName("paginationjs-go-pagenumber")[0].getInputValue();
        if (!jq.isNumeric(pageNumber))
          return;
        var curNumber = self2.model.pageNumber;
        if (curNumber == pageNumber)
          return;
        await self2.go(parseInt(pageNumber));
      }));
      pageCont.push(buttonWrap);
    }
    ulYele.$findByClassName("paginationjs-page").forEach(function(pageYele, index2) {
      pageYele.$addListener("click", debounce(async function(event2) {
        if (pageYele.hasClass("disabled"))
          return;
        var pageNumber = pageYele.getDataSet("num").trim();
        if (!pageNumber || pageYele.hasClass("active"))
          return;
        await self2.go(parseInt(pageNumber));
      }));
    });
    ulYele.$findByClassName("paginationjs-previous").forEach(function(pageYele, index2) {
      pageYele.$addListener("click", debounce(async function(event2) {
        if (pageYele.hasClass("disabled"))
          return;
        var pageNumber = pageYele.getDataSet("num").trim();
        if (!pageNumber)
          return;
        await self2.go(parseInt(pageNumber));
      }));
    });
    ulYele.$findByClassName("paginationjs-next").forEach(function(pageYele, index2) {
      pageYele.$addListener("click", debounce(async function(event2) {
        if (pageYele.hasClass("disabled"))
          return;
        var pageNumber = pageYele.getDataSet("num").trim();
        if (!pageNumber)
          return;
        await self2.go(parseInt(pageNumber));
      }));
    });
    ulYele.$findByClassName("paginationjs-firstpage").forEach(function(pageYele, index2) {
      pageYele.$addListener("click", debounce(async function(event2) {
        if (pageYele.hasClass("disabled"))
          return;
        await self2.go(1);
      }));
    });
    ulYele.$findByClassName("paginationjs-lastpage").forEach(function(pageYele, index2) {
      pageYele.$addListener("click", debounce(async function(event2) {
        if (pageYele.hasClass("disabled"))
          return;
        await self2.go(self2.model.totalPage);
      }));
    });
    return pageCont;
  }
  go(number) {
    var self2 = this;
    if (self2.container.getAttr("disabled"))
      return;
    var model = self2.model, pageNumber = number, totalPage = model.totalPage;
    if (model.disabled)
      return;
    if (pageNumber < 1) {
      pageNumber = 1;
    }
    if (pageNumber > totalPage) {
      pageNumber = totalPage;
    }
    model.pageNumber = pageNumber;
    self2.render();
    self2.doCallback(pageNumber - 1);
  }
  doCallback(currentPageNumber) {
    if (currentPageNumber < 0)
      return;
    var model = this.model;
    if (typeof model.pageChanges === "function") {
      model.pageChanges(currentPageNumber);
    }
  }
  delay_till_last(id, fn, wait) {
    var _timer = this._timer || {};
    if (_timer[id]) {
      window.clearTimeout(_timer[id]);
      delete _timer[id];
    }
    return _timer[id] = window.setTimeout(function() {
      fn();
      delete _timer[id];
    }, wait);
  }
  observer() {
    this.go(Math.min(this.attributes.pageNumber, this.model.totalPage));
  }
}
function invokeHandler(handler, vnode2, event2) {
  if (typeof handler === "function") {
    handler.call(vnode2, event2, vnode2);
  } else if (typeof handler === "object") {
    for (let i = 0; i < handler.length; i++) {
      invokeHandler(handler[i], vnode2, event2);
    }
  }
}
function handleEvent(event2, vnode2) {
  const name = event2.type;
  const on2 = vnode2.data.on;
  if (on2 && on2[name]) {
    invokeHandler(on2[name], vnode2, event2);
  }
}
function createListener() {
  return function handler(event2) {
    handleEvent(event2, handler.vnode);
  };
}
let hookKeyArr = [
  "pre",
  "init",
  "create",
  "insert",
  "prepatch",
  "update",
  "postpatch",
  "destroy",
  "remove",
  "post"
];
function createHookWrapper(type) {
  if (hookKeyArr.includes(type)) {
    switch (type) {
      case "pre":
        let preWrapper = function() {
          preWrapper.outerHook && preWrapper.outerHook();
          preWrapper.innerHook && preWrapper.innerHook();
        };
        return preWrapper;
      case "init":
        let initWrapper = function(vNode) {
          initWrapper.outerHook && initWrapper.outerHook(vNode);
          initWrapper.innerHook && initWrapper.innerHook(vNode);
        };
        return initWrapper;
      case "create":
        let createWrapper = function(emptyVNode, vNode) {
          createWrapper.outerHook && createWrapper.outerHook(emptyVNode, vNode);
          createWrapper.innerHook && createWrapper.innerHook(emptyVNode, vNode);
        };
        return createWrapper;
      case "insert":
        let insertWrapper = function(vNode) {
          insertWrapper.outerHook && insertWrapper.outerHook(vNode);
          insertWrapper.innerHook && insertWrapper.innerHook(vNode);
        };
        return insertWrapper;
      case "prepatch":
        let prePatchWrapper = function(oldVNode, vNode) {
          prePatchWrapper.outerHook && prePatchWrapper.outerHook(oldVNode, vNode);
          prePatchWrapper.innerHook && prePatchWrapper.innerHook(oldVNode, vNode);
        };
        return prePatchWrapper;
      case "update":
        let updateWrapper = function(oldVNode, vNode) {
          updateWrapper.outerHook && updateWrapper.outerHook(oldVNode, vNode);
          updateWrapper.innerHook && updateWrapper.innerHook(oldVNode, vNode);
        };
        return updateWrapper;
      case "postpatch":
        let postPatchWrapper = function(oldVNode, vNode) {
          postPatchWrapper.innerHook && postPatchWrapper.innerHook(oldVNode, vNode);
          postPatchWrapper.outerHook && postPatchWrapper.outerHook(oldVNode, vNode);
        };
        return postPatchWrapper;
      case "destroy":
        let destroyWrapper = function(vNode) {
          destroyWrapper.outerHook && destroyWrapper.outerHook(vNode);
          destroyWrapper.innerHook && destroyWrapper.innerHook(vNode);
        };
        return destroyWrapper;
      case "remove":
        let removeWrapper = function(vNode, removeCallback) {
          removeCallback();
          removeWrapper.outerHook && removeWrapper.outerHook(vNode, () => {
          });
          removeWrapper.innerHook && removeWrapper.innerHook(vNode, () => {
          });
        };
        return removeWrapper;
      case "post":
        let postWrapper = function() {
          postWrapper.outerHook && postWrapper.outerHook();
          postWrapper.innerHook && postWrapper.innerHook();
        };
        return postWrapper;
    }
  }
}
const patch = init$1([
  // Init patch function with chosen modules
  classModule,
  // makes it easy to toggle classes
  propsModule,
  // for setting properties on DOM elements
  attributesModule,
  styleModule,
  // handles styling on elements with support for animations
  eventListenersModule,
  // attaches event listeners
  datasetModule
  // for setting data properties on DOM elements
  // ,yigoModule
]);
let globalkeySeed = 0;
function createVKey() {
  return globalkeySeed++;
}
class YHooks {
  constructor() {
    this.postpatch = [];
  }
  addPostPatch(postPatchHook) {
    this.postpatch.push(postPatchHook);
  }
  clearPostPatch() {
    this.postpatch.splice(0, this.postpatch.length);
  }
  getPostPatch() {
    return this.postpatch;
  }
}
class YElementData {
  constructor(options) {
    this.innerHooks = new YHooks();
    this._needCleanYeles = [];
    Object.assign(this, options);
  }
  getParentVNode() {
    return this.parentVNode;
  }
  setParentVNode(parentVNode) {
    this.parentVNode = parentVNode;
  }
  getInnerHooks() {
    return this.innerHooks;
  }
  // SetInnerHooks
  getDisplayBak() {
    return this._displayBak;
  }
  setDisplayBak(displayBak) {
    this._displayBak = displayBak;
  }
  getForzenDOMElement() {
    return this._forzenDOMElement;
  }
  setForzenDOMElement(forzenDOMElement) {
    this._forzenDOMElement = forzenDOMElement;
  }
  getForzenDOMMaskCls() {
    return this._forzenDOMMaskCls;
  }
  setForzenDOMMaskCls(forzenDOMMaskCls) {
    this._forzenDOMMaskCls = forzenDOMMaskCls;
  }
  getRawDomElm() {
    return this._rawDomElm;
  }
  setRawDomElm(rawDomElm) {
    this._rawDomElm = rawDomElm;
  }
  getOldVNode() {
    return this._oldVNode;
  }
  setOldVNode(oldVNode) {
    this._oldVNode = oldVNode;
  }
  addRemovedYele(removeYele) {
    if (Array.isArray(removeYele)) {
      this._needCleanYeles.push(...removeYele);
    } else {
      this._needCleanYeles.push(removeYele);
    }
  }
  getNeedCleanYeles() {
    return this._needCleanYeles;
  }
  clearNeedCleanYeles() {
    this._needCleanYeles = [];
  }
}
const _YElement = class _YElement2 {
  constructor(vnode2) {
    var _a, _b;
    this.__IsVirtual = true;
    this.vnode = vnode2;
    if (!this.vnode.data) {
      this.vnode.data = {};
    }
    var _d = this.vnode.data;
    _d.class = _d.class || {};
    _d.style = _d.style || {};
    _d.attrs = _d.attrs || {};
    _d.props = _d.props || {};
    _d.dataset = _d.dataset || {};
    _d.on = _d.on || {};
    _d.hook = _d.hook || {};
    _d.attachData = _d.attachData || {};
    _d.yelementData = new YElementData(_d.yelementData);
    let children = vnode2.children;
    if (Array.isArray(children) && !this.getAttachData("cleanAfterRemove") && !this.getYelementData().getParentVNode()) {
      for (let i = 0; i < children.length; i++) {
        const child = children[i];
        if (typeof child !== "string" && !((_b = (_a = child.data) == null ? void 0 : _a.yelementData) == null ? void 0 : _b.parentVNode)) {
          const cYele = new _YElement2(child);
          cYele.getYelementData().setParentVNode(vnode2);
        }
      }
    }
  }
  getHtmlTag() {
    var sel = this.vnode.sel;
    if (!sel) {
      return "";
    }
    var idIdx = sel.indexOf("#");
    if (idIdx >= 0) {
      sel = sel.substring(0, idIdx);
    }
    var clsIdx = sel.indexOf(".");
    if (clsIdx >= 0) {
      sel = sel.substring(0, clsIdx);
    }
    return sel.toLowerCase();
  }
  getElm() {
    return this.vnode.elm;
  }
  getComputedStyle() {
    const elm = this.getElm();
    if (elm) {
      return window.getComputedStyle(elm);
    }
  }
  addPostpatchHook(callback) {
    let root = vb._findRoot(this);
    if (this.getAttachData("isRemoved") || root.getAttachData("isRemoved")) {
      return;
    }
    if (this.getElm() && !vb.isGlobalSuspendPatch() && !root.getAttachData("willPatch")) {
      callback(this);
    } else {
      let innerHooks = this.getYelementData().getInnerHooks();
      innerHooks.addPostPatch(callback);
    }
  }
  static runHook(el) {
    var _a;
    let innerHooks = el.getYelementData().getInnerHooks();
    innerHooks.getPostPatch().forEach((cb) => {
      cb(el);
    });
    innerHooks.clearPostPatch();
    (_a = el.vnode.children) == null ? void 0 : _a.forEach((child) => {
      if (typeof child !== "string" && child.data) {
        _YElement2.runHook(_YElement2.buildFromVNode(child));
      }
    });
  }
  static buildFromVNode(vnode2) {
    return new _YElement2(vnode2);
  }
  getYelementData() {
    return this.vnode.data.yelementData;
  }
  delYelementData() {
    this.vnode.data.yelementData = null;
  }
  cleanVNode() {
    if (this.getAttachData("cleanAfterRemove")) {
      return;
    }
    let childElms = this.getChildElms();
    if (childElms.length) {
      for (let i = 0; i < childElms.length; i++) {
        const childElm = childElms[i];
        if (typeof childElm !== "string") {
          childElm.cleanVNode();
        }
      }
    }
    this.vnode.children = void 0;
    this.vnode["listener"] = void 0;
    this.$removeListener();
    this.vnode.data.hook = {};
    this.delYelementData();
    this.vnode.elm = void 0;
    this.$setAttachData("isRemoved", true);
    this.$setAttachData("cleanAfterRemove", true);
  }
  addRemovedYele(removeYele) {
    var yelementData = this.getYelementData();
    yelementData == null ? void 0 : yelementData.addRemovedYele(removeYele);
  }
  getRawDomElm() {
    var _a;
    var rawDomElm = (_a = this.getYelementData()) == null ? void 0 : _a.getRawDomElm();
    return rawDomElm;
  }
  $setRawDomElm(rawDomElm) {
    var _a;
    if (!this.getAttachData("cleanAfterRemove")) {
      (_a = this.getYelementData()) == null ? void 0 : _a.setRawDomElm(rawDomElm);
    }
    return this;
  }
  getCustomData(key2) {
    var yelementData = this.getYelementData();
    if (yelementData && key2) {
      return yelementData["custom_" + key2];
    }
  }
  $setCustomData(key2, value) {
    var yelementData = this.getYelementData();
    if (yelementData && key2) {
      yelementData["custom_" + key2] = value;
    }
    return this;
  }
  compareVNode(yele) {
    return this.vnode === yele.vnode;
  }
  supportPatch() {
    if (this.getRawDomElm()) {
      return true;
    } else {
      return false;
    }
  }
  $applyPatch() {
    var yelementData = this.getYelementData();
    var rawDomElm = yelementData == null ? void 0 : yelementData.getRawDomElm();
    if (rawDomElm) {
      let target = yelementData.getOldVNode() || rawDomElm;
      patch(target, this.vnode);
      let _needCleanYeles = yelementData.getNeedCleanYeles();
      for (let i = 0; i < _needCleanYeles.length; i++) {
        const _needCleanYele = _needCleanYeles[i];
        if (this.getAttachData("isRemoved")) {
          _needCleanYele.cleanVNode();
        }
      }
      yelementData.clearNeedCleanYeles();
      let _oldVNode = toVNodeFun(this.vnode);
      this.$setAttachData("willPatch", false);
      yelementData.setOldVNode(_oldVNode);
      _YElement2.runHook(this);
    } else {
      throw new Error("无效状态: 节点未从 HTML Element 初始化");
    }
    return this;
  }
  pagination(options) {
    if (typeof options === "undefined") {
      return options;
    }
    var container = this;
    var pagination = new Pagination(container, options);
    pagination.initialize();
    return pagination.model;
  }
  suspendRootPatch(options) {
    vb.suspendRootPatch(options);
  }
  resumeRootPatch() {
    vb.resumeRootPatch();
  }
  checkCleanAfterRemoved() {
    if (this.getAttachData("cleanAfterRemove")) {
      console.warn("当前状态无法操作虚拟元素(已移除并清理数据)");
    }
  }
  /** 私有化未使用代码---开始*/
  checkFrozenDOM() {
    if (this.getYelementData().getForzenDOMElement()) {
      throw new Error("当前状态无法操作虚拟元素(已被冻结到 DOM 元素)");
    }
  }
  static processForzenDom(el) {
    var _a;
    var yelementData = el.getYelementData();
    var parentVNode = yelementData.getParentVNode();
    var forzenDOMElement = yelementData.getForzenDOMElement();
    var forzenDOMMaskCls = yelementData.getForzenDOMMaskCls();
    if (parentVNode && forzenDOMElement) {
      var pElm = _YElement2.buildFromVNode(parentVNode);
      var pNode = pElm.vnode.elm;
      var earlyPatchNode = pNode.querySelector("." + forzenDOMMaskCls);
      if (null != earlyPatchNode) {
        pNode.replaceChild(forzenDOMElement, earlyPatchNode);
      }
    }
    (_a = el.vnode.children) == null ? void 0 : _a.forEach((child) => {
      if (typeof child !== "string" && child.data) {
        _YElement2.processForzenDom(_YElement2.buildFromVNode(child));
      }
    });
  }
  /**
   * 将当前虚拟元素提前渲染成 DOM 元素返回
   * @returns
   */
  earlyPatch() {
    var yelementData = this.getYelementData();
    if (yelementData.getRawDomElm()) {
      throw new Error("无法执行 earlyPatch, 当前 YElement 已包含初始 DOM 元素");
    }
    var tag = this.getHtmlTag() || "div";
    var dom = document.createElement(tag);
    yelementData.setRawDomElm(dom);
    this.$applyPatch();
    const seq = _YElement2._forzenDOMSeqSeed++;
    const seqCls = "vnode-early-patch-seq-" + seq;
    this.$addClass(seqCls);
    yelementData.setForzenDOMMaskCls(seqCls);
    yelementData.setForzenDOMElement(dom);
    return dom;
  }
  /** 私有化未使用代码---结束*/
  /** 分区1 --- vnode结构变更相关方法
   * 已移除暂未清理节点应该能再次加入vnodeTree和添加子节点（isRemoved == true）
   * 已移除且已清理节点不宜再添加子节点和被添加到vnodeTree（cleanAfterRemove == true）
  */
  $append(child) {
    this.checkCleanAfterRemoved();
    if (this.getAttachData("cleanAfterRemove")) {
      return this;
    }
    if (Array.isArray(child)) {
      if (child.length > 0) {
        this.vnode.children = this.vnode.children || [];
        this.vnode.text && this.vnode.children.push(this.vnode.text);
        this.vnode.text = void 0;
        for (let i = 0; i < child.length; i++) {
          const cYele = child[i];
          cYele.checkCleanAfterRemoved();
          if (cYele.getAttachData("cleanAfterRemove")) {
            continue;
          }
          if (cYele.getAttachData("isRemoved")) {
            cYele.$setAttachData("isRemoved", false);
          }
          cYele._remove();
          cYele.getYelementData().setParentVNode(this.vnode);
          this.vnode.children.push(cYele.vnode);
          if (!cYele.getVKey()) {
            cYele.$setVKey(createVKey());
          }
        }
        vb.noticeChange(this, "$append");
      }
    } else {
      child.checkCleanAfterRemoved();
      if (child.getAttachData("cleanAfterRemove")) {
        return this;
      }
      if (child.getAttachData("isRemoved")) {
        child.$setAttachData("isRemoved", false);
      }
      child._remove();
      child.getYelementData().setParentVNode(this.vnode);
      if (!child.getVKey()) {
        child.$setVKey(createVKey());
      }
      this.vnode.children = this.vnode.children || [];
      this.vnode.text && this.vnode.children.push(this.vnode.text);
      this.vnode.children.push(child.vnode);
      this.vnode.text = void 0;
      vb.noticeChange(this, "$append");
    }
    return this;
  }
  $appendTo(container) {
    container.checkCleanAfterRemoved();
    this.checkCleanAfterRemoved();
    if (this.getAttachData("cleanAfterRemove") || container.getAttachData("cleanAfterRemove")) {
      return this;
    }
    if (this.getAttachData("isRemoved")) {
      this.$setAttachData("isRemoved", false);
    }
    if (!this.getVKey()) {
      this.$setVKey(createVKey());
    }
    this._remove();
    this.getYelementData().setParentVNode(container.vnode);
    container.vnode.children = container.vnode.children || [];
    container.vnode.children.push(this.vnode);
    container.vnode.text = void 0;
    vb.noticeChange(this, "$appendTo");
    return this;
  }
  $prependTo(container) {
    container.checkCleanAfterRemoved();
    this.checkCleanAfterRemoved();
    if (this.getAttachData("cleanAfterRemove") || container.getAttachData("cleanAfterRemove")) {
      return this;
    }
    if (this.getAttachData("isRemoved")) {
      this.$setAttachData("isRemoved", false);
    }
    if (!this.getVKey()) {
      this.$setVKey(createVKey());
    }
    this._remove();
    this.getYelementData().setParentVNode(container.vnode);
    container.vnode.children = container.vnode.children || [];
    container.vnode.children.unshift(this.vnode);
    container.vnode.text = void 0;
    vb.noticeChange(this, "$prependTo");
    return this;
  }
  $insertBefore(elm) {
    elm.checkCleanAfterRemoved();
    this.checkCleanAfterRemoved();
    if (this.getAttachData("cleanAfterRemove") || elm.getAttachData("cleanAfterRemove")) {
      return this;
    }
    if (!this.getVKey()) {
      this.$setVKey(createVKey());
    }
    var elmParentVNode = elm.getYelementData().getParentVNode();
    if (elmParentVNode) {
      var brothers = elmParentVNode == null ? void 0 : elmParentVNode.children;
      var idx = brothers ? brothers.indexOf(elm.vnode) : -1;
      if (idx < 0) {
        throw new Error("无法执行 insertBefore: 没有在父节点中找到指定节点, 数据状态错误");
      }
      if (this.getAttachData("isRemoved")) {
        this.$setAttachData("isRemoved", false);
      } else {
        this._remove();
      }
      this.getYelementData().setParentVNode(elmParentVNode);
      brothers && brothers.splice(idx, 0, this.vnode);
      elmParentVNode.text = void 0;
      vb.noticeChange(this, "$insertBefore");
    } else {
      throw new Error("无法对顶层组件执行 insertBefore");
    }
    return this;
  }
  $insertAfter(elm) {
    elm.checkCleanAfterRemoved();
    this.checkCleanAfterRemoved();
    if (this.getAttachData("cleanAfterRemove") || elm.getAttachData("cleanAfterRemove")) {
      return this;
    }
    if (!this.getVKey()) {
      this.$setVKey(createVKey());
    }
    var elmParentVNode = elm.getYelementData().getParentVNode();
    if (elmParentVNode) {
      var brothers = elmParentVNode == null ? void 0 : elmParentVNode.children;
      var idx = brothers ? brothers.indexOf(elm.vnode) : -1;
      if (idx < 0) {
        throw new Error("无法执行 insertAfter: 没有在父节点中找到指定节点, 数据状态错误");
      }
      if (this.getAttachData("isRemoved")) {
        this.$setAttachData("isRemoved", false);
      } else {
        this._remove();
      }
      this.getYelementData().setParentVNode(elmParentVNode);
      brothers && brothers.splice(idx + 1, 0, this.vnode);
      elmParentVNode.text = void 0;
      vb.noticeChange(this, "$insertAfter");
    } else {
      throw new Error("无法对顶层组件执行 insertAfter");
    }
    return brothers;
  }
  // A、B 兄弟节点交换位置
  $switchWith(elm) {
    elm.checkCleanAfterRemoved();
    this.checkCleanAfterRemoved();
    if (this.getAttachData("cleanAfterRemove") || elm.getAttachData("cleanAfterRemove")) {
      return this;
    }
    var parentVNode = this.getYelementData().getParentVNode();
    var parentVNode2 = elm.getYelementData().getParentVNode();
    if (parentVNode && parentVNode2 && parentVNode == parentVNode2) {
      let replace = function(arr, i, j) {
        const temp = arr[i];
        arr[i] = arr[j];
        arr[j] = temp;
      };
      var brothers = parentVNode.children;
      var idx1 = brothers ? brothers.indexOf(this.vnode) : -1;
      var idx2 = brothers ? brothers.indexOf(elm.vnode) : -1;
      if (idx1 < 0) {
        throw new Error("无法执行 $switchWith: 没有在父节点中找到指定的节点, 数据状态错误");
      }
      if (idx2 < 0) {
        brothers == null ? void 0 : brothers.push(elm.vnode);
        idx2 = (brothers == null ? void 0 : brothers.length) || 0 - 1;
      }
      brothers && replace(brothers, idx1, idx2);
      vb.noticeChange(this, "$switchWith");
    } else {
      throw new Error("无法对顶层组件执行 $switchWith");
    }
    return this;
  }
  // A节点替换成B节点(A将不存在)
  $replaceWith(elm) {
    this.checkCleanAfterRemoved();
    elm.checkCleanAfterRemoved();
    if (this.getAttachData("cleanAfterRemove") || elm.getAttachData("cleanAfterRemove")) {
      return this;
    }
    var parentVNode = this.getYelementData().getParentVNode();
    if (parentVNode) {
      var brothers = parentVNode.children;
      var idx = brothers ? brothers.indexOf(this.vnode) : -1;
      if (idx < 0) {
        throw new Error("无法执行 $replaceWith: 没有在父节点中找到指定的节点, 数据状态错误");
      } else if (brothers == null ? void 0 : brothers.length) {
        brothers.splice(idx, 1, elm.vnode);
        if (elm.getAttachData("isRemoved")) {
          elm.$setAttachData("isRemoved", false);
        }
        vb.noticeChange(this, "$replaceWith");
        this.$remove();
        elm.getYelementData().setParentVNode(parentVNode);
      }
    } else {
      throw new Error("无法对顶层组件执行 $replaceWith");
    }
    return this;
  }
  //仅在yelement 方法内使用，无须单独触发noticeChange
  _remove(parentVNode) {
    !parentVNode && (parentVNode = this.getYelementData().getParentVNode());
    if (parentVNode) {
      var brothers = parentVNode.children;
      const index2 = brothers ? brothers.indexOf(this.vnode) : -1;
      if (brothers && index2 >= 0) {
        brothers.splice(index2, 1);
      }
      this.getYelementData().setParentVNode(void 0);
    }
  }
  /**
   * 移除的是this对应的整棵vnodeTree，但被移除节点及其子孙节点关系不变
  */
  $remove() {
    if (this.getAttachData("isRemoved") || this.getAttachData("cleanAfterRemove")) {
      return this;
    }
    var parentVNode = this.getYelementData().getParentVNode();
    if (parentVNode) {
      var brothers = parentVNode.children;
      const index2 = brothers ? brothers.indexOf(this.vnode) : -1;
      if (brothers && index2 >= 0) {
        brothers.splice(index2, 1);
      }
      vb.noticeChange(this, "$remove");
      this.getYelementData().setParentVNode(void 0);
    } else {
      if (this.supportPatch()) {
        this.$empty();
        let innerHooks = this.getYelementData().getInnerHooks();
        innerHooks.clearPostPatch();
        vb.noticeChange(this, "$remove-rootVNode");
        this.addPostpatchHook(function(yele) {
          let elm = yele.getElm();
          elm && elm.remove();
          yele.cleanVNode();
        });
      }
    }
    this.$setAttachData("isRemoved", true);
    return this;
  }
  /**
   * 只是清空所有childVNode，但子孙节点关系不变
  */
  $empty() {
    var _a;
    if (((_a = this.vnode.children) == null ? void 0 : _a.length) || this.vnode.text) {
      let childElms = this.getChildElms();
      if (childElms.length) {
        for (let i = 0; i < childElms.length; i++) {
          const childElm = childElms[i];
          if (typeof childElm !== "string") {
            childElm.$remove();
          }
        }
        this.vnode.children.splice(0, this.vnode.children.length);
      }
      this.vnode.text = void 0;
      vb.noticeChange(this, "$empty");
    }
    return this;
  }
  /** 分区2 --- data处理相关方法*/
  getHook(hookName, options) {
    if (hookKeyArr.includes(hookName) && this.vnode.data.hook) {
      let hookWrapperFun = this.vnode.data.hook[hookName];
      if (!hookWrapperFun) {
        return hookWrapperFun;
      } else {
        if (options && options.isInner) {
          return hookWrapperFun.innerHook;
        } else {
          return hookWrapperFun.outerHook;
        }
      }
    }
  }
  _setHook(hookName, hookFun, options) {
    if (hookKeyArr.includes(hookName)) {
      let hookData = this.vnode.data.hook = this.vnode.data.hook || {};
      if (!hookData[hookName]) {
        hookData[hookName] = createHookWrapper(hookName);
      }
      let hookWrapperFun = hookData[hookName];
      if (options && options.isInner) {
        hookWrapperFun.innerHook = hookFun;
      } else {
        hookWrapperFun.outerHook = hookFun;
      }
    } else {
      throw new Error(`hook (${hookName}) is not able to be set!`);
    }
  }
  setHook(hookName, hookFun) {
    this._setHook(hookName, hookFun);
  }
  $addClass(cssClass, options) {
    this.checkCleanAfterRemoved();
    if (this.getAttachData("cleanAfterRemove")) {
      return this;
    }
    if (!cssClass || this.hasClass(cssClass)) {
      return this;
    }
    const classNames = cssClass.trim().split(" ");
    classNames.forEach((item) => {
      this.vnode.data.class[item] = true;
    });
    if (this.getAttachData("isOld")) {
      return this;
    }
    let elm = this.getElm();
    if (elm && elm.nodeType == 1 && !(options == null ? void 0 : options.forcePatch) && !vb.isGlobalSuspendPatch()) {
      classNames.forEach((item) => {
        elm.classList.add(item);
      });
      let oldVNode = this.getYelementData().getOldVNode();
      oldVNode && _YElement2.buildFromVNode(oldVNode).$addClass(cssClass);
      return this;
    }
    vb.noticeChange(this, `$addClass:${cssClass}`);
    return this;
  }
  $removeClass(cssClass, options) {
    this.checkCleanAfterRemoved();
    if (this.getAttachData("cleanAfterRemove")) {
      return this;
    }
    if (cssClass) {
      const classNames = cssClass.trim().split(" ");
      if (classNames.length === 1 && !this.hasClass(cssClass)) {
        return this;
      }
      classNames.forEach((item) => {
        this.vnode.data.class[item] = false;
      });
      if (this.getAttachData("isOld")) {
        return this;
      }
      let elm = this.getElm();
      if (elm && elm.nodeType == 1 && !(options == null ? void 0 : options.forcePatch) && !vb.isGlobalSuspendPatch()) {
        classNames.forEach((item) => {
          elm.classList.remove(item);
        });
        let oldVNode = this.getYelementData().getOldVNode();
        oldVNode && _YElement2.buildFromVNode(oldVNode).$removeClass(cssClass);
        return this;
      }
    } else {
      let sel = this.vnode.sel || "";
      let clsIdx = sel.indexOf(".");
      if (clsIdx >= 0) {
        sel = sel.substring(clsIdx + 1);
        sel.split(".").map((item) => {
          this.vnode.data.class[item] = false;
        });
      }
      for (const key2 in this.vnode.data.class) {
        this.vnode.data.class[key2] = false;
      }
      if (this.getAttachData("isOld")) {
        return this;
      }
      let elm = this.getElm();
      if (elm && elm.nodeType == 1 && !(options == null ? void 0 : options.forcePatch) && !vb.isGlobalSuspendPatch()) {
        elm.className = "";
        let oldVNode = this.getYelementData().getOldVNode();
        oldVNode && _YElement2.buildFromVNode(oldVNode).$removeClass(cssClass);
        return this;
      }
    }
    vb.noticeChange(this, `$removeClass:${cssClass}`);
    return this;
  }
  hasClass(cssClass) {
    if (!cssClass) {
      return false;
    }
    return cssClass.trim().split(" ").every((item) => {
      return this.vnode.data.class[item] || this.vnode.data.class[item] === void 0 && this.vnode.sel && new RegExp("(\\." + item + "\\.|\\." + item + "$)", "g").test(
        this.vnode.sel
      );
    });
  }
  $toggleClass(cssClass, options) {
    if (cssClass) {
      if (this.hasClass(cssClass)) {
        this.$removeClass(cssClass, options);
      } else {
        this.$addClass(cssClass, options);
      }
    }
    return this;
  }
  $addStyle(name, value, options) {
    this.checkCleanAfterRemoved();
    if (this.getAttachData("cleanAfterRemove")) {
      return this;
    }
    if (!name.trim()) {
      throw new Error(`$addStyle, 参数有误 name: ${name}, value: ${value}`);
    }
    var oldstyle = this.vnode.data.style[name];
    this.vnode.data.style[name] = value;
    if (this.getAttachData("isOld")) {
      return this;
    }
    let elm = this.getElm();
    if (elm && elm.nodeType == 1 && !(options == null ? void 0 : options.forcePatch) && !vb.isGlobalSuspendPatch()) {
      elm.style[name] = value;
      let oldVNode = this.getYelementData().getOldVNode();
      oldVNode && _YElement2.buildFromVNode(oldVNode).$addStyle(name, value);
      return this;
    }
    if (oldstyle == value) {
      return this;
    }
    vb.noticeChange(this, `$addStyle:${name}=${value}`);
    return this;
  }
  getStyle(name) {
    return this.vnode.data.style[name];
  }
  $appendStyles(styles, options) {
    for (let style of styles.entries()) {
      this.$addStyle(style[0], style[1], options);
    }
    return this;
  }
  $setVKey(value) {
    var _a;
    var old = this.vnode.key;
    if (old === value) {
      return this;
    }
    if (value === void 0 || value === null) {
      delete this.vnode.key;
      if ((_a = this.vnode.data) == null ? void 0 : _a.key) {
        delete this.vnode.data.key;
      }
    } else {
      this.vnode.key = value;
      if (this.vnode.data) {
        this.vnode.data.key = value;
      }
    }
    vb.noticeChange(this, `$setVkey:key=${value == null ? void 0 : value.toString()}`);
    return this;
  }
  getVKey() {
    let vkey = this.vnode.key;
    return vkey;
  }
  $setAttr(name, value, options) {
    this.checkCleanAfterRemoved();
    if (this.getAttachData("cleanAfterRemove")) {
      return this;
    }
    if (!name.trim()) {
      throw new Error(`$setAttr, 参数有误 name: ${name}, value: ${value}`);
    }
    var old = this.vnode.data.attrs[name];
    if (value === void 0 || value === null) {
      delete this.vnode.data.attrs[name];
    } else {
      this.vnode.data.attrs[name] = value;
    }
    if (this.getAttachData("isOld")) {
      return this;
    }
    let elm = this.getElm();
    if (elm && elm.nodeType == 1 && !(options == null ? void 0 : options.forcePatch) && !vb.isGlobalSuspendPatch()) {
      if (value === void 0 || value === null) {
        elm.removeAttribute(name);
      } else {
        elm.setAttribute(name, value);
      }
      let oldVNode = this.getYelementData().getOldVNode();
      oldVNode && _YElement2.buildFromVNode(oldVNode).$setAttr(name, value);
      return this;
    }
    if (old == value) {
      return this;
    }
    vb.noticeChange(this, `$setAttr:${name}=${value}`);
    return this;
  }
  getAttr(name) {
    let attr = this.vnode.data.attrs[name];
    if (name === "id" && attr === void 0) {
      let sel = this.vnode.sel;
      if (sel) {
        let hashIdx = sel.indexOf("#");
        if (hashIdx > 0) {
          let dotIdx = sel.indexOf(".");
          dotIdx = dotIdx > hashIdx ? dotIdx : sel.length;
          attr = sel.slice(hashIdx + 1, dotIdx);
        }
      }
    }
    return attr;
  }
  $setProp(name, value, options) {
    this.checkCleanAfterRemoved();
    if (this.getAttachData("cleanAfterRemove")) {
      return this;
    }
    name = name.trim();
    if (!name) {
      throw new Error(`$setProp, 参数有误 name: ${name}`);
    }
    const old = this.vnode.data.props[name];
    const elm = this.getElm();
    if (value === void 0 || value === null) {
      delete this.vnode.data.props[name];
    } else {
      this.vnode.data.props[name] = value;
    }
    if (this.getAttachData("isOld")) {
      return this;
    }
    if (elm && elm.nodeType == 1 && !(options == null ? void 0 : options.forcePatch) && !vb.isGlobalSuspendPatch()) {
      elm[name] = value;
      let oldVNode = this.getYelementData().getOldVNode();
      oldVNode && _YElement2.buildFromVNode(oldVNode).$setProp(name, value);
      return this;
    }
    if (old == value) {
      return this;
    }
    vb.noticeChange(this, `$setProp:${name}=${value}`);
    return this;
  }
  getProp(name) {
    return this.vnode.data.props[name];
  }
  $setDataSet(name, value, options) {
    this.checkCleanAfterRemoved();
    if (this.getAttachData("cleanAfterRemove")) {
      return this;
    }
    if (!name.trim()) {
      throw new Error(`$setDataSet, 参数有误 name: ${name}`);
    }
    var old = this.vnode.data.dataset[name];
    if (value === void 0 || value === null) {
      delete this.vnode.data.dataset[name];
    } else {
      this.vnode.data.dataset[name] = value;
    }
    if (this.getAttachData("isOld")) {
      return this;
    }
    let elm = this.getElm();
    if (elm && elm.nodeType == 1 && !(options == null ? void 0 : options.forcePatch) && !vb.isGlobalSuspendPatch()) {
      if (value === void 0 || value === null) {
        elm.dataset[name] && delete elm.dataset[name];
      } else {
        elm.dataset[name] = value;
      }
      let oldVNode = this.getYelementData().getOldVNode();
      oldVNode && _YElement2.buildFromVNode(oldVNode).$setDataSet(name, value);
      return this;
    }
    if (old == value) {
      return this;
    }
    vb.noticeChange(this, `$setDataSet:${name}=${value}`);
    return this;
  }
  getDataSet(name) {
    return this.vnode.data.dataset[name];
  }
  $setAttachData(name, value) {
    if (!name.trim()) {
      throw new Error(`$setAttachData, 参数有误 name: ${name}`);
    }
    var attachData = this.vnode.data.attachData;
    var old = attachData && attachData[name];
    if (old != value) {
      this.vnode.data.attachData = attachData || {};
      this.vnode.data.attachData[name] = value;
    }
    return this;
  }
  getAttachData(name) {
    var attachData = this.vnode.data.attachData;
    return attachData && attachData[name];
  }
  $setInputValue(value, options) {
    if (value !== 0 && !value) {
      value = "";
    }
    var tag = this.getHtmlTag();
    if ("input" == tag || "textarea" == tag) {
      this.$setProp("value", value.toString(), options);
    } else {
      throw new Error("无法对 '" + this.vnode.sel + "' 设置 value");
    }
    return this;
  }
  getInputValue() {
    var tag = this.getHtmlTag();
    if ("input" == tag || "textarea" == tag) {
      return this.getProp("value") || "";
    } else {
      throw new Error("无法对 '" + this.vnode.sel + "' 获取 value");
    }
  }
  $setInnerText(innerText, options) {
    this.checkCleanAfterRemoved();
    if (this.getAttachData("cleanAfterRemove")) {
      return this;
    }
    let oldText = this.vnode.text;
    let oldChildren = this.vnode.children;
    if (innerText === oldText) {
      return this;
    }
    this.vnode.children = void 0;
    typeof innerText === "string" && (innerText = innerText.replace(/\&nbsp;/g, " "));
    this.vnode.text = innerText;
    if (this.getAttachData("isOld")) {
      return this;
    }
    let elm = this.getElm();
    if (elm && oldText !== void 0 && !Array.isArray(oldChildren) && !this.getAttachData("will-change-children") && !(options == null ? void 0 : options.forcePatch) && !vb.isGlobalSuspendPatch()) {
      elm.textContent = innerText;
      let oldVNode = this.getYelementData().getOldVNode();
      oldVNode && _YElement2.buildFromVNode(oldVNode).$setInnerText(innerText);
      return this;
    }
    vb.noticeChange(this, "$setInnerText:" + innerText);
    if (elm && !this.getAttachData("will-change-children")) {
      this.$setAttachData("will-change-children", true);
      this.addPostpatchHook(function(elm2) {
        elm2.$setAttachData("will-change-children", false);
      });
    }
    return this;
  }
  getInnerText() {
    return this.vnode.text;
  }
  $addListener(eventName, handler, options) {
    this.checkCleanAfterRemoved();
    if (this.getAttachData("cleanAfterRemove")) {
      return this;
    }
    var lnrArray = this.vnode.data.on[eventName];
    if (void 0 == lnrArray) {
      lnrArray = [];
      this.vnode.data.on[eventName] = lnrArray;
    }
    if (!Array.isArray(lnrArray)) {
      lnrArray = [lnrArray];
      this.vnode.data.on[eventName] = lnrArray;
    }
    if (lnrArray.includes(handler)) {
      return this;
    }
    lnrArray.push(handler);
    if (this.getAttachData("isOld")) {
      return this;
    }
    let elm = this.getElm();
    if (elm && elm.nodeType == 1 && !(options == null ? void 0 : options.forcePatch) && !vb.isGlobalSuspendPatch()) {
      let vnode2 = this.vnode;
      let listener = vnode2.listener;
      if (!listener) {
        listener = createListener();
        listener.vnode = vnode2;
        vnode2.listener = listener;
      }
      elm.addEventListener(eventName, listener, false);
      let oldVNode = this.getYelementData().getOldVNode();
      oldVNode && _YElement2.buildFromVNode(oldVNode).$addListener(eventName, handler);
      return this;
    }
    vb.noticeChange(this, "$addListener:" + eventName);
    return this;
  }
  $removeListener(eventName, handler) {
    this.checkCleanAfterRemoved();
    if (this.getAttachData("cleanAfterRemove")) {
      return this;
    }
    if (eventName) {
      if (handler) {
        var lnrArray = this.vnode.data.on[eventName];
        if (!Array.isArray(lnrArray)) {
          lnrArray === handler && delete this.vnode.data.on[eventName];
        } else {
          this.vnode.data.on[eventName] = lnrArray.filter((item) => item !== handler);
        }
      } else {
        var lnrArray = this.vnode.data.on[eventName];
        if (lnrArray) {
          delete this.vnode.data.on[eventName];
        }
      }
    } else {
      this.vnode.data.on = {};
    }
    return this;
  }
  $mousedown(handler, options) {
    return this.$addListener("mousedown", handler, options);
  }
  $mouseup(handler, options) {
    return this.$addListener("mouseup", handler, options);
  }
  $mousemove(handler, options) {
    return this.$addListener("mousemove", handler, options);
  }
  $mouseleave(handler, options) {
    return this.$addListener("mouseleave", handler, options);
  }
  $click(handler, options) {
    return this.$addListener("click", handler, options);
  }
  $scroll(handler, options) {
    return this.$addListener("scroll", handler, options);
  }
  $dblclick(handler, options) {
    return this.$addListener("dblclick", handler, options);
  }
  $keydown(handler, options) {
    return this.$addListener("keydown", handler, options);
  }
  $keyup(handler, options) {
    return this.$addListener("keyup", handler, options);
  }
  $keypress(handler, options) {
    return this.$addListener("keypress", handler, options);
  }
  $show(displayVal, options) {
    this.checkCleanAfterRemoved();
    if (this.getAttachData("cleanAfterRemove")) {
      return this;
    }
    var _displayBak = this.getYelementData().getDisplayBak();
    if (void 0 == _displayBak || "none" == _displayBak) {
      this.$addStyle("display", displayVal || "", options);
    } else {
      this.$addStyle("display", _displayBak, options);
    }
    return this;
  }
  $hide(options) {
    this.checkCleanAfterRemoved();
    if (this.getAttachData("cleanAfterRemove")) {
      return this;
    }
    this.getYelementData().setDisplayBak(this.getStyle("display"));
    this.$addStyle("display", "none", options);
    return this;
  }
  $slideInit(options) {
    let defOptions = {
      speed: 200,
      // 速度：毫秒 | 'fast' | 'slow'
      timeCurve: "ease-in",
      // 动画曲线：'ease-in' | 'ease' | 'ease-out' | 'linear'
      delay: 0
      // 延迟间隔
    };
    let speedState;
    ((speedState2) => {
      speedState2[speedState2["slow"] = 1e3] = "slow";
      speedState2[speedState2["fast"] = 100] = "fast";
    })(speedState || (speedState = {}));
    options = Object.assign(defOptions, options);
    typeof options.speed === "string" && (options.speed = speedState[options.speed]);
    this.$appendStyles(new Map(Object.entries({
      transition: `all ${options.speed}ms ${options.timeCurve} ${options.delay}ms`,
      transform: `scale(1, 0)`,
      // 初始化时仅针对Y
      "transform-origin": "50% 0",
      display: "block"
    })));
    return this;
  }
  $slideUp(options) {
    this.$addStyle("transform", "scale(1, 0)", options);
    return this;
  }
  $slideDown(options) {
    this.$addStyle("transform", "scale(1, 1)", options);
    return this;
  }
  isShow() {
    return this.getStyle("display") !== "none";
  }
  isHide() {
    return this.getStyle("display") === "none";
  }
  isRemoved() {
    return this.getAttachData("isRemoved");
  }
  getWidth() {
    return this.getStyle("width");
  }
  $setWidth(w, options) {
    if ("number" == typeof w) {
      this.$addStyle("width", w + "px", options);
    } else {
      this.$addStyle("width", w, options);
    }
    return this;
  }
  getHeight() {
    return this.getStyle("height");
  }
  $setHeight(h2, options) {
    if ("number" == typeof h2) {
      this.$addStyle("height", h2 + "px", options);
    } else {
      this.$addStyle("height", h2, options);
    }
    return this;
  }
  $callSync(name, data2) {
    const dom = this.vnode.elm;
    if (!dom || !name.trim()) {
      console.error(`无法在dom：${dom} 上执行 ${name} 事件`);
      return;
    }
    const staticEventsArr = [
      "focus",
      "blur",
      "load",
      "unload",
      "change",
      "submit",
      "reset",
      "error",
      "click"
      // 特例
    ];
    if (staticEventsArr.includes(name) && !data2) {
      dom[name]();
    } else {
      const _data = { detail: data2, bubbles: true, cancelable: true };
      const event2 = new CustomEvent(name, _data);
      dom.dispatchEvent(event2);
    }
    return this;
  }
  $call(name, data2) {
    const _elm = this.getElm();
    const _this = this;
    if (_elm) {
      this.$callSync(name, data2);
    } else {
      this.addPostpatchHook(function(el) {
        _this.$callSync(name, data2);
      });
    }
    return this;
  }
  $focus() {
    return this.$call("focus");
  }
  $blur() {
    return this.$call("blur");
  }
  /** 分区3 --- vnode节点查找相关方法*/
  $parents(callback) {
    var _p = this;
    var parentVNode = null;
    if (!this.getAttachData("cleanAfterRemove")) {
      parentVNode = this.getYelementData().getParentVNode();
    }
    while (parentVNode) {
      var cont = callback(_p);
      if (!cont) {
        return _p;
      }
      _p = _YElement2.buildFromVNode(parentVNode);
      parentVNode = _p.getYelementData().getParentVNode();
    }
    return _p;
  }
  $parentsAll(callback, level) {
    let result = [];
    function traverse(yesEl, callback2, _level, maxlevel) {
      if (maxlevel && _level > maxlevel) {
        return;
      }
      callback2(yesEl) && result.push(yesEl);
    }
    if (this.$parent()) {
      traverse(this.$parent(), callback, 1, level);
    }
    traverse(this, callback, 1, level);
    return result;
  }
  $parent() {
    var parentVNode = null;
    if (!this.getAttachData("cleanAfterRemove")) {
      parentVNode = this.getYelementData().getParentVNode();
    }
    if (parentVNode) {
      var _p = _YElement2.buildFromVNode(parentVNode);
      return _p;
    }
  }
  $next() {
    var parentVNode = null;
    if (!this.getAttachData("cleanAfterRemove")) {
      parentVNode = this.getYelementData().getParentVNode();
    }
    if (parentVNode) {
      var brothers = parentVNode.children;
      var idx = brothers ? brothers.indexOf(this.vnode) : -1;
      if (brothers && idx !== brothers.length - 1 && idx !== -1) {
        var result = brothers[idx + 1];
        return _YElement2.buildFromVNode(result);
      }
      return void 0;
    }
  }
  $prev() {
    var parentVNode = null;
    if (!this.getAttachData("cleanAfterRemove")) {
      parentVNode = this.getYelementData().getParentVNode();
    }
    if (parentVNode) {
      var brothers = parentVNode.children;
      var idx = brothers ? brothers.indexOf(this.vnode) : -1;
      if (brothers && idx !== 0 && idx !== -1) {
        var result = brothers[idx - 1];
        return _YElement2.buildFromVNode(result);
      }
      return void 0;
    }
  }
  index() {
    var parentVNode = null;
    if (!this.getAttachData("cleanAfterRemove")) {
      parentVNode = this.getYelementData().getParentVNode();
    }
    if (parentVNode) {
      var brothers = parentVNode.children;
      var idx = brothers ? brothers.indexOf(this.vnode) : -1;
      return idx;
    }
    return -1;
  }
  $find(callback, level) {
    let result = [];
    function traverse(yesEl, callback2, _level, maxlevel) {
      if (maxlevel && _level > maxlevel) {
        return;
      }
      callback2(yesEl) && result.push(yesEl);
      var childElms = yesEl.getChildElms();
      if (childElms == null ? void 0 : childElms.length) {
        for (let i = 0; i < childElms.length; i++) {
          let childElm = childElms[i];
          if (typeof childElm !== "string") {
            traverse(childElm, callback2, _level + 1, maxlevel);
          }
        }
      }
    }
    traverse(this, callback, 1, level);
    return result;
  }
  $findByTagName(tag, level) {
    return this.$find((vEl) => vEl.getHtmlTag() === tag, level);
  }
  $findByClassName(className, level) {
    return this.$find((vEl) => vEl.hasClass(className), level);
  }
  $findById(id, level) {
    let result = null;
    function traverse(yesEl, _level, maxlevel) {
      if (maxlevel && _level > maxlevel) {
        return;
      }
      if (yesEl.getAttr("id") === id) {
        result = yesEl;
        return;
      }
      var childElms = yesEl.getChildElms();
      if (childElms == null ? void 0 : childElms.length) {
        for (let i = 0; i < childElms.length; i++) {
          let childElm = childElms[i];
          if (typeof childElm !== "string") {
            traverse(childElm, _level + 1, maxlevel);
          }
        }
      }
    }
    if (id) {
      traverse(this, 1, level);
    }
    return result;
  }
  $clone() {
    let vnodeCopy = toVNodeFun(this.vnode, true);
    return _YElement2.buildFromVNode(vnodeCopy);
  }
  // 第一个子节点
  childNode() {
    var children = this.vnode.children;
    if (children) {
      var child = children[0];
      return child && typeof child !== "string" ? _YElement2.buildFromVNode(child) : null;
    }
    return null;
  }
  // 最后一个子节点
  lastNode() {
    var children = this.vnode.children;
    if (children) {
      var child = children[children.length - 1];
      return child && typeof child !== "string" ? _YElement2.buildFromVNode(child) : null;
    }
    return null;
  }
  siblings(includeStr) {
    var _a;
    let siblingArr = ((_a = this.$parent()) == null ? void 0 : _a.getChildElms(includeStr)) || [];
    let self2 = this;
    if (siblingArr.length) {
      siblingArr = siblingArr.filter(function(item) {
        if (typeof item !== "string") {
          return !item.compareVNode(self2);
        } else {
          return includeStr;
        }
      });
    }
    return siblingArr;
  }
  getChildElms(includeStr) {
    let childYElms = [];
    let children = this.vnode.children || [];
    for (let i = 0; i < children.length; i++) {
      const item = children[i];
      if (typeof item !== "string") {
        item.data = item.data || {};
        childYElms.push(_YElement2.buildFromVNode(item));
      } else {
        includeStr && childYElms.push(item);
      }
    }
    return childYElms;
  }
};
_YElement._forzenDOMSeqSeed = 0;
let YElement = _YElement;
class FontSizeLayoutUtil {
}
FontSizeLayoutUtil.px2Rem = (value, font_size) => {
  const regex2 = /^(\d+)(px)$/;
  const match = value.match(regex2);
  if (match) {
    let baseFontSize = window.YIUI.BaseYigoFontSize || 12;
    font_size = font_size || baseFontSize;
    const rem = parseFloat(match[1]) / font_size;
    return `${rem.toFixed(3)}rem`;
  } else {
    return value;
  }
};
class YesVBaseComponent {
  constructor(options) {
    this.compData = /* @__PURE__ */ new Map();
    this.owner = options;
    this.initOptions(options);
  }
  initOptions(options) {
    this.key = options.key;
    this.caption = options.caption;
    this.defaultValue = options.defaultValue;
    this.editable = options.editable;
    this.format = options.format;
    this.buddyKey = options.buddyKey;
    this.buddy = options.buddy;
    this.extend = options.extend;
    this.clearable = options.clearable;
    this.width = options.width;
    this.height = options.height;
    this.enable = options.enable;
    this.visible = options.visible;
    this.required = options.required;
    this.error = options.errorInfo ? options.errorInfo.error : false;
    this.errorMsg = options.errorInfo ? options.errorInfo.errorMsg : "";
    this.tip = options.tip;
    this.formulaTip = options.formulaTip;
    this.cssClass = options.cssClass;
  }
  getOwner() {
    return this.owner;
  }
  getId() {
    return this.owner.getId();
  }
  getOuterCss(options, isMargin) {
    var elCss = /* @__PURE__ */ new Map();
    options.position && elCss.set("position", options.position);
    options.left && elCss.set("left", options.left);
    options.right && elCss.set("right", options.right);
    options.top && elCss.set("top", options.top);
    options.bottom && elCss.set("bottom", options.bottom);
    options.margin && elCss.set("margin", parseFloat(options.margin) + "px");
    options.leftMargin && elCss.set("margin-left", parseFloat(options.leftMargin) + "px");
    options.rightMargin && elCss.set("margin-right", parseFloat(options.rightMargin) + "px");
    options.topMargin && elCss.set("margin-top", parseFloat(options.topMargin) + "px");
    options.bottomMargin && elCss.set("margin-bottom", parseFloat(options.bottomMargin) + "px");
    if (options.cssObj) {
      var cssObj = options.cssObj;
      for (var k2 in cssObj) {
        var v2 = cssObj[k2];
        if (v2 != null) {
          elCss.set(k2, v2);
        }
      }
    }
    return elCss;
  }
  getInputCss(options) {
    var _a;
    var txtCss = /* @__PURE__ */ new Map();
    options.padding && txtCss.set("padding", parseFloat(options.padding) + "px");
    options.leftPadding && txtCss.set("padding-left", parseFloat(options.leftPadding) + "px");
    options.rightPadding && txtCss.set("padding-right", parseFloat(options.rightPadding) + "px");
    options.topPadding && txtCss.set("padding-top", parseFloat(options.topPadding) + "px");
    options.bottomPadding && txtCss.set("padding-bottom", parseFloat(options.bottomPadding) + "px");
    options.borderColor && txtCss.set("border-color", options.borderColor);
    options.borderRadius && txtCss.set("border-radius", options.borderRadius + "px");
    options.borderStyle && txtCss.set("border-style", options.borderStyle);
    options.foreColor && txtCss.set("color", ((_a = this.owner.format) == null ? void 0 : _a.foreColor) || options.foreColor);
    options.backColor && txtCss.set("background-color", options.backColor);
    if (options.borderWidth) {
      txtCss.set("border-width", parseFloat(options.borderWidth) + "px");
    } else if (options.borderStyle && !options.borderWidth) {
      txtCss.set("border-width", "1px");
    }
    var format = options.format;
    if (format) {
      var hAlign = format.hAlign;
      switch (hAlign) {
        case 0:
          txtCss.set("text-align", "left");
          break;
        case 1:
          txtCss.set("text-align", "center");
          break;
        case 2:
          txtCss.set("text-align", "right");
          break;
      }
    }
    return txtCss;
  }
  getLabelCss(options) {
    var lblCss = /* @__PURE__ */ new Map();
    var format = options.format;
    if (format) {
      var font = format.font;
      if (font) {
        font.name && lblCss.set("font-family", font.name);
        font.size && lblCss.set("font-size", FontSizeLayoutUtil.px2Rem(font.size + "px"));
        font.bold && lblCss.set("font-weight", "bold");
        font.italic && lblCss.set("font-style", "italic");
      }
    }
    return lblCss;
  }
  getEl() {
    return this.el;
  }
  getDom() {
    return this.el.getElm();
  }
  setOuterCss(outCss) {
    this.el.$appendStyles(outCss);
  }
  setInputCss(inputCss) {
    this.el.$appendStyles(inputCss);
  }
  setLabelCss(lblCss) {
  }
  setCssClass(cssClass) {
    this.el.$addClass(cssClass);
  }
  setFormatStyle(options) {
    this.iconCss = /* @__PURE__ */ new Map();
    this.txtCss = /* @__PURE__ */ new Map();
    var format = options.format;
    if (format) {
      var hAlign = format.hAlign;
      var vAlign = format.vAlign;
      switch (vAlign) {
        case 0:
          this.iconCss.set("vertical-align", "top");
          break;
        case 2:
          this.iconCss.set("vertical-align", "bottom");
          break;
      }
      if (vAlign > -1) {
        this.txtCss.set("vertical-align", VAlignment.parse(vAlign));
      }
      hAlign > -1 && this.txtCss.set("text-align", HAlignment.parse(hAlign));
    }
  }
  setAlignCssName(format) {
    this.el.$addClass(this.getHAlignCssName(format));
    this.el.$addClass(this.getVAlignCssName(format));
  }
  getHAlignCssName(format) {
    var str = "";
    switch (format.hAlign) {
      case HAlignment.LEFT:
      case HAlignment.CENTER:
      case HAlignment.RIGHT:
        str = "flex-";
        str += HAlignment.parse(format.hAlign);
        break;
    }
    return str;
  }
  getVAlignCssName(format) {
    var str = "";
    switch (format.vAlign) {
      case VAlignment.TOP:
      case VAlignment.CENTER:
      case VAlignment.BOTTOM:
        str = "flex-";
        str += VAlignment.parse(format.vAlign);
        break;
    }
    return str;
  }
  initCss(options) {
    if (!options || !this.el) {
      return;
    }
    var outerCss = this.getOuterCss(options, false);
    outerCss && this.setOuterCss(outerCss);
    var inputCss = this.getInputCss(options);
    inputCss && this.setInputCss(inputCss);
    var lblCss = this.getLabelCss(options);
    lblCss && this.setLabelCss(lblCss);
    this.setFormatStyle(options);
    if (options.format && options.format.highlightBackColor) {
      CssUtil.setHighlightBackColor(this.el, options.format.highlightBackColor);
    }
  }
  beforeRender($el) {
    if (null != $el) {
      if (vb.isVirtual($el)) {
        this.rawEl = void 0;
      } else if ($el[0]) {
        this.rawEl = $el[0];
      } else {
        this.rawEl = $el;
      }
    }
    if (!this.rawEl) {
      this.el = $el;
    } else {
      this.el = YElement.buildFromVNode(h$1("div"));
      this.el.$setRawDomElm(this.rawEl);
    }
    this.el.$addClass("vnode");
    this.el.$setAttr("id", this.owner.getId());
  }
  afterRender() {
    let owner = this.owner;
    var style = CssUtil.getStyle(owner.meta, owner);
    owner.cssObj && (style.cssObj = owner.cssObj);
    style && this.initCss(style);
    owner._needCheckRequired && this.needCheckRequired();
    owner.checkEnd && owner.checkEnd(owner.value);
    owner.enable != void 0 && this.setEnable(owner.enable);
    owner.visible != void 0 && this.setVisible(owner.visible);
    owner.required != void 0 && this.setRequired(owner.required);
    this.error != void 0 && this.setError(this.error, this.errorMsg);
    owner.width && this.setWidth(owner.width);
    owner.height && this.setHeight(owner.height);
    owner.tip && this.setTip(owner.tip);
    this.cssClass && this.setCssClass(this.cssClass);
    owner.caption && this.setCaption(owner.caption);
  }
  render(ct) {
    let form = this.owner.getForm();
    let renderContext = form.getRenderContext();
    this.beforeRender(ct);
    this.createHtml();
    this.afterRender();
    this.showFormulaTip();
    if (renderContext.isPrinting()) {
      this.installPrint();
    } else {
      this.install();
    }
  }
  installPrint() {
    this.el.$addClass(`ui-print`);
  }
  // 内部实现重写此方法
  setWidth(width) {
    var w = width == "auto" ? "" : width;
    if (w.toString().indexOf("px") > 0) {
      w = FontSizeLayoutUtil.px2Rem(w.toString());
    }
    this.el.$setWidth(w);
  }
  // 内部实现重写此方法
  setHeight(height) {
    var h2 = height == "auto" ? "" : height;
    if (h2.toString().indexOf("px") > 0) {
      h2 = FontSizeLayoutUtil.px2Rem(h2.toString());
    }
    this.el.$setHeight(h2);
  }
  flex(flex) {
    if (void 0 == flex) {
      console.log("basecomponent get flex not impl");
    } else {
      this.el.$addStyle("flex", flex);
    }
  }
  setCss(key2, val) {
    this.el.$addStyle(key2, val);
  }
  /**
   * TODO 确认用途
   */
  left(left) {
    if (void 0 == left) {
      console.log("basecomponent get left not impl");
    } else {
      this.el.$addStyle("position", "absolute");
      this.el.$addStyle("left", left);
    }
  }
  /**
   * TODO 确认用途
   */
  top(top) {
    if (void 0 == top) {
      console.log("basecomponent get left not impl");
    } else {
      this.el.$addStyle("position", "absolute");
      this.el.$addStyle("top", top);
    }
  }
  setBackColor(backColor) {
    this.el.$addStyle("background-image", "none").$addStyle("background-color", backColor);
  }
  setForeColor(foreColor) {
    this.el.$addStyle("color", foreColor);
  }
  setEnable(enable) {
    this.enable = enable;
    if (!this.el)
      return;
    this.__setEnable(this.el, enable);
  }
  // 作用对象不一样
  __setEnable(ele, enable) {
    if (enable) {
      ele.$removeClass("ui-readonly");
    } else {
      ele.$addClass("ui-readonly");
    }
  }
  setVisible(visible) {
    if (visible) {
      this.el.$removeClass("ui-hidden");
    } else {
      this.el.$addClass("ui-hidden");
    }
  }
  setError(error, msg) {
    if (error) {
      if (!this.errorElm && !this.owner.advancedQueryJsonValue) {
        this.errorElm = YElement.buildFromVNode(
          h$1("span", { class: { "error-icon": true } })
        );
        this.el.$addClass("error");
        var node = this.getWrapNode();
        if (node) {
          this.errorElm.$prependTo(node);
        } else {
          this.errorElm.$appendTo(this.el);
        }
      }
      this.errorElm.$setAttr("title", msg);
    } else {
      if (this.errorElm) {
        this.errorElm.$remove();
        this.errorElm = null;
      }
      this.el.$removeClass("error");
    }
  }
  setRequired(required) {
    if (required) {
      if (!this.requireElm) {
        this.requireElm = YElement.buildFromVNode(
          h$1("span", { class: { "required-icon": true } })
        );
        this.el.$addClass("required");
        var node = this.getWrapNode();
        if (node) {
          this.requireElm.$prependTo(node);
        } else {
          this.requireElm.$appendTo(this.el);
        }
        this.requireElm.$setAttr("title", I18N.getString("REQUIRED_TIP", "请输入") + (this.caption || ""));
      }
    } else {
      if (this.requireElm) {
        this.requireElm.$remove();
        this.requireElm = null;
      }
      this.el.$removeClass("required");
    }
  }
  setTip(tip) {
    if (this.formulaTip)
      return;
    tip = tip || this.tip;
    if (tip) {
      tip = TypeConvertor.toString(tip);
      tip = tip.replace(/\\n/g, "\r");
      this.el && this.el.$setAttr("title", tip);
    } else {
      this.el && this.el.$setAttr("title");
    }
  }
  focus() {
    this.el && this.el.$setAttr("tabindex", 0).$focus();
  }
  setCaption(caption) {
    this.caption = caption;
    this.el.$setAttr("caption", caption);
  }
  getCaption() {
    return this.caption;
  }
  setValue(value) {
    this.value = value;
  }
  getValue() {
    return this.value;
  }
  setShowText(text) {
  }
  showFormulaTip() {
    var self2 = this;
    self2.el.$addListener("mouseenter", async function(e) {
      if (!self2.formulaTip)
        return;
      if (self2.owner.isDestroyed)
        return;
      var errorNode = self2.el.$findByClassName("error-icon")[0];
      var requiredNode = self2.el.$findByClassName("required-icon")[0];
      if (!errorNode && !requiredNode) {
        let form = self2.owner.getForm();
        let cxt = new ViewContext(form);
        let msg = await form.asyncEval(self2.formulaTip, cxt);
        var zIndex = self2.owner.getZIndex("tip");
        ToolTipUtil.show(self2.el.getElm(), zIndex, msg, "");
      }
    });
  }
  install() {
  }
  destroy() {
    if (this.rawEl) {
      this.rawEl.remove();
      this.rawEl = void 0;
      delete this.rawEl;
    } else if (this.el) {
      this.el.$remove();
    }
  }
  isDestroyed() {
    return this.el ? this.el.getAttachData("isRemoved") : false;
  }
  margin(margin) {
    this.el.$addStyle("margin", margin);
  }
  marginTop(top) {
    this.el.$addStyle("margin-top", top);
  }
  marginRight(right) {
    this.el.$addStyle("margin-right", right);
  }
  marginBottom(bottom) {
    this.el.$addStyle("margin-bottom", bottom);
  }
  marginLeft(left) {
    this.el.$addStyle("margin-left", left);
  }
  css(key2, value) {
    this.el.$addStyle(key2, value);
  }
  beforeDestroy() {
  }
  setId(id) {
    this.el && this.el.$setAttr("id", id);
  }
  isActive() {
    var active = true;
    this.el.$parents((p) => {
      if (p.hasClass("ui-tabs-panel")) {
        if (!p.hasClass("aria-show")) {
          active = false;
          return false;
        }
      }
      return true;
    });
    return active;
  }
  needCheckRequired() {
    this.el && this.el.$setAttr("checkrequired", true + "");
  }
  addViewBadge(badge, view) {
    var el = view ? view : this.el;
    var value = badge[1];
    if (el.__IsVirtual) {
      var _view = el && el.$setAttr("badgeValue", value).$addClass("badge");
      if (parseFloat(value) < 0) {
        _view == null ? void 0 : _view.$addClass("dota").$removeClass("dotm");
      } else {
        _view == null ? void 0 : _view.$addClass("dotm").$removeClass("dota");
      }
    } else {
      var _view = el && el.$setAttr("badgeValue", value).$addClass("badge");
      if (parseFloat(value) < 0) {
        _view == null ? void 0 : _view.$addClass("dota").$removeClass("dotm");
      } else {
        _view == null ? void 0 : _view.$addClass("dotm").$removeClass("dota");
      }
    }
  }
  removeViewBadge(badge, view) {
    var _view = view ? view : this.el;
    if (_view == null ? void 0 : _view.__IsVirtual) {
      _view.$removeClass("badge dota dotm").$setAttr("badgeValue");
    } else {
      _view == null ? void 0 : _view.$removeClass("badge dota dotm").$setAttr("badgeValue");
    }
  }
  focusOwner() {
    return this.owner.focusOwner();
  }
  requestNextFocus(...args) {
    if (typeof this.owner.requestNextFocus == "function") {
      return this.owner.requestNextFocus.apply(this.owner, args);
    }
  }
  async commitValue(...args) {
    LoadingUtil.show();
    try {
      let isChanged = await this.owner.commitValue.apply(this.owner, args);
      if (isChanged != false) {
        this.owner.getForm().getUIOptTracer().traceOnValueChanged(this.owner, this.owner.value);
      }
      return isChanged;
    } finally {
      LoadingUtil.hide();
    }
  }
  createHtml(args) {
  }
  getWrapNode() {
    return null;
  }
  setCompData(name, value) {
    this.compData.set(name, value);
  }
  getCompData(name) {
    if (name) {
      return this.compData.get(name);
    } else {
      return this.compData;
    }
  }
  removeCompData(key2) {
    this.compData.delete(key2);
  }
}
var __defProp$E = Object.defineProperty;
var __getOwnPropDesc$E = Object.getOwnPropertyDescriptor;
var __decorateClass$E = (decorators, target, key2, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$E(target, key2) : target;
  for (var i = decorators.length - 1, decorator; i >= 0; i--)
    if (decorator = decorators[i])
      result = (kind ? decorator(target, key2, result) : decorator(result)) || result;
  if (kind && result)
    __defProp$E(target, key2, result);
  return result;
};
class YesVBaseButton extends YesVBaseComponent {
  constructor(options) {
    super(options);
  }
  beforeRender(ct) {
    super.beforeRender(ct);
    this.initCompStyle(this.owner.meta);
  }
  initCompStyle(meta) {
    switch (meta.type) {
      case ControlType.IMAGE:
        var compStyle = meta.compStyle || CompSetting.CompStyle;
        if (compStyle && !meta.buddyKey) {
          this.cssClass += " " + compStyle;
        }
    }
  }
  isClicking(el) {
    return el && el.hasClass("btn-load");
  }
  setClicking(el) {
    el && el.$addClass("btn-load");
  }
  removeClicking(el) {
    el && el.$removeClass("btn-load");
  }
  async doOnClick(event2, subItem) {
    var fn = this.owner.doOnClick;
    if (typeof fn === "function") {
      return fn.apply(this.owner, arguments);
    }
  }
  getImageBase64URL(icon, thumbnail, sourceType) {
    var fn = this.owner.getImageBase64URL;
    if (typeof fn === "function") {
      return fn.apply(this.owner, arguments);
    }
  }
}
__decorateClass$E([
  TraceUIOptEvent()
], YesVBaseButton.prototype, "doOnClick", 1);
const Types = {
  OWNER_DRAW: "ownerDraw",
  ITEM_OWNER_DRAW: "itemOwnerDraw",
  CELL_OWNER_DRAW: "cellOwnerDraw"
};
class BaseOwnerDrawContext {
  constructor(component, type) {
    this._component = null;
    this._formId = -1;
    this._sourceObj = null;
    if (null == component) {
      return;
    }
    this._component = component;
    this._formId = component.owner.getForm().formID;
    this._type = type || Types.OWNER_DRAW;
    this._value = component.getValue();
  }
  getComponent() {
    return this._component;
  }
  getFormId() {
    return this._formId;
  }
  getType() {
    return this._type;
  }
  getValue() {
    return this._value;
  }
  setSourceObj(sourceObj) {
    this._sourceObj = sourceObj;
  }
  getSourceObj() {
    return this._sourceObj;
  }
}
class ComboboxItemOwnerDrawContext extends BaseOwnerDrawContext {
  // current item data
  constructor(combobox, item) {
    super(combobox, Types.ITEM_OWNER_DRAW);
    this._items = combobox.owner.getItems();
    this._item = item;
  }
  getItems() {
    return this._items;
  }
  getItem() {
    return this._item;
  }
}
const _Service = class _Service2 {
  static reg(key2, handler, description) {
    if (key2.trim().length <= 0) {
      console.log(`Own draw need a valid key string`);
      return;
    }
    if (typeof handler != "function") {
      console.log(`Own draw need a valid handler`);
      return;
    }
    if (_Service2.handlers.containsKey(key2.trim().toLowerCase())) {
      alert(`Fail to register owner draw service 4 "${key2}". Key already exist!`);
      return;
    }
    _Service2.handlers.put(key2.trim().toLowerCase(), {
      handler,
      description
    });
  }
  static get(key2) {
    let result = _Service2.handlers.get(key2.trim().toLowerCase());
    if (!result) {
      console.log(`Owner draw ${key2} not supported!`);
      return;
    }
    return result.handler;
  }
  static getAll() {
    return _Service2.handlers;
  }
};
_Service.handlers = new HashMap();
let Service = _Service;
const YesOwnerDraw = {
  Service,
  ComboboxItemOwnerDrawContext,
  BaseOwnerDrawContext,
  Types
};
class OwnerDrawUtil {
  static getHandler(options) {
    let cssClass = options.cssClass;
    if (!cssClass || typeof cssClass != "string" || cssClass.trim().length == 0) {
      return;
    }
    let classes = cssClass.trim().split(" ");
    for (let i = 0; i < classes.length; i++) {
      let parts = classes[i].trim().split(":");
      if (parts.length != 2) {
        continue;
      }
      if (parts[0] == "ownerDraw") {
        let _ownerDrawKey = "" + parts[1];
        if (_ownerDrawKey.trim().length > 0) {
          return YesOwnerDraw.Service.get(_ownerDrawKey);
        }
      }
    }
    return null;
  }
}
const getOwnerDrawHandler = function(yesComp) {
  let cssClass = yesComp.cssClass;
  if (!cssClass || typeof cssClass != "string" || cssClass.trim().length == 0) {
    return;
  }
  let classes = cssClass.trim().split(" ");
  for (let i = 0; i < classes.length; i++) {
    let parts = classes[i].trim().split(":");
    if (parts.length != 2) {
      continue;
    }
    if (parts[0] == "ownerDraw") {
      let _ownerDrawKey = "" + parts[1];
      if (_ownerDrawKey.trim().length > 0) {
        return YesOwnerDraw.Service.get(_ownerDrawKey);
      }
    }
  }
  return null;
};
const RenderEventListener = (params = {}) => (target, name, descriptor) => {
  var type = params["type"];
  var fn = renderEventFns.get(type);
  const origin = descriptor.value;
  descriptor.value = async function(...args) {
    var orgMethod = async function(target2, args2) {
      return await origin.apply(target2, args2);
    };
    return await fn(this, orgMethod, ...args);
  };
};
var renderEventFns = /* @__PURE__ */ new Map();
class YesCompAspectRegistry {
  constructor() {
  }
  static registRenderEvent(type, fn) {
    renderEventFns.set(type, fn);
  }
}
YesCompAspectRegistry.registRenderEvent("IconSourceLoad", async function(target, orgMethod, ...args) {
  var option2 = args[0];
  var icon = args[1];
  var element = args[2];
  var key2 = option2["key"];
  var iconCode = option2["iconCode"];
  var scene = option2["scene"];
  if (!iconCode && !icon) {
    iconCode = key2;
  }
  let info = await IconSourceLoader.getIconSourceInfo(iconCode, scene);
  var iconSourceClass;
  if (info) {
    iconSourceClass = info["className"];
  }
  if (iconSourceClass) {
    element.$addClass(iconSourceClass);
    return true;
  } else {
    return orgMethod(target, args);
  }
});
YesCompAspectRegistry.registRenderEvent("OwnerDraw", function(target, orgMethod, ...args) {
  let ownerDrawHandler = getOwnerDrawHandler(target);
  if (ownerDrawHandler) {
    var ret = ownerDrawHandler(context, ...args);
    if (!ret) {
      orgMethod(target, args);
    }
  } else {
    orgMethod(target, args);
  }
});
var __defProp$D = Object.defineProperty;
var __getOwnPropDesc$D = Object.getOwnPropertyDescriptor;
var __decorateClass$D = (decorators, target, key2, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$D(target, key2) : target;
  for (var i = decorators.length - 1, decorator; i >= 0; i--)
    if (decorator = decorators[i])
      result = (kind ? decorator(target, key2, result) : decorator(result)) || result;
  if (kind && result)
    __defProp$D(target, key2, result);
  return result;
};
class YesVButton extends YesVBaseButton {
  constructor(options) {
    super(options);
    this.icon = options.icon;
    this.uploadType = options.uploadType;
    this.ownerDrawHandler = OwnerDrawUtil.getHandler(options);
    this.iconCode = options.iconCode;
    this.key = options.key;
  }
  createHtml() {
    this.el.$addClass("ui-btn").$addClass("ui-control").$setAttr("tabindex", "0");
    if (this.ownerDrawHandler) {
      this.reDraw();
    } else {
      const _btn = h$1("button");
      this.$btn = YElement.buildFromVNode(_btn).$appendTo(this.el);
      this.$span = YElement.buildFromVNode(h$1("span.txt", this.caption)).$appendTo(this.$btn);
    }
    this.setIcon(this.icon);
    this.setType();
    this.setCheckOnClickNode();
  }
  getOwnerDrawHandler() {
    return this.ownerDrawHandler;
  }
  /**
   * @caption 重绘
   * @param {Object} sourceObj - 控件消息，例："{name: 'setValue', args: arguments}" 
   */
  reDraw(sourceObj) {
    let ownerDrawHandler = this.getOwnerDrawHandler();
    var context2 = new YesOwnerDraw.BaseOwnerDrawContext(this, null);
    sourceObj && context2.setSourceObj(sourceObj);
    this.el.addPostpatchHook((el) => {
      ownerDrawHandler(context2, el.getElm());
    });
  }
  getInput() {
  }
  getClearBtn() {
  }
  initCss(options) {
    if (!options || !this.el) {
      return;
    }
    var outerCss = this.getOuterCss(options, false);
    this.el.$appendStyles(outerCss);
    var inputCss = this.getInputCss(options);
    var lblCss = this.getLabelCss(options);
    this.$btn && this.$btn.$appendStyles(lblCss).$appendStyles(inputCss);
    this.setFormatStyle(options);
    this.$span && this.$span.$appendStyles(this.txtCss || /* @__PURE__ */ new Map());
    var format = options.format;
    if (format) {
      if (format.hAlign != HAlignment.LEFT && format.hAlign != HAlignment.RIGHT) {
        format.hAlign = HAlignment.CENTER;
      }
      if (format.vAlign != VAlignment.TOP && format.vAlign != VAlignment.BOTTOM) {
        format.vAlign = VAlignment.CENTER;
      }
      this.setAlignCssName(format);
      if (format && format.highlightBackColor) {
        CssUtil.setHighlightBackColor(this.el, format.highlightBackColor);
      }
    }
  }
  setType() {
    this.el.$addClass(`btn-${this.owner.btnType}`);
  }
  // 处理点击的时候，是否点击在本控件上，是否执行父层事件
  setCheckOnClickNode() {
    this.el.$setAttr("checkOnClickNode", this.owner.checkOnClickNode);
  }
  setShowText(caption) {
    if (this.owner.onlyIcon) {
      this.el.$addClass("onlyIcon");
      caption = "";
    }
    this.$span && this.$span.$setInnerText(caption);
  }
  setValue(value) {
    if (this.ownerDrawHandler) {
      const sourceObj = { name: "setValue", args: arguments };
      this.reDraw(sourceObj);
    } else {
      this.setShowText(value != null ? value.toString() : "");
    }
  }
  setHeight(height) {
    super.setHeight(height);
    if (this.icon) {
      var textheight = 12;
      if (this.$icon) {
        this.$icon.$setWidth(textheight).$setHeight(textheight);
      }
    }
  }
  setBackColor(backColor) {
    this.$btn && this.$btn.$addStyle("background-color", backColor);
  }
  setForeColor(foreColor) {
    this.$span && this.$span.$addStyle("color", foreColor);
  }
  setIcon(icon) {
    if (!this.$icon) {
      const _icon = h$1("span.icon");
      this.$icon = YElement.buildFromVNode(_icon);
    }
    var self2 = this;
    this.owner.scene = "Button";
    this.loadIcon(this.owner, icon, self2.$icon).then(function(result) {
      if (result) {
        self2.$icon.$prependTo(self2.$btn);
        switch (self2.owner.iconLocation) {
          case 0:
            self2.$btn.$addClass("top");
            break;
          case 1:
            self2.$btn.$addClass("bottom");
            break;
          case 3:
            self2.$btn.$addClass("right");
            break;
          default:
            self2.$btn.$addClass("left");
            break;
        }
      } else {
        self2.$icon && self2.$icon.$addStyle("background-image", "none");
      }
    });
  }
  install() {
    var self2 = this;
    var win = window;
    self2.el.$click(debounce(async function(e) {
      if (self2.uploadType == "multiple") {
        win.uploadType = "multiple";
      } else {
        win.uploadType = "";
      }
      if (self2.enable) {
        self2.focusOwner();
        await self2.doOnClick(e, null);
      }
    }));
    self2.el.$keydown(debounce(async function(event2) {
      var keyCode = event2.keyCode || event2.charCode;
      switch (keyCode) {
        case 13:
        case 108:
          await self2.doOnClick(event2, null);
          event2.preventDefault();
          break;
        case 9:
          self2.requestNextFocus(keyCode);
          event2.preventDefault();
          break;
      }
    }));
  }
  async loadIcon(option2, icon, element) {
    var self2 = this;
    if (!icon) {
      return false;
    }
    try {
      var url;
      if (Utils.isBase64Image(icon)) {
        url = icon;
      } else {
        url = await this.getImageBase64URL(icon, null, null);
      }
      if (!url) {
        return false;
      }
      if (void 0 == self2.iconCss) {
        self2.iconCss = /* @__PURE__ */ new Map();
      }
      self2.iconCss.set("background-image", "url(" + url + ")");
      element.$appendStyles(self2.iconCss);
      element.$removeClass("fail");
      return true;
    } catch (error) {
      element.$addClass("fail");
      return true;
    }
  }
}
__decorateClass$D([
  RenderEventListener({ "type": "IconSourceLoad" })
], YesVButton.prototype, "loadIcon", 1);
class YesAdvancedQuery {
  constructor(options) {
    this.enable = false;
    this.visible = false;
    this.options = options;
    this.enable = options.enable;
    this.visible = options.visible;
    this.key = options.key;
  }
  render(container) {
    const comp = this.owner.associatedComp;
    if (!comp)
      return;
    const comp_el = comp.getEl();
    comp_el.$addClass("advancedqueryconditionfieldcom");
    if (!container) {
      container = comp.impl.getWrapNode();
    }
    const attrs = {
      enable: this.enable + "",
      id: comp.id + "_Query",
      offormid: this.options.form.formID,
      key: this.options.key
    };
    this.createHTML(container, attrs);
    this.install();
  }
  setEnable(enable) {
    this.enable = enable;
    if (!this.queryBtn) {
      return;
    }
    if (enable) {
      this.queryBtn.$removeClass("ui-readonly");
    } else {
      this.queryBtn.$addClass("ui-readonly");
    }
    this.queryBtn.$setAttr("enable", enable + "");
  }
  setVisible(visible) {
    if (!this.queryBtn) {
      return;
    }
    if (visible) {
      this.queryBtn.$removeClass("ui-hidden");
    } else {
      this.queryBtn.$addClass("ui-hidden");
    }
  }
  createHTML(container, attrs) {
    if (!container) {
      return;
    }
    const hasData = this.hasValue();
    if (!this.queryBtn) {
      this.queryBtn = YElement.buildFromVNode(h$1("div.query.advancedquerybutton" + (hasData ? ".useradvancedquerybutton" : ""), { attrs })).$appendTo(container);
    }
    this.owner.queryBtn = this.queryBtn;
    this.setEnable(this.enable);
    this.setVisible(this.visible);
  }
  hasValue() {
    const fn = this.owner.hasValue;
    if (typeof fn === "function") {
      return fn.apply(this.owner, arguments);
    }
  }
  install() {
    this.queryBtn && this.queryBtn.$click(this.onAdvancedQueryButtonClick.bind(this));
  }
  async onAdvancedQueryButtonClick() {
    try {
      LoadingUtil.show();
      if (!this.enable) {
        return;
      }
      const form = this.options.form;
      await form.asyncEval("showMultipleOptions('" + this.key + "')");
    } finally {
      LoadingUtil.hide();
    }
  }
  setHasAdvancedQueryData(hasData) {
    if (!this.queryBtn) {
      return;
    }
    if (hasData) {
      this.queryBtn.$addClass("useradvancedquerybutton");
    } else {
      this.queryBtn.$removeClass("useradvancedquerybutton");
    }
  }
}
class YesAdvancedQueryBuilder {
  constructor(options) {
  }
  static create(options) {
    return new YesAdvancedQuery(options);
  }
}
class YesComponentBuilder {
  constructor(options) {
  }
  static initOptions(options) {
  }
  static build(comp) {
    this.initOptions(comp);
    const yescomp = this.create(comp);
    if (comp.useAdvancedQuery) {
      const impl2 = YesAdvancedQueryBuilder.create(comp.advancedQueryObj);
      impl2.owner = comp.advancedQueryObj;
      comp.advancedQueryObj.impl = impl2;
    }
    return yescomp;
  }
  static create(options) {
    console.error(options.key + " yescomponentbuilder is not impl.");
    return null;
  }
}
class YesButtonBuilder extends YesComponentBuilder {
  static create(options) {
    return new YesVButton(options);
  }
}
class VEchartsBase extends YesVBaseButton {
  constructor(options) {
    super(options);
    this.chartTemplate = options.chartTemplate;
  }
  createHtml() {
    this.el.$addClass("ui-chart");
    this.draw();
  }
  initCss(options) {
    super.initCss(options);
  }
  afterRender() {
    super.afterRender();
  }
  //TODO 不要默认减20
  setWidth(width) {
    if (width) {
      var w = Utils.isNumeric(width) ? parseInt(width) - 20 + "px" : width;
      this.el.$addStyle("width", w);
      this.el.$addStyle("margin-right", "20px");
    }
  }
  //TODO 不要默认减30
  setHeight(height) {
    if (height) {
      var h2 = Utils.isNumeric(height) ? parseInt(height) - 20 + "px" : height;
      this.el.$addStyle("height", h2 + "");
    }
  }
  install() {
  }
  initData(options, dataModel) {
  }
  draw() {
    var _this = this;
    var dataModel = _this.getDataModel();
    _this.options = {};
    var options = _this.options;
    if (_this.chartTemplate) {
      var form = _this.owner.getForm();
      var dataSource = _this.owner.meta.dataSource;
      var document2 = form.getDocument();
      var table = document2.getByKey(dataSource.bindingKey);
      options = _this.getYesChartOption(_this.chartTemplate, table);
    } else {
      _this.initData(options, dataModel);
    }
    this.el.addPostpatchHook(() => {
      _this.chart = init$2(_this.el.getElm());
      _this.chart.setOption(options, true);
      _this.chart.on("click", function(params) {
        try {
          _this.setCompData(CompDataType.YES_Chart_Raw_Event, params);
          _this.doOnClick(params.event, null);
        } finally {
          _this.removeCompData(CompDataType.YES_Chart_Raw_Event);
        }
      });
    });
  }
  reDraw() {
    if (this.chart) {
      var chart = this.chart;
      setTimeout(function() {
        chart.resize();
      }, 200);
    }
  }
  getDataModel() {
    var fn = this.owner.getDataModel;
    if (typeof fn === "function") {
      return fn.apply(this.owner, arguments);
    }
  }
}
class VYesBar extends VEchartsBase {
  constructor(options) {
    super(options);
    this.owner.barWidth = 0.5;
    this.owner.yMin = 0;
    this.owner.xMin = null;
    this.owner.grouped = true;
    this.chartType = options.chartType;
  }
  initData(options, dataModel) {
    var showValues = this.owner.showValues, chartType = this.owner.chartType, horizontal = false, stacked = false;
    options.xScale = [];
    options.yScale = [];
    switch (chartType) {
      case 1:
        stacked = true;
        break;
      case 2:
        horizontal = true;
        break;
      case 3:
        horizontal = true;
        stacked = true;
        break;
    }
    var xyData = [], series = [], categories = [];
    if (dataModel) {
      series = dataModel.series || [];
      categories = dataModel.categories || [];
    }
    var legendData = [];
    for (var i = 0, len = series.length; i < len; i++) {
      series[i].name && legendData.push(series[i].name);
    }
    options.legend = {
      data: legendData,
      x: "center",
      y: "bottom"
    };
    var xAxisData = [];
    var bNumeric = true;
    for (var j = 0, len2 = categories.length; j < len2; j++) {
      xAxisData.push(categories[j]);
      if (Utils.isNumeric(categories[j])) {
        bNumeric = false;
      }
    }
    bNumeric && xAxisData.sort(function(a, b) {
      return parseInt(a) - parseInt(b);
    });
    for (var i = 0, len = series.length; i < len; i++) {
      var data2 = [];
      for (var j = 0, len2 = categories.length; j < len2; j++) {
        var index2 = xAxisData.indexOf(categories[j]);
        data2[index2] = series[i].data[j];
      }
      var datas = {
        data: data2,
        name: series[i].name,
        type: "bar",
        avoidLabelOverlap: true,
        label: {
          show: showValues,
          position: horizontal ? "insideRight" : "inside"
        }
      };
      stacked && (datas.stack = "total");
      xyData.push(datas);
    }
    options.series = xyData;
    var xAxis = [
      {
        type: "category",
        axisTick: { show: false },
        data: xAxisData,
        name: this.owner.categoryAxisTitle,
        axisLine: { show: true },
        splitLine: { show: true }
      }
    ];
    var yAxis = [
      {
        type: "value",
        name: this.owner.seriesAxisTitle,
        axisLine: { show: true },
        axisTick: { show: true },
        splitLine: { show: true }
      }
    ];
    if (horizontal) {
      options.yAxis = xAxis;
      options.xAxis = yAxis;
    } else {
      options.xAxis = xAxis;
      options.yAxis = yAxis;
    }
    options.color = [
      "#5B8FF9",
      "#5AD8A6",
      "#5D7092",
      "#F6BD16",
      "#E86452",
      "#6DC8EC",
      "#945FB9",
      "#FF9845",
      "#1E9493",
      "#FF99C3"
    ];
    options.tooltip = {
      trigger: "axis",
      axisPointer: {
        type: "shadow"
      }
    };
    options.title = {
      text: this.owner.title,
      left: "center"
    };
  }
}
class VYesLine extends VEchartsBase {
  constructor(options) {
    super(options);
  }
  initData(options, dataModel) {
    var showValues = this.owner.showValues;
    var xyData = [], series = [], categories = [];
    if (dataModel) {
      series = dataModel.series || series;
      categories = dataModel.categories || categories;
    }
    var legendData = [];
    for (var i = 0, len = series.length; i < len; i++) {
      legendData.push(series[i].name);
    }
    options.legend = {
      data: legendData,
      x: "center",
      y: "bottom"
    };
    var xAxisData = [];
    var bNumeric = true;
    for (var j = 0, len2 = categories.length; j < len2; j++) {
      xAxisData.push(categories[j]);
      if (Utils.isNumeric(categories[j])) {
        bNumeric = false;
      }
    }
    bNumeric && xAxisData.sort(function(a, b) {
      return parseInt(a) - parseInt(b);
    });
    xyData = [];
    for (var i = 0, len = series.length; i < len; i++) {
      var data2 = [];
      for (var j = 0, len2 = categories.length; j < len2; j++) {
        var index2 = xAxisData.indexOf(categories[j]);
        data2[index2] = series[i].data[j];
      }
      var datas = {
        data: data2,
        name: series[i].name,
        type: "line",
        label: {
          show: showValues,
          position: "top"
        }
      };
      xyData.push(datas);
    }
    options.series = xyData;
    var xAxis = [
      {
        type: "category",
        //axisTick: {show: false},
        // boundaryGap: false,
        data: xAxisData,
        name: this.owner.categoryAxisTitle,
        axisLine: { show: true },
        axisTick: { show: true },
        splitLine: { show: true }
      }
    ];
    var yAxis = [
      {
        type: "value",
        name: this.owner.seriesAxisTitle,
        axisLine: { show: true },
        axisTick: { show: true },
        splitLine: { show: true }
      }
    ];
    options.yAxis = yAxis;
    options.xAxis = xAxis;
    options.color = [
      "#5B8FF9",
      "#5AD8A6",
      "#5D7092",
      "#F6BD16",
      "#E86452",
      "#6DC8EC",
      "#945FB9",
      "#FF9845",
      "#1E9493",
      "#FF99C3"
    ];
    options.tooltip = {
      trigger: "axis"
      // axisPointer: {
      //     type: 'shadow'
      // }
    };
    options.title = {
      text: this.owner.title,
      left: "center"
    };
  }
}
class VYesPie extends VEchartsBase {
  constructor(options) {
    super(options);
    this.barWidth = 0.5;
    this.yMin = 0;
    this.xMin = null;
    this.xScale = [];
    this.yScale = [];
    this.grouped = true;
    this.seriesAxisTitle = options.seriesAxisTitle;
    this.categoryAxisTitle = options.categoryAxisTitle;
  }
  initData(options, dataModel) {
    var showValues = this.owner.showValues;
    var series = [];
    if (dataModel) {
      series = dataModel.series || series;
    }
    var data2 = [], legendData = [], item;
    for (var i = 0, len = series.length; i < len; i++) {
      item = series[i];
      legendData.push(item.name);
      data2.push({
        value: item.data[i],
        name: item.name
      });
    }
    options.legend = {
      orient: "vertical",
      left: "left",
      data: legendData
    };
    var datas = {
      data: data2,
      type: "pie",
      emphasis: {
        itemStyle: {
          shadowBlur: 10,
          shadowOffsetX: 0,
          shadowColor: "rgba(0, 0, 0, 0.5)"
        }
      },
      label: {
        show: showValues,
        formatter: "{b} : {c} ({d}%)"
      }
    };
    options.series = [datas];
    options.color = [
      "#5B8FF9",
      "#5AD8A6",
      "#5D7092",
      "#F6BD16",
      "#E86452",
      "#6DC8EC",
      "#945FB9",
      "#FF9845",
      "#1E9493",
      "#FF99C3"
    ];
    options.tooltip = {
      trigger: "item"
    };
    options.title = {
      text: this.owner.title,
      left: "center"
    };
  }
}
class VYesScatter extends VEchartsBase {
  constructor(options) {
    super(options);
  }
  initData(options, dataModel) {
    var showValues = this.owner.showValues;
    var xyData = [], series = [], categories = [];
    if (dataModel) {
      series = dataModel.series || [];
      categories = dataModel.categories || [];
    }
    var legendData = [];
    for (var i = 0, len = series.length; i < len; i++) {
      legendData.push(series[i].name);
    }
    options.legend = {
      data: legendData,
      x: "center",
      y: "bottom"
    };
    var xAxisData = [];
    var bNumeric = true;
    for (var j = 0, len2 = categories.length; j < len2; j++) {
      xAxisData.push(categories[j]);
      if (Utils.isNumeric(categories[j])) {
        bNumeric = false;
      }
    }
    bNumeric && xAxisData.sort(function(a, b) {
      return parseInt(a) - parseInt(b);
    });
    xyData = [];
    for (var i = 0, len = series.length; i < len; i++) {
      var data2 = [];
      for (var j = 0, len2 = categories.length; j < len2; j++) {
        var index2 = xAxisData.indexOf(categories[j]);
        data2[index2] = series[i].data[j];
      }
      var datas = {
        data: data2,
        name: series[i].name,
        symbolSize: 20,
        type: "scatter",
        label: {
          show: showValues,
          position: "top"
        }
      };
      xyData.push(datas);
    }
    options.series = xyData;
    var xAxis = [
      {
        type: "category",
        //axisTick: {show: false},
        //boundaryGap: false,
        data: xAxisData,
        name: this.owner.categoryAxisTitle,
        axisLine: { show: true },
        axisTick: { show: true },
        splitLine: { show: true }
      }
    ];
    var yAxis = [
      {
        type: "value",
        name: this.owner.seriesAxisTitle,
        axisLine: { show: true },
        axisTick: { show: true },
        splitLine: { show: true }
      }
    ];
    options.yAxis = yAxis;
    options.xAxis = xAxis;
    options.color = [
      "#5B8FF9",
      "#5AD8A6",
      "#5D7092",
      "#F6BD16",
      "#E86452",
      "#6DC8EC",
      "#945FB9",
      "#FF9845",
      "#1E9493",
      "#FF99C3"
    ];
    options.title = {
      text: this.owner.title,
      left: "center"
    };
  }
}
class VYesRadar extends VEchartsBase {
  constructor(options) {
    super(options);
    this.barWidth = 0.5;
    this.yMin = 0;
    this.xMin = null;
    this.xScale = [];
    this.yScale = [];
    this.grouped = true;
    this.seriesAxisTitle = options.seriesAxisTitle;
    this.categoryAxisTitle = options.categoryAxisTitle;
  }
  initData(options, dataModel) {
    var showValues = this.owner.showValues;
    var series = [], categories = [], legendData = [], data2 = [];
    if (dataModel) {
      series = dataModel.series || [];
      categories = dataModel.categories || [];
    }
    for (var i = 0, len = series.length; i < len; i++) {
      legendData.push(series[i].name);
      data2[i] = {
        value: series[i].data,
        name: series[i].name,
        label: {
          show: showValues,
          position: "insideRight"
        }
      };
    }
    var num = 0, indicator = [];
    for (var j = 0; j < categories.length; j++) {
      for (var k2 = 0; k2 < series.length; k2++) {
        if (num < series[k2].data[j]) {
          num = series[k2].data[j];
        }
      }
      indicator[j] = { name: categories[j], max: num };
      num = 0;
    }
    options.legend = { data: legendData, x: "center", y: "bottom" };
    options.series = [{ name: "", type: "radar", data: data2 }];
    options.radar = { name: {}, indicator, radius: 90 };
    options.color = [
      "#5B8FF9",
      "#5AD8A6",
      "#5D7092",
      "#F6BD16",
      "#E86452",
      "#6DC8EC",
      "#945FB9",
      "#FF9845",
      "#1E9493",
      "#FF99C3"
    ];
    options.tooltip = { trigger: "item" };
    options.title = { text: this.owner.title, left: "center" };
  }
}
class VYesGauge extends VEchartsBase {
  constructor(options) {
    super(options);
  }
  initData(options, dataModel) {
    if (!dataModel) {
      return;
    }
    var series = dataModel.series[0];
    var categories = dataModel.categories;
    var numFun = function(arr, index2) {
      var num = 0;
      for (var z = 0; z < arr.length; z++) {
        if (index2 < z) {
          break;
        }
        num += arr[z];
      }
      return parseInt(num + "");
    };
    var _data = series.data, data2 = [], sum2 = 0, self2 = this;
    var gaugeData = function(index2, _count, firstX2) {
      let h2 = self2.el.getElm().clientHeight;
      return {
        value: index2 == _data.length - 1 ? 99.99 : numFun(_count, index2),
        name: categories[index2],
        title: {
          offsetCenter: [firstX2 + index2 * 40, h2 / 2 * 0.5]
        },
        detail: {
          offsetCenter: [firstX2 + index2 * 40, h2 / 2 * 0.5 + 15]
        }
      };
    };
    var sumFun = function(arr) {
      return arr.reduce(function(prev2, curr, idx, arr2) {
        return prev2 + curr;
      });
    };
    sum2 = sumFun(_data);
    for (var j = 0; j < _data.length; j++) {
      _data[j] = parseFloat(_data[j] / sum2 * 100 + "");
    }
    var firstX = 0;
    if (_data.length % 2 == 0) {
      firstX = -(parseInt(_data.length / 2 - 1 + "") * 40 + 20);
    } else {
      firstX = -(parseInt(_data.length / 2 + "") * 40);
    }
    var self2 = this;
    this.el.addPostpatchHook(() => {
      for (var i = 0; i < _data.length; i++) {
        if (_data[i]) {
          data2.push(gaugeData(i, _data, firstX));
        }
      }
      var elm = self2.el.getElm();
      var width = elm.clientWidth;
      options.series = [
        {
          type: "gauge",
          startAngle: 200,
          endAngle: -20,
          // radius: "90%",//圆弧半径，可以使用百分比
          axisLine: {
            lineStyle: {
              width: width / 100 * 2.5
              //圆弧部分 线宽
            }
          },
          anchor: {
            show: false
          },
          pointer: {
            show: false
          },
          progress: {
            width: width / 100 * 2.5,
            show: true,
            overlap: true,
            roundCap: true
          },
          data: data2,
          axisTick: {
            show: false
          },
          axisLabel: {
            show: false
          },
          splitLine: {
            show: false
          },
          title: {
            fontSize: 8
          },
          detail: {
            width: 2,
            height: 2,
            fontSize: 8,
            borderRadius: 3,
            color: "auto",
            backgroundColor: "auto"
          }
        }
      ];
      options.title = {
        text: this.owner.title,
        left: "center"
      };
    });
  }
}
class VYesArea extends VEchartsBase {
  constructor(options) {
    super(options);
  }
  initData(options, dataModel) {
    var showValues = this.owner.showValues;
    var xyData = [], series = [], categories = [];
    if (dataModel) {
      series = dataModel.series || [];
      categories = dataModel.categories || [];
    }
    var legendData = [];
    for (var i = 0, len = series.length; i < len; i++) {
      legendData.push(series[i].name);
    }
    options.legend = {
      data: legendData,
      x: "center",
      y: "bottom"
    };
    var xAxisData = [];
    var bNumeric = true;
    for (var j = 0, len2 = categories.length; j < len2; j++) {
      xAxisData.push(categories[j]);
      if (Utils.isNumeric(categories[j])) {
        bNumeric = false;
      }
    }
    bNumeric && xAxisData.sort(function(a, b) {
      return parseInt(a) - parseInt(b);
    });
    xyData = [];
    for (var i = 0, len = series.length; i < len; i++) {
      var data2 = [];
      for (var j = 0, len2 = categories.length; j < len2; j++) {
        var index2 = xAxisData.indexOf(categories[j]);
        data2[index2] = series[i].data[j];
      }
      var datas = {
        data: data2,
        name: series[i].name,
        type: "line",
        areaStyle: {},
        label: {
          show: showValues,
          position: "top"
        }
      };
      xyData.push(datas);
    }
    options.series = xyData;
    var xAxis = [
      {
        type: "category",
        //axisTick: {show: false},
        boundaryGap: false,
        data: xAxisData,
        name: this.owner.categoryAxisTitle,
        axisLine: { show: true },
        axisTick: { show: true },
        splitLine: { show: true }
      }
    ];
    var yAxis = [
      {
        type: "value",
        name: this.owner.seriesAxisTitle,
        axisLine: { show: true },
        axisTick: { show: true },
        splitLine: { show: true }
      }
    ];
    options.yAxis = yAxis;
    options.xAxis = xAxis;
    options.color = [
      "#5B8FF9",
      "#5AD8A6",
      "#5D7092",
      "#F6BD16",
      "#E86452",
      "#6DC8EC",
      "#945FB9",
      "#FF9845",
      "#1E9493",
      "#FF99C3"
    ];
    options.tooltip = {
      trigger: "axis"
      // axisPointer: {
      //     type: 'shadow'
      // }
    };
    options.title = {
      text: this.owner.title,
      left: "center"
    };
  }
}
class YesChart {
  constructor() {
  }
  isYesFormula(o) {
    return o && typeof o === "string" && (o.indexOf(":") > -1 && o.indexOf("yes-") > -1);
  }
  getYesObjByFormula(formula, provider) {
    var dataObjList = [];
    if (!this.isYesFormula(formula)) {
      return formula;
    }
    if (formula.indexOf("yes-data:column") > -1) {
      var columnKey = formula.split("=")[1];
      var size = provider.getSize();
      for (var row = 0; row < size; row++) {
        dataObjList.push(provider.getValue(columnKey, row));
      }
    }
    if (formula.indexOf("yes-value:column") > -1) {
      const columnKey2 = formula.split("=")[1];
      const size2 = provider.getSize();
      if (size2 == 0) {
        throw new Error(`绑定数据表无有效数据`);
      }
      let result = "";
      if (provider.contain(columnKey2)) {
        for (var row = 0; row < size2; row++) {
          if (row == 0) {
            result = provider.getValue(columnKey2, row);
          }
          if (result !== provider.getValue(columnKey2, row)) {
            throw new Error(`无效的列定义：[${formula}], 列[${columnKey2} ]数据不唯一`);
          }
        }
      }
      return result;
    }
    if (formula.indexOf("yes-data-unique:column") > -1) {
      var seen = /* @__PURE__ */ new Map();
      var columnKey = formula.split("=")[1];
      var size = provider.getSize();
      for (var rowIndex = 0; rowIndex < size; rowIndex++) {
        var v = provider.getValue(columnKey, rowIndex);
        if (!seen.has(v)) {
          seen.set(v, true);
          dataObjList.push(v);
        }
      }
    } else if (formula.indexOf("yes-kv-data:") > -1) {
      var regex = /k-column=(.*?),v-column=(.*?)$/;
      var matches = formula.match(regex);
      var k_column_key = matches[1];
      var v_column_key = matches[2];
      var map = /* @__PURE__ */ new Map();
      var size = provider.getSize();
      for (var row = 0; row < size; row++) {
        var v = provider.getValue(v_column_key, row);
        if (!k_column_key || k_column_key == "") {
          dataObjList.push({ value: v });
          return dataObjList;
        } else if (!provider.contain(k_column_key)) {
          dataObjList.push({ name: k_column_key, value: v });
          return dataObjList;
        }
        var k = provider.getValue(k_column_key, row);
        if (map.get(k) == null) {
          map.set(k, v);
          dataObjList.push({ name: k, value: v });
        }
      }
    } else if (formula.indexOf("yes-function:") > -1) {
      var fnStr = formula.split(":")[1];
      var df = eval("(" + fnStr + ")");
      return df;
    }
    return dataObjList;
  }
  getRowValByFormula(formula2, row2, provider2) {
    var value = formula2;
    if (this.isYesFormula(formula2)) {
      if (formula2.indexOf("yes-data:column") > -1) {
        var data_column_key = formula2.split("=")[1];
        value = provider2.getValue(data_column_key, row2);
      } else if (formula2.indexOf("yes-value:column") > -1) {
        value = provider2.getValue(formula2.split("=")[1], row2);
      } else if (formula2.indexOf("yes-kv-data:") > -1) {
        var arr = formula2.split("=");
        var k_column_key2 = arr[0];
        var v_column_key2 = arr[1];
        var k2 = provider2.getValue(k_column_key2, row2);
        var v2 = provider2.getValue(v_column_key2, row2);
        value = { name: k2, value: v2 };
      }
    }
    return value;
  }
  yesSeries(seriesList, provider2) {
    var series = [];
    var size2 = provider2.getSize();
    var _this = this;
    seriesList.forEach(function(s) {
      var yes_group_by = s["yes-group-by"];
      var name_formula = s["name"];
      var data_formula = s["data"];
      if (_this.isYesFormula(data_formula)) {
        if (size2 > 0) {
          if (yes_group_by) {
            var groupCols = yes_group_by.split("=")[1].split(",");
            var dataMap = /* @__PURE__ */ new Map();
            var dataObjList2 = [];
            for (var row2 = 0; row2 < size2; row2++) {
              var gk = "";
              var groupValList = [];
              groupCols.forEach(function(columnKey2) {
                groupValList.push(provider2.getValue(columnKey2, row2));
              });
              gk = groupValList.join(",");
              var groupDataObj = dataMap.get(gk);
              if (groupDataObj == null) {
                groupDataObj = {};
                groupDataObj.name = _this.getRowValByFormula(name_formula, row2, provider2);
                groupDataObj.data = [];
                dataMap.set(gk, groupDataObj);
                dataObjList2.push(groupDataObj);
              }
              groupDataObj.data.push(_this.getRowValByFormula(data_formula, row2, provider2));
            }
            dataObjList2.forEach(function(item) {
              var curSeries2 = JSON.parse(JSON.stringify(s));
              curSeries2["name"] = item.name;
              curSeries2["data"] = item.data;
              delete curSeries2["yes-group-by"];
              series.push(curSeries2);
            });
          } else {
            var curSeries = JSON.parse(JSON.stringify(s));
            curSeries["name"] = _this.getRowValByFormula(name_formula, 0, provider2);
            curSeries["data"] = _this.getYesObjByFormula(data_formula, provider2);
            series.push(curSeries);
          }
        }
      } else if (Array.isArray(data_formula)) {
        _this.loopOption(data_formula, provider2);
        series.push(s);
      } else {
        series.push(s);
      }
    });
    return series;
  }
  loopOption(obj, provider2) {
    var _this = this;
    for (var key2 in obj) {
      if (key2 == "series") {
        obj[key2] = _this.yesSeries(obj[key2], provider2);
      } else if (typeof obj[key2] === "string") {
        obj[key2] = _this.getYesObjByFormula(obj[key2], provider2);
      } else if (typeof obj[key2] === "object") {
        _this.loopOption(obj[key2], provider2);
      }
    }
  }
  render(option2, yesChartDataProvider) {
    this.loopOption(option2, yesChartDataProvider);
    return option2;
  }
}
class YesChartYIGODataProvider {
  constructor(table) {
    this.yTable = table;
  }
  getValue(columnKey2, rowIndex2) {
    this.yTable.setPos(rowIndex2);
    var value = this.yTable.getByKey(columnKey2);
    return TypeConvertor.toString(value);
  }
  getSize() {
    return this.yTable.size();
  }
  contain(columnKey2) {
    if (this.yTable.getColByKey(columnKey2)) {
      return true;
    }
    return false;
  }
}
const Yes_Chart_Core = {
  test(name) {
    return name;
  },
  buildYesChart() {
    return new YesChart();
  },
  buildYesDataProvider(data2) {
    return new YesChartYIGODataProvider(data2);
  }
};
class VYesTemplate extends VEchartsBase {
  constructor(options) {
    super(options);
  }
  getYesChartOption(chartTemplate, table) {
    if (Yes_Chart_Core) {
      var yesDataProvider = Yes_Chart_Core.buildYesDataProvider(table);
      var yesChart = Yes_Chart_Core.buildYesChart();
      var yesOption = yesChart.render(JSON.parse(chartTemplate.option), yesDataProvider);
      return yesOption;
    }
    return null;
  }
}
const chartTypeNames = new HashMap();
chartTypeNames.put(ChartType.HBAR, VYesBar);
chartTypeNames.put(ChartType.VBAR, VYesBar);
chartTypeNames.put(ChartType.STACKEDHBAR, VYesBar);
chartTypeNames.put(ChartType.STACKEDVBAR, VYesBar);
chartTypeNames.put(ChartType.AREA, VYesArea);
chartTypeNames.put(ChartType.LINE, VYesLine);
chartTypeNames.put(ChartType.PIE, VYesPie);
chartTypeNames.put(ChartType.SCATTER, VYesScatter);
chartTypeNames.put(ChartType.RADAR, VYesRadar);
chartTypeNames.put(ChartType.GAUGE, VYesGauge);
class YesVChart extends YesVBaseComponent {
  constructor(options) {
    super(options);
    var owner = this.owner;
    this.owner.getDataModel = function() {
      return owner.dataModel;
    };
  }
  render(ct) {
    super.render(ct);
    var type = this.owner.chartType;
    var name = chartTypeNames.get(type);
    if (this.owner.chartTemplate) {
      name = VYesTemplate;
    }
    if (name) {
      this.chart = new name(this.owner);
      this.chart.render(ct);
    } else {
      console.error("chart type : " + name + " not impl.");
    }
  }
  draw() {
    this.chart && this.chart.draw();
  }
  getCompData(name) {
    return this.chart && this.chart.getCompData(name);
  }
}
class YesChartBuilder extends YesComponentBuilder {
  static create(options) {
    return new YesVChart(options);
  }
}
class YesVLabel extends YesVBaseButton {
  constructor(options) {
    super(options);
    this.icon = options.icon;
  }
  createHtml() {
    this.el.$addClass("ui-control").$addClass("ui-lbl");
    if (this.buddyKey) {
      this.el.$addClass("ui-innerlbl");
    }
    this.$label = YElement.buildFromVNode(h$1("label")).$appendTo(this.el);
    this.setShowText(this.owner.caption);
    switch (this.owner.lineBreakType) {
      case 2:
        this.el.$addClass("tail");
        break;
      case 4:
        this.el.$empty();
        this.el.$addClass("marquee");
        this.$label = YElement.buildFromVNode(h$1("marquee")).$appendTo(this.el);
        this.$label.$setAttr("scrollamount", 3);
        break;
    }
  }
  initCss(options) {
    if (!options || !this.el) {
      return;
    }
    const outerCss = this.getOuterCss(options, false);
    this.el.$appendStyles(outerCss);
    const inputCss = this.getInputCss(options);
    this.el.$appendStyles(inputCss);
    const lblCss = this.getLabelCss(options);
    this.$label.$appendStyles(lblCss);
    this.el.$appendStyles(lblCss);
    this.setFormatStyle(options);
    this.el.$appendStyles(this.txtCss || /* @__PURE__ */ new Map());
    if (this.owner.singleLine == false) {
      this.el.$addClass("lines");
    }
    var format = options.format;
    if (format) {
      this.setAlignCssName(format);
    }
  }
  render(ct) {
    super.render(ct);
    this.setIcon(this.icon);
  }
  setWidth(width) {
    super.setWidth(width);
  }
  setHeight(height) {
    super.setHeight(height);
  }
  setIcon(icon) {
    if (icon) {
      if (!this.$icon) {
        this.$icon = YElement.buildFromVNode(h$1("span.icon")).$prependTo(this.el);
      }
      var self2 = this;
      this.getImageBase64URL(icon, null, null).then(function(url) {
        if (void 0 == self2.iconCss) {
          self2.iconCss = /* @__PURE__ */ new Map();
        }
        self2.iconCss.set("background-image", "url(" + url + ")");
        self2.$icon.$appendStyles(self2.iconCss);
        self2.$icon.$removeClass("fail");
      }).catch(function() {
        self2.$icon.$addClass("fail");
      });
    } else {
      this.$icon && this.$icon.$addStyle("background-image", "none");
    }
  }
  setValue(value) {
    super.setValue(value);
    this.setShowText(value != null ? value.toString() : "");
  }
  setShowText(caption) {
    var captionArray = caption ? caption.split("\\n") : [];
    if (captionArray.length > 1) {
      this.$label.$setInnerText("");
      for (let index2 = 0; index2 < captionArray.length; index2++) {
        var textEl = YElement.buildFromVNode(h$1("span")).$appendTo(this.$label);
        textEl.$setInnerText(captionArray[index2]);
        if (index2 != captionArray.length - 1)
          this.$label.$append(YElement.buildFromVNode(h$1("br")));
      }
    } else {
      this.$label.$setInnerText(caption);
    }
  }
}
class YesLabelBuilder extends YesComponentBuilder {
  static create(options) {
    return new YesVLabel(options);
  }
}
var __defProp$C = Object.defineProperty;
var __getOwnPropDesc$C = Object.getOwnPropertyDescriptor;
var __decorateClass$C = (decorators, target, key2, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$C(target, key2) : target;
  for (var i = decorators.length - 1, decorator; i >= 0; i--)
    if (decorator = decorators[i])
      result = (kind ? decorator(target, key2, result) : decorator(result)) || result;
  if (kind && result)
    __defProp$C(target, key2, result);
  return result;
};
class YesVCheckBox extends YesVBaseComponent {
  constructor(options) {
    super(options);
    this.hideButton = options.hideButton;
  }
  createHtml() {
    this.el.$addClass("ui-chk").$addClass("ui-control");
    this.$span = YElement.buildFromVNode(h$1("span.chk", { attrs: { "tabindex": 0 } })).$appendTo(this.el);
    this.$label = YElement.buildFromVNode(h$1("label")).$appendTo(this.el);
    this.setCaption(this.caption);
    if (this.hideButton) {
      this.$span.$hide();
      this.el.$addClass("chk-btn");
    }
    this.setCheckOnClickNode();
  }
  getInput() {
  }
  getClearBtn() {
  }
  initCss(options) {
    super.initCss(options);
    if (!options) {
      return;
    }
    var str = this.getOuterCss(options, false);
    str && this.el.$appendStyles(str);
    var inputCss = this.getInputCss(options);
    inputCss && this.el.$appendStyles(inputCss);
    var lblCss = this.getLabelCss(options);
    this.$label.$appendStyles(lblCss);
    this.setFormatStyle(options);
    this.iconCss && this.el.$appendStyles(this.iconCss);
    switch (this.owner.iconLocation) {
      case 0:
        this.el.$addClass("top");
        break;
      case 1:
        this.el.$addClass("bottom");
        break;
      case 3:
        this.el.$addClass("right");
        break;
    }
    var format = options.format;
    if (format) {
      this.setAlignCssName(format);
    }
  }
  focus() {
    this.$span.$focus();
  }
  async setIcon(icon, checked) {
    if (icon) {
      var self2 = this;
      this.$span.$removeClass("default").$addClass("icon");
      var iconContent = checked ? this.sIconContent : this.usIconContent;
      if (!iconContent) {
        var newIcon = await this.owner.getImageBase64URL(icon, false);
        checked ? this.sIconContent = newIcon : this.usIconContent = newIcon;
        iconContent = newIcon;
      }
      self2.$span.$addStyle("background-image", "url(" + iconContent + ")");
    } else {
      this.$span.$removeClass("icon").$addClass("default");
      this.$span.$addStyle("background-image", "");
    }
  }
  setValue(value, halfChecked) {
    this.el.$setAttr("ischecked", value + "");
    this.checked = value;
    this.$span.$removeClass("halfChecked checked");
    this.el.$removeClass("halfChecked checked");
    if (value) {
      this.$span.$addClass(halfChecked ? "halfChecked" : "checked");
      this.el.$addClass(halfChecked ? "halfChecked" : "checked");
      this.setIcon(this.owner.selectedIcon, true);
    } else {
      this.setIcon(this.owner.icon, false);
    }
  }
  setCaption(text = "") {
    if (text) {
      text = Utils.htmlEncode(text);
      var txt = text.replace(/ /g, "&nbsp;");
      this.$label.$setInnerText(txt);
    } else {
      this.$label.$addStyle("display", "none");
    }
  }
  setHeight(height) {
    super.setHeight(height);
  }
  setWidth(width) {
    super.setWidth(width);
  }
  // 处理点击的时候，是否点击在本控件上，是否执行父层事件
  setCheckOnClickNode() {
    this.el.$setAttr("checkOnClickNode", this.owner.checkOnClickNode);
  }
  async doOnClick(event2, item) {
    if (this.enable) {
      this.focusOwner();
      await this.commitValue(!this.checked, event2.shiftKey);
    }
  }
  install() {
    var self2 = this;
    self2.el.$click(debounce(async function(e) {
      self2.doOnClick(e, null);
    }));
    self2.el.$keydown(function(event2) {
      var keyCode = event2.keyCode || event2.charCode;
      switch (keyCode) {
        case 13:
        case 108:
          self2.commitValue(!self2.checked);
          event2.preventDefault();
          break;
        case 9:
          self2.requestNextFocus(keyCode);
          event2.preventDefault();
          break;
      }
    });
  }
}
__decorateClass$C([
  TraceUIOptEvent()
], YesVCheckBox.prototype, "doOnClick", 1);
class YesCheckBoxBuilder extends YesComponentBuilder {
  static create(options) {
    return new YesVCheckBox(options);
  }
}
var __defProp$B = Object.defineProperty;
var __getOwnPropDesc$B = Object.getOwnPropertyDescriptor;
var __decorateClass$B = (decorators, target, key2, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$B(target, key2) : target;
  for (var i = decorators.length - 1, decorator; i >= 0; i--)
    if (decorator = decorators[i])
      result = (kind ? decorator(target, key2, result) : decorator(result)) || result;
  if (kind && result)
    __defProp$B(target, key2, result);
  return result;
};
var itemClick$1 = async (e, self2) => {
  var _a;
  var items = self2.items;
  var btnKey = (_a = getClosestEle(e.target, (el) => el.tagName == "LI")) == null ? void 0 : _a.getAttribute("key");
  var item = {};
  if (btnKey) {
    for (var i = 0, len = items.length; i < len; i++) {
      if (items[i].key == btnKey) {
        items[i].formula;
        item = items[i];
        break;
      }
    }
  }
  self2.hideDropdownList();
  await self2.doOnClick(e, { caption: item.text, ...item });
};
class YesVSplitButton extends YesVBaseButton {
  constructor(options) {
    super(options);
    this.icon = options.icon;
    this.items = options.items;
    this.onClick = options.onClick;
    this.iconCss = /* @__PURE__ */ new Map();
    this.mdHandler = this.mdHandler.bind(this);
  }
  createHtml() {
    this.el.$addClass("ui-control").$addClass("ui-splbtn").$addClass("btn-group");
    this.buttonLeft = YElement.buildFromVNode(h$1("button.btn")).$addClass("btn-left").$appendTo(this.el);
    this.$label = YElement.buildFromVNode(h$1("label")).$appendTo(this.buttonLeft);
    this.buttonRight = YElement.buildFromVNode(
      h$1("button", { class: { btn: true, "dp-tgl": true }, dataSet: { toggle: "dropdown" } })
    ).$appendTo(this.el);
    this.$arrow = YElement.buildFromVNode(h$1("span.arrow")).$appendTo(this.buttonRight);
    this._dropView = YElement.buildFromVNode(h$1("div.sp-vw"));
    this._dropView.$setAttr("id", this.owner.getId() + "_dropdown");
    var items = this.items, caption = this.caption;
    YElement.buildFromVNode(h$1("text")).$setInnerText((this.$label.getInnerText() || "") + caption).$appendTo(this.$label);
    if (items.length > 0) {
      var rawDropview = document.createElement("div");
      document.body.appendChild(rawDropview);
      this._dropView.$setRawDomElm(rawDropview);
      var uls = YElement.buildFromVNode(h$1("ul")).$appendTo(this._dropView);
      var self2 = this;
      for (var i = 0; i < items.length; i++) {
        var item = this.items[i];
        var li = YElement.buildFromVNode(h$1("li")).$appendTo(uls);
        li.$click(debounce(async function(e) {
          await itemClick$1(e, self2);
        }));
        if (i > 5) {
          uls.$addStyle("height", "180px");
        }
        if (item.separator) {
          li.$setAttr("role", "separator").$addClass("sep");
        } else {
          YElement.buildFromVNode(h$1("a", null, item.text)).$appendTo(li);
          li.$setAttr("key", item.key);
        }
      }
    }
  }
  initCss(options) {
    if (!options) {
      return;
    }
    var str = this.getOuterCss(options, false);
    var inputCss = this.getInputCss(options);
    var lblCss = this.getLabelCss(options);
    this.el.$appendStyles(str);
    this.buttonLeft.$appendStyles(inputCss).$appendStyles(lblCss);
    this.buttonRight.$appendStyles(inputCss);
    this.setFormatStyle(options);
    if (void 0 == this.txtCss) {
      this.txtCss = /* @__PURE__ */ new Map();
    }
    this.$label.$appendStyles(this.txtCss);
    this.$label.$appendStyles(lblCss);
  }
  afterRender() {
    super.afterRender();
    this.icon && this.setIcon(this.icon);
  }
  setIcon(icon) {
    if (icon) {
      if (!this.$icon) {
        this.$icon = YElement.buildFromVNode(h$1("span.icon"));
        this.$icon.$prependTo(this.$label);
      }
      var self2 = this;
      this.getImageBase64URL(icon, null, null).then(function(url) {
        if (void 0 == self2.iconCss) {
          self2.iconCss = /* @__PURE__ */ new Map();
        }
        self2.iconCss.set("background-image", "url(" + url + ")");
        self2.$icon.$appendStyles(self2.iconCss);
      });
    } else {
      this.$icon && this.$icon.$addStyle("background-image", "none");
    }
  }
  setWidth(width) {
    var w = width == "auto" ? "" : width;
    this.el.$addStyle("width", w);
  }
  setHeight(height) {
    this.el.addPostpatchHook(() => {
      var h2 = height == "auto" ? "" : height;
      this.el.$addStyle("height", h2);
      this.buttonRight.$addStyle("height", h2);
      var labelH = this.$label.getHeight();
      var icon = this.$icon;
      if (icon) {
        icon.$setWidth(labelH).$setHeight(labelH);
      }
      var style = CssUtil.getStyle(this.owner.meta, this.owner);
      if (style.format) {
        var vAlign = style.format.vAlign;
        switch (vAlign) {
          case 0:
            this.buttonLeft.$addStyle("align-items", "flex-start");
            break;
          case 2:
            this.buttonLeft.$addStyle("align-items", "flex-end");
            break;
        }
      }
    });
  }
  getDropView() {
    return this._dropView;
  }
  hideDropdownList() {
    this._dropView.$hide();
    this._hasShow = false;
    this.el.$removeClass("focus");
  }
  setBackColor(backColor) {
    this.el.$addStyle("background-color", "rgba(0, 0, 0, 0)");
    this.buttonLeft.$addStyle("background-color", backColor);
    this.buttonRight.$addStyle("background-color", backColor);
  }
  setForeColor(foreColor) {
    this.buttonLeft.$findByTagName("label")[0].$addStyle("color", foreColor);
  }
  beforeDestroy() {
    this._dropView && this._dropView.$remove();
    this._removeMousedownListener();
  }
  async doOnClick(event2, item) {
    var self2 = this;
    self2.setClicking(self2.$arrow);
    var fn = this.owner.doOnClick;
    if (typeof fn === "function") {
      return fn.apply(self2.owner, arguments).finally(() => {
        self2.removeClicking(self2.$arrow);
      });
    }
  }
  mdHandler(e) {
    var _a, _b, _c;
    var self2 = this;
    try {
      var target = e.target;
      if (!((_a = self2._dropView.getElm()) == null ? void 0 : _a.contains(target)) && !((_b = self2.buttonLeft.getElm()) == null ? void 0 : _b.contains(target)) && !((_c = self2.buttonRight.getElm()) == null ? void 0 : _c.contains(target))) {
        if (self2._hasShow) {
          self2.doOnDocumentClick(e, null);
          self2.hideDropdownList();
        }
        self2._removeMousedownListener();
      }
    } catch (error) {
      self2._removeMousedownListener();
      throw error;
    }
  }
  _addMouseDownListener() {
    document.addEventListener("mousedown", this.mdHandler);
  }
  _removeMousedownListener() {
    document.removeEventListener("mousedown", this.mdHandler);
  }
  async doOnDocumentClick(event2, item) {
  }
  async doOnDropBtnClick(event2, item) {
    var _a, _b, _c, _d, _e;
    var self2 = this;
    if (!self2.enable) {
      return;
    }
    self2.el.$addClass("focus");
    self2.setClicking(self2.$arrow);
    if (self2._hasShow) {
      self2.hideDropdownList();
      self2._hasShow = false;
      self2.removeClicking(self2.$arrow);
      return;
    }
    self2._addMouseDownListener();
    if (!self2._dropView) {
      self2.removeClicking(self2.$arrow);
      return;
    }
    if (self2._dropView.getElm()) {
      self2._dropView.$addStyle("zIndex", self2.owner.getZIndex("control"));
      PositionUtil.setViewPos(
        self2.el.getElm(),
        self2._dropView.getElm(),
        false
      );
      self2._dropView.$slideInit();
      self2._dropView.$slideDown();
      if (((_a = self2._dropView.getElm()) == null ? void 0 : _a["scrollWidth"]) > ((_c = (_b = self2._dropView) == null ? void 0 : _b.getElm()) == null ? void 0 : _c["clientWidth"])) {
        self2._dropView.$findByTagName("ul")[0].$setWidth((_e = (_d = self2._dropView) == null ? void 0 : _d.getElm()) == null ? void 0 : _e["scrollWidth"]);
      }
    }
    self2._hasShow = true;
    self2.removeClicking(self2.$arrow);
    event2.stopPropagation();
  }
  install() {
    var self2 = this;
    self2.buttonRight.$click(function(event2) {
      self2.doOnDropBtnClick(event2, null);
    });
    self2.el.$keydown(function(event2) {
      var keyCode = event2.keyCode || event2.charCode;
      if (keyCode === 9 || keyCode === 13 || keyCode === 108) {
        self2.el.$setAttr("tabIndex", false);
        self2.el.$blur();
        self2.requestNextFocus(keyCode);
        event2.preventDefault();
      }
    });
    self2.buttonLeft.$click(debounce(async function(e) {
      if (!self2.enable) {
        return;
      }
      self2._dropView && self2._dropView.$hide();
      await self2.doOnClick(e, { formula: self2.onClick });
    }));
  }
}
__decorateClass$B([
  TraceUIOptEvent()
], YesVSplitButton.prototype, "doOnClick", 1);
__decorateClass$B([
  TraceUIOptEvent()
], YesVSplitButton.prototype, "doOnDocumentClick", 1);
__decorateClass$B([
  TraceUIOptEvent()
], YesVSplitButton.prototype, "doOnDropBtnClick", 1);
class YesSplitButtonBuilder extends YesComponentBuilder {
  static create(options) {
    return new YesVSplitButton(options);
  }
}
var __defProp$A = Object.defineProperty;
var __getOwnPropDesc$A = Object.getOwnPropertyDescriptor;
var __decorateClass$A = (decorators, target, key2, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$A(target, key2) : target;
  for (var i = decorators.length - 1, decorator; i >= 0; i--)
    if (decorator = decorators[i])
      result = (kind ? decorator(target, key2, result) : decorator(result)) || result;
  if (kind && result)
    __defProp$A(target, key2, result);
  return result;
};
class YesVBaseText extends YesVBaseComponent {
  constructor(options) {
    super(options);
    this.promptType = options.promptType;
    this.promptText = options.promptText;
  }
  beforeRender(ct) {
    super.beforeRender(ct);
    this.initCompStyle(this.owner.meta);
  }
  afterRender() {
    super.afterRender();
    this.showCompStyle();
    this.resetPromptText();
  }
  showCompStyle() {
    var meta = this.owner.meta;
    if (!meta.compStyle)
      return;
    if (CompSetting.PromptText == "showCaption") {
      this.setPromptType(PromptType.SHOWCAPTION);
    }
  }
  setPromptType(value) {
    this.promptType = value;
  }
  resetPromptText() {
    if (this.promptType == PromptType.SHOWCAPTION) {
      this.promptText = this.caption;
    }
    if (this.promptText) {
      this.el.$addClass("prompt-text");
      this.setPromptText(this.promptText);
    }
  }
  initCompStyle(meta) {
    switch (meta.type) {
      case ControlType.TEXTEDITOR:
      case ControlType.TEXTAREA:
      case ControlType.TEXTBUTTON:
      case ControlType.NUMBEREDITOR:
      case ControlType.PASSWORDEDITOR:
      case ControlType.COMBOBOX:
      case ControlType.CHECKLISTBOX:
      case ControlType.DICT:
      case ControlType.DYNAMICDICT:
      case ControlType.COMPDICT:
      case ControlType.DATEPICKER:
      case ControlType.DATERANGEPICKER:
      case ControlType.UTCDATEPICKER:
      case ControlType.TIMEZONEDATEPICKER:
      case ControlType.MONTHPICKER:
      case ControlType.TIMEPICKER:
        var compStyle = meta.compStyle || CompSetting.CompStyle;
        if (compStyle && !meta.buddyKey) {
          this.cssClass += " " + compStyle;
        }
    }
  }
  getInputLbl(options) {
    var lblCss = /* @__PURE__ */ new Map();
    options.foreColor && lblCss.set("color", options.foreColor);
    options.backColor && lblCss.set("background-color", options.backColor);
    return lblCss;
  }
  __setEnable(ele, enable) {
    var inputEl = this.getInput();
    if (enable) {
      if (inputEl) {
        inputEl.$setAttr("readonly", null);
        inputEl.$setAttr("unselectable", "off");
      } else {
        ele.$setAttr("readonly", null);
      }
      ele.$removeClass("ui-readonly");
    } else {
      if (inputEl) {
        inputEl.$setAttr("readonly", true);
        inputEl.$setAttr("unselectable", "on");
      } else {
        ele.$setAttr("readonly", true);
      }
      ele.$addClass("ui-readonly");
    }
    if (CompSetting.DisableClick) {
      ele.$addClass("disable-click");
    }
  }
  toolTipHide() {
    ToolTipUtil.hide();
  }
  disableClickEvent() {
    var dropView = this.getDropView();
    var className = "pointer-vw";
    if (!dropView)
      return;
    if (dropView.__IsVirtual) {
      if (CompSetting.DisableClick) {
        dropView.$addClass(className);
      }
      if (this.enable) {
        dropView.$removeClass(className);
      }
    } else {
      if (CompSetting.DisableClick) {
        dropView.classList.add(className);
      }
      if (this.enable) {
        dropView.classList.remove(className);
      }
    }
  }
  install() {
    var _a;
    var self2 = this;
    var btn = self2.getClearBtn();
    self2.el.$addListener("mouseenter", function(e) {
      var _a2;
      self2.el.getElm().mouseleave = false;
      if (!self2.el.hasClass("focus") && !self2.el.hasClass("line_focus")) {
        var errorNode = self2.el.$findByClassName("error-icon")[0];
        var requiredNode = self2.el.$findByClassName("required-icon")[0];
        var className = "error";
        if (requiredNode)
          className = "required";
        var node = errorNode || requiredNode;
        if (node) {
          var msg = node.getAttr("title");
          var zIndex = self2.owner.getZIndex("tip");
          msg && ToolTipUtil.show(self2.el.getElm(), zIndex, msg, className);
        }
      }
      if (self2.enable && ((_a2 = self2.getInput()) == null ? void 0 : _a2.getInputValue())) {
        btn == null ? void 0 : btn.$addClass("show");
      }
    }).$addListener("mouseleave", function(e) {
      self2.el.getElm().mouseleave = true;
      ToolTipUtil.hide();
      btn == null ? void 0 : btn.$removeClass("show");
    });
    (_a = self2.getInput()) == null ? void 0 : _a.$addListener("focusin", function() {
      if (!self2.enable)
        return;
      ToolTipUtil.hide();
    });
    if (btn) {
      btn.$mousedown(function() {
        var _a2;
        (_a2 = self2.getInput()) == null ? void 0 : _a2.$setInputValue("");
        self2.processing = true;
      }).$mouseup(function(e) {
        self2.doOnClearBtnClick(e, null);
      });
    }
  }
  doOnClearBtnClick(event2, item) {
    var _a;
    var btn = this.getClearBtn();
    (_a = this.getInput()) == null ? void 0 : _a.$focus();
    this.processing = false;
    btn && btn.$removeClass("show");
  }
  doFocusOut() {
    var fn = this.owner.doFocusOut;
    if (typeof fn === "function") {
      return fn.apply(this.owner, arguments);
    }
  }
  doOnKeyInput(options) {
    var _a;
    let curText = this.getInput() ? (_a = this.getInput().getElm()) == null ? void 0 : _a.value : "";
    this.owner.getForm().getUIOptTracer().traceOnKeyInput(this.owner, curText, options);
  }
  getImageBase64URL(icon, thumbnail, sourceType) {
    var fn = this.owner.getImageBase64URL;
    if (typeof fn === "function") {
      return fn.apply(this.owner, arguments);
    }
  }
  setIsEmpty(value) {
    if (value) {
      this.el.$setAttr("isempty", "false");
    } else {
      this.el.$setAttr("isempty", "true");
    }
  }
  getWrapNode() {
    return this.el.$findByClassName("wrap")[0];
  }
  createLeftElement() {
  }
  createCenterElement() {
  }
  createRightElement() {
  }
  getInput() {
    return null;
  }
  getClearBtn() {
    return null;
  }
  setPromptText(promptText) {
  }
  getDropView() {
    return null;
  }
}
__decorateClass$A([
  TraceUIOptEvent()
], YesVBaseText.prototype, "doOnClearBtnClick", 1);
class _SyncEvent {
  constructor(fn) {
    this.running = false;
    this.fn = fn;
  }
  doAction() {
    var self2 = this;
    return async function() {
      await DomEventQueue.lock();
      try {
        return await self2.fn.apply(this, arguments);
      } finally {
        DomEventQueue.unlock();
      }
    };
  }
}
const syncevent = function(fn) {
  return new _SyncEvent(fn).doAction();
};
var __defProp$z = Object.defineProperty;
var __getOwnPropDesc$z = Object.getOwnPropertyDescriptor;
var __decorateClass$z = (decorators, target, key2, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$z(target, key2) : target;
  for (var i = decorators.length - 1, decorator; i >= 0; i--)
    if (decorator = decorators[i])
      result = (kind ? decorator(target, key2, result) : decorator(result)) || result;
  if (kind && result)
    __defProp$z(target, key2, result);
  return result;
};
class YesVTextEditor extends YesVBaseText {
  constructor(options) {
    super(options);
    this.maxLength = options.maxLength;
    this.caseType = options.caseType;
    this.trim = options.trim;
    this.icon = options.icon;
    this.preIcon = options.preIcon;
    this.embedText = options.embedText;
    this.selectOnFocus = options.selectOnFocus;
    this.invalidChars = options.invalidChars;
    this.keyEnter = options.keyEnter;
    this.holdFocus = options.holdFocus;
    this.prefix = options.prefix;
    this.suffix = options.suffix;
  }
  createLeftElement() {
    var wrap = YElement.buildFromVNode(h$1("div.left-wrap")).$appendTo(this.el);
    if (this.prefix) {
      this.$prefix = YElement.buildFromVNode(h$1("div.prefix"));
      this.$prefix.$setInnerText(this.prefix);
      this.$prefix.$appendTo(wrap);
    }
    this.$preIcon = YElement.buildFromVNode(h$1("span.pre-icon"));
    this.preIcon && this.$preIcon.$appendTo(wrap);
    this.$embed = YElement.buildFromVNode(h$1("span.embed"));
    this.embedText && this.$embed.$appendTo(wrap);
  }
  createCenterElement() {
    this.$input = YElement.buildFromVNode(h$1("input", { props: { type: "text" } })).$appendTo(this.el);
  }
  createRightElement() {
    this.$wrap = YElement.buildFromVNode(h$1("div.wrap")).$appendTo(this.el);
    this.$clearBtn = YElement.buildFromVNode(h$1("span.clear")).$appendTo(this.$wrap);
    if (this.suffix) {
      this.$suffix = YElement.buildFromVNode(h$1("div.suffix"));
      this.$suffix.$setInnerText(this.suffix);
      this.$suffix.$appendTo(this.$wrap);
    }
    this.$icon = YElement.buildFromVNode(h$1("span.icon"));
    this.icon && this.$icon.$appendTo(this.$wrap);
  }
  createHtml() {
    this.el.$addClass("ui-control").$addClass("ui-txted");
    this.createLeftElement();
    this.createCenterElement();
    this.createRightElement();
    if (this.prefix || this.suffix) {
      this.el.$addClass("char");
    }
    if (parseInt(this.maxLength) > 0) {
      this.$input.$setAttr("maxlength", this.maxLength);
    }
    var textCase = this.caseType;
    if (textCase != CaseType.NONE) {
      if (textCase == CaseType.UPPER) {
        this.$input.$addClass("uppercase");
      } else {
        this.$input.$addClass("lowercase");
      }
    }
  }
  initCss(options) {
    if (!options || !this.el) {
      return;
    }
    var outerCss = this.getOuterCss(options, false);
    var inputCss = this.getInputCss(options);
    var lblCss = this.getLabelCss(options);
    var inputLblCss = this.getInputLbl(options);
    this.el.$appendStyles(outerCss).$appendStyles(inputCss);
    this.$input.$appendStyles(lblCss).$appendStyles(inputLblCss);
    this.setFormatStyle(options);
    this.$input.$appendStyles(this.txtCss || /* @__PURE__ */ new Map());
  }
  afterRender() {
    super.afterRender();
    this.icon && this.setIcon(this.icon);
    this.preIcon && this.setPreIcon(this.preIcon);
    this.promptText && this.setPromptText(this.promptText);
    this.embedText && this.setEmbedText(this.embedText);
  }
  getInput() {
    return this.$input;
  }
  focus() {
    this.$input.$focus();
  }
  setShowText(text) {
    let renderContext = this.owner.getForm().getRenderContext();
    let printText = this.el.$findByClassName(`ui-print-text`);
    if (renderContext.isPrinting() && printText.length > 0) {
      printText[0].$setInnerText(text + ` `);
    } else {
      this.$input.$setInputValue(text);
      this.$input.getElm() && (this.$input.getElm().value = text);
      this.setIsEmpty(text);
    }
  }
  getShowText() {
    return this.$input.getInputValue();
  }
  //TODO icon 不需要 缓存， 模型该处理this.icon， 多次seticon 有问题
  setIcon(icon) {
    if (icon) {
      if (!this.$icon) {
        this.el.$addClass("icon");
      }
      var self2 = this;
      this.getImageBase64URL(icon, null, null).then(function(url) {
        self2.$icon.$addStyle("background-image", "url(" + url + ")");
      });
    } else {
      this.$icon && this.$icon.$addStyle("background-image", "none");
    }
  }
  //TODO 同icon
  setPreIcon(preIcon) {
    if (preIcon) {
      if (!this.$preIcon) {
        this.el.$addClass("preicon");
      }
      var self2 = this;
      this.getImageBase64URL(preIcon, null, null).then(function(url) {
        self2.$preIcon.$addStyle("background-image", "url(" + url + ")");
      });
    } else {
      this.$preIcon && this.$preIcon.$addStyle("background-image", "none");
    }
  }
  setBackColor(backColor) {
    this.$input.$appendStyles(new Map(Object.entries({
      "background-image": "none",
      "background-color": backColor
    })));
    this.el.$appendStyles(new Map(Object.entries({
      "background-image": "none",
      "background-color": backColor
    })));
  }
  setForeColor(foreColor) {
    this.$input.$addStyle("color", foreColor);
  }
  setEmbedText(embedText) {
    if (embedText) {
      this.$embed.$setInnerText(embedText);
      this.el.$addClass("embed");
      if (this.owner.embedTextSize) {
        this.$embed.$addStyle("fontSize", this.owner.embedTextSize + "px");
      }
      if (this.owner.embedTextColor) {
        this.$embed.$addStyle("color", this.owner.embedTextColor);
      }
    }
  }
  setPromptText(promptText) {
    this.$input.$setAttr("placeholder", promptText);
  }
  doEnterPress() {
    var fn = this.owner.doEnterPress;
    if (typeof fn === "function") {
      return fn.apply(this.owner, arguments);
    }
  }
  doFocusOut() {
    var fn = this.owner.doFocusOut;
    if (typeof fn === "function") {
      return fn.apply(this.owner, arguments);
    }
  }
  doOnFocus() {
    var fn = this.owner.doOnFocus;
    if (typeof fn === "function") {
      return fn.apply(this.owner, arguments);
    }
  }
  getClearBtn() {
    return this.$clearBtn;
  }
  async doOnInputClick(event2, item) {
  }
  async doOnInputFocusin(event2, item) {
    var _a;
    var self2 = this;
    if (!self2.enable)
      return false;
    if (self2.selectOnFocus && !self2.el.hasClass("focus")) {
      let doc = document;
      if ((_a = doc.selection) == null ? void 0 : _a.empty) {
        doc.selection.empty();
      } else if (window.getSelection) {
        var sel = window.getSelection();
        sel == null ? void 0 : sel.removeAllRanges();
      }
      const $target = event2 == null ? void 0 : event2.target;
      $target == null ? void 0 : $target.select();
    }
    self2.focusOwner();
    self2.el.$addClass("focus");
    self2.doOnFocus();
  }
  install() {
    super.install();
    var self2 = this;
    var input = this.$input;
    input.$addListener("click", function(event2) {
      self2.doOnInputClick(event2, null);
    }).$addListener("focusin", function(event2) {
      self2.doOnInputFocusin(event2, null);
    }).$addListener("keypress", function(event2) {
      if (!self2.enable)
        return;
      var code = event2.keyCode || event2.which;
      var c = String.fromCharCode(code), upper = CaseType.UPPER, lower = CaseType.LOWER;
      c = self2.caseType == upper ? c.toUpperCase() : self2.caseType == lower ? c.toLowerCase() : c;
      if (self2.invalidChars && self2.invalidChars.indexOf(c) != -1) {
        event2.preventDefault();
      }
    }).$addListener("keyup", function() {
      self2.doOnKeyInput({});
    }).$addListener("keydown", async (event2) => {
      if (!self2.enable)
        return;
      let keyCode = event2.keyCode || event2.charCode;
      switch (keyCode) {
        case 13:
        case 108:
          input.$setInputValue(event2.target.value);
          try {
            await self2.commitValue(input.getInputValue());
          } catch (error) {
            throw error;
          }
          if (self2.keyEnter) {
            let result = self2.doEnterPress();
            return result;
          }
          if (self2.holdFocus) {
            input.$focus();
          } else {
            self2.requestNextFocus(keyCode);
          }
          event2.preventDefault();
          break;
        case 9:
          self2.requestNextFocus(keyCode);
          event2.preventDefault();
          break;
      }
    }).$addListener("focus", function() {
    }).$addListener("focusout", syncevent(async function(event2) {
      var _a, _b;
      console.log("=======focusout=============key:" + self2.key + ";isDestroyed:" + self2.owner.isDestroyed);
      if (self2.processing || self2.isDestroyed()) {
        return false;
      }
      try {
        input.$setInputValue(event2.target.value);
        (_a = this.$clearBtn) == null ? void 0 : _a.$removeClass("show");
        try {
          await self2.commitValue(input.getInputValue());
        } catch (error) {
          console.log("===========error==============key:" + self2.key + ";isDestroyed:" + self2.owner.isDestroyed);
          throw error;
        }
        self2.doFocusOut();
      } finally {
        self2.el && self2.el.$removeClass("focus");
        input.$blur();
        (_b = input.getElm()) == null ? void 0 : _b.setSelectionRange(0, 0);
      }
    })).$addListener("paste", function() {
      setTimeout(function() {
        var v2 = self2.$input.getElm().value;
        v2 = TextFormat.format(v2, self2.owner);
        self2.$input.$setInputValue(v2);
      });
    });
  }
  installPrint() {
    this.el.$addClass(`ui-print`);
    let printText = YElement.buildFromVNode(h$1(`div`)).$addClass(`ui-print-text`).$insertBefore(this.$input);
    printText.$setInnerText(this.getShowText() + ` `);
    this.$input.$addStyle(`display`, `none`);
  }
}
__decorateClass$z([
  TraceUIOptEvent()
], YesVTextEditor.prototype, "doOnInputClick", 1);
class YesTextEditorBuilder extends YesComponentBuilder {
  static create(options) {
    return new YesVTextEditor(options);
  }
}
var reClsMap = {};
function getClsRE(cls) {
  if (!reClsMap[cls]) {
    reClsMap[cls] = new RegExp("(?:^|\\s)".concat(cls, "(?!\\S)"), "g");
  }
  return reClsMap[cls];
}
function isVisible(el) {
  var loopable = true, visible = getComputedStyle(el).display != "none" && getComputedStyle(el).visibility != "hidden";
  while (loopable && visible) {
    el = el.parentNode;
    if (el && el != document.body) {
      visible = getComputedStyle(el).display != "none" && getComputedStyle(el).visibility != "hidden";
    } else {
      loopable = false;
    }
  }
  return visible;
}
function getFitWidth(el) {
  var span = document.getElementById("__getWidth");
  if (span == null) {
    span = document.createElement("span");
    span.id = "__getWidth";
    document.body.appendChild(span);
    span.style.visibility = "hidden";
    span.style.whiteSpace = "pre";
  }
  var style = getComputedStyle(el);
  if (style.display == "none") {
    return 0;
  }
  var font = style.fontFamily;
  if (font) {
    span.style.fontFamily = font;
  }
  var fontSize = style.fontSize;
  if (fontSize) {
    span.style.fontSize = fontSize;
  }
  var fontWeight = style.fontWeight;
  if (fontSize) {
    span.style.fontWeight = fontWeight;
  }
  var paddingLeft = style.paddingLeft;
  if (paddingLeft) {
    span.style.paddingLeft = paddingLeft;
  }
  var paddingRight = style.paddingRight;
  if (paddingRight) {
    span.style.paddingRight = paddingRight;
  }
  span.innerText = el.innerText;
  return span.offsetWidth + 2;
}
function hasClass(elem, cls) {
  return elem && elem.className && elem.className.match && elem.className.match(getClsRE(cls));
}
function escape$1(caption) {
  return caption.replace(/\r\n/g, "").replace(/\n/g, "");
}
function getDomNode() {
  var documentElement = document.documentElement;
  var bodyElem = document.body;
  return {
    scrollTop: documentElement.scrollTop || bodyElem.scrollTop,
    scrollLeft: documentElement.scrollLeft || bodyElem.scrollLeft,
    visibleHeight: documentElement.clientHeight || bodyElem.clientHeight,
    visibleWidth: documentElement.clientWidth || bodyElem.clientWidth
  };
}
function getAbsolutePos(elem) {
  var bounding = elem.getBoundingClientRect();
  var boundingTop = bounding.top;
  var boundingLeft = bounding.left;
  var _a = getDomNode(), scrollTop = _a.scrollTop, scrollLeft = _a.scrollLeft, visibleHeight = _a.visibleHeight, visibleWidth = _a.visibleWidth;
  return { boundingTop, top: scrollTop + boundingTop, boundingLeft, left: scrollLeft + boundingLeft, visibleHeight, visibleWidth };
}
function moveStart(element) {
  var length = element.value.length;
  if (element.setSelectionRange) {
    element.setSelectionRange(length, length);
  } else if (element.createTextRange) {
    var range = element.createTextRange();
    range.moveStart("character", length);
    range.collapse(true);
    range.select();
  }
}
function select(element) {
  var length = element.value.length;
  if (element.setSelectionRange) {
    element.setSelectionRange(0, length);
  } else if (element.createTextRange) {
    var range = element.createTextRange();
    range.moveStart("character", 0);
    range.moveEnd("character", length);
    range.collapse(true);
    range.select();
  }
}
function adjustPositon(elem, evnt) {
  let { scrollTop, scrollLeft, visibleHeight, visibleWidth } = getDomNode();
  let top = evnt.clientY + scrollTop;
  let left = evnt.clientX + scrollLeft;
  let clientHeight = elem.clientHeight;
  let clientWidth = elem.clientWidth;
  let { boundingTop, boundingLeft } = getAbsolutePos(elem);
  let offsetTop = boundingTop + clientHeight - visibleHeight;
  let offsetLeft = boundingLeft + clientWidth - visibleWidth;
  if (offsetTop > -10) {
    elem.style.top = "".concat(Math.max(scrollTop, top - clientHeight), "px");
  }
  if (offsetLeft > -10) {
    elem.style.left = "".concat(Math.max(scrollLeft, left - clientWidth), "px");
  }
}
var __defProp$y = Object.defineProperty;
var __getOwnPropDesc$y = Object.getOwnPropertyDescriptor;
var __decorateClass$y = (decorators, target, key2, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$y(target, key2) : target;
  for (var i = decorators.length - 1, decorator; i >= 0; i--)
    if (decorator = decorators[i])
      result = (kind ? decorator(target, key2, result) : decorator(result)) || result;
  if (kind && result)
    __defProp$y(target, key2, result);
  return result;
};
function autoStrip(s, settings) {
  s = s || "";
  if (settings.aSign) {
    if (s.indexOf(settings.aSign) > -1) {
      if (settings.pSign == "s") {
        var first = settings.aSign.substr(0, 1);
        var reg2 = new RegExp("^[0-9]+.?[0-9]*");
        if (reg2.test(first)) {
          var reg = new RegExp("(.*)" + settings.aSign);
          s = s.replace(reg, "$1", "");
        } else {
          s = s.replace(settings.aSign, "");
        }
      } else {
        s = s.replace(settings.aSign, "");
      }
    }
  }
  s = s.replace(settings.skipFirstAutoStrip, "$1$2");
  s = s.replace(settings.skipLastAutoStrip, "$1");
  s = s.replace(settings.allowedAutoStrip, "");
  if (settings.altDec) {
    s = s.replace(settings.altDec, settings.aDec);
  }
  var m = s.match(settings.numRegAutoStrip);
  s = m ? [m[1], m[2], m[3]].join("") : "";
  return s;
}
function convertKeyToNumber(settings, key2) {
  if (typeof settings[key2] === "string") {
    settings[key2] *= 1;
  }
}
function autoCode(settings) {
  settings.oEvent = null;
  var vmax = settings.vMax.toString().split("."), vmin = !settings.vMin && settings.vMin !== 0 ? [] : settings.vMin.toString().split(".");
  convertKeyToNumber(settings, "vMax");
  convertKeyToNumber(settings, "vMin");
  convertKeyToNumber(settings, "mDec");
  settings.aNeg = settings.vMin < 0 ? "-" : "";
  vmax[0] = vmax[0].replace("-", "");
  vmin[0] = vmin[0].replace("-", "");
  settings.mInt = Math.max(vmax[0].length, vmin[0].length, 1);
  if (settings.mDec === null) {
    var vmaxLength = 0, vminLength = 0;
    if (vmax[1]) {
      vmaxLength = vmax[1].length;
    }
    if (vmin[1]) {
      vminLength = vmin[1].length;
    }
    settings.mDec = Math.max(vmaxLength, vminLength);
  }
  if (settings.altDec === null && settings.mDec > 0) {
    if (settings.aDec === "." && settings.aSep !== ",") {
      settings.altDec = ",";
    } else if (settings.aDec === "," && settings.aSep !== ".") {
      settings.altDec = ".";
    }
  }
  var aNegReg = settings.aNeg ? "([-\\" + settings.aNeg + "]?)" : "(-?)";
  settings.aNegRegAutoStrip = aNegReg;
  settings.skipFirstAutoStrip = new RegExp(aNegReg + "[^-" + (settings.aNeg ? "\\" + settings.aNeg : "") + "\\" + settings.aDec + "\\d].*?(\\d|\\" + settings.aDec + "\\d)");
  settings.skipLastAutoStrip = new RegExp("(\\d\\" + settings.aDec + "?)[^\\" + settings.aDec + "\\d]\\D*$");
  var allowed = "-" + settings.aNum + "\\" + settings.aDec;
  settings.allowedAutoStrip = new RegExp("[^" + allowed + "]", "gi");
  settings.numRegAutoStrip = new RegExp(aNegReg + "(?:\\" + settings.aDec + "?(\\d+\\" + settings.aDec + "\\d+)|(\\d*(?:\\" + settings.aDec + "\\d*)?))");
  return settings;
}
function presentNumber(s, aDec, aNeg) {
  if (aNeg && aNeg !== "-") {
    s = s.replace("-", aNeg);
  }
  if (aDec && aDec !== ".") {
    s = s.replace(".", aDec);
  }
  return s;
}
function autoCheck(s, settings) {
  s = autoStrip(s, settings);
  s = truncateDecimal(s, settings.aDec, settings.mDec);
  s = fixNumber(s, settings.aDec, settings.aNeg);
  var value = s;
  let d = new Decimal(value);
  return d.greaterThanOrEqualTo(settings.dMin) && d.lessThanOrEqualTo(settings.dMax);
}
function truncateDecimal(s, aDec, mDec) {
  if (aDec && mDec) {
    var parts = s.split(aDec);
    if (parts[1] && parts[1].length > mDec) {
      if (mDec > 0) {
        parts[1] = parts[1].substring(0, mDec);
        s = parts.join(aDec);
      } else {
        s = parts[0];
      }
    }
  }
  return s;
}
function fixNumber(s, aDec, aNeg) {
  if (aDec && aDec !== ".") {
    s = s.replace(aDec, ".");
  }
  if (aNeg && aNeg !== "-") {
    s = s.replace(aNeg, "-");
  }
  if (!s.match(/\d/)) {
    s += "0";
  }
  return s;
}
function stripTrailingZeros(iv, settings) {
  if (iv.length > 0 && settings.stripTrailingZeros) {
    if (iv.indexOf(".") > 0) {
      var as = iv.split("");
      while (as.length > 0) {
        var len = as.length - 1;
        if (as[len] == 0) {
          as.splice(len);
        } else if (as[len] == ".") {
          as.splice(len);
          break;
        } else {
          break;
        }
      }
      iv = as.join("");
    }
  }
  return iv;
}
function autoRound(iv, settings) {
  iv = iv === "" ? "0" : iv.toString();
  var ivRounded = "", i = 0, nSign = "";
  if (iv.charAt(0) === "-") {
    nSign = "-";
    iv = iv.replace("-", "");
  }
  if (!iv.match(/^\d/)) {
    iv = "0" + iv;
  }
  if (nSign === "-" && +iv === 0) {
    nSign = "";
  }
  var dPos = iv.lastIndexOf("."), vdPos = dPos === -1 ? iv.length - 1 : dPos, cDec = iv.length - 1 - vdPos;
  if (cDec <= settings.mDec) {
    ivRounded = iv;
    if (!settings.stripTrailingZeros) {
      if (dPos === -1) {
        ivRounded += ".";
      }
      var zeros = "0";
      while (cDec < settings.mDec) {
        ivRounded += zeros;
        cDec += zeros.length;
      }
    }
  } else {
    var rLength = dPos + settings.mDec, tRound = +iv.charAt(rLength + 1), ivArray = iv.substring(0, rLength + 1).split("");
    if (tRound > 4 && settings.mRound === RoundingMode.HALF_UP || tRound > 0 && settings.mRound === RoundingMode.ROUND_UP || nSign === "" && tRound > 0 && settings.mRound === RoundingMode.ROUND_CEILING || nSign === "-" && tRound > 0 && settings.mRound === RoundingMode.ROUND_FLOOR) {
      for (i = ivArray.length - 1; i >= 0; i -= 1) {
        if (ivArray[i] !== ".") {
          ivArray[i] = +ivArray[i] + 1;
          if (ivArray[i] < 10) {
            break;
          }
          if (i > 0) {
            ivArray[i] = "0";
          }
        }
      }
    }
    ivArray = ivArray.slice(0, rLength + 1);
    ivRounded = ivArray.join("");
  }
  return +ivRounded === 0 ? ivRounded : nSign + ivRounded;
}
function autoGroup(iv, settings, isNumber) {
  if (isNumber) {
    if (iv != settings.aSign) {
      iv = autoStrip(iv, settings);
    }
  } else {
    iv = autoStrip(iv, settings);
  }
  iv.replace(",", ".");
  var empty = checkEmpty(iv, settings);
  if (empty !== null) {
    return empty;
  }
  var ivSplit = iv.split(settings.aDec);
  if (settings.altDec && ivSplit.length === 1) {
    ivSplit = iv.split(settings.altDec);
  }
  var s = ivSplit[0];
  if (settings.aSep && settings.useSeparator) {
    var digitalGroup;
    if (settings.dGroup === 2) {
      digitalGroup = /(\d)((\d)(\d{2}?)+)$/;
    } else if (settings.dGroup === 4) {
      digitalGroup = /(\d)((\d{4}?)+)$/;
    } else {
      digitalGroup = /(\d)((\d{3}?)+)$/;
    }
    while (digitalGroup.test(s)) {
      s = s.replace(digitalGroup, "$1" + settings.aSep + "$2");
    }
  }
  if (settings.mDec !== 0 && ivSplit.length > 1) {
    iv = s;
    if (ivSplit[1].length > settings.mDec) {
      ivSplit[1] = ivSplit[1].substring(0, settings.mDec);
    }
    if (ivSplit.length > 1) {
      iv += settings.aDec + ivSplit[1];
    }
  } else {
    iv = s;
  }
  if (settings.aSign && (settings.pSign === "p" || settings.pSign === "s")) {
    var has_aNeg = iv.indexOf(settings.aNeg) !== -1;
    iv = iv.replace(settings.aNeg, "");
    if (has_aNeg) {
      iv = settings.aNeg + iv;
    }
    iv = settings.pSign === "p" ? settings.aSign + iv : iv + settings.aSign;
  }
  return iv;
}
function checkEmpty(iv, settings) {
  if (iv === "" || iv === settings.aNeg) {
    return iv;
  }
  return null;
}
function getElementSelection(that) {
  if (that.__IsVirtual) {
    that = that.getRawDomElm();
  }
  var position2 = {
    length: 0,
    end: 0,
    start: 0
  };
  if (that.selectionStart === void 0) {
    that.focus();
    let doc = document;
    var select2 = doc.selection.createRange();
    position2.length = select2.text.length;
    select2.moveStart("character", -that.value.length);
    position2.end = select2.text.length;
    position2.start = position2.end - position2.length;
  } else {
    position2.start = that.selectionStart;
    position2.end = that.selectionEnd;
    position2.length = position2.end - position2.start;
  }
  return position2;
}
function setElementSelection(that, start, end) {
  if (that.__IsVirtual) {
    that = that.getRawDomElm();
  }
  if (that.selectionStart === void 0) {
    that.focus();
    var r = that.createTextRange();
    r.collapse(true);
    r.moveEnd("character", end);
    r.moveStart("character", start);
    r.select();
  } else {
    that.selectionStart = start;
    that.selectionEnd = end;
  }
}
function NumberEditorHandler(that, settings) {
  this.settings = settings;
  this.that = that;
  this.formatted = false;
  this.settingsClone = autoCode(this.settings);
  this.value = that.getInputValue();
}
NumberEditorHandler.prototype = {
  init: function(e) {
    this.value = this.that.getInputValue() || "";
    this.settingsClone = autoCode(this.settings);
    this.ctrlKey = e.ctrlKey;
    this.cmdKey = e.metaKey;
    this.shiftKey = e.shiftKey;
    this.selection = getElementSelection(this.that);
    if (e.type === "keydown" || e.type === "keyup") {
      this.kdCode = e.keyCode;
    }
    this.which = e.which;
    this.processed = false;
    this.formatted = false;
  },
  setSelection: function(start, end, setReal) {
    start = Math.max(start, 0);
    var val = this.that.getInputValue() || "";
    end = Math.min(end, val.length);
    this.selection = {
      start,
      end,
      length: end - start
    };
    if (setReal === void 0 || setReal) {
      setElementSelection(this.that, start, end);
    }
  },
  setPosition: function(pos, setReal) {
    this.setSelection(pos, pos, setReal);
  },
  getBeforeAfter: function() {
    var value = this.value, left = value.substring(
      0,
      this.selection.start
    ), right = value.substring(
      this.selection.end,
      value.length
    );
    return [left, right];
  },
  getBeforeAfterStriped: function() {
    var parts = this.getBeforeAfter();
    return parts;
  },
  normalizeParts: function(left, right) {
    var settingsClone = this.settingsClone;
    if (this.first) {
      right = autoStrip(right, settingsClone);
      left = autoStrip(left, settingsClone);
      this.first = false;
    }
    var new_value = left + right;
    if (settingsClone.aDec) {
      var m = new_value.match(new RegExp("^" + settingsClone.aNegRegAutoStrip + "\\" + settingsClone.aDec));
      if (m) {
        left = left.replace(m[1], m[1] + "0");
        new_value = left + right;
      }
    }
    return [left, right];
  },
  processKeypress: function() {
    var settingsClone = this.settingsClone, cCode = String.fromCharCode(this.which), parts = this.getBeforeAfterStriped(), left = parts[0], right = parts[1];
    if (cCode === settingsClone.aDec || settingsClone.altDec && cCode === settingsClone.altDec || (cCode === "." || cCode === ",") && this.kdCode === 110) {
      if (!settingsClone.mDec || !settingsClone.aDec) {
        return true;
      }
      if (settingsClone.aNeg && right.indexOf(settingsClone.aNeg) > -1) {
        return true;
      }
      if (left.indexOf(settingsClone.aDec) > -1) {
        return true;
      }
      if (right.indexOf(settingsClone.aDec) > 0) {
        return true;
      }
      if (right.indexOf(settingsClone.aDec) === 0) {
        right = right.substr(1);
      }
      this.setValueParts(left + settingsClone.aDec, right);
      return true;
    }
    if (cCode === "-" || cCode === "+") {
      if (!settingsClone.aNeg) {
        return true;
      }
      if (left === "" && right.indexOf(settingsClone.aNeg) > -1) {
        left = settingsClone.aNeg;
        right = right.substring(1, right.length);
      }
      if (left.charAt(0) === settingsClone.aNeg) {
        left = left.substring(1, left.length);
      } else {
        left = cCode === "-" ? settingsClone.aNeg + left : left;
      }
      this.setValueParts(left, right);
      return true;
    }
    if (cCode >= "0" && cCode <= "9") {
      if (settingsClone.aNeg && left === "" && right.indexOf(settingsClone.aNeg) > -1) {
        left = settingsClone.aNeg;
        right = right.substring(1, right.length);
      }
      if (settingsClone.vMax <= 0 && settingsClone.vMin < settingsClone.vMax && this.value.indexOf(settingsClone.aNeg) === -1 && cCode !== "0") {
        left = settingsClone.aNeg + left;
      }
      this.setValueParts(left + cCode, right);
      return true;
    }
    return true;
  },
  setValueParts: function(left, right) {
    var settingsClone = this.settingsClone, parts = this.normalizeParts(left, right), new_value = parts.join(""), position2 = parts[0].length;
    if (autoCheck(new_value, settingsClone)) {
      new_value = truncateDecimal(
        new_value,
        settingsClone.aDec,
        settingsClone.mDec
      );
      if (position2 > new_value.length) {
        position2 = new_value.length;
      }
      this.value = new_value;
      this.setPosition(position2, false);
      return true;
    }
    return false;
  },
  processAllways: function() {
    var parts;
    if (this.kdCode === 8 || this.kdCode === 46) {
      if (!this.selection.length) {
        parts = this.getBeforeAfter();
        parts[0] = autoStrip(parts[0], this.settingsClone);
        parts[1] = autoStrip(parts[1], this.settingsClone);
        if (this.kdCode === 8) {
          parts[0] = parts[0].substring(0, parts[0].length - 1);
        } else {
          parts[1] = parts[1].substring(1, parts[1].length);
        }
        this.setValueParts(parts[0], parts[1]);
      } else {
        parts = this.getBeforeAfterStriped();
        this.setValueParts(parts[0], parts[1]);
      }
      return true;
    }
    return false;
  },
  checkPaste: function() {
    if (this.valuePartsBeforePaste !== void 0) {
      var parts = this.getBeforeAfter(), oldParts = this.valuePartsBeforePaste;
      delete this.valuePartsBeforePaste;
      parts[0] = parts[0].substr(0, oldParts[0].length) + autoStrip(parts[0].substr(oldParts[0].length), this.settingsClone);
      if (!this.setValueParts(parts[0], parts[1])) {
        this.value = oldParts.join("");
        this.setPosition(oldParts[0].length, false);
      }
    }
  },
  skipAllways: function(e) {
    var kdCode = this.kdCode, which = this.which, ctrlKey = this.ctrlKey, cmdKey = this.cmdKey, shiftKey = this.shiftKey;
    if ((ctrlKey || cmdKey) && e.type === "keyup" && this.valuePartsBeforePaste !== void 0 || shiftKey && kdCode === 45) {
      this.checkPaste();
      return false;
    }
    if (kdCode >= 112 && kdCode <= 123 || kdCode >= 91 && kdCode <= 93 || kdCode >= 9 && kdCode <= 31 || kdCode < 8 && (which === 0 || which === kdCode) || kdCode === 144 || kdCode === 145 || kdCode === 45) {
      return true;
    }
    if ((ctrlKey || cmdKey) && kdCode === 65) {
      return true;
    }
    if ((ctrlKey || cmdKey) && (kdCode === 67 || kdCode === 86 || kdCode === 88)) {
      if (kdCode === 86 || kdCode === 45) {
        if (e.type === "keydown" || e.type === "keypress") {
          if (this.valuePartsBeforePaste === void 0) {
            this.valuePartsBeforePaste = this.getBeforeAfter();
          }
        } else {
          this.checkPaste();
        }
      }
      return e.type === "keydown" || e.type === "keypress" || kdCode === 67;
    }
    if (ctrlKey || cmdKey) {
      return true;
    }
    if (kdCode === 37 || kdCode === 39) {
      var aSep = this.settingsClone.aSep, start = this.selection.start, value = this.that.getInputValue();
      if (e.type === "keydown" && aSep && !this.shiftKey) {
        if (kdCode === 37 && value.charAt(start - 2) === aSep) {
          this.setPosition(start - 1);
        } else if (kdCode === 39 && value.charAt(start + 1) === aSep) {
          this.setPosition(start + 1);
        }
      }
      return true;
    }
    if (kdCode >= 34 && kdCode <= 40) {
      return true;
    }
    return false;
  },
  formatQuick: function() {
    var settingsClone = this.settingsClone, parts = this.getBeforeAfterStriped(), leftLength = this.value;
    if ((settingsClone.aSep === "" || settingsClone.aSep !== "" && leftLength.indexOf(settingsClone.aSep) === -1) && (settingsClone.aSign === "" || settingsClone.aSign !== "" && leftLength.indexOf(settingsClone.aSign) === -1)) {
      var subParts = [], nSign = "";
      subParts = leftLength.split(settingsClone.aDec);
      if (subParts[0].indexOf("-") > -1) {
        nSign = "-";
        subParts[0] = subParts[0].replace("-", "");
        parts[0] = parts[0].replace("-", "");
      }
      if (subParts[0].length > settingsClone.mInt && parts[0].charAt(0) === "0") {
        parts[0] = parts[0].slice(1);
      }
      parts[0] = nSign + parts[0];
    }
    var value;
    if ((this.kdCode >= 48 && this.kdCode <= 57 || this.kdCode >= 96 && this.kdCode <= 105) && !this.shiftKey) {
      value = autoGroup(this.value, this.settingsClone, true);
    } else {
      value = autoGroup(this.value, this.settingsClone, false);
    }
    var position2 = value.length;
    if (value) {
      var left_ar = parts[0].split(""), i = 0;
      for (i; i < left_ar.length; i += 1) {
        if (!left_ar[i].match("\\d")) {
          left_ar[i] = "\\" + left_ar[i];
        }
      }
      var leftReg = new RegExp("^.*?" + left_ar.join(".*?"));
      if (settingsClone.pSign == "p") {
        leftReg = new RegExp("^.*" + left_ar.join(".*"));
      }
      var newLeft = value.match(leftReg);
      if (newLeft) {
        position2 = newLeft[0].length;
        if ((position2 === 0 && value.charAt(0) !== settingsClone.aNeg || position2 === 1 && value.charAt(0) === settingsClone.aNeg) && settingsClone.aSign && settingsClone.pSign === "p") {
          position2 = this.settingsClone.aSign.length + (value.charAt(0) === "-" ? 1 : 0);
        }
      } else if (settingsClone.aSign && settingsClone.pSign === "s") {
        position2 -= settingsClone.aSign.length;
      }
    } else {
      settingsClone.aSign && (value = settingsClone.aSign);
    }
    if (this.that.__IsVirtual) {
      this.that.$setInputValue(value);
    } else {
      this.that.value = value;
    }
    this.setPosition(position2);
    this.formatted = true;
  }
};
function getHandler($that, settings, update) {
  var data2 = $that.getDataSet("NumberEditor");
  if (!data2) {
    data2 = {};
    $that.$setDataSet("NumberEditor", data2);
  }
  var handler = data2.handler;
  if (handler === void 0 && settings || update) {
    handler = new NumberEditorHandler($that, settings);
    data2.handler = handler;
  }
  return handler;
}
class YesVNumberEditor extends YesVBaseText {
  constructor(options) {
    var decPrecision = options.precision;
    var decScale = options.scale;
    var roundingMode = options.roundingMode;
    var maxNumber = "";
    for (var i = 0; i < decPrecision - decScale; i++) {
      maxNumber += "9";
    }
    if (decScale > 0) {
      maxNumber += ".";
      for (var i = 0; i < decScale; i++) {
        maxNumber += "9";
      }
    }
    options.vMax = maxNumber;
    options.vMin = "-" + maxNumber;
    options.mDec = decScale;
    options.mRound = roundingMode;
    super(options);
    this.normalCaption = "";
    this.text_focusout = async (event2) => {
      var self2 = this;
      var $this = self2.$input;
      if (!self2.enable || self2.processing)
        return false;
      self2.needSelectAll = self2.selectOnFocus;
      var handler = self2.handler, settingsClone = handler.settingsClone, value = $this.getInputValue(), origValue = value;
      handler.settingsClone.oEvent = "focusout";
      if (handler.that.__IsVirtual) {
        handler.that.$setRawDomElm(self2.$input.getElm());
      }
      if (value !== "") {
        value = autoStrip(value, settingsClone);
        if (checkEmpty(value, settingsClone) === null && autoCheck(value, settingsClone)) {
          value = fixNumber(
            value,
            settingsClone.aDec,
            settingsClone.aNeg
          );
          value = autoRound(value, settingsClone);
          value = presentNumber(
            value,
            settingsClone.aDec,
            settingsClone.aNeg
          );
          value = stripTrailingZeros(value, settingsClone);
        } else {
          value = "";
        }
      }
      var groupedValue = checkEmpty(value, settingsClone);
      if (groupedValue === null) {
        groupedValue = autoGroup(value, settingsClone, void 0);
      }
      if (groupedValue !== origValue) {
        $this.$setInputValue(groupedValue);
      }
      var curValue = value == "" ? new Decimal(0) : new Decimal(value);
      if (self2.allowNull) {
        if (value == "") {
          curValue = null;
        }
      }
      try {
        await self2.commitValue(curValue);
      } catch (error) {
        throw error;
      } finally {
        self2.doFocusOut();
        self2.el && self2.el.$removeClass("focus");
      }
    };
    this.aNum = options.aNum || "0123456789";
    this.aSep = options.aSep || ",";
    this.dGroup = options.dGroup || "3";
    this.aDec = options.aDec || ".";
    this.aSign = options.aSign;
    this.pSign = options.pSign;
    this.vMax = options.vMax;
    this.dMax = new Decimal(this.vMax);
    this.vMin = options.vMin;
    this.dMin = new Decimal(this.vMin);
    this.mDec = options.mDec;
    this.mPre = options.mPre || "16";
    this.mRound = options.mRound;
    this.altDec = options.altDec;
    this.formulaText = options.formulaText;
    this.selectOnFocus = options.selectOnFocus;
    this.allowNull = options.allowNull || false;
    this.precision = options.precision;
  }
  createCenterElement() {
    this.$input = YElement.buildFromVNode(h$1("input", { props: { type: "text" } })).$appendTo(this.el);
  }
  createRightElement() {
    var wrap = YElement.buildFromVNode(h$1("div.wrap")).$appendTo(this.el);
    this.$clearBtn = YElement.buildFromVNode(h$1("span.clear")).$appendTo(wrap);
  }
  createHtml() {
    this.el.$addClass("ui-control").$addClass("ui-numed");
    this.createLeftElement();
    this.createCenterElement();
    this.createRightElement();
  }
  initCss(options) {
    if (!options) {
      return;
    }
    var str = this.getOuterCss(options, false);
    var inputCss = this.getInputCss(options);
    var lblCss = this.getLabelCss(options);
    var inputLblCss = this.getInputLbl(options);
    this.el.$appendStyles(str).$appendStyles(inputCss);
    this.$input.$appendStyles(inputLblCss).$appendStyles(lblCss);
    this.setFormatStyle(options);
    this.txtCss && this.$input.$appendStyles(this.txtCss);
  }
  render(ct) {
    super.render(ct);
    this.handler = getHandler(this.$input, this, false);
    this.handler.first = true;
  }
  afterRender() {
    super.afterRender();
    this.promptText && this.setPromptText(this.promptText);
  }
  getValue() {
    var realV = null;
    if (this.value == null) {
      realV = 0;
    } else {
      realV = fixNumber(this.value, this.aDec);
    }
    return new Decimal(realV);
  }
  getInput() {
    return this.$input;
  }
  getClearBtn() {
    return this.$clearBtn;
  }
  setShowText(text) {
    let renderContext = this.owner.getForm().getRenderContext();
    let printText = this.el.$findByClassName(`ui-print-text`);
    if (renderContext.isPrinting() && printText.length > 0) {
      printText[0].$setInnerText(text + ` `);
    } else {
      this.$input.$setInputValue(text);
      this.$input.getElm() && (this.$input.getElm().value = text);
    }
  }
  focus() {
    this.$input.$focus();
  }
  //TODO 处理颜色
  setBackColor(backColor) {
    this.backColor = backColor;
    this.$input.$appendStyles(new Map(Object.entries({
      "background-image": "none",
      "background-color": backColor
    })));
    this.el.$appendStyles(new Map(Object.entries({
      "background-image": "none",
      "background-color": backColor
    })));
  }
  //TODO 处理颜色
  setForeColor(foreColor) {
    this.foreColor = foreColor;
    this.$input.$addStyle("color", foreColor);
  }
  //TODO 不要出现 -3 的PX
  setHeight(height) {
    super.setHeight(height);
  }
  setWidth(width) {
    super.setWidth(width);
  }
  setPromptText(promptText) {
    this.$input.$setAttr("placeholder", promptText);
  }
  // autoGroup(value) {
  //     var value = autoGroup(value, this.settings, false);
  //     return value;
  // };
  setNormalCaption(caption) {
    this.normalCaption = caption;
  }
  doFocusOut() {
    var fn = this.owner.doFocusOut;
    if (typeof fn === "function") {
      return fn.apply(this.owner, arguments);
    }
  }
  doTextChanged() {
    var fn = this.owner.doTextChanged;
    if (typeof fn === "function") {
      return fn.apply(this.owner, arguments);
    }
  }
  doOnFocus() {
    var fn = this.owner.doOnFocus;
    if (typeof fn === "function") {
      return fn.apply(this.owner, arguments);
    }
  }
  getShowText() {
    return this.$input.getInputValue();
  }
  async doOnInputClick(event2, item) {
    var $this = this.$input;
    var self2 = this;
    if (!self2.enable)
      return false;
    var handler = self2.handler;
    if (handler.that.__IsVirtual) {
      handler.that.$setRawDomElm(event2.target);
    }
    if (self2.aSign && !$this.getInputValue() && (self2.pSign == "s" || self2.pSign == "p")) {
      $this.$setInputValue(self2.aSign);
    }
    self2.focusOwner();
    if (self2.needSelectAll) {
      let doc = document;
      if (doc.selection && doc.selection.empty) {
        doc.selection.empty();
      } else if (window.getSelection) {
        var sel = window.getSelection();
        sel && sel.removeAllRanges();
      }
      var pSign = self2.pSign;
      if (self2.selectOnFocus) {
        if (pSign) {
          if (pSign == "p") {
            setElementSelection(event2.target, self2.aSign.length, self2.$input.getInputValue().length);
          } else if (pSign == "s") {
            setElementSelection(event2.target, 0, self2.$input.getInputValue().length - self2.aSign.length);
          }
        } else {
          select(event2.target);
        }
      }
      self2.needSelectAll = false;
    }
  }
  install() {
    super.install();
    var $this = this.$input;
    var self2 = this;
    self2.needSelectAll = self2.selectOnFocus;
    $this.$addListener("keydown", function(e) {
      if (!self2.enable)
        return;
      var handler = self2.handler;
      var keyCode = e.keyCode || e.charCode;
      if (keyCode === 13 || keyCode === 108 || keyCode === 9) {
        self2.requestNextFocus(keyCode);
        e.preventDefault();
      }
      if (handler.settings.aDec === handler.settings.aSep) {
        jq.error("error");
      }
      if (e.target.readOnly) {
        handler.processed = true;
        return true;
      }
      if (handler.that.__IsVirtual) {
        handler.that.$setRawDomElm(e.target);
      }
      handler.init(e);
      handler.settings.oEvent = "keydown";
      if (handler.skipAllways(e)) {
        handler.processed = true;
        return true;
      }
      if (handler.processAllways()) {
        handler.processed = true;
        handler.formatQuick();
        e.preventDefault();
        return;
      }
      handler.formatted = false;
      return true;
    });
    $this.$addListener("keypress", function(e) {
      if (!self2.enable)
        return;
      var handler = self2.handler;
      var processed = handler.processed;
      if (handler.that.__IsVirtual) {
        handler.that.$setRawDomElm(e.target);
      }
      handler.init(e);
      handler.settings.oEvent = "keypress";
      self2.doTextChanged();
      if (handler.skipAllways(e)) {
        return true;
      }
      if (processed) {
        e.preventDefault();
        return;
      }
      if (handler.processAllways() || handler.processKeypress()) {
        handler.formatQuick();
        e.preventDefault();
        return;
      }
      handler.formatted = false;
    });
    $this.$addListener("keyup", function(e) {
      if (!self2.enable)
        return false;
      var handler = self2.handler;
      if (handler.that.__IsVirtual) {
        handler.that.$setRawDomElm(e.target);
      }
      handler.init(e);
      handler.settings.oEvent = "keyup";
      var skip = handler.skipAllways(e);
      handler.kdCode = 0;
      delete handler.valuePartsBeforePaste;
      self2.doOnKeyInput({});
      if (e.target.value === handler.settings.aSign) {
        if (handler.settings.pSign === "s") {
          setElementSelection(e.target, 0, 0);
        } else {
          setElementSelection(
            e.target,
            handler.settings.aSign.length,
            handler.settings.aSign.length
          );
        }
      }
      e.target.value && $this.$setInputValue(e.target.value);
      if (skip) {
        return true;
      }
      if (this.value === "") {
        return true;
      }
    });
    $this.$addListener("focusin", function(event2) {
      if (!self2.enable)
        return false;
      if (self2.formulaText && !self2.el.hasClass("focus")) {
        self2.$input.$setInputValue(self2.normalCaption);
      }
      self2.el.$addClass("focus");
      var handler = self2.handler;
      handler.settingsClone.oEvent = "focusin";
      if (handler.that.__IsVirtual) {
        handler.that.$setRawDomElm(event2.target);
      }
      var onempty = checkEmpty($this.getInputValue(), handler.settingsClone);
      if (onempty) {
        $this.$setInputValue(onempty);
        if (handler.settings.pSign === "s") {
          setElementSelection(event2.target, 0, 0);
        } else {
          setElementSelection(
            event2.target,
            handler.settings.aSign.length,
            handler.settings.aSign.length
          );
        }
      }
      if (self2.needSelectAll) {
        var pSign = self2.pSign;
        if (self2.selectOnFocus) {
          if (pSign) {
            if (pSign == "p") {
              setElementSelection(event2.target, self2.aSign.length, self2.$input.getInputValue().length);
            } else if (pSign == "s") {
              setElementSelection(event2.target, 0, self2.$input.getInputValue().length - self2.aSign.length);
            }
          } else {
            select(event2.target);
          }
        }
      }
      self2.doOnFocus();
    });
    $this.$addListener("focusout", syncevent(self2.text_focusout));
    $this.$addListener("click", function(event2) {
      self2.doOnInputClick(event2, null);
    });
    self2.el.$addListener("mouseenter", function() {
      if (!self2.enable)
        return false;
      if (self2.aSign && !$this.getInputValue() && (self2.pSign == "s" || self2.pSign == "p")) {
        $this.$setInputValue(self2.aSign);
      }
    });
    self2.el.$addListener("mouseleave", function() {
      if (!self2.enable)
        return false;
      if (!self2.el.hasClass("focus") && $this.getInputValue() == self2.aSign) {
        $this.$setInputValue("");
      }
    });
    self2.$clearBtn.$mousedown(function(e) {
      self2.aSign && $this.$setInputValue(self2.aSign);
      self2.normalCaption = "";
    });
  }
  installPrint() {
    this.el.$addClass(`ui-print`);
    let printText = YElement.buildFromVNode(h$1(`div`)).$addClass(`ui-print-text`).$insertBefore(this.$input);
    printText.$setInnerText(this.getShowText() + ` `);
    this.$input.$addStyle(`display`, `none`);
  }
}
__decorateClass$y([
  TraceUIOptEvent()
], YesVNumberEditor.prototype, "doOnInputClick", 1);
class YesNumberEditorBuilderBuilder extends YesComponentBuilder {
  static create(options) {
    return new YesVNumberEditor(options);
  }
}
var __defProp$x = Object.defineProperty;
var __getOwnPropDesc$x = Object.getOwnPropertyDescriptor;
var __decorateClass$x = (decorators, target, key2, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$x(target, key2) : target;
  for (var i = decorators.length - 1, decorator; i >= 0; i--)
    if (decorator = decorators[i])
      result = (kind ? decorator(target, key2, result) : decorator(result)) || result;
  if (kind && result)
    __defProp$x(target, key2, result);
  return result;
};
class YesVTextArea extends YesVBaseText {
  constructor(options) {
    super(options);
    this.caseType = options.caseType;
    this.maxLength = options.maxLength;
    this.autoSize = options.autoSize || false;
  }
  createHtml() {
    this.el.$addClass("ui-control").$addClass("ui-txta");
    this.$input = YElement.buildFromVNode(h$1("textarea")).$appendTo(this.el);
    this.$input.$setAttr("spellcheck", "false");
    if (this.autoSize) {
      let $pre = YElement.buildFromVNode(h$1("pre"));
      this.$span = YElement.buildFromVNode(h$1("span")).$appendTo($pre);
      YElement.buildFromVNode(h$1("br")).$appendTo($pre);
      $pre.$insertBefore(this.$input);
      this.el.$addClass("txta-wrap");
    }
  }
  initCss(options) {
    if (!options) {
      return;
    }
    var str = this.getOuterCss(options, false);
    var inputCss = this.getInputCss(options);
    var lblCss = this.getLabelCss(options);
    this.$input.$appendStyles(inputCss).$appendStyles(lblCss);
    this.setFormatStyle(options);
    this.txtCss && this.$input.$appendStyles(this.txtCss);
    this.el.$appendStyles(str).$appendStyles(inputCss);
  }
  afterRender() {
    super.afterRender();
    this.setcaseType(this.caseType);
    this.setMaxLength(this.maxLength);
  }
  getInput() {
    return this.$input;
  }
  setEnable(enable) {
    super.setEnable(enable);
  }
  focus() {
    this.$input.$focus();
  }
  setShowText(text) {
    let renderContext = this.owner.getForm().getRenderContext();
    let printText = this.el.$findByClassName(`ui-print-text`);
    if (renderContext.isPrinting() && printText.length > 0) {
      printText[0].$setInnerText(text + ` `);
    } else {
      this.$input.$setInputValue(text);
    }
  }
  setBackColor(backColor) {
    this.$input.$appendStyles(
      new Map(
        Object.entries({
          "background-image": "none",
          "background-color": backColor
        })
      )
    );
  }
  setForeColor(foreColor) {
    this.$input.$addStyle("color", foreColor);
  }
  setHeight(height) {
    super.setHeight(height);
  }
  setWidth(width) {
    super.setWidth(width);
  }
  setcaseType(caseType) {
    var el = this.$input;
    this.caseType = caseType;
    if (caseType === CaseType.UPPER) {
      el.$addClass("uppercase");
    } else {
      el.$removeClass("uppercase");
    }
    if (caseType === CaseType.LOWER) {
      el.$addClass("lowercase");
    } else {
      el.$removeClass("lowercase");
    }
  }
  setInvalidChars(invalidChars) {
    if (invalidChars) {
      this.invalidChars = invalidChars;
    }
  }
  setMaxLength(maxLength) {
    if (maxLength > 0) {
      this.maxLength = maxLength;
      this.$input.$setAttr("maxlength", maxLength);
    }
  }
  setPromptText(promptText) {
    this.promptText = promptText;
    this.$input.$setAttr("placeholder", promptText);
  }
  doFocusOut() {
    var fn = this.owner.doFocusOut;
    if (typeof fn === "function") {
      return fn.apply(this.owner, arguments);
    }
  }
  async doOnInputClick(event2, item) {
    var self2 = this;
    if (!self2.enable)
      return false;
    self2.el.$addClass("focus");
    if (self2.needSelectAll) {
      event2.target.select();
      self2.needSelectAll = false;
    }
    self2.focusOwner();
  }
  install() {
    super.install();
    var self2 = this;
    var input = this.$input;
    input.$addListener("click", function(event2) {
      self2.doOnInputClick(event2, null);
    }).$addListener("focusin", function() {
      if (!self2.enable)
        return false;
      if (self2.selectOnFocus) {
        self2.needSelectAll = self2.selectOnFocus;
      }
    }).$addListener("blur", async (event2) => {
      if (!self2.enable)
        return false;
      self2.el.$removeClass("focus");
      var curValue = event2.target.value;
      try {
        await self2.commitValue(curValue.replace(/\r?\n/g, "\r\n"));
      } catch (error) {
        throw error;
      }
      self2.doFocusOut();
    }).$addListener("keydown", function(event2) {
      if (!self2.enable)
        return;
      var keyCode = event2.keyCode || event2.charCode;
      if (keyCode == 9) {
        self2.requestNextFocus(keyCode);
        event2.preventDefault();
      }
    });
    if (jq.browser.isIE) {
      self2.$input.$addListener("keypress", function(event2) {
        var _a;
        if (!self2.enable)
          return;
        let tmpString = (_a = event2.target) == null ? void 0 : _a.value;
        if (tmpString.length > self2.maxLength) {
          self2.$input.$setInputValue(tmpString.substring(0, self2.maxLength));
        }
      });
    }
    self2.getInput().$addListener("input", function(event2) {
      self2.$span && self2.$span.$setInnerText(event2.target.value);
    }).$addListener("propertychange", function(event2) {
      self2.$span && self2.$span.$setInnerText(event2.target.value);
    }).$addListener("keyup", function(event2) {
      self2.$span && self2.$span.$setInnerText(event2.target.value);
      self2.doOnKeyInput({});
    }).$addListener("change", function(event2) {
      self2.$span && self2.$span.$setInnerText(event2.target.value);
    });
  }
  installPrint() {
    this.el.$addClass(`ui-print`);
    let printText = YElement.buildFromVNode(h$1(`div`)).$addClass(`ui-print-text`).$insertBefore(this.$input);
    printText.$setInnerText(this.owner.value + ` `);
    this.$input.$addStyle(`display`, `none`);
  }
}
__decorateClass$x([
  TraceUIOptEvent()
], YesVTextArea.prototype, "doOnInputClick", 1);
class YesTextAreaBuilder extends YesComponentBuilder {
  static create(options) {
    return new YesVTextArea(options);
  }
}
/**!
 * Sortable 1.15.0
 * @author	RubaXa   <trash@rubaxa.org>
 * @author	owenm    <owen23355@gmail.com>
 * @license MIT
 */
function ownKeys(object, enumerableOnly) {
  var keys = Object.keys(object);
  if (Object.getOwnPropertySymbols) {
    var symbols = Object.getOwnPropertySymbols(object);
    if (enumerableOnly) {
      symbols = symbols.filter(function(sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });
    }
    keys.push.apply(keys, symbols);
  }
  return keys;
}
function _objectSpread2(target) {
  for (var i = 1; i < arguments.length; i++) {
    var source = arguments[i] != null ? arguments[i] : {};
    if (i % 2) {
      ownKeys(Object(source), true).forEach(function(key2) {
        _defineProperty(target, key2, source[key2]);
      });
    } else if (Object.getOwnPropertyDescriptors) {
      Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
    } else {
      ownKeys(Object(source)).forEach(function(key2) {
        Object.defineProperty(target, key2, Object.getOwnPropertyDescriptor(source, key2));
      });
    }
  }
  return target;
}
function _typeof$1(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof$1 = function(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof$1 = function(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof$1(obj);
}
function _defineProperty(obj, key2, value) {
  if (key2 in obj) {
    Object.defineProperty(obj, key2, {
      value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key2] = value;
  }
  return obj;
}
function _extends() {
  _extends = Object.assign || function(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];
      for (var key2 in source) {
        if (Object.prototype.hasOwnProperty.call(source, key2)) {
          target[key2] = source[key2];
        }
      }
    }
    return target;
  };
  return _extends.apply(this, arguments);
}
function _objectWithoutPropertiesLoose(source, excluded) {
  if (source == null)
    return {};
  var target = {};
  var sourceKeys = Object.keys(source);
  var key2, i;
  for (i = 0; i < sourceKeys.length; i++) {
    key2 = sourceKeys[i];
    if (excluded.indexOf(key2) >= 0)
      continue;
    target[key2] = source[key2];
  }
  return target;
}
function _objectWithoutProperties(source, excluded) {
  if (source == null)
    return {};
  var target = _objectWithoutPropertiesLoose(source, excluded);
  var key2, i;
  if (Object.getOwnPropertySymbols) {
    var sourceSymbolKeys = Object.getOwnPropertySymbols(source);
    for (i = 0; i < sourceSymbolKeys.length; i++) {
      key2 = sourceSymbolKeys[i];
      if (excluded.indexOf(key2) >= 0)
        continue;
      if (!Object.prototype.propertyIsEnumerable.call(source, key2))
        continue;
      target[key2] = source[key2];
    }
  }
  return target;
}
function _toConsumableArray(arr) {
  return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray$1(arr) || _nonIterableSpread();
}
function _arrayWithoutHoles(arr) {
  if (Array.isArray(arr))
    return _arrayLikeToArray$1(arr);
}
function _iterableToArray(iter) {
  if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null)
    return Array.from(iter);
}
function _unsupportedIterableToArray$1(o, minLen) {
  if (!o)
    return;
  if (typeof o === "string")
    return _arrayLikeToArray$1(o, minLen);
  var n = Object.prototype.toString.call(o).slice(8, -1);
  if (n === "Object" && o.constructor)
    n = o.constructor.name;
  if (n === "Map" || n === "Set")
    return Array.from(o);
  if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))
    return _arrayLikeToArray$1(o, minLen);
}
function _arrayLikeToArray$1(arr, len) {
  if (len == null || len > arr.length)
    len = arr.length;
  for (var i = 0, arr2 = new Array(len); i < len; i++)
    arr2[i] = arr[i];
  return arr2;
}
function _nonIterableSpread() {
  throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}
var version = "1.15.0";
function userAgent(pattern) {
  if (typeof window !== "undefined" && window.navigator) {
    return !!/* @__PURE__ */ navigator.userAgent.match(pattern);
  }
}
var IE11OrLess = userAgent(/(?:Trident.*rv[ :]?11\.|msie|iemobile|Windows Phone)/i);
var Edge = userAgent(/Edge/i);
var FireFox = userAgent(/firefox/i);
var Safari = userAgent(/safari/i) && !userAgent(/chrome/i) && !userAgent(/android/i);
var IOS = userAgent(/iP(ad|od|hone)/i);
var ChromeForAndroid = userAgent(/chrome/i) && userAgent(/android/i);
var captureMode = {
  capture: false,
  passive: false
};
function on(el, event2, fn) {
  el.addEventListener(event2, fn, !IE11OrLess && captureMode);
}
function off(el, event2, fn) {
  el.removeEventListener(event2, fn, !IE11OrLess && captureMode);
}
function matches(el, selector) {
  if (!selector)
    return;
  selector[0] === ">" && (selector = selector.substring(1));
  if (el) {
    try {
      if (el.matches) {
        return el.matches(selector);
      } else if (el.msMatchesSelector) {
        return el.msMatchesSelector(selector);
      } else if (el.webkitMatchesSelector) {
        return el.webkitMatchesSelector(selector);
      }
    } catch (_2) {
      return false;
    }
  }
  return false;
}
function getParentOrHost(el) {
  return el.host && el !== document && el.host.nodeType ? el.host : el.parentNode;
}
function closest(el, selector, ctx, includeCTX) {
  if (el) {
    ctx = ctx || document;
    do {
      if (selector != null && (selector[0] === ">" ? el.parentNode === ctx && matches(el, selector) : matches(el, selector)) || includeCTX && el === ctx) {
        return el;
      }
      if (el === ctx)
        break;
    } while (el = getParentOrHost(el));
  }
  return null;
}
var R_SPACE = /\s+/g;
function toggleClass(el, name, state) {
  if (el && name) {
    if (el.classList) {
      el.classList[state ? "add" : "remove"](name);
    } else {
      var className = (" " + el.className + " ").replace(R_SPACE, " ").replace(" " + name + " ", " ");
      el.className = (className + (state ? " " + name : "")).replace(R_SPACE, " ");
    }
  }
}
function css(el, prop, val) {
  var style = el && el.style;
  if (style) {
    if (val === void 0) {
      if (document.defaultView && document.defaultView.getComputedStyle) {
        val = document.defaultView.getComputedStyle(el, "");
      } else if (el.currentStyle) {
        val = el.currentStyle;
      }
      return prop === void 0 ? val : val[prop];
    } else {
      if (!(prop in style) && prop.indexOf("webkit") === -1) {
        prop = "-webkit-" + prop;
      }
      style[prop] = val + (typeof val === "string" ? "" : "px");
    }
  }
}
function matrix(el, selfOnly) {
  var appliedTransforms = "";
  if (typeof el === "string") {
    appliedTransforms = el;
  } else {
    do {
      var transform = css(el, "transform");
      if (transform && transform !== "none") {
        appliedTransforms = transform + " " + appliedTransforms;
      }
    } while (!selfOnly && (el = el.parentNode));
  }
  var matrixFn = window.DOMMatrix || window.WebKitCSSMatrix || window.CSSMatrix || window.MSCSSMatrix;
  return matrixFn && new matrixFn(appliedTransforms);
}
function find(ctx, tagName, iterator) {
  if (ctx) {
    var list = ctx.getElementsByTagName(tagName), i = 0, n = list.length;
    if (iterator) {
      for (; i < n; i++) {
        iterator(list[i], i);
      }
    }
    return list;
  }
  return [];
}
function getWindowScrollingElement() {
  var scrollingElement = document.scrollingElement;
  if (scrollingElement) {
    return scrollingElement;
  } else {
    return document.documentElement;
  }
}
function getRect(el, relativeToContainingBlock, relativeToNonStaticParent, undoScale, container) {
  if (!el.getBoundingClientRect && el !== window)
    return;
  var elRect, top, left, bottom, right, height, width;
  if (el !== window && el.parentNode && el !== getWindowScrollingElement()) {
    elRect = el.getBoundingClientRect();
    top = elRect.top;
    left = elRect.left;
    bottom = elRect.bottom;
    right = elRect.right;
    height = elRect.height;
    width = elRect.width;
  } else {
    top = 0;
    left = 0;
    bottom = window.innerHeight;
    right = window.innerWidth;
    height = window.innerHeight;
    width = window.innerWidth;
  }
  if ((relativeToContainingBlock || relativeToNonStaticParent) && el !== window) {
    container = container || el.parentNode;
    if (!IE11OrLess) {
      do {
        if (container && container.getBoundingClientRect && (css(container, "transform") !== "none" || relativeToNonStaticParent && css(container, "position") !== "static")) {
          var containerRect = container.getBoundingClientRect();
          top -= containerRect.top + parseInt(css(container, "border-top-width"));
          left -= containerRect.left + parseInt(css(container, "border-left-width"));
          bottom = top + elRect.height;
          right = left + elRect.width;
          break;
        }
      } while (container = container.parentNode);
    }
  }
  if (undoScale && el !== window) {
    var elMatrix = matrix(container || el), scaleX = elMatrix && elMatrix.a, scaleY = elMatrix && elMatrix.d;
    if (elMatrix) {
      top /= scaleY;
      left /= scaleX;
      width /= scaleX;
      height /= scaleY;
      bottom = top + height;
      right = left + width;
    }
  }
  return {
    top,
    left,
    bottom,
    right,
    width,
    height
  };
}
function isScrolledPast(el, elSide, parentSide) {
  var parent2 = getParentAutoScrollElement(el, true), elSideVal = getRect(el)[elSide];
  while (parent2) {
    var parentSideVal = getRect(parent2)[parentSide], visible = void 0;
    if (parentSide === "top" || parentSide === "left") {
      visible = elSideVal >= parentSideVal;
    } else {
      visible = elSideVal <= parentSideVal;
    }
    if (!visible)
      return parent2;
    if (parent2 === getWindowScrollingElement())
      break;
    parent2 = getParentAutoScrollElement(parent2, false);
  }
  return false;
}
function getChild(el, childNum, options, includeDragEl) {
  var currentChild = 0, i = 0, children = el.children;
  while (i < children.length) {
    if (children[i].style.display !== "none" && children[i] !== Sortable.ghost && (includeDragEl || children[i] !== Sortable.dragged) && closest(children[i], options.draggable, el, false)) {
      if (currentChild === childNum) {
        return children[i];
      }
      currentChild++;
    }
    i++;
  }
  return null;
}
function lastChild(el, selector) {
  var last = el.lastElementChild;
  while (last && (last === Sortable.ghost || css(last, "display") === "none" || selector && !matches(last, selector))) {
    last = last.previousElementSibling;
  }
  return last || null;
}
function index(el, selector) {
  var index2 = 0;
  if (!el || !el.parentNode) {
    return -1;
  }
  while (el = el.previousElementSibling) {
    if (el.nodeName.toUpperCase() !== "TEMPLATE" && el !== Sortable.clone && (!selector || matches(el, selector))) {
      index2++;
    }
  }
  return index2;
}
function getRelativeScrollOffset(el) {
  var offsetLeft = 0, offsetTop = 0, winScroller = getWindowScrollingElement();
  if (el) {
    do {
      var elMatrix = matrix(el), scaleX = elMatrix.a, scaleY = elMatrix.d;
      offsetLeft += el.scrollLeft * scaleX;
      offsetTop += el.scrollTop * scaleY;
    } while (el !== winScroller && (el = el.parentNode));
  }
  return [offsetLeft, offsetTop];
}
function indexOfObject(arr, obj) {
  for (var i in arr) {
    if (!arr.hasOwnProperty(i))
      continue;
    for (var key2 in obj) {
      if (obj.hasOwnProperty(key2) && obj[key2] === arr[i][key2])
        return Number(i);
    }
  }
  return -1;
}
function getParentAutoScrollElement(el, includeSelf) {
  if (!el || !el.getBoundingClientRect)
    return getWindowScrollingElement();
  var elem = el;
  var gotSelf = false;
  do {
    if (elem.clientWidth < elem.scrollWidth || elem.clientHeight < elem.scrollHeight) {
      var elemCSS = css(elem);
      if (elem.clientWidth < elem.scrollWidth && (elemCSS.overflowX == "auto" || elemCSS.overflowX == "scroll") || elem.clientHeight < elem.scrollHeight && (elemCSS.overflowY == "auto" || elemCSS.overflowY == "scroll")) {
        if (!elem.getBoundingClientRect || elem === document.body)
          return getWindowScrollingElement();
        if (gotSelf || includeSelf)
          return elem;
        gotSelf = true;
      }
    }
  } while (elem = elem.parentNode);
  return getWindowScrollingElement();
}
function extend(dst, src) {
  if (dst && src) {
    for (var key2 in src) {
      if (src.hasOwnProperty(key2)) {
        dst[key2] = src[key2];
      }
    }
  }
  return dst;
}
function isRectEqual(rect1, rect2) {
  return Math.round(rect1.top) === Math.round(rect2.top) && Math.round(rect1.left) === Math.round(rect2.left) && Math.round(rect1.height) === Math.round(rect2.height) && Math.round(rect1.width) === Math.round(rect2.width);
}
var _throttleTimeout;
function throttle(callback, ms) {
  return function() {
    if (!_throttleTimeout) {
      var args = arguments, _this = this;
      if (args.length === 1) {
        callback.call(_this, args[0]);
      } else {
        callback.apply(_this, args);
      }
      _throttleTimeout = setTimeout(function() {
        _throttleTimeout = void 0;
      }, ms);
    }
  };
}
function cancelThrottle() {
  clearTimeout(_throttleTimeout);
  _throttleTimeout = void 0;
}
function scrollBy(el, x, y) {
  el.scrollLeft += x;
  el.scrollTop += y;
}
function clone(el) {
  var Polymer = window.Polymer;
  var $ = window.jQuery || window.Zepto;
  if (Polymer && Polymer.dom) {
    return Polymer.dom(el).cloneNode(true);
  } else if ($) {
    return $(el).clone(true)[0];
  } else {
    return el.cloneNode(true);
  }
}
function setRect(el, rect) {
  css(el, "position", "absolute");
  css(el, "top", rect.top);
  css(el, "left", rect.left);
  css(el, "width", rect.width);
  css(el, "height", rect.height);
}
function unsetRect(el) {
  css(el, "position", "");
  css(el, "top", "");
  css(el, "left", "");
  css(el, "width", "");
  css(el, "height", "");
}
var expando = "Sortable" + (/* @__PURE__ */ new Date()).getTime();
function AnimationStateManager() {
  var animationStates = [], animationCallbackId;
  return {
    captureAnimationState: function captureAnimationState() {
      animationStates = [];
      if (!this.options.animation)
        return;
      var children = [].slice.call(this.el.children);
      children.forEach(function(child) {
        if (css(child, "display") === "none" || child === Sortable.ghost)
          return;
        animationStates.push({
          target: child,
          rect: getRect(child)
        });
        var fromRect = _objectSpread2({}, animationStates[animationStates.length - 1].rect);
        if (child.thisAnimationDuration) {
          var childMatrix = matrix(child, true);
          if (childMatrix) {
            fromRect.top -= childMatrix.f;
            fromRect.left -= childMatrix.e;
          }
        }
        child.fromRect = fromRect;
      });
    },
    addAnimationState: function addAnimationState(state) {
      animationStates.push(state);
    },
    removeAnimationState: function removeAnimationState(target) {
      animationStates.splice(indexOfObject(animationStates, {
        target
      }), 1);
    },
    animateAll: function animateAll(callback) {
      var _this = this;
      if (!this.options.animation) {
        clearTimeout(animationCallbackId);
        if (typeof callback === "function")
          callback();
        return;
      }
      var animating = false, animationTime = 0;
      animationStates.forEach(function(state) {
        var time = 0, target = state.target, fromRect = target.fromRect, toRect = getRect(target), prevFromRect = target.prevFromRect, prevToRect = target.prevToRect, animatingRect = state.rect, targetMatrix = matrix(target, true);
        if (targetMatrix) {
          toRect.top -= targetMatrix.f;
          toRect.left -= targetMatrix.e;
        }
        target.toRect = toRect;
        if (target.thisAnimationDuration) {
          if (isRectEqual(prevFromRect, toRect) && !isRectEqual(fromRect, toRect) && // Make sure animatingRect is on line between toRect & fromRect
          (animatingRect.top - toRect.top) / (animatingRect.left - toRect.left) === (fromRect.top - toRect.top) / (fromRect.left - toRect.left)) {
            time = calculateRealTime(animatingRect, prevFromRect, prevToRect, _this.options);
          }
        }
        if (!isRectEqual(toRect, fromRect)) {
          target.prevFromRect = fromRect;
          target.prevToRect = toRect;
          if (!time) {
            time = _this.options.animation;
          }
          _this.animate(target, animatingRect, toRect, time);
        }
        if (time) {
          animating = true;
          animationTime = Math.max(animationTime, time);
          clearTimeout(target.animationResetTimer);
          target.animationResetTimer = setTimeout(function() {
            target.animationTime = 0;
            target.prevFromRect = null;
            target.fromRect = null;
            target.prevToRect = null;
            target.thisAnimationDuration = null;
          }, time);
          target.thisAnimationDuration = time;
        }
      });
      clearTimeout(animationCallbackId);
      if (!animating) {
        if (typeof callback === "function")
          callback();
      } else {
        animationCallbackId = setTimeout(function() {
          if (typeof callback === "function")
            callback();
        }, animationTime);
      }
      animationStates = [];
    },
    animate: function animate(target, currentRect, toRect, duration) {
      if (duration) {
        css(target, "transition", "");
        css(target, "transform", "");
        var elMatrix = matrix(this.el), scaleX = elMatrix && elMatrix.a, scaleY = elMatrix && elMatrix.d, translateX = (currentRect.left - toRect.left) / (scaleX || 1), translateY = (currentRect.top - toRect.top) / (scaleY || 1);
        target.animatingX = !!translateX;
        target.animatingY = !!translateY;
        css(target, "transform", "translate3d(" + translateX + "px," + translateY + "px,0)");
        this.forRepaintDummy = repaint(target);
        css(target, "transition", "transform " + duration + "ms" + (this.options.easing ? " " + this.options.easing : ""));
        css(target, "transform", "translate3d(0,0,0)");
        typeof target.animated === "number" && clearTimeout(target.animated);
        target.animated = setTimeout(function() {
          css(target, "transition", "");
          css(target, "transform", "");
          target.animated = false;
          target.animatingX = false;
          target.animatingY = false;
        }, duration);
      }
    }
  };
}
function repaint(target) {
  return target.offsetWidth;
}
function calculateRealTime(animatingRect, fromRect, toRect, options) {
  return Math.sqrt(Math.pow(fromRect.top - animatingRect.top, 2) + Math.pow(fromRect.left - animatingRect.left, 2)) / Math.sqrt(Math.pow(fromRect.top - toRect.top, 2) + Math.pow(fromRect.left - toRect.left, 2)) * options.animation;
}
var plugins = [];
var defaults = {
  initializeByDefault: true
};
var PluginManager = {
  mount: function mount(plugin) {
    for (var option2 in defaults) {
      if (defaults.hasOwnProperty(option2) && !(option2 in plugin)) {
        plugin[option2] = defaults[option2];
      }
    }
    plugins.forEach(function(p) {
      if (p.pluginName === plugin.pluginName) {
        throw "Sortable: Cannot mount plugin ".concat(plugin.pluginName, " more than once");
      }
    });
    plugins.push(plugin);
  },
  pluginEvent: function pluginEvent2(eventName, sortable, evt) {
    var _this = this;
    this.eventCanceled = false;
    evt.cancel = function() {
      _this.eventCanceled = true;
    };
    var eventNameGlobal = eventName + "Global";
    plugins.forEach(function(plugin) {
      if (!sortable[plugin.pluginName])
        return;
      if (sortable[plugin.pluginName][eventNameGlobal]) {
        sortable[plugin.pluginName][eventNameGlobal](_objectSpread2({
          sortable
        }, evt));
      }
      if (sortable.options[plugin.pluginName] && sortable[plugin.pluginName][eventName]) {
        sortable[plugin.pluginName][eventName](_objectSpread2({
          sortable
        }, evt));
      }
    });
  },
  initializePlugins: function initializePlugins(sortable, el, defaults2, options) {
    plugins.forEach(function(plugin) {
      var pluginName = plugin.pluginName;
      if (!sortable.options[pluginName] && !plugin.initializeByDefault)
        return;
      var initialized = new plugin(sortable, el, sortable.options);
      initialized.sortable = sortable;
      initialized.options = sortable.options;
      sortable[pluginName] = initialized;
      _extends(defaults2, initialized.defaults);
    });
    for (var option2 in sortable.options) {
      if (!sortable.options.hasOwnProperty(option2))
        continue;
      var modified = this.modifyOption(sortable, option2, sortable.options[option2]);
      if (typeof modified !== "undefined") {
        sortable.options[option2] = modified;
      }
    }
  },
  getEventProperties: function getEventProperties(name, sortable) {
    var eventProperties = {};
    plugins.forEach(function(plugin) {
      if (typeof plugin.eventProperties !== "function")
        return;
      _extends(eventProperties, plugin.eventProperties.call(sortable[plugin.pluginName], name));
    });
    return eventProperties;
  },
  modifyOption: function modifyOption(sortable, name, value) {
    var modifiedValue;
    plugins.forEach(function(plugin) {
      if (!sortable[plugin.pluginName])
        return;
      if (plugin.optionListeners && typeof plugin.optionListeners[name] === "function") {
        modifiedValue = plugin.optionListeners[name].call(sortable[plugin.pluginName], value);
      }
    });
    return modifiedValue;
  }
};
function dispatchEvent(_ref) {
  var sortable = _ref.sortable, rootEl2 = _ref.rootEl, name = _ref.name, targetEl = _ref.targetEl, cloneEl2 = _ref.cloneEl, toEl = _ref.toEl, fromEl = _ref.fromEl, oldIndex2 = _ref.oldIndex, newIndex2 = _ref.newIndex, oldDraggableIndex2 = _ref.oldDraggableIndex, newDraggableIndex2 = _ref.newDraggableIndex, originalEvent = _ref.originalEvent, putSortable2 = _ref.putSortable, extraEventProperties = _ref.extraEventProperties;
  sortable = sortable || rootEl2 && rootEl2[expando];
  if (!sortable)
    return;
  var evt, options = sortable.options, onName = "on" + name.charAt(0).toUpperCase() + name.substr(1);
  if (window.CustomEvent && !IE11OrLess && !Edge) {
    evt = new CustomEvent(name, {
      bubbles: true,
      cancelable: true
    });
  } else {
    evt = document.createEvent("Event");
    evt.initEvent(name, true, true);
  }
  evt.to = toEl || rootEl2;
  evt.from = fromEl || rootEl2;
  evt.item = targetEl || rootEl2;
  evt.clone = cloneEl2;
  evt.oldIndex = oldIndex2;
  evt.newIndex = newIndex2;
  evt.oldDraggableIndex = oldDraggableIndex2;
  evt.newDraggableIndex = newDraggableIndex2;
  evt.originalEvent = originalEvent;
  evt.pullMode = putSortable2 ? putSortable2.lastPutMode : void 0;
  var allEventProperties = _objectSpread2(_objectSpread2({}, extraEventProperties), PluginManager.getEventProperties(name, sortable));
  for (var option2 in allEventProperties) {
    evt[option2] = allEventProperties[option2];
  }
  if (rootEl2) {
    rootEl2.dispatchEvent(evt);
  }
  if (options[onName]) {
    options[onName].call(sortable, evt);
  }
}
var _excluded = ["evt"];
var pluginEvent = function pluginEvent3(eventName, sortable) {
  var _ref = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : {}, originalEvent = _ref.evt, data2 = _objectWithoutProperties(_ref, _excluded);
  PluginManager.pluginEvent.bind(Sortable)(eventName, sortable, _objectSpread2({
    dragEl,
    parentEl,
    ghostEl,
    rootEl,
    nextEl,
    lastDownEl,
    cloneEl,
    cloneHidden,
    dragStarted: moved,
    putSortable,
    activeSortable: Sortable.active,
    originalEvent,
    oldIndex,
    oldDraggableIndex,
    newIndex,
    newDraggableIndex,
    hideGhostForTarget: _hideGhostForTarget,
    unhideGhostForTarget: _unhideGhostForTarget,
    cloneNowHidden: function cloneNowHidden() {
      cloneHidden = true;
    },
    cloneNowShown: function cloneNowShown() {
      cloneHidden = false;
    },
    dispatchSortableEvent: function dispatchSortableEvent(name) {
      _dispatchEvent({
        sortable,
        name,
        originalEvent
      });
    }
  }, data2));
};
function _dispatchEvent(info) {
  dispatchEvent(_objectSpread2({
    putSortable,
    cloneEl,
    targetEl: dragEl,
    rootEl,
    oldIndex,
    oldDraggableIndex,
    newIndex,
    newDraggableIndex
  }, info));
}
var dragEl, parentEl, ghostEl, rootEl, nextEl, lastDownEl, cloneEl, cloneHidden, oldIndex, newIndex, oldDraggableIndex, newDraggableIndex, activeGroup, putSortable, awaitingDragStarted = false, ignoreNextClick = false, sortables = [], tapEvt, touchEvt, lastDx, lastDy, tapDistanceLeft, tapDistanceTop, moved, lastTarget, lastDirection, pastFirstInvertThresh = false, isCircumstantialInvert = false, targetMoveDistance, ghostRelativeParent, ghostRelativeParentInitialScroll = [], _silent = false, savedInputChecked = [];
var documentExists = typeof document !== "undefined", PositionGhostAbsolutely = IOS, CSSFloatProperty = Edge || IE11OrLess ? "cssFloat" : "float", supportDraggable = documentExists && !ChromeForAndroid && !IOS && "draggable" in document.createElement("div"), supportCssPointerEvents = function() {
  if (!documentExists)
    return;
  if (IE11OrLess) {
    return false;
  }
  var el = document.createElement("x");
  el.style.cssText = "pointer-events:auto";
  return el.style.pointerEvents === "auto";
}(), _detectDirection = function _detectDirection2(el, options) {
  var elCSS = css(el), elWidth = parseInt(elCSS.width) - parseInt(elCSS.paddingLeft) - parseInt(elCSS.paddingRight) - parseInt(elCSS.borderLeftWidth) - parseInt(elCSS.borderRightWidth), child1 = getChild(el, 0, options), child2 = getChild(el, 1, options), firstChildCSS = child1 && css(child1), secondChildCSS = child2 && css(child2), firstChildWidth = firstChildCSS && parseInt(firstChildCSS.marginLeft) + parseInt(firstChildCSS.marginRight) + getRect(child1).width, secondChildWidth = secondChildCSS && parseInt(secondChildCSS.marginLeft) + parseInt(secondChildCSS.marginRight) + getRect(child2).width;
  if (elCSS.display === "flex") {
    return elCSS.flexDirection === "column" || elCSS.flexDirection === "column-reverse" ? "vertical" : "horizontal";
  }
  if (elCSS.display === "grid") {
    return elCSS.gridTemplateColumns.split(" ").length <= 1 ? "vertical" : "horizontal";
  }
  if (child1 && firstChildCSS["float"] && firstChildCSS["float"] !== "none") {
    var touchingSideChild2 = firstChildCSS["float"] === "left" ? "left" : "right";
    return child2 && (secondChildCSS.clear === "both" || secondChildCSS.clear === touchingSideChild2) ? "vertical" : "horizontal";
  }
  return child1 && (firstChildCSS.display === "block" || firstChildCSS.display === "flex" || firstChildCSS.display === "table" || firstChildCSS.display === "grid" || firstChildWidth >= elWidth && elCSS[CSSFloatProperty] === "none" || child2 && elCSS[CSSFloatProperty] === "none" && firstChildWidth + secondChildWidth > elWidth) ? "vertical" : "horizontal";
}, _dragElInRowColumn = function _dragElInRowColumn2(dragRect, targetRect, vertical) {
  var dragElS1Opp = vertical ? dragRect.left : dragRect.top, dragElS2Opp = vertical ? dragRect.right : dragRect.bottom, dragElOppLength = vertical ? dragRect.width : dragRect.height, targetS1Opp = vertical ? targetRect.left : targetRect.top, targetS2Opp = vertical ? targetRect.right : targetRect.bottom, targetOppLength = vertical ? targetRect.width : targetRect.height;
  return dragElS1Opp === targetS1Opp || dragElS2Opp === targetS2Opp || dragElS1Opp + dragElOppLength / 2 === targetS1Opp + targetOppLength / 2;
}, _detectNearestEmptySortable = function _detectNearestEmptySortable2(x, y) {
  var ret;
  sortables.some(function(sortable) {
    var threshold = sortable[expando].options.emptyInsertThreshold;
    if (!threshold || lastChild(sortable))
      return;
    var rect = getRect(sortable), insideHorizontally = x >= rect.left - threshold && x <= rect.right + threshold, insideVertically = y >= rect.top - threshold && y <= rect.bottom + threshold;
    if (insideHorizontally && insideVertically) {
      return ret = sortable;
    }
  });
  return ret;
}, _prepareGroup = function _prepareGroup2(options) {
  function toFn(value, pull) {
    return function(to, from, dragEl2, evt) {
      var sameGroup = to.options.group.name && from.options.group.name && to.options.group.name === from.options.group.name;
      if (value == null && (pull || sameGroup)) {
        return true;
      } else if (value == null || value === false) {
        return false;
      } else if (pull && value === "clone") {
        return value;
      } else if (typeof value === "function") {
        return toFn(value(to, from, dragEl2, evt), pull)(to, from, dragEl2, evt);
      } else {
        var otherGroup = (pull ? to : from).options.group.name;
        return value === true || typeof value === "string" && value === otherGroup || value.join && value.indexOf(otherGroup) > -1;
      }
    };
  }
  var group = {};
  var originalGroup = options.group;
  if (!originalGroup || _typeof$1(originalGroup) != "object") {
    originalGroup = {
      name: originalGroup
    };
  }
  group.name = originalGroup.name;
  group.checkPull = toFn(originalGroup.pull, true);
  group.checkPut = toFn(originalGroup.put);
  group.revertClone = originalGroup.revertClone;
  options.group = group;
}, _hideGhostForTarget = function _hideGhostForTarget2() {
  if (!supportCssPointerEvents && ghostEl) {
    css(ghostEl, "display", "none");
  }
}, _unhideGhostForTarget = function _unhideGhostForTarget2() {
  if (!supportCssPointerEvents && ghostEl) {
    css(ghostEl, "display", "");
  }
}, _nochromeForAndroidClick = function(evt) {
  if (ignoreNextClick) {
    evt.preventDefault();
    evt.stopPropagation && evt.stopPropagation();
    evt.stopImmediatePropagation && evt.stopImmediatePropagation();
    ignoreNextClick = false;
    return false;
  }
};
if (documentExists && !ChromeForAndroid) {
  document.addEventListener("click", _nochromeForAndroidClick, true);
}
var nearestEmptyInsertDetectEvent = function nearestEmptyInsertDetectEvent2(evt) {
  if (dragEl) {
    evt = evt.touches ? evt.touches[0] : evt;
    var nearest = _detectNearestEmptySortable(evt.clientX, evt.clientY);
    if (nearest) {
      var event2 = {};
      for (var i in evt) {
        if (evt.hasOwnProperty(i)) {
          event2[i] = evt[i];
        }
      }
      event2.target = event2.rootEl = nearest;
      event2.preventDefault = void 0;
      event2.stopPropagation = void 0;
      nearest[expando]._onDragOver(event2);
    }
  }
};
var _checkOutsideTargetEl = function _checkOutsideTargetEl2(evt) {
  if (dragEl) {
    dragEl.parentNode[expando]._isOutsideThisEl(evt.target);
  }
};
function Sortable(el, options) {
  if (!(el && el.nodeType && el.nodeType === 1)) {
    throw "Sortable: `el` must be an HTMLElement, not ".concat({}.toString.call(el));
  }
  this.el = el;
  this.options = options = _extends({}, options);
  el[expando] = this;
  var defaults2 = {
    group: null,
    sort: true,
    disabled: false,
    store: null,
    handle: null,
    draggable: /^[uo]l$/i.test(el.nodeName) ? ">li" : ">*",
    swapThreshold: 1,
    // percentage; 0 <= x <= 1
    invertSwap: false,
    // invert always
    invertedSwapThreshold: null,
    // will be set to same as swapThreshold if default
    removeCloneOnHide: true,
    direction: function direction() {
      return _detectDirection(el, this.options);
    },
    ghostClass: "sortable-ghost",
    chosenClass: "sortable-chosen",
    dragClass: "sortable-drag",
    ignore: "a, img",
    filter: null,
    preventOnFilter: true,
    animation: 0,
    easing: null,
    setData: function setData(dataTransfer, dragEl2) {
      dataTransfer.setData("Text", dragEl2.textContent);
    },
    dropBubble: false,
    dragoverBubble: false,
    dataIdAttr: "data-id",
    delay: 0,
    delayOnTouchOnly: false,
    touchStartThreshold: (Number.parseInt ? Number : window).parseInt(window.devicePixelRatio, 10) || 1,
    forceFallback: false,
    fallbackClass: "sortable-fallback",
    fallbackOnBody: false,
    fallbackTolerance: 0,
    fallbackOffset: {
      x: 0,
      y: 0
    },
    supportPointer: Sortable.supportPointer !== false && "PointerEvent" in window && !Safari,
    emptyInsertThreshold: 5
  };
  PluginManager.initializePlugins(this, el, defaults2);
  for (var name in defaults2) {
    !(name in options) && (options[name] = defaults2[name]);
  }
  _prepareGroup(options);
  for (var fn in this) {
    if (fn.charAt(0) === "_" && typeof this[fn] === "function") {
      this[fn] = this[fn].bind(this);
    }
  }
  this.nativeDraggable = options.forceFallback ? false : supportDraggable;
  if (this.nativeDraggable) {
    this.options.touchStartThreshold = 1;
  }
  if (options.supportPointer) {
    on(el, "pointerdown", this._onTapStart);
  } else {
    on(el, "mousedown", this._onTapStart);
    on(el, "touchstart", this._onTapStart);
  }
  if (this.nativeDraggable) {
    on(el, "dragover", this);
    on(el, "dragenter", this);
  }
  sortables.push(this.el);
  options.store && options.store.get && this.sort(options.store.get(this) || []);
  _extends(this, AnimationStateManager());
}
Sortable.prototype = /** @lends Sortable.prototype */
{
  constructor: Sortable,
  _isOutsideThisEl: function _isOutsideThisEl(target) {
    if (!this.el.contains(target) && target !== this.el) {
      lastTarget = null;
    }
  },
  _getDirection: function _getDirection(evt, target) {
    return typeof this.options.direction === "function" ? this.options.direction.call(this, evt, target, dragEl) : this.options.direction;
  },
  _onTapStart: function _onTapStart(evt) {
    if (!evt.cancelable)
      return;
    var _this = this, el = this.el, options = this.options, preventOnFilter = options.preventOnFilter, type = evt.type, touch = evt.touches && evt.touches[0] || evt.pointerType && evt.pointerType === "touch" && evt, target = (touch || evt).target, originalTarget = evt.target.shadowRoot && (evt.path && evt.path[0] || evt.composedPath && evt.composedPath()[0]) || target, filter = options.filter;
    _saveInputCheckedState(el);
    if (dragEl) {
      return;
    }
    if (/mousedown|pointerdown/.test(type) && evt.button !== 0 || options.disabled) {
      return;
    }
    if (originalTarget.isContentEditable) {
      return;
    }
    if (!this.nativeDraggable && Safari && target && target.tagName.toUpperCase() === "SELECT") {
      return;
    }
    target = closest(target, options.draggable, el, false);
    if (target && target.animated) {
      return;
    }
    if (lastDownEl === target) {
      return;
    }
    oldIndex = index(target);
    oldDraggableIndex = index(target, options.draggable);
    if (typeof filter === "function") {
      if (filter.call(this, evt, target, this)) {
        _dispatchEvent({
          sortable: _this,
          rootEl: originalTarget,
          name: "filter",
          targetEl: target,
          toEl: el,
          fromEl: el
        });
        pluginEvent("filter", _this, {
          evt
        });
        preventOnFilter && evt.cancelable && evt.preventDefault();
        return;
      }
    } else if (filter) {
      filter = filter.split(",").some(function(criteria) {
        criteria = closest(originalTarget, criteria.trim(), el, false);
        if (criteria) {
          _dispatchEvent({
            sortable: _this,
            rootEl: criteria,
            name: "filter",
            targetEl: target,
            fromEl: el,
            toEl: el
          });
          pluginEvent("filter", _this, {
            evt
          });
          return true;
        }
      });
      if (filter) {
        preventOnFilter && evt.cancelable && evt.preventDefault();
        return;
      }
    }
    if (options.handle && !closest(originalTarget, options.handle, el, false)) {
      return;
    }
    this._prepareDragStart(evt, touch, target);
  },
  _prepareDragStart: function _prepareDragStart(evt, touch, target) {
    var _this = this, el = _this.el, options = _this.options, ownerDocument = el.ownerDocument, dragStartFn;
    if (target && !dragEl && target.parentNode === el) {
      var dragRect = getRect(target);
      rootEl = el;
      dragEl = target;
      parentEl = dragEl.parentNode;
      nextEl = dragEl.nextSibling;
      lastDownEl = target;
      activeGroup = options.group;
      Sortable.dragged = dragEl;
      tapEvt = {
        target: dragEl,
        clientX: (touch || evt).clientX,
        clientY: (touch || evt).clientY
      };
      tapDistanceLeft = tapEvt.clientX - dragRect.left;
      tapDistanceTop = tapEvt.clientY - dragRect.top;
      this._lastX = (touch || evt).clientX;
      this._lastY = (touch || evt).clientY;
      dragEl.style["will-change"] = "all";
      dragStartFn = function dragStartFn2() {
        pluginEvent("delayEnded", _this, {
          evt
        });
        if (Sortable.eventCanceled) {
          _this._onDrop();
          return;
        }
        _this._disableDelayedDragEvents();
        if (!FireFox && _this.nativeDraggable) {
          dragEl.draggable = true;
        }
        _this._triggerDragStart(evt, touch);
        _dispatchEvent({
          sortable: _this,
          name: "choose",
          originalEvent: evt
        });
        toggleClass(dragEl, options.chosenClass, true);
      };
      options.ignore.split(",").forEach(function(criteria) {
        find(dragEl, criteria.trim(), _disableDraggable);
      });
      on(ownerDocument, "dragover", nearestEmptyInsertDetectEvent);
      on(ownerDocument, "mousemove", nearestEmptyInsertDetectEvent);
      on(ownerDocument, "touchmove", nearestEmptyInsertDetectEvent);
      on(ownerDocument, "mouseup", _this._onDrop);
      on(ownerDocument, "touchend", _this._onDrop);
      on(ownerDocument, "touchcancel", _this._onDrop);
      if (FireFox && this.nativeDraggable) {
        this.options.touchStartThreshold = 4;
        dragEl.draggable = true;
      }
      pluginEvent("delayStart", this, {
        evt
      });
      if (options.delay && (!options.delayOnTouchOnly || touch) && (!this.nativeDraggable || !(Edge || IE11OrLess))) {
        if (Sortable.eventCanceled) {
          this._onDrop();
          return;
        }
        on(ownerDocument, "mouseup", _this._disableDelayedDrag);
        on(ownerDocument, "touchend", _this._disableDelayedDrag);
        on(ownerDocument, "touchcancel", _this._disableDelayedDrag);
        on(ownerDocument, "mousemove", _this._delayedDragTouchMoveHandler);
        on(ownerDocument, "touchmove", _this._delayedDragTouchMoveHandler);
        options.supportPointer && on(ownerDocument, "pointermove", _this._delayedDragTouchMoveHandler);
        _this._dragStartTimer = setTimeout(dragStartFn, options.delay);
      } else {
        dragStartFn();
      }
    }
  },
  _delayedDragTouchMoveHandler: function _delayedDragTouchMoveHandler(e) {
    var touch = e.touches ? e.touches[0] : e;
    if (Math.max(Math.abs(touch.clientX - this._lastX), Math.abs(touch.clientY - this._lastY)) >= Math.floor(this.options.touchStartThreshold / (this.nativeDraggable && window.devicePixelRatio || 1))) {
      this._disableDelayedDrag();
    }
  },
  _disableDelayedDrag: function _disableDelayedDrag() {
    dragEl && _disableDraggable(dragEl);
    clearTimeout(this._dragStartTimer);
    this._disableDelayedDragEvents();
  },
  _disableDelayedDragEvents: function _disableDelayedDragEvents() {
    var ownerDocument = this.el.ownerDocument;
    off(ownerDocument, "mouseup", this._disableDelayedDrag);
    off(ownerDocument, "touchend", this._disableDelayedDrag);
    off(ownerDocument, "touchcancel", this._disableDelayedDrag);
    off(ownerDocument, "mousemove", this._delayedDragTouchMoveHandler);
    off(ownerDocument, "touchmove", this._delayedDragTouchMoveHandler);
    off(ownerDocument, "pointermove", this._delayedDragTouchMoveHandler);
  },
  _triggerDragStart: function _triggerDragStart(evt, touch) {
    touch = touch || evt.pointerType == "touch" && evt;
    if (!this.nativeDraggable || touch) {
      if (this.options.supportPointer) {
        on(document, "pointermove", this._onTouchMove);
      } else if (touch) {
        on(document, "touchmove", this._onTouchMove);
      } else {
        on(document, "mousemove", this._onTouchMove);
      }
    } else {
      on(dragEl, "dragend", this);
      on(rootEl, "dragstart", this._onDragStart);
    }
    try {
      if (document.selection) {
        _nextTick(function() {
          document.selection.empty();
        });
      } else {
        window.getSelection().removeAllRanges();
      }
    } catch (err) {
    }
  },
  _dragStarted: function _dragStarted(fallback, evt) {
    awaitingDragStarted = false;
    if (rootEl && dragEl) {
      pluginEvent("dragStarted", this, {
        evt
      });
      if (this.nativeDraggable) {
        on(document, "dragover", _checkOutsideTargetEl);
      }
      var options = this.options;
      !fallback && toggleClass(dragEl, options.dragClass, false);
      toggleClass(dragEl, options.ghostClass, true);
      Sortable.active = this;
      fallback && this._appendGhost();
      _dispatchEvent({
        sortable: this,
        name: "start",
        originalEvent: evt
      });
    } else {
      this._nulling();
    }
  },
  _emulateDragOver: function _emulateDragOver() {
    if (touchEvt) {
      this._lastX = touchEvt.clientX;
      this._lastY = touchEvt.clientY;
      _hideGhostForTarget();
      var target = document.elementFromPoint(touchEvt.clientX, touchEvt.clientY);
      var parent2 = target;
      while (target && target.shadowRoot) {
        target = target.shadowRoot.elementFromPoint(touchEvt.clientX, touchEvt.clientY);
        if (target === parent2)
          break;
        parent2 = target;
      }
      dragEl.parentNode[expando]._isOutsideThisEl(target);
      if (parent2) {
        do {
          if (parent2[expando]) {
            var inserted = void 0;
            inserted = parent2[expando]._onDragOver({
              clientX: touchEvt.clientX,
              clientY: touchEvt.clientY,
              target,
              rootEl: parent2
            });
            if (inserted && !this.options.dragoverBubble) {
              break;
            }
          }
          target = parent2;
        } while (parent2 = parent2.parentNode);
      }
      _unhideGhostForTarget();
    }
  },
  _onTouchMove: function _onTouchMove(evt) {
    if (tapEvt) {
      var options = this.options, fallbackTolerance = options.fallbackTolerance, fallbackOffset = options.fallbackOffset, touch = evt.touches ? evt.touches[0] : evt, ghostMatrix = ghostEl && matrix(ghostEl, true), scaleX = ghostEl && ghostMatrix && ghostMatrix.a, scaleY = ghostEl && ghostMatrix && ghostMatrix.d, relativeScrollOffset = PositionGhostAbsolutely && ghostRelativeParent && getRelativeScrollOffset(ghostRelativeParent), dx = (touch.clientX - tapEvt.clientX + fallbackOffset.x) / (scaleX || 1) + (relativeScrollOffset ? relativeScrollOffset[0] - ghostRelativeParentInitialScroll[0] : 0) / (scaleX || 1), dy = (touch.clientY - tapEvt.clientY + fallbackOffset.y) / (scaleY || 1) + (relativeScrollOffset ? relativeScrollOffset[1] - ghostRelativeParentInitialScroll[1] : 0) / (scaleY || 1);
      if (!Sortable.active && !awaitingDragStarted) {
        if (fallbackTolerance && Math.max(Math.abs(touch.clientX - this._lastX), Math.abs(touch.clientY - this._lastY)) < fallbackTolerance) {
          return;
        }
        this._onDragStart(evt, true);
      }
      if (ghostEl) {
        if (ghostMatrix) {
          ghostMatrix.e += dx - (lastDx || 0);
          ghostMatrix.f += dy - (lastDy || 0);
        } else {
          ghostMatrix = {
            a: 1,
            b: 0,
            c: 0,
            d: 1,
            e: dx,
            f: dy
          };
        }
        var cssMatrix = "matrix(".concat(ghostMatrix.a, ",").concat(ghostMatrix.b, ",").concat(ghostMatrix.c, ",").concat(ghostMatrix.d, ",").concat(ghostMatrix.e, ",").concat(ghostMatrix.f, ")");
        css(ghostEl, "webkitTransform", cssMatrix);
        css(ghostEl, "mozTransform", cssMatrix);
        css(ghostEl, "msTransform", cssMatrix);
        css(ghostEl, "transform", cssMatrix);
        lastDx = dx;
        lastDy = dy;
        touchEvt = touch;
      }
      evt.cancelable && evt.preventDefault();
    }
  },
  _appendGhost: function _appendGhost() {
    if (!ghostEl) {
      var container = this.options.fallbackOnBody ? document.body : rootEl, rect = getRect(dragEl, true, PositionGhostAbsolutely, true, container), options = this.options;
      if (PositionGhostAbsolutely) {
        ghostRelativeParent = container;
        while (css(ghostRelativeParent, "position") === "static" && css(ghostRelativeParent, "transform") === "none" && ghostRelativeParent !== document) {
          ghostRelativeParent = ghostRelativeParent.parentNode;
        }
        if (ghostRelativeParent !== document.body && ghostRelativeParent !== document.documentElement) {
          if (ghostRelativeParent === document)
            ghostRelativeParent = getWindowScrollingElement();
          rect.top += ghostRelativeParent.scrollTop;
          rect.left += ghostRelativeParent.scrollLeft;
        } else {
          ghostRelativeParent = getWindowScrollingElement();
        }
        ghostRelativeParentInitialScroll = getRelativeScrollOffset(ghostRelativeParent);
      }
      ghostEl = dragEl.cloneNode(true);
      toggleClass(ghostEl, options.ghostClass, false);
      toggleClass(ghostEl, options.fallbackClass, true);
      toggleClass(ghostEl, options.dragClass, true);
      css(ghostEl, "transition", "");
      css(ghostEl, "transform", "");
      css(ghostEl, "box-sizing", "border-box");
      css(ghostEl, "margin", 0);
      css(ghostEl, "top", rect.top);
      css(ghostEl, "left", rect.left);
      css(ghostEl, "width", rect.width);
      css(ghostEl, "height", rect.height);
      css(ghostEl, "opacity", "0.8");
      css(ghostEl, "position", PositionGhostAbsolutely ? "absolute" : "fixed");
      css(ghostEl, "zIndex", "100000");
      css(ghostEl, "pointerEvents", "none");
      Sortable.ghost = ghostEl;
      container.appendChild(ghostEl);
      css(ghostEl, "transform-origin", tapDistanceLeft / parseInt(ghostEl.style.width) * 100 + "% " + tapDistanceTop / parseInt(ghostEl.style.height) * 100 + "%");
    }
  },
  _onDragStart: function _onDragStart(evt, fallback) {
    var _this = this;
    var dataTransfer = evt.dataTransfer;
    var options = _this.options;
    pluginEvent("dragStart", this, {
      evt
    });
    if (Sortable.eventCanceled) {
      this._onDrop();
      return;
    }
    pluginEvent("setupClone", this);
    if (!Sortable.eventCanceled) {
      cloneEl = clone(dragEl);
      cloneEl.removeAttribute("id");
      cloneEl.draggable = false;
      cloneEl.style["will-change"] = "";
      this._hideClone();
      toggleClass(cloneEl, this.options.chosenClass, false);
      Sortable.clone = cloneEl;
    }
    _this.cloneId = _nextTick(function() {
      pluginEvent("clone", _this);
      if (Sortable.eventCanceled)
        return;
      if (!_this.options.removeCloneOnHide) {
        rootEl.insertBefore(cloneEl, dragEl);
      }
      _this._hideClone();
      _dispatchEvent({
        sortable: _this,
        name: "clone"
      });
    });
    !fallback && toggleClass(dragEl, options.dragClass, true);
    if (fallback) {
      ignoreNextClick = true;
      _this._loopId = setInterval(_this._emulateDragOver, 50);
    } else {
      off(document, "mouseup", _this._onDrop);
      off(document, "touchend", _this._onDrop);
      off(document, "touchcancel", _this._onDrop);
      if (dataTransfer) {
        dataTransfer.effectAllowed = "move";
        options.setData && options.setData.call(_this, dataTransfer, dragEl);
      }
      on(document, "drop", _this);
      css(dragEl, "transform", "translateZ(0)");
    }
    awaitingDragStarted = true;
    _this._dragStartId = _nextTick(_this._dragStarted.bind(_this, fallback, evt));
    on(document, "selectstart", _this);
    moved = true;
    if (Safari) {
      css(document.body, "user-select", "none");
    }
  },
  // Returns true - if no further action is needed (either inserted or another condition)
  _onDragOver: function _onDragOver(evt) {
    var el = this.el, target = evt.target, dragRect, targetRect, revert, options = this.options, group = options.group, activeSortable = Sortable.active, isOwner = activeGroup === group, canSort = options.sort, fromSortable = putSortable || activeSortable, vertical, _this = this, completedFired = false;
    if (_silent)
      return;
    function dragOverEvent(name, extra) {
      pluginEvent(name, _this, _objectSpread2({
        evt,
        isOwner,
        axis: vertical ? "vertical" : "horizontal",
        revert,
        dragRect,
        targetRect,
        canSort,
        fromSortable,
        target,
        completed,
        onMove: function onMove(target2, after2) {
          return _onMove(rootEl, el, dragEl, dragRect, target2, getRect(target2), evt, after2);
        },
        changed
      }, extra));
    }
    function capture() {
      dragOverEvent("dragOverAnimationCapture");
      _this.captureAnimationState();
      if (_this !== fromSortable) {
        fromSortable.captureAnimationState();
      }
    }
    function completed(insertion) {
      dragOverEvent("dragOverCompleted", {
        insertion
      });
      if (insertion) {
        if (isOwner) {
          activeSortable._hideClone();
        } else {
          activeSortable._showClone(_this);
        }
        if (_this !== fromSortable) {
          toggleClass(dragEl, putSortable ? putSortable.options.ghostClass : activeSortable.options.ghostClass, false);
          toggleClass(dragEl, options.ghostClass, true);
        }
        if (putSortable !== _this && _this !== Sortable.active) {
          putSortable = _this;
        } else if (_this === Sortable.active && putSortable) {
          putSortable = null;
        }
        if (fromSortable === _this) {
          _this._ignoreWhileAnimating = target;
        }
        _this.animateAll(function() {
          dragOverEvent("dragOverAnimationComplete");
          _this._ignoreWhileAnimating = null;
        });
        if (_this !== fromSortable) {
          fromSortable.animateAll();
          fromSortable._ignoreWhileAnimating = null;
        }
      }
      if (target === dragEl && !dragEl.animated || target === el && !target.animated) {
        lastTarget = null;
      }
      if (!options.dragoverBubble && !evt.rootEl && target !== document) {
        dragEl.parentNode[expando]._isOutsideThisEl(evt.target);
        !insertion && nearestEmptyInsertDetectEvent(evt);
      }
      !options.dragoverBubble && evt.stopPropagation && evt.stopPropagation();
      return completedFired = true;
    }
    function changed() {
      newIndex = index(dragEl);
      newDraggableIndex = index(dragEl, options.draggable);
      _dispatchEvent({
        sortable: _this,
        name: "change",
        toEl: el,
        newIndex,
        newDraggableIndex,
        originalEvent: evt
      });
    }
    if (evt.preventDefault !== void 0) {
      evt.cancelable && evt.preventDefault();
    }
    target = closest(target, options.draggable, el, true);
    dragOverEvent("dragOver");
    if (Sortable.eventCanceled)
      return completedFired;
    if (dragEl.contains(evt.target) || target.animated && target.animatingX && target.animatingY || _this._ignoreWhileAnimating === target) {
      return completed(false);
    }
    ignoreNextClick = false;
    if (activeSortable && !options.disabled && (isOwner ? canSort || (revert = parentEl !== rootEl) : putSortable === this || (this.lastPutMode = activeGroup.checkPull(this, activeSortable, dragEl, evt)) && group.checkPut(this, activeSortable, dragEl, evt))) {
      vertical = this._getDirection(evt, target) === "vertical";
      dragRect = getRect(dragEl);
      dragOverEvent("dragOverValid");
      if (Sortable.eventCanceled)
        return completedFired;
      if (revert) {
        parentEl = rootEl;
        capture();
        this._hideClone();
        dragOverEvent("revert");
        if (!Sortable.eventCanceled) {
          if (nextEl) {
            rootEl.insertBefore(dragEl, nextEl);
          } else {
            rootEl.appendChild(dragEl);
          }
        }
        return completed(true);
      }
      var elLastChild = lastChild(el, options.draggable);
      if (!elLastChild || _ghostIsLast(evt, vertical, this) && !elLastChild.animated) {
        if (elLastChild === dragEl) {
          return completed(false);
        }
        if (elLastChild && el === evt.target) {
          target = elLastChild;
        }
        if (target) {
          targetRect = getRect(target);
        }
        if (_onMove(rootEl, el, dragEl, dragRect, target, targetRect, evt, !!target) !== false) {
          capture();
          if (elLastChild && elLastChild.nextSibling) {
            el.insertBefore(dragEl, elLastChild.nextSibling);
          } else {
            el.appendChild(dragEl);
          }
          parentEl = el;
          changed();
          return completed(true);
        }
      } else if (elLastChild && _ghostIsFirst(evt, vertical, this)) {
        var firstChild = getChild(el, 0, options, true);
        if (firstChild === dragEl) {
          return completed(false);
        }
        target = firstChild;
        targetRect = getRect(target);
        if (_onMove(rootEl, el, dragEl, dragRect, target, targetRect, evt, false) !== false) {
          capture();
          el.insertBefore(dragEl, firstChild);
          parentEl = el;
          changed();
          return completed(true);
        }
      } else if (target.parentNode === el) {
        targetRect = getRect(target);
        var direction = 0, targetBeforeFirstSwap, differentLevel = dragEl.parentNode !== el, differentRowCol = !_dragElInRowColumn(dragEl.animated && dragEl.toRect || dragRect, target.animated && target.toRect || targetRect, vertical), side1 = vertical ? "top" : "left", scrolledPastTop = isScrolledPast(target, "top", "top") || isScrolledPast(dragEl, "top", "top"), scrollBefore = scrolledPastTop ? scrolledPastTop.scrollTop : void 0;
        if (lastTarget !== target) {
          targetBeforeFirstSwap = targetRect[side1];
          pastFirstInvertThresh = false;
          isCircumstantialInvert = !differentRowCol && options.invertSwap || differentLevel;
        }
        direction = _getSwapDirection(evt, target, targetRect, vertical, differentRowCol ? 1 : options.swapThreshold, options.invertedSwapThreshold == null ? options.swapThreshold : options.invertedSwapThreshold, isCircumstantialInvert, lastTarget === target);
        var sibling;
        if (direction !== 0) {
          var dragIndex = index(dragEl);
          do {
            dragIndex -= direction;
            sibling = parentEl.children[dragIndex];
          } while (sibling && (css(sibling, "display") === "none" || sibling === ghostEl));
        }
        if (direction === 0 || sibling === target) {
          return completed(false);
        }
        lastTarget = target;
        lastDirection = direction;
        var nextSibling = target.nextElementSibling, after = false;
        after = direction === 1;
        var moveVector = _onMove(rootEl, el, dragEl, dragRect, target, targetRect, evt, after);
        if (moveVector !== false) {
          if (moveVector === 1 || moveVector === -1) {
            after = moveVector === 1;
          }
          _silent = true;
          setTimeout(_unsilent, 30);
          capture();
          if (after && !nextSibling) {
            el.appendChild(dragEl);
          } else {
            target.parentNode.insertBefore(dragEl, after ? nextSibling : target);
          }
          if (scrolledPastTop) {
            scrollBy(scrolledPastTop, 0, scrollBefore - scrolledPastTop.scrollTop);
          }
          parentEl = dragEl.parentNode;
          if (targetBeforeFirstSwap !== void 0 && !isCircumstantialInvert) {
            targetMoveDistance = Math.abs(targetBeforeFirstSwap - getRect(target)[side1]);
          }
          changed();
          return completed(true);
        }
      }
      if (el.contains(dragEl)) {
        return completed(false);
      }
    }
    return false;
  },
  _ignoreWhileAnimating: null,
  _offMoveEvents: function _offMoveEvents() {
    off(document, "mousemove", this._onTouchMove);
    off(document, "touchmove", this._onTouchMove);
    off(document, "pointermove", this._onTouchMove);
    off(document, "dragover", nearestEmptyInsertDetectEvent);
    off(document, "mousemove", nearestEmptyInsertDetectEvent);
    off(document, "touchmove", nearestEmptyInsertDetectEvent);
  },
  _offUpEvents: function _offUpEvents() {
    var ownerDocument = this.el.ownerDocument;
    off(ownerDocument, "mouseup", this._onDrop);
    off(ownerDocument, "touchend", this._onDrop);
    off(ownerDocument, "pointerup", this._onDrop);
    off(ownerDocument, "touchcancel", this._onDrop);
    off(document, "selectstart", this);
  },
  _onDrop: function _onDrop(evt) {
    var el = this.el, options = this.options;
    newIndex = index(dragEl);
    newDraggableIndex = index(dragEl, options.draggable);
    pluginEvent("drop", this, {
      evt
    });
    parentEl = dragEl && dragEl.parentNode;
    newIndex = index(dragEl);
    newDraggableIndex = index(dragEl, options.draggable);
    if (Sortable.eventCanceled) {
      this._nulling();
      return;
    }
    awaitingDragStarted = false;
    isCircumstantialInvert = false;
    pastFirstInvertThresh = false;
    clearInterval(this._loopId);
    clearTimeout(this._dragStartTimer);
    _cancelNextTick(this.cloneId);
    _cancelNextTick(this._dragStartId);
    if (this.nativeDraggable) {
      off(document, "drop", this);
      off(el, "dragstart", this._onDragStart);
    }
    this._offMoveEvents();
    this._offUpEvents();
    if (Safari) {
      css(document.body, "user-select", "");
    }
    css(dragEl, "transform", "");
    if (evt) {
      if (moved) {
        evt.cancelable && evt.preventDefault();
        !options.dropBubble && evt.stopPropagation();
      }
      ghostEl && ghostEl.parentNode && ghostEl.parentNode.removeChild(ghostEl);
      if (rootEl === parentEl || putSortable && putSortable.lastPutMode !== "clone") {
        cloneEl && cloneEl.parentNode && cloneEl.parentNode.removeChild(cloneEl);
      }
      if (dragEl) {
        if (this.nativeDraggable) {
          off(dragEl, "dragend", this);
        }
        _disableDraggable(dragEl);
        dragEl.style["will-change"] = "";
        if (moved && !awaitingDragStarted) {
          toggleClass(dragEl, putSortable ? putSortable.options.ghostClass : this.options.ghostClass, false);
        }
        toggleClass(dragEl, this.options.chosenClass, false);
        _dispatchEvent({
          sortable: this,
          name: "unchoose",
          toEl: parentEl,
          newIndex: null,
          newDraggableIndex: null,
          originalEvent: evt
        });
        if (rootEl !== parentEl) {
          if (newIndex >= 0) {
            _dispatchEvent({
              rootEl: parentEl,
              name: "add",
              toEl: parentEl,
              fromEl: rootEl,
              originalEvent: evt
            });
            _dispatchEvent({
              sortable: this,
              name: "remove",
              toEl: parentEl,
              originalEvent: evt
            });
            _dispatchEvent({
              rootEl: parentEl,
              name: "sort",
              toEl: parentEl,
              fromEl: rootEl,
              originalEvent: evt
            });
            _dispatchEvent({
              sortable: this,
              name: "sort",
              toEl: parentEl,
              originalEvent: evt
            });
          }
          putSortable && putSortable.save();
        } else {
          if (newIndex !== oldIndex) {
            if (newIndex >= 0) {
              _dispatchEvent({
                sortable: this,
                name: "update",
                toEl: parentEl,
                originalEvent: evt
              });
              _dispatchEvent({
                sortable: this,
                name: "sort",
                toEl: parentEl,
                originalEvent: evt
              });
            }
          }
        }
        if (Sortable.active) {
          if (newIndex == null || newIndex === -1) {
            newIndex = oldIndex;
            newDraggableIndex = oldDraggableIndex;
          }
          _dispatchEvent({
            sortable: this,
            name: "end",
            toEl: parentEl,
            originalEvent: evt
          });
          this.save();
        }
      }
    }
    this._nulling();
  },
  _nulling: function _nulling() {
    pluginEvent("nulling", this);
    rootEl = dragEl = parentEl = ghostEl = nextEl = cloneEl = lastDownEl = cloneHidden = tapEvt = touchEvt = moved = newIndex = newDraggableIndex = oldIndex = oldDraggableIndex = lastTarget = lastDirection = putSortable = activeGroup = Sortable.dragged = Sortable.ghost = Sortable.clone = Sortable.active = null;
    savedInputChecked.forEach(function(el) {
      el.checked = true;
    });
    savedInputChecked.length = lastDx = lastDy = 0;
  },
  handleEvent: function handleEvent2(evt) {
    switch (evt.type) {
      case "drop":
      case "dragend":
        this._onDrop(evt);
        break;
      case "dragenter":
      case "dragover":
        if (dragEl) {
          this._onDragOver(evt);
          _globalDragOver(evt);
        }
        break;
      case "selectstart":
        evt.preventDefault();
        break;
    }
  },
  /**
   * Serializes the item into an array of string.
   * @returns {String[]}
   */
  toArray: function toArray() {
    var order = [], el, children = this.el.children, i = 0, n = children.length, options = this.options;
    for (; i < n; i++) {
      el = children[i];
      if (closest(el, options.draggable, this.el, false)) {
        order.push(el.getAttribute(options.dataIdAttr) || _generateId(el));
      }
    }
    return order;
  },
  /**
   * Sorts the elements according to the array.
   * @param  {String[]}  order  order of the items
   */
  sort: function sort(order, useAnimation) {
    var items = {}, rootEl2 = this.el;
    this.toArray().forEach(function(id, i) {
      var el = rootEl2.children[i];
      if (closest(el, this.options.draggable, rootEl2, false)) {
        items[id] = el;
      }
    }, this);
    useAnimation && this.captureAnimationState();
    order.forEach(function(id) {
      if (items[id]) {
        rootEl2.removeChild(items[id]);
        rootEl2.appendChild(items[id]);
      }
    });
    useAnimation && this.animateAll();
  },
  /**
   * Save the current sorting
   */
  save: function save() {
    var store = this.options.store;
    store && store.set && store.set(this);
  },
  /**
   * For each element in the set, get the first element that matches the selector by testing the element itself and traversing up through its ancestors in the DOM tree.
   * @param   {HTMLElement}  el
   * @param   {String}       [selector]  default: `options.draggable`
   * @returns {HTMLElement|null}
   */
  closest: function closest$1(el, selector) {
    return closest(el, selector || this.options.draggable, this.el, false);
  },
  /**
   * Set/get option
   * @param   {string} name
   * @param   {*}      [value]
   * @returns {*}
   */
  option: function option(name, value) {
    var options = this.options;
    if (value === void 0) {
      return options[name];
    } else {
      var modifiedValue = PluginManager.modifyOption(this, name, value);
      if (typeof modifiedValue !== "undefined") {
        options[name] = modifiedValue;
      } else {
        options[name] = value;
      }
      if (name === "group") {
        _prepareGroup(options);
      }
    }
  },
  /**
   * Destroy
   */
  destroy: function destroy2() {
    pluginEvent("destroy", this);
    if (!this.el) {
      return;
    }
    var el = this.el;
    el[expando] = null;
    off(el, "mousedown", this._onTapStart);
    off(el, "touchstart", this._onTapStart);
    off(el, "pointerdown", this._onTapStart);
    if (this.nativeDraggable) {
      off(el, "dragover", this);
      off(el, "dragenter", this);
    }
    Array.prototype.forEach.call(el.querySelectorAll("[draggable]"), function(el2) {
      el2.removeAttribute("draggable");
    });
    this._onDrop();
    this._disableDelayedDragEvents();
    if (documentExists && !ChromeForAndroid) {
      document.removeEventListener("click", _nochromeForAndroidClick, true);
    }
    sortables.splice(sortables.indexOf(this.el), 1);
    this.el = el = null;
  },
  _hideClone: function _hideClone() {
    if (!cloneHidden) {
      pluginEvent("hideClone", this);
      if (Sortable.eventCanceled)
        return;
      css(cloneEl, "display", "none");
      if (this.options.removeCloneOnHide && cloneEl.parentNode) {
        cloneEl.parentNode.removeChild(cloneEl);
      }
      cloneHidden = true;
    }
  },
  _showClone: function _showClone(putSortable2) {
    if (putSortable2.lastPutMode !== "clone") {
      this._hideClone();
      return;
    }
    if (cloneHidden) {
      pluginEvent("showClone", this);
      if (Sortable.eventCanceled)
        return;
      if (dragEl.parentNode == rootEl && !this.options.group.revertClone) {
        rootEl.insertBefore(cloneEl, dragEl);
      } else if (nextEl) {
        rootEl.insertBefore(cloneEl, nextEl);
      } else {
        rootEl.appendChild(cloneEl);
      }
      if (this.options.group.revertClone) {
        this.animate(dragEl, cloneEl);
      }
      css(cloneEl, "display", "");
      cloneHidden = false;
    }
  }
};
function _globalDragOver(evt) {
  if (evt.dataTransfer) {
    evt.dataTransfer.dropEffect = "move";
  }
  evt.cancelable && evt.preventDefault();
}
function _onMove(fromEl, toEl, dragEl2, dragRect, targetEl, targetRect, originalEvent, willInsertAfter) {
  var evt, sortable = fromEl[expando], onMoveFn = sortable.options.onMove, retVal;
  if (window.CustomEvent && !IE11OrLess && !Edge) {
    evt = new CustomEvent("move", {
      bubbles: true,
      cancelable: true
    });
  } else {
    evt = document.createEvent("Event");
    evt.initEvent("move", true, true);
  }
  evt.to = toEl;
  evt.from = fromEl;
  evt.dragged = dragEl2;
  evt.draggedRect = dragRect;
  evt.related = targetEl || toEl;
  evt.relatedRect = targetRect || getRect(toEl);
  evt.willInsertAfter = willInsertAfter;
  evt.originalEvent = originalEvent;
  fromEl.dispatchEvent(evt);
  if (onMoveFn) {
    retVal = onMoveFn.call(sortable, evt, originalEvent);
  }
  return retVal;
}
function _disableDraggable(el) {
  el.draggable = false;
}
function _unsilent() {
  _silent = false;
}
function _ghostIsFirst(evt, vertical, sortable) {
  var rect = getRect(getChild(sortable.el, 0, sortable.options, true));
  var spacer = 10;
  return vertical ? evt.clientX < rect.left - spacer || evt.clientY < rect.top && evt.clientX < rect.right : evt.clientY < rect.top - spacer || evt.clientY < rect.bottom && evt.clientX < rect.left;
}
function _ghostIsLast(evt, vertical, sortable) {
  var rect = getRect(lastChild(sortable.el, sortable.options.draggable));
  var spacer = 10;
  return vertical ? evt.clientX > rect.right + spacer || evt.clientX <= rect.right && evt.clientY > rect.bottom && evt.clientX >= rect.left : evt.clientX > rect.right && evt.clientY > rect.top || evt.clientX <= rect.right && evt.clientY > rect.bottom + spacer;
}
function _getSwapDirection(evt, target, targetRect, vertical, swapThreshold, invertedSwapThreshold, invertSwap, isLastTarget) {
  var mouseOnAxis = vertical ? evt.clientY : evt.clientX, targetLength = vertical ? targetRect.height : targetRect.width, targetS1 = vertical ? targetRect.top : targetRect.left, targetS2 = vertical ? targetRect.bottom : targetRect.right, invert = false;
  if (!invertSwap) {
    if (isLastTarget && targetMoveDistance < targetLength * swapThreshold) {
      if (!pastFirstInvertThresh && (lastDirection === 1 ? mouseOnAxis > targetS1 + targetLength * invertedSwapThreshold / 2 : mouseOnAxis < targetS2 - targetLength * invertedSwapThreshold / 2)) {
        pastFirstInvertThresh = true;
      }
      if (!pastFirstInvertThresh) {
        if (lastDirection === 1 ? mouseOnAxis < targetS1 + targetMoveDistance : mouseOnAxis > targetS2 - targetMoveDistance) {
          return -lastDirection;
        }
      } else {
        invert = true;
      }
    } else {
      if (mouseOnAxis > targetS1 + targetLength * (1 - swapThreshold) / 2 && mouseOnAxis < targetS2 - targetLength * (1 - swapThreshold) / 2) {
        return _getInsertDirection(target);
      }
    }
  }
  invert = invert || invertSwap;
  if (invert) {
    if (mouseOnAxis < targetS1 + targetLength * invertedSwapThreshold / 2 || mouseOnAxis > targetS2 - targetLength * invertedSwapThreshold / 2) {
      return mouseOnAxis > targetS1 + targetLength / 2 ? 1 : -1;
    }
  }
  return 0;
}
function _getInsertDirection(target) {
  if (index(dragEl) < index(target)) {
    return 1;
  } else {
    return -1;
  }
}
function _generateId(el) {
  var str = el.tagName + el.className + el.src + el.href + el.textContent, i = str.length, sum2 = 0;
  while (i--) {
    sum2 += str.charCodeAt(i);
  }
  return sum2.toString(36);
}
function _saveInputCheckedState(root) {
  savedInputChecked.length = 0;
  var inputs = root.getElementsByTagName("input");
  var idx = inputs.length;
  while (idx--) {
    var el = inputs[idx];
    el.checked && savedInputChecked.push(el);
  }
}
function _nextTick(fn) {
  return setTimeout(fn, 0);
}
function _cancelNextTick(id) {
  return clearTimeout(id);
}
Sortable.utils = {
  on,
  off,
  css,
  find,
  is: function is(el, selector) {
    return !!closest(el, selector, el, false);
  },
  extend,
  throttle,
  closest,
  toggleClass,
  clone,
  index,
  nextTick: _nextTick,
  cancelNextTick: _cancelNextTick,
  detectDirection: _detectDirection,
  getChild
};
Sortable.get = function(element) {
  return element[expando];
};
Sortable.mount = function() {
  for (var _len = arguments.length, plugins2 = new Array(_len), _key = 0; _key < _len; _key++) {
    plugins2[_key] = arguments[_key];
  }
  if (plugins2[0].constructor === Array)
    plugins2 = plugins2[0];
  plugins2.forEach(function(plugin) {
    if (!plugin.prototype || !plugin.prototype.constructor) {
      throw "Sortable: Mounted plugin must be a constructor function, not ".concat({}.toString.call(plugin));
    }
    if (plugin.utils)
      Sortable.utils = _objectSpread2(_objectSpread2({}, Sortable.utils), plugin.utils);
    PluginManager.mount(plugin);
  });
};
Sortable.create = function(el, options) {
  return new Sortable(el, options);
};
Sortable.version = version;
var autoScrolls = [], scrollEl, scrollRootEl, scrolling = false, lastAutoScrollX, lastAutoScrollY, touchEvt$1, pointerElemChangedInterval;
function AutoScrollPlugin() {
  function AutoScroll() {
    this.defaults = {
      scroll: true,
      forceAutoScrollFallback: false,
      scrollSensitivity: 30,
      scrollSpeed: 10,
      bubbleScroll: true
    };
    for (var fn in this) {
      if (fn.charAt(0) === "_" && typeof this[fn] === "function") {
        this[fn] = this[fn].bind(this);
      }
    }
  }
  AutoScroll.prototype = {
    dragStarted: function dragStarted2(_ref) {
      var originalEvent = _ref.originalEvent;
      if (this.sortable.nativeDraggable) {
        on(document, "dragover", this._handleAutoScroll);
      } else {
        if (this.options.supportPointer) {
          on(document, "pointermove", this._handleFallbackAutoScroll);
        } else if (originalEvent.touches) {
          on(document, "touchmove", this._handleFallbackAutoScroll);
        } else {
          on(document, "mousemove", this._handleFallbackAutoScroll);
        }
      }
    },
    dragOverCompleted: function dragOverCompleted(_ref2) {
      var originalEvent = _ref2.originalEvent;
      if (!this.options.dragOverBubble && !originalEvent.rootEl) {
        this._handleAutoScroll(originalEvent);
      }
    },
    drop: function drop3() {
      if (this.sortable.nativeDraggable) {
        off(document, "dragover", this._handleAutoScroll);
      } else {
        off(document, "pointermove", this._handleFallbackAutoScroll);
        off(document, "touchmove", this._handleFallbackAutoScroll);
        off(document, "mousemove", this._handleFallbackAutoScroll);
      }
      clearPointerElemChangedInterval();
      clearAutoScrolls();
      cancelThrottle();
    },
    nulling: function nulling() {
      touchEvt$1 = scrollRootEl = scrollEl = scrolling = pointerElemChangedInterval = lastAutoScrollX = lastAutoScrollY = null;
      autoScrolls.length = 0;
    },
    _handleFallbackAutoScroll: function _handleFallbackAutoScroll(evt) {
      this._handleAutoScroll(evt, true);
    },
    _handleAutoScroll: function _handleAutoScroll(evt, fallback) {
      var _this = this;
      var x = (evt.touches ? evt.touches[0] : evt).clientX, y = (evt.touches ? evt.touches[0] : evt).clientY, elem = document.elementFromPoint(x, y);
      touchEvt$1 = evt;
      if (fallback || this.options.forceAutoScrollFallback || Edge || IE11OrLess || Safari) {
        autoScroll(evt, this.options, elem, fallback);
        var ogElemScroller = getParentAutoScrollElement(elem, true);
        if (scrolling && (!pointerElemChangedInterval || x !== lastAutoScrollX || y !== lastAutoScrollY)) {
          pointerElemChangedInterval && clearPointerElemChangedInterval();
          pointerElemChangedInterval = setInterval(function() {
            var newElem = getParentAutoScrollElement(document.elementFromPoint(x, y), true);
            if (newElem !== ogElemScroller) {
              ogElemScroller = newElem;
              clearAutoScrolls();
            }
            autoScroll(evt, _this.options, newElem, fallback);
          }, 10);
          lastAutoScrollX = x;
          lastAutoScrollY = y;
        }
      } else {
        if (!this.options.bubbleScroll || getParentAutoScrollElement(elem, true) === getWindowScrollingElement()) {
          clearAutoScrolls();
          return;
        }
        autoScroll(evt, this.options, getParentAutoScrollElement(elem, false), false);
      }
    }
  };
  return _extends(AutoScroll, {
    pluginName: "scroll",
    initializeByDefault: true
  });
}
function clearAutoScrolls() {
  autoScrolls.forEach(function(autoScroll2) {
    clearInterval(autoScroll2.pid);
  });
  autoScrolls = [];
}
function clearPointerElemChangedInterval() {
  clearInterval(pointerElemChangedInterval);
}
var autoScroll = throttle(function(evt, options, rootEl2, isFallback) {
  if (!options.scroll)
    return;
  var x = (evt.touches ? evt.touches[0] : evt).clientX, y = (evt.touches ? evt.touches[0] : evt).clientY, sens = options.scrollSensitivity, speed = options.scrollSpeed, winScroller = getWindowScrollingElement();
  var scrollThisInstance = false, scrollCustomFn;
  if (scrollRootEl !== rootEl2) {
    scrollRootEl = rootEl2;
    clearAutoScrolls();
    scrollEl = options.scroll;
    scrollCustomFn = options.scrollFn;
    if (scrollEl === true) {
      scrollEl = getParentAutoScrollElement(rootEl2, true);
    }
  }
  var layersOut = 0;
  var currentParent = scrollEl;
  do {
    var el = currentParent, rect = getRect(el), top = rect.top, bottom = rect.bottom, left = rect.left, right = rect.right, width = rect.width, height = rect.height, canScrollX = void 0, canScrollY = void 0, scrollWidth = el.scrollWidth, scrollHeight = el.scrollHeight, elCSS = css(el), scrollPosX = el.scrollLeft, scrollPosY = el.scrollTop;
    if (el === winScroller) {
      canScrollX = width < scrollWidth && (elCSS.overflowX === "auto" || elCSS.overflowX === "scroll" || elCSS.overflowX === "visible");
      canScrollY = height < scrollHeight && (elCSS.overflowY === "auto" || elCSS.overflowY === "scroll" || elCSS.overflowY === "visible");
    } else {
      canScrollX = width < scrollWidth && (elCSS.overflowX === "auto" || elCSS.overflowX === "scroll");
      canScrollY = height < scrollHeight && (elCSS.overflowY === "auto" || elCSS.overflowY === "scroll");
    }
    var vx = canScrollX && (Math.abs(right - x) <= sens && scrollPosX + width < scrollWidth) - (Math.abs(left - x) <= sens && !!scrollPosX);
    var vy = canScrollY && (Math.abs(bottom - y) <= sens && scrollPosY + height < scrollHeight) - (Math.abs(top - y) <= sens && !!scrollPosY);
    if (!autoScrolls[layersOut]) {
      for (var i = 0; i <= layersOut; i++) {
        if (!autoScrolls[i]) {
          autoScrolls[i] = {};
        }
      }
    }
    if (autoScrolls[layersOut].vx != vx || autoScrolls[layersOut].vy != vy || autoScrolls[layersOut].el !== el) {
      autoScrolls[layersOut].el = el;
      autoScrolls[layersOut].vx = vx;
      autoScrolls[layersOut].vy = vy;
      clearInterval(autoScrolls[layersOut].pid);
      if (vx != 0 || vy != 0) {
        scrollThisInstance = true;
        autoScrolls[layersOut].pid = setInterval((function() {
          if (isFallback && this.layer === 0) {
            Sortable.active._onTouchMove(touchEvt$1);
          }
          var scrollOffsetY = autoScrolls[this.layer].vy ? autoScrolls[this.layer].vy * speed : 0;
          var scrollOffsetX = autoScrolls[this.layer].vx ? autoScrolls[this.layer].vx * speed : 0;
          if (typeof scrollCustomFn === "function") {
            if (scrollCustomFn.call(Sortable.dragged.parentNode[expando], scrollOffsetX, scrollOffsetY, evt, touchEvt$1, autoScrolls[this.layer].el) !== "continue") {
              return;
            }
          }
          scrollBy(autoScrolls[this.layer].el, scrollOffsetX, scrollOffsetY);
        }).bind({
          layer: layersOut
        }), 24);
      }
    }
    layersOut++;
  } while (options.bubbleScroll && currentParent !== winScroller && (currentParent = getParentAutoScrollElement(currentParent, false)));
  scrolling = scrollThisInstance;
}, 30);
var drop = function drop2(_ref) {
  var originalEvent = _ref.originalEvent, putSortable2 = _ref.putSortable, dragEl2 = _ref.dragEl, activeSortable = _ref.activeSortable, dispatchSortableEvent = _ref.dispatchSortableEvent, hideGhostForTarget = _ref.hideGhostForTarget, unhideGhostForTarget = _ref.unhideGhostForTarget;
  if (!originalEvent)
    return;
  var toSortable = putSortable2 || activeSortable;
  hideGhostForTarget();
  var touch = originalEvent.changedTouches && originalEvent.changedTouches.length ? originalEvent.changedTouches[0] : originalEvent;
  var target = document.elementFromPoint(touch.clientX, touch.clientY);
  unhideGhostForTarget();
  if (toSortable && !toSortable.el.contains(target)) {
    dispatchSortableEvent("spill");
    this.onSpill({
      dragEl: dragEl2,
      putSortable: putSortable2
    });
  }
};
function Revert() {
}
Revert.prototype = {
  startIndex: null,
  dragStart: function dragStart(_ref2) {
    var oldDraggableIndex2 = _ref2.oldDraggableIndex;
    this.startIndex = oldDraggableIndex2;
  },
  onSpill: function onSpill(_ref3) {
    var dragEl2 = _ref3.dragEl, putSortable2 = _ref3.putSortable;
    this.sortable.captureAnimationState();
    if (putSortable2) {
      putSortable2.captureAnimationState();
    }
    var nextSibling = getChild(this.sortable.el, this.startIndex, this.options);
    if (nextSibling) {
      this.sortable.el.insertBefore(dragEl2, nextSibling);
    } else {
      this.sortable.el.appendChild(dragEl2);
    }
    this.sortable.animateAll();
    if (putSortable2) {
      putSortable2.animateAll();
    }
  },
  drop
};
_extends(Revert, {
  pluginName: "revertOnSpill"
});
function Remove() {
}
Remove.prototype = {
  onSpill: function onSpill2(_ref4) {
    var dragEl2 = _ref4.dragEl, putSortable2 = _ref4.putSortable;
    var parentSortable = putSortable2 || this.sortable;
    parentSortable.captureAnimationState();
    dragEl2.parentNode && dragEl2.parentNode.removeChild(dragEl2);
    parentSortable.animateAll();
  },
  drop
};
_extends(Remove, {
  pluginName: "removeOnSpill"
});
var lastSwapEl;
function SwapPlugin() {
  function Swap() {
    this.defaults = {
      swapClass: "sortable-swap-highlight"
    };
  }
  Swap.prototype = {
    dragStart: function dragStart2(_ref) {
      var dragEl2 = _ref.dragEl;
      lastSwapEl = dragEl2;
    },
    dragOverValid: function dragOverValid(_ref2) {
      var completed = _ref2.completed, target = _ref2.target, onMove = _ref2.onMove, activeSortable = _ref2.activeSortable, changed = _ref2.changed, cancel = _ref2.cancel;
      if (!activeSortable.options.swap)
        return;
      var el = this.sortable.el, options = this.options;
      if (target && target !== el) {
        var prevSwapEl = lastSwapEl;
        if (onMove(target) !== false) {
          toggleClass(target, options.swapClass, true);
          lastSwapEl = target;
        } else {
          lastSwapEl = null;
        }
        if (prevSwapEl && prevSwapEl !== lastSwapEl) {
          toggleClass(prevSwapEl, options.swapClass, false);
        }
      }
      changed();
      completed(true);
      cancel();
    },
    drop: function drop3(_ref3) {
      var activeSortable = _ref3.activeSortable, putSortable2 = _ref3.putSortable, dragEl2 = _ref3.dragEl;
      var toSortable = putSortable2 || this.sortable;
      var options = this.options;
      lastSwapEl && toggleClass(lastSwapEl, options.swapClass, false);
      if (lastSwapEl && (options.swap || putSortable2 && putSortable2.options.swap)) {
        if (dragEl2 !== lastSwapEl) {
          toSortable.captureAnimationState();
          if (toSortable !== activeSortable)
            activeSortable.captureAnimationState();
          swapNodes(dragEl2, lastSwapEl);
          toSortable.animateAll();
          if (toSortable !== activeSortable)
            activeSortable.animateAll();
        }
      }
    },
    nulling: function nulling() {
      lastSwapEl = null;
    }
  };
  return _extends(Swap, {
    pluginName: "swap",
    eventProperties: function eventProperties() {
      return {
        swapItem: lastSwapEl
      };
    }
  });
}
function swapNodes(n1, n2) {
  var p1 = n1.parentNode, p2 = n2.parentNode, i1, i2;
  if (!p1 || !p2 || p1.isEqualNode(n2) || p2.isEqualNode(n1))
    return;
  i1 = index(n1);
  i2 = index(n2);
  if (p1.isEqualNode(p2) && i1 < i2) {
    i2++;
  }
  p1.insertBefore(n2, p1.children[i1]);
  p2.insertBefore(n1, p2.children[i2]);
}
var multiDragElements = [], multiDragClones = [], lastMultiDragSelect, multiDragSortable, initialFolding = false, folding = false, dragStarted = false, dragEl$1, clonesFromRect, clonesHidden;
function MultiDragPlugin() {
  function MultiDrag(sortable) {
    for (var fn in this) {
      if (fn.charAt(0) === "_" && typeof this[fn] === "function") {
        this[fn] = this[fn].bind(this);
      }
    }
    if (!sortable.options.avoidImplicitDeselect) {
      if (sortable.options.supportPointer) {
        on(document, "pointerup", this._deselectMultiDrag);
      } else {
        on(document, "mouseup", this._deselectMultiDrag);
        on(document, "touchend", this._deselectMultiDrag);
      }
    }
    on(document, "keydown", this._checkKeyDown);
    on(document, "keyup", this._checkKeyUp);
    this.defaults = {
      selectedClass: "sortable-selected",
      multiDragKey: null,
      avoidImplicitDeselect: false,
      setData: function setData(dataTransfer, dragEl2) {
        var data2 = "";
        if (multiDragElements.length && multiDragSortable === sortable) {
          multiDragElements.forEach(function(multiDragElement, i) {
            data2 += (!i ? "" : ", ") + multiDragElement.textContent;
          });
        } else {
          data2 = dragEl2.textContent;
        }
        dataTransfer.setData("Text", data2);
      }
    };
  }
  MultiDrag.prototype = {
    multiDragKeyDown: false,
    isMultiDrag: false,
    delayStartGlobal: function delayStartGlobal(_ref) {
      var dragged = _ref.dragEl;
      dragEl$1 = dragged;
    },
    delayEnded: function delayEnded() {
      this.isMultiDrag = ~multiDragElements.indexOf(dragEl$1);
    },
    setupClone: function setupClone(_ref2) {
      var sortable = _ref2.sortable, cancel = _ref2.cancel;
      if (!this.isMultiDrag)
        return;
      for (var i = 0; i < multiDragElements.length; i++) {
        multiDragClones.push(clone(multiDragElements[i]));
        multiDragClones[i].sortableIndex = multiDragElements[i].sortableIndex;
        multiDragClones[i].draggable = false;
        multiDragClones[i].style["will-change"] = "";
        toggleClass(multiDragClones[i], this.options.selectedClass, false);
        multiDragElements[i] === dragEl$1 && toggleClass(multiDragClones[i], this.options.chosenClass, false);
      }
      sortable._hideClone();
      cancel();
    },
    clone: function clone2(_ref3) {
      var sortable = _ref3.sortable, rootEl2 = _ref3.rootEl, dispatchSortableEvent = _ref3.dispatchSortableEvent, cancel = _ref3.cancel;
      if (!this.isMultiDrag)
        return;
      if (!this.options.removeCloneOnHide) {
        if (multiDragElements.length && multiDragSortable === sortable) {
          insertMultiDragClones(true, rootEl2);
          dispatchSortableEvent("clone");
          cancel();
        }
      }
    },
    showClone: function showClone(_ref4) {
      var cloneNowShown = _ref4.cloneNowShown, rootEl2 = _ref4.rootEl, cancel = _ref4.cancel;
      if (!this.isMultiDrag)
        return;
      insertMultiDragClones(false, rootEl2);
      multiDragClones.forEach(function(clone2) {
        css(clone2, "display", "");
      });
      cloneNowShown();
      clonesHidden = false;
      cancel();
    },
    hideClone: function hideClone(_ref5) {
      var _this = this;
      _ref5.sortable;
      var cloneNowHidden = _ref5.cloneNowHidden, cancel = _ref5.cancel;
      if (!this.isMultiDrag)
        return;
      multiDragClones.forEach(function(clone2) {
        css(clone2, "display", "none");
        if (_this.options.removeCloneOnHide && clone2.parentNode) {
          clone2.parentNode.removeChild(clone2);
        }
      });
      cloneNowHidden();
      clonesHidden = true;
      cancel();
    },
    dragStartGlobal: function dragStartGlobal(_ref6) {
      _ref6.sortable;
      if (!this.isMultiDrag && multiDragSortable) {
        multiDragSortable.multiDrag._deselectMultiDrag();
      }
      multiDragElements.forEach(function(multiDragElement) {
        multiDragElement.sortableIndex = index(multiDragElement);
      });
      multiDragElements = multiDragElements.sort(function(a, b) {
        return a.sortableIndex - b.sortableIndex;
      });
      dragStarted = true;
    },
    dragStarted: function dragStarted2(_ref7) {
      var _this2 = this;
      var sortable = _ref7.sortable;
      if (!this.isMultiDrag)
        return;
      if (this.options.sort) {
        sortable.captureAnimationState();
        if (this.options.animation) {
          multiDragElements.forEach(function(multiDragElement) {
            if (multiDragElement === dragEl$1)
              return;
            css(multiDragElement, "position", "absolute");
          });
          var dragRect = getRect(dragEl$1, false, true, true);
          multiDragElements.forEach(function(multiDragElement) {
            if (multiDragElement === dragEl$1)
              return;
            setRect(multiDragElement, dragRect);
          });
          folding = true;
          initialFolding = true;
        }
      }
      sortable.animateAll(function() {
        folding = false;
        initialFolding = false;
        if (_this2.options.animation) {
          multiDragElements.forEach(function(multiDragElement) {
            unsetRect(multiDragElement);
          });
        }
        if (_this2.options.sort) {
          removeMultiDragElements();
        }
      });
    },
    dragOver: function dragOver(_ref8) {
      var target = _ref8.target, completed = _ref8.completed, cancel = _ref8.cancel;
      if (folding && ~multiDragElements.indexOf(target)) {
        completed(false);
        cancel();
      }
    },
    revert: function revert(_ref9) {
      var fromSortable = _ref9.fromSortable, rootEl2 = _ref9.rootEl, sortable = _ref9.sortable, dragRect = _ref9.dragRect;
      if (multiDragElements.length > 1) {
        multiDragElements.forEach(function(multiDragElement) {
          sortable.addAnimationState({
            target: multiDragElement,
            rect: folding ? getRect(multiDragElement) : dragRect
          });
          unsetRect(multiDragElement);
          multiDragElement.fromRect = dragRect;
          fromSortable.removeAnimationState(multiDragElement);
        });
        folding = false;
        insertMultiDragElements(!this.options.removeCloneOnHide, rootEl2);
      }
    },
    dragOverCompleted: function dragOverCompleted(_ref10) {
      var sortable = _ref10.sortable, isOwner = _ref10.isOwner, insertion = _ref10.insertion, activeSortable = _ref10.activeSortable, parentEl2 = _ref10.parentEl, putSortable2 = _ref10.putSortable;
      var options = this.options;
      if (insertion) {
        if (isOwner) {
          activeSortable._hideClone();
        }
        initialFolding = false;
        if (options.animation && multiDragElements.length > 1 && (folding || !isOwner && !activeSortable.options.sort && !putSortable2)) {
          var dragRectAbsolute = getRect(dragEl$1, false, true, true);
          multiDragElements.forEach(function(multiDragElement) {
            if (multiDragElement === dragEl$1)
              return;
            setRect(multiDragElement, dragRectAbsolute);
            parentEl2.appendChild(multiDragElement);
          });
          folding = true;
        }
        if (!isOwner) {
          if (!folding) {
            removeMultiDragElements();
          }
          if (multiDragElements.length > 1) {
            var clonesHiddenBefore = clonesHidden;
            activeSortable._showClone(sortable);
            if (activeSortable.options.animation && !clonesHidden && clonesHiddenBefore) {
              multiDragClones.forEach(function(clone2) {
                activeSortable.addAnimationState({
                  target: clone2,
                  rect: clonesFromRect
                });
                clone2.fromRect = clonesFromRect;
                clone2.thisAnimationDuration = null;
              });
            }
          } else {
            activeSortable._showClone(sortable);
          }
        }
      }
    },
    dragOverAnimationCapture: function dragOverAnimationCapture(_ref11) {
      var dragRect = _ref11.dragRect, isOwner = _ref11.isOwner, activeSortable = _ref11.activeSortable;
      multiDragElements.forEach(function(multiDragElement) {
        multiDragElement.thisAnimationDuration = null;
      });
      if (activeSortable.options.animation && !isOwner && activeSortable.multiDrag.isMultiDrag) {
        clonesFromRect = _extends({}, dragRect);
        var dragMatrix = matrix(dragEl$1, true);
        clonesFromRect.top -= dragMatrix.f;
        clonesFromRect.left -= dragMatrix.e;
      }
    },
    dragOverAnimationComplete: function dragOverAnimationComplete() {
      if (folding) {
        folding = false;
        removeMultiDragElements();
      }
    },
    drop: function drop3(_ref12) {
      var evt = _ref12.originalEvent, rootEl2 = _ref12.rootEl, parentEl2 = _ref12.parentEl, sortable = _ref12.sortable, dispatchSortableEvent = _ref12.dispatchSortableEvent, oldIndex2 = _ref12.oldIndex, putSortable2 = _ref12.putSortable;
      var toSortable = putSortable2 || this.sortable;
      if (!evt)
        return;
      var options = this.options, children = parentEl2.children;
      if (!dragStarted) {
        if (options.multiDragKey && !this.multiDragKeyDown) {
          this._deselectMultiDrag();
        }
        toggleClass(dragEl$1, options.selectedClass, !~multiDragElements.indexOf(dragEl$1));
        if (!~multiDragElements.indexOf(dragEl$1)) {
          multiDragElements.push(dragEl$1);
          dispatchEvent({
            sortable,
            rootEl: rootEl2,
            name: "select",
            targetEl: dragEl$1,
            originalEvent: evt
          });
          if (evt.shiftKey && lastMultiDragSelect && sortable.el.contains(lastMultiDragSelect)) {
            var lastIndex = index(lastMultiDragSelect), currentIndex = index(dragEl$1);
            if (~lastIndex && ~currentIndex && lastIndex !== currentIndex) {
              var n, i;
              if (currentIndex > lastIndex) {
                i = lastIndex;
                n = currentIndex;
              } else {
                i = currentIndex;
                n = lastIndex + 1;
              }
              for (; i < n; i++) {
                if (~multiDragElements.indexOf(children[i]))
                  continue;
                toggleClass(children[i], options.selectedClass, true);
                multiDragElements.push(children[i]);
                dispatchEvent({
                  sortable,
                  rootEl: rootEl2,
                  name: "select",
                  targetEl: children[i],
                  originalEvent: evt
                });
              }
            }
          } else {
            lastMultiDragSelect = dragEl$1;
          }
          multiDragSortable = toSortable;
        } else {
          multiDragElements.splice(multiDragElements.indexOf(dragEl$1), 1);
          lastMultiDragSelect = null;
          dispatchEvent({
            sortable,
            rootEl: rootEl2,
            name: "deselect",
            targetEl: dragEl$1,
            originalEvent: evt
          });
        }
      }
      if (dragStarted && this.isMultiDrag) {
        folding = false;
        if ((parentEl2[expando].options.sort || parentEl2 !== rootEl2) && multiDragElements.length > 1) {
          var dragRect = getRect(dragEl$1), multiDragIndex = index(dragEl$1, ":not(." + this.options.selectedClass + ")");
          if (!initialFolding && options.animation)
            dragEl$1.thisAnimationDuration = null;
          toSortable.captureAnimationState();
          if (!initialFolding) {
            if (options.animation) {
              dragEl$1.fromRect = dragRect;
              multiDragElements.forEach(function(multiDragElement) {
                multiDragElement.thisAnimationDuration = null;
                if (multiDragElement !== dragEl$1) {
                  var rect = folding ? getRect(multiDragElement) : dragRect;
                  multiDragElement.fromRect = rect;
                  toSortable.addAnimationState({
                    target: multiDragElement,
                    rect
                  });
                }
              });
            }
            removeMultiDragElements();
            multiDragElements.forEach(function(multiDragElement) {
              if (children[multiDragIndex]) {
                parentEl2.insertBefore(multiDragElement, children[multiDragIndex]);
              } else {
                parentEl2.appendChild(multiDragElement);
              }
              multiDragIndex++;
            });
            if (oldIndex2 === index(dragEl$1)) {
              var update = false;
              multiDragElements.forEach(function(multiDragElement) {
                if (multiDragElement.sortableIndex !== index(multiDragElement)) {
                  update = true;
                  return;
                }
              });
              if (update) {
                dispatchSortableEvent("update");
              }
            }
          }
          multiDragElements.forEach(function(multiDragElement) {
            unsetRect(multiDragElement);
          });
          toSortable.animateAll();
        }
        multiDragSortable = toSortable;
      }
      if (rootEl2 === parentEl2 || putSortable2 && putSortable2.lastPutMode !== "clone") {
        multiDragClones.forEach(function(clone2) {
          clone2.parentNode && clone2.parentNode.removeChild(clone2);
        });
      }
    },
    nullingGlobal: function nullingGlobal() {
      this.isMultiDrag = dragStarted = false;
      multiDragClones.length = 0;
    },
    destroyGlobal: function destroyGlobal() {
      this._deselectMultiDrag();
      off(document, "pointerup", this._deselectMultiDrag);
      off(document, "mouseup", this._deselectMultiDrag);
      off(document, "touchend", this._deselectMultiDrag);
      off(document, "keydown", this._checkKeyDown);
      off(document, "keyup", this._checkKeyUp);
    },
    _deselectMultiDrag: function _deselectMultiDrag(evt) {
      if (typeof dragStarted !== "undefined" && dragStarted)
        return;
      if (multiDragSortable !== this.sortable)
        return;
      if (evt && closest(evt.target, this.options.draggable, this.sortable.el, false))
        return;
      if (evt && evt.button !== 0)
        return;
      while (multiDragElements.length) {
        var el = multiDragElements[0];
        toggleClass(el, this.options.selectedClass, false);
        multiDragElements.shift();
        dispatchEvent({
          sortable: this.sortable,
          rootEl: this.sortable.el,
          name: "deselect",
          targetEl: el,
          originalEvent: evt
        });
      }
    },
    _checkKeyDown: function _checkKeyDown(evt) {
      if (evt.key === this.options.multiDragKey) {
        this.multiDragKeyDown = true;
      }
    },
    _checkKeyUp: function _checkKeyUp(evt) {
      if (evt.key === this.options.multiDragKey) {
        this.multiDragKeyDown = false;
      }
    }
  };
  return _extends(MultiDrag, {
    // Static methods & properties
    pluginName: "multiDrag",
    utils: {
      /**
       * Selects the provided multi-drag item
       * @param  {HTMLElement} el    The element to be selected
       */
      select: function select2(el) {
        var sortable = el.parentNode[expando];
        if (!sortable || !sortable.options.multiDrag || ~multiDragElements.indexOf(el))
          return;
        if (multiDragSortable && multiDragSortable !== sortable) {
          multiDragSortable.multiDrag._deselectMultiDrag();
          multiDragSortable = sortable;
        }
        toggleClass(el, sortable.options.selectedClass, true);
        multiDragElements.push(el);
      },
      /**
       * Deselects the provided multi-drag item
       * @param  {HTMLElement} el    The element to be deselected
       */
      deselect: function deselect(el) {
        var sortable = el.parentNode[expando], index2 = multiDragElements.indexOf(el);
        if (!sortable || !sortable.options.multiDrag || !~index2)
          return;
        toggleClass(el, sortable.options.selectedClass, false);
        multiDragElements.splice(index2, 1);
      }
    },
    eventProperties: function eventProperties() {
      var _this3 = this;
      var oldIndicies = [], newIndicies = [];
      multiDragElements.forEach(function(multiDragElement) {
        oldIndicies.push({
          multiDragElement,
          index: multiDragElement.sortableIndex
        });
        var newIndex2;
        if (folding && multiDragElement !== dragEl$1) {
          newIndex2 = -1;
        } else if (folding) {
          newIndex2 = index(multiDragElement, ":not(." + _this3.options.selectedClass + ")");
        } else {
          newIndex2 = index(multiDragElement);
        }
        newIndicies.push({
          multiDragElement,
          index: newIndex2
        });
      });
      return {
        items: _toConsumableArray(multiDragElements),
        clones: [].concat(multiDragClones),
        oldIndicies,
        newIndicies
      };
    },
    optionListeners: {
      multiDragKey: function multiDragKey(key2) {
        key2 = key2.toLowerCase();
        if (key2 === "ctrl") {
          key2 = "Control";
        } else if (key2.length > 1) {
          key2 = key2.charAt(0).toUpperCase() + key2.substr(1);
        }
        return key2;
      }
    }
  });
}
function insertMultiDragElements(clonesInserted, rootEl2) {
  multiDragElements.forEach(function(multiDragElement, i) {
    var target = rootEl2.children[multiDragElement.sortableIndex + (clonesInserted ? Number(i) : 0)];
    if (target) {
      rootEl2.insertBefore(multiDragElement, target);
    } else {
      rootEl2.appendChild(multiDragElement);
    }
  });
}
function insertMultiDragClones(elementsInserted, rootEl2) {
  multiDragClones.forEach(function(clone2, i) {
    var target = rootEl2.children[clone2.sortableIndex + (elementsInserted ? Number(i) : 0)];
    if (target) {
      rootEl2.insertBefore(clone2, target);
    } else {
      rootEl2.appendChild(clone2);
    }
  });
}
function removeMultiDragElements() {
  multiDragElements.forEach(function(multiDragElement) {
    if (multiDragElement === dragEl$1)
      return;
    multiDragElement.parentNode && multiDragElement.parentNode.removeChild(multiDragElement);
  });
}
Sortable.mount(new AutoScrollPlugin());
Sortable.mount(Remove, Revert);
Sortable.mount(new SwapPlugin());
Sortable.mount(new MultiDragPlugin());
let resizeTimeout;
const eventStore = [];
const defaultInterval = 500;
function eventHandle() {
  if (eventStore.length) {
    eventStore.forEach((item) => {
      item.tarList.forEach((observer) => {
        const { target, width, height } = observer;
        const clientWidth = target.clientWidth;
        const clientHeight = target.clientHeight;
        const rWidth = clientWidth && width !== clientWidth;
        const rHeight = clientHeight && height !== clientHeight;
        if (rWidth || rHeight) {
          observer.width = clientWidth;
          observer.height = clientHeight;
          setTimeout(item.callback);
        }
      });
    });
    eventListener();
  }
}
function eventListener() {
  clearTimeout(resizeTimeout);
  resizeTimeout = setTimeout(eventHandle, defaultInterval);
}
class YesResizeObserver {
  constructor(callback) {
    this.tarList = [];
    this.callback = callback;
  }
  observe(target) {
    if (target) {
      const { tarList } = this;
      if (!tarList.some((observer) => observer.target === target)) {
        tarList.push({
          target,
          width: target.clientWidth,
          height: target.clientHeight
        });
      }
      if (!eventStore.length) {
        eventListener();
      }
      if (!eventStore.some((item) => item === this)) {
        eventStore.push(this);
      }
    }
  }
  unobserve(target) {
    for (let i = eventStore.length - 1; i >= 0; --i) {
      if (eventStore[i].target === target) {
        eventStore.splice(i, 1);
      }
    }
  }
  disconnect() {
    eventStore.length = 0;
  }
}
function createResizeObserver(callback) {
  if (window.ResizeObserver) {
    return new window.ResizeObserver(callback);
  }
  return new YesResizeObserver(callback);
}
function createDebounce(fn, delay) {
  let timer;
  return function() {
    let _this = this;
    let args = arguments;
    if (timer) {
      clearTimeout(timer);
    }
    timer = setTimeout(function() {
      fn.apply(_this, args);
    }, delay);
  };
}
function createThrottle(fn) {
  let lock = false;
  return function(...args) {
    if (lock) {
      return;
    }
    lock = true;
    window.requestAnimationFrame(() => {
      fn.apply(this, args);
      lock = false;
    });
  };
}
const stripHtml = function(v2) {
  v2 = String(v2);
  let regexp = /<("[^"]*"|'[^']*'|[^'">])*>/gi;
  if (v2) {
    v2 = v2.replace(regexp, "");
    return v2 && v2 !== "&nbsp;" && v2 !== "&#160;" ? v2.replace(/\"/g, "'") : "";
  }
  return v2;
};
const stripPref = function(pref, id) {
  var obj = typeof pref;
  if (obj === "string" || obj === "number") {
    pref = String(pref);
    id = pref !== "" ? String(id).replace(String(pref), "") : id;
  }
  return id;
};
const formatString = function(format) {
  var args = Array.from(arguments).slice(1);
  if (format == null) {
    format = "";
  }
  return format.replace(/\{(\d+)\}/g, function(m, i) {
    return args[i];
  });
};
const randomString = function(len) {
  len = len || 32;
  let $chars = "ABCDEFGHJKMNPQRSTWXYZabcdefhijkmnprstwxyz2345678";
  let maxPos = $chars.length;
  let pwd = "";
  for (let i = 0; i < len; i++) {
    pwd += $chars.charAt(Math.floor(Math.random() * maxPos));
  }
  return pwd;
};
const hitTest = (e, uidPref, delta) => {
  let hit = {}, td = e.target.closest("td"), tr = td && td.closest("tr.ygrow");
  if (!tr) {
    return hit;
  }
  let rowIndex2 = parseInt(stripPref(uidPref, tr.id)), colIndex = td.cellIndex - delta;
  let metaKey = td.getAttribute("meta-key");
  return {
    row: rowIndex2,
    column: colIndex,
    metaKey
  };
};
function getChromeVersion() {
  let raw = navigator.userAgent.match(/Chrom(e|ium)\/([0-9]+)\./);
  return raw ? parseInt(raw[2], 10) : 0;
}
let RowCache$1 = class RowCache2 {
  constructor() {
    this.cache = /* @__PURE__ */ new Map();
    this.transactionNodesPendingRemoval = /* @__PURE__ */ new Set();
    this.inTransaction = false;
  }
  /**
   * Returns a row either by creating a new one or reusing
   * a previously released row which shares the same metaRowId.
   */
  alloc(metaRowId) {
    let cache_row = this.getRowCache(metaRowId).pop();
    let isStale = false;
    if (cache_row) {
      isStale = this.transactionNodesPendingRemoval.has(cache_row.domNode);
      if (isStale) {
        this.transactionNodesPendingRemoval.delete(cache_row.domNode);
      }
    }
    return { row: cache_row, stale: isStale };
  }
  /**
   * Releases the row for eventual reuse.
   */
  release(domNode) {
    if (!domNode) {
      return;
    }
    this.releaseRow(domNode);
  }
  /**
   * Begin a set of changes that use the cache. This lets us skip work when a row is removed and then inserted again.
   */
  transact(makeChanges) {
    if (this.inTransaction) {
      throw new Error("Already in transaction");
    }
    this.inTransaction = true;
    try {
      makeChanges();
    } finally {
      for (const domNode of this.transactionNodesPendingRemoval) {
        this.doRemoveNode(domNode);
      }
      this.transactionNodesPendingRemoval.clear();
      this.inTransaction = false;
    }
  }
  releaseRow(domNode) {
    let metaRowId = domNode.getAttr("meta-key");
    if (domNode) {
      if (this.inTransaction) {
        this.transactionNodesPendingRemoval.add(domNode);
      } else {
        this.doRemoveNode(domNode);
      }
    }
    this.getRowCache(metaRowId).unshift({ domNode, metaRowId });
  }
  doRemoveNode(domNode) {
    domNode.$remove();
  }
  getRowCache(metaRowId) {
    let result = this.cache.get(metaRowId);
    if (!result) {
      result = [];
      this.cache.set(metaRowId, result);
    }
    return result;
  }
  dispose() {
    this.cache.clear();
    this.transactionNodesPendingRemoval.clear();
  }
  size() {
    return this.cache.size;
  }
};
var Range$1;
((Range2) => {
  function intersect(one, other) {
    if (one.start >= other.end || other.start >= one.end) {
      return { start: 0, end: 0 };
    }
    const start = Math.max(one.start, other.start);
    const end = Math.min(one.end, other.end);
    if (end - start <= 0) {
      return { start: 0, end: 0 };
    }
    return { start, end };
  }
  Range2.intersect = intersect;
  function relativeComplement(one, other) {
    const first = { start: one.start, end: Math.min(other.start, one.end) };
    const second = { start: Math.max(other.end, one.start), end: one.end };
    if (!isEmpty2(first)) {
      return first;
    }
    if (!isEmpty2(second)) {
      return second;
    }
    return { start: 0, end: 0 };
  }
  Range2.relativeComplement = relativeComplement;
  function isEmpty2(range) {
    return range.end - range.start <= 0;
  }
  Range2.isEmpty = isEmpty2;
  function notEmpty(range) {
    return !isEmpty2(range);
  }
  Range2.notEmpty = notEmpty;
  function intersects(one, other) {
    return !isEmpty2(intersect(one, other));
  }
  Range2.intersects = intersects;
  function shift2({ start, end }, much) {
    return { start: start + much, end: end + much };
  }
  Range2.shift = shift2;
})(Range$1 || (Range$1 = {}));
let observerMap = /* @__PURE__ */ new Map();
let newChrome = getChromeVersion() > 83;
function vGrid(options) {
  var _a, _b;
  let uidPref = "ygd";
  let build = YElement.buildFromVNode;
  let p = {
    rowHeight: 32,
    minColWidth: GridSetting.minColWidth || 30,
    // 列最小宽度
    maxColWidth: GridSetting.maxColWidth || 300,
    // 列最大宽度
    scrollPage: true,
    //是否使用滚动来代替分页操作，及滚动翻页，如为true，则屏蔽分页操作按钮及页码输入
    scrollBarWidth: 8,
    // 滚动条宽度
    columns: [],
    //列集合,其中列的属性为：name:名称,label:显示名称,sortable:排序,editable:可编辑,align:文本位置
    data: [],
    //行数据，
    seqWidth: 50,
    //序号列宽度
    tblWidth: 0,
    // table宽度
    rowList: [],
    // 动态分页每页行数范围
    extOpts: [],
    // 额外操作列表
    selectModel: null,
    // 鼠标选择模型
    enableColumnMenu: true
    // 是否开启右键菜单
  };
  for (let key2 in options) {
    let value = options[key2];
    if (value !== void 0) {
      if (Array.isArray(value)) {
        p[key2] = value.slice(0);
      } else {
        p[key2] = value;
      }
    }
  }
  p.delta = p.showRowHead() ? 1 : 0;
  p.knv = p.id + "_kn";
  p.copy = p.id + "_copy";
  let pageInfo = p.pageInfo;
  let selectModel = p.selectModel;
  if (p.showRowHead()) {
    p.columns.unshift({
      caption: I18N.getString("GRID_SEQ", "序号"),
      name: "rn",
      type: "seq",
      width: p.seqWidth,
      sortable: false,
      align: "center",
      visible: true
    });
  }
  p.columns.forEach(function(column) {
    if (column.visible) {
      p.tblWidth += parseInt(column.width);
    }
  });
  const grid = {
    headers: [],
    // 表头的所有子叶列
    scrollTop: 0,
    // 记录纵向滚动距离,在动态加载时使用
    scrollTimeout: 50,
    // 滚动延时时间
    scrollThrottle: 100,
    // 超过此列数,使用timer
    rendered: false,
    // 是否已经渲染,首次打开postHook中渲染
    lastRenderTop: 0,
    // 记录实际渲染的滚动距离,因为有缓冲区
    fsl: 0,
    // 锁定时横向滚动距离scrollLeft
    promises: [],
    // 公式标题异步集合
    formulaTip: {},
    // 公式tip集合
    cache: new RowCache$1(),
    // 行缓存
    renderRange: { start: 0, top: 0, bottom: 0, end: 0 },
    // 当前渲染范围
    VIEW_COUNT: null,
    // 可视区域渲染的行数,设置过小设计器菜单树打开设置焦点渲染行数不正确
    // 滚动函数
    scrollGrid(e) {
      let bdiv = grid.bDiv.getElm();
      grid.bDiv.$setProp("scrollLeft", bdiv.scrollLeft);
      grid.bDiv.$setProp("scrollTop", bdiv.scrollTop);
      if (p.scrollPage) {
        if (bdiv.scrollTop !== grid.scrollTop) {
          grid.scrollTop = bdiv.scrollTop;
          if (grid.timer) {
            clearTimeout(grid.timer);
          }
          if (p.columns.length < grid.scrollThrottle) {
            (grid.requestFrame = grid.requestFrame || createThrottle(grid.populateVisible.bind(grid)))();
          } else {
            grid.timer = setTimeout(grid.populateVisible.bind(grid), grid.scrollTimeout);
          }
        }
      }
      grid.hDiv.$setProp("scrollLeft", bdiv.scrollLeft);
      if (grid.hDiv.getElm()) {
        grid.hDiv.getElm().scrollLeft = bdiv.scrollLeft;
      }
      if (p.frozenRows) {
        grid.fbDiv2.$setProp("scrollLeft", bdiv.scrollLeft);
        if (grid.fbDiv2.getElm()) {
          grid.fbDiv2.getElm().scrollLeft = bdiv.scrollLeft;
        }
      }
      if (e) {
        e.stopPropagation();
      }
    },
    // 滚动渲染
    populateVisible() {
      if (grid.timer) {
        clearTimeout(grid.timer);
      }
      grid.timer = null;
      if (grid.bDiv.isRemoved()) {
        return;
      }
      let bdiv = grid.bDiv.getElm();
      if (!bdiv) {
        return;
      }
      grid.scrollTop = bdiv.scrollTop;
      grid.doRender(true);
      $table.doAfterScroll();
    },
    // 有上下缓冲区在scrollTop处于[top,bottom]的数据上的时候不渲染数据
    doRender(scrollRender = false, scrollTop = grid.scrollTop) {
      if (!this.withinRange(scrollTop)) {
        console.time(`render..${p.id}`);
        let previousRenderRange = { ...this.renderRange };
        this.renderRange = this.getRenderRange(scrollTop);
        console.log(p.id, "renderRange", this.renderRange, p.data.length);
        this.lastRenderTop = scrollTop;
        $table.$addStyle("transform", `translate(0px, ${this.renderRange.start * p.rowHeight}px)`);
        let rows = $table.getRows();
        let rangeToInsert = Range$1.relativeComplement(this.renderRange, previousRenderRange);
        let rangeToRemove = Range$1.relativeComplement(previousRenderRange, this.renderRange);
        let beforeElement = this.getBeforeElement(previousRenderRange, rangeToInsert.end, rows);
        this.cache.transact(() => {
          for (let i = rangeToRemove.end - 1; i >= rangeToRemove.start; i--) {
            this.removeRowFromDOM(i - previousRenderRange.start, rows);
          }
          for (let i = rangeToInsert.start; i < rangeToInsert.end; i++) {
            this.insertRowToDOM(i, beforeElement);
          }
        });
        if (Range$1.notEmpty(rangeToInsert)) {
          setTimeout(() => {
            let { start, end } = rangeToInsert;
            p.fetchCaption(start, end, true, !scrollRender);
            if (scrollRender) {
              p.fetchRowsStatus(start, end, true);
            } else if (end > GridSetting.pageRowCount) {
              p.fetchRowsStatus(GridSetting.pageRowCount, end, true);
            }
          }, 0);
        }
        grid.rendered = true;
        console.timeEnd(`render..${p.id}`);
      }
    },
    // 插入/删除/展开/折叠
    splice(start, deleteCount, insertCount) {
      if (grid.bDiv.isRemoved()) {
        return;
      }
      if (grid.rendered === false) {
        return;
      }
      if (deleteCount == 0 && insertCount == 0) {
        return;
      }
      this.doSplice(start, deleteCount, insertCount);
    },
    // 回收更新previousRenderRange + rows
    doSplice(start, deleteCount, insertCount) {
      const lastRenderTop = grid.lastRenderTop;
      const previousRenderRange = { ...this.renderRange };
      this.renderRange = this.getRenderRange(lastRenderTop);
      $table.$addStyle("transform", `translate(0px, ${this.renderRange.start * p.rowHeight}px)`);
      const rows = $table.getRows();
      const deleteRange = { start, end: start + deleteCount };
      const deleteRemoveRange = Range$1.intersect(previousRenderRange, deleteRange);
      for (let i = deleteRemoveRange.end - 1; i >= deleteRemoveRange.start; i--) {
        this.removeRowFromDOM(i - previousRenderRange.start, rows);
      }
      const previousRestRange = { start: start + deleteCount, end: p.data.length + deleteCount };
      const previousRenderRestRange = Range$1.intersect(previousRestRange, previousRenderRange);
      const previousUnrenderedRestRange = Range$1.relativeComplement(previousRestRange, previousRenderRange);
      const delta = insertCount - deleteCount;
      const renderRange = this.renderRange;
      const renderedRestRange = Range$1.shift(previousRenderRestRange, delta);
      const updateRange = Range$1.intersect(renderRange, renderedRestRange);
      for (let i = updateRange.start; i < updateRange.end; i++) {
        this.updateRowInDOM(i, rows[i - previousRenderRange.start - delta]);
      }
      const insertRemoveRange = Range$1.relativeComplement(renderedRestRange, renderRange);
      for (let i = insertRemoveRange.end - 1; i >= insertRemoveRange.start; i--) {
        this.removeRowFromDOM(i - previousRenderRange.start - delta, rows);
      }
      const unrenderedRestRange = Range$1.shift(previousUnrenderedRestRange, delta);
      const elementsRange = { start, end: start + insertCount };
      let insertRange, beforeElement;
      if (Range$1.isEmpty(elementsRange)) {
        insertRange = Range$1.intersect(renderRange, unrenderedRestRange);
        beforeElement = null;
      } else {
        insertRange = Range$1.intersect(renderRange, elementsRange);
        beforeElement = this.getBeforeElement(previousRenderRange, start, rows);
      }
      for (let i = insertRange.start; i < insertRange.end; i++) {
        this.insertRowToDOM(i, beforeElement, true);
      }
    },
    // 获取渲染区域
    getRenderRange(scrollTop) {
      let top = this.getTopIndex(scrollTop);
      let start = this.getBeforeIndex(top);
      let bottom = this.getBottomIndex(top);
      let end = this.getEndIndex(bottom);
      return { start, top, bottom, end };
    },
    // 判断是否在安全区
    withinRange(scrollTop) {
      const rh = p.rowHeight;
      const { top, bottom } = this.renderRange;
      return scrollTop > top * rh && scrollTop < bottom * rh;
    },
    // 渲染区域首行
    getBeforeIndex(topIndex) {
      return Math.max(topIndex - this.VIEW_COUNT, 0);
    },
    // 可视区域首行,向下取整
    getTopIndex(scrollTop) {
      return Math.floor(scrollTop / p.rowHeight);
    },
    // 可视区域尾部行
    getBottomIndex(topIndex) {
      return Math.min(topIndex + this.VIEW_COUNT, p.data.length);
    },
    // 渲染区域尾行
    getEndIndex(bottomIndex) {
      return Math.min(bottomIndex + this.VIEW_COUNT, p.data.length);
    },
    // 更新视图行,插入空白行,需要及时更新
    updateRowInDOM(index2, domNode, isSplice) {
      if (domNode == null)
        return;
      let data2 = p.data[index2], $t = $table, cells = domNode.getChildElms();
      let { top, no } = $t.getRowInfo(index2);
      if (p.showRowHead()) {
        cells[0].childNode().$setInnerText(no.toString());
      }
      let treelevel = domNode.getAttr("treelevel");
      domNode.$setAttr("id", uidPref + index2);
      domNode.$setAttr("rowid", data2.rowId);
      domNode.$setAttr("treelevel", data2.treeLevel);
      $t.refreshTreeImage(index2, domNode);
      if (data2.meta.backColor && !data2.backColorProcessed) {
        $t.setBackColor(data2, index2, -1, domNode, true);
      }
      if (data2.meta.foreColor && !data2.foreColorProcessed) {
        $t.setForeColor(data2, index2, -1, domNode, true);
      }
      for (let i = p.delta, vcell; vcell = cells[i]; i++) {
        const column = p.columns[i];
        const cell = data2.data[column.orgIndex];
        if (p.showRowHead() && i == 1) {
          $t.impl_setCellError(cells[0], data2.error.isError(), data2.error.getErrorMsg());
          $t.impl_setBackColor(cells[0], data2.backColor);
        }
        if (data2.UIProcessed || isSplice) {
          $t.impl_setCellCaption(vcell, cell);
          $t.impl_setCellEnable(vcell, cell.enable);
          $t.impl_setCellRequired(vcell, cell.required);
          $t.impl_setCellError(vcell, cell.error, cell.errorMsg);
        }
        if (cell.meta.backColor && !cell.backColorProcessed) {
          $t.setBackColor(cell, index2, column.orgIndex, domNode);
        } else {
          $t.impl_setBackColor(vcell, cell.backColor || data2.backColor);
        }
        if (cell.meta.foreColor && !cell.foreColorProcessed) {
          $t.setForeColor(cell, index2, column.orgIndex, domNode);
        } else {
          $t.impl_setForeColor(vcell, cell.foreColor);
        }
        $t.impl_setCellSelected(vcell, cell.selected);
        $t.impl_setCellMatched(vcell, cell.caption);
        $t.impl_setCellFocus(vcell, index2, i - p.delta);
        $t.impl_setCellNegtive(vcell, cell);
        const editor = vcell.getCustomData("editor");
        if (editor) {
          editor.refreshId(index2);
        }
        const isTreeCell = vcell.getProp("treecell");
        if (isTreeCell) {
          $t.refreshTreeIcon(data2, vcell);
          vcell.$removeClass("treelevel--" + treelevel);
          vcell.$addClass("treelevel--" + data2.treeLevel);
        }
        vcell.$addStyle("width", `${p.columns[i].width}px`).$addStyle("position", "").$addStyle("left", "").$addStyle("z-index", "");
      }
    },
    // 回收视图行
    removeRowFromDOM(index2, rows) {
      var _a2;
      if (newChrome) {
        this.cache.release(rows[index2]);
      } else {
        (_a2 = rows[index2]) == null ? void 0 : _a2.$remove();
      }
    },
    // 插入视图行
    insertRowToDOM(index2, beforeElement, isSplice) {
      let data2 = p.data[index2];
      let { row: row2 } = this.cache.alloc(data2.key);
      let domNode = row2 == null ? void 0 : row2.domNode, needUpdate;
      if (domNode) {
        needUpdate = true;
      } else {
        domNode = this.bTable.addGridRow(data2, index2);
      }
      if (domNode) {
        if (beforeElement && beforeElement.$parent()) {
          domNode.$insertBefore(beforeElement);
        } else {
          tbody.$append(domNode);
        }
      }
      if (needUpdate) {
        this.updateRowInDOM(index2, domNode, isSplice);
      }
      if (isSplice) {
        if (!data2.captionFetched) {
          p.fetchCaption(index2, index2 + 1, true);
        }
        if (!data2.UIProcessed) {
          p.fetchRowsStatus(index2, index2 + 1, true);
        }
      }
    },
    // 根据相对位置找到参照节点,参考节点可能被回收
    getBeforeElement(previousRenderRange, from, rows) {
      let relative_pos = from - previousRenderRange.start;
      if (relative_pos < 0) {
        return null;
      }
      let row2 = rows[relative_pos];
      if (!row2) {
        return null;
      }
      if (!row2.$parent()) {
        return null;
      }
      return row2;
    },
    //修改列大小，拖动开始
    dragStart(i, e, arr2) {
      let gridLeftPos = this.bDiv.getElm().getBoundingClientRect().left;
      this.resizing = { index: i, startX: e.clientX, startLeft: e.clientX - gridLeftPos };
      this.hDiv.$addStyle("cursor", "col-resize");
      this.marker.$addStyle("display", "block");
      this.marker.$addStyle("left", e.clientX - gridLeftPos + "px");
      this.marker.$addStyle("top", arr2[1] + "px");
      this.marker.$addStyle("height", arr2[2] + "px");
      document.onselectstart = function() {
        return false;
      };
    },
    // 修改列大小，拖动中
    dragMove(e) {
      if (this.resizing) {
        let delta = e.clientX - this.resizing.startX, header = this.headers[this.resizing.index], newWidth = header.width + delta;
        if (newWidth > p.minColWidth) {
          let marker = this.marker.getElm();
          marker.style.left = this.resizing.startLeft + delta + "px";
          this.newWidth = p.tblWidth + delta;
          header.newWidth = newWidth;
          header.delta = delta;
        }
      }
    },
    // 修改列大小，拖动结束
    dragEnd() {
      var _a2, _b2, _c, _d;
      if (this.resizing) {
        let index2 = this.resizing.index, header = this.headers[index2];
        if (header.delta != null) {
          p.tblWidth = this.newWidth;
          header.width = header.newWidth;
          p.columns[index2].width = header.width;
          header.el.$addStyle("width", header.width + "px");
          this.hColGroup.getChildElms()[index2].$addStyle("width", header.width + "px");
          this.bColGroup.getChildElms()[index2].$addStyle("width", header.width + "px");
          (_a2 = this.fhColGroup) == null ? void 0 : _a2.getChildElms()[index2].$addStyle("width", header.width + "px");
          (_b2 = this.fhColGroup3) == null ? void 0 : _b2.getChildElms()[index2].$addStyle("width", header.width + "px");
          (_c = this.fbColGroup2) == null ? void 0 : _c.getChildElms()[index2].$addStyle("width", header.width + "px");
          this.hTable.$addStyle("width", p.tblWidth + "px");
          this.bTable.$addStyle("width", p.tblWidth + "px");
          (_d = this.fbTbl2) == null ? void 0 : _d.$addStyle("width", p.tblWidth + "px");
          if (index2 <= p.freezeLeftColCnt && p.frozenLeftColumns) {
            this.fhDiv.$setWidth(parseFloat(this.fhDiv.getWidth()) + header.delta + "px");
            $table.setFrozenLeftColumns();
          }
          if (index2 >= p.columns.length - p.freezeRightColCnt && p.frozenRightColumns) {
            this.fhDiv3.$setWidth(parseFloat(this.fhDiv3.getWidth()) + header.delta + "px");
            $table.setFrozenRightColumns();
          }
          this.hDiv.$setProp("scrollLeft", this.bDiv.getProp("scrollLeft"));
          delete header.delta;
        }
      }
      this.resizing = null;
      this.hDiv.$addStyle("cursor", "default");
      this.marker.$addStyle("display", "none");
      document.onselectstart = function() {
        return true;
      };
    }
  };
  const tableProps = {
    p,
    grid,
    knvFocus() {
      if (!this.grid)
        return;
      grid.knv.$setAttr("tabindex", "-1").$focus();
    },
    setEnable(enable) {
      p.enable = enable;
      this.updateOpt(enable);
    },
    setExtOptEnable(optKey, enable) {
      let id = optKey + "_" + p.id;
      let $td = grid.toolEl.$findById(id);
      if (enable) {
        $td.$removeClass("ui-state-disabled");
      } else {
        $td.$addClass("ui-state-disabled");
      }
    },
    setExtOptVisible(optKey, visible) {
      let id = optKey + "_" + p.id;
      let $td = grid.toolEl.$findById(id);
      if (visible) {
        $td.$removeClass("ui-hidden");
      } else {
        $td.$addClass("ui-hidden");
      }
    },
    getRenderInfo() {
      let bdiv = grid.bDiv.getElm();
      let VIEW_COUNT = grid.VIEW_COUNT;
      return {
        VIEW_COUNT,
        cntHeight: bdiv == null ? void 0 : bdiv.clientHeight,
        focusRowIndex: selectModel.focusRow
      };
    },
    getOffset(iCol) {
      let $th = grid.headers[iCol].el.getElm();
      let view = grid.view.getElm(), bdom = grid.bDiv.getElm();
      let ret = [$th.offsetLeft + $th.offsetWidth];
      ret[0] -= bdom.scrollLeft;
      ret.push(view.offsetTop);
      ret.push(view.offsetHeight);
      return ret;
    },
    isMax() {
      return el.hasClass("is--maximize");
    },
    getRowRange(rows = this.getRows()) {
      let start = 0, end = 0;
      if (rows.length > 0) {
        start = parseInt(stripPref(uidPref, rows[0].getAttr("id")), 10);
        end = parseInt(stripPref(uidPref, rows[rows.length - 1].getAttr("id")), 10) + 1;
      }
      return { start, end };
    },
    getScrollTop() {
      var _a2;
      return ((_a2 = grid.bDiv.getElm()) == null ? void 0 : _a2.scrollTop) || 0;
    },
    getScrollLeft() {
      var _a2;
      return ((_a2 = grid.bDiv.getElm()) == null ? void 0 : _a2.scrollLeft) || 0;
    },
    revert() {
      let $td = grid.toolEl.$findById("zoom_" + p.id);
      if (el.hasClass("is--maximize")) {
        p.clearZoomZIndex();
        el.$addStyle("zIndex", "auto");
        el.$removeClass("is--maximize");
        $td.$setAttr("title", I18N.getString("GRID_ZOOM", "全屏")).$findById("zoom_span_" + p.id).$removeClass("ui-icon-minimize").$addClass("ui-icon-fullscreen");
      }
    },
    zoom() {
      let $td = grid.toolEl.$findById("zoom_" + p.id);
      if (!el.hasClass("is--maximize")) {
        el.$addStyle("zIndex", p.getZIndex("zoom"));
        el.$addClass("is--maximize");
        $td.$setAttr("title", I18N.getString("GRID_REVERT", "还原")).$findById("zoom_span_" + p.id).$removeClass("ui-icon-fullscreen").$addClass("ui-icon-minimize");
      }
    },
    search() {
      let $search = el.$findByClassName("ui-ygrid--search")[0];
      if ($search) {
        return $search.$findByClassName("ui-ygrid--search-input-inner")[0].$focus();
      }
      let search = async (dir) => {
        if (grid.searchTimer) {
          clearTimeout(grid.searchTimer);
        }
        grid.searchTimer = setTimeout(async () => {
          if (grid.searchTimer) {
            clearTimeout(grid.searchTimer);
          }
          grid.searchTimer = null;
          let elm = $input.getElm();
          let txt = elm.value.trim();
          p.search_text = txt;
          let result = await p.searchText(dir, txt);
          $info.$setInnerText(`${result ? result.total : ""}`);
        }, 100);
      };
      let close = () => {
        p.search_text = "";
        p.clearSearch();
        $search.$remove();
      };
      let inputKeydown = (e) => {
        let keyCode = e.charCode || e.keyCode;
        if (keyCode == 13) {
          search(e.shiftKey ? "prev" : "next");
          e.preventDefault();
        }
      };
      $search = build(h$1("div", { class: { "ui-ygrid--search": true }, style: { "z-index": "25" } })).$appendTo(el);
      let $left = build(h$1("div", { class: { "ui-ygrid--search-input": true } })).$appendTo($search);
      let $right = build(h$1("div", { class: { "ui-ygrid--search-option": true } })).$appendTo($search);
      let $input = build(h$1("input", { class: { "ui-ygrid--search-input-inner": true }, on: { keydown: (e) => inputKeydown(e) }, attrs: { type: "text", placeholder: I18N.getString("GRID_SEARCH", "搜索"), autocomplete: "off" } })).$appendTo($left);
      let $info = build(h$1("span", { class: { "ui-ygrid--search-input-info": true } })).$appendTo($left);
      build(h$1("div", { class: { "ui-ygrid--search-next": true }, on: { click: () => search("next") } })).$appendTo($right);
      build(h$1("div", { class: { "ui-ygrid--search-prev": true }, on: { click: () => search("prev") } })).$appendTo($right);
      build(h$1("div", { class: { "ui-ygrid--search-close": true }, on: { click: () => close() } })).$appendTo($right);
      $input.$setInputValue(p.search_text);
      $input.$focus();
    },
    async setBackColor(data2, ri, ci, $El, isRow) {
      let color2 = data2.backColor;
      if (!color2 && data2.meta.backColor) {
        color2 = await p.calcColor(data2.meta.backColor, ri, ci);
      }
      data2.backColor = color2;
      data2.backColorProcessed = true;
      this.impl_setBackColor($El, color2, isRow);
    },
    impl_setBackColor($El, color2, isRow) {
      if (color2) {
        if (isRow) {
          $El.getChildElms().forEach((cell) => cell.$addStyle("background-color", color2));
        } else {
          $El.$addStyle("background-color", color2);
        }
      } else {
        if (isRow) {
          $El.getChildElms().forEach((cell) => cell.$addStyle("background-color", ""));
        } else {
          $El.$addStyle("background-color", "");
        }
      }
    },
    async setForeColor(data2, ri, ci, $El, isRow) {
      let color2 = data2.foreColor;
      if (!color2 && data2.meta.foreColor) {
        color2 = await p.calcColor(data2.meta.foreColor, ri, ci);
      }
      data2.foreColor = color2;
      data2.foreColorProcessed = true;
      this.impl_setForeColor($El, color2, isRow);
    },
    impl_setForeColor($El, color2, isRow) {
      if (color2) {
        if (isRow) {
          $El.getChildElms().forEach((cell) => cell.$addStyle("color", color2));
        } else {
          $El.$addStyle("color", color2);
        }
      } else {
        if (isRow) {
          $El.getChildElms().forEach((cell) => cell.$addStyle("color", ""));
        } else {
          $El.$addStyle("color", "");
        }
      }
    },
    getAlign(editOpt) {
      let format = editOpt.format, align = "";
      if (format) {
        switch (format.hAlign) {
          case 0:
            align = "left";
            break;
          case 1:
            align = "center";
            break;
          case 2:
            align = "right";
            break;
          default:
            align = format.align;
        }
      } else {
        if (editOpt.type == "label" || editOpt.type == "hyperlink") {
          align = "left";
        } else if (editOpt.type == "numbereditor") {
          align = "right";
        }
      }
      return align;
    },
    formatCol(column, editOpt, cellData, rowData, row2, col) {
      let result = { style: {}, class: {}, attr: {} };
      let align = this.getAlign(editOpt);
      if (align) {
        result.style["text-align"] = align;
      }
      let format = editOpt.format;
      if (format) {
        if (format.topBorder) {
          result.style["border-top"] = "1px double black";
        }
        if (format.rightBorder) {
          result.style["border-right"] = "1px double black";
        }
        if (format.bottomBorder) {
          result.style["border-bottom"] = "1px double black";
        }
        if (format.leftBorder) {
          result.style["border-left"] = "1px double black";
        }
        let font = format.font;
        if (font) {
          if (font.name) {
            result.style["font-family"] = font.name;
          }
          if (font.size) {
            result.style["font-size"] = font.size + "px";
          }
          if (font.bold) {
            result.style["font-weight"] = "bold";
          }
          if (font.italic) {
            result.style["font-style"] = "italic";
          }
        }
      }
      if (column.type == "tree") {
        result.class["treelevel--" + rowData.treeLevel] = true;
      }
      if (!column.visible) {
        result.style["display"] = "none";
      }
      if (cellData.isMerged) {
        if (cellData.isMergedHead) {
          result.attr["rowspan"] = cellData.rowspan;
          result.attr["colspan"] = cellData.colspan;
        } else {
          result.style["display"] = "none";
        }
      }
      if (cellData.error) {
        result.class["ygrid-cell-error"] = true;
        result.attr["errorInfo"] = cellData.errMsg;
      }
      if (cellData.required) {
        result.class["ygrid-cell-required"] = true;
        result.attr["requireInfo"] = I18N.getString("CONTROL_REQUIRED", "必填");
      }
      if (cellData.enable == false) {
        result.class["ui-cell-disabled"] = true;
      }
      if (cellData.selected == true) {
        result.class["search-matched-cell-selected"] = true;
      }
      if (cellData.caption && p.search_text && cellData.caption.includes(p.search_text)) {
        result.class["search-matched-cell"] = true;
      }
      if (row2 == selectModel.getFocusRow() && col - p.delta == selectModel.getFocusCol()) {
        result.class["ui-state-highlight"] = true;
      }
      if (selectModel.isSelectColumn(col - p.delta)) {
        result.class["ui-state-highlight"] = true;
      }
      if (editOpt.isAlwaysShow) {
        result.class["always-show"] = true;
      } else {
        result.class["space"] = true;
      }
      let tip = cellData.caption || editOpt.tip;
      if (tip && !editOpt.formulaTip) {
        result.attr["title"] = stripHtml(tip);
      }
      if (editOpt.formulaTip) {
        result.attr["formulatip"] = true;
        grid.formulaTip[editOpt.key] = editOpt.formulaTip;
      }
      result.attr["aria-describedby"] = p.id + "_" + column.name;
      result.attr["meta-key"] = editOpt.key;
      result.attr["meta-cellkey"] = editOpt.key;
      result.attr["meta-type"] = "cell";
      result.attr["meta-columnkey"] = editOpt.columnKey;
      return result;
    },
    formatCell(column, editOpt, cellData, rowData, row2, col) {
      let $t = this, prp = $t.formatCol(column, editOpt, cellData, rowData, row2, col);
      let $TD = build(h$1("td", { on: { mouseenter: () => $t.showTip($TD), mouseleave: () => $t.hideTip($TD) }, attrs: { role: "gridcell", ...prp.attr }, style: prp.style, class: prp.class }));
      let caption = cellData.caption;
      if (editOpt.isAlwaysShow) {
        caption = "";
      } else if (cellData.infinity) {
        caption = "#DIV/0";
      }
      caption = escape$1(caption);
      let $div = build(h$1("div.ygrid-cell")).$appendTo($TD);
      if (column.type == "tree" && rowData.rowType === "Detail") {
        let $node = build(h$1("div.ygrid-tree-node." + (p.treeImg ? "img" : ""))).$appendTo($div);
        let $icon = build(h$1("div.ygrid-tree-icon")).$appendTo($node);
        if (rowData.isLeaf) {
          build(h$1("span.cell-tree-icon")).$appendTo($icon);
        } else {
          build(h$1("span.cell-tree-icon." + (rowData.expanded ? "cell-expand" : "cell-collapse"))).$appendTo($icon);
        }
        let $img = build(h$1("div.ygrid-tree-img")).$appendTo($node);
        build(h$1("img")).$appendTo(build(h$1("span.cell-tree-img", { style: { display: p.treeImg ? "block" : "none" } })).$appendTo($img));
        let $label = build(h$1("div.ygrid-tree-label")).$appendTo($node);
        build(h$1("span.cell--label", caption)).$appendTo($label);
        $TD.$setProp("treecell", true);
      } else {
        build(h$1("span.cell--label", cellData.hideCaption ? "" : caption)).$appendTo($div);
      }
      if (cellData.expandFlag) {
        build(h$1(
          "div.cell-alv-icon" + (rowData.rowType == "Group" ? rowData.expand ? ".cell-alv-expand" : ".cell-alv-collapse" : ".cell-alv-collapse.cell-alv-total"),
          {
            on: { click: (e) => $t.toggleRow(e) },
            attrs: { "title": rowData.expand ? "折叠所选内容" : "展开所选内容" }
          }
        )).$appendTo($TD);
      }
      if (cellData.alvGroupLevel > 0) {
        let $box = build(h$1(
          "div.cell--alv-level-box",
          {
            on: { click: (e) => $t.toggleRow(e) },
            attrs: { "title": rowData.expand ? "折叠所选内容" : "展开所选内容" }
          }
        )).$prependTo($div);
        for (let i = 0; i < cellData.alvGroupLevel; i++) {
          build(h$1("div.cell--alv-level")).$prependTo($box);
        }
      }
      return $TD;
    },
    getFocusRowId() {
      return selectModel.focusRowId;
    },
    getFocusRowIndex() {
      return selectModel.focusRow;
    },
    getFocusColIndex() {
      return selectModel.focusCol;
    },
    mergeCell(start) {
      start = start != null ? start : 0;
      for (let i = start, count = p.data.length; i < count; i++) {
        let row2 = this.getRow(i);
        if (!row2)
          return;
        p.columns.forEach(function(column, c) {
          if (column.type != "seq") {
            let cellData = p.data[i].data[column.orgIndex];
            if (cellData.isMerged) {
              if (cellData.isMergedHead) {
                if (cellData.rowspan > 0) {
                  row2.getChildElms()[c].$setAttr("rowspan", cellData.rowspan);
                }
                if (cellData.colspan > 0) {
                  row2.getChildElms()[c].$setAttr("colspan", cellData.colspan);
                }
              } else {
                row2.getChildElms()[c].$addStyle("display", "none");
              }
            }
          }
        });
      }
    },
    refreshRows: function(from = 0) {
      while (from < p.data.length) {
        let $row = this.getRow(from);
        if (!$row) {
          return;
        }
        let { top, no } = this.getRowInfo(from);
        if (p.showRowHead()) {
          $row.childNode().childNode().$setInnerText(no++);
        }
        from++;
      }
    },
    __rowCountChanged() {
      this.updateScroll();
      this.updateRecords();
    },
    getLastIndex() {
      let rows = this.getRows();
      if (rows.length == 0)
        return -1;
      return parseInt(stripPref(uidPref, rows[rows.length - 1].getAttr("id")), 10);
    },
    getRowById(rowid) {
      let rows = this.getRows(), row2;
      let i = 0, length = rows.length;
      while (i < length) {
        if (rowid === rows[i].getAttr("rowid")) {
          row2 = rows[i];
          break;
        }
        i++;
      }
      return row2;
    },
    getRows() {
      return this.lastNode().getChildElms();
    },
    getRow(idx) {
      if (idx == null || idx < 0)
        return null;
      let rows = this.getRows(), row2;
      if (p.scrollPage) {
        let rowId = uidPref + idx;
        let i = 0, length = rows.length;
        while (i < length) {
          rowId = rowId.toString();
          if (rowId === rows[i].getAttr("id")) {
            row2 = rows[i];
            break;
          }
          i++;
        }
      } else {
        row2 = rows[idx];
      }
      return row2;
    },
    getViewRowCount() {
      let table = this.getElm();
      if (!table)
        return 0;
      return table.rows.length;
    },
    getViewIndex(idx, rows = this.getRows()) {
      let index2;
      if (p.scrollPage) {
        let rowId = uidPref + idx;
        let i = 0, length = rows.length;
        while (i < length) {
          rowId = rowId.toString();
          if (rowId === rows[i].getAttr("id")) {
            index2 = i;
            break;
          }
          i++;
        }
      } else {
        index2 = idx;
      }
      return index2;
    },
    getCell(row2, col) {
      row2 = this.getRow(row2), col = this.iCol(col);
      return row2 ? row2.getChildElms()[col] : null;
    },
    unselect(rowIndex2, left, right) {
      var _a2;
      left = this.iCol(left), right = this.iCol(right);
      let row2 = this.getRow(rowIndex2);
      if (row2) {
        let elms = row2.getChildElms();
        for (let i = left; i <= right && elms[i]; i++) {
          elms[i].$removeClass("ui-state-highlight");
          let ftbl = this.getCandidateTbl(rowIndex2, i - p.delta);
          if (ftbl) {
            let $cell = (_a2 = ftbl.getRow(rowIndex2)) == null ? void 0 : _a2.getChildElms()[i];
            $cell.$removeClass("ui-state-highlight");
          }
        }
      }
    },
    select(rowIndex2, left, right) {
      var _a2;
      left = this.iCol(left), right = this.iCol(right);
      let row2 = this.getRow(rowIndex2);
      if (row2) {
        let elms = row2.getChildElms();
        for (let i = left; i <= right && elms[i]; i++) {
          elms[i].hasClass("ui-state-highlight") || elms[i].$addClass("ui-state-highlight");
          let ftbl = this.getCandidateTbl(rowIndex2, i - p.delta);
          if (ftbl) {
            let $cell = (_a2 = ftbl.getRow(rowIndex2)) == null ? void 0 : _a2.getChildElms()[i];
            $cell.$addClass("ui-state-highlight");
          }
        }
      }
    },
    refreshDynamicEditor(typeDef, rowIndex2, colIndex) {
      let cells = this.getCandidateCells(rowIndex2, colIndex);
      cells.forEach((cell) => {
        cell.$empty().$removeClass("always-show").$removeClass("space").$setCustomData("editor", null);
        if (typeDef == null) {
          return;
        }
        if (!typeDef.isAlwaysShow) {
          return cell.$addClass("space");
        }
        cell.$addClass("always-show");
        let iCol = this.iCol(colIndex), column = p.columns[iCol];
        p.createShowEditor(typeDef, cell, rowIndex2, column.orgIndex, colIndex);
      });
    },
    iRow(rowIndex2) {
      return rowIndex2;
    },
    iCol(colIndex) {
      return colIndex + p.delta;
    },
    isEditing() {
      return p.editInfo;
    },
    doAfterScroll() {
      if (p.freezeLeftColCnt > 0) {
        this.setFrozenLeftColumns();
      }
      if (p.freezeRightColCnt > 0) {
        this.setFrozenRightColumns();
      }
      if (p.postScrollHook) {
        p.postScrollHook();
      }
      p.postScrollHook = null;
    },
    updateScroll(renderInfo) {
      if (p.scrollPage) {
        let rowHeight = p.rowHeight;
        let rowCount = p.data.length;
        if (p.hasRowVisible) {
          rowCount = p.data.filter((row2) => row2.visible !== false).length;
        }
        grid.bDiv.childNode().$addStyle("height", rowCount * rowHeight + "px");
        if (renderInfo) {
          let { scrollIndex, scrollTop, scrollLeft, cntHeight } = renderInfo;
          if (cntHeight) {
            if (scrollIndex >= 0) {
              let totalH = (scrollIndex + 1) * rowHeight;
              scrollTop = totalH - cntHeight;
            }
            if (scrollTop > 0) {
              grid.bDiv.$setProp("scrollTop", scrollTop);
              grid.scrollTop = scrollTop;
              grid.doRender();
            }
            grid.bDiv.addPostpatchHook(() => {
              grid.bDiv.getElm().scrollTop = scrollTop;
            });
          } else {
            grid.bDiv.addPostpatchHook(() => {
              let bdiv = grid.bDiv.getElm();
              if (scrollIndex >= 0) {
                let totalH = (scrollIndex + 1) * rowHeight;
                scrollTop = totalH - bdiv.offsetHeight;
              }
              if (scrollTop > 0) {
                grid.bDiv.$setProp("scrollTop", scrollTop);
                bdiv.scrollTop = scrollTop;
              }
            });
          }
          if (scrollLeft > 0) {
            grid.bDiv.$setProp("scrollLeft", scrollLeft);
            grid.bDiv.addPostpatchHook(() => {
              grid.bDiv.getElm().scrollLeft = scrollLeft;
            });
          }
        }
      }
    },
    focus() {
      this.addPostpatchHook(() => {
        this.knvFocus();
      });
    },
    updateState() {
      this.updateOpt(p.enable);
      this.updatePagination();
      this.updatePageOpt();
      this.updateRecords();
    },
    updatePageOpt() {
      if (pageInfo.pageLoadType > 0) {
        let total = pageInfo.total, curPage = pageInfo.currentPage, pageCount = pageInfo.pageCount;
        let pageBtnEl = grid.pageBtnEl, id = "_" + p.id + "_pager", className = "ui-state-disabled";
        const prev2 = pageBtnEl.$findById("prev" + id);
        const next = pageBtnEl.$findById("next" + id);
        if (curPage == 1 || total == 0) {
          prev2.$addClass(className);
        } else {
          prev2.$removeClass(className);
        }
        if (curPage == pageCount || total == 0) {
          next.$addClass(className);
        } else {
          next.$removeClass(className);
        }
      }
    },
    updateOpt(enable) {
      let toolEl2 = grid.toolEl;
      let vdoms = [
        toolEl2.$findById("add_" + p.id),
        toolEl2.$findById("del_" + p.id),
        toolEl2.$findById("upRow_" + p.id),
        toolEl2.$findById("downRow_" + p.id),
        toolEl2.$findById("editRow_" + p.id),
        toolEl2.$findById("ClickPaste_" + p.id),
        toolEl2.$findById("FilePaste_" + p.id)
      ];
      if (enable) {
        vdoms.forEach((vdom) => {
          vdom && vdom.$show();
        });
      } else {
        vdoms.forEach((vdom) => {
          vdom && vdom.$hide();
        });
      }
      vdoms = [
        toolEl2.$findById("filter_" + p.id),
        toolEl2.$findById("sum_" + p.id),
        toolEl2.$findById("groupsum_" + p.id)
        //toolEl.$findById("variantset_" + p.id),
      ];
      if (enable) {
        vdoms.forEach((vdom) => {
          vdom && vdom.$hide();
        });
      } else {
        vdoms.forEach((vdom) => {
          vdom && vdom.$show();
        });
      }
    },
    updateFrozenOpt() {
      let toolEl2 = grid.toolEl;
      let frozenrow = toolEl2.$findById("frozenRow_span_" + p.id);
      let frozenleftcol = toolEl2.$findById("frozenLeftColumn_span_" + p.id);
      let frozenleftrowcol = toolEl2.$findById("frozenLeftRowColumn_span_" + p.id);
      let frozenrightcol = toolEl2.$findById("frozenRightColumn_span_" + p.id);
      let frozenrightrowcol = toolEl2.$findById("frozenRightRowColumn_span_" + p.id);
      if (p.frozenLeftRowCols) {
        frozenrow == null ? void 0 : frozenrow.$hide();
        frozenleftcol == null ? void 0 : frozenleftcol.$hide();
        frozenleftrowcol == null ? void 0 : frozenleftrowcol.$removeClass("ui-icon-frozenLeftRowColumn").$addClass("ui-icon-unfrozenLeftRowColumn").$setAttr("title", I18N.getString("GRID_UNFROZENROWCOL", "解冻左侧行列"));
        frozenrightcol == null ? void 0 : frozenrightcol.$hide();
        frozenrightrowcol == null ? void 0 : frozenrightrowcol.$hide();
      } else if (p.frozenRightRowCols) {
        frozenrow == null ? void 0 : frozenrow.$hide();
        frozenleftcol == null ? void 0 : frozenleftcol.$hide();
        frozenleftrowcol == null ? void 0 : frozenleftrowcol.$hide();
        frozenrightcol == null ? void 0 : frozenrightcol.$hide();
        frozenrightrowcol == null ? void 0 : frozenrightrowcol.$removeClass("ui-icon-frozenRightRowColumn").$addClass("ui-icon-unfrozenRightRowColumn").$setAttr("title", I18N.getString("GRID_UNFROZENROWCOL", "解冻右侧行列"));
      } else if (p.frozenRows) {
        frozenrow == null ? void 0 : frozenrow.$removeClass("ui-icon-frozenRow").$addClass("ui-icon-unfrozenRow").$setAttr("title", I18N.getString("GRID_UNFROZENROW", "解冻行"));
        frozenleftcol == null ? void 0 : frozenleftcol.$hide();
        frozenleftrowcol == null ? void 0 : frozenleftrowcol.$hide();
        frozenrightcol == null ? void 0 : frozenrightcol.$hide();
        frozenrightrowcol == null ? void 0 : frozenrightrowcol.$hide();
      } else if (p.frozenLeftColumns) {
        frozenrow == null ? void 0 : frozenrow.$hide();
        frozenleftcol == null ? void 0 : frozenleftcol.$removeClass("ui-icon-frozenLeftColumn").$addClass("ui-icon-unfrozenLeftColumn").$setAttr("title", I18N.getString("GRID_UNFROZENLEFTCOL", "解冻左侧列"));
        frozenleftrowcol == null ? void 0 : frozenleftrowcol.$hide();
        frozenrightcol == null ? void 0 : frozenrightcol.$hide();
        frozenrightrowcol == null ? void 0 : frozenrightrowcol.$hide();
      } else if (p.frozenRightColumns) {
        frozenrow == null ? void 0 : frozenrow.$hide();
        frozenleftcol == null ? void 0 : frozenleftcol.$hide();
        frozenleftrowcol == null ? void 0 : frozenleftrowcol.$hide();
        frozenrightcol == null ? void 0 : frozenrightcol.$removeClass("ui-icon-frozenRightColumn").$addClass("ui-icon-unfrozenRightColumn").$setAttr("title", I18N.getString("GRID_UNFROZENRIGHTCOL", "解冻右侧列"));
        frozenrightrowcol == null ? void 0 : frozenrightrowcol.$hide();
      } else {
        frozenrow == null ? void 0 : frozenrow.$removeClass("ui-icon-unfrozenRow").$addClass("ui-icon-frozenRow").$setAttr("title", I18N.getString("GRID_FROZENROW", "冻结行")).$show();
        frozenleftcol == null ? void 0 : frozenleftcol.$removeClass("ui-icon-unfrozenLeftColumn").$addClass("ui-icon-frozenLeftColumn").$setAttr("title", I18N.getString("GRID_FROZENLEFTCOL", "冻结左侧列")).$show();
        frozenleftrowcol == null ? void 0 : frozenleftrowcol.$removeClass("ui-icon-unfrozenLeftRowColumn").$addClass("ui-icon-frozenLeftRowColumn").$setAttr("title", I18N.getString("GRID_FROZENLEFTROWCOL", "冻结左侧行列")).$show();
        frozenrightcol == null ? void 0 : frozenrightcol.$removeClass("ui-icon-unfrozenRightColumn").$addClass("ui-icon-frozenRightColumn").$setAttr("title", I18N.getString("GRID_FROZENRIGHTCOL", "冻结右侧列")).$show();
        frozenrightrowcol == null ? void 0 : frozenrightrowcol.$removeClass("ui-icon-unfrozenRightRowColumn").$addClass("ui-icon-frozenRightRowColumn").$setAttr("title", I18N.getString("GRID_FROZENRIGHTROWCOL", "冻结右侧行列")).$show();
      }
    },
    updateRecords() {
      grid.pageInfoEl.$setInnerText(formatString(I18N.getString("GRID_TOTAL", "共 {0} 条"), pageInfo.total));
    },
    updatePagination() {
      if (pageInfo.pageLoadType == 0)
        return;
      let $TD = grid.pageBtnEl.$findById(`pagination_${p.id + "_pager"}`);
      let $ul = $TD.childNode().$empty();
      let begin, end;
      let { currentPage, pagerCount, pageCount } = pageInfo;
      if (pageCount <= pagerCount) {
        begin = 2;
        end = pageCount;
      } else {
        let count = pagerCount - 2 > 1 ? pagerCount - 2 : 1;
        let step = Math.floor(count / 2) || 1;
        begin = currentPage - step > 1 ? currentPage - step : 2;
        end = begin + count - 1;
        if (end > pageCount - 1) {
          end = pageCount - 1;
        }
      }
      build(h$1("li.pagination_btn.first_page" + (1 == currentPage ? ".ui-state-highlight" : "") + (1 == pageCount ? ".last_page" : ""), { attrs: { "data-num": 1 }, on: { click: this.gotoPageEvent } }, 1)).$appendTo($ul);
      for (let i = begin; i <= end; i++) {
        build(h$1("li.pagination_btn" + (i == currentPage ? ".ui-state-highlight" : "") + (i == pageCount ? ".last_page" : ""), { attrs: { "data-num": i }, on: { click: this.gotoPageEvent } }, i)).$appendTo($ul);
      }
      if (pageCount > end) {
        if (pageCount - end > 1) {
          build(h$1("li.pagination_btn.dot")).$appendTo($ul);
        }
        build(h$1("li.pagination_btn.last_page" + (pageCount == currentPage ? ".ui-state-highlight" : ""), { attrs: { "data-num": pageCount }, on: { click: this.gotoPageEvent } }, pageCount)).$appendTo($ul);
      }
    },
    rowNumChangeEvent(e) {
      p.gotoPage(1, parseInt(e.target.value));
    },
    gotoPageEvent(e) {
      try {
        let target = e.target;
        let td = target.closest("td");
        if (hasClass(td, "ui-state-disabled")) {
          return;
        }
        let curPage = pageInfo.currentPage, page = curPage;
        let id = td.id;
        if (id.startsWith("first")) {
          page = 1;
        } else if (id.startsWith("prev")) {
          page = page - 1;
        } else if (id.startsWith("next")) {
          page = page + 1;
        } else if (id.startsWith("last")) {
          page = pageInfo.pageCount;
        } else if (hasClass(target, "pagination_btn")) {
          page = parseInt(target.getAttribute("data-num"));
        }
        if (curPage == page) {
          return;
        }
        let pageBtnEl = grid.pageBtnEl, className = "ui-state-disabled";
        pageBtnEl.$findById(p.pagerIds[1]).$addClass(className);
        pageBtnEl.$findById(p.pagerIds[2]).$addClass(className);
        p.gotoPage(page);
      } finally {
        e.stopPropagation();
      }
    },
    matchShortCuts(e, shortCuts) {
      for (let i = 0, sc; sc = shortCuts[i]; i++) {
        if (sc.shortCut) {
          let keys = sc.shortCut.toLowerCase().split("+");
          if (e.shiftKey) {
            let index22 = keys.indexOf("shift");
            if (index22 >= 0) {
              keys.splice(index22, 1);
            }
          }
          if (e.altKey) {
            let index22 = keys.indexOf("alt");
            if (index22 >= 0) {
              keys.splice(index22, 1);
            }
          }
          if (e.ctrlKey) {
            let index22 = keys.indexOf("ctrl");
            if (index22 >= 0) {
              keys.splice(index22, 1);
            }
          }
          if (e.metaKey) {
            let index22 = keys.indexOf("meta");
            if (index22 >= 0) {
              keys.splice(index22, 1);
            }
          }
          let key2;
          if (e.key) {
            key2 = e.key;
          } else {
            key2 = String.fromCharCode(e.which || e.keyCode);
          }
          let index2 = keys.indexOf(key2.toLowerCase());
          if (index2 >= 0) {
            keys.splice(index2, 1);
          }
          if (keys.length == 0) {
            return sc;
          }
        }
      }
    },
    handleShortCuts(e) {
      if (grid.doingShortCut) {
        return console.warn("正在执行快捷键操作,本次忽略");
      }
      let { focusRow, focusCol } = selectModel;
      if (focusRow == null || focusCol == null || focusRow < 0 || focusCol < 0)
        return;
      let iCol = this.iCol(focusCol);
      let column = p.columns[iCol];
      let orgIndex = column.orgIndex;
      let rowData = p.data[focusRow];
      let cellData = rowData.data[orgIndex];
      let editOpt = cellData.meta;
      let shortCuts = editOpt.shortCuts;
      if (!shortCuts || shortCuts.length == 0)
        return;
      let sc = this.matchShortCuts(e, shortCuts);
      if (!sc)
        return;
      e.preventDefault();
      grid.doingShortCut = true;
      return p.asyncEval(sc.content, focusRow).finally(() => {
        grid.doingShortCut = false;
      });
    },
    bindEvents2Widget() {
      let $t = this;
      let handler = p.cpHandler;
      let textArea = grid.textArea;
      if (p.preventPaste !== true) {
        const paste = () => {
          grid.shouldRelease = true;
          Promise.resolve(function() {
            $t.knvFocus();
            console.log("执行.....ctrl + v");
            LoadingUtil.show();
            let text = textArea.getElm();
            let val = text.value;
            if (val) {
              return handler.paste(val);
            }
            return true;
          }()).finally(function() {
            LoadingUtil.hide();
            console.log("结束.....ctrl + v");
          });
        };
        textArea.$addListener("input", paste).$addListener("propertychange", paste).$keydown(function(e) {
          let keyCode = e.charCode || e.keyCode;
          if (keyCode == 70) {
            $t.search();
            e.preventDefault();
          } else {
            $t.handleShortCuts(e);
          }
        });
      }
      const doEdit = function(event2, keyCode, ri, ci) {
        let code = String.fromCharCode(keyCode);
        if (code) {
          let tbl = $t.getCandidateTbl(ri, ci) || $t;
          tbl.editCell(ri, ci, code, event2);
          event2.preventDefault();
        }
      };
      const doDelete = function() {
        let left = selectModel.left, right = selectModel.right, top = selectModel.top, bottom = selectModel.bottom;
        return p.deleteRange.call($t, left, right, top, bottom);
      };
      const doFunc = (event2, keyCode) => {
        switch (keyCode) {
          case 13:
          case 108:
          case 9:
            $t.doFocusPolicy(keyCode);
            event2.preventDefault();
            break;
          case 37:
            $t.changeFocus(keyCode, "left");
            break;
          case 38:
            $t.changeFocus(keyCode, "top");
            break;
          case 39:
            $t.changeFocus(keyCode, "right");
            break;
          case 40:
            $t.changeFocus(keyCode, "bottom");
            break;
          case 46:
            doDelete();
            break;
          default:
            $t.handleShortCuts(event2);
            break;
        }
      };
      grid.knv.$keydown(function(event2) {
        let changeFocus = event2.detail.changeFocus;
        if (changeFocus == false)
          return;
        if (!selectModel.isValid())
          return;
        if (event2.ctrlKey || event2.metaKey) {
          if (grid.shouldRelease) {
            console.warn("需要先释放ctrl");
            return;
          }
          let text = textArea.getElm();
          text.value = handler.copy();
          text.focus();
          select(text);
        } else {
          let outEvent = event2.detail.event;
          let keyCode = event2.charCode || event2.keyCode || 0;
          if (keyCode == 0 && outEvent) {
            keyCode = outEvent.charCode || outEvent.keyCode || 0;
          }
          if (keyCode) {
            doFunc(event2, keyCode);
          }
        }
      }).$keyup(function(event2) {
        if ((event2.ctrlKey || event2.keyCode == 17) && grid.shouldRelease) {
          grid.shouldRelease = false;
          console.warn("ctrl键已释放");
        }
      }).$keypress(function(event2) {
        let ri = selectModel.focusRow, ci = selectModel.focusCol;
        if (ri == -1 || ci == -1) {
          return;
        }
        let keyCode = event2.charCode || event2.keyCode;
        doEdit(event2, keyCode, ri, ci);
      });
    },
    sortableColumns() {
      let $t = this, p2 = $t.p;
      grid.ltr.addPostpatchHook(() => {
        if (p2.sortable && !p2.isGroup) {
          let sortable_opts = {
            sort: true,
            // sorting inside list
            animation: 200,
            // ms, animation speed moving items when sorting, `0` — without animation
            draggable: "th[leaf='true']",
            // Specifies which items inside the element should be draggable
            filter: ".rn,.select",
            preventOnFilter: false,
            // 在触发过滤器`filter`的时候调用`event.preventDefault()`
            scrollSensitivity: 30,
            // px, how near the mouse must be to an edge to start scrolling.
            scrollSpeed: 30,
            // px
            direction: "horizontal",
            handle: "th[leaf='true'] div",
            ghostClass: "sortable-ghost",
            // Class name for the drop placeholder
            chosenClass: "sortable-chosen",
            // Class name for the chosen item
            dragClass: "sortable-drag",
            // Class name for the dragging item
            // 因为是用的bDiv的滚动,要在bDiv上拖动才会自动滚动
            scroll: grid.bDiv.getElm(),
            forceFallBack: true,
            // Called when creating a clone of element
            onClone: function(evt) {
              let cloneEl2 = evt.clone;
              cloneEl2.style.border = "1px solid red";
            },
            // 拖拽移动的时候
            onMove: function(evt, originalEvent) {
              let related = evt.related;
              if (!related) {
                return false;
              }
              if (related.hasAttribute("isselect") || related.hasAttribute("rn")) {
                return false;
              }
            },
            onEnd: function() {
              let sortdata = {}, colkey, isselect;
              let focuscol = selectModel.getFocusCol();
              let focuscolkey = p2.columns[p2.delta + focuscol].key;
              let ths = grid.ltr.getElm().querySelectorAll("th[leaf='true']");
              let newfocuscol = -1;
              ths.forEach((th, index2) => {
                colkey = th.getAttribute("colkey");
                isselect = th.hasAttribute("isselect");
                if (colkey && !isselect) {
                  sortdata[colkey] = index2;
                }
                if (colkey == focuscolkey) {
                  newfocuscol = index2 - p2.delta;
                }
              });
              if (newfocuscol >= 0) {
                $table.selectGridColumn(newfocuscol);
              }
              p2.setColumnSort(sortdata);
            }
          };
          grid.sortable = Sortable.create(grid.ltr.getElm(), sortable_opts);
        }
      });
    },
    bindBlankEvent() {
      var _a2, _b2;
      if (GridSetting.loseFocusOnBlankClick) {
        let $t = this;
        let cleanFocus = function(e) {
          let tbl = e.target.closest(".ui-ygrid-btable");
          if (tbl == null) {
            tbl = e.target.closest(".ui-ygrid-htable");
            if (tbl == null) {
              let rowIndex2 = selectModel.focusRow;
              if (rowIndex2 != -1) {
                $t.cleanSelection();
                p.rowChanged(-1, rowIndex2);
              }
            }
          }
        };
        (_a2 = grid.header) == null ? void 0 : _a2.$click(cleanFocus);
        grid.view.$click(cleanFocus);
        (_b2 = grid.footer) == null ? void 0 : _b2.$click(cleanFocus);
      }
    },
    bindEvents2View() {
      grid.view.$mousemove(function(e) {
        if (grid.resizing) {
          grid.dragMove(e);
        }
      });
      document.addEventListener("mouseup", this.mouseupHandler);
    },
    mouseupHandler() {
      if (grid.resizing) {
        grid.dragEnd();
        return false;
      }
      return true;
    },
    findVisibleColumn(iCol) {
      let headers = grid.headers, header;
      for (let i = iCol - 1; header = headers[i]; --i) {
        if (header.visible && header.name !== "rn") {
          header.el.$callSync("mousedown");
          return i;
        }
      }
      return -1;
    },
    handleHideColumn(iCol) {
      let selectedCols = selectModel.getSelectedColumns();
      if (selectedCols.length == 0)
        return;
      selectedCols.forEach((col) => {
        p.setColumnVisible(col, false, true);
      });
      let frozenCnt = p.freezeLeftColCnt;
      if (frozenCnt > 0) {
        let frozenColumn = p.columns[frozenCnt];
        if (frozenColumn.visible) {
          p.doFrozenLeftColumns(frozenCnt);
        } else {
          p.doFrozenLeftColumns(this.findVisibleColumn(frozenCnt));
        }
      }
    },
    handleFitWidth(iCol) {
      let selectedCols = selectModel.getSelectedColumns();
      if (selectedCols.length == 0)
        return;
      selectedCols.forEach((col) => {
        $table.toColumnFitWidth(col + p.delta);
      });
    },
    triggerHeadEvent(evet, column, iCol) {
      switch (evet) {
        case "hidecolumn":
          $table.handleHideColumn(iCol);
          break;
        case "showcolumn":
          p.setVariant();
          break;
        case "bestwidth":
          $table.handleFitWidth(iCol);
          break;
        case "frozencolumn":
          p.doFrozenLeftColumns(iCol);
          break;
        case "unfrozencolumn":
          p.doFrozenLeftColumns();
          break;
        case "sortasc":
          p.setRowSort([{ key: column.key, order: "asc" }]);
          break;
        case "sortdesc":
          p.setRowSort([{ key: column.key, order: "desc" }]);
          break;
        case "search":
          $table.search();
          break;
        case "setfilter":
          p.setColumnFilter();
          break;
        case "sum":
          p.setRowSum();
          break;
        case "group":
          p.setRowGroup([{ key: column.key, order: column.order || "asc", group: true }], true);
          break;
      }
    },
    doCmd(cmd) {
      let func = $table[cmd];
      if (func) {
        return func.call($table);
      }
    },
    add() {
      return p.insertRow(this.getFocusRowIndex(), true);
    },
    addTree(insertChild) {
      return p.insertRow(this.getFocusRowIndex(), true, insertChild);
    },
    del() {
      if (p.hasSelect) {
        return p.batchDeleteRow();
      } else {
        return p.deleteRow(this.getFocusRowIndex());
      }
    },
    shiftUp() {
      return p.doShiftUpRow(this.getFocusRowIndex());
    },
    shiftDown() {
      return p.doShiftDownRow(this.getFocusRowIndex());
    },
    edit() {
      return p.editGridRow();
    },
    async toFitWidth(recordStatus = false) {
      let func = () => {
        let columns = p.columns, column;
        for (let i = 0; column = columns[i]; i++) {
          if (column.visible && column.type !== "seq" && column.type !== "select") {
            this.toColumnFitWidth(i, recordStatus ? this.isFitWidthStatus : false);
          }
        }
        if (recordStatus) {
          this.isFitWidthStatus = !this.isFitWidthStatus;
        }
      };
      if (grid.promises.length > 0) {
        await Promise.all(grid.promises);
      }
      this.addPostpatchHook(() => {
        func();
      });
      this.doFrozen();
    },
    toColumnFitWidth(iCol, toDefault) {
      let header = this.grid.headers[iCol];
      let el2 = header.el;
      let tWidth = 0;
      let $th = el2.getElm();
      let oldWidth = $th.offsetWidth;
      if (toDefault !== true) {
        let div = $th.querySelector("div.content");
        let nodes = div.childNodes, node;
        for (let i = 0; node = nodes[i]; i++) {
          if (hasClass(node, "col-caption")) {
            tWidth += getFitWidth(node);
          } else {
            tWidth += node.offsetWidth;
          }
        }
        let span = $th.querySelector("span.ui-ygrid-resize");
        tWidth = span ? tWidth + span.offsetWidth : tWidth;
        let divStyle = getComputedStyle(div);
        tWidth += parseInt(divStyle.paddingLeft);
        tWidth += parseInt(divStyle.paddingRight);
        let column = p.columns[iCol];
        let row2, fitWidth, rows = this.getRows();
        for (let i = 0; i < rows.length; i++) {
          row2 = rows[i];
          let cell = row2.getChildElms()[iCol];
          let $cell = cell.getElm(), editor = cell.getCustomData("editor"), delta = 0;
          if (!$cell || $cell.style.display === "none" || parseInt($cell.getAttribute("colspan")) > 1) {
            continue;
          }
          let el3 = $cell;
          if (editor && editor.getEl().hasClass("ui-txta")) {
            return;
          }
          if (editor && editor.getEl().hasClass("ui-btn")) {
            delta = 24;
            if (editor.getEl().$findByClassName("icon").length > 0) {
              delta += 14;
            }
          }
          if (column.type == "tree") {
            let icon = $cell.querySelector(".ygrid-tree-icon");
            if (icon) {
              delta += icon.offsetWidth;
              let style = getComputedStyle($cell);
              delta += parseInt(style.paddingLeft) + parseInt(style.paddingRight);
              let image = $cell.querySelector(".ygrid-tree-img");
              delta += image.offsetWidth;
              el3 = $cell.querySelector(".ygrid-tree-label");
            }
          }
          if (editor && editor.getEl().hasClass("ui-lbl")) {
            el3 = editor.getEl().getElm();
            let icon = el3.querySelector(".icon");
            if (icon) {
              let style = getComputedStyle(icon);
              delta += parseFloat(style.marginLeft) + icon.offsetWidth + parseFloat(style.marginRight);
            }
          }
          let expandIcon = $cell.querySelector(".cell-alv-icon");
          if (expandIcon) {
            delta += expandIcon.offsetWidth;
          }
          let levelIcon = $cell.querySelector(".cell--alv-level-box");
          if (levelIcon) {
            delta += levelIcon.offsetWidth;
          }
          if (column.type == "dict" || column.type == "dynamicdict" || column.type == "compdict") {
            let pop = $cell.querySelector(".popup-dic-td");
            if (pop) {
              delta += pop.offsetWidth;
            }
          }
          fitWidth = getFitWidth(el3) + delta;
          if (fitWidth > tWidth) {
            tWidth = fitWidth;
          }
        }
        if (tWidth < p.minColWidth) {
          tWidth = p.minColWidth;
        }
        if (tWidth > p.maxColWidth) {
          tWidth = p.maxColWidth;
        }
      } else {
        tWidth = header.orgWidth;
      }
      header.newWidth = tWidth;
      header.delta = tWidth - oldWidth;
      grid.newWidth = p.tblWidth + header.delta;
      grid.resizing = { index: iCol };
      grid.dragEnd();
    },
    doLayout() {
      let bdiv = grid.bDiv.getElm();
      if (!bdiv) {
        return;
      }
      let scrollY = bdiv.scrollHeight > bdiv.clientHeight;
      if (p.frozenRows) {
        if (scrollY) {
          grid.fbDiv2.$addStyle("right", p.scrollBarWidth + "px");
        } else {
          grid.fbDiv2.$addStyle("right", "0px");
        }
      }
      if (p.frozenRightColumns) {
        let width = parseFloat(grid.fhDiv3.getCustomData("width"));
        if (scrollY) {
          grid.fhDiv3.$addStyle("width", width + p.scrollBarWidth + "px");
          grid.fbDiv3.$addStyle("right", width + p.scrollBarWidth + "px");
        } else {
          grid.fhDiv3.$addStyle("width", width + "px");
          grid.fbDiv3.$addStyle("right", width + "px");
        }
      }
      if (scrollY) {
        grid.hDiv.$setWidth(`calc(${grid.width} - ${p.scrollBarWidth}px)`);
      } else {
        grid.hDiv.$setWidth(grid.width);
      }
    },
    refreshAlwaysShowEditor() {
      let rows = this.getRows(), row2, cell;
      for (let r = 0; row2 = rows[r]; r++) {
        let cells = row2.getChildElms();
        for (let c = p.delta; cell = cells[c]; c++) {
          if (cell.hasClass("always-show")) {
            p.createShowEditor(null, cell, r, p.columns[c].orgIndex);
          }
        }
      }
    },
    setFrozenRows() {
      var _a2;
      let frozenCount = p.freezeRowCnt;
      if (frozenCount == 0 || p.frozenRows)
        return;
      let bdiv = grid.bDiv.getElm();
      let hdiv = grid.hDiv.getElm();
      let vrow = (_a2 = this.getRow(frozenCount - 1)) == null ? void 0 : _a2.getElm();
      if (vrow == null) {
        return;
      }
      let index2 = parseInt(stripPref(uidPref, vrow.id), 10);
      let divh = (index2 + 1) * p.rowHeight;
      if (divh > bdiv.clientHeight) {
        return;
      }
      grid.fbDiv2 = grid.bDiv.$clone();
      grid.fbDiv2.$removeClass().$addClass("ui-ygrid-fbdiv2").$appendStyles(new Map(Object.entries({
        width: "",
        left: "0px",
        right: "0px",
        top: hdiv.offsetHeight + "px",
        height: divh + "px",
        "z-index": 20
      }))).$appendTo(grid.view);
      grid.fbTbl2 = grid.fbDiv2.childNode().lastNode();
      grid.fbColGroup2 = grid.fbTbl2.childNode();
      Object.assign(grid.fbTbl2, tableProps);
      grid.fbTbl2.refreshAlwaysShowEditor();
      grid.fbTbl2.$addStyle("left", bdiv.scrollLeft * -1 + "px");
      p.frozenRows = true;
      this.doLayout();
    },
    destroyFrozenRows() {
      if (p.frozenRows) {
        grid.fbDiv2.$remove();
        grid.fbDiv2 = null;
        grid.fbTbl2 = null;
        grid.fbColGroup2 = null;
        p.frozenRows = false;
      }
    },
    setFrozenLeftColumns() {
      var _a2;
      let frozenCount = p.freezeLeftColCnt;
      if (frozenCount == 0)
        return;
      let view = grid.view.getElm();
      let bdiv = grid.bDiv.getElm();
      let iCol = this.iCol(frozenCount - 1);
      let firstFrozen = !p.frozenLeftColumns;
      grid.fsl = firstFrozen ? bdiv.scrollLeft : grid.fsl;
      let headers = grid.headers, header;
      if (firstFrozen) {
        let divw = 0, hasVisibleColumn;
        for (let i = 0; i <= iCol; i++) {
          if (headers[i].visible) {
            divw += headers[i].el.getElm().getBoundingClientRect().width;
            if (headers[i].name !== "rn") {
              hasVisibleColumn = true;
            }
          }
        }
        if (!hasVisibleColumn) {
          return p.freezeLeftColCnt = 0;
        }
        divw -= bdiv.scrollLeft;
        grid.fhDiv = grid.hDiv.$clone();
        grid.fhDiv.$removeClass().$addClass("ui-ygrid-fhdiv").$appendStyles(new Map(Object.entries({
          width: divw + "px",
          left: "0px",
          top: "0px"
        }))).$appendTo(grid.view).childNode().$removeClass();
        grid.fhTbl = grid.fhDiv.$findByClassName("ui-ygrid-htable")[0].$appendStyles(new Map(Object.entries({
          left: "",
          width: "1px"
        })));
        grid.fhColGroup = grid.fhTbl.childNode();
        grid.fbDiv = build(h$1("div.ui-ygrid-fbdiv")).$appendTo(grid.view);
      }
      let rows = this.getRows();
      let frows = (_a2 = grid.fbTbl2) == null ? void 0 : _a2.getRows();
      let width = grid.fsl * -1;
      for (let i = 0; i <= iCol; i++) {
        header = headers[i];
        rows.forEach(function(row2, index2) {
          let td = row2.getChildElms()[i];
          td.$addStyle("position", "sticky").$addStyle("left", width + "px").$addStyle("z-index", 20);
        });
        frows && frows.forEach(function(row2, index2) {
          let td = row2.getChildElms()[i];
          td.$addStyle("position", "sticky").$addStyle("left", width + "px").$addStyle("z-index", 30);
        });
        headers[i].visible && (width += header.width);
      }
      grid.fbDiv.$addStyle("height", view.offsetHeight + "px").$addStyle("left", width + "px");
      if (firstFrozen) {
        grid.hTable.$addStyle("left", grid.fsl * -1 + "px");
        grid.bTable.$addStyle("left", grid.fsl * -1 + "px");
        grid.fhTbl.$addStyle("left", grid.fsl * -1 + "px");
        grid.bDiv.$setProp("scrollLeft", 0);
      }
      p.frozenLeftColumns = true;
    },
    destroyFrozenLeftColumns() {
      if (!p.frozenLeftColumns)
        return;
      grid.fhDiv.$remove();
      grid.fbDiv.$remove();
      grid.fhDiv = null;
      grid.fhTbl = null;
      grid.fbDiv = null;
      grid.fhColGroup = null;
      let frozenCount = p.freezeLeftColCnt;
      let iCol = this.iCol(frozenCount - 1);
      let rows = this.getRows();
      for (let i = 0; i <= iCol; i++) {
        rows.forEach(function(row2, index2) {
          let td = row2.getChildElms()[i];
          td.$addStyle("position", "").$addStyle("left", "").$addStyle("z-index", "");
        });
      }
      grid.hTable.$addStyle("left", "");
      grid.bTable.$addStyle("left", "");
      grid.bDiv.$setProp("scrollLeft", grid.bDiv.getProp("scrollLeft") + grid.fsl);
      grid.fsl = 0;
      p.freezeLeftColCnt = 0;
      p.frozenLeftColumns = false;
    },
    setFrozenRightColumns() {
      var _a2;
      let frozenCount = p.freezeRightColCnt;
      if (frozenCount == 0)
        return;
      let view = grid.view.getElm();
      let headers = grid.headers, header;
      let firstFrozen = !p.frozenRightColumns;
      if (firstFrozen) {
        let divw = 0;
        for (let i = p.columns.length - 1, count = 0; i >= 0 && count < frozenCount; i--, count++) {
          headers[i].visible && (divw += headers[i].el.getElm().getBoundingClientRect().width);
        }
        grid.fhDiv3 = grid.hDiv.$clone();
        grid.fhDiv3.$removeClass().$addClass("ui-ygrid-fhDiv3").$appendStyles(new Map(Object.entries({
          width: divw + "px",
          right: "0px",
          top: "0px"
        }))).$setCustomData("width", divw).$appendTo(grid.view).childNode().$removeClass();
        grid.fhTbl3 = grid.fhDiv3.$findByClassName("ui-ygrid-htable")[0].$appendStyles(new Map(Object.entries({
          width: "1px"
        })));
        grid.fhColGroup3 = grid.fhTbl3.childNode();
        grid.fbDiv3 = build(h$1("div.ui-ygrid-fbdiv3")).$appendTo(grid.view);
      }
      let rows = this.getRows();
      let frows = (_a2 = grid.fbTbl2) == null ? void 0 : _a2.getRows();
      let width = 0;
      for (let i = p.columns.length - 1, count = 0; i >= 0 && count < frozenCount; i--, count++) {
        header = headers[i];
        rows.forEach(function(row2, index2) {
          let td = row2.getChildElms()[i];
          td.$addStyle("position", "sticky").$addStyle("right", width + "px").$addStyle("z-index", 20);
        });
        frows && frows.forEach(function(row2, index2) {
          let td = row2.getChildElms()[i];
          td.$addStyle("position", "sticky").$addStyle("right", width + "px").$addStyle("z-index", 30);
        });
        headers[i].visible && (width += header.width);
      }
      grid.fbDiv3.$addStyle("height", view.offsetHeight + "px").$addStyle("right", width + "px");
      grid.fhTbl3.$addStyle("left", (p.tblWidth - width) * -1 + "px");
      p.frozenRightColumns = true;
      this.doLayout();
    },
    destroyFrozenRightColumns() {
      if (!p.frozenRightColumns)
        return;
      grid.fhDiv3.$remove();
      grid.fbDiv3.$remove();
      grid.fhDiv3 = null;
      grid.fbDiv3 = null;
      grid.fhTbl3 = null;
      grid.fhColGroup3 = null;
      let rows = this.getRows();
      for (let i = p.columns.length - 1, count = 0; i >= 0 && count < p.freezeRightColCnt; i--, count++) {
        rows.forEach(function(row2, index2) {
          let td = row2.getChildElms()[i];
          td.$addStyle("position", "").$addStyle("right", "").$addStyle("z-index", "");
        });
      }
      p.freezeRightColCnt = 0;
      p.frozenRightColumns = false;
    },
    frozenRow(frozenCnt) {
      if (p.frozenRows) {
        this.destroyFrozenRows();
        this.updateFrozenOpt();
      }
      if (frozenCnt == null || frozenCnt <= 0) {
        return false;
      }
      p.freezeRowCnt = frozenCnt;
      this.setFrozenRows();
      this.updateFrozenOpt();
    },
    frozenLeftColumn(frozenCnt) {
      if (p.frozenLeftColumns) {
        this.destroyFrozenLeftColumns();
        this.updateFrozenOpt();
      }
      if (frozenCnt == null || frozenCnt <= 0) {
        return false;
      }
      p.freezeLeftColCnt = frozenCnt;
      this.setFrozenLeftColumns();
      this.updateFrozenOpt();
    },
    frozenRightColumn(frozenCnt) {
      if (p.frozenRightColumns) {
        this.destroyFrozenRightColumns();
        this.updateFrozenOpt();
      }
      if (frozenCnt == null || frozenCnt <= 0) {
        return false;
      }
      p.freezeRightColCnt = frozenCnt;
      this.setFrozenRightColumns();
      this.updateFrozenOpt();
    },
    frozenLeftRowColumn(frozenRowCnt, frozenColCnt) {
      if (p.frozenRows || p.frozenLeftColumns) {
        this.destroyFrozenRows();
        this.destroyFrozenLeftColumns();
        p.frozenLeftRowCols = false;
        this.updateFrozenOpt();
      }
      if (frozenRowCnt == null || frozenColCnt == null || frozenRowCnt <= 0 || frozenColCnt <= 0) {
        return false;
      }
      p.freezeRowCnt = frozenRowCnt;
      p.freezeLeftColCnt = frozenColCnt;
      this.setFrozenRows();
      this.setFrozenLeftColumns();
      p.frozenLeftRowCols = true;
      this.updateFrozenOpt();
    },
    frozenRightRowColumn() {
      let focusRow = selectModel.focusRow, focusCol = selectModel.focusCol;
      if (p.frozenRows || p.frozenRightColumns) {
        this.destroyFrozenRows();
        this.destroyFrozenRightColumns();
        p.frozenRightRowCols = false;
      } else {
        if (focusRow == -1 || focusCol == -1) {
          return false;
        }
        p.freezeRowCnt = focusRow;
        p.freezeRightColCnt = p.columns.length - p.delta - focusCol - 1;
        this.setFrozenRows();
        this.setFrozenRightColumns();
        p.frozenRightRowCols = true;
      }
      this.updateFrozenOpt();
    },
    doFrozen() {
      this.addPostpatchHook((el2) => {
        if (p.freezeRowCnt > 0) {
          this.setFrozenRows();
        }
        if (p.freezeLeftColCnt > 0) {
          this.setFrozenLeftColumns();
        }
        if (p.freezeRightColCnt > 0) {
          this.setFrozenRightColumns();
        }
        if (p.freezeRowCnt > 0 && p.freezeLeftColCnt > 0) {
          p.frozenLeftRowCols = true;
        }
        if (p.freezeRowCnt > 0 && p.freezeRightColCnt > 0) {
          p.frozenRightRowCols = true;
        }
        this.updateFrozenOpt();
      });
    },
    populate(renderInfo) {
      let VIEW_COUNT = renderInfo.VIEW_COUNT;
      if (VIEW_COUNT > 0) {
        grid.VIEW_COUNT = VIEW_COUNT;
        let { scrollIndex, scrollTop, focusRowIndex } = renderInfo;
        let willScroll = scrollIndex > VIEW_COUNT && scrollIndex < p.data.length || focusRowIndex > VIEW_COUNT && focusRowIndex < p.data.length || scrollTop > 0;
        if (!willScroll) {
          this.render();
        }
        this.updateScroll(renderInfo);
      } else {
        grid.bDiv.addPostpatchHook(() => {
          this.render(renderInfo);
          this.updateScroll(renderInfo);
        });
      }
    },
    render() {
      if (grid.bDiv.isRemoved()) {
        return;
      }
      let bDiv = grid.bDiv.getElm();
      if (bDiv) {
        grid.VIEW_COUNT = Math.ceil(bDiv.clientHeight / p.rowHeight);
      }
      grid.doRender();
    },
    selectGridColumn(colIndex, shiftKey, ctrlKey, button) {
      var _a2, _b2, _c;
      let selectedCols = selectModel.getSelectedColumns();
      if (selectedCols.includes(colIndex) && button == 2) {
        return;
      }
      let cancelCols = [], selCols = [];
      if (colIndex >= 0) {
        if (ctrlKey) {
          let index2 = selectedCols.indexOf(colIndex);
          if (index2 >= 0) {
            selectedCols.splice(index2, 1);
            cancelCols.push(colIndex);
          } else {
            selectedCols.push(colIndex);
            selCols.push(colIndex);
          }
        } else if (shiftKey) {
          let focusCol = selectModel.getFocusCol();
          if (focusCol >= 0) {
            let startCol = Math.min(focusCol, colIndex);
            let endCol = Math.max(focusCol, colIndex);
            for (let i = startCol; i <= endCol; i++) {
              if (!selectedCols.includes(i)) {
                selectedCols.push(i);
                selCols.push(i);
              }
            }
          } else {
            selectedCols.length = 0;
            selectedCols.push(colIndex);
            selCols.push(colIndex);
          }
        } else {
          cancelCols = selectedCols.slice();
          selectedCols.length = 0;
          selectedCols.push(colIndex);
          selCols.push(colIndex);
        }
      } else {
        cancelCols = selectedCols.slice();
        selectedCols.length = 0;
      }
      let { start, end } = this.getRowRange();
      if (cancelCols) {
        for (let i = 0; i < cancelCols.length; i++) {
          let el2 = grid.headers[cancelCols[i] + p.delta].el, id = el2.getAttr("id");
          el2.$removeClass("active");
          (_a2 = grid.fhDiv) == null ? void 0 : _a2.$findById(id).$removeClass("active");
          for (let k2 = start; k2 <= end; k2++) {
            this.unselect(k2, cancelCols[i], cancelCols[i]);
          }
        }
      }
      if (!shiftKey && !ctrlKey) {
        grid.hDiv.$findByClassName("active").forEach((el2) => el2.$removeClass("active"));
        (_b2 = grid.fhDiv) == null ? void 0 : _b2.$findByClassName("active").forEach((el2) => el2.$removeClass("active"));
      }
      let { left, right, top, bottom, focusRowId, activeRow } = selectModel;
      if (top != -1 && bottom != -1 && left != -1 && right != -1) {
        for (let i = top; i <= bottom; i++) {
          if (i >= start && i <= end) {
            this.unselect(i, left, right);
          }
        }
        if (focusRowId) {
          let rowIndex2 = p.indexById(focusRowId);
          this.unselect(rowIndex2, left, right);
        }
        if (activeRow) {
          let row2 = this.getRow(activeRow);
          let el2 = row2 == null ? void 0 : row2.getChildElms()[0];
          el2 == null ? void 0 : el2.$removeClass("ui-state-highlight");
        }
      }
      for (let i = 0; i < selCols.length; i++) {
        let el2 = grid.headers[selCols[i] + p.delta].el, id = el2.getAttr("id");
        el2.$addClass("active");
        (_c = grid.fhDiv) == null ? void 0 : _c.$findById(id).$addClass("active");
        for (let k2 = start; k2 <= end; k2++) {
          this.select(k2, selCols[i], selCols[i]);
        }
      }
      selectModel.selectRange(-1, -1, -1, -1, -1, colIndex, null, false);
    },
    selectGridRow(left, top, right, bottom, focusRow, focusCol, shiftKey, trigger, selectRow) {
      let p2 = this.p, count = p2.columns.length - p2.delta, oldFocusRow = selectModel.focusRow, oldFocusCol = selectModel.focusCol;
      if (arguments.length == 1) {
        left = 0;
        focusCol = 0;
        right = p2.columns.length - p2.delta;
        top = bottom = focusRow = arguments[0];
      } else {
        if (shiftKey) {
          left = Math.min(left, oldFocusCol);
          top = Math.min(top, oldFocusRow);
          right = Math.max(right, oldFocusCol);
          bottom = Math.max(bottom, oldFocusRow);
        }
      }
      let focusRowId = null;
      if (focusRow != -1 && trigger != false) {
        focusRowId = p2.data[focusRow].rowId;
      }
      let mode = selectModel.getMode();
      if (selectRow) {
        mode = selectModel.RANGE;
      }
      switch (mode) {
        case selectModel.RANGE:
          selectModel.selectRange(left, top, right, bottom, focusRow, focusCol, focusRowId, selectRow);
          break;
        case selectModel.ROW:
          selectModel.selectRange(0, focusRow, count - 1, focusRow, focusRow, focusCol, focusRowId);
          break;
        case selectModel.CELL:
          selectModel.selectRange(focusCol, focusRow, focusCol, focusRow, focusRow, focusCol, focusRowId);
          break;
      }
      this.setFocusStyle();
    },
    setFocusStyle() {
      var _a2;
      let { oldLeft, oldRight, oldTop, oldBottom, activeRow, oldActiveRow } = selectModel;
      let { start, end } = this.getRowRange();
      if (oldTop != -1 && oldBottom != -1 && oldLeft != -1 && oldRight != -1) {
        for (let i = oldTop; i <= oldBottom; i++) {
          if (i >= start && i <= end) {
            this.unselect(i, oldLeft, oldRight);
          }
        }
        let oldRowId = selectModel.getOldFocusRowId();
        if (oldRowId) {
          let oldIndex2 = p.indexById(oldRowId);
          this.unselect(oldIndex2, oldLeft, oldRight);
        }
      }
      let selectedCols = selectModel.getSelectedColumns();
      for (let i = 0; i < selectedCols.length; i++) {
        let el2 = grid.headers[selectedCols[i] + p.delta].el, id = el2.getAttr("id");
        el2.$removeClass("active");
        (_a2 = grid.fhDiv) == null ? void 0 : _a2.$findById(id).$removeClass("active");
        for (let k2 = start; k2 <= end; k2++) {
          this.unselect(k2, selectedCols[i], selectedCols[i]);
        }
      }
      selectedCols.length = 0;
      if (oldActiveRow > -1 && oldActiveRow != activeRow) {
        let row2 = this.getRow(oldActiveRow);
        let el2 = row2 == null ? void 0 : row2.getChildElms()[0];
        el2 == null ? void 0 : el2.$removeClass("ui-state-highlight");
      }
      if (activeRow > -1 && oldActiveRow != activeRow) {
        let row2 = this.getRow(activeRow);
        let el2 = row2 == null ? void 0 : row2.getChildElms()[0];
        el2 == null ? void 0 : el2.$addClass("ui-state-highlight");
      }
      let left = selectModel.left, right = selectModel.right, top = selectModel.top, bottom = selectModel.bottom;
      if (top != -1 && bottom != -1 && left != -1 && right != -1) {
        for (let i = top; i <= bottom; i++) {
          if (i >= start && i <= end) {
            this.select(i, left, right);
          }
        }
      }
    },
    doFocusPolicy(keyCode) {
      this.doFocusPolicyImpl(keyCode) || p.requestNextFocus(keyCode);
    },
    doFocusPolicyImpl(keyCode) {
      let row2 = selectModel.focusRow, col = selectModel.focusCol;
      if (row2 == -1 || col == -1) {
        return false;
      }
      switch (keyCode) {
        case 13:
        case 108:
          let cell = this.getCell(row2, col);
          switch (cell.getCustomData("type")) {
            case "button":
            case "hyperlink":
            case "checkbox":
              let el2 = cell.getCustomData("editor").getEl();
              el2.$callSync("click");
              return true;
            default:
              return this.changeFocus(keyCode);
          }
        case 9:
          return this.changeFocus(keyCode);
      }
      return true;
    },
    changeFocus(keyCode, dir = "right") {
      let row2 = selectModel.focusRow, column = selectModel.focusCol, columns = p.columns;
      if (row2 == -1 || column == -1)
        return;
      let findFocusPos = (row22, column2, dir2) => {
        let pos2 = { row: row22, column: column2 }, cl = columns.length;
        let iCol = this.iCol(column2);
        if (dir2 === "next") {
          for (let i = iCol + 1; i < cl; i++) {
            if (columns[i].visible) {
              pos2.row = row22;
              pos2.column = i - p.delta;
              return pos2;
            }
          }
          if (keyCode != 13 && keyCode != 108) {
            for (let i = row22 + 1; ; i++) {
              let row3 = this.getRow(i);
              if (!row3) {
                break;
              }
              if (row3.getStyle("display") === "none") {
                continue;
              }
              for (let j = p.delta; j < cl; j++) {
                if (columns[j].visible) {
                  pos2.row = i, pos2.column = j - p.delta;
                  return pos2;
                }
              }
            }
          }
        } else if (dir2 === "pre") {
          for (let i = iCol - 1; i >= p.delta; i--) {
            if (columns[i].visible) {
              pos2.row = row22, pos2.column = i - p.delta;
              return pos2;
            }
          }
          for (let i = row22 - 1; i > 0; --i) {
            let row3 = this.getRow(i);
            if (!row3) {
              break;
            }
            if (row3.getStyle("display") === "none") {
              continue;
            }
            for (let j = cl - 1; j >= p.delta; j--) {
              if (columns[j].visible) {
                pos2.row = i, pos2.column = j - p.delta;
                return pos2;
              }
            }
          }
        }
        return pos2;
      };
      let pos = {};
      switch (dir) {
        case "left":
          pos = findFocusPos(row2, column, "pre");
          break;
        case "top":
          pos.row = this.getRow(row2 - 1) ? row2 - 1 : row2, pos.column = column;
          break;
        case "right":
          pos = findFocusPos(row2, column, "next");
          break;
        case "bottom":
          pos.row = this.getRow(row2 + 1) ? row2 + 1 : row2, pos.column = column;
          break;
      }
      if (pos.row > -1 && pos.column > -1 && (pos.row != row2 || pos.column != column)) {
        this.setCellFocus(pos.row, pos.column, true);
        return true;
      }
      return false;
    },
    cleanSelection() {
      this.selectGridRow(-1, -1, -1, -1, -1, -1);
      this.selectGridColumn(-1);
    },
    clearRows() {
      tbody.getChildElms().forEach((tr) => tr.$remove());
    },
    clearGridData() {
      this.clearRows();
      this.renderRange = { start: 0, after: 0, end: 0 };
      p.editInfo = null;
      grid.hDiv.$setProp("scrollTop", 0);
      grid.bDiv.$setProp("scrollTop", 0);
      grid.bDiv.$setProp("scrollLeft", 0);
      this.updateScroll();
    },
    setColumnCaption(vcolIndex, caption) {
      let el2 = grid.headers[this.iCol(vcolIndex)].el;
      el2.$findByClassName("col-caption")[0].$setInnerText(caption);
    },
    setColumnVisible(vcolIndex, visible) {
      let iCol = this.iCol(vcolIndex);
      let header = grid.headers[iCol];
      let col = grid.hColGroup.getChildElms()[iCol];
      if (visible) {
        header.el.$show();
        col.$show();
      } else {
        header.el.$hide();
        col.$hide();
      }
      header.visible = visible;
      let curTR = grid.ltr;
      let parent2 = header.el.getAttr("parent");
      while (parent2 != null) {
        let preTR = curTR.$prev();
        let parentTH = preTR.$find((th) => th.getAttr("colkey") == parent2)[0];
        let colspan = parentTH.isHide() ? 0 : parseInt(parentTH.getAttr("colspan"));
        if (visible) {
          parentTH.$setAttr("colspan", colspan + 1);
          if (parentTH.isHide()) {
            parentTH.$show();
          }
        } else {
          parentTH.$setAttr("colspan", colspan - 1 || 1);
          if (colspan == 1) {
            parentTH.$hide();
          }
        }
        curTR = preTR;
        parent2 = parentTH.getAttr("parent");
      }
      let bcol = grid.bColGroup.getChildElms()[iCol];
      if (visible) {
        bcol.$show();
      } else {
        bcol.$hide();
      }
      let rows = this.getRows();
      rows.forEach(function(row2) {
        let $cell = row2.getChildElms()[iCol];
        if (visible) {
          $cell.$show();
        } else {
          $cell.$hide();
        }
      });
      if (visible) {
        p.tblWidth += header.width;
      } else {
        p.tblWidth -= header.width;
      }
      grid.hTable.$addStyle("width", p.tblWidth + "px");
      grid.bTable.$addStyle("width", p.tblWidth + "px");
    },
    editCell(rowIndex2, colIndex, keyCode, event2) {
      let $t = this;
      if (!$t.grid) {
        return;
      }
      let iRow = $t.iRow(rowIndex2), iCol = $t.iCol(colIndex);
      let editRow = $t.getRow(rowIndex2);
      if (!editRow) {
        return;
      }
      let editCell = editRow.getChildElms()[iCol];
      let editor = editCell.getCustomData("editor");
      if (editor) {
        return;
      }
      if (p.editInfo) {
        $t.endEdit(p.editInfo.ri, p.editInfo.ci, p.editInfo.vci);
        p.editInfo = null;
      }
      let column = p.columns[iCol];
      let orgIndex = column.orgIndex;
      let rowData = p.data[rowIndex2];
      let cellData = rowData.data[orgIndex];
      let editOpt = cellData.meta;
      if (editOpt.type == "dynamic") {
        editOpt = cellData.typeDef;
      }
      if (column.type == "seq" || column.type == "rowexpand" || rowData.rowType == "Total" || rowData.rowType == "Group" || cellData.enable == false || !editOpt || editOpt.isAlwaysShow) {
        return;
      }
      const popElms = editCell.$findByClassName("popup-dic-td");
      if (popElms && popElms.length == 1) {
        popElms[0].$addClass("ui-hidden");
      }
      let options2 = { keyCode, ir: iRow, ic: iCol, name: column.name, event: event2 };
      p.createCellEditor(editOpt, editCell, rowIndex2, orgIndex, colIndex, options2);
      editCell.$removeClass("space").$addClass("ui-edit-cell");
      p.editInfo = { ir: iRow, ic: iCol, ri: rowIndex2, ci: orgIndex, vci: colIndex };
      return true;
    },
    endEdit(ri, ci, vci, update) {
      if (arguments.length == 0 && p.editInfo) {
        ri = p.editInfo.ri;
        ci = p.editInfo.ci;
        vci = p.editInfo.vci;
      }
      let cell = this.getCandidateCell(ri, vci);
      if (!cell)
        return;
      let editor = cell.getCustomData("editor");
      if (!editor) {
        return;
      }
      cell.$setCustomData("editor", null);
      p.editInfo = null;
      editor.destory();
      setTimeout(() => {
        if (!cell.getCustomData("editor")) {
          cell.$addClass("space").$removeClass("ui-edit-cell");
        }
      });
      if (update) {
        this.updateCell(ri, ci, vci);
      }
      const popElms = cell.$findByClassName("popup-dic-td");
      if (popElms && popElms.length == 1) {
        popElms[0].$removeClass("ui-hidden");
      }
    },
    addCellClass(rowIndex2, vcolIndex, className) {
      let cells = this.getCandidateCells(rowIndex2, vcolIndex);
      cells.forEach((cell) => className.forEach((clazz) => cell.$addClass(clazz)));
      return this;
    },
    removeCellClass(rowIndex2, vcolIndex, className) {
      let cells = this.getCandidateCells(rowIndex2, vcolIndex);
      cells.forEach((cell) => className.forEach((clazz) => cell.$removeClass(clazz)));
      return this;
    },
    setCellMatched(rowIndex2, vcolIndex, matched) {
      let cells = this.getCandidateCells(rowIndex2, vcolIndex);
      if (matched) {
        cells.forEach((cell) => cell.$addClass("search-matched-cell"));
      } else {
        cells.forEach((cell) => cell.$removeClass("search-matched-cell"));
      }
    },
    removeAllMatched() {
      this.$findByClassName("search-matched-cell").forEach(($td) => $td.$removeClass("search-matched-cell"));
    },
    updateHalfChecked(rowIndex2, colIndex, vcolIndex) {
      let cells = this.getCandidateCells(rowIndex2, vcolIndex);
      let cellData = p.data[rowIndex2].data[colIndex];
      cells.forEach((cell) => {
        let editor = cell.getCustomData("editor");
        if (editor) {
          editor.setValue(cellData.value, cellData.halfChecked);
        }
      });
    },
    updateCell(rowIndex2, colIndex, vcolIndex) {
      let cells = this.getCandidateCells(rowIndex2, vcolIndex);
      let cellData = p.data[rowIndex2].data[colIndex];
      cells.forEach((cell) => {
        this.impl_setCellCaption(cell, cellData);
        this.impl_setCellNegtive(cell, cellData);
      });
    },
    setCellCaption(rowIndex2, colIndex, vcolIndex) {
      let cells = this.getCandidateCells(rowIndex2, vcolIndex);
      let cellData = p.data[rowIndex2].data[colIndex];
      cells.forEach((cell) => {
        this.impl_setCellCaption(cell, cellData);
      });
    },
    impl_setCellCaption(cell, cellData) {
      let editor = cell.getCustomData("editor");
      let { value, caption } = cellData;
      if (editor) {
        editor.setValue(value).setShowText(caption);
      } else {
        let $span = cell.$findByClassName("cell--label")[0];
        if (!$span) {
          $span = build(h$1("span.cell--label"));
          build(h$1("div.ygrid-cell")).$append($span).$appendTo(cell);
        }
        caption = escape$1(caption);
        $span.$setInnerText(caption);
      }
      if (p.search_text) {
        if (caption.includes(p.search_text)) {
          cell.$addClass("search-matched-cell");
        } else {
          cell.$removeClass("search-matched-cell");
        }
      }
      if (!cellData.meta.formulaTip) {
        cell.$setAttr("title", cellData.caption);
      }
    },
    impl_setCellNegtive(cell, cellData) {
      if (cellData.meta.editOptions.negtiveForeColor) {
        if (cellData.value == null || cellData.value.lt(0)) {
          cell.$addStyle("color", cellData.foreColor);
        } else {
          cell.$addStyle("color", "");
        }
      }
    },
    setColumnRequired(vcolIndex, required) {
      let cells = this.getCandidateCellsByRowRange(vcolIndex);
      cells.forEach((cell) => {
        if (required) {
          cell.$addClass("ygrid-cell-required");
          cell.$setAttr("requireInfo", I18N.getString("CONTROL_REQUIRED", "必填"));
        } else {
          cell.$removeClass("ygrid-cell-required");
          cell.$setAttr("requireInfo", null);
        }
      });
    },
    setColumnEnable(vcolIndex, enable) {
      let cells = this.getCandidateCellsByRowRange(vcolIndex);
      cells.forEach((cell) => {
        let editor = cell.getCustomData("editor");
        if (editor) {
          editor.setEnable(enable);
        }
        if (enable) {
          cell.$removeClass("ui-cell-disabled");
        } else {
          cell.$addClass("ui-cell-disabled");
        }
      });
    },
    setCellEnable(rowIndex2, vcolIndex, enable) {
      let cells = this.getCandidateCells(rowIndex2, vcolIndex);
      cells.forEach((cell) => {
        this.impl_setCellEnable(cell, enable);
      });
    },
    impl_setCellEnable(cell, enable) {
      let editor = cell.getCustomData("editor");
      if (editor) {
        editor.setEnable(enable);
      }
      if (enable) {
        cell.$removeClass("ui-cell-disabled");
      } else {
        cell.$addClass("ui-cell-disabled");
      }
    },
    setCellRequired(rowIndex2, vcolIndex, required) {
      let cells = this.getCandidateCells(rowIndex2, vcolIndex);
      cells.forEach((cell) => {
        this.impl_setCellRequired(cell, required);
      });
    },
    impl_setCellRequired(cell, required) {
      if (required) {
        cell.$addClass("ygrid-cell-required");
        cell.$setAttr("requireInfo", I18N.getString("CONTROL_REQUIRED", "必填"));
      } else {
        cell.$removeClass("ygrid-cell-required");
        cell.$setAttr("requireInfo", null);
      }
    },
    setRowError(rowIndex2, error, errorMsg) {
      if (!p.showRowHead())
        return;
      let rows = this.getCandidateRows(rowIndex2);
      rows.forEach((row2) => {
        this.impl_setCellError(row2.childNode(), error, errorMsg);
        if (error == false) {
          row2.childNode().$removeClass("search-matched-cell-selected");
        }
      });
    },
    setCellError(rowIndex2, colIndex, error, errorMsg) {
      let cells = this.getCandidateCells(rowIndex2, colIndex);
      cells.forEach((cell) => {
        this.impl_setCellError(cell, error, errorMsg);
        if (error == false) {
          cell.$removeClass("search-matched-cell-selected");
        }
      });
    },
    impl_setCellError(cell, error, errorMsg) {
      if (error) {
        cell.$addClass("ygrid-cell-error");
        cell.$setAttr("errorInfo", errorMsg);
      } else {
        cell.$removeClass("ygrid-cell-error");
        cell.$setAttr("errorInfo", null);
      }
    },
    impl_setCellSelected(cell, selected) {
      if (selected) {
        cell.$addClass("search-matched-cell-selected");
      } else {
        cell.$removeClass("search-matched-cell-selected");
      }
    },
    impl_setCellMatched: function(cell, caption) {
      if (caption && p.search_text && caption.includes(p.search_text)) {
        cell.$addClass("search-matched-cell");
      } else {
        cell.$removeClass("search-matched-cell");
      }
    },
    impl_setCellFocus(cell, row2, col) {
      if (selectModel.isFocusCell(row2, col) || selectModel.isSelectColumn(col)) {
        cell.$addClass("ui-state-highlight");
      } else {
        cell.$removeClass("ui-state-highlight");
      }
    },
    setCellBackColor(rowIndex2, colIndex, color2) {
      let cells = this.getCandidateCells(rowIndex2, colIndex);
      cells.forEach((cell) => {
        this.impl_setBackColor(cell, color2);
      });
    },
    setCellForeColor(rowIndex2, colIndex, color2) {
      let cells = this.getCandidateCells(rowIndex2, colIndex);
      cells.forEach((cell) => {
        this.impl_setForeColor(cell, color2);
      });
    },
    setRowBackColor(ri, color2) {
      let rows = this.getCandidateRows(ri);
      rows.forEach((row2) => {
        this.impl_setBackColor(row2, color2, true);
      });
    },
    batchUpdateUI(start, end, updateCaption, updateUI, updateWidth) {
      console.time("batchUpdateUI");
      let rows = this.getRows();
      if (rows.length > 0) {
        let dataRange = { start, end };
        let viewRange = this.getRowRange(rows);
        let updateRange = Range$1.intersect(dataRange, viewRange);
        if (!Range$1.isEmpty(updateRange)) {
          let view_i = this.getViewIndex(updateRange.start, rows);
          let data_i = parseInt(stripPref(uidPref, rows[view_i].getAttr("id")), 10);
          for (let i = data_i, k2 = view_i, count = 0; count < end - start; i++, k2++, count++) {
            let viewRow = rows[k2], dataRow = p.data[i];
            if (!viewRow || !dataRow)
              continue;
            let viewCells = viewRow.getChildElms();
            for (let j = p.delta; j < viewCells.length; j++) {
              let viewCell = viewCells[j];
              let dataCell = dataRow.data[p.columns[j].orgIndex];
              if (updateCaption) {
                this.impl_setCellCaption(viewCell, dataCell);
              }
              if (updateUI) {
                this.impl_setCellEnable(viewCell, dataCell.enable);
                this.impl_setCellRequired(viewCell, dataCell.required);
                this.impl_setCellError(viewCell, dataCell.error, dataCell.errorMsg);
              }
            }
          }
        }
      }
      if (updateWidth) {
        if (p.defaultFitWidth) {
          p.toFitWidth();
        } else {
          p.doFrozen();
        }
      }
      console.timeEnd("batchUpdateUI");
    },
    setRowSelected(rowIndex2, selected) {
      return this.setCellSelected(rowIndex2, -1, selected);
    },
    setCellSelected(rowIndex2, vcolIndex, selected) {
      let select2 = (cells2) => {
        cells2.forEach((cell) => {
          cell.$addClass("search-matched-cell-selected");
          cell.addPostpatchHook((cell2) => {
            cell2.getElm().scrollIntoView({
              block: "nearest",
              // 如果元素已经在可见区域内，则垂直方向不发生滚动。如果元素未能完全在可见区域内，则根据最短滚动距离原则，垂直方向滚动父级容器，使元素完全在可见区域内。
              inline: "nearest"
              // 如果元素已经在可见区域内，则水平方向不发生滚动。如果元素未能完全在可见区域内，则根据最短滚动距离原则，水平方向滚动父级容器，使元素完全在可见区域内。
            });
          });
        });
      };
      let unselect = (cells2) => {
        cells2.forEach((cell) => cell.$removeClass("search-matched-cell-selected"));
      };
      let cells = this.getCandidateCells(rowIndex2, vcolIndex);
      if (selected) {
        if (cells.length > 0) {
          select2(cells);
        } else {
          let btbl = grid.bTable.getElm();
          let bdiv = grid.bDiv.getElm();
          let totalH = (rowIndex2 + 1) * p.rowHeight;
          let scrollTop = totalH - bdiv.offsetHeight;
          if (btbl.offsetWidth > bdiv.clientWidth) {
            scrollTop += p.scrollBarWidth;
          }
          bdiv.scrollTop = scrollTop;
          p.postScrollHook = () => {
            let cells2 = this.getCandidateCells(rowIndex2, vcolIndex);
            if (cells2.length > 0) {
              select2(cells2);
            }
          };
        }
      } else {
        if (cells.length > 0) {
          unselect(cells);
        }
      }
    },
    async setCellFocus(rowIndex2, colIndex, trigger) {
      if (rowIndex2 >= p.data.length) {
        return this.cleanSelection();
      }
      if (trigger != false) {
        await this.doFocusEvent(rowIndex2, colIndex);
      }
      let select2 = (cells2) => {
        cells2.forEach((cell) => {
          this.setFocusStyle();
          cell.addPostpatchHook((cell2) => {
            cell2.getElm().scrollIntoView({
              block: "nearest",
              // 如果元素已经在可见区域内，则垂直方向不发生滚动。如果元素未能完全在可见区域内，则根据最短滚动距离原则，垂直方向滚动父级容器，使元素完全在可见区域内。
              inline: "nearest"
              // 如果元素已经在可见区域内，则水平方向不发生滚动。如果元素未能完全在可见区域内，则根据最短滚动距离原则，水平方向滚动父级容器，使元素完全在可见区域内。
            });
          });
        });
      };
      let cells = this.getCandidateCells(rowIndex2, colIndex);
      if (cells.length > 0) {
        select2(cells);
      } else {
        this.addPostpatchHook(() => {
          let btbl = grid.bTable.getElm();
          let bdiv = grid.bDiv.getElm();
          let totalH = (rowIndex2 + 1) * p.rowHeight;
          let scrollTop = totalH - bdiv.offsetHeight;
          if (btbl.offsetWidth > bdiv.clientWidth) {
            scrollTop += p.scrollBarWidth;
          }
          console.log(p.id, "scrollTop", scrollTop);
          bdiv.scrollTop = scrollTop;
          p.postScrollHook = () => {
            let cells2 = this.getCandidateCells(rowIndex2, colIndex);
            if (cells2.length > 0) {
              select2(cells2);
            }
          };
        });
      }
      this.knvFocus();
    },
    async doFocusEvent(rowIndex2, vcolIndex) {
      let oldRowIndex = selectModel.focusRow;
      let oldRowId = selectModel.focusRowId;
      this.selectGridRow(vcolIndex, rowIndex2, vcolIndex, rowIndex2, rowIndex2, vcolIndex, false, true);
      let curRowIndex = selectModel.focusRow;
      let curRowId = selectModel.focusRowId;
      await p.clickRow(rowIndex2, oldRowIndex);
      if (curRowIndex !== oldRowIndex || oldRowId !== curRowId) {
        await p.rowChanged(rowIndex2, oldRowIndex);
      }
    },
    scrollVisibleCell(rowIndex2, vcolIndex) {
      let vrow = this.getRow(rowIndex2);
      if (!vrow)
        return;
      let col = this.iCol(vcolIndex);
      let cell = vrow.getChildElms()[col];
      cell.addPostpatchHook((cell2) => {
        cell2.getElm().scrollIntoView({
          block: "nearest",
          // 如果元素已经在可见区域内，则垂直方向不发生滚动。如果元素未能完全在可见区域内，则根据最短滚动距离原则，垂直方向滚动父级容器，使元素完全在可见区域内。
          inline: "nearest"
          // 如果元素已经在可见区域内，则水平方向不发生滚动。如果元素未能完全在可见区域内，则根据最短滚动距离原则，水平方向滚动父级容器，使元素完全在可见区域内。
        });
      });
    },
    updateSelectAllVisible(vcolIndex, visible) {
      let chkAll = grid.headers[this.iCol(vcolIndex)].chkAll;
      if (visible) {
        chkAll == null ? void 0 : chkAll.$addStyle("display", "");
      } else {
        chkAll == null ? void 0 : chkAll.$addStyle("display", "none");
      }
    },
    cleanSelectAll() {
      grid.headers.forEach((h2) => {
        var _a2;
        return (_a2 = h2.chkAll) == null ? void 0 : _a2.$removeClass("checked halfChecked");
      });
    },
    findChkAll(iCol) {
      let chks = [];
      [grid.fhDiv, grid.fhDiv3].forEach(($div) => {
        if ($div) {
          let $th = $div.$find((ele) => ele.getHtmlTag() == "th" && parseInt(ele.getElm().getAttribute("colindex")) == iCol)[0];
          if ($th) {
            let $chk = $th.$findByClassName("chk")[0];
            if ($chk) {
              chks.push($chk);
            }
          }
        }
      });
      return chks;
    },
    updateSelectAll(vcolIndex, info) {
      let iCol = this.iCol(vcolIndex);
      let chks = this.findChkAll(iCol);
      let chkAll = grid.headers[iCol].chkAll;
      if (chkAll) {
        chks.unshift(chkAll);
      }
      chks.forEach(($chk) => {
        $chk.$removeClass("checked halfChecked");
        if (info == null ? void 0 : info.value) {
          if (info.halfChecked) {
            $chk.$addClass("halfChecked");
          } else {
            $chk.$addClass("checked");
          }
          $chk.$setAttr("checked", true);
        } else {
          $chk.$setAttr("checked", null);
        }
      });
    },
    buildGroupHeaders() {
      let $t = this;
      $t.rhlevel = 1;
      if (!$t.p.isGroup)
        return;
      let getColumnList = (columns) => {
        let _getColumnList = function(columns2) {
          let result = [];
          columns2.forEach(function(column) {
            result.push.apply(result, column.columns && column.columns.length ? _getColumnList(column.columns) : [column]);
          });
          return result;
        };
        return _getColumnList(columns);
      };
      let findGroupHeader2Build = function(columns) {
        let groupHeaders = [], children = [];
        for (let i = 0, column; column = columns[i]; i++) {
          if (column.columns && column.columns.length) {
            let leafColumns = getColumnList(column.columns);
            let groupHeader = {
              key: column.key,
              metaKey: column.metaKey,
              parentKey: column.parentKey,
              caption: column.caption,
              isColExpand: column.isColExpand,
              startColumnName: leafColumns[0].name,
              numberOfColumns: leafColumns.length,
              formulaCaption: column.formulaCaption
            };
            groupHeaders.push(groupHeader);
            children = children.concat(column.columns);
          }
        }
        if (groupHeaders.length > 0) {
          $t.addGroupHeaders(groupHeaders);
        }
        if (children.length > 0) {
          findGroupHeader2Build(children);
        }
      };
      findGroupHeader2Build($t.p.rootColumns);
      grid.hDiv.addPostpatchHook((el2) => {
        let chs = grid.hDiv.$findByClassName("ui-ygrid-multicolumnheader");
        for (let i = chs.length - 1, ch; ch = chs[i]; i--) {
          let chCells = ch.getChildElms();
          for (let ci = 0, rhci = 0, clen = chCells.length; ci < clen; ci++) {
            let chCell = chCells[ci];
            let span = parseInt(chCell.getAttr("span")) || 0;
            if (span > 0) {
              rhci += span;
            } else {
              let th = grid.headers[rhci].el;
              let rowSpan = (th.getAttr("rowSpan") || 1) + 1;
              th.$setAttr("rowSpan", rowSpan, { forcePatch: true }).$insertBefore(chCell);
              chCell.$remove();
              rhci++;
            }
          }
        }
      });
    },
    addGroupHeaders(groupHeaderArray) {
      let $t = this;
      $t.rhlevel++;
      let header = build(h$1("tr.ui-ygrid-columnheader.ui-ygrid-multicolumnheader", { attrs: { role: "columnheader" } })).$insertBefore(grid.ltr);
      let columns = $t.p.columns;
      for (let i = 0; i < columns.length; i++) {
        let colHeader = build(h$1("th.ui-state-default.ui-th-column.ui-th-ltr", {
          attrs: { role: "columnheader" },
          on: {
            mousedown(e) {
              p.recordClick(e.target.getAttribute("meta-key"));
              $table.selectGridColumn(-1);
              colHeader.$addClass("active");
            }
          }
        })).$appendTo(header);
        let index2 = -1;
        for (let k2 = 0; k2 < groupHeaderArray.length; k2++) {
          if (groupHeaderArray[k2].startColumnName === columns[i].name) {
            index2 = k2;
            break;
          }
        }
        if (index2 >= 0) {
          let groupInfo = groupHeaderArray[index2];
          let count = groupInfo.numberOfColumns, colspan = 0;
          for (let iCol = 0; iCol < count && i + iCol < columns.length; iCol++) {
            if (!columns[i + iCol].visible)
              continue;
            colspan += 1;
          }
          if (colspan == 0) {
            colHeader.$hide();
          }
          colHeader.$setInnerText(groupInfo.caption).$setAttr("meta-key", groupInfo.metaKey).$setAttr("colkey", groupInfo.key).$setAttr("parent", groupInfo.parentKey).$setAttr("meta-type", "columnheader").$setAttr("colexpand", groupInfo.isColExpand).$setAttr("span", count).$setAttr("colspan", colspan).$setAttr("title", groupInfo.caption);
          i += count - 1;
          if (groupInfo.formulaCaption) {
            $t.p.asyncEval(groupInfo.formulaCaption).then(function(header2) {
              return function(caption) {
                header2.$setInnerText(caption).$setAttr("title", caption);
              };
            }(colHeader));
          }
        } else {
          if (!columns[i].visible) {
            colHeader.$hide();
          }
        }
      }
    },
    setGridWidth(width) {
      var _a2, _b2;
      grid.width = width;
      grid.view.$setWidth(width);
      grid.hDiv.$setWidth(width);
      grid.bDiv.$setWidth(width);
      (_a2 = grid.footer) == null ? void 0 : _a2.$setWidth(width);
      (_b2 = grid.header) == null ? void 0 : _b2.$setWidth(width);
    },
    setGridHeight(height) {
      if (!height) {
        grid.bDiv.$addStyle("flex", "1 1 auto");
      }
    },
    getCandidateTbl(ri, ci) {
      let iRow = this.iRow(ri), ftbl;
      if (p.frozenRows && iRow <= p.freezeRowCnt) {
        ftbl = grid.fbTbl2;
      }
      return ftbl;
    },
    getCandidateRows(ri) {
      let rows = [];
      let row2 = this.getRow(ri);
      row2 && rows.push(row2);
      let ftbl = this.getCandidateTbl(ri, 0);
      if (ftbl) {
        row2 = ftbl.getRow(ri);
        row2 && rows.push(row2);
      }
      return rows;
    },
    getCandidateRowsById(rowId) {
      let rows = [];
      let row2 = this.getRowById(rowId);
      row2 && rows.push(row2);
      let ftbl = grid.fbTbl2;
      if (grid.fbTbl2) {
        row2 = ftbl.getRowById(rowId);
        row2 && rows.push(row2);
      }
      return rows;
    },
    getCandidateCells(ri, ci) {
      let iCol = Math.max(this.iCol(ci), 0), cells = [];
      let row2 = this.getRow(ri);
      let cell = row2 && row2.getChildElms()[iCol];
      cell && cells.push(cell);
      let ftbl = this.getCandidateTbl(ri, ci);
      if (ftbl) {
        row2 = ftbl.getRow(ri);
        cell = row2 && row2.getChildElms()[iCol];
        cell && cells.push(cell);
      }
      return cells;
    },
    getCandidateCellsByRowId(rowId, ci) {
      let iCol = this.iCol(ci), cells = [];
      let row2 = this.getRowById(rowId);
      let cell = row2 && row2.getChildElms()[iCol];
      cell && cells.push(cell);
      let ftbl = grid.fbTbl2;
      if (ftbl) {
        row2 = ftbl.getRowById(rowId);
        cell = row2 && row2.getChildElms()[iCol];
        cell && cells.push(cell);
      }
      return cells;
    },
    getCandidateCellsByRowRange(ci) {
      Math.max(this.iCol(ci), 0);
      let cells = [];
      let tbls = [this, grid.fbTbl2];
      tbls.forEach((tbl) => {
        if (tbl) {
          let rows = tbl.getRows();
          rows.length;
        }
      });
      return cells;
    },
    getCandidateCell(ri, ci) {
      let iCol = Math.max(this.iCol(ci), 0);
      let ftbl = this.getCandidateTbl(ri, ci);
      if (ftbl) {
        let row22 = ftbl.getRow(ri);
        return row22 && row22.getChildElms()[iCol];
      }
      let row2 = this.getRow(ri);
      return row2 && row2.getChildElms()[iCol];
    },
    unmount() {
      var _a2, _b2, _c, _d, _e, _f, _g, _h, _i, _j, _k, _l, _m, _n, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, _A, _B;
      const doc = document;
      doc.onselectstart = null;
      doc.removeEventListener("mouseup", this.mouseupHandler);
      (_a2 = observerMap.get(p.id)) == null ? void 0 : _a2.disconnect();
      observerMap.delete(p.id);
      (_b2 = grid.hDiv) == null ? void 0 : _b2.$removeListener();
      (_c = grid.bDiv) == null ? void 0 : _c.$removeListener();
      (_d = grid.bTable) == null ? void 0 : _d.$removeListener();
      (_e = grid.view) == null ? void 0 : _e.$removeListener();
      (_f = grid.bDiv) == null ? void 0 : _f.$remove();
      (_g = grid.hDiv) == null ? void 0 : _g.$remove();
      (_h = grid.fhDiv) == null ? void 0 : _h.$remove();
      (_i = grid.fbDiv) == null ? void 0 : _i.$remove();
      (_j = grid.fbDiv2) == null ? void 0 : _j.$remove();
      (_k = grid.view) == null ? void 0 : _k.$remove();
      (_l = grid.captionEl) == null ? void 0 : _l.$remove();
      (_m = grid.view) == null ? void 0 : _m.$removeListener();
      (_n = grid.view) == null ? void 0 : _n.$remove();
      (_o = grid.ltr) == null ? void 0 : _o.$remove();
      (_p = grid.footer) == null ? void 0 : _p.$remove();
      (_q = grid.toolEl) == null ? void 0 : _q.$remove();
      (_r = grid.pageBtnEl) == null ? void 0 : _r.$remove();
      (_s = grid.pageInfoEl) == null ? void 0 : _s.$remove();
      (_t = grid.pageInfo) == null ? void 0 : _t.$remove();
      (_u = grid.marker) == null ? void 0 : _u.$remove();
      (_v = grid.knv) == null ? void 0 : _v.$removeListener();
      (_w = grid.knv) == null ? void 0 : _w.$remove();
      (_x = grid.textArea) == null ? void 0 : _x.$removeListener();
      (_y = grid.textArea) == null ? void 0 : _y.$remove();
      grid.headers.forEach((h2) => {
        var _a3, _b3;
        return ((_a3 = h2.el) == null ? void 0 : _a3.$remove()) && ((_b3 = h2.chkAll) == null ? void 0 : _b3.$remove());
      });
      (_z = grid.headMenu) == null ? void 0 : _z.$remove();
      (_A = grid.contextMenu) == null ? void 0 : _A.$remove();
      (_B = grid.sortable) == null ? void 0 : _B.destroy();
      grid.sortable = null;
      grid.formulaTip = null;
      grid.cache.dispose();
      grid.promises = null;
      grid.cache = null;
      grid.requestFrame = null;
    },
    addGridRow(rowData, index2) {
      let { top, no } = this.getRowInfo(index2);
      let $row = build(h$1("tr.ygrow", { attrs: { id: uidPref + index2, role: "row", rowid: rowData.rowId, rowType: rowData.rowType, treelevel: rowData.treeLevel, "meta-key": rowData.key, "meta-type": "GridRow" }, style: { height: `${rowData.rowHeight}px` } }));
      if (p.showRowHead()) {
        let prp = this.formatCol(p.columns[0], { isAlwaysShow: true, format: { align: "center" }, editOptions: {} }, {}, rowData);
        let $TD = build(h$1("td.ygrid-rownum", { on: { mouseenter: () => this.showTip($TD), mouseleave: () => this.hideTip($TD) }, attrs: { role: "gridcell", ...prp.attr }, style: prp.style, class: prp.class })).$append(build(h$1("span")).$setInnerText(no.toString())).$appendTo($row);
        if (rowData.error.isError()) {
          $TD.$addClass("ygrid-cell-error");
          $TD.$setAttr("errorInfo", rowData.error.getErrorMsg());
        }
        if (rowData.selected) {
          $TD.$addClass("search-matched-cell-selected");
        }
      }
      let column, cellData, metaCell, dataIndex;
      for (let k2 = p.delta; column = p.columns[k2]; k2++) {
        dataIndex = column.orgIndex;
        cellData = rowData.data[dataIndex];
        metaCell = cellData.typeDef || cellData.meta;
        let $cell = this.formatCell(column, metaCell, cellData, rowData, index2, k2);
        $cell.$setCustomData("type", metaCell.type);
        p.enhanceCell(rowData, cellData, $cell, index2, dataIndex, k2);
        if (metaCell.isAlwaysShow) {
          p.createShowEditor(metaCell, $cell, index2, dataIndex, k2);
        }
        $cell.$appendTo($row);
      }
      this.setBackColor(rowData, index2, -1, $row, true);
      this.setForeColor(rowData, index2, -1, $row, true);
      $row.getChildElms().forEach(($cell, cellIndex) => {
        let column2 = p.columns[cellIndex];
        if (column2.type === "seq") {
          return;
        }
        let dataIndex2 = column2.orgIndex;
        let cellData2 = rowData.data[dataIndex2];
        let metaCell2 = cellData2.typeDef || cellData2.meta;
        if (metaCell2.backColor || cellData2.backColor) {
          this.setBackColor(cellData2, index2, dataIndex2, $cell);
        }
        if (metaCell2.foreColor || cellData2.foreColor) {
          this.setForeColor(cellData2, index2, dataIndex2, $cell);
        }
      });
      this.refreshTreeImage(index2, $row);
      if (rowData.visible == false) {
        $row.$hide();
      }
      this.$removeClass("ui-ygrid-empty");
      return $row;
    },
    async showTip($cell) {
      if (grid.tipTimer) {
        clearTimeout(grid.tipTimer);
      }
      grid.tipTimer = null;
      let hasError = $cell.hasClass("ygrid-cell-error");
      let hasRequired = $cell.hasClass("ygrid-cell-required");
      if ($cell.getAttr("formulatip") && !hasError && !hasRequired) {
        grid.tipTimer = setTimeout(async ($cell2) => {
          if (grid.tipTimer) {
            clearTimeout(grid.tipTimer);
          }
          grid.tipTimer = null;
          let rowIndex2 = parseInt(stripPref(uidPref, $cell2.$parent().getAttr("id")));
          let cellKey = $cell2.getAttr("meta-cellkey");
          let formula2 = grid.formulaTip[cellKey];
          let msg2 = await p.asyncEval(formula2, rowIndex2);
          ToolTipUtil.show($cell2.getElm(), p.getZIndex("tip"), msg2, "");
        }, 500, $cell);
      }
      if (this.isEditing()) {
        return;
      }
      let className, msg;
      if (hasError) {
        className = "error";
        msg = $cell.getAttr("errorInfo");
      } else if (hasRequired) {
        className = "required";
        msg = $cell.getAttr("requireInfo");
      }
      if (className && msg) {
        ToolTipUtil.show($cell.getElm(), p.getZIndex("tip"), msg, className);
      }
    },
    hideTip($cell) {
      if (grid.tipTimer) {
        clearTimeout(grid.tipTimer);
      }
      ToolTipUtil.hide();
    },
    showChildren(rowIndex2) {
      let row2 = p.data[rowIndex2], childRows = row2.childRows || [];
      grid.splice(rowIndex2 + 1, 0, childRows.length);
      let $row = this.getRowById(row2.rowId);
      if ($row) {
        let vspan = $row.$findByClassName("cell-tree-icon")[0];
        vspan.$removeClass("cell-collapse").$addClass("cell-expand");
      }
      this.__rowCountChanged();
    },
    hideChildren(rowIndex2, hideCount) {
      let row2 = p.data[rowIndex2];
      grid.splice(rowIndex2 + 1, hideCount, 0);
      let $row = this.getRowById(row2.rowId);
      let vspan = $row.$findByClassName("cell-tree-icon")[0];
      vspan.$removeClass("cell-expand").$addClass("cell-collapse");
      this.__rowCountChanged();
    },
    insertGridRow(rowIndex2) {
      let row2 = p.data[rowIndex2];
      grid.splice(rowIndex2, 0, 1, false);
      if (row2.parentRow) {
        this.refreshTreeIcon(row2.parentRow);
      }
      this.__rowCountChanged();
    },
    deleteGridRow(rowIndex2) {
      grid.splice(rowIndex2, 1, 0, false);
      this.__rowCountChanged();
    },
    setRowVisible(ri, visible) {
      this.__rowCountChanged();
      let row2 = this.getRow(ri);
      if (visible) {
        row2.$show();
      } else {
        row2.$hide();
      }
      this.refreshRows(ri);
    },
    toggleRow(e) {
      let hit = hitTest(e, uidPref, p.delta);
      if (hit.row == null || hit.column == null) {
        return;
      }
      return p.toggleRow(hit.row);
    },
    doUpdate(from, to) {
      for (let i = from; i <= to; i++) {
        grid.updateRowInDOM(i, this.getRow(i));
      }
      this.addPostpatchHook(() => this.setCellFocus(this.getFocusRowIndex(), this.getFocusColIndex(), true));
    },
    async showRows(ri) {
      if (this.isRemoved())
        return;
      let row2 = p.data[ri];
      if (!row2.isLeaf && !row2.expanded) {
        let $row = this.getRow(ri);
        if (!$row)
          return;
        let vspan = $row.$findByClassName("cell-tree-icon")[0];
        vspan.$addClass("cell-loading");
        setTimeout(async () => {
          await p.showChildren(ri);
          vspan.$removeClass("cell-loading");
        }, 0);
      }
    },
    hideRows(ri) {
      if (this.isRemoved())
        return;
      let data2 = p.data, row2 = data2[ri];
      if (!row2.isLeaf && row2.expanded) {
        p.hideChildren(ri);
      }
    },
    refreshTreeImage(ri, $row) {
      if (!p.treeImg)
        return;
      p.asyncEval(p.treeImg, ri).then((img) => {
        if (img) {
          p.getImageBase64URL(img).then((url) => {
            if (url) {
              $row.$findByTagName("img")[0].$setAttr("src", url);
            }
          });
        } else {
          $row.$findByTagName("img")[0].$parent().$hide();
        }
      });
    },
    refreshTreeIcon(data2, vcell) {
      let vspan;
      if (vcell) {
        vspan = vcell.$findByClassName("cell-tree-icon")[0];
      } else {
        vspan = this.getRowById(data2.rowId).$findByClassName("cell-tree-icon")[0];
      }
      vspan.$removeClass("cell-expand cell-collapse cell-loading");
      if (data2.isLeaf === false) {
        vspan.$addClass(data2.expanded ? "cell-expand" : "cell-collapse");
      }
    },
    getRowInfo(index2) {
      let unvisible_count = 0;
      if (p.hasRowVisible) {
        for (let i = 0; i <= index2; i++) {
          let row2 = p.data[i];
          if (row2.rowType === "Detail") {
            break;
          }
          if (row2.visible == false) {
            unvisible_count++;
          }
        }
      }
      let top = (index2 - unvisible_count) * p.rowHeight;
      let no = index2 - unvisible_count + 1;
      if (p.serialRowNum) {
        let pageIndex = pageInfo.currentPage - 1, pageSize = pageInfo.pageSize;
        no += pageIndex * pageSize;
      }
      return { top, no };
    }
  };
  const $table = build(h$1("table")).$setAttr("id", options.id).$setAttr("disabled", false);
  const el = this;
  el.$table = $table;
  grid.bTable = $table;
  Object.assign(el, publicfuns);
  Object.assign($table, tableProps);
  this.$addClass("ui-ygrid").$setAttr("id", options.id + "_box");
  let captionEl = grid.captionEl = el.$findById("#grid-caption");
  if (captionEl) {
    captionEl.$setInnerText(p.caption);
  }
  if (p.template) {
    grid.view = el.$findById("#grid-view");
  } else {
    grid.view = build(h$1("div.ui-ygrid-view", { attrs: { id: p.id + "_view" } })).$appendTo(el);
  }
  grid.hDiv = build(h$1("div.ui-ygrid-hdiv")).$appendTo(grid.view);
  let hb = build(h$1("div.ui-ygrid-hbox-ltr")).$appendTo(grid.hDiv);
  let hTable = grid.hTable = build(h$1("table.ui-ygrid-htable", { style: { width: p.tblWidth + "px" }, attrs: { cellspacing: "0", cellpadding: "0", border: 0, role: "ygrid", "aria-labelledby": "gbox_" + p.id } })).$appendTo(hb);
  grid.hColGroup = build(h$1("colgroup")).$appendTo(hTable);
  for (let i = 0, column; column = p.columns[i]; i++) {
    build(h$1("col", {
      attrs: { name: column.name },
      style: { width: column.width + "px", display: column.visible ? "" : "none" }
    })).$appendTo(grid.hColGroup);
  }
  let thead = build(h$1("thead")).$appendTo(hTable);
  let ltr = grid.ltr = build(h$1("tr.ui-ygrid-columnheader", { attrs: { role: "columnheader" } })).$appendTo(thead);
  let arr = [];
  for (let i = 0, column; column = p.columns[i]; i++) {
    let $th = build(h$1("th.ui-state-default.ui-th-column.ui-th-ltr" + (column.type == "seq" ? ".rn" : "") + (column.type == "select" ? ".select" : "") + (column.sortable ? ".sortable" : "") + (selectModel.isSelectColumn(i - p.delta) ? ".active" : ""), {
      // 子叶列标志
      attrs: { id: p.id + "_" + column.name, colexpand: column.isColExpand, role: "columnheader", rn: column.type == "seq", isselect: column.type == "select", parent: column.parentKey, title: column.caption, leaf: "true", "meta-type": "columnheader", colindex: i, "oldkey": column.type == "seq" ? "" : column.key, "colkey": column.key, "meta-key": column.metaKey },
      style: { width: column.width + "px", display: column.visible ? "" : "none" },
      on: {
        mousedown(e) {
          let target = e.target || e.srcElement;
          let $th2 = target.closest("th");
          let iCol = parseInt($th2.getAttribute("colindex"));
          let colIndex = iCol - p.delta;
          let column2 = p.columns[iCol];
          if (column2.type == "seq")
            return;
          p.recordClick(column2.metaKey);
          $table.selectGridColumn(colIndex, e.shiftKey, e.ctrlKey, e.button);
          if (e.button == 2) {
            document.oncontextmenu = function(e2) {
              let ev = e2 || window.event;
              if (ev.preventDefault) {
                ev.preventDefault();
              } else {
                ev.returnValue = false;
                ev.cancelBubble = true;
              }
              return false;
            };
          }
        },
        dblclick(e) {
          let target = e.target || e.srcElement;
          let $th2 = target.closest("th");
          let boxpos = $th2.getBoundingClientRect();
          if (e.clientX < boxpos.left + boxpos.width / 2) {
            $table.toColumnFitWidth(parseInt($th2.getAttribute("colindex")));
          }
        },
        mouseup(e) {
          if (e.button == 2) {
            if (!p.enableColumnMenu)
              return;
            let target = e.target || e.srcElement;
            let $th2 = target.closest("th");
            let iCol = parseInt($th2.getAttribute("colindex"));
            let column2 = p.columns[iCol];
            if (column2.type == "seq" || column2.type == "image" || column2.type == "button" || column2.type == "radiobutton")
              return;
            let selectOneColumn = selectModel.getSelectedColumns().length == 1;
            let options2 = [
              { name: "hidecolumn", group: "ui", visible: p.variantSet, caption: I18N.getString("GRID_HIDECOLUMN", "隐藏") },
              { name: "showcolumn", group: "ui", visible: p.variantSet, caption: I18N.getString("GRID_SHOWCOLUMN", "显示") },
              { name: "bestwidth", group: "ui", visible: p.bestWidth, caption: I18N.getString("GRID_BESTWIDTH", "最佳列宽") },
              { name: "frozencolumn", group: "ui", visible: p.frozenColumn, caption: I18N.getString("GRID_FROZENTHISCOLUMN", "冻结至此列") },
              { name: "unfrozencolumn", group: "ui", visible: p.frozenLeftColumns, caption: I18N.getString("GRID_UNFROZEN", "解冻列") },
              { name: "sortasc", group: "data", visible: p.hasDetailRow && !p.enable && selectOneColumn && !p.hasTree, caption: I18N.getString("GRID_SORTASC", "按升序排序") },
              { name: "sortdesc", group: "data", visible: p.hasDetailRow && !p.enable && selectOneColumn && !p.hasTree, caption: I18N.getString("GRID_SORTDESC", "按降序排序") },
              { name: "search", group: "data", visible: p.search && selectOneColumn, caption: I18N.getString("GRID_SEARCH", "查找") },
              { name: "setfilter", group: "data", visible: p.hasDetailRow && !p.enable && !p.hasTree && selectOneColumn && !p.hasColumnExpand, caption: I18N.getString("GRID_FILTERSET", "设置过滤器") },
              { name: "sum", group: "stats", visible: p.hasDetailRow && !p.hasTree && !p.enable && selectOneColumn && column2.type == "numbereditor", caption: I18N.getString("GRID_SUM", "总计") },
              { name: "group", group: "stats", visible: p.hasDetailRow && !p.hasTree && !p.enable && selectOneColumn && !p.hasColumnExpand && p.hasTotalRow() && !column2.sum && (!column2.isAlwaysShow || column2.type == "hyperlink"), caption: I18N.getString("GRID_GROUPSUM", "小计") }
            ];
            if (options2.filter((opt) => opt.visible).length == 0) {
              return;
            }
            document.oncontextmenu = function(e2) {
              let ev = e2 || window.event;
              if (ev.preventDefault) {
                ev.preventDefault();
              } else {
                ev.returnValue = false;
                ev.cancelBubble = true;
              }
              return false;
            };
            const mousedownHandler = function(e2) {
              document.oncontextmenu = function(e3) {
                let ev = e3 || window.event;
                return ev.returnValue = true;
              };
              let stop = hasClass(e2.target, "menu-list");
              if (!stop) {
                stop = e2.target.closest(".menu-list");
              }
              if (stop)
                return;
              grid.headMenu.$hide();
              document.removeEventListener("mousedown", mousedownHandler);
            };
            document.addEventListener("mousedown", mousedownHandler);
            let menu = grid.headMenu, ul;
            if (menu == null) {
              menu = grid.headMenu = build(h$1("div.contextmenu", { attrs: { id: "headmenu_" + p.id }, style: { "z-index": "30" } })).$appendTo(el);
              ul = build(h$1("ul.menu-list", { attrs: { id: "headmenuul_" + p.id } })).$appendTo(menu);
            } else {
              ul = menu.$findById("headmenuul_" + p.id);
              ul.$empty();
            }
            let group;
            options2.forEach((opt) => {
              if (opt && opt.visible) {
                if (group && group != opt.group) {
                  build(h$1("hr")).$appendTo(ul);
                }
                build(h$1("li", {
                  on: {
                    click: function(e2) {
                      $table.triggerHeadEvent(opt.name, column2, iCol);
                      grid.headMenu.$hide();
                    }
                  }
                }, h$1("a", opt.caption))).$appendTo(ul);
                group = opt.group;
              }
            });
            menu.$appendStyles(new Map(Object.entries({
              left: e.clientX + "px",
              top: e.clientY + "px"
            })));
            menu.addPostpatchHook(() => adjustPositon(menu.getElm(), e));
            menu.$show();
          } else {
            $table.knvFocus();
          }
        }
      }
    })).$appendTo(ltr);
    if (column.type != "seq" && column.type != "select") {
      let $alv = build(h$1("div", { class: { "alv": true } })).$appendTo($th);
      build(h$1("div", { attrs: { id: uidPref + "_" + p.id + "_" + column.name + "_order" }, class: { "ygrid-alv-icon": true, "ygrid-alv-desc": column.order == "desc", "ygrid-alv-asc": column.order == "asc" } })).$appendTo($alv);
      build(h$1("div", { attrs: { id: uidPref + "_" + p.id + "_" + column.name + "_sum" }, class: { "ygrid-alv-icon": true, "ygrid-alv-sum": column.sum } })).$appendTo($alv);
      build(h$1("div", { attrs: { id: uidPref + "_" + p.id + "_" + column.name + "_filter" }, class: { "ygrid-alv-icon": true, "ygrid-alv-filter": column.filter } })).$appendTo($alv);
    }
    let $cnt = build(h$1("div", { attrs: { id: uidPref + "_" + p.id + "_" + column.name }, class: { "content": true } })).$appendTo($th);
    let $img = build(h$1("img")).$appendTo(build(h$1("span.col-img", { style: { display: column.img ? "block" : "none" } })).$appendTo($cnt));
    let $col = build(h$1("span.col-caption", { style: { display: column.type == "select" ? "none" : "block" } })).$setInnerText(column.caption).$appendTo($cnt);
    if (column.type != "seq" && column.type != "select") {
      build(h$1("span.ui-ygrid-resize.ui-ygrid-resize-ltr", {
        on: {
          mousedown(e) {
            let target = e.target || e.srcElement;
            let th = target.closest("th");
            let index2 = parseInt(th.getAttribute("colindex"));
            grid.dragStart(index2, e, $table.getOffset(index2));
          }
        }
      })).$setInnerText(" ").$appendTo($th);
    }
    let chkAll;
    if (!column.singleSelect && column.enableCheckAll) {
      let select2 = function(e, vi) {
        let target = e.target;
        let $i = build(vi);
        let checked = $i.getAttr("checked");
        let $th2 = target.closest("th");
        p.doSelectAll(!checked, $th2.getAttribute("colkey"));
        $i.$removeClass("checked halfChecked");
        if (checked) {
          $i.$removeClass("checked").$setAttr("checked", null);
        } else {
          $i.$addClass("checked").$setAttr("checked", true);
        }
        e.stopPropagation();
      };
      chkAll = build(h$1("span.chk", { on: { click: select2 } })).$prependTo($cnt);
      let info = p.selectAllInfo[column.key];
      if (info == null ? void 0 : info.value) {
        if (info.halfChecked) {
          chkAll.$addClass("halfChecked");
        } else {
          chkAll.$addClass("checked");
        }
        chkAll.$setAttr("checked", true);
      }
    }
    if (column.sortable) {
      let sort2 = function(e, vi) {
        if (p.hasRowGroup) {
          return;
        }
        let target = e.target || e.srcElement;
        let $th2 = target.closest("th");
        let iCol = parseInt($th2.getAttribute("colindex"));
        let column2 = p.columns[iCol];
        let $i = build(vi);
        let sortConfig = [];
        if ($i.hasClass("sort--active")) {
          $i.$removeClass("sort--active");
          delete column2.order;
          p.columns.forEach((column3) => {
            column3.order && sortConfig.push({ key: column3.key, order: column3.order });
          });
        } else {
          $i.$addClass("sort--active");
          let sibling = $i.$prev() || $i.$next();
          sibling.$removeClass("sort--active");
          column2.order = $i.getAttr("order");
          sortConfig.push({ key: column2.key, order: column2.order });
        }
        p.setRowSort(sortConfig);
        e.stopPropagation();
      };
      let $span = build(h$1("span.ui-ygrid-sort")).$appendTo($cnt);
      build(h$1("i.ui-ygrid-sort-asc" + (column.order == "asc" ? ".sort--active" : ""), { on: { click: sort2 }, attrs: { order: "asc" } })).$appendTo($span);
      build(h$1("i.ui-ygrid-sort-desc" + (column.order == "desc" ? ".sort--active" : ""), { on: { click: sort2 }, attrs: { order: "desc" } })).$appendTo($span);
    }
    if (column.formulaCaption || column.img) {
      arr.push({
        thEl: $th,
        labelEl: $col,
        imgEl: $img,
        ci: column.orgIndex,
        img: column.img,
        column,
        formula: column.formulaCaption
      });
    }
    grid.headers[i] = {
      el: $th,
      chkAll,
      name: column.name,
      width: column.width,
      orgWidth: column.width,
      caption: column.caption,
      visible: column.visible
    };
  }
  arr.forEach((item) => {
    if (item.formula) {
      grid.promises.push(p.asyncEval(item.formula, -1, item.ci).then((caption) => {
        item.column.caption = caption;
        item.thEl.$setAttr("title", caption);
        item.labelEl.$setInnerText(caption);
      }));
    }
    if (item.img) {
      p.asyncEval(item.img, -1, item.ci).then((img) => {
        if (img) {
          p.getImageBase64URL(img).then((url) => {
            if (url) {
              item.imgEl.$setAttr("src", url);
            }
          });
        } else {
          item.imgEl.$parent().$hide();
        }
      });
    }
  });
  arr = null;
  $table.buildGroupHeaders();
  grid.bDiv = build(h$1("div.ui-ygrid-bdiv")).$scroll(grid.scrollGrid).$appendTo(grid.view);
  let $bDiv = build(h$1("div")).$appendTo(grid.bDiv);
  $table.$addClass("ui-ygrid-btable").$addClass("ui-ygrid-empty").$addStyle("width", p.tblWidth + "px").$appendTo($bDiv);
  grid.bColGroup = build(h$1("colgroup")).$appendTo($table);
  for (let i = 0, column; column = p.columns[i]; i++) {
    build(h$1("col", {
      attrs: { name: column.name },
      style: { width: column.width + "px", display: column.visible ? "" : "none" }
    })).$appendTo(grid.bColGroup);
  }
  let tbody = build(h$1("tbody")).$appendTo($table);
  $table.$click(async function(e) {
    let target = e.target;
    let tbl = el.$table;
    let $td = target.closest("td");
    if (!$td) {
      return;
    }
    if (target.tagName === "INPUT" && target.type != "file") {
      return;
    }
    if (hasClass(target, "btn") || hasClass(target, "clear")) {
      return;
    }
    if (target.tagName != "TEXTAREA" && target.type != "file") {
      tbl.knvFocus();
    }
    let hit = hitTest(e, uidPref, p.delta);
    if (hit.row == null || hit.column == null) {
      return;
    }
    tbl = el.$table.getCandidateTbl(hit.row, hit.column) || el.$table;
    tbl.p.recordClick(hit.metaKey);
    await DomEventQueue.isFinished();
    let rowIndex2 = selectModel.focusRow, colIndex = selectModel.focusCol, oldRowIndex = selectModel.oldRowIndex, oldRowId = selectModel.oldRowId;
    let curRowIndex = selectModel.focusRow;
    let curRowId = selectModel.focusRowId;
    if (!hasClass(target.closest("td"), "ygrid-rownum") && !hasClass(target, "cell-tree-icon") && !selectModel.changed && hit.row == rowIndex2 && hit.column == colIndex) {
      if (tbl.editCell(rowIndex2, colIndex, false, e)) {
        return;
      }
    }
    await tbl.p.clickRow(rowIndex2, oldRowIndex);
    if (curRowIndex !== oldRowIndex || oldRowId !== curRowId) {
      await tbl.p.rowChanged(rowIndex2, oldRowIndex);
    }
    tbl.p.setRowChanging(false);
    if (hasClass(target, "cell-tree-icon")) {
      if (hasClass(target, "cell-collapse")) {
        await tbl.showRows(rowIndex2);
      } else {
        await tbl.hideRows(rowIndex2);
      }
      tbl.doFrozen();
    }
    e.stopPropagation();
  }).$mouseup(async function(e) {
    let _e = e;
    let target = e.target;
    let tbl = el.$table;
    let $td = target.closest("td");
    if (!$td) {
      return;
    }
    if (target.tagName === "INPUT" && target.type != "file") {
      return;
    }
    if (hasClass(target, "btn") || hasClass(target, "clear")) {
      return;
    }
    tbl.p.hitCell = null;
    if (target.tagName != "TEXTAREA" && target.type != "file") {
      tbl.knvFocus();
    }
    if (_e.button == 2) {
      let traces = p.traces;
      if (traces && traces.length > 0) {
        document.oncontextmenu = function(e2) {
          let ev = e2 || window.event;
          if (ev.preventDefault) {
            ev.preventDefault();
          } else {
            ev.returnValue = false;
            ev.cancelBubble = true;
          }
          return false;
        };
        const mousedownHandler = function(e2) {
          var _a2;
          document.oncontextmenu = function(e3) {
            let ev = e3 || window.event;
            return ev.returnValue = true;
          };
          let stop = hasClass(e2.target, "menu-list");
          if (!stop) {
            stop = e2.target.closest(".menu-list");
          }
          if (stop)
            return;
          (_a2 = grid.contextMenu) == null ? void 0 : _a2.$hide();
          document.removeEventListener("mousedown", mousedownHandler);
        };
        document.addEventListener("mousedown", mousedownHandler);
        let menu = grid.contextMenu, ul;
        if (menu == null) {
          menu = grid.contextMenu = build(h$1("div.contextmenu", { attrs: { id: "tracemenu_" + p.id } })).$appendTo(el);
          ul = build(h$1("ul.menu-list", { attrs: { id: "tracemenuul_" + p.id } })).$appendTo(menu);
        } else {
          ul = menu.$findById("tracemenuul_" + p.id);
          ul.$empty();
        }
        let rowIndex2 = selectModel.focusRow;
        return traces.reduce(function(prev2, trace, idx) {
          return prev2.then(function() {
            let cond = true;
            if (trace.condition) {
              cond = p.asyncEval(trace.condition, rowIndex2);
            }
            return Promise.resolve(cond).then(function(ret) {
              if (ret) {
                const li = build(h$1("li")).$setAttr("idx", idx).$appendTo(ul);
                build(h$1("a", trace.caption)).$appendTo(li);
              }
            });
          });
        }, Promise.resolve()).then(function() {
          let lis = ul.$findByTagName("li");
          if (lis.length == 0)
            return;
          ul.$findByTagName("li").forEach((li) => {
            li.$click(function(e2) {
              let i = parseInt(e2.target.closest("li").getAttribute("idx"));
              return p.asyncEval(traces[i].content, rowIndex2).then(function() {
                menu.$hide();
              });
            });
          });
          menu.$appendStyles(new Map(Object.entries({
            left: _e.clientX + "px",
            top: _e.clientY + "px"
          })));
          menu.addPostpatchHook(() => adjustPositon(menu.getElm(), e));
          menu.$show();
        });
      }
    }
  }).$mousedown(async function(e) {
    let _e = e;
    let target = _e.target;
    let tbl = el.$table;
    let $td = target.closest("td");
    if (!$td) {
      return;
    }
    if (target.tagName === "INPUT" && target.type != "file") {
      return;
    }
    if (hasClass(target, "btn") || hasClass(target, "clear")) {
      return;
    }
    let hit = hitTest(e, uidPref, p.delta);
    let rowIndex2 = hit.row, colIndex = hit.column;
    if (rowIndex2 == null || rowIndex2 < 0) {
      return;
    }
    tbl.p.hitCell = hit;
    tbl = el.$table;
    if (hasClass($td, "ygrid-rownum")) {
      tbl.selectGridRow(0, rowIndex2, p.columns.length - p.delta - 1, rowIndex2, rowIndex2, -1, _e.shiftKey, true, true);
    } else {
      tbl.selectGridRow(colIndex, rowIndex2, colIndex, rowIndex2, rowIndex2, colIndex, _e.shiftKey);
    }
    tbl.p.setRowChanging(selectModel.changed);
  }).$mousemove(function(e) {
    let target = e.target;
    if (target.closest("td") && p.hitCell) {
      let hitCell = p.hitCell;
      let hit = hitTest(e, uidPref, p.delta);
      if (hit.row == null || hit.column == null || hit.row == hitCell.row && hit.column == hitCell.column) {
        return;
      }
      let oldLeft = hitCell.column, oldRight = oldLeft, oldTop = hitCell.row, oldBottom = oldTop, rowIndex2 = hit.row, colIndex = hit.column, left = Math.min(colIndex, oldLeft), right = Math.max(colIndex, oldRight), top = Math.min(rowIndex2, oldTop), bottom = Math.max(rowIndex2, oldBottom);
      $table.selectGridRow(left, top, right, bottom, top, left);
    }
  }).$dblclick(debounce(function(e) {
    let hit = hitTest(e, uidPref, p.delta);
    let rowIndex2 = hit.row, colIndex = hit.column;
    if (rowIndex2 == null || rowIndex2 < 0 || p.editInfo)
      return;
    return p.dblClick(rowIndex2, colIndex);
  })).$keydown(function(e) {
    if (p.endEditByNav) {
      let target = e.target;
      let $tbl = target.closest(".ui-ygrid-btable");
      if (!$tbl) {
        return;
      }
      let keyCode = e.charCode || e.keyCode;
      switch (keyCode) {
        case 37:
          $table.changeFocus(keyCode, "left");
          break;
        case 38:
          $table.changeFocus(keyCode, "top");
          break;
        case 39:
          $table.changeFocus(keyCode, "right");
          break;
        case 40:
          $table.changeFocus(keyCode, "bottom");
          break;
      }
    }
  });
  let headerId = p.id + "_header";
  if (!p.template) {
    grid.header = build(h$1("div.ui-ygrid-header", { attrs: { id: headerId } })).$insertBefore(grid.view).$hide();
    const table = build(h$1("table")).$appendTo(grid.header);
    const tbody2 = build(h$1("tbody")).$appendTo(table);
    const tr = build(h$1("tr")).$appendTo(tbody2);
    build(h$1("td", { attrs: { id: `${headerId}_left`, align: "left" } })).$appendTo(tr);
    build(h$1("td", { attrs: { id: `${headerId}_center`, align: "center" } })).$appendTo(tr);
    build(h$1("td", { attrs: { id: `${headerId}_tools`, align: "right" } })).$appendTo(tr);
  } else {
    grid.header = el.$findById("grid-header");
  }
  let footerId = p.id + "_footer", footerLeft, footerRight;
  if (!p.template) {
    grid.footer = build(h$1("div.ui-ygrid-footer", { attrs: { id: footerId } })).$appendTo(el);
    const table = build(h$1("table")).$appendTo(grid.footer);
    const tbody2 = build(h$1("tbody")).$appendTo(table);
    const tr = build(h$1("tr")).$appendTo(tbody2);
    footerLeft = build(h$1("td", { attrs: { id: `${footerId}_left`, align: "left" } })).$appendTo(tr);
    build(h$1("td", { attrs: { id: `${footerId}_center`, align: "center" } })).$appendTo(tr);
    footerRight = build(h$1("td", { attrs: { id: `${footerId}_pager`, align: "right" } })).$appendTo(tr);
  } else {
    grid.footer = el.$findById("grid-footer");
  }
  let toolEl = grid.toolEl = build(h$1("table.ui-ygrid-options"));
  let toolBody = build(h$1("tbody")).$appendTo(toolEl);
  let toolTR = build(h$1("tr")).$appendTo(toolBody);
  let fillIcon = ($icon, item) => {
    if (item.cssClass) {
      $icon.$addClass(item.cssClass);
    } else if (item.icon) {
      p.getImageBase64URL(item.icon).then(function(url) {
        $icon.$addStyle("backgroundImage", "url(" + url + ")");
        $icon.$addStyle("backgroundPosition", "center");
      });
    } else {
      $icon.$addClass("ui-icon-extOpt");
    }
  };
  let hideUl = (uid) => {
    toolTR.$findByClassName("ui-sub-opts").forEach((ul) => {
      if (!uid || ul.getAttr("id") != uid) {
        ul.$hide();
        let $arrow = ul.$prev();
        if ($arrow.hasClass("ui-opt-arrow")) {
          $arrow.$removeClass("triangle_bom").$addClass("triangle_up");
        }
      }
    });
  };
  let docClickEvt = (e) => {
    let $optul = e.target.closest(".ui-sub-opts");
    let $optarrow = e.target.closest(".ui-opt-arrow");
    if ($optul == null && $optarrow == null) {
      hideUl();
    }
    document.removeEventListener("click", docClickEvt);
  };
  let addOpt = (item, visible = true, enable = true) => {
    let id = (item.key || randomString(5)) + "_" + p.id;
    let ele = build(h$1("td.ui-pg-button", {
      class: { "ui-hidden": !visible, "ui-state-disabled": !enable },
      attrs: { title: item.caption || "", id },
      on: {
        click: function(e) {
          try {
            if (item.content) {
              if (!ele.hasClass("ui-state-disabled")) {
                p.asyncEval(item.content);
              }
            } else if (item.func) {
              if (!ele.hasClass("ui-state-disabled")) {
                item.func.call($table);
              }
            } else {
              let $ul = ele.$findByClassName("ui-sub-opts")[0];
              if ($ul) {
                if ($ul.isHide()) {
                  $ul.$show();
                  hideUl($ul.getAttr("id"));
                  document.addEventListener("click", docClickEvt);
                } else {
                  $ul.$hide();
                }
              }
            }
          } finally {
            e.stopPropagation();
          }
          return false;
        }
      }
    })).$appendTo(toolTR);
    let $div = build(h$1("div.ui-pg-div")).$appendTo(ele);
    let $icon = build(h$1("span.ygrid-icon", { attrs: { id: item.key + "_span_" + p.id } })).$appendTo($div);
    fillIcon($icon, item);
    if (item.items && item.items.length > 0) {
      if (item.content) {
        $icon.$addClass("items");
        let $arrow = build(h$1("span.ui-opt-arrow.triangle_up", {
          on: {
            click: function(e) {
              let $ul2 = $arrow.$next();
              if (hasClass(e.target, "triangle_up")) {
                $ul2.$show();
                hideUl($ul2.getAttr("id"));
                $arrow.$removeClass("triangle_up").$addClass("triangle_bom");
              } else {
                $ul2.$hide();
                $arrow.$removeClass("triangle_bom").$addClass("triangle_up");
              }
              document.addEventListener("click", docClickEvt);
              e.stopPropagation();
            }
          }
        }));
        $div.$append($arrow);
      }
      let $ul = build(h$1("ul.ui-sub-opts", { attrs: { id: randomString(5) } })).$appendTo($div).$hide();
      item.items.forEach((item2) => {
        let id2 = (item2.key || randomString(5)) + "_" + p.id;
        let $li = build(h$1("li", {
          attrs: { id: id2 },
          on: {
            click: (e) => {
              try {
                if (item2.content) {
                  p.asyncEval(item2.content);
                } else if (item2.func) {
                  item2.func.call($table);
                }
              } finally {
                $ul.$hide();
                let $arrow = $ul.$prev();
                if ($arrow.hasClass("ui-opt-arrow")) {
                  $arrow.$removeClass("triangle_bom").$addClass("triangle_up");
                }
                e.stopPropagation();
              }
              return false;
            }
          }
        })).$appendTo($ul);
        let $icon2 = build(h$1("span.ygrid-icon")).$appendTo($li);
        build(h$1("span.ygrid-caption", item2.caption)).$appendTo($li);
        fillIcon($icon2, item2);
      });
    }
  };
  if (p.add) {
    let opt;
    if (p.hasTree) {
      opt = {
        key: "add",
        cssClass: "ui-icon-plus",
        caption: I18N.getString("GRID_ADDRECORD", "添加行"),
        items: [
          {
            key: "AddTreeGridSiblingRow",
            caption: I18N.getString("AddTreeGridSiblingRow", "新增行(同级)"),
            cssClass: "ui-icon-treeopt-sibling",
            func: () => $table.addTree(false)
          },
          {
            key: "AddTreeGridChildRow",
            caption: I18N.getString("AddTreeGridChildRow", "新增行(下级)"),
            cssClass: "ui-icon-treeopt-child",
            func: () => $table.addTree(true)
          }
        ]
      };
    } else {
      opt = {
        key: "add",
        cssClass: "ui-icon-plus",
        func: () => $table.add(),
        caption: I18N.getString("GRID_ADDRECORD", "添加行")
      };
    }
    addOpt(opt);
  }
  if (p.del) {
    let ele = build(h$1("td.ui-pg-button", {
      attrs: { title: I18N.getString("GRID_DELRECORD", "删除选中行"), id: "del_" + p.id },
      on: {
        click: function(e) {
          $table.del();
          e.stopPropagation();
          return false;
        }
      }
    })).$appendTo(toolTR);
    build(h$1("div.ui-pg-div", [h$1("span.ygrid-icon.ui-icon-trash", { attrs: { id: "del_span_" + p.id } })])).$appendTo(ele);
  }
  if (p.shift) {
    let ele = build(h$1("td.ui-pg-button", {
      attrs: { title: I18N.getString("GRID_MOVEUP", "上移数据行"), id: "upRow_" + p.id },
      on: {
        click: function(e) {
          $table.shiftUp();
          e.stopPropagation();
          return false;
        }
      }
    })).$appendTo(toolTR);
    build(h$1("div.ui-pg-div", [h$1("span.ygrid-icon.ui-icon-up", { attrs: { id: "upRow_span_" + p.id } })])).$appendTo(ele);
    ele = build(h$1("td.ui-pg-button", {
      attrs: { title: I18N.getString("GRID_MOVEDOWN", "下移数据行"), id: "downRow_" + p.id },
      on: {
        click: function(e) {
          $table.shiftDown();
          e.stopPropagation();
          return false;
        }
      }
    })).$appendTo(toolTR);
    build(h$1("div.ui-pg-div", [h$1("span.ygrid-icon.ui-icon-down", { attrs: { id: "downRow_span_" + p.id } })])).$appendTo(ele);
  }
  if (p.bestWidth) {
    let ele = build(h$1("td.ui-pg-button", {
      attrs: { title: I18N.getString("GRID_BESTWIDTH", "最佳列宽"), id: "bestWidth_" + p.id },
      on: {
        click: function(e) {
          p.doFitWidth(true);
          e.stopPropagation();
          return false;
        }
      }
    })).$appendTo(toolTR);
    build(h$1("div.ui-pg-div", [h$1("span.ygrid-icon.ui-icon-bestwidth", { attrs: { id: "bestWidth_span_" + p.id } })])).$appendTo(ele);
  }
  if (p.frozenRow)
    ;
  if (p.frozenColumn) {
    let ele = build(h$1("td.ui-pg-button", {
      attrs: { title: I18N.getString("GRID_FROZENLEFTCOL", "冻结左侧列"), id: "frozenLeftColumn_" + p.id },
      on: {
        click: function(e) {
          let focusCol = selectModel.focusCol;
          if (!p.frozenLeftColumns) {
            if (p.columns[$table.iCol(focusCol)].visible) {
              p.doFrozenLeftColumns(focusCol + 1);
            } else {
              p.doFrozenLeftColumns($table.findVisibleColumn($table.iCol(focusCol)));
            }
          } else {
            p.doFrozenLeftColumns(0);
          }
          e.stopPropagation();
          return false;
        }
      }
    })).$appendTo(toolTR);
    let div = build(h$1("div.ui-pg-div.frozenleftcol")).$appendTo(ele);
    build(h$1("span", { attrs: { id: "frozenLeftColumn_span_" + p.id } })).$addClass("ygrid-icon").$addClass("ui-icon-frozenLeftColumn").$appendTo(div);
  }
  if (p.frozenRowColumn)
    ;
  if (p.editRowFormKey) {
    let ele = build(h$1("td.ui-pg-button", {
      attrs: { title: I18N.getString("GRID_EDITROW", "行编辑"), id: "editRow_" + p.id },
      on: {
        click: function(e) {
          $table.edit();
          e.stopPropagation();
          return false;
        }
      }
    })).$appendTo(toolTR);
    build(h$1("div.ui-pg-div editrow", [h$1("span.ygrid-icon.ui-icon-editRow", { attrs: { id: "editRow_span_" + p.id } })])).$appendTo(ele);
  }
  if (p.zoom) {
    let isZMax = el.hasClass("is--maximize");
    let className = isZMax ? ".ui-icon-minimize" : ".ui-icon-fullscreen";
    let title = isZMax ? I18N.getString("GRID_REVERT", "还原") : I18N.getString("GRID_ZOOM", "全屏显示");
    let ele = build(h$1("td.ui-pg-button", {
      attrs: { title, id: "zoom_" + p.id },
      on: {
        click: function(e) {
          if (el.hasClass("is--maximize")) {
            p.doRevert();
          } else {
            p.doZoom();
          }
          e.stopPropagation();
          return false;
        }
      }
    })).$appendTo(toolTR);
    build(h$1("div.ui-pg-div zoom", [h$1("span.ygrid-icon" + className, { attrs: { id: "zoom_span_" + p.id } })])).$appendTo(ele);
  }
  if (p.export) {
    let ele = build(h$1("td.ui-pg-button", {
      attrs: { title: I18N.getString("GRID_EXPORT", "导出"), id: "export_" + p.id },
      on: {
        click: function(e) {
          p.doExport();
          e.stopPropagation();
          return false;
        }
      }
    })).$appendTo(toolTR);
    build(h$1("div.ui-pg-div export", [h$1("span.ygrid-icon.ui-icon-export", { attrs: { id: "export_span_" + p.id } })])).$appendTo(ele);
  }
  if (p.sum) {
    let ele = build(h$1("td.ui-pg-button", {
      attrs: { title: I18N.getString("GRID_SUM", "汇总"), id: "sum_" + p.id },
      on: {
        click: function(e) {
          p.setRowSum();
          e.stopPropagation();
          return false;
        }
      }
    })).$appendTo(toolTR);
    build(h$1("div.ui-pg-div sum", [h$1("span.ygrid-icon.ui-icon-sum" + (((_a = p.sumConfig) == null ? void 0 : _a.length) > 0 ? ".ui-sum-set" : ""), { attrs: { id: "sum_span_" + p.id } })])).$appendTo(ele);
  }
  if (p.groupsum) {
    let ele = build(h$1("td.ui-pg-button", {
      attrs: { title: I18N.getString("GRID_GROUPSUM", "小计"), id: "groupsum_" + p.id },
      on: {
        click: function(e) {
          p.setGroup();
          e.stopPropagation();
          return false;
        }
      }
    })).$appendTo(toolTR);
    build(h$1("div.ui-pg-div groupsum", [h$1("span.ygrid-icon.ui-icon-groupsum" + (((_b = p.sortConfig) == null ? void 0 : _b.filter((cfg) => cfg.group).length) > 0 ? ".ui-groupsum-set" : ""), { attrs: { id: "groupsum_span_" + p.id } })])).$appendTo(ele);
  }
  if (p.variantset) {
    let ele = build(h$1("td.ui-pg-button", {
      attrs: { title: I18N.getString("GRID_VARIANTSET", "当前显示变式"), id: "variantset_" + p.id },
      on: {
        click: function(e) {
          p.setVariant();
          e.stopPropagation();
          return false;
        }
      }
    })).$appendTo(toolTR);
    build(h$1("div.ui-pg-div variantset", [h$1("span.ygrid-icon.ui-icon-variantset", { attrs: { id: "variantset_span_" + p.id } })])).$appendTo(ele);
  }
  if (p.filterset) {
    let ele = build(h$1("td.ui-pg-button", {
      attrs: { title: I18N.getString("GRID_FILTERSET", "过滤"), id: "filter_" + p.id },
      on: {
        click: function(e) {
          p.setFilter();
          e.stopPropagation();
          return false;
        }
      }
    })).$appendTo(toolTR);
    build(h$1("div.ui-pg-div filter", [h$1("span.ygrid-icon.ui-icon-filter" + (Object.keys(p.filterConfig || {}).length > 0 ? ".ui-filter-set" : ""), { attrs: { id: "filter_span_" + p.id } })])).$appendTo(ele);
  }
  if (p.search) {
    let ele = build(h$1("td.ui-pg-button", {
      attrs: { title: I18N.getString("GRID_SEARCH", "搜索"), id: "search_" + p.id },
      on: {
        click: function(e) {
          p.doSearch();
          e.stopPropagation();
          return false;
        }
      }
    })).$appendTo(toolTR);
    build(h$1("div.ui-pg-div search", [h$1("span.ygrid-icon.ui-icon-search", { attrs: { id: "search_span_" + p.id } })])).$appendTo(ele);
  }
  let extOpts = p.addExtOpt() || [];
  extOpts = extOpts.concat(p.extOpts || []);
  extOpts.forEach((item) => {
    let info = p.extOptsInfo[item.key] || {};
    addOpt(item, info.visible, info.enable);
  });
  let $tool;
  if (p.template) {
    $tool = el.$findById("grid-tools");
  } else {
    $tool = footerLeft;
  }
  $tool && $tool.$append(toolEl).$setAttr("id", footerId + "_tools");
  let pagingInfo = grid.pageInfoEl = build(h$1("div.ui-paging-info", { attrs: { totalRowCount: pageInfo.showTotalPage + "" } }));
  let $pager;
  if (p.template) {
    $pager = el.$findById("grid-pager");
  } else {
    $pager = footerRight;
  }
  $pager && $pager.$append(pagingInfo).$setAttr("id", footerId + "_pager");
  if (pageInfo.pageLoadType > 0 && $pager) {
    let pagerId = p.id + "_pager";
    let pageBtn = grid.pageBtnEl = build(h$1("table.ui-ygrid-pagebtns"));
    let body = build(h$1("tbody")).$appendTo(pageBtn);
    let tr = build(h$1("tr")).$appendTo(body);
    if (p.rowList.length > 0) {
      let div = build(h$1("div.ui-ygrid-rowlist")).$appendTo($pager);
      let select2 = build(h$1("select.ui-pg-selbox", { attrs: { role: "listbox" }, on: { change: $table.rowNumChangeEvent } })).$appendTo(div);
      let nm, rowNum = pageInfo.pageSize;
      for (let i = 0; i < p.rowList.length; i++) {
        nm = p.rowList[i].toString();
        const option2 = build(h$1("option", { attrs: { role: "option", value: nm } }, nm + "条/页")).$appendTo(select2);
        if (rowNum === parseInt(nm)) {
          option2.$setAttr("selected", "selected");
        }
      }
    }
    p.pagerIds = [
      "first_" + pagerId,
      "prev_" + pagerId,
      "next_" + pagerId,
      "last_" + pagerId
    ];
    if (pageInfo.showTotalPage) {
      const firstPage = build(h$1("td.ui-pg-button", { attrs: { id: p.pagerIds[0] }, on: { click: $table.gotoPageEvent } })).$appendTo(tr);
      build(h$1("span.ygrid-icon.ui-icon-seek-first")).$appendTo(firstPage);
    }
    const prevPage = build(h$1("td.ui-pg-button", { attrs: { id: p.pagerIds[1] }, on: { click: $table.gotoPageEvent } })).$appendTo(tr);
    build(h$1("span.ygrid-icon.ui-icon-seek-prev")).$appendTo(prevPage);
    const pageBtns = build(h$1("td.ui-pagination", { attrs: { id: `pagination_${pagerId}` } })).$appendTo(tr);
    build(h$1("ul")).$appendTo(pageBtns);
    const nextPage = build(h$1("td.ui-pg-button", { attrs: { id: p.pagerIds[2] }, on: { click: $table.gotoPageEvent } })).$appendTo(tr);
    build(h$1("span.ygrid-icon.ui-icon-seek-next")).$appendTo(nextPage);
    if (pageInfo.showTotalPage) {
      const endPage = build(h$1("td.ui-pg-button", { attrs: { id: p.pagerIds[3] }, on: { click: $table.gotoPageEvent } })).$appendTo(tr);
      build(h$1("span.ygrid-icon.ui-icon-seek-end")).$appendTo(endPage);
    }
    $pager.$append(pageBtn);
  }
  if (p.template) {
    let $totalInfo = el.$findById("grid-totalinfo");
    if ($totalInfo) {
      $totalInfo.$setInnerText(p.getTotalInfo()).$setAttr("id", footerId + "_totalinfo");
    }
  }
  grid.marker = build(h$1("div.ui-ygrid-marker", { attrs: { id: p.id + "_rsm" } })).$appendTo(el);
  grid.knv = build(h$1("div.ui-ygrid-knv", { attrs: { id: p.id + "_knv", tabindex: "-1" } })).$appendTo(el);
  grid.textArea = build(h$1("textarea.ui-ygrid-copy", { attrs: { id: p.copy, tabindex: "-1" }, style: { position: "fixed", top: "-10000px", left: "0px", width: "1000px", height: "200px" } })).$appendTo(el);
  $table.updateState();
  $table.sortableColumns();
  $table.bindBlankEvent();
  $table.bindEvents2Widget();
  $table.bindEvents2View();
  grid.bDiv.addPostpatchHook((el2) => {
    let resizeObserver = observerMap.get(p.id);
    if (resizeObserver == null) {
      let resizeFn = createDebounce(function(entry) {
        const contentRect = entry.contentRect;
        if (contentRect.height > 0 && contentRect.width > 0) {
          if (p.scrollPage && !$table.isRemoved()) {
            console.log("resize render....");
            $table.render();
          }
        }
        $table.doLayout();
      }, 1e3);
      resizeObserver = createResizeObserver(function(entries) {
        resizeFn.call(this, entries[0]);
      });
      resizeObserver.observe(grid.bDiv.getElm());
      observerMap.set(p.id, resizeObserver);
    }
  });
  if (p.search_text) {
    $table.search();
  }
  return this;
}
const publicfuns = {
  clearGridData() {
    let t = this.$table;
    return t.clearGridData.apply(t, arguments);
  },
  populate(...args) {
    let t = this.$table;
    return t.populate.apply(t, args);
  },
  setData(data2) {
    let t = this.$table;
    t.p.data = data2;
  },
  setGridWidth(...args) {
    let t = this.$table;
    return t.setGridWidth.apply(t, args);
  },
  setGridHeight(newHeight) {
    this.$setHeight(newHeight);
    let t = this.$table;
    return t.setGridHeight.apply(t, arguments);
  },
  insertGridRow() {
    let t = this.$table;
    return t.insertGridRow.apply(t, arguments);
  },
  refreshDynamicEditor() {
    let t = this.$table;
    return t.refreshDynamicEditor.apply(t, arguments);
  },
  doFocusPolicy() {
    let t = this.$table;
    return t.doFocusPolicy.apply(t, arguments);
  },
  mergeCell() {
    let t = this.$table;
    return t.mergeCell.apply(t, arguments);
  },
  setCellCaption() {
    let t = this.$table;
    return t.setCellCaption.apply(t, arguments);
  },
  setCellRequired() {
    let t = this.$table;
    return t.setCellRequired.apply(t, arguments);
  },
  setCellFocus() {
    let t = this.$table;
    return t.setCellFocus.apply(t, arguments);
  },
  setCellBackColor() {
    let t = this.$table;
    return t.setCellBackColor.apply(t, arguments);
  },
  setCellForeColor() {
    let t = this.$table;
    return t.setCellForeColor.apply(t, arguments);
  },
  setColumnEnable() {
    let t = this.$table;
    return t.setColumnEnable.apply(t, arguments);
  },
  setColumnRequired() {
    let t = this.$table;
    return t.setColumnRequired.apply(t, arguments);
  },
  setCellEnable() {
    let t = this.$table;
    return t.setCellEnable.apply(t, arguments);
  },
  setCellError() {
    let t = this.$table;
    return t.setCellError.apply(t, arguments);
  },
  setRowError() {
    let t = this.$table;
    return t.setRowError.apply(t, arguments);
  },
  setRowVisible() {
    let t = this.$table;
    return t.setRowVisible.apply(t, arguments);
  },
  exchangeRow() {
    let t = this.$table;
    return t.exchangeRow.apply(t, arguments);
  },
  setRowBackColor() {
    let t = this.$table;
    return t.setRowBackColor.apply(t, arguments);
  },
  updateCell() {
    let t = this.$table;
    return t.updateCell.apply(t, arguments);
  },
  updateHalfChecked() {
    let t = this.$table;
    return t.updateHalfChecked.apply(t, arguments);
  },
  endEdit(...args) {
    let t = this.$table;
    return t.endEdit.apply(t, args);
  },
  cleanSelection() {
    let t = this.$table;
    return t.cleanSelection.apply(t, arguments);
  },
  doUpdate() {
    let t = this.$table;
    return t.doUpdate.apply(t, arguments);
  },
  toFitWidth() {
    let t = this.$table;
    return t.toFitWidth.apply(t, arguments);
  },
  doFrozen() {
    let t = this.$table;
    return t.doFrozen.apply(t, arguments);
  },
  doFrozenRows() {
    let t = this.$table;
    return t.frozenRow.apply(t, arguments);
  },
  doFrozenLeftColumns() {
    let t = this.$table;
    return t.frozenLeftColumn.apply(t, arguments);
  },
  doFrozenRightColumns() {
    let t = this.$table;
    return t.frozenRightColumn.apply(t, arguments);
  },
  doFrozenLeftRowColumns() {
    let t = this.$table;
    return t.frozenLeftRowColumn.apply(t, arguments);
  },
  doCmd() {
    let t = this.$table;
    return t.doCmd.apply(t, arguments);
  },
  batchInsertRows() {
    let t = this.$table;
    return t.batchInsertRows.apply(t, arguments);
  },
  deleteGridRow() {
    let t = this.$table;
    return t.deleteGridRow.apply(t, arguments);
  },
  isEditing() {
    let t = this.$table;
    return t.isEditing.apply(t, arguments);
  },
  setEnable() {
    let t = this.$table;
    return t.setEnable.apply(t, arguments);
  },
  setColumnCaption() {
    let t = this.$table;
    return t.setColumnCaption.apply(t, arguments);
  },
  setColumnVisible: function() {
    let t = this.$table;
    return t.setColumnVisible.apply(t, arguments);
  },
  knvFocus() {
    let t = this.$table;
    return t.knvFocus.apply(t, arguments);
  },
  keydown(event2, changeFocus) {
    let t = this.$table;
    t.grid.knv.$callSync("keydown", { event: event2, changeFocus });
  },
  updateSelectAll() {
    let t = this.$table;
    return t.updateSelectAll.apply(t, arguments);
  },
  cleanSelectAll() {
    let t = this.$table;
    return t.cleanSelectAll.apply(t, arguments);
  },
  updateSelectAllVisible() {
    let t = this.$table;
    return t.updateSelectAllVisible.apply(t, arguments);
  },
  doLayout() {
    let t = this.$table;
    return t.doLayout.apply(t, arguments);
  },
  addCellClass() {
    let t = this.$table;
    return t.addCellClass.apply(t, arguments);
  },
  removeCellClass() {
    let t = this.$table;
    return t.removeCellClass.apply(t, arguments);
  },
  setCellMatched() {
    let t = this.$table;
    return t.setCellMatched.apply(t, arguments);
  },
  setCellSelected() {
    let t = this.$table;
    return t.setCellSelected.apply(t, arguments);
  },
  setRowSelected() {
    let t = this.$table;
    return t.setRowSelected.apply(t, arguments);
  },
  removeAllMatched() {
    let t = this.$table;
    return t.removeAllMatched.apply(t, arguments);
  },
  unmount() {
    this.$table.unmount();
    this.$table = null;
  },
  isMax() {
    let t = this.$table;
    return t.isMax.apply(t, arguments);
  },
  zoom() {
    let t = this.$table;
    return t.zoom.apply(t, arguments);
  },
  search() {
    let t = this.$table;
    return t.search.apply(t, arguments);
  },
  revert() {
    let t = this.$table;
    return t.revert.apply(t, arguments);
  },
  getRowRange() {
    let t = this.$table;
    return t.getRowRange.apply(t, arguments);
  },
  getScrollTop() {
    let t = this.$table;
    return t.getScrollTop.apply(t, arguments);
  },
  getScrollLeft() {
    let t = this.$table;
    return t.getScrollLeft.apply(t, arguments);
  },
  focus() {
    let t = this.$table;
    return t.focus.apply(t, arguments);
  },
  setExtOptEnable() {
    let t = this.$table;
    return t.setExtOptEnable.apply(t, arguments);
  },
  setExtOptVisible() {
    let t = this.$table;
    return t.setExtOptVisible.apply(t, arguments);
  },
  hideChildren() {
    let t = this.$table;
    return t.hideChildren.apply(t, arguments);
  },
  showChildren() {
    let t = this.$table;
    return t.showChildren.apply(t, arguments);
  },
  batchUpdateUI() {
    let t = this.$table;
    return t.batchUpdateUI.apply(t, arguments);
  },
  getRenderInfo() {
    let t = this.$table;
    return t.getRenderInfo.apply(t, arguments);
  }
};
class PrintHtmlControlUtil {
  static printGrid(control, columns, rows, option2) {
    this._updateGridColumnInfo(control, columns, option2);
    this._addGridSeqColumn(control, columns, rows, option2);
    let printContent = this._printGridContent(control, option2);
    let printHead = this._printGridHeader(control, option2, columns);
    printHead.$appendTo(printContent);
    let selectColumnIndex = this._getGridSelectColumnIndex(control, columns);
    let selectedRowCount = this._getGridSelectedRowCount(rows, selectColumnIndex);
    let printBody = this._printGridBody(control, columns, rows, option2, selectColumnIndex, selectedRowCount);
    printBody.$appendTo(printContent);
    let printFooter = this._printGridFooter(selectedRowCount > 0 ? selectedRowCount : rows.length);
    printFooter.$appendTo(printContent);
  }
  static _printGridContent(control, option2) {
    control.el.$removeClass();
    control.el.$addClass(`ui-print-grid`);
    if (option2.lineWrap == true)
      control.el.$addClass(`line-wrap`);
    else
      control.el.$addClass(`no-line-wrap`);
    if (option2.repeatHeaderPerPage == true)
      control.el.$addClass(`repeat-header-per-page`);
    if (option2.repeatFooterPerPage == true)
      control.el.$addClass(`repeat-footer-per-page`);
    let printContent = YElement.buildFromVNode(h$1(`table`)).$appendTo(control.el);
    printContent.$addClass(`print-grid`);
    printContent.$addStyle(`width`, control.width);
    return printContent;
  }
  static _printGridHeader(control, option2, columns) {
    let printHeader = YElement.buildFromVNode(h$1(`thead`)).$addClass(`print-grid-head`);
    let printHeaderTr = YElement.buildFromVNode(h$1(`tr`)).$appendTo(printHeader);
    let printHeaderTd = YElement.buildFromVNode(h$1(`td`)).$appendTo(printHeaderTr);
    printHeaderTd.$setAttr(`colspan`, `1000`);
    let printHeaderCols = YElement.buildFromVNode(h$1(`div`)).$addClass(`print-grid-head-cols`).$appendTo(printHeaderTd);
    for (let i = 0; i < columns.length; i++) {
      let column = columns[i];
      if (column.visible == false)
        continue;
      let printHeaderCol = YElement.buildFromVNode(h$1(`div`)).$addClass(`print-grid-head-col`).$appendTo(printHeaderCols);
      printHeaderCol.$setInnerText(column.caption);
      if (option2.lineWrap == true) {
        printHeaderCol.$addStyle(`width`, option2.columnWidth);
      } else {
        if (column.width) {
          printHeaderCol.$addStyle(`width`, column.width);
        }
      }
    }
    return printHeader;
  }
  static _printGridBody(control, columns, rows, option2, selectColumnIndex, selectedRowCount) {
    let printBody = YElement.buildFromVNode(h$1(`tbody`)).$addClass(`print-grid-body`);
    for (let row2 of rows) {
      if (selectedRowCount > 0) {
        if (row2.data[selectColumnIndex].value != true) {
          continue;
        }
      }
      let printBodyTr = YElement.buildFromVNode(h$1(`tr`)).$appendTo(printBody);
      let printBodyTd = YElement.buildFromVNode(h$1(`td`)).$appendTo(printBodyTr);
      printBodyTd.$setAttr(`colspan`, `1000`);
      let rowDiv = YElement.buildFromVNode(h$1(`div`)).$addClass(`print-grid-row`).$appendTo(printBodyTd);
      for (let i = 0; i < row2.data.length; i++) {
        if (columns[i].visible == false)
          continue;
        let fieldData = row2.data[i];
        let fieldDiv = YElement.buildFromVNode(h$1(`div`)).$addClass(`print-grid-field-value`).$appendTo(rowDiv);
        let caption = i == selectColumnIndex ? `` : fieldData.caption;
        fieldDiv.$setInnerText(caption);
        if (option2.lineWrap == true) {
          fieldDiv.$addStyle(`width`, option2.columnWidth);
        } else {
          if (columns[i].width) {
            fieldDiv.$addStyle(`width`, columns[i].width);
          }
        }
        if (ControlType.GRID == control.owner.type && columns[i].type.trim().toLowerCase() == `select` || ControlType.LISTVIEW == control.owner.type && columns[i].columnType == ControlType.CHECKBOX) {
          fieldDiv.$addClass(`checkbox`);
          fieldDiv.$setInnerText(``);
          if (fieldData.value == 1) {
            fieldDiv.$addClass(`checked`);
          }
        }
      }
    }
    return printBody;
  }
  static _printGridFooter(count) {
    let printFooter = YElement.buildFromVNode(h$1(`tfoot`)).$addClass(`print-grid-foot`);
    let printFooterTr = YElement.buildFromVNode(h$1(`tr`)).$appendTo(printFooter);
    let printFooterTd = YElement.buildFromVNode(h$1(`td`)).$appendTo(printFooterTr);
    printFooterTd.$setAttr(`colspan`, `1000`);
    let printFooterContent = YElement.buildFromVNode(h$1(`div`)).$addClass(`print-grid-foot-container`).$appendTo(printFooterTd);
    printFooterContent.$setInnerText(`共${count}行`);
    return printFooter;
  }
  static _updateGridColumnInfo(control, columns, option2) {
    var _a;
    let form = control.owner.getForm();
    let configColumns = (_a = option2 == null ? void 0 : option2.config) == null ? void 0 : _a.columns;
    if (configColumns) {
      let updateColumnInfo = (key2, configColumns2, info) => {
        if (!info) {
          info = {
            path: []
          };
        }
        for (let column of configColumns2) {
          if (key2 == column.key) {
            if (info.path.length > 0) {
              info.caption = `${info.path.join(`/`)}/${column.caption}`;
            }
            if (typeof column.visible == `string` && column.visible != ``) {
              info.visible = form.eval(column.visible, { form }, null);
            }
            return info;
          }
          if (Object.prototype.toString.call(column.columns) === "[object Array]" && column.columns.length > 0) {
            info.path.push(column.caption);
            updateColumnInfo(key2, column.columns, info);
            info.path.pop();
          }
        }
        return info;
      };
      if (columns.length > 0 && configColumns.length > 0) {
        for (let i = 0; i < columns.length; i++) {
          let info = updateColumnInfo(columns[i].key, configColumns);
          if (info.caption)
            columns[i].caption = info.caption;
          if (info.visible)
            columns[i].visible = info.visible;
        }
      }
    }
  }
  static _addGridSeqColumn(control, columns, rows, option2) {
    let seqFlag = option2.config.seq;
    if (seqFlag == true) {
      let seqCaption = `#`;
      if (ControlType.GRID == control.owner.type)
        seqCaption = I18N.getString(`GRID_SEQ`, `序号`);
      if (ControlType.LISTVIEW == control.owner.type)
        seqCaption = I18N.getString(`LISTVIEW_SEQ`, `序号`);
      columns.unshift({
        type: `seq`,
        caption: seqCaption,
        width: `60px`
      });
      for (let i = 0; i < rows.length; i++) {
        rows[i].data.unshift({
          caption: i + 1
        });
      }
    }
  }
  static _getGridSelectColumnIndex(control, columns) {
    let selectColumnIndex = -1;
    for (let i = 0; i < columns.length; i++) {
      let column = columns[i];
      if (column.visible == false)
        continue;
      if (ControlType.GRID == control.owner.type) {
        if (column.type.trim().toLowerCase() == `select`) {
          selectColumnIndex = i;
          break;
        }
      } else if (ControlType.LISTVIEW == control.owner.type) {
        if (column.isSelect == true) {
          selectColumnIndex = i;
          break;
        }
      }
    }
    return selectColumnIndex;
  }
  static _getGridSelectedRowCount(rows, selectColumnIndex) {
    let selectedRowCount = 0;
    if (selectColumnIndex >= 0) {
      for (let row2 of rows) {
        if (row2.data[selectColumnIndex].value == true) {
          selectedRowCount++;
        }
      }
    }
    return selectedRowCount;
  }
}
class YesVGrid extends YesVBaseComponent {
  constructor(option2) {
    super(option2);
    var owner = this.owner;
    var self2 = this;
    var p = this.options = {};
    p.id = owner.getId();
    p.key = owner.key;
    p.tableKey = owner.tableKey;
    p.caption = owner.caption;
    p.enable = owner.enable;
    p.rowHeight = owner.rowHeight;
    p.selectionMode = owner.selectionMode;
    p.selectModel = owner.selection;
    p.hasTree = owner.hasTree;
    p.hasColumnExpand = owner.hasColumnExpand();
    p.hasSelect = owner.hasSelect;
    p.hasDetailRow = owner.hasDetailRow;
    p.hasRowVisible = owner.hasRowVisible;
    p.hasRowGroup = owner.hasRowGroup;
    p.treeImg = owner.treeImg;
    p.treeExpand = owner.treeExpand;
    p.showRowHead = () => owner.showRowHead();
    p.serialSeq = owner.serialSeq;
    p.rootColumns = owner.getRootColumns();
    p.columns = owner.getViewColumns();
    p.add = owner.add;
    p.del = owner.del;
    p.shift = owner.shift;
    p.search = owner.search;
    p.bestWidth = owner.bestWidth;
    p.frozenRow = owner.frozenRow;
    p.frozenColumn = owner.frozenColumn;
    p.frozenRowColumn = owner.frozenRowColumn;
    p.variantSet = owner.variantset;
    p.editRowFormKey = owner.editRowFormKey;
    p.extOpts = owner.extOpts;
    p.traces = owner.traces;
    p.endEditByNav = owner.endEditByNav;
    p.defaultFitWidth = owner.defaultFitWidth;
    p.pageInfo = owner.pageInfo;
    p.rowList = owner.rowList;
    p.serialRowNum = owner.serialRowNum;
    p.freezeRowCnt = owner.freezeRowCnt;
    p.freezeLeftColCnt = owner.freezeLeftColCnt;
    p.freezeRightColCnt = owner.freezeRightColCnt;
    p.scrollPage = owner.scrollPage;
    p.isGroup = owner.isGroup;
    p.selectAllInfo = owner.selectAllInfo;
    p.extOptsInfo = owner.extOptsInfo;
    p.historyInput = owner.historyInput;
    p.enableColumnMenu = owner.enableColumnMenu;
    p.preventPaste = owner.preventPaste;
    p.sortConfig = owner.sortConfig, p.sumConfig = owner.sumConfig, p.filterConfig = owner.filterConfig, p.variantConfig = owner.variantConfig, p.search = owner.search;
    p.zoom = owner.zoom;
    p.sortable = owner.sortable;
    p.export = owner.export;
    p.sum = owner.sum;
    p.filterset = owner.filterset;
    p.groupsum = owner.groupsum;
    p.variantset = owner.variantset;
    p.cpHandler = owner.getCPHandler();
    var handler = owner.getHandler();
    p.gotoPage = function() {
      return handler.doGoToPage.call(handler, owner, ...arguments);
    };
    p.toFitWidth = function() {
      return owner.toFitWidth.apply(owner, arguments);
    };
    p.recordClick = function() {
      return owner.recordClick.apply(owner, arguments);
    };
    p.clickRow = function() {
      return handler.doOnRowClick.call(handler, owner, ...arguments);
    };
    p.dblClick = function() {
      return handler.doOnDblClick.call(handler, owner, ...arguments);
    };
    p.rowChanged = function() {
      return handler.doOnRowChanged.call(handler, owner, ...arguments);
    };
    p.deleteRange = function() {
      return handler.deleteRange.call(handler, owner, ...arguments);
    };
    p.editGridRow = function() {
      return handler.editGridRow.call(handler, owner);
    };
    p.addGridRow = function() {
      return handler.addGridRow.call(handler, owner);
    };
    p.doZoom = function() {
      return owner.doZoom.apply(owner, arguments);
    };
    p.doRevert = function() {
      return owner.doRevert.apply(owner, arguments);
    };
    p.doSearch = function() {
      return owner.doSearch.apply(owner, arguments);
    };
    p.searchText = function() {
      return owner.searchText.apply(owner, arguments);
    };
    p.doFitWidth = function() {
      return owner.doFitWidth.apply(owner, arguments);
    };
    p.doExport = function() {
      return owner.doExport.apply(owner, arguments);
    };
    p.doFrozen = function() {
      return owner.doFrozen.apply(owner, arguments);
    };
    p.fetchRowsStatus = function() {
      return owner.fetchRowsStatus.apply(owner, arguments);
    };
    p.fetchCaption = function() {
      return owner.fetchCaption.apply(owner, arguments);
    };
    p.createCellEditor = function() {
      return owner.createCellEditor.apply(owner, arguments);
    };
    p.createShowEditor = function() {
      return owner.createShowEditor.apply(owner, arguments);
    };
    p.asyncEval = function() {
      return owner.asyncEval.apply(owner, arguments);
    };
    p.getImageBase64URL = function() {
      return owner.getImageBase64URL.apply(owner, arguments);
    };
    p.calcColor = function() {
      return owner.calcColor.apply(owner, arguments);
    };
    p.requestNextFocus = function() {
      return owner.requestNextFocus.apply(owner, arguments);
    };
    p.showChildren = function() {
      return owner.showChildren.apply(owner, arguments);
    };
    p.hideChildren = function() {
      return owner.hideChildren.apply(owner, arguments);
    };
    p.insertRow = function() {
      return owner.insertRow.apply(owner, arguments);
    };
    p.deleteRow = function() {
      return owner.deleteRow.call(owner, arguments[0], true);
    };
    p.batchDeleteRow = function() {
      return owner.batchDeleteRow.call(owner, true);
    };
    p.doShiftUpRow = function() {
      return handler.doShiftUpRow.call(handler, owner, ...arguments);
    };
    p.doShiftDownRow = function() {
      return handler.doShiftDownRow.call(handler, owner, ...arguments);
    };
    p.createShowEditor = function() {
      return owner.createShowEditor.apply(owner, arguments);
    };
    p.commitValue = function() {
      return owner.setValueAt.apply(owner, arguments);
    };
    p.doSelectAll = function() {
      return owner.doSelectAll.apply(owner, arguments);
    };
    p.getControlGrid = function() {
      return owner;
    };
    p.setColumnVisible = function() {
      return owner.setColumnVisible.apply(owner, arguments);
    };
    p.doFrozenRows = function() {
      return owner.doFrozenRows.apply(owner, arguments);
    };
    p.doFrozenLeftColumns = function() {
      return owner.doFrozenLeftColumns.apply(owner, arguments);
    };
    p.doFrozenRightColumns = function() {
      return owner.doFrozenRightColumns.apply(owner, arguments);
    };
    p.doFrozenLeftRowColumns = function() {
      return owner.doFrozenLeftRowColumns.apply(owner, arguments);
    };
    p.getTotalInfo = function() {
      return owner.getTotalInfo.apply(owner, arguments);
    };
    p.findColumn = function() {
      return owner.findColumn.apply(owner, arguments);
    };
    p.indexById = function() {
      return owner.getRowIndexByID.apply(owner, arguments);
    };
    p.getRowCount = function() {
      return owner.getRowCount.apply(owner, arguments);
    };
    p.hasGroupRow = function() {
      return owner.hasGroupRow;
    };
    p.hasTotalRow = function() {
      return owner.hasTotalRow;
    };
    p.setRowChanging = function() {
      return owner.setRowChanging.apply(owner, arguments);
    };
    p.doSearch = function() {
      return owner.doSearch.apply(owner, arguments);
    };
    p.clearSearch = function() {
      return owner.clearSearch.apply(owner, arguments);
    };
    p.searchNext = function() {
      return owner.searchNext.apply(owner, arguments);
    };
    p.getZIndex = function() {
      return owner.getZIndex.apply(owner, arguments);
    };
    p.clearZoomZIndex = function() {
      return owner.clearZoomZIndex.apply(owner, arguments);
    };
    p.setRowSum = function() {
      return owner.setRowSum.apply(owner, arguments);
    };
    p.setGroup = function() {
      return owner.setGroup.apply(owner, arguments);
    };
    p.setRowGroup = function() {
      return owner.setRowGroup.apply(owner, arguments);
    };
    p.setVariant = function() {
      return owner.setVariant.apply(owner, arguments);
    };
    p.setFilter = function() {
      return owner.setFilter.apply(owner, arguments);
    };
    p.setColumnFilter = function() {
      return owner.setColumnFilter.apply(owner, arguments);
    };
    p.setColumnSort = function() {
      return owner.setColumnSort.apply(owner, arguments);
    };
    p.setRowSort = function() {
      return owner.setRowSort.apply(owner, arguments);
    };
    p.toggleRow = function() {
      return owner.toggleRow.apply(owner, arguments);
    };
    p.enhanceCell = function() {
      var _a;
      return (_a = self2["enhanceCell"]) == null ? void 0 : _a.apply(self2, arguments);
    };
    p.addExtOpt = function() {
      var _a;
      return (_a = self2["addExtOpt"]) == null ? void 0 : _a.apply(self2, arguments);
    };
    p.findFocusPos = function() {
      var _a;
      return (_a = self2["findFocusPos"]) == null ? void 0 : _a.apply(self2, arguments);
    };
  }
  beforeRender($el) {
    super.beforeRender($el);
    this.el.vGrid = vGrid;
  }
  refreshGrid(scrollInfo) {
    return this.createHtml(scrollInfo);
  }
  afterRender() {
    super.afterRender();
    let model = this.owner.selection;
    if (model.focusRow >= 0 && model.focusCol >= 0) {
      this.el.focus();
    }
  }
  createHtml(scrollInfo) {
    let renderInfo;
    if (this.el.getRenderInfo) {
      renderInfo = this.el.getRenderInfo();
    }
    if (this.el.unmount) {
      this.el.unmount();
    }
    this.el.$empty();
    this.el.vGrid(this.options);
    this.el.setData(this.owner.getDatas());
    this.el.populate({ ...scrollInfo, ...renderInfo });
  }
  render(ct) {
    var _a;
    let form = this.owner.getForm();
    let renderContext = form.getRenderContext();
    let formOption = renderContext.getPrintFormOption();
    if (renderContext.isPrinting()) {
      this.beforeRender(ct);
      this.el.$empty();
      this.el.$setAttr(`id`, this.options.id + `_box`);
      if (!this.el.unmount)
        this.el.unmount = () => {
        };
      let columns = [...this.options.columns];
      let sourceForm = renderContext.getPrintSourceForm();
      let sourceControl = sourceForm.formAdapt.comMap[this.key];
      let colInfoList = (_a = sourceControl == null ? void 0 : sourceControl.dataModel) == null ? void 0 : _a.columns;
      if (colInfoList) {
        for (let colInfo of colInfoList) {
          let key2 = colInfo.key;
          let width = colInfo.width;
          if (key2 && width) {
            for (let column of columns) {
              if (column.key == key2) {
                column.width = `${width}px`;
                break;
              }
            }
          }
        }
      }
      let config = form.metaForm.componentMap.table[this.key];
      let option2 = {
        columnWidth: formOption.getTableColumnWidth(),
        lineWrap: formOption.getTableLineWrap(),
        repeatHeaderPerPage: formOption.getTableRepeatHeaderPerPage(),
        repeatFooterPerPage: formOption.getTableRepeatFooterPerPage(),
        config: {
          columns: [...config.columns],
          seq: config.showRowHead
        }
      };
      PrintHtmlControlUtil.printGrid(this, columns, this.owner.getDatas(), option2);
    } else {
      super.render(ct);
    }
  }
  updateOption(option2) {
    Object.assign(this.options, option2);
  }
  setWidth(width) {
    var w = width == "auto" ? "" : width;
    this.el.setGridWidth(w);
  }
  setHeight(height) {
    var h2 = height == "auto" ? "" : height;
    this.el.setGridHeight(h2);
  }
  doLayout() {
    this.el.doLayout();
  }
  doFrozen() {
    this.el.doFrozen();
  }
  doUpdate(...args) {
    this.el.doUpdate.apply(this.el, args);
  }
  doFrozenRows() {
    this.el.doFrozenRows.apply(this.el, arguments);
  }
  doFrozenLeftColumns(...args) {
    this.el.doFrozenLeftColumns.apply(this.el, args);
  }
  doFrozenRightColumns(...args) {
    this.el.doFrozenRightColumns.apply(this.el, args);
  }
  doFrozenLeftRowColumns(...args) {
    this.el.doFrozenLeftRowColumns.apply(this.el, args);
  }
  doCmd(...args) {
    return this.el.doCmd.apply(this.el, args);
  }
  showChildren(...args) {
    this.el.showChildren.apply(this.el, args);
  }
  hideChildren(...args) {
    this.el.hideChildren.apply(this.el, args);
  }
  setData(data2) {
    this.el.setData(data2);
  }
  refreshDynamicEditor(...args) {
    this.el.refreshDynamicEditor.apply(this.el, args);
  }
  setEnable(...args) {
    this.el.setEnable.apply(this.el, args);
  }
  populate() {
    this.el.populate();
  }
  updateSelectAll(...args) {
    this.el.updateSelectAll.apply(this.el, args);
  }
  cleanSelectAll() {
    this.el.cleanSelectAll();
  }
  updateSelectAllVisible(...args) {
    this.el.updateSelectAllVisible.apply(this.el, args);
  }
  addCellClass(...args) {
    this.el.addCellClass.apply(this.el, args);
    return this;
  }
  removeCellClass(...args) {
    this.el.removeCellClass.apply(this.el, args);
    return this;
  }
  setCellMatched(...args) {
    this.el.setCellMatched.apply(this.el, args);
    return this;
  }
  setCellSelected(...args) {
    this.el.setCellSelected.apply(this.el, args);
    return this;
  }
  removeAllMatched() {
    return this.el.removeAllMatched();
  }
  setRowSelected(...args) {
    this.el.setRowSelected.apply(this.el, args);
    return this;
  }
  cleanSelection() {
    this.el.cleanSelection();
  }
  clearGridData() {
    this.el.clearGridData();
  }
  mergeCell() {
    this.el.mergeCell();
  }
  toFitWidth(...args) {
    return this.el.toFitWidth.apply(this.el, args);
  }
  unmount() {
    this.el.unmount();
  }
  setFocusRowIndex(...args) {
    return this.el.setCellFocus.apply(this.el, args);
  }
  setCellFocus(...args) {
    return this.el.setCellFocus.apply(this.el, args);
  }
  setCellBackColor(...args) {
    this.el.setCellBackColor.apply(this.el, args);
  }
  setCellForeColor(...args) {
    this.el.setCellForeColor.apply(this.el, args);
  }
  setCellCaption(...args) {
    this.el.setCellCaption.apply(this.el, args);
  }
  updateCell(...args) {
    this.el.updateCell.apply(this.el, args);
  }
  updateHalfChecked(...args) {
    this.el.updateHalfChecked.apply(this.el, args);
  }
  insertGridRow(...args) {
    this.el.insertGridRow.apply(this.el, args);
  }
  deleteGridRow(...args) {
    this.el.deleteGridRow.apply(this.el, args);
  }
  setCellEnable(...args) {
    this.el.setCellEnable.apply(this.el, args);
  }
  setColumnEnable(...args) {
    this.el.setColumnEnable.apply(this.el, args);
  }
  setColumnRequired(...args) {
    this.el.setColumnRequired.apply(this.el, args);
  }
  setCellRequired(...args) {
    this.el.setCellRequired.apply(this.el, args);
  }
  setCellError(...args) {
    this.el.setCellError.apply(this.el, args);
  }
  batchUpdateUI(...args) {
    this.el.batchUpdateUI.apply(this.el, args);
  }
  setRowBackColor(...args) {
    this.el.setRowBackColor.apply(this.el, args);
  }
  setRowError(...args) {
    this.el.setRowError.apply(this.el, args);
  }
  isEditing() {
    return this.el.isEditing();
  }
  isHide() {
    let elm = this.el.getElm();
    return elm && !isVisible(elm);
  }
  isMax() {
    return this.el.isMax();
  }
  zoom() {
    return this.el.zoom();
  }
  revert() {
    return this.el.revert();
  }
  search() {
    return this.el.search();
  }
  endEdit() {
    this.el.endEdit();
  }
  setExtOptEnable(...args) {
    this.el.setExtOptEnable.apply(this.el, args);
  }
  setExtOptVisible(...args) {
    this.el.setExtOptVisible.apply(this.el, args);
  }
  setRowVisible(...args) {
    this.el.setRowVisible.apply(this.el, args);
  }
  setColumnCaption(...args) {
    this.el.setColumnCaption.apply(this.el, args);
  }
  setColumnVisible(...args) {
    this.el.setColumnVisible.apply(this.el, args);
  }
  exchangeRow(...args) {
    this.el.exchangeRow.apply(this.el, args);
  }
  getRowRange() {
    return this.el.getRowRange();
  }
  getScrollTop() {
    return this.el.getScrollTop();
  }
  getScrollLeft() {
    return this.el.getScrollLeft();
  }
  doFocusPolicy(...args) {
    this.el.doFocusPolicy.apply(this.el, args);
  }
  commitValue(...args) {
    return this.owner.setValueAt.apply(this.owner, args).then((isChanged) => {
      if (isChanged == true) {
        let rowIndex2 = args[0], colIndex = args[1];
        let editor = this.owner.getCellEditOpt(rowIndex2, colIndex);
        let value = this.owner.getValueAt(rowIndex2, colIndex);
        if (editor) {
          editor.label = editor.caption;
          editor.getControl = () => {
            return this.owner;
          };
          editor.getRowIndex = () => {
            return rowIndex2;
          };
          editor.getColIndex = () => {
            return colIndex;
          };
          this.owner.getForm().getUIOptTracer().traceOnValueChanged(editor, value);
        }
      }
    });
  }
  createShowEditor(options, cell, ri, ci, vci) {
    cell.$empty();
    options.getRowIndex = () => {
      var tr = cell.$parents((p) => {
        if (p.getAttr("role") === "row") {
          return false;
        }
        return true;
      });
      return parseInt(stripPref("ygd", tr.getAttr("id")), 10);
    };
    options.getColIndex = () => {
      return ci;
    };
    options.requestNextFocus = (keyCode) => {
      return this.doFocusPolicy(keyCode);
    };
    options.commitValue = (value) => {
      var rowIndex2 = options.getRowIndex();
      var colIndex = options.getColIndex();
      colIndex = options.resolveColIndex(colIndex);
      return Promise.resolve(this.commitValue(rowIndex2, colIndex, value, true, true, true)).then(() => {
        window.setTimeout(() => {
          this.el.knvFocus();
        }, 0);
      }, function(error) {
        throw error;
      });
    };
    let $dom = YElement.buildFromVNode(h$1("div")).$appendTo(cell);
    var clazz = EditorMapping.getInstance().get(options.cellType);
    var editor = new clazz(options);
    editor.render($dom);
    editor.setEnable(options.enable);
    if (options.type == ControlType.CHECKBOX) {
      editor.setValue(options.value, options.halfChecked);
    } else {
      editor.setValue(options.value);
    }
    editor.setShowText(options.caption);
    cell.$setCustomData("editor", editor);
  }
  createCellEditor(options, cell, ri, ci, vci, opt) {
    options.rowIndex = ri;
    options.colIndex = ci;
    this.owner.getForm();
    var startEdit = function(editor2) {
      var event2 = opt.event || window.event;
      if (event2.type === "click" && editor2.getDropBtn) {
        var srcE = event2.target || event2.srcElement, x = event2.offsetX || event2.clientX - srcE.getBoundingClientRect().left;
        if (x + 30 > cell.getElm().offsetWidth) {
          return editor2.getDropBtn().$call("click");
        }
        if (editor2.hasInputEvent()) {
          return editor2.getInput().$call("click");
        }
      }
      window.setTimeout(function() {
        const $input2 = editor2.getInput();
        $input2.$addListener("focus", (e) => {
          if (opt.keyCode) {
            moveStart(e.target);
          } else {
            e.target.select();
          }
        });
        $input2.$focus();
        if (opt.keyCode) {
          $input2.$setInputValue(opt.keyCode);
        }
      }, 0);
    };
    let $dom = YElement.buildFromVNode(h$1("div")).$appendTo(cell);
    var clazz = EditorMapping.getInstance().get(options.cellType);
    var editor = new clazz(options);
    editor.render($dom);
    editor.setWidth("100%");
    editor.setHeight("100%");
    editor.setValue(options.value);
    editor.setShowText(options.caption);
    options.getRowIndex = function() {
      return ri;
    };
    options.getColIndex = function() {
      return ci;
    };
    options.commitValue = (value) => {
      const editor2 = cell.getCustomData("editor");
      if (editor2) {
        options.displayCols = editor2.displayCols;
      }
      options.endEdit(false);
      if (options.cellType = ControlType.DYNAMICDICT) {
        let cellData = this.owner.getCellDataAt(ri, ci);
        if (cellData) {
          if (!cellData.dataElementKey) {
            if (options.dataElementKey) {
              cellData.dataElementKey = options.dataElementKey;
            }
          }
        }
      }
      return Promise.resolve(this.commitValue(ri, ci, value, true, true, true)).then(() => {
        window.setTimeout(() => {
          this.el.knvFocus();
        }, 0);
      });
    };
    options.endEdit = options.doFocusOut = (update) => {
      if (this.isEditing()) {
        this.el.endEdit(ri, ci, vci, update);
      }
    };
    options.hasAffect = () => {
      return this.owner.hasAffect();
    };
    const $input = editor.getInput();
    $input.$keydown((event2) => {
      var keyCode = event2.charCode || event2.keyCode || 0;
      if (keyCode === 13 || keyCode === 108 || keyCode === 9) {
        $input.$blur();
        setTimeout(async () => {
          await DomEventQueue.isFinished();
          let changeFocus = true;
          if (editor && editor.impl.hasQueryPanel) {
            changeFocus = false;
          }
          this.el.keydown(event2, changeFocus);
        }, 0);
      }
    });
    startEdit(editor);
    cell.$setCustomData("editor", editor);
  }
}
class YesGridBuilder extends YesComponentBuilder {
  static create(options) {
    return new YesVGrid(options);
  }
}
function addNS(data2, children, sel) {
  data2.ns = "http://www.w3.org/2000/svg";
  if (sel !== "foreignObject" && children !== void 0) {
    for (let i = 0; i < children.length; ++i) {
      const child = children[i];
      if (typeof child === "string")
        continue;
      const childData = child.data;
      if (childData !== void 0) {
        addNS(childData, child.children, child.sel);
      }
    }
  }
}
function h(sel, b, c) {
  let data2 = {};
  let children;
  let text;
  let i;
  if (c !== void 0) {
    if (b !== null) {
      data2 = b;
    }
    if (array(c)) {
      children = c;
    } else if (primitive(c)) {
      text = c.toString();
    } else if (c && c.sel) {
      children = [c];
    }
  } else if (b !== void 0 && b !== null) {
    if (array(b)) {
      children = b;
    } else if (primitive(b)) {
      text = b.toString();
    } else if (b && b.sel) {
      children = [b];
    } else {
      data2 = b;
    }
  }
  if (children !== void 0) {
    for (i = 0; i < children.length; ++i) {
      if (primitive(children[i]))
        children[i] = vnode(void 0, void 0, void 0, children[i], void 0);
    }
  }
  const getTagNameFromSel = (sel2) => {
    if (!sel2) {
      return "";
    }
    var idIdx = sel2.indexOf("#");
    if (idIdx >= 0) {
      sel2 = sel2.substring(0, idIdx);
    }
    var clsIdx = sel2.indexOf(".");
    if (clsIdx >= 0) {
      sel2 = sel2.substring(0, clsIdx);
    }
    return sel2.toLowerCase();
  };
  const getIdFromSel = (sel2) => {
    if (!sel2) {
      return "";
    }
    let idIdx = sel2.indexOf("#");
    if (idIdx >= 0) {
      sel2 = sel2.substring(idIdx + 1);
      const _t = sel2.indexOf(".");
      _t >= 0 && (sel2 = sel2.substring(0, _t));
      return sel2;
    } else {
      return "";
    }
  };
  const getClassesFromSel = (sel2) => {
    let result = [];
    if (!sel2) {
      return result;
    }
    if (sel2.includes(" ")) {
      console.error(`sel: ${sel2}无效！`);
      return result;
    }
    sel2 = sel2.replace(getTagNameFromSel(sel2), "");
    sel2 = sel2.replace("#" + getIdFromSel(sel2), "");
    result = sel2.split(".");
    result = result.filter((item) => item).filter((item) => !item.includes("#"));
    return result;
  };
  let myid = getIdFromSel(sel);
  let myclass = getClassesFromSel(sel);
  myid && (data2.attrs.id = myid);
  myclass.forEach((item) => {
    data2.class = data2.class || {};
    data2.class[item] = true;
  });
  sel = getTagNameFromSel(sel);
  if (sel[0] === "s" && sel[1] === "v" && sel[2] === "g" && (sel.length === 3 || sel[3] === "." || sel[3] === "#")) {
    addNS(data2, children, sel);
  }
  return vnode(sel, data2, children, text, void 0);
}
/*
@license

dhtmlxGantt v.7.1.7 Professional

This software is covered by DHTMLX Ultimate License. Usage without proper license is prohibited.

(c) XB Software Ltd.

*/
!function(t, e) {
  "object" == typeof exports && "object" == typeof module ? module.exports = e() : "function" == typeof define && define.amd ? define("dhtmlxgantt", [], e) : "object" == typeof exports ? exports.dhtmlxgantt = e() : t.dhtmlxgantt = e();
}(window, function() {
  return function(t) {
    var e = {};
    function n(i) {
      if (e[i])
        return e[i].exports;
      var r = e[i] = { i, l: false, exports: {} };
      return t[i].call(r.exports, r, r.exports, n), r.l = true, r.exports;
    }
    return n.m = t, n.c = e, n.d = function(t2, e2, i) {
      n.o(t2, e2) || Object.defineProperty(t2, e2, { enumerable: true, get: i });
    }, n.r = function(t2) {
      "undefined" != typeof Symbol && Symbol.toStringTag && Object.defineProperty(t2, Symbol.toStringTag, { value: "Module" }), Object.defineProperty(t2, "__esModule", { value: true });
    }, n.t = function(t2, e2) {
      if (1 & e2 && (t2 = n(t2)), 8 & e2)
        return t2;
      if (4 & e2 && "object" == typeof t2 && t2 && t2.__esModule)
        return t2;
      var i = /* @__PURE__ */ Object.create(null);
      if (n.r(i), Object.defineProperty(i, "default", { enumerable: true, value: t2 }), 2 & e2 && "string" != typeof t2)
        for (var r in t2)
          n.d(i, r, (function(e3) {
            return t2[e3];
          }).bind(null, r));
      return i;
    }, n.n = function(t2) {
      var e2 = t2 && t2.__esModule ? function() {
        return t2.default;
      } : function() {
        return t2;
      };
      return n.d(e2, "a", e2), e2;
    }, n.o = function(t2, e2) {
      return Object.prototype.hasOwnProperty.call(t2, e2);
    }, n.p = "/codebase/", n(n.s = 281);
  }([function(t, e, n) {
    function i(t2) {
      "@babel/helpers - typeof";
      return (i = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(t3) {
        return typeof t3;
      } : function(t3) {
        return t3 && "function" == typeof Symbol && t3.constructor === Symbol && t3 !== Symbol.prototype ? "symbol" : typeof t3;
      })(t2);
    }
    var r, a = n(2), o = {}.constructor.toString();
    t.exports = { copy: function t2(e2) {
      var n2, r2;
      if (e2 && "object" == i(e2))
        switch (true) {
          case a.isDate(e2):
            r2 = new Date(e2);
            break;
          case a.isArray(e2):
            for (r2 = new Array(e2.length), n2 = 0; n2 < e2.length; n2++)
              r2[n2] = t2(e2[n2]);
            break;
          default:
            for (n2 in r2 = function(t3) {
              return t3.constructor.toString() !== o;
            }(e2) ? Object.create(e2) : {}, e2)
              Object.prototype.hasOwnProperty.apply(e2, [n2]) && (r2[n2] = t2(e2[n2]));
        }
      return r2 || e2;
    }, defined: function(t2) {
      return void 0 !== t2;
    }, mixin: function(t2, e2, n2) {
      for (var i2 in e2)
        (void 0 === t2[i2] || n2) && (t2[i2] = e2[i2]);
      return t2;
    }, uid: function() {
      return r || (r = (/* @__PURE__ */ new Date()).valueOf()), ++r;
    }, bind: function(t2, e2) {
      return t2.bind ? t2.bind(e2) : function() {
        return t2.apply(e2, arguments);
      };
    }, event: function(t2, e2, n2, i2) {
      t2.addEventListener ? t2.addEventListener(e2, n2, void 0 !== i2 && i2) : t2.attachEvent && t2.attachEvent("on" + e2, n2);
    }, eventRemove: function(t2, e2, n2, i2) {
      t2.removeEventListener ? t2.removeEventListener(e2, n2, void 0 !== i2 && i2) : t2.detachEvent && t2.detachEvent("on" + e2, n2);
    } };
  }, function(t, e) {
    function n(t2) {
      var e2 = 0, n2 = 0, i2 = 0, r2 = 0;
      if (t2.getBoundingClientRect) {
        var a2 = t2.getBoundingClientRect(), o2 = document.body, s2 = document.documentElement || document.body.parentNode || document.body, l2 = window.pageYOffset || s2.scrollTop || o2.scrollTop, c2 = window.pageXOffset || s2.scrollLeft || o2.scrollLeft, u2 = s2.clientTop || o2.clientTop || 0, d = s2.clientLeft || o2.clientLeft || 0;
        e2 = a2.top + l2 - u2, n2 = a2.left + c2 - d, i2 = document.body.offsetWidth - a2.right, r2 = document.body.offsetHeight - a2.bottom;
      } else {
        for (; t2; )
          e2 += parseInt(t2.offsetTop, 10), n2 += parseInt(t2.offsetLeft, 10), t2 = t2.offsetParent;
        i2 = document.body.offsetWidth - t2.offsetWidth - n2, r2 = document.body.offsetHeight - t2.offsetHeight - e2;
      }
      return { y: Math.round(e2), x: Math.round(n2), width: t2.offsetWidth, height: t2.offsetHeight, right: Math.round(i2), bottom: Math.round(r2) };
    }
    function i(t2) {
      var e2 = false, n2 = false;
      if (window.getComputedStyle) {
        var i2 = window.getComputedStyle(t2, null);
        e2 = i2.display, n2 = i2.visibility;
      } else
        t2.currentStyle && (e2 = t2.currentStyle.display, n2 = t2.currentStyle.visibility);
      return "none" != e2 && "hidden" != n2;
    }
    function r(t2) {
      return !isNaN(t2.getAttribute("tabindex")) && 1 * t2.getAttribute("tabindex") >= 0;
    }
    function a(t2) {
      return !{ a: true, area: true }[t2.nodeName.loLowerCase()] || !!t2.getAttribute("href");
    }
    function o(t2) {
      return !{ input: true, select: true, textarea: true, button: true, object: true }[t2.nodeName.toLowerCase()] || !t2.hasAttribute("disabled");
    }
    function s(t2) {
      if (!t2)
        return "";
      var e2 = t2.className || "";
      return e2.baseVal && (e2 = e2.baseVal), e2.indexOf || (e2 = ""), u(e2);
    }
    var l;
    function c(t2) {
      return t2.tagName ? t2 : (t2 = t2 || window.event).target || t2.srcElement;
    }
    function u(t2) {
      return (String.prototype.trim || function() {
        return this.replace(/^\s+|\s+$/g, "");
      }).apply(t2);
    }
    t.exports = { getNodePosition: n, getFocusableNodes: function(t2) {
      for (var e2 = t2.querySelectorAll(["a[href]", "area[href]", "input", "select", "textarea", "button", "iframe", "object", "embed", "[tabindex]", "[contenteditable]"].join(", ")), n2 = Array.prototype.slice.call(e2, 0), s2 = 0; s2 < n2.length; s2++)
        n2[s2].$position = s2;
      for (n2.sort(function(t3, e3) {
        return 0 === t3.tabIndex && 0 !== e3.tabIndex ? 1 : 0 !== t3.tabIndex && 0 === e3.tabIndex ? -1 : t3.tabIndex === e3.tabIndex ? t3.$position - e3.$position : t3.tabIndex < e3.tabIndex ? -1 : 1;
      }), s2 = 0; s2 < n2.length; s2++) {
        var l2 = n2[s2];
        (r(l2) || o(l2) || a(l2)) && i(l2) || (n2.splice(s2, 1), s2--);
      }
      return n2;
    }, getScrollSize: function() {
      var t2 = document.createElement("div");
      t2.style.cssText = "visibility:hidden;position:absolute;left:-1000px;width:100px;padding:0px;margin:0px;height:110px;min-height:100px;overflow-y:scroll;", document.body.appendChild(t2);
      var e2 = t2.offsetWidth - t2.clientWidth;
      return document.body.removeChild(t2), e2;
    }, getClassName: s, addClassName: function(t2, e2) {
      e2 && -1 === t2.className.indexOf(e2) && (t2.className += " " + e2);
    }, removeClassName: function(t2, e2) {
      e2 = e2.split(" ");
      for (var n2 = 0; n2 < e2.length; n2++) {
        var i2 = new RegExp("\\s?\\b" + e2[n2] + "\\b(?![-_.])", "");
        t2.className = t2.className.replace(i2, "");
      }
    }, insertNode: function(t2, e2) {
      l || (l = document.createElement("div")), l.innerHTML = e2;
      var n2 = l.firstChild;
      return t2.appendChild(n2), n2;
    }, removeNode: function(t2) {
      t2 && t2.parentNode && t2.parentNode.removeChild(t2);
    }, getChildNodes: function(t2, e2) {
      for (var n2 = t2.childNodes, i2 = n2.length, r2 = [], a2 = 0; a2 < i2; a2++) {
        var o2 = n2[a2];
        o2.className && -1 !== o2.className.indexOf(e2) && r2.push(o2);
      }
      return r2;
    }, toNode: function(t2) {
      return "string" == typeof t2 ? document.getElementById(t2) || document.querySelector(t2) || document.body : t2 || document.body;
    }, locateClassName: function(t2, e2, n2) {
      var i2 = c(t2), r2 = "";
      for (void 0 === n2 && (n2 = true); i2; ) {
        if (r2 = s(i2)) {
          var a2 = r2.indexOf(e2);
          if (a2 >= 0) {
            if (!n2)
              return i2;
            var o2 = 0 === a2 || !u(r2.charAt(a2 - 1)), l2 = a2 + e2.length >= r2.length || !u(r2.charAt(a2 + e2.length));
            if (o2 && l2)
              return i2;
          }
        }
        i2 = i2.parentNode;
      }
      return null;
    }, locateAttribute: function(t2, e2) {
      if (e2) {
        for (var n2 = c(t2); n2; ) {
          if (n2.getAttribute && n2.getAttribute(e2))
            return n2;
          n2 = n2.parentNode;
        }
        return null;
      }
    }, getTargetNode: c, getRelativeEventPosition: function(t2, e2) {
      var i2 = document.documentElement, r2 = n(e2);
      return { x: t2.clientX + i2.scrollLeft - i2.clientLeft - r2.x + e2.scrollLeft, y: t2.clientY + i2.scrollTop - i2.clientTop - r2.y + e2.scrollTop };
    }, isChildOf: function(t2, e2) {
      if (!t2 || !e2)
        return false;
      for (; t2 && t2 != e2; )
        t2 = t2.parentNode;
      return t2 === e2;
    }, hasClass: function(t2, e2) {
      return "classList" in t2 ? t2.classList.contains(e2) : new RegExp("\\b" + e2 + "\\b").test(t2.className);
    }, closest: function(t2, e2) {
      if (t2.closest)
        return t2.closest(e2);
      if (t2.matches || t2.msMatchesSelector || t2.webkitMatchesSelector) {
        var n2 = t2;
        if (!document.documentElement.contains(n2))
          return null;
        do {
          if ((n2.matches || n2.msMatchesSelector || n2.webkitMatchesSelector).call(n2, e2))
            return n2;
          n2 = n2.parentElement || n2.parentNode;
        } while (null !== n2 && 1 === n2.nodeType);
        return null;
      }
      return console.error("Your browser is not supported"), null;
    } };
  }, function(t, e) {
    function n(t2) {
      "@babel/helpers - typeof";
      return (n = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(t3) {
        return typeof t3;
      } : function(t3) {
        return t3 && "function" == typeof Symbol && t3.constructor === Symbol && t3 !== Symbol.prototype ? "symbol" : typeof t3;
      })(t2);
    }
    var i = { second: 1, minute: 60, hour: 3600, day: 86400, week: 604800, month: 2592e3, quarter: 7776e3, year: 31536e3 };
    function r(t2) {
      return !(!t2 || "object" !== n(t2)) && !!(t2.getFullYear && t2.getMonth && t2.getDate);
    }
    function a(t2, e2) {
      var n2 = [];
      if (t2.filter)
        return t2.filter(e2);
      for (var i2 = 0; i2 < t2.length; i2++)
        e2(t2[i2], i2) && (n2[n2.length] = t2[i2]);
      return n2;
    }
    function o(t2) {
      return 0 === t2;
    }
    t.exports = { getSecondsInUnit: function(t2) {
      return i[t2] || i.hour;
    }, forEach: function(t2, e2) {
      if (t2.forEach)
        t2.forEach(e2);
      else
        for (var n2 = t2.slice(), i2 = 0; i2 < n2.length; i2++)
          e2(n2[i2], i2);
    }, arrayMap: function(t2, e2) {
      if (t2.map)
        return t2.map(e2);
      for (var n2 = t2.slice(), i2 = [], r2 = 0; r2 < n2.length; r2++)
        i2.push(e2(n2[r2], r2));
      return i2;
    }, arrayIncludes: function(t2, e2) {
      if (t2.includes)
        return t2.includes(e2);
      for (var n2 = 0; n2 < t2.length; n2++)
        if (t2[n2] === e2)
          return true;
      return false;
    }, arrayFind: function(t2, e2) {
      if (t2.find)
        return t2.find(e2);
      for (var n2 = 0; n2 < t2.length; n2++)
        if (e2(t2[n2], n2))
          return t2[n2];
    }, arrayFilter: a, arrayDifference: function(t2, e2) {
      return a(t2, function(t3, n2) {
        return !e2(t3, n2);
      });
    }, arraySome: function(t2, e2) {
      if (0 === t2.length)
        return false;
      for (var n2 = 0; n2 < t2.length; n2++)
        if (e2(t2[n2], n2, t2))
          return true;
      return false;
    }, hashToArray: function(t2) {
      var e2 = [];
      for (var n2 in t2)
        t2.hasOwnProperty(n2) && e2.push(t2[n2]);
      return e2;
    }, sortArrayOfHash: function(t2, e2, n2) {
      var i2 = function(t3, e3) {
        return t3 < e3;
      };
      t2.sort(function(t3, r2) {
        return t3[e2] === r2[e2] ? 0 : n2 ? i2(t3[e2], r2[e2]) : i2(r2[e2], t3[e2]);
      });
    }, throttle: function(t2, e2) {
      var n2 = false;
      return function() {
        n2 || (t2.apply(null, arguments), n2 = true, setTimeout(function() {
          n2 = false;
        }, e2));
      };
    }, isArray: function(t2) {
      return Array.isArray ? Array.isArray(t2) : t2 && void 0 !== t2.length && t2.pop && t2.push;
    }, isDate: r, isValidDate: function(t2) {
      return r(t2) && !isNaN(t2.getTime());
    }, isStringObject: function(t2) {
      return t2 && "object" === n(t2) && "function String() { [native code] }" === Function.prototype.toString.call(t2.constructor);
    }, isNumberObject: function(t2) {
      return t2 && "object" === n(t2) && "function Number() { [native code] }" === Function.prototype.toString.call(t2.constructor);
    }, isBooleanObject: function(t2) {
      return t2 && "object" === n(t2) && "function Boolean() { [native code] }" === Function.prototype.toString.call(t2.constructor);
    }, delay: function(t2, e2) {
      var n2, i2 = function i3() {
        i3.$cancelTimeout(), i3.$pending = true;
        var r2 = Array.prototype.slice.call(arguments);
        n2 = setTimeout(function() {
          t2.apply(this, r2), i3.$pending = false;
        }, e2);
      };
      return i2.$pending = false, i2.$cancelTimeout = function() {
        clearTimeout(n2), i2.$pending = false;
      }, i2.$execute = function() {
        var e3 = Array.prototype.slice.call(arguments);
        t2.apply(this, e3), i2.$cancelTimeout();
      }, i2;
    }, objectKeys: function(t2) {
      if (Object.keys)
        return Object.keys(t2);
      var e2, n2 = [];
      for (e2 in t2)
        Object.prototype.hasOwnProperty.call(t2, e2) && n2.push(e2);
      return n2;
    }, isEventable: function(t2) {
      return t2.attachEvent && t2.detachEvent;
    }, replaceValidZeroId: function(t2, e2) {
      return o(t2) && !o(e2) && (t2 = "0"), t2;
    }, checkZeroId: o, findBinary: function(t2, e2) {
      for (var n2, i2, r2, a2 = 0, o2 = t2.length - 1; a2 <= o2; )
        if (i2 = +t2[n2 = Math.floor((a2 + o2) / 2)], r2 = +t2[n2 - 1], i2 < e2)
          a2 = n2 + 1;
        else {
          if (!(i2 > e2)) {
            for (; +t2[n2] == +t2[n2 + 1]; )
              n2++;
            return n2;
          }
          if (!isNaN(r2) && r2 < e2)
            return n2 - 1;
          o2 = n2 - 1;
        }
      return t2.length - 1;
    } };
  }, function(t, e) {
    t.exports = function(t2, e2) {
      for (var n in e2)
        e2.hasOwnProperty(n) && (t2[n] = e2[n]);
      function i() {
        this.constructor = t2;
      }
      t2.prototype = null === e2 ? Object.create(e2) : (i.prototype = e2.prototype, new i());
    };
  }, function(t, e) {
    var n = function() {
      this._silent_mode = false, this.listeners = {};
    };
    n.prototype = { _silentStart: function() {
      this._silent_mode = true;
    }, _silentEnd: function() {
      this._silent_mode = false;
    } };
    var i = function(t2) {
      var e2 = {}, n2 = 0, i2 = function() {
        var n3 = true;
        for (var i3 in e2) {
          var r = e2[i3].apply(t2, arguments);
          n3 = n3 && r;
        }
        return n3;
      };
      return i2.addEvent = function(t3, r) {
        if ("function" == typeof t3) {
          var a;
          if (r && r.id ? a = r.id : (a = n2, n2++), r && r.once) {
            var o = t3;
            t3 = function() {
              o(), i2.removeEvent(a);
            };
          }
          return e2[a] = t3, a;
        }
        return false;
      }, i2.removeEvent = function(t3) {
        delete e2[t3];
      }, i2.clear = function() {
        e2 = {};
      }, i2;
    };
    t.exports = function(t2) {
      var e2 = new n();
      t2.attachEvent = function(t3, n2, r) {
        t3 = "ev_" + t3.toLowerCase(), e2.listeners[t3] || (e2.listeners[t3] = i(this)), r && r.thisObject && (n2 = n2.bind(r.thisObject));
        var a = t3 + ":" + e2.listeners[t3].addEvent(n2, r);
        return r && r.id && (a = r.id), a;
      }, t2.attachAll = function(t3) {
        this.attachEvent("listen_all", t3);
      }, t2.callEvent = function(t3, n2) {
        if (e2._silent_mode)
          return true;
        var i2 = "ev_" + t3.toLowerCase(), r = e2.listeners;
        return r.ev_listen_all && r.ev_listen_all.apply(this, [t3].concat(n2)), !r[i2] || r[i2].apply(this, n2);
      }, t2.checkEvent = function(t3) {
        return !!e2.listeners["ev_" + t3.toLowerCase()];
      }, t2.detachEvent = function(t3) {
        if (t3) {
          var n2 = e2.listeners;
          for (var i2 in n2)
            n2[i2].removeEvent(t3);
          var r = t3.split(":");
          if (n2 = e2.listeners, 2 === r.length) {
            var a = r[0], o = r[1];
            n2[a] && n2[a].removeEvent(o);
          }
        }
      }, t2.detachAllEvents = function() {
        for (var t3 in e2.listeners)
          e2.listeners[t3].clear();
      };
    };
  }, function(t, e) {
    function n() {
      console.log("Method is not implemented.");
    }
    function i() {
    }
    i.prototype.render = n, i.prototype.set_value = n, i.prototype.get_value = n, i.prototype.focus = n, t.exports = function(t2) {
      return i;
    };
  }, function(t, e) {
    t.exports = function(t2, e2, n, i, r) {
      var a = e2.getItemIndexByTopPosition(r.y) || 0, o = e2.getItemIndexByTopPosition(r.y_end) || i.count();
      return { start: Math.max(0, a - 1), end: Math.min(i.count(), o + 1) };
    };
  }, function(t, e) {
    var n = "undefined" != typeof window, i = { isIE: n && (navigator.userAgent.indexOf("MSIE") >= 0 || navigator.userAgent.indexOf("Trident") >= 0), isIE6: n && !XMLHttpRequest && navigator.userAgent.indexOf("MSIE") >= 0, isIE7: n && navigator.userAgent.indexOf("MSIE 7.0") >= 0 && navigator.userAgent.indexOf("Trident") < 0, isIE8: n && navigator.userAgent.indexOf("MSIE 8.0") >= 0 && navigator.userAgent.indexOf("Trident") >= 0, isOpera: n && navigator.userAgent.indexOf("Opera") >= 0, isChrome: n && navigator.userAgent.indexOf("Chrome") >= 0, isKHTML: n && (navigator.userAgent.indexOf("Safari") >= 0 || navigator.userAgent.indexOf("Konqueror") >= 0), isFF: n && navigator.userAgent.indexOf("Firefox") >= 0, isIPad: n && navigator.userAgent.search(/iPad/gi) >= 0, isEdge: n && -1 != navigator.userAgent.indexOf("Edge"), isNode: !n || "undefined" == typeof navigator };
    t.exports = i;
  }, function(t, e) {
    t.exports = function(t2) {
      var e2 = function() {
      };
      return e2.prototype = { show: function(t3, e3, n, i) {
      }, hide: function() {
      }, set_value: function(t3, e3, n, i) {
        this.get_input(i).value = t3;
      }, get_value: function(t3, e3, n) {
        return this.get_input(n).value || "";
      }, is_changed: function(t3, e3, n, i) {
        var r = this.get_value(e3, n, i);
        return r && t3 && r.valueOf && t3.valueOf ? r.valueOf() != t3.valueOf() : r != t3;
      }, is_valid: function(t3, e3, n, i) {
        return true;
      }, save: function(t3, e3, n) {
      }, get_input: function(t3) {
        return t3.querySelector("input");
      }, focus: function(t3) {
        var e3 = this.get_input(t3);
        e3 && (e3.focus && e3.focus(), e3.select && e3.select());
      } }, e2;
    };
  }, function(t, e, n) {
    var i = n(0), r = n(4), a = n(1), o = function() {
      function t2(t3, e2, n2, o2) {
        t3 && (this.$container = a.toNode(t3), this.$parent = t3), this.$config = i.mixin(e2, { headerHeight: 33 }), this.$gantt = o2, this.$domEvents = o2._createDomEventScope(), this.$id = e2.id || "c" + i.uid(), this.$name = "cell", this.$factory = n2, r(this);
      }
      return t2.prototype.destructor = function() {
        this.$parent = this.$container = this.$view = null, this.$gantt.$services.getService("mouseEvents").detach("click", "gantt_header_arrow", this._headerClickHandler), this.$domEvents.detachAll(), this.callEvent("onDestroy", []), this.detachAllEvents();
      }, t2.prototype.cell = function(t3) {
        return null;
      }, t2.prototype.scrollTo = function(t3, e2) {
        var n2 = this.$view;
        this.$config.html && (n2 = this.$view.firstChild), 1 * t3 == t3 && (n2.scrollLeft = t3), 1 * e2 == e2 && (n2.scrollTop = e2);
      }, t2.prototype.clear = function() {
        this.getNode().innerHTML = "", this.getNode().className = "gantt_layout_content", this.getNode().style.padding = "0";
      }, t2.prototype.resize = function(t3) {
        if (this.$parent)
          return this.$parent.resize(t3);
        false === t3 && (this.$preResize = true);
        var e2 = this.$container, n2 = e2.offsetWidth, i2 = e2.offsetHeight, r2 = this.getSize();
        e2 === document.body && (n2 = document.body.offsetWidth, i2 = document.body.offsetHeight), n2 < r2.minWidth && (n2 = r2.minWidth), n2 > r2.maxWidth && (n2 = r2.maxWidth), i2 < r2.minHeight && (i2 = r2.minHeight), i2 > r2.maxHeight && (i2 = r2.maxHeight), this.setSize(n2, i2), this.$preResize, this.$preResize = false;
      }, t2.prototype.hide = function() {
        this._hide(true), this.resize();
      }, t2.prototype.show = function(t3) {
        this._hide(false), t3 && this.$parent && this.$parent.show(), this.resize();
      }, t2.prototype._hide = function(t3) {
        if (true === t3 && this.$view.parentNode)
          this.$view.parentNode.removeChild(this.$view);
        else if (false === t3 && !this.$view.parentNode) {
          var e2 = this.$parent.cellIndex(this.$id);
          this.$parent.moveView(this, e2);
        }
        this.$config.hidden = t3;
      }, t2.prototype.$toHTML = function(t3, e2) {
        void 0 === t3 && (t3 = ""), e2 = [e2 || "", this.$config.css || ""].join(" ");
        var n2 = this.$config, i2 = "";
        n2.raw ? t3 = "string" == typeof n2.raw ? n2.raw : "" : (t3 || (t3 = "<div class='gantt_layout_content' " + (e2 ? " class='" + e2 + "' " : "") + " >" + (n2.html || "") + "</div>"), n2.header && (i2 = "<div class='gantt_layout_header'>" + (n2.canCollapse ? "<div class='gantt_layout_header_arrow'></div>" : "") + "<div class='gantt_layout_header_content'>" + n2.header + "</div></div>"));
        return "<div class='gantt_layout_cell " + e2 + "' data-cell-id='" + this.$id + "'>" + i2 + t3 + "</div>";
      }, t2.prototype.$fill = function(t3, e2) {
        this.$view = t3, this.$parent = e2, this.init();
      }, t2.prototype.getNode = function() {
        return this.$view.querySelector("gantt_layout_cell") || this.$view;
      }, t2.prototype.init = function() {
        var t3 = this;
        this._headerClickHandler = function(e2) {
          a.locateAttribute(e2, "data-cell-id") == t3.$id && t3.toggle();
        }, this.$gantt.$services.getService("mouseEvents").delegate("click", "gantt_header_arrow", this._headerClickHandler), this.callEvent("onReady", []);
      }, t2.prototype.toggle = function() {
        this.$config.collapsed = !this.$config.collapsed, this.resize();
      }, t2.prototype.getSize = function() {
        var t3 = { height: this.$config.height || 0, width: this.$config.width || 0, gravity: this.$config.gravity || 1, minHeight: this.$config.minHeight || 0, minWidth: this.$config.minWidth || 0, maxHeight: this.$config.maxHeight || 1e11, maxWidth: this.$config.maxWidth || 1e11 };
        if (this.$config.collapsed) {
          var e2 = "x" === this.$config.mode;
          t3[e2 ? "width" : "height"] = t3[e2 ? "maxWidth" : "maxHeight"] = this.$config.headerHeight;
        }
        return t3;
      }, t2.prototype.getContentSize = function() {
        var t3 = this.$lastSize.contentX;
        t3 !== 1 * t3 && (t3 = this.$lastSize.width);
        var e2 = this.$lastSize.contentY;
        return e2 !== 1 * e2 && (e2 = this.$lastSize.height), { width: t3, height: e2 };
      }, t2.prototype._getBorderSizes = function() {
        var t3 = { top: 0, right: 0, bottom: 0, left: 0, horizontal: 0, vertical: 0 };
        return this._currentBorders && (this._currentBorders[this._borders.left] && (t3.left = 1, t3.horizontal++), this._currentBorders[this._borders.right] && (t3.right = 1, t3.horizontal++), this._currentBorders[this._borders.top] && (t3.top = 1, t3.vertical++), this._currentBorders[this._borders.bottom] && (t3.bottom = 1, t3.vertical++)), t3;
      }, t2.prototype.setSize = function(t3, e2) {
        this.$view.style.width = t3 + "px", this.$view.style.height = e2 + "px";
        var n2 = this._getBorderSizes(), i2 = e2 - n2.vertical, r2 = t3 - n2.horizontal;
        this.$lastSize = { x: t3, y: e2, contentX: r2, contentY: i2 }, this.$config.header ? this._sizeHeader() : this._sizeContent();
      }, t2.prototype._borders = { left: "gantt_layout_cell_border_left", right: "gantt_layout_cell_border_right", top: "gantt_layout_cell_border_top", bottom: "gantt_layout_cell_border_bottom" }, t2.prototype._setBorders = function(t3, e2) {
        e2 || (e2 = this);
        var n2 = e2.$view;
        for (var i2 in this._borders)
          a.removeClassName(n2, this._borders[i2]);
        "string" == typeof t3 && (t3 = [t3]);
        var r2 = {};
        for (i2 = 0; i2 < t3.length; i2++)
          a.addClassName(n2, t3[i2]), r2[t3[i2]] = true;
        e2._currentBorders = r2;
      }, t2.prototype._sizeContent = function() {
        var t3 = this.$view.childNodes[0];
        t3 && "gantt_layout_content" == t3.className && (t3.style.height = this.$lastSize.contentY + "px");
      }, t2.prototype._sizeHeader = function() {
        var t3 = this.$lastSize;
        t3.contentY -= this.$config.headerHeight;
        var e2 = this.$view.childNodes[0], n2 = this.$view.childNodes[1], i2 = "x" === this.$config.mode;
        if (this.$config.collapsed)
          if (n2.style.display = "none", i2) {
            e2.className = "gantt_layout_header collapsed_x", e2.style.width = t3.y + "px";
            var r2 = Math.floor(t3.y / 2 - t3.x / 2);
            e2.style.transform = "rotate(90deg) translate(" + r2 + "px, " + r2 + "px)", n2.style.display = "none";
          } else
            e2.className = "gantt_layout_header collapsed_y";
        else
          e2.className = i2 ? "gantt_layout_header" : "gantt_layout_header vertical", e2.style.width = "auto", e2.style.transform = "", n2.style.display = "", n2.style.height = t3.contentY + "px";
        e2.style.height = this.$config.headerHeight + "px";
      }, t2;
    }();
    t.exports = o;
  }, function(t, e, n) {
    var i = n(7);
    t.exports = function(t2) {
      return i.isNode || !t2.$root;
    };
  }, function(t, e) {
    t.exports = function(t2, e2, n, i) {
      if ((i = e2 ? e2.config : i) && i.placeholder_task && n.exists(t2))
        return n.getItem(t2).type === i.types.placeholder;
      return false;
    };
  }, function(t, e, n) {
    (function(e2) {
      var n2;
      n2 = "undefined" != typeof window ? window : e2, t.exports = n2;
    }).call(this, n(14));
  }, function(t, e) {
    t.exports = function(t2) {
      return t2.config.smart_rendering && t2._smart_render;
    };
  }, function(t, e) {
    function n(t2) {
      "@babel/helpers - typeof";
      return (n = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(t3) {
        return typeof t3;
      } : function(t3) {
        return t3 && "function" == typeof Symbol && t3.constructor === Symbol && t3 !== Symbol.prototype ? "symbol" : typeof t3;
      })(t2);
    }
    var i;
    i = function() {
      return this;
    }();
    try {
      i = i || Function("return this")() || (0, eval)("this");
    } catch (t2) {
      "object" === ("undefined" == typeof window ? "undefined" : n(window)) && (i = window);
    }
    t.exports = i;
  }, function(t, e, n) {
    Object.defineProperty(e, "__esModule", { value: true });
    var i = function() {
      function t2() {
        this.link = null, this.task = null, this.start_date = null, this.end_date = null, this.latestStart = null, this.earliestStart = null, this.earliestEnd = null, this.latestEnd = null, this.latestSchedulingStart = null, this.earliestSchedulingStart = null, this.latestSchedulingEnd = null, this.earliestSchedulingEnd = null, this.kind = "asap", this.conflict = false;
      }
      return t2.Create = function(e2) {
        var n2 = new t2();
        if (e2)
          for (var i2 in n2)
            void 0 !== e2[i2] && (n2[i2] = e2[i2]);
        return n2;
      }, t2;
    }();
    e.TaskPlan = i;
  }, function(t, e, n) {
    var i = n(2), r = { getHtmlSelect: function(t2, e2, n2) {
      var r2 = "", o2 = this;
      return t2 = t2 || [], i.forEach(t2, function(t3) {
        var e3 = [{ key: "value", value: t3.key }];
        n2 == t3.key && (e3[e3.length] = { key: "selected", value: "selected" }), t3.attributes && (e3 = e3.concat(t3.attributes)), r2 += o2.getHtmlOption({ innerHTML: t3.label }, e3);
      }), a("select", { innerHTML: r2 }, e2);
    }, getHtmlOption: function(t2, e2) {
      return a("option", t2, e2);
    }, getHtmlButton: function(t2, e2) {
      return a("button", t2, e2);
    }, getHtmlDiv: function(t2, e2) {
      return a("div", t2, e2);
    }, getHtmlLabel: function(t2, e2) {
      return a("label", t2, e2);
    }, getHtmlInput: function(t2) {
      return "<input" + o(t2 || []) + ">";
    } };
    function a(t2, e2, n2) {
      return e2 = e2 || [], "<" + t2 + o(n2 || []) + ">" + (e2.innerHTML || "") + "</" + t2 + ">";
    }
    function o(t2) {
      var e2 = "";
      return i.forEach(t2, function(t3) {
        e2 += " " + t3.key + "='" + t3.value + "'";
      }), e2;
    }
    t.exports = r;
  }, function(t, e, n) {
    var i = n(3), r = n(16);
    t.exports = function(t2) {
      var e2 = n(5)(t2);
      function a() {
        return e2.apply(this, arguments) || this;
      }
      return i(a, e2), a.prototype.render = function(t3) {
        var e3 = "<div class='gantt_cal_ltext' style='height:" + ((t3.height || "23") + "px") + ";'>";
        return e3 += r.getHtmlSelect(t3.options, [{ key: "style", value: "width:100%;" }]), e3 += "</div>";
      }, a.prototype.set_value = function(t3, e3, n2, i2) {
        var r2 = t3.firstChild;
        !r2._dhx_onchange && i2.onchange && (r2.onchange = i2.onchange, r2._dhx_onchange = true), void 0 === e3 && (e3 = (r2.options[0] || {}).value), r2.value = e3 || "";
      }, a.prototype.get_value = function(t3) {
        return t3.firstChild.value;
      }, a.prototype.focus = function(e3) {
        var n2 = e3.firstChild;
        t2._focus(n2, true);
      }, a;
    };
  }, function(t, e, n) {
    var i = n(0);
    t.exports = { createDropTargetObject: function(t2) {
      var e2 = { targetParent: null, targetIndex: 0, targetId: null, child: false, nextSibling: false, prevSibling: false };
      return t2 && i.mixin(e2, t2, true), e2;
    }, nextSiblingTarget: function(t2, e2, n2) {
      var i2 = this.createDropTargetObject();
      return i2.targetId = e2, i2.nextSibling = true, i2.targetParent = n2.getParent(i2.targetId), i2.targetIndex = n2.getBranchIndex(i2.targetId), (n2.getParent(t2) != i2.targetParent || i2.targetIndex < n2.getBranchIndex(t2)) && (i2.targetIndex += 1), i2;
    }, prevSiblingTarget: function(t2, e2, n2) {
      var i2 = this.createDropTargetObject();
      return i2.targetId = e2, i2.prevSibling = true, i2.targetParent = n2.getParent(i2.targetId), i2.targetIndex = n2.getBranchIndex(i2.targetId), n2.getParent(t2) == i2.targetParent && i2.targetIndex > n2.getBranchIndex(t2) && (i2.targetIndex -= 1), i2;
    }, firstChildTarget: function(t2, e2, n2) {
      var i2 = this.createDropTargetObject();
      return i2.targetId = e2, i2.targetParent = i2.targetId, i2.targetIndex = 0, i2.child = true, i2;
    }, lastChildTarget: function(t2, e2, n2) {
      var i2 = n2.getChildren(e2), r = this.createDropTargetObject();
      return r.targetId = i2[i2.length - 1], r.targetParent = e2, r.targetIndex = i2.length, r.nextSibling = true, r;
    } };
  }, function(t, e, n) {
    var i = n(13);
    t.exports = function(t2, e2, n2, r) {
      var a = e2.width[t2];
      if (a <= 0)
        return false;
      if (!r.config.smart_rendering || i(r))
        return true;
      var o = e2.left[t2] - a, s = e2.left[t2] + a;
      return o <= n2.x_end && s >= n2.x;
    };
  }, function(t, e) {
    t.exports = function(t2, e2) {
      var n = 0, i = t2.left.length - 1;
      if (e2)
        for (var r = 0; r < t2.left.length; r++) {
          var a = t2.left[r];
          if (a < e2.x && (n = r), a > e2.x_end) {
            i = r;
            break;
          }
        }
      return { start: n, end: i };
    };
  }, function(t, e) {
    t.exports = function(t2, e2, n) {
      return { top: e2.getItemTop(t2.id), height: e2.getItemHeight(t2.id), left: 0, right: 1 / 0 };
    };
  }, function(t, e) {
    t.exports = function(t2) {
      function e2(e3, a, o) {
        if (!t2._isAllowedUnscheduledTask(e3) && t2._isTaskInTimelineLimits(e3)) {
          var s = a.getItemPosition(e3), l = o, c = a.$getTemplates(), u = t2.getTaskType(e3.type), d = a.getBarHeight(e3.id, u == l.types.milestone), h2 = 0;
          u == l.types.milestone && (h2 = (d - s.height) / 2);
          var f = Math.floor((a.getItemHeight(e3.id) - d) / 2);
          u == l.types.milestone && (s.left -= Math.round(d / 2), s.width = d);
          var _2 = document.createElement("div"), g = Math.round(s.width);
          a.$config.item_attribute && (_2.setAttribute(a.$config.item_attribute, e3.id), _2.setAttribute(a.$config.bind + "_id", e3.id)), l.show_progress && u != l.types.milestone && function(e4, n2, i2, r2, a2) {
            var o2 = 1 * e4.progress || 0;
            i2 = Math.max(i2 - 2, 0);
            var s2 = document.createElement("div"), l2 = Math.round(i2 * o2);
            l2 = Math.min(i2, l2), e4.progressColor && (s2.style.backgroundColor = e4.progressColor, s2.style.opacity = 1), s2.style.width = l2 + "px", s2.className = "gantt_task_progress", s2.innerHTML = a2.progress_text(e4.start_date, e4.end_date, e4), r2.rtl && (s2.style.position = "absolute", s2.style.right = "0px");
            var c2 = document.createElement("div");
            if (c2.className = "gantt_task_progress_wrapper", c2.appendChild(s2), n2.appendChild(c2), t2.config.drag_progress && !t2.isReadonly(e4)) {
              var u2 = document.createElement("div"), d2 = l2;
              r2.rtl && (d2 = i2 - l2), u2.style.left = d2 + "px", u2.className = "gantt_task_progress_drag", s2.appendChild(u2), n2.appendChild(u2);
            }
          }(e3, _2, g, l, c);
          var p = function(e4, n2, i2) {
            var r2 = document.createElement("div");
            return t2.getTaskType(e4.type) != t2.config.types.milestone ? r2.innerHTML = i2.task_text(e4.start_date, e4.end_date, e4) : t2.getTaskType(e4.type) == t2.config.types.milestone && n2 && (r2.style.height = r2.style.width = n2 + "px"), r2.className = "gantt_task_content", r2;
          }(e3, g, c);
          e3.textColor && (p.style.color = e3.textColor), _2.appendChild(p);
          var v2 = function(e4, n2, i2, r2) {
            var a2 = r2.$getConfig(), o2 = [e4];
            n2 && o2.push(n2);
            var s2 = t2.getState(), l2 = t2.getTask(i2);
            if (t2.getTaskType(l2.type) == a2.types.milestone ? o2.push("gantt_milestone") : t2.getTaskType(l2.type) == a2.types.project && o2.push("gantt_project"), o2.push("gantt_bar_" + t2.getTaskType(l2.type)), t2.isSummaryTask(l2) && o2.push("gantt_dependent_task"), t2.isSplitTask(l2) && (a2.open_split_tasks && !l2.$open || !a2.open_split_tasks) && o2.push("gantt_split_parent"), a2.select_task && t2.isSelectedTask(i2) && o2.push("gantt_selected"), i2 == s2.drag_id && (o2.push("gantt_drag_" + s2.drag_mode), s2.touch_drag && o2.push("gantt_touch_" + s2.drag_mode)), s2.link_source_id == i2 && o2.push("gantt_link_source"), s2.link_target_id == i2 && o2.push("gantt_link_target"), a2.highlight_critical_path && t2.isCriticalTask && t2.isCriticalTask(l2) && o2.push("gantt_critical_task"), s2.link_landing_area && s2.link_target_id && s2.link_source_id && s2.link_target_id != s2.link_source_id && (s2.link_target_id == i2 || s2.link_source_id == i2)) {
              var c2 = s2.link_source_id, u2 = s2.link_from_start, d2 = s2.link_to_start, h3 = t2.isLinkAllowed(c2, i2, u2, d2), f2 = "";
              f2 = h3 ? d2 ? "link_start_allow" : "link_finish_allow" : d2 ? "link_start_deny" : "link_finish_deny", o2.push(f2);
            }
            return o2.join(" ");
          }("gantt_task_line", c.task_class(e3.start_date, e3.end_date, e3), e3.id, a);
          (e3.color || e3.progressColor || e3.textColor) && (v2 += " gantt_task_inline_color"), s.width < 20 && (v2 += " gantt_thin_task"), _2.className = v2;
          var m = ["left:" + s.left + "px", "top:" + (f + s.top) + "px", "height:" + (u == l.types.milestone ? s.height : d) + "px", "line-height:" + Math.max(d < 30 ? d - 2 : d, 0) + "px", "width:" + g + "px"];
          e3.color && m.push("background-color:" + e3.color), e3.textColor && m.push("color:" + e3.textColor), _2.style.cssText = m.join(";");
          var y = function(t3, e4, r2, a2) {
            var o2 = "gantt_left " + i(!e4.rtl, t3), s2 = null;
            return a2 && (s2 = { type: "marginRight", value: a2 }), n(t3, r2.leftside_text, o2, s2);
          }(e3, l, c, h2);
          y && _2.appendChild(y), (y = function(t3, e4, r2, a2) {
            var o2 = "gantt_right " + i(!!e4.rtl, t3), s2 = null;
            return a2 && (s2 = { type: "marginLeft", value: a2 }), n(t3, r2.rightside_text, o2, s2);
          }(e3, l, c, h2)) && _2.appendChild(y), t2._waiAria.setTaskBarAttr(e3, _2);
          var k2 = t2.getState();
          return t2.isReadonly(e3) || (l.drag_resize && !t2.isSummaryTask(e3) && u != l.types.milestone && r(_2, "gantt_task_drag", e3, function(t3) {
            var e4 = document.createElement("div");
            return e4.className = t3, e4;
          }, l), l.drag_links && l.show_links && r(_2, "gantt_link_control", e3, function(t3) {
            var e4 = document.createElement("div");
            e4.className = t3, e4.style.cssText = ["height:" + d + "px", "line-height:" + d + "px"].join(";");
            var n2 = document.createElement("div");
            n2.className = "gantt_link_point";
            var i2 = false;
            return k2.link_source_id && l.touch && (i2 = true), n2.style.display = i2 ? "block" : "", e4.appendChild(n2), e4;
          }, l, h2)), _2;
        }
      }
      function n(t3, e3, n2, i2) {
        if (!e3)
          return null;
        var r2 = e3(t3.start_date, t3.end_date, t3);
        if (!r2)
          return null;
        var a = document.createElement("div");
        return a.className = "gantt_side_content " + n2, a.innerHTML = r2, i2 && (a.style[i2.type] = Math.abs(i2.value) + "px"), a;
      }
      function i(e3, n2) {
        var i2 = function(e4) {
          return e4 ? { $source: [t2.config.links.start_to_start], $target: [t2.config.links.start_to_start, t2.config.links.finish_to_start] } : { $source: [t2.config.links.finish_to_start, t2.config.links.finish_to_finish], $target: [t2.config.links.finish_to_finish] };
        }(e3);
        for (var r2 in i2)
          for (var a = n2[r2], o = 0; o < a.length; o++)
            for (var s = t2.getLink(a[o]), l = 0; l < i2[r2].length; l++)
              if (s.type == i2[r2][l])
                return "gantt_link_crossing";
        return "";
      }
      function r(e3, n2, i2, r2, a, o) {
        var s, l = t2.getState();
        +i2.start_date >= +l.min_date && ((s = r2([n2, a.rtl ? "task_right" : "task_left", "task_start_date"].join(" "))).setAttribute("data-bind-property", "start_date"), o && (s.style.marginLeft = o + "px"), e3.appendChild(s)), +i2.end_date <= +l.max_date && ((s = r2([n2, a.rtl ? "task_left" : "task_right", "task_end_date"].join(" "))).setAttribute("data-bind-property", "end_date"), o && (s.style.marginRight = o + "px"), e3.appendChild(s));
      }
      return function(n2, i2, r2) {
        var a = (r2 = i2.$getConfig()).type_renderers[t2.getTaskType(n2.type)], o = e2;
        return a ? a.call(t2, n2, function(e3) {
          return o.call(t2, e3, i2, r2);
        }, i2) : o.call(t2, n2, i2, r2);
      };
    };
  }, function(t, e) {
    t.exports = function(t2, e2, n, i, r) {
      if (!t2.start_date || !t2.end_date)
        return null;
      var a = n.getItemTop(t2.id), o = n.getItemHeight(t2.id);
      if (a > e2.y_end || a + o < e2.y)
        return false;
      var s = n.posFromDate(t2.start_date), l = n.posFromDate(t2.end_date), c = Math.min(s, l) - 200, u = Math.max(s, l) + 200;
      return !(c > e2.x_end || u < e2.x);
    };
  }, function(t, e, n) {
    var i = n(2);
    function r(t2) {
      if (t2._delayRender && t2._delayRender.$cancelTimeout(), t2.$gantt) {
        var e2 = t2.$gantt.$data.tasksStore, n2 = t2.$config.rowStore, i2 = "_attached_" + n2.$config.name;
        t2[i2] && (e2.detachEvent(t2[i2]), t2[i2] = null), n2.$attachedResourceViewHandler && (n2.detachEvent(n2.$attachedResourceViewHandler), n2.$attachedResourceViewHandler = null, e2.detachEvent(n2.$attachedTaskStoreHandler), n2.$attachedTaskStoreHandler = null);
      }
    }
    t.exports = function(t2) {
      var e2 = t2.prototype.init, n2 = t2.prototype.destructor;
      return { init: function() {
        e2.apply(this, arguments), this._linkToTaskStore();
      }, destructor: function() {
        r(this), n2.apply(this, arguments);
      }, _linkToTaskStore: function() {
        if (this.$config.rowStore && this.$gantt.$data.tasksStore) {
          var t3 = this.$gantt.$data.tasksStore, e3 = this.$config.rowStore;
          r(this);
          var n3 = this, a = i.delay(function() {
            n3.$gantt.getState().lightbox ? a() : n3.$config.rowStore.refresh();
          }, 300);
          this._delayRender = a;
          var o = "_attached_" + e3.$config.name;
          n3[o] || (n3[o] = t3.attachEvent("onStoreUpdated", function() {
            return a.$pending || a(), true;
          })), this.$gantt.attachEvent("onDestroy", function() {
            return r(n3), true;
          }), e3.$attachedResourceViewHandler || (e3.$attachedResourceViewHandler = e3.attachEvent("onBeforeFilter", function() {
            return !n3.$gantt.getState().lightbox && (a.$pending && a.$cancelTimeout(), n3._updateNestedTasks(), true);
          }), e3.$attachedTaskStoreHandler = t3.attachEvent("onAfterDelete", function() {
            e3._mark_recompute = true;
          }));
        }
      }, _updateNestedTasks: function() {
        var t3 = this.$gantt, e3 = t3.getDatastore(t3.config.resource_store);
        e3.$config.fetchTasks && e3.silent(function() {
          var n3 = [], i2 = {}, r2 = {};
          for (var a in e3.eachItem(function(a2) {
            if ("task" != a2.$role) {
              var o = {};
              t3.getResourceAssignments(a2.id).forEach(function(r3) {
                if (!o[r3.task_id]) {
                  o[r3.task_id] = true;
                  var s = t3.getTask(r3.task_id), l = Object.create(s);
                  l.id = s.id + "_" + a2.id, l.$task_id = s.id, l.$resource_id = a2.id, l[e3.$parentProperty] = a2.id, l.$role = "task", n3.push(l), i2[l.id] = true;
                }
              });
            } else
              r2[a2.id] = true;
          }), r2)
            i2[a] || e3.removeItem(a);
          n3.length && e3.parse(n3);
        });
      } };
    };
  }, function(t, e) {
    t.exports = function(t2, e2, n) {
      return { top: e2.getItemTop(t2.id), height: e2.getItemHeight(t2.id), left: 0, right: 1 / 0 };
    };
  }, function(t, e) {
    t.exports = function(t2) {
      var e2 = [];
      return { delegate: function(n, i, r, a) {
        e2.push([n, i, r, a]), t2.$services.getService("mouseEvents").delegate(n, i, r, a);
      }, destructor: function() {
        for (var n = t2.$services.getService("mouseEvents"), i = 0; i < e2.length; i++) {
          var r = e2[i];
          n.detach(r[0], r[1], r[2], r[3]);
        }
        e2 = [];
      } };
    };
  }, function(t, e, n) {
    var i = n(1), r = n(0), a = n(4), o = n(196), s = n(38), l = n(194), c = n(193).default, u = function(t2, e2, n2, i2) {
      this.$config = r.mixin({}, e2 || {}), this.$gantt = i2, this.$parent = t2, a(this), this.$state = {}, r.mixin(this, s(this));
    };
    u.prototype = { init: function(t2) {
      var e2 = this.$gantt, i2 = e2._waiAria.gridAttrString(), r2 = e2._waiAria.gridDataAttrString(), a2 = this.$getConfig(), s2 = a2.reorder_grid_columns || false;
      void 0 !== this.$config.reorder_grid_columns && (s2 = this.$config.reorder_grid_columns), t2.innerHTML = "<div class='gantt_grid' style='height:inherit;width:inherit;' " + i2 + "></div>", this.$grid = t2.childNodes[0], this.$grid.innerHTML = "<div class='gantt_grid_scale' " + e2._waiAria.gridScaleRowAttrString() + "></div><div class='gantt_grid_data' " + r2 + "></div>", this.$grid_scale = this.$grid.childNodes[0], this.$grid_data = this.$grid.childNodes[1];
      var u2 = a2[this.$config.bind + "_attribute"];
      if (!u2 && this.$config.bind && (u2 = "data-" + this.$config.bind + "-id"), this.$config.item_attribute = u2 || null, !this.$config.layers) {
        var d = this._createLayerConfig();
        this.$config.layers = d;
      }
      var h2 = o(e2, this);
      h2.init(), this._renderHeaderResizers = h2.doOnRender, this._mouseDelegates = n(26)(e2), l(e2, this).init(), this._addLayers(this.$gantt), this._initEvents(), s2 && (this._columnDND = new c(e2, this), this._columnDND.init()), this.callEvent("onReady", []);
    }, _validateColumnWidth: function(t2, e2) {
      var n2 = t2[e2];
      if (n2 && "*" != n2) {
        var i2 = this.$gantt, r2 = 1 * n2;
        isNaN(r2) ? i2.assert(false, "Wrong " + e2 + " value of column " + t2.name) : t2[e2] = r2;
      }
    }, setSize: function(t2, e2) {
      this.$config.width = this.$state.width = t2, this.$config.height = this.$state.height = e2;
      for (var n2, i2 = this.getGridColumns(), r2 = 0, a2 = (u2 = this.$getConfig()).grid_elastic_columns, o2 = 0, s2 = i2.length; o2 < s2; o2++)
        this._validateColumnWidth(i2[o2], "min_width"), this._validateColumnWidth(i2[o2], "max_width"), this._validateColumnWidth(i2[o2], "width"), r2 += 1 * i2[o2].width;
      if (!isNaN(r2) && this.$config.scrollable || (r2 = n2 = this._setColumnsWidth(t2 + 1)), this.$config.scrollable && a2 && !isNaN(r2)) {
        var l2 = 0;
        i2.forEach(function(t3) {
          l2 += t3.min_width || u2.min_grid_column_width;
        });
        var c2 = Math.max(l2, t2);
        r2 = this._setColumnsWidth(c2), n2 = t2;
      }
      this.$config.scrollable ? (this.$grid_scale.style.width = r2 + "px", this.$grid_data.style.width = r2 + "px") : (this.$grid_scale.style.width = "inherit", this.$grid_data.style.width = "inherit"), this.$config.width -= 1;
      var u2 = this.$getConfig();
      n2 !== t2 && (void 0 !== n2 ? (u2.grid_width = n2, this.$config.width = n2 - 1) : isNaN(r2) || (this._setColumnsWidth(r2), u2.grid_width = r2, this.$config.width = r2 - 1));
      var d = Math.max(this.$state.height - u2.scale_height, 0);
      this.$grid_data.style.height = d + "px", this.refresh();
    }, getSize: function() {
      var t2 = this.$getConfig(), e2 = this.$config.rowStore ? this.getTotalHeight() : 0, n2 = this._getGridWidth();
      return { x: this.$state.width, y: this.$state.height, contentX: this.isVisible() ? n2 : 0, contentY: this.isVisible() ? t2.scale_height + e2 : 0, scrollHeight: this.isVisible() ? e2 : 0, scrollWidth: this.isVisible() ? n2 : 0 };
    }, _bindStore: function() {
      if (this.$config.bind) {
        var t2 = this.$gantt.getDatastore(this.$config.bind);
        if (this.$config.rowStore = t2, t2 && !t2._gridCacheAttached) {
          var e2 = this;
          t2._gridCacheAttached = t2.attachEvent("onBeforeFilter", function() {
            e2._resetTopPositionHeight();
          });
        }
      }
    }, _unbindStore: function() {
      if (this.$config.bind) {
        var t2 = this.$gantt.getDatastore(this.$config.bind);
        t2 && t2._gridCacheAttached && (t2.detachEvent(t2._gridCacheAttached), t2._gridCacheAttached = false);
      }
    }, refresh: function() {
      this._bindStore(), this._resetTopPositionHeight(), this._resetHeight(), this._initSmartRenderingPlaceholder(), this._calculateGridWidth(), this._renderGridHeader();
    }, getViewPort: function() {
      var t2 = this.$config.scrollLeft || 0, e2 = this.$config.scrollTop || 0, n2 = this.$config.height || 0, i2 = this.$config.width || 0;
      return { y: e2, y_end: e2 + n2, x: t2, x_end: t2 + i2, height: n2, width: i2 };
    }, scrollTo: function(t2, e2) {
      if (this.isVisible()) {
        var n2 = false;
        this.$config.scrollTop = this.$config.scrollTop || 0, this.$config.scrollLeft = this.$config.scrollLeft || 0, 1 * t2 == t2 && (this.$config.scrollLeft = this.$state.scrollLeft = this.$grid.scrollLeft = t2, n2 = true), 1 * e2 == e2 && (this.$config.scrollTop = this.$state.scrollTop = this.$grid_data.scrollTop = e2, n2 = true), n2 && this.callEvent("onScroll", [this.$config.scrollLeft, this.$config.scrollTop]);
      }
    }, getColumnIndex: function(t2, e2) {
      for (var n2 = this.$getConfig().columns, i2 = 0, r2 = 0; r2 < n2.length; r2++)
        if (e2 && n2[r2].hide && i2++, n2[r2].name == t2)
          return r2 - i2;
      return null;
    }, getColumn: function(t2) {
      var e2 = this.getColumnIndex(t2);
      return null === e2 ? null : this.$getConfig().columns[e2];
    }, getGridColumns: function() {
      return this.$getConfig().columns.slice();
    }, isVisible: function() {
      return this.$parent && this.$parent.$config ? !this.$parent.$config.hidden : this.$grid.offsetWidth;
    }, _createLayerConfig: function() {
      var t2 = this.$gantt, e2 = this;
      return [{ renderer: t2.$ui.layers.gridLine(), container: this.$grid_data, filter: [function() {
        return e2.isVisible();
      }] }, { renderer: t2.$ui.layers.gridTaskRowResizer(), container: this.$grid_data, append: true, filter: [function() {
        return t2.config.resize_rows;
      }] }];
    }, _addLayers: function(t2) {
      if (this.$config.bind) {
        this._taskLayers = [];
        var e2 = this, n2 = this.$gantt.$services.getService("layers"), i2 = n2.getDataRender(this.$config.bind);
        i2 || (i2 = n2.createDataRender({ name: this.$config.bind, defaultContainer: function() {
          return e2.$grid_data;
        } }));
        for (var r2 = this.$config.layers, a2 = 0; r2 && a2 < r2.length; a2++) {
          var o2 = r2[a2];
          o2.view = this;
          var s2 = i2.addLayer(o2);
          this._taskLayers.push(s2);
        }
        this._bindStore(), this._initSmartRenderingPlaceholder();
      }
    }, _refreshPlaceholderOnStoreUpdate: function(t2) {
      var e2 = this.$getConfig(), n2 = this.$config.rowStore;
      if (n2 && null === t2 && this.isVisible() && e2.smart_rendering) {
        var i2;
        if (this.$config.scrollY) {
          var r2 = this.$gantt.$ui.getView(this.$config.scrollY);
          r2 && (i2 = r2.getScrollState().scrollSize);
        }
        if (i2 || (i2 = n2 ? this.getTotalHeight() : 0), i2) {
          this.$rowsPlaceholder && this.$rowsPlaceholder.parentNode && this.$rowsPlaceholder.parentNode.removeChild(this.$rowsPlaceholder);
          var a2 = this.$rowsPlaceholder = document.createElement("div");
          a2.style.visibility = "hidden", a2.style.height = i2 + "px", a2.style.width = "1px", this.$grid_data.appendChild(a2);
        }
      }
    }, _initSmartRenderingPlaceholder: function() {
      var t2 = this.$config.rowStore;
      t2 && (this._initSmartRenderingPlaceholder = function() {
      }, this._staticBgHandler = t2.attachEvent("onStoreUpdated", r.bind(this._refreshPlaceholderOnStoreUpdate, this)));
    }, _initEvents: function() {
      var t2 = this.$gantt;
      this._mouseDelegates.delegate("click", "gantt_close", t2.bind(function(t3, e2, n2) {
        var r2 = this.$config.rowStore;
        if (!r2)
          return true;
        var a2 = i.locateAttribute(t3, this.$config.item_attribute);
        return a2 && r2.close(a2.getAttribute(this.$config.item_attribute)), false;
      }, this), this.$grid), this._mouseDelegates.delegate("click", "gantt_open", t2.bind(function(t3, e2, n2) {
        var r2 = this.$config.rowStore;
        if (!r2)
          return true;
        var a2 = i.locateAttribute(t3, this.$config.item_attribute);
        return a2 && r2.open(a2.getAttribute(this.$config.item_attribute)), false;
      }, this), this.$grid);
    }, _clearLayers: function(t2) {
      var e2 = this.$gantt.$services.getService("layers").getDataRender(this.$config.bind);
      if (this._taskLayers)
        for (var n2 = 0; n2 < this._taskLayers.length; n2++)
          e2.removeLayer(this._taskLayers[n2]);
      this._taskLayers = [];
    }, _getColumnWidth: function(t2, e2, n2) {
      var i2 = t2.min_width || e2.min_grid_column_width, r2 = Math.max(n2, i2 || 10);
      return t2.max_width && (r2 = Math.min(r2, t2.max_width)), r2;
    }, _checkGridColumnMinWidthLimits: function(t2, e2) {
      for (var n2 = 0, i2 = t2.length; n2 < i2; n2++) {
        var r2 = 1 * t2[n2].width;
        !t2[n2].min_width && r2 < e2.min_grid_column_width && (t2[n2].min_width = r2);
      }
    }, _getGridWidthLimits: function() {
      for (var t2 = this.$getConfig(), e2 = this.getGridColumns(), n2 = 0, i2 = 0, r2 = 0; r2 < e2.length; r2++)
        n2 += e2[r2].min_width ? e2[r2].min_width : t2.min_grid_column_width, void 0 !== i2 && (i2 = e2[r2].max_width ? i2 + e2[r2].max_width : void 0);
      return this._checkGridColumnMinWidthLimits(e2, t2), [n2, i2];
    }, _setColumnsWidth: function(t2, e2) {
      var n2 = this.$getConfig(), i2 = this.getGridColumns(), r2 = 0, a2 = t2;
      e2 = window.isNaN(e2) ? -1 : e2;
      for (var o2 = 0, s2 = i2.length; o2 < s2; o2++)
        r2 += 1 * i2[o2].width;
      if (window.isNaN(r2)) {
        this._calculateGridWidth(), r2 = 0;
        for (o2 = 0, s2 = i2.length; o2 < s2; o2++)
          r2 += 1 * i2[o2].width;
      }
      var l2 = a2 - r2, c2 = 0;
      for (o2 = 0; o2 < e2 + 1; o2++)
        c2 += i2[o2].width;
      r2 -= c2;
      for (o2 = e2 + 1; o2 < i2.length; o2++) {
        var u2 = i2[o2], d = Math.round(l2 * (u2.width / r2));
        l2 < 0 ? u2.min_width && u2.width + d < u2.min_width ? d = u2.min_width - u2.width : !u2.min_width && n2.min_grid_column_width && u2.width + d < n2.min_grid_column_width && (d = n2.min_grid_column_width - u2.width) : u2.max_width && u2.width + d > u2.max_width && (d = u2.max_width - u2.width), r2 -= u2.width, u2.width += d, l2 -= d;
      }
      for (var h2 = l2 > 0 ? 1 : -1; l2 > 0 && 1 === h2 || l2 < 0 && -1 === h2; ) {
        var f = l2;
        for (o2 = e2 + 1; o2 < i2.length; o2++) {
          var _2;
          if ((_2 = i2[o2].width + h2) == this._getColumnWidth(i2[o2], n2, _2) && (l2 -= h2, i2[o2].width = _2), !l2)
            break;
        }
        if (f == l2)
          break;
      }
      l2 && e2 > -1 && ((_2 = i2[e2].width + l2) == this._getColumnWidth(i2[e2], n2, _2) && (i2[e2].width = _2));
      return this._getColsTotalWidth();
    }, _getColsTotalWidth: function() {
      for (var t2 = this.getGridColumns(), e2 = 0, n2 = 0; n2 < t2.length; n2++) {
        var i2 = parseFloat(t2[n2].width);
        if (window.isNaN(i2))
          return false;
        e2 += i2;
      }
      return e2;
    }, _calculateGridWidth: function() {
      for (var t2 = this.$getConfig(), e2 = this.getGridColumns(), n2 = 0, i2 = [], r2 = [], a2 = 0; a2 < e2.length; a2++) {
        var o2 = parseFloat(e2[a2].width);
        window.isNaN(o2) && (o2 = t2.min_grid_column_width || 10, i2.push(a2)), r2[a2] = o2, n2 += o2;
      }
      var s2 = this._getGridWidth() + 1;
      if (t2.autofit || i2.length) {
        var l2 = s2 - n2;
        if (t2.autofit && !t2.grid_elastic_columns)
          for (a2 = 0; a2 < r2.length; a2++) {
            var c2 = Math.round(l2 / (r2.length - a2));
            r2[a2] += c2, (u2 = this._getColumnWidth(e2[a2], t2, r2[a2])) != r2[a2] && (c2 = u2 - r2[a2], r2[a2] = u2), l2 -= c2;
          }
        else if (i2.length)
          for (a2 = 0; a2 < i2.length; a2++) {
            c2 = Math.round(l2 / (i2.length - a2));
            var u2, d = i2[a2];
            r2[d] += c2, (u2 = this._getColumnWidth(e2[d], t2, r2[d])) != r2[d] && (c2 = u2 - r2[d], r2[d] = u2), l2 -= c2;
          }
        for (a2 = 0; a2 < r2.length; a2++)
          e2[a2].width = r2[a2];
      } else {
        var h2 = s2 != n2;
        this.$config.width = n2 - 1, t2.grid_width = n2, h2 && this.$parent._setContentSize(this.$config.width, null);
      }
    }, _renderGridHeader: function() {
      var t2 = this.$gantt, e2 = this.$getConfig(), n2 = this.$gantt.locale, i2 = this.$gantt.templates, r2 = this.getGridColumns();
      e2.rtl && (r2 = r2.reverse());
      for (var a2 = [], o2 = 0, s2 = n2.labels, l2 = e2.scale_height - 1, c2 = 0; c2 < r2.length; c2++) {
        var u2 = c2 == r2.length - 1, d = r2[c2];
        d.name || (d.name = t2.uid() + "");
        var h2 = 1 * d.width, f = this._getGridWidth();
        u2 && f > o2 + h2 && (d.width = h2 = f - o2), o2 += h2;
        var _2 = t2._sort && d.name == t2._sort.name ? "<div class='gantt_sort gantt_" + t2._sort.direction + "'></div>" : "", g = ["gantt_grid_head_cell", "gantt_grid_head_" + d.name, u2 ? "gantt_last_cell" : "", i2.grid_header_class(d.name, d)].join(" "), p = "width:" + (h2 - (u2 ? 1 : 0)) + "px;", v2 = d.label || s2["column_" + d.name] || s2[d.name];
        v2 = v2 || "";
        var m = "<div class='" + g + "' style='" + p + "' " + t2._waiAria.gridScaleCellAttrString(d, v2) + " data-column-id='" + d.name + "' column_id='" + d.name + "' data-column-name='" + d.name + "' data-column-index='" + c2 + "'>" + v2 + _2 + "</div>";
        a2.push(m);
      }
      this.$grid_scale.style.height = e2.scale_height + "px", this.$grid_scale.style.lineHeight = l2 + "px", this.$grid_scale.innerHTML = a2.join(""), this._renderHeaderResizers && this._renderHeaderResizers();
    }, _getGridWidth: function() {
      return this.$config.width;
    }, destructor: function() {
      this._clearLayers(this.$gantt), this._mouseDelegates && (this._mouseDelegates.destructor(), this._mouseDelegates = null), this._unbindStore(), this.$grid = null, this.$grid_scale = null, this.$grid_data = null, this.$gantt = null, this.$config.rowStore && (this.$config.rowStore.detachEvent(this._staticBgHandler), this.$config.rowStore = null), this.callEvent("onDestroy", []), this.detachAllEvents();
    } }, t.exports = u;
  }, function(t, e, n) {
    Object.defineProperty(e, "__esModule", { value: true }), function(t2) {
      t2.ASAP = "asap", t2.ALAP = "alap", t2.SNET = "snet", t2.SNLT = "snlt", t2.FNET = "fnet", t2.FNLT = "fnlt", t2.MSO = "mso", t2.MFO = "mfo";
    }(e.ConstraintTypes || (e.ConstraintTypes = {}));
  }, function(t, e) {
    t.exports = function(t2) {
      return { getVirtualRoot: function() {
        return t2.mixin(t2.getSubtaskDates(), { id: t2.config.root_id, type: t2.config.types.project, $source: [], $target: [], $virtual: true });
      }, getLinkedTasks: function(e2, n) {
        var i = [e2], r = false;
        t2._isLinksCacheEnabled() || (t2._startLinksCache(), r = true);
        for (var a = [], o = {}, s = {}, l = 0; l < i.length; l++)
          this._getLinkedTasks(i[l], o, n, s);
        for (var l in s)
          a.push(s[l]);
        return r && t2._endLinksCache(), a;
      }, _collectRelations: function(e2, n, i, r) {
        var a, o = t2._getSuccessors(e2, n), s = [];
        i && (s = t2._getPredecessors(e2, n));
        for (var l = [], c = 0; c < o.length; c++)
          r[a = o[c].hashSum] || (r[a] = true, l.push(o[c]));
        for (c = 0; c < s.length; c++)
          r[a = s[c].hashSum] || (r[a] = true, l.push(s[c]));
        return l;
      }, _getLinkedTasks: function(e2, n, i, r) {
        for (var a, o = void 0 === e2 ? t2.config.root_id : e2, s = (n = {}, {}), l = [{ from: o, includePredecessors: i, isChild: false }]; l.length; ) {
          var c = l.pop(), u = c.isChild;
          if (!n[o = c.from]) {
            a = t2.isTaskExists(o) ? t2.getTask(o) : this.getVirtualRoot(), n[o] = true;
            for (var d = this._collectRelations(a, u, i, s), h2 = 0; h2 < d.length; h2++) {
              var f = d[h2];
              r[f.hashSum] = f;
              var _2 = f.sourceParent == f.targetParent;
              n[f.target] || l.push({ from: f.target, includePredecessors: true, isChild: _2 });
            }
            if (t2.hasChild(a.id)) {
              var g = t2.getChildren(a.id);
              for (h2 = 0; h2 < g.length; h2++)
                n[g[h2]] || l.push({ from: g[h2], includePredecessors: true, isChild: true });
            }
          }
        }
        return r;
      } };
    };
  }, , function(t, e, n) {
  }, function(t, e, n) {
    var i = n(2);
    t.exports = function(t2) {
      var e2 = {};
      return t2.$data.tasksStore.attachEvent("onStoreUpdated", function() {
        e2 = {};
      }), function(n2, r, a, o) {
        var s = n2.id + "_" + r + "_" + a.unit + "_" + a.step;
        return e2[s] ? e2[s] : e2[s] = function(e3, n3, r2, a2) {
          var o2, s2 = false, l = {};
          t2.config.process_resource_assignments && n3 === t2.config.resource_property ? (o2 = "task" == e3.$role ? t2.getResourceAssignments(e3.$resource_id, e3.$task_id) : t2.getResourceAssignments(e3.id), s2 = true) : o2 = "task" == e3.$role ? [] : t2.getTaskBy(n3, e3.id);
          for (var c, u, d, h2, f, l = function(e4, n4, r3) {
            for (var a3 = n4.unit, o3 = n4.step, s3 = {}, l2 = {}, c2 = 0; c2 < e4.length; c2++) {
              var u2 = e4[c2], d2 = u2;
              r3 && (d2 = t2.getTask(u2.task_id));
              var h3 = u2.start_date || d2.start_date, f2 = u2.end_date || d2.end_date;
              r3 && (u2.start_date && (h3 = new Date(Math.max(u2.start_date.valueOf(), d2.start_date.valueOf()))), u2.end_date && (f2 = new Date(Math.min(u2.end_date.valueOf(), d2.end_date.valueOf()))));
              var _3 = i.findBinary(n4.trace_x, h3.valueOf()), g2 = new Date(n4.trace_x[_3] || t2.date[a3 + "_start"](new Date(h3))), p2 = t2.config.work_time ? t2.getTaskCalendar(d2) : t2;
              for (l2[p2.id] = {}; g2 < f2; ) {
                var v3 = l2[p2.id], m2 = g2, y = m2.valueOf();
                if (g2 = t2.date.add(g2, o3, a3), false !== v3[y]) {
                  var k2 = p2.isWorkTime({ date: m2, task: d2, unit: a3 });
                  k2 ? (s3[y] || (s3[y] = { tasks: [], assignments: [] }), s3[y].tasks.push(d2), r3 && s3[y].assignments.push(u2)) : v3[y] = false;
                }
              }
            }
            return s3;
          }(o2, r2, s2), _2 = r2.unit, g = r2.step, p = [], v2 = a2.$getConfig(), m = 0; m < r2.trace_x.length; m++)
            c = new Date(r2.trace_x[m]), u = t2.date.add(c, g, _2), f = l[c.valueOf()] || {}, d = f.tasks || [], h2 = f.assignments || [], d.length || v2.resource_render_empty_cells ? p.push({ start_date: c, end_date: u, tasks: d, assignments: h2 }) : p.push(null);
          return p;
        }(n2, r, a, o);
      };
    };
  }, function(t, e, n) {
    var i = n(0), r = n(34), a = n(24), o = n(3), s = function(t2) {
      function e2(e3, n2, i2, r2) {
        var a2 = t2.apply(this, arguments) || this;
        return a2.$config.bindLinks = null, a2;
      }
      return o(e2, t2), i.mixin(e2.prototype, { init: function() {
        void 0 === this.$config.bind && (this.$config.bind = this.$getConfig().resource_store), t2.prototype.init.apply(this, arguments);
      }, _createLayerConfig: function() {
        var t3 = this, e3 = function() {
          return t3.isVisible();
        };
        return { tasks: [{ renderer: this.$gantt.$ui.layers.resourceRow(), container: this.$task_bars, filter: [e3] }, { renderer: this.$gantt.$ui.layers.taskBg(), container: this.$task_bg, filter: [e3] }], links: [] };
      } }, true), i.mixin(e2.prototype, a(e2), true), e2;
    }(r);
    t.exports = s;
  }, function(t, e, n) {
    var i = n(41), r = n(4), a = n(0), o = n(2), s = n(38), l = n(117), c = function(t2, e2, n2, o2) {
      this.$config = a.mixin({}, e2 || {}), this.$scaleHelper = new i(o2), this.$gantt = o2, this._posFromDateCache = {}, this._timelineDragScroll = null, a.mixin(this, s(this)), r(this);
    };
    c.prototype = { init: function(t2) {
      t2.innerHTML += "<div class='gantt_task' style='width:inherit;height:inherit;'></div>", this.$task = t2.childNodes[0], this.$task.innerHTML = "<div class='gantt_task_scale'></div><div class='gantt_data_area'></div>", this.$task_scale = this.$task.childNodes[0], this.$task_data = this.$task.childNodes[1], this.$task_data.innerHTML = "<div class='gantt_task_bg'></div><div class='gantt_links_area'></div><div class='gantt_bars_area'></div>", this.$task_bg = this.$task_data.childNodes[0], this.$task_links = this.$task_data.childNodes[1], this.$task_bars = this.$task_data.childNodes[2], this._tasks = { col_width: 0, width: [], full_width: 0, trace_x: [], rendered: {} };
      var e2 = this.$getConfig(), n2 = e2[this.$config.bind + "_attribute"], i2 = e2[this.$config.bindLinks + "_attribute"];
      !n2 && this.$config.bind && (n2 = "data-" + this.$config.bind + "-id"), !i2 && this.$config.bindLinks && (i2 = "data-" + this.$config.bindLinks + "-id"), this.$config.item_attribute = n2 || null, this.$config.link_attribute = i2 || null;
      var r2 = this._createLayerConfig();
      this.$config.layers || (this.$config.layers = r2.tasks), this.$config.linkLayers || (this.$config.linkLayers = r2.links), this._attachLayers(this.$gantt), this.callEvent("onReady", []), this.$gantt.ext.dragTimeline && (this._timelineDragScroll = this.$gantt.ext.dragTimeline.create(), this._timelineDragScroll.attach(this));
    }, setSize: function(t2, e2) {
      var n2 = this.$getConfig();
      if (1 * t2 === t2 && (this.$config.width = t2), 1 * e2 === e2) {
        this.$config.height = e2;
        var i2 = Math.max(this.$config.height - n2.scale_height);
        this.$task_data.style.height = i2 + "px";
      }
      this.refresh(), this.$task_bg.style.backgroundImage = "", n2.smart_rendering && this.$config.rowStore ? this.$task_bg.style.height = this.getTotalHeight() + "px" : this.$task_bg.style.height = "";
      for (var r2 = this._tasks, a2 = this.$task_data.childNodes, o2 = 0, s2 = a2.length; o2 < s2; o2++) {
        var l2 = a2[o2];
        l2.hasAttribute("data-layer") && l2.style && (l2.style.width = r2.full_width + "px");
      }
    }, isVisible: function() {
      return this.$parent && this.$parent.$config ? !this.$parent.$config.hidden : this.$task.offsetWidth;
    }, getSize: function() {
      var t2 = this.$getConfig(), e2 = this.$config.rowStore ? this.getTotalHeight() : 0, n2 = this.isVisible() ? this._tasks.full_width : 0;
      return { x: this.isVisible() ? this.$config.width : 0, y: this.isVisible() ? this.$config.height : 0, contentX: this.isVisible() ? n2 : 0, contentY: this.isVisible() ? t2.scale_height + e2 : 0, scrollHeight: this.isVisible() ? e2 : 0, scrollWidth: this.isVisible() ? n2 : 0 };
    }, scrollTo: function(t2, e2) {
      if (this.isVisible()) {
        var n2 = false;
        this.$config.scrollTop = this.$config.scrollTop || 0, this.$config.scrollLeft = this.$config.scrollLeft || 0, 1 * e2 === e2 && (this.$config.scrollTop = e2, this.$task_data.scrollTop = this.$config.scrollTop, n2 = true), 1 * t2 === t2 && (this.$task.scrollLeft = t2, this.$config.scrollLeft = this.$task.scrollLeft, this._refreshScales(), n2 = true), n2 && this.callEvent("onScroll", [this.$config.scrollLeft, this.$config.scrollTop]);
      }
    }, _refreshScales: function() {
      if (this.isVisible() && this.$getConfig().smart_scales) {
        var t2 = this.getViewPort(), e2 = this._scales;
        this.$task_scale.innerHTML = this._getScaleChunkHtml(e2, t2.x, t2.x_end);
      }
    }, getViewPort: function() {
      var t2 = this.$config.scrollLeft || 0, e2 = this.$config.scrollTop || 0, n2 = this.$config.height || 0, i2 = this.$config.width || 0;
      return { y: e2, y_end: e2 + n2, x: t2, x_end: t2 + i2, height: n2, width: i2 };
    }, _createLayerConfig: function() {
      var t2 = this, e2 = function() {
        return t2.isVisible();
      };
      return { tasks: [{ expose: true, renderer: this.$gantt.$ui.layers.taskBar(), container: this.$task_bars, filter: [e2, function(t3, e3) {
        return !e3.hide_bar;
      }] }, { renderer: this.$gantt.$ui.layers.taskSplitBar(), filter: [e2], container: this.$task_bars, append: true }, { renderer: this.$gantt.$ui.layers.taskRollupBar(), filter: [e2], container: this.$task_bars, append: true }, { renderer: this.$gantt.$ui.layers.taskBg(), container: this.$task_bg, filter: [e2] }], links: [{ expose: true, renderer: this.$gantt.$ui.layers.link(), container: this.$task_links, filter: [e2] }] };
    }, _attachLayers: function(t2) {
      this._taskLayers = [], this._linkLayers = [];
      var e2 = this, n2 = this.$gantt.$services.getService("layers");
      if (this.$config.bind) {
        this._bindStore();
        var i2 = n2.getDataRender(this.$config.bind);
        i2 || (i2 = n2.createDataRender({ name: this.$config.bind, defaultContainer: function() {
          return e2.$task_data;
        } })), i2.container = function() {
          return e2.$task_data;
        };
        for (var r2 = this.$config.layers, a2 = 0; r2 && a2 < r2.length; a2++) {
          "string" == typeof (c2 = r2[a2]) && (c2 = this.$gantt.$ui.layers[c2]()), ("function" == typeof c2 || c2 && c2.render && c2.update) && (c2 = { renderer: c2 }), c2.view = this;
          var o2 = i2.addLayer(c2);
          this._taskLayers.push(o2), c2.expose && (this._taskRenderer = i2.getLayer(o2));
        }
        this._initStaticBackgroundRender();
      }
      if (this.$config.bindLinks) {
        e2.$config.linkStore = e2.$gantt.getDatastore(e2.$config.bindLinks);
        var s2 = n2.getDataRender(this.$config.bindLinks);
        s2 || (s2 = n2.createDataRender({ name: this.$config.bindLinks, defaultContainer: function() {
          return e2.$task_data;
        } }));
        var l2 = this.$config.linkLayers;
        for (a2 = 0; l2 && a2 < l2.length; a2++) {
          var c2;
          "string" == typeof c2 && (c2 = this.$gantt.$ui.layers[c2]()), (c2 = l2[a2]).view = this;
          var u = s2.addLayer(c2);
          this._taskLayers.push(u), l2[a2].expose && (this._linkRenderer = s2.getLayer(u));
        }
      }
    }, _initStaticBackgroundRender: function() {
      var t2 = this, e2 = l.create(), n2 = t2.$config.rowStore;
      n2 && (this._staticBgHandler = n2.attachEvent("onStoreUpdated", function(n3, i2, r2) {
        if (null === n3 && t2.isVisible()) {
          var a2 = t2.$getConfig();
          if (a2.static_background) {
            var o2 = t2.$gantt.getDatastore(t2.$config.bind), s2 = t2.$task_bg_static;
            s2 || ((s2 = document.createElement("div")).className = "gantt_task_bg", t2.$task_bg_static = s2, t2.$task_bg.nextSibling ? t2.$task_data.insertBefore(s2, t2.$task_bg.nextSibling) : t2.$task_data.appendChild(s2)), o2 && e2.render(s2, a2, t2.getScale(), t2.getTotalHeight(), t2.getItemHeight(i2 ? i2.id : null));
          } else
            a2.static_background && t2.$task_bg_static && t2.$task_bg_static.parentNode && t2.$task_bg_static.parentNode.removeChild(t2.$task_bg_static);
        }
      }), this.attachEvent("onDestroy", function() {
        e2.destroy();
      }), this._initStaticBackgroundRender = function() {
      });
    }, _clearLayers: function(t2) {
      var e2 = this.$gantt.$services.getService("layers"), n2 = e2.getDataRender(this.$config.bind), i2 = e2.getDataRender(this.$config.bindLinks);
      if (this._taskLayers)
        for (var r2 = 0; r2 < this._taskLayers.length; r2++)
          n2.removeLayer(this._taskLayers[r2]);
      if (this._linkLayers)
        for (r2 = 0; r2 < this._linkLayers.length; r2++)
          i2.removeLayer(this._linkLayers[r2]);
      this._linkLayers = [], this._taskLayers = [];
    }, _render_tasks_scales: function() {
      var t2 = this.$getConfig(), e2 = "", n2 = 0, i2 = 0, r2 = this.$gantt.getState();
      if (this.isVisible()) {
        var a2 = this.$scaleHelper, o2 = this._getScales();
        i2 = t2.scale_height;
        var s2 = this.$config.width;
        "x" != t2.autosize && "xy" != t2.autosize || (s2 = Math.max(t2.autosize_min_width, 0));
        var l2 = a2.prepareConfigs(o2, t2.min_column_width, s2, i2 - 1, r2.min_date, r2.max_date, t2.rtl), c2 = this._tasks = l2[l2.length - 1];
        this._scales = l2, this._posFromDateCache = {}, e2 = this._getScaleChunkHtml(l2, 0, this.$config.width), n2 = c2.full_width + "px", i2 += "px";
      }
      this.$task_scale.style.height = i2, this.$task_data.style.width = this.$task_scale.style.width = n2, this.$task_scale.innerHTML = e2;
    }, _getScaleChunkHtml: function(t2, e2, n2) {
      for (var i2 = [], r2 = this.$gantt.templates.scale_row_class, a2 = 0; a2 < t2.length; a2++) {
        var o2 = "gantt_scale_line", s2 = r2(t2[a2]);
        s2 && (o2 += " " + s2), i2.push('<div class="' + o2 + '" style="height:' + t2[a2].height + "px;position:relative;line-height:" + t2[a2].height + 'px">' + this._prepareScaleHtml(t2[a2], e2, n2) + "</div>");
      }
      return i2.join("");
    }, _prepareScaleHtml: function(t2, e2, n2) {
      var i2 = this.$getConfig(), r2 = this.$gantt.templates, a2 = [], s2 = null, l2 = null, c2 = t2.format || t2.template || t2.date;
      "string" == typeof c2 && (c2 = this.$gantt.date.date_to_str(c2));
      var u = 0, d = t2.count;
      !i2.smart_scales || isNaN(e2) || isNaN(n2) || (u = o.findBinary(t2.left, e2), d = o.findBinary(t2.left, n2) + 1), l2 = t2.css || function() {
      }, !t2.css && i2.inherit_scale_class && (l2 = r2.scale_cell_class);
      for (var h2 = u; h2 < d && t2.trace_x[h2]; h2++) {
        s2 = new Date(t2.trace_x[h2]);
        var f = c2.call(this, s2), _2 = t2.width[h2], g = t2.height, p = t2.left[h2], v2 = "", m = "", y = "";
        if (_2) {
          v2 = "width:" + _2 + "px;height:" + g + "px;" + (i2.smart_scales ? "position:absolute;left:" + p + "px" : ""), y = "gantt_scale_cell" + (h2 == t2.count - 1 ? " gantt_last_cell" : ""), (m = l2.call(this, s2)) && (y += " " + m);
          var k2 = "<div class='" + y + "'" + this.$gantt._waiAria.getTimelineCellAttr(f) + " style='" + v2 + "'>" + f + "</div>";
          a2.push(k2);
        }
      }
      return a2.join("");
    }, dateFromPos: function(t2) {
      var e2 = this._tasks;
      if (t2 < 0 || t2 > e2.full_width || !e2.full_width)
        return null;
      var n2 = o.findBinary(this._tasks.left, t2), i2 = this._tasks.left[n2], r2 = e2.width[n2] || e2.col_width, a2 = 0;
      r2 && (a2 = (t2 - i2) / r2, e2.rtl && (a2 = 1 - a2));
      var s2 = 0;
      return a2 && (s2 = this._getColumnDuration(e2, e2.trace_x[n2])), new Date(e2.trace_x[n2].valueOf() + Math.round(a2 * s2));
    }, posFromDate: function(t2) {
      if (!this.isVisible())
        return 0;
      if (!t2)
        return 0;
      var e2 = String(t2.valueOf());
      if (void 0 !== this._posFromDateCache[e2])
        return this._posFromDateCache[e2];
      var n2 = this.columnIndexByDate(t2);
      this.$gantt.assert(n2 >= 0, "Invalid day index");
      var i2 = Math.floor(n2), r2 = n2 % 1, a2 = this._tasks.left[Math.min(i2, this._tasks.width.length - 1)];
      i2 == this._tasks.width.length && (a2 += this._tasks.width[this._tasks.width.length - 1]), r2 && (i2 < this._tasks.width.length ? a2 += this._tasks.width[i2] * (r2 % 1) : a2 += 1);
      var o2 = Math.round(a2);
      return this._posFromDateCache[e2] = o2, Math.round(o2);
    }, _getNextVisibleColumn: function(t2, e2, n2) {
      for (var i2 = +e2[t2], r2 = t2; n2[i2]; )
        i2 = +e2[++r2];
      return r2;
    }, _getPrevVisibleColumn: function(t2, e2, n2) {
      for (var i2 = +e2[t2], r2 = t2; n2[i2]; )
        i2 = +e2[--r2];
      return r2;
    }, _getClosestVisibleColumn: function(t2, e2, n2) {
      var i2 = this._getNextVisibleColumn(t2, e2, n2);
      return e2[i2] || (i2 = this._getPrevVisibleColumn(t2, e2, n2)), i2;
    }, columnIndexByDate: function(t2) {
      var e2 = new Date(t2).valueOf(), n2 = this._tasks.trace_x_ascending, i2 = this._tasks.ignore_x, r2 = this.$gantt.getState();
      if (e2 <= r2.min_date)
        return this._tasks.rtl ? n2.length : 0;
      if (e2 >= r2.max_date)
        return this._tasks.rtl ? 0 : n2.length;
      var a2 = o.findBinary(n2, e2), s2 = this._getClosestVisibleColumn(a2, n2, i2), l2 = n2[s2], c2 = this._tasks.trace_index_transition;
      if (!l2)
        return c2 ? c2[0] : 0;
      var u = (t2 - n2[s2]) / this._getColumnDuration(this._tasks, n2[s2]);
      return c2 ? c2[s2] + (1 - u) : s2 + u;
    }, getItemPosition: function(t2, e2, n2) {
      var i2, r2, a2;
      return this._tasks.rtl ? (r2 = this.posFromDate(e2 || t2.start_date), i2 = this.posFromDate(n2 || t2.end_date)) : (i2 = this.posFromDate(e2 || t2.start_date), r2 = this.posFromDate(n2 || t2.end_date)), a2 = Math.max(r2 - i2, 0), { left: i2, top: this.getItemTop(t2.id), height: this.getBarHeight(t2.id), width: a2, rowHeight: this.getItemHeight(t2.id) };
    }, getBarHeight: function(t2, e2) {
      var n2 = this.$getConfig(), i2 = this.$config.rowStore.getItem(t2), r2 = i2.task_height || i2.bar_height || n2.bar_height || n2.task_height, a2 = this.getItemHeight(t2);
      "full" == r2 && (r2 = a2 - (n2.task_height_offset || 5));
      return r2 = Math.min(r2, a2), e2 && (r2 = Math.round(r2 / Math.sqrt(2))), Math.max(r2, 0);
    }, getScale: function() {
      return this._tasks;
    }, _getScales: function() {
      var t2 = this.$getConfig(), e2 = this.$scaleHelper, n2 = [e2.primaryScale(t2)].concat(e2.getSubScales(t2));
      return e2.sortScales(n2), n2;
    }, _getColumnDuration: function(t2, e2) {
      return this.$gantt.date.add(e2, t2.step, t2.unit) - e2;
    }, _bindStore: function() {
      if (this.$config.bind) {
        var t2 = this.$gantt.getDatastore(this.$config.bind);
        if (this.$config.rowStore = t2, t2 && !t2._timelineCacheAttached) {
          var e2 = this;
          t2._timelineCacheAttached = t2.attachEvent("onBeforeFilter", function() {
            e2._resetTopPositionHeight();
          });
        }
      }
    }, _unbindStore: function() {
      if (this.$config.bind) {
        var t2 = this.$gantt.getDatastore(this.$config.bind);
        t2 && t2._timelineCacheAttached && (t2.detachEvent(t2._timelineCacheAttached), t2._timelineCacheAttached = false);
      }
    }, refresh: function() {
      this._bindStore(), this.$config.bindLinks && (this.$config.linkStore = this.$gantt.getDatastore(this.$config.bindLinks)), this._resetTopPositionHeight(), this._resetHeight(), this._initStaticBackgroundRender(), this._render_tasks_scales();
    }, destructor: function() {
      var t2 = this.$gantt;
      this._clearLayers(t2), this._unbindStore(), this.$task = null, this.$task_scale = null, this.$task_data = null, this.$task_bg = null, this.$task_links = null, this.$task_bars = null, this.$gantt = null, this.$config.rowStore && (this.$config.rowStore.detachEvent(this._staticBgHandler), this.$config.rowStore = null), this.$config.linkStore && (this.$config.linkStore = null), this._timelineDragScroll && (this._timelineDragScroll.destructor(), this._timelineDragScroll = null), this.callEvent("onDestroy", []), this.detachAllEvents();
    } }, t.exports = c;
  }, function(t, e, n) {
    var i = n(3), r = n(1), a = function(t2) {
      function e2(e3, n2, i2) {
        var r2 = t2.apply(this, arguments) || this;
        return e3 && (r2.$root = true), r2._parseConfig(n2), r2.$name = "layout", r2;
      }
      return i(e2, t2), e2.prototype.destructor = function() {
        this.$container && this.$view && r.removeNode(this.$view);
        for (var e3 = 0; e3 < this.$cells.length; e3++) {
          this.$cells[e3].destructor();
        }
        this.$cells = [], t2.prototype.destructor.call(this);
      }, e2.prototype._resizeScrollbars = function(t3, e3) {
        var n2, i2 = false, r2 = [], a2 = [];
        function o(t4) {
          t4.$parent.show(), i2 = true, r2.push(t4);
        }
        function s(t4) {
          t4.$parent.hide(), i2 = true, a2.push(t4);
        }
        for (var l = 0; l < e3.length; l++)
          t3[(n2 = e3[l]).$config.scroll] ? s(n2) : n2.shouldHide() ? s(n2) : n2.shouldShow() ? o(n2) : n2.isVisible() ? r2.push(n2) : a2.push(n2);
        var c = {};
        for (l = 0; l < r2.length; l++)
          r2[l].$config.group && (c[r2[l].$config.group] = true);
        for (l = 0; l < a2.length; l++)
          if ((n2 = a2[l]).$config.group && c[n2.$config.group]) {
            o(n2);
            for (var u = 0; u < r2.length; u++)
              if (r2[u] == n2) {
                this.$gantt.$scrollbarRepaint = true;
                break;
              }
          }
        return i2;
      }, e2.prototype._syncCellSizes = function(t3, e3) {
        if (t3) {
          var n2 = {};
          return this._eachChild(function(t4) {
            t4.$config.group && "scrollbar" != t4.$name && "resizer" != t4.$name && (n2[t4.$config.group] || (n2[t4.$config.group] = []), n2[t4.$config.group].push(t4));
          }), n2[t3] && this._syncGroupSize(n2[t3], e3), n2[t3];
        }
      }, e2.prototype._syncGroupSize = function(t3, e3) {
        if (t3.length)
          for (var n2 = t3[0].$parent._xLayout ? "width" : "height", i2 = t3[0].$parent.getNextSibling(t3[0].$id) ? 1 : -1, r2 = e3.value, a2 = e3.isGravity, o = 0; o < t3.length; o++) {
            var s = t3[o].getSize(), l = i2 > 0 ? t3[o].$parent.getNextSibling(t3[o].$id) : t3[o].$parent.getPrevSibling(t3[o].$id);
            "resizer" == l.$name && (l = i2 > 0 ? l.$parent.getNextSibling(l.$id) : l.$parent.getPrevSibling(l.$id));
            var c = l.getSize();
            if (a2)
              t3[o].$config.gravity = r2;
            else if (l[n2]) {
              var u = s.gravity + c.gravity, d = s[n2] + c[n2], h2 = u / d;
              t3[o].$config.gravity = h2 * r2, l.$config[n2] = d - r2, l.$config.gravity = u - h2 * r2;
            } else
              t3[o].$config[n2] = r2;
            var f = this.$gantt.$ui.getView("grid");
            !f || t3[o].$content !== f || f.$config.scrollable || a2 || (this.$gantt.config.grid_width = r2);
          }
      }, e2.prototype.resize = function(e3) {
        var n2 = false;
        if (this.$root && !this._resizeInProgress && (this.callEvent("onBeforeResize", []), n2 = true, this._resizeInProgress = true), t2.prototype.resize.call(this, true), t2.prototype.resize.call(this, false), n2) {
          var i2 = [];
          i2 = (i2 = (i2 = i2.concat(this.getCellsByType("viewCell"))).concat(this.getCellsByType("viewLayout"))).concat(this.getCellsByType("hostCell"));
          for (var r2 = this.getCellsByType("scroller"), a2 = 0; a2 < i2.length; a2++)
            i2[a2].$config.hidden || i2[a2].setContentSize();
          var o = this._getAutosizeMode(this.$config.autosize), s = this._resizeScrollbars(o, r2);
          if (this.$config.autosize && (this.autosize(this.$config.autosize), s = true), s) {
            this.resize();
            for (a2 = 0; a2 < i2.length; a2++)
              i2[a2].$config.hidden || i2[a2].setContentSize();
          }
          this.callEvent("onResize", []);
        }
        n2 && (this._resizeInProgress = false);
      }, e2.prototype._eachChild = function(t3, e3) {
        if (t3(e3 = e3 || this), e3.$cells)
          for (var n2 = 0; n2 < e3.$cells.length; n2++)
            this._eachChild(t3, e3.$cells[n2]);
      }, e2.prototype.isChild = function(t3) {
        var e3 = false;
        return this._eachChild(function(n2) {
          n2 !== t3 && n2.$content !== t3 || (e3 = true);
        }), e3;
      }, e2.prototype.getCellsByType = function(t3) {
        var n2 = [];
        if (t3 === this.$name && n2.push(this), this.$content && this.$content.$name == t3 && n2.push(this.$content), this.$cells)
          for (var i2 = 0; i2 < this.$cells.length; i2++) {
            var r2 = e2.prototype.getCellsByType.call(this.$cells[i2], t3);
            r2.length && n2.push.apply(n2, r2);
          }
        return n2;
      }, e2.prototype.getNextSibling = function(t3) {
        var e3 = this.cellIndex(t3);
        return e3 >= 0 && this.$cells[e3 + 1] ? this.$cells[e3 + 1] : null;
      }, e2.prototype.getPrevSibling = function(t3) {
        var e3 = this.cellIndex(t3);
        return e3 >= 0 && this.$cells[e3 - 1] ? this.$cells[e3 - 1] : null;
      }, e2.prototype.cell = function(t3) {
        for (var e3 = 0; e3 < this.$cells.length; e3++) {
          var n2 = this.$cells[e3];
          if (n2.$id === t3)
            return n2;
          var i2 = n2.cell(t3);
          if (i2)
            return i2;
        }
      }, e2.prototype.cellIndex = function(t3) {
        for (var e3 = 0; e3 < this.$cells.length; e3++)
          if (this.$cells[e3].$id === t3)
            return e3;
        return -1;
      }, e2.prototype.moveView = function(t3, e3) {
        if (this.$cells[e3] !== t3)
          return window.alert("Not implemented");
        e3 += this.$config.header ? 1 : 0;
        var n2 = this.$view;
        e3 >= n2.childNodes.length ? n2.appendChild(t3.$view) : n2.insertBefore(t3.$view, n2.childNodes[e3]);
      }, e2.prototype._parseConfig = function(t3) {
        this.$cells = [], this._xLayout = !t3.rows;
        for (var e3 = t3.rows || t3.cols || t3.views, n2 = 0; n2 < e3.length; n2++) {
          var i2 = e3[n2];
          i2.mode = this._xLayout ? "x" : "y";
          var r2 = this.$factory.initUI(i2, this);
          r2 ? (r2.$parent = this, this.$cells.push(r2)) : (e3.splice(n2, 1), n2--);
        }
      }, e2.prototype.getCells = function() {
        return this.$cells;
      }, e2.prototype.render = function() {
        var t3 = r.insertNode(this.$container, this.$toHTML());
        this.$fill(t3, null), this.callEvent("onReady", []), this.resize(), this.render = this.resize;
      }, e2.prototype.$fill = function(t3, e3) {
        this.$view = t3, this.$parent = e3;
        for (var n2 = r.getChildNodes(t3, "gantt_layout_cell"), i2 = n2.length - 1; i2 >= 0; i2--) {
          var a2 = this.$cells[i2];
          a2.$fill(n2[i2], this), a2.$config.hidden && a2.$view.parentNode.removeChild(a2.$view);
        }
      }, e2.prototype.$toHTML = function() {
        for (var e3 = this._xLayout ? "x" : "y", n2 = [], i2 = 0; i2 < this.$cells.length; i2++)
          n2.push(this.$cells[i2].$toHTML());
        return t2.prototype.$toHTML.call(this, n2.join(""), (this.$root ? "gantt_layout_root " : "") + "gantt_layout gantt_layout_" + e3);
      }, e2.prototype.getContentSize = function(t3) {
        for (var e3, n2, i2, r2 = 0, a2 = 0, o = 0; o < this.$cells.length; o++)
          (n2 = this.$cells[o]).$config.hidden || (e3 = n2.getContentSize(t3), "scrollbar" === n2.$config.view && t3[n2.$config.scroll] && (e3.height = 0, e3.width = 0), n2.$config.resizer && (this._xLayout ? e3.height = 0 : e3.width = 0), i2 = n2._getBorderSizes(), this._xLayout ? (r2 += e3.width + i2.horizontal, a2 = Math.max(a2, e3.height + i2.vertical)) : (r2 = Math.max(r2, e3.width + i2.horizontal), a2 += e3.height + i2.vertical));
        return { width: r2 += (i2 = this._getBorderSizes()).horizontal, height: a2 += i2.vertical };
      }, e2.prototype._cleanElSize = function(t3) {
        return 1 * (t3 || "").toString().replace("px", "") || 0;
      }, e2.prototype._getBoxStyles = function(t3) {
        var e3 = null, n2 = ["width", "height", "paddingTop", "paddingBottom", "paddingLeft", "paddingRight", "borderLeftWidth", "borderRightWidth", "borderTopWidth", "borderBottomWidth"], i2 = { boxSizing: "border-box" == (e3 = window.getComputedStyle ? window.getComputedStyle(t3, null) : { width: t3.clientWidth, height: t3.clientHeight }).boxSizing };
        e3.MozBoxSizing && (i2.boxSizing = "border-box" == e3.MozBoxSizing);
        for (var r2 = 0; r2 < n2.length; r2++)
          i2[n2[r2]] = e3[n2[r2]] ? this._cleanElSize(e3[n2[r2]]) : 0;
        var a2 = { horPaddings: i2.paddingLeft + i2.paddingRight + i2.borderLeftWidth + i2.borderRightWidth, vertPaddings: i2.paddingTop + i2.paddingBottom + i2.borderTopWidth + i2.borderBottomWidth, borderBox: i2.boxSizing, innerWidth: i2.width, innerHeight: i2.height, outerWidth: i2.width, outerHeight: i2.height };
        return a2.borderBox ? (a2.innerWidth -= a2.horPaddings, a2.innerHeight -= a2.vertPaddings) : (a2.outerWidth += a2.horPaddings, a2.outerHeight += a2.vertPaddings), a2;
      }, e2.prototype._getAutosizeMode = function(t3) {
        var e3 = { x: false, y: false };
        return "xy" === t3 ? e3.x = e3.y = true : "y" === t3 || true === t3 ? e3.y = true : "x" === t3 && (e3.x = true), e3;
      }, e2.prototype.autosize = function(t3) {
        var e3 = this._getAutosizeMode(t3), n2 = this._getBoxStyles(this.$container), i2 = this.getContentSize(t3), r2 = this.$container;
        e3.x && (n2.borderBox && (i2.width += n2.horPaddings), r2.style.width = i2.width + "px"), e3.y && (n2.borderBox && (i2.height += n2.vertPaddings), r2.style.height = i2.height + "px");
      }, e2.prototype.getSize = function() {
        this._sizes = [];
        for (var e3 = 0, n2 = 0, i2 = 1e11, r2 = 0, a2 = 1e11, o = 0, s = 0; s < this.$cells.length; s++) {
          var l = this._sizes[s] = this.$cells[s].getSize();
          this.$cells[s].$config.hidden || (this._xLayout ? (!l.width && l.minWidth ? e3 += l.minWidth : e3 += l.width, i2 += l.maxWidth, n2 += l.minWidth, r2 = Math.max(r2, l.height), a2 = Math.min(a2, l.maxHeight), o = Math.max(o, l.minHeight)) : (!l.height && l.minHeight ? r2 += l.minHeight : r2 += l.height, a2 += l.maxHeight, o += l.minHeight, e3 = Math.max(e3, l.width), i2 = Math.min(i2, l.maxWidth), n2 = Math.max(n2, l.minWidth)));
        }
        var c = t2.prototype.getSize.call(this);
        return c.maxWidth >= 1e5 && (c.maxWidth = i2), c.maxHeight >= 1e5 && (c.maxHeight = a2), c.minWidth = c.minWidth != c.minWidth ? 0 : c.minWidth, c.minHeight = c.minHeight != c.minHeight ? 0 : c.minHeight, this._xLayout ? (c.minWidth += this.$config.margin * this.$cells.length || 0, c.minWidth += 2 * this.$config.padding || 0, c.minHeight += 2 * this.$config.padding || 0) : (c.minHeight += this.$config.margin * this.$cells.length || 0, c.minHeight += 2 * this.$config.padding || 0), c;
      }, e2.prototype._calcFreeSpace = function(t3, e3, n2) {
        var i2 = n2 ? e3.minWidth : e3.minHeight, r2 = e3.maxWidth, a2 = t3;
        return a2 ? (a2 > r2 && (a2 = r2), a2 < i2 && (a2 = i2), this._free -= a2) : ((a2 = Math.floor(this._free / this._gravity * e3.gravity)) > r2 && (a2 = r2, this._free -= a2, this._gravity -= e3.gravity), a2 < i2 && (a2 = i2, this._free -= a2, this._gravity -= e3.gravity)), a2;
      }, e2.prototype._calcSize = function(t3, e3, n2) {
        var i2 = t3, r2 = n2 ? e3.minWidth : e3.minHeight, a2 = n2 ? e3.maxWidth : e3.maxHeight;
        return i2 || (i2 = Math.floor(this._free / this._gravity * e3.gravity)), i2 > a2 && (i2 = a2), i2 < r2 && (i2 = r2), i2;
      }, e2.prototype._configureBorders = function() {
        this.$root && this._setBorders([this._borders.left, this._borders.top, this._borders.right, this._borders.bottom], this);
        for (var t3 = this._xLayout ? this._borders.right : this._borders.bottom, e3 = this.$cells, n2 = e3.length - 1, i2 = n2; i2 >= 0; i2--)
          if (!e3[i2].$config.hidden) {
            n2 = i2;
            break;
          }
        for (i2 = 0; i2 < e3.length; i2++)
          if (!e3[i2].$config.hidden) {
            var r2 = i2 >= n2, a2 = "";
            !r2 && e3[i2 + 1] && "scrollbar" == e3[i2 + 1].$config.view && (this._xLayout ? r2 = true : a2 = "gantt_layout_cell_border_transparent"), this._setBorders(r2 ? [] : [t3, a2], e3[i2]);
          }
      }, e2.prototype._updateCellVisibility = function() {
        for (var t3 = this._visibleCells || {}, e3 = !this._visibleCells, n2 = {}, i2 = [], r2 = 0; r2 < this._sizes.length; r2++)
          (a2 = this.$cells[r2]).$config.hide_empty && i2.push(a2), !e3 && a2.$config.hidden && t3[a2.$id] ? a2._hide(true) : a2.$config.hidden || t3[a2.$id] || a2._hide(false), a2.$config.hidden || (n2[a2.$id] = true);
        this._visibleCells = n2;
        for (r2 = 0; r2 < i2.length; r2++) {
          var a2, o = true;
          (a2 = i2[r2]).$cells.forEach(function(t4) {
            t4.$config.hidden || t4.$config.resizer || (o = false);
          }), a2.$config.hidden = o;
        }
      }, e2.prototype.setSize = function(e3, n2) {
        this._configureBorders(), t2.prototype.setSize.call(this, e3, n2), n2 = this.$lastSize.contentY, e3 = this.$lastSize.contentX;
        var i2, r2, a2 = this.$config.padding || 0;
        this.$view.style.padding = a2 + "px", this._gravity = 0, this._free = this._xLayout ? e3 : n2, this._free -= 2 * a2, this._updateCellVisibility();
        for (var o = 0; o < this._sizes.length; o++)
          if (!(i2 = this.$cells[o]).$config.hidden) {
            var s = this.$config.margin || 0;
            "resizer" != i2.$name || s || (s = -1);
            var l = i2.$view, c = this._xLayout ? "marginRight" : "marginBottom";
            o !== this.$cells.length - 1 && (l.style[c] = s + "px", this._free -= s), r2 = this._sizes[o], this._xLayout ? r2.width || (this._gravity += r2.gravity) : r2.height || (this._gravity += r2.gravity);
          }
        for (o = 0; o < this._sizes.length; o++)
          if (!(i2 = this.$cells[o]).$config.hidden) {
            var u = (r2 = this._sizes[o]).width, d = r2.height;
            this._xLayout ? this._calcFreeSpace(u, r2, true) : this._calcFreeSpace(d, r2, false);
          }
        for (o = 0; o < this.$cells.length; o++)
          if (!(i2 = this.$cells[o]).$config.hidden) {
            r2 = this._sizes[o];
            var h2 = void 0, f = void 0;
            this._xLayout ? (h2 = this._calcSize(r2.width, r2, true), f = n2 - 2 * a2) : (h2 = e3 - 2 * a2, f = this._calcSize(r2.height, r2, false)), i2.setSize(h2, f);
          }
      }, e2;
    }(n(9));
    t.exports = a;
  }, function(t, e, n) {
    Object.defineProperty(e, "__esModule", { value: true });
    var i = n(183), r = n(182), a = n(181);
    e.LargerUnitsCache = a.LargerUnitsCache, e.createCacheObject = function() {
      return "undefined" != typeof Map ? new i.WorkUnitsMapCache() : new r.WorkUnitsObjectCache();
    };
  }, function(t, e, n) {
    var i = n(0), r = n(2);
    function a(t2, e2, n2, i2, r2) {
      return this.date = t2, this.unit = e2, this.task = n2, this.id = i2, this.calendar = r2, this;
    }
    function o(t2, e2, n2, i2, r2, a2) {
      return this.date = t2, this.dir = e2, this.unit = n2, this.task = i2, this.id = r2, this.calendar = a2, this;
    }
    function s(t2, e2, n2, i2, r2, a2, o2) {
      return this.start_date = t2, this.duration = e2, this.unit = n2, this.step = i2, this.task = r2, this.id = a2, this.calendar = o2, this;
    }
    function l(t2, e2, n2, i2) {
      return this.start_date = t2, this.end_date = e2, this.task = n2, this.calendar = i2, this.unit = null, this.step = null, this;
    }
    t.exports = function(t2) {
      return { getWorkHoursArguments: function() {
        var e2 = arguments[0];
        if (e2 = r.isDate(e2) ? { date: e2 } : i.mixin({}, e2), !r.isValidDate(e2.date))
          throw t2.assert(false, "Invalid date argument for getWorkHours method"), new Error("Invalid date argument for getWorkHours method");
        return e2;
      }, setWorkTimeArguments: function() {
        return arguments[0];
      }, unsetWorkTimeArguments: function() {
        return arguments[0];
      }, isWorkTimeArguments: function() {
        var e2, n2 = arguments[0];
        if (n2 instanceof a)
          return n2;
        if ((e2 = n2.date ? new a(n2.date, n2.unit, n2.task, null, n2.calendar) : new a(arguments[0], arguments[1], arguments[2], null, arguments[3])).unit = e2.unit || t2.config.duration_unit, !r.isValidDate(e2.date))
          throw t2.assert(false, "Invalid date argument for isWorkTime method"), new Error("Invalid date argument for isWorkTime method");
        return e2;
      }, getClosestWorkTimeArguments: function(e2) {
        var n2, i2 = arguments[0];
        if (i2 instanceof o)
          return i2;
        if (n2 = r.isDate(i2) ? new o(i2) : new o(i2.date, i2.dir, i2.unit, i2.task, null, i2.calendar), i2.id && (n2.task = i2), n2.dir = i2.dir || "any", n2.unit = i2.unit || t2.config.duration_unit, !r.isValidDate(n2.date))
          throw t2.assert(false, "Invalid date argument for getClosestWorkTime method"), new Error("Invalid date argument for getClosestWorkTime method");
        return n2;
      }, _getStartEndConfig: function(e2) {
        var n2, i2 = l;
        if (e2 instanceof i2)
          return e2;
        if (r.isDate(e2) ? n2 = new i2(arguments[0], arguments[1], arguments[2], arguments[3]) : (n2 = new i2(e2.start_date, e2.end_date, e2.task), e2.id && (n2.task = e2)), n2.unit = n2.unit || t2.config.duration_unit, n2.step = n2.step || t2.config.duration_step, n2.start_date = n2.start_date || n2.start || n2.date, !r.isValidDate(n2.start_date))
          throw t2.assert(false, "Invalid start_date argument for getDuration method"), new Error("Invalid start_date argument for getDuration method");
        if (!r.isValidDate(n2.end_date))
          throw t2.assert(false, "Invalid end_date argument for getDuration method"), new Error("Invalid end_date argument for getDuration method");
        return n2;
      }, getDurationArguments: function(t3, e2, n2, i2) {
        return this._getStartEndConfig.apply(this, arguments);
      }, hasDurationArguments: function(t3, e2, n2, i2) {
        return this._getStartEndConfig.apply(this, arguments);
      }, calculateEndDateArguments: function(e2, n2, i2, a2) {
        var o2, l2 = arguments[0];
        if (l2 instanceof s)
          return l2;
        if (o2 = r.isDate(l2) ? new s(arguments[0], arguments[1], arguments[2], void 0, arguments[3], void 0, arguments[4]) : new s(l2.start_date, l2.duration, l2.unit, l2.step, l2.task, null, l2.calendar), l2.id && (o2.task = l2, o2.unit = null, o2.step = null), o2.unit = o2.unit || t2.config.duration_unit, o2.step = o2.step || t2.config.duration_step, !r.isValidDate(o2.start_date))
          throw t2.assert(false, "Invalid start_date argument for calculateEndDate method"), new Error("Invalid start_date argument for calculateEndDate method");
        return o2;
      } };
    };
  }, function(t, e, n) {
    var i = n(195);
    t.exports = function(t2) {
      var e2 = {}, n2 = {}, r = null, a = -1, o = null, s = i(t2);
      return { _resetTopPositionHeight: function() {
        e2 = {}, n2 = {}, s.resetCache();
      }, _resetHeight: function() {
        var t3 = this.$config.rowStore, e3 = this.getCacheStateTotalHeight(t3);
        o ? this.shouldClearHeightCache(o, e3) && (o = e3, r = null) : o = e3, a = -1, s.resetCache();
      }, getRowTop: function(t3) {
        if (s.canUseSimpleCalculation())
          return s.getRowTop(t3);
        var e3 = this.$config.rowStore;
        if (!e3)
          return 0;
        if (void 0 !== n2[t3])
          return n2[t3];
        for (var i2 = e3.getIndexRange(), r2 = 0, a2 = 0, o2 = 0; o2 < i2.length; o2++)
          n2[o2] = r2, r2 += this.getItemHeight(i2[o2].id), o2 < t3 && (a2 = r2);
        return a2;
      }, getItemTop: function(t3) {
        if (this.$config.rowStore) {
          if (void 0 !== e2[t3])
            return e2[t3];
          var n3 = this.$config.rowStore;
          if (!n3)
            return 0;
          var i2 = n3.getIndexById(t3);
          if (-1 === i2 && n3.getParent && n3.exists(t3)) {
            var r2 = n3.getParent(t3);
            if (n3.exists(r2)) {
              var a2 = n3.getItem(r2);
              if (this.$gantt.isSplitTask(a2))
                return this.getItemTop(r2);
            }
          }
          return e2[t3] = this.getRowTop(i2), e2[t3];
        }
        return 0;
      }, getItemHeight: function(t3) {
        if (s.canUseSimpleCalculation())
          return s.getItemHeight(t3);
        if (!r && this.$config.rowStore && this._fillHeightCache(this.$config.rowStore), void 0 !== r[t3])
          return r[t3];
        var e3 = this.$getConfig().row_height;
        if (this.$config.rowStore) {
          var n3 = this.$config.rowStore;
          if (!n3)
            return e3;
          var i2 = n3.getItem(t3);
          return r[t3] = i2 && i2.row_height || e3;
        }
        return e3;
      }, _fillHeightCache: function(t3) {
        if (t3) {
          r = {};
          var e3 = this.$getConfig().row_height;
          t3.eachItem(function(t4) {
            return r[t4.id] = t4 && t4.row_height || e3;
          });
        }
      }, getCacheStateTotalHeight: function(t3) {
        var e3 = this.$getConfig().row_height, n3 = {}, i2 = [], r2 = 0;
        return t3 && t3.eachItem(function(t4) {
          i2.push(t4), n3[t4.id] = t4.row_height, r2 += t4.row_height || e3;
        }), { globalHeight: e3, items: i2, count: i2.length, sumHeight: r2 };
      }, shouldClearHeightCache: function(t3, e3) {
        if (t3.count != e3.count)
          return true;
        if (t3.globalHeight != e3.globalHeight)
          return true;
        if (t3.sumHeight != e3.sumHeight)
          return true;
        for (var n3 in t3.items) {
          var i2 = e3.items[n3];
          if (void 0 !== i2 && i2 != t3.items[n3])
            return true;
        }
        return false;
      }, getTotalHeight: function() {
        if (s.canUseSimpleCalculation())
          return s.getTotalHeight();
        if (-1 != a)
          return a;
        if (this.$config.rowStore) {
          var t3 = this.$config.rowStore;
          this._fillHeightCache(t3);
          var e3 = this.getItemHeight.bind(this), n3 = 0;
          return t3.getVisibleItems().forEach(function(t4) {
            n3 += e3(t4.id);
          }), a = n3, n3;
        }
        return 0;
      }, getItemIndexByTopPosition: function(t3) {
        if (!this.$config.rowStore)
          return 0;
        if (s.canUseSimpleCalculation())
          return s.getItemIndexByTopPosition(t3);
        for (var e3 = this.$config.rowStore, n3 = 0; n3 < e3.countVisible(); n3++) {
          var i2 = this.getRowTop(n3), r2 = this.getRowTop(n3 + 1);
          if (!r2) {
            var a2 = e3.getIdByIndex(n3);
            r2 = i2 + this.getItemHeight(a2);
          }
          if (t3 >= i2 && t3 < r2)
            return n3;
        }
      } };
    };
  }, function(t, e) {
    function n(t2, e2, n2) {
      for (var i2 = 0; i2 < e2.length; i2++)
        t2.isLinkExists(e2[i2]) && (n2[e2[i2]] = t2.getLink(e2[i2]));
    }
    function i(t2, e2, i2) {
      n(t2, e2.$source, i2), n(t2, e2.$target, i2);
    }
    t.exports = { getSubtreeLinks: function(t2, e2) {
      var n2 = {};
      return t2.isTaskExists(e2) && i(t2, t2.getTask(e2), n2), t2.eachTask(function(e3) {
        i(t2, e3, n2);
      }, e2), n2;
    }, getSubtreeTasks: function(t2, e2) {
      var n2 = {};
      return t2.eachTask(function(t3) {
        n2[t3.id] = t3;
      }, e2), n2;
    } };
  }, function(t, e, n) {
    var i = n(0);
    t.exports = function(t2) {
      var e2 = t2.date, n2 = t2.$services;
      return { getSum: function(t3, e3, n3) {
        void 0 === n3 && (n3 = t3.length - 1), void 0 === e3 && (e3 = 0);
        for (var i2 = 0, r = e3; r <= n3; r++)
          i2 += t3[r];
        return i2;
      }, setSumWidth: function(t3, e3, n3, i2) {
        var r = e3.width;
        void 0 === i2 && (i2 = r.length - 1), void 0 === n3 && (n3 = 0);
        var a = i2 - n3 + 1;
        if (!(n3 > r.length - 1 || a <= 0 || i2 > r.length - 1)) {
          var o = t3 - this.getSum(r, n3, i2);
          this.adjustSize(o, r, n3, i2), this.adjustSize(-o, r, i2 + 1), e3.full_width = this.getSum(r);
        }
      }, splitSize: function(t3, e3) {
        for (var n3 = [], i2 = 0; i2 < e3; i2++)
          n3[i2] = 0;
        return this.adjustSize(t3, n3), n3;
      }, adjustSize: function(t3, e3, n3, i2) {
        n3 || (n3 = 0), void 0 === i2 && (i2 = e3.length - 1);
        for (var r = i2 - n3 + 1, a = this.getSum(e3, n3, i2), o = n3; o <= i2; o++) {
          var s = Math.floor(t3 * (a ? e3[o] / a : 1 / r));
          a -= e3[o], t3 -= s, r--, e3[o] += s;
        }
        e3[e3.length - 1] += t3;
      }, sortScales: function(t3) {
        function n3(t4, n4) {
          var i3 = new Date(1970, 0, 1);
          return e2.add(i3, n4, t4) - i3;
        }
        t3.sort(function(t4, e3) {
          return n3(t4.unit, t4.step) < n3(e3.unit, e3.step) ? 1 : n3(t4.unit, t4.step) > n3(e3.unit, e3.step) ? -1 : 0;
        });
        for (var i2 = 0; i2 < t3.length; i2++)
          t3[i2].index = i2;
      }, _isLegacyMode: function(e3) {
        var n3 = e3 || t2.config;
        return n3.scale_unit || n3.date_scale || n3.subscales;
      }, _prepareScaleObject: function(e3) {
        var n3 = e3.format;
        return n3 || (n3 = e3.template || e3.date || "%d %M"), "string" == typeof n3 && (n3 = t2.date.date_to_str(n3)), { unit: e3.unit || "day", step: e3.step || 1, format: n3, css: e3.css };
      }, primaryScale: function(e3) {
        var i2, r = n2.getService("templateLoader"), a = this._isLegacyMode(e3), o = e3 || t2.config;
        if (a)
          r.initTemplate("date_scale", void 0, void 0, o, t2.config.templates), i2 = { unit: t2.config.scale_unit, step: t2.config.step, template: t2.templates.date_scale, date: t2.config.date_scale, css: t2.templates.scale_cell_class };
        else {
          var s = o.scales[0];
          i2 = { unit: s.unit, step: s.step, template: s.template, format: s.format, date: s.date, css: s.css || t2.templates.scale_cell_class };
        }
        return this._prepareScaleObject(i2);
      }, getSubScales: function(e3) {
        var n3 = this._isLegacyMode(e3), i2 = e3 || t2.config;
        return (n3 ? i2.subscales || [] : i2.scales.slice(1)).map((function(t3) {
          return this._prepareScaleObject(t3);
        }).bind(this));
      }, prepareConfigs: function(t3, e3, n3, i2, r, a, o) {
        for (var s = this.splitSize(i2, t3.length), l = n3, c = [], u = t3.length - 1; u >= 0; u--) {
          var d = u == t3.length - 1, h2 = this.initScaleConfig(t3[u], r, a);
          d && this.processIgnores(h2), this.initColSizes(h2, e3, l, s[u]), this.limitVisibleRange(h2), d && (l = h2.full_width), c.unshift(h2);
        }
        for (u = 0; u < c.length - 1; u++)
          this.alineScaleColumns(c[c.length - 1], c[u]);
        for (u = 0; u < c.length; u++)
          o && this.reverseScale(c[u]), this.setPosSettings(c[u]);
        return c;
      }, reverseScale: function(t3) {
        t3.width = t3.width.reverse(), t3.trace_x = t3.trace_x.reverse();
        var e3 = t3.trace_indexes;
        t3.trace_indexes = {}, t3.trace_index_transition = {}, t3.rtl = true;
        for (var n3 = 0; n3 < t3.trace_x.length; n3++)
          t3.trace_indexes[t3.trace_x[n3].valueOf()] = n3, t3.trace_index_transition[e3[t3.trace_x[n3].valueOf()]] = n3;
        return t3;
      }, setPosSettings: function(t3) {
        for (var e3 = 0, n3 = t3.trace_x.length; e3 < n3; e3++)
          t3.left.push((t3.width[e3 - 1] || 0) + (t3.left[e3 - 1] || 0));
      }, _ignore_time_config: function(n3, i2) {
        if (t2.config.skip_off_time) {
          for (var r = true, a = n3, o = 0; o < i2.step; o++)
            o && (a = e2.add(n3, o, i2.unit)), r = r && !this.isWorkTime(a, i2.unit);
          return r;
        }
        return false;
      }, processIgnores: function(t3) {
        t3.ignore_x = {}, t3.display_count = t3.count;
      }, initColSizes: function(t3, n3, i2, r) {
        var a = i2;
        t3.height = r;
        var o = void 0 === t3.display_count ? t3.count : t3.display_count;
        o || (o = 1), t3.col_width = Math.floor(a / o), n3 && t3.col_width < n3 && (t3.col_width = n3, a = t3.col_width * o), t3.width = [];
        for (var s = t3.ignore_x || {}, l = 0; l < t3.trace_x.length; l++)
          if (s[t3.trace_x[l].valueOf()] || t3.display_count == t3.count)
            t3.width[l] = 0;
          else {
            var c = 1;
            "month" == t3.unit && (c = Math.round((e2.add(t3.trace_x[l], t3.step, t3.unit) - t3.trace_x[l]) / 864e5)), t3.width[l] = c;
          }
        this.adjustSize(a - this.getSum(t3.width), t3.width), t3.full_width = this.getSum(t3.width);
      }, initScaleConfig: function(t3, e3, n3) {
        var r = i.mixin({ count: 0, col_width: 0, full_width: 0, height: 0, width: [], left: [], trace_x: [], trace_indexes: {}, min_date: new Date(e3), max_date: new Date(n3) }, t3);
        return this.eachColumn(t3.unit, t3.step, e3, n3, function(t4) {
          r.count++, r.trace_x.push(new Date(t4)), r.trace_indexes[t4.valueOf()] = r.trace_x.length - 1;
        }), r.trace_x_ascending = r.trace_x.slice(), r;
      }, iterateScales: function(t3, e3, n3, i2, r) {
        for (var a = e3.trace_x, o = t3.trace_x, s = n3 || 0, l = i2 || o.length - 1, c = 0, u = 1; u < a.length; u++) {
          var d = t3.trace_indexes[+a[u]];
          void 0 !== d && d <= l && (r && r.apply(this, [c, u, s, d]), s = d, c = u);
        }
      }, alineScaleColumns: function(t3, e3, n3, i2) {
        this.iterateScales(t3, e3, n3, i2, function(n4, i3, r, a) {
          var o = this.getSum(t3.width, r, a - 1);
          this.getSum(e3.width, n4, i3 - 1) != o && this.setSumWidth(o, e3, n4, i3 - 1);
        });
      }, eachColumn: function(n3, i2, r, a, o) {
        var s = new Date(r), l = new Date(a);
        e2[n3 + "_start"] && (s = e2[n3 + "_start"](s));
        var c = new Date(s);
        for (+c >= +l && (l = e2.add(c, i2, n3)); +c < +l; ) {
          o.call(this, new Date(c));
          var u = c.getTimezoneOffset();
          c = e2.add(c, i2, n3), c = t2._correct_dst_change(c, u, i2, n3), e2[n3 + "_start"] && (c = e2[n3 + "_start"](c));
        }
      }, limitVisibleRange: function(t3) {
        var n3 = t3.trace_x, i2 = t3.width.length - 1, r = 0;
        if (+n3[0] < +t3.min_date && 0 != i2) {
          var a = Math.floor(t3.width[0] * ((n3[1] - t3.min_date) / (n3[1] - n3[0])));
          r += t3.width[0] - a, t3.width[0] = a, n3[0] = new Date(t3.min_date);
        }
        var o = n3.length - 1, s = n3[o], l = e2.add(s, t3.step, t3.unit);
        if (+l > +t3.max_date && o > 0 && (a = t3.width[o] - Math.floor(t3.width[o] * ((l - t3.max_date) / (l - s))), r += t3.width[o] - a, t3.width[o] = a), r) {
          for (var c = this.getSum(t3.width), u = 0, d = 0; d < t3.width.length; d++) {
            var h2 = Math.floor(r * (t3.width[d] / c));
            t3.width[d] += h2, u += h2;
          }
          this.adjustSize(r - u, t3.width);
        }
      } };
    };
  }, function(t, e, n) {
    var i = n(40);
    t.exports = function(t2) {
      var e2 = new i(t2);
      return e2.processIgnores = function(e3) {
        var n2 = e3.count;
        if (e3.ignore_x = {}, t2.ignore_time || t2.config.skip_off_time) {
          var i2 = t2.ignore_time || function() {
            return false;
          };
          n2 = 0;
          for (var r = 0; r < e3.trace_x.length; r++)
            i2.call(t2, e3.trace_x[r]) || this._ignore_time_config.call(t2, e3.trace_x[r], e3) ? (e3.ignore_x[e3.trace_x[r].valueOf()] = true, e3.ignored_colls = true) : n2++;
        }
        e3.display_count = n2;
      }, e2;
    };
  }, function(t, e, n) {
    var i = n(41), r = n(40);
    function a(t2) {
      var e2 = function(t3) {
        var e3 = new r(t3).primaryScale(), n3 = e3.unit, a3 = e3.step;
        if (t3.config.scale_offset_minimal) {
          var o2 = new i(t3), s = [o2.primaryScale()].concat(o2.getSubScales());
          o2.sortScales(s), n3 = s[s.length - 1].unit, a3 = s[s.length - 1].step || 1;
        }
        return { unit: n3, step: a3 };
      }(t2), n2 = e2.unit, a2 = e2.step, o = function(t3, e3) {
        var n3 = { start_date: null, end_date: null };
        if (e3.config.start_date && e3.config.end_date) {
          n3.start_date = e3.date[t3 + "_start"](new Date(e3.config.start_date));
          var i2 = new Date(e3.config.end_date), r2 = e3.date[t3 + "_start"](new Date(i2));
          i2 = +i2 != +r2 ? e3.date.add(r2, 1, t3) : r2, n3.end_date = i2;
        }
        return n3;
      }(n2, t2);
      o.start_date && o.end_date || ((o = t2.getSubtaskDates()).start_date && o.end_date || (o = { start_date: /* @__PURE__ */ new Date(), end_date: /* @__PURE__ */ new Date() }), o.start_date = t2.date[n2 + "_start"](o.start_date), o.start_date = t2.calculateEndDate({ start_date: t2.date[n2 + "_start"](o.start_date), duration: -1, unit: n2, step: a2 }), o.end_date = t2.date[n2 + "_start"](o.end_date), o.end_date = t2.calculateEndDate({ start_date: o.end_date, duration: 2, unit: n2, step: a2 })), t2._min_date = o.start_date, t2._max_date = o.end_date;
    }
    t.exports = function(t2) {
      a(t2), function(t3) {
        if (t3.config.fit_tasks) {
          var e2 = +t3._min_date, n2 = +t3._max_date;
          if (+t3._min_date != e2 || +t3._max_date != n2)
            return t3.render(), t3.callEvent("onScaleAdjusted", []), true;
        }
      }(t2);
    };
  }, function(t, e, n) {
    var i = n(44), r = n(0), a = n(2), o = n(45), s = n(11), l = n(2).replaceValidZeroId;
    o.default && (o = o.default);
    var c = function(t2) {
      o.apply(this, [t2]), this._branches = {}, this.pull = {}, this.$initItem = function(e3) {
        var n3 = e3;
        t2.initItem && (n3 = t2.initItem(n3));
        var i2 = this.getItem(e3.id);
        return i2 && i2.parent != n3.parent && this.move(n3.id, n3.$index || -1, n3.parent || this._ganttConfig.root_id), n3;
      }, this.$parentProperty = t2.parentProperty || "parent", "function" != typeof t2.rootId ? this.$getRootId = function(t3) {
        return function() {
          return t3;
        };
      }(t2.rootId || 0) : this.$getRootId = t2.rootId, this.$openInitially = t2.openInitially, this.visibleOrder = i.$create(), this.fullOrder = i.$create(), this._searchVisibleOrder = {}, this._indexRangeCache = {}, this._eachItemMainRangeCache = null, this._getItemsCache = null, this._skip_refresh = false, this._ganttConfig = null, t2.getConfig && (this._ganttConfig = t2.getConfig());
      var e2 = {}, n2 = {}, r2 = {}, a2 = {}, s2 = false;
      return this._attachDataChange(function() {
        return this._indexRangeCache = {}, this._eachItemMainRangeCache = null, this._getItemsCache = null, true;
      }), this.attachEvent("onPreFilter", function() {
        this._indexRangeCache = {}, this._eachItemMainRangeCache = null, e2 = {}, n2 = {}, r2 = {}, a2 = {}, s2 = false, this.eachItem(function(t3) {
          var i2 = this.getParent(t3.id);
          t3.$open && false !== r2[i2] ? r2[t3.id] = true : r2[t3.id] = false, this._isSplitItem(t3) && (s2 = true, e2[t3.id] = true, n2[t3.id] = true), s2 && n2[i2] && (n2[t3.id] = true), r2[i2] || void 0 === r2[i2] ? a2[t3.id] = true : a2[t3.id] = false;
        });
      }), this.attachEvent("onFilterItem", function(t3, i2) {
        var r3 = false;
        if (this._ganttConfig)
          r3 = this._ganttConfig.open_split_tasks;
        var o2 = a2[i2.id];
        return s2 && (o2 && n2[i2.id] && !e2[i2.id] && (o2 = !!r3), n2[i2.id] && !e2[i2.id] && (i2.$split_subtask = true)), i2.$expanded_branch = !!a2[i2.id], !!o2;
      }), this.attachEvent("onFilter", function() {
        e2 = {}, n2 = {}, r2 = {}, a2 = {};
      }), this;
    };
    c.prototype = r.mixin({ _buildTree: function(t2) {
      for (var e2 = null, n2 = this.$getRootId(), i2 = 0, a2 = t2.length; i2 < a2; i2++)
        e2 = t2[i2], this.setParent(e2, this.getParent(e2) || n2);
      for (i2 = 0, a2 = t2.length; i2 < a2; i2++)
        e2 = t2[i2], this._add_branch(e2), e2.$level = this.calculateItemLevel(e2), e2.$local_index = this.getBranchIndex(e2.id), r.defined(e2.$open) || (e2.$open = r.defined(e2.open) ? e2.open : this.$openInitially());
      this._updateOrder();
    }, _isSplitItem: function(t2) {
      return "split" == t2.render && this.hasChild(t2.id);
    }, parse: function(t2) {
      this._skip_refresh || this.callEvent("onBeforeParse", [t2]);
      var e2 = this._parseInner(t2);
      this._buildTree(e2), this.filter(), this._skip_refresh || this.callEvent("onParse", [e2]);
    }, _addItemInner: function(t2, e2) {
      var n2 = this.getParent(t2);
      r.defined(n2) || (n2 = this.$getRootId(), this.setParent(t2, n2));
      var i2 = this.getIndexById(n2) + Math.min(Math.max(e2, 0), this.visibleOrder.length);
      1 * i2 !== i2 && (i2 = void 0), o.prototype._addItemInner.call(this, t2, i2), this.setParent(t2, n2), t2.hasOwnProperty("$rendered_parent") && this._move_branch(t2, t2.$rendered_parent), this._add_branch(t2, e2);
    }, _changeIdInner: function(t2, e2) {
      var n2 = this.getChildren(t2), i2 = this._searchVisibleOrder[t2];
      o.prototype._changeIdInner.call(this, t2, e2);
      var r2 = this.getParent(e2);
      this._replace_branch_child(r2, t2, e2);
      for (var a2 = 0; a2 < n2.length; a2++)
        this.setParent(this.getItem(n2[a2]), e2);
      this._searchVisibleOrder[e2] = i2, delete this._branches[t2];
    }, _traverseBranches: function(t2, e2) {
      r.defined(e2) || (e2 = this.$getRootId());
      var n2 = this._branches[e2];
      if (n2)
        for (var i2 = 0; i2 < n2.length; i2++) {
          var a2 = n2[i2];
          t2.call(this, a2), this._branches[a2] && this._traverseBranches(t2, a2);
        }
    }, _updateOrder: function(t2) {
      this.fullOrder = i.$create(), this._traverseBranches(function(t3) {
        this.fullOrder.push(t3);
      }), t2 && o.prototype._updateOrder.call(this, t2);
    }, _removeItemInner: function(t2) {
      var e2 = [];
      this.eachItem(function(t3) {
        e2.push(t3);
      }, t2), e2.push(this.getItem(t2));
      for (var n2 = 0; n2 < e2.length; n2++)
        this._move_branch(e2[n2], this.getParent(e2[n2]), null), o.prototype._removeItemInner.call(this, e2[n2].id), this._move_branch(e2[n2], this.getParent(e2[n2]), null);
    }, move: function(t2, e2, n2) {
      var i2 = arguments[3];
      if (i2 = l(i2, this._ganttConfig.root_id)) {
        if (i2 === t2)
          return;
        n2 = this.getParent(i2), e2 = this.getBranchIndex(i2);
      }
      if (t2 != n2) {
        r.defined(n2) || (n2 = this.$getRootId());
        var a2 = this.getItem(t2), o2 = this.getParent(a2.id), c2 = this.getChildren(n2);
        if (-1 == e2 && (e2 = c2.length + 1), o2 == n2) {
          if (this.getBranchIndex(t2) == e2)
            return;
        }
        if (false === this.callEvent("onBeforeItemMove", [t2, n2, e2]))
          return false;
        for (var u = [], d = 0; d < c2.length; d++)
          s(c2[d], null, this, this._ganttConfig) && (u.push(c2[d]), c2.splice(d, 1), d--);
        this._replace_branch_child(o2, t2);
        var h2 = (c2 = this.getChildren(n2))[e2];
        (h2 = l(h2, this._ganttConfig.root_id)) ? c2 = c2.slice(0, e2).concat([t2]).concat(c2.slice(e2)) : c2.push(t2), u.length && (c2 = c2.concat(u)), this.setParent(a2, n2), this._branches[n2] = c2;
        var f = this.calculateItemLevel(a2) - a2.$level;
        a2.$level += f, this.eachItem(function(t3) {
          t3.$level += f;
        }, a2.id, this), this._moveInner(this.getIndexById(t2), this.getIndexById(n2) + e2), this.callEvent("onAfterItemMove", [t2, n2, e2]), this.refresh();
      }
    }, getBranchIndex: function(t2) {
      for (var e2 = this.getChildren(this.getParent(t2)), n2 = 0; n2 < e2.length; n2++)
        if (e2[n2] == t2)
          return n2;
      return -1;
    }, hasChild: function(t2) {
      var e2 = this._branches[t2];
      return e2 && e2.length;
    }, getChildren: function(t2) {
      var e2 = this._branches[t2];
      return e2 || i.$create();
    }, isChildOf: function(t2, e2) {
      if (!this.exists(t2))
        return false;
      if (e2 === this.$getRootId())
        return true;
      if (!this.hasChild(e2))
        return false;
      var n2 = this.getItem(t2), i2 = this.getParent(t2);
      if (this.getItem(e2).$level >= n2.$level)
        return false;
      for (; n2 && this.exists(i2); ) {
        if ((n2 = this.getItem(i2)) && n2.id == e2)
          return true;
        i2 = this.getParent(n2);
      }
      return false;
    }, getSiblings: function(t2) {
      if (!this.exists(t2))
        return i.$create();
      var e2 = this.getParent(t2);
      return this.getChildren(e2);
    }, getNextSibling: function(t2) {
      for (var e2 = this.getSiblings(t2), n2 = 0, i2 = e2.length; n2 < i2; n2++)
        if (e2[n2] == t2) {
          var r2 = e2[n2 + 1];
          return 0 === r2 && n2 > 0 && (r2 = "0"), r2 || null;
        }
      return null;
    }, getPrevSibling: function(t2) {
      for (var e2 = this.getSiblings(t2), n2 = 0, i2 = e2.length; n2 < i2; n2++)
        if (e2[n2] == t2) {
          var r2 = e2[n2 - 1];
          return 0 === r2 && n2 > 0 && (r2 = "0"), r2 || null;
        }
      return null;
    }, getParent: function(t2) {
      var e2 = null;
      return (e2 = void 0 !== t2.id ? t2 : this.getItem(t2)) ? e2[this.$parentProperty] : this.$getRootId();
    }, clearAll: function() {
      this._branches = {}, o.prototype.clearAll.call(this);
    }, calculateItemLevel: function(t2) {
      var e2 = 0;
      return this.eachParent(function() {
        e2++;
      }, t2), e2;
    }, _setParentInner: function(t2, e2, n2) {
      n2 || (t2.hasOwnProperty("$rendered_parent") ? this._move_branch(t2, t2.$rendered_parent, e2) : this._move_branch(t2, t2[this.$parentProperty], e2));
    }, setParent: function(t2, e2, n2) {
      this._setParentInner(t2, e2, n2), t2[this.$parentProperty] = e2;
    }, _eachItemCached: function(t2, e2) {
      for (var n2 = 0, i2 = e2.length; n2 < i2; n2++)
        t2.call(this, e2[n2]);
    }, _eachItemIterate: function(t2, e2, n2) {
      var i2 = this.getChildren(e2);
      for (i2.length && (i2 = i2.slice().reverse()); i2.length; ) {
        var r2 = i2.pop(), a2 = this.getItem(r2);
        if (t2.call(this, a2), n2 && n2.push(a2), this.hasChild(a2.id))
          for (var o2 = this.getChildren(a2.id), s2 = o2.length - 1; s2 >= 0; s2--)
            i2.push(o2[s2]);
      }
    }, eachItem: function(t2, e2) {
      var n2 = this.$getRootId();
      r.defined(e2) || (e2 = n2);
      var i2 = e2 || n2, a2 = false, o2 = false, s2 = null;
      i2 === n2 && (this._eachItemMainRangeCache ? (a2 = true, s2 = this._eachItemMainRangeCache) : (o2 = true, s2 = this._eachItemMainRangeCache = [])), a2 ? this._eachItemCached(t2, s2) : this._eachItemIterate(t2, i2, o2 ? s2 : null);
    }, eachParent: function(t2, e2) {
      for (var n2 = {}, i2 = e2, r2 = this.getParent(i2); this.exists(r2); ) {
        if (n2[r2])
          throw new Error("Invalid tasks tree. Cyclic reference has been detected on task " + r2);
        n2[r2] = true, i2 = this.getItem(r2), t2.call(this, i2), r2 = this.getParent(i2);
      }
    }, _add_branch: function(t2, e2, n2) {
      var r2 = void 0 === n2 ? this.getParent(t2) : n2;
      this.hasChild(r2) || (this._branches[r2] = i.$create());
      for (var a2 = this.getChildren(r2), o2 = false, s2 = 0, l2 = a2.length; s2 < l2; s2++)
        if (a2[s2] == t2.id) {
          o2 = true;
          break;
        }
      o2 || (1 * e2 == e2 ? a2.splice(e2, 0, t2.id) : a2.push(t2.id), t2.$rendered_parent = r2);
    }, _move_branch: function(t2, e2, n2) {
      this._eachItemMainRangeCache = null, this._replace_branch_child(e2, t2.id), this.exists(n2) || n2 == this.$getRootId() ? this._add_branch(t2, void 0, n2) : delete this._branches[t2.id], t2.$level = this.calculateItemLevel(t2), this.eachItem(function(t3) {
        t3.$level = this.calculateItemLevel(t3);
      }, t2.id);
    }, _replace_branch_child: function(t2, e2, n2) {
      var r2 = this.getChildren(t2);
      if (r2 && void 0 !== t2) {
        for (var a2 = i.$create(), o2 = 0; o2 < r2.length; o2++)
          r2[o2] != e2 ? a2.push(r2[o2]) : n2 && a2.push(n2);
        this._branches[t2] = a2;
      }
    }, sort: function(t2, e2, n2) {
      this.exists(n2) || (n2 = this.$getRootId()), t2 || (t2 = "order");
      var i2 = "string" == typeof t2 ? function(e3, n3) {
        return e3[t2] == n3[t2] || a.isDate(e3[t2]) && a.isDate(n3[t2]) && e3[t2].valueOf() == n3[t2].valueOf() ? 0 : e3[t2] > n3[t2] ? 1 : -1;
      } : t2;
      if (e2) {
        var r2 = i2;
        i2 = function(t3, e3) {
          return r2(e3, t3);
        };
      }
      var o2 = this.getChildren(n2);
      if (o2) {
        for (var s2 = [], l2 = o2.length - 1; l2 >= 0; l2--)
          s2[l2] = this.getItem(o2[l2]);
        s2.sort(i2);
        for (l2 = 0; l2 < s2.length; l2++)
          o2[l2] = s2[l2].id, this.sort(t2, e2, o2[l2]);
      }
    }, filter: function(t2) {
      for (var e2 in this.pull)
        this.pull[e2].$rendered_parent !== this.getParent(this.pull[e2]) && this._move_branch(this.pull[e2], this.pull[e2].$rendered_parent, this.getParent(this.pull[e2]));
      return o.prototype.filter.apply(this, arguments);
    }, open: function(t2) {
      this.exists(t2) && (this.getItem(t2).$open = true, this.callEvent("onItemOpen", [t2]));
    }, close: function(t2) {
      this.exists(t2) && (this.getItem(t2).$open = false, this.callEvent("onItemClose", [t2]));
    }, destructor: function() {
      o.prototype.destructor.call(this), this._branches = null, this._indexRangeCache = {}, this._eachItemMainRangeCache = null;
    } }, o.prototype), t.exports = c;
  }, function(t, e, n) {
    var i = n(0), r = { $create: function(t2) {
      return i.mixin(t2 || [], this);
    }, $removeAt: function(t2, e2) {
      t2 >= 0 && this.splice(t2, e2 || 1);
    }, $remove: function(t2) {
      this.$removeAt(this.$find(t2));
    }, $insertAt: function(t2, e2) {
      if (e2 || 0 === e2) {
        var n2 = this.splice(e2, this.length - e2);
        this[e2] = t2, this.push.apply(this, n2);
      } else
        this.push(t2);
    }, $find: function(t2) {
      for (var e2 = 0; e2 < this.length; e2++)
        if (t2 == this[e2])
          return e2;
      return -1;
    }, $each: function(t2, e2) {
      for (var n2 = 0; n2 < this.length; n2++)
        t2.call(e2 || this, this[n2]);
    }, $map: function(t2, e2) {
      for (var n2 = 0; n2 < this.length; n2++)
        this[n2] = t2.call(e2 || this, this[n2]);
      return this;
    }, $filter: function(t2, e2) {
      for (var n2 = 0; n2 < this.length; n2++)
        t2.call(e2 || this, this[n2]) || (this.splice(n2, 1), n2--);
      return this;
    } };
    t.exports = r;
  }, function(t, e, n) {
    var i = n(44), r = n(0), a = n(4), o = n(11), s = function(t2) {
      return this.pull = {}, this.$initItem = t2.initItem, this.visibleOrder = i.$create(), this.fullOrder = i.$create(), this._skip_refresh = false, this._filterRule = null, this._searchVisibleOrder = {}, this._indexRangeCache = {}, this._getItemsCache = null, this.$config = t2, a(this), this._attachDataChange(function() {
        return this._indexRangeCache = {}, this._getItemsCache = null, true;
      }), this;
    };
    s.prototype = { _attachDataChange: function(t2) {
      this.attachEvent("onClearAll", t2), this.attachEvent("onBeforeParse", t2), this.attachEvent("onBeforeUpdate", t2), this.attachEvent("onBeforeDelete", t2), this.attachEvent("onBeforeAdd", t2), this.attachEvent("onParse", t2), this.attachEvent("onBeforeFilter", t2);
    }, _parseInner: function(t2) {
      for (var e2 = null, n2 = [], i2 = 0, a2 = t2.length; i2 < a2; i2++)
        e2 = t2[i2], this.$initItem && (this.$config.copyOnParse() && (e2 = r.copy(e2)), e2 = this.$initItem(e2)), this.callEvent("onItemLoading", [e2]) && (this.pull.hasOwnProperty(e2.id) || this.fullOrder.push(e2.id), n2.push(e2), this.pull[e2.id] = e2);
      return n2;
    }, parse: function(t2) {
      this._skip_refresh || this.callEvent("onBeforeParse", [t2]);
      var e2 = this._parseInner(t2);
      this._skip_refresh || (this.refresh(), this.callEvent("onParse", [e2]));
    }, getItem: function(t2) {
      return this.pull[t2];
    }, _updateOrder: function(t2) {
      t2.call(this.visibleOrder), t2.call(this.fullOrder);
    }, updateItem: function(t2, e2) {
      if (r.defined(e2) || (e2 = this.getItem(t2)), !this._skip_refresh && false === this.callEvent("onBeforeUpdate", [e2.id, e2]))
        return false;
      r.mixin(this.pull[t2], e2, true), this._skip_refresh || (this.callEvent("onAfterUpdate", [e2.id, e2]), this.callEvent("onStoreUpdated", [e2.id, e2, "update"]));
    }, _removeItemInner: function(t2) {
      this._updateOrder(function() {
        this.$remove(t2);
      }), delete this.pull[t2];
    }, removeItem: function(t2) {
      var e2 = this.getItem(t2);
      if (!this._skip_refresh && false === this.callEvent("onBeforeDelete", [e2.id, e2]))
        return false;
      this.callEvent("onAfterDeleteConfirmed", [e2.id, e2]), this._removeItemInner(t2), this._skip_refresh || (this.filter(), this.callEvent("onAfterDelete", [e2.id, e2]), this.callEvent("onStoreUpdated", [e2.id, e2, "delete"]));
    }, _addItemInner: function(t2, e2) {
      if (this.exists(t2.id))
        this.silent(function() {
          this.updateItem(t2.id, t2);
        });
      else {
        var n2 = this.visibleOrder, i2 = n2.length;
        (!r.defined(e2) || e2 < 0) && (e2 = i2), e2 > i2 && (e2 = Math.min(n2.length, e2));
      }
      this.pull[t2.id] = t2, this._skip_refresh || this._updateOrder(function() {
        -1 === this.$find(t2.id) && this.$insertAt(t2.id, e2);
      }), this.filter();
    }, isVisible: function(t2) {
      return this.visibleOrder.$find(t2) > -1;
    }, getVisibleItems: function() {
      return this.getIndexRange();
    }, addItem: function(t2, e2) {
      return r.defined(t2.id) || (t2.id = r.uid()), this.$initItem && (t2 = this.$initItem(t2)), !(!this._skip_refresh && false === this.callEvent("onBeforeAdd", [t2.id, t2])) && (this._addItemInner(t2, e2), this._skip_refresh || (this.callEvent("onAfterAdd", [t2.id, t2]), this.callEvent("onStoreUpdated", [t2.id, t2, "add"])), t2.id);
    }, _changeIdInner: function(t2, e2) {
      this.pull[t2] && (this.pull[e2] = this.pull[t2]);
      var n2 = this._searchVisibleOrder[t2];
      this.pull[e2].id = e2, this._updateOrder(function() {
        this[this.$find(t2)] = e2;
      }), this._searchVisibleOrder[e2] = n2, delete this._searchVisibleOrder[t2], delete this.pull[t2];
    }, changeId: function(t2, e2) {
      this._changeIdInner(t2, e2), this.callEvent("onIdChange", [t2, e2]);
    }, exists: function(t2) {
      return !!this.pull[t2];
    }, _moveInner: function(t2, e2) {
      var n2 = this.getIdByIndex(t2);
      this._updateOrder(function() {
        this.$removeAt(t2), this.$insertAt(n2, Math.min(this.length, e2));
      });
    }, move: function(t2, e2) {
      var n2 = this.getIdByIndex(t2), i2 = this.getItem(n2);
      this._moveInner(t2, e2), this._skip_refresh || this.callEvent("onStoreUpdated", [i2.id, i2, "move"]);
    }, clearAll: function() {
      this.$destroyed || (this.silent(function() {
        this.unselect();
      }), this.pull = {}, this.visibleOrder = i.$create(), this.fullOrder = i.$create(), this._skip_refresh || (this.callEvent("onClearAll", []), this.refresh()));
    }, silent: function(t2, e2) {
      var n2 = false;
      this._skip_refresh && (n2 = true), this._skip_refresh = true, t2.call(e2 || this), n2 || (this._skip_refresh = false);
    }, arraysEqual: function(t2, e2) {
      if (t2.length !== e2.length)
        return false;
      for (var n2 = 0; n2 < t2.length; n2++)
        if (t2[n2] !== e2[n2])
          return false;
      return true;
    }, refresh: function(t2, e2) {
      var n2, i2;
      if (!this._skip_refresh && (t2 && (n2 = this.getItem(t2)), i2 = t2 ? [t2, n2, "paint"] : [null, null, null], false !== this.callEvent("onBeforeStoreUpdate", i2))) {
        var r2 = this._quick_refresh && !this._mark_recompute;
        if (this._mark_recompute = false, t2) {
          if (!e2 && !r2) {
            var a2 = this.visibleOrder;
            this.filter(), this.arraysEqual(a2, this.visibleOrder) || (t2 = void 0);
          }
        } else
          r2 || this.filter();
        i2 = t2 ? [t2, n2, "paint"] : [null, null, null], this.callEvent("onStoreUpdated", i2);
      }
    }, count: function() {
      return this.fullOrder.length;
    }, countVisible: function() {
      return this.visibleOrder.length;
    }, sort: function(t2) {
    }, serialize: function() {
    }, eachItem: function(t2) {
      for (var e2 = 0; e2 < this.fullOrder.length; e2++) {
        var n2 = this.getItem(this.fullOrder[e2]);
        t2.call(this, n2);
      }
    }, find: function(t2) {
      var e2 = [];
      return this.eachItem(function(n2) {
        t2(n2) && e2.push(n2);
      }), e2;
    }, filter: function(t2) {
      this._skip_refresh || this.callEvent("onBeforeFilter", []), this.callEvent("onPreFilter", []);
      var e2 = i.$create(), n2 = [];
      this.eachItem(function(t3) {
        this.callEvent("onFilterItem", [t3.id, t3]) && (o(t3.id, null, this, this._ganttConfig) ? n2.push(t3.id) : e2.push(t3.id));
      });
      for (var r2 = 0; r2 < n2.length; r2++)
        e2.push(n2[r2]);
      this.visibleOrder = e2, this._searchVisibleOrder = {};
      for (r2 = 0; r2 < this.visibleOrder.length; r2++)
        this._searchVisibleOrder[this.visibleOrder[r2]] = r2;
      this._skip_refresh || this.callEvent("onFilter", []);
    }, getIndexRange: function(t2, e2) {
      var n2 = Math.min(e2 || 1 / 0, this.countVisible() - 1), i2 = t2 || 0, r2 = i2 + "-" + n2;
      if (this._indexRangeCache[r2])
        return this._indexRangeCache[r2].slice();
      for (var a2 = [], o2 = i2; o2 <= n2; o2++)
        a2.push(this.getItem(this.visibleOrder[o2]));
      return this._indexRangeCache[r2] = a2.slice(), a2;
    }, getItems: function() {
      if (this._getItemsCache)
        return this._getItemsCache.slice();
      var t2 = [];
      for (var e2 in this.pull)
        t2.push(this.pull[e2]);
      return this._getItemsCache = t2.slice(), t2;
    }, getIdByIndex: function(t2) {
      return this.visibleOrder[t2];
    }, getIndexById: function(t2) {
      var e2 = this._searchVisibleOrder[t2];
      return void 0 === e2 && (e2 = -1), e2;
    }, _getNullIfUndefined: function(t2) {
      return void 0 === t2 ? null : t2;
    }, getFirst: function() {
      return this._getNullIfUndefined(this.visibleOrder[0]);
    }, getLast: function() {
      return this._getNullIfUndefined(this.visibleOrder[this.visibleOrder.length - 1]);
    }, getNext: function(t2) {
      return this._getNullIfUndefined(this.visibleOrder[this.getIndexById(t2) + 1]);
    }, getPrev: function(t2) {
      return this._getNullIfUndefined(this.visibleOrder[this.getIndexById(t2) - 1]);
    }, destructor: function() {
      this.callEvent("onDestroy", []), this.detachAllEvents(), this.$destroyed = true, this.pull = null, this.$initItem = null, this.visibleOrder = null, this.fullOrder = null, this._skip_refresh = null, this._filterRule = null, this._searchVisibleOrder = null, this._indexRangeCache = {};
    } }, t.exports = s;
  }, function(t, e) {
    var n, i, r = t.exports = {};
    function a() {
      throw new Error("setTimeout has not been defined");
    }
    function o() {
      throw new Error("clearTimeout has not been defined");
    }
    function s(t2) {
      if (n === setTimeout)
        return setTimeout(t2, 0);
      if ((n === a || !n) && setTimeout)
        return n = setTimeout, setTimeout(t2, 0);
      try {
        return n(t2, 0);
      } catch (e2) {
        try {
          return n.call(null, t2, 0);
        } catch (e3) {
          return n.call(this, t2, 0);
        }
      }
    }
    !function() {
      try {
        n = "function" == typeof setTimeout ? setTimeout : a;
      } catch (t2) {
        n = a;
      }
      try {
        i = "function" == typeof clearTimeout ? clearTimeout : o;
      } catch (t2) {
        i = o;
      }
    }();
    var l, c = [], u = false, d = -1;
    function h2() {
      u && l && (u = false, l.length ? c = l.concat(c) : d = -1, c.length && f());
    }
    function f() {
      if (!u) {
        var t2 = s(h2);
        u = true;
        for (var e2 = c.length; e2; ) {
          for (l = c, c = []; ++d < e2; )
            l && l[d].run();
          d = -1, e2 = c.length;
        }
        l = null, u = false, function(t3) {
          if (i === clearTimeout)
            return clearTimeout(t3);
          if ((i === o || !i) && clearTimeout)
            return i = clearTimeout, clearTimeout(t3);
          try {
            i(t3);
          } catch (e3) {
            try {
              return i.call(null, t3);
            } catch (e4) {
              return i.call(this, t3);
            }
          }
        }(t2);
      }
    }
    function _2(t2, e2) {
      this.fun = t2, this.array = e2;
    }
    function g() {
    }
    r.nextTick = function(t2) {
      var e2 = new Array(arguments.length - 1);
      if (arguments.length > 1)
        for (var n2 = 1; n2 < arguments.length; n2++)
          e2[n2 - 1] = arguments[n2];
      c.push(new _2(t2, e2)), 1 !== c.length || u || s(f);
    }, _2.prototype.run = function() {
      this.fun.apply(null, this.array);
    }, r.title = "browser", r.browser = true, r.env = {}, r.argv = [], r.version = "", r.versions = {}, r.on = g, r.addListener = g, r.once = g, r.off = g, r.removeListener = g, r.removeAllListeners = g, r.emit = g, r.prependListener = g, r.prependOnceListener = g, r.listeners = function(t2) {
      return [];
    }, r.binding = function(t2) {
      throw new Error("process.binding is not supported");
    }, r.cwd = function() {
      return "/";
    }, r.chdir = function(t2) {
      throw new Error("process.chdir is not supported");
    }, r.umask = function() {
      return 0;
    };
  }, function(t, e) {
    t.exports = function(t2, e2) {
      if (!e2)
        return true;
      if (t2._on_timeout)
        return false;
      var n = Math.ceil(1e3 / e2);
      return n < 2 || (setTimeout(function() {
        delete t2._on_timeout;
      }, n), t2._on_timeout = true, true);
    };
  }, function(t, e, n) {
    Object.defineProperty(e, "__esModule", { value: true });
    var i = function() {
      return function(t2) {
        var e2 = this;
        for (var n2 in this.addExtension = function(t3, n3) {
          e2._extensions[t3] = n3;
        }, this.getExtension = function(t3) {
          return e2._extensions[t3];
        }, this._extensions = {}, t2)
          this._extensions[n2] = t2[n2];
      };
    }();
    e.default = i;
  }, function(t, e, n) {
    var i = n(0);
    t.exports = function t2(e2, n2) {
      e2 = e2 || i.event, n2 = n2 || i.eventRemove;
      var r = [], a = { attach: function(t3, n3, i2, a2) {
        r.push({ element: t3, event: n3, callback: i2, capture: a2 }), e2(t3, n3, i2, a2);
      }, detach: function(t3, e3, i2, a2) {
        n2(t3, e3, i2, a2);
        for (var o = 0; o < r.length; o++) {
          var s = r[o];
          s.element === t3 && s.event === e3 && s.callback === i2 && s.capture === a2 && (r.splice(o, 1), o--);
        }
      }, detachAll: function() {
        for (var t3 = r.slice(), e3 = 0; e3 < t3.length; e3++) {
          var n3 = t3[e3];
          a.detach(n3.element, n3.event, n3.callback, n3.capture), a.detach(n3.element, n3.event, n3.callback, void 0), a.detach(n3.element, n3.event, n3.callback, false), a.detach(n3.element, n3.event, n3.callback, true);
        }
        r.splice(0, r.length);
      }, extend: function() {
        return t2(this.event, this.eventRemove);
      } };
      return a;
    };
  }, function(t, e, n) {
    Object.defineProperty(e, "__esModule", { value: true });
    var i = function() {
      function t2(t3) {
        this._gantt = t3;
      }
      return t2.prototype.isEqual = function(t3, e2, n2) {
        return !this._gantt._hasDuration(t3, e2, n2);
      }, t2.prototype.isFirstSmaller = function(t3, e2, n2) {
        return t3.valueOf() < e2.valueOf() && !this.isEqual(t3, e2, n2);
      }, t2.prototype.isSmallerOrDefault = function(t3, e2, n2) {
        return !(t3 && !this.isFirstSmaller(t3, e2, n2));
      }, t2.prototype.isGreaterOrDefault = function(t3, e2, n2) {
        return !(t3 && !this.isFirstSmaller(e2, t3, n2));
      }, t2;
    }();
    e.default = i;
  }, function(t, e, n) {
    var i = n(2);
    t.exports = function() {
      return { getVertices: function(t2) {
        for (var e2, n2 = {}, i2 = 0, r = t2.length; i2 < r; i2++)
          n2[(e2 = t2[i2]).target] = e2.target, n2[e2.source] = e2.source;
        var a, o = [];
        for (var i2 in n2)
          a = n2[i2], o.push(a);
        return o;
      }, topologicalSort: function(t2) {
        for (var e2 = this.getVertices(t2), n2 = {}, i2 = 0, r = e2.length; i2 < r; i2++)
          n2[e2[i2]] = { id: e2[i2], $source: [], $target: [], $incoming: 0 };
        for (i2 = 0, r = t2.length; i2 < r; i2++) {
          var a = n2[t2[i2].target];
          a.$target.push(i2), a.$incoming = a.$target.length, n2[t2[i2].source].$source.push(i2);
        }
        for (var o = e2.filter(function(t3) {
          return !n2[t3].$incoming;
        }), s = []; o.length; ) {
          var l = o.pop();
          s.push(l);
          var c = n2[l];
          for (i2 = 0; i2 < c.$source.length; i2++) {
            var u = n2[t2[c.$source[i2]].target];
            u.$incoming--, u.$incoming || o.push(u.id);
          }
        }
        return s;
      }, groupAdjacentEdges: function(t2) {
        for (var e2, n2 = {}, i2 = 0, r = t2.length; i2 < r; i2++)
          n2[(e2 = t2[i2]).source] || (n2[e2.source] = []), n2[e2.source].push(e2);
        return n2;
      }, tarjanStronglyConnectedComponents: function(t2, e2) {
        for (var n2 = {}, i2 = [], r = this.groupAdjacentEdges(e2), a = false, o = [], s = 0; s < t2.length; s++) {
          var l = g(t2[s]);
          if (!l.visited)
            for (var c = [l], u = 0; c.length; ) {
              var d = c.pop();
              d.visited || (d.index = u, d.lowLink = u, u++, i2.push(d), d.onStack = true, d.visited = true), a = false;
              e2 = r[d.id] || [];
              for (var h2 = 0; h2 < e2.length; h2++) {
                var f = g(e2[h2].target);
                if (f.edge = e2[h2], void 0 === f.index) {
                  c.push(d), c.push(f), a = true;
                  break;
                }
                f.onStack && (d.lowLink = Math.min(d.lowLink, f.index));
              }
              if (!a) {
                if (d.index == d.lowLink) {
                  for (var _2 = { tasks: [], links: [] }; (f = i2.pop()).onStack = false, _2.tasks.push(f.id), f.edge && _2.links.push(f.edge.id), f != d; )
                    ;
                  o.push(_2);
                }
                c.length && (f = d, (d = c[c.length - 1]).lowLink = Math.min(d.lowLink, f.lowLink));
              }
            }
        }
        return o;
        function g(t3) {
          return n2[t3] || (n2[t3] = { id: t3, onStack: false, index: void 0, lowLink: void 0, edge: void 0 }), n2[t3];
        }
      }, findLoops: function(t2) {
        var e2 = [];
        i.forEach(t2, function(t3) {
          t3.target == t3.source && e2.push([t3.target, t3.source]);
        });
        var n2 = this.getVertices(t2), r = this.tarjanStronglyConnectedComponents(n2, t2);
        return i.forEach(r, function(t3) {
          t3.tasks.length > 1 && e2.push(t3);
        }), e2;
      } };
    };
  }, function(t, e) {
    t.exports = function(t2) {
      t2._get_linked_task = function(e3, n2) {
        var i2 = null, r2 = n2 ? e3.target : e3.source;
        return t2.isTaskExists(r2) && (i2 = t2.getTask(r2)), i2;
      }, t2._get_link_target = function(e3) {
        return t2._get_linked_task(e3, true);
      }, t2._get_link_source = function(e3) {
        return t2._get_linked_task(e3, false);
      };
      var e2 = false, n = {}, i = {}, r = {}, a = {};
      t2._isLinksCacheEnabled = function() {
        return e2;
      }, t2._startLinksCache = function() {
        n = {}, i = {}, r = {}, a = {}, e2 = true;
      }, t2._endLinksCache = function() {
        n = {}, i = {}, r = {}, a = {}, e2 = false;
      }, t2._formatLink = function(i2) {
        if (e2 && n[i2.id])
          return n[i2.id];
        var r2 = [], a2 = this._get_link_target(i2), o = this._get_link_source(i2);
        if (!o || !a2)
          return r2;
        if (t2.isSummaryTask(a2) && t2.isChildOf(o.id, a2.id) || t2.isSummaryTask(o) && t2.isChildOf(a2.id, o.id))
          return r2;
        var s = t2.config.schedule_from_end && t2.config.project_end, l = t2.config.auto_scheduling_move_projects;
        !t2.config.auto_scheduling_compatibility && t2.config.auto_scheduling_strict && (l = false);
        for (var c = this.isSummaryTask(o) ? this.getSubtaskDates(o.id) : { start_date: o.start_date, end_date: o.end_date }, u = this._getImplicitLinks(i2, o, function(e3) {
          return l && s ? e3.$source.length || t2.getState("tasksDnd").drag_id == e3.id ? 0 : t2.calculateDuration({ start_date: e3.end_date, end_date: c.end_date, task: o }) : 0;
        }, true), d = this.isSummaryTask(a2) ? this.getSubtaskDates(a2.id) : { start_date: a2.start_date, end_date: a2.end_date }, h2 = this._getImplicitLinks(i2, a2, function(e3) {
          return !l || s ? 0 : e3.$target.length || t2.getState("tasksDnd").drag_id == e3.id ? 0 : t2.calculateDuration({ start_date: d.start_date, end_date: e3.start_date, task: o });
        }), f = 0, _2 = u.length; f < _2; f++)
          for (var g = u[f], p = 0, v2 = h2.length; p < v2; p++) {
            var m = h2[p], y = 1 * g.lag + 1 * m.lag, k2 = { id: i2.id, type: i2.type, source: g.task, target: m.task, subtaskLink: g.subtaskLink, lag: (1 * i2.lag || 0) + y };
            r2.push(t2._convertToFinishToStartLink(m.task, k2, o, a2, g.taskParent, m.taskParent));
          }
        return e2 && (n[i2.id] = r2), r2;
      }, t2._isAutoSchedulable = function(t3) {
        return false !== t3.auto_scheduling;
      }, t2._getImplicitLinks = function(e3, n2, i2, r2) {
        var a2 = [];
        if (this.isSummaryTask(n2)) {
          var o, s = {};
          for (var l in this.eachTask(function(t3) {
            this.isSummaryTask(t3) || (s[t3.id] = t3);
          }, n2.id), s) {
            var c = s[l], u = r2 ? c.$source : c.$target;
            o = false;
            for (var d = 0; d < u.length; d++) {
              var h2 = t2.getLink(u[d]), f = r2 ? h2.target : h2.source, _2 = s[f];
              if (_2 && false !== c.auto_scheduling && false !== _2.auto_scheduling && (h2.target == _2.id && Math.abs(h2.lag) <= _2.duration || h2.target == c.id && Math.abs(h2.lag) <= c.duration)) {
                o = true;
                break;
              }
            }
            o || a2.push({ task: c.id, taskParent: c.parent, lag: i2(c), subtaskLink: true });
          }
        } else
          a2.push({ task: n2.id, taskParent: n2.parent, lag: 0 });
        return a2;
      }, t2._getDirectDependencies = function(t3, e3) {
        for (var n2 = [], i2 = [], r2 = e3 ? t3.$source : t3.$target, a2 = 0; a2 < r2.length; a2++) {
          var o = this.getLink(r2[a2]);
          if (this.isTaskExists(o.source) && this.isTaskExists(o.target)) {
            var s = this.getTask(o.target);
            this._isAutoSchedulable(s) && n2.push(this.getLink(r2[a2]));
          }
        }
        for (a2 = 0; a2 < n2.length; a2++)
          i2 = i2.concat(this._formatLink(n2[a2]));
        return i2;
      }, t2._getInheritedDependencies = function(t3, n2) {
        var a2, o = false, s = [];
        return this.isTaskExists(t3.id) && this.eachParent(function(t4) {
          var l;
          o || (e2 && (a2 = n2 ? i : r)[t4.id] ? s = s.concat(a2[t4.id]) : this.isSummaryTask(t4) && (this._isAutoSchedulable(t4) ? (l = this._getDirectDependencies(t4, n2), e2 && (a2[t4.id] = l), s = s.concat(l)) : o = true));
        }, t3.id, this), s;
      }, t2._getDirectSuccessors = function(t3) {
        return this._getDirectDependencies(t3, true);
      }, t2._getInheritedSuccessors = function(t3) {
        return this._getInheritedDependencies(t3, true);
      }, t2._getDirectPredecessors = function(t3) {
        return this._getDirectDependencies(t3, false);
      }, t2._getInheritedPredecessors = function(t3) {
        return this._getInheritedDependencies(t3, false);
      }, t2._getSuccessors = function(t3, e3) {
        var n2 = this._getDirectSuccessors(t3);
        return e3 ? n2 : n2.concat(this._getInheritedSuccessors(t3));
      }, t2._getPredecessors = function(t3, n2) {
        var i2, r2 = String(t3.id) + "-" + String(n2);
        if (e2 && a[r2])
          return a[r2];
        var o = this._getDirectPredecessors(t3);
        return i2 = n2 ? o : o.concat(this._getInheritedPredecessors(t3)), e2 && (a[r2] = i2), i2;
      }, t2._convertToFinishToStartLink = function(e3, n2, i2, r2, a2, o) {
        var s = { target: e3, link: t2.config.links.finish_to_start, id: n2.id, lag: n2.lag || 0, sourceLag: 0, targetLag: 0, trueLag: n2.lag || 0, source: n2.source, preferredStart: null, sourceParent: a2, targetParent: o, hashSum: null, subtaskLink: n2.subtaskLink }, l = 0;
        switch (String(n2.type)) {
          case String(t2.config.links.start_to_start):
            l = -i2.duration, s.sourceLag = l;
            break;
          case String(t2.config.links.finish_to_finish):
            l = -r2.duration, s.targetLag = l;
            break;
          case String(t2.config.links.start_to_finish):
            l = -i2.duration - r2.duration, s.sourceLag = -i2.duration, s.targetLag = -r2.duration;
            break;
          default:
            l = 0;
        }
        return s.lag += l, s.hashSum = s.lag + "_" + s.link + "_" + s.source + "_" + s.target, s;
      };
    };
  }, function(t, e) {
    t.exports = function(t2) {
      var e2 = new RegExp("<(?:.|\n)*?>", "gm"), n = new RegExp(" +", "gm");
      function i(t3) {
        return (t3 + "").replace(e2, " ").replace(n, " ");
      }
      var r = new RegExp("'", "gm");
      function a(t3) {
        return (t3 + "").replace(r, "&#39;");
      }
      for (var o in t2._waiAria = { getAttributeString: function(t3) {
        var e3 = [" "];
        for (var n2 in t3) {
          var r2 = a(i(t3[n2]));
          e3.push(n2 + "='" + r2 + "'");
        }
        return e3.push(" "), e3.join(" ");
      }, getTimelineCellAttr: function(e3) {
        return t2._waiAria.getAttributeString({ "aria-label": e3 });
      }, _taskCommonAttr: function(e3, n2) {
        e3.start_date && e3.end_date && (n2.setAttribute("aria-label", i(t2.templates.tooltip_text(e3.start_date, e3.end_date, e3))), e3.$dataprocessor_class && n2.setAttribute("aria-busy", true), n2.setAttribute("aria-selected", t2.isSelectedTask(e3.id) ? "true" : "false"));
      }, setTaskBarAttr: function(e3, n2) {
        this._taskCommonAttr(e3, n2), !t2.isReadonly(e3) && t2.config.drag_move && (e3.id != t2.getState("tasksDnd").drag_id ? n2.setAttribute("aria-grabbed", false) : n2.setAttribute("aria-grabbed", true));
      }, taskRowAttr: function(e3, n2) {
        this._taskCommonAttr(e3, n2), !t2.isReadonly(e3) && t2.config.order_branch && n2.setAttribute("aria-grabbed", false), n2.setAttribute("role", "row"), n2.setAttribute("aria-level", e3.$level), t2.hasChild(e3.id) && n2.setAttribute("aria-expanded", e3.$open ? "true" : "false");
      }, linkAttr: function(e3, n2) {
        var r2 = t2.config.links, a2 = e3.type == r2.finish_to_start || e3.type == r2.start_to_start, o2 = e3.type == r2.start_to_start || e3.type == r2.start_to_finish, s = t2.locale.labels.link + " " + t2.templates.drag_link(e3.source, o2, e3.target, a2);
        n2.setAttribute("aria-label", i(s)), t2.isReadonly(e3) && n2.setAttribute("aria-readonly", true);
      }, gridSeparatorAttr: function(t3) {
        t3.setAttribute("role", "separator");
      }, lightboxHiddenAttr: function(t3) {
        t3.setAttribute("aria-hidden", "true");
      }, lightboxVisibleAttr: function(t3) {
        t3.setAttribute("aria-hidden", "false");
      }, lightboxAttr: function(t3) {
        t3.setAttribute("role", "dialog"), t3.setAttribute("aria-hidden", "true"), t3.firstChild.setAttribute("role", "heading");
      }, lightboxButtonAttrString: function(e3) {
        return this.getAttributeString({ role: "button", "aria-label": t2.locale.labels[e3], tabindex: "0" });
      }, lightboxHeader: function(t3, e3) {
        t3.setAttribute("aria-label", e3);
      }, lightboxSelectAttrString: function(e3) {
        var n2 = "";
        switch (e3) {
          case "%Y":
            n2 = t2.locale.labels.years;
            break;
          case "%m":
            n2 = t2.locale.labels.months;
            break;
          case "%d":
            n2 = t2.locale.labels.days;
            break;
          case "%H:%i":
            n2 = t2.locale.labels.hours + t2.locale.labels.minutes;
        }
        return t2._waiAria.getAttributeString({ "aria-label": n2 });
      }, lightboxDurationInputAttrString: function(e3) {
        return this.getAttributeString({ "aria-label": t2.locale.labels.column_duration, "aria-valuemin": "0" });
      }, gridAttrString: function() {
        return [" role='treegrid'", t2.config.multiselect ? "aria-multiselectable='true'" : "aria-multiselectable='false'", " "].join(" ");
      }, gridScaleRowAttrString: function() {
        return "role='row'";
      }, gridScaleCellAttrString: function(e3, n2) {
        var i2 = "";
        if ("add" == e3.name)
          i2 = this.getAttributeString({ role: "button", "aria-label": t2.locale.labels.new_task });
        else {
          var r2 = { role: "columnheader", "aria-label": n2 };
          t2._sort && t2._sort.name == e3.name && ("asc" == t2._sort.direction ? r2["aria-sort"] = "ascending" : r2["aria-sort"] = "descending"), i2 = this.getAttributeString(r2);
        }
        return i2;
      }, gridDataAttrString: function() {
        return "role='rowgroup'";
      }, gridCellAttrString: function(e3, n2, i2) {
        var r2 = { role: "gridcell", "aria-label": n2 };
        return e3.editor && !t2.isReadonly(i2) || (r2["aria-readonly"] = true), this.getAttributeString(r2);
      }, gridAddButtonAttrString: function(e3) {
        return this.getAttributeString({ role: "button", "aria-label": t2.locale.labels.new_task });
      }, messageButtonAttrString: function(t3) {
        return "tabindex='0' role='button' aria-label='" + t3 + "'";
      }, messageInfoAttr: function(t3) {
        t3.setAttribute("role", "alert");
      }, messageModalAttr: function(t3, e3) {
        t3.setAttribute("role", "dialog"), e3 && t3.setAttribute("aria-labelledby", e3);
      }, quickInfoAttr: function(t3) {
        t3.setAttribute("role", "dialog");
      }, quickInfoHeaderAttrString: function() {
        return " role='heading' ";
      }, quickInfoHeader: function(t3, e3) {
        t3.setAttribute("aria-label", e3);
      }, quickInfoButtonAttrString: function(e3) {
        return t2._waiAria.getAttributeString({ role: "button", "aria-label": e3, tabindex: "0" });
      }, tooltipAttr: function(t3) {
        t3.setAttribute("role", "tooltip");
      }, tooltipVisibleAttr: function(t3) {
        t3.setAttribute("aria-hidden", "false");
      }, tooltipHiddenAttr: function(t3) {
        t3.setAttribute("aria-hidden", "true");
      } }, t2._waiAria)
        t2._waiAria[o] = function(e3) {
          return function() {
            return t2.config.wai_aria_attributes ? e3.apply(this, arguments) : "";
          };
        }(t2._waiAria[o]);
    };
  }, function(t, e) {
    t.exports = function(t2) {
      t2._extend_to_optional = function(e2) {
        var n = e2, i = { render: n.render, focus: n.focus, set_value: function(e3, r, a, o) {
          var s = t2._resolve_default_mapping(o);
          if (!a[s.start_date] || "start_date" == s.start_date && this._isAllowedUnscheduledTask(a)) {
            i.disable(e3, o);
            var l = {};
            for (var c in s)
              l[s[c]] = a[c];
            return n.set_value.call(t2, e3, r, l, o);
          }
          return i.enable(e3, o), n.set_value.call(t2, e3, r, a, o);
        }, get_value: function(e3, i2, r) {
          return r.disabled ? { start_date: null } : n.get_value.call(t2, e3, i2, r);
        }, update_block: function(e3, n2) {
          if (t2.callEvent("onSectionToggle", [t2._lightbox_id, n2]), e3.style.display = n2.disabled ? "none" : "block", n2.button) {
            var i2 = e3.previousSibling.querySelector(".gantt_custom_button_label"), r = t2.locale.labels, a = n2.disabled ? r[n2.name + "_enable_button"] : r[n2.name + "_disable_button"];
            i2.innerHTML = a;
          }
          t2.resizeLightbox();
        }, disable: function(t3, e3) {
          e3.disabled = true, i.update_block(t3, e3);
        }, enable: function(t3, e3) {
          e3.disabled = false, i.update_block(t3, e3);
        }, button_click: function(e3, n2, r, a) {
          if (false !== t2.callEvent("onSectionButton", [t2._lightbox_id, r])) {
            var o = t2._get_typed_lightbox_config()[e3];
            o.disabled ? i.enable(a, o) : i.disable(a, o);
          }
        } };
        return i;
      }, t2.form_blocks.duration_optional = t2._extend_to_optional(t2.form_blocks.duration), t2.form_blocks.time_optional = t2._extend_to_optional(t2.form_blocks.time);
    };
  }, function(t, e, n) {
    var i = n(3);
    t.exports = function(t2) {
      var e2 = n(17)(t2);
      function r() {
        return e2.apply(this, arguments) || this;
      }
      return i(r, e2), r.prototype.render = function(n2) {
        var i2 = t2.config.types, r2 = t2.locale.labels, a = [], o = n2.filter || function(t3, e3) {
          return !i2.placeholder || e3 !== i2.placeholder;
        };
        for (var s in i2)
          false == !o(s, i2[s]) && a.push({ key: i2[s], label: r2["type_" + s] });
        n2.options = a;
        var l = n2.onchange;
        return n2.onchange = function() {
          t2.changeLightboxType(this.value), this.value === t2.config.types.task && (t2._lightbox_new_type = "task"), "function" == typeof l && l.apply(this, arguments);
        }, e2.prototype.render.apply(this, arguments);
      }, r;
    };
  }, function(t, e, n) {
    var i = n(3), r = n(16);
    t.exports = function(t2) {
      var e2 = n(5)(t2);
      function a() {
        return e2.apply(this, arguments) || this;
      }
      function o(e3) {
        return !e3 || e3 === t2.config.constraint_types.ASAP || e3 === t2.config.constraint_types.ALAP;
      }
      function s(t3, e3) {
        for (var n2 = o(e3), i2 = 0; i2 < t3.length; i2++)
          t3[i2].disabled = n2;
      }
      return i(a, e2), a.prototype.render = function(e3) {
        var n2 = (e3.height || 30) + "px", i2 = "<div class='gantt_cal_ltext gantt_section_" + e3.name + "' style='height:" + n2 + ";'>", a2 = [];
        for (var o2 in t2.config.constraint_types)
          a2.push({ key: t2.config.constraint_types[o2], label: t2.locale.labels[t2.config.constraint_types[o2]] });
        return e3.options = e3.options || a2, i2 += "<span data-constraint-type-select>" + r.getHtmlSelect(e3.options, [{ key: "data-type", value: "constraint-type" }]) + "</span>", i2 += "<label data-constraint-time-select>" + (t2.locale.labels.constraint_date || "Constraint date") + ": " + t2.form_blocks.getTimePicker.call(this, e3) + "</label>", i2 += "</div>";
      }, a.prototype.set_value = function(e3, n2, i2, r2) {
        var a2 = e3.querySelector("[data-constraint-type-select] select"), o2 = e3.querySelectorAll("[data-constraint-time-select] select"), l = r2._time_format_order, c = t2._resolve_default_mapping(r2);
        a2._eventsInitialized || (a2.addEventListener("change", function(t3) {
          s(o2, t3.target.value);
        }), a2._eventsInitialized = true);
        var u = i2[c.constraint_date] || /* @__PURE__ */ new Date();
        t2.form_blocks._fill_lightbox_select(o2, 0, u, l, r2);
        var d = i2[c.constraint_type] || t2.getConstraintType(i2);
        a2.value = d, s(o2, d);
      }, a.prototype.get_value = function(e3, n2, i2) {
        var r2 = e3.querySelector("[data-constraint-type-select] select"), a2 = e3.querySelectorAll("[data-constraint-time-select] select"), s2 = r2.value, l = null;
        return o(s2) || (l = t2.form_blocks.getTimePickerValue(a2, i2)), { constraint_type: s2, constraint_date: l };
      }, a.prototype.focus = function(e3) {
        t2._focus(e3.querySelector("select"));
      }, a;
    };
  }, function(t, e, n) {
    var i = n(2), r = n(1), a = n(16), o = n(3);
    t.exports = function(t2) {
      var e2 = n(5)(t2), s = { resources: {}, resourcesValues: {}, filter: {}, eventsInitialized: {}, changed: false };
      function l() {
        return e2.apply(this, arguments) || this;
      }
      function c(t3) {
        return void 0 === t3 ? ".gantt_resource_amount_input" : "[data-checked='" + (t3 ? "true" : "false") + "'] .gantt_resource_amount_input";
      }
      function u(t3) {
        return s.resources[t3.id];
      }
      function d(t3) {
        return s.filter[t3.id];
      }
      return t2.attachEvent("onAfterLightbox", function() {
        for (var t3 in s.filter)
          s.filter[t3].checkbox.checked = false, s.filter[t3].input.value = "", s.filter[t3].filterApplied = false;
        s.resourcesValues = {};
      }), o(l, e2), l.prototype.render = function(e3) {
        var n2, i2 = t2.locale.labels.resources_filter_placeholder || e3.filter_placeholder || "type to filter", r2 = t2.locale.labels.resources_filter_label || "hide empty";
        return n2 = "<div" + (isNaN(e3.height) ? "" : " style='height: " + e3.height + "px;'") + ">", n2 += "<div class='gantt_cal_ltext gantt_resources_filter'><input type='text' class='gantt_resources_filter_input' placeholder='" + i2 + "'> <label><input class='switch_unsetted' type='checkbox'><span class='matherial_checkbox_icon'></span>" + r2 + "</label></div>", n2 += "<div class='gantt_cal_ltext gantt_resources' data-name='" + e3.name + "'></div>", n2 += "</div>";
      }, l.prototype.set_value = function(e3, n2, o2, l2) {
        var h2, f = function(t3, e4) {
          s.resources[e4.id] || (s.resources[e4.id] = t3.querySelector(".gantt_resources"));
          return s.resources[e4.id];
        }(e3, l2), _2 = "";
        !function(t3, e4) {
          if (!s.filter[e4.id]) {
            var n3 = t3.querySelector(".gantt_resources_filter"), i2 = n3.querySelector(".gantt_resources_filter_input"), r2 = n3.querySelector(".switch_unsetted");
            s.filter[e4.id] = { container: n3, input: i2, checkbox: r2, filterApplied: false };
          }
          s.filter[e4.id];
        }(e3, l2), function(e4, n3, a2, o3) {
          if (s.eventsInitialized[a2.id])
            return;
          var l3 = function(r2) {
            var l4, c2, u2, h4, _3;
            f2(a2, e4);
            var g = d(a2);
            _3 = g.checkbox, h4 = g.input, u2 = _3.checked, c2 = function(t3) {
              return t3.value.trim();
            }(h4), g.filterApplied = !!c2, t2.getState().lightbox && (n3 = t2.getLightboxValues()), l4 = function(e5, n4, r3, a3) {
              var o4, l5;
              if (a3) {
                var c3 = n4[e5.map_to] || [];
                if (i.isArray(c3) || (c3 = [c3]), 0 === (c3 = c3.slice()).length) {
                  for (var u3 in c3 = [], (l5 = t2.copy(e5)).options = [], s.resourcesValues[e5.id])
                    "" !== s.resourcesValues[e5.id][u3] && c3.push({ resource_id: u3, value: s.resourcesValues[e5.id][u3] });
                  if (0 === c3.length)
                    return l5;
                } else
                  for (var u3 in s.resourcesValues[e5.id])
                    if ("" !== s.resourcesValues[e5.id][u3]) {
                      var d2 = i.arrayFind(c3, function(t3) {
                        return t3.id == u3;
                      });
                      d2 || c3.push({ resource_id: u3, value: s.resourcesValues[e5.id][u3] });
                    }
                for (var h5 = {}, f3 = 0; f3 < c3.length; f3++)
                  h5[c3[f3].resource_id] = true;
                o4 = function(t3) {
                  if (h5[String(t3.key)] && ("" === r3 || t3.label.toLowerCase().indexOf(r3.toLowerCase()) >= 0))
                    return t3;
                };
              } else {
                if ("" === r3)
                  return e5;
                o4 = function(t3) {
                  if (t3.label.toLowerCase().indexOf(r3.toLowerCase()) >= 0)
                    return t3;
                };
              }
              return (l5 = t2.copy(e5)).options = i.arrayFilter(l5.options, o4), l5;
            }(a2, n3, c2, u2);
            var p = n3[a2.map_to];
            o3.form_blocks.resources.set_value(e4, p, n3, l4);
          };
          function h3(e5) {
            var n4, i2, o4 = e5.target;
            if (s.changed = true, "checkbox" === e5.target.type) {
              n4 = o4.parentNode, (i2 = n4.querySelector(c())).disabled = !o4.checked;
              var l4 = i2.getAttribute("data-item-id"), u2 = r.locateClassName(e5, "gantt_resource_row"), d2 = u2.querySelector(".gantt_resource_amount_input");
              if (u2.setAttribute("data-checked", o4.checked), o4.checked) {
                "select" === i2.nodeName.toLowerCase() && t2.callEvent("onResourcesSelectActivated", [{ target: i2 }]);
                var h4 = l4, _3 = a2.default_value;
                a2.options.forEach(function(t3) {
                  t3.key == h4 && t3.default_value && (_3 = t3.default_value);
                }), d2 && !d2.value && void 0 !== _3 && (d2.value = _3, f2(a2, this)), d2.select ? d2.select() : d2.focus && d2.focus();
              } else
                s.resourcesValues[a2.id] && delete s.resourcesValues[a2.id][l4];
            } else
              "text" !== e5.target.type && "select" !== e5.target.nodeName.toLowerCase() || (n4 = o4.parentNode.parentNode, i2 = e5.target, f2(a2, this));
          }
          function f2(t3, e5) {
            var n4 = c(), i2 = e5.querySelectorAll(n4);
            s.resourcesValues[t3.id] = s.resourcesValues[t3.id] || {};
            for (var r2 = 0; r2 < i2.length; r2++) {
              var a3 = i2[r2].getAttribute("data-item-id");
              i2[r2].disabled ? delete s.resourcesValues[t3.id][a3] : s.resourcesValues[t3.id][a3] = i2[r2].value;
            }
          }
          l3 = i.throttle(l3, 100), d(a2).container.addEventListener("keyup", l3), d(a2).container.addEventListener("input", l3, true), d(a2).container.addEventListener("change", l3, true), u(a2).addEventListener("input", h3), u(a2).addEventListener("change", h3), t2.attachEvent("onResourcesSelectActivated", t2.bind(h3, u(a2))), s.eventsInitialized[a2.id] = true;
        }(e3, o2, l2, this), i.forEach(l2.options, function(t3, e4) {
          l2.unassigned_value != t3.key && (h2 = function(t4, e5, n3) {
            var r2 = {};
            if (e5) {
              var a2;
              i.isArray(e5) ? a2 = i.arrayFind(e5, function(t5) {
                return t5.resource_id == n3.key;
              }) : e5.resource_id == n3.key && (a2 = e5), a2 && (r2.value = a2.value);
            }
            s.resourcesValues[t4.id] && s.resourcesValues[t4.id][n3.key] && (r2.value = s.resourcesValues[t4.id][n3.key]);
            return r2;
          }(l2, n2, t3), _2 += ["<label class='gantt_resource_row' data-item-id='" + t3.key + "' data-checked=" + (h2.value ? "true" : "false") + ">", "<input class='gantt_resource_toggle' type='checkbox'", h2.value ? " checked='checked'" : "", "><div class='gantt_resource_cell gantt_resource_cell_checkbox'><span class='matherial_checkbox_icon'></span></div>", "<div class='gantt_resource_cell gantt_resource_cell_label'>", t3.label, "</div>", "<div class='gantt_resource_cell gantt_resource_cell_value'>", function(t4, e5, n3) {
            var i2, r2 = "";
            if (!t4)
              return;
            i2 = [{ key: "data-item-id", value: t4.key }, { key: "class", value: "gantt_resource_amount_input" }], n3 && i2.push({ key: "disabled", value: "disabled" });
            t4.options ? r2 += a.getHtmlSelect(t4.options, i2, e5) : (i2[i2.length] = { key: "value", value: e5 || "" }, r2 += a.getHtmlInput(i2));
            return r2;
          }(t3, h2.value, !h2.value), "</div>", "<div class='gantt_resource_cell gantt_resource_cell_unit'>", t3.unit, "</div>", "</label>"].join(""));
        }), f.innerHTML = _2, f.style.zoom = "1", f._offsetSizes = f.offsetHeight, f.style.zoom = "", t2.resizeLightbox(), t2._center_lightbox(t2.getLightbox()), s.changed = false;
      }, l.prototype.get_value = function(e3, n2, i2) {
        if (!s.changed)
          return n2[i2.map_to || t2.config.resource_property] || [];
        for (var r2 = u(i2), a2 = [], o2 = c(true), l2 = c(false), h2 = d(i2), f = t2.copy(s.resourcesValues[i2.id]) || {}, _2 = r2.querySelectorAll(o2), g = r2.querySelectorAll(l2), p = 0; p < g.length; p++)
          delete f[g[p].getAttribute("data-item-id")];
        for (p = 0; p < _2.length; p++) {
          var v2 = _2[p].getAttribute("data-item-id"), m = _2[p].value.trim();
          "" !== m && "0" !== m && (delete f[v2], a2[a2.length] = { resource_id: v2, value: m });
        }
        if (h2.filterApplied)
          for (var y in f)
            a2[a2.length] = { resource_id: y, value: f[y] };
        return a2;
      }, l.prototype.focus = function(e3) {
        t2._focus(e3.querySelector(".gantt_resources"));
      }, l;
    };
  }, function(t, e, n) {
    var i = n(3);
    t.exports = function(t2) {
      var e2 = n(17)(t2);
      function r() {
        return e2.apply(this, arguments) || this;
      }
      function a(e3, n2) {
        var i2 = [], r2 = [];
        n2 && (i2 = t2.getTaskByTime(), e3.allow_root && i2.unshift({ id: t2.config.root_id, text: e3.root_label || "" }), i2 = function(e4, n3, i3) {
          var r3 = n3.filter || function() {
            return true;
          };
          e4 = e4.slice(0);
          for (var a3 = 0; a3 < e4.length; a3++) {
            var o2 = e4[a3];
            (o2.id == i3 || t2.isChildOf(o2.id, i3) || false === r3(o2.id, o2)) && (e4.splice(a3, 1), a3--);
          }
          return e4;
        }(i2, e3, n2), e3.sort && i2.sort(e3.sort));
        for (var a2 = e3.template || t2.templates.task_text, o = 0; o < i2.length; o++) {
          var s = a2.apply(t2, [i2[o].start_date, i2[o].end_date, i2[o]]);
          void 0 === s && (s = ""), r2.push({ key: i2[o].id, label: s });
        }
        return e3.options = r2, e3.map_to = e3.map_to || "parent", t2.form_blocks.select.render.apply(this, arguments);
      }
      return i(r, e2), r.prototype.render = function(t3) {
        return a(t3, false);
      }, r.prototype.set_value = function(e3, n2, i2, r2) {
        0 === n2 && (n2 = "0");
        var o = document.createElement("div");
        o.innerHTML = a(r2, i2.id);
        var s = o.removeChild(o.firstChild);
        return e3.onselect = null, e3.parentNode.replaceChild(s, e3), t2.form_blocks.select.set_value.apply(t2, [s, n2, i2, r2]);
      }, r;
    };
  }, function(t, e, n) {
    Object.defineProperty(e, "__esModule", { value: true });
    var i = function() {
      function t2() {
        var t3 = this;
        this.canParse = function(e2) {
          return !isNaN(t3.parse(e2));
        }, this.format = function(t4) {
          return String(t4);
        }, this.parse = function(t4) {
          return parseInt(t4, 10);
        };
      }
      return t2.create = function(e2) {
        return new t2();
      }, t2;
    }();
    e.default = i;
  }, function(t, e, n) {
    var i = n(3), r = n(59).default;
    t.exports = function(t2) {
      var e2 = n(5)(t2);
      function a() {
        return e2.apply(this, arguments) || this;
      }
      function o(t3) {
        return t3.formatter || new r();
      }
      function s(e3, n2) {
        var i2 = e3.getElementsByTagName("select"), r2 = n2._time_format_order, a2 = 0, o2 = 0;
        if (t2.defined(r2[3])) {
          var s2 = i2[r2[3]], l2 = parseInt(s2.value, 10);
          isNaN(l2) && s2.hasAttribute("data-value") && (l2 = parseInt(s2.getAttribute("data-value"), 10)), a2 = Math.floor(l2 / 60), o2 = l2 % 60;
        }
        return new Date(i2[r2[2]].value, i2[r2[1]].value, i2[r2[0]].value, a2, o2);
      }
      function l(t3, e3) {
        var n2 = t3.getElementsByTagName("input")[1];
        return (n2 = o(e3).parse(n2.value)) && !window.isNaN(n2) || (n2 = 1), n2 < 0 && (n2 *= -1), n2;
      }
      return i(a, e2), a.prototype.render = function(e3) {
        var n2 = "<div class='gantt_time_selects'>" + t2.form_blocks.getTimePicker.call(this, e3) + "</div>", i2 = " " + t2.locale.labels[t2.config.duration_unit + "s"] + " ", r2 = e3.single_date ? " style='display:none'" : "", a2 = e3.readonly ? " disabled='disabled'" : "", o2 = t2._waiAria.lightboxDurationInputAttrString(e3), s2 = "gantt_duration_value";
        e3.formatter && (i2 = "", s2 += " gantt_duration_value_formatted");
        var l2 = "<div class='gantt_duration' " + r2 + "><input type='button' class='gantt_duration_dec' value='−'" + a2 + "><input type='text' value='5days' class='" + s2 + "'" + a2 + " " + o2 + "><input type='button' class='gantt_duration_inc' value='+'" + a2 + ">" + i2 + "<span></span></div>";
        return "<div style='height:" + (e3.height || 30) + "px;padding-top:0px;font-size:inherit;' class='gantt_section_time'>" + n2 + " " + l2 + "</div>";
      }, a.prototype.set_value = function(e3, n2, i2, r2) {
        var a2, c, u, d, h2 = e3.getElementsByTagName("select"), f = e3.getElementsByTagName("input"), _2 = f[1], g = [f[0], f[2]], p = e3.getElementsByTagName("span")[0], v2 = r2._time_format_order;
        function m() {
          var n3 = s.call(t2, e3, r2), a3 = l.call(t2, e3, r2), o2 = t2.calculateEndDate({ start_date: n3, duration: a3, task: i2 }), c2 = t2.templates.task_end_date || t2.templates.task_date;
          p.innerHTML = c2(o2);
        }
        function y(t3) {
          var e4 = _2.value;
          e4 = o(r2).parse(e4), window.isNaN(e4) && (e4 = 0), (e4 += t3) < 1 && (e4 = 1), _2.value = o(r2).format(e4), m();
        }
        g[0].onclick = t2.bind(function() {
          y(-1 * t2.config.duration_step);
        }, this), g[1].onclick = t2.bind(function() {
          y(1 * t2.config.duration_step);
        }, this), h2[0].onchange = m, h2[1].onchange = m, h2[2].onchange = m, h2[3] && (h2[3].onchange = m), _2.onkeydown = t2.bind(function(e4) {
          var n3;
          return (n3 = (e4 = e4 || window.event).charCode || e4.keyCode || e4.which) == t2.constants.KEY_CODES.DOWN ? (y(-1 * t2.config.duration_step), false) : n3 == t2.constants.KEY_CODES.UP ? (y(1 * t2.config.duration_step), false) : void window.setTimeout(m, 1);
        }, this), _2.onchange = t2.bind(m, this), "string" == typeof (a2 = t2._resolve_default_mapping(r2)) && (a2 = { start_date: a2 }), c = i2[a2.start_date] || /* @__PURE__ */ new Date(), u = i2[a2.end_date] || t2.calculateEndDate({ start_date: c, duration: 1, task: i2 }), d = Math.round(i2[a2.duration]) || t2.calculateDuration({ start_date: c, end_date: u, task: i2 }), d = o(r2).format(d), t2.form_blocks._fill_lightbox_select(h2, 0, c, v2, r2), _2.value = d, m();
      }, a.prototype.get_value = function(e3, n2, i2) {
        var r2 = s(e3, i2), a2 = l(e3, i2), o2 = t2.calculateEndDate({ start_date: r2, duration: a2, task: n2 });
        return "string" == typeof t2._resolve_default_mapping(i2) ? r2 : { start_date: r2, end_date: o2, duration: a2 };
      }, a.prototype.focus = function(e3) {
        t2._focus(e3.getElementsByTagName("select")[0]);
      }, a;
    };
  }, function(t, e, n) {
    var i = n(3);
    t.exports = function(t2) {
      var e2 = n(5)(t2);
      function r() {
        return e2.apply(this, arguments) || this;
      }
      return i(r, e2), r.prototype.render = function(t3) {
        var e3 = "<div class='gantt_cal_ltext' style='height:" + ((t3.height || "23") + "px") + ";'>";
        if (t3.options && t3.options.length)
          for (var n2 = 0; n2 < t3.options.length; n2++)
            e3 += "<label><input type='radio' value='" + t3.options[n2].key + "' name='" + t3.name + "'>" + t3.options[n2].label + "</label>";
        return e3 += "</div>";
      }, r.prototype.set_value = function(t3, e3, n2, i2) {
        var r2;
        i2.options && i2.options.length && (r2 = t3.querySelector("input[type=radio][value='" + e3 + "']") || t3.querySelector("input[type=radio][value='" + i2.default_value + "']")) && (!t3._dhx_onchange && i2.onchange && (t3.onchange = i2.onchange, t3._dhx_onchange = true), r2.checked = true);
      }, r.prototype.get_value = function(t3, e3) {
        var n2 = t3.querySelector("input[type=radio]:checked");
        return n2 ? n2.value : "";
      }, r.prototype.focus = function(e3) {
        t2._focus(e3.querySelector("input[type=radio]"));
      }, r;
    };
  }, function(t, e, n) {
    var i = n(2), r = n(3);
    t.exports = function(t2) {
      var e2 = n(5)(t2);
      function a() {
        return e2.apply(this, arguments) || this;
      }
      return r(a, e2), a.prototype.render = function(t3) {
        var e3 = "<div class='gantt_cal_ltext' style='height:" + ((t3.height || "23") + "px") + ";'>";
        if (t3.options && t3.options.length)
          for (var n2 = 0; n2 < t3.options.length; n2++)
            e3 += "<label><input type='checkbox' value='" + t3.options[n2].key + "' name='" + t3.name + "'>" + t3.options[n2].label + "</label>";
        else
          t3.single_value = true, e3 += "<label><input type='checkbox' name='" + t3.name + "'></label>";
        return e3 += "</div>";
      }, a.prototype.set_value = function(t3, e3, n2, r2) {
        var a2 = Array.prototype.slice.call(t3.querySelectorAll("input[type=checkbox]"));
        (!t3._dhx_onchange && r2.onchange && (t3.onchange = r2.onchange, t3._dhx_onchange = true), r2.single_value) ? a2[0].checked = !!e3 : i.forEach(a2, function(t4) {
          t4.checked = !!e3 && e3.indexOf(t4.value) >= 0;
        });
      }, a.prototype.get_value = function(t3, e3, n2) {
        return n2.single_value ? t3.querySelector("input[type=checkbox]").checked : i.arrayMap(Array.prototype.slice.call(t3.querySelectorAll("input[type=checkbox]:checked")), function(t4) {
          return t4.value;
        });
      }, a.prototype.focus = function(e3) {
        t2._focus(e3.querySelector("input[type=checkbox]"));
      }, a;
    };
  }, function(t, e, n) {
    var i = n(3);
    t.exports = function(t2) {
      var e2 = n(5)(t2);
      function r() {
        return e2.apply(this, arguments) || this;
      }
      return i(r, e2), r.prototype.render = function(e3) {
        var n2 = t2.form_blocks.getTimePicker.call(this, e3), i2 = "<div style='height:" + (e3.height || 30) + "px;padding-top:0px;font-size:inherit;text-align:center;' class='gantt_section_time'>";
        return i2 += n2, e3.single_date ? (n2 = t2.form_blocks.getTimePicker.call(this, e3, true), i2 += "<span></span>") : i2 += "<span style='font-weight:normal; font-size:10pt;'> &nbsp;&ndash;&nbsp; </span>", i2 += n2, i2 += "</div>";
      }, r.prototype.set_value = function(e3, n2, i2, r2) {
        var a = r2, o = e3.getElementsByTagName("select"), s = r2._time_format_order;
        if (a.auto_end_date)
          for (var l = function() {
            d = new Date(o[s[2]].value, o[s[1]].value, o[s[0]].value, 0, 0), h2 = t2.calculateEndDate({ start_date: d, duration: 1, task: i2 }), t2.form_blocks._fill_lightbox_select(o, s.size, h2, s, a);
          }, c = 0; c < 4; c++)
            o[c].onchange = l;
        var u = t2._resolve_default_mapping(r2);
        "string" == typeof u && (u = { start_date: u });
        var d = i2[u.start_date] || /* @__PURE__ */ new Date(), h2 = i2[u.end_date] || t2.calculateEndDate({ start_date: d, duration: 1, task: i2 });
        t2.form_blocks._fill_lightbox_select(o, 0, d, s, a), t2.form_blocks._fill_lightbox_select(o, s.size, h2, s, a);
      }, r.prototype.get_value = function(e3, n2, i2) {
        var r2, a = e3.getElementsByTagName("select"), o = i2._time_format_order;
        return r2 = t2.form_blocks.getTimePickerValue(a, i2), "string" == typeof t2._resolve_default_mapping(i2) ? r2 : { start_date: r2, end_date: function(e4, n3, r3) {
          var a2 = t2.form_blocks.getTimePickerValue(e4, i2, n3.size);
          return a2 <= r3 && (false !== i2.autofix_end || i2.single_date) ? t2.date.add(r3, t2._get_timepicker_step(), "minute") : a2;
        }(a, o, r2) };
      }, r.prototype.focus = function(e3) {
        t2._focus(e3.getElementsByTagName("select")[0]);
      }, r;
    };
  }, function(t, e, n) {
    var i = n(3);
    t.exports = function(t2) {
      var e2 = n(5)(t2);
      function r() {
        return e2.apply(this, arguments) || this;
      }
      return i(r, e2), r.prototype.render = function(t3) {
        return "<div class='gantt_cal_ltext' style='height:" + ((t3.height || "130") + "px") + ";'><textarea></textarea></div>";
      }, r.prototype.set_value = function(e3, n2) {
        t2.form_blocks.textarea._get_input(e3).value = n2 || "";
      }, r.prototype.get_value = function(e3) {
        return t2.form_blocks.textarea._get_input(e3).value;
      }, r.prototype.focus = function(e3) {
        var n2 = t2.form_blocks.textarea._get_input(e3);
        t2._focus(n2, true);
      }, r.prototype._get_input = function(t3) {
        return t3.querySelector("textarea");
      }, r;
    };
  }, function(t, e, n) {
    var i = n(3);
    t.exports = function(t2) {
      var e2 = n(5)(t2);
      function r() {
        return e2.apply(this, arguments) || this;
      }
      return i(r, e2), r.prototype.render = function(t3) {
        return "<div class='gantt_cal_ltext gantt_cal_template' style='height:" + ((t3.height || "30") + "px") + ";'></div>";
      }, r.prototype.set_value = function(t3, e3) {
        t3.innerHTML = e3 || "";
      }, r.prototype.get_value = function(t3) {
        return t3.innerHTML || "";
      }, r.prototype.focus = function() {
      }, r;
    };
  }, function(t, e, n) {
    function i(t2) {
      "@babel/helpers - typeof";
      return (i = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(t3) {
        return typeof t3;
      } : function(t3) {
        return t3 && "function" == typeof Symbol && t3.constructor === Symbol && t3 !== Symbol.prototype ? "symbol" : typeof t3;
      })(t2);
    }
    t.exports = function(t2) {
      var e2 = n(1), r = n(2), a = n(65)(t2), o = n(64)(t2), s = n(63)(t2), l = n(17)(t2), c = n(62)(t2), u = n(61)(t2), d = n(60)(t2), h2 = n(58)(t2), f = n(57)(t2), _2 = n(56)(t2), g = n(55)(t2);
      function p(e3, n2) {
        var i2, r2, a2 = "";
        for (r2 = 0; r2 < e3.length; r2++)
          i2 = t2.config._migrate_buttons[e3[r2]] ? t2.config._migrate_buttons[e3[r2]] : e3[r2], a2 += "<div " + t2._waiAria.lightboxButtonAttrString(i2) + " class='gantt_btn_set gantt_left_btn_set " + i2 + "_set'" + (n2 ? " style='float:right;'" : "") + "><div dhx_button='1' data-dhx-button='1' class='" + i2 + "'></div><div>" + t2.locale.labels[i2] + "</div></div>";
        return a2;
      }
      function v2(e3, n2, i2) {
        var r2, a2, o2, s2, l2, c2, u2 = "";
        switch (i2.timeFormat[n2]) {
          case "%Y":
            for (e3._time_format_order[2] = n2, e3._time_format_order.size++, e3.year_range && (isNaN(e3.year_range) ? e3.year_range.push && (o2 = e3.year_range[0], s2 = e3.year_range[1]) : r2 = e3.year_range), r2 = r2 || 10, a2 = a2 || Math.floor(r2 / 2), o2 = o2 || i2.date.getFullYear() - a2, s2 = s2 || o2 + r2, l2 = o2; l2 < s2; l2++)
              u2 += "<option value='" + l2 + "'>" + l2 + "</option>";
            break;
          case "%m":
            for (e3._time_format_order[1] = n2, e3._time_format_order.size++, l2 = 0; l2 < 12; l2++)
              u2 += "<option value='" + l2 + "'>" + t2.locale.date.month_full[l2] + "</option>";
            break;
          case "%d":
            for (e3._time_format_order[0] = n2, e3._time_format_order.size++, l2 = 1; l2 < 32; l2++)
              u2 += "<option value='" + l2 + "'>" + l2 + "</option>";
            break;
          case "%H:%i":
            for (e3._time_format_order[3] = n2, e3._time_format_order.size++, l2 = i2.first, c2 = i2.date.getDate(), e3._time_values = []; l2 < i2.last; )
              u2 += "<option value='" + l2 + "'>" + t2.templates.time_picker(i2.date) + "</option>", e3._time_values.push(l2), i2.date.setTime(i2.date.valueOf() + 60 * t2._get_timepicker_step() * 1e3), l2 = 24 * (i2.date.getDate() != c2 ? 1 : 0) * 60 + 60 * i2.date.getHours() + i2.date.getMinutes();
        }
        return u2;
      }
      t2._lightbox_methods = {}, t2._lightbox_template = "<div class='gantt_cal_ltitle'><span class='gantt_mark'>&nbsp;</span><span class='gantt_time'></span><span class='gantt_title'></span></div><div class='gantt_cal_larea'></div>", t2.$services.getService("state").registerProvider("lightbox", function() {
        return { lightbox: t2._lightbox_id };
      }), t2.showLightbox = function(t3) {
        if (this.callEvent("onBeforeLightbox", [t3])) {
          var e3 = this.getTask(t3), n2 = this.getLightbox(this.getTaskType(e3.type));
          this._center_lightbox(n2), this.showCover(), this._fill_lightbox(t3, n2), this._waiAria.lightboxVisibleAttr(n2), this.callEvent("onLightbox", [t3]);
        }
      }, t2._get_timepicker_step = function() {
        if (this.config.round_dnd_dates) {
          var e3;
          if (function(t3) {
            var e4 = t3.$ui.getView("timeline");
            return !(!e4 || !e4.isVisible());
          }(this)) {
            var n2 = t2.getScale();
            e3 = r.getSecondsInUnit(n2.unit) * n2.step / 60;
          }
          return (!e3 || e3 >= 1440) && (e3 = this.config.time_step), e3;
        }
        return this.config.time_step;
      }, t2.getLabel = function(t3, e3) {
        for (var n2 = this._get_typed_lightbox_config(), i2 = 0; i2 < n2.length; i2++)
          if (n2[i2].map_to == t3) {
            for (var r2 = n2[i2].options, a2 = 0; a2 < r2.length; a2++)
              if (r2[a2].key == e3)
                return r2[a2].label;
          }
        return "";
      }, t2.updateCollection = function(e3, n2) {
        n2 = n2.slice(0);
        var i2 = t2.serverList(e3);
        if (!i2)
          return false;
        i2.splice(0, i2.length), i2.push.apply(i2, n2 || []), t2.resetLightbox();
      }, t2.getLightboxType = function() {
        return this.getTaskType(this._lightbox_type);
      }, t2.getLightbox = function(e3) {
        var n2, i2, r2, a2, o2, s2 = "";
        if (void 0 === e3 && (e3 = this.getLightboxType()), !this._lightbox || this.getLightboxType() != this.getTaskType(e3)) {
          this._lightbox_type = this.getTaskType(e3), n2 = document.createElement("div"), s2 = "gantt_cal_light", i2 = this._is_lightbox_timepicker(), (t2.config.wide_form || i2) && (s2 += " gantt_cal_light_wide"), i2 && (t2.config.wide_form = true, s2 += " gantt_cal_light_full"), n2.className = s2, n2.style.visibility = "hidden", r2 = this._lightbox_template, r2 += p(this.config.buttons_left), r2 += p(this.config.buttons_right, true), n2.innerHTML = r2, t2._waiAria.lightboxAttr(n2), t2.config.drag_lightbox && (n2.firstChild.onmousedown = t2._ready_to_dnd, n2.firstChild.onselectstart = function() {
            return false;
          }, n2.firstChild.style.cursor = "pointer", t2._init_dnd_events()), document.body.insertBefore(n2, document.body.firstChild), this._lightbox = n2, a2 = this._get_typed_lightbox_config(e3), r2 = this._render_sections(a2);
          var l2 = (o2 = n2.querySelector("div.gantt_cal_larea")).style.overflow;
          o2.style.overflow = "hidden", o2.innerHTML = r2, function(e4) {
            var n3, i3, r3, a3, o3, s3;
            for (s3 = 0; s3 < e4.length; s3++)
              n3 = e4[s3], r3 = document.getElementById(n3.id), n3.id && r3 && (i3 = r3.querySelector("label"), (a3 = r3.nextSibling) && (o3 = a3.querySelector("input, select, textarea")) && (o3.id = o3.id || "input_" + t2.uid(), n3.inputId = o3.id, i3.setAttribute("for", n3.inputId)));
          }(a2), this.resizeLightbox(), o2.style.overflow = l2, this._init_lightbox_events(this), n2.style.display = "none", n2.style.visibility = "visible";
        }
        return this._lightbox;
      }, t2._render_sections = function(t3) {
        for (var e3 = "", n2 = 0; n2 < t3.length; n2++) {
          var i2 = this.form_blocks[t3[n2].type];
          if (i2) {
            t3[n2].id = "area_" + this.uid();
            var r2 = t3[n2].hidden ? " style='display:none'" : "", a2 = "";
            t3[n2].button && (a2 = "<div class='gantt_custom_button' data-index='" + n2 + "'><div class='gantt_custom_button_" + t3[n2].button + "'></div><div class='gantt_custom_button_label'>" + this.locale.labels["button_" + t3[n2].button] + "</div></div>"), this.config.wide_form && (e3 += "<div class='gantt_wrap_section' " + r2 + ">"), e3 += "<div id='" + t3[n2].id + "' class='gantt_cal_lsection'><label>" + a2 + this.locale.labels["section_" + t3[n2].name] + "</label></div>" + i2.render.call(this, t3[n2]), e3 += "</div>";
          }
        }
        return e3;
      }, t2.resizeLightbox = function() {
        if (this._lightbox) {
          var t3 = this._lightbox.querySelector(".gantt_cal_larea");
          t3.style.height = "0px", t3.style.height = t3.scrollHeight + "px", this._lightbox.style.height = t3.scrollHeight + this.config.lightbox_additional_height + "px", t3.style.height = t3.scrollHeight + "px";
        }
      }, t2._center_lightbox = function(t3) {
        if (t3) {
          t3.style.display = "block";
          var e3 = window.pageYOffset || document.body.scrollTop || document.documentElement.scrollTop, n2 = window.pageXOffset || document.body.scrollLeft || document.documentElement.scrollLeft, i2 = window.innerHeight || document.documentElement.clientHeight;
          t3.style.top = e3 ? Math.round(e3 + Math.max((i2 - t3.offsetHeight) / 2, 0)) + "px" : Math.round(Math.max((i2 - t3.offsetHeight) / 2, 0) + 9) + "px", document.documentElement.scrollWidth > document.body.offsetWidth ? t3.style.left = Math.round(n2 + (document.body.offsetWidth - t3.offsetWidth) / 2) + "px" : t3.style.left = Math.round((document.body.offsetWidth - t3.offsetWidth) / 2) + "px";
        }
      }, t2.showCover = function() {
        this._cover || (this._cover = document.createElement("DIV"), this._cover.className = "gantt_cal_cover", document.body.appendChild(this._cover));
      }, t2.event(window, "deviceorientation", function() {
        t2.getState().lightbox && t2._center_lightbox(t2.getLightbox());
      }), t2._init_lightbox_events = function() {
        t2.lightbox_events = {}, t2.lightbox_events.gantt_save_btn = function() {
          t2._save_lightbox();
        }, t2.lightbox_events.gantt_delete_btn = function() {
          t2._lightbox_new_type = null, t2.callEvent("onLightboxDelete", [t2._lightbox_id]) && (t2.isTaskExists(t2._lightbox_id) ? t2.$click.buttons.delete(t2._lightbox_id) : t2.hideLightbox());
        }, t2.lightbox_events.gantt_cancel_btn = function() {
          t2._cancel_lightbox();
        }, t2.lightbox_events.default = function(n2, i2) {
          if (i2.getAttribute("data-dhx-button"))
            t2.callEvent("onLightboxButton", [i2.className, i2, n2]);
          else {
            var r2, a2, o2 = e2.getClassName(i2);
            if (-1 != o2.indexOf("gantt_custom_button"))
              if (-1 != o2.indexOf("gantt_custom_button_"))
                for (r2 = i2.parentNode.getAttribute("data-index"), a2 = i2; a2 && -1 == e2.getClassName(a2).indexOf("gantt_cal_lsection"); )
                  a2 = a2.parentNode;
              else
                r2 = i2.getAttribute("data-index"), a2 = i2.parentNode, i2 = i2.firstChild;
            var s2 = t2._get_typed_lightbox_config();
            r2 && (r2 *= 1, t2.form_blocks[s2[1 * r2].type].button_click(r2, i2, a2, a2.nextSibling));
          }
        }, this.event(t2.getLightbox(), "click", function(n2) {
          var i2 = (n2 = n2 || window.event).target ? n2.target : n2.srcElement, r2 = e2.getClassName(i2);
          return r2 || (i2 = i2.previousSibling, r2 = e2.getClassName(i2)), i2 && r2 && 0 === r2.indexOf("gantt_btn_set") && (i2 = i2.firstChild, r2 = e2.getClassName(i2)), !(!i2 || !r2) && (t2.defined(t2.lightbox_events[i2.className]) ? t2.lightbox_events[i2.className] : t2.lightbox_events.default)(n2, i2);
        }), t2.getLightbox().onkeydown = function(n2) {
          var i2 = n2 || window.event, r2 = n2.target || n2.srcElement, a2 = e2.getClassName(r2).indexOf("gantt_btn_set") > -1;
          switch ((n2 || i2).keyCode) {
            case t2.constants.KEY_CODES.SPACE:
              if ((n2 || i2).shiftKey)
                return;
              a2 && r2.click && r2.click();
              break;
            case t2.keys.edit_save:
              if ((n2 || i2).shiftKey)
                return;
              a2 && r2.click ? r2.click() : t2._save_lightbox();
              break;
            case t2.keys.edit_cancel:
              t2._cancel_lightbox();
          }
        };
      }, t2._cancel_lightbox = function() {
        var e3 = this.getLightboxValues();
        this.callEvent("onLightboxCancel", [this._lightbox_id, e3.$new]), t2.isTaskExists(e3.id) && e3.$new && this.silent(function() {
          t2.$data.tasksStore.removeItem(e3.id), t2._update_flags(e3.id, null);
        }), this.refreshData(), this.hideLightbox();
      }, t2._save_lightbox = function() {
        var t3 = this.getLightboxValues();
        this.callEvent("onLightboxSave", [this._lightbox_id, t3, !!t3.$new]) && (t3.$new ? (delete t3.$new, this.addTask(t3, t3.parent, this.getTaskIndex(t3.id))) : this.isTaskExists(t3.id) && (this.mixin(this.getTask(t3.id), t3, true), this.refreshTask(t3.id), this.updateTask(t3.id)), this.refreshData(), this.hideLightbox());
      }, t2._resolve_default_mapping = function(t3) {
        var e3 = t3.map_to;
        return !{ time: true, time_optional: true, duration: true, duration_optional: true }[t3.type] ? "constraint" === t3.type && (t3.map_to && "string" != typeof t3.map_to || (e3 = { constraint_type: "constraint_type", constraint_date: "constraint_date" })) : "auto" == t3.map_to ? e3 = { start_date: "start_date", end_date: "end_date", duration: "duration" } : "string" == typeof t3.map_to && (e3 = { start_date: t3.map_to }), e3;
      }, t2.getLightboxValues = function() {
        var e3 = {};
        t2.isTaskExists(this._lightbox_id) && (e3 = this.mixin({}, this.getTask(this._lightbox_id)));
        for (var n2 = this._get_typed_lightbox_config(), r2 = 0; r2 < n2.length; r2++) {
          var a2 = document.getElementById(n2[r2].id);
          a2 = a2 ? a2.nextSibling : a2;
          var o2 = this.form_blocks[n2[r2].type];
          if (o2) {
            var s2 = o2.get_value.call(this, a2, e3, n2[r2]), l2 = t2._resolve_default_mapping(n2[r2]);
            if ("string" == typeof l2 && "auto" != l2)
              e3[l2] = s2;
            else if ("object" == i(l2))
              for (var c2 in l2)
                l2[c2] && (e3[l2[c2]] = s2[c2]);
          }
        }
        return "task" == t2._lightbox_new_type && (e3.type = t2.config.types.task, t2._lightbox_new_type = null), e3;
      }, t2.hideLightbox = function() {
        var t3 = this.getLightbox();
        t3 && (t3.style.display = "none"), this._waiAria.lightboxHiddenAttr(t3), this._lightbox_id = null, this.hideCover(), this.callEvent("onAfterLightbox", []);
      }, t2.hideCover = function() {
        this._cover && this._cover.parentNode.removeChild(this._cover), this._cover = null;
      }, t2.resetLightbox = function() {
        t2._lightbox && !t2._custom_lightbox && t2._lightbox.parentNode.removeChild(t2._lightbox), t2._lightbox = null, t2.hideCover();
      }, t2._set_lightbox_values = function(e3, n2) {
        var i2 = e3, r2 = n2.getElementsByTagName("span"), a2 = [];
        t2.templates.lightbox_header ? (a2.push(""), a2.push(t2.templates.lightbox_header(i2.start_date, i2.end_date, i2)), r2[1].innerHTML = "", r2[2].innerHTML = t2.templates.lightbox_header(i2.start_date, i2.end_date, i2)) : (a2.push(this.templates.task_time(i2.start_date, i2.end_date, i2)), a2.push(String(this.templates.task_text(i2.start_date, i2.end_date, i2) || "").substr(0, 70)), r2[1].innerHTML = this.templates.task_time(i2.start_date, i2.end_date, i2), r2[2].innerHTML = String(this.templates.task_text(i2.start_date, i2.end_date, i2) || "").substr(0, 70)), r2[1].innerHTML = a2[0], r2[2].innerHTML = a2[1], t2._waiAria.lightboxHeader(n2, a2.join(" "));
        for (var o2 = this._get_typed_lightbox_config(this.getLightboxType()), s2 = 0; s2 < o2.length; s2++) {
          var l2 = o2[s2];
          if (this.form_blocks[l2.type]) {
            var c2 = document.getElementById(l2.id).nextSibling, u2 = this.form_blocks[l2.type], d2 = t2._resolve_default_mapping(o2[s2]), h3 = this.defined(i2[d2]) ? i2[d2] : l2.default_value;
            u2.set_value.call(t2, c2, h3, i2, l2), l2.focus && u2.focus.call(t2, c2);
          }
        }
        t2.isTaskExists(e3.id) && (t2._lightbox_id = e3.id);
      }, t2._fill_lightbox = function(t3, e3) {
        var n2 = this.getTask(t3);
        this._set_lightbox_values(n2, e3);
      }, t2.getLightboxSection = function(e3) {
        for (var n2 = this._get_typed_lightbox_config(), i2 = 0; i2 < n2.length && n2[i2].name != e3; i2++)
          ;
        var r2 = n2[i2];
        if (!r2)
          return null;
        this._lightbox || this.getLightbox();
        var a2 = document.getElementById(r2.id), o2 = a2.nextSibling, s2 = { section: r2, header: a2, node: o2, getValue: function(e4) {
          return t2.form_blocks[r2.type].get_value.call(t2, o2, e4 || {}, r2);
        }, setValue: function(e4, n3) {
          return t2.form_blocks[r2.type].set_value.call(t2, o2, e4, n3 || {}, r2);
        } }, l2 = this._lightbox_methods["get_" + r2.type + "_control"];
        return l2 ? l2(s2) : s2;
      }, t2._lightbox_methods.get_template_control = function(t3) {
        return t3.control = t3.node, t3;
      }, t2._lightbox_methods.get_select_control = function(t3) {
        return t3.control = t3.node.getElementsByTagName("select")[0], t3;
      }, t2._lightbox_methods.get_textarea_control = function(t3) {
        return t3.control = t3.node.getElementsByTagName("textarea")[0], t3;
      }, t2._lightbox_methods.get_time_control = function(t3) {
        return t3.control = t3.node.getElementsByTagName("select"), t3;
      }, t2._init_dnd_events = function() {
        this.event(document.body, "mousemove", t2._move_while_dnd), this.event(document.body, "mouseup", t2._finish_dnd), t2._init_dnd_events = function() {
        };
      }, t2._move_while_dnd = function(e3) {
        if (t2._dnd_start_lb) {
          document.gantt_unselectable || (document.body.className += " gantt_unselectable", document.gantt_unselectable = true);
          var n2 = t2.getLightbox(), i2 = [e3.pageX, e3.pageY];
          n2.style.top = t2._lb_start[1] + i2[1] - t2._dnd_start_lb[1] + "px", n2.style.left = t2._lb_start[0] + i2[0] - t2._dnd_start_lb[0] + "px";
        }
      }, t2._ready_to_dnd = function(e3) {
        var n2 = t2.getLightbox();
        t2._lb_start = [parseInt(n2.style.left, 10), parseInt(n2.style.top, 10)], t2._dnd_start_lb = [e3.pageX, e3.pageY];
      }, t2._finish_dnd = function() {
        t2._lb_start && (t2._lb_start = t2._dnd_start_lb = false, document.body.className = document.body.className.replace(" gantt_unselectable", ""), document.gantt_unselectable = false);
      }, t2._focus = function(e3, n2) {
        if (e3 && e3.focus)
          if (t2.config.touch)
            ;
          else
            try {
              n2 && e3.select && e3.select(), e3.focus();
            } catch (t3) {
            }
      }, t2.form_blocks = { getTimePicker: function(e3, n2) {
        var i2, a2, o2, s2 = "", l2 = this.config, c2 = { first: 0, last: 1440, date: this.date.date_part(new Date(t2._min_date.valueOf())), timeFormat: function(e4) {
          var n3, i3, a3;
          if (e4.time_format)
            return e4.time_format;
          a3 = ["%d", "%m", "%Y"], n3 = t2.getScale(), i3 = n3 ? n3.unit : t2.config.duration_unit, r.getSecondsInUnit(i3) < r.getSecondsInUnit("day") && a3.push("%H:%i");
          return a3;
        }(e3) };
        for (e3._time_format_order = { size: 0 }, t2.config.limit_time_select && (c2.first = 60 * l2.first_hour, c2.last = 60 * l2.last_hour + 1, c2.date.setHours(l2.first_hour)), i2 = 0; i2 < c2.timeFormat.length; i2++)
          i2 > 0 && (s2 += " "), (a2 = v2(e3, i2, c2)) && (o2 = t2._waiAria.lightboxSelectAttrString(c2.timeFormat[i2]), s2 += "<select " + (e3.readonly ? "disabled='disabled'" : "") + (n2 ? " style='display:none' " : "") + o2 + ">" + a2 + "</select>");
        return s2;
      }, getTimePickerValue: function(e3, n2, i2) {
        var r2, a2 = n2._time_format_order, o2 = t2.defined(a2[3]), s2 = 0, l2 = 0, c2 = i2 || 0;
        return o2 && (r2 = parseInt(e3[a2[3] + c2].value, 10), s2 = Math.floor(r2 / 60), l2 = r2 % 60), new Date(e3[a2[2] + c2].value, e3[a2[1] + c2].value, e3[a2[0] + c2].value, s2, l2);
      }, _fill_lightbox_select: function(e3, n2, i2, r2) {
        if (e3[n2 + r2[0]].value = i2.getDate(), e3[n2 + r2[1]].value = i2.getMonth(), e3[n2 + r2[2]].value = i2.getFullYear(), t2.defined(r2[3])) {
          var a2 = 60 * i2.getHours() + i2.getMinutes();
          a2 = Math.round(a2 / t2._get_timepicker_step()) * t2._get_timepicker_step();
          var o2 = e3[n2 + r2[3]];
          o2.value = a2, o2.setAttribute("data-value", a2);
        }
      }, template: new a(), textarea: new o(), select: new l(), time: new s(), duration: new d(), parent: new h2(), radio: new u(), checkbox: new c(), resources: new f(), constraint: new _2(), typeselect: new g() }, t2._is_lightbox_timepicker = function() {
        for (var t3 = this._get_typed_lightbox_config(), e3 = 0; e3 < t3.length; e3++)
          if ("time" == t3[e3].name && "time" == t3[e3].type)
            return true;
        return false;
      }, t2._dhtmlx_confirm = function(e3, n2, i2, r2) {
        if (!e3)
          return i2();
        var a2 = { text: e3 };
        n2 && (a2.title = n2), r2 && (a2.ok = r2), i2 && (a2.callback = function(t3) {
          t3 && i2();
        }), t2.confirm(a2);
      }, t2._get_typed_lightbox_config = function(e3) {
        void 0 === e3 && (e3 = this.getLightboxType());
        var n2 = (function(t3) {
          for (var e4 in this.config.types)
            if (this.config.types[e4] == t3)
              return e4;
          return "task";
        }).call(this, e3);
        return t2.config.lightbox[n2 + "_sections"] ? t2.config.lightbox[n2 + "_sections"] : t2.config.lightbox.sections;
      }, t2._silent_redraw_lightbox = function(t3) {
        var e3 = this.getLightboxType();
        if (this.getState().lightbox) {
          var n2 = this.getState().lightbox, i2 = this.getLightboxValues(), r2 = this.copy(this.getTask(n2));
          this.resetLightbox();
          var a2 = this.mixin(r2, i2, true), o2 = this.getLightbox(t3 || void 0);
          this._center_lightbox(this.getLightbox()), this._set_lightbox_values(a2, o2), this.showCover();
        } else
          this.resetLightbox(), this.getLightbox(t3 || void 0);
        this.callEvent("onLightboxChange", [e3, this.getLightboxType()]);
      };
    };
  }, function(t, e) {
    t.exports = function(t2) {
      function e2(e3) {
        var n2 = e3.$config.scrollX ? t2.$ui.getView(e3.$config.scrollX) : null, i2 = e3.$config.scrollY ? t2.$ui.getView(e3.$config.scrollY) : null, r = { x: null, y: null };
        n2 && (n2.getScrollState().visible && (r.x = n2.$view.scrollLeft));
        i2 && (i2.getScrollState().visible && (r.y = i2.$view.scrollTop));
        return r;
      }
      function n() {
        var e3;
        return t2.$ui.getView("timeline") && (e3 = t2.$ui.getView("timeline")._tasks_dnd), e3;
      }
      t2.config.touch_drag = 500, t2.config.touch = true, t2.config.touch_feedback = true, t2.config.touch_feedback_duration = 1, t2._prevent_touch_scroll = false, t2._touch_feedback = function() {
        t2.config.touch_feedback && navigator.vibrate && navigator.vibrate(t2.config.touch_feedback_duration);
      }, t2.attachEvent("onGanttReady", t2.bind(function() {
        if ("force" != this.config.touch && (this.config.touch = this.config.touch && (-1 != navigator.userAgent.indexOf("Mobile") || -1 != navigator.userAgent.indexOf("iPad") || -1 != navigator.userAgent.indexOf("Android") || -1 != navigator.userAgent.indexOf("Touch")) || "MacIntel" === navigator.platform && navigator.maxTouchPoints > 1), this.config.touch) {
          var t3 = true;
          try {
            document.createEvent("TouchEvent");
          } catch (e3) {
            t3 = false;
          }
          t3 ? this._touch_events(["touchmove", "touchstart", "touchend"], function(t4) {
            return t4.touches && t4.touches.length > 1 ? null : t4.touches[0] ? { target: t4.target, pageX: t4.touches[0].pageX, pageY: t4.touches[0].pageY, clientX: t4.touches[0].clientX, clientY: t4.touches[0].clientY } : t4;
          }, function() {
            return false;
          }) : window.navigator.pointerEnabled ? this._touch_events(["pointermove", "pointerdown", "pointerup"], function(t4) {
            return "mouse" == t4.pointerType ? null : t4;
          }, function(t4) {
            return !t4 || "mouse" == t4.pointerType;
          }) : window.navigator.msPointerEnabled && this._touch_events(["MSPointerMove", "MSPointerDown", "MSPointerUp"], function(t4) {
            return t4.pointerType == t4.MSPOINTER_TYPE_MOUSE ? null : t4;
          }, function(t4) {
            return !t4 || t4.pointerType == t4.MSPOINTER_TYPE_MOUSE;
          });
        }
      }, t2));
      var i = [];
      t2._touch_events = function(r, a, o) {
        for (var s, l = 0, c = false, u = false, d = null, h2 = null, f = null, _2 = [], g = null, p = 0; p < i.length; p++)
          t2.eventRemove(i[p][0], i[p][1], i[p][2]);
        (i = []).push([t2.$container, r[0], function(i2) {
          var r2 = n();
          if (!o(i2) && c) {
            h2 && clearTimeout(h2);
            var f2 = a(i2);
            if (r2 && (r2.drag.id || r2.drag.start_drag))
              return r2.on_mouse_move(f2), i2.preventDefault && i2.preventDefault(), i2.cancelBubble = true, false;
            if (!t2._prevent_touch_scroll) {
              if (f2 && d) {
                var _3 = d.pageX - f2.pageX, p2 = d.pageY - f2.pageY;
                if (!u && (Math.abs(_3) > 5 || Math.abs(p2) > 5) && (u = true, l = 0, s = g ? e2(g) : t2.getScrollState()), u) {
                  var m, y = s.x + _3, k2 = s.y + p2;
                  if (g ? (!function(e3, n2, i3) {
                    var r3 = e3.$config.scrollX ? t2.$ui.getView(e3.$config.scrollX) : null, a2 = e3.$config.scrollY ? t2.$ui.getView(e3.$config.scrollY) : null;
                    r3 && r3.scrollTo(n2, null), a2 && a2.scrollTo(null, i3);
                  }(g, y, k2), m = e2(g)) : (t2.scrollTo(y, k2), m = t2.getScrollState()), s.x != m.x && p2 > 2 * _3 || s.y != m.y && _3 > 2 * p2)
                    return v2(i2);
                }
              }
              return v2(i2);
            }
            return true;
          }
        }]), i.push([this.$container, "contextmenu", function(t3) {
          if (c)
            return v2(t3);
        }]), i.push([this.$container, r[1], function(e3) {
          if (document && document.body && document.body.classList.add("gantt_touch_active"), !o(e3))
            if (e3.touches && e3.touches.length > 1)
              c = false;
            else {
              d = a(e3), g = function(e4) {
                for (var n2 = t2.$layout.getCellsByType("viewCell"), i3 = 0; i3 < n2.length; i3++) {
                  var r2 = n2[i3].$view.getBoundingClientRect();
                  if (e4.clientX >= r2.left && e4.clientX <= r2.right && e4.clientY <= r2.bottom && e4.clientY >= r2.top)
                    return n2[i3];
                }
              }(d), t2._locate_css(d, "gantt_hor_scroll") || t2._locate_css(d, "gantt_ver_scroll") || (c = true);
              var i2 = n();
              h2 = setTimeout(function() {
                var e4 = t2.locate(d);
                i2 && e4 && !t2._locate_css(d, "gantt_link_control") && !t2._locate_css(d, "gantt_grid_data") && (i2.on_mouse_down(d), i2.drag && i2.drag.start_drag && (!function(e5) {
                  var n2 = t2._getTaskLayers(), i3 = t2.getTask(e5);
                  if (i3 && t2.isTaskVisible(e5)) {
                    f = e5;
                    for (var r2 = 0; r2 < n2.length; r2++)
                      if ((i3 = n2[r2].rendered[e5]) && i3.getAttribute(t2.config.task_attribute) && i3.getAttribute(t2.config.task_attribute) == e5) {
                        var a2 = i3.cloneNode(true);
                        _2.push(i3), n2[r2].rendered[e5] = a2, i3.style.display = "none", a2.className += " gantt_drag_move ", i3.parentNode.appendChild(a2);
                      }
                  }
                }(e4), i2._start_dnd(d), t2._touch_drag = true, t2.refreshTask(e4), t2._touch_feedback())), h2 = null;
              }, t2.config.touch_drag);
            }
        }]), i.push([this.$container, r[2], function(e3) {
          if (document && document.body && document.body.classList.remove("gantt_touch_active"), !o(e3)) {
            h2 && clearTimeout(h2), t2._touch_drag = false, c = false;
            var i2 = a(e3), r2 = n();
            if (r2 && r2.on_mouse_up(i2), f && t2.isTaskExists(f) && (t2.refreshTask(f), _2.length && (_2.forEach(function(t3) {
              t3.parentNode && t3.parentNode.removeChild(t3);
            }), t2._touch_feedback())), c = u = false, _2 = [], f = null, d && l) {
              var s2 = /* @__PURE__ */ new Date();
              if (s2 - l < 500)
                t2.$services.getService("mouseEvents").onDoubleClick(d), v2(e3);
              else
                l = s2;
            } else
              l = /* @__PURE__ */ new Date();
          }
        }]);
        for (p = 0; p < i.length; p++)
          t2.event(i[p][0], i[p][1], i[p][2]);
        function v2(t3) {
          return t3 && t3.preventDefault && t3.preventDefault(), t3.cancelBubble = true, false;
        }
      };
    };
  }, function(t, e, n) {
    Object.defineProperty(e, "__esModule", { value: true });
    var i = n(7), r = n(4), a = ["ctrlKey", "altKey", "shiftKey", "metaKey"], o = [[{ unit: "month", date: "%M", step: 1 }, { unit: "day", date: "%d", step: 1 }], [{ unit: "day", date: "%d %M", step: 1 }], [{ unit: "day", date: "%d %M", step: 1 }, { unit: "hour", date: "%H:00", step: 8 }], [{ unit: "day", date: "%d %M", step: 1 }, { unit: "hour", date: "%H:00", step: 1 }]], s = function() {
      function t2(t3) {
        var e2 = this;
        this.zoomIn = function() {
          var t4 = e2.getCurrentLevel() - 1;
          t4 < 0 || e2.setLevel(t4);
        }, this.zoomOut = function() {
          var t4 = e2.getCurrentLevel() + 1;
          t4 > e2._levels.length - 1 || e2.setLevel(t4);
        }, this.getCurrentLevel = function() {
          return e2._activeLevelIndex;
        }, this.getLevels = function() {
          return e2._levels;
        }, this.setLevel = function(t4) {
          var n2 = e2._getZoomIndexByName(t4);
          -1 === n2 && e2.$gantt.assert(-1 !== n2, "Invalid zoom level for gantt.ext.zoom.setLevel. " + t4 + " is not an expected value."), e2._setLevel(n2, 0);
        }, this._getZoomIndexByName = function(t4) {
          var n2 = -1;
          if ("string" == typeof t4) {
            if (!isNaN(Number(t4)) && e2._levels[Number(t4)])
              n2 = Number(t4);
            else
              for (var i2 = 0; i2 < e2._levels.length; i2++)
                if (e2._levels[i2].name === t4) {
                  n2 = i2;
                  break;
                }
          } else
            n2 = t4;
          return n2;
        }, this._getVisibleDate = function() {
          var t4 = e2.$gantt.getScrollState().x, n2 = e2.$gantt.$task.offsetWidth;
          e2._visibleDate = e2.$gantt.dateFromPos(t4 + n2 / 2);
        }, this._setLevel = function(t4, n2) {
          e2._activeLevelIndex = t4;
          var i2 = e2.$gantt, r2 = i2.copy(e2._levels[e2._activeLevelIndex]), a2 = i2.copy(r2);
          if (delete a2.name, i2.mixin(i2.config, a2, true), !!i2.$root) {
            if (n2) {
              var o2 = e2.$gantt.dateFromPos(n2 + e2.$gantt.getScrollState().x);
              e2.$gantt.render();
              var s2 = e2.$gantt.posFromDate(o2);
              e2.$gantt.scrollTo(s2 - n2);
            } else {
              var l = e2.$gantt.$task.offsetWidth;
              e2._visibleDate || e2._getVisibleDate();
              var c = e2._visibleDate;
              e2.$gantt.render();
              s2 = e2.$gantt.posFromDate(c);
              e2.$gantt.scrollTo(s2 - l / 2);
            }
            e2.callEvent("onAfterZoom", [e2._activeLevelIndex, r2]);
          }
        }, this._attachWheelEvent = function(t4) {
          var n2, r2 = i.isFF ? "wheel" : "mousewheel";
          (n2 = "function" == typeof t4.element ? t4.element() : t4.element) && e2._domEvents.attach(n2, r2, e2.$gantt.bind(function(t5) {
            if (this._useKey) {
              if (a.indexOf(this._useKey) < 0)
                return false;
              if (!t5[this._useKey])
                return false;
            }
            if ("function" == typeof this._handler)
              return this._handler.apply(this, [t5]), true;
          }, e2), { passive: false });
        }, this._defaultHandler = function(t4) {
          var n2 = e2.$gantt.$task.getBoundingClientRect().x, i2 = t4.clientX - n2, r2 = false;
          (e2.$gantt.env.isFF ? -40 * t4.deltaY : t4.wheelDelta) > 0 && (r2 = true), t4.preventDefault(), t4.stopPropagation(), e2._setScaleSettings(r2, i2);
        }, this._setScaleDates = function() {
          e2._initialStartDate && e2._initialEndDate && (e2.$gantt.config.start_date = e2._initialStartDate, e2.$gantt.config.end_date = e2._initialEndDate);
        }, this.$gantt = t3, this._domEvents = this.$gantt._createDomEventScope();
      }
      return t2.prototype.init = function(t3) {
        var e2 = this;
        this.$gantt.env.isNode || (this._initialStartDate = t3.startDate, this._initialEndDate = t3.endDate, this._activeLevelIndex = t3.activeLevelIndex ? t3.activeLevelIndex : 0, this._levels = this._mapScales(t3.levels || o), this._handler = t3.handler || this._defaultHandler, this._minColumnWidth = t3.minColumnWidth || 60, this._maxColumnWidth = t3.maxColumnWidth || 240, this._widthStep = t3.widthStep || 3 / 8 * t3.minColumnWidth, this._useKey = t3.useKey, this._initialized || (r(this), this.$gantt.attachEvent("onGanttScroll", function() {
          e2._getVisibleDate();
        })), this._domEvents.detachAll(), "wheel" === t3.trigger && (this.$gantt.$root ? this._attachWheelEvent(t3) : this.$gantt.attachEvent("onGanttReady", function() {
          e2._attachWheelEvent(t3);
        })), this._initialized = true, this.setLevel(this._activeLevelIndex));
      }, t2.prototype._mapScales = function(t3) {
        return t3.map(function(t4) {
          return Array.isArray(t4) ? { scales: t4 } : t4;
        });
      }, t2.prototype._setScaleSettings = function(t3, e2) {
        t3 ? this._stepUp(e2) : this._stepDown(e2);
      }, t2.prototype._stepUp = function(t3) {
        if (!(this._activeLevelIndex >= this._levels.length - 1)) {
          var e2 = this._activeLevelIndex;
          if (this._setScaleDates(), this._widthStep) {
            var n2 = this.$gantt.config.min_column_width + this._widthStep;
            n2 > this._maxColumnWidth && (n2 = this._minColumnWidth, e2++), this.$gantt.config.min_column_width = n2;
          } else
            e2++;
          this._setLevel(e2, t3);
        }
      }, t2.prototype._stepDown = function(t3) {
        if (!(this._activeLevelIndex < 1)) {
          var e2 = this._activeLevelIndex;
          if (this._setScaleDates(), this._widthStep) {
            var n2 = this.$gantt.config.min_column_width - this._widthStep;
            n2 < this._minColumnWidth && (n2 = this._maxColumnWidth, e2--), this.$gantt.config.min_column_width = n2;
          } else
            e2--;
          this._setLevel(e2, t3);
        }
      }, t2;
    }();
    e.default = s;
  }, function(t, e) {
    window.dhtmlx && (window.dhtmlx.attaches || (window.dhtmlx.attaches = {}), window.dhtmlx.attaches.attachGantt = function(t2, e2, n) {
      var i = document.createElement("DIV");
      n = n || window.gantt, i.id = "gantt_" + n.uid(), i.style.width = "100%", i.style.height = "100%", i.cmp = "grid", document.body.appendChild(i), this.attachObject(i.id), this.dataType = "gantt", this.dataObj = n;
      var r = this.vs[this.av];
      r.grid = n, n.init(i.id, t2, e2), i.firstChild.style.border = "none", r.gridId = i.id, r.gridObj = i;
      return this.vs[this._viewRestore()].grid;
    }), void 0 !== window.dhtmlXCellObject && (window.dhtmlXCellObject.prototype.attachGantt = function(t2, e2, n) {
      n = n || window.gantt;
      var i = document.createElement("DIV");
      return i.id = "gantt_" + n.uid(), i.style.width = "100%", i.style.height = "100%", i.cmp = "grid", document.body.appendChild(i), this.attachObject(i.id), this.dataType = "gantt", this.dataObj = n, n.init(i.id, t2, e2), i.firstChild.style.border = "none", i = null, this.callEvent("_onContentAttach", []), this.dataObj;
    }), t.exports = null;
  }, function(t, e) {
    function n(t2) {
      "@babel/helpers - typeof";
      return (n = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(t3) {
        return typeof t3;
      } : function(t3) {
        return t3 && "function" == typeof Symbol && t3.constructor === Symbol && t3 !== Symbol.prototype ? "symbol" : typeof t3;
      })(t2);
    }
    window.jQuery && function(t2) {
      var e2 = [];
      t2.fn.dhx_gantt = function(i) {
        if ("string" != typeof (i = i || {})) {
          var r = [];
          return this.each(function() {
            if (this && this.getAttribute)
              if (this.gantt || window.gantt.$root == this)
                r.push("object" == n(this.gantt) ? this.gantt : window.gantt);
              else {
                var t3 = window.gantt.$container && window.Gantt ? window.Gantt.getGanttInstance() : window.gantt;
                for (var e3 in i)
                  "data" != e3 && (t3.config[e3] = i[e3]);
                t3.init(this), i.data && t3.parse(i.data), r.push(t3);
              }
          }), 1 === r.length ? r[0] : r;
        }
        if (e2[i])
          return e2[i].apply(this, []);
        t2.error("Method " + i + " does not exist on jQuery.dhx_gantt");
      };
    }(window.jQuery), t.exports = null;
  }, function(t, e, n) {
    var i = n(1), r = n(10);
    t.exports = function(t2) {
      var e2 = 50, n2 = 30, a = 10, o = 50, s = null, l = false, c = null, u = { started: false }, d = {};
      function h2(e3) {
        return e3 && i.isChildOf(e3, t2.$root) && e3.offsetHeight;
      }
      function f() {
        var e3 = !!document.querySelector(".gantt_drag_marker"), n3 = !!document.querySelector(".gantt_drag_marker.gantt_grid_resize_area") || !!document.querySelector(".gantt_drag_marker.gantt_row_grid_resize_area"), i2 = !!document.querySelector(".gantt_link_direction"), r2 = t2.getState(), a2 = r2.autoscroll;
        return l = e3 && !n3 && !i2, !(!r2.drag_mode && !e3 || n3) || a2;
      }
      function _2(e3) {
        if (c && (clearTimeout(c), c = null), e3) {
          var n3 = t2.config.autoscroll_speed;
          n3 && n3 < 10 && (n3 = 10), c = setTimeout(function() {
            s = setInterval(v2, n3 || o);
          }, t2.config.autoscroll_delay || a);
        }
      }
      function g(t3) {
        t3 ? (_2(true), u.started || (u.x = d.x, u.y = d.y, u.started = true)) : (s && (clearInterval(s), s = null), _2(false), u.started = false);
      }
      function p(e3) {
        var n3 = f();
        if (!s && !c || n3 || g(false), !t2.config.autoscroll || !n3)
          return false;
        d = { x: e3.clientX, y: e3.clientY }, "touchmove" == e3.type && (d.x = e3.targetTouches[0].clientX, d.y = e3.targetTouches[0].clientY), !s && n3 && g(true);
      }
      function v2() {
        if (!f())
          return g(false), false;
        var e3 = h2(t2.$task) ? t2.$task : h2(t2.$grid) ? t2.$grid : t2.$root;
        if (e3) {
          var r2 = i.getNodePosition(e3), a2 = d.x - r2.x, o2 = d.y - r2.y, s2 = l ? 0 : m(a2, r2.width, u.x - r2.x), c2 = m(o2, r2.height, u.y - r2.y), _3 = t2.getScrollState(), p2 = _3.y, v3 = _3.inner_height, y = _3.height, k2 = _3.x, b = _3.inner_width, w = _3.width;
          c2 && !v3 ? c2 = 0 : c2 < 0 && !p2 ? c2 = 0 : c2 > 0 && p2 + v3 >= y + 2 && (c2 = 0), s2 && !b ? s2 = 0 : s2 < 0 && !k2 ? s2 = 0 : s2 > 0 && k2 + b >= w && (s2 = 0);
          var x = t2.config.autoscroll_step;
          x && x < 2 && (x = 2), s2 *= x || n2, c2 *= x || n2, (s2 || c2) && function(e4, n3) {
            var i2 = t2.getScrollState(), r3 = null, a3 = null;
            e4 && (r3 = i2.x + e4, r3 = Math.min(i2.width, r3), r3 = Math.max(0, r3));
            n3 && (a3 = i2.y + n3, a3 = Math.min(i2.height, a3), a3 = Math.max(0, a3));
            t2.scrollTo(r3, a3);
          }(s2, c2);
        }
      }
      function m(t3, n3, i2) {
        return t3 - e2 < 0 && t3 < i2 ? -1 : t3 > n3 - e2 && t3 > i2 ? 1 : 0;
      }
      t2.attachEvent("onGanttReady", function() {
        r(t2) || (t2.eventRemove(document.body, "mousemove", p), t2.event(document.body, "mousemove", p), t2.eventRemove(document.body, "touchmove", p), t2.event(document.body, "touchmove", p), t2.eventRemove(document.body, "pointermove", p), t2.event(document.body, "pointermove", p));
      }), t2.attachEvent("onDestroy", function() {
        g(false);
      });
    };
  }, function(t, e, n) {
    t.exports = function(t2) {
      t2.ext || (t2.ext = {});
      for (var e2 = [n(71), n(70), n(69)], i = 0; i < e2.length; i++)
        e2[i] && e2[i](t2);
      var r = n(68).default;
      t2.ext.zoom = new r(t2);
    };
  }, function(t, e) {
    t.exports = function(t2) {
      t2.skins.contrast_white = { config: { grid_width: 360, row_height: 35, scale_height: 35, link_line_width: 2, link_arrow_size: 6, lightbox_additional_height: 75 }, _second_column_width: 100, _third_column_width: 80 };
    };
  }, function(t, e) {
    t.exports = function(t2) {
      t2.skins.contrast_black = { config: { grid_width: 360, row_height: 35, scale_height: 35, link_line_width: 2, link_arrow_size: 6, lightbox_additional_height: 75 }, _second_column_width: 100, _third_column_width: 80 };
    };
  }, function(t, e) {
    t.exports = function(t2) {
      t2.skins.material = { config: { grid_width: 411, row_height: 34, task_height_offset: 6, scale_height: 36, link_line_width: 2, link_arrow_size: 6, lightbox_additional_height: 80 }, _second_column_width: 110, _third_column_width: 75, _redefine_lightbox_buttons: { buttons_left: ["dhx_delete_btn"], buttons_right: ["dhx_save_btn", "dhx_cancel_btn"] } }, t2.attachEvent("onAfterTaskDrag", function(e2) {
        var n = t2.getTaskNode(e2);
        n && (n.className += " gantt_drag_animation", setTimeout(function() {
          var t3 = n.className.indexOf(" gantt_drag_animation");
          t3 > -1 && (n.className = n.className.slice(0, t3));
        }, 200));
      });
    };
  }, function(t, e) {
    t.exports = function(t2) {
      t2.skins.broadway = { config: { grid_width: 360, row_height: 35, scale_height: 35, link_line_width: 1, link_arrow_size: 7, lightbox_additional_height: 86 }, _second_column_width: 90, _third_column_width: 80, _lightbox_template: "<div class='gantt_cal_ltitle'><span class='gantt_mark'>&nbsp;</span><span class='gantt_time'></span><span class='gantt_title'></span><div class='gantt_cancel_btn'></div></div><div class='gantt_cal_larea'></div>", _config_buttons_left: {}, _config_buttons_right: { gantt_delete_btn: "icon_delete", gantt_save_btn: "icon_save" } };
    };
  }, function(t, e) {
    t.exports = function(t2) {
      t2.skins.terrace = { config: { grid_width: 360, row_height: 35, scale_height: 35, link_line_width: 2, link_arrow_size: 6, lightbox_additional_height: 75 }, _second_column_width: 90, _third_column_width: 70 };
    };
  }, function(t, e) {
    t.exports = function(t2) {
      t2.skins.meadow = { config: { grid_width: 350, row_height: 27, scale_height: 30, link_line_width: 2, link_arrow_size: 6, lightbox_additional_height: 72 }, _second_column_width: 95, _third_column_width: 80 };
    };
  }, function(t, e) {
    t.exports = function(t2) {
      t2.skins.skyblue = { config: { grid_width: 350, row_height: 27, scale_height: 27, link_line_width: 1, link_arrow_size: 8, lightbox_additional_height: 75 }, _second_column_width: 95, _third_column_width: 80 };
    };
  }, function(t, e) {
    function n(t2, e2) {
      var n2 = e2.skin;
      if (!n2 || t2)
        for (var i = document.getElementsByTagName("link"), r = 0; r < i.length; r++) {
          var a = i[r].href.match("dhtmlxgantt_([a-z_]+).css");
          if (a && (e2.skins[a[1]] || !n2)) {
            n2 = a[1];
            break;
          }
        }
      e2.skin = n2 || "terrace";
      var o = e2.skins[e2.skin] || e2.skins.terrace;
      !function(t3, e3, n3) {
        for (var i2 in e3)
          (void 0 === t3[i2] || n3) && (t3[i2] = e3[i2]);
      }(e2.config, o.config, t2);
      var s = e2.getGridColumns();
      s[1] && !e2.defined(s[1].width) && (s[1].width = o._second_column_width), s[2] && !e2.defined(s[2].width) && (s[2].width = o._third_column_width);
      for (r = 0; r < s.length; r++) {
        var l = s[r];
        "add" == l.name && (l.width || (l.width = 44), e2.defined(l.min_width) && e2.defined(l.max_width) || (l.min_width = l.min_width || l.width, l.max_width = l.max_width || l.width), l.min_width && (l.min_width = +l.min_width), l.max_width && (l.max_width = +l.max_width), l.width && (l.width = +l.width, l.width = l.min_width && l.min_width > l.width ? l.min_width : l.width, l.width = l.max_width && l.max_width < l.width ? l.max_width : l.width));
      }
      o.config.task_height && (e2.config.task_height = o.config.task_height || "full"), o.config.bar_height && (e2.config.bar_height = o.config.bar_height || "full"), o._lightbox_template && (e2._lightbox_template = o._lightbox_template), o._redefine_lightbox_buttons && (e2.config.buttons_right = o._redefine_lightbox_buttons.buttons_right, e2.config.buttons_left = o._redefine_lightbox_buttons.buttons_left), e2.resetLightbox();
    }
    t.exports = function(t2) {
      t2.resetSkin || (t2.resetSkin = function() {
        this.skin = "", n(true, this);
      }, t2.skins = {}, t2.attachEvent("onGanttLayoutReady", function() {
        n(false, this);
      }));
    };
  }, function(t, e) {
    t.exports = function() {
      function t2(t3) {
        return t3.$ui.getView("timeline");
      }
      function e2(t3) {
        return t3.$ui.getView("grid");
      }
      function n(t3) {
        return t3.$ui.getView("scrollVer");
      }
      function i(t3) {
        return t3.$ui.getView("scrollHor");
      }
      var r = "DEFAULT_VALUE";
      function a(t3, e3, n2, i2) {
        var a2 = t3(this);
        return a2 && a2.isVisible() ? a2[e3].apply(a2, n2) : i2 ? i2() : r;
      }
      return { getColumnIndex: function(t3) {
        var n2 = a.call(this, e2, "getColumnIndex", [t3]);
        return n2 === r ? 0 : n2;
      }, dateFromPos: function(e3) {
        var n2 = a.call(this, t2, "dateFromPos", Array.prototype.slice.call(arguments));
        return n2 === r ? this.getState().min_date : n2;
      }, posFromDate: function(e3) {
        var n2 = a.call(this, t2, "posFromDate", [e3]);
        return n2 === r ? 0 : n2;
      }, getRowTop: function(n2) {
        var i2 = this, o = a.call(i2, t2, "getRowTop", [n2], function() {
          return a.call(i2, e2, "getRowTop", [n2]);
        });
        return o === r ? 0 : o;
      }, getTaskTop: function(n2) {
        var i2 = this, o = a.call(i2, t2, "getItemTop", [n2], function() {
          return a.call(i2, e2, "getItemTop", [n2]);
        });
        return o === r ? 0 : o;
      }, getTaskPosition: function(e3, n2, i2) {
        var o = a.call(this, t2, "getItemPosition", [e3, n2, i2]);
        return o === r ? { left: 0, top: this.getTaskTop(e3.id), height: this.getTaskBarHeight(e3.id), width: 0 } : o;
      }, getTaskBarHeight: function(n2, i2) {
        var o = this, s = a.call(o, t2, "getBarHeight", [n2, i2], function() {
          return a.call(o, e2, "getItemHeight", [n2]);
        });
        return s === r ? 0 : s;
      }, getTaskHeight: function(n2) {
        var i2 = this, o = a.call(i2, t2, "getItemHeight", [n2], function() {
          return a.call(i2, e2, "getItemHeight", [n2]);
        });
        return o === r ? 0 : o;
      }, columnIndexByDate: function(e3) {
        var n2 = a.call(this, t2, "columnIndexByDate", [e3]);
        return n2 === r ? 0 : n2;
      }, roundTaskDates: function() {
        a.call(this, t2, "roundTaskDates", []);
      }, getScale: function() {
        var e3 = a.call(this, t2, "getScale", []);
        return e3 === r ? null : e3;
      }, getTaskNode: function(e3) {
        var n2 = t2(this);
        if (n2 && n2.isVisible()) {
          var i2 = n2._taskRenderer.rendered[e3];
          if (!i2) {
            var r2 = n2.$config.item_attribute;
            i2 = n2.$task_bars.querySelector("[" + r2 + "='" + e3 + "']");
          }
          return i2 || null;
        }
        return null;
      }, getLinkNode: function(e3) {
        var n2 = t2(this);
        return n2.isVisible() ? n2._linkRenderer.rendered[e3] : null;
      }, scrollTo: function(t3, e3) {
        var r2 = n(this), a2 = i(this), o = { position: 0 }, s = { position: 0 };
        r2 && (s = r2.getScrollState()), a2 && (o = a2.getScrollState());
        var l = a2 && 1 * t3 == t3, c = r2 && 1 * e3 == e3;
        if (l && c)
          for (var u = r2._getLinkedViews(), d = a2._getLinkedViews(), h2 = [], f = 0; f < u.length; f++)
            for (var _2 = 0; _2 < d.length; _2++)
              u[f].$config.id && u[_2].$config.id && u[f].$config.id === u[_2].$config.id && h2.push(u[f].$config.id);
        l && (h2 && h2.forEach((function(t4) {
          this.$ui.getView(t4).$config.$skipSmartRenderOnScroll = true;
        }).bind(this)), a2.scroll(t3), h2 && h2.forEach((function(t4) {
          this.$ui.getView(t4).$config.$skipSmartRenderOnScroll = false;
        }).bind(this))), c && r2.scroll(e3);
        var g = { position: 0 }, p = { position: 0 };
        r2 && (g = r2.getScrollState()), a2 && (p = a2.getScrollState()), this.callEvent("onGanttScroll", [o.position, s.position, p.position, g.position]);
      }, showDate: function(t3) {
        var e3 = this.posFromDate(t3), n2 = Math.max(e3 - this.config.task_scroll_offset, 0);
        this.scrollTo(n2);
      }, showTask: function(t3) {
        var e3 = this.getTaskPosition(this.getTask(t3)), n2 = e3.left;
        this.config.rtl && (n2 = e3.left + e3.width);
        var i2, r2 = Math.max(n2 - this.config.task_scroll_offset, 0), a2 = this._scroll_state().y;
        i2 = a2 ? e3.top - (a2 - this.getTaskBarHeight(t3)) / 2 : e3.top, this.scrollTo(r2, i2);
      }, _scroll_state: function() {
        var t3 = { x: false, y: false, x_pos: 0, y_pos: 0, scroll_size: this.config.scroll_size + 1, x_inner: 0, y_inner: 0 }, e3 = n(this), r2 = i(this);
        if (r2) {
          var a2 = r2.getScrollState();
          a2.visible && (t3.x = a2.size, t3.x_inner = a2.scrollSize), t3.x_pos = a2.position || 0;
        }
        if (e3) {
          var o = e3.getScrollState();
          o.visible && (t3.y = o.size, t3.y_inner = o.scrollSize), t3.y_pos = o.position || 0;
        }
        return t3;
      }, getScrollState: function() {
        var t3 = this._scroll_state();
        return { x: t3.x_pos, y: t3.y_pos, inner_width: t3.x, inner_height: t3.y, width: t3.x_inner, height: t3.y_inner };
      } };
    };
  }, function(t, e) {
    t.exports = function(t2) {
    };
  }, function(t, e, n) {
    var i = n(1), r = function(t2) {
      return { getVerticalScrollbar: function() {
        return t2.$ui.getView("scrollVer");
      }, getHorizontalScrollbar: function() {
        return t2.$ui.getView("scrollHor");
      }, _legacyGridResizerClass: function(t3) {
        for (var e2 = t3.getCellsByType("resizer"), n2 = 0; n2 < e2.length; n2++) {
          var i2 = e2[n2], r2 = false, a = i2.$parent.getPrevSibling(i2.$id);
          if (a && a.$config && "grid" === a.$config.id)
            r2 = true;
          else {
            var o = i2.$parent.getNextSibling(i2.$id);
            o && o.$config && "grid" === o.$config.id && (r2 = true);
          }
          r2 && (i2.$config.css = (i2.$config.css ? i2.$config.css + " " : "") + "gantt_grid_resize_wrap");
        }
      }, onCreated: function(e2) {
        var n2 = true;
        this._legacyGridResizerClass(e2), e2.attachEvent("onBeforeResize", function() {
          var r2 = t2.$ui.getView("timeline");
          r2 && (r2.$config.hidden = r2.$parent.$config.hidden = !t2.config.show_chart);
          var a = t2.$ui.getView("grid");
          if (a) {
            var o = a._getColsTotalWidth(), s = !t2.config.show_grid || !t2.config.grid_width || 0 === o;
            if (n2 && !s && false !== o && (t2.config.grid_width = o), a.$config.hidden = a.$parent.$config.hidden = s, !a.$config.hidden) {
              var l = a._getGridWidthLimits();
              if (l[0] && t2.config.grid_width < l[0] && (t2.config.grid_width = l[0]), l[1] && t2.config.grid_width > l[1] && (t2.config.grid_width = l[1]), r2 && t2.config.show_chart) {
                if (a.$config.width = t2.config.grid_width - 1, !a.$config.scrollable && a.$config.scrollY) {
                  var c = a.$gantt.$layout.$container.offsetWidth, u = t2.$ui.getView(a.$config.scrollY).$config.width, d = c - (a.$config.width + u);
                  d < 0 && (a.$config.width += d, t2.config.grid_width += d);
                }
                if (n2)
                  a.$parent.$config.width = t2.config.grid_width, a.$parent.$config.group && t2.$layout._syncCellSizes(a.$parent.$config.group, { value: a.$parent.$config.width, isGravity: false });
                else if (r2 && !i.isChildOf(r2.$task, e2.$view)) {
                  if (!a.$config.original_grid_width) {
                    var h2 = t2.skins[t2.skin];
                    h2 && h2.config && h2.config.grid_width ? a.$config.original_grid_width = h2.config.grid_width : a.$config.original_grid_width = 0;
                  }
                  t2.config.grid_width = a.$config.original_grid_width, a.$parent.$config.width = t2.config.grid_width;
                } else
                  a.$parent._setContentSize(a.$config.width, null), t2.$layout._syncCellSizes(a.$parent.$config.group, { value: t2.config.grid_width, isGravity: false });
              } else
                r2 && i.isChildOf(r2.$task, e2.$view) && (a.$config.original_grid_width = t2.config.grid_width), n2 || (a.$parent.$config.width = 0);
            }
            n2 = false;
          }
        }), this._initScrollStateEvents(e2);
      }, _initScrollStateEvents: function(e2) {
        t2._getVerticalScrollbar = this.getVerticalScrollbar, t2._getHorizontalScrollbar = this.getHorizontalScrollbar;
        var n2 = this.getVerticalScrollbar(), i2 = this.getHorizontalScrollbar();
        n2 && n2.attachEvent("onScroll", function(e3, n3, i3) {
          var r2 = t2.getScrollState();
          t2.callEvent("onGanttScroll", [r2.x, e3, r2.x, n3]);
        }), i2 && i2.attachEvent("onScroll", function(e3, n3, i3) {
          var r2 = t2.getScrollState();
          t2.callEvent("onGanttScroll", [e3, r2.y, n3, r2.y]);
          var a = t2.$ui.getView("grid");
          a && a.$grid_data && !a.$config.scrollable && (a.$grid_data.style.left = a.$grid.scrollLeft + "px", a.$grid_data.scrollLeft = a.$grid.scrollLeft);
        }), e2.attachEvent("onResize", function() {
          n2 && !t2.$scroll_ver && (t2.$scroll_ver = n2.$scroll_ver), i2 && !t2.$scroll_hor && (t2.$scroll_hor = i2.$scroll_hor);
        });
      }, _findGridResizer: function(t3, e2) {
        for (var n2, i2 = t3.getCellsByType("resizer"), r2 = true, a = 0; a < i2.length; a++) {
          var o = i2[a];
          o._getSiblings();
          var s = o._behind, l = o._front;
          if (s && s.$content === e2 || s.isChild && s.isChild(e2)) {
            n2 = o, r2 = true;
            break;
          }
          if (l && l.$content === e2 || l.isChild && l.isChild(e2)) {
            n2 = o, r2 = false;
            break;
          }
        }
        return { resizer: n2, gridFirst: r2 };
      }, onInitialized: function(e2) {
        var n2 = t2.$ui.getView("grid"), i2 = this._findGridResizer(e2, n2);
        if (i2.resizer) {
          var r2, a = i2.gridFirst, o = i2.resizer;
          if ("x" !== o.$config.mode)
            return;
          o.attachEvent("onResizeStart", function(e3, n3) {
            var i3 = t2.$ui.getView("grid"), o2 = i3 ? i3.$parent : null;
            if (o2) {
              var s = i3._getGridWidthLimits();
              i3.$config.scrollable || (o2.$config.minWidth = s[0]), o2.$config.maxWidth = s[1];
            }
            return r2 = a ? e3 : n3, t2.callEvent("onGridResizeStart", [r2]);
          }), o.attachEvent("onResize", function(e3, n3) {
            var i3 = a ? e3 : n3;
            return t2.callEvent("onGridResize", [r2, i3]);
          }), o.attachEvent("onResizeEnd", function(e3, n3, i3, r3) {
            var o2 = a ? e3 : n3, s = a ? i3 : r3, l = t2.$ui.getView("grid"), c = l ? l.$parent : null;
            c && (c.$config.minWidth = void 0);
            var u = t2.callEvent("onGridResizeEnd", [o2, s]);
            return u && 0 !== s && (t2.config.grid_width = s), u;
          });
        }
      }, onDestroyed: function(t3) {
      } };
    };
    t.exports = r;
  }, function(t, e, n) {
    var i = n(1), r = function(t2, e2) {
      var n2, r2, a, o, s, l = 10, c = 18;
      function u() {
        return { link_source_id: o, link_target_id: r2, link_from_start: s, link_to_start: a, link_landing_area: n2 };
      }
      var d = e2.$services, h2 = d.getService("state"), f = d.getService("dnd");
      h2.registerProvider("linksDnD", u);
      var _2 = new f(t2.$task_bars, { sensitivity: 0, updates_per_second: 60, mousemoveContainer: e2.$root, selector: ".gantt_link_point", preventDefault: true });
      function g(n3, i2, r3, a2, o2) {
        var s2 = function(n4, i3, r4) {
          var a3 = i3(n4), o3 = { x: a3.left, y: a3.top, width: a3.width, height: a3.height };
          r4.rtl ? (o3.xEnd = o3.x, o3.x = o3.xEnd + o3.width) : o3.xEnd = o3.x + o3.width;
          if (o3.yEnd = o3.y + o3.height, e2.getTaskType(n4.type) == e2.config.types.milestone) {
            var s3 = function(e3) {
              var n5 = t2.getBarHeight(e3, true);
              return Math.round(Math.sqrt(2 * n5 * n5)) - 2;
            }(n4.id);
            o3.x += (r4.rtl ? 1 : -1) * (s3 / 2), o3.xEnd += (r4.rtl ? -1 : 1) * (s3 / 2), o3.width = a3.xEnd - a3.x;
          }
          return o3;
        }(n3, function(t3) {
          return e2.getTaskPosition(t3);
        }, a2), l2 = { x: s2.x, y: s2.y };
        i2 || (l2.x = s2.xEnd), l2.y += e2.getTaskHeight(n3.id) / 2;
        var c2 = function(t3) {
          return e2.getTaskType(t3.type) == e2.config.types.milestone;
        }(n3) && o2 ? 2 : 0;
        return r3 = r3 || 0, a2.rtl && (r3 *= -1), l2.x += (i2 ? -1 : 1) * r3 - c2, l2;
      }
      function p(t3, n3) {
        var i2 = _2.getPosition(t3), r3 = function(t4) {
          var e3 = 0, n4 = 0;
          return t4 && (e3 = t4.offsetWidth || 0, n4 = t4.offsetHeight || 0), { width: e3, height: n4 };
        }(n3), a2 = function() {
          var t4 = e2.$root;
          return { right: t4.offsetWidth, bottom: t4.offsetHeight };
        }(), o2 = e2.config.tooltip_offset_x || l, s2 = e2.config.tooltip_offset_y || l, u2 = e2.config.scroll_size || c, d2 = { y: i2.y + s2, x: i2.x + o2, bottom: i2.y + r3.height + s2 + u2, right: i2.x + r3.width + o2 + u2 };
        return d2.bottom > a2.bottom && (d2.y = a2.bottom - r3.height - s2), d2.right > a2.right && (d2.x = a2.right - r3.width - o2), d2;
      }
      function v2(t3) {
        var n3 = u(), i2 = ["gantt_link_tooltip"];
        n3.link_source_id && n3.link_target_id && (e2.isLinkAllowed(n3.link_source_id, n3.link_target_id, n3.link_from_start, n3.link_to_start) ? i2.push("gantt_allowed_link") : i2.push("gantt_invalid_link"));
        var r3 = e2.templates.drag_link_class(n3.link_source_id, n3.link_from_start, n3.link_target_id, n3.link_to_start);
        r3 && i2.push(r3);
        var a2 = "<div class='" + r3 + "'>" + e2.templates.drag_link(n3.link_source_id, n3.link_from_start, n3.link_target_id, n3.link_to_start) + "</div>";
        t3.innerHTML = a2;
      }
      function m() {
        o = s = r2 = null, a = true;
      }
      function y(n3, i2, r3, a2) {
        var o2 = function() {
          _2._direction && _2._direction.parentNode || (_2._direction = document.createElement("div"), t2.$task_links.appendChild(_2._direction));
          return _2._direction;
        }(), s2 = u(), l2 = ["gantt_link_direction"];
        e2.templates.link_direction_class && l2.push(e2.templates.link_direction_class(s2.link_source_id, s2.link_from_start, s2.link_target_id, s2.link_to_start));
        var c2 = Math.sqrt(Math.pow(r3 - n3, 2) + Math.pow(a2 - i2, 2));
        if (c2 = Math.max(0, c2 - 3)) {
          o2.className = l2.join(" ");
          var d2 = (a2 - i2) / (r3 - n3), h3 = Math.atan(d2);
          2 == k2(n3, r3, i2, a2) ? h3 += Math.PI : 3 == k2(n3, r3, i2, a2) && (h3 -= Math.PI);
          var f2 = Math.sin(h3), g2 = Math.cos(h3), p2 = Math.round(i2), v3 = Math.round(n3), m2 = ["-webkit-transform: rotate(" + h3 + "rad)", "-moz-transform: rotate(" + h3 + "rad)", "-ms-transform: rotate(" + h3 + "rad)", "-o-transform: rotate(" + h3 + "rad)", "transform: rotate(" + h3 + "rad)", "width:" + Math.round(c2) + "px"];
          if (-1 != window.navigator.userAgent.indexOf("MSIE 8.0")) {
            m2.push('-ms-filter: "' + function(t3, e3) {
              return "progid:DXImageTransform.Microsoft.Matrix(M11 = " + e3 + ",M12 = -" + t3 + ",M21 = " + t3 + ",M22 = " + e3 + ",SizingMethod = 'auto expand')";
            }(f2, g2) + '"');
            var y2 = Math.abs(Math.round(n3 - r3)), b = Math.abs(Math.round(a2 - i2));
            switch (k2(n3, r3, i2, a2)) {
              case 1:
                p2 -= b;
                break;
              case 2:
                v3 -= y2, p2 -= b;
                break;
              case 3:
                v3 -= y2;
            }
          }
          m2.push("top:" + p2 + "px"), m2.push("left:" + v3 + "px"), o2.style.cssText = m2.join(";");
        }
      }
      function k2(t3, e3, n3, i2) {
        return e3 >= t3 ? i2 <= n3 ? 1 : 4 : i2 <= n3 ? 2 : 3;
      }
      _2.attachEvent("onBeforeDragStart", e2.bind(function(n3, r3) {
        var a2 = r3.target || r3.srcElement;
        if (m(), e2.getState("tasksDnd").drag_id)
          return false;
        if (i.locateClassName(a2, "gantt_link_point")) {
          i.locateClassName(a2, "task_start_date") && (s = true);
          var l2 = e2.locate(r3);
          o = l2;
          var c2 = e2.getTask(l2);
          if (e2.isReadonly(c2))
            return m(), false;
          return this._dir_start = g(c2, !!s, 0, t2.$getConfig(), true), true;
        }
        return false;
      }, this)), _2.attachEvent("onAfterDragStart", e2.bind(function(t3, n3) {
        e2.config.touch && e2.refreshData(), v2(_2.config.marker);
      }, this)), _2.attachEvent("onDragMove", e2.bind(function(o2, s2) {
        var l2 = _2.config, c2 = p(s2, l2.marker);
        !function(t3, e3) {
          t3.style.left = e3.x + "px", t3.style.top = e3.y + "px";
        }(l2.marker, c2);
        var u2 = !!i.locateClassName(s2, "gantt_link_control"), d2 = r2, h3 = n2, f2 = a, m2 = e2.locate(s2), k3 = true;
        if (i.isChildOf(s2.target || s2.srcElement, e2.$root) || (u2 = false, m2 = null), u2 && (k3 = !i.locateClassName(s2, "task_end_date"), u2 = !!m2), r2 = m2, n2 = u2, a = k3, u2) {
          var b = e2.getTask(m2), w = t2.$getConfig(), x = i.locateClassName(s2, "gantt_link_control"), S = 0;
          x && (S = Math.floor(x.offsetWidth / 2)), this._dir_end = g(b, !!a, S, w);
        } else
          this._dir_end = i.getRelativeEventPosition(s2, t2.$task_data), e2.env.isEdge && (this._dir_end.y += window.scrollY);
        var $ = !(h3 == u2 && d2 == m2 && f2 == k3);
        return $ && (d2 && e2.refreshTask(d2, false), m2 && e2.refreshTask(m2, false)), $ && v2(l2.marker), y(this._dir_start.x, this._dir_start.y, this._dir_end.x, this._dir_end.y), true;
      }, this)), _2.attachEvent("onDragEnd", e2.bind(function() {
        var t3 = u();
        if (t3.link_source_id && t3.link_target_id && t3.link_source_id != t3.link_target_id) {
          var n3 = e2._get_link_type(t3.link_from_start, t3.link_to_start), i2 = { source: t3.link_source_id, target: t3.link_target_id, type: n3 };
          i2.type && e2.isLinkAllowed(i2) && e2.callEvent("onLinkCreated", [i2]) && e2.addLink(i2);
        }
        m(), e2.config.touch ? e2.refreshData() : (t3.link_source_id && e2.refreshTask(t3.link_source_id, false), t3.link_target_id && e2.refreshTask(t3.link_target_id, false)), _2._direction && (_2._direction.parentNode && _2._direction.parentNode.removeChild(_2._direction), _2._direction = null);
      }, this)), e2.attachEvent("onGanttRender", e2.bind(function() {
        _2._direction && y(this._dir_start.x, this._dir_start.y, this._dir_end.x, this._dir_end.y);
      }, this));
    };
    t.exports = { createLinkDND: function() {
      return { init: r };
    } };
  }, function(t, e, n) {
    var i = n(1), r = n(0), a = n(47), o = n(2);
    t.exports = { createTaskDND: function() {
      var t2;
      return { extend: function(e2) {
        e2.roundTaskDates = function(e3) {
          t2.round_task_dates(e3);
        };
      }, init: function(e2, n2) {
        return t2 = function(t3, e3) {
          var n3 = e3.$services;
          return { drag: null, dragMultiple: {}, _events: { before_start: {}, before_finish: {}, after_finish: {} }, _handlers: {}, init: function() {
            this._domEvents = e3._createDomEventScope(), this.clear_drag_state();
            var t4 = e3.config.drag_mode;
            this.set_actions(), n3.getService("state").registerProvider("tasksDnd", r.bind(function() {
              return { drag_id: this.drag ? this.drag.id : void 0, drag_mode: this.drag ? this.drag.mode : void 0, drag_from_start: this.drag ? this.drag.left : void 0 };
            }, this));
            var i2 = { before_start: "onBeforeTaskDrag", before_finish: "onBeforeTaskChanged", after_finish: "onAfterTaskDrag" };
            for (var a2 in this._events)
              for (var o2 in t4)
                this._events[a2][o2] = i2[a2];
            this._handlers[t4.move] = this._move, this._handlers[t4.resize] = this._resize, this._handlers[t4.progress] = this._resize_progress;
          }, set_actions: function() {
            var n4 = t3.$task_data;
            this._domEvents.attach(n4, "mousemove", e3.bind(function(t4) {
              this.on_mouse_move(t4);
            }, this)), this._domEvents.attach(n4, "mousedown", e3.bind(function(t4) {
              this.on_mouse_down(t4);
            }, this)), this._domEvents.attach(document.body, "mouseup", e3.bind(function(t4) {
              this.on_mouse_up(t4);
            }, this));
          }, clear_drag_state: function() {
            this.drag = { id: null, mode: null, pos: null, start_x: null, start_y: null, obj: null, left: null }, this.dragMultiple = {};
          }, _resize: function(n4, i2, r2) {
            var a2 = t3.$getConfig(), o2 = this._drag_task_coords(n4, r2);
            r2.left ? (n4.start_date = e3.dateFromPos(o2.start + i2), n4.start_date || (n4.start_date = new Date(e3.getState().min_date))) : (n4.end_date = e3.dateFromPos(o2.end + i2), n4.end_date || (n4.end_date = new Date(e3.getState().max_date)));
            var s = this._calculateMinDuration(a2.min_duration, a2.duration_unit);
            n4.end_date - n4.start_date < a2.min_duration && (r2.left ? n4.start_date = e3.calculateEndDate(n4.end_date, -s, a2.duration_unit, n4) : n4.end_date = e3.calculateEndDate(n4.start_date, s, a2.duration_unit, n4)), e3._init_task_timing(n4);
          }, _calculateMinDuration: function(t4, e4) {
            return Math.ceil(t4 / { minute: 6e4, hour: 36e5, day: 864e5, week: 6048e5, month: 24192e5, year: 31356e6 }[e4]);
          }, _resize_progress: function(e4, n4, i2) {
            var r2 = this._drag_task_coords(e4, i2), a2 = t3.$getConfig().rtl ? r2.start - i2.pos.x : i2.pos.x - r2.start, o2 = Math.max(0, a2);
            e4.progress = Math.min(1, o2 / Math.abs(r2.end - r2.start));
          }, _find_max_shift: function(t4, n4) {
            var i2;
            for (var r2 in t4) {
              var a2 = t4[r2], o2 = e3.getTask(a2.id), s = this._drag_task_coords(o2, a2), l = e3.posFromDate(new Date(e3.getState().min_date)), c = e3.posFromDate(new Date(e3.getState().max_date));
              if (s.end + n4 > c) {
                var u = c - s.end;
                (u < i2 || void 0 === i2) && (i2 = u);
              } else if (s.start + n4 < l) {
                var d = l - s.start;
                (d > i2 || void 0 === i2) && (i2 = d);
              }
            }
            return i2;
          }, _move: function(t4, n4, i2) {
            var r2 = this._drag_task_coords(t4, i2), a2 = e3.dateFromPos(r2.start + n4), o2 = e3.dateFromPos(r2.end + n4);
            a2 ? o2 ? (t4.start_date = a2, t4.end_date = o2) : (t4.end_date = new Date(e3.getState().max_date), t4.start_date = e3.dateFromPos(e3.posFromDate(t4.end_date) - (r2.end - r2.start))) : (t4.start_date = new Date(e3.getState().min_date), t4.end_date = e3.dateFromPos(e3.posFromDate(t4.start_date) + (r2.end - r2.start)));
          }, _drag_task_coords: function(t4, n4) {
            return { start: n4.obj_s_x = n4.obj_s_x || e3.posFromDate(t4.start_date), end: n4.obj_e_x = n4.obj_e_x || e3.posFromDate(t4.end_date) };
          }, _mouse_position_change: function(t4, e4) {
            var n4 = t4.x - e4.x, i2 = t4.y - e4.y;
            return Math.sqrt(n4 * n4 + i2 * i2);
          }, _is_number: function(t4) {
            return !isNaN(parseFloat(t4)) && isFinite(t4);
          }, on_mouse_move: function(t4) {
            if (this.drag.start_drag) {
              var n4 = i.getRelativeEventPosition(t4, e3.$task_data), r2 = this.drag.start_drag.start_x, o2 = this.drag.start_drag.start_y;
              (Date.now() - this.drag.timestamp > 50 || this._is_number(r2) && this._is_number(o2) && this._mouse_position_change({ x: r2, y: o2 }, n4) > 20) && this._start_dnd(t4);
            }
            if (this.drag.mode) {
              if (!a(this, 40))
                return;
              this._update_on_move(t4);
            }
          }, _update_item_on_move: function(t4, n4, i2, r2, a2) {
            var o2 = e3.getTask(n4), s = e3.mixin({}, o2), l = e3.mixin({}, o2);
            this._handlers[i2].apply(this, [l, t4, r2]), e3.mixin(o2, l, true), e3.callEvent("onTaskDrag", [o2.id, i2, l, s, a2]), e3.mixin(o2, l, true), e3.refreshTask(n4);
          }, _update_on_move: function(n4) {
            var a2 = this.drag, o2 = t3.$getConfig();
            if (a2.mode) {
              var s = i.getRelativeEventPosition(n4, t3.$task_data);
              if (a2.pos && a2.pos.x == s.x)
                return;
              a2.pos = s;
              var l = e3.dateFromPos(s.x);
              if (!l || isNaN(l.getTime()))
                return;
              var c = s.x - a2.start_x, u = e3.getTask(a2.id);
              if (this._handlers[a2.mode]) {
                if (a2.mode === o2.drag_mode.move) {
                  var d = {};
                  this._isMultiselect() && e3.getSelectedTasks().indexOf(a2.id) >= 0 && (d = this.dragMultiple);
                  var h2 = false;
                  if (e3.isSummaryTask(u) && e3.config.drag_project) {
                    var f = {};
                    f[a2.id] = r.copy(a2), h2 = true, d = r.mixin(f, this.dragMultiple);
                  }
                  var _2 = this._find_max_shift(d, c);
                  for (var g in void 0 !== _2 && (c = _2), this._update_item_on_move(c, a2.id, a2.mode, a2, n4), d) {
                    var p = d[g];
                    h2 && p.id != a2.id && (e3._bulk_dnd = true), this._update_item_on_move(c, p.id, p.mode, p, n4);
                  }
                  e3._bulk_dnd = false;
                } else
                  this._update_item_on_move(c, a2.id, a2.mode, a2, n4);
                e3._update_parents(a2.id);
              }
            }
          }, on_mouse_down: function(n4, r2) {
            if (2 != n4.button || void 0 === n4.button) {
              var a2 = t3.$getConfig(), o2 = e3.locate(n4), s = null;
              if (e3.isTaskExists(o2) && (s = e3.getTask(o2)), !e3.isReadonly(s) && !this.drag.mode) {
                this.clear_drag_state(), r2 = r2 || n4.target || n4.srcElement;
                var l = i.getClassName(r2), c = this._get_drag_mode(l, r2);
                if (!l || !c)
                  return r2.parentNode ? this.on_mouse_down(n4, r2.parentNode) : void 0;
                if (c)
                  if (c.mode && c.mode != a2.drag_mode.ignore && a2["drag_" + c.mode]) {
                    if (o2 = e3.locate(r2), s = e3.copy(e3.getTask(o2) || {}), e3.isReadonly(s))
                      return this.clear_drag_state(), false;
                    if (e3.isSummaryTask(s) && !a2.drag_project && c.mode != a2.drag_mode.progress)
                      return void this.clear_drag_state();
                    c.id = o2;
                    var u = i.getRelativeEventPosition(n4, e3.$task_data);
                    c.start_x = u.x, c.start_y = u.y, c.obj = s, this.drag.start_drag = c, this.drag.timestamp = Date.now();
                  } else
                    this.clear_drag_state();
                else if (e3.checkEvent("onMouseDown") && e3.callEvent("onMouseDown", [l.split(" ")[0]]) && r2.parentNode)
                  return this.on_mouse_down(n4, r2.parentNode);
              }
            }
          }, _fix_dnd_scale_time: function(n4, i2) {
            var r2 = t3.$getConfig(), a2 = e3.getScale().unit, o2 = e3.getScale().step;
            function s(n5) {
              if (e3.config.correct_work_time) {
                var i3 = t3.$getConfig();
                e3.isWorkTime(n5.start_date, void 0, n5) || (n5.start_date = e3.calculateEndDate({ start_date: n5.start_date, duration: -1, unit: i3.duration_unit, task: n5 }));
              }
            }
            r2.round_dnd_dates || (a2 = "minute", o2 = r2.time_step), i2.mode == r2.drag_mode.resize ? i2.left ? (n4.start_date = e3.roundDate({ date: n4.start_date, unit: a2, step: o2 }), s(n4)) : (n4.end_date = e3.roundDate({ date: n4.end_date, unit: a2, step: o2 }), function(n5) {
              if (e3.config.correct_work_time) {
                var i3 = t3.$getConfig();
                e3.isWorkTime(new Date(n5.end_date - 1), void 0, n5) || (n5.end_date = e3.calculateEndDate({ start_date: n5.end_date, duration: 1, unit: i3.duration_unit, task: n5 }));
              }
            }(n4)) : i2.mode == r2.drag_mode.move && (n4.start_date = e3.roundDate({ date: n4.start_date, unit: a2, step: o2 }), s(n4), n4.end_date = e3.calculateEndDate(n4));
          }, _fix_working_times: function(n4, i2) {
            var r2 = t3.$getConfig();
            (i2 = i2 || { mode: r2.drag_mode.move }).mode == r2.drag_mode.resize ? i2.left ? n4.start_date = e3.getClosestWorkTime({ date: n4.start_date, dir: "future", task: n4 }) : n4.end_date = e3.getClosestWorkTime({ date: n4.end_date, dir: "past", task: n4 }) : i2.mode == r2.drag_mode.move && e3.correctTaskWorkTime(n4);
          }, _finalize_mouse_up: function(t4, n4, i2, r2) {
            var a2 = e3.getTask(t4);
            if (n4.work_time && n4.correct_work_time && this._fix_working_times(a2, i2), this._fix_dnd_scale_time(a2, i2), this._fireEvent("before_finish", i2.mode, [t4, i2.mode, e3.copy(i2.obj), r2])) {
              var o2 = t4;
              e3._init_task_timing(a2), this.clear_drag_state(), e3.updateTask(a2.id), this._fireEvent("after_finish", i2.mode, [o2, i2.mode, r2]);
            } else
              this.clear_drag_state(), t4 == i2.id && (i2.obj._dhx_changed = false, e3.mixin(a2, i2.obj, true)), e3.refreshTask(a2.id);
          }, on_mouse_up: function(n4) {
            var i2 = this.drag;
            if (i2.mode && i2.id) {
              var r2 = t3.$getConfig(), a2 = e3.getTask(i2.id), o2 = this.dragMultiple, s = false, l = 0;
              i2.mode === r2.drag_mode.move && (e3.isSummaryTask(a2) && r2.drag_project || this._isMultiselect()) && (s = true, l = Object.keys(o2).length);
              var c = function() {
                if (s)
                  for (var t4 in o2)
                    this._finalize_mouse_up(o2[t4].id, r2, o2[t4], n4);
                this._finalize_mouse_up(i2.id, r2, i2, n4);
              };
              s && l > 10 ? e3.batchUpdate((function() {
                c.call(this);
              }).bind(this)) : c.call(this);
            }
            this.clear_drag_state();
          }, _get_drag_mode: function(e4, n4) {
            var i2 = t3.$getConfig().drag_mode, r2 = { mode: null, left: null };
            switch ((e4 || "").split(" ")[0]) {
              case "gantt_task_line":
              case "gantt_task_content":
                r2.mode = i2.move;
                break;
              case "gantt_task_drag":
                r2.mode = i2.resize;
                var a2 = n4.getAttribute("data-bind-property");
                r2.left = "start_date" == a2;
                break;
              case "gantt_task_progress_drag":
                r2.mode = i2.progress;
                break;
              case "gantt_link_control":
              case "gantt_link_point":
                r2.mode = i2.ignore;
                break;
              default:
                r2 = null;
            }
            return r2;
          }, _start_dnd: function(n4) {
            var i2 = this.drag = this.drag.start_drag;
            delete i2.start_drag;
            var r2 = t3.$getConfig(), a2 = i2.id;
            if (r2["drag_" + i2.mode] && e3.callEvent("onBeforeDrag", [a2, i2.mode, n4]) && this._fireEvent("before_start", i2.mode, [a2, i2.mode, n4])) {
              delete i2.start_drag;
              var s = e3.getTask(a2);
              if (e3.isReadonly(s))
                return void this.clear_drag_state();
              if (this._isMultiselect()) {
                var l = e3.getSelectedTasks();
                l.indexOf(i2.id) >= 0 && o.forEach(l, e3.bind(function(t4) {
                  var n5 = e3.getTask(t4);
                  e3.isSummaryTask(n5) && e3.config.drag_project && i2.mode == r2.drag_mode.move && this._addSubtasksToDragMultiple(n5.id), this.dragMultiple[t4] = e3.mixin({ id: n5.id, obj: e3.copy(n5) }, this.drag);
                }, this));
              }
              e3.isSummaryTask(s) && e3.config.drag_project && i2.mode == r2.drag_mode.move && this._addSubtasksToDragMultiple(s.id), e3.callEvent("onTaskDragStart", []);
            } else
              this.clear_drag_state();
          }, _fireEvent: function(t4, n4, i2) {
            e3.assert(this._events[t4], "Invalid stage:{" + t4 + "}");
            var r2 = this._events[t4][n4];
            return e3.assert(r2, "Unknown after drop mode:{" + n4 + "}"), e3.assert(i2, "Invalid event arguments"), !e3.checkEvent(r2) || e3.callEvent(r2, i2);
          }, round_task_dates: function(e4) {
            var n4 = this.drag, i2 = t3.$getConfig();
            n4 || (n4 = { mode: i2.drag_mode.move }), this._fix_dnd_scale_time(e4, n4);
          }, destructor: function() {
            this._domEvents.detachAll();
          }, _isMultiselect: function() {
            return e3.config.drag_multiple && !!(e3.getSelectedTasks && e3.getSelectedTasks().length > 0);
          }, _addSubtasksToDragMultiple: function(t4) {
            e3.eachTask(function(t5) {
              this.dragMultiple[t5.id] = e3.mixin({ id: t5.id, obj: e3.copy(t5) }, this.drag);
            }, t4, this);
          } };
        }(e2, n2), e2._tasks_dnd = t2, t2.init(n2);
      }, destructor: function() {
        t2 && (t2.destructor(), t2 = null);
      } };
    } };
  }, function(t, e, n) {
    var i = n(0), r = n(85), a = n(84), o = n(1), s = function(t2) {
      var e2 = t2.$services;
      return { onCreated: function(e3) {
        var o2 = e3.$config;
        o2.bind = i.defined(o2.bind) ? o2.bind : "task", o2.bindLinks = i.defined(o2.bindLinks) ? o2.bindLinks : "link", e3._linksDnD = a.createLinkDND(), e3._tasksDnD = r.createTaskDND(), e3._tasksDnD.extend(e3), this._mouseDelegates = n(26)(t2);
      }, onInitialized: function(e3) {
        this._attachDomEvents(t2), this._attachStateProvider(t2, e3), e3._tasksDnD.init(e3, t2), e3._linksDnD.init(e3, t2), "timeline" == e3.$config.id && this.extendDom(e3);
      }, onDestroyed: function(e3) {
        this._clearDomEvents(t2), this._clearStateProvider(t2), e3._tasksDnD && e3._tasksDnD.destructor();
      }, extendDom: function(e3) {
        t2.$task = e3.$task, t2.$task_scale = e3.$task_scale, t2.$task_data = e3.$task_data, t2.$task_bg = e3.$task_bg, t2.$task_links = e3.$task_links, t2.$task_bars = e3.$task_bars;
      }, _clearDomEvents: function() {
        this._mouseDelegates.destructor(), this._mouseDelegates = null;
      }, _attachDomEvents: function(t3) {
        function e3(e4, n2) {
          if (e4 && this.callEvent("onLinkDblClick", [e4, n2])) {
            var i2 = this.getLink(e4);
            if (this.isReadonly(i2))
              return;
            var r2 = this.locale.labels.link + " " + this.templates.link_description(this.getLink(e4)) + " " + this.locale.labels.confirm_link_deleting;
            window.setTimeout(function() {
              t3._dhtmlx_confirm(r2, "", function() {
                t3.deleteLink(e4);
              });
            }, this.config.touch ? 300 : 1);
          }
        }
        this._mouseDelegates.delegate("click", "gantt_task_link", t3.bind(function(t4, e4) {
          var n2 = this.locate(t4, this.config.link_attribute);
          n2 && this.callEvent("onLinkClick", [n2, t4]);
        }, t3), this.$task), this._mouseDelegates.delegate("click", "gantt_scale_cell", t3.bind(function(e4, n2) {
          var i2 = o.getRelativeEventPosition(e4, t3.$task_data), r2 = t3.dateFromPos(i2.x), a2 = Math.floor(t3.columnIndexByDate(r2)), s2 = t3.getScale().trace_x[a2];
          t3.callEvent("onScaleClick", [e4, s2]);
        }, t3), this.$task), this._mouseDelegates.delegate("doubleclick", "gantt_task_link", t3.bind(function(n2, i2, r2) {
          i2 = this.locate(n2, t3.config.link_attribute), e3.call(this, i2, n2);
        }, t3), this.$task), this._mouseDelegates.delegate("doubleclick", "gantt_link_point", t3.bind(function(t4, n2, i2) {
          n2 = this.locate(t4);
          var r2 = this.getTask(n2), a2 = null;
          return i2.parentNode && o.getClassName(i2.parentNode) && (a2 = o.getClassName(i2.parentNode).indexOf("_left") > -1 ? r2.$target[0] : r2.$source[0]), a2 && e3.call(this, a2, t4), false;
        }, t3), this.$task);
      }, _attachStateProvider: function(t3, n2) {
        var i2 = n2;
        e2.getService("state").registerProvider("tasksTimeline", function() {
          return { scale_unit: i2._tasks ? i2._tasks.unit : void 0, scale_step: i2._tasks ? i2._tasks.step : void 0 };
        });
      }, _clearStateProvider: function() {
        e2.getService("state").unregisterProvider("tasksTimeline");
      } };
    };
    t.exports = s;
  }, function(t, e, n) {
    var i = n(1);
    function r(t2, e2) {
      var n2 = i.getNodePosition(e2.$grid_data);
      return t2.x += n2.x - e2.$grid.scrollLeft, t2.y += n2.y - e2.$grid_data.scrollTop, t2;
    }
    t.exports = { removeLineHighlight: function(t2) {
      t2.markerLine && t2.markerLine.parentNode && t2.markerLine.parentNode.removeChild(t2.markerLine), t2.markerLine = null;
    }, highlightPosition: function(t2, e2, n2) {
      var a = function(t3, e3) {
        var n3 = i.getNodePosition(e3.$grid_data), r2 = i.getRelativeEventPosition(t3, e3.$grid_data), a2 = n3.x, o2 = r2.y - 10, s = e3.getItemHeight(t3.targetId);
        o2 < n3.y && (o2 = n3.y);
        var l = e3.getTotalHeight();
        return o2 > n3.y + l - s && (o2 = n3.y + l - s), n3.x = a2, n3.y = o2, n3;
      }(t2, n2);
      e2.marker.style.left = a.x + 9 + "px", e2.marker.style.top = a.y + "px";
      var o = e2.markerLine;
      o || ((o = document.createElement("div")).className = "gantt_drag_marker gantt_grid_dnd_marker", o.innerHTML = "<div class='gantt_grid_dnd_marker_line'></div>", o.style.pointerEvents = "none"), t2.child ? function(t3, e3, n3) {
        var i2 = t3.targetParent, a2 = r({ x: 0, y: n3.getItemTop(i2) }, n3), o2 = n3.$grid_data.getBoundingClientRect().bottom;
        e3.innerHTML = "<div class='gantt_grid_dnd_marker_folder'></div>", e3.style.width = n3.$grid_data.offsetWidth + "px", e3.style.top = a2.y + "px", e3.style.left = a2.x + "px", e3.style.height = n3.getItemHeight(i2) + "px", a2.y > o2 && (e3.style.top = o2 + "px");
      }(t2, o, n2) : function(t3, e3, n3) {
        var i2 = function(t4, e4) {
          var n4 = e4.$config.rowStore, i3 = { x: 0, y: 0 }, a3 = e4.$grid_data.querySelector(".gantt_tree_indent"), o3 = 15, s = 0;
          if (a3 && (o3 = a3.offsetWidth), t4.targetId !== n4.$getRootId()) {
            var l = e4.getItemTop(t4.targetId), c = e4.getItemHeight(t4.targetId);
            if (s = n4.exists(t4.targetId) ? n4.calculateItemLevel(n4.getItem(t4.targetId)) : 0, t4.prevSibling)
              i3.y = l;
            else if (t4.nextSibling) {
              var u = 0;
              n4.eachItem(function(t5) {
                -1 !== n4.getIndexById(t5.id) && u++;
              }, t4.targetId), i3.y = l + c + u * c;
            } else
              i3.y = l + c, s += 1;
          }
          return i3.x = 40 + s * o3, i3.width = Math.max(e4.$grid_data.offsetWidth - i3.x, 0), r(i3, e4);
        }(t3, n3), a2 = n3.$grid_data.getBoundingClientRect().bottom;
        e3.innerHTML = "<div class='gantt_grid_dnd_marker_line'></div>", e3.style.left = i2.x + "px", e3.style.height = "4px";
        var o2 = i2.y - 2;
        e3.style.top = o2 + "px", e3.style.width = i2.width + "px", o2 > a2 && (e3.style.top = a2 + "px");
      }(t2, o, n2), e2.markerLine || (document.body.appendChild(o), e2.markerLine = o);
    } };
  }, function(t, e, n) {
    var i = n(18);
    t.exports = function(t2, e2, n2, r, a) {
      var o;
      if (e2 !== a.$getRootId())
        o = n2 < 0.25 ? i.prevSiblingTarget(t2, e2, a) : !(n2 > 0.6) || a.hasChild(e2) && a.getItem(e2).$open ? i.firstChildTarget(t2, e2, a) : i.nextSiblingTarget(t2, e2, a);
      else {
        var s = a.$getRootId();
        o = a.hasChild(s) && r >= 0 ? i.lastChildTarget(t2, s, a) : i.firstChildTarget(t2, s, a);
      }
      return o;
    };
  }, function(t, e, n) {
    var i = n(18);
    function r(t2, e2, n2, r2, a2) {
      for (var o2 = e2; r2.exists(o2); ) {
        var s = r2.calculateItemLevel(r2.getItem(o2));
        if ((s === n2 || s === n2 - 1) && r2.getBranchIndex(o2) > -1)
          break;
        o2 = a2 ? r2.getPrev(o2) : r2.getNext(o2);
      }
      return r2.exists(o2) ? r2.calculateItemLevel(r2.getItem(o2)) === n2 ? a2 ? i.nextSiblingTarget(t2, o2, r2) : i.prevSiblingTarget(t2, o2, r2) : i.firstChildTarget(t2, o2, r2) : null;
    }
    function a(t2, e2, n2, i2) {
      return r(t2, e2, n2, i2, true);
    }
    function o(t2, e2, n2, i2) {
      return r(t2, e2, n2, i2, false);
    }
    t.exports = function(t2, e2, n2, r2, s, l) {
      var c;
      if (e2 !== s.$getRootId()) {
        var u = s.getItem(e2), d = s.calculateItemLevel(u);
        if (d === l) {
          var h2 = s.getPrevSibling(e2);
          n2 < 0.5 && !h2 ? c = i.prevSiblingTarget(t2, e2, s) : (n2 < 0.5 && (e2 = h2), c = i.nextSiblingTarget(t2, e2, s));
        } else if (d > l)
          s.eachParent(function(t3) {
            s.calculateItemLevel(t3) === l && (e2 = t3.id);
          }, u), c = a(t2, e2, l, s);
        else {
          var f = a(t2, e2, l, s), _2 = o(t2, e2, l, s);
          c = n2 < 0.5 ? f : _2;
        }
      } else {
        var g = s.$getRootId(), p = s.getChildren(g);
        c = i.createDropTargetObject(), c = p.length && r2 >= 0 ? a(t2, function(t3) {
          for (var e3 = t3.getNext(); t3.exists(e3); ) {
            var n3 = t3.getNext(e3);
            if (!t3.exists(n3))
              return e3;
            e3 = n3;
          }
          return null;
        }(s), l, s) : o(t2, g, l, s);
      }
      return c;
    };
  }, function(t, e, n) {
    var i = n(1), r = n(18), a = n(89), o = n(88), s = n(87), l = n(11);
    t.exports = { init: function(t2, e2) {
      var n2 = t2.$services.getService("dnd");
      if (e2.$config.bind && t2.getDatastore(e2.$config.bind)) {
        var c = new n2(e2.$grid_data, { updates_per_second: 60 });
        t2.defined(e2.$getConfig().dnd_sensitivity) && (c.config.sensitivity = e2.$getConfig().dnd_sensitivity), c.attachEvent("onBeforeDragStart", t2.bind(function(n3, r2) {
          var a2 = u(r2);
          if (!a2)
            return false;
          if (t2.hideQuickInfo && t2._hideQuickInfo(), i.closest(r2.target, ".gantt_grid_editor_placeholder"))
            return false;
          var o2 = a2.getAttribute(e2.$config.item_attribute), s2 = e2.$config.rowStore.getItem(o2);
          return !t2.isReadonly(s2) && !d(o2) && (c.config.initial_open_state = s2.$open, !!t2.callEvent("onRowDragStart", [o2, r2.target || r2.srcElement, r2]) && void 0);
        }, t2)), c.attachEvent("onAfterDragStart", t2.bind(function(t3, n3) {
          var i2 = u(n3);
          c.config.marker.innerHTML = i2.outerHTML;
          var a2 = c.config.marker.firstChild;
          a2 && (c.config.marker.style.opacity = 0.4, a2.style.position = "static", a2.style.pointerEvents = "none"), c.config.id = i2.getAttribute(e2.$config.item_attribute);
          var o2 = e2.$config.rowStore, s2 = o2.getItem(c.config.id);
          c.config.level = o2.calculateItemLevel(s2), c.config.drop_target = r.createDropTargetObject({ targetParent: o2.getParent(s2.id), targetIndex: o2.getBranchIndex(s2.id), targetId: s2.id, nextSibling: true }), s2.$open = false, s2.$transparent = true, this.refreshData();
        }, t2)), c.attachEvent("onDragMove", t2.bind(function(n3, i2) {
          var a2 = h2(i2);
          return a2 && false !== t2.callEvent("onBeforeRowDragMove", [c.config.id, a2.targetParent, a2.targetIndex]) || (a2 = r.createDropTargetObject(c.config.drop_target)), s.highlightPosition(a2, c.config, e2), c.config.drop_target = a2, this.callEvent("onRowDragMove", [c.config.id, a2.targetParent, a2.targetIndex]), true;
        }, t2)), c.attachEvent("onDragEnd", t2.bind(function() {
          var n3 = e2.$config.rowStore, i2 = n3.getItem(c.config.id);
          s.removeLineHighlight(c.config), i2.$transparent = false, i2.$open = c.config.initial_open_state;
          var r2 = c.config.drop_target;
          false === this.callEvent("onBeforeRowDragEnd", [c.config.id, r2.targetParent, r2.targetIndex]) ? i2.$drop_target = null : (n3.move(c.config.id, r2.targetIndex, r2.targetParent), t2.render(), this.callEvent("onRowDragEnd", [c.config.id, r2.targetParent, r2.targetIndex])), n3.refresh(i2.id);
        }, t2));
      }
      function u(t3) {
        return i.locateAttribute(t3, e2.$config.item_attribute);
      }
      function d(n3) {
        return l(n3, t2, t2.getDatastore(e2.$config.bind));
      }
      function h2(n3) {
        var r2, s2 = function(n4) {
          var r3 = i.getRelativeEventPosition(n4, e2.$grid_data).y, a2 = e2.$config.rowStore;
          r3 = r3 || 0;
          var o2 = e2.$state.scrollTop || 0, s3 = t2.$grid_data.getBoundingClientRect().height + o2, l3 = o2, c2 = e2.getItemIndexByTopPosition(e2.$state.scrollTop);
          if (a2.exists(c2) || (c2 = a2.countVisible() - 1), c2 < 0)
            return a2.$getRootId();
          var u3 = a2.getIdByIndex(c2), h4 = e2.$state.scrollTop / e2.getItemHeight(u3), f2 = h4 - Math.floor(h4);
          f2 > 0.1 && f2 < 0.9 && (s3 -= e2.getItemHeight(u3) * f2, l3 += e2.getItemHeight(u3) * (1 - f2)), r3 >= s3 ? r3 = s3 : r3 <= l3 && (r3 = l3);
          var _2 = e2.getItemIndexByTopPosition(r3);
          if (_2 > a2.countVisible() - 1 || _2 < 0)
            return a2.$getRootId();
          var g = a2.getIdByIndex(_2);
          return d(g) ? a2.getPrevSibling(g) : a2.getIdByIndex(_2);
        }(n3), l2 = null, u2 = e2.$config.rowStore, h3 = !e2.$getConfig().order_branch_free, f = i.getRelativeEventPosition(n3, e2.$grid_data).y;
        return s2 !== u2.$getRootId() && (l2 = (f - e2.getItemTop(s2)) / e2.getItemHeight(s2)), h3 ? (r2 = a(c.config.id, s2, l2, f, u2, c.config.level)) && r2.targetParent && d(r2.targetParent) && (s2 = u2.getPrevSibling(r2.targetParent), r2 = a(c.config.id, s2, l2, f, u2, c.config.level)) : r2 = o(c.config.id, s2, l2, f, u2), r2;
      }
    } };
  }, function(t, e, n) {
    var i = n(1), r = n(11);
    t.exports = { init: function(t2, e2) {
      var n2 = t2.$services.getService("dnd");
      if (e2.$config.bind && t2.getDatastore(e2.$config.bind)) {
        var a = new n2(e2.$grid_data, { updates_per_second: 60 });
        t2.defined(e2.$getConfig().dnd_sensitivity) && (a.config.sensitivity = e2.$getConfig().dnd_sensitivity), a.attachEvent("onBeforeDragStart", t2.bind(function(n3, r2) {
          var c = o(r2);
          if (!c)
            return false;
          if (t2.hideQuickInfo && t2._hideQuickInfo(), i.closest(r2.target, ".gantt_grid_editor_placeholder"))
            return false;
          var u = c.getAttribute(e2.$config.item_attribute);
          if (l(u))
            return false;
          var d = s().getItem(u);
          return !t2.isReadonly(d) && (a.config.initial_open_state = d.$open, !!t2.callEvent("onRowDragStart", [u, r2.target || r2.srcElement, r2]) && void 0);
        }, t2)), a.attachEvent("onAfterDragStart", t2.bind(function(t3, n3) {
          var i2 = o(n3);
          a.config.marker.innerHTML = i2.outerHTML;
          var r2 = a.config.marker.firstChild;
          r2 && (r2.style.position = "static"), a.config.id = i2.getAttribute(e2.$config.item_attribute);
          var l2 = s(), c = l2.getItem(a.config.id);
          a.config.index = l2.getBranchIndex(a.config.id), a.config.parent = c.parent, c.$open = false, c.$transparent = true, this.refreshData();
        }, t2)), a.lastTaskOfLevel = function(t3) {
          for (var e3 = null, n3 = s().getItems(), i2 = 0, r2 = n3.length; i2 < r2; i2++)
            n3[i2].$level == t3 && (e3 = n3[i2]);
          return e3 ? e3.id : null;
        }, a._getGridPos = t2.bind(function(t3) {
          var n3 = i.getNodePosition(e2.$grid_data), r2 = n3.x, o2 = t3.pos.y - 10, s2 = e2.getItemHeight(a.config.id);
          o2 < n3.y && (o2 = n3.y);
          var l2 = e2.getTotalHeight();
          return o2 > n3.y + l2 - s2 && (o2 = n3.y + l2 - s2), n3.x = r2, n3.y = o2, n3;
        }, t2), a._getTargetY = t2.bind(function(n3) {
          var r2 = i.getNodePosition(e2.$grid_data), a2 = e2.$state.scrollTop || 0, o2 = t2.$grid_data.getBoundingClientRect().height + a2, s2 = n3.pageY - r2.y + a2;
          return s2 > o2 ? s2 = o2 : s2 < a2 && (s2 = a2), s2;
        }, t2), a._getTaskByY = t2.bind(function(t3, n3) {
          var i2 = s();
          t3 = t3 || 0;
          var r2 = e2.getItemIndexByTopPosition(t3);
          return (r2 = n3 < r2 ? r2 - 1 : r2) > i2.countVisible() - 1 ? null : i2.getIdByIndex(r2);
        }, t2), a.attachEvent("onDragMove", t2.bind(function(n3, i2) {
          var r2 = t2.$grid_data.getBoundingClientRect().height + (e2.$state.scrollTop || 0), o2 = a.config, c = a._getGridPos(i2), u = e2.$getConfig(), d = s();
          c.y < r2 ? o2.marker.style.top = c.y + "px" : o2.marker.style.top = r2 + "px", o2.marker.style.left = c.x + 10 + "px";
          var h2 = d.getItem(a.config.id), f = a._getTargetY(i2), _2 = a._getTaskByY(f, d.getIndexById(h2.id));
          function g(t3, e3) {
            return !d.isChildOf(p.id, e3.id) && (t3.$level == e3.$level || u.order_branch_free);
          }
          if (d.exists(_2) || (_2 = a.lastTaskOfLevel(u.order_branch_free ? h2.$level : 0)) == a.config.id && (_2 = null), d.exists(_2)) {
            var p = d.getItem(_2), v2 = e2.getItemTop(p.id), m = e2.getItemHeight(p.id);
            if (v2 + m / 2 < f) {
              var y = d.getIndexById(p.id), k2 = d.getNext(p.id), b = d.getItem(k2);
              if (l(k2)) {
                var w = d.getPrev(b.id);
                b = d.getItem(w);
              }
              if (b) {
                if (b.id == h2.id)
                  return u.order_branch_free && d.isChildOf(h2.id, p.id) && 1 == d.getChildren(p.id).length ? void d.move(h2.id, d.getBranchIndex(p.id) + 1, d.getParent(p.id)) : void 0;
                p = b;
              } else if (k2 = d.getIdByIndex(y), b = d.getItem(k2), l(k2) && (w = d.getPrev(b.id), b = d.getItem(w)), g(b, h2) && b.id != h2.id)
                return void d.move(h2.id, -1, d.getParent(b.id));
            } else if (u.order_branch_free && p.id != h2.id && g(p, h2) && !l(p.id)) {
              if (!d.hasChild(p.id))
                return p.$open = true, void d.move(h2.id, -1, p.id);
              if (d.getIndexById(p.id) || m / 3 < f)
                return;
            }
            y = d.getIndexById(p.id), w = d.getIdByIndex(y - 1);
            for (var x = d.getItem(w), S = 1; (!x || x.id == p.id) && y - S >= 0; )
              w = d.getIdByIndex(y - S), x = d.getItem(w), S++;
            if (h2.id == p.id || l(p.id))
              return;
            g(p, h2) && h2.id != p.id ? d.move(h2.id, 0, 0, p.id) : p.$level != h2.$level - 1 || d.getChildren(p.id).length ? x && g(x, h2) && h2.id != x.id && d.move(h2.id, -1, d.getParent(x.id)) : d.move(h2.id, 0, p.id);
          }
          return true;
        }, t2)), a.attachEvent("onDragEnd", t2.bind(function() {
          var e3 = s(), n3 = e3.getItem(a.config.id);
          n3.$transparent = false, n3.$open = a.config.initial_open_state, false === this.callEvent("onBeforeRowDragEnd", [a.config.id, a.config.parent, a.config.index]) ? (e3.move(a.config.id, a.config.index, a.config.parent), n3.$drop_target = null) : this.callEvent("onRowDragEnd", [a.config.id, n3.$drop_target]), t2.render(), this.refreshData();
        }, t2));
      }
      function o(t3) {
        return i.locateAttribute(t3, e2.$config.item_attribute);
      }
      function s() {
        return t2.getDatastore(e2.$config.bind);
      }
      function l(e3) {
        return r(e3, t2, s());
      }
    } };
  }, function(t, e, n) {
    var i = n(0), r = n(91), a = n(90), o = function(t2) {
      return { onCreated: function(e2) {
        e2.$config = i.mixin(e2.$config, { bind: "task" }), "grid" == e2.$config.id && (this.extendGantt(e2), t2.ext.inlineEditors = t2.ext._inlineEditors.createEditors(e2), t2.ext.inlineEditors.init()), this._mouseDelegates = n(26)(t2);
      }, onInitialized: function(e2) {
        var n2 = e2.$getConfig();
        n2.order_branch && ("marker" == n2.order_branch ? a.init(e2.$gantt, e2) : r.init(e2.$gantt, e2)), this.initEvents(e2, t2), "grid" == e2.$config.id && this.extendDom(e2);
      }, onDestroyed: function(e2) {
        "grid" == e2.$config.id && t2.ext.inlineEditors.destructor(), this.clearEvents(e2, t2);
      }, initEvents: function(t3, e2) {
        this._mouseDelegates.delegate("click", "gantt_row", e2.bind(function(n2, i2, r2) {
          var a2 = t3.$getConfig();
          if (null !== i2) {
            var o2 = this.getTask(i2);
            a2.scroll_on_click && !e2._is_icon_open_click(n2) && this.showDate(o2.start_date), e2.callEvent("onTaskRowClick", [i2, r2]);
          }
        }, e2), t3.$grid), this._mouseDelegates.delegate("click", "gantt_grid_head_cell", e2.bind(function(n2, i2, r2) {
          var a2 = r2.getAttribute("data-column-id");
          if (e2.callEvent("onGridHeaderClick", [a2, n2])) {
            var o2 = t3.$getConfig();
            if ("add" != a2) {
              if (o2.sort && a2) {
                for (var s, l = a2, c = 0; c < o2.columns.length; c++)
                  if (o2.columns[c].name == a2) {
                    s = o2.columns[c];
                    break;
                  }
                if (s && void 0 !== s.sort && true !== s.sort && !(l = s.sort))
                  return;
                var u = this._sort && this._sort.direction && this._sort.name == a2 ? this._sort.direction : "desc";
                u = "desc" == u ? "asc" : "desc", this._sort = { name: a2, direction: u }, this.sort(l, "desc" == u);
              }
            } else
              e2.$services.getService("mouseEvents").callHandler("click", "gantt_add", t3.$grid, [n2, o2.root_id]);
          }
        }, e2), t3.$grid), this._mouseDelegates.delegate("click", "gantt_add", e2.bind(function(n2, i2, r2) {
          if (!t3.$getConfig().readonly)
            return this.createTask({}, i2 || e2.config.root_id), false;
        }, e2), t3.$grid);
      }, clearEvents: function(t3, e2) {
        this._mouseDelegates.destructor(), this._mouseDelegates = null;
      }, extendDom: function(e2) {
        t2.$grid = e2.$grid, t2.$grid_scale = e2.$grid_scale, t2.$grid_data = e2.$grid_data;
      }, extendGantt: function(e2) {
        t2.getGridColumns = t2.bind(e2.getGridColumns, e2), e2.attachEvent("onColumnResizeStart", function() {
          return t2.callEvent("onColumnResizeStart", arguments);
        }), e2.attachEvent("onColumnResize", function() {
          return t2.callEvent("onColumnResize", arguments);
        }), e2.attachEvent("onColumnResizeEnd", function() {
          return t2.callEvent("onColumnResizeEnd", arguments);
        }), e2.attachEvent("onColumnResizeComplete", function(e3, n2) {
          t2.config.grid_width = n2;
        }), e2.attachEvent("onBeforeRowResize", function() {
          return t2.callEvent("onBeforeRowResize", arguments);
        }), e2.attachEvent("onRowResize", function() {
          return t2.callEvent("onRowResize", arguments);
        }), e2.attachEvent("onBeforeRowResizeEnd", function() {
          return t2.callEvent("onBeforeRowResizeEnd", arguments);
        }), e2.attachEvent("onAfterRowResize", function() {
          return t2.callEvent("onAfterRowResize", arguments);
        });
      } };
    };
    t.exports = o;
  }, function(t, e, n) {
    var i = n(25), r = n(6);
    t.exports = function(t2) {
      return { render: function(e2, n2, i2) {
        var r2 = n2.$getConfig(), a = document.createElement("div");
        return a.className = "gantt_task_grid_row_resize_wrap", a.style.top = n2.getItemTop(e2.id) + n2.getItemHeight(e2.id) + "px", a.innerHTML = "<div class='gantt_task_grid_row_resize'></div>", a.setAttribute(r2.task_grid_row_resizer_attribute, e2.id), t2._waiAria.gridSeparatorAttr(a), a;
      }, update: null, getRectangle: i, getVisibleRange: r };
    };
  }, function(t, e, n) {
    var i = n(21), r = n(6), a = n(20), o = n(19), s = n(32);
    function l(t2, e2, n2, i2) {
      var r2 = 100 * (1 - (1 * t2 || 0)), a2 = i2.posFromDate(e2), o2 = i2.posFromDate(n2), s2 = document.createElement("div");
      return s2.className = "gantt_histogram_hor_bar", s2.style.top = r2 + "%", s2.style.left = a2 + "px", s2.style.width = o2 - a2 + 1 + "px", s2;
    }
    function c(t2, e2, n2) {
      if (t2 === e2)
        return null;
      var i2 = 1 - Math.max(t2, e2), r2 = Math.abs(t2 - e2), a2 = document.createElement("div");
      return a2.className = "gantt_histogram_vert_bar", a2.style.top = 100 * i2 + "%", a2.style.height = 100 * r2 + "%", a2.style.left = n2 + "px", a2;
    }
    t.exports = function(t2) {
      var e2 = s(t2), n2 = {}, u = {}, d = {};
      function h2(t3, e3) {
        var i2 = n2[t3];
        i2 && i2[e3] && i2[e3].parentNode && i2[e3].parentNode.removeChild(i2[e3]);
      }
      function f(e3, n3, i2, r2, o2, s2, u2) {
        var h3 = d[e3.id];
        h3 && h3.parentNode && h3.parentNode.removeChild(h3);
        var f2 = function(e4, n4, i3, r3) {
          for (var o3 = n4.getScale(), s3 = document.createElement("div"), u3 = a(o3, r3), d2 = u3.start; d2 <= u3.end; d2++) {
            var h4 = o3.trace_x[d2], f3 = o3.trace_x[d2 + 1] || t2.date.add(h4, o3.step, o3.unit), _3 = o3.trace_x[d2].valueOf(), g = Math.min(e4[_3] / i3, 1) || 0;
            if (g < 0)
              return null;
            var p = Math.min(e4[f3.valueOf()] / i3, 1) || 0, v2 = l(g, h4, f3, n4);
            v2 && s3.appendChild(v2);
            var m = c(g, p, n4.posFromDate(f3));
            m && s3.appendChild(m);
          }
          return s3;
        }(i2, o2, s2, u2);
        return f2 && n3 && (f2.setAttribute("data-resource-id", e3.id), f2.setAttribute(o2.$config.item_attribute, e3.id), f2.style.position = "absolute", f2.style.top = n3.top + 1 + "px", f2.style.height = o2.getItemHeight(e3.id) - 1 + "px", f2.style.left = 0), f2;
      }
      function _2(t3, e3, n3, i2, r2, a2, o2) {
        var s2 = r2.histogram_cell_class(a2.start_date, a2.end_date, t3, a2.tasks, a2.assignments), l2 = r2.histogram_cell_label(a2.start_date, a2.end_date, t3, a2.tasks, a2.assignments), c2 = r2.histogram_cell_allocated(a2.start_date, a2.end_date, t3, a2.tasks, a2.assignments), u2 = o2.getItemHeight(t3.id) - 1;
        if (s2 || l2) {
          var d2 = document.createElement("div");
          return d2.className = ["gantt_histogram_cell", s2].join(" "), d2.setAttribute(o2.$config.item_attribute, t3.id), d2.style.cssText = ["left:" + e3.left + "px", "width:" + e3.width + "px", "height:" + u2 + "px", "line-height:" + u2 + "px", "top:" + (e3.top + 1) + "px"].join(";"), l2 && (l2 = "<div class='gantt_histogram_label'>" + l2 + "</div>"), c2 && (l2 = "<div class='gantt_histogram_fill' style='height:" + 100 * Math.min(c2 / n3 || 0, 1) + "%;'></div>" + l2), l2 && (d2.innerHTML = l2), d2;
        }
        return null;
      }
      return { render: function(i2, r2, s2, l2) {
        var c2 = r2.$getTemplates(), h3 = r2.getScale(), g = e2(i2, s2.resource_property, h3, r2), p = [], v2 = {}, m = i2.capacity || r2.$config.capacity || 24;
        n2[i2.id] = {}, u[i2.id] = null, d[i2.id] = null;
        for (var y = !!l2, k2 = a(h3, l2), b = k2.start; b <= k2.end; b++) {
          var w = g[b];
          if (w && (!y || o(b, h3, l2, t2))) {
            var x = c2.histogram_cell_capacity(w.start_date, w.end_date, i2, w.tasks, w.assignments);
            v2[w.start_date.valueOf()] = x || 0;
            var S = r2.getItemPosition(i2, w.start_date, w.end_date), $ = _2(i2, S, m, 0, c2, w, r2);
            $ && (p.push($), n2[i2.id][b] = $);
          }
        }
        var T = null;
        if (p.length) {
          T = document.createElement("div");
          for (var C = 0; C < p.length; C++)
            T.appendChild(p[C]);
          var E2 = f(i2, S, v2, 0, r2, m, l2);
          E2 && (T.appendChild(E2), d[i2.id] = E2), u[i2.id] = T;
        }
        return T;
      }, update: function(i2, r2, s2, l2, c2) {
        var u2 = s2.$getTemplates(), g = s2.getScale(), p = e2(i2, l2.resource_property, g, s2), v2 = i2.capacity || s2.$config.capacity || 24, m = {}, y = !!c2, k2 = a(g, c2), b = {};
        if (n2 && n2[i2.id])
          for (var w in n2[i2.id])
            b[w] = w;
        for (var x = k2.start; x <= k2.end; x++) {
          var S = p[x];
          if (b[x] = false, S) {
            var $ = u2.histogram_cell_capacity(S.start_date, S.end_date, i2, S.tasks, S.assignments);
            m[S.start_date.valueOf()] = $ || 0;
            var T = s2.getItemPosition(i2, S.start_date, S.end_date);
            if (!y || o(x, g, c2, t2)) {
              var C = n2[i2.id];
              if (C && C[x])
                C && C[x] && !C[x].parentNode && r2.appendChild(C[x]);
              else {
                var E2 = _2(i2, T, v2, 0, u2, S, s2);
                E2 && (r2.appendChild(E2), n2[i2.id][x] = E2);
              }
            } else
              h2(i2.id, x);
          }
        }
        for (var w in b)
          false !== b[w] && h2(i2.id, w);
        var D = f(i2, T, m, 0, s2, v2, c2);
        D && (r2.appendChild(D), d[i2.id] = D);
      }, getRectangle: i, getVisibleRange: r };
    };
  }, function(t, e, n) {
    var i = n(21), r = n(6), a = n(20), o = n(19), s = n(32);
    t.exports = function(t2) {
      var e2 = s(t2), n2 = {};
      function l(t3, e3, n3, i2, r2) {
        var a2 = n3.resource_cell_class(e3.start_date, e3.end_date, t3, e3.tasks, e3.assignments), o2 = n3.resource_cell_value(e3.start_date, e3.end_date, t3, e3.tasks, e3.assignments), s2 = r2.getItemHeight(t3.id) - 1;
        if (a2 || o2) {
          var l2 = r2.getItemPosition(t3, e3.start_date, e3.end_date), c2 = document.createElement("div");
          return c2.setAttribute(r2.$config.item_attribute, t3.id), c2.className = ["gantt_resource_marker", a2].join(" "), c2.style.cssText = ["left:" + l2.left + "px", "width:" + l2.width + "px", "height:" + s2 + "px", "line-height:" + s2 + "px", "top:" + l2.top + "px"].join(";"), o2 && (c2.innerHTML = o2), c2;
        }
        return null;
      }
      function c(t3, e3) {
        n2[t3] && n2[t3][e3] && n2[t3][e3].parentNode && n2[t3][e3].parentNode.removeChild(n2[t3][e3]);
      }
      return { render: function(i2, r2, s2, c2) {
        var u = r2.$getTemplates(), d = r2.getScale(), h2 = e2(i2, s2.resource_property, r2.getScale(), r2), f = !!c2, _2 = [];
        n2[i2.id] = {};
        for (var g = a(d, c2), p = g.start; p <= g.end; p++) {
          var v2 = h2[p];
          if (v2 && (!f || o(p, d, c2, t2))) {
            var m = l(i2, v2, u, 0, r2);
            m && (_2.push(m), n2[i2.id][p] = m);
          }
        }
        var y = null;
        if (_2.length) {
          y = document.createElement("div");
          for (var k2 = 0; k2 < _2.length; k2++)
            y.appendChild(_2[k2]);
        }
        return y;
      }, update: function(i2, r2, s2, u, d) {
        var h2 = s2.$getTemplates(), f = s2.getScale(), _2 = e2(i2, u.resource_property, s2.getScale(), s2), g = a(f, d), p = {};
        if (n2 && n2[i2.id])
          for (var v2 in n2[i2.id])
            p[v2] = v2;
        for (var m = g.start; m <= g.end; m++) {
          var y = _2[m];
          if (p[m] = false, y)
            if (o(m, f, d, t2))
              if (n2[i2.id] && n2[i2.id][m])
                n2[i2.id] && n2[i2.id][m] && !n2[i2.id][m].parentNode && r2.appendChild(n2[i2.id][m]);
              else {
                var k2 = l(i2, y, h2, 0, s2);
                k2 && (r2.appendChild(k2), n2[i2.id][m] = k2);
              }
            else
              c(i2.id, m);
        }
        for (var v2 in p)
          false !== p[v2] && c(i2.id, v2);
      }, getRectangle: i, getVisibleRange: r };
    };
  }, function(t, e, n) {
    function i(t2) {
      "@babel/helpers - typeof";
      return (i = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(t3) {
        return typeof t3;
      } : function(t3) {
        return t3 && "function" == typeof Symbol && t3.constructor === Symbol && t3 !== Symbol.prototype ? "symbol" : typeof t3;
      })(t2);
    }
    var r = n(2), a = n(25), o = n(6);
    t.exports = function(t2) {
      return { render: function(e2, n2, i2, a2) {
        for (var o2 = n2.getGridColumns(), s = n2.$getTemplates(), l = n2.$config.rowStore, c = [], u = 0; u < o2.length; u++) {
          var d, h2, f, _2 = u == o2.length - 1, g = o2[u];
          "add" == g.name ? (h2 = "<div " + (b = t2._waiAria.gridAddButtonAttrString(g)) + " class='gantt_add'></div>", f = "") : (h2 = g.template ? g.template(e2) : e2[g.name], r.isDate(h2) && (h2 = s.date_grid(h2, e2, g.name)), null !== h2 && void 0 !== h2 || (h2 = ""), f = h2, h2 = "<div class='gantt_tree_content'>" + h2 + "</div>");
          var p = "gantt_cell" + (_2 ? " gantt_last_cell" : ""), v2 = [];
          if (g.tree) {
            p += " gantt_cell_tree";
            for (var m = 0; m < e2.$level; m++)
              v2.push(s.grid_indent(e2));
            !l.hasChild(e2.id) || t2.isSplitTask(e2) && !t2.config.open_split_tasks ? (v2.push(s.grid_blank(e2)), v2.push(s.grid_file(e2))) : (v2.push(s.grid_open(e2)), v2.push(s.grid_folder(e2)));
          }
          var y = "width:" + (g.width - (_2 ? 1 : 0)) + "px;";
          if (this.defined(g.align)) {
            var k2 = { right: "flex-end", left: "flex-start", center: "center" }[g.align];
            y += "text-align:" + g.align + ";justify-content:" + k2 + ";";
          }
          var b = t2._waiAria.gridCellAttrString(g, f, e2);
          v2.push(h2), d = "<div class='" + p + "' data-column-index='" + u + "' data-column-name='" + g.name + "' style='" + y + "' " + b + ">" + v2.join("") + "</div>", c.push(d);
        }
        if (p = t2.getGlobalTaskIndex(e2.id) % 2 == 0 ? "" : " odd", p += e2.$transparent ? " gantt_transparent" : "", p += e2.$dataprocessor_class ? " " + e2.$dataprocessor_class : "", s.grid_row_class) {
          var w = s.grid_row_class.call(t2, e2.start_date, e2.end_date, e2);
          w && (p += " " + w);
        }
        l.isSelected(e2.id) && (p += " gantt_selected");
        var x = document.createElement("div");
        x.className = "gantt_row" + p + " gantt_row_" + t2.getTaskType(e2.type);
        var S = n2.getItemHeight(e2.id);
        return x.style.height = S + "px", x.style.lineHeight = S + "px", i2.smart_rendering && (x.style.position = "absolute", x.style.left = "0px", x.style.top = n2.getItemTop(e2.id) + "px"), n2.$config.item_attribute && (x.setAttribute(n2.$config.item_attribute, e2.id), x.setAttribute(n2.$config.bind + "_id", e2.id)), t2._waiAria.taskRowAttr(e2, x), x.innerHTML = c.join(""), x;
      }, update: null, getRectangle: a, getVisibleRange: o, onrender: function(e2, n2, r2) {
        for (var a2 = r2.getGridColumns(), o2 = 0; o2 < a2.length; o2++) {
          var s = a2[o2];
          if (s.onrender) {
            var l = n2.querySelector("[data-column-name=" + s.name + "]");
            if (l) {
              var c = s.onrender(e2, l);
              if (c && "string" == typeof c)
                l.innerHTML = c;
              else if (c && "object" === i(c) && t2.config.external_render) {
                var u = t2.config.external_render;
                u.isElement(c) && u.renderElement(c, l);
              }
            }
          }
        }
      } };
    };
  }, function(t, e) {
    t.exports = function(t2, e2, n, i, r) {
      var a = n.$gantt.getTask(t2.source), o = n.$gantt.getTask(t2.target), s = n.getItemTop(a.id), l = n.getItemHeight(a.id), c = n.getItemTop(o.id), u = n.getItemHeight(o.id);
      if (e2.y > s + l && e2.y > c + u)
        return false;
      if (e2.y_end < c && e2.y_end < s)
        return false;
      var d = n.posFromDate(a.start_date), h2 = n.posFromDate(a.end_date), f = n.posFromDate(o.start_date), _2 = n.posFromDate(o.end_date);
      if (d > h2) {
        var g = h2;
        h2 = d, d = g;
      }
      if (f > _2) {
        g = _2;
        _2 = f, f = g;
      }
      return d += -100, h2 += 100, f += -100, _2 += 100, !(e2.x > h2 && e2.x > _2) && !(e2.x_end < d && e2.x_end < f);
    };
  }, function(t, e, n) {
    var i = n(97);
    t.exports = function(t2) {
      var e2 = { current_pos: null, dirs: { left: "left", right: "right", up: "up", down: "down" }, path: [], clear: function() {
        this.current_pos = null, this.path = [];
      }, point: function(e3) {
        this.current_pos = t2.copy(e3);
      }, get_lines: function(t3) {
        this.clear(), this.point(t3[0]);
        for (var e3 = 1; e3 < t3.length; e3++)
          this.line_to(t3[e3]);
        return this.get_path();
      }, line_to: function(e3) {
        var n3 = t2.copy(e3), i2 = this.current_pos, r2 = this._get_line(i2, n3);
        this.path.push(r2), this.current_pos = n3;
      }, get_path: function() {
        return this.path;
      }, get_wrapper_sizes: function(t3, e3, n3) {
        var i2, r2 = e3.$getConfig().link_wrapper_width, a = t3.y - r2 / 2;
        switch (t3.direction) {
          case this.dirs.left:
            i2 = { top: a, height: r2, lineHeight: r2, left: t3.x - t3.size - r2 / 2, width: t3.size + r2 };
            break;
          case this.dirs.right:
            i2 = { top: a, lineHeight: r2, height: r2, left: t3.x - r2 / 2, width: t3.size + r2 };
            break;
          case this.dirs.up:
            i2 = { top: a - t3.size, lineHeight: t3.size + r2, height: t3.size + r2, left: t3.x - r2 / 2, width: r2 };
            break;
          case this.dirs.down:
            i2 = { top: a, lineHeight: t3.size + r2, height: t3.size + r2, left: t3.x - r2 / 2, width: r2 };
        }
        return i2;
      }, get_line_sizes: function(t3, e3) {
        var n3, i2 = e3.$getConfig(), r2 = i2.link_line_width, a = i2.link_wrapper_width, o = t3.size + r2;
        switch (t3.direction) {
          case this.dirs.left:
          case this.dirs.right:
            n3 = { height: r2, width: o, marginTop: (a - r2) / 2, marginLeft: (a - r2) / 2 };
            break;
          case this.dirs.up:
          case this.dirs.down:
            n3 = { height: o, width: r2, marginTop: (a - r2) / 2, marginLeft: (a - r2) / 2 };
        }
        return n3;
      }, render_line: function(t3, e3, n3, i2) {
        var r2 = this.get_wrapper_sizes(t3, n3, i2), a = document.createElement("div");
        a.style.cssText = ["top:" + r2.top + "px", "left:" + r2.left + "px", "height:" + r2.height + "px", "width:" + r2.width + "px"].join(";"), a.className = "gantt_line_wrapper";
        var o = this.get_line_sizes(t3, n3), s = document.createElement("div");
        return s.style.cssText = ["height:" + o.height + "px", "width:" + o.width + "px", "margin-top:" + o.marginTop + "px", "margin-left:" + o.marginLeft + "px"].join(";"), s.className = "gantt_link_line_" + t3.direction, a.appendChild(s), a;
      }, _get_line: function(t3, e3) {
        var n3 = this.get_direction(t3, e3), i2 = { x: t3.x, y: t3.y, direction: this.get_direction(t3, e3) };
        return n3 == this.dirs.left || n3 == this.dirs.right ? i2.size = Math.abs(t3.x - e3.x) : i2.size = Math.abs(t3.y - e3.y), i2;
      }, get_direction: function(t3, e3) {
        return e3.x < t3.x ? this.dirs.left : e3.x > t3.x ? this.dirs.right : e3.y > t3.y ? this.dirs.down : this.dirs.up;
      } }, n2 = { path: [], clear: function() {
        this.path = [];
      }, current: function() {
        return this.path[this.path.length - 1];
      }, point: function(e3) {
        return e3 ? (this.path.push(t2.copy(e3)), e3) : this.current();
      }, point_to: function(n3, i2, r2) {
        r2 = r2 ? { x: r2.x, y: r2.y } : t2.copy(this.point());
        var a = e2.dirs;
        switch (n3) {
          case a.left:
            r2.x -= i2;
            break;
          case a.right:
            r2.x += i2;
            break;
          case a.up:
            r2.y -= i2;
            break;
          case a.down:
            r2.y += i2;
        }
        return this.point(r2);
      }, get_points: function(n3, i2, r2, a) {
        var o = this.get_endpoint(n3, i2, r2, a), s = t2.config, l = o.e_y - o.y, c = o.e_x - o.x, u = e2.dirs, d = i2.getItemHeight(n3.source);
        this.clear(), this.point({ x: o.x, y: o.y });
        var h2 = 2 * s.link_arrow_size, f = this.get_line_type(n3, i2.$getConfig()), _2 = o.e_x > o.x;
        if (f.from_start && f.to_start)
          this.point_to(u.left, h2), _2 ? (this.point_to(u.down, l), this.point_to(u.right, c)) : (this.point_to(u.right, c), this.point_to(u.down, l)), this.point_to(u.right, h2);
        else if (!f.from_start && f.to_start)
          if (_2 = o.e_x > o.x + 2 * h2, this.point_to(u.right, h2), _2)
            c -= h2, this.point_to(u.down, l), this.point_to(u.right, c);
          else {
            c -= 2 * h2;
            var g = l > 0 ? 1 : -1;
            this.point_to(u.down, g * (d / 2)), this.point_to(u.right, c), this.point_to(u.down, g * (Math.abs(l) - d / 2)), this.point_to(u.right, h2);
          }
        else
          f.from_start || f.to_start ? f.from_start && !f.to_start && (_2 = o.e_x > o.x - 2 * h2, this.point_to(u.left, h2), _2 ? (c += 2 * h2, g = l > 0 ? 1 : -1, this.point_to(u.down, g * (d / 2)), this.point_to(u.right, c), this.point_to(u.down, g * (Math.abs(l) - d / 2)), this.point_to(u.left, h2)) : (c += h2, this.point_to(u.down, l), this.point_to(u.right, c))) : (this.point_to(u.right, h2), _2 ? (this.point_to(u.right, c), this.point_to(u.down, l)) : (this.point_to(u.down, l), this.point_to(u.right, c)), this.point_to(u.left, h2));
        return this.path;
      }, get_line_type: function(e3, n3) {
        var i2 = n3.links, r2 = false, a = false;
        return e3.type == i2.start_to_start ? r2 = a = true : e3.type == i2.finish_to_finish ? r2 = a = false : e3.type == i2.finish_to_start ? (r2 = false, a = true) : e3.type == i2.start_to_finish ? (r2 = true, a = false) : t2.assert(false, "Invalid link type"), n3.rtl && (r2 = !r2, a = !a), { from_start: r2, to_start: a };
      }, get_endpoint: function(t3, e3, n3, i2) {
        var a = e3.$getConfig(), o = this.get_line_type(t3, a), s = o.from_start, l = o.to_start, c = r(n3, e3, a), u = r(i2, e3, a);
        return { x: s ? c.left : c.left + c.width, e_x: l ? u.left : u.left + u.width, y: c.top + c.rowHeight / 2 - 1, e_y: u.top + u.rowHeight / 2 - 1 };
      } };
      function r(e3, n3, i2) {
        var r2 = n3.getItemPosition(e3);
        if (t2.getTaskType(e3.type) == i2.types.milestone) {
          var a = n3.getBarHeight(e3.id, true), o = Math.sqrt(2 * a * a);
          r2.left -= o / 2, r2.width = o;
        }
        return r2;
      }
      return { render: function(i2, r2, a) {
        var o = t2.getTask(i2.source);
        if (!o.hide_bar) {
          var s = t2.getTask(i2.target);
          if (!s.hide_bar) {
            var l = n2.get_endpoint(i2, r2, o, s), c = l.e_y - l.y;
            if (!(l.e_x - l.x || c))
              return null;
            var u = n2.get_points(i2, r2, o, s), d = e2.get_lines(u, r2), h2 = document.createElement("div"), f = "gantt_task_link";
            i2.color && (f += " gantt_link_inline_color");
            var _2 = t2.templates.link_class ? t2.templates.link_class(i2) : "";
            _2 && (f += " " + _2), a.highlight_critical_path && t2.isCriticalLink && t2.isCriticalLink(i2) && (f += " gantt_critical_link"), h2.className = f, r2.$config.link_attribute && (h2.setAttribute(r2.$config.link_attribute, i2.id), h2.setAttribute("link_id", i2.id));
            for (var g = 0; g < d.length; g++) {
              g == d.length - 1 && (d[g].size -= a.link_arrow_size);
              var p = e2.render_line(d[g], d[g + 1], r2, i2.source);
              i2.color && (p.firstChild.style.backgroundColor = i2.color), h2.appendChild(p);
            }
            var v2 = d[d.length - 1].direction, m = function(t3, n3, i3, r3) {
              var a2 = i3.$getConfig(), o2 = document.createElement("div"), s2 = t3.y, l2 = t3.x, c2 = a2.link_arrow_size, u2 = "gantt_link_arrow gantt_link_arrow_" + n3;
              switch (n3) {
                case e2.dirs.right:
                  s2 -= c2 / 2, l2 -= c2;
                  break;
                case e2.dirs.left:
                  s2 -= c2 / 2;
                  break;
                case e2.dirs.up:
                  l2 -= c2;
                  break;
                case e2.dirs.down:
                  s2 += 2 * c2, l2 -= c2;
              }
              return o2.style.cssText = ["top:" + s2 + "px", "left:" + l2 + "px"].join(";"), o2.className = u2, o2;
            }(u[u.length - 1], v2, r2, i2.source);
            return i2.color && (m.style.borderColor = i2.color), h2.appendChild(m), t2._waiAria.linkAttr(i2, h2), h2;
          }
        }
      }, update: null, isInViewPort: i };
    };
  }, function(t, e, n) {
    var i = n(21), r = n(13), a = n(6), o = n(20), s = n(19);
    t.exports = function(t2) {
      var e2 = {}, n2 = {};
      function l(t3, n3) {
        return !(!e2[t3.id][n3] || !e2[t3.id][n3].parentNode);
      }
      function c(t3, n3) {
        e2[t3] && e2[t3][n3] && e2[t3][n3].parentNode && e2[t3][n3].parentNode.removeChild(e2[t3][n3]);
      }
      function u(t3) {
        var e3, n3 = t3.$getTemplates();
        return void 0 !== n3.task_cell_class ? (e3 = n3.task_cell_class, (console.warn || console.log)("gantt.templates.task_cell_class template is deprecated and will be removed soon. Please use gantt.templates.timeline_cell_class instead.")) : e3 = n3.timeline_cell_class, e3;
      }
      function d(i2, r2, a2, o2, l2, c2, u2) {
        var d2 = i2.width[r2], h2 = "";
        if (s(r2, i2, o2, t2)) {
          var f = c2(a2, i2.trace_x[r2]);
          if (u2.static_background && (!u2.static_background_cells || !f))
            return null;
          if (e2[a2.id][r2])
            return n2[a2.id][r2] = r2, e2[a2.id][r2];
          var _2 = document.createElement("div");
          return _2.style.width = d2 + "px", h2 = "gantt_task_cell" + (r2 == l2 - 1 ? " gantt_last_cell" : ""), f && (h2 += " " + f), _2.className = h2, _2.style.position = "absolute", _2.style.left = i2.left[r2] + "px", e2[a2.id][r2] = _2, n2[a2.id][r2] = r2, _2;
        }
        return null;
      }
      return { render: function(i2, a2, s2, l2) {
        var c2 = a2.$getTemplates(), h2 = a2.getScale(), f = h2.count;
        if (s2.static_background && !s2.static_background_cells)
          return null;
        var _2, g = document.createElement("div"), p = u(a2);
        if (_2 = l2 && s2.smart_rendering && !r(t2) ? o(h2, l2.x) : { start: 0, end: f - 1 }, s2.show_task_cells) {
          e2[i2.id] = {}, n2[i2.id] = {};
          for (var v2 = _2.start; v2 <= _2.end; v2++) {
            var m = d(h2, v2, i2, l2, f, p, s2);
            m && g.appendChild(m);
          }
        }
        var y = t2.getGlobalTaskIndex(i2.id) % 2 != 0, k2 = c2.task_row_class(i2.start_date, i2.end_date, i2), b = "gantt_task_row" + (y ? " odd" : "") + (k2 ? " " + k2 : "");
        return a2.$config.rowStore.isSelected(i2.id) && (b += " gantt_selected"), g.className = b, s2.smart_rendering ? (g.style.position = "absolute", g.style.top = a2.getItemTop(i2.id) + "px", g.style.width = "100%") : g.style.position = "relative", g.style.height = a2.getItemHeight(i2.id) + "px", a2.$config.item_attribute && (g.setAttribute(a2.$config.item_attribute, i2.id), g.setAttribute(a2.$config.bind + "_id", i2.id)), g;
      }, update: function(t3, i2, r2, a2, s2) {
        var h2 = r2.getScale(), f = h2.count, _2 = u(r2);
        if (a2.show_task_cells) {
          e2[t3.id] || (e2[t3.id] = {}), n2[t3.id] || (n2[t3.id] = {});
          var g = o(h2, s2);
          for (var p in n2[t3.id]) {
            var v2 = n2[t3.id][p];
            (Number(v2) < g.start || Number(v2) > g.end) && c(t3.id, v2);
          }
          n2[t3.id] = {};
          for (var m = g.start; m <= g.end; m++) {
            var y = d(h2, m, t3, s2, f, _2, a2);
            !y && l(t3, m) ? c(t3.id, m) : y && !y.parentNode && i2.appendChild(y);
          }
        }
      }, getRectangle: i, getVisibleRange: a };
    };
  }, function(t, e, n) {
    var i = n(22), r = n(23), a = n(6);
    t.exports = function(t2) {
      var e2 = i(t2);
      return { render: function(n2, i2) {
        if (n2.$rollup && n2.$rollup.length) {
          var r2 = document.createElement("div"), a2 = t2.getTaskPosition(n2);
          return n2.$rollup.forEach(function(o) {
            var s = t2.getTask(o), l = e2(s, i2);
            if (l) {
              var c = i2.getBarHeight(n2.id, s.type == t2.config.types.milestone), u = Math.floor((i2.getItemHeight(n2.id) - c) / 2);
              l.style.top = a2.top + u + "px", l.classList.add("gantt_rollup_child"), r2.appendChild(l);
            }
          }), r2;
        }
        return false;
      }, update: null, isInViewPort: r, getVisibleRange: a };
    };
  }, function(t, e, n) {
    var i = n(23);
    t.exports = function(t2, e2, n2, r, a) {
      if (!a.isSplitTask(t2))
        return false;
      var o = a.getSubtaskDates(t2.id);
      return i({ id: t2.id, start_date: o.start_date, end_date: o.end_date, parent: t2.parent }, e2, n2, a);
    };
  }, function(t, e, n) {
    var i = n(22), r = n(101), a = n(6);
    t.exports = function(t2) {
      var e2 = i(t2);
      return { render: function(n2, i2) {
        if (t2.isSplitTask(n2) && (t2.config.open_split_tasks && !n2.$open || !t2.config.open_split_tasks)) {
          var r2 = document.createElement("div"), a2 = t2.getTaskPosition(n2);
          return t2.hasChild(n2.id) && t2.eachTask(function(o) {
            var s = t2.isSummaryTask(o);
            if (s && t2.resetProjectDates(o), !o.hide_bar) {
              var l = e2(o, i2);
              if (l) {
                var c = i2.getBarHeight(n2.id, o.type == t2.config.types.milestone), u = Math.floor((i2.getItemHeight(n2.id) - c) / 2);
                l.style.top = a2.top + u + "px", l.classList.add("gantt_split_child"), s && l.classList.add("gantt_split_subproject"), r2.appendChild(l);
              }
            }
          }, n2.id), r2;
        }
        return false;
      }, update: null, isInViewPort: r, getVisibleRange: a };
    };
  }, function(t, e, n) {
    var i = n(23), r = n(6), a = n(22);
    t.exports = function(t2) {
      return { render: a(t2), update: null, isInViewPort: i, getVisibleRange: r };
    };
  }, function(t, e) {
    t.exports = function(t2) {
      return function(e2, n, i) {
        "keepDates" == i ? function(e3, n2) {
          "duration" == n2 ? e3.end_date = t2.calculateEndDate(e3) : "end_date" != n2 && "start_date" != n2 || (e3.duration = t2.calculateDuration(e3));
        }(e2, n) : "keepDuration" == i ? function(e3, n2) {
          "end_date" == n2 ? e3.start_date = t2.calculateEndDate({ start_date: e3.end_date, duration: -e3.duration, task: e3 }) : "start_date" != n2 && "duration" != n2 || (e3.end_date = t2.calculateEndDate(e3));
        }(e2, n) : function(e3, n2) {
          "start_date" == n2 || "duration" == n2 ? e3.end_date = t2.calculateEndDate(e3) : "end_date" == n2 && (e3.duration = t2.calculateDuration(e3));
        }(e2, n);
      };
    };
  }, function(t, e, n) {
    t.exports = function(t2) {
      var e2 = n(8)(t2), i = n(0);
      function r() {
        return e2.apply(this, arguments) || this;
      }
      function a(e3) {
        return e3.formatter || t2.ext.formatters.durationFormatter();
      }
      return n(3)(r, e2), i.mixin(r.prototype, { show: function(t3, e3, n2, i2) {
        var r2 = "<div><input type='text' name='" + e3.name + "'></div>";
        i2.innerHTML = r2;
      }, set_value: function(t3, e3, n2, i2) {
        this.get_input(i2).value = a(n2.editor).format(t3);
      }, get_value: function(t3, e3, n2) {
        return a(e3.editor).parse(this.get_input(n2).value || "");
      } }, true), r;
    };
  }, function(t, e, n) {
    t.exports = function(t2) {
      var e2 = n(8)(t2), i = n(0);
      function r() {
        return e2.apply(this, arguments) || this;
      }
      function a(e3) {
        return e3.formatter || t2.ext.formatters.linkFormatter();
      }
      function o(t3, e3) {
        for (var n2 = (t3 || "").split(e3.delimiter || ","), i2 = 0; i2 < n2.length; i2++) {
          var r2 = n2[i2].trim();
          r2 ? n2[i2] = r2 : (n2.splice(i2, 1), i2--);
        }
        return n2.sort(), n2;
      }
      function s(t3, e3, n2) {
        for (var i2 = t3.$target, r2 = [], o2 = 0; o2 < i2.length; o2++) {
          var s2 = n2.getLink(i2[o2]);
          r2.push(a(e3).format(s2));
        }
        return r2.join((e3.delimiter || ",") + " ");
      }
      function l(t3) {
        return t3.source + "_" + t3.target + "_" + t3.type + "_" + (t3.lag || 0);
      }
      function c(e3, n2, i2) {
        var r2 = function(e4, n3, i3) {
          var r3 = [];
          return n3.forEach(function(n4) {
            var o3 = a(i3).parse(n4);
            o3 && (o3.target = e4, o3.id = "predecessor_generated", t2.isLinkAllowed(o3) && (o3.id = void 0, r3.push(o3)));
          }), r3;
        }(e3.id, n2, i2), o2 = {};
        e3.$target.forEach(function(e4) {
          var n3 = t2.getLink(e4);
          o2[l(n3)] = n3.id;
        });
        var s2 = [];
        r2.forEach(function(t3) {
          var e4 = l(t3);
          o2[e4] ? delete o2[e4] : s2.push(t3);
        });
        var c2 = [];
        for (var u in o2)
          c2.push(o2[u]);
        return { add: s2, remove: c2 };
      }
      return n(3)(r, e2), i.mixin(r.prototype, { show: function(t3, e3, n2, i2) {
        var r2 = "<div><input type='text' name='" + e3.name + "'></div>";
        i2.innerHTML = r2;
      }, hide: function() {
      }, set_value: function(e3, n2, i2, r2) {
        this.get_input(r2).value = s(e3, i2.editor, t2);
      }, get_value: function(t3, e3, n2) {
        return o(this.get_input(n2).value || "", e3.editor);
      }, save: function(e3, n2, i2) {
        var r2 = c(t2.getTask(e3), this.get_value(e3, n2, i2), n2.editor);
        (r2.add.length || r2.remove.length) && t2.batchUpdate(function() {
          r2.add.forEach(function(e4) {
            t2.addLink(e4);
          }), r2.remove.forEach(function(e4) {
            t2.deleteLink(e4);
          }), t2.autoSchedule && t2.autoSchedule();
        });
      }, is_changed: function(e3, n2, i2, r2) {
        var a2 = this.get_value(n2, i2, r2), l2 = o(s(e3, i2.editor, t2), i2.editor);
        return a2.join() !== l2.join();
      } }, true), r;
    };
  }, function(t, e, n) {
    t.exports = function(t2) {
      var e2 = n(8)(t2), i = n(0), r = "%Y-%m-%d", a = null, o = null;
      function s() {
        return e2.apply(this, arguments) || this;
      }
      return n(3)(s, e2), i.mixin(s.prototype, { show: function(e3, n2, i2, s2) {
        a || (a = t2.date.date_to_str(r)), o || (o = t2.date.str_to_date(r));
        var l = null, c = null;
        l = "function" == typeof i2.min ? i2.min(e3, n2) : i2.min, c = "function" == typeof i2.max ? i2.max(e3, n2) : i2.max;
        var u = "<div style='width:140px'><input type='date' " + (l ? " min='" + a(l) + "' " : "") + (c ? " max='" + a(c) + "' " : "") + " name='" + n2.name + "'></div>";
        s2.innerHTML = u;
      }, set_value: function(t3, e3, n2, i2) {
        t3 && t3.getFullYear ? this.get_input(i2).value = a(t3) : this.get_input(i2).value = t3;
      }, is_valid: function(t3, e3, n2, i2) {
        return !(!t3 || isNaN(t3.getTime()));
      }, get_value: function(t3, e3, n2) {
        var i2;
        try {
          i2 = o(this.get_input(n2).value || "");
        } catch (t4) {
          i2 = null;
        }
        return i2;
      } }, true), s;
    };
  }, function(t, e, n) {
    t.exports = function(t2) {
      var e2 = n(8)(t2), i = n(0);
      function r() {
        return e2.apply(this, arguments) || this;
      }
      return n(3)(r, e2), i.mixin(r.prototype, { show: function(t3, e3, n2, i2) {
        for (var r2 = "<div><select name='" + e3.name + "'>", a = [], o = n2.options || [], s = 0; s < o.length; s++)
          a.push("<option value='" + n2.options[s].key + "'>" + o[s].label + "</option>");
        r2 += a.join("") + "</select></div>", i2.innerHTML = r2;
      }, get_input: function(t3) {
        return t3.querySelector("select");
      } }, true), r;
    };
  }, function(t, e, n) {
    t.exports = function(t2) {
      var e2 = n(8)(t2), i = n(0);
      function r() {
        return e2.apply(this, arguments) || this;
      }
      return n(3)(r, e2), i.mixin(r.prototype, { show: function(t3, e3, n2, i2) {
        var r2 = "<div><input type='number' min='" + (n2.min || 0) + "' max='" + (n2.max || 100) + "' name='" + e3.name + "'></div>";
        i2.innerHTML = r2;
      }, get_value: function(t3, e3, n2) {
        return this.get_input(n2).value || "";
      }, is_valid: function(t3, e3, n2, i2) {
        return !isNaN(parseInt(t3, 10));
      } }, true), r;
    };
  }, function(t, e, n) {
    t.exports = function(t2) {
      var e2 = n(8)(t2), i = n(0);
      function r() {
        return e2.apply(this, arguments) || this;
      }
      return n(3)(r, e2), i.mixin(r.prototype, { show: function(t3, e3, n2, i2) {
        var r2 = "<div><input type='text' name='" + e3.name + "'></div>";
        i2.innerHTML = r2;
      } }, true), r;
    };
  }, function(t, e) {
    t.exports = { init: function(t2, e2) {
      var n = t2, i = e2.$gantt, r = null, a = i.ext.keyboardNavigation;
      a.attachEvent("onBeforeFocus", function(e3) {
        var i2 = t2.locateCell(e3);
        if (clearTimeout(r), i2) {
          var a2 = i2.columnName, o = i2.id, s = n.getState();
          if (n.isVisible() && s.id == o && s.columnName === a2)
            return false;
        }
        return true;
      }), a.attachEvent("onFocus", function(e3) {
        var i2 = t2.locateCell(e3), a2 = t2.getState();
        return clearTimeout(r), !i2 || i2.id == a2.id && i2.columnName == a2.columnName || n.isVisible() && n.save(), true;
      }), t2.attachEvent("onHide", function() {
        clearTimeout(r);
      }), a.attachEvent("onBlur", function() {
        return r = setTimeout(function() {
          n.save();
        }), true;
      }), i.attachEvent("onTaskDblClick", function(e3, n2) {
        var i2 = t2.getState(), r2 = t2.locateCell(n2.target);
        return !r2 || !t2.isVisible() || r2.columnName != i2.columnName;
      }), i.attachEvent("onTaskClick", function(e3, n2) {
        if (i._is_icon_open_click(n2))
          return true;
        var r2 = t2.getState(), a2 = t2.locateCell(n2.target);
        return !a2 || !t2.getEditorConfig(a2.columnName) || (t2.isVisible() && r2.id == a2.id && r2.columnName == a2.columnName || t2.startEdit(a2.id, a2.columnName), false);
      }), i.attachEvent("onEmptyClick", function() {
        return n.save(), true;
      }), a.attachEvent("onKeyDown", function(e3, r2) {
        var o = t2.locateCell(r2.target), s = !!o && t2.getEditorConfig(o.columnName), l = t2.getState(), c = i.constants.KEY_CODES, u = r2.keyCode, d = false;
        switch (u) {
          case c.ENTER:
            t2.isVisible() ? (t2.save(), r2.preventDefault(), d = true) : s && !(r2.ctrlKey || r2.metaKey || r2.shiftKey) && (n.startEdit(o.id, o.columnName), r2.preventDefault(), d = true);
            break;
          case c.ESC:
            t2.isVisible() && (t2.hide(), r2.preventDefault(), d = true);
            break;
          case c.UP:
          case c.DOWN:
            break;
          case c.LEFT:
          case c.RIGHT:
            (s && t2.isVisible() || "date" === l.editorType) && (d = true);
            break;
          case c.SPACE:
            t2.isVisible() && (d = true), s && !t2.isVisible() && (n.startEdit(o.id, o.columnName), r2.preventDefault(), d = true);
            break;
          case c.DELETE:
            s && !t2.isVisible() ? (n.startEdit(o.id, o.columnName), d = true) : s && t2.isVisible() && (d = true);
            break;
          case c.TAB:
            if (t2.isVisible()) {
              r2.shiftKey ? t2.editPrevCell(true) : t2.editNextCell(true);
              var h2 = t2.getState();
              h2.id && a.focus({ type: "taskCell", id: h2.id, column: h2.columnName }), r2.preventDefault(), d = true;
            }
            break;
          default:
            if (t2.isVisible())
              d = true;
            else if (u >= 48 && u <= 57 || u > 95 && u < 112 || u >= 64 && u <= 91 || u > 185 && u < 193 || u > 218 && u < 223) {
              var f = e3.modifiers, _2 = f.alt || f.ctrl || f.meta || f.shift;
              f.alt || _2 && a.getCommandHandler(e3, "taskCell") || s && !t2.isVisible() && (n.startEdit(o.id, o.columnName), d = true);
            }
        }
        return !d;
      });
    }, onShow: function(t2, e2, n) {
    }, onHide: function(t2, e2, n) {
      n.$gantt.focus();
    }, destroy: function() {
    } };
  }, function(t, e) {
    t.exports = { init: function(t2, e2) {
      var n = e2.$gantt;
      n.attachEvent("onTaskClick", function(e3, i) {
        if (n._is_icon_open_click(i))
          return true;
        var r = t2.getState(), a = t2.locateCell(i.target);
        return !a || !t2.getEditorConfig(a.columnName) || (t2.isVisible() && r.id == a.id && r.columnName == a.columnName || t2.startEdit(a.id, a.columnName), false);
      }), n.attachEvent("onEmptyClick", function() {
        return t2.isVisible() && t2.isChanged() ? t2.save() : t2.hide(), true;
      }), n.attachEvent("onTaskDblClick", function(e3, n2) {
        var i = t2.getState(), r = t2.locateCell(n2.target);
        return !r || !t2.isVisible() || r.columnName != i.columnName;
      });
    }, onShow: function(t2, e2, n) {
      var i = n.$gantt;
      i.ext && i.ext.keyboardNavigation && i.ext.keyboardNavigation.attachEvent("onKeyDown", function(e3, n2) {
        var r = i.constants.KEY_CODES, a = false;
        switch (n2.keyCode) {
          case r.SPACE:
            t2.isVisible() && (a = true);
        }
        return !a;
      });
      e2.onkeydown = function(e3) {
        e3 = e3 || window.event;
        var n2 = i.constants.KEY_CODES;
        if (!(e3.defaultPrevented || e3.shiftKey && e3.keyCode != n2.TAB)) {
          var r = true;
          switch (e3.keyCode) {
            case i.keys.edit_save:
              t2.save();
              break;
            case i.keys.edit_cancel:
              t2.hide();
              break;
            case n2.UP:
            case n2.DOWN:
              t2.isVisible() && (t2.hide(), r = false);
              break;
            case n2.TAB:
              e3.shiftKey ? t2.editPrevCell(true) : t2.editNextCell(true);
              break;
            default:
              r = false;
          }
          r && e3.preventDefault();
        }
      };
    }, onHide: function() {
    }, destroy: function() {
    } };
  }, function(t, e, n) {
    var i = n(112), r = n(111);
    t.exports = function(t2) {
      var e2 = null;
      return { setMapping: function(t3) {
        e2 = t3;
      }, getMapping: function() {
        return e2 || (t2.config.keyboard_navigation_cells && t2.ext.keyboardNavigation ? r : i);
      } };
    };
  }, function(t, e, n) {
    var i = n(113), r = n(110), a = n(109), o = n(108), s = n(107), l = n(106), c = n(105), u = n(0), d = n(1), h2 = n(4), f = n(104);
    function _2(t2) {
      t2.config.editor_types = { text: new (r(t2))(), number: new (a(t2))(), select: new (o(t2))(), date: new (s(t2))(), predecessor: new (l(t2))(), duration: new (c(t2))() };
    }
    t.exports = function(t2) {
      var e2 = i(t2), n2 = {};
      h2(n2);
      var r2 = { init: _2, createEditors: function(i2) {
        function r3(t3, e3) {
          var n3 = i2.$getConfig(), r4 = function(t4, e4) {
            for (var n4 = i2.$getConfig(), r5 = i2.getItemTop(t4), a4 = i2.getItemHeight(t4), o4 = i2.getGridColumns(), s3 = 0, l3 = 0, c3 = 0, u2 = 0; u2 < o4.length; u2++) {
              if (o4[u2].name == e4) {
                c3 = o4[u2].width;
                break;
              }
              n4.rtl ? l3 += o4[u2].width : s3 += o4[u2].width;
            }
            return n4.rtl ? { top: r5, right: l3, height: a4, width: c3 } : { top: r5, left: s3, height: a4, width: c3 };
          }(t3, e3), a3 = document.createElement("div");
          a3.className = "gantt_grid_editor_placeholder", a3.setAttribute(i2.$config.item_attribute, t3), a3.setAttribute(i2.$config.bind + "_id", t3), a3.setAttribute("data-column-name", e3);
          var o3 = function(t4, e4) {
            for (var n4 = t4.getGridColumns(), i3 = 0; i3 < n4.length; i3++)
              if (n4[i3].name == e4)
                return i3;
            return 0;
          }(i2, e3);
          return a3.setAttribute("data-column-index", o3), n3.rtl ? a3.style.cssText = ["top:" + r4.top + "px", "right:" + r4.right + "px", "width:" + r4.width + "px", "height:" + r4.height + "px"].join(";") : a3.style.cssText = ["top:" + r4.top + "px", "left:" + r4.left + "px", "width:" + r4.width + "px", "height:" + r4.height + "px"].join(";"), a3;
        }
        var a2 = f(t2), o2 = [], s2 = [], l2 = null, c2 = { _itemId: null, _columnName: null, _editor: null, _editorType: null, _placeholder: null, locateCell: function(t3) {
          if (!d.isChildOf(t3, i2.$grid))
            return null;
          var e3 = d.locateAttribute(t3, i2.$config.item_attribute), n3 = d.locateAttribute(t3, "data-column-name");
          if (e3 && n3) {
            var r4 = n3.getAttribute("data-column-name");
            return { id: e3.getAttribute(i2.$config.item_attribute), columnName: r4 };
          }
          return null;
        }, getEditorConfig: function(t3) {
          return i2.getColumn(t3).editor;
        }, init: function() {
          var n3 = e2.getMapping();
          n3.init && n3.init(this, i2), l2 = i2.$gantt.getDatastore(i2.$config.bind);
          var r4 = this;
          o2.push(l2.attachEvent("onIdChange", function(t3, e3) {
            r4._itemId == t3 && (r4._itemId = e3);
          })), o2.push(l2.attachEvent("onStoreUpdated", function() {
            i2.$gantt.getState("batchUpdate").batch_update || r4.isVisible() && !l2.isVisible(r4._itemId) && r4.hide();
          })), s2.push(t2.attachEvent("onDataRender", function() {
            r4._editor && r4._placeholder && !d.isChildOf(r4._placeholder, t2.$root) && i2.$grid_data.appendChild(r4._placeholder);
          })), this.init = function() {
          };
        }, getState: function() {
          return { editor: this._editor, editorType: this._editorType, placeholder: this._placeholder, id: this._itemId, columnName: this._columnName };
        }, startEdit: function(e3, n3) {
          if (this.isVisible() && this.save(), l2.exists(e3)) {
            var i3 = { id: e3, columnName: n3 };
            t2.isReadonly(l2.getItem(e3)) ? this.callEvent("onEditPrevent", [i3]) : false !== this.callEvent("onBeforeEditStart", [i3]) ? (this.show(i3.id, i3.columnName), this.setValue(), this.callEvent("onEditStart", [i3])) : this.callEvent("onEditPrevent", [i3]);
          }
        }, isVisible: function() {
          return !(!this._editor || !d.isChildOf(this._placeholder, t2.$root));
        }, show: function(t3, n3) {
          this.isVisible() && this.save();
          var a3 = { id: t3, columnName: n3 }, o3 = i2.getColumn(a3.columnName), s3 = this.getEditorConfig(o3.name);
          if (s3) {
            var l3 = i2.$getConfig().editor_types[s3.type], c3 = r3(a3.id, a3.columnName);
            i2.$grid_data.appendChild(c3), l3.show(a3.id, o3, s3, c3), this._editor = l3, this._placeholder = c3, this._itemId = a3.id, this._columnName = a3.columnName, this._editorType = s3.type;
            var u2 = e2.getMapping();
            u2.onShow && u2.onShow(this, c3, i2);
          }
        }, setValue: function() {
          var t3 = this.getState(), e3 = t3.id, n3 = t3.columnName, r4 = i2.getColumn(n3), a3 = l2.getItem(e3), o3 = this.getEditorConfig(n3);
          if (o3) {
            var s3 = a3[o3.map_to];
            "auto" == o3.map_to && (s3 = l2.getItem(e3)), this._editor.set_value(s3, e3, r4, this._placeholder), this.focus();
          }
        }, focus: function() {
          this._editor.focus(this._placeholder);
        }, getValue: function() {
          var t3 = i2.getColumn(this._columnName);
          return this._editor.get_value(this._itemId, t3, this._placeholder);
        }, _getItemValue: function() {
          var e3 = this.getEditorConfig(this._columnName);
          if (e3) {
            var n3 = t2.getTask(this._itemId)[e3.map_to];
            return "auto" == e3.map_to && (n3 = l2.getItem(this._itemId)), n3;
          }
        }, isChanged: function() {
          var t3 = i2.getColumn(this._columnName), e3 = this._getItemValue();
          return this._editor.is_changed(e3, this._itemId, t3, this._placeholder);
        }, hide: function() {
          if (this._itemId) {
            var t3 = this._itemId, n3 = this._columnName, r4 = e2.getMapping();
            r4.onHide && r4.onHide(this, this._placeholder, i2), this._itemId = null, this._columnName = null, this._editorType = null, this._placeholder && (this._editor && this._editor.hide && this._editor.hide(this._placeholder), this._editor = null, this._placeholder.parentNode && this._placeholder.parentNode.removeChild(this._placeholder), this._placeholder = null, this.callEvent("onEditEnd", [{ id: t3, columnName: n3 }]));
          }
        }, save: function() {
          if (this.isVisible() && l2.exists(this._itemId) && this.isChanged()) {
            var e3 = this._itemId, n3 = this._columnName;
            if (l2.exists(e3)) {
              var r4 = l2.getItem(e3), o3 = this.getEditorConfig(n3), s3 = { id: e3, columnName: n3, newValue: this.getValue(), oldValue: this._getItemValue() };
              if (false !== this.callEvent("onBeforeSave", [s3]) && (!this._editor.is_valid || this._editor.is_valid(s3.newValue, s3.id, s3.columnName, this._placeholder))) {
                var c3 = o3.map_to, u2 = s3.newValue;
                "auto" != c3 ? (r4[c3] = u2, a2(r4, c3, t2.config.inline_editors_date_processing), l2.updateItem(e3)) : this._editor.save(e3, i2.getColumn(n3), this._placeholder), this.callEvent("onSave", [s3]);
              }
              this.hide();
            }
          } else
            this.hide();
        }, _findEditableCell: function(t3, e3) {
          var n3 = t3, r4 = i2.getGridColumns()[n3], a3 = r4 ? r4.name : null;
          if (a3) {
            for (; a3 && !this.getEditorConfig(a3); )
              a3 = this._findEditableCell(t3 + e3, e3);
            return a3;
          }
          return null;
        }, getNextCell: function(t3) {
          return this._findEditableCell(i2.getColumnIndex(this._columnName, true) + t3, t3);
        }, getFirstCell: function() {
          return this._findEditableCell(0, 1);
        }, getLastCell: function() {
          return this._findEditableCell(i2.getGridColumns().length - 1, -1);
        }, editNextCell: function(t3) {
          var e3 = this.getNextCell(1);
          if (e3) {
            var n3 = this.getNextCell(1);
            n3 && this.getEditorConfig(n3) && this.startEdit(this._itemId, n3);
          } else if (t3 && this.moveRow(1)) {
            var i3 = this.moveRow(1);
            (e3 = this.getFirstCell()) && this.getEditorConfig(e3) && this.startEdit(i3, e3);
          }
        }, editPrevCell: function(t3) {
          var e3 = this.getNextCell(-1);
          if (e3) {
            var n3 = this.getNextCell(-1);
            n3 && this.getEditorConfig(n3) && this.startEdit(this._itemId, n3);
          } else if (t3 && this.moveRow(-1)) {
            var i3 = this.moveRow(-1);
            (e3 = this.getLastCell()) && this.getEditorConfig(e3) && this.startEdit(i3, e3);
          }
        }, moveRow: function(e3) {
          for (var n3 = e3 > 0 ? t2.getNext : t2.getPrev, i3 = (n3 = t2.bind(n3, t2))(this._itemId); t2.isTaskExists(i3) && t2.isReadonly(t2.getTask(i3)); )
            i3 = n3(i3);
          return i3;
        }, editNextRow: function(e3) {
          var n3 = this.getState().id;
          if (t2.isTaskExists(n3)) {
            var i3 = null;
            i3 = e3 ? this.moveRow(1) : t2.getNext(n3), t2.isTaskExists(i3) && this.startEdit(i3, this._columnName);
          }
        }, editPrevRow: function(e3) {
          var n3 = this.getState().id;
          if (t2.isTaskExists(n3)) {
            var i3 = null;
            i3 = e3 ? this.moveRow(-1) : t2.getPrev(n3), t2.isTaskExists(i3) && this.startEdit(i3, this._columnName);
          }
        }, destructor: function() {
          o2.forEach(function(t3) {
            l2.detachEvent(t3);
          }), s2.forEach(function(e3) {
            t2.detachEvent(e3);
          }), o2 = [], s2 = [], l2 = null, this.hide(), this.detachAllEvents();
        } };
        return u.mixin(c2, e2), u.mixin(c2, n2), c2;
      } };
      return u.mixin(r2, e2), u.mixin(r2, n2), r2;
    };
  }, function(t, e, n) {
    var i = n(0), r = n(33), a = n(24), o = n(3), s = function(t2) {
      function e2(e3, n2, i2, r2) {
        var a2 = t2.apply(this, arguments) || this;
        return a2.$config.bindLinks = null, a2;
      }
      return o(e2, t2), i.mixin(e2.prototype, { _createLayerConfig: function() {
        var t3 = this, e3 = function() {
          return t3.isVisible();
        };
        return { tasks: [{ renderer: this.$gantt.$ui.layers.resourceHistogram(), container: this.$task_bars, filter: [e3] }, { renderer: this.$gantt.$ui.layers.taskBg(), container: this.$task_bg, filter: [e3] }], links: [] };
      } }, true), i.mixin(e2.prototype, a(t2), true), e2;
    }(r);
    t.exports = s;
  }, function(t, e, n) {
    var i = n(1), r = n(0), a = n(24), o = n(27), s = n(3), l = function(t2) {
      function e2(e3, n2, i2, r2) {
        return t2.apply(this, arguments) || this;
      }
      return s(e2, t2), r.mixin(e2.prototype, { init: function() {
        void 0 === this.$config.bind && (this.$config.bind = this.$getConfig().resource_store), t2.prototype.init.apply(this, arguments);
      }, _initEvents: function() {
        var e3 = this.$gantt;
        t2.prototype._initEvents.apply(this, arguments), this._mouseDelegates.delegate("click", "gantt_row", e3.bind(function(t3, e4, n2) {
          var r2 = this.$config.rowStore;
          if (!r2)
            return true;
          var a2 = i.locateAttribute(t3, this.$config.item_attribute);
          return a2 && r2.select(a2.getAttribute(this.$config.item_attribute)), false;
        }, this), this.$grid);
      } }, true), r.mixin(e2.prototype, a(e2), true), e2;
    }(o);
    t.exports = l;
  }, function(t, e, n) {
    var i = n(0), r = n(7), a = function(t2, e2) {
      var n2 = {}, i2 = "gantt-static-bg-styles-" + t2.uid();
      function r2(t3) {
        var e3 = /^rgba?\(([\d]{1,3}), *([\d]{1,3}), *([\d]{1,3}) *(,( *[\d.]+ *))?\)$/i.exec(t3);
        return e3 ? { r: 1 * e3[1], g: 1 * e3[2], b: 1 * e3[3], a: 255 * e3[5] || 255 } : null;
      }
      function a2(t3) {
        return n2[t3] || null;
      }
      function o(t3, e3, n3) {
        return (t3 + "" + e3 + n3.bottomBorderColor + n3.rightBorderColor).replace(/[^\w\d]/g, "");
      }
      function s(t3, e3) {
        n2[t3] = e3;
      }
      function l(t3, e3, n3) {
        var i3 = Math.floor(500 / t3) || 1, a3 = Math.floor(500 / e3) || 1, o2 = document.createElement("canvas");
        o2.height = e3 * a3, o2.width = t3 * i3;
        var s2 = o2.getContext("2d");
        return function(t4, e4, n4, i4, a4, o3) {
          var s3 = a4.createImageData(e4 * i4, t4 * n4);
          s3.imageSmoothingEnabled = false;
          for (var c2 = 1 * o3.rightBorderWidth, u2 = r2(o3.rightBorderColor), d = 0, h2 = 0, f = 0, _2 = 1; _2 <= i4; _2++)
            for (d = _2 * e4 - 1, f = 0; f < c2; f++)
              for (h2 = 0; h2 < t4 * n4; h2++)
                l2(d - f, h2, u2, s3);
          var g = 1 * o3.bottomBorderWidth, p = r2(o3.bottomBorderColor);
          h2 = 0;
          for (var v2 = 1; v2 <= n4; v2++)
            for (h2 = v2 * t4 - 1, f = 0; f < g; f++)
              for (d = 0; d < e4 * i4; d++)
                l2(d, h2 - f, p, s3);
          a4.putImageData(s3, 0, 0);
        }(e3, t3, a3, i3, s2, n3), o2.toDataURL();
        function l2(e4, n4, r3, a4) {
          var o3 = 4 * (n4 * (t3 * i3) + e4);
          a4.data[o3] = r3.r, a4.data[o3 + 1] = r3.g, a4.data[o3 + 2] = r3.b, a4.data[o3 + 3] = r3.a;
        }
      }
      function c(t3) {
        return "gantt-static-bg-" + t3;
      }
      function u() {
        var t3 = document.createElement("div");
        t3.className = "gantt_task_cell";
        var e3 = document.createElement("div");
        return e3.className = "gantt_task_row", e3.appendChild(t3), e3;
      }
      return { render: function(t3, n3, r3, d, h2) {
        if (n3.static_background && document.createElement("canvas").getContext) {
          t3.innerHTML = "";
          var f = function(t4, n4, i3, r4) {
            var a3, o2, s2 = [], l2 = 0, c2 = i3.width.filter(function(t5) {
              return !!t5;
            }), u2 = 0, d2 = 1e5;
            if (e2.isIE) {
              var h3 = navigator.appVersion || "";
              -1 == h3.indexOf("Windows NT 6.2") && -1 == h3.indexOf("Windows NT 6.1") && -1 == h3.indexOf("Windows NT 6.0") || (d2 = 2e4);
            }
            for (var f2 = 0; f2 < c2.length; f2++) {
              var _3 = c2[f2];
              if (_3 != o2 && void 0 !== o2 || f2 == c2.length - 1 || l2 > d2) {
                for (var g = r4, p = 0, v2 = Math.floor(d2 / n4.row_height) * n4.row_height, m = l2; g > 0; ) {
                  var y = Math.min(g, v2);
                  g -= v2, (a3 = document.createElement("div")).style.height = y + "px", a3.style.position = "absolute", a3.style.top = p + "px", a3.style.left = u2 + "px", a3.style.pointerEvents = "none", a3.style.whiteSpace = "no-wrap", a3.className = t4[o2 || _3], f2 == c2.length - 1 && (m = _3 + m - 1), a3.style.width = m + "px", s2.push(a3), p += y;
                }
                l2 = 0, u2 += m;
              }
              _3 && (l2 += _3, o2 = _3);
            }
            return s2;
          }(function(t4, e3, n4, r4) {
            var u2 = {}, d2 = function(t5) {
              for (var e4 = t5.width, n5 = {}, i3 = 0; i3 < e4.length; i3++)
                1 * e4[i3] && (n5[e4[i3]] = true);
              return n5;
            }(n4), h3 = r4, f2 = "";
            for (var _3 in d2) {
              var g = 1 * _3, p = o(g, h3, t4), v2 = a2(p);
              if (!v2) {
                var m = l(g, h3, t4);
                s(p, m), f2 += "." + c(p) + "{ background-image: url('" + m + "');}";
              }
              u2[_3] = c(p);
            }
            if (f2) {
              var y = function() {
                var t5 = document.getElementById(i2);
                return t5 || ((t5 = document.createElement("style")).id = i2, document.body.appendChild(t5)), t5;
              }();
              y.innerHTML += f2;
            }
            return u2;
          }(function(t4) {
            var e3 = u(), n4 = u();
            t4.appendChild(e3), t4.appendChild(n4);
            var i3 = e3.firstChild, r4 = getComputedStyle(e3), a3 = getComputedStyle(i3), o2 = { bottomBorderWidth: r4.getPropertyValue("border-bottom-width").replace("px", ""), rightBorderWidth: a3.getPropertyValue("border-right-width").replace("px", ""), bottomBorderColor: r4.getPropertyValue("border-bottom-color"), rightBorderColor: a3.getPropertyValue("border-right-color") };
            return t4.removeChild(e3), t4.removeChild(n4), o2;
          }(t3), 0, r3, h2), n3, r3, d), _2 = document.createDocumentFragment();
          f.forEach(function(t4) {
            _2.appendChild(t4);
          }), t3.appendChild(_2);
        }
      }, destroy: function() {
        var t3 = document.getElementById(i2);
        t3 && t3.parentNode && t3.parentNode.removeChild(t3);
      } };
    };
    t.exports = { create: function() {
      return a(i, r);
    } };
  }, function(t, e, n) {
    var i = n(3), r = n(1), a = n(0), o = n(7), s = function(t2) {
      var e2 = ["altKey", "shiftKey", "metaKey"];
      function n2(e3, n3, i2, r2) {
        var o2 = t2.apply(this, arguments) || this;
        this.$config = a.mixin(n3, { scroll: "x" }), o2._scrollHorizontalHandler = a.bind(o2._scrollHorizontalHandler, o2), o2._scrollVerticalHandler = a.bind(o2._scrollVerticalHandler, o2), o2._outerScrollVerticalHandler = a.bind(o2._outerScrollVerticalHandler, o2), o2._outerScrollHorizontalHandler = a.bind(o2._outerScrollHorizontalHandler, o2), o2._mouseWheelHandler = a.bind(o2._mouseWheelHandler, o2), this.$config.hidden = true;
        var s2 = r2.config.scroll_size;
        return r2.env.isIE && (s2 += 1), this._isHorizontal() ? (o2.$config.height = s2, o2.$parent.$config.height = s2) : (o2.$config.width = s2, o2.$parent.$config.width = s2), this.$config.scrollPosition = 0, o2.$name = "scroller", o2;
      }
      return i(n2, t2), n2.prototype.init = function(t3) {
        t3.innerHTML = this.$toHTML(), this.$view = t3.firstChild, this.$view || this.init(), this._isVertical() ? this._initVertical() : this._initHorizontal(), this._initMouseWheel(), this._initLinkedViews();
      }, n2.prototype.$toHTML = function() {
        return "<div class='gantt_layout_cell " + (this._isHorizontal() ? "gantt_hor_scroll" : "gantt_ver_scroll") + "'><div style='" + (this._isHorizontal() ? "width:2000px" : "height:2000px") + "'></div></div>";
      }, n2.prototype._getRootParent = function() {
        for (var t3 = this.$parent; t3 && t3.$parent; )
          t3 = t3.$parent;
        if (t3)
          return t3;
      }, n2.prototype._eachView = function() {
        var t3 = [];
        return function t4(e3, n3) {
          if (n3.push(e3), e3.$cells)
            for (var i2 = 0; i2 < e3.$cells.length; i2++)
              t4(e3.$cells[i2], n3);
        }(this._getRootParent(), t3), t3;
      }, n2.prototype._getLinkedViews = function() {
        for (var t3 = this._eachView(), e3 = [], n3 = 0; n3 < t3.length; n3++)
          t3[n3].$config && (this._isVertical() && t3[n3].$config.scrollY == this.$id || this._isHorizontal() && t3[n3].$config.scrollX == this.$id) && e3.push(t3[n3]);
        return e3;
      }, n2.prototype._initHorizontal = function() {
        this.$scroll_hor = this.$view, this.$domEvents.attach(this.$view, "scroll", this._scrollHorizontalHandler);
      }, n2.prototype._initLinkedViews = function() {
        for (var t3 = this._getLinkedViews(), e3 = this._isVertical() ? "gantt_layout_outer_scroll gantt_layout_outer_scroll_vertical" : "gantt_layout_outer_scroll gantt_layout_outer_scroll_horizontal", n3 = 0; n3 < t3.length; n3++)
          r.addClassName(t3[n3].$view || t3[n3].getNode(), e3);
      }, n2.prototype._initVertical = function() {
        this.$scroll_ver = this.$view, this.$domEvents.attach(this.$view, "scroll", this._scrollVerticalHandler);
      }, n2.prototype._updateLinkedViews = function() {
      }, n2.prototype._initMouseWheel = function() {
        o.isFF ? this.$domEvents.attach(this._getRootParent().$view, "wheel", this._mouseWheelHandler, { passive: false }) : this.$domEvents.attach(this._getRootParent().$view, "mousewheel", this._mouseWheelHandler, { passive: false });
      }, n2.prototype.scrollHorizontally = function(t3) {
        if (!this._scrolling) {
          this._scrolling = true, this.$scroll_hor.scrollLeft = t3, this.$config.codeScrollLeft = t3, t3 = this.$scroll_hor.scrollLeft;
          for (var e3 = this._getLinkedViews(), n3 = 0; n3 < e3.length; n3++)
            e3[n3].scrollTo && e3[n3].scrollTo(t3, void 0);
          var i2 = this.$config.scrollPosition;
          this.$config.scrollPosition = t3, this.callEvent("onScroll", [i2, t3, this.$config.scroll]), this._scrolling = false;
        }
      }, n2.prototype.scrollVertically = function(t3) {
        if (!this._scrolling) {
          this._scrolling = true, this.$scroll_ver.scrollTop = t3, t3 = this.$scroll_ver.scrollTop;
          for (var e3 = this._getLinkedViews(), n3 = 0; n3 < e3.length; n3++)
            e3[n3].scrollTo && e3[n3].scrollTo(void 0, t3);
          var i2 = this.$config.scrollPosition;
          this.$config.scrollPosition = t3, this.callEvent("onScroll", [i2, t3, this.$config.scroll]), this._scrolling = false;
        }
      }, n2.prototype._isVertical = function() {
        return "y" == this.$config.scroll;
      }, n2.prototype._isHorizontal = function() {
        return "x" == this.$config.scroll;
      }, n2.prototype._scrollHorizontalHandler = function(t3) {
        if (!this._isVertical() && !this._scrolling) {
          if (/* @__PURE__ */ new Date() - (this._wheel_time || 0) < 100)
            return true;
          var e3 = this.$scroll_hor.scrollLeft;
          this.scrollHorizontally(e3), this._oldLeft = this.$scroll_hor.scrollLeft;
        }
      }, n2.prototype._outerScrollHorizontalHandler = function(t3) {
        this._isVertical();
      }, n2.prototype.show = function() {
        this.$parent.show();
      }, n2.prototype.hide = function() {
        this.$parent.hide();
      }, n2.prototype._getScrollSize = function() {
        for (var t3, e3 = 0, n3 = 0, i2 = this._isHorizontal(), r2 = this._getLinkedViews(), a2 = i2 ? "scrollWidth" : "scrollHeight", o2 = i2 ? "contentX" : "contentY", s2 = i2 ? "x" : "y", l = this._getScrollOffset(), c = 0; c < r2.length; c++)
          if ((t3 = r2[c]) && t3.$content && t3.$content.getSize && !t3.$config.hidden) {
            var u, d = t3.$content.getSize();
            if (u = d.hasOwnProperty(a2) ? d[a2] : d[o2], l)
              d[o2] > d[s2] && d[o2] > e3 && u > d[s2] - l + 2 && (e3 = u + (i2 ? 0 : 2), n3 = d[s2]);
            else {
              var h2 = Math.max(d[o2] - u, 0);
              (u += h2) > Math.max(d[s2] - h2, 0) && u > e3 && (e3 = u, n3 = d[s2]);
            }
          }
        return { outerScroll: n3, innerScroll: e3 };
      }, n2.prototype.scroll = function(t3) {
        this._isHorizontal() ? this.scrollHorizontally(t3) : this.scrollVertically(t3);
      }, n2.prototype.getScrollState = function() {
        return { visible: this.isVisible(), direction: this.$config.scroll, size: this.$config.outerSize, scrollSize: this.$config.scrollSize || 0, position: this.$config.scrollPosition || 0 };
      }, n2.prototype.setSize = function(e3, n3) {
        t2.prototype.setSize.apply(this, arguments);
        var i2 = this._getScrollSize(), r2 = (this._isVertical() ? n3 : e3) - this._getScrollOffset() + (this._isHorizontal() ? 1 : 0);
        i2.innerScroll && r2 > i2.outerScroll && (i2.innerScroll += r2 - i2.outerScroll), this.$config.scrollSize = i2.innerScroll, this.$config.width = e3, this.$config.height = n3, this._setScrollSize(i2.innerScroll);
      }, n2.prototype.isVisible = function() {
        return !(!this.$parent || !this.$parent.$view.parentNode);
      }, n2.prototype.shouldShow = function() {
        var t3 = this._getScrollSize();
        return !(!t3.innerScroll && this.$parent && this.$parent.$view.parentNode) && !(!t3.innerScroll || this.$parent && this.$parent.$view.parentNode);
      }, n2.prototype.shouldHide = function() {
        return !(this._getScrollSize().innerScroll || !this.$parent || !this.$parent.$view.parentNode);
      }, n2.prototype.toggleVisibility = function() {
        this.shouldHide() ? this.hide() : this.shouldShow() && this.show();
      }, n2.prototype._getScaleOffset = function(t3) {
        var e3 = 0;
        return !t3 || "timeline" != t3.$config.view && "grid" != t3.$config.view || (e3 = t3.$content.$getConfig().scale_height), e3;
      }, n2.prototype._getScrollOffset = function() {
        var t3 = 0;
        if (this._isVertical()) {
          var e3 = this.$parent.$parent;
          t3 = Math.max(this._getScaleOffset(e3.getPrevSibling(this.$parent.$id)), this._getScaleOffset(e3.getNextSibling(this.$parent.$id)));
        } else
          for (var n3 = this._getLinkedViews(), i2 = 0; i2 < n3.length; i2++) {
            var r2 = n3[i2].$parent.$cells, a2 = r2[r2.length - 1];
            if (a2 && "scrollbar" == a2.$config.view && false === a2.$config.hidden) {
              t3 = a2.$config.width;
              break;
            }
          }
        return t3 || 0;
      }, n2.prototype._setScrollSize = function(t3) {
        var e3 = this._isHorizontal() ? "width" : "height", n3 = this._isHorizontal() ? this.$scroll_hor : this.$scroll_ver, i2 = this._getScrollOffset(), a2 = n3.firstChild;
        i2 ? this._isVertical() ? (this.$config.outerSize = this.$config.height - i2 + 3, n3.style.height = this.$config.outerSize + "px", n3.style.top = i2 - 1 + "px", r.addClassName(n3, this.$parent._borders.top), r.addClassName(n3.parentNode, "gantt_task_vscroll")) : (this.$config.outerSize = this.$config.width - i2 + 1, n3.style.width = this.$config.outerSize + "px") : (n3.style.top = "auto", r.removeClassName(n3, this.$parent._borders.top), r.removeClassName(n3.parentNode, "gantt_task_vscroll"), this.$config.outerSize = this.$config.height), a2.style[e3] = t3 + "px";
      }, n2.prototype._scrollVerticalHandler = function(t3) {
        if (!this._scrollHorizontalHandler() && !this._scrolling) {
          var e3 = this.$scroll_ver.scrollTop;
          e3 != this._oldTop && (this.scrollVertically(e3), this._oldTop = this.$scroll_ver.scrollTop);
        }
      }, n2.prototype._outerScrollVerticalHandler = function(t3) {
        this._scrollHorizontalHandler();
      }, n2.prototype._checkWheelTarget = function(t3) {
        for (var e3 = this._getLinkedViews().concat(this), n3 = 0; n3 < e3.length; n3++) {
          var i2 = e3[n3].$view;
          if (r.isChildOf(t3, i2))
            return true;
        }
        return false;
      }, n2.prototype._mouseWheelHandler = function(t3) {
        var n3 = t3.target || t3.srcElement;
        if (this._checkWheelTarget(n3)) {
          this._wheel_time = /* @__PURE__ */ new Date();
          var i2 = {}, r2 = { x: 1, y: 1 }, a2 = this.$gantt.config.wheel_scroll_sensitivity;
          "number" == typeof a2 && a2 ? r2 = { x: a2, y: a2 } : "[object Object]" == {}.toString.apply(a2) && (r2 = { x: a2.x, y: a2.y });
          var s2 = o.isFF, l = s2 ? t3.deltaX : t3.wheelDeltaX, c = s2 ? t3.deltaY : t3.wheelDelta, u = -20;
          s2 && (u = 0 !== t3.deltaMode ? -40 : -10);
          var d = s2 ? l * u * r2.x : 2 * l * r2.x, h2 = s2 ? c * u * r2.y : c * r2.y, f = this.$gantt.config.horizontal_scroll_key;
          if (false !== f && e2.indexOf(f) >= 0 && (!t3[f] || t3.deltaX || t3.wheelDeltaX || (d = 2 * h2, h2 = 0)), d && Math.abs(d) > Math.abs(h2)) {
            if (this._isVertical())
              return;
            if (i2.x)
              return true;
            if (!this.$scroll_hor || !this.$scroll_hor.offsetWidth)
              return true;
            var _2 = d / -40, g = this._oldLeft, p = g + 30 * _2;
            if (this.scrollHorizontally(p), this.$scroll_hor.scrollLeft = p, g == this.$scroll_hor.scrollLeft)
              return true;
            this._oldLeft = this.$scroll_hor.scrollLeft;
          } else {
            if (this._isHorizontal())
              return;
            if (i2.y)
              return true;
            if (!this.$scroll_ver || !this.$scroll_ver.offsetHeight)
              return true;
            _2 = h2 / -40;
            void 0 === h2 && (_2 = t3.detail);
            var v2 = this._oldTop, m = this.$scroll_ver.scrollTop + 30 * _2;
            if (this.scrollVertically(m), this.$scroll_ver.scrollTop = m, v2 == this.$scroll_ver.scrollTop)
              return true;
            this._oldTop = this.$scroll_ver.scrollTop;
          }
          return t3.preventDefault && t3.preventDefault(), t3.cancelBubble = true, false;
        }
      }, n2;
    }(n(9));
    t.exports = s;
  }, function(t, e, n) {
    var i = n(3), r = n(1), a = n(0), o = n(9), s = function(t2) {
      function e2(e3, n2, i2) {
        var r2, a2, o2 = t2.apply(this, arguments) || this;
        function s2(t3) {
          var e4 = t3.pageX, n3 = t3.pageY;
          return t3.touches && (e4 = t3.touches[0].pageX, n3 = t3.touches[0].pageY), { x: e4, y: n3 };
        }
        return o2._moveHandler = function(t3) {
          o2._moveResizer(o2._resizer, s2(t3).x, s2(t3).y);
        }, o2._upHandler = function(t3) {
          var e4 = o2._getNewSizes();
          false !== o2.callEvent("onResizeEnd", [r2, a2, e4 ? e4.back : 0, e4 ? e4.front : 0]) && o2._setSizes(), o2._setBackground(false), o2._clearResizer(), o2._clearListeneres(), t3.touches && (o2.$gantt._prevent_touch_scroll = false);
        }, o2._clearListeneres = function() {
          this.$domEvents.detach(document, "mouseup", o2._upHandler), this.$domEvents.detach(document, "mousemove", o2._moveHandler), this.$domEvents.detach(document, "mousemove", o2._startOnMove), this.$domEvents.detach(document, "mouseup", o2._cancelDND), this.$domEvents.detach(document, "touchend", o2._upHandler), this.$domEvents.detach(document, "touchmove", o2._startOnMove), this.$domEvents.detach(document, "touchstart", o2._downHandler);
        }, o2._callStartDNDEvent = function() {
          if (this._xMode ? (r2 = this._behind.$config.width || this._behind.$view.offsetWidth, a2 = this._front.$config.width || this._front.$view.offsetWidth) : (r2 = this._behind.$config.height || this._behind.$view.offsetHeight, a2 = this._front.$config.height || this._front.$view.offsetHeight), false === o2.callEvent("onResizeStart", [r2, a2]))
            return false;
        }, o2._startDND = function(t3) {
          if (false !== this._callStartDNDEvent()) {
            var e4 = false;
            this._eachGroupItem(function(t4) {
              t4._getSiblings(), false === t4._callStartDNDEvent() && (e4 = true);
            }), e4 || (o2._moveHandler(t3), o2.$domEvents.attach(document, "mousemove", o2._moveHandler), o2.$domEvents.attach(document, "mouseup", o2._upHandler));
          }
        }, o2._cancelDND = function() {
          o2._setBackground(false), o2._clearResizer(), o2._clearListeneres();
        }, o2._startOnMove = function(t3) {
          t3.touches && (o2.$gantt._prevent_touch_scroll = true), o2._isPosChanged(t3) && (o2._clearListeneres(), o2._startDND(t3));
        }, o2._downHandler = function(t3) {
          o2._getSiblings(), o2._behind.$config.collapsed || o2._front.$config.collapsed || (o2._setBackground(true), o2._resizer = o2._setResizer(), o2._positions = { x: s2(t3).x, y: s2(t3).y, timestamp: Date.now() }, o2.$domEvents.attach(document, "mousemove", o2._startOnMove), o2.$domEvents.attach(document, "mouseup", o2._cancelDND));
        }, o2.$name = "resizer", o2;
      }
      return i(e2, t2), e2.prototype.init = function() {
        t2.prototype.init.call(this), this._xMode = "x" === this.$config.mode, this._xMode && !this.$config.width ? this.$config.width = this.$config.minWidth = 1 : this._xMode || this.$config.height || (this.$config.height = this.$config.minHeight = 1), this.$config.margin = -1, this.$domEvents.attach(this.$view, "mousedown", this._downHandler), this.$domEvents.attach(this.$view, "touchstart", this._downHandler), this.$domEvents.attach(this.$view, "touchmove", this._startOnMove), this.$domEvents.attach(this.$view, "touchend", this._upHandler);
      }, e2.prototype.$toHTML = function() {
        var t3 = this.$config.mode, e3 = this.$config.css || "";
        return "<div class='gantt_layout_cell gantt_resizer gantt_resizer_" + t3 + "'><div class='gantt_layout_content gantt_resizer_" + t3 + (e3 ? " " + e3 : "") + "'></div></div>";
      }, e2.prototype._clearResizer = function() {
        this._resizer && (this._resizer.parentNode && this._resizer.parentNode.removeChild(this._resizer), this._resizer = null);
      }, e2.prototype._isPosChanged = function(t3) {
        return !!this._positions && (Math.abs(this._positions.x - t3.pageX) > 3 || Math.abs(this._positions.y - t3.pageY) > 3 || Date.now() - this._positions.timestamp > 300);
      }, e2.prototype._getSiblings = function() {
        var t3 = this.$parent.getCells();
        this.$config.prev && (this._behind = this.$factory.getView(this.$config.prev), this._behind instanceof o || (this._behind = this._behind.$parent)), this.$config.next && (this._front = this.$factory.getView(this.$config.next), this._front instanceof o || (this._front = this._behind.$parent));
        for (var e3 = 0; e3 < t3.length; e3++)
          this === t3[e3] && (this._behind || (this._behind = t3[e3 - 1]), this._front || (this._front = t3[e3 + 1]));
      }, e2.prototype._setBackground = function(t3) {
        var e3 = "gantt_resizing";
        if (!t3)
          return r.removeClassName(this._behind.$view, e3), r.removeClassName(this._front.$view, e3), void r.removeClassName(document.body, "gantt_noselect");
        r.addClassName(this._behind.$view, e3, true), r.addClassName(this._front.$view, e3, true), r.addClassName(document.body, "gantt_noselect", true);
      }, e2.prototype._setResizer = function() {
        var t3 = document.createElement("div");
        return t3.className = "gantt_resizer_stick", this.$view.appendChild(t3), this.$view.style.overflow = "visible", t3.style.height = this.$view.style.height, t3;
      }, e2.prototype._getDirection = function(t3, e3) {
        var n2;
        return (n2 = this._xMode ? t3 - this._positions.x : e3 - this._positions.y) ? n2 < 0 ? -1 : 1 : 0;
      }, e2.prototype._getResizePosition = function(t3, e3) {
        var n2, i2, r2, a2, o2;
        this._xMode ? (n2 = t3 - this._positions.x, i2 = this._behind.$config.width || this._behind.$view.offsetWidth, a2 = this._front.$config.width || this._front.$view.offsetWidth, r2 = this._behind.$config.minWidth, o2 = this._front.$config.minWidth) : (n2 = e3 - this._positions.y, i2 = this._behind.$config.height || this._behind.$view.offsetHeight, a2 = this._front.$config.height || this._front.$view.offsetHeight, r2 = this._front.$config.minHeight, o2 = this._front.$config.minHeight);
        var s2, l, c = this._getDirection(t3, e3);
        if (-1 === c) {
          if (l = a2 - n2, s2 = i2 - Math.abs(n2), a2 - n2 > this._front.$config.maxWidth)
            return;
          Math.abs(n2) >= i2 && (n2 = -Math.abs(i2 - 2)), i2 - Math.abs(n2) <= r2 && (n2 = -Math.abs(i2 - r2));
        } else
          l = a2 - Math.abs(n2), s2 = i2 + n2, i2 + n2 > this._behind.$config.maxWidth && (n2 = this._behind.$config.maxWidth - i2), Math.abs(n2) >= a2 && (n2 = a2 - 2), a2 - Math.abs(n2) <= o2 && (n2 = Math.abs(a2 - o2));
        return -1 === c ? (l = a2 - n2, s2 = i2 - Math.abs(n2)) : (l = a2 - Math.abs(n2), s2 = i2 + n2), { size: n2, newFrontSide: l, newBehindSide: s2 };
      }, e2.prototype._getGroupName = function() {
        return this._getSiblings(), this._front.$config.group || this._behind.$config.group;
      }, e2.prototype._eachGroupItem = function(t3, e3) {
        for (var n2 = this.$factory.getView("main"), i2 = this._getGroupName(), r2 = n2.getCellsByType("resizer"), a2 = 0; a2 < r2.length; a2++)
          r2[a2]._getGroupName() == i2 && r2[a2] != this && t3.call(e3 || this, r2[a2]);
      }, e2.prototype._getGroupResizePosition = function(t3, e3) {
        var n2 = this._getResizePosition(t3, e3);
        if (!this._getGroupName())
          return n2;
        var i2, r2 = [n2];
        this._eachGroupItem(function(n3) {
          n3._getSiblings();
          var i3 = a.copy(this._positions);
          this._xMode ? i3.x += n3._behind.$config.width - this._behind.$config.width : i3.y += n3._behind.$config.height - this._behind.$config.height, n3._positions = i3, r2.push(n3._getResizePosition(t3, e3));
        });
        for (var o2 = 0; o2 < r2.length; o2++) {
          if (!r2[o2])
            return;
          void 0 === i2 ? i2 = r2[o2] : r2[o2].newBehindSide > i2.newBehindSide && (i2 = r2[o2]);
        }
        return i2;
      }, e2.prototype._moveResizer = function(t3, e3, n2) {
        if (0 !== e3) {
          var i2 = this._getGroupResizePosition(e3, n2);
          i2 && 1 !== Math.abs(i2.size) && (this._xMode ? (t3.style.left = i2.size + "px", this._positions.nextX = i2.size || 0) : (t3.style.top = i2.size + "px", this._positions.nextY = i2.size || 0), this.callEvent("onResize", [i2.newBehindSide, i2.newFrontSide]));
        }
      }, e2.prototype._setGravity = function(t3) {
        var e3 = this._xMode ? "offsetWidth" : "offsetHeight", n2 = this._xMode ? this._positions.nextX : this._positions.nextY, i2 = this._front.$view[e3], r2 = this._behind.$view[e3], a2 = (i2 - n2) / i2 * this._front.getSize().gravity, o2 = (r2 + n2) / r2 * this._behind.getSize().gravity;
        "front" !== t3 && (this._front.$config.gravity = a2), "behind" !== t3 && (this._behind.$config.gravity = o2);
      }, e2.prototype._getNewSizes = function() {
        var t3, e3, n2;
        return this._xMode ? (t3 = this._behind.$config.width, e3 = this._front.$config.width, n2 = this._positions.nextX) : (t3 = this._behind.$config.height, e3 = this._front.$config.height, n2 = this._positions.nextY), e3 || t3 ? { front: e3 ? e3 - n2 || 1 : 0, back: t3 ? t3 + n2 || 1 : 0 } : null;
      }, e2.prototype._assignNewSizes = function(t3) {
        this._getSiblings();
        var e3 = this._xMode ? "width" : "height";
        t3 ? (t3.front ? this._front.$config[e3] = t3.front : this._setGravity("behind"), t3.back ? this._behind.$config[e3] = t3.back : this._setGravity("front")) : this._setGravity();
      }, e2.prototype._setSizes = function() {
        this._resizer && this.$view.removeChild(this._resizer);
        var t3 = this._getNewSizes();
        if (this._positions.nextX || this._positions.nextY) {
          this._assignNewSizes(t3);
          var e3, n2 = this._xMode ? "width" : "height";
          t3 && t3.front || this._front.$config.group && (e3 = { value: this._front.$config.gravity, isGravity: true }, this.$gantt.$layout._syncCellSizes(this._front.$config.group, e3)), t3 && t3.back || this._behind.$config.group && (e3 = { value: this._behind.$config.gravity, isGravity: true }, this.$gantt.$layout._syncCellSizes(this._behind.$config.group, e3)), t3 && (t3.front ? this._front.$config.group && (e3 = { value: this._front.$config[n2], isGravity: false }, this.$gantt.$layout._syncCellSizes(this._front.$config.group, e3)) : t3.back && this._behind.$config.group && (e3 = { value: this._behind.$config[n2], isGravity: false }, this.$gantt.$layout._syncCellSizes(this._behind.$config.group, e3))), this._getGroupName() ? this.$factory.getView("main").resize() : this.$parent.resize();
        }
      }, e2;
    }(o);
    t.exports = s;
  }, function(t, e, n) {
    var i = n(3), r = n(0), a = function(t2) {
      function e2(e3, n2, i2) {
        var a2 = t2.apply(this, arguments) || this;
        if (n2.view) {
          n2.id && (this.$id = r.uid());
          var o = r.copy(n2);
          if (delete o.config, delete o.templates, this.$content = this.$factory.createView(n2.view, this, o, this), !this.$content)
            return false;
        }
        return a2.$name = "viewCell", a2;
      }
      return i(e2, t2), e2.prototype.destructor = function() {
        this.clear(), t2.prototype.destructor.call(this);
      }, e2.prototype.clear = function() {
        if (this.$initialized = false, this.$content) {
          var e3 = this.$content.unload || this.$content.destructor;
          e3 && e3.call(this.$content);
        }
        t2.prototype.clear.call(this);
      }, e2.prototype.scrollTo = function(e3, n2) {
        this.$content && this.$content.scrollTo ? this.$content.scrollTo(e3, n2) : t2.prototype.scrollTo.call(this, e3, n2);
      }, e2.prototype._setContentSize = function(t3, e3) {
        var n2 = this._getBorderSizes();
        if ("number" == typeof t3) {
          var i2 = t3 + n2.horizontal;
          this.$config.width = i2;
        }
        if ("number" == typeof e3) {
          var r2 = e3 + n2.vertical;
          this.$config.height = r2;
        }
      }, e2.prototype.setSize = function(e3, n2) {
        if (t2.prototype.setSize.call(this, e3, n2), !this.$preResize && this.$content && !this.$initialized) {
          this.$initialized = true;
          var i2 = this.$view.childNodes[0], r2 = this.$view.childNodes[1];
          r2 || (r2 = i2), this.$content.init(r2);
        }
      }, e2.prototype.setContentSize = function() {
        !this.$preResize && this.$content && this.$initialized && this.$content.setSize(this.$lastSize.contentX, this.$lastSize.contentY);
      }, e2.prototype.getContentSize = function() {
        var e3 = t2.prototype.getContentSize.call(this);
        if (this.$content && this.$initialized) {
          var n2 = this.$content.getSize();
          e3.width = void 0 === n2.contentX ? n2.width : n2.contentX, e3.height = void 0 === n2.contentY ? n2.height : n2.contentY;
        }
        var i2 = this._getBorderSizes();
        return e3.width += i2.horizontal, e3.height += i2.vertical, e3;
      }, e2;
    }(n(9));
    t.exports = a;
  }, function(t, e, n) {
    var i = n(3), r = n(35), a = n(9), o = function(t2) {
      function e2(e3, n2, i2) {
        for (var r2 = t2.apply(this, arguments) || this, a2 = 0; a2 < r2.$cells.length; a2++)
          r2.$cells[a2].$config.hidden = 0 !== a2;
        return r2.$cell = r2.$cells[0], r2.$name = "viewLayout", r2;
      }
      return i(e2, t2), e2.prototype.cell = function(e3) {
        var n2 = t2.prototype.cell.call(this, e3);
        return n2.$view || this.$fill(null, this), n2;
      }, e2.prototype.moveView = function(t3) {
        var e3 = this.$view;
        this.$cell && (this.$cell.$config.hidden = true, e3.removeChild(this.$cell.$view)), this.$cell = t3, e3.appendChild(t3.$view);
      }, e2.prototype.setSize = function(t3, e3) {
        a.prototype.setSize.call(this, t3, e3);
      }, e2.prototype.setContentSize = function() {
        var t3 = this.$lastSize;
        this.$cell.setSize(t3.contentX, t3.contentY);
      }, e2.prototype.getSize = function() {
        var e3 = t2.prototype.getSize.call(this);
        if (this.$cell) {
          var n2 = this.$cell.getSize();
          if (this.$config.byMaxSize)
            for (var i2 = 0; i2 < this.$cells.length; i2++) {
              var r2 = this.$cells[i2].getSize();
              for (var a2 in n2)
                n2[a2] = Math.max(n2[a2], r2[a2]);
            }
          for (var o2 in e3)
            e3[o2] = e3[o2] || n2[o2];
          e3.gravity = Math.max(e3.gravity, n2.gravity);
        }
        return e3;
      }, e2;
    }(r);
    t.exports = o;
  }, function(t, e) {
    t.exports = function(t2, e2) {
      return !!e2 && (!(e2.left > t2.x_end || e2.left + e2.width < t2.x) && !(e2.top > t2.y_end || e2.top + e2.height < t2.y));
    };
  }, function(t, e, n) {
    var i = n(122), r = n(13), a = n(25), o = n(6);
    t.exports = function(t2) {
      var e2 = {}, n2 = {};
      function s(e3) {
        var n3 = null;
        return "string" == typeof e3.view ? n3 = t2.$ui.getView(e3.view) : e3.view && (n3 = e3.view), n3;
      }
      function l(l2, c, u) {
        if (n2[l2])
          return n2[l2];
        c.renderer || t2.assert(false, "Invalid renderer call");
        var d = null, h2 = null, f = null, _2 = null, g = null;
        "function" == typeof c.renderer ? (d = c.renderer, f = a) : (d = c.renderer.render, h2 = c.renderer.update, _2 = c.renderer.onrender, c.renderer.isInViewPort ? g = c.renderer.isInViewPort : f = c.renderer.getRectangle, f || null === f || (f = a));
        var p = c.filter;
        return u && u.setAttribute(t2.config.layer_attribute, true), n2[l2] = { render_item: function(e3, n3, a2, o2, l3) {
          if (n3 = n3 || u, !p || p(e3)) {
            var h3 = o2 || s(c), v2 = l3 || (h3 ? h3.$getConfig() : null), m = a2;
            !m && v2 && v2.smart_rendering && (m = h3.getViewPort());
            var y = null;
            !r(t2) && (f || g) && m ? (g ? g(e3, m, h3, v2, t2) : i(m, f(e3, h3, v2, t2))) && (y = d.call(t2, e3, h3, v2, m)) : y = d.call(t2, e3, h3, v2, m), this.append(e3, y, n3);
            var k2 = 11 == n3.nodeType;
            _2 && !k2 && y && _2.call(t2, e3, y, h3);
          } else
            this.remove_item(e3.id);
        }, clear: function(t3) {
          this.rendered = e2[l2] = {}, c.append || this.clear_container(t3);
        }, clear_container: function(t3) {
          (t3 = t3 || u) && (t3.innerHTML = "");
        }, get_visible_range: function(e3) {
          var n3, i2, r2 = s(c), a2 = r2 ? r2.$getConfig() : null;
          return a2 && a2.smart_rendering && (n3 = r2.getViewPort()), r2 && n3 && ("function" == typeof c.renderer ? i2 = o(t2, r2, a2, e3, n3) : c.renderer && c.renderer.getVisibleRange && (i2 = c.renderer.getVisibleRange(t2, r2, a2, e3, n3))), i2 || (i2 = { start: 0, end: e3.count() }), i2;
        }, render_items: function(e3, n3) {
          n3 = n3 || u;
          var i2 = document.createDocumentFragment();
          this.clear(n3);
          var r2 = null, a2 = s(c), o2 = a2 ? a2.$getConfig() : null;
          o2 && o2.smart_rendering && (r2 = a2.getViewPort());
          for (var l3 = 0, d2 = e3.length; l3 < d2; l3++)
            this.render_item(e3[l3], i2, r2, a2, o2);
          n3.appendChild(i2, n3);
          var h3 = {};
          e3.forEach(function(t3) {
            h3[t3.id] = t3;
          });
          var f2 = {};
          if (_2) {
            var g2 = {};
            for (var l3 in this.rendered)
              f2[l3] || (g2[l3] = this.rendered[l3], _2.call(t2, h3[l3], this.rendered[l3], a2));
          }
        }, update_items: function(e3, n3) {
          var a2 = s(c), o2 = a2 ? a2.$getConfig() : null;
          if (a2 && a2.$getConfig().smart_rendering && !r(t2) && this.rendered && (f || g)) {
            n3 = n3 || u;
            var l3 = document.createDocumentFragment(), d2 = null;
            a2 && (d2 = a2.getViewPort());
            var p2 = {};
            e3.forEach(function(t3) {
              p2[t3.id] = t3;
            });
            var v2 = {}, m = {};
            for (var y in this.rendered)
              m[y] = true, v2[y] = true;
            for (var k2 = {}, b = (y = 0, e3.length); y < b; y++) {
              var w = e3[y], x = this.rendered[w.id];
              m[w.id] = false, x && x.parentNode ? (g ? g(w, d2, a2, o2, t2) : i(d2, f(w, a2, o2, t2))) ? (h2 && h2.call(t2, w, x, a2, o2, d2), this.restore(w, l3)) : m[w.id] = true : (k2[e3[y].id] = true, this.render_item(e3[y], l3, d2, a2, o2));
            }
            for (var y in m)
              m[y] && this.hide(y);
            if (l3.childNodes.length && n3.appendChild(l3, n3), _2) {
              var S = {};
              for (var y in this.rendered)
                v2[y] && !k2[y] || (S[y] = this.rendered[y], _2.call(t2, p2[y], this.rendered[y], a2));
            }
          }
        }, append: function(t3, e3, n3) {
          this.rendered && (e3 ? (this.rendered[t3.id] && this.rendered[t3.id].parentNode ? this.replace_item(t3.id, e3) : n3.appendChild(e3), this.rendered[t3.id] = e3) : this.rendered[t3.id] && this.remove_item(t3.id));
        }, replace_item: function(t3, e3) {
          var n3 = this.rendered[t3];
          n3 && n3.parentNode && n3.parentNode.replaceChild(e3, n3), this.rendered[t3] = e3;
        }, remove_item: function(t3) {
          this.hide(t3), delete this.rendered[t3];
        }, hide: function(t3) {
          var e3 = this.rendered[t3];
          e3 && e3.parentNode && e3.parentNode.removeChild(e3);
        }, restore: function(t3, e3) {
          var n3 = this.rendered[t3.id];
          n3 ? n3.parentNode || this.append(t3, n3, e3 || u) : this.render_item(t3, e3 || u);
        }, change_id: function(t3, e3) {
          this.rendered[e3] = this.rendered[t3], delete this.rendered[t3];
        }, rendered: e2[l2], node: u, destructor: function() {
          this.clear(), delete n2[l2], delete e2[l2];
        } }, n2[l2];
      }
      return { getRenderer: l, clearRenderers: function() {
        for (var t3 in n2)
          l(t3).destructor();
      } };
    };
  }, function(t, e, n) {
    var i = n(123), r = n(0), a = n(1), o = n(13);
    function s(t2) {
      return t2 instanceof Array || (t2 = Array.prototype.slice.call(arguments, 0)), function(e2) {
        for (var n2 = true, i2 = 0, r2 = t2.length; i2 < r2; i2++) {
          var a2 = t2[i2];
          a2 && (n2 = n2 && false !== a2(e2.id, e2));
        }
        return n2;
      };
    }
    t.exports = function(t2) {
      var e2 = i(t2);
      return { createGroup: function(n2, i2, l, c) {
        var u = { tempCollection: [], renderers: {}, container: n2, filters: [], getLayers: function() {
          this._add();
          var t3 = [];
          for (var e3 in this.renderers)
            t3.push(this.renderers[e3]);
          return t3;
        }, getLayer: function(t3) {
          return this.renderers[t3];
        }, _add: function(n3) {
          n3 && (n3.id = n3.id || r.uid(), this.tempCollection.push(n3));
          for (var o2 = this.container(), s2 = this.tempCollection, l2 = 0; l2 < s2.length; l2++)
            if (n3 = s2[l2], this.container() || n3 && n3.container && a.isChildOf(n3.container, document.body)) {
              var u2 = n3.container, d = n3.id, h2 = n3.topmost;
              if (!u2.parentNode)
                if (h2)
                  o2.appendChild(u2);
                else {
                  var f = i2 ? i2() : o2.firstChild;
                  f && f.parentNode == o2 ? o2.insertBefore(u2, f) : o2.appendChild(u2);
                }
              this.renderers[d] = e2.getRenderer(d, n3, u2), c && c(n3, t2), this.tempCollection.splice(l2, 1), l2--;
            }
        }, addLayer: function(e3) {
          if (e3) {
            "function" == typeof e3 && (e3 = { renderer: e3 }), void 0 === e3.filter ? e3.filter = s(l || []) : e3.filter instanceof Array && (e3.filter.push(l), e3.filter = s(e3.filter)), e3.container || (e3.container = document.createElement("div"));
            var n3 = this;
            e3.requestUpdate = function() {
              t2.config.smart_rendering && !o(t2) && n3.renderers[e3.id] && n3.onUpdateRequest(n3.renderers[e3.id]);
            };
          }
          return this._add(e3), e3 ? e3.id : void 0;
        }, onUpdateRequest: function(t3) {
        }, eachLayer: function(t3) {
          for (var e3 in this.renderers)
            t3(this.renderers[e3]);
        }, removeLayer: function(t3) {
          this.renderers[t3] && (this.renderers[t3].destructor(), delete this.renderers[t3]);
        }, clear: function() {
          for (var t3 in this.renderers)
            this.renderers[t3].destructor();
          this.renderers = {};
        } };
        return t2.attachEvent("onDestroy", function() {
          u.clear(), u = null;
        }), u;
      } };
    };
  }, function(t, e, n) {
    var i = n(124);
    function r(t2, e2) {
      if (t2.view) {
        var n2 = t2.view;
        "string" == typeof n2 && (n2 = e2.$ui.getView(n2)), n2 && n2.attachEvent && n2.attachEvent("onScroll", function() {
          e2.$services.getService("state").getState("batchUpdate").batch_update || n2.$config.$skipSmartRenderOnScroll || t2.requestUpdate && t2.requestUpdate();
        });
      }
    }
    t.exports = function(t2) {
      var e2 = i(t2);
      return { getDataRender: function(e3) {
        return t2.$services.getService("layer:" + e3) || null;
      }, createDataRender: function(n2) {
        var i2 = n2.name, a = n2.defaultContainer, o = n2.defaultContainerSibling, s = e2.createGroup(a, o, function(t3, e3) {
          if (!s.filters)
            return true;
          for (var n3 = 0; n3 < s.filters.length; n3++)
            if (false === s.filters[n3](t3, e3))
              return false;
        }, r);
        return t2.$services.setService("layer:" + i2, function() {
          return s;
        }), t2.attachEvent("onGanttReady", function() {
          s.addLayer();
        }), s;
      }, init: function() {
        var e3 = this.createDataRender({ name: "task", defaultContainer: function() {
          return t2.$task_data ? t2.$task_data : t2.$ui.getView("timeline") ? t2.$ui.getView("timeline").$task_data : void 0;
        }, defaultContainerSibling: function() {
          return t2.$task_links ? t2.$task_links : t2.$ui.getView("timeline") ? t2.$ui.getView("timeline").$task_links : void 0;
        }, filter: function(t3) {
        } }, t2), n2 = this.createDataRender({ name: "link", defaultContainer: function() {
          return t2.$task_data ? t2.$task_data : t2.$ui.getView("timeline") ? t2.$ui.getView("timeline").$task_data : void 0;
        } }, t2);
        return { addTaskLayer: function(t3) {
          return "function" == typeof t3 && (t3 = { renderer: t3 }), t3.view = "timeline", e3.addLayer(t3);
        }, _getTaskLayers: function() {
          return e3.getLayers();
        }, removeTaskLayer: function(t3) {
          e3.removeLayer(t3);
        }, _clearTaskLayers: function() {
          e3.clear();
        }, addLinkLayer: function(t3) {
          return "function" == typeof t3 && (t3 = { renderer: { render: t3 } }), t3.view = "timeline", n2.addLayer(t3);
        }, _getLinkLayers: function() {
          return n2.getLayers();
        }, removeLinkLayer: function(t3) {
          n2.removeLayer(t3);
        }, _clearLinkLayers: function() {
          n2.clear();
        } };
      } };
    };
  }, function(t, e, n) {
    var i = function(t2) {
      return function(e2) {
        var n2 = { click: {}, doubleclick: {}, contextMenu: {} };
        function i2(t3, e3, i3, r2) {
          n2[t3][e3] || (n2[t3][e3] = []), n2[t3][e3].push({ handler: i3, root: r2 });
        }
        function r(t3) {
          t3 = t3 || window.event;
          var i3 = e2.locate(t3), r2 = o(t3, n2.click), a2 = true;
          if (null !== i3 ? a2 = !e2.checkEvent("onTaskClick") || e2.callEvent("onTaskClick", [i3, t3]) : e2.callEvent("onEmptyClick", [t3]), a2) {
            if (!s(r2, t3, i3))
              return;
            switch (t3.target.nodeName) {
              case "SELECT":
              case "INPUT":
                return;
            }
            i3 && e2.getTask(i3) && !e2._multiselect && e2.config.select_task && e2.selectTask(i3);
          }
        }
        function a(t3) {
          var n3 = (t3 = t3 || window.event).target || t3.srcElement, i3 = e2.locate(n3), r2 = e2.locate(n3, e2.config.link_attribute), a2 = !e2.checkEvent("onContextMenu") || e2.callEvent("onContextMenu", [i3, r2, t3]);
          return a2 || (t3.preventDefault ? t3.preventDefault() : t3.returnValue = false), a2;
        }
        function o(e3, n3) {
          for (var i3 = e3.target || e3.srcElement, r2 = []; i3; ) {
            var a2 = t2.getClassName(i3);
            if (a2) {
              a2 = a2.split(" ");
              for (var o2 = 0; o2 < a2.length; o2++)
                if (a2[o2] && n3[a2[o2]])
                  for (var s2 = n3[a2[o2]], l2 = 0; l2 < s2.length; l2++)
                    s2[l2].root && !t2.isChildOf(i3, s2[l2].root) || r2.push(s2[l2].handler);
            }
            i3 = i3.parentNode;
          }
          return r2;
        }
        function s(t3, n3, i3) {
          for (var r2 = true, a2 = 0; a2 < t3.length; a2++) {
            var o2 = t3[a2].call(e2, n3, i3, n3.target || n3.srcElement);
            r2 = r2 && !(void 0 !== o2 && true !== o2);
          }
          return r2;
        }
        function l(t3) {
          t3 = t3 || window.event;
          var i3 = e2.locate(t3), r2 = o(t3, n2.doubleclick), a2 = !e2.checkEvent("onTaskDblClick") || null === i3 || e2.callEvent("onTaskDblClick", [i3, t3]);
          if (a2) {
            if (!s(r2, t3, i3))
              return;
            null !== i3 && e2.getTask(i3) && a2 && e2.config.details_on_dblclick && !e2.isReadonly() && e2.showLightbox(i3);
          }
        }
        function c(t3) {
          if (e2.checkEvent("onMouseMove")) {
            var n3 = e2.locate(t3);
            e2._last_move_event = t3, e2.callEvent("onMouseMove", [n3, t3]);
          }
        }
        var u = e2._createDomEventScope();
        function d(t3) {
          u.detachAll(), t3 && (u.attach(t3, "click", r), u.attach(t3, "dblclick", l), u.attach(t3, "mousemove", c), u.attach(t3, "contextmenu", a));
        }
        return { reset: d, global: function(t3, e3, n3) {
          i2(t3, e3, n3, null);
        }, delegate: i2, detach: function(t3, e3, i3, r2) {
          if (n2[t3] && n2[t3][e3]) {
            for (var a2 = n2[t3], o2 = a2[e3], s2 = 0; s2 < o2.length; s2++)
              o2[s2].root == r2 && (o2.splice(s2, 1), s2--);
            o2.length || delete a2[e3];
          }
        }, callHandler: function(t3, e3, i3, r2) {
          var a2 = n2[t3][e3];
          if (a2)
            for (var o2 = 0; o2 < a2.length; o2++)
              (i3 || a2[o2].root) && a2[o2].root !== i3 || a2[o2].handler.apply(this, r2);
        }, onDoubleClick: l, onMouseMove: c, onContextMenu: a, onClick: r, destructor: function() {
          d(), n2 = null, u = null;
        } };
      };
    }(n(1));
    t.exports = { init: i };
  }, function(t, e, n) {
    var i = n(0);
    function r(t2, e2) {
      var n2 = this.$config[t2];
      return n2 ? (n2.$extendedConfig || (n2.$extendedConfig = true, Object.setPrototypeOf(n2, e2)), n2) : e2;
    }
    t.exports = function(t2, e2) {
      i.mixin(t2, function(t3) {
        var e3, n2;
        return { $getConfig: function() {
          return e3 || (e3 = t3 ? t3.$getConfig() : this.$gantt.config), this.$config.config ? r.call(this, "config", e3) : e3;
        }, $getTemplates: function() {
          return n2 || (n2 = t3 ? t3.$getTemplates() : this.$gantt.templates), this.$config.templates ? r.call(this, "templates", n2) : n2;
        } };
      }(e2));
    };
  }, function(t, e, n) {
    function i(t2) {
      "@babel/helpers - typeof";
      return (i = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(t3) {
        return typeof t3;
      } : function(t3) {
        return t3 && "function" == typeof Symbol && t3.constructor === Symbol && t3 !== Symbol.prototype ? "symbol" : typeof t3;
      })(t2);
    }
    var r = n(0), a = n(127);
    t.exports = { createFactory: function(t2) {
      var e2 = {};
      var n2 = {};
      function o(o2, s, l, c) {
        var u = e2[o2];
        if (!u || !u.create)
          return false;
        "resizer" != o2 || l.mode || (c.$config.cols ? l.mode = "x" : l.mode = "y"), "viewcell" != o2 || "scrollbar" != l.view || l.scroll || (c.$config.cols ? l.scroll = "y" : l.scroll = "x"), (l = r.copy(l)).id || n2[l.view] || (l.id = l.view), l.id && !l.css && (l.css = l.id + "_cell");
        var d = new u.create(s, l, this, t2);
        return u.configure && u.configure(d), a(d, c), d.$id || (d.$id = l.id || t2.uid()), d.$parent || "object" != i(s) || (d.$parent = s), d.$config || (d.$config = l), n2[d.$id] && (d.$id = t2.uid()), n2[d.$id] = d, d;
      }
      return { initUI: function(t3, e3) {
        var n3 = "cell";
        return t3.view ? n3 = "viewcell" : t3.resizer ? n3 = "resizer" : t3.rows || t3.cols ? n3 = "layout" : t3.views && (n3 = "multiview"), o.call(this, n3, null, t3, e3);
      }, reset: function() {
        n2 = {};
      }, registerView: function(t3, n3, i2) {
        e2[t3] = { create: n3, configure: i2 };
      }, createView: o, getView: function(t3) {
        return n2[t3];
      } };
    } };
  }, function(t, e, n) {
    var i = n(128), r = n(126), a = n(125), o = n(9), s = n(35), l = n(121), c = n(120), u = n(119), d = n(118), h2 = n(34), f = n(27), _2 = n(116), g = n(33), p = n(115), v2 = n(114), m = n(103), y = n(102), k2 = n(100), b = n(99), w = n(98), x = n(96), S = n(95), $ = n(94), T = n(93), C = n(92), E2 = n(86), D = n(83);
    t.exports = { init: function(t2) {
      function e2(e3, n3) {
        var i2 = n3(t2);
        i2.onCreated && i2.onCreated(e3), e3.attachEvent("onReady", function() {
          i2.onInitialized && i2.onInitialized(e3);
        }), e3.attachEvent("onDestroy", function() {
          i2.onDestroyed && i2.onDestroyed(e3);
        });
      }
      var n2 = i.createFactory(t2);
      n2.registerView("cell", o), n2.registerView("resizer", u), n2.registerView("scrollbar", d), n2.registerView("layout", s, function(t3) {
        "main" === (t3.$config ? t3.$config.id : null) && e2(t3, D);
      }), n2.registerView("viewcell", c), n2.registerView("multiview", l), n2.registerView("timeline", h2, function(t3) {
        "timeline" !== (t3.$config ? t3.$config.id : null) && "task" != t3.$config.bind || e2(t3, E2);
      }), n2.registerView("grid", f, function(t3) {
        "grid" !== (t3.$config ? t3.$config.id : null) && "task" != t3.$config.bind || e2(t3, C);
      }), n2.registerView("resourceGrid", _2), n2.registerView("resourceTimeline", g), n2.registerView("resourceHistogram", p);
      var A = a(t2), M = v2(t2);
      return t2.ext.inlineEditors = M, t2.ext._inlineEditors = M, M.init(t2), { factory: n2, mouseEvents: r.init(t2), layersApi: A.init(), render: { gridLine: function() {
        return x(t2);
      }, taskBg: function() {
        return b(t2);
      }, taskBar: function() {
        return m(t2);
      }, taskRollupBar: function() {
        return k2(t2);
      }, taskSplitBar: function() {
        return y(t2);
      }, link: function() {
        return w(t2);
      }, resourceRow: function() {
        return S(t2);
      }, resourceHistogram: function() {
        return $(t2);
      }, gridTaskRowResizer: function() {
        return T(t2);
      } }, layersService: { getDataRender: function(e3) {
        return A.getDataRender(e3, t2);
      }, createDataRender: function(e3) {
        return A.createDataRender(e3, t2);
      } } };
    } };
  }, function(t, e, n) {
    function i(t2) {
      "@babel/helpers - typeof";
      return (i = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(t3) {
        return typeof t3;
      } : function(t3) {
        return t3 && "function" == typeof Symbol && t3.constructor === Symbol && t3 !== Symbol.prototype ? "symbol" : typeof t3;
      })(t2);
    }
    var r = n(0), a = n(1);
    t.exports = function(t2) {
      var e2 = "data-dhxbox", n2 = null;
      function o(t3, e3) {
        var i2 = t3.callback;
        m.hide(t3.box), n2 = t3.box = null, i2 && i2(e3);
      }
      function s(t3) {
        if (n2) {
          var e3 = t3.which || t3.keyCode, i2 = false;
          if (y.keyboard) {
            if (13 == e3 || 32 == e3) {
              var r2 = t3.target || t3.srcElement;
              a.getClassName(r2).indexOf("gantt_popup_button") > -1 && r2.click ? r2.click() : (o(n2, true), i2 = true);
            }
            27 == e3 && (o(n2, false), i2 = true);
          }
          return i2 ? (t3.preventDefault && t3.preventDefault(), !(t3.cancelBubble = true)) : void 0;
        }
      }
      function l(t3) {
        l.cover || (l.cover = document.createElement("div"), l.cover.onkeydown = s, l.cover.className = "dhx_modal_cover", document.body.appendChild(l.cover)), l.cover.style.display = t3 ? "inline-block" : "none";
      }
      function c(e3, n3, i2) {
        var r2 = t2._waiAria.messageButtonAttrString(e3), a2 = n3.toLowerCase().replace(/ /g, "_");
        return "<div " + r2 + " class='gantt_popup_button dhtmlx_popup_button " + ("gantt_" + a2 + "_button dhtmlx_" + a2 + "_button") + "' data-result='" + i2 + "' result='" + i2 + "' ><div>" + e3 + "</div></div>";
      }
      function u(e3) {
        y.area || (y.area = document.createElement("div"), y.area.className = "gantt_message_area dhtmlx_message_area", y.area.style[y.position] = "5px", document.body.appendChild(y.area)), y.hide(e3.id);
        var n3 = document.createElement("div");
        return n3.innerHTML = "<div>" + e3.text + "</div>", n3.className = "gantt-info dhtmlx-info gantt-" + e3.type + " dhtmlx-" + e3.type, n3.onclick = function() {
          y.hide(e3.id), e3 = null;
        }, t2._waiAria.messageInfoAttr(n3), "bottom" == y.position && y.area.firstChild ? y.area.insertBefore(n3, y.area.firstChild) : y.area.appendChild(n3), e3.expire > 0 && (y.timers[e3.id] = window.setTimeout(function() {
          y && y.hide(e3.id);
        }, e3.expire)), y.pull[e3.id] = n3, n3 = null, e3.id;
      }
      function d() {
        for (var t3 = [].slice.apply(arguments, [0]), e3 = 0; e3 < t3.length; e3++)
          if (t3[e3])
            return t3[e3];
      }
      function h2(u2, h3, f2) {
        var _3 = u2.tagName ? u2 : function(s2, l2, u3) {
          var h4 = document.createElement("div"), f3 = r.uid();
          t2._waiAria.messageModalAttr(h4, f3), h4.className = " gantt_modal_box dhtmlx_modal_box gantt-" + s2.type + " dhtmlx-" + s2.type, h4.setAttribute(e2, 1);
          var _4 = "";
          if (s2.width && (h4.style.width = s2.width), s2.height && (h4.style.height = s2.height), s2.title && (_4 += '<div class="gantt_popup_title dhtmlx_popup_title">' + s2.title + "</div>"), _4 += '<div class="gantt_popup_text dhtmlx_popup_text" id="' + f3 + '"><span>' + (s2.content ? "" : s2.text) + '</span></div><div  class="gantt_popup_controls dhtmlx_popup_controls">', l2 && (_4 += c(d(s2.ok, t2.locale.labels.message_ok, "OK"), "ok", true)), u3 && (_4 += c(d(s2.cancel, t2.locale.labels.message_cancel, "Cancel"), "cancel", false)), s2.buttons)
            for (var g3 = 0; g3 < s2.buttons.length; g3++) {
              var p3 = s2.buttons[g3];
              "object" == i(p3) ? _4 += c(p3.label, p3.css || "gantt_" + p3.label.toLowerCase() + "_button dhtmlx_" + p3.label.toLowerCase() + "_button", p3.value || g3) : _4 += c(p3, p3, g3);
            }
          if (_4 += "</div>", h4.innerHTML = _4, s2.content) {
            var v3 = s2.content;
            "string" == typeof v3 && (v3 = document.getElementById(v3)), "none" == v3.style.display && (v3.style.display = ""), h4.childNodes[s2.title ? 1 : 0].appendChild(v3);
          }
          return h4.onclick = function(t3) {
            var e3 = t3.target || t3.srcElement;
            if (e3.className || (e3 = e3.parentNode), a.closest(e3, ".gantt_popup_button")) {
              var n3 = e3.getAttribute("data-result");
              o(s2, n3 = "true" == n3 || "false" != n3 && n3);
            }
          }, s2.box = h4, (l2 || u3) && (n2 = s2), h4;
        }(u2, h3, f2);
        u2.hidden || l(true), document.body.appendChild(_3);
        var g2 = Math.abs(Math.floor(((window.innerWidth || document.documentElement.offsetWidth) - _3.offsetWidth) / 2)), p2 = Math.abs(Math.floor(((window.innerHeight || document.documentElement.offsetHeight) - _3.offsetHeight) / 2));
        return "top" == u2.position ? _3.style.top = "-3px" : _3.style.top = p2 + "px", _3.style.left = g2 + "px", _3.onkeydown = s, m.focus(_3), u2.hidden && m.hide(_3), t2.callEvent("onMessagePopup", [_3]), _3;
      }
      function f(t3) {
        return h2(t3, true, false);
      }
      function _2(t3) {
        return h2(t3, true, true);
      }
      function g(t3) {
        return h2(t3);
      }
      function p(t3, e3, n3) {
        return "object" != i(t3) && ("function" == typeof e3 && (n3 = e3, e3 = ""), t3 = { text: t3, type: e3, callback: n3 }), t3;
      }
      function v2(t3, e3, n3, a2) {
        return "object" != i(t3) && (t3 = { text: t3, type: e3, expire: n3, id: a2 }), t3.id = t3.id || r.uid(), t3.expire = t3.expire || y.expire, t3;
      }
      t2.event(document, "keydown", s, true);
      var m = function() {
        var t3 = p.apply(this, arguments);
        return t3.type = t3.type || "alert", g(t3);
      };
      m.hide = function(n3) {
        for (; n3 && n3.getAttribute && !n3.getAttribute(e2); )
          n3 = n3.parentNode;
        n3 && (n3.parentNode.removeChild(n3), l(false), t2.callEvent("onAfterMessagePopup", [n3]));
      }, m.focus = function(t3) {
        setTimeout(function() {
          var e3 = a.getFocusableNodes(t3);
          e3.length && e3[0].focus && e3[0].focus();
        }, 1);
      };
      var y = function(t3, e3, n3, i2) {
        switch ((t3 = v2.apply(this, arguments)).type = t3.type || "info", t3.type.split("-")[0]) {
          case "alert":
            return f(t3);
          case "confirm":
            return _2(t3);
          case "modalbox":
            return g(t3);
          default:
            return u(t3);
        }
      };
      y.seed = (/* @__PURE__ */ new Date()).valueOf(), y.uid = r.uid, y.expire = 4e3, y.keyboard = true, y.position = "top", y.pull = {}, y.timers = {}, y.hideAll = function() {
        for (var t3 in y.pull)
          y.hide(t3);
      }, y.hide = function(t3) {
        var e3 = y.pull[t3];
        e3 && e3.parentNode && (window.setTimeout(function() {
          e3.parentNode.removeChild(e3), e3 = null;
        }, 2e3), e3.className += " hidden", y.timers[t3] && window.clearTimeout(y.timers[t3]), delete y.pull[t3]);
      };
      var k2 = [];
      return t2.attachEvent("onMessagePopup", function(t3) {
        k2.push(t3);
      }), t2.attachEvent("onAfterMessagePopup", function(t3) {
        for (var e3 = 0; e3 < k2.length; e3++)
          k2[e3] === t3 && (k2.splice(e3, 1), e3--);
      }), t2.attachEvent("onDestroy", function() {
        l.cover && l.cover.parentNode && l.cover.parentNode.removeChild(l.cover);
        for (var t3 = 0; t3 < k2.length; t3++)
          k2[t3].parentNode && k2[t3].parentNode.removeChild(k2[t3]);
        k2 = null, y.area && y.area.parentNode && y.area.parentNode.removeChild(y.area), y = null;
      }), { alert: function() {
        var t3 = p.apply(this, arguments);
        return t3.type = t3.type || "confirm", f(t3);
      }, confirm: function() {
        var t3 = p.apply(this, arguments);
        return t3.type = t3.type || "alert", _2(t3);
      }, message: y, modalbox: m };
    };
  }, function(t, e, n) {
    t.exports = function(t2) {
      var e2 = n(0), i = n(7), r = n(10);
      if (!i.isNode) {
        var a = n(1), o = n(2);
        t2.utils = { arrayFind: o.arrayFind, dom: { getNodePosition: a.getNodePosition, getRelativeEventPosition: a.getRelativeEventPosition, isChildOf: a.isChildOf, hasClass: a.hasClass, closest: a.closest } };
        var s = n(49)();
        t2.event = s.attach, t2.eventRemove = s.detach, t2._eventRemoveAll = s.detachAll, t2._createDomEventScope = s.extend, e2.mixin(t2, n(130)(t2));
        var l = n(129).init(t2);
        t2.$ui = l.factory, t2.$ui.layers = l.render, t2.$mouseEvents = l.mouseEvents, t2.$services.setService("mouseEvents", function() {
          return t2.$mouseEvents;
        }), t2.mixin(t2, l.layersApi), n(82)(t2), t2.$services.setService("layers", function() {
          return l.layersService;
        });
        var c = n(81);
        t2.mixin(t2, c()), n(80)(t2), n(79)(t2), n(78)(t2), n(77)(t2), n(76)(t2), n(75)(t2), n(74)(t2), n(73)(t2), n(72)(t2), n(67)(t2), n(66)(t2), n(54)(t2), n(53)(t2), t2.locate = function(t3) {
          var e3 = a.getTargetNode(t3);
          if (a.closest(e3, ".gantt_task_row"))
            return null;
          var n2 = arguments[1] || this.config.task_attribute, i2 = a.locateAttribute(e3, n2);
          return i2 ? i2.getAttribute(n2) : null;
        }, t2._locate_css = function(t3, e3, n2) {
          return a.locateClassName(t3, e3, n2);
        }, t2._locateHTML = function(t3, e3) {
          return a.locateAttribute(t3, e3 || this.config.task_attribute);
        };
      }
      t2.attachEvent("onParse", function() {
        r(t2) || t2.attachEvent("onGanttRender", function() {
          if (t2.config.initial_scroll) {
            var e3 = t2.getTaskByIndex(0), n2 = e3 ? e3.id : t2.config.root_id;
            t2.isTaskExists(n2) && t2.showTask(n2);
          }
        }, { once: true });
      }), t2.attachEvent("onBeforeGanttReady", function() {
        this.config.scroll_size || (this.config.scroll_size = a.getScrollSize() || 1), r(t2) || (this._eventRemoveAll(), this.$mouseEvents.reset(), this.resetLightbox());
      }), t2.attachEvent("onGanttReady", function() {
        !r(t2) && t2.config.rtl && t2.$layout.getCellsByType("viewCell").forEach(function(e3) {
          var n2 = e3.$config.scrollX;
          if (n2) {
            var i2 = t2.$ui.getView(n2);
            i2 && i2.scrollTo(i2.$config.scrollSize, 0);
          }
        });
      });
    };
  }, function(t, e, n) {
    Object.defineProperty(e, "__esModule", { value: true });
    e.default = { date: { month_full: ["Січень", "Лютий", "Березень", "Квітень", "Травень", "Червень", "Липень", "Серпень", "Вересень", "Жовтень", "Листопад", "Грудень"], month_short: ["Січ", "Лют", "Бер", "Кві", "Тра", "Чер", "Лип", "Сер", "Вер", "Жов", "Лис", "Гру"], day_full: ["Неділя", "Понеділок", "Вівторок", "Середа", "Четвер", "П'ятниця", "Субота"], day_short: ["Нед", "Пон", "Вів", "Сер", "Чет", "Птн", "Суб"] }, labels: { new_task: "Нове завдання", icon_save: "Зберегти", icon_cancel: "Відміна", icon_details: "Деталі", icon_edit: "Редагувати", icon_delete: "Вилучити", confirm_closing: "", confirm_deleting: "Подія вилучиться назавжди. Ви впевнені?", section_description: "Опис", section_time: "Часовий проміжок", section_type: "Тип", column_wbs: "WBS", column_text: "Task name", column_start_date: "Start time", column_duration: "Duration", column_add: "", link: "Link", confirm_link_deleting: "will be deleted", link_start: " (start)", link_end: " (end)", type_task: "Task", type_project: "Project", type_milestone: "Milestone", minutes: "Minutes", hours: "Hours", days: "Days", weeks: "Week", months: "Months", years: "Years", message_ok: "OK", message_cancel: "Відміна", section_constraint: "Constraint", constraint_type: "Constraint type", constraint_date: "Constraint date", asap: "As Soon As Possible", alap: "As Late As Possible", snet: "Start No Earlier Than", snlt: "Start No Later Than", fnet: "Finish No Earlier Than", fnlt: "Finish No Later Than", mso: "Must Start On", mfo: "Must Finish On", resources_filter_placeholder: "type to filter", resources_filter_label: "hide empty" } };
  }, function(t, e, n) {
    Object.defineProperty(e, "__esModule", { value: true });
    e.default = { date: { month_full: ["Ocak", "Şubat", "Mart", "Nisan", "Mayıs", "Haziran", "Temmuz", "Ağustos", "Eylül", "Ekim", "Kasım", "Aralık"], month_short: ["Oca", "Şub", "Mar", "Nis", "May", "Haz", "Tem", "Ağu", "Eyl", "Eki", "Kas", "Ara"], day_full: ["Pazar", "Pazartesi", "Salı", "Çarşamba", "Perşembe", "Cuma", "Cumartesi"], day_short: ["Paz", "Pzt", "Sal", "Çar", "Per", "Cum", "Cmt"] }, labels: { new_task: "Yeni görev", icon_save: "Kaydet", icon_cancel: "İptal", icon_details: "Detaylar", icon_edit: "Düzenle", icon_delete: "Sil", confirm_closing: "", confirm_deleting: "Görev silinecek, emin misiniz?", section_description: "Açıklama", section_time: "Zaman Aralığı", section_type: "Tip", column_wbs: "WBS", column_text: "Görev Adı", column_start_date: "Başlangıç", column_duration: "Süre", column_add: "", link: "Bağlantı", confirm_link_deleting: "silinecek", link_start: " (başlangıç)", link_end: " (bitiş)", type_task: "Görev", type_project: "Proje", type_milestone: "Kilometretaşı", minutes: "Dakika", hours: "Saat", days: "Gün", weeks: "Hafta", months: "Ay", years: "Yıl", message_ok: "OK", message_cancel: "Ýptal", section_constraint: "Constraint", constraint_type: "Constraint type", constraint_date: "Constraint date", asap: "As Soon As Possible", alap: "As Late As Possible", snet: "Start No Earlier Than", snlt: "Start No Later Than", fnet: "Finish No Earlier Than", fnlt: "Finish No Later Than", mso: "Must Start On", mfo: "Must Finish On", resources_filter_placeholder: "type to filter", resources_filter_label: "hide empty" } };
  }, function(t, e, n) {
    Object.defineProperty(e, "__esModule", { value: true });
    e.default = { date: { month_full: ["Januari", "Februari", "Mars", "April", "Maj", "Juni", "Juli", "Augusti", "September", "Oktober", "November", "December"], month_short: ["Jan", "Feb", "Mar", "Apr", "Maj", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Dec"], day_full: ["Söndag", "Måndag", "Tisdag", "Onsdag", "Torsdag", "Fredag", "Lördag"], day_short: ["Sön", "Mån", "Tis", "Ons", "Tor", "Fre", "Lör"] }, labels: { new_task: "Ny uppgift", icon_save: "Spara", icon_cancel: "Avbryt", icon_details: "Detajer", icon_edit: "Ändra", icon_delete: "Ta bort", confirm_closing: "", confirm_deleting: "Är du säker på att du vill ta bort händelsen permanent?", section_description: "Beskrivning", section_time: "Tid", section_type: "Typ", column_wbs: "WBS", column_text: "Uppgiftsnamn", column_start_date: "Starttid", column_duration: "Varaktighet", column_add: "", link: "Länk", confirm_link_deleting: "kommer tas bort", link_start: " (start)", link_end: " (slut)", type_task: "Uppgift", type_project: "Projekt", type_milestone: "Milstolpe", minutes: "Minuter", hours: "Timmar", days: "Dagar", weeks: "Veckor", months: "Månader", years: "År", message_ok: "OK", message_cancel: "Avbryt", section_constraint: "Constraint", constraint_type: "Constraint type", constraint_date: "Constraint date", asap: "As Soon As Possible", alap: "As Late As Possible", snet: "Start No Earlier Than", snlt: "Start No Later Than", fnet: "Finish No Earlier Than", fnlt: "Finish No Later Than", mso: "Must Start On", mfo: "Must Finish On", resources_filter_placeholder: "type to filter", resources_filter_label: "hide empty" } };
  }, function(t, e, n) {
    Object.defineProperty(e, "__esModule", { value: true });
    e.default = { date: { month_full: ["Január", "Február", "Marec", "Apríl", "Máj", "Jún", "Júl", "August", "September", "Október", "November", "December"], month_short: ["Jan", "Feb", "Mar", "Apr", "Máj", "Jún", "Júl", "Aug", "Sept", "Okt", "Nov", "Dec"], day_full: ["Nedeľa", "Pondelok", "Utorok", "Streda", "Štvrtok", "Piatok", "Sobota"], day_short: ["Ne", "Po", "Ut", "St", "Št", "Pi", "So"] }, labels: { new_task: "Nová úloha", icon_save: "Uložiť", icon_cancel: "Späť", icon_details: "Detail", icon_edit: "Edituj", icon_delete: "Zmazať", confirm_closing: "Vaše zmeny nebudú uložené. Skutočne?", confirm_deleting: "Udalosť bude natrvalo vymazaná. Skutočne?", section_description: "Poznámky", section_time: "Doba platnosti", section_type: "Type", column_wbs: "WBS", column_text: "Task name", column_start_date: "Start time", column_duration: "Duration", column_add: "", link: "Link", confirm_link_deleting: "will be deleted", link_start: " (start)", link_end: " (end)", type_task: "Task", type_project: "Project", type_milestone: "Milestone", minutes: "Minutes", hours: "Hours", days: "Days", weeks: "Week", months: "Months", years: "Years", message_ok: "OK", message_cancel: "Späť", section_constraint: "Constraint", constraint_type: "Constraint type", constraint_date: "Constraint date", asap: "As Soon As Possible", alap: "As Late As Possible", snet: "Start No Earlier Than", snlt: "Start No Later Than", fnet: "Finish No Earlier Than", fnlt: "Finish No Later Than", mso: "Must Start On", mfo: "Must Finish On", resources_filter_placeholder: "type to filter", resources_filter_label: "hide empty" } };
  }, function(t, e, n) {
    Object.defineProperty(e, "__esModule", { value: true });
    e.default = { date: { month_full: ["Januar", "Februar", "Marec", "April", "Maj", "Junij", "Julij", "Avgust", "September", "Oktober", "November", "December"], month_short: ["Jan", "Feb", "Mar", "Apr", "Maj", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Dec"], day_full: ["Nedelja", "Ponedeljek", "Torek", "Sreda", "Četrtek", "Petek", "Sobota"], day_short: ["Ned", "Pon", "Tor", "Sre", "Čet", "Pet", "Sob"] }, labels: { new_task: "Nova naloga", icon_save: "Shrani", icon_cancel: "Prekliči", icon_details: "Podrobnosti", icon_edit: "Uredi", icon_delete: "Izbriši", confirm_closing: "", confirm_deleting: "Dogodek bo izbrisan. Želite nadaljevati?", section_description: "Opis", section_time: "Časovni okvir", section_type: "Type", column_wbs: "WBS", column_text: "Task name", column_start_date: "Start time", column_duration: "Duration", column_add: "", link: "Link", confirm_link_deleting: "will be deleted", link_start: " (start)", link_end: " (end)", type_task: "Task", type_project: "Project", type_milestone: "Milestone", minutes: "Minutes", hours: "Hours", days: "Days", weeks: "Week", months: "Months", years: "Years", message_ok: "OK", message_cancel: "Prekliči", section_constraint: "Constraint", constraint_type: "Constraint type", constraint_date: "Constraint date", asap: "As Soon As Possible", alap: "As Late As Possible", snet: "Start No Earlier Than", snlt: "Start No Later Than", fnet: "Finish No Earlier Than", fnlt: "Finish No Later Than", mso: "Must Start On", mfo: "Must Finish On", resources_filter_placeholder: "type to filter", resources_filter_label: "hide empty" } };
  }, function(t, e, n) {
    Object.defineProperty(e, "__esModule", { value: true });
    e.default = { date: { month_full: ["Январь", "Февраль", "Март", "Апрель", "Maй", "Июнь", "Июль", "Август", "Сентябрь", "Oктябрь", "Ноябрь", "Декабрь"], month_short: ["Янв", "Фев", "Maр", "Aпр", "Maй", "Июн", "Июл", "Aвг", "Сен", "Окт", "Ноя", "Дек"], day_full: ["Воскресенье", "Понедельник", "Вторник", "Среда", "Четверг", "Пятница", "Суббота"], day_short: ["Вс", "Пн", "Вт", "Ср", "Чт", "Пт", "Сб"] }, labels: { new_task: "Новое задание", icon_save: "Сохранить", icon_cancel: "Отменить", icon_details: "Детали", icon_edit: "Изменить", icon_delete: "Удалить", confirm_closing: "", confirm_deleting: "Событие будет удалено безвозвратно, продолжить?", section_description: "Описание", section_time: "Период времени", section_type: "Тип", column_wbs: "ИСР", column_text: "Задача", column_start_date: "Начало", column_duration: "Длительность", column_add: "", link: "Связь", confirm_link_deleting: "будет удалена", link_start: " (начало)", link_end: " (конец)", type_task: "Task", type_project: "Project", type_milestone: "Milestone", minutes: "Минута", hours: "Час", days: "День", weeks: "Неделя", months: "Месяц", years: "Год", message_ok: "OK", message_cancel: "Отменить", section_constraint: "Constraint", constraint_type: "Constraint type", constraint_date: "Constraint date", asap: "As Soon As Possible", alap: "As Late As Possible", snet: "Start No Earlier Than", snlt: "Start No Later Than", fnet: "Finish No Earlier Than", fnlt: "Finish No Later Than", mso: "Must Start On", mfo: "Must Finish On", resources_filter_placeholder: "начните вводить слово для фильтрации", resources_filter_label: "спрятать не установленные" } };
  }, function(t, e, n) {
    Object.defineProperty(e, "__esModule", { value: true });
    e.default = { date: { month_full: ["Ianuarie", "Februarie", "Martie", "Aprilie", "Mai", "Iunie", "Iulie", "August", "Septembrie", "Octombrie", "November", "December"], month_short: ["Ian", "Feb", "Mar", "Apr", "Mai", "Iun", "Iul", "Aug", "Sep", "Oct", "Nov", "Dec"], day_full: ["Duminica", "Luni", "Marti", "Miercuri", "Joi", "Vineri", "Sambata"], day_short: ["Du", "Lu", "Ma", "Mi", "Jo", "Vi", "Sa"] }, labels: { new_task: "Sarcina noua", icon_save: "Salveaza", icon_cancel: "Anuleaza", icon_details: "Detalii", icon_edit: "Editeaza", icon_delete: "Sterge", confirm_closing: "Schimbarile nu vor fi salvate, esti sigur?", confirm_deleting: "Evenimentul va fi sters permanent, esti sigur?", section_description: "Descriere", section_time: "Interval", section_type: "Type", column_wbs: "WBS", column_text: "Task name", column_start_date: "Start time", column_duration: "Duration", column_add: "", link: "Link", confirm_link_deleting: "will be deleted", link_start: " (start)", link_end: " (end)", type_task: "Task", type_project: "Project", type_milestone: "Milestone", minutes: "Minutes", hours: "Hours", days: "Days", weeks: "Week", months: "Months", years: "Years", message_ok: "OK", message_cancel: "Anuleaza", section_constraint: "Constraint", constraint_type: "Constraint type", constraint_date: "Constraint date", asap: "As Soon As Possible", alap: "As Late As Possible", snet: "Start No Earlier Than", snlt: "Start No Later Than", fnet: "Finish No Earlier Than", fnlt: "Finish No Later Than", mso: "Must Start On", mfo: "Must Finish On", resources_filter_placeholder: "type to filter", resources_filter_label: "hide empty" } };
  }, function(t, e, n) {
    Object.defineProperty(e, "__esModule", { value: true });
    e.default = { date: { month_full: ["Janeiro", "Fevereiro", "Março", "Abril", "Maio", "Junho", "Julho", "Agosto", "Setembro", "Outubro", "Novembro", "Dezembro"], month_short: ["Jan", "Fev", "Mar", "Abr", "Mai", "Jun", "Jul", "Ago", "Set", "Out", "Nov", "Dez"], day_full: ["Domingo", "Segunda", "Terça", "Quarta", "Quinta", "Sexta", "Sábado"], day_short: ["Dom", "Seg", "Ter", "Qua", "Qui", "Sex", "Sab"] }, labels: { new_task: "Nova tarefa", icon_save: "Salvar", icon_cancel: "Cancelar", icon_details: "Detalhes", icon_edit: "Editar", icon_delete: "Excluir", confirm_closing: "", confirm_deleting: "As tarefas serão excluidas permanentemente, confirme?", section_description: "Descrição", section_time: "Período", section_type: "Tipo", column_wbs: "EAP", column_text: "Nome tarefa", column_start_date: "Data início", column_duration: "Duração", column_add: "", link: "Link", confirm_link_deleting: "Será excluído!", link_start: " (início)", link_end: " (fim)", type_task: "Task", type_project: "Projeto", type_milestone: "Marco", minutes: "Minutos", hours: "Horas", days: "Dias", weeks: "Semanas", months: "Meses", years: "Anos", message_ok: "OK", message_cancel: "Cancelar", section_constraint: "Restrição", constraint_type: "Tipo Restrição", constraint_date: "Data restrição", asap: "Mais breve possível", alap: "Mais tarde possível", snet: "Não começar antes de", snlt: "Não começar depois de", fnet: "Não terminar antes de", fnlt: "Não terminar depois de", mso: "Precisa começar em", mfo: "Precisa terminar em", resources_filter_placeholder: "Tipo de filtros", resources_filter_label: "Ocultar vazios" } };
  }, function(t, e, n) {
    Object.defineProperty(e, "__esModule", { value: true });
    e.default = { date: { month_full: ["Styczeń", "Luty", "Marzec", "Kwiecień", "Maj", "Czerwiec", "Lipiec", "Sierpień", "Wrzesień", "Październik", "Listopad", "Grudzień"], month_short: ["Sty", "Lut", "Mar", "Kwi", "Maj", "Cze", "Lip", "Sie", "Wrz", "Paź", "Lis", "Gru"], day_full: ["Niedziela", "Poniedziałek", "Wtorek", "Środa", "Czwartek", "Piątek", "Sobota"], day_short: ["Nie", "Pon", "Wto", "Śro", "Czw", "Pią", "Sob"] }, labels: { new_task: "Nowe zadanie", icon_save: "Zapisz", icon_cancel: "Anuluj", icon_details: "Szczegóły", icon_edit: "Edytuj", icon_delete: "Usuń", confirm_closing: "", confirm_deleting: "Zdarzenie zostanie usunięte na zawsze, kontynuować?", section_description: "Opis", section_time: "Okres czasu", section_type: "Typ", column_wbs: "WBS", column_text: "Nazwa zadania", column_start_date: "Początek", column_duration: "Czas trwania", column_add: "", link: "Link", confirm_link_deleting: "zostanie usunięty", link_start: " (początek)", link_end: " (koniec)", type_task: "Zadanie", type_project: "Projekt", type_milestone: "Milestone", minutes: "Minuty", hours: "Godziny", days: "Dni", weeks: "Tydzień", months: "Miesiące", years: "Lata", message_ok: "OK", message_cancel: "Anuluj", section_constraint: "Constraint", constraint_type: "Constraint type", constraint_date: "Constraint date", asap: "As Soon As Possible", alap: "As Late As Possible", snet: "Start No Earlier Than", snlt: "Start No Later Than", fnet: "Finish No Earlier Than", fnlt: "Finish No Later Than", mso: "Must Start On", mfo: "Must Finish On", resources_filter_placeholder: "type to filter", resources_filter_label: "hide empty" } };
  }, function(t, e, n) {
    Object.defineProperty(e, "__esModule", { value: true });
    e.default = { date: { month_full: ["Januar", "Februar", "Mars", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Desember"], month_short: ["Jan", "Feb", "Mar", "Apr", "Mai", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Des"], day_full: ["Søndag", "Mandag", "Tirsdag", "Onsdag", "Torsdag", "Fredag", "Lørdag"], day_short: ["Søn", "Man", "Tir", "Ons", "Tor", "Fre", "Lør"] }, labels: { new_task: "Ny oppgave", icon_save: "Lagre", icon_cancel: "Avbryt", icon_details: "Detaljer", icon_edit: "Endre", icon_delete: "Slett", confirm_closing: "Endringer blir ikke lagret, er du sikker?", confirm_deleting: "Oppføringen vil bli slettet, er du sikker?", section_description: "Beskrivelse", section_time: "Tidsperiode", section_type: "Type", column_wbs: "WBS", column_text: "Task name", column_start_date: "Start time", column_duration: "Duration", column_add: "", link: "Link", confirm_link_deleting: "will be deleted", link_start: " (start)", link_end: " (end)", type_task: "Task", type_project: "Project", type_milestone: "Milestone", minutes: "Minutes", hours: "Hours", days: "Days", weeks: "Week", months: "Months", years: "Years", message_ok: "OK", message_cancel: "Avbryt", section_constraint: "Constraint", constraint_type: "Constraint type", constraint_date: "Constraint date", asap: "As Soon As Possible", alap: "As Late As Possible", snet: "Start No Earlier Than", snlt: "Start No Later Than", fnet: "Finish No Earlier Than", fnlt: "Finish No Later Than", mso: "Must Start On", mfo: "Must Finish On", resources_filter_placeholder: "type to filter", resources_filter_label: "hide empty" } };
  }, function(t, e, n) {
    Object.defineProperty(e, "__esModule", { value: true });
    e.default = { date: { month_full: ["Januari", "Februari", "Maart", "April", "Mei", "Juni", "Juli", "Augustus", "September", "Oktober", "November", "December"], month_short: ["Jan", "Feb", "mrt", "Apr", "Mei", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Dec"], day_full: ["Zondag", "Maandag", "Dinsdag", "Woensdag", "Donderdag", "Vrijdag", "Zaterdag"], day_short: ["Zo", "Ma", "Di", "Wo", "Do", "Vr", "Za"] }, labels: { new_task: "Nieuwe taak", icon_save: "Opslaan", icon_cancel: "Annuleren", icon_details: "Details", icon_edit: "Bewerken", icon_delete: "Verwijderen", confirm_closing: "", confirm_deleting: "Item zal permanent worden verwijderd, doorgaan?", section_description: "Beschrijving", section_time: "Tijd periode", section_type: "Type", column_wbs: "WBS", column_text: "Taak omschrijving", column_start_date: "Startdatum", column_duration: "Duur", column_add: "", link: "Koppeling", confirm_link_deleting: "zal worden verwijderd", link_start: " (start)", link_end: " (eind)", type_task: "Task", type_project: "Project", type_milestone: "Milestone", minutes: "minuten", hours: "uren", days: "dagen", weeks: "weken", months: "maanden", years: "jaren", message_ok: "OK", message_cancel: "Annuleren", section_constraint: "Constraint", constraint_type: "Constraint type", constraint_date: "Constraint date", asap: "As Soon As Possible", alap: "As Late As Possible", snet: "Start No Earlier Than", snlt: "Start No Later Than", fnet: "Finish No Earlier Than", fnlt: "Finish No Later Than", mso: "Must Start On", mfo: "Must Finish On", resources_filter_placeholder: "type to filter", resources_filter_label: "hide empty" } };
  }, function(t, e, n) {
    Object.defineProperty(e, "__esModule", { value: true });
    e.default = { date: { month_full: ["Januar", "Februar", "Mars", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Desember"], month_short: ["Jan", "Feb", "Mar", "Apr", "Mai", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Des"], day_full: ["Søndag", "Mandag", "Tirsdag", "Onsdag", "Torsdag", "Fredag", "Lørdag"], day_short: ["Søn", "Mon", "Tir", "Ons", "Tor", "Fre", "Lør"] }, labels: { new_task: "Ny oppgave", icon_save: "Lagre", icon_cancel: "Avbryt", icon_details: "Detaljer", icon_edit: "Rediger", icon_delete: "Slett", confirm_closing: "", confirm_deleting: "Hendelsen vil bli slettet permanent. Er du sikker?", section_description: "Beskrivelse", section_time: "Tidsperiode", section_type: "Type", column_wbs: "WBS", column_text: "Task name", column_start_date: "Start time", column_duration: "Duration", column_add: "", link: "Link", confirm_link_deleting: "will be deleted", link_start: " (start)", link_end: " (end)", type_task: "Task", type_project: "Project", type_milestone: "Milestone", minutes: "Minutes", hours: "Hours", days: "Days", weeks: "Week", months: "Months", years: "Years", message_ok: "OK", message_cancel: "Avbryt", section_constraint: "Constraint", constraint_type: "Constraint type", constraint_date: "Constraint date", asap: "As Soon As Possible", alap: "As Late As Possible", snet: "Start No Earlier Than", snlt: "Start No Later Than", fnet: "Finish No Earlier Than", fnlt: "Finish No Later Than", mso: "Must Start On", mfo: "Must Finish On", resources_filter_placeholder: "type to filter", resources_filter_label: "hide empty" } };
  }, function(t, e, n) {
    Object.defineProperty(e, "__esModule", { value: true });
    var i = function() {
      return function(t2) {
        var e2 = this;
        for (var n2 in this.addLocale = function(t3, n3) {
          e2._locales[t3] = n3;
        }, this.getLocale = function(t3) {
          return e2._locales[t3];
        }, this._locales = {}, t2)
          this._locales[n2] = t2[n2];
      };
    }();
    e.default = i;
  }, function(t, e, n) {
    Object.defineProperty(e, "__esModule", { value: true });
    e.default = { date: { month_full: ["1월", "2월", "3월", "4월", "5월", "6월", "7월", "8월", "9월", "10월", "11월", "12월"], month_short: ["1월", "2월", "3월", "4월", "5월", "6월", "7월", "8월", "9월", "10월", "11월", "12월"], day_full: ["일요일", "월요일", "화요일", "수요일", "목요일", "금요일", "토요일"], day_short: ["일", "월", "화", "수", "목", "금", "토"] }, labels: { new_task: "이름없는 작업", icon_save: "저장", icon_cancel: "취소", icon_details: "세부 사항", icon_edit: "수정", icon_delete: "삭제", confirm_closing: "", confirm_deleting: "작업을 삭제하시겠습니까?", section_description: "설명", section_time: "기간", section_type: "Type", column_wbs: "WBS", column_text: "작업명", column_start_date: "시작일", column_duration: "기간", column_add: "", link: "전제", confirm_link_deleting: "삭제 하시겠습니까?", link_start: " (start)", link_end: " (end)", type_task: "작업", type_project: "프로젝트", type_milestone: "마일스톤", minutes: "분", hours: "시간", days: "일", weeks: "주", months: "달", years: "년", message_ok: "OK", message_cancel: "취소", section_constraint: "Constraint", constraint_type: "Constraint type", constraint_date: "Constraint date", asap: "As Soon As Possible", alap: "As Late As Possible", snet: "Start No Earlier Than", snlt: "Start No Later Than", fnet: "Finish No Earlier Than", fnlt: "Finish No Later Than", mso: "Must Start On", mfo: "Must Finish On", resources_filter_placeholder: "type to filter", resources_filter_label: "hide empty" } };
  }, function(t, e, n) {
    Object.defineProperty(e, "__esModule", { value: true });
    e.default = { date: { month_full: ["1月", "2月", "3月", "4月", "5月", "6月", "7月", "8月", "9月", "10月", "11月", "12月"], month_short: ["1月", "2月", "3月", "4月", "5月", "6月", "7月", "8月", "9月", "10月", "11月", "12月"], day_full: ["日曜日", "月曜日", "火曜日", "水曜日", "木曜日", "金曜日", "土曜日"], day_short: ["日", "月", "火", "水", "木", "金", "土"] }, labels: { new_task: "新しい仕事", icon_save: "保存", icon_cancel: "キャンセル", icon_details: "詳細", icon_edit: "編集", icon_delete: "削除", confirm_closing: "", confirm_deleting: "イベント完全に削除されます、宜しいですか？", section_description: "デスクリプション", section_time: "期間", section_type: "Type", column_wbs: "WBS", column_text: "Task name", column_start_date: "Start time", column_duration: "Duration", column_add: "", link: "Link", confirm_link_deleting: "will be deleted", link_start: " (start)", link_end: " (end)", type_task: "Task", type_project: "Project", type_milestone: "Milestone", minutes: "Minutes", hours: "Hours", days: "Days", weeks: "Week", months: "Months", years: "Years", message_ok: "OK", message_cancel: "キャンセル", section_constraint: "Constraint", constraint_type: "Constraint type", constraint_date: "Constraint date", asap: "As Soon As Possible", alap: "As Late As Possible", snet: "Start No Earlier Than", snlt: "Start No Later Than", fnet: "Finish No Earlier Than", fnlt: "Finish No Later Than", mso: "Must Start On", mfo: "Must Finish On", resources_filter_placeholder: "type to filter", resources_filter_label: "hide empty" } };
  }, function(t, e, n) {
    Object.defineProperty(e, "__esModule", { value: true });
    e.default = { date: { month_full: ["Gennaio", "Febbraio", "Marzo", "Aprile", "Maggio", "Giugno", "Luglio", "Agosto", "Settembre", "Ottobre", "Novembre", "Dicembre"], month_short: ["Gen", "Feb", "Mar", "Apr", "Mag", "Giu", "Lug", "Ago", "Set", "Ott", "Nov", "Dic"], day_full: ["Domenica", "Lunedì", "Martedì", "Mercoledì", "Giovedì", "Venerdì", "Sabato"], day_short: ["Dom", "Lun", "Mar", "Mer", "Gio", "Ven", "Sab"] }, labels: { new_task: "Nuovo compito", icon_save: "Salva", icon_cancel: "Chiudi", icon_details: "Dettagli", icon_edit: "Modifica", icon_delete: "Elimina", confirm_closing: "", confirm_deleting: "Sei sicuro di confermare l'eliminazione?", section_description: "Descrizione", section_time: "Periodo di tempo", section_type: "Tipo", column_wbs: "WBS", column_text: "Nome Attività", column_start_date: "Inizio", column_duration: "Durata", column_add: "", link: "Link", confirm_link_deleting: "sarà eliminato", link_start: " (inizio)", link_end: " (fine)", type_task: "Task", type_project: "Project", type_milestone: "Milestone", minutes: "Minuti", hours: "Ore", days: "Giorni", weeks: "Settimane", months: "Mesi", years: "Anni", message_ok: "OK", message_cancel: "Chiudi", section_constraint: "Constraint", constraint_type: "Constraint type", constraint_date: "Constraint date", asap: "As Soon As Possible", alap: "As Late As Possible", snet: "Start No Earlier Than", snlt: "Start No Later Than", fnet: "Finish No Earlier Than", fnlt: "Finish No Later Than", mso: "Must Start On", mfo: "Must Finish On", resources_filter_placeholder: "type to filter", resources_filter_label: "hide empty" } };
  }, function(t, e, n) {
    Object.defineProperty(e, "__esModule", { value: true });
    e.default = { date: { month_full: ["Januari", "Februari", "Maret", "April", "Mei", "Juni", "Juli", "Agustus", "September", "Oktober", "November", "Desember"], month_short: ["Jan", "Feb", "Mar", "Apr", "Mei", "Jun", "Jul", "Ags", "Sep", "Okt", "Nov", "Des"], day_full: ["Minggu", "Senin", "Selasa", "Rabu", "Kamis", "Jumat", "Sabtu"], day_short: ["Ming", "Sen", "Sel", "Rab", "Kam", "Jum", "Sab"] }, labels: { new_task: "Tugas baru", icon_save: "Simpan", icon_cancel: "Batal", icon_details: "Detail", icon_edit: "Edit", icon_delete: "Hapus", confirm_closing: "", confirm_deleting: "Acara akan dihapus", section_description: "Keterangan", section_time: "Periode", section_type: "Type", column_wbs: "WBS", column_text: "Task name", column_start_date: "Start time", column_duration: "Duration", column_add: "", link: "Link", confirm_link_deleting: "will be deleted", link_start: " (start)", link_end: " (end)", type_task: "Task", type_project: "Project", type_milestone: "Milestone", minutes: "Minutes", hours: "Hours", days: "Days", weeks: "Week", months: "Months", years: "Years", message_ok: "OK", message_cancel: "Batal", section_constraint: "Constraint", constraint_type: "Constraint type", constraint_date: "Constraint date", asap: "As Soon As Possible", alap: "As Late As Possible", snet: "Start No Earlier Than", snlt: "Start No Later Than", fnet: "Finish No Earlier Than", fnlt: "Finish No Later Than", mso: "Must Start On", mfo: "Must Finish On", resources_filter_placeholder: "type to filter", resources_filter_label: "hide empty" } };
  }, function(t, e, n) {
    Object.defineProperty(e, "__esModule", { value: true });
    e.default = { date: { month_full: ["Január", "Február", "Március", "Április", "Május", "Június", "Július", "Augusztus", "Szeptember", "Október", "November", "December"], month_short: ["Jan", "Feb", "Már", "Ápr", "Máj", "Jún", "Júl", "Aug", "Sep", "Okt", "Nov", "Dec"], day_full: ["Vasárnap", "Hétfõ", "Kedd", "Szerda", "Csütörtök", "Péntek", "szombat"], day_short: ["Va", "Hé", "Ke", "Sze", "Csü", "Pé", "Szo"] }, labels: { new_task: "Új feladat", icon_save: "Mentés", icon_cancel: "Mégse", icon_details: "Részletek", icon_edit: "Szerkesztés", icon_delete: "Törlés", confirm_closing: "", confirm_deleting: "Az esemény törölve lesz, biztosan folytatja?", section_description: "Leírás", section_time: "Idõszak", section_type: "Type", column_wbs: "WBS", column_text: "Task name", column_start_date: "Start time", column_duration: "Duration", column_add: "", link: "Link", confirm_link_deleting: "will be deleted", link_start: " (start)", link_end: " (end)", type_task: "Task", type_project: "Project", type_milestone: "Milestone", minutes: "Minutes", hours: "Hours", days: "Days", weeks: "Week", months: "Months", years: "Years", message_ok: "OK", message_cancel: "Mégse", section_constraint: "Constraint", constraint_type: "Constraint type", constraint_date: "Constraint date", asap: "As Soon As Possible", alap: "As Late As Possible", snet: "Start No Earlier Than", snlt: "Start No Later Than", fnet: "Finish No Earlier Than", fnlt: "Finish No Later Than", mso: "Must Start On", mfo: "Must Finish On", resources_filter_placeholder: "type to filter", resources_filter_label: "hide empty" } };
  }, function(t, e, n) {
    Object.defineProperty(e, "__esModule", { value: true });
    e.default = { date: { month_full: ["Siječanj", "Veljača", "Ožujak", "Travanj", "Svibanj", "Lipanj", "Srpanj", "Kolovoz", "Rujan", "Listopad", "Studeni", "Prosinac"], month_short: ["Sij", "Velj", "Ožu", "Tra", "Svi", "Lip", "Srp", "Kol", "Ruj", "Lis", "Stu", "Pro"], day_full: ["Nedjelja", "Ponedjeljak", "Utorak", "Srijeda", "Četvrtak", "Petak", "Subota"], day_short: ["Ned", "Pon", "Uto", "Sri", "Čet", "Pet", "Sub"] }, labels: { new_task: "Novi Zadatak", icon_save: "Spremi", icon_cancel: "Odustani", icon_details: "Detalji", icon_edit: "Izmjeni", icon_delete: "Obriši", confirm_closing: "", confirm_deleting: "Zadatak će biti trajno izbrisan, jeste li sigurni?", section_description: "Opis", section_time: "Vremenski Period", section_type: "Tip", column_wbs: "WBS", column_text: "Naziv Zadatka", column_start_date: "Početno Vrijeme", column_duration: "Trajanje", column_add: "", link: "Poveznica", confirm_link_deleting: "će biti izbrisan", link_start: " (početak)", link_end: " (kraj)", type_task: "Zadatak", type_project: "Projekt", type_milestone: "Milestone", minutes: "Minute", hours: "Sati", days: "Dani", weeks: "Tjedni", months: "Mjeseci", years: "Godine", message_ok: "OK", message_cancel: "Odustani", section_constraint: "Constraint", constraint_type: "Constraint type", constraint_date: "Constraint date", asap: "As Soon As Possible", alap: "As Late As Possible", snet: "Start No Earlier Than", snlt: "Start No Later Than", fnet: "Finish No Earlier Than", fnlt: "Finish No Later Than", mso: "Must Start On", mfo: "Must Finish On", resources_filter_placeholder: "type to filter", resources_filter_label: "hide empty" } };
  }, function(t, e, n) {
    Object.defineProperty(e, "__esModule", { value: true });
    e.default = { date: { month_full: ["ינואר", "פברואר", "מרץ", "אפריל", "מאי", "יוני", "יולי", "אוגוסט", "ספטמבר", "אוקטובר", "נובמבר", "דצמבר"], month_short: ["ינו", "פבר", "מרץ", "אפר", "מאי", "יונ", "יול", "אוג", "ספט", "אוק", "נוב", "דצמ"], day_full: ["ראשון", "שני", "שלישי", "רביעי", "חמישי", "שישי", "שבת"], day_short: ["א", "ב", "ג", "ד", "ה", "ו", "ש"] }, labels: { new_task: "משימה חדש", icon_save: "שמור", icon_cancel: "בטל", icon_details: "פרטים", icon_edit: "ערוך", icon_delete: "מחק", confirm_closing: "", confirm_deleting: "ארוע ימחק סופית.להמשיך?", section_description: "הסבר", section_time: "תקופה", section_type: "Type", column_wbs: "WBS", column_text: "Task name", column_start_date: "Start time", column_duration: "Duration", column_add: "", link: "Link", confirm_link_deleting: "will be deleted", link_start: " (start)", link_end: " (end)", type_task: "Task", type_project: "Project", type_milestone: "Milestone", minutes: "Minutes", hours: "Hours", days: "Days", weeks: "Week", months: "Months", years: "Years", message_ok: "OK", message_cancel: "בטל", section_constraint: "Constraint", constraint_type: "Constraint type", constraint_date: "Constraint date", asap: "As Soon As Possible", alap: "As Late As Possible", snet: "Start No Earlier Than", snlt: "Start No Later Than", fnet: "Finish No Earlier Than", fnlt: "Finish No Later Than", mso: "Must Start On", mfo: "Must Finish On", resources_filter_placeholder: "type to filter", resources_filter_label: "hide empty" } };
  }, function(t, e, n) {
    Object.defineProperty(e, "__esModule", { value: true });
    e.default = { date: { month_full: ["Janvier", "Février", "Mars", "Avril", "Mai", "Juin", "Juillet", "Août", "Septembre", "Octobre", "Novembre", "Décembre"], month_short: ["Jan", "Fév", "Mar", "Avr", "Mai", "Juin", "Juil", "Aoû", "Sep", "Oct", "Nov", "Déc"], day_full: ["Dimanche", "Lundi", "Mardi", "Mercredi", "Jeudi", "Vendredi", "Samedi"], day_short: ["Dim", "Lun", "Mar", "Mer", "Jeu", "Ven", "Sam"] }, labels: { new_task: "Nouvelle tâche", icon_save: "Enregistrer", icon_cancel: "Annuler", icon_details: "Détails", icon_edit: "Modifier", icon_delete: "Effacer", confirm_closing: "", confirm_deleting: "L'événement sera effacé sans appel, êtes-vous sûr ?", section_description: "Description", section_time: "Période", section_type: "Type", column_wbs: "OTP", column_text: "Nom de la tâche", column_start_date: "Date initiale", column_duration: "Durée", column_add: "", link: "Le lien", confirm_link_deleting: "sera supprimé", link_start: "(début)", link_end: "(fin)", type_task: "Task", type_project: "Project", type_milestone: "Milestone", minutes: "Minutes", hours: "Heures", days: "Jours", weeks: "Semaines", months: "Mois", years: "Années", message_ok: "OK", message_cancel: "Annuler", section_constraint: "Constraint", constraint_type: "Constraint type", constraint_date: "Constraint date", asap: "As Soon As Possible", alap: "As Late As Possible", snet: "Start No Earlier Than", snlt: "Start No Later Than", fnet: "Finish No Earlier Than", fnlt: "Finish No Later Than", mso: "Must Start On", mfo: "Must Finish On", resources_filter_placeholder: "type to filter", resources_filter_label: "hide empty" } };
  }, function(t, e, n) {
    Object.defineProperty(e, "__esModule", { value: true });
    e.default = { date: { month_full: ["Tammikuu", "Helmikuu", "Maaliskuu", "Huhtikuu", "Toukokuu", "Kes&auml;kuu", "Hein&auml;kuu", "Elokuu", "Syyskuu", "Lokakuu", "Marraskuu", "Joulukuu"], month_short: ["Tam", "Hel", "Maa", "Huh", "Tou", "Kes", "Hei", "Elo", "Syy", "Lok", "Mar", "Jou"], day_full: ["Sunnuntai", "Maanantai", "Tiistai", "Keskiviikko", "Torstai", "Perjantai", "Lauantai"], day_short: ["Su", "Ma", "Ti", "Ke", "To", "Pe", "La"] }, labels: { new_task: "Uusi tehtävä", icon_save: "Tallenna", icon_cancel: "Peru", icon_details: "Tiedot", icon_edit: "Muokkaa", icon_delete: "Poista", confirm_closing: "", confirm_deleting: "Haluatko varmasti poistaa tapahtuman?", section_description: "Kuvaus", section_time: "Aikajakso", section_type: "Type", column_wbs: "WBS", column_text: "Task name", column_start_date: "Start time", column_duration: "Duration", column_add: "", link: "Link", confirm_link_deleting: "will be deleted", link_start: " (start)", link_end: " (end)", type_task: "Task", type_project: "Project", type_milestone: "Milestone", minutes: "Minutes", hours: "Hours", days: "Days", weeks: "Week", months: "Months", years: "Years", message_ok: "OK", message_cancel: "Peru", section_constraint: "Constraint", constraint_type: "Constraint type", constraint_date: "Constraint date", asap: "As Soon As Possible", alap: "As Late As Possible", snet: "Start No Earlier Than", snlt: "Start No Later Than", fnet: "Finish No Earlier Than", fnlt: "Finish No Later Than", mso: "Must Start On", mfo: "Must Finish On", resources_filter_placeholder: "type to filter", resources_filter_label: "hide empty" } };
  }, function(t, e, n) {
    Object.defineProperty(e, "__esModule", { value: true });
    e.default = { date: { month_full: ["ژانویه", "فوریه", "مارس", "آوریل", "مه", "ژوئن", "ژوئیه", "اوت", "سپتامبر", "اکتبر", "نوامبر", "دسامبر"], month_short: ["1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"], day_full: ["يکشنبه", "دوشنبه", "سه‌شنبه", "چهارشنبه", "پنجشنبه", "جمعه", "شنبه"], day_short: ["ی", "د", "س", "چ", "پ", "ج", "ش"] }, labels: { new_task: "وظیفه جدید", icon_save: "ذخیره", icon_cancel: "لغو", icon_details: "جزییات", icon_edit: "ویرایش", icon_delete: "حذف", confirm_closing: "تغییرات شما ازدست خواهد رفت، آیا مطمئن هستید؟", confirm_deleting: "این مورد برای همیشه حذف خواهد شد، آیا مطمئن هستید؟", section_description: "توضیحات", section_time: "مدت زمان", section_type: "نوع", column_wbs: "WBS", column_text: "عنوان", column_start_date: "زمان شروع", column_duration: "مدت", column_add: "", link: "ارتباط", confirm_link_deleting: "حذف خواهد شد", link_start: " (آغاز)", link_end: " (پایان)", type_task: "وظیفه", type_project: "پروژه", type_milestone: "نگارش", minutes: "دقایق", hours: "ساعات", days: "روزها", weeks: "هفته", months: "ماه‌ها", years: "سال‌ها", message_ok: "تایید", message_cancel: "لغو", section_constraint: "Constraint", constraint_type: "Constraint type", constraint_date: "Constraint date", asap: "As Soon As Possible", alap: "As Late As Possible", snet: "Start No Earlier Than", snlt: "Start No Later Than", fnet: "Finish No Earlier Than", fnlt: "Finish No Later Than", mso: "Must Start On", mfo: "Must Finish On", resources_filter_placeholder: "type to filter", resources_filter_label: "hide empty" } };
  }, function(t, e, n) {
    Object.defineProperty(e, "__esModule", { value: true });
    e.default = { date: { month_full: ["Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"], month_short: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"], day_full: ["Domingo", "Lunes", "Martes", "Miércoles", "Jueves", "Viernes", "Sábado"], day_short: ["Dom", "Lun", "Mar", "Mié", "Jue", "Vie", "Sáb"] }, labels: { new_task: "Nueva tarea", icon_save: "Guardar", icon_cancel: "Cancelar", icon_details: "Detalles", icon_edit: "Editar", icon_delete: "Eliminar", confirm_closing: "", confirm_deleting: "El evento se borrará definitivamente, ¿continuar?", section_description: "Descripción", section_time: "Período", section_type: "Tipo", column_wbs: "EDT", column_text: "Tarea", column_start_date: "Inicio", column_duration: "Duración", column_add: "", link: "Enlace", confirm_link_deleting: "será borrada", link_start: " (inicio)", link_end: " (fin)", type_task: "Tarea", type_project: "Proyecto", type_milestone: "Hito", minutes: "Minutos", hours: "Horas", days: "Días", weeks: "Semanas", months: "Meses", years: "Años", message_ok: "OK", message_cancel: "Cancelar", section_constraint: "Constraint", constraint_type: "Constraint type", constraint_date: "Constraint date", asap: "As Soon As Possible", alap: "As Late As Possible", snet: "Start No Earlier Than", snlt: "Start No Later Than", fnet: "Finish No Earlier Than", fnlt: "Finish No Later Than", mso: "Must Start On", mfo: "Must Finish On", resources_filter_placeholder: "type to filter", resources_filter_label: "hide empty" } };
  }, function(t, e, n) {
    Object.defineProperty(e, "__esModule", { value: true });
    e.default = { date: { month_full: ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"], month_short: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"], day_full: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"], day_short: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"] }, labels: { new_task: "New task", icon_save: "Save", icon_cancel: "Cancel", icon_details: "Details", icon_edit: "Edit", icon_delete: "Delete", confirm_closing: "", confirm_deleting: "Task will be deleted permanently, are you sure?", section_description: "Description", section_time: "Time period", section_type: "Type", column_wbs: "WBS", column_text: "Task name", column_start_date: "Start time", column_duration: "Duration", column_add: "", link: "Link", confirm_link_deleting: "will be deleted", link_start: " (start)", link_end: " (end)", type_task: "Task", type_project: "Project", type_milestone: "Milestone", minutes: "Minutes", hours: "Hours", days: "Days", weeks: "Week", months: "Months", years: "Years", message_ok: "OK", message_cancel: "Cancel", section_constraint: "Constraint", constraint_type: "Constraint type", constraint_date: "Constraint date", asap: "As Soon As Possible", alap: "As Late As Possible", snet: "Start No Earlier Than", snlt: "Start No Later Than", fnet: "Finish No Earlier Than", fnlt: "Finish No Later Than", mso: "Must Start On", mfo: "Must Finish On", resources_filter_placeholder: "type to filter", resources_filter_label: "hide empty" } };
  }, function(t, e, n) {
    Object.defineProperty(e, "__esModule", { value: true });
    e.default = { date: { month_full: ["Ιανουάριος", "Φεβρουάριος", "Μάρτιος", "Απρίλιος", "Μάϊος", "Ιούνιος", "Ιούλιος", "Αύγουστος", "Σεπτέμβριος", "Οκτώβριος", "Νοέμβριος", "Δεκέμβριος"], month_short: ["ΙΑΝ", "ΦΕΒ", "ΜΑΡ", "ΑΠΡ", "ΜΑΙ", "ΙΟΥΝ", "ΙΟΥΛ", "ΑΥΓ", "ΣΕΠ", "ΟΚΤ", "ΝΟΕ", "ΔΕΚ"], day_full: ["Κυριακή", "Δευτέρα", "Τρίτη", "Τετάρτη", "Πέμπτη", "Παρασκευή", "Κυριακή"], day_short: ["ΚΥ", "ΔΕ", "ΤΡ", "ΤΕ", "ΠΕ", "ΠΑ", "ΣΑ"] }, labels: { new_task: "Νέα εργασία", icon_save: "Αποθήκευση", icon_cancel: "Άκυρο", icon_details: "Λεπτομέρειες", icon_edit: "Επεξεργασία", icon_delete: "Διαγραφή", confirm_closing: "", confirm_deleting: "Το έργο θα διαγραφεί οριστικά. Θέλετε να συνεχίσετε;", section_description: "Περιγραφή", section_time: "Χρονική περίοδος", section_type: "Type", column_wbs: "WBS", column_text: "Task name", column_start_date: "Start time", column_duration: "Duration", column_add: "", link: "Link", confirm_link_deleting: "will be deleted", link_start: " (start)", link_end: " (end)", type_task: "Task", type_project: "Project", type_milestone: "Milestone", minutes: "Minutes", hours: "Hours", days: "Days", weeks: "Week", months: "Months", years: "Years", message_ok: "OK", message_cancel: "Άκυρο", section_constraint: "Constraint", constraint_type: "Constraint type", constraint_date: "Constraint date", asap: "As Soon As Possible", alap: "As Late As Possible", snet: "Start No Earlier Than", snlt: "Start No Later Than", fnet: "Finish No Earlier Than", fnlt: "Finish No Later Than", mso: "Must Start On", mfo: "Must Finish On", resources_filter_placeholder: "type to filter", resources_filter_label: "hide empty" } };
  }, function(t, e, n) {
    Object.defineProperty(e, "__esModule", { value: true });
    e.default = { date: { month_full: [" Januar", " Februar", " März ", " April", " Mai", " Juni", " Juli", " August", " September ", " Oktober", " November ", " Dezember"], month_short: ["Jan", "Feb", "Mär", "Apr", "Mai", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Dez"], day_full: ["Sonntag", "Montag", "Dienstag", " Mittwoch", " Donnerstag", "Freitag", "Samstag"], day_short: ["So", "Mo", "Di", "Mi", "Do", "Fr", "Sa"] }, labels: { new_task: "Neue Aufgabe", icon_save: "Speichern", icon_cancel: "Abbrechen", icon_details: "Details", icon_edit: "Ändern", icon_delete: "Löschen", confirm_closing: "", confirm_deleting: "Der Eintrag wird gelöscht", section_description: "Beschreibung", section_time: "Zeitspanne", section_type: "Type", column_wbs: "PSP", column_text: "Task-Namen", column_start_date: "Startzeit", column_duration: "Dauer", column_add: "", link: "Link", confirm_link_deleting: "werden gelöscht", link_start: "(starten)", link_end: "(ende)", type_task: "Task", type_project: "Project", type_milestone: "Milestone", minutes: "Minuten", hours: "Stunden", days: "Tage", weeks: "Wochen", months: "Monate", years: "Jahre", message_ok: "OK", message_cancel: "Abbrechen", section_constraint: "Constraint", constraint_type: "Constraint type", constraint_date: "Constraint date", asap: "As Soon As Possible", alap: "As Late As Possible", snet: "Start No Earlier Than", snlt: "Start No Later Than", fnet: "Finish No Earlier Than", fnlt: "Finish No Later Than", mso: "Must Start On", mfo: "Must Finish On", resources_filter_placeholder: "type to filter", resources_filter_label: "hide empty" } };
  }, function(t, e, n) {
    Object.defineProperty(e, "__esModule", { value: true });
    e.default = { date: { month_full: ["Januar", "Februar", "Marts", "April", "Maj", "Juni", "Juli", "August", "September", "Oktober", "November", "December"], month_short: ["Jan", "Feb", "Mar", "Apr", "Maj", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Dec"], day_full: ["Søndag", "Mandag", "Tirsdag", "Onsdag", "Torsdag", "Fredag", "Lørdag"], day_short: ["Søn", "Man", "Tir", "Ons", "Tor", "Fre", "Lør"] }, labels: { new_task: "Ny opgave", icon_save: "Gem", icon_cancel: "Fortryd", icon_details: "Detaljer", icon_edit: "Tilret", icon_delete: "Slet", confirm_closing: "Dine rettelser vil gå tabt.. Er dy sikker?", confirm_deleting: "Bigivenheden vil blive slettet permanent. Er du sikker?", section_description: "Beskrivelse", section_time: "Tidsperiode", section_type: "Type", column_wbs: "WBS", column_text: "Task name", column_start_date: "Start time", column_duration: "Duration", column_add: "", link: "Link", confirm_link_deleting: "will be deleted", link_start: " (start)", link_end: " (end)", type_task: "Task", type_project: "Project", type_milestone: "Milestone", minutes: "Minutes", hours: "Hours", days: "Days", weeks: "Week", months: "Months", years: "Years", message_ok: "OK", message_cancel: "Fortryd", section_constraint: "Constraint", constraint_type: "Constraint type", constraint_date: "Constraint date", asap: "As Soon As Possible", alap: "As Late As Possible", snet: "Start No Earlier Than", snlt: "Start No Later Than", fnet: "Finish No Earlier Than", fnlt: "Finish No Later Than", mso: "Must Start On", mfo: "Must Finish On", resources_filter_placeholder: "type to filter", resources_filter_label: "hide empty" } };
  }, function(t, e, n) {
    Object.defineProperty(e, "__esModule", { value: true });
    e.default = { date: { month_full: ["Leden", "Únor", "Březen", "Duben", "Květen", "Červen", "Červenec", "Srpen", "Září", "Říjen", "Listopad", "Prosinec"], month_short: ["Led", "Ún", "Bře", "Dub", "Kvě", "Čer", "Čec", "Srp", "Září", "Říj", "List", "Pro"], day_full: ["Neděle", "Pondělí", "Úterý", "Středa", "Čtvrtek", "Pátek", "Sobota"], day_short: ["Ne", "Po", "Út", "St", "Čt", "Pá", "So"] }, labels: { new_task: "Nová práce", icon_save: "Uložit", icon_cancel: "Zpět", icon_details: "Detail", icon_edit: "Edituj", icon_delete: "Smazat", confirm_closing: "", confirm_deleting: "Událost bude trvale smazána, opravdu?", section_description: "Poznámky", section_time: "Doba platnosti", section_type: "Type", column_wbs: "WBS", column_text: "Task name", column_start_date: "Start time", column_duration: "Duration", column_add: "", link: "Link", confirm_link_deleting: "will be deleted", link_start: " (start)", link_end: " (end)", type_task: "Task", type_project: "Project", type_milestone: "Milestone", minutes: "Minutes", hours: "Hours", days: "Days", weeks: "Week", months: "Months", years: "Years", message_ok: "OK", message_cancel: "Zpět", section_constraint: "Constraint", constraint_type: "Constraint type", constraint_date: "Constraint date", asap: "As Soon As Possible", alap: "As Late As Possible", snet: "Start No Earlier Than", snlt: "Start No Later Than", fnet: "Finish No Earlier Than", fnlt: "Finish No Later Than", mso: "Must Start On", mfo: "Must Finish On", resources_filter_placeholder: "type to filter", resources_filter_label: "hide empty" } };
  }, function(t, e, n) {
    Object.defineProperty(e, "__esModule", { value: true });
    e.default = { date: { month_full: ["一月", "二月", "三月", "四月", "五月", "六月", "七月", "八月", "九月", "十月", "十一月", "十二月"], month_short: ["1月", "2月", "3月", "4月", "5月", "6月", "7月", "8月", "9月", "10月", "11月", "12月"], day_full: ["星期日", "星期一", "星期二", "星期三", "星期四", "星期五", "星期六"], day_short: ["日", "一", "二", "三", "四", "五", "六"] }, labels: { new_task: "新任務", icon_save: "保存", icon_cancel: "关闭", icon_details: "详细", icon_edit: "编辑", icon_delete: "删除", confirm_closing: "请确认是否撤销修改!", confirm_deleting: "是否删除日程?", section_description: "描述", section_time: "时间范围", section_type: "类型", column_wbs: "工作分解结构", column_text: "任务名", column_start_date: "开始时间", column_duration: "持续时间", column_add: "", link: "关联", confirm_link_deleting: "将被删除", link_start: " (开始)", link_end: " (结束)", type_task: "任务", type_project: "项目", type_milestone: "里程碑", minutes: "分钟", hours: "小时", days: "天", weeks: "周", months: "月", years: "年", message_ok: "OK", message_cancel: "关闭", section_constraint: "Constraint", constraint_type: "Constraint type", constraint_date: "Constraint date", asap: "As Soon As Possible", alap: "As Late As Possible", snet: "Start No Earlier Than", snlt: "Start No Later Than", fnet: "Finish No Earlier Than", fnlt: "Finish No Later Than", mso: "Must Start On", mfo: "Must Finish On", resources_filter_placeholder: "type to filter", resources_filter_label: "hide empty" } };
  }, function(t, e, n) {
    Object.defineProperty(e, "__esModule", { value: true });
    e.default = { date: { month_full: ["Gener", "Febrer", "Març", "Abril", "Maig", "Juny", "Juliol", "Agost", "Setembre", "Octubre", "Novembre", "Desembre"], month_short: ["Gen", "Feb", "Mar", "Abr", "Mai", "Jun", "Jul", "Ago", "Set", "Oct", "Nov", "Des"], day_full: ["Diumenge", "Dilluns", "Dimarts", "Dimecres", "Dijous", "Divendres", "Dissabte"], day_short: ["Dg", "Dl", "Dm", "Dc", "Dj", "Dv", "Ds"] }, labels: { new_task: "Nova tasca", icon_save: "Guardar", icon_cancel: "Cancel·lar", icon_details: "Detalls", icon_edit: "Editar", icon_delete: "Esborrar", confirm_closing: "", confirm_deleting: "L'esdeveniment s'esborrarà definitivament, continuar ?", section_description: "Descripció", section_time: "Periode de temps", section_type: "Type", column_wbs: "WBS", column_text: "Task name", column_start_date: "Start time", column_duration: "Duration", column_add: "", link: "Link", confirm_link_deleting: "will be deleted", link_start: " (start)", link_end: " (end)", type_task: "Task", type_project: "Project", type_milestone: "Milestone", minutes: "Minutes", hours: "Hours", days: "Days", weeks: "Week", months: "Months", years: "Years", message_ok: "OK", message_cancel: "Cancel·lar", section_constraint: "Constraint", constraint_type: "Constraint type", constraint_date: "Constraint date", asap: "As Soon As Possible", alap: "As Late As Possible", snet: "Start No Earlier Than", snlt: "Start No Later Than", fnet: "Finish No Earlier Than", fnlt: "Finish No Later Than", mso: "Must Start On", mfo: "Must Finish On", resources_filter_placeholder: "type to filter", resources_filter_label: "hide empty" } };
  }, function(t, e, n) {
    Object.defineProperty(e, "__esModule", { value: true });
    e.default = { date: { month_full: ["Студзень", "Люты", "Сакавік", "Красавік", "Maй", "Чэрвень", "Ліпень", "Жнівень", "Верасень", "Кастрычнік", "Лістапад", "Снежань"], month_short: ["Студз", "Лют", "Сак", "Крас", "Maй", "Чэр", "Ліп", "Жнів", "Вер", "Каст", "Ліст", "Снеж"], day_full: ["Нядзеля", "Панядзелак", "Аўторак", "Серада", "Чацвер", "Пятніца", "Субота"], day_short: ["Нд", "Пн", "Аўт", "Ср", "Чцв", "Пт", "Сб"] }, labels: { new_task: "Новае заданне", icon_save: "Захаваць", icon_cancel: "Адмяніць", icon_details: "Дэталі", icon_edit: "Змяніць", icon_delete: "Выдаліць", confirm_closing: "", confirm_deleting: "Падзея будзе выдалена незваротна, працягнуць?", section_description: "Апісанне", section_time: "Перыяд часу", section_type: "Тып", column_wbs: "ІСР", column_text: "Задача", column_start_date: "Пачатак", column_duration: "Працяг", column_add: "", link: "Сувязь", confirm_link_deleting: "будзе выдалена", link_start: "(пачатак)", link_end: "(канец)", type_task: "Task", type_project: "Project", type_milestone: "Milestone", minutes: "Хвiлiна", hours: "Гадзiна", days: "Дзень", weeks: "Тыдзень", months: "Месяц", years: "Год", message_ok: "OK", message_cancel: "Адмяніць", section_constraint: "Constraint", constraint_type: "Constraint type", constraint_date: "Constraint date", asap: "As Soon As Possible", alap: "As Late As Possible", snet: "Start No Earlier Than", snlt: "Start No Later Than", fnet: "Finish No Earlier Than", fnlt: "Finish No Later Than", mso: "Must Start On", mfo: "Must Finish On", resources_filter_placeholder: "type to filter", resources_filter_label: "hide empty" } };
  }, function(t, e, n) {
    Object.defineProperty(e, "__esModule", { value: true });
    e.default = { date: { month_full: ["كانون الثاني", "شباط", "آذار", "نيسان", "أيار", "حزيران", "تموز", "آب", "أيلول", "تشرين الأول", "تشرين الثاني", "كانون الأول"], month_short: ["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"], day_full: ["الأحد", "الأثنين", "ألثلاثاء", "الأربعاء", "ألحميس", "ألجمعة", "السبت"], day_short: ["احد", "اثنين", "ثلاثاء", "اربعاء", "خميس", "جمعة", "سبت"] }, labels: { new_task: "مهمة جديد", icon_save: "اخزن", icon_cancel: "الغاء", icon_details: "تفاصيل", icon_edit: "تحرير", icon_delete: "حذف", confirm_closing: "التغييرات سوف تضيع, هل انت متأكد؟", confirm_deleting: "الحدث سيتم حذفها نهائيا ، هل أنت متأكد؟", section_description: "الوصف", section_time: "الفترة الزمنية", section_type: "Type", column_wbs: "WBS", column_text: "Task name", column_start_date: "Start time", column_duration: "Duration", column_add: "", link: "Link", confirm_link_deleting: "will be deleted", link_start: " (start)", link_end: " (end)", type_task: "Task", type_project: "Project", type_milestone: "Milestone", minutes: "Minutes", hours: "Hours", days: "Days", weeks: "Week", months: "Months", years: "Years", message_ok: "OK", message_cancel: "الغاء", section_constraint: "Constraint", constraint_type: "Constraint type", constraint_date: "Constraint date", asap: "As Soon As Possible", alap: "As Late As Possible", snet: "Start No Earlier Than", snlt: "Start No Later Than", fnet: "Finish No Earlier Than", fnlt: "Finish No Later Than", mso: "Must Start On", mfo: "Must Finish On", resources_filter_placeholder: "type to filter", resources_filter_label: "hide empty" } };
  }, function(t, e, n) {
    Object.defineProperty(e, "__esModule", { value: true });
    var i = n(164), r = n(163), a = n(162), o = n(161), s = n(160), l = n(159), c = n(158), u = n(157), d = n(156), h2 = n(155), f = n(154), _2 = n(153), g = n(152), p = n(151), v2 = n(150), m = n(149), y = n(148), k2 = n(147), b = n(146), w = n(145), x = n(144), S = n(143), $ = n(142), T = n(141), C = n(140), E2 = n(139), D = n(138), A = n(137), M = n(136), I = n(135), P = n(134), N = n(133), L = n(132);
    e.default = function() {
      return new x.default({ en: d.default, ar: i.default, be: r.default, ca: a.default, cn: o.default, cs: s.default, da: l.default, de: c.default, el: u.default, es: h2.default, fa: f.default, fi: _2.default, fr: g.default, he: p.default, hr: v2.default, hu: m.default, id: y.default, it: k2.default, jp: b.default, kr: w.default, nb: S.default, nl: $.default, no: T.default, pl: C.default, pt: E2.default, ro: D.default, ru: A.default, si: M.default, sk: I.default, sv: P.default, tr: N.default, ua: L.default });
    };
  }, function(t, e, n) {
    Object.defineProperty(e, "__esModule", { value: true }), e.default = function() {
    };
  }, function(t, e) {
    t.exports = function(t2) {
      t2.destructor = function() {
        for (var t3 in this.clearAll(), this.callEvent("onDestroy", []), this.$root && delete this.$root.gantt, this._eventRemoveAll && this._eventRemoveAll(), this.$layout && this.$layout.destructor(), this.resetLightbox && this.resetLightbox(), this._dp && this._dp.destructor && this._dp.destructor(), this.$services.destructor(), this.detachAllEvents(), this)
          0 === t3.indexOf("$") && delete this[t3];
        this.$destroyed = true;
      };
    };
  }, function(t, e) {
    t.exports = function(t2) {
      return function(e2, n) {
        e2 || t2.config.show_errors && false !== t2.callEvent("onError", [n]) && (t2.message ? t2.message({ type: "error", text: n, expire: -1 }) : console.log(n));
      };
    };
  }, function(t, e) {
    function n(t2, e2) {
      var n2, i = t2.config.container_resize_timeout || 20;
      if ("timeout" == t2.config.container_resize_method)
        s();
      else
        try {
          t2.event(e2, "resize", function() {
            t2.$scrollbarRepaint ? t2.$scrollbarRepaint = null : r();
          });
        } catch (t3) {
          s();
        }
      function r() {
        clearTimeout(n2), n2 = setTimeout(function() {
          t2.$destroyed || t2.render();
        }, i);
      }
      var a = t2.$root.offsetHeight, o = t2.$root.offsetWidth;
      function s() {
        t2.$root.offsetHeight == a && t2.$root.offsetWidth == o || r(), a = t2.$root.offsetHeight, o = t2.$root.offsetWidth, setTimeout(s, i);
      }
    }
    t.exports = function(t2) {
      "static" == window.getComputedStyle(t2.$root).getPropertyValue("position") && (t2.$root.style.position = "relative");
      var e2 = document.createElement("iframe");
      e2.className = "gantt_container_resize_watcher", e2.tabIndex = -1, t2.config.wai_aria_attributes && (e2.setAttribute("role", "none"), e2.setAttribute("aria-hidden", true)), (!!window.Sfdc || !!window.$A || window.Aura) && (t2.config.container_resize_method = "timeout"), t2.$root.appendChild(e2), e2.contentWindow ? n(t2, e2.contentWindow) : (t2.$root.removeChild(e2), n(t2, window));
    };
  }, function(t, e, n) {
    function i(t2) {
      "@babel/helpers - typeof";
      return (i = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(t3) {
        return typeof t3;
      } : function(t3) {
        return t3 && "function" == typeof Symbol && t3.constructor === Symbol && t3 !== Symbol.prototype ? "symbol" : typeof t3;
      })(t2);
    }
    var r = n(1), a = n(2), o = n(10), s = n(169);
    t.exports = function(t2) {
      var e2 = n(42);
      t2.assert = n(168)(t2);
      var l = "Invalid value of the first argument of `gantt.init`. Supported values: HTMLElement, String (element id).This error means that either invalid object is passed into `gantt.init` or that the element with the specified ID doesn't exist on the page when `gantt.init` is called.";
      function c(e3) {
        if (!e3 || "string" == typeof e3 && document.getElementById(e3))
          return true;
        if (function(t3) {
          try {
            t3.cloneNode(false);
          } catch (t4) {
            return false;
          }
          return true;
        }(e3))
          return true;
        throw t2.assert(false, l), new Error(l);
      }
      t2.init = function(e3, n2, i2) {
        t2.env.isNode ? e3 = null : c(e3), n2 && i2 && (this.config.start_date = this._min_date = new Date(n2), this.config.end_date = this._max_date = new Date(i2)), this.date.init(), this.init = function(e4) {
          t2.env.isNode ? e4 = null : c(e4), this.$container && this.$container.parentNode && (this.$container.parentNode.removeChild(this.$container), this.$container = null), this.$layout && this.$layout.clear(), this._reinit(e4);
        }, this._reinit(e3);
      }, t2._quickRefresh = function(t3) {
        for (var e3 = this._getDatastores.call(this), n2 = 0; n2 < e3.length; n2++)
          e3[n2]._quick_refresh = true;
        t3();
        for (n2 = 0; n2 < e3.length; n2++)
          e3[n2]._quick_refresh = false;
      };
      var u = (function() {
        this._clearTaskLayers && this._clearTaskLayers(), this._clearLinkLayers && this._clearLinkLayers(), this.$layout && (this.$layout.destructor(), this.$layout = null, this.$ui.reset());
      }).bind(t2), d = (function() {
        o(t2) || (this.$root.innerHTML = "", this.$root.gantt = this, e2(this), this.config.layout.id = "main", this.$layout = this.$ui.createView("layout", this.$root, this.config.layout), this.$layout.attachEvent("onBeforeResize", function() {
          for (var e3 = t2.$services.getService("datastores"), n2 = 0; n2 < e3.length; n2++)
            t2.getDatastore(e3[n2]).filter(), t2.getDatastore(e3[n2]).callEvent("onBeforeRefreshAll", []);
        }), this.$layout.attachEvent("onResize", function() {
          t2._quickRefresh(function() {
            t2.refreshData();
          });
        }), this.callEvent("onGanttLayoutReady", []), this.$layout.render(), this.$container = this.$layout.$container.firstChild, s(this));
      }).bind(t2);
      t2.resetLayout = function() {
        u(), d(), this.render();
      }, t2._reinit = function(t3) {
        this.callEvent("onBeforeGanttReady", []), this._update_flags(), this.$services.getService("templateLoader").initTemplates(this), u(), this.$root = null, t3 && (this.$root = r.toNode(t3), d(), this.$mouseEvents.reset(this.$root)), this.callEvent("onTemplatesReady", []), this.callEvent("onGanttReady", []), this.render();
      }, t2.$click = { buttons: { edit: function(e3) {
        t2.isReadonly(t2.getTask(e3)) || t2.showLightbox(e3);
      }, delete: function(e3) {
        var n2 = t2.getTask(e3);
        if (!t2.isReadonly(n2)) {
          var i2 = t2.locale.labels.confirm_deleting, r2 = t2.locale.labels.confirm_deleting_title;
          t2._dhtmlx_confirm(i2, r2, function() {
            t2.isTaskExists(e3) ? (n2.$new ? (t2.silent(function() {
              t2.deleteTask(e3, true);
            }), t2.refreshData()) : t2.deleteTask(e3), t2.hideLightbox()) : t2.hideLightbox();
          });
        }
      } } }, t2.render = function() {
        var n2;
        if (this.callEvent("onBeforeGanttRender", []), !o(t2)) {
          !this.config.sort && this._sort && (this._sort = void 0), this.$root && (this.config.rtl ? (this.$root.classList.add("gantt_rtl"), this.$root.firstChild.classList.add("gantt_rtl")) : (this.$root.classList.remove("gantt_rtl"), this.$root.firstChild.classList.remove("gantt_rtl")));
          var i2 = this.getScrollState(), r2 = i2 ? i2.x : 0;
          if (this._getHorizontalScrollbar())
            r2 = this._getHorizontalScrollbar().$config.codeScrollLeft || r2 || 0;
          n2 = null, r2 && (n2 = t2.dateFromPos(r2 + this.config.task_scroll_offset));
        }
        if (e2(this), o(t2))
          t2.refreshData();
        else {
          this.$layout.$config.autosize = this.config.autosize;
          var a2 = this.config.preserve_scroll;
          if (this.config.preserve_scroll = false, this.$layout.resize(), this.config.preserve_scroll = a2, this.config.preserve_scroll && i2 && r2) {
            var s2 = t2.getScrollState();
            if (+n2 != +t2.dateFromPos(s2.x) || s2.y != i2.y) {
              r2 = null;
              var l2 = null;
              if (n2)
                r2 = Math.max(t2.posFromDate(n2) - t2.config.task_scroll_offset, 0);
              i2.y && (l2 = i2.y), t2.scrollTo(r2, l2);
            }
          }
        }
        this.callEvent("onGanttRender", []);
      }, t2.setSizes = t2.render, t2.getTaskRowNode = function(t3) {
        for (var e3 = this.$grid_data.childNodes, n2 = this.config.task_attribute, i2 = 0; i2 < e3.length; i2++) {
          if (e3[i2].getAttribute) {
            if (e3[i2].getAttribute(n2) == t3)
              return e3[i2];
          }
        }
        return null;
      }, t2.changeLightboxType = function(e3) {
        if (this.getLightboxType() == e3)
          return true;
        t2._silent_redraw_lightbox(e3);
      }, t2._get_link_type = function(e3, n2) {
        var i2 = null;
        return e3 && n2 ? i2 = t2.config.links.start_to_start : !e3 && n2 ? i2 = t2.config.links.finish_to_start : e3 || n2 ? e3 && !n2 && (i2 = t2.config.links.start_to_finish) : i2 = t2.config.links.finish_to_finish, i2;
      }, t2.isLinkAllowed = function(t3, e3, n2, r2) {
        var a2 = null;
        if (!(a2 = "object" == i(t3) ? t3 : { source: t3, target: e3, type: this._get_link_type(n2, r2) }))
          return false;
        if (!(a2.source && a2.target && a2.type))
          return false;
        if (a2.source == a2.target)
          return false;
        var o2 = true;
        return this.checkEvent("onLinkValidation") && (o2 = this.callEvent("onLinkValidation", [a2])), o2;
      }, t2._correct_dst_change = function(e3, n2, i2, r2) {
        var o2 = a.getSecondsInUnit(r2) * i2;
        if (o2 > 3600 && o2 < 86400) {
          var s2 = e3.getTimezoneOffset() - n2;
          s2 && (e3 = t2.date.add(e3, s2, "minute"));
        }
        return e3;
      }, t2.isSplitTask = function(e3) {
        return t2.assert(e3 && e3 instanceof Object, "Invalid argument <b>task</b>=" + e3 + " of gantt.isSplitTask. Task object was expected"), this.$data.tasksStore._isSplitItem(e3);
      }, t2._is_icon_open_click = function(t3) {
        if (!t3)
          return false;
        var e3 = t3.target || t3.srcElement;
        if (!e3 || !e3.className)
          return false;
        var n2 = r.getClassName(e3);
        return -1 !== n2.indexOf("gantt_tree_icon") && (-1 !== n2.indexOf("gantt_close") || -1 !== n2.indexOf("gantt_open"));
      };
    };
  }, function(t, e) {
    t.exports = function(t2) {
      function e2() {
        return t2._cached_functions.update_if_changed(t2), t2._cached_functions.active || t2._cached_functions.activate(), true;
      }
      t2._cached_functions = { cache: {}, mode: false, critical_path_mode: false, wrap_methods: function(t3, e3) {
        if (e3._prefetch_originals)
          for (var n2 in e3._prefetch_originals)
            e3[n2] = e3._prefetch_originals[n2];
        e3._prefetch_originals = {};
        for (n2 = 0; n2 < t3.length; n2++)
          this.prefetch(t3[n2], e3);
      }, prefetch: function(t3, e3) {
        var n2 = e3[t3];
        if (n2) {
          var i = this;
          e3._prefetch_originals[t3] = n2, e3[t3] = function() {
            for (var e4 = new Array(arguments.length), r = 0, a = arguments.length; r < a; r++)
              e4[r] = arguments[r];
            if (i.active) {
              var o = i.get_arguments_hash(Array.prototype.slice.call(e4));
              i.cache[t3] || (i.cache[t3] = {});
              var s = i.cache[t3];
              if (i.has_cached_value(s, o))
                return i.get_cached_value(s, o);
              var l = n2.apply(this, e4);
              return i.cache_value(s, o, l), l;
            }
            return n2.apply(this, e4);
          };
        }
        return n2;
      }, cache_value: function(t3, e3, n2) {
        this.is_date(n2) && (n2 = new Date(n2)), t3[e3] = n2;
      }, has_cached_value: function(t3, e3) {
        return t3.hasOwnProperty(e3);
      }, get_cached_value: function(t3, e3) {
        var n2 = t3[e3];
        return this.is_date(n2) && (n2 = new Date(n2)), n2;
      }, is_date: function(t3) {
        return t3 && t3.getUTCDate;
      }, get_arguments_hash: function(t3) {
        for (var e3 = [], n2 = 0; n2 < t3.length; n2++)
          e3.push(this.stringify_argument(t3[n2]));
        return "(" + e3.join(";") + ")";
      }, stringify_argument: function(t3) {
        return (t3.id ? t3.id : this.is_date(t3) ? t3.valueOf() : t3) + "";
      }, activate: function() {
        this.clear(), this.active = true;
      }, deactivate: function() {
        this.clear(), this.active = false;
      }, clear: function() {
        this.cache = {};
      }, setup: function(t3) {
        var e3 = [], n2 = ["_isProjectEnd", "_getProjectEnd", "_getSlack"];
        "auto" == this.mode ? t3.config.highlight_critical_path && (e3 = n2) : true === this.mode && (e3 = n2), this.wrap_methods(e3, t3);
      }, update_if_changed: function(t3) {
        (this.critical_path_mode != t3.config.highlight_critical_path || this.mode !== t3.config.optimize_render) && (this.critical_path_mode = t3.config.highlight_critical_path, this.mode = t3.config.optimize_render, this.setup(t3));
      } }, t2.attachEvent("onBeforeGanttRender", e2), t2.attachEvent("onBeforeDataRender", e2), t2.attachEvent("onBeforeSmartRender", function() {
        e2();
      }), t2.attachEvent("onBeforeParse", e2), t2.attachEvent("onDataRender", function() {
        t2._cached_functions.deactivate();
      });
      var n = null;
      t2.attachEvent("onSmartRender", function() {
        n && clearTimeout(n), n = setTimeout(function() {
          t2._cached_functions.deactivate();
        }, 1e3);
      }), t2.attachEvent("onBeforeGanttReady", function() {
        return t2._cached_functions.update_if_changed(t2), true;
      });
    };
  }, function(t, e) {
    function n(t2) {
      "@babel/helpers - typeof";
      return (n = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(t3) {
        return typeof t3;
      } : function(t3) {
        return t3 && "function" == typeof Symbol && t3.constructor === Symbol && t3 !== Symbol.prototype ? "symbol" : typeof t3;
      })(t2);
    }
    t.exports = function(t2) {
      t2.getTaskType = function(e2) {
        var i = e2;
        for (var r in e2 && "object" == n(e2) && (i = e2.type), this.config.types)
          if (this.config.types[r] == i)
            return i;
        return t2.config.types.task;
      };
    };
  }, function(t, e, n) {
    Object.defineProperty(e, "__esModule", { value: true }), e.default = function() {
    };
  }, function(t, e, n) {
    var i = n(2);
    t.exports = function(t2) {
      t2.isUnscheduledTask = function(e3) {
        return t2.assert(e3 && e3 instanceof Object, "Invalid argument <b>task</b>=" + e3 + " of gantt.isUnscheduledTask. Task object was expected"), !!e3.unscheduled || !e3.start_date;
      }, t2._isAllowedUnscheduledTask = function(e3) {
        return !(!e3.unscheduled || !t2.config.show_unscheduled);
      }, t2._isTaskInTimelineLimits = function(t3) {
        var e3 = t3.start_date ? t3.start_date.valueOf() : null, n3 = t3.end_date ? t3.end_date.valueOf() : null;
        return !!(e3 && n3 && e3 <= this._max_date.valueOf() && n3 >= this._min_date.valueOf());
      }, t2.isTaskVisible = function(t3) {
        if (!this.isTaskExists(t3))
          return false;
        var e3 = this.getTask(t3);
        return !(!this._isAllowedUnscheduledTask(e3) && !this._isTaskInTimelineLimits(e3)) && !!(this.getGlobalTaskIndex(t3) >= 0);
      }, t2._getProjectEnd = function() {
        if (t2.config.project_end)
          return t2.config.project_end;
        var e3 = t2.getTaskByTime();
        return (e3 = e3.sort(function(t3, e4) {
          return +t3.end_date > +e4.end_date ? 1 : -1;
        })).length ? e3[e3.length - 1].end_date : null;
      }, t2._getProjectStart = function() {
        if (t2.config.project_start)
          return t2.config.project_start;
        if (t2.config.start_date)
          return t2.config.start_date;
        if (t2.getState().min_date)
          return t2.getState().min_date;
        var e3 = t2.getTaskByTime();
        return (e3 = e3.sort(function(t3, e4) {
          return +t3.start_date > +e4.start_date ? 1 : -1;
        })).length ? e3[0].start_date : null;
      };
      var e2 = function(e3, n3) {
        var i2 = !(!n3 || n3 == t2.config.root_id) && t2.getTask(n3), r2 = null;
        if (i2)
          r2 = t2.config.schedule_from_end ? t2.calculateEndDate({ start_date: i2.end_date, duration: -t2.config.duration_step, task: e3 }) : i2.start_date;
        else if (t2.config.schedule_from_end)
          r2 = t2.calculateEndDate({ start_date: t2._getProjectEnd(), duration: -t2.config.duration_step, task: e3 });
        else {
          var a2 = t2.getTaskByIndex(0);
          r2 = a2 ? a2.start_date ? a2.start_date : a2.end_date ? t2.calculateEndDate({ start_date: a2.end_date, duration: -t2.config.duration_step, task: e3 }) : null : t2.config.start_date || t2.getState().min_date;
        }
        return t2.assert(r2, "Invalid dates"), new Date(r2);
      };
      t2._set_default_task_timing = function(n3) {
        n3.start_date = n3.start_date || e2(n3, t2.getParent(n3)), n3.duration = n3.duration || t2.config.duration_step, n3.end_date = n3.end_date || t2.calculateEndDate(n3);
      }, t2.createTask = function(n3, i2, r2) {
        (n3 = n3 || {}, t2.defined(n3.id) || (n3.id = t2.uid()), n3.start_date || (n3.start_date = e2(n3, i2)), void 0 === n3.text && (n3.text = t2.locale.labels.new_task), void 0 === n3.duration && (n3.duration = 1), this.isTaskExists(i2)) && (this.setParent(n3, i2, true), this.getTask(i2).$open = true);
        if (!this.callEvent("onTaskCreated", [n3]))
          return null;
        if (this.config.details_on_create) {
          if (t2.isTaskExists(n3.id))
            t2.getTask(n3.id).$index != n3.$index && (n3.start_date && "string" == typeof n3.start_date && (n3.start_date = this.date.parseDate(n3.start_date, "parse_date")), n3.end_date && "string" == typeof n3.end_date && (n3.end_date = this.date.parseDate(n3.end_date, "parse_date")), this.$data.tasksStore.updateItem(n3.id, n3));
          else
            n3.$new = true, this.silent(function() {
              t2.$data.tasksStore.addItem(n3, r2);
            });
          this.selectTask(n3.id), this.refreshData(), this.showLightbox(n3.id);
        } else
          this.addTask(n3, i2, r2) && (this.showTask(n3.id), this.selectTask(n3.id));
        return n3.id;
      }, t2._update_flags = function(e3, n3) {
        var i2 = t2.$data.tasksStore;
        void 0 === e3 ? (this._lightbox_id = null, i2.silent(function() {
          i2.unselect();
        }), this._tasks_dnd && this._tasks_dnd.drag && (this._tasks_dnd.drag.id = null)) : (this._lightbox_id == e3 && (this._lightbox_id = n3), i2.getSelectedId() == e3 && i2.silent(function() {
          i2.unselect(e3), i2.select(n3);
        }), this._tasks_dnd && this._tasks_dnd.drag && this._tasks_dnd.drag.id == e3 && (this._tasks_dnd.drag.id = n3));
      };
      var n2 = function(e3, n3) {
        var i2 = t2.getTaskType(e3.type), r2 = { type: i2, $no_start: false, $no_end: false };
        return n3 || i2 != e3.$rendered_type ? (i2 == t2.config.types.project ? r2.$no_end = r2.$no_start = true : i2 != t2.config.types.milestone && (r2.$no_end = !(e3.end_date || e3.duration), r2.$no_start = !e3.start_date, t2._isAllowedUnscheduledTask(e3) && (r2.$no_end = r2.$no_start = false)), r2) : (r2.$no_start = e3.$no_start, r2.$no_end = e3.$no_end, r2);
      };
      function r(e3) {
        e3.$effective_calendar = t2.getTaskCalendar(e3).id, e3.start_date = t2.getClosestWorkTime({ dir: "future", date: e3.start_date, unit: t2.config.duration_unit, task: e3 }), e3.end_date = t2.calculateEndDate(e3);
      }
      function a(e3) {
        var n3 = null, i2 = null, r2 = void 0 !== e3 ? e3 : t2.config.root_id, a2 = [];
        return t2.eachTask(function(e4) {
          t2.getTaskType(e4.type) == t2.config.types.project || t2.isUnscheduledTask(e4) || (e4.rollup && a2.push(e4.id), e4.start_date && !e4.$no_start && (!n3 || n3 > e4.start_date.valueOf()) && (n3 = e4.start_date.valueOf()), e4.end_date && !e4.$no_end && (!i2 || i2 < e4.end_date.valueOf()) && (i2 = e4.end_date.valueOf()));
        }, r2), { start_date: n3 ? new Date(n3) : null, end_date: i2 ? new Date(i2) : null, rollup: a2 };
      }
      t2._init_task_timing = function(t3) {
        var e3 = n2(t3, true), i2 = t3.$rendered_type != e3.type, a2 = e3.type;
        i2 && (t3.$no_start = e3.$no_start, t3.$no_end = e3.$no_end, t3.$rendered_type = e3.type), i2 && a2 != this.config.types.milestone && a2 == this.config.types.project && (this._set_default_task_timing(t3), t3.$calculate_duration = false), a2 == this.config.types.milestone && (t3.end_date = t3.start_date), t3.start_date && t3.end_date && false !== t3.$calculate_duration && (t3.duration = this.calculateDuration(t3)), t3.$calculate_duration || (t3.$calculate_duration = true), t3.end_date || (t3.end_date = t3.start_date), t3.duration = t3.duration || 0, 0 === this.config.min_duration && 0 === t3.duration && (t3.$no_end = false);
        var o = this.getTaskCalendar(t3);
        t3.$effective_calendar && t3.$effective_calendar !== o.id && (r(t3), this.config.inherit_calendar && this.isSummaryTask(t3) && this.eachTask(function(t4) {
          r(t4);
        }, t3.id)), t3.$effective_calendar = o.id;
      }, t2.isSummaryTask = function(e3) {
        t2.assert(e3 && e3 instanceof Object, "Invalid argument <b>task</b>=" + e3 + " of gantt.isSummaryTask. Task object was expected");
        var i2 = n2(e3);
        return !(!i2.$no_end && !i2.$no_start);
      }, t2.resetProjectDates = function(t3) {
        var i2 = n2(t3);
        if (i2.$no_end || i2.$no_start) {
          var r2 = a(t3.id);
          (function(t4, n3, i3, r3) {
            n3.$no_start && (t4.start_date = i3 ? new Date(i3) : e2(t4, this.getParent(t4)));
            n3.$no_end && (t4.end_date = r3 ? new Date(r3) : this.calculateEndDate({ start_date: t4.start_date, duration: this.config.duration_step, task: t4 }));
            (n3.$no_start || n3.$no_end) && this._init_task_timing(t4);
          }).call(this, t3, i2, r2.start_date, r2.end_date), t3.$rollup = r2.rollup;
        }
      }, t2.getSubtaskDuration = function(e3) {
        var n3 = 0, i2 = void 0 !== e3 ? e3 : t2.config.root_id;
        return this.eachTask(function(e4) {
          this.getTaskType(e4.type) == t2.config.types.project || this.isUnscheduledTask(e4) || (n3 += e4.duration);
        }, i2), n3;
      }, t2.getSubtaskDates = function(t3) {
        var e3 = a(t3);
        return { start_date: e3.start_date, end_date: e3.end_date };
      }, t2._update_parents = function(e3, i2, r2) {
        if (e3) {
          var a2 = this.getTask(e3);
          a2.rollup && (r2 = true);
          var o = this.getParent(a2), s = n2(a2), l = true;
          if (r2 || a2.start_date && a2.end_date && (s.$no_start || s.$no_end)) {
            var c = a2.start_date.valueOf(), u = a2.end_date.valueOf();
            t2.resetProjectDates(a2), r2 || c != a2.start_date.valueOf() || u != a2.end_date.valueOf() || (l = false), l && !i2 && this.refreshTask(a2.id, true);
          }
          l && o && this.isTaskExists(o) && this._update_parents(o, i2, r2);
        }
      }, t2.roundDate = function(e3) {
        var n3 = t2.getScale();
        i.isDate(e3) && (e3 = { date: e3, unit: n3 ? n3.unit : t2.config.duration_unit, step: n3 ? n3.step : t2.config.duration_step });
        var r2, a2, o, s = e3.date, l = e3.step, c = e3.unit;
        if (!n3)
          return s;
        if (c == n3.unit && l == n3.step && +s >= +n3.min_date && +s <= +n3.max_date)
          o = Math.floor(t2.columnIndexByDate(s)), n3.trace_x[o] || (o -= 1, n3.rtl && (o = 0)), a2 = new Date(n3.trace_x[o]), r2 = t2.date.add(a2, l, c);
        else {
          for (o = Math.floor(t2.columnIndexByDate(s)), r2 = t2.date[c + "_start"](new Date(n3.min_date)), n3.trace_x[o] && (r2 = t2.date[c + "_start"](n3.trace_x[o])); +r2 < +s; ) {
            var u = (r2 = t2.date[c + "_start"](t2.date.add(r2, l, c))).getTimezoneOffset();
            r2 = t2._correct_dst_change(r2, u, r2, c), t2.date[c + "_start"] && (r2 = t2.date[c + "_start"](r2));
          }
          a2 = t2.date.add(r2, -1 * l, c);
        }
        return e3.dir && "future" == e3.dir ? r2 : e3.dir && "past" == e3.dir ? a2 : Math.abs(s - a2) < Math.abs(r2 - s) ? a2 : r2;
      }, t2.correctTaskWorkTime = function(e3) {
        t2.config.work_time && t2.config.correct_work_time && (this.isWorkTime(e3.start_date, void 0, e3) ? this.isWorkTime(new Date(+e3.end_date - 1), void 0, e3) || (e3.end_date = this.calculateEndDate(e3)) : (e3.start_date = this.getClosestWorkTime({ date: e3.start_date, dir: "future", task: e3 }), e3.end_date = this.calculateEndDate(e3)));
      }, t2.attachEvent("onBeforeTaskUpdate", function(e3, n3) {
        return t2._init_task_timing(n3), true;
      }), t2.attachEvent("onBeforeTaskAdd", function(e3, n3) {
        return t2._init_task_timing(n3), true;
      }), t2.attachEvent("onAfterTaskMove", function(e3, n3, i2) {
        return t2._init_task_timing(t2.getTask(e3)), true;
      });
    };
  }, function(t, e, n) {
    var i = n(0);
    t.exports = { create: function(t2, e2) {
      return { getWorkHours: function(t3) {
        return e2.getWorkHours(t3);
      }, setWorkTime: function(t3) {
        return e2.setWorkTime(t3);
      }, unsetWorkTime: function(t3) {
        e2.unsetWorkTime(t3);
      }, isWorkTime: function(t3, n2, i2) {
        return e2.isWorkTime(t3, n2, i2);
      }, getClosestWorkTime: function(t3) {
        return e2.getClosestWorkTime(t3);
      }, calculateDuration: function(t3, n2, i2) {
        return e2.calculateDuration(t3, n2, i2);
      }, _hasDuration: function(t3, n2, i2) {
        return e2.hasDuration(t3, n2, i2);
      }, calculateEndDate: function(t3, n2, i2, r) {
        return e2.calculateEndDate(t3, n2, i2, r);
      }, mergeCalendars: i.bind(t2.mergeCalendars, t2), createCalendar: i.bind(t2.createCalendar, t2), addCalendar: i.bind(t2.addCalendar, t2), getCalendar: i.bind(t2.getCalendar, t2), getCalendars: i.bind(t2.getCalendars, t2), getResourceCalendar: i.bind(t2.getResourceCalendar, t2), getTaskCalendar: i.bind(t2.getTaskCalendar, t2), deleteCalendar: i.bind(t2.deleteCalendar, t2) };
    } };
  }, function(t, e) {
    function n(t2, e2) {
      this.argumentsHelper = e2, this.$gantt = t2;
    }
    n.prototype = { getWorkHours: function() {
      return [0, 24];
    }, setWorkTime: function() {
      return true;
    }, unsetWorkTime: function() {
      return true;
    }, isWorkTime: function() {
      return true;
    }, getClosestWorkTime: function(t2) {
      return this.argumentsHelper.getClosestWorkTimeArguments.apply(this.argumentsHelper, arguments).date;
    }, calculateDuration: function() {
      var t2 = this.argumentsHelper.getDurationArguments.apply(this.argumentsHelper, arguments), e2 = t2.start_date, n2 = t2.end_date, i = t2.unit, r = t2.step;
      return this._calculateDuration(e2, n2, i, r);
    }, _calculateDuration: function(t2, e2, n2, i) {
      var r = this.$gantt.date, a = { week: 6048e5, day: 864e5, hour: 36e5, minute: 6e4 }, o = 0;
      if (a[n2])
        o = Math.round((e2 - t2) / (i * a[n2]));
      else {
        for (var s = new Date(t2), l = new Date(e2); s.valueOf() < l.valueOf(); )
          o += 1, s = r.add(s, i, n2);
        s.valueOf() != e2.valueOf() && (o += (l - s) / (r.add(s, i, n2) - s));
      }
      return Math.round(o);
    }, hasDuration: function() {
      var t2 = this.argumentsHelper.getDurationArguments.apply(this.argumentsHelper, arguments), e2 = t2.start_date, n2 = t2.end_date;
      return !!t2.unit && (e2 = new Date(e2), n2 = new Date(n2), e2.valueOf() < n2.valueOf());
    }, hasWorkTime: function() {
      return true;
    }, equals: function(t2) {
      return t2 instanceof n;
    }, calculateEndDate: function() {
      var t2 = this.argumentsHelper.calculateEndDateArguments.apply(this.argumentsHelper, arguments), e2 = t2.start_date, n2 = t2.duration, i = t2.unit, r = t2.step;
      return this.$gantt.date.add(e2, r * n2, i);
    } }, t.exports = n;
  }, function(t, e, n) {
    var i = n(37), r = n(176);
    function a(t2) {
      this.$gantt = t2.$gantt, this.argumentsHelper = i(this.$gantt), this.calendarManager = t2, this.$disabledCalendar = new r(this.$gantt, this.argumentsHelper);
    }
    a.prototype = { _getCalendar: function(t2) {
      var e2;
      if (this.$gantt.config.work_time) {
        var n2 = this.calendarManager;
        t2.task ? e2 = n2.getTaskCalendar(t2.task) : t2.id ? e2 = n2.getTaskCalendar(t2) : t2.calendar && (e2 = t2.calendar), e2 || (e2 = n2.getTaskCalendar());
      } else
        e2 = this.$disabledCalendar;
      return e2;
    }, getWorkHours: function(t2) {
      return t2 = this.argumentsHelper.getWorkHoursArguments.apply(this.argumentsHelper, arguments), this._getCalendar(t2).getWorkHours(t2.date);
    }, setWorkTime: function(t2, e2) {
      return t2 = this.argumentsHelper.setWorkTimeArguments.apply(this.argumentsHelper, arguments), e2 || (e2 = this.calendarManager.getCalendar()), e2.setWorkTime(t2);
    }, unsetWorkTime: function(t2, e2) {
      return t2 = this.argumentsHelper.unsetWorkTimeArguments.apply(this.argumentsHelper, arguments), e2 || (e2 = this.calendarManager.getCalendar()), e2.unsetWorkTime(t2);
    }, isWorkTime: function(t2, e2, n2, i2) {
      var r2 = this.argumentsHelper.isWorkTimeArguments.apply(this.argumentsHelper, arguments);
      return this._getCalendar(r2).isWorkTime(r2);
    }, getClosestWorkTime: function(t2) {
      return t2 = this.argumentsHelper.getClosestWorkTimeArguments.apply(this.argumentsHelper, arguments), this._getCalendar(t2).getClosestWorkTime(t2);
    }, calculateDuration: function() {
      var t2 = this.argumentsHelper.getDurationArguments.apply(this.argumentsHelper, arguments);
      return this._getCalendar(t2).calculateDuration(t2);
    }, hasDuration: function() {
      var t2 = this.argumentsHelper.hasDurationArguments.apply(this.argumentsHelper, arguments);
      return this._getCalendar(t2).hasDuration(t2);
    }, calculateEndDate: function(t2) {
      t2 = this.argumentsHelper.calculateEndDateArguments.apply(this.argumentsHelper, arguments);
      return this._getCalendar(t2).calculateEndDate(t2);
    } }, t.exports = a;
  }, function(t, e) {
    t.exports = function() {
      var t2 = {};
      return { getCalendarIdFromMultipleResources: function(e2, n) {
        var i = function(t3) {
          return t3.map(function(t4) {
            return t4 && t4.resource_id ? t4.resource_id : t4;
          }).sort().join("-");
        }(e2);
        if (e2.length) {
          if (1 === e2.length)
            return n.getResourceCalendar(i).id;
          if (t2[i])
            return t2[i].id;
          var r = function(t3, e3) {
            return e3.mergeCalendars(t3.map(function(t4) {
              var n2 = t4 && t4.resource_id ? t4.resource_id : t4;
              return e3.getResourceCalendar(n2);
            }));
          }(e2, n);
          return t2[i] = r, n.addCalendar(r);
        }
        return null;
      } };
    };
  }, function(t, e) {
    function n(t2) {
      "@babel/helpers - typeof";
      return (n = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(t3) {
        return typeof t3;
      } : function(t3) {
        return t3 && "function" == typeof Symbol && t3.constructor === Symbol && t3 !== Symbol.prototype ? "symbol" : typeof t3;
      })(t2);
    }
    t.exports = { isLegacyResourceCalendarFormat: function(t2) {
      if (!t2)
        return false;
      for (var e2 in t2)
        if (t2[e2] && "object" === n(t2[e2]))
          return true;
      return false;
    }, getResourceProperty: function(t2) {
      var e2 = t2.resource_calendars, n2 = t2.resource_property;
      if (this.isLegacyResourceCalendarFormat(e2))
        for (var i in t2) {
          n2 = i;
          break;
        }
      return n2;
    }, getCalendarIdFromLegacyConfig: function(t2, e2) {
      if (e2)
        for (var n2 in e2) {
          var i = e2[n2];
          if (t2[n2]) {
            var r = i[t2[n2]];
            if (r)
              return r;
          }
        }
      return null;
    } };
  }, function(t, e, n) {
    Object.defineProperty(e, "__esModule", { value: true });
    var i = function() {
      function t2()