package com.bokesoft.yes.mid.web.ui.load.viewcollection;

import java.util.Iterator;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.AbstractJSONBuilder;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yigo.common.def.LayoutType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutTabItem;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaTabLayout;
import com.bokesoft.yigo.tools.ve.VE;

public class TabLayoutJSONBuilder extends AbstractJSONBuilder<MetaTabLayout>{

	@Override
	public void load(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm,
			MetaTabLayout meta) throws Throwable {
		json.put(JSONConstants.COMMON_TYPE, LayoutType.toString(meta.getLayoutType()));
		
		JSONArray itemArray = new JSONArray();
		Iterator<MetaLayoutTabItem> it = meta.iterator();
		while(it.hasNext()){
			MetaLayoutTabItem metaLayoutTabItem = it.next();
			JSONObject itemObj = new JSONObject();
			JSONHelper.writeToJSON(itemObj, JSONConstants.COMMON_KEY, metaLayoutTabItem.getKey(), "");
			JSONHelper.writeToJSON(itemObj, JSONConstants.COMMON_CAPTION, metaLayoutTabItem.getCaption(), "");
			itemArray.put(itemObj);
		}
		
		json.put(JSONConstants.COMMON_ITEMS, itemArray);
	}

}
