package com.bokesoft.yes.mid.web.ui.load.viewcollection;

import java.util.Iterator;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.AbstractJSONBuilder;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.def.LayoutType;
import com.bokesoft.yigo.common.def.OrientationType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLinearItem;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLinearLayout;
import com.bokesoft.yigo.tools.ve.VE;

public class LinearLayoutJSONBuilder extends AbstractJSONBuilder<MetaLinearLayout> {

	@Override
	public void load(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm,
			MetaLinearLayout meta) throws Throwable {
		json.put(JSONConstants.COMMON_TYPE, LayoutType.toString(meta.getLayoutType()));
		JSONHelper.writeToJSON(json, JSONConstants.LINEARLAYOUTPANEL_ORIENTATION,
				OrientationType.toString(meta.getOrientation()), "");

		JSONArray itemArray = new JSONArray();
		Iterator<MetaLinearItem> it = meta.iterator();
		while (it.hasNext()) {
			MetaLinearItem metaLinearItem = it.next();
			JSONObject itemObj = new JSONObject();
			DefSize width = metaLinearItem.getWidth();
			DefSize height = metaLinearItem.getHeight();
			JSONHelper.writeToJSON(itemObj, JSONConstants.COMMON_WIDTH, width == null ? "" : width.toString(), "");
			JSONHelper.writeToJSON(itemObj, JSONConstants.COMMON_HEIGHT, height == null ? "" : height.toString(), "");
			JSONHelper.writeToJSON(itemObj, JSONConstants.COMMON_WEIGHT, metaLinearItem.getWeight() + "", "");
			itemArray.put(itemObj);
		}
		json.put(JSONConstants.COMMON_ITEMS, itemArray);
	}

}
