package com.bokesoft.yes.mid.web.ui.load.panel.gridpanel;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.mid.web.ui.AbstractJSONBuilder;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaGroup;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaHandle;
import com.bokesoft.yigo.tools.ve.VE;
import org.json.JSONObject;

/*
 *文件名: GroupJSONBuilder
 *创建者: zhangk
 *创建时间:2022/9/13 14:44
 */
public class GroupJSONBuilder extends AbstractJSONBuilder<MetaGroup> {
	@Override
	public void load(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm, MetaGroup meta) throws Throwable {
		json.put(JSONConstants.COMMON_KEY, meta.getKey());
		json.put(JSONConstants.COMMON_CAPTION, meta.getCaption());
		json.put(JSONConstants.GRIDLAYOUTPANEL_GROUP_EXPANDED, meta.getExpanded());
		json.put(JSONConstants.GRIDLAYOUTPANEL_GROUP_START_ROW, meta.getStartRow());
		json.put(JSONConstants.GRIDLAYOUTPANEL_GROUP_END_ROW, meta.getEndRow());
		MetaHandle metaHandle = meta.getMetaHandle();
		if (metaHandle != null) {
			JSONObject build = builder.build(ve, builder, metaForm, metaHandle);
			json.put(JSONConstants.GRIDLAYOUTPANEL_GROUP_HANDLE, build);
		}
	}
}
